/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package XMLStreamReader;

import junit.framework.TestCase;

import java.io.StringReader;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;


import junit.textui.TestRunner;
/**
 * See bug 6389307.
 * 
 * @author Kohsuke Kawaguchi
 */
public class DoubleXmlnsTest extends TestCase {

    public static void main(String[] args) {
    	TestRunner.run(DoubleXmlnsTest.class);
    }

    public void testDoubleNS() throws Exception {

        final String INVALID_XML =
                "<foo xmlns:xmli='http://www.w3.org/XML/1998/namespacei' xmlns:xmli='http://www.w3.org/XML/1998/namespacei' />";
        
        try {
            XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(
                    new StringReader(INVALID_XML));

            while(xsr.hasNext()) {
                xsr.next();
            }

            fail("Wellformedness error expected: "
                    + INVALID_XML);
        } catch (XMLStreamException e) {
            ; // this is expected
        }
    }
        
    public void testNestedNS() throws Exception {

        final String VALID_XML =
                "<foo xmlns:xmli='http://www.w3.org/XML/1998/namespacei'><bar xmlns:xmli='http://www.w3.org/XML/1998/namespaceii'></bar></foo>";

        try {
            XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(
                    new StringReader(VALID_XML));
            
            while(xsr.hasNext()) {
                xsr.next();
            }

            // expected success
        } catch (XMLStreamException e) {
            e.printStackTrace();

            fail("Wellformedness error is not expected: "
                    + VALID_XML
                    + ", "
                    + e.getMessage());
        }
    }
    
    public void testDoubleXmlns() throws Exception {

        final String INVALID_XML =
                "<foo xmlns:xml='http://www.w3.org/XML/1998/namespace' xmlns:xml='http://www.w3.org/XML/1998/namespace' ></foo>";

        try {
            XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(
                    new StringReader(INVALID_XML));
           
            while(xsr.hasNext()) {
                xsr.next();
            }

            fail("Wellformedness error expected :"
                    + INVALID_XML);
        } catch (XMLStreamException e) {
            ; // this is expected
        }
    }
    
    public void testNestedXmlns() throws Exception {
        
        final String VALID_XML =
                "<foo xmlns:xml='http://www.w3.org/XML/1998/namespace'><bar xmlns:xml='http://www.w3.org/XML/1998/namespace'></bar></foo>";

        try {
            XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(
                    new StringReader(VALID_XML));
           
            while(xsr.hasNext()) {
                xsr.next();
            }

            // expected success
        } catch (XMLStreamException e) {
            e.printStackTrace();
           fail("Wellformedness error is not expected: "
                   + VALID_XML
                   + ", "
                   + e.getMessage()); 
        }
    }
}
