/*
 * NamespaceTest.java
 *
 * Created on February 20, 2004, 12:46 PM
 */

package XMLStreamReader;

import java.io.InputStream;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamReader;

import junit.framework.*;
import junit.textui.TestRunner;

/**
 *
 * @author  neeraj
 */
public class NamespaceTest extends TestCase {

    String namespaceURI = "foobar.com" ;
    String rootElement = "foo";
    String childElement = "foochild" ;
    String prefix = "a" ;
    
    
    /** Creates a new instance of NamespaceTest */
    public NamespaceTest(java.lang.String testName) {
        super(testName) ;
    }
    
    
    public static Test suite() {
        TestSuite suite = new TestSuite(NamespaceTest.class);
        return suite;
    }
    
    // Add test methods here, they have to start with 'test' name.
    // for example:
    // public void testHello() {}

    String getXML(){
        StringBuffer sbuffer = new StringBuffer() ;
        sbuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sbuffer.append("<" + rootElement + " xmlns:") ;
        sbuffer.append(prefix);
        sbuffer.append("=\"" +  namespaceURI + "\">");
        sbuffer.append("<" + prefix + ":" + childElement + ">");
        sbuffer.append("blahblah");
        sbuffer.append("</" + prefix + ":" + childElement + ">");            
        sbuffer.append("</" + rootElement + ">");
        //System.out.println("XML = " + sbuffer.toString()) ;
        return sbuffer.toString();
    }
    
    
    public void testRootElementNamespace(){
        try{
            XMLInputFactory xif = XMLInputFactory.newInstance() ;
            xif.setProperty(XMLInputFactory.IS_NAMESPACE_AWARE, Boolean.TRUE) ;
            InputStream is = new java.io.ByteArrayInputStream(getXML().getBytes());
            XMLStreamReader sr = xif.createXMLStreamReader(is) ;
            while(sr.hasNext()){
                int eventType = sr.next() ;
                if(eventType == XMLStreamConstants.START_ELEMENT){
                    if(sr.getLocalName().equals(rootElement)){    
                        assertTrue(sr.getNamespacePrefix(0).equals(prefix) && sr.getNamespaceURI(0).equals(namespaceURI));
                    }
                }        
            }
        }catch(Exception ex){
            ex.printStackTrace();
        }
    }

    
    public void testChildElementNamespace(){
        try{
            XMLInputFactory xif = XMLInputFactory.newInstance() ;
            xif.setProperty(XMLInputFactory.IS_NAMESPACE_AWARE, Boolean.TRUE) ;
            InputStream is = new java.io.ByteArrayInputStream(getXML().getBytes());
            XMLStreamReader sr = xif.createXMLStreamReader(is) ;
            while(sr.hasNext()){
                int eventType = sr.next() ;
                if(eventType == XMLStreamConstants.START_ELEMENT){
                    if(sr.getLocalName().equals(childElement)){                    
                        QName qname = sr.getName();
                        assertTrue(qname.getPrefix().equals(prefix) && qname.getNamespaceURI().equals(namespaceURI) && qname.getLocalPart().equals(childElement));
                    }
                }        
            }
        }catch(Exception ex){
            ex.printStackTrace();
        }
    }

    
    
    public void testNamespaceContext(){
        try{
            XMLInputFactory xif = XMLInputFactory.newInstance() ;
            xif.setProperty(XMLInputFactory.IS_NAMESPACE_AWARE, Boolean.TRUE) ;
            InputStream is = new java.io.ByteArrayInputStream(getXML().getBytes());
            XMLStreamReader sr = xif.createXMLStreamReader(is) ;
            while(sr.hasNext()){
                int eventType = sr.next() ;
                if(eventType == XMLStreamConstants.START_ELEMENT){
                    if(sr.getLocalName().equals(childElement)){
                    NamespaceContext context = sr.getNamespaceContext() ; 
                    assertTrue(context.getPrefix(namespaceURI).equals(prefix));
                    }
                }        
            }
        }catch(Exception ex){
            ex.printStackTrace();
        }
    }
    
    
    public void testNamespaceCount(){
        try{
            XMLInputFactory xif = XMLInputFactory.newInstance() ;
            xif.setProperty(XMLInputFactory.IS_NAMESPACE_AWARE, Boolean.TRUE) ;
            InputStream is = new java.io.ByteArrayInputStream(getXML().getBytes());
            XMLStreamReader sr = xif.createXMLStreamReader(is) ;
            while(sr.hasNext()){
                int eventType = sr.next() ;
                if(eventType == XMLStreamConstants.START_ELEMENT){
                    if(sr.getLocalName().equals(rootElement)){
                    int count = sr.getNamespaceCount() ;                           
                    assertTrue(count == 1);
                    }
                }        
            }
        }catch(Exception ex){
            ex.printStackTrace();
        }
    }
    
    public static void main(String[] args) {
        TestRunner.run(NamespaceTest.class);
    }

}
