/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://jaxp.dev.java.net/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * https://jaxp.dev.java.net/CDDLv1.0.html
 * If applicable add the following below this CDDL HEADER
 * with the fields enclosed by brackets "[]" replaced with
 * your own identifying information: Portions Copyright
 * [year] [name of copyright owner]
 */

/*
 * $Id: AttributeEscapeTest.java,v 1.2 2006/05/04 01:31:18 jeffsuttor Exp $
 * %W% %E%
 *
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package XMLStreamWriter;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * CR 6420953 Zephyr doesn't escape namespace URIs.
 *
 * @author Kohsuke Kawaguchi
 */
public class AttributeEscapeTest extends Base {

    /**
     * XML content for testing the escaping of <, >, &, ', ".
     */
    private static final String XML_CONTENT =
            "Testing escaping: lt=<, gt=>, amp=&, apos=', dquote=\"";

    /**
     * Test CR 6420953 Zephyr doesn't escape namespace URIs.
     */
    public void testCR6420953() {

        try {
            StringWriter sw = new StringWriter();
            XMLStreamWriter w = xof.createXMLStreamWriter(sw);

            w.writeStartDocument();
            w.writeStartElement("element");

            w.writeDefaultNamespace(XML_CONTENT);
            w.writeNamespace("prefix", XML_CONTENT);

            w.writeAttribute("attribute", XML_CONTENT);
            w.writeAttribute(XML_CONTENT, "attribute2", XML_CONTENT);
            w.writeAttribute(
                    "prefix", XML_CONTENT, "attribute3", XML_CONTENT);

            w.writeCharacters("\n");
            w.writeCharacters(XML_CONTENT);
            w.writeCharacters("\n");
            w.writeCharacters(
                    XML_CONTENT.toCharArray(), 0, XML_CONTENT.length());
            w.writeCharacters("\n");

            w.writeEndElement();
            w.writeEndDocument();
            w.flush();

            System.out.println(sw);

            // make sure that the generated XML parses
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.newDocumentBuilder().parse(
                    new InputSource(new StringReader(sw.toString())));
        } catch (XMLStreamException xmlStreamException) {
            xmlStreamException.printStackTrace();
            fail(xmlStreamException.toString());
        } catch (SAXException saxException) {
            saxException.printStackTrace();
            fail(saxException.toString());
        } catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            fail(parserConfigurationException.toString());
        } catch (IOException ioException) {
            ioException.printStackTrace();
            fail(ioException.toString());
        }
    }
}
