/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://jaxp.dev.java.net/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * https://jaxp.dev.java.net/CDDLv1.0.html
 * If applicable add the following below this CDDL HEADER
 * with the fields enclosed by brackets "[]" replaced with
 * your own identifying information: Portions Copyright
 * [year] [name of copyright owner]
 */
/*
 * $Id: EncodingTest.java,v 1.2 2006/11/01 17:00:09 spericas Exp $
 * %W% %E%
 *
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package XMLStreamWriter;

import java.io.ByteArrayOutputStream;

import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

import junit.framework.TestCase;
import junit.textui.TestRunner;

/**
 *
 * @author Sunitha Reddy, Sun Microsystems
 */

public class EncodingTest extends TestCase {
    
    private static final XMLOutputFactory XML_OUTPUT_FACTORY =
            XMLOutputFactory.newInstance();
    
    public EncodingTest(String name) {
        super(name);
    }

    public static void main(String [] args) {
        TestRunner.run(EncodingTest.class);
    }
    
    /*
     * Tests writing a document with UTF-8 encoding, by setting UTF-8 on writer.
     */
    public void testWriteStartDocumentUTF8() {
        
        final String EXPECTED_OUTPUT =
                "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root></root>";
        XMLStreamWriter writer = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(byteArrayOutputStream, "UTF-8");
            
            writer.writeStartDocument("UTF-8","1.0");
            writer.writeStartElement("root");
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            
            String actualOutput = byteArrayOutputStream.toString();
            assertEquals(EXPECTED_OUTPUT, actualOutput);
            
        } catch(Exception e){
            e.printStackTrace();
            fail(e.toString());
        } 
               
    }
        
    /*
     * Tests writing a document with UTF-8 encoding using an ASCII
     * writer. This should result in an exception.
     */
    public void testWriteStartDocumentUTF8Fail() {
        
        XMLStreamWriter writer = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(byteArrayOutputStream, "ASCII");
            
            writer.writeStartDocument("UTF-8","1.0");
            writer.writeStartElement("root");
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            
            fail("Expected XMLStreamException as underlyiing stream encoding differs from UTF-8");
        } catch(Exception e){
            e.printStackTrace();
        } 
    }
}