/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

// StAX tests that are failing 

package XMLStreamWriter;

import java.io.*;
import javax.xml.namespace.*;
import javax.xml.stream.*;

import junit.framework.TestCase;

public class SqeLinuxTest extends TestCase {

    // note that expected output will have multiple declarations,
    // StAX does not do well formedness checking
    private static final String EXPECTED_OUTPUT =
            "<?xml version=\"1.0\" ?>"
            + "<?xml version=\"wStDoc_ver\"?>"
            + "<?xml version=\"wStDoc_ver2\" encoding=\"ASCII\"?>"
            + "<?xml version=\"1.0\" ?>";
    
    XMLStreamWriter xmlStreamWriter;
    ByteArrayOutputStream byteArrayOutputStream;
    XMLOutputFactory xmlOutputFactory ;

    public void testWriterOnLinux()
        throws Exception {

        // setup XMLStreamWriter
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();    
            xmlOutputFactory = XMLOutputFactory.newInstance();
            xmlOutputFactory.setProperty(xmlOutputFactory.IS_REPAIRING_NAMESPACES, new Boolean(false));
            xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter(byteArrayOutputStream, "ASCII");
        } catch(Exception e) {
	    System.err.println("Unexpected Exception: " + e.toString());
            e.printStackTrace();
            fail(e.toString());
        }

        // create & write a document
        try {
            xmlStreamWriter.writeStartDocument();
            xmlStreamWriter.writeStartDocument("wStDoc_ver");
            xmlStreamWriter.writeStartDocument("ASCII", "wStDoc_ver2");
            xmlStreamWriter.writeStartDocument(null ,null);           

            // orignal SQE test used reset() before flush() 
            // believe this is false as reset() throws away output before flush() writes any cached output
            // it is valid for a XMLStreamWriter to write its output at any time, flush() just garuntees it
            // byteArrayOutputStream.reset();
            xmlStreamWriter.flush();
            assertEquals(EXPECTED_OUTPUT, byteArrayOutputStream.toString());
        } catch(Exception e) {
	    System.err.println("Unexpected Exception: " + e.toString());
            e.printStackTrace();
            fail(e.toString());
        }
    }
}
