/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package XMLStreamWriter;

import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/**
 * Zephyr can't write &lt;bar xmlns="foo" />. See 6394074.
 *
 * @author Kohsuke Kawaguchi
 */
public class UnprefixedNameTest extends Base {

    /**
     * Expected failure due to unbound prefix.
     */
    public void testUnboundPrefix() throws Exception {

        try {
            XMLStreamWriter w = xof.createXMLStreamWriter(System.out);
            // here I'm trying to write
            // <bar xmlns="foo" />
            w.writeStartDocument();
            w.writeStartElement("foo", "bar");
            w.writeDefaultNamespace("foo");
            w.writeCharacters("---");
            w.writeEndElement();
            w.writeEndDocument();
            w.close();
            
            // Unexpected success
            String FAIL_MSG = "Unexpected success.  Expected: "
                    + "XMLStreamException - "
                    + "if the namespace URI has not been bound to a prefix "
                    + "and javax.xml.stream.isPrefixDefaulting has not been "
                    + "set to true";
            System.err.println(FAIL_MSG);
            fail(FAIL_MSG);
        } catch (XMLStreamException xmlStreamException) {
            // Expected Exception
            System.out.println("Expected XMLStreamException: " + xmlStreamException.toString());
        }
    }

    /**
     * Expected success due to bound prefix.
     */
    public void testBoundPrefix() throws Exception {

        try {
            XMLStreamWriter w = xof.createXMLStreamWriter(System.out);
            // here I'm trying to write
            // <bar xmlns="foo" />
            w.writeStartDocument();
            w.writeStartElement("foo", "bar", "http://namespace");
            w.writeCharacters("---");
            w.writeEndElement();
            w.writeEndDocument();
            w.close();
            
            // Expected success
            System.out.println("Expected success.");
        } catch (Exception exception) {
            // Unexpected Exception
            String FAIL_MSG = "Unexpected Exception: " + exception.toString();
            System.err.println(FAIL_MSG);
            fail(FAIL_MSG);
        }
    }

    /**
     * Expected success due to repairing prefix.
     */
    public void testRepairingPrefix() throws Exception {

        try {
            
            // repair namespaces
            // use new XMLOutputFactory as changing its property settings
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            xof.setProperty(xof.IS_REPAIRING_NAMESPACES, new Boolean(true));
            XMLStreamWriter w = xof.createXMLStreamWriter(System.out);

            // here I'm trying to write
            // <bar xmlns="foo" />
            w.writeStartDocument();
            w.writeStartElement("foo", "bar");
            w.writeDefaultNamespace("foo");
            w.writeCharacters("---");
            w.writeEndElement();
            w.writeEndDocument();
            w.close();
            
            // Expected success
            System.out.println("Expected success.");
        } catch (Exception exception) {
            // Unexpected Exception
            String FAIL_MSG = "Unexpected Exception: " + exception.toString();
            System.err.println(FAIL_MSG);
            fail(FAIL_MSG);
        }
    }
}
