/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */


package XMLStreamWriter;

import java.net.URL;
import java.io.*;
import javax.xml.stream.*;
import javax.xml.stream.events.* ;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import junit.framework.TestCase;
import junit.textui.TestRunner;


/**
 * @author K.Venugopal@sun.com
 * Tests Xml stream writer functionality.
 */

public class WriterTests extends TestCase {
    
    XMLOutputFactory outputFactory = null;
    XMLInputFactory inputFactory = null;
    XMLStreamWriter xtw = null;
    String[] files = new String[] { "testOne.xml","testTwo.xml","testThree.xml","testFour.xml","testFive.xml","testSix.xml","testSeven.xml","testEight.xml","testNine.xml",
    "testTen.xml","testEleven.xml","testTwelve.xml","testDefaultNS.xml",null,"testFixAttr.xml"};
    
    String output="";
    
    public WriterTests(String name) {
        super(name);
    }
    
    public static void main(String[] args) {
        TestRunner.run(WriterTests.class);
    }
    
    protected void setUp() {
        try{
            outputFactory = XMLOutputFactory.newInstance();
            inputFactory = XMLInputFactory.newInstance();
        }catch(Exception ex){
            fail("Could not create XMLInputFactory");
        }
    }
    
    
    protected void tearDown() {
        outputFactory = null;
        inputFactory = null;
    }
    
    public void testOne() {
        
        System.out.println("Test StreamWriter with out any namespace functionality");
        
        try{
            String outputFile = "./build/classes/XMLStreamWriter/"+files[0]+".out";
            System.out.println("Writing output to "+outputFile);
            
            xtw = outputFactory.createXMLStreamWriter(new FileWriter(outputFile));
            xtw.writeStartDocument("utf-8","1.0");
            xtw.writeStartElement("elmeOne");
            xtw.writeStartElement("elemTwo");
            xtw.writeStartElement("elemThree");
            xtw.writeStartElement("elemFour");
            xtw.writeStartElement("elemFive");
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
            
            assertTrue(checkResults(files[0]+".out", files[0]+".org"));
            
        }catch(Exception ex){
            fail("testOne Failed "+ex);
            ex.printStackTrace();
        }
        
    }
    
    public void testTwo() {
        
        System.out.println("Test StreamWriter's Namespace Context");
        
        try{
            String outputFile = "./build/classes/XMLStreamWriter/"+files[1]+".out";
            System.out.println("Writing output to "+outputFile);
            
            xtw = outputFactory.createXMLStreamWriter(System.out);
            xtw.writeStartDocument("utf-8","1.0");
            xtw.writeStartElement("elemTwo");
            xtw.setPrefix("html", "http://www.w3.org/TR/REC-html40");
            xtw.writeNamespace("html", "http://www.w3.org/TR/REC-html40");
            xtw.writeEndDocument();
            NamespaceContext nc = xtw.getNamespaceContext();
            //Got a Namespace Context.class
            
            XMLStreamWriter xtw1 = outputFactory.createXMLStreamWriter(new FileWriter(outputFile));
            
            xtw1.writeComment("all elements here are explicitly in the HTML namespace");
            xtw1.setNamespaceContext(nc);
            xtw1.writeStartDocument("utf-8","1.0");
            xtw1.setPrefix("htmlOne", "http://www.w3.org/TR/REC-html40");
            NamespaceContext nc1 = xtw1.getNamespaceContext();
            xtw1.close();
            Iterator it = nc1.getPrefixes("http://www.w3.org/TR/REC-html40");
            
            //FileWriter fw = new FileWriter(outputFile);
            while(it.hasNext()){
                System.out.println("Prefixes :"+it.next());
                //fw.write((String)it.next());
                //fw.write(";");
            }
            // fw.close();
            //assertTrue(checkResults(testTwo+".out", testTwo+".org"));
            System.out.println("Done");
        }catch(Exception ex){
            fail("testTwo Failed "+ex);
            ex.printStackTrace();
        }
        
    }
    public void testThree() {
        
        System.out.println("Test StreamWriter for proper element sequence.");
        
        try{
            String outputFile = "./build/classes/XMLStreamWriter/"+files[2]+".out";
            System.out.println("Writing output to "+outputFile);
            
            xtw = outputFactory.createXMLStreamWriter(new FileWriter(outputFile));
            xtw.writeStartDocument("utf-8","1.0");
            xtw.writeStartElement("elmeOne");
            xtw.writeStartElement("elemTwo");
            xtw.writeEmptyElement("emptyElem");
            xtw.writeStartElement("elemThree");
            xtw.writeStartElement("elemFour");
            xtw.writeStartElement("elemFive");
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
            
            assertTrue(checkResults(files[2]+".out", files[2]+".org"));
            
        }catch(Exception ex){
            fail("testThree Failed "+ex);
            ex.printStackTrace();
        }
        
    }
    
    public void testFour() {
        
        System.out.println("Test StreamWriter with elements,attribute and element content.");
        
        try{
            
            String outputFile = "./build/classes/XMLStreamWriter/"+files[3]+".out";
            System.out.println("Writing output to "+outputFile);
            
            xtw = outputFactory.createXMLStreamWriter(new FileWriter(outputFile));
            xtw.writeStartDocument("utf-8","1.0");
            xtw.writeStartElement("elmeOne");
            xtw.writeStartElement("elemTwo");
            xtw.writeEmptyElement("emptyElem");
            xtw.writeAttribute("testAttr","testValue");
            xtw.writeStartElement("elemThree");
            xtw.writeStartElement("elemFour");
            xtw.writeCharacters("TestCharacterData");
            xtw.writeStartElement("elemFive");
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
            
            assertTrue(checkResults(files[3]+".out",files[3]+".org"));
            
        }catch(Exception ex){
            fail("testFour Failed "+ex);
            ex.printStackTrace();
        }
        
    }
    
    public void testFive() {
        
        System.out.println("Test StreamWriter's Namespace Context.");
        
        try{
            
            String outputFile = "./build/classes/XMLStreamWriter/"+ files[4]+".out";
            System.out.println("Writing output to "+outputFile);
            
            xtw = outputFactory.createXMLStreamWriter(System.out);
            xtw.writeStartDocument("utf-8","1.0");
            xtw.writeStartElement("elemTwo");
            xtw.setPrefix("html", "http://www.w3.org/TR/REC-html40");
            xtw.writeNamespace("html", "http://www.w3.org/TR/REC-html40");
            //xtw.writeEndDocument();
            NamespaceContext nc = xtw.getNamespaceContext();
            //Got a Namespace Context.class
            
            xtw = outputFactory.createXMLStreamWriter(new FileWriter(outputFile));
            
            xtw.writeComment("all elements here are explicitly in the HTML namespace");
            xtw.setNamespaceContext(nc);
            xtw.writeStartDocument("utf-8","1.0");
            //xtw.setPrefix("html", "http://www.w3.org/TR/REC-html40");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","html");
            //xtw.writeNamespace("html", "http://www.w3.org/TR/REC-html40");
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","head");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","title");
            
            xtw.writeCharacters("Frobnostication");
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","body");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","p");
            xtw.writeCharacters("Moved to");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","a");
            xtw.writeAttribute("href","http://frob.com");
            
            xtw.writeCharacters("here");
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeEndElement();
            
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
            assertTrue(checkResults(files[4]+".out",files[4]+".org"));
            System.out.println("Done");
        }catch(Exception ex){
            fail("testFive Failed "+ex);
            ex.printStackTrace();
        }
        
    }
    
    
    
    public void testSix() {
        
        System.out.println("Test StreamWriter, uses the Namespace Context set by the user to resolve namespaces.");
        
        try{
            
            String outputFile = "./build/classes/XMLStreamWriter/"+ files[5]+".out";
            System.out.println("Writing output to "+outputFile);
            
            xtw = outputFactory.createXMLStreamWriter(System.out);
            xtw.writeStartDocument("utf-8","1.0");
            xtw.writeStartElement("elemTwo");
            xtw.setPrefix("html", "http://www.w3.org/TR/REC-html40");
            xtw.writeNamespace("html", "http://www.w3.org/TR/REC-html40");
            xtw.writeEndDocument();
            NamespaceContext nc = xtw.getNamespaceContext();
            //Got a Namespace Context information.
            
            xtw = outputFactory.createXMLStreamWriter(new FileWriter(outputFile));
            
            xtw.writeComment("all elements here are explicitly in the HTML namespace");
            xtw.setNamespaceContext(nc);
            xtw.writeStartDocument("utf-8","1.0");
            xtw.setPrefix("htmlNewPrefix", "http://www.w3.org/TR/REC-html40");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","html");
            //xtw.writeNamespace("html", "http://www.w3.org/TR/REC-html40");
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","head");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","title");
            
            xtw.writeCharacters("Frobnostication");
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","body");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","p");
            xtw.writeCharacters("Moved to");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","a");
            xtw.writeAttribute("href","http://frob.com");
            
            xtw.writeCharacters("here");
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeEndElement();
            
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
            assertTrue(checkResults(files[5]+".out",files[5]+".org"));
            System.out.println("Done");
        }catch(Exception ex){
            fail("testSix Failed "+ex);
            ex.printStackTrace();
        }
        
    }
    
    public void testSeven() {
        
        System.out.println("Test StreamWriter supplied with correct namespace information");
        
        try{
            
            String outputFile = "./build/classes/XMLStreamWriter/"+ files[6]+".out";
            System.out.println("Writing output to "+outputFile);
            
            xtw = outputFactory.createXMLStreamWriter(new FileWriter(outputFile));
            xtw.writeComment("all elements here are explicitly in the HTML namespace");
            xtw.writeStartDocument("utf-8","1.0");
            xtw.setPrefix("html", "http://www.w3.org/TR/REC-html40");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","html");
            xtw.writeNamespace("html", "http://www.w3.org/TR/REC-html40");
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","head");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","title");
            
            xtw.writeCharacters("Frobnostication");
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","body");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","p");
            xtw.writeCharacters("Moved to");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","a");
            xtw.writeAttribute("href","http://frob.com");
            
            xtw.writeCharacters("here");
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeEndElement();
            
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
            assertTrue(checkResults(files[6]+".out",files[6]+".org"));
            System.out.println("Done");
        }catch(Exception ex){
            fail("testSeven Failed "+ex);
            ex.printStackTrace();
        }
        
    }
    
    public void testEight() {
        
        System.out.println("Test StreamWriter supplied with correct namespace information and"+
        "isRepairingNamespace is set to true.");
        
        try{
            
            String outputFile = "./build/classes/XMLStreamWriter/"+ files[7]+".out";
            System.out.println("Writing output to "+outputFile);
            outputFactory.setProperty(XMLOutputFactory.IS_REPAIRING_NAMESPACES, new Boolean(true));
            xtw = outputFactory.createXMLStreamWriter(new FileWriter(outputFile));
            xtw.writeComment("all elements here are explicitly in the HTML namespace");
            xtw.writeStartDocument("utf-8","1.0");
            xtw.setPrefix("html", "http://www.w3.org/TR/REC-html40");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","html");
            xtw.writeNamespace("html", "http://www.w3.org/TR/REC-html40");
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","head");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","title");
            
            xtw.writeCharacters("Frobnostication");
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","body");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","p");
            xtw.writeCharacters("Moved to");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","a");
            xtw.writeAttribute("href","http://frob.com");
            
            xtw.writeCharacters("here");
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeEndElement();
            
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
            //check against testSeven.xml.org
            assertTrue(checkResults(files[7]+".out",files[7]+".org"));
            System.out.println("Done");
        }catch(Exception ex){
            ex.printStackTrace();
            fail("testEight Failed "+ex);
            
        }
        
    }
    public void testNine() {
        
        System.out.println("Test StreamWriter supplied with correct namespace information and"+
        "isRepairingNamespace is set to true."+"pass namespace information using" +
        "writenamespace function");
        
        
        try{
            
            String outputFile = "./build/classes/XMLStreamWriter/"+ files[8]+".out";
            System.out.println("Writing output to "+outputFile);
            outputFactory.setProperty(XMLOutputFactory.IS_REPAIRING_NAMESPACES, new Boolean(true));
            xtw = outputFactory.createXMLStreamWriter(new FileWriter(outputFile));
            xtw.writeComment("all elements here are explicitly in the HTML namespace");
            xtw.writeStartDocument("utf-8","1.0");
            //xtw.setPrefix("html", "http://www.w3.org/TR/REC-html40");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","html");
            xtw.writeNamespace("html", "http://www.w3.org/TR/REC-html40");
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","head");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","title");
            
            xtw.writeCharacters("Frobnostication");
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","body");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","p");
            xtw.writeCharacters("Moved to");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","a");
            xtw.writeAttribute("href","http://frob.com");
            
            xtw.writeCharacters("here");
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeEndElement();
            
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
            //check against testSeven.xml.org
            assertTrue(checkResults(files[8]+".out",files[7]+".org"));
            System.out.println("Done");
        }catch(Exception ex){
            fail("testNine Failed "+ex);
            ex.printStackTrace();
        }
        
    }
    
    public void testTen() {
        
        System.out.println("Test StreamWriter supplied with no namespace information and"+
        "isRepairingNamespace is set to true.");
        try{
            
            String outputFile = "./build/classes/XMLStreamWriter/"+ files[9]+".out";
            System.out.println("Writing output to "+outputFile);
            outputFactory.setProperty(XMLOutputFactory.IS_REPAIRING_NAMESPACES, new Boolean(true));
            xtw = outputFactory.createXMLStreamWriter(new FileWriter(outputFile));
            xtw.writeComment("all elements here are explicitly in the HTML namespace");
            xtw.writeStartDocument("utf-8","1.0");
            //xtw.setPrefix("html", "http://www.w3.org/TR/REC-html40");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","html");
            //xtw.writeNamespace("html", "http://www.w3.org/TR/REC-html40");
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","head");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","title");
            
            xtw.writeCharacters("Frobnostication");
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","body");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","p");
            xtw.writeCharacters("Moved to");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","a");
            xtw.writeAttribute("href","http://frob.com");
            
            xtw.writeCharacters("here");
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeEndElement();
            
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
            //check against testSeven.xml.org
            assertTrue(checkResults(files[9]+".out",files[7]+".org"));
            System.out.println("Done");
        }catch(Exception ex){
            fail("testTen Failed "+ex);
            ex.printStackTrace();
        }
        
    }
    
    public void testEleven() {
        
        System.out.println("Test StreamWriter supplied with  namespace information passed through startElement and"+
        "isRepairingNamespace is set to true.");
        try{
            
            String outputFile = "./build/classes/XMLStreamWriter/"+ files[10]+".out";
            System.out.println("Writing output to "+outputFile);
            outputFactory.setProperty(XMLOutputFactory.IS_REPAIRING_NAMESPACES, new Boolean(true));
            xtw = outputFactory.createXMLStreamWriter(new FileWriter(outputFile));
            xtw.writeComment("all elements here are explicitly in the HTML namespace");
            xtw.writeStartDocument("utf-8","1.0");
            //xtw.setPrefix("html", "http://www.w3.org/TR/REC-html40");
            xtw.writeStartElement("html","html","http://www.w3.org/TR/REC-html40");
            //xtw.writeNamespace("html", "http://www.w3.org/TR/REC-html40");
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","head");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","title");
            
            xtw.writeCharacters("Frobnostication");
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","body");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","p");
            xtw.writeCharacters("Moved to");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","a");
            xtw.writeAttribute("href","http://frob.com");
            
            xtw.writeCharacters("here");
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeEndElement();
            
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
            //check against testSeven.xml.org
            assertTrue(checkResults(files[10]+".out",files[7]+".org"));
            System.out.println("Done");
        }catch(Exception ex){
            fail("testEleven Failed "+ex);
            ex.printStackTrace();
        }
        
    }
    
    public void testTwelve() {
        
        System.out.println("Test StreamWriter supplied with  namespace information set at few places");
        
        try{
            
            String outputFile = "./build/classes/XMLStreamWriter/"+ files[11]+".out";
            System.out.println("Writing output to "+outputFile);
            outputFactory.setProperty(XMLOutputFactory.IS_REPAIRING_NAMESPACES, new Boolean(true));
            xtw = outputFactory.createXMLStreamWriter(new FileWriter(outputFile));
            xtw.writeComment("all elements here are explicitly in the HTML namespace");
            xtw.writeStartDocument("utf-8","1.0");
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","html");
            //xtw.writeNamespace("html", "http://www.w3.org/TR/REC-html40");
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","head");
            xtw.setPrefix("html", "http://www.w3.org/TR/REC-html40");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","title");
            
            xtw.writeCharacters("Frobnostication");
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","body");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","p");
            xtw.writeCharacters("Moved to");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","a");
            xtw.writeAttribute("href","http://frob.com");
            
            xtw.writeCharacters("here");
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeEndElement();
            
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
            //check against testSeven.xml.org
            //assertTrue(checkResults(files[10]+".out",files[7]+".org"));
            System.out.println("Done");
        }catch(Exception ex){
            fail("testtwelve Failed "+ex);
            ex.printStackTrace();
        }
        
    }
    
    public void testDefaultNamespace() {
        
        System.out.println("Test StreamWriter supplied with  namespace information set at few places");
        
        try{
            
            String outputFile = "./build/classes/XMLStreamWriter/"+ files[12]+".out";
            System.out.println("Writing output to "+outputFile);
            outputFactory.setProperty(XMLOutputFactory.IS_REPAIRING_NAMESPACES, new Boolean(true));
            xtw = outputFactory.createXMLStreamWriter(new FileWriter(outputFile));
            xtw.writeComment("all elements here are explicitly in the HTML namespace");
            xtw.writeStartDocument("utf-8","1.0");
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","html");
            xtw.writeDefaultNamespace("http://www.w3.org/TR/REC-html40");
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","head");
            //xtw.setPrefix("html", "http://www.w3.org/TR/REC-html40");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","title");
            
            xtw.writeCharacters("Frobnostication");
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","body");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","p");
            xtw.writeCharacters("Moved to");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","a");
            xtw.writeAttribute("href","http://frob.com");
            
            xtw.writeCharacters("here");
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeEndElement();
            
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
            //check against testSeven.xml.org
            //assertTrue(checkResults(files[10]+".out",files[7]+".org"));
            System.out.println("Done");
        }catch(Exception ex){
            ex.printStackTrace();
            fail("testDefaultNamespace Failed "+ex);
            
        }
        
    }
    
    public void testRepairNamespace() {
        
        System.out.println("Test StreamWriter supplied with  namespace information set at few places");
        
        try{
            
            String outputFile = "./build/classes/XMLStreamWriter/"+ files[14]+".out";
            System.out.println("Writing output to "+outputFile);
            outputFactory.setProperty(XMLOutputFactory.IS_REPAIRING_NAMESPACES, new Boolean(true));
            xtw = outputFactory.createXMLStreamWriter(new FileWriter(outputFile));
            xtw.writeComment("all elements here are explicitly in the HTML namespace");
            xtw.writeStartDocument("utf-8","1.0");
            xtw.writeStartElement("html","html","http://www.w3.org/TR/REC-html40");
            // xtw.writeStartElement("http://www.w3.org/TR/REC-html40","html");
            //xtw.writeDefaultNamespace("http://www.w3.org/TR/REC-html40");
            xtw.writeAttribute("html","testPrefix","attr1","http://frob.com");
            xtw.writeAttribute("html","testPrefix","attr2","http://frob2.com");
            xtw.writeAttribute("html","http://www.w3.org/TR/REC-html40","attr4","http://frob4.com");
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","head");
            xtw.setPrefix("html", "http://www.w3.org/TR/REC-html40");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","title");
            
            xtw.writeCharacters("Frobnostication");
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","body");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","p");
            xtw.writeCharacters("Moved to");
            xtw.writeStartElement("http://www.w3.org/TR/REC-html40","a");
            xtw.writeAttribute("href","http://frob.com");
            
            xtw.writeCharacters("here");
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndElement();
            
            xtw.writeEndElement();
            
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
            //check against testSeven.xml.org
            //assertTrue(checkResults(files[10]+".out",files[7]+".org"));
            System.out.println("Done");
        }catch(Exception ex){
            ex.printStackTrace();
            fail("testDefaultNamespace Failed "+ex);
            
        }
        
    }
    
    protected boolean checkResults(String checkFile, String orgFile) {
        try{
            URL fileName = WriterTests.class.getResource(orgFile);
            URL outputFileName = WriterTests.class.getResource(checkFile);
            return compareOutput(new InputStreamReader(fileName.openStream()),new InputStreamReader(outputFileName.openStream()));
            
        }catch(Exception ex){
            ex.printStackTrace();
            fail(ex.getMessage());
        }
        return false;
    }
    
    
    protected boolean compareOutput(Reader expected, Reader actual)
    throws IOException {
        LineNumberReader expectedOutput = null;
        LineNumberReader actualOutput = null;
        try{
            expectedOutput = new LineNumberReader(expected);
            actualOutput = new LineNumberReader(actual);
            
            while (expectedOutput.ready() && actualOutput.ready()) {
                String expectedLine = expectedOutput.readLine();
                String actualLine = actualOutput.readLine();
                if (!expectedLine.equals(actualLine)) {
                    System.out.println(
                    "Entityreference expansion failed, line no: " + expectedOutput.getLineNumber());
                    System.out.println("Expected: " + expectedLine);
                    System.out.println("Actual  : " + actualLine);
                    return false;
                }
            }
            return true;
        }catch(IOException ex){
            System.err.println("Error  occured while comparing results.");
            throw ex;
        }finally{
            expectedOutput.close();
            actualOutput.close();
            
        }
    }
}
