
package bug6481615;

import java.io.File;
import java.io.StringReader;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

import junit.framework.TestCase;
import junit.textui.TestRunner;

/**
 *
 * @author Santiago.PericasGeertsen@sun.com
 */
public class Bug  extends TestCase{
    
    static final String XML = "<?xml version=\"1.0\"?>" +
            "<S:Envelope foo=\"bar\" xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\"></S:Envelope>";
    
    private XMLInputFactory factory;
    
    public Bug(String name) {
        super(name);
        factory = XMLInputFactory.newInstance();
    }
    
    public static void main(String[] args) {
        TestRunner.run(Bug.class);
    }
    
    public void test(){        
        try {
            XMLStreamReader reader =
                    factory.createXMLStreamReader(new StringReader(XML));
            reader.next();      // advance to START_ELEMENT
            XMLStreamReader filter = 
                    factory.createFilteredReader(reader, new Filter());
            assertTrue(filter.getEventType() != -1);
        } 
        catch (Exception e) {
            e.printStackTrace();
            fail("Unexpected Exception: " + e.getMessage());
        }
    }
    
    class Filter implements StreamFilter {
        
        public boolean accept(XMLStreamReader reader) {
            return true;
        }        
    }    
}
