/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */


package entities;

import java.net.URL;
import java.io.*;
import javax.xml.stream.*;
import javax.xml.stream.events.* ;
import java.util.Date;
import junit.framework.TestCase;
import junit.textui.TestRunner;


/**
 * @author K.Venugopal@sun.com
 */

public class TestEntity extends TestCase {
    
    XMLInputFactory factory = null;
    String output="";
    
    public TestEntity(String name) {
        super(name);
    }
    
    public static void main(String[] args) {
        TestRunner.run(TestEntity.class);
    }
    
    protected void setUp() {
        try{
            factory = XMLInputFactory.newInstance();
        }catch(Exception ex){
            fail("Could not create XMLInputFactory");
        }
    }
    
    protected void tearDown() {
        factory = null;
    }
    
    public void testProperties() {
        assertTrue(factory.isPropertySupported("javax.xml.stream.isReplacingEntityReferences"));
    }
    
    public void testCharacterReferences() {
        try{
            URL fileName = TestEntity.class.getResource("testCharRef.xml");
            URL outputFileName = TestEntity.class.getResource("testCharRef.xml.output");
            XMLStreamReader xmlr = factory.createXMLStreamReader(new InputStreamReader(fileName.openStream()));
            int eventType = 0;
            while(xmlr.hasNext()){
                eventType = xmlr.next();
                handleEvent(xmlr,eventType);
            }
            //System.out.println();
            //System.out.println(output);
            assertTrue(compareOutput(new InputStreamReader(outputFileName.openStream()), new StringReader(output)));
        }catch(Exception ex){
            ex.printStackTrace();
            fail(ex.getMessage());
        }
    }
    
    private void handleEvent(XMLStreamReader xmlr , int eventType){
        switch (eventType){
            case XMLEvent.START_ELEMENT:
                handleStartElement(xmlr);
                break;
            case XMLEvent.END_ELEMENT:
                handleEndElement(xmlr);
                break;
            case XMLEvent.CHARACTERS:
                handleCharacters(xmlr);
                break;
            case XMLEvent.COMMENT:
                handleComment(xmlr);
                break;
            case XMLEvent.ENTITY_REFERENCE:
                break;
            case XMLEvent.ATTRIBUTE:
                break;
            case XMLEvent.DTD:
                break;
            case XMLEvent.CDATA:
                break;
            default :
                break;
        }
    }
    
    private void handleStartElement(XMLStreamReader xmlr){
        output+="<";
        output+=xmlr.getLocalName();
        if(xmlr.hasText())
            output+=xmlr.getText();
        printAttributes(xmlr);
        output+=">";
    }
    
    private void handleEndElement(XMLStreamReader xmlr){
        output+="</";
        output+=xmlr.getLocalName();
        output+=">";
    }
    
    private void handleComment(XMLStreamReader xmlr){
        if(xmlr.hasText())
            output+=xmlr.getText();
    }
    private void handleCharacters(XMLStreamReader xmlr){
        if(xmlr.hasText())
            output+=xmlr.getText();
    }
    private  void printAttributes(XMLStreamReader xmlr){
        if(xmlr.getAttributeCount() > 0){
            int count = xmlr.getAttributeCount() ;
            for(int i = 0 ; i < count ; i++) {
                output+=xmlr.getAttributeName(i);
                output+="=";
                output+=xmlr.getAttributeValue(i);
                /*String name = xmlr.getAttributeName(i) ;
                String value = xmlr.getAttributeValue(i) ;
                System.out.println(name+"="+value);*/
            }
        }
    }
    
    protected boolean compareOutput(Reader expected, Reader actual)
    throws IOException {
        LineNumberReader expectedOutput = new LineNumberReader(expected);
        LineNumberReader actualOutput = new LineNumberReader(actual);
        
        while (expectedOutput.ready() && actualOutput.ready()) {
            String expectedLine = expectedOutput.readLine();
            String actualLine = actualOutput.readLine();
            if (!expectedLine.equals(actualLine)) {
                System.out.println(
                "Entityreference expansion failed, line no: " + expectedOutput.getLineNumber());
                System.out.println("Expected: " + expectedLine);
                System.out.println("Actual  : " + actualLine);
                return false;
            }
        }
        expectedOutput.close();
        actualOutput.close();
        return true;
    }
}
