/*
 * The Sleuth Kit - Add on for EWF image support
 * Eye Witness Compression Format Support
 *
 * $Date: 2007/06/05 20:04:41 $
 *
 * Joachim Metz <metz@studenten.net>
 * Copyright (c) 2006 Joachim Metz.  All rights reserved 
 *
 * Based on raw image support of the Sleuth Kit from
 * Brian Carrier.
 */
#ifndef _EWF_H
#define _EWF_H

#ifdef USE_LIBEWF

#include <libewf.h>

#ifdef __cplusplus
extern "C" {
#endif

    extern TSK_IMG_INFO *ewf_open(int, const char **, TSK_IMG_INFO *);

    typedef struct IMG_EWF_INFO IMG_EWF_INFO;
    struct IMG_EWF_INFO {
        TSK_IMG_INFO img_info;
        LIBEWF_HANDLE *handle;
        char md5hash[LIBEWF_STRING_DIGEST_HASH_LENGTH_MD5];
        int md5hash_isset;
    };

#ifdef __cplusplus
}
#endif
#endif
#endif
