/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.pattern.parser.ScanException;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.IntegerTokenConverter;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FileNamePattern
extends ContextAwareBase {
    static final Map<String, String> CONVERTER_MAP = new HashMap<String, String>();
    String pattern;
    Converter<Object> headTokenConverter;

    static {
        CONVERTER_MAP.put("i", IntegerTokenConverter.class.getName());
        CONVERTER_MAP.put("d", DateTokenConverter.class.getName());
    }

    public FileNamePattern(String patternArg, Context contextArg) {
        this.setPattern(patternArg);
        this.setContext(contextArg);
        this.parse();
        DynamicConverter.startConverters(this.headTokenConverter);
    }

    void parse() {
        try {
            Parser p = new Parser(this.pattern);
            p.setContext(this.context);
            Node t = p.parse();
            this.headTokenConverter = p.compile(t, CONVERTER_MAP);
        }
        catch (ScanException sce) {
            this.addError("Failed to parse pattern \"" + this.pattern + "\".", sce);
        }
    }

    public String toString() {
        return this.pattern;
    }

    public DateTokenConverter getDateTokenConverter() {
        Converter<Object> p = this.headTokenConverter;
        while (p != null) {
            if (p instanceof DateTokenConverter) {
                return (DateTokenConverter)p;
            }
            p = p.getNext();
        }
        return null;
    }

    public IntegerTokenConverter getIntegerTokenConverter() {
        Converter<Object> p = this.headTokenConverter;
        while (p != null) {
            if (p instanceof IntegerTokenConverter) {
                return (IntegerTokenConverter)p;
            }
            p = p.getNext();
        }
        return null;
    }

    public String convert(Object o) {
        Converter<Object> p = this.headTokenConverter;
        StringBuffer buf = new StringBuffer();
        while (p != null) {
            buf.append(p.convert(o));
            p = p.getNext();
        }
        return buf.toString();
    }

    public String convertInt(int i) {
        Integer integerArg = new Integer(i);
        return this.convert(integerArg);
    }

    public String convertDate(Date date) {
        return this.convert(date);
    }

    public void setPattern(String pattern) {
        if (pattern != null) {
            this.pattern = pattern.trim();
        }
    }

    public String getPattern() {
        return this.pattern;
    }
}

