/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import java.io.Serializable;

public class ThrowableInformation
implements Serializable {
    private static final long serialVersionUID = 6307784764626694851L;
    private String[] sa;
    private final transient Throwable throwable;

    public ThrowableInformation(Throwable throwable) {
        this.throwable = throwable;
        this.sa = this.extractStringRep(throwable, null);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String[] extractStringRep(Throwable t, StackTraceElement[] parentSTE) {
        String[] result;
        Throwable cause;
        StackTraceElement[] ste = t.getStackTrace();
        int commonFrames = this.findCommonFrames(ste, parentSTE);
        String[] firstArray = commonFrames == 0 ? new String[ste.length + 1] : new String[ste.length - commonFrames + 2];
        String prefix = "";
        if (parentSTE != null) {
            prefix = "Caused by: ";
        }
        firstArray[0] = String.valueOf(prefix) + t.getClass().getName();
        if (t.getMessage() != null) {
            firstArray[0] = String.valueOf(firstArray[0]) + ": " + t.getMessage();
        }
        int i = 0;
        while (i < ste.length - commonFrames) {
            firstArray[i + 1] = ste[i].toString();
            ++i;
        }
        if (commonFrames != 0) {
            firstArray[firstArray.length - 1] = String.valueOf(commonFrames) + " common frames omitted";
        }
        if ((cause = t.getCause()) != null) {
            String[] causeArray = this.extractStringRep(cause, ste);
            String[] tmp = new String[firstArray.length + causeArray.length];
            System.arraycopy(firstArray, 0, tmp, 0, firstArray.length);
            System.arraycopy(causeArray, 0, tmp, firstArray.length, causeArray.length);
            result = tmp;
        } else {
            result = firstArray;
        }
        return result;
    }

    private int findCommonFrames(StackTraceElement[] ste, StackTraceElement[] parentSTE) {
        if (parentSTE == null) {
            return 0;
        }
        int steIndex = ste.length - 1;
        int parentIndex = parentSTE.length - 1;
        int count = 0;
        while (steIndex >= 0 && parentIndex >= 0) {
            if (!ste[steIndex].equals(parentSTE[parentIndex])) break;
            ++count;
            --steIndex;
            --parentIndex;
        }
        return count;
    }

    public String[] getThrowableStrRep() {
        return this.sa;
    }
}

