/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.ULogger;
import org.apache.log4j.pattern.LoggingEventPatternConverter;
import org.apache.log4j.spi.LoggingEvent;

public final class PropertiesPatternConverter
extends LoggingEventPatternConverter {
    private final String option;

    private PropertiesPatternConverter(String[] options, ULogger logger) {
        super(options != null && options.length > 0 ? "Property{" + options[0] + "}" : "Properties", "property");
        this.option = options != null && options.length > 0 ? options[0] : null;
    }

    public static PropertiesPatternConverter newInstance(String[] options, ULogger logger) {
        return new PropertiesPatternConverter(options, logger);
    }

    public void format(LoggingEvent event, StringBuffer toAppendTo) {
        if (this.option == null) {
            toAppendTo.append("{");
            Set keySet = event.getPropertyKeySet();
            Iterator i = keySet.iterator();
            while (i.hasNext()) {
                Object item = i.next();
                String val = event.getProperty(item.toString());
                toAppendTo.append("{").append(item).append(",").append((Object)val).append("}");
            }
            toAppendTo.append("}");
        } else {
            String val = event.getProperty(this.option);
            if (val != null) {
                toAppendTo.append((Object)val);
            }
        }
    }
}

