/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.plugins;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.LoggerRepository;

public abstract class PluginSkeleton
extends ComponentBase
implements Plugin {
    protected String name = "";
    protected boolean active;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.propertySupport.firePropertyChange("name", oldName, this.name);
    }

    public LoggerRepository getLoggerRepository() {
        return this.repository;
    }

    public void setLoggerRepository(LoggerRepository repository) {
        LoggerRepository oldValue = this.repository;
        this.repository = repository;
        this.firePropertyChange("loggerRepository", oldValue, this.repository);
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public boolean isEquivalent(Plugin testPlugin) {
        return this.repository == testPlugin.getLoggerRepository() && (this.name == null && testPlugin.getName() == null || this.name != null && this.name.equals(testPlugin.getName())) && this.getClass().equals(testPlugin.getClass());
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    protected final void firePropertyChange(PropertyChangeEvent evt) {
        this.propertySupport.firePropertyChange(evt);
    }

    protected final void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public abstract void shutdown();

    public abstract void activateOptions();
}

