/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import java.io.Serializable;
import org.apache.log4j.helpers.PlatformInfo;
import org.apache.log4j.spi.location.LegacyExtractor;
import org.apache.log4j.spi.location.StackTraceElementExtractor;

public class LocationInfo
implements Serializable {
    public static final String NA = "?";
    static final long serialVersionUID = -1325822038990805636L;
    public static LocationInfo NA_LOCATION_INFO = new LocationInfo("?", "?", "?", "?");
    public String lineNumber;
    public String fileName;
    public String className;
    public String methodName;
    public transient String fullInfo;

    public LocationInfo(String fileName, String className, String methodName, String lineNumber) {
        this.fileName = fileName;
        this.className = className;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
    }

    public LocationInfo(Throwable t, String fqnOfInvokingClass) {
        if (t == null) {
            return;
        }
        if (PlatformInfo.hasStackTraceElement()) {
            StackTraceElementExtractor.extract(this, t, fqnOfInvokingClass);
        } else {
            LegacyExtractor.extract(this, t, fqnOfInvokingClass);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocationInfo)) {
            return false;
        }
        LocationInfo r = (LocationInfo)o;
        if (!this.getClassName().equals(r.getClassName())) {
            return false;
        }
        if (!this.getFileName().equals(r.getFileName())) {
            return false;
        }
        if (!this.getMethodName().equals(r.getMethodName())) {
            return false;
        }
        return this.getLineNumber().equals(r.getLineNumber());
    }

    public String getClassName() {
        return this.className;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getFullInfo() {
        if (this.fullInfo == null) {
            this.fullInfo = this.getClassName() + "." + this.getMethodName() + "(" + this.getFileName() + ":" + this.getLineNumber() + ")";
        }
        return this.fullInfo;
    }

    public String toString() {
        return "(class=" + this.getClassName() + ", file=" + this.getFileName() + ", line=" + this.getLineNumber() + ", methodName=" + this.getMethodName();
    }
}

