#include <stdio.h>
#include <string.h>

#include "lrmi.h"

int
do_int15(void)
{
	struct LRMI_regs r;
	int             retval;

	if (!LRMI_init())
		return 0;

	memset(&r, 0, sizeof(r));

	r.eax = 0x53B0;
	r.ebx = 0x0172;
	r.ecx = 0x6164;

	retval = LRMI_int(0x15, &r);

	if (!retval) {
		printf("Failed!\n");
		return 0;
	}
	if ((r.flags & 1 == 0)) {
		printf("BIOS seems to support smbus bios call 'installation check:\n");
		printf("SMBus bios interface specification version = %d.%d\n",
		        (r.eax & 0xff00) >> 8,
			(r.eax & 0xff));
		printf("number of devices present = %d\n", r.ebx & 0xff);
		printf("ch cl = %c%c (should be 'iA')\n", (r.ecx & 0xff00) >> 8, r.ecx & 0xff);
		printf("vendor specified smbus hardware code = 0x%.16x\n", r.edx & 0xffff);
	} else {
		printf("BIOS DO NOT support smbus bios check call.  Dumping registers anyway:\n");
		printf("eax = 0x%.8x\n", r.eax);
		printf("ebx = 0x%.8x\n", r.ebx);
		printf("ecx = 0x%.8x\n", r.ecx);
		printf("edx = 0x%.8x\n", r.edx);
	}
	return 1;
}
