#! /bin/sh

### Since the Snort makefiles seem to be a challenge to patch,
### I've written this script to make things easier.
### 
### Run this script with the path to the Snort source directory
###
### Example:  patchsnort.sh snort-1.9.0
###

snortpath=$1

if [ "${snortpath}" = '' ];then
	echo "Usage: patchsnort <path-to-snort-source>"
	exit 1
fi

snortversion="n"

if [ -r ${snortpath}/snort.c ];then
	if [ -r ${snortpath}/twofish.c ];then
		snortversion="a"
	else
		snortversion="1.8"
	fi
elif [ -r ${snortpath}/src/parser/Makefile.am ];then
	if [ -r ${snortpath}/src/twofish.c ];then
		snortversion="a"
	else
		snortversion="2.x"
	fi
elif [ -r ${snortpath}/src/snort.c ];then
	if [ -r ${snortpath}/src/twofish.c ];then
		snortversion="a"
	else
		snortversion="1.9"
	fi
fi
case ${snortversion} in
	'n')
		echo "Can't find Snort sources in '${snortpath}'!"
		exit 2
	;;
	'a')
		echo "SnortSam patch already applied in '${snortpath}'!"
		exit 3
	;;
	'1.8')
		echo "Patching Snort version ${snortversion}..."
		cp snortpatchb ${snortpath}
		cp snortpatch8 ${snortpath}
		cd ${snortpath}
		patch < snortpatchb
		patch < snortpatch8
		echo "#define PLUGIN_FWSAM	27" > plugin_enum.h
                rm snortpatchb snortpatch8
		rm spo_alert_fwsam.?.orig twofish.?.orig
		echo "/* Dummy util.h file created by SnortSam patch */" > util.h
		echo "Patching Makefiles..."
		mv Makefile.in Makefile.in.bak
		cat Makefile.in.bak |\
		sed "s/plugbase\.c/plugbase\.c\ twofish\.c\ twofish\.h\ spo_alert_fwsam\.c\ spo_alert_fwsam\.h/" |\
		sed "s/plugbase\.o/plugbase\.o\ twofish\.o\ spo_alert_fwsam\.o/" |\
		sed "s/plugbase\...OBJEXT./plugbase\.\${OBJEXT}\ twofish\.\${OBJEXT}\ spo_alert_fwsam\.\${OBJEXT}/" > Makefile.in
		mv Makefile.am Makefile.am.bak
		cat Makefile.am.bak |\
		sed "s/plugbase\.c/plugbase\.c\ twofish\.c\ twofish\.h\ spo_alert_fwsam\.c\ spo_alert_fwsam\.h/" |\
		sed "s/plugbase\.o/plugbase\.o\ twofish\.o\ spo_alert_fwsam\.o/" |\
		sed "s/plugbase\...OBJEXT./plugbase\.\${OBJEXT}\ twofish\.\${OBJEXT}\ spo_alert_fwsam\.\${OBJEXT}/" > Makefile.am
	;;
	'1.9')
		echo "Patching Snort version ${snortversion}..."
		cp snortpatchb ${snortpath}/src
		cp snortpatch9 ${snortpath}/src
		cd ${snortpath}/src
		patch < snortpatchb
		mv spo_alert_fwsam.? output-plugins
		rm spo_alert_fwsam.?.orig twofish.?.orig
		patch < snortpatch9
                rm snortpatchb snortpatch9
		echo "Patching Makefiles..."
		mv Makefile.in Makefile.in.bak
		cat Makefile.in.bak |\
		sed "s/plugbase\.c/plugbase\.c\ twofish\.c\ twofish\.h/" |\
		sed "s/plugbase\.o/plugbase\.o\ twofish\.o/" > Makefile.in
		mv Makefile.am Makefile.am.bak
		cat Makefile.am.bak |\
		sed "s/plugbase\.c/plugbase\.c\ twofish\.c\ twofish\.h/" |\
		sed "s/plugbase\.o/plugbase\.o\ twofish\.o/" > Makefile.am
		cd output-plugins
		mv Makefile.in Makefile.in.bak
		cat Makefile.in.bak |\
		sed "s/spo_alert_fast\.c/spo_alert_fast\.c\ spo_alert_fwsam\.c\ spo_alert_fwsam\.h/" |\
		sed "s/spo_alert_fast\.o/spo_alert_fast\.o\ spo_alert_fwsam\.o/" > Makefile.in
		mv Makefile.am Makefile.am.bak
		cat Makefile.am.bak |\
		sed "s/spo_alert_fast\.c/spo_alert_fast\.c\ spo_alert_fwsam\.c\ spo_alert_fwsam\.h/" |\
		sed "s/spo_alert_fast\.o/spo_alert_fast\.o\ spo_alert_fwsam\.o/" > Makefile.am
	;;
	'2.x')
		echo "Patching Snort version ${snortversion}..."
		cp snortpatchb ${snortpath}/src
		cp snortpatch9 ${snortpath}/src
		cd ${snortpath}/src
		patch < snortpatchb
		mv spo_alert_fwsam.? output-plugins
		rm spo_alert_fwsam.?.orig twofish.?.orig
		patch < snortpatch9
                rm snortpatchb snortpatch9
		echo "Patching Makefiles..."
		mv Makefile.am Makefile.am.bak
		cat Makefile.am.bak |\
		sed "s/plugbase\.c/plugbase\.c\ twofish\.c\ twofish\.h/" |\
		sed "s/plugbase\.o/plugbase\.o\ twofish\.o/" > Makefile.am
		cd output-plugins
		mv Makefile.am Makefile.am.bak
		cat Makefile.am.bak |\
		sed "s/spo_alert_fast\.c/spo_alert_fast\.c\ spo_alert_fwsam\.c\ spo_alert_fwsam\.h/" |\
		sed "s/spo_alert_fast\.o/spo_alert_fast\.o\ spo_alert_fwsam\.o/" > Makefile.am
	;;
esac
echo "Done"

