/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementPattern
extends QueryModelNodeBase
implements TupleExpr {
    private Scope scope;
    private Var subjectVar;
    private Var predicateVar;
    private Var objectVar;
    private Var contextVar;

    public StatementPattern() {
    }

    public StatementPattern(Var subject, Var predicate, Var object) {
        this(Scope.DEFAULT_CONTEXTS, subject, predicate, object);
    }

    public StatementPattern(Scope scope, Var subject, Var predicate, Var object) {
        this(scope, subject, predicate, object, null);
    }

    public StatementPattern(Var subject, Var predicate, Var object, Var context) {
        this(Scope.DEFAULT_CONTEXTS, subject, predicate, object, context);
    }

    public StatementPattern(Scope scope, Var subjVar, Var predVar, Var objVar, Var conVar) {
        this.setScope(scope);
        this.setSubjectVar(subjVar);
        this.setPredicateVar(predVar);
        this.setObjectVar(objVar);
        this.setContextVar(conVar);
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        assert (scope != null) : "scope must not be null";
        this.scope = scope;
    }

    public Var getSubjectVar() {
        return this.subjectVar;
    }

    public void setSubjectVar(Var subject) {
        assert (subject != null) : "subject must not be null";
        subject.setParentNode(this);
        this.subjectVar = subject;
    }

    public Var getPredicateVar() {
        return this.predicateVar;
    }

    public void setPredicateVar(Var predicate) {
        assert (predicate != null) : "predicate must not be null";
        predicate.setParentNode(this);
        this.predicateVar = predicate;
    }

    public Var getObjectVar() {
        return this.objectVar;
    }

    public void setObjectVar(Var object) {
        assert (object != null) : "object must not be null";
        object.setParentNode(this);
        this.objectVar = object;
    }

    public Var getContextVar() {
        return this.contextVar;
    }

    public void setContextVar(Var context) {
        if (context != null) {
            context.setParentNode(this);
        }
        this.contextVar = context;
    }

    @Override
    public Set<String> getBindingNames() {
        HashSet<String> bindingNames = new HashSet<String>(8);
        if (this.subjectVar != null) {
            bindingNames.add(this.subjectVar.getName());
        }
        if (this.predicateVar != null) {
            bindingNames.add(this.predicateVar.getName());
        }
        if (this.objectVar != null) {
            bindingNames.add(this.objectVar.getName());
        }
        if (this.contextVar != null) {
            bindingNames.add(this.contextVar.getName());
        }
        return bindingNames;
    }

    public List<Var> getVarList() {
        return this.getVars(new ArrayList(4));
    }

    public <L extends Collection<Var>> L getVars(L varCollection) {
        if (this.subjectVar != null) {
            varCollection.add((Var)this.subjectVar);
        }
        if (this.predicateVar != null) {
            varCollection.add((Var)this.predicateVar);
        }
        if (this.objectVar != null) {
            varCollection.add((Var)this.objectVar);
        }
        if (this.contextVar != null) {
            varCollection.add((Var)this.contextVar);
        }
        return varCollection;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        if (this.subjectVar != null) {
            this.subjectVar.visit(visitor);
        }
        if (this.predicateVar != null) {
            this.predicateVar.visit(visitor);
        }
        if (this.objectVar != null) {
            this.objectVar.visit(visitor);
        }
        if (this.contextVar != null) {
            this.contextVar.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.subjectVar == current) {
            this.setSubjectVar((Var)replacement);
        } else if (this.predicateVar == current) {
            this.setPredicateVar((Var)replacement);
        } else if (this.objectVar == current) {
            this.setObjectVar((Var)replacement);
        } else if (this.contextVar == current) {
            this.setContextVar((Var)replacement);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.getSignature());
        if (this.scope == Scope.NAMED_CONTEXTS) {
            sb.append(" FROM NAMED CONTEXT");
        }
        return sb.toString();
    }

    @Override
    public StatementPattern clone() {
        StatementPattern clone = (StatementPattern)super.clone();
        clone.setSubjectVar(this.getSubjectVar().clone());
        clone.setPredicateVar(this.getPredicateVar().clone());
        clone.setObjectVar(this.getObjectVar().clone());
        if (this.getContextVar() != null) {
            clone.setContextVar(this.getContextVar().clone());
        }
        return clone;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scope {
        DEFAULT_CONTEXTS,
        NAMED_CONTEXTS;

    }
}

