/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UriUtil {
    private static final String ESCAPE_CHARS = "<>%\"{}|\\^[]`";

    public static String encodeUri(String uri) {
        StringBuilder result = new StringBuilder();
        UriUtil.encodeUri(uri, result);
        return result.toString();
    }

    public static void encodeUri(String uri, StringBuilder buf) {
        int uriLen = uri.length();
        for (int i = 0; i < uriLen; ++i) {
            char c;
            char cInt = c = uri.charAt(i);
            if (ESCAPE_CHARS.indexOf(c) >= 0 || cInt <= ' ') {
                buf.append('%');
                String hexVal = Integer.toHexString(cInt);
                if (hexVal.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexVal);
                continue;
            }
            buf.append(c);
        }
    }

    public static String decodeUri(String uri) {
        StringBuilder result = new StringBuilder();
        UriUtil.decodeUri(uri, result);
        return result.toString();
    }

    public static void decodeUri(String uri, StringBuilder buf) {
        int percentIdx = uri.indexOf(37);
        int startIdx = 0;
        while (percentIdx != -1 && percentIdx < uri.length() - 3) {
            buf.append(uri.substring(startIdx, percentIdx));
            String xx = uri.substring(percentIdx + 1, percentIdx + 3);
            try {
                buf.append((char)Integer.parseInt(xx, 16));
            }
            catch (NumberFormatException e) {
                buf.append('%');
                buf.append(xx);
            }
            startIdx = percentIdx + 3;
            percentIdx = uri.indexOf(37, startIdx);
        }
        buf.append(uri.substring(startIdx));
    }

    public static String buildQueryString(Map<String, String> keyValuePairs) {
        StringBuilder result = new StringBuilder();
        Set<Map.Entry<String, String>> entrySet = keyValuePairs.entrySet();
        Iterator<Map.Entry<String, String>> iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> keyValuePair = iter.next();
            String key = keyValuePair.getKey();
            String value = keyValuePair.getValue();
            UriUtil.formUrlEncode(key, result);
            result.append('=');
            UriUtil.formUrlEncode(value, result);
            if (!iter.hasNext()) continue;
            result.append('&');
        }
        return result.toString();
    }

    public static void formUrlEncode(String s, StringBuilder buf) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            char cInt = c;
            if (cInt >= '0' && cInt <= '9' || cInt >= 'A' && cInt <= 'Z' || cInt >= 'a' && cInt <= 'z') {
                buf.append(c);
                continue;
            }
            buf.append('%');
            String hexVal = Integer.toHexString(cInt);
            if (hexVal.length() == 1) {
                buf.append('0');
            }
            buf.append(hexVal);
        }
    }

    public static String formUrlEncode(String s) {
        StringBuilder result = new StringBuilder();
        UriUtil.formUrlEncode(s, result);
        return result.toString();
    }

    public static URI urlToUri(URL url) throws URISyntaxException {
        return new URI(UriUtil.encodeUri(url.toExternalForm()));
    }
}

