# This test checks if spamdyke will skip graylisting when graylist-level is
# "none".

export TCPREMOTEIP=${TESTSD_MISSING_RDNS_IP}

FROM_ADDRESS=test-${TEST_NUM}.${RANDOM}.${RANDOM}@example.com

mkdir -p ${TMPDIR}/${TEST_NUM}-graylist.d/`echo $1 | sed -e "s/[^@]*@//" | awk '{ print tolower($1) }'`
echo 11.22.33.44 > ${TMPDIR}/${TEST_NUM}-exception_ip.txt
echo example.com > ${TMPDIR}/${TEST_NUM}-exception_rdns.txt

cat input.txt | sed -e "s/TEST_NUM/${TEST_NUM}/g" -e "s/TARGET_EMAIL/$1/g" -e "s/FROM_ADDRESS/${FROM_ADDRESS}/g" > ${TMPDIR}/${TEST_NUM}-input.txt
echo "${SENDRECV_PATH} -t 30 -r 221 -- ${SPAMDYKE_PATH} --graylist-level none -g ${TMPDIR}/${TEST_NUM}-graylist.d --graylist-exception-ip-file ${TMPDIR}/${TEST_NUM}-exception_ip.txt --graylist-exception-rdns-file ${TMPDIR}/${TEST_NUM}-exception_rdns.txt ${QMAIL_CMDLINE} < ${TMPDIR}/${TEST_NUM}-input.txt > ${TMPDIR}/${TEST_NUM}-output.txt"
${SENDRECV_PATH} -t 30 -r 221 -- ${SPAMDYKE_PATH} --graylist-level none -g ${TMPDIR}/${TEST_NUM}-graylist.d --graylist-exception-ip-file ${TMPDIR}/${TEST_NUM}-exception_ip.txt --graylist-exception-rdns-file ${TMPDIR}/${TEST_NUM}-exception_rdns.txt ${QMAIL_CMDLINE} < ${TMPDIR}/${TEST_NUM}-input.txt > ${TMPDIR}/${TEST_NUM}-output.txt

output=`grep -E "250 ok [0-9]* qp [0-9]*" ${TMPDIR}/${TEST_NUM}-output.txt`
if [ ! -z "${output}" ]
then
  outcome="success"
else
  echo OUTPUT IN tmp/${TEST_NUM}-output.txt:
  cat ${TMPDIR}/${TEST_NUM}-output.txt

  outcome="failure"
fi
