/* foreign-menu.c generated by valac 0.20.1, the Vala compiler
 * generated from foreign-menu.vala, do not modify */

/* Copyright (C) 2012 Red Hat, Inc.*/
/* This library is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU Lesser General Public*/
/* License as published by the Free Software Foundation; either*/
/* version 2.1 of the License, or (at your option) any later version.*/
/* This library is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU*/
/* Lesser General Public License for more details.*/
/* You should have received a copy of the GNU Lesser General Public*/
/* License along with this library; if not, see <http://www.gnu.org/licenses/>.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <spice/foreign_menu_prot.h>
#include <spice/controller_prot.h>
#include <custom.h>
#include <spice-foreign-menu-listener.h>


#define SPICE_CTRL_TYPE_FOREIGN_MENU (spice_ctrl_foreign_menu_get_type ())
#define SPICE_CTRL_FOREIGN_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CTRL_TYPE_FOREIGN_MENU, SpiceCtrlForeignMenu))
#define SPICE_CTRL_FOREIGN_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CTRL_TYPE_FOREIGN_MENU, SpiceCtrlForeignMenuClass))
#define SPICE_CTRL_IS_FOREIGN_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CTRL_TYPE_FOREIGN_MENU))
#define SPICE_CTRL_IS_FOREIGN_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CTRL_TYPE_FOREIGN_MENU))
#define SPICE_CTRL_FOREIGN_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CTRL_TYPE_FOREIGN_MENU, SpiceCtrlForeignMenuClass))

typedef struct _SpiceCtrlForeignMenu SpiceCtrlForeignMenu;
typedef struct _SpiceCtrlForeignMenuClass SpiceCtrlForeignMenuClass;
typedef struct _SpiceCtrlForeignMenuPrivate SpiceCtrlForeignMenuPrivate;

#define SPICE_CTRL_TYPE_MENU (spice_ctrl_menu_get_type ())
#define SPICE_CTRL_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CTRL_TYPE_MENU, SpiceCtrlMenu))
#define SPICE_CTRL_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CTRL_TYPE_MENU, SpiceCtrlMenuClass))
#define SPICE_CTRL_IS_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CTRL_TYPE_MENU))
#define SPICE_CTRL_IS_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CTRL_TYPE_MENU))
#define SPICE_CTRL_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CTRL_TYPE_MENU, SpiceCtrlMenuClass))

typedef struct _SpiceCtrlMenu SpiceCtrlMenu;
typedef struct _SpiceCtrlMenuClass SpiceCtrlMenuClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SpiceCtrlForeignMenuSendMsgData SpiceCtrlForeignMenuSendMsgData;
typedef struct _SpiceCtrlMenuPrivate SpiceCtrlMenuPrivate;

#define SPICE_CTRL_TYPE_MENU_ITEM (spice_ctrl_menu_item_get_type ())
#define SPICE_CTRL_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CTRL_TYPE_MENU_ITEM, SpiceCtrlMenuItem))
#define SPICE_CTRL_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CTRL_TYPE_MENU_ITEM, SpiceCtrlMenuItemClass))
#define SPICE_CTRL_IS_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CTRL_TYPE_MENU_ITEM))
#define SPICE_CTRL_IS_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CTRL_TYPE_MENU_ITEM))
#define SPICE_CTRL_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CTRL_TYPE_MENU_ITEM, SpiceCtrlMenuItemClass))

typedef struct _SpiceCtrlMenuItem SpiceCtrlMenuItem;
typedef struct _SpiceCtrlMenuItemClass SpiceCtrlMenuItemClass;
typedef struct _SpiceCtrlForeignMenuHandleClientData SpiceCtrlForeignMenuHandleClientData;
typedef struct _SpiceCtrlForeignMenuListenData SpiceCtrlForeignMenuListenData;

struct _SpiceCtrlForeignMenu {
	GObject parent_instance;
	SpiceCtrlForeignMenuPrivate * priv;
};

struct _SpiceCtrlForeignMenuClass {
	GObjectClass parent_class;
};

struct _SpiceCtrlForeignMenuPrivate {
	SpiceCtrlMenu* _menu;
	gchar* _title;
	gint nclients;
	GList* clients;
};

struct _SpiceCtrlForeignMenuSendMsgData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SpiceCtrlForeignMenu* self;
	guint8* p;
	gint p_length1;
	gboolean result;
	GList* _tmp0_;
	GList* c_collection;
	GList* c_it;
	GIOStream* _tmp1_;
	GIOStream* c;
	GIOStream* _tmp2_;
	GOutputStream* _tmp3_;
	GOutputStream* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	GError* e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError * _inner_error_;
};

struct _SpiceCtrlMenu {
	GObject parent_instance;
	SpiceCtrlMenuPrivate * priv;
	GList* items;
};

struct _SpiceCtrlMenuClass {
	GObjectClass parent_class;
};

struct _SpiceCtrlForeignMenuHandleClientData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SpiceCtrlForeignMenu* self;
	GIOStream* c;
	guint8* _tmp0_;
	guint8* p;
	gint p_length1;
	gint _p_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	FrgMenuInitHeader* header;
	GIOStream* _tmp2_;
	GInputStream* _tmp3_;
	GInputStream* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	FrgMenuInitHeader* _tmp6_;
	guint32 _tmp7_;
	gboolean _tmp8_;
	FrgMenuInitHeader* _tmp9_;
	guint32 _tmp10_;
	gboolean _tmp11_;
	FrgMenuInitHeader* _tmp12_;
	guint32 _tmp13_;
	gboolean _tmp14_;
	guint8* _tmp15_;
	guint8* cp;
	gint cp_length1;
	gint _cp_size_;
	GIOStream* _tmp16_;
	GInputStream* _tmp17_;
	GInputStream* _tmp18_;
	guint8* _tmp19_;
	gint _tmp19__length1;
	guint8* _tmp20_;
	gint _tmp20__length1;
	guint64 credentials;
	guint64 _tmp21_;
	gboolean _tmp22_;
	FrgMenuInitHeader* _tmp23_;
	guint32 _tmp24_;
	gulong title_size;
	gulong _tmp25_;
	guint8* _tmp26_;
	guint8* title;
	gint title_length1;
	gint _title_size_;
	GIOStream* _tmp27_;
	GInputStream* _tmp28_;
	GInputStream* _tmp29_;
	guint8* _tmp30_;
	gint _tmp30__length1;
	gulong _tmp31_;
	guint8* _tmp32_;
	gint _tmp32__length1;
	gboolean _tmp33_;
	gboolean _tmp34_;
	guint8* _tmp35_;
	guint8* t;
	gint t_length1;
	gint _t_size_;
	GIOStream* _tmp36_;
	GInputStream* _tmp37_;
	GInputStream* _tmp38_;
	guint8* _tmp39_;
	gint _tmp39__length1;
	guint8* _tmp40_;
	gint _tmp40__length1;
	FrgMenuMsg* msg;
	FrgMenuMsg* _tmp41_;
	guint32 _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	FrgMenuMsg* _tmp49_;
	guint32 _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	FrgMenuMsg* _tmp55_;
	guint32 _tmp56_;
	gboolean _tmp57_;
	FrgMenuMsg* _tmp58_;
	guint32 _tmp59_;
	FrgMenuMsg* _tmp60_;
	guint32 _tmp61_;
	gint _tmp62_;
	guint8* _tmp63_;
	gint _tmp63__length1;
	GIOStream* _tmp64_;
	GInputStream* _tmp65_;
	GInputStream* _tmp66_;
	guint8* _tmp67_;
	gint _tmp67__length1;
	FrgMenuMsg* _tmp68_;
	guint32 _tmp69_;
	FrgMenuMsg* _tmp70_;
	GError * _inner_error_;
};

typedef enum  {
	SPICE_CTRL_ERROR_VALUE
} SpiceCtrlError;
#define SPICE_CTRL_ERROR spice_ctrl_error_quark ()
struct _SpiceCtrlForeignMenuListenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SpiceCtrlForeignMenu* self;
	gchar* addr;
	const gchar* _tmp0_;
	GObject* _tmp1_;
	GObject* listener;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GObject* _tmp4_;
	GIOStream* _tmp5_;
	GIOStream* _tmp6_;
	GIOStream* c;
	gint _tmp7_;
	GIOStream* _tmp8_;
	GIOStream* _tmp9_;
	GIOStream* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GIOStream* _tmp13_;
	GIOStream* _tmp14_;
	gint _tmp15_;
	GError * _inner_error_;
};


static gpointer spice_ctrl_foreign_menu_parent_class = NULL;

GType spice_ctrl_foreign_menu_get_type (void) G_GNUC_CONST;
GType spice_ctrl_menu_get_type (void) G_GNUC_CONST;
#define SPICE_CTRL_FOREIGN_MENU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SPICE_CTRL_TYPE_FOREIGN_MENU, SpiceCtrlForeignMenuPrivate))
enum  {
	SPICE_CTRL_FOREIGN_MENU_DUMMY_PROPERTY,
	SPICE_CTRL_FOREIGN_MENU_MENU,
	SPICE_CTRL_FOREIGN_MENU_TITLE
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
SpiceCtrlForeignMenu* spice_ctrl_foreign_menu_new (void);
SpiceCtrlForeignMenu* spice_ctrl_foreign_menu_construct (GType object_type);
SpiceCtrlMenu* spice_ctrl_menu_new (void);
SpiceCtrlMenu* spice_ctrl_menu_construct (GType object_type);
static void spice_ctrl_foreign_menu_set_menu (SpiceCtrlForeignMenu* self, SpiceCtrlMenu* value);
void spice_ctrl_foreign_menu_menu_item_click_msg (SpiceCtrlForeignMenu* self, gint32 item_id);
void spice_ctrl_foreign_menu_send_msg (SpiceCtrlForeignMenu* self, guint8* p, int p_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean spice_ctrl_foreign_menu_send_msg_finish (SpiceCtrlForeignMenu* self, GAsyncResult* _res_, GError** error);
static guint8* _vala_array_dup6 (guint8* self, int length);
void spice_ctrl_foreign_menu_menu_item_checked_msg (SpiceCtrlForeignMenu* self, gint32 item_id, gboolean checked);
static guint8* _vala_array_dup7 (guint8* self, int length);
void spice_ctrl_foreign_menu_app_activated_msg (SpiceCtrlForeignMenu* self, gboolean activated);
static guint8* _vala_array_dup8 (guint8* self, int length);
static void spice_ctrl_foreign_menu_send_msg_data_free (gpointer _data);
static gboolean spice_ctrl_foreign_menu_send_msg_co (SpiceCtrlForeignMenuSendMsgData* _data_);
void spice_ctrl_output_stream_write (GOutputStream* stream, guint8* buffer, int buffer_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void spice_ctrl_output_stream_write_finish (GAsyncResult* _res_, GError** error);
static guint8* _vala_array_dup9 (guint8* self, int length);
static void spice_ctrl_foreign_menu_send_msg_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static unsigned int spice_ctrl_foreign_menu_get_menu_flags (SpiceCtrlForeignMenu* self, guint32 type);
static gboolean spice_ctrl_foreign_menu_handle_message (SpiceCtrlForeignMenu* self, FrgMenuMsg* msg);
static void spice_ctrl_foreign_menu_set_title (SpiceCtrlForeignMenu* self, const gchar* value);
SpiceCtrlMenu* spice_ctrl_foreign_menu_get_menu (SpiceCtrlForeignMenu* self);
GType spice_ctrl_menu_item_get_type (void) G_GNUC_CONST;
SpiceCtrlMenuItem* spice_ctrl_menu_item_new (gint id, const gchar* text, unsigned int flags);
SpiceCtrlMenuItem* spice_ctrl_menu_item_construct (GType object_type, gint id, const gchar* text, unsigned int flags);
static void spice_ctrl_foreign_menu_handle_client_data_free (gpointer _data);
static void spice_ctrl_foreign_menu_handle_client (SpiceCtrlForeignMenu* self, GIOStream* c, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void spice_ctrl_foreign_menu_handle_client_finish (SpiceCtrlForeignMenu* self, GAsyncResult* _res_, GError** error);
static gboolean spice_ctrl_foreign_menu_handle_client_co (SpiceCtrlForeignMenuHandleClientData* _data_);
void spice_ctrl_input_stream_read (GInputStream* stream, guint8* buffer, int buffer_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void spice_ctrl_input_stream_read_finish (GAsyncResult* _res_, GError** error);
static void spice_ctrl_foreign_menu_handle_client_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void spice_ctrl_foreign_menu_listen_data_free (gpointer _data);
GQuark spice_ctrl_error_quark (void);
void spice_ctrl_foreign_menu_listen (SpiceCtrlForeignMenu* self, const gchar* addr, GAsyncReadyCallback _callback_, gpointer _user_data_);
void spice_ctrl_foreign_menu_listen_finish (SpiceCtrlForeignMenu* self, GAsyncResult* _res_, GError** error);
static gboolean spice_ctrl_foreign_menu_listen_co (SpiceCtrlForeignMenuListenData* _data_);
static void spice_ctrl_foreign_menu_listen_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* spice_ctrl_foreign_menu_get_title (SpiceCtrlForeignMenu* self);
static void spice_ctrl_foreign_menu_finalize (GObject* obj);
static void _vala_spice_ctrl_foreign_menu_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_spice_ctrl_foreign_menu_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


SpiceCtrlForeignMenu* spice_ctrl_foreign_menu_construct (GType object_type) {
	SpiceCtrlForeignMenu * self = NULL;
	SpiceCtrlMenu* _tmp0_;
	SpiceCtrlMenu* _tmp1_;
	self = (SpiceCtrlForeignMenu*) g_object_new (object_type, NULL);
	_tmp0_ = spice_ctrl_menu_new ();
	_tmp1_ = _tmp0_;
	spice_ctrl_foreign_menu_set_menu (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}


SpiceCtrlForeignMenu* spice_ctrl_foreign_menu_new (void) {
	return spice_ctrl_foreign_menu_construct (SPICE_CTRL_TYPE_FOREIGN_MENU);
}


static guint8* _vala_array_dup6 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void spice_ctrl_foreign_menu_menu_item_click_msg (SpiceCtrlForeignMenu* self, gint32 item_id) {
	gint32 _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	FrgMenuEvent msg = {0};
	gint32 _tmp3_;
	FrgMenuEvent _tmp4_;
	FrgMenuMsg _tmp5_;
	guint32 _tmp6_;
	guint8* p;
	gint p_length1;
	gint _p_size_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = item_id;
	_tmp1_ = g_strdup_printf ("clicked id: %d", (gint) _tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("foreign-menu.vala:35: %s", _tmp2_);
	_g_free0 (_tmp2_);
	memset (&msg, 0, sizeof (FrgMenuEvent));
	msg.base.size = (guint32) sizeof (FrgMenuEvent);
	msg.base.id = (guint32) FOREIGN_MENU_ITEM_EVENT;
	_tmp3_ = item_id;
	msg.id = (guint32) _tmp3_;
	msg.action = (guint32) FOREIGN_MENU_EVENT_CLICK;
	_tmp4_ = msg;
	_tmp5_ = _tmp4_.base;
	_tmp6_ = _tmp5_.size;
	p = ((guint8*) (&msg)) + 0;
	p_length1 = _tmp6_ - 0;
	_p_size_ = p_length1;
	_tmp7_ = (p != NULL) ? _vala_array_dup6 (p, p_length1) : ((gpointer) p);
	_tmp7__length1 = p_length1;
	spice_ctrl_foreign_menu_send_msg (self, _tmp7_, _tmp7__length1, NULL, NULL);
}


static guint8* _vala_array_dup7 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void spice_ctrl_foreign_menu_menu_item_checked_msg (SpiceCtrlForeignMenu* self, gint32 item_id, gboolean checked) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gint32 _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	FrgMenuEvent msg = {0};
	gint32 _tmp6_;
	int _tmp7_ = 0;
	gboolean _tmp8_;
	int _tmp9_;
	FrgMenuEvent _tmp10_;
	FrgMenuMsg _tmp11_;
	guint32 _tmp12_;
	guint8* p;
	gint p_length1;
	gint _p_size_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	g_return_if_fail (self != NULL);
	_tmp1_ = checked;
	if (_tmp1_) {
		_tmp0_ = "";
	} else {
		_tmp0_ = "un";
	}
	_tmp2_ = _tmp0_;
	_tmp3_ = item_id;
	_tmp4_ = g_strdup_printf ("%schecked id: %d", _tmp2_, (gint) _tmp3_);
	_tmp5_ = _tmp4_;
	g_debug ("foreign-menu.vala:48: %s", _tmp5_);
	_g_free0 (_tmp5_);
	memset (&msg, 0, sizeof (FrgMenuEvent));
	msg.base.size = (guint32) sizeof (FrgMenuEvent);
	msg.base.id = (guint32) FOREIGN_MENU_ITEM_EVENT;
	_tmp6_ = item_id;
	msg.id = (guint32) _tmp6_;
	_tmp8_ = checked;
	if (_tmp8_) {
		_tmp7_ = FOREIGN_MENU_EVENT_CHECKED;
	} else {
		_tmp7_ = FOREIGN_MENU_EVENT_UNCHECKED;
	}
	_tmp9_ = _tmp7_;
	msg.action = (guint32) _tmp9_;
	_tmp10_ = msg;
	_tmp11_ = _tmp10_.base;
	_tmp12_ = _tmp11_.size;
	p = ((guint8*) (&msg)) + 0;
	p_length1 = _tmp12_ - 0;
	_p_size_ = p_length1;
	_tmp13_ = (p != NULL) ? _vala_array_dup7 (p, p_length1) : ((gpointer) p);
	_tmp13__length1 = p_length1;
	spice_ctrl_foreign_menu_send_msg (self, _tmp13_, _tmp13__length1, NULL, NULL);
}


static guint8* _vala_array_dup8 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void spice_ctrl_foreign_menu_app_activated_msg (SpiceCtrlForeignMenu* self, gboolean activated) {
	FrgMenuMsg msg = {0};
	int _tmp0_ = 0;
	gboolean _tmp1_;
	int _tmp2_;
	FrgMenuMsg _tmp3_;
	guint32 _tmp4_;
	guint8* p;
	gint p_length1;
	gint _p_size_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	memset (&msg, 0, sizeof (FrgMenuMsg));
	msg.size = (guint32) sizeof (FrgMenuEvent);
	_tmp1_ = activated;
	if (_tmp1_) {
		_tmp0_ = FOREIGN_MENU_APP_ACTIVATED;
	} else {
		_tmp0_ = FOREIGN_MENU_APP_DEACTIVATED;
	}
	_tmp2_ = _tmp0_;
	msg.id = (guint32) _tmp2_;
	_tmp3_ = msg;
	_tmp4_ = _tmp3_.size;
	p = ((guint8*) (&msg)) + 0;
	p_length1 = _tmp4_ - 0;
	_p_size_ = p_length1;
	_tmp5_ = (p != NULL) ? _vala_array_dup8 (p, p_length1) : ((gpointer) p);
	_tmp5__length1 = p_length1;
	spice_ctrl_foreign_menu_send_msg (self, _tmp5_, _tmp5__length1, NULL, NULL);
}


static void spice_ctrl_foreign_menu_send_msg_data_free (gpointer _data) {
	SpiceCtrlForeignMenuSendMsgData* _data_;
	_data_ = _data;
	_data_->p = (g_free (_data_->p), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (SpiceCtrlForeignMenuSendMsgData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void spice_ctrl_foreign_menu_send_msg (SpiceCtrlForeignMenu* self, guint8* p, int p_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SpiceCtrlForeignMenuSendMsgData* _data_;
	SpiceCtrlForeignMenu* _tmp0_;
	_data_ = g_slice_new0 (SpiceCtrlForeignMenuSendMsgData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, spice_ctrl_foreign_menu_send_msg);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, spice_ctrl_foreign_menu_send_msg_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->p = (g_free (_data_->p), NULL);
	_data_->p = p;
	_data_->p_length1 = p_length1;
	spice_ctrl_foreign_menu_send_msg_co (_data_);
}


gboolean spice_ctrl_foreign_menu_send_msg_finish (SpiceCtrlForeignMenu* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SpiceCtrlForeignMenuSendMsgData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static guint8* _vala_array_dup9 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void spice_ctrl_foreign_menu_send_msg_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SpiceCtrlForeignMenuSendMsgData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	spice_ctrl_foreign_menu_send_msg_co (_data_);
}


static gboolean spice_ctrl_foreign_menu_send_msg_co (SpiceCtrlForeignMenuSendMsgData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->clients;
		{
			_data_->c_collection = _data_->_tmp0_;
			for (_data_->c_it = _data_->c_collection; _data_->c_it != NULL; _data_->c_it = _data_->c_it->next) {
				_data_->_tmp1_ = _g_object_ref0 ((GIOStream*) _data_->c_it->data);
				_data_->c = _data_->_tmp1_;
				{
					_data_->_tmp2_ = _data_->c;
					_data_->_tmp3_ = g_io_stream_get_output_stream (_data_->_tmp2_);
					_data_->_tmp4_ = _data_->_tmp3_;
					_data_->_tmp5_ = _data_->p;
					_data_->_tmp5__length1 = _data_->p_length1;
					_data_->_tmp6_ = (_data_->_tmp5_ != NULL) ? _vala_array_dup9 (_data_->_tmp5_, _data_->_tmp5__length1) : ((gpointer) _data_->_tmp5_);
					_data_->_tmp6__length1 = _data_->_tmp5__length1;
					_data_->_state_ = 1;
					spice_ctrl_output_stream_write (_data_->_tmp4_, _data_->_tmp6_, _data_->_tmp6__length1, spice_ctrl_foreign_menu_send_msg_ready, _data_);
					return FALSE;
					_state_1:
					spice_ctrl_output_stream_write_finish (_data_->_res_, &_data_->_inner_error_);
					if (_data_->_inner_error_ != NULL) {
						_g_object_unref0 (_data_->c);
						goto __catch3_g_error;
					}
					_g_object_unref0 (_data_->c);
				}
			}
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp7_ = _data_->e;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		g_warning ("foreign-menu.vala:83: %s", _data_->_tmp8_);
		_g_error_free0 (_data_->e);
	}
	__finally3:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->p = (g_free (_data_->p), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	_data_->p = (g_free (_data_->p), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->p = (g_free (_data_->p), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static unsigned int spice_ctrl_foreign_menu_get_menu_flags (SpiceCtrlForeignMenu* self, guint32 type) {
	unsigned int result = 0;
	unsigned int flags;
	guint32 _tmp0_;
	guint32 _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	flags = 0;
	_tmp0_ = type;
	if ((FOREIGN_MENU_ITEM_TYPE_CHECKED & _tmp0_) != 0) {
		unsigned int _tmp1_;
		_tmp1_ = flags;
		flags = _tmp1_ | CONTROLLER_MENU_FLAGS_CHECKED;
	}
	_tmp2_ = type;
	if ((FOREIGN_MENU_ITEM_TYPE_DIM & _tmp2_) != 0) {
		unsigned int _tmp3_;
		_tmp3_ = flags;
		flags = _tmp3_ | CONTROLLER_MENU_FLAGS_GRAYED;
	}
	result = flags;
	return result;
}


static gboolean spice_ctrl_foreign_menu_handle_message (SpiceCtrlForeignMenu* self, FrgMenuMsg* msg) {
	gboolean result = FALSE;
	FrgMenuMsg* _tmp0_;
	guint32 _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = msg;
	_tmp1_ = (*_tmp0_).id;
	switch (_tmp1_) {
		case FOREIGN_MENU_SET_TITLE:
		{
			FrgMenuMsg* _tmp2_;
			FrgMenuSetTitle* t;
			FrgMenuSetTitle* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = msg;
			t = (FrgMenuSetTitle*) _tmp2_;
			_tmp3_ = t;
			_tmp4_ = (*_tmp3_).string;
			spice_ctrl_foreign_menu_set_title (self, _tmp4_);
			break;
		}
		case FOREIGN_MENU_ADD_ITEM:
		{
			FrgMenuMsg* _tmp5_;
			FrgMenuAddItem* i;
			FrgMenuAddItem* _tmp6_;
			guint32 _tmp7_;
			FrgMenuAddItem* _tmp8_;
			guint32 _tmp9_;
			FrgMenuAddItem* _tmp10_;
			guint32 _tmp11_;
			FrgMenuAddItem* _tmp12_;
			const gchar* _tmp13_;
			SpiceCtrlMenu* _tmp14_;
			FrgMenuAddItem* _tmp15_;
			guint32 _tmp16_;
			FrgMenuAddItem* _tmp17_;
			const gchar* _tmp18_;
			FrgMenuAddItem* _tmp19_;
			guint32 _tmp20_;
			unsigned int _tmp21_ = 0;
			SpiceCtrlMenuItem* _tmp22_;
			_tmp5_ = msg;
			i = (FrgMenuAddItem*) _tmp5_;
			_tmp6_ = i;
			_tmp7_ = (*_tmp6_).id;
			_tmp8_ = i;
			_tmp9_ = (*_tmp8_).type;
			_tmp10_ = i;
			_tmp11_ = (*_tmp10_).position;
			_tmp12_ = i;
			_tmp13_ = (*_tmp12_).string;
			g_debug ("foreign-menu.vala:108: add id:%u type:%u position:%u title:%s", (guint) _tmp7_, (guint) _tmp9_, (guint) _tmp11_, _tmp13_);
			_tmp14_ = self->priv->_menu;
			_tmp15_ = i;
			_tmp16_ = (*_tmp15_).id;
			_tmp17_ = i;
			_tmp18_ = (*_tmp17_).string;
			_tmp19_ = i;
			_tmp20_ = (*_tmp19_).type;
			_tmp21_ = spice_ctrl_foreign_menu_get_menu_flags (self, _tmp20_);
			_tmp22_ = spice_ctrl_menu_item_new ((gint) _tmp16_, _tmp18_, _tmp21_);
			_tmp14_->items = g_list_append (_tmp14_->items, _tmp22_);
			g_object_notify ((GObject*) self, "menu");
			break;
		}
		case FOREIGN_MENU_MODIFY_ITEM:
		{
			g_debug ("foreign-menu.vala:113: deprecated: modify item");
			break;
		}
		case FOREIGN_MENU_REMOVE_ITEM:
		{
			FrgMenuMsg* _tmp23_;
			FrgMenuRmItem* i;
			FrgMenuRmItem* _tmp24_;
			guint32 _tmp25_;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			_tmp23_ = msg;
			i = (FrgMenuRmItem*) _tmp23_;
			_tmp24_ = i;
			_tmp25_ = (*_tmp24_).id;
			_tmp26_ = g_strdup_printf ("not implemented: remove id:%u", (guint) _tmp25_);
			_tmp27_ = _tmp26_;
			g_debug ("foreign-menu.vala:117: %s", _tmp27_);
			_g_free0 (_tmp27_);
			break;
		}
		case FOREIGN_MENU_CLEAR:
		{
			SpiceCtrlMenu* _tmp28_;
			SpiceCtrlMenu* _tmp29_;
			_tmp28_ = spice_ctrl_menu_new ();
			_tmp29_ = _tmp28_;
			spice_ctrl_foreign_menu_set_menu (self, _tmp29_);
			_g_object_unref0 (_tmp29_);
			break;
		}
		default:
		{
			g_warn_if_reached ();
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static void spice_ctrl_foreign_menu_handle_client_data_free (gpointer _data) {
	SpiceCtrlForeignMenuHandleClientData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->c);
	_g_object_unref0 (_data_->self);
	g_slice_free (SpiceCtrlForeignMenuHandleClientData, _data_);
}


static void spice_ctrl_foreign_menu_handle_client (SpiceCtrlForeignMenu* self, GIOStream* c, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SpiceCtrlForeignMenuHandleClientData* _data_;
	SpiceCtrlForeignMenu* _tmp0_;
	GIOStream* _tmp1_;
	GIOStream* _tmp2_;
	_data_ = g_slice_new0 (SpiceCtrlForeignMenuHandleClientData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, spice_ctrl_foreign_menu_handle_client);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, spice_ctrl_foreign_menu_handle_client_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = c;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->c);
	_data_->c = _tmp2_;
	spice_ctrl_foreign_menu_handle_client_co (_data_);
}


static void spice_ctrl_foreign_menu_handle_client_finish (SpiceCtrlForeignMenu* self, GAsyncResult* _res_, GError** error) {
	SpiceCtrlForeignMenuHandleClientData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void spice_ctrl_foreign_menu_handle_client_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SpiceCtrlForeignMenuHandleClientData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	spice_ctrl_foreign_menu_handle_client_co (_data_);
}


static gboolean spice_ctrl_foreign_menu_handle_client_co (SpiceCtrlForeignMenuHandleClientData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("foreign-menu.vala:130: new socket client, reading init header");
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_new0 (guint8, sizeof (FrgMenuInitHeader));
	_data_->p = _data_->_tmp0_;
	_data_->p_length1 = sizeof (FrgMenuInitHeader);
	_data_->_p_size_ = _data_->p_length1;
	_data_->_tmp1_ = _data_->p;
	_data_->_tmp1__length1 = _data_->p_length1;
	_data_->header = (FrgMenuInitHeader*) _data_->_tmp1_;
	_data_->_tmp2_ = _data_->c;
	_data_->_tmp3_ = g_io_stream_get_input_stream (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->p;
	_data_->_tmp5__length1 = _data_->p_length1;
	_data_->_state_ = 1;
	spice_ctrl_input_stream_read (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp5__length1, spice_ctrl_foreign_menu_handle_client_ready, _data_);
	return FALSE;
	_state_1:
	spice_ctrl_input_stream_read_finish (_data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->p = (g_free (_data_->p), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->header;
	_data_->_tmp7_ = (*_data_->_tmp6_).magic;
	_data_->_tmp8_ = FALSE;
	_data_->_tmp8_ = g_warn_if (_data_->_tmp7_ != FOREIGN_MENU_MAGIC);
	if (_data_->_tmp8_) {
		_data_->p = (g_free (_data_->p), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->header;
	_data_->_tmp10_ = (*_data_->_tmp9_).version;
	_data_->_tmp11_ = FALSE;
	_data_->_tmp11_ = g_warn_if (_data_->_tmp10_ != ((guint32) FOREIGN_MENU_VERSION));
	if (_data_->_tmp11_) {
		_data_->p = (g_free (_data_->p), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->header;
	_data_->_tmp13_ = (*_data_->_tmp12_).size;
	_data_->_tmp14_ = FALSE;
	_data_->_tmp14_ = g_warn_if (((gulong) _data_->_tmp13_) < sizeof (FrgMenuInit));
	if (_data_->_tmp14_) {
		_data_->p = (g_free (_data_->p), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = g_new0 (guint8, sizeof (guint64));
	_data_->cp = _data_->_tmp15_;
	_data_->cp_length1 = sizeof (guint64);
	_data_->_cp_size_ = _data_->cp_length1;
	_data_->_tmp16_ = _data_->c;
	_data_->_tmp17_ = g_io_stream_get_input_stream (_data_->_tmp16_);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = _data_->cp;
	_data_->_tmp19__length1 = _data_->cp_length1;
	_data_->_state_ = 2;
	spice_ctrl_input_stream_read (_data_->_tmp18_, _data_->_tmp19_, _data_->_tmp19__length1, spice_ctrl_foreign_menu_handle_client_ready, _data_);
	return FALSE;
	_state_2:
	spice_ctrl_input_stream_read_finish (_data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->cp = (g_free (_data_->cp), NULL);
		_data_->p = (g_free (_data_->p), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = _data_->cp;
	_data_->_tmp20__length1 = _data_->cp_length1;
	_data_->credentials = *((guint64*) _data_->_tmp20_);
	_data_->_tmp21_ = _data_->credentials;
	_data_->_tmp22_ = FALSE;
	_data_->_tmp22_ = g_warn_if (_data_->_tmp21_ != ((guint64) 0));
	if (_data_->_tmp22_) {
		_data_->cp = (g_free (_data_->cp), NULL);
		_data_->p = (g_free (_data_->p), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp23_ = _data_->header;
	_data_->_tmp24_ = (*_data_->_tmp23_).size;
	_data_->title_size = _data_->_tmp24_ - sizeof (FrgMenuInit);
	_data_->_tmp25_ = _data_->title_size;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = g_new0 (guint8, _data_->_tmp25_ + 1);
	_data_->title = _data_->_tmp26_;
	_data_->title_length1 = _data_->_tmp25_ + 1;
	_data_->_title_size_ = _data_->title_length1;
	_data_->_tmp27_ = _data_->c;
	_data_->_tmp28_ = g_io_stream_get_input_stream (_data_->_tmp27_);
	_data_->_tmp29_ = _data_->_tmp28_;
	_data_->_tmp30_ = _data_->title;
	_data_->_tmp30__length1 = _data_->title_length1;
	_data_->_tmp31_ = _data_->title_size;
	_data_->_state_ = 3;
	g_input_stream_read_async (_data_->_tmp29_, (void*) (_data_->_tmp30_ + 0), (gsize) (_data_->_tmp31_ - 0), G_PRIORITY_DEFAULT, NULL, spice_ctrl_foreign_menu_handle_client_ready, _data_);
	return FALSE;
	_state_3:
	g_input_stream_read_finish (_data_->_tmp29_, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->title = (g_free (_data_->title), NULL);
		_data_->cp = (g_free (_data_->cp), NULL);
		_data_->p = (g_free (_data_->p), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp32_ = _data_->title;
	_data_->_tmp32__length1 = _data_->title_length1;
	spice_ctrl_foreign_menu_set_title (_data_->self, (const gchar*) _data_->_tmp32_);
	g_signal_emit_by_name (_data_->self, "client-connected");
	{
		_data_->_tmp33_ = TRUE;
		while (TRUE) {
			_data_->_tmp34_ = _data_->_tmp33_;
			if (!_data_->_tmp34_) {
			}
			_data_->_tmp33_ = FALSE;
			_data_->_tmp35_ = NULL;
			_data_->_tmp35_ = g_new0 (guint8, sizeof (FrgMenuMsg));
			_data_->t = _data_->_tmp35_;
			_data_->t_length1 = sizeof (FrgMenuMsg);
			_data_->_t_size_ = _data_->t_length1;
			_data_->_tmp36_ = _data_->c;
			_data_->_tmp37_ = g_io_stream_get_input_stream (_data_->_tmp36_);
			_data_->_tmp38_ = _data_->_tmp37_;
			_data_->_tmp39_ = _data_->t;
			_data_->_tmp39__length1 = _data_->t_length1;
			_data_->_state_ = 4;
			spice_ctrl_input_stream_read (_data_->_tmp38_, _data_->_tmp39_, _data_->_tmp39__length1, spice_ctrl_foreign_menu_handle_client_ready, _data_);
			return FALSE;
			_state_4:
			spice_ctrl_input_stream_read_finish (_data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_data_->t = (g_free (_data_->t), NULL);
				_data_->title = (g_free (_data_->title), NULL);
				_data_->cp = (g_free (_data_->cp), NULL);
				_data_->p = (g_free (_data_->p), NULL);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp40_ = _data_->t;
			_data_->_tmp40__length1 = _data_->t_length1;
			_data_->msg = (FrgMenuMsg*) _data_->_tmp40_;
			_data_->_tmp41_ = _data_->msg;
			_data_->_tmp42_ = (*_data_->_tmp41_).id;
			_data_->_tmp43_ = NULL;
			_data_->_tmp43_ = g_strdup_printf ("%u", _data_->_tmp42_);
			_data_->_tmp44_ = _data_->_tmp43_;
			_data_->_tmp45_ = g_strconcat ("new message ", _data_->_tmp44_, NULL);
			_data_->_tmp46_ = _data_->_tmp45_;
			_data_->_tmp47_ = g_strconcat (_data_->_tmp46_, "size ", NULL);
			_data_->_tmp48_ = _data_->_tmp47_;
			_data_->_tmp49_ = _data_->msg;
			_data_->_tmp50_ = (*_data_->_tmp49_).size;
			_data_->_tmp51_ = NULL;
			_data_->_tmp51_ = g_strdup_printf ("%u", _data_->_tmp50_);
			_data_->_tmp52_ = _data_->_tmp51_;
			_data_->_tmp53_ = g_strconcat (_data_->_tmp48_, _data_->_tmp52_, NULL);
			_data_->_tmp54_ = _data_->_tmp53_;
			g_debug ("foreign-menu.vala:159: %s", _data_->_tmp54_);
			_g_free0 (_data_->_tmp54_);
			_g_free0 (_data_->_tmp52_);
			_g_free0 (_data_->_tmp48_);
			_g_free0 (_data_->_tmp46_);
			_g_free0 (_data_->_tmp44_);
			_data_->_tmp55_ = _data_->msg;
			_data_->_tmp56_ = (*_data_->_tmp55_).size;
			_data_->_tmp57_ = FALSE;
			_data_->_tmp57_ = g_warn_if (((gulong) _data_->_tmp56_) < sizeof (FrgMenuMsg));
			if (_data_->_tmp57_) {
				_data_->t = (g_free (_data_->t), NULL);
				break;
			}
			_data_->_tmp58_ = _data_->msg;
			_data_->_tmp59_ = (*_data_->_tmp58_).size;
			if (((gulong) _data_->_tmp59_) > sizeof (FrgMenuMsg)) {
				_data_->_tmp60_ = _data_->msg;
				_data_->_tmp61_ = (*_data_->_tmp60_).size;
				_data_->_tmp62_ = 0;
				_data_->_tmp62_ = (gint) _data_->_tmp61_;
				_data_->t = g_renew (guint8, _data_->t, (gint) _data_->_tmp61_);
				(_data_->_tmp62_ > _data_->t_length1) ? memset (_data_->t + _data_->t_length1, 0, sizeof (guint8) * (_data_->_tmp62_ - _data_->t_length1)) : NULL;
				_data_->t_length1 = _data_->_tmp62_;
				_data_->_t_size_ = _data_->_tmp62_;
				_data_->_tmp63_ = _data_->t;
				_data_->_tmp63__length1 = _data_->t_length1;
				_data_->msg = (FrgMenuMsg*) _data_->_tmp63_;
				_data_->_tmp64_ = _data_->c;
				_data_->_tmp65_ = g_io_stream_get_input_stream (_data_->_tmp64_);
				_data_->_tmp66_ = _data_->_tmp65_;
				_data_->_tmp67_ = _data_->t;
				_data_->_tmp67__length1 = _data_->t_length1;
				_data_->_tmp68_ = _data_->msg;
				_data_->_tmp69_ = (*_data_->_tmp68_).size;
				_data_->_state_ = 5;
				spice_ctrl_input_stream_read (_data_->_tmp66_, _data_->_tmp67_ + sizeof (FrgMenuMsg), _data_->_tmp69_ - sizeof (FrgMenuMsg), spice_ctrl_foreign_menu_handle_client_ready, _data_);
				return FALSE;
				_state_5:
				spice_ctrl_input_stream_read_finish (_data_->_res_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					_data_->t = (g_free (_data_->t), NULL);
					_data_->title = (g_free (_data_->title), NULL);
					_data_->cp = (g_free (_data_->cp), NULL);
					_data_->p = (g_free (_data_->p), NULL);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_data_->_tmp70_ = _data_->msg;
			spice_ctrl_foreign_menu_handle_message (_data_->self, _data_->_tmp70_);
			_data_->t = (g_free (_data_->t), NULL);
		}
	}
	_data_->title = (g_free (_data_->title), NULL);
	_data_->cp = (g_free (_data_->cp), NULL);
	_data_->p = (g_free (_data_->p), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void spice_ctrl_foreign_menu_listen_data_free (gpointer _data) {
	SpiceCtrlForeignMenuListenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->addr);
	_g_object_unref0 (_data_->self);
	g_slice_free (SpiceCtrlForeignMenuListenData, _data_);
}


void spice_ctrl_foreign_menu_listen (SpiceCtrlForeignMenu* self, const gchar* addr, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SpiceCtrlForeignMenuListenData* _data_;
	SpiceCtrlForeignMenu* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (SpiceCtrlForeignMenuListenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, spice_ctrl_foreign_menu_listen);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, spice_ctrl_foreign_menu_listen_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = addr;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->addr);
	_data_->addr = _tmp2_;
	spice_ctrl_foreign_menu_listen_co (_data_);
}


void spice_ctrl_foreign_menu_listen_finish (SpiceCtrlForeignMenu* self, GAsyncResult* _res_, GError** error) {
	SpiceCtrlForeignMenuListenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void spice_ctrl_foreign_menu_listen_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SpiceCtrlForeignMenuListenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	spice_ctrl_foreign_menu_listen_co (_data_);
}


static gboolean spice_ctrl_foreign_menu_listen_co (SpiceCtrlForeignMenuListenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->addr;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = spice_foreign_menu_listener_new (_data_->_tmp0_, &_data_->_inner_error_);
	_data_->listener = _data_->_tmp1_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp2_ = TRUE;
		while (TRUE) {
			_data_->_tmp3_ = _data_->_tmp2_;
			if (!_data_->_tmp3_) {
			}
			_data_->_tmp2_ = FALSE;
			_data_->_tmp4_ = _data_->listener;
			_data_->_state_ = 1;
			spice_foreign_menu_listener_accept_async (_data_->_tmp4_, NULL, spice_ctrl_foreign_menu_listen_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = spice_foreign_menu_listener_accept_finish (_data_->_tmp4_, _data_->_res_, NULL, &_data_->_inner_error_);
			_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
			_data_->c = _data_->_tmp6_;
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->listener);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp7_ = _data_->self->priv->nclients;
			_data_->self->priv->nclients = _data_->_tmp7_ + 1;
			_data_->_tmp8_ = _data_->c;
			_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
			_data_->self->priv->clients = g_list_append (_data_->self->priv->clients, _data_->_tmp9_);
			{
				_data_->_tmp10_ = _data_->c;
				_data_->_state_ = 2;
				spice_ctrl_foreign_menu_handle_client (_data_->self, _data_->_tmp10_, spice_ctrl_foreign_menu_listen_ready, _data_);
				return FALSE;
				_state_2:
				spice_ctrl_foreign_menu_handle_client_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					goto __catch4_g_error;
				}
			}
			goto __finally4;
			__catch4_g_error:
			{
				_data_->e = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp11_ = _data_->e;
				_data_->_tmp12_ = _data_->_tmp11_->message;
				g_warning ("foreign-menu.vala:187: %s", _data_->_tmp12_);
				_g_error_free0 (_data_->e);
			}
			__finally4:
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->c);
				_g_object_unref0 (_data_->listener);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp13_ = _data_->c;
			g_io_stream_close (_data_->_tmp13_, NULL, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->c);
				_g_object_unref0 (_data_->listener);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp14_ = _data_->c;
			_data_->self->priv->clients = g_list_remove (_data_->self->priv->clients, _data_->_tmp14_);
			_data_->_tmp15_ = _data_->self->priv->nclients;
			_data_->self->priv->nclients = _data_->_tmp15_ - 1;
			_g_object_unref0 (_data_->c);
		}
	}
	_g_object_unref0 (_data_->listener);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


SpiceCtrlMenu* spice_ctrl_foreign_menu_get_menu (SpiceCtrlForeignMenu* self) {
	SpiceCtrlMenu* result;
	SpiceCtrlMenu* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_menu;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_foreign_menu_set_menu (SpiceCtrlForeignMenu* self, SpiceCtrlMenu* value) {
	SpiceCtrlMenu* _tmp0_;
	SpiceCtrlMenu* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_menu);
	self->priv->_menu = _tmp1_;
	g_object_notify ((GObject *) self, "menu");
}


const gchar* spice_ctrl_foreign_menu_get_title (SpiceCtrlForeignMenu* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_foreign_menu_set_title (SpiceCtrlForeignMenu* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	g_object_notify ((GObject *) self, "title");
}


static void spice_ctrl_foreign_menu_class_init (SpiceCtrlForeignMenuClass * klass) {
	spice_ctrl_foreign_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SpiceCtrlForeignMenuPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_ctrl_foreign_menu_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_ctrl_foreign_menu_set_property;
	G_OBJECT_CLASS (klass)->finalize = spice_ctrl_foreign_menu_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_FOREIGN_MENU_MENU, g_param_spec_object ("menu", "menu", "menu", SPICE_CTRL_TYPE_MENU, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_FOREIGN_MENU_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("client_connected", SPICE_CTRL_TYPE_FOREIGN_MENU, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void spice_ctrl_foreign_menu_instance_init (SpiceCtrlForeignMenu * self) {
	self->priv = SPICE_CTRL_FOREIGN_MENU_GET_PRIVATE (self);
}


static void spice_ctrl_foreign_menu_finalize (GObject* obj) {
	SpiceCtrlForeignMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_CTRL_TYPE_FOREIGN_MENU, SpiceCtrlForeignMenu);
	_g_object_unref0 (self->priv->_menu);
	_g_free0 (self->priv->_title);
	__g_list_free__g_object_unref0_0 (self->priv->clients);
	G_OBJECT_CLASS (spice_ctrl_foreign_menu_parent_class)->finalize (obj);
}


GType spice_ctrl_foreign_menu_get_type (void) {
	static volatile gsize spice_ctrl_foreign_menu_type_id__volatile = 0;
	if (g_once_init_enter (&spice_ctrl_foreign_menu_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpiceCtrlForeignMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_ctrl_foreign_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceCtrlForeignMenu), 0, (GInstanceInitFunc) spice_ctrl_foreign_menu_instance_init, NULL };
		GType spice_ctrl_foreign_menu_type_id;
		spice_ctrl_foreign_menu_type_id = g_type_register_static (G_TYPE_OBJECT, "SpiceCtrlForeignMenu", &g_define_type_info, 0);
		g_once_init_leave (&spice_ctrl_foreign_menu_type_id__volatile, spice_ctrl_foreign_menu_type_id);
	}
	return spice_ctrl_foreign_menu_type_id__volatile;
}


static void _vala_spice_ctrl_foreign_menu_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SpiceCtrlForeignMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_CTRL_TYPE_FOREIGN_MENU, SpiceCtrlForeignMenu);
	switch (property_id) {
		case SPICE_CTRL_FOREIGN_MENU_MENU:
		g_value_set_object (value, spice_ctrl_foreign_menu_get_menu (self));
		break;
		case SPICE_CTRL_FOREIGN_MENU_TITLE:
		g_value_set_string (value, spice_ctrl_foreign_menu_get_title (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_spice_ctrl_foreign_menu_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SpiceCtrlForeignMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_CTRL_TYPE_FOREIGN_MENU, SpiceCtrlForeignMenu);
	switch (property_id) {
		case SPICE_CTRL_FOREIGN_MENU_MENU:
		spice_ctrl_foreign_menu_set_menu (self, g_value_get_object (value));
		break;
		case SPICE_CTRL_FOREIGN_MENU_TITLE:
		spice_ctrl_foreign_menu_set_title (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



