/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
**
** This version of "lempar.c" is modified, slightly, for use by SQLite.
** The only modifications are the addition of a couple of NEVER()
** macros to disable tests that are needed in the case of a general
** LALR(1) grammar but which are always false in the
** specific grammar used by SQLite.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>

#include "token.h"
#include "parsercontext.h"
#include "parser_helper_stubs.h"
#include "common/utils_sql.h"
#include "parser/ast/sqlitealtertable.h"
#include "parser/ast/sqliteanalyze.h"
#include "parser/ast/sqliteattach.h"
#include "parser/ast/sqlitebegintrans.h"
#include "parser/ast/sqlitecommittrans.h"
#include "parser/ast/sqlitecopy.h"
#include "parser/ast/sqlitecreateindex.h"
#include "parser/ast/sqlitecreatetable.h"
#include "parser/ast/sqlitecreatetrigger.h"
#include "parser/ast/sqlitecreateview.h"
#include "parser/ast/sqlitecreatevirtualtable.h"
#include "parser/ast/sqlitedelete.h"
#include "parser/ast/sqlitedetach.h"
#include "parser/ast/sqlitedropindex.h"
#include "parser/ast/sqlitedroptable.h"
#include "parser/ast/sqlitedroptrigger.h"
#include "parser/ast/sqlitedropview.h"
#include "parser/ast/sqliteemptyquery.h"
#include "parser/ast/sqliteinsert.h"
#include "parser/ast/sqlitepragma.h"
#include "parser/ast/sqlitereindex.h"
#include "parser/ast/sqliterelease.h"
#include "parser/ast/sqliterollback.h"
#include "parser/ast/sqlitesavepoint.h"
#include "parser/ast/sqliteselect.h"
#include "parser/ast/sqliteupdate.h"
#include "parser/ast/sqlitevacuum.h"
#include "parser/ast/sqliteexpr.h"
#include "parser/ast/sqlitecolumntype.h"
#include "parser/ast/sqliteconflictalgo.h"
#include "parser/ast/sqlitesortorder.h"
#include "parser/ast/sqliteindexedcolumn.h"
#include "parser/ast/sqliteforeignkey.h"
#include "parser/ast/sqlitewith.h"
#include "parser/ast/sqliteupsert.h"
#include <QObject>
#include <QDebug>
#include <limits.h>

#define assert(X) Q_ASSERT(X)
#define UNUSED_PARAMETER(X) (void)(X)
#define DONT_INHERIT_TOKENS(X) noTokenInheritanceFields << X
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/*
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands.
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3_parseTOKENTYPE     is the data type used for minor tokens given
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3_parseTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3_parseARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3_parseARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3_parseARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3_parseARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned short int
#define YYNOCODE 281
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 61
#define sqlite3_parseTOKENTYPE Token*
typedef union {
  int yyinit;
  sqlite3_parseTOKENTYPE yy0;
  SqliteCreateTrigger::Scope* yy3;
  ParserCreateTableColumnConstraintList* yy51;
  QStringList* yy95;
  SqliteForeignKey::Condition::Reaction* yy104;
  ParserStubInsertOrReplace* yy105;
  SqliteIndexedColumn* yy108;
  ParserOtherSourceList* yy131;
  SqliteCreateTrigger::Time* yy132;
  int* yy146;
  ParserOrderByList* yy163;
  ParserExprNestedList* yy166;
  ParserFkConditionList* yy184;
  ParserIndexedBy* yy192;
  ParserStubAlias* yy200;
  SqliteSelect::Core::SingleSource* yy201;
  ParserCreateTableColumnList* yy202;
  ParserIndexedColumnList* yy223;
  SqliteCreateTable::Column* yy227;
  SqliteQuery* yy283;
  SqliteSelect::Core::JoinConstraint* yy295;
  SqliteSelect::Core::JoinOp* yy301;
  SqliteCreateTable::Column::Constraint* yy304;
  SqliteSortOrder* yy309;
  SqliteSelect::Core* yy310;
  SqliteWith* yy321;
  ParserDeferSubClause* yy329;
  ParserCreateTableConstraintList* yy333;
  SqliteConflictAlgo* yy338;
  SqliteForeignKey::Condition* yy347;
  SqliteExpr* yy352;
  ParserFullName* yy360;
  ParserResultColumnList* yy373;
  SqliteInitially* yy392;
  QString* yy399;
  ParserStubTransDetails* yy404;
  SqliteCreateTable::Constraint* yy406;
  ParserStubExplain* yy411;
  ParserQueryList* yy430;
  bool* yy451;
  SqliteSelect::CompoundOperator* yy462;
  QVariant* yy469;
  SqliteSelect* yy473;
  SqliteLimit* yy484;
  SqliteSelect::Core::JoinSource* yy511;
  SqliteExpr::LikeOp* yy520;
  ParserSetValueList* yy521;
  SqliteColumnType* yy537;
  ParserExprList* yy551;
  SqliteCreateTrigger::Event* yy552;
  SqliteUpsert* yy560;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3_parseARG_SDECL ParserContext* parserContext;
#define sqlite3_parseARG_PDECL ,ParserContext* parserContext
#define sqlite3_parseARG_FETCH ParserContext* parserContext = yypParser->parserContext
#define sqlite3_parseARG_STORE yypParser->parserContext = parserContext
#define YYNSTATE 754
#define YYNRULE 431
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

#define GET_CONTEXT yyParser* yypParser = pParser; sqlite3_parseARG_FETCH

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (2384)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   457,   54,   54,   53,   53,   53,   52,  225,  277,  746,
 /*    10 */   280,  445,   57,   57,   57,   57,   32,   55,   55,   55,
 /*    20 */    55,   54,   54,   53,   53,   53,   52,  225,  658, 1062,
 /*    30 */  1062,   63,  746,  165,   57,   57,   57,   57,  450,   55,
 /*    40 */    55,   55,   55,   54,   54,   53,   53,   53,   52,  225,
 /*    50 */   697,   87,  312,  644,  746,  701,  143,   71, 1062, 1062,
 /*    60 */    45, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062,
 /*    70 */  1062, 1062,  652, 1062, 1062, 1062, 1062,   42,   43, 1062,
 /*    80 */  1062, 1062, 1062, 1062,   44,  457,   53,   53,   53,   52,
 /*    90 */   225,  746,    3,  643,  639,  717,  445,  707,  751,  442,
 /*   100 */   720,    1,  717,  455,  293,  454,  623,  720,  719,  718,
 /*   110 */   717,  744,  743,  411,  707,  719,  718,  717,  456,  746,
 /*   120 */   454,  683,  292,  450,   15,  485,  702,  196,   96,  645,
 /*   130 */  1179, 1179,  665,  456,  744,  743,  378,  454,  745,  149,
 /*   140 */   701,  702,  196,  486,  487,   45,  646,   98,  707,  537,
 /*   150 */   456,  473,   10,  707,  658,  698,  744,  743,  702,  196,
 /*   160 */   350,  645,   42,   43,  637,  543,  298,  474,  473,   44,
 /*   170 */   914,  721,  931,  931,  722,  424,  407,    3,  914,  745,
 /*   180 */   329,   87,  707,  746,  442,  914,  138,  717,  455,  401,
 /*   190 */   398,  397,  720,  744,  743,  329,  473,  457,  638,  707,
 /*   200 */   719,  718,  717,  724,  914,  454,  139,  396,  445,  488,
 /*   210 */   690,   92,  410,  349,  307, 1116,  219,  914,  456,  914,
 /*   220 */   914,  744,  743,  914,  746,  241,  702,   99,  914,  914,
 /*   230 */   914,  914,  914,  707,   19,  450,  222,   10,  707,  314,
 /*   240 */   698,   55,   55,   55,   55,   54,   54,   53,   53,   53,
 /*   250 */    52,  225,  701,  427,  746,  454,  746,   45,  152,  102,
 /*   260 */   294,  404,  289,  403,  140,  310,  436,  550,  456,  215,
 /*   270 */   214,  213,  431,  296,   42,   43,  702,  196,  287,  746,
 /*   280 */   671,   44,  977,  746,  580,  744,  743,  426,  138,    3,
 /*   290 */   977,  401,  398,  397,  707,  333,  442,  977,  509,  717,
 /*   300 */   455,  593,  594,  557,  720,  413,  668,  631,  630,  396,
 /*   310 */   351,  707,  719,  718,  717,  521,  977,  457,  509,  365,
 /*   320 */   508,  508,  526,  527,  371,  713,  744,  743,  445,  977,
 /*   330 */   329,  977,  977,  319,  511,  636,  532,   65,  613,  226,
 /*   340 */   977,  977,  977,  977,   64,  707,   15,  977,  703,   10,
 /*   350 */   707,  645,  698,  319,  510,  450,  744,  743,  744,  743,
 /*   360 */   209,  208,  524,  533,  535,  746,  525,  534,  646,  703,
 /*   370 */   714,  609,  701,   52,  225,   61,  470,   45,  516,  620,
 /*   380 */   620,  744,  743,  645,  454,  717,  375,  369,  608,  633,
 /*   390 */   720,  703,  408,  470,   42,   43,   38,  456,  719,  718,
 /*   400 */   717,   44,  962,  746,  714,  702,  196,  358,  605,    3,
 /*   410 */   962,  512,   60,  116,  707,  713,  442,  962,  604,  717,
 /*   420 */   455,  470,  538,  801,  720,  742,   98,  713, 1082,  686,
 /*   430 */   740,  707,  719,  718,  717,  741,  962,  485,  328,  424,
 /*   440 */   409,  687,  582,  224, 1064, 1064,  320, 1171,  297,  962,
 /*   450 */   745,  962,  962,  300, 1171,  486,  360,   91,   12,  329,
 /*   460 */   962,  745,  962,  962,  628,  707,  745,  744,  743,   10,
 /*   470 */   707,   38,  698,   58,   59,  452,  308, 1064, 1064,  710,
 /*   480 */   710,   56,   56,   57,   57,   57,   57,  219,   55,   55,
 /*   490 */    55,   55,   54,   54,   53,   53,   53,   52,  225,  563,
 /*   500 */   563,  265,  387,  271,  478,  744,  743,  667,  324,  148,
 /*   510 */   581,  242,  414,  549,  803,  311,  377,  713,  245,  567,
 /*   520 */    73,  361,  690,  745, 1064, 1064,   58,   59,  452,  308,
 /*   530 */   119,   47,  710,  710,   56,   56,   57,   57,   57,   57,
 /*   540 */   406,   55,   55,   55,   55,   54,   54,   53,   53,   53,
 /*   550 */    52,  225,  657,   58,   59,  452,  308, 1064, 1064,  710,
 /*   560 */   710,   56,   56,   57,   57,   57,   57,  334,   55,   55,
 /*   570 */    55,   55,   54,   54,   53,   53,   53,   52,  225,  681,
 /*   580 */   687,  443,  224,  581, 1186,  162,  461,    2,  240,  239,
 /*   590 */   680,  285,  466,   73,  721,   41,  745,  722,   96,   58,
 /*   600 */    59,  452,  308, 1064, 1064,  710,  710,   56,   56,   57,
 /*   610 */    57,   57,   57,   96,   55,   55,   55,   55,   54,   54,
 /*   620 */    53,   53,   53,   52,  225,   49,  692,  691,  151, 1063,
 /*   630 */  1063,  602,   58,   59,  452,  308, 1064, 1064,  710,  710,
 /*   640 */    56,   56,   57,   57,   57,   57,  368,   55,   55,   55,
 /*   650 */    55,   54,   54,   53,   53,   53,   52,  225, 1063, 1063,
 /*   660 */  1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063,
 /*   670 */  1063, 1063,  746, 1063, 1063, 1063, 1063, 1063, 1063, 1063,
 /*   680 */  1063, 1063, 1063, 1063, 1064, 1064,  452,  308,  692,  691,
 /*   690 */   710,  710,   56,   56,   57,   57,   57,   57,   34,   55,
 /*   700 */    55,   55,   55,   54,   54,   53,   53,   53,   52,  225,
 /*   710 */   713,   95,  709,   58,   59,  452,  308, 1064, 1064,  710,
 /*   720 */   710,   56,   56,   57,   57,   57,   57,  708,   55,   55,
 /*   730 */    55,   55,   54,   54,   53,   53,   53,   52,  225,   58,
 /*   740 */    59,  452,  308,  746,  218,  710,  710,   56,   56,   57,
 /*   750 */    57,   57,   57,  150,   55,   55,   55,   55,   54,   54,
 /*   760 */    53,   53,   53,   52,  225,  658,  984,  253,  672,  257,
 /*   770 */   512,   50,  706,   36,  744,  743,   58,   59,  452,  308,
 /*   780 */   746,  984,  710,  710,   56,   56,   57,   57,   57,   57,
 /*   790 */   161,   55,   55,   55,   55,   54,   54,   53,   53,   53,
 /*   800 */    52,  225,    6,  985,  148,  320, 1170,  217,  629,  648,
 /*   810 */   412,  259,  713, 1170,   58,   59,  452,  308,  985,   17,
 /*   820 */   710,  710,   56,   56,   57,   57,   57,   57,  984,   55,
 /*   830 */    55,   55,   55,   54,   54,   53,   53,   53,   52,  225,
 /*   840 */   498,  986,  299,  394,   16,  744,  743,  657, 1131,  438,
 /*   850 */    96,   58,   59,  452,  308,  745,  986,  710,  710,   56,
 /*   860 */    56,   57,   57,   57,   57,  985,   55,   55,   55,   55,
 /*   870 */    54,   54,   53,   53,   53,   52,  225,  554,  987,  255,
 /*   880 */   337,  211,  744,  743,  383,  498,  658,  354,  695,  694,
 /*   890 */   444,  695,  694,  987,  554,  746,  705,  745,   58,   59,
 /*   900 */   452,  308,   24,  986,  710,  710,   56,   56,   57,   57,
 /*   910 */    57,   57,  112,   55,   55,   55,   55,   54,   54,   53,
 /*   920 */    53,   53,   52,  225,  682, 1131,   58,   59,  452,  308,
 /*   930 */   647,  746,  710,  710,   56,   56,   57,   57,   57,   57,
 /*   940 */   987,   55,   55,   55,   55,   54,   54,   53,   53,   53,
 /*   950 */    52,  225,  457, 1145,  229,  690,  704,  441,  690,   20,
 /*   960 */   571,  598,   46,  445,   58,   59,  452,  308,  572,  139,
 /*   970 */   710,  710,   56,   56,   57,   57,   57,   57,  746,   55,
 /*   980 */    55,   55,   55,   54,   54,   53,   53,   53,   52,  225,
 /*   990 */   450,   98,  746,   37,  713,  696,  580,  744,  743,  393,
 /*  1000 */    97,  454,  298,   87,  454,  685,  662,  701,  240,  239,
 /*  1010 */   754,  581,   45,  428,  456,  745,  168,  456,  454,  745,
 /*  1020 */   727,   73,  702,  196,  745,  702,   99,  557,  281,   42,
 /*  1030 */    43,  456,  355,  744,  743,  357,   44,  482,  684,  702,
 /*  1040 */   196,  745,  703,  233,    3,  568,  692,  691,  746,  707,
 /*  1050 */   484,  442,  483,  167,  717,  455,  424,  425,  333,  720,
 /*  1060 */   532,   65,   87,  703,  287,  446,  707,  719,  718,  717,
 /*  1070 */   384,  340,  352,  424,  415,  517,  329,  149,  674,  671,
 /*  1080 */   744,  743, 1179, 1179,  297,  703,   72,  533,  535,  746,
 /*  1090 */   383,  534,  423,  329,  744,  743,  713,  745,  363,  752,
 /*  1100 */   707,  382,  440,  745,   10,  707,  714,  698,  149,    8,
 /*  1110 */   374,  745,   58,   59,  452,  308,  434,  376,  710,  710,
 /*  1120 */    56,   56,   57,   57,   57,   57,   98,   55,   55,   55,
 /*  1130 */    55,   54,   54,   53,   53,   53,   52,  225,  517,  166,
 /*  1140 */   714,  662,  681,  422,  324,  278,  454,  617,  273,  279,
 /*  1150 */   744,  743,  231,  680,  745,  437,  746,  673,  745,  456,
 /*  1160 */   228,  745,  651,   58,   59,  452,  308,  702,  204,  710,
 /*  1170 */   710,   56,   56,   57,   57,   57,   57,  650,   55,   55,
 /*  1180 */    55,   55,   54,   54,   53,   53,   53,   52,  225,   98,
 /*  1190 */   546,  744,  743,   58,   59,  452,  308,  149,  600,  710,
 /*  1200 */   710,   56,   56,   57,   57,   57,   57,  344,   55,   55,
 /*  1210 */    55,   55,   54,   54,   53,   53,   53,   52,  225,   14,
 /*  1220 */   746,  671,  433,  566,   40,  726,  659,  266,  284,   58,
 /*  1230 */    59,  452,  308,  586,   40,  710,  710,   56,   56,   57,
 /*  1240 */    57,   57,   57,  747,   55,   55,   55,   55,   54,   54,
 /*  1250 */    53,   53,   53,   52,  225,    9,   98,   98,  744,  743,
 /*  1260 */    38,   58,   59,  452,  308,   25,   94,  710,  710,   56,
 /*  1270 */    56,   57,   57,   57,   57,  653,   55,   55,   55,   55,
 /*  1280 */    54,   54,   53,   53,   53,   52,  225,  561, 1146,  262,
 /*  1290 */   713,   58,   59,  452,  308,  267,   40,  710,  710,   56,
 /*  1300 */    56,   57,   57,   57,   57,  147,   55,   55,   55,   55,
 /*  1310 */    54,   54,   53,   53,   53,   52,  225,  522, 1144,  746,
 /*  1320 */   614,   98,  744,  743,   58,   59,  452,  308,  723,   98,
 /*  1330 */   710,  710,   56,   56,   57,   57,   57,   57,  146,   55,
 /*  1340 */    55,   55,   55,   54,   54,   53,   53,   53,   52,  225,
 /*  1350 */   670,   58,   62,  452,  308,  357,  746,  710,  710,   56,
 /*  1360 */    56,   57,   57,   57,   57,  454,   55,   55,   55,   55,
 /*  1370 */    54,   54,   53,   53,   53,   52,  225,  457,  456,  611,
 /*  1380 */   746,  610,  522,  106,  148,  746,  702,  196,  445,   59,
 /*  1390 */   452,  308,  713,  746,  710,  710,   56,   56,   57,   57,
 /*  1400 */    57,   57,  219,   55,   55,   55,   55,   54,   54,   53,
 /*  1410 */    53,   53,   52,  225,  592,  450,  559,  514,  297,  752,
 /*  1420 */   429,  744,  743,  750,  321,  490,  145,  657,  460,  299,
 /*  1430 */   454,  745,  701,  144,  859,  402,  635,   45,  745,  557,
 /*  1440 */   329,  569,  745,  456,   87,  640,  591,  559,  746,  753,
 /*  1450 */     2,  702,   99,  479,   42,   43,  669,  418,  744,  743,
 /*  1460 */   457,   44,  748,  746,  353,  416,  746,  735,  746,    3,
 /*  1470 */   599,  445,  494,   65,  707,  745,  442,  746,  237,  717,
 /*  1480 */   455,  746,  744,  743,  720,   15,  924,  744,  743,    5,
 /*  1490 */   645,  707,  719,  718,  717,  744,  743,  338,  450,  493,
 /*  1500 */   492,  736,  746,  491,  746,  671,  299,  646,  219,  217,
 /*  1510 */   629,  675,  412,  634,  745,  701,  553,  479,  610,  745,
 /*  1520 */    45,   13,  645, 1179, 1179,  707,  463,  746,  347,   10,
 /*  1530 */   707,  746,  698,  716,  454,  746,  662,   42,   43,  381,
 /*  1540 */   632,  232,  627,  457,   44,  495, 1071,  456,  662,  745,
 /*  1550 */   744,  743,    3,  283,  445,  702,  191,  707,  625,  442,
 /*  1560 */   501,  745,  717,  455,  728,  744,  743,  720,  744,  743,
 /*  1570 */   744,  743,  115,  662,  707,  719,  718,  717,  624,  744,
 /*  1580 */   743,  450,  619,  744,  743,  746,  745,  734,  675,  235,
 /*  1590 */   746,  476,  501,  618,  286,  472,  590,  732,  701,  548,
 /*  1600 */   745,  540,  343,   45,  744,  743,  744,  743,  707,  671,
 /*  1610 */   745,  495,   10,  707,  342,  698,  548,   22,  540,  476,
 /*  1620 */    42,   43,  448,  472,  505,  457,  658,   44,   69,  744,
 /*  1630 */   743,  454,  464,  744,  743,    3,  445,  744,  743,  370,
 /*  1640 */   707,  505,  442,   87,  456,  717,  455,  242,  414,  464,
 /*  1650 */   720,  454,  702,  195,  454,  400,   68,  707,  719,  718,
 /*  1660 */   717,  454,   21,  450,  456,  299,  395,  456,  746,   67,
 /*  1670 */   236,  729,  702,  199,  456,  702,  197,  530,  745,  663,
 /*  1680 */   701,  725,  702,  205,  745,   45,  137,  744,  743,  391,
 /*  1690 */   292,  707,  744,  743,  745,   10,  707,  577,  698, 1072,
 /*  1700 */   346,  746,   42,   43,  570,    4,  671,  713,  457,   44,
 /*  1710 */   562,  746,  454,  164,  133,   31,   85,    3, 1074,  445,
 /*  1720 */    83,   30,  707,   29,  442,  456,  671,  717,  455,  671,
 /*  1730 */    28,  454,  720,  702,  203,  715,  671,  454,  746,  707,
 /*  1740 */   719,  718,  717,  454,  456,  341,  450,  675,  745,  746,
 /*  1750 */   456,   82,  702,  206,  454,  733,  456,  339,  702,  210,
 /*  1760 */    81,  454,  541,  701,  702,  244,  447,  456,   45,  542,
 /*  1770 */   744,  743,  372,  707,  456,  702,  309,   10,  707,  745,
 /*  1780 */   698,  664,  702,  202,  660,   42,   43,  671,  731,  270,
 /*  1790 */   457,  536,   44,  230,  745,  454,  529,  745,  531,  149,
 /*  1800 */     3,  445,  745,  744,  743,  707,  671,  442,  456,  713,
 /*  1810 */   717,  455,  671,  744,  743,  720,  702,  194,  671,  655,
 /*  1820 */   712,  454,  707,  719,  718,  717,  454,   89,  450,  671,
 /*  1830 */   523,  264,  745,  457,  456,  128,  671,   11,  261,  456,
 /*  1840 */   744,  743,  702,  180,  445,  701,   76,  702,  171,  160,
 /*  1850 */    45,  744,  743,  654,  169,  504,  707,  120,  481,  356,
 /*  1860 */    10,  707,  454,  698,  480,  103,  746,   42,   43,  462,
 /*  1870 */   671,  450,  596,  746,   44,  456,  216,  269,  642,  219,
 /*  1880 */   746,  268,    3,  702,  179,  234,   93,  707,  701,  442,
 /*  1890 */   745,  332,  744,  455,  212,  749,  671,  720,  331,  454,
 /*  1900 */   158,  671,  454,  739,  707,  719,  718,  717,  737,  258,
 /*  1910 */    42,   43,  456,  507,  256,  456,  738,   44,  503,  157,
 /*  1920 */   702,  193,  745,  702,  198,    3,  459,  745,   88,  713,
 /*  1930 */   707,  392,  442,  155,   18,  717,  455,  671,  707,  454,
 /*  1940 */   720,  454,   10,  707,  458,  698,  746,  707,  719,  718,
 /*  1950 */   717,  105,  456,  250,  456,  227,  746,  454,  142,  421,
 /*  1960 */   702,  327,  702,  326,  249,  153,  316,  730,  744,  743,
 /*  1970 */   456,  745,  745,  225,  671,  744,  743,  671,  702,  325,
 /*  1980 */   454,  707,  744,  743,  109,   10,  707,  313,  698,  243,
 /*  1990 */   454,  315,  156,  456,  622,  159,  454,  649,   87,   51,
 /*  2000 */   104,  702,  178,  456,  626,   35,  454,  700,  242,  456,
 /*  2010 */   745,  702,  100,  641,  671,   20,  671,  702,  177,  456,
 /*  2020 */   303,  299,  304,  454,  301,  454,  520,  702,  176,  430,
 /*  2030 */   454,  713,  671,  746,  745,  317,  456,  154,  456,  302,
 /*  2040 */   454,   39,  677,  456,  702,  174,  702,  173,  744,  743,
 /*  2050 */   432,  702,  192,  456,  454,  671,  345,  288,  744,  743,
 /*  2060 */   587,  702,  172,  746,  454,  671,  746,  456,  699,  454,
 /*  2070 */   745,  671,  746,   48,  330,  702,  200,  456,  439,  254,
 /*  2080 */    70,  671,  456,  499,  560,  702,  201,  238,  223,  252,
 /*  2090 */   702,  184,  745,  496,  597,  454,  746,  454,  671,  435,
 /*  2100 */   671,  454,  745,  675,  117,  671,  746,  745,  456,  118,
 /*  2110 */   456,  359,  454,  746,  456,  671,  702,  183,  702,  182,
 /*  2120 */   746,  417,  702,  181,  713,  456,  414,  454,  746,  671,
 /*  2130 */   454,  621,  454,  702,  185,  744,  743,  454,  746,  671,
 /*  2140 */   456,  746,  454,  456,  671,  456,  746,  141,  702,  188,
 /*  2150 */   456,  702,  101,  702,  187,  456,  746,  612,  702,  186,
 /*  2160 */   454,  746,  565,  702,  190,  744,  743,  454,  744,  743,
 /*  2170 */   671,  420,  671,  456,  744,  743,  671,  528,  746,  405,
 /*  2180 */   456,  702,  189,  746,  456,  607,  556,  671,  702,  175,
 /*  2190 */   578,  746,  702,   74,  746,  558,  746,  606,  744,  743,
 /*  2200 */   348,  282,  671,  745,  290,  671,  275,  671,  744,  743,
 /*  2210 */   552,  603,  671,  602,  745,  744,  743,  671,  601,  745,
 /*  2220 */   547,  576,  744,  743,  515,  246,  713,  518,  323,  335,
 /*  2230 */   744,  743,  366,  575,  506,  671,  583,  584,  745,  468,
 /*  2240 */   744,  743,  671,  744,  743,  745,  671,  574,  744,  743,
 /*  2250 */   136,  573,  745,  564,   86,  453,  295,  276,  744,  743,
 /*  2260 */   322,  135,  390,  744,  743,  385,  263,  502,  745,  745,
 /*  2270 */   745,  114,  134,  221,  467,  469,  260,  251,  745,  745,
 /*  2280 */   744,  743,  247,  500,  274,  744,  743,  672,  373,  745,
 /*  2290 */   745,  248,  388,  744,  743,  745,  744,  743,  744,  743,
 /*  2300 */    27,  132,  555,  113,  745,   84,  131,  130,  163,  497,
 /*  2310 */    90,  380,  379,  539,  545,  111,  129,  489,  367,  519,
 /*  2320 */   110,  127,  364,   80,  362,  126,   79,  125,  124,   78,
 /*  2330 */    77,  676,  123,  122,   26,  477,  336,   23,  475,  108,
 /*  2340 */    66,  107,  661,  471,  121,  465,  305,  170,  693,  689,
 /*  2350 */   679,  291,  451,  598,  399,  666,  207,  551,  656,  272,
 /*  2360 */   544,  386,  318,  711,  688,    7,  220,   33,  678,  585,
 /*  2370 */   306,  389,  449,   75,  595,  589,  588,  616,  615,   87,
 /*  2380 */  1187,  579, 1187,  513,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     4,   81,   82,   83,   84,   85,   86,   87,   51,    4,
 /*    10 */    53,   15,   72,   73,   74,   75,   76,   77,   78,   79,
 /*    20 */    80,   81,   82,   83,   84,   85,   86,   87,  193,   33,
 /*    30 */    34,   96,    4,   98,   72,   73,   74,   75,   42,   77,
 /*    40 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*    50 */    97,   55,   95,  104,    4,   59,  107,  104,   62,   63,
 /*    60 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*    70 */    74,   75,  237,   77,   78,   79,   80,   81,   82,   83,
 /*    80 */    84,   85,   86,   87,   88,    4,   83,   84,   85,   86,
 /*    90 */    87,    4,   96,  144,  145,  106,   15,  101,   89,  103,
 /*   100 */   111,   96,  106,  107,  111,  179,  101,  111,  119,  120,
 /*   110 */   121,  106,  107,  187,  118,  119,  120,  121,  192,    4,
 /*   120 */   179,   97,  129,   42,   96,  179,  200,  201,  104,  101,
 /*   130 */   134,  135,   97,  192,  106,  107,  126,  179,  192,  104,
 /*   140 */    59,  200,  201,  197,  198,   64,  118,  221,  152,   23,
 /*   150 */   192,  101,  156,  157,  193,  159,  106,  107,  200,  201,
 /*   160 */   234,  133,   81,   82,   83,  155,  179,  117,  118,   88,
 /*   170 */    89,  137,  144,  145,  140,  234,  235,   96,   97,  192,
 /*   180 */   254,   55,  101,    4,  103,  104,  109,  106,  107,  112,
 /*   190 */   113,  114,  111,  106,  107,  254,  146,    4,  237,  118,
 /*   200 */   119,  120,  121,  116,  123,  179,   34,  130,   15,  263,
 /*   210 */   264,   96,  254,   64,  256,   89,  255,  136,  192,  138,
 /*   220 */   139,  106,  107,  142,    4,  227,  200,  201,  147,  148,
 /*   230 */   149,  150,  151,  152,  236,   42,   87,  156,  157,   93,
 /*   240 */   159,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   250 */    86,   87,   59,   30,    4,  179,    4,   64,  109,  110,
 /*   260 */   111,  112,  113,  114,  115,   97,  279,  152,  192,  124,
 /*   270 */   125,  126,  246,  104,   81,   82,  200,  201,  129,    4,
 /*   280 */   254,   88,   89,    4,  105,  106,  107,   64,  109,   96,
 /*   290 */    97,  112,  113,  114,  101,  123,  103,  104,   61,  106,
 /*   300 */   107,  110,  111,  187,  111,  136,  104,  138,  139,  130,
 /*   310 */   234,  118,  119,  120,  121,   50,  123,    4,   61,   54,
 /*   320 */   100,  101,  124,  125,  126,    4,  106,  107,   15,  136,
 /*   330 */   254,  138,  139,   96,   97,   83,  220,  221,   59,   96,
 /*   340 */   147,  148,  149,  150,  142,  152,   96,  154,    5,  156,
 /*   350 */   157,  101,  159,   96,   97,   42,  106,  107,  106,  107,
 /*   360 */    81,   82,    7,  247,  248,    4,   11,  251,  118,   26,
 /*   370 */   118,   28,   59,   86,   87,   96,  101,   64,  113,   33,
 /*   380 */    34,  106,  107,  133,  179,  106,  270,   32,   45,   97,
 /*   390 */   111,   48,  187,  118,   81,   82,  104,  192,  119,  120,
 /*   400 */   121,   88,   89,    4,  152,  200,  201,   58,   19,   96,
 /*   410 */    97,   61,   66,   67,  101,    4,  103,  104,   29,  106,
 /*   420 */   107,  146,   45,   99,  111,   19,  221,  106,  163,  108,
 /*   430 */    24,  118,  119,  120,  121,   29,  123,  179,  190,  234,
 /*   440 */   235,  193,  194,  195,   33,   34,   96,   97,  179,  136,
 /*   450 */   192,  138,  139,  179,  104,  197,  198,   96,   96,  254,
 /*   460 */   147,  192,  149,  150,   97,  152,  192,  106,  107,  156,
 /*   470 */   157,  104,  159,   62,   63,   64,   65,   66,   67,   68,
 /*   480 */    69,   70,   71,   72,   73,   74,   75,  255,   77,   78,
 /*   490 */    79,   80,   81,   82,   83,   84,   85,   86,   87,  100,
 /*   500 */   101,  124,  125,  126,  272,  106,  107,  238,  239,   98,
 /*   510 */   179,  134,  135,  152,   99,  184,  154,  106,  169,  188,
 /*   520 */   189,  263,  264,  192,   33,   34,   62,   63,   64,   65,
 /*   530 */    99,   40,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   540 */    83,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   550 */    86,   87,  141,   62,   63,   64,   65,   66,   67,   68,
 /*   560 */    69,   70,   71,   72,   73,   74,   75,  181,   77,   78,
 /*   570 */    79,   80,   81,   82,   83,   84,   85,   86,   87,    9,
 /*   580 */   193,  194,  195,  179,  172,  173,  174,  175,   81,   82,
 /*   590 */    20,   97,  188,  189,  137,  104,  192,  140,  104,   62,
 /*   600 */    63,   64,   65,   33,   34,   68,   69,   70,   71,   72,
 /*   610 */    73,   74,   75,  104,   77,   78,   79,   80,   81,   82,
 /*   620 */    83,   84,   85,   86,   87,  161,  119,  120,   99,   33,
 /*   630 */    34,  122,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   640 */    70,   71,   72,   73,   74,   75,  260,   77,   78,   79,
 /*   650 */    80,   81,   82,   83,   84,   85,   86,   87,   62,   63,
 /*   660 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   670 */    74,   75,    4,   77,   78,   79,   80,   81,   82,   83,
 /*   680 */    84,   85,   86,   87,   33,   34,   64,   65,  119,  120,
 /*   690 */    68,   69,   70,   71,   72,   73,   74,   75,  161,   77,
 /*   700 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   710 */     4,   43,  111,   62,   63,   64,   65,   66,   67,   68,
 /*   720 */    69,   70,   71,   72,   73,   74,   75,   23,   77,   78,
 /*   730 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   62,
 /*   740 */    63,   64,   65,    4,   96,   68,   69,   70,   71,   72,
 /*   750 */    73,   74,   75,  104,   77,   78,   79,   80,   81,   82,
 /*   760 */    83,   84,   85,   86,   87,  193,   89,   51,  100,   53,
 /*   770 */    61,  160,   97,  162,  106,  107,   62,   63,   64,   65,
 /*   780 */     4,  104,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   790 */   104,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   800 */    86,   87,   96,   89,   98,   96,   97,  222,  223,  237,
 /*   810 */   225,   95,  106,  104,   62,   63,   64,   65,  104,   71,
 /*   820 */    68,   69,   70,   71,   72,   73,   74,   75,  151,   77,
 /*   830 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   840 */   101,   89,  179,   97,   96,  106,  107,  141,   12,   98,
 /*   850 */   104,   62,   63,   64,   65,  192,  104,   68,   69,   70,
 /*   860 */    71,   72,   73,   74,   75,  151,   77,   78,   79,   80,
 /*   870 */    81,   82,   83,   84,   85,   86,   87,  101,   89,  163,
 /*   880 */   275,  276,  106,  107,  179,  146,  193,  196,  197,  198,
 /*   890 */   196,  197,  198,  104,  118,    4,   97,  192,   62,   63,
 /*   900 */    64,   65,   38,  151,   68,   69,   70,   71,   72,   73,
 /*   910 */    74,   75,  104,   77,   78,   79,   80,   81,   82,   83,
 /*   920 */    84,   85,   86,   87,  261,   89,   62,   63,   64,   65,
 /*   930 */   237,    4,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   940 */   151,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   950 */    86,   87,    4,   89,  249,  264,   97,  187,  264,  151,
 /*   960 */   207,  208,   96,   15,   62,   63,   64,   65,  215,   34,
 /*   970 */    68,   69,   70,   71,   72,   73,   74,   75,    4,   77,
 /*   980 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   990 */    42,  221,    4,  123,    4,   97,  105,  106,  107,   64,
 /*  1000 */    98,  179,  179,   55,  179,   97,  179,   59,   81,   82,
 /*  1010 */     0,  179,   64,  143,  192,  192,   96,  192,  179,  192,
 /*  1020 */   188,  189,  200,  201,  192,  200,  201,  187,  179,   81,
 /*  1030 */    82,  192,  183,  106,  107,   25,   88,  110,   97,  200,
 /*  1040 */   201,  192,    5,  211,   96,  213,  119,  120,    4,  101,
 /*  1050 */   123,  103,  125,   96,  106,  107,  234,  235,  123,  111,
 /*  1060 */   220,  221,   55,   26,  129,   28,  118,  119,  120,  121,
 /*  1070 */    97,  246,  245,  234,  235,  101,  254,  104,   97,  254,
 /*  1080 */   106,  107,  134,  135,  179,   48,   96,  247,  248,    4,
 /*  1090 */   179,  251,  187,  254,  106,  107,  106,  192,  179,   89,
 /*  1100 */   152,   97,  279,  192,  156,  157,  118,  159,  104,  269,
 /*  1110 */   270,  192,   62,   63,   64,   65,   98,  110,   68,   69,
 /*  1120 */    70,   71,   72,   73,   74,   75,  221,   77,   78,   79,
 /*  1130 */    80,   81,   82,   83,   84,   85,   86,   87,  164,   96,
 /*  1140 */   152,  179,    9,  238,  239,  179,  179,   97,  179,  183,
 /*  1150 */   106,  107,  183,   20,  192,  187,    4,   97,  192,  192,
 /*  1160 */   249,  192,  118,   62,   63,   64,   65,  200,  201,   68,
 /*  1170 */    69,   70,   71,   72,   73,   74,   75,  133,   77,   78,
 /*  1180 */    79,   80,   81,   82,   83,   84,   85,   86,   87,  221,
 /*  1190 */    97,  106,  107,   62,   63,   64,   65,  104,   97,   68,
 /*  1200 */    69,   70,   71,   72,   73,   74,   75,  245,   77,   78,
 /*  1210 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   13,
 /*  1220 */     4,  254,  187,  187,  104,  199,  141,   97,   97,   62,
 /*  1230 */    63,   64,   65,  207,  104,   68,   69,   70,   71,   72,
 /*  1240 */    73,   74,   75,   91,   77,   78,   79,   80,   81,   82,
 /*  1250 */    83,   84,   85,   86,   87,   13,  221,  221,  106,  107,
 /*  1260 */   104,   62,   63,   64,   65,   98,   96,   68,   69,   70,
 /*  1270 */    71,   72,   73,   74,   75,   30,   77,   78,   79,   80,
 /*  1280 */    81,   82,   83,   84,   85,   86,   87,  187,   89,   97,
 /*  1290 */     4,   62,   63,   64,   65,  187,  104,   68,   69,   70,
 /*  1300 */    71,   72,   73,   74,   75,   13,   77,   78,   79,   80,
 /*  1310 */    81,   82,   83,   84,   85,   86,   87,  101,   89,    4,
 /*  1320 */   192,  221,  106,  107,   62,   63,   64,   65,  200,  221,
 /*  1330 */    68,   69,   70,   71,   72,   73,   74,   75,   97,   77,
 /*  1340 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  1350 */   203,   62,   63,   64,   65,   25,    4,   68,   69,   70,
 /*  1360 */    71,   72,   73,   74,   75,  179,   77,   78,   79,   80,
 /*  1370 */    81,   82,   83,   84,   85,   86,   87,    4,  192,  216,
 /*  1380 */     4,  218,  166,   99,   98,    4,  200,  201,   15,   63,
 /*  1390 */    64,   65,  106,    4,   68,   69,   70,   71,   72,   73,
 /*  1400 */    74,   75,  255,   77,   78,   79,   80,   81,   82,   83,
 /*  1410 */    84,   85,   86,   87,   14,   42,  101,   97,  179,   89,
 /*  1420 */   234,  106,  107,  171,  104,  179,   97,  141,  176,  179,
 /*  1430 */   179,  192,   59,   97,   97,   35,   83,   64,  192,  187,
 /*  1440 */   254,  104,  192,  192,   55,  144,   46,  132,    4,  174,
 /*  1450 */   175,  200,  201,  101,   81,   82,  203,   99,  106,  107,
 /*  1460 */     4,   88,  179,    4,  214,  104,    4,   91,    4,   96,
 /*  1470 */    97,   15,  220,  221,  101,  192,  103,    4,  239,  106,
 /*  1480 */   107,    4,  106,  107,  111,   96,   97,  106,  107,   96,
 /*  1490 */   101,  118,  119,  120,  121,  106,  107,  246,   42,  247,
 /*  1500 */   248,  179,    4,  251,    4,  254,  179,  118,  255,  222,
 /*  1510 */   223,  261,  225,   97,  192,   59,  216,  165,  218,  192,
 /*  1520 */    64,   96,  133,  134,  135,  152,  274,    4,  128,  156,
 /*  1530 */   157,    4,  159,  152,  179,    4,  179,   81,   82,  252,
 /*  1540 */   137,  214,   97,    4,   88,  101,  160,  192,  179,  192,
 /*  1550 */   106,  107,   96,   97,   15,  200,  201,  101,   97,  103,
 /*  1560 */   101,  192,  106,  107,  102,  106,  107,  111,  106,  107,
 /*  1570 */   106,  107,   17,  179,  118,  119,  120,  121,   97,  106,
 /*  1580 */   107,   42,   97,  106,  107,    4,  192,  179,  261,   38,
 /*  1590 */     4,  118,  133,   97,   97,  118,    6,  179,   59,  101,
 /*  1600 */   192,  101,  245,   64,  106,  107,  106,  107,  152,  254,
 /*  1610 */   192,  167,  156,  157,  245,  159,  118,   96,  118,  146,
 /*  1620 */    81,   82,  158,  146,  101,    4,  193,   88,   96,  106,
 /*  1630 */   107,  179,  101,  106,  107,   96,   15,  106,  107,  245,
 /*  1640 */   101,  118,  103,   55,  192,  106,  107,  134,  135,  118,
 /*  1650 */   111,  179,  200,  201,  179,   38,   96,  118,  119,  120,
 /*  1660 */   121,  179,   96,   42,  192,  179,   38,  192,    4,   96,
 /*  1670 */   237,  179,  200,  201,  192,  200,  201,   89,  192,  152,
 /*  1680 */    59,  179,  200,  201,  192,   64,  115,  106,  107,   64,
 /*  1690 */   129,  152,  106,  107,  192,  156,  157,  116,  159,  160,
 /*  1700 */   214,    4,   81,   82,  118,   12,  254,    4,    4,   88,
 /*  1710 */   103,    4,  179,   98,  123,   71,  142,   96,   97,   15,
 /*  1720 */   128,   71,  101,   71,  103,  192,  254,  106,  107,  254,
 /*  1730 */    71,  179,  111,  200,  201,  179,  254,  179,    4,  118,
 /*  1740 */   119,  120,  121,  179,  192,   17,   42,  261,  192,    4,
 /*  1750 */   192,  153,  200,  201,  179,   91,  192,  154,  200,  201,
 /*  1760 */   128,  179,  135,   59,  200,  201,  179,  192,   64,  155,
 /*  1770 */   106,  107,   22,  152,  192,  200,  201,  156,  157,  192,
 /*  1780 */   159,  179,  200,  201,  179,   81,   82,  254,   91,  179,
 /*  1790 */     4,   89,   88,  183,  192,  179,   47,  192,   89,  104,
 /*  1800 */    96,   15,  192,  106,  107,  101,  254,  103,  192,  106,
 /*  1810 */   106,  107,  254,  106,  107,  111,  200,  201,  254,  179,
 /*  1820 */   117,  179,  118,  119,  120,  121,  179,   39,   42,  254,
 /*  1830 */    39,  163,  192,    4,  192,  123,  254,   96,   95,  192,
 /*  1840 */   106,  107,  200,  201,   15,   59,   95,  200,  201,  143,
 /*  1850 */    64,  106,  107,  146,   96,  103,  152,   93,   97,   37,
 /*  1860 */   156,  157,  179,  159,   97,  191,    4,   81,   82,   36,
 /*  1870 */   254,   42,  127,    4,   88,  192,  240,  179,  144,  255,
 /*  1880 */     4,  183,   96,  200,  201,  206,  206,  101,   59,  103,
 /*  1890 */   192,  278,  106,  107,  276,  178,  254,  111,  278,  179,
 /*  1900 */    90,  254,  179,  178,  118,  119,  120,  121,   49,  179,
 /*  1910 */    81,   82,  192,  183,  179,  192,  178,   88,  183,  180,
 /*  1920 */   200,  201,  192,  200,  201,   96,  178,  192,  182,    4,
 /*  1930 */   101,   60,  103,  180,  104,  106,  107,  254,  152,  179,
 /*  1940 */   111,  179,  156,  157,  185,  159,    4,  118,  119,  120,
 /*  1950 */   121,    8,  192,   10,  192,   12,    4,  179,  179,  179,
 /*  1960 */   200,  201,  200,  201,   21,   56,   23,  186,  106,  107,
 /*  1970 */   192,  192,  192,   87,  254,  106,  107,  254,  200,  201,
 /*  1980 */   179,  152,  106,  107,   41,  156,  157,   44,  159,  257,
 /*  1990 */   179,   48,   49,  192,  118,   52,  179,  179,   55,  255,
 /*  2000 */    57,  200,  201,  192,   64,  160,  179,  223,  134,  192,
 /*  2010 */   192,  200,  201,  144,  254,  151,  254,  200,  201,  192,
 /*  2020 */   230,  179,  229,  179,  232,  179,  164,  200,  201,  148,
 /*  2030 */   179,  106,  254,    4,  192,   92,  192,   94,  192,  231,
 /*  2040 */   179,  149,  117,  192,  200,  201,  200,  201,  106,  107,
 /*  2050 */   147,  200,  201,  192,  179,  254,  214,  179,  106,  107,
 /*  2060 */   118,  200,  201,    4,  179,  254,    4,  192,  233,  179,
 /*  2070 */   192,  254,    4,  150,  131,  200,  201,  192,  205,  179,
 /*  2080 */    96,  254,  192,  183,  132,  200,  201,  262,   87,  179,
 /*  2090 */   200,  201,  192,  183,  179,  179,    4,  179,  254,  205,
 /*  2100 */   254,  179,  192,  261,   99,  254,    4,  192,  192,  243,
 /*  2110 */   192,  168,  179,    4,  192,  254,  200,  201,  200,  201,
 /*  2120 */     4,  225,  200,  201,    4,  192,  135,  179,    4,  254,
 /*  2130 */   179,  243,  179,  200,  201,  106,  107,  179,    4,  254,
 /*  2140 */   192,    4,  179,  192,  254,  192,    4,   99,  200,  201,
 /*  2150 */   192,  200,  201,  200,  201,  192,    4,  202,  200,  201,
 /*  2160 */   179,    4,  100,  200,  201,  106,  107,  179,  106,  107,
 /*  2170 */   254,  179,  254,  192,  106,  107,  254,  118,    4,  123,
 /*  2180 */   192,  200,  201,    4,  192,  202,  118,  254,  200,  201,
 /*  2190 */   179,    4,  200,  201,    4,  166,    4,  210,  106,  107,
 /*  2200 */    31,  179,  254,  192,  202,  254,  179,  254,  106,  107,
 /*  2210 */   118,  204,  254,  122,  192,  106,  107,  254,  202,  192,
 /*  2220 */   118,  202,  106,  107,  100,  179,  106,  118,  205,  183,
 /*  2230 */   106,  107,  179,  202,  118,  254,  210,  117,  192,  179,
 /*  2240 */   106,  107,  254,  106,  107,  192,  254,  202,  106,  107,
 /*  2250 */    99,  202,  192,  243,  182,  179,  179,  179,  106,  107,
 /*  2260 */   205,   99,  205,  106,  107,  179,  179,  133,  192,  192,
 /*  2270 */   192,  182,   99,  243,  100,  118,  179,  179,  192,  192,
 /*  2280 */   106,  107,  179,  146,  267,  106,  107,  100,   27,  192,
 /*  2290 */   192,  179,  268,  106,  107,  192,  106,  107,  106,  107,
 /*  2300 */   160,   99,  229,   62,  192,  217,   99,   99,  250,  167,
 /*  2310 */    96,  123,  229,  217,  253,  182,   99,  165,  243,  229,
 /*  2320 */   182,   99,  243,  219,   60,   99,  219,   99,   99,  219,
 /*  2330 */   219,  152,   99,   99,  271,   18,  243,  271,  243,   99,
 /*  2340 */   273,   99,  152,  243,   99,   16,  228,  226,  264,  264,
 /*  2350 */   203,  203,  258,  208,  204,  242,  212,  229,  244,  244,
 /*  2360 */   229,  244,  177,  193,  193,  226,  265,  259,  193,  193,
 /*  2370 */   224,  266,  218,  241,  209,  209,  209,  200,  200,   55,
 /*  2380 */   280,  213,  280,  277,
};
#define YY_SHIFT_USE_DFLT (-81)
#define YY_SHIFT_COUNT (460)
#define YY_SHIFT_MIN   (-80)
#define YY_SHIFT_MAX   (2329)
static const short yy_shift_ofst[] = {
 /*     0 */  1330,   -4, 1943,  948, 1588, 1621, 1621, 1621,  126,  313,
 /*    10 */  1539, 1704, 1704, 1704, 1704, 1389,  927,  927,  179,   81,
 /*    20 */   193, 1456, 1373, 1704, 1704, 1704, 1704, 1704, 1704, 1704,
 /*    30 */  1704, 1704, 1704, 1704, 1704, 1704, 1704, 1704, 1704, 1704,
 /*    40 */  1786, 1704, 1704, 1704, 1704, 1786, 1704, 1704, 1704, 1704,
 /*    50 */  1704, 1704, 1704, 1704, 1704, 1704, 1704, 1704, 1704, 1704,
 /*    60 */  1704, 1704, 1829,  891,   28,  377,  891, 2179, 2179, 2179,
 /*    70 */  2179,  507,  507,  321,  411,  250, 1531, 1444,  739, 1459,
 /*    80 */  1523,  361, 1500,  361, 1498,  776, 1315,  668,  399, 2190,
 /*    90 */  2190, 2190, 2190,  935, 2190, 2187, 2179,  321, 1513,  570,
 /*   100 */   570,  864,  279,  149,   50,  275,  252, 1477, 1473, 1352,
 /*   110 */   220,  974,  115,  343, 1216,  343,    5, 1044,  706,  988,
 /*   120 */  2174, 2157, 2152, 2142, 2137, 2134, 2116, 2124, 2109, 1862,
 /*   130 */  2102, 2092, 2068, 2059, 2029, 1952, 2062, 1586, 1581, 1745,
 /*   140 */  1942, 1876, 1869, 1734, 1286, 1286, 1286, 1707, 1085, 1527,
 /*   150 */  1464, 1381,   87, 1462,  265, 1697, 1664, 1376, 1152, 2192,
 /*   160 */  2192, 2192, 1010, 1007, 2324, 2324, 2324, 2324, 2324,  -81,
 /*   170 */   -81,  491,  651,  651,  651,  651,  651,  651,  651,  651,
 /*   180 */   651,  789,  752,  714,  677,  836, 1229, 1199, 1167, 1131,
 /*   190 */  1101, 1050,  537,  902,  464, 1289, 1262, 1326,  622,  622,
 /*   200 */   -60,  -38,  -38,  -38,  -38,  164,  -80,   77,  -11,  -11,
 /*   210 */     3,  709,  350, 1400, 1400, 1400,  -51,  169, 1037,  346,
 /*   220 */   198,  355, 2120, 1925,  990, 1703,  457,  406,  808,  808,
 /*   230 */   223,  223,  509, 1337,  172, 1133,  223,  870, 1133,  569,
 /*   240 */   569,  202,   34,  611,  287, 2329, 2245, 2242, 2240, 2317,
 /*   250 */  2317, 2234, 2233, 2264, 2229, 2264, 2228, 2264, 2226, 2264,
 /*   260 */  2222, 1871, 1864, 2217, 1871, 2241, 1864, 2188, 2214, 2208,
 /*   270 */  2207, 2241, 1864, 2202, 2140, 2261, 2173, 1871, 2162, 1984,
 /*   280 */  1871, 2151, 1984, 2056, 2056, 2056, 2056, 2169, 1984, 2056,
 /*   290 */  2091, 2056, 2169, 2056, 2056, 2048, 1991, 2005, 1984, 2001,
 /*   300 */  1984, 1923, 1903, 1892, 1881, 1864, 1874, 1845, 1940, 1886,
 /*   310 */  1909, 1830, 1871, 1859, 1859, 1810, 1810, 1810, 1810,  -81,
 /*   320 */   -81,  -81,  -81,  -81,  -81,  -81,  -81,  -81,  -81,  596,
 /*   330 */   716,  257,  237,  145,  -43,  349,  748, 1320, 1192,   10,
 /*   340 */  1130,  362, 1093, 1004,  973,  746,  494,  191,  389,   -7,
 /*   350 */   367,  292,   35,   24,  -47,  -65, 1833, 1822, 1764, 1751,
 /*   360 */  1767, 1761, 1752, 1758, 1706, 1743, 1741, 1712, 1668, 1791,
 /*   370 */  1695, 1788, 1749, 1750, 1709, 1702, 1627, 1614, 1632, 1603,
 /*   380 */  1728, 1598, 1659, 1652, 1650, 1644, 1592, 1574, 1693, 1591,
 /*   390 */  1615, 1607, 1625, 1561, 1571, 1573, 1628, 1566, 1560, 1497,
 /*   400 */  1532, 1617, 1590, 1521, 1551, 1555, 1496, 1485, 1481, 1461,
 /*   410 */  1386, 1445, 1361, 1403, 1425, 1416, 1393, 1361, 1353, 1358,
 /*   420 */  1284, 1301, 1336, 1329, 1156, 1241, 1245, 1292, 1170, 1156,
 /*   430 */  1242, 1120, 1206, 1060, 1043, 1018,  686,  981,  957,  751,
 /*   440 */   686,  941,  920,  908,  898,  866,  859,  799,  675,  649,
 /*   450 */   648,  704,  601,  529,  431,  415,  324,  243,  168,  146,
 /*   460 */     9,
};
#define YY_REDUCE_USE_DFLT (-166)
#define YY_REDUCE_COUNT (328)
#define YY_REDUCE_MIN   (-165)
#define YY_REDUCE_MAX   (2185)
static const short yy_reduce_ofst[] = {
 /*     0 */   412,  205, 1252,  -74,  840,  839,  822,  -59,  116, 1186,
 /*    10 */   -42, 1251,  825,   76,   26,  905,  258,  -54,  832, 1992,
 /*    20 */  1988, 1981, 1963, 1958, 1953, 1951, 1948, 1933, 1922, 1918,
 /*    30 */  1916, 1890, 1885, 1875, 1861, 1851, 1846, 1844, 1827, 1817,
 /*    40 */  1811, 1801, 1778, 1762, 1760, 1723, 1720, 1683, 1647, 1642,
 /*    50 */  1616, 1582, 1575, 1564, 1558, 1552, 1533, 1482, 1475, 1472,
 /*    60 */  1452, 1355,  967,  331,  269, 1287,  404, 1842, 1486, 1327,
 /*    70 */  1250,  694,  691,  248,  -39, 1239, 2046, 1910, 1900, 1735,
 /*    80 */  1730,  911, 1698,  705, 1610,  969,  966,  823,  849, 1394,
 /*    90 */  1369, 1357,  962,  753,  827,  -13,  663,  387,  585, 1253,
 /*   100 */  1147,  232, 1128, 1026, 2112, 2103, 2076, 1818, 1818, 2098,
 /*   110 */  2097, 2087, 2086, 1300, 2078, 1163, 2077, 1818, 1433, 2076,
 /*   120 */  2060, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 2053, 1818,
 /*   130 */  1818, 1818, 1818, 2027, 1818, 1818, 1818, 2022, 2011, 1915,
 /*   140 */  1878, 1818, 1780, 1779,  693,  572, -165, 1640, 1605, 1602,
 /*   150 */  1587, 1556, 1502, 1492,  386, 1418, 1408, 1322, 1283, 1246,
 /*   160 */   919,  274, 1275, 1108, 1100, 1036, 1035,  968,  770,  605,
 /*   170 */    -2, 1624, 1624, 1624, 1624, 1624, 1624, 1624, 1624, 1624,
 /*   180 */  1624, 1624, 1624, 1624, 1624, 1624, 1624, 1624, 1624, 1624,
 /*   190 */  1624, 1624, 1624, 1624, 1624, 1624, 1624, 1624, 1624, 1624,
 /*   200 */  1624, 1624, 1624, 1624, 1624, 1624, 1624, 2168, 2178, 2177,
 /*   210 */  1624, 2106, 2106, 2167, 2166, 2165, 2132, 2146, 2154, 2108,
 /*   220 */  2105, 2101, 2176, 2175, 2171, 2170, 2139, 2185, 2131, 2128,
 /*   230 */  2117, 2115, 2150, 2144, 2145, 2148, 2114, 2113, 2147, 2085,
 /*   240 */  2084, 2118, 2121, 2094, 1624, 2067, 2010, 2100, 2095, 2066,
 /*   250 */  2063, 2093, 2010, 2111, 2010, 2110, 2010, 2107, 2010, 2104,
 /*   260 */  2079, 2138, 2090, 2075, 2133, 2096, 2083, 2061, 2058, 2010,
 /*   270 */  2010, 2088, 2073, 2010, 2024, 2017, 2030, 2089, 2010, 2057,
 /*   280 */  2072, 2010, 2055, 2049, 2045, 2031, 2019, 2026, 2023, 2016,
 /*   290 */  2007, 2002, 1987, 1983, 1955, 1888, 1896, 1866, 1894, 1825,
 /*   300 */  1873, 1835, 1792, 1808, 1790, 1793, 1784, 1732, 1744, 1624,
 /*   310 */  1781, 1759, 1746, 1753, 1739, 1748, 1738, 1725, 1717, 1620,
 /*   320 */  1613, 1618, 1680, 1679, 1636, 1624, 1624, 1624, 1674,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   759, 1074, 1179, 1062, 1179, 1062, 1062, 1062, 1179, 1062,
 /*    10 */  1062, 1062, 1062, 1062, 1062,  931, 1185, 1185, 1185, 1062,
 /*    20 */  1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062,
 /*    30 */  1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062,
 /*    40 */  1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062,
 /*    50 */  1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062,
 /*    60 */  1062, 1062, 1014, 1185,  924, 1185, 1185, 1185, 1185, 1185,
 /*    70 */  1185, 1185, 1185,  804,  920,  931, 1185, 1185, 1185, 1185,
 /*    80 */  1185,  988, 1002,  988,  980,  971, 1185, 1185, 1185,  996,
 /*    90 */   996,  996,  996,  872,  996, 1185, 1185, 1185, 1185,  959,
 /*   100 */   959, 1064, 1185,  796, 1149, 1154, 1012, 1185, 1185, 1185,
 /*   110 */  1185, 1185,  989, 1185, 1185, 1185, 1185,  932,  920, 1012,
 /*   120 */  1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185,
 /*   130 */  1003,  981,  972, 1185, 1185, 1185, 1185, 1185, 1185, 1185,
 /*   140 */  1185, 1185, 1185, 1185,  920,  920,  920, 1185, 1185, 1185,
 /*   150 */  1185, 1013, 1185, 1185,  793, 1185, 1185, 1185,  765, 1095,
 /*   160 */  1185, 1185,  759, 1179, 1179, 1179, 1179, 1179, 1179, 1172,
 /*   170 */   910,  966, 1068, 1069,  937,  976, 1075,  964,  968,  967,
 /*   180 */  1067, 1064, 1064, 1064, 1064, 1064, 1064, 1064, 1064, 1064,
 /*   190 */  1064, 1064, 1064, 1064, 1064, 1064, 1064, 1037, 1049, 1036,
 /*   200 */  1044, 1045, 1048, 1039, 1053, 1038, 1040, 1185, 1185, 1185,
 /*   210 */  1041, 1185, 1185, 1185, 1185, 1185,  923,  894, 1185, 1185,
 /*   220 */  1185, 1123, 1185, 1185,  806, 1185,  908,  768,  975,  975,
 /*   230 */   949,  949,  839,  863,  828,  959,  949,  939,  959, 1185,
 /*   240 */  1185,  921,  908, 1070, 1042, 1163,  940,  940,  940, 1148,
 /*   250 */  1148,  940,  940,  885,  940,  885,  940,  885,  940,  885,
 /*   260 */   940,  790,  975,  940,  790,  876,  975, 1008,  992,  940,
 /*   270 */   940,  876,  975,  940, 1130, 1128,  940,  790,  940, 1083,
 /*   280 */   790,  940, 1083,  874,  874,  874,  874,  855, 1083,  874,
 /*   290 */   839,  874,  855,  874,  874,  940, 1185,  940, 1083, 1089,
 /*   300 */  1083,  965,  953,  963,  960,  975, 1185, 1185, 1064, 1043,
 /*   310 */   787,  858,  790,  776,  776,  764,  764,  764,  764, 1176,
 /*   320 */  1176, 1172,  841,  841,  926, 1052, 1051, 1050,  815, 1076,
 /*   330 */  1185, 1185, 1185, 1185, 1185, 1185, 1097, 1185, 1185, 1185,
 /*   340 */  1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185,
 /*   350 */  1185, 1185, 1185, 1185, 1185, 1185, 1185,  760, 1185, 1185,
 /*   360 */  1185, 1185, 1185, 1166, 1185, 1185, 1185, 1185, 1185, 1185,
 /*   370 */  1127, 1126, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185,
 /*   380 */  1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 1115, 1185,
 /*   390 */  1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185,
 /*   400 */  1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 1016,
 /*   410 */  1063, 1185,  897,  902, 1185, 1185, 1185,  898, 1185, 1185,
 /*   420 */  1185, 1185, 1185, 1185, 1073, 1185, 1185, 1185, 1185,  961,
 /*   430 */  1185,  954, 1185, 1185, 1185, 1185, 1181, 1185, 1185, 1185,
 /*   440 */  1180, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185,
 /*   450 */  1185, 1015, 1065, 1029, 1185, 1028, 1027,  799, 1185,  774,
 /*   460 */  1185,  756,  761, 1165, 1162, 1164, 1159, 1160, 1158, 1161,
 /*   470 */  1157, 1155, 1156, 1153, 1151, 1150, 1152, 1147, 1143, 1103,
 /*   480 */  1101, 1099, 1108, 1107, 1106, 1105, 1104, 1100, 1098, 1102,
 /*   490 */  1096,  999,  978,  969,  892, 1142, 1140, 1141, 1094, 1092,
 /*   500 */  1093,  891,  890,  889,  884,  883,  882,  881, 1169, 1178,
 /*   510 */  1177, 1175, 1174, 1173, 1167, 1168, 1081, 1080, 1078, 1077,
 /*   520 */  1079,  792, 1119, 1122, 1121, 1120, 1125, 1124, 1117, 1129,
 /*   530 */  1134, 1133, 1138, 1137, 1136, 1135, 1132, 1114, 1007, 1006,
 /*   540 */  1004, 1001, 1011, 1010, 1009, 1000,  993, 1005,  983,  991,
 /*   550 */   990,  979,  982,  877,  974,  970,  973,  893, 1118,  888,
 /*   560 */   887,  886,  791,  786,  942,  785,  784,  795,  861,  862,
 /*   570 */   870,  873,  868,  871,  867,  866,  865,  869,  864,  860,
 /*   580 */   798,  797,  805,  854,  832,  830,  829,  833,  846,  845,
 /*   590 */   852,  851,  850,  849,  848,  844,  847,  843,  842,  834,
 /*   600 */   827,  826,  840,  825,  857,  856,  853,  824,  880,  879,
 /*   610 */   878,  875,  823,  822,  821,  820,  819,  818, 1035, 1034,
 /*   620 */  1066, 1057, 1018, 1017, 1056, 1054, 1065, 1055, 1026,  895,
 /*   630 */   905,  904,  903,  900,  901,  915,  913,  912,  911,  948,
 /*   640 */   947,  946,  945,  944,  943,  936,  934,  929,  928,  941,
 /*   650 */   935,  933,  930,  951,  952,  950,  927,  919,  917,  918,
 /*   660 */   916,  998,  995,  997,  994,  938,  925,  922,  909,  956,
 /*   670 */   955, 1063, 1184, 1182, 1183, 1086, 1088, 1091, 1090, 1087,
 /*   680 */   958,  957, 1085, 1084, 1058, 1033,  811,  809,  810, 1111,
 /*   690 */  1110, 1113, 1112, 1109,  813,  812,  808,  807, 1031,  899,
 /*   700 */   896, 1025, 1024, 1139, 1060, 1061, 1023, 1019, 1059, 1047,
 /*   710 */  1046, 1032, 1022,  800, 1020, 1030, 1021,  838,  837,  836,
 /*   720 */   835,  907,  906,  817,  831,  816,  814,  794,  789,  788,
 /*   730 */   783,  781,  778,  780,  777,  782,  779,  775,  773,  772,
 /*   740 */   771,  770,  769,  803,  802,  801,  799,  767,  766,  763,
 /*   750 */   762,  758,  757,  755,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*      SPACE => nothing */
    0,  /*         ID => nothing */
    4,  /*      ABORT => ID */
    4,  /*     ACTION => ID */
    4,  /*      AFTER => ID */
    4,  /*    ANALYZE => ID */
    4,  /*        ASC => ID */
    4,  /*     ATTACH => ID */
    4,  /*     BEFORE => ID */
    4,  /*      BEGIN => ID */
    4,  /*         BY => ID */
    4,  /*    CASCADE => ID */
    4,  /*       CAST => ID */
    4,  /*   COLUMNKW => ID */
    4,  /*   CONFLICT => ID */
    4,  /*   DATABASE => ID */
    4,  /*   DEFERRED => ID */
    4,  /*       DESC => ID */
    4,  /*     DETACH => ID */
    4,  /*       EACH => ID */
    4,  /*        END => ID */
    4,  /*  EXCLUSIVE => ID */
    4,  /*    EXPLAIN => ID */
    4,  /*       FAIL => ID */
    4,  /*        FOR => ID */
    4,  /*     IGNORE => ID */
    4,  /*  IMMEDIATE => ID */
    4,  /*    INDEXED => ID */
    4,  /*  INITIALLY => ID */
    4,  /*    INSTEAD => ID */
    4,  /*    LIKE_KW => ID */
    4,  /*      MATCH => ID */
    4,  /*         NO => ID */
    4,  /*       PLAN => ID */
    4,  /*      QUERY => ID */
    4,  /*        KEY => ID */
    4,  /*         OF => ID */
    4,  /*     OFFSET => ID */
    4,  /*     PRAGMA => ID */
    4,  /*      RAISE => ID */
    4,  /*  RECURSIVE => ID */
    4,  /*    RELEASE => ID */
    4,  /*    REPLACE => ID */
    4,  /*   RESTRICT => ID */
    4,  /*        ROW => ID */
    4,  /*   ROLLBACK => ID */
    4,  /*  SAVEPOINT => ID */
    4,  /*       TEMP => ID */
    4,  /*    TRIGGER => ID */
    4,  /*     VACUUM => ID */
    4,  /*       VIEW => ID */
    4,  /*    VIRTUAL => ID */
    4,  /*       WITH => ID */
    4,  /*    WITHOUT => ID */
    4,  /*    REINDEX => ID */
    4,  /*     RENAME => ID */
    4,  /*   CTIME_KW => ID */
    4,  /*         IF => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
  QList<Token*>* tokens = nullptr;
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3_parseARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

void *sqlite3_parseCopyParserState(void* other)
{
  yyParser *pParser;
  yyParser *otherParser = (yyParser*)other;

  // Copy parser
  pParser = (yyParser*)malloc((size_t)sizeof(yyParser));
  memcpy(pParser, other, (size_t)sizeof(yyParser));

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = malloc((size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)other)->yystack, (size_t)stackSize);
#endif

  for (int i = 0; i <= pParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(otherParser->yystack[i].tokens);
  }

  return pParser;
}

void sqlite3_parseAddToken(void* other, Token* token)
{
    yyParser *otherParser = (yyParser*)other;
    if (otherParser->yyidx < 0)
        return; // Nothing on stack yet. Might happen when parsing just whitespaces, nothing else.

    otherParser->yystack[otherParser->yyidx].tokens->append(token);
}

void sqlite3_parseRestoreParserState(void* saved, void* target)
{
  yyParser *pParser = (yyParser*)target;
  yyParser *savedParser = (yyParser*)saved;

  for (int i = 0; i <= pParser->yyidx; i++)
      delete pParser->yystack[i].tokens;

  memcpy(pParser, saved, (size_t)sizeof(yyParser));

  for (int i = 0; i <= savedParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(savedParser->yystack[i].tokens);
  }

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = relloc(pParser->yystack, (size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)saved)->yystack, (size_t)stackSize);
#endif
}

void sqlite3_parseFreeSavedState(void* other)
{
    yyParser *pParser = (yyParser*)other;
    for (int i = 0; i <= pParser->yyidx; i++)
        delete pParser->yystack[i].tokens;

#if YYSTACKDEPTH<=0
    free(pParser->yystack);
#endif
    free(other);
}

#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  "$",             "ILLEGAL",       "COMMENT",       "SPACE",       
  "ID",            "ABORT",         "ACTION",        "AFTER",       
  "ANALYZE",       "ASC",           "ATTACH",        "BEFORE",      
  "BEGIN",         "BY",            "CASCADE",       "CAST",        
  "COLUMNKW",      "CONFLICT",      "DATABASE",      "DEFERRED",    
  "DESC",          "DETACH",        "EACH",          "END",         
  "EXCLUSIVE",     "EXPLAIN",       "FAIL",          "FOR",         
  "IGNORE",        "IMMEDIATE",     "INDEXED",       "INITIALLY",   
  "INSTEAD",       "LIKE_KW",       "MATCH",         "NO",          
  "PLAN",          "QUERY",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "RECURSIVE",   
  "RELEASE",       "REPLACE",       "RESTRICT",      "ROW",         
  "ROLLBACK",      "SAVEPOINT",     "TEMP",          "TRIGGER",     
  "VACUUM",        "VIEW",          "VIRTUAL",       "WITH",        
  "WITHOUT",       "REINDEX",       "RENAME",        "CTIME_KW",    
  "IF",            "ANY",           "OR",            "AND",         
  "NOT",           "IS",            "BETWEEN",       "IN",          
  "ISNULL",        "NOTNULL",       "NE",            "EQ",          
  "GT",            "LE",            "LT",            "GE",          
  "ESCAPE",        "BITAND",        "BITOR",         "LSHIFT",      
  "RSHIFT",        "PLUS",          "MINUS",         "STAR",        
  "SLASH",         "REM",           "CONCAT",        "COLLATE",     
  "BITNOT",        "SEMI",          "TRANSACTION",   "ID_TRANS",    
  "COMMIT",        "TO",            "CREATE",        "TABLE",       
  "LP",            "RP",            "AS",            "DOT",         
  "ID_TAB_NEW",    "ID_DB",         "CTX_ROWID_KW",  "EXISTS",      
  "COMMA",         "ID_COL_NEW",    "STRING",        "JOIN_KW",     
  "ID_COL_TYPE",   "CONSTRAINT",    "DEFAULT",       "NULL",        
  "PRIMARY",       "UNIQUE",        "CHECK",         "REFERENCES",  
  "ID_CONSTR",     "ID_COLLATE",    "ID_TAB",        "INTEGER",     
  "FLOAT",         "BLOB",          "AUTOINCR",      "ON",          
  "INSERT",        "DELETE",        "UPDATE",        "ID_FK_MATCH", 
  "SET",           "DEFERRABLE",    "FOREIGN",       "DROP",        
  "ID_VIEW_NEW",   "ID_VIEW",       "SELECT",        "VALUES",      
  "UNION",         "ALL",           "EXCEPT",        "INTERSECT",   
  "DISTINCT",      "ID_ALIAS",      "FROM",          "USING",       
  "JOIN",          "ID_JOIN_OPTS",  "ID_IDX",        "ORDER",       
  "GROUP",         "HAVING",        "LIMIT",         "WHERE",       
  "ID_COL",        "INTO",          "DO",            "NOTHING",     
  "CASE",          "ID_FN",         "ID_ERR_MSG",    "VARIABLE",    
  "WHEN",          "THEN",          "ELSE",          "INDEX",       
  "ID_IDX_NEW",    "ID_PRAGMA",     "ID_TRIG_NEW",   "ID_TRIG",     
  "ALTER",         "ADD",           "error",         "cmd",         
  "input",         "cmdlist",       "ecmd",          "explain",     
  "cmdx",          "transtype",     "trans_opt",     "nm",          
  "savepoint_opt",  "temp",          "ifnotexists",   "fullname",    
  "columnlist",    "conslist_opt",  "table_options",  "select",      
  "column",        "columnid",      "type",          "carglist",    
  "id",            "ids",           "typetoken",     "typename",    
  "signed",        "plus_num",      "minus_num",     "ccons",       
  "term",          "expr",          "onconf",        "sortorder",   
  "autoinc",       "idxlist_opt",   "refargs",       "defer_subclause",
  "refarg",        "refact",        "init_deferred_pred_opt",  "conslist",    
  "tconscomma",    "tcons",         "idxlist",       "defer_subclause_opt",
  "resolvetype",   "orconf",        "raisetype",     "ifexists",    
  "select_stmt",   "with",          "selectnowith",  "oneselect",   
  "multiselect_op",  "values",        "distinct",      "selcollist",  
  "from",          "where_opt",     "groupby_opt",   "having_opt",  
  "orderby_opt",   "limit_opt",     "nexprlist",     "exprlist",    
  "sclp",          "as",            "joinsrc",       "singlesrc",   
  "seltablist",    "joinop",        "joinconstr_opt",  "dbnm",        
  "indexed_opt",   "idlist",        "sortlist",      "delete_stmt", 
  "update_stmt",   "setlist",       "idlist_opt",    "insert_stmt", 
  "insert_cmd",    "upsert",        "exprx",         "not_opt",     
  "case_operand",  "case_exprlist",  "case_else",     "likeop",      
  "uniqueflag",    "idxlist_single",  "collate",       "nmnum",       
  "number",        "trigger_time",  "trigger_event",  "foreach_clause",
  "when_clause",   "trigger_cmd_list",  "trigger_cmd",   "database_kw_opt",
  "key_opt",       "kwcolumn_opt",  "create_vtab",   "vtabarglist", 
  "vtabarg",       "vtabargtoken",  "anylist",       "wqlist",      
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   8 */ "cmdx ::= cmd",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "trans_opt ::= TRANSACTION ID_TRANS",
 /*  14 */ "transtype ::=",
 /*  15 */ "transtype ::= DEFERRED",
 /*  16 */ "transtype ::= IMMEDIATE",
 /*  17 */ "transtype ::= EXCLUSIVE",
 /*  18 */ "cmd ::= COMMIT trans_opt",
 /*  19 */ "cmd ::= END trans_opt",
 /*  20 */ "cmd ::= ROLLBACK trans_opt",
 /*  21 */ "savepoint_opt ::= SAVEPOINT",
 /*  22 */ "savepoint_opt ::=",
 /*  23 */ "cmd ::= SAVEPOINT nm",
 /*  24 */ "cmd ::= RELEASE savepoint_opt nm",
 /*  25 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt nm",
 /*  26 */ "cmd ::= SAVEPOINT ID_TRANS",
 /*  27 */ "cmd ::= RELEASE savepoint_opt ID_TRANS",
 /*  28 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS",
 /*  29 */ "cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options",
 /*  30 */ "cmd ::= CREATE temp TABLE ifnotexists fullname AS select",
 /*  31 */ "cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW",
 /*  32 */ "cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /*  33 */ "table_options ::=",
 /*  34 */ "table_options ::= WITHOUT nm",
 /*  35 */ "table_options ::= WITHOUT CTX_ROWID_KW",
 /*  36 */ "ifnotexists ::=",
 /*  37 */ "ifnotexists ::= IF NOT EXISTS",
 /*  38 */ "temp ::= TEMP",
 /*  39 */ "temp ::=",
 /*  40 */ "columnlist ::= columnlist COMMA column",
 /*  41 */ "columnlist ::= column",
 /*  42 */ "column ::= columnid type carglist",
 /*  43 */ "columnid ::= nm",
 /*  44 */ "columnid ::= ID_COL_NEW",
 /*  45 */ "id ::= ID",
 /*  46 */ "ids ::= ID|STRING",
 /*  47 */ "nm ::= id",
 /*  48 */ "nm ::= STRING",
 /*  49 */ "nm ::= JOIN_KW",
 /*  50 */ "type ::=",
 /*  51 */ "type ::= typetoken",
 /*  52 */ "typetoken ::= typename",
 /*  53 */ "typetoken ::= typename LP signed RP",
 /*  54 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  55 */ "typename ::= ids",
 /*  56 */ "typename ::= typename ids",
 /*  57 */ "typename ::= ID_COL_TYPE",
 /*  58 */ "signed ::= plus_num",
 /*  59 */ "signed ::= minus_num",
 /*  60 */ "carglist ::= carglist ccons",
 /*  61 */ "carglist ::=",
 /*  62 */ "ccons ::= CONSTRAINT nm",
 /*  63 */ "ccons ::= DEFAULT term",
 /*  64 */ "ccons ::= DEFAULT LP expr RP",
 /*  65 */ "ccons ::= DEFAULT PLUS term",
 /*  66 */ "ccons ::= DEFAULT MINUS term",
 /*  67 */ "ccons ::= DEFAULT id",
 /*  68 */ "ccons ::= DEFAULT CTIME_KW",
 /*  69 */ "ccons ::= NULL onconf",
 /*  70 */ "ccons ::= NOT NULL onconf",
 /*  71 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  72 */ "ccons ::= UNIQUE onconf",
 /*  73 */ "ccons ::= CHECK LP expr RP",
 /*  74 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  75 */ "ccons ::= defer_subclause",
 /*  76 */ "ccons ::= COLLATE ids",
 /*  77 */ "ccons ::= CONSTRAINT ID_CONSTR",
 /*  78 */ "ccons ::= COLLATE ID_COLLATE",
 /*  79 */ "ccons ::= REFERENCES ID_TAB",
 /*  80 */ "ccons ::= CHECK LP RP",
 /*  81 */ "term ::= NULL",
 /*  82 */ "term ::= INTEGER",
 /*  83 */ "term ::= FLOAT",
 /*  84 */ "term ::= STRING|BLOB",
 /*  85 */ "autoinc ::=",
 /*  86 */ "autoinc ::= AUTOINCR",
 /*  87 */ "refargs ::=",
 /*  88 */ "refargs ::= refargs refarg",
 /*  89 */ "refarg ::= MATCH nm",
 /*  90 */ "refarg ::= ON INSERT refact",
 /*  91 */ "refarg ::= ON DELETE refact",
 /*  92 */ "refarg ::= ON UPDATE refact",
 /*  93 */ "refarg ::= MATCH ID_FK_MATCH",
 /*  94 */ "refact ::= SET NULL",
 /*  95 */ "refact ::= SET DEFAULT",
 /*  96 */ "refact ::= CASCADE",
 /*  97 */ "refact ::= RESTRICT",
 /*  98 */ "refact ::= NO ACTION",
 /*  99 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /* 100 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /* 101 */ "init_deferred_pred_opt ::=",
 /* 102 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /* 103 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /* 104 */ "conslist_opt ::=",
 /* 105 */ "conslist_opt ::= COMMA conslist",
 /* 106 */ "conslist ::= conslist tconscomma tcons",
 /* 107 */ "conslist ::= tcons",
 /* 108 */ "tconscomma ::= COMMA",
 /* 109 */ "tconscomma ::=",
 /* 110 */ "tcons ::= CONSTRAINT nm",
 /* 111 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /* 112 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /* 113 */ "tcons ::= CHECK LP expr RP onconf",
 /* 114 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /* 115 */ "tcons ::= CONSTRAINT ID_CONSTR",
 /* 116 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB",
 /* 117 */ "tcons ::= CHECK LP RP onconf",
 /* 118 */ "defer_subclause_opt ::=",
 /* 119 */ "defer_subclause_opt ::= defer_subclause",
 /* 120 */ "onconf ::=",
 /* 121 */ "onconf ::= ON CONFLICT resolvetype",
 /* 122 */ "orconf ::=",
 /* 123 */ "orconf ::= OR resolvetype",
 /* 124 */ "resolvetype ::= raisetype",
 /* 125 */ "resolvetype ::= IGNORE",
 /* 126 */ "resolvetype ::= REPLACE",
 /* 127 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 128 */ "cmd ::= DROP TABLE ifexists nm DOT ID_TAB",
 /* 129 */ "cmd ::= DROP TABLE ifexists ID_DB|ID_TAB",
 /* 130 */ "ifexists ::= IF EXISTS",
 /* 131 */ "ifexists ::=",
 /* 132 */ "cmd ::= CREATE temp VIEW ifnotexists fullname idxlist_opt AS select",
 /* 133 */ "cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW",
 /* 134 */ "cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW",
 /* 135 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 136 */ "cmd ::= DROP VIEW ifexists nm DOT ID_VIEW",
 /* 137 */ "cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW",
 /* 138 */ "cmd ::= select_stmt",
 /* 139 */ "select_stmt ::= select",
 /* 140 */ "select ::= with selectnowith",
 /* 141 */ "selectnowith ::= oneselect",
 /* 142 */ "selectnowith ::= selectnowith multiselect_op oneselect",
 /* 143 */ "selectnowith ::= values",
 /* 144 */ "selectnowith ::= selectnowith COMMA values",
 /* 145 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 146 */ "values ::= VALUES LP nexprlist RP",
 /* 147 */ "values ::= values COMMA LP exprlist RP",
 /* 148 */ "multiselect_op ::= UNION",
 /* 149 */ "multiselect_op ::= UNION ALL",
 /* 150 */ "multiselect_op ::= EXCEPT",
 /* 151 */ "multiselect_op ::= INTERSECT",
 /* 152 */ "distinct ::= DISTINCT",
 /* 153 */ "distinct ::= ALL",
 /* 154 */ "distinct ::=",
 /* 155 */ "sclp ::= selcollist COMMA",
 /* 156 */ "sclp ::=",
 /* 157 */ "selcollist ::= sclp expr as",
 /* 158 */ "selcollist ::= sclp STAR",
 /* 159 */ "selcollist ::= sclp nm DOT STAR",
 /* 160 */ "selcollist ::= sclp",
 /* 161 */ "selcollist ::= sclp ID_TAB DOT STAR",
 /* 162 */ "as ::= AS nm",
 /* 163 */ "as ::= ids",
 /* 164 */ "as ::= AS ID_ALIAS",
 /* 165 */ "as ::= ID_ALIAS",
 /* 166 */ "as ::=",
 /* 167 */ "from ::=",
 /* 168 */ "from ::= FROM joinsrc",
 /* 169 */ "joinsrc ::= singlesrc seltablist",
 /* 170 */ "joinsrc ::=",
 /* 171 */ "seltablist ::= seltablist joinop singlesrc joinconstr_opt",
 /* 172 */ "seltablist ::=",
 /* 173 */ "singlesrc ::= nm dbnm as indexed_opt",
 /* 174 */ "singlesrc ::= LP select RP as",
 /* 175 */ "singlesrc ::= LP joinsrc RP as",
 /* 176 */ "singlesrc ::= nm dbnm LP exprlist RP as",
 /* 177 */ "singlesrc ::=",
 /* 178 */ "singlesrc ::= nm DOT",
 /* 179 */ "singlesrc ::= nm DOT ID_TAB",
 /* 180 */ "singlesrc ::= ID_DB|ID_TAB",
 /* 181 */ "singlesrc ::= nm DOT ID_VIEW",
 /* 182 */ "singlesrc ::= ID_DB|ID_VIEW",
 /* 183 */ "joinconstr_opt ::= ON expr",
 /* 184 */ "joinconstr_opt ::= USING LP idlist RP",
 /* 185 */ "joinconstr_opt ::=",
 /* 186 */ "dbnm ::=",
 /* 187 */ "dbnm ::= DOT nm",
 /* 188 */ "fullname ::= nm dbnm",
 /* 189 */ "joinop ::= COMMA",
 /* 190 */ "joinop ::= JOIN",
 /* 191 */ "joinop ::= JOIN_KW JOIN",
 /* 192 */ "joinop ::= JOIN_KW nm JOIN",
 /* 193 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 194 */ "joinop ::= ID_JOIN_OPTS",
 /* 195 */ "indexed_opt ::=",
 /* 196 */ "indexed_opt ::= INDEXED BY nm",
 /* 197 */ "indexed_opt ::= NOT INDEXED",
 /* 198 */ "indexed_opt ::= INDEXED BY ID_IDX",
 /* 199 */ "orderby_opt ::=",
 /* 200 */ "orderby_opt ::= ORDER BY sortlist",
 /* 201 */ "sortlist ::= sortlist COMMA expr sortorder",
 /* 202 */ "sortlist ::= expr sortorder",
 /* 203 */ "sortorder ::= ASC",
 /* 204 */ "sortorder ::= DESC",
 /* 205 */ "sortorder ::=",
 /* 206 */ "groupby_opt ::=",
 /* 207 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 208 */ "groupby_opt ::= GROUP BY",
 /* 209 */ "having_opt ::=",
 /* 210 */ "having_opt ::= HAVING expr",
 /* 211 */ "limit_opt ::=",
 /* 212 */ "limit_opt ::= LIMIT expr",
 /* 213 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 214 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 215 */ "cmd ::= delete_stmt",
 /* 216 */ "delete_stmt ::= with DELETE FROM fullname indexed_opt where_opt",
 /* 217 */ "delete_stmt ::= with DELETE FROM",
 /* 218 */ "delete_stmt ::= with DELETE FROM nm DOT",
 /* 219 */ "delete_stmt ::= with DELETE FROM nm DOT ID_TAB",
 /* 220 */ "delete_stmt ::= with DELETE FROM ID_DB|ID_TAB",
 /* 221 */ "where_opt ::=",
 /* 222 */ "where_opt ::= WHERE expr",
 /* 223 */ "where_opt ::= WHERE",
 /* 224 */ "cmd ::= update_stmt",
 /* 225 */ "update_stmt ::= with UPDATE orconf fullname indexed_opt SET setlist where_opt",
 /* 226 */ "update_stmt ::= with UPDATE orconf",
 /* 227 */ "update_stmt ::= with UPDATE orconf nm DOT",
 /* 228 */ "update_stmt ::= with UPDATE orconf nm DOT ID_TAB",
 /* 229 */ "update_stmt ::= with UPDATE orconf ID_DB|ID_TAB",
 /* 230 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 231 */ "setlist ::= setlist COMMA LP idlist RP EQ expr",
 /* 232 */ "setlist ::= nm EQ expr",
 /* 233 */ "setlist ::= LP idlist RP EQ expr",
 /* 234 */ "setlist ::=",
 /* 235 */ "setlist ::= setlist COMMA",
 /* 236 */ "setlist ::= setlist COMMA ID_COL",
 /* 237 */ "setlist ::= ID_COL",
 /* 238 */ "idlist_opt ::=",
 /* 239 */ "idlist_opt ::= LP idlist RP",
 /* 240 */ "idlist ::= idlist COMMA nm",
 /* 241 */ "idlist ::= nm",
 /* 242 */ "idlist ::=",
 /* 243 */ "idlist ::= idlist COMMA ID_COL",
 /* 244 */ "idlist ::= ID_COL",
 /* 245 */ "cmd ::= insert_stmt",
 /* 246 */ "insert_stmt ::= with insert_cmd INTO fullname idlist_opt select upsert",
 /* 247 */ "insert_stmt ::= with insert_cmd INTO fullname idlist_opt DEFAULT VALUES",
 /* 248 */ "insert_stmt ::= with insert_cmd INTO",
 /* 249 */ "insert_stmt ::= with insert_cmd INTO nm DOT",
 /* 250 */ "insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB",
 /* 251 */ "insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB",
 /* 252 */ "insert_cmd ::= INSERT orconf",
 /* 253 */ "insert_cmd ::= REPLACE",
 /* 254 */ "upsert ::=",
 /* 255 */ "upsert ::= ON CONFLICT LP sortlist RP where_opt DO UPDATE SET setlist where_opt",
 /* 256 */ "upsert ::= ON CONFLICT LP sortlist RP where_opt DO NOTHING",
 /* 257 */ "upsert ::= ON CONFLICT DO NOTHING",
 /* 258 */ "exprx ::= nm DOT",
 /* 259 */ "exprx ::= nm DOT nm DOT",
 /* 260 */ "exprx ::= expr not_opt BETWEEN expr AND",
 /* 261 */ "exprx ::= CASE case_operand case_exprlist case_else",
 /* 262 */ "exprx ::= expr not_opt IN LP exprlist",
 /* 263 */ "exprx ::= expr not_opt IN ID_DB",
 /* 264 */ "exprx ::= expr not_opt IN nm DOT ID_TAB",
 /* 265 */ "exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN",
 /* 266 */ "exprx ::= nm DOT ID_TAB|ID_COL",
 /* 267 */ "exprx ::= nm DOT nm DOT ID_COL",
 /* 268 */ "exprx ::= expr COLLATE ID_COLLATE",
 /* 269 */ "exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP",
 /* 270 */ "exprx ::= term",
 /* 271 */ "exprx ::= CTIME_KW",
 /* 272 */ "exprx ::= LP nexprlist RP",
 /* 273 */ "exprx ::= id",
 /* 274 */ "exprx ::= JOIN_KW",
 /* 275 */ "exprx ::= nm DOT nm",
 /* 276 */ "exprx ::= nm DOT nm DOT nm",
 /* 277 */ "exprx ::= VARIABLE",
 /* 278 */ "exprx ::= expr COLLATE ids",
 /* 279 */ "exprx ::= CAST LP expr AS typetoken RP",
 /* 280 */ "exprx ::= ID LP distinct exprlist RP",
 /* 281 */ "exprx ::= ID LP STAR RP",
 /* 282 */ "exprx ::= expr AND expr",
 /* 283 */ "exprx ::= expr OR expr",
 /* 284 */ "exprx ::= expr LT|GT|GE|LE expr",
 /* 285 */ "exprx ::= expr EQ|NE expr",
 /* 286 */ "exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 287 */ "exprx ::= expr PLUS|MINUS expr",
 /* 288 */ "exprx ::= expr STAR|SLASH|REM expr",
 /* 289 */ "exprx ::= expr CONCAT expr",
 /* 290 */ "exprx ::= expr not_opt likeop expr",
 /* 291 */ "exprx ::= expr not_opt likeop expr ESCAPE expr",
 /* 292 */ "exprx ::= expr ISNULL|NOTNULL",
 /* 293 */ "exprx ::= expr NOT NULL",
 /* 294 */ "exprx ::= expr IS not_opt expr",
 /* 295 */ "exprx ::= NOT expr",
 /* 296 */ "exprx ::= BITNOT expr",
 /* 297 */ "exprx ::= MINUS expr",
 /* 298 */ "exprx ::= PLUS expr",
 /* 299 */ "exprx ::= expr not_opt BETWEEN expr AND expr",
 /* 300 */ "exprx ::= expr not_opt IN LP exprlist RP",
 /* 301 */ "exprx ::= LP select RP",
 /* 302 */ "exprx ::= expr not_opt IN LP select RP",
 /* 303 */ "exprx ::= expr not_opt IN nm dbnm",
 /* 304 */ "exprx ::= EXISTS LP select RP",
 /* 305 */ "exprx ::= CASE case_operand case_exprlist case_else END",
 /* 306 */ "exprx ::= RAISE LP IGNORE RP",
 /* 307 */ "exprx ::= RAISE LP raisetype COMMA nm RP",
 /* 308 */ "expr ::=",
 /* 309 */ "expr ::= exprx",
 /* 310 */ "not_opt ::=",
 /* 311 */ "not_opt ::= NOT",
 /* 312 */ "likeop ::= LIKE_KW|MATCH",
 /* 313 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 314 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 315 */ "case_else ::= ELSE expr",
 /* 316 */ "case_else ::=",
 /* 317 */ "case_operand ::= exprx",
 /* 318 */ "case_operand ::=",
 /* 319 */ "exprlist ::= nexprlist",
 /* 320 */ "exprlist ::=",
 /* 321 */ "nexprlist ::= nexprlist COMMA expr",
 /* 322 */ "nexprlist ::= exprx",
 /* 323 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP sortlist RP where_opt",
 /* 324 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB",
 /* 325 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW",
 /* 326 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW",
 /* 327 */ "uniqueflag ::= UNIQUE",
 /* 328 */ "uniqueflag ::=",
 /* 329 */ "idxlist_opt ::=",
 /* 330 */ "idxlist_opt ::= LP idxlist RP",
 /* 331 */ "idxlist ::= idxlist COMMA idxlist_single",
 /* 332 */ "idxlist ::= idxlist_single",
 /* 333 */ "idxlist_single ::= nm collate sortorder",
 /* 334 */ "idxlist_single ::= ID_COL",
 /* 335 */ "collate ::=",
 /* 336 */ "collate ::= COLLATE ids",
 /* 337 */ "collate ::= COLLATE ID_COLLATE",
 /* 338 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 339 */ "cmd ::= DROP INDEX ifexists nm DOT ID_IDX",
 /* 340 */ "cmd ::= DROP INDEX ifexists ID_DB|ID_IDX",
 /* 341 */ "cmd ::= VACUUM",
 /* 342 */ "cmd ::= VACUUM nm",
 /* 343 */ "cmd ::= PRAGMA nm dbnm",
 /* 344 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 345 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 346 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 347 */ "cmd ::= PRAGMA nm dbnm LP minus_num RP",
 /* 348 */ "cmd ::= PRAGMA nm DOT ID_PRAGMA",
 /* 349 */ "cmd ::= PRAGMA ID_DB|ID_PRAGMA",
 /* 350 */ "nmnum ::= plus_num",
 /* 351 */ "nmnum ::= nm",
 /* 352 */ "nmnum ::= ON",
 /* 353 */ "nmnum ::= DELETE",
 /* 354 */ "nmnum ::= DEFAULT",
 /* 355 */ "plus_num ::= PLUS number",
 /* 356 */ "plus_num ::= number",
 /* 357 */ "minus_num ::= MINUS number",
 /* 358 */ "number ::= INTEGER",
 /* 359 */ "number ::= FLOAT",
 /* 360 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END",
 /* 361 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause",
 /* 362 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list",
 /* 363 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB",
 /* 364 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW",
 /* 365 */ "cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW",
 /* 366 */ "trigger_time ::= BEFORE",
 /* 367 */ "trigger_time ::= AFTER",
 /* 368 */ "trigger_time ::= INSTEAD OF",
 /* 369 */ "trigger_time ::=",
 /* 370 */ "trigger_event ::= DELETE",
 /* 371 */ "trigger_event ::= INSERT",
 /* 372 */ "trigger_event ::= UPDATE",
 /* 373 */ "trigger_event ::= UPDATE OF idlist",
 /* 374 */ "foreach_clause ::=",
 /* 375 */ "foreach_clause ::= FOR EACH ROW",
 /* 376 */ "when_clause ::=",
 /* 377 */ "when_clause ::= WHEN expr",
 /* 378 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 379 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 380 */ "trigger_cmd_list ::= SEMI",
 /* 381 */ "trigger_cmd ::= update_stmt",
 /* 382 */ "trigger_cmd ::= insert_stmt",
 /* 383 */ "trigger_cmd ::= delete_stmt",
 /* 384 */ "trigger_cmd ::= select_stmt",
 /* 385 */ "raisetype ::= ROLLBACK|ABORT|FAIL",
 /* 386 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 387 */ "cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG",
 /* 388 */ "cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG",
 /* 389 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 390 */ "cmd ::= DETACH database_kw_opt expr",
 /* 391 */ "key_opt ::=",
 /* 392 */ "key_opt ::= KEY expr",
 /* 393 */ "database_kw_opt ::= DATABASE",
 /* 394 */ "database_kw_opt ::=",
 /* 395 */ "cmd ::= REINDEX",
 /* 396 */ "cmd ::= REINDEX nm dbnm",
 /* 397 */ "cmd ::= REINDEX ID_COLLATE",
 /* 398 */ "cmd ::= REINDEX nm DOT ID_TAB|ID_IDX",
 /* 399 */ "cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB",
 /* 400 */ "cmd ::= ANALYZE",
 /* 401 */ "cmd ::= ANALYZE nm dbnm",
 /* 402 */ "cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX",
 /* 403 */ "cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB",
 /* 404 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 405 */ "cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column",
 /* 406 */ "cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW",
 /* 407 */ "cmd ::= ALTER TABLE nm DOT ID_TAB",
 /* 408 */ "cmd ::= ALTER TABLE ID_DB|ID_TAB",
 /* 409 */ "kwcolumn_opt ::=",
 /* 410 */ "kwcolumn_opt ::= COLUMNKW",
 /* 411 */ "cmd ::= create_vtab",
 /* 412 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm",
 /* 413 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP",
 /* 414 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW",
 /* 415 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /* 416 */ "vtabarglist ::= vtabarg",
 /* 417 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 418 */ "vtabarg ::=",
 /* 419 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 420 */ "vtabargtoken ::= ANY",
 /* 421 */ "vtabargtoken ::= LP anylist RP",
 /* 422 */ "anylist ::=",
 /* 423 */ "anylist ::= anylist LP anylist RP",
 /* 424 */ "anylist ::= anylist ANY",
 /* 425 */ "with ::=",
 /* 426 */ "with ::= WITH wqlist",
 /* 427 */ "with ::= WITH RECURSIVE wqlist",
 /* 428 */ "wqlist ::= nm idxlist_opt AS LP select RP",
 /* 429 */ "wqlist ::= wqlist COMMA nm idxlist_opt AS LP select RP",
 /* 430 */ "wqlist ::= ID_TAB_NEW",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3_parse and sqlite3_parseFree.
*/
void *sqlite3_parseAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3_parseARG_FETCH;
  if (parserContext->executeRules)
  {
      switch( yymajor ){
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
    case 171: /* cmd */
    case 174: /* ecmd */
    case 176: /* cmdx */
    case 220: /* select_stmt */
    case 247: /* delete_stmt */
    case 248: /* update_stmt */
    case 251: /* insert_stmt */
    case 270: /* trigger_cmd */
    case 274: /* create_vtab */
{
delete (yypminor->yy283);
}
      break;
    case 175: /* explain */
{
delete (yypminor->yy411);
}
      break;
    case 177: /* transtype */
    case 178: /* trans_opt */
{
delete (yypminor->yy404);
}
      break;
    case 179: /* nm */
    case 186: /* table_options */
    case 189: /* columnid */
    case 192: /* id */
    case 193: /* ids */
    case 195: /* typename */
    case 243: /* dbnm */
    case 262: /* collate */
    case 276: /* vtabarg */
    case 277: /* vtabargtoken */
    case 278: /* anylist */
{
delete (yypminor->yy399);
}
      break;
    case 180: /* savepoint_opt */
    case 182: /* ifnotexists */
    case 204: /* autoinc */
    case 212: /* tconscomma */
    case 219: /* ifexists */
    case 255: /* not_opt */
    case 260: /* uniqueflag */
    case 271: /* database_kw_opt */
    case 273: /* kwcolumn_opt */
{
delete (yypminor->yy451);
}
      break;
    case 181: /* temp */
    case 226: /* distinct */
{
delete (yypminor->yy146);
}
      break;
    case 183: /* fullname */
{
delete (yypminor->yy360);
}
      break;
    case 184: /* columnlist */
{
delete (yypminor->yy202);
}
      break;
    case 185: /* conslist_opt */
    case 211: /* conslist */
{
delete (yypminor->yy333);
}
      break;
    case 187: /* select */
    case 222: /* selectnowith */
{
delete (yypminor->yy473);
}
      break;
    case 188: /* column */
{
delete (yypminor->yy227);
}
      break;
    case 190: /* type */
    case 194: /* typetoken */
{
delete (yypminor->yy537);
}
      break;
    case 191: /* carglist */
{
delete (yypminor->yy51);
}
      break;
    case 196: /* signed */
    case 197: /* plus_num */
    case 198: /* minus_num */
    case 200: /* term */
    case 263: /* nmnum */
    case 264: /* number */
{
delete (yypminor->yy469);
}
      break;
    case 199: /* ccons */
{
delete (yypminor->yy304);
}
      break;
    case 201: /* expr */
    case 229: /* where_opt */
    case 231: /* having_opt */
    case 254: /* exprx */
    case 256: /* case_operand */
    case 258: /* case_else */
{
delete (yypminor->yy352);
}
      break;
    case 202: /* onconf */
    case 216: /* resolvetype */
    case 217: /* orconf */
{
delete (yypminor->yy338);
}
      break;
    case 203: /* sortorder */
{
delete (yypminor->yy309);
}
      break;
    case 205: /* idxlist_opt */
    case 214: /* idxlist */
{
delete (yypminor->yy223);
}
      break;
    case 206: /* refargs */
{
delete (yypminor->yy184);
}
      break;
    case 207: /* defer_subclause */
    case 215: /* defer_subclause_opt */
{
delete (yypminor->yy329);
}
      break;
    case 208: /* refarg */
{
delete (yypminor->yy347);
}
      break;
    case 209: /* refact */
{
delete (yypminor->yy104);
}
      break;
    case 210: /* init_deferred_pred_opt */
{
delete (yypminor->yy392);
}
      break;
    case 213: /* tcons */
{
delete (yypminor->yy406);
}
      break;
    case 221: /* with */
    case 279: /* wqlist */
{
delete (yypminor->yy321);
}
      break;
    case 223: /* oneselect */
{
delete (yypminor->yy310);
}
      break;
    case 224: /* multiselect_op */
{
delete (yypminor->yy462);
}
      break;
    case 225: /* values */
{
delete (yypminor->yy166);
}
      break;
    case 227: /* selcollist */
    case 236: /* sclp */
{
delete (yypminor->yy373);
}
      break;
    case 228: /* from */
    case 238: /* joinsrc */
{
delete (yypminor->yy511);
}
      break;
    case 230: /* groupby_opt */
    case 234: /* nexprlist */
    case 235: /* exprlist */
    case 257: /* case_exprlist */
{
delete (yypminor->yy551);
}
      break;
    case 232: /* orderby_opt */
    case 246: /* sortlist */
{
delete (yypminor->yy163);
}
      break;
    case 233: /* limit_opt */
{
delete (yypminor->yy484);
}
      break;
    case 237: /* as */
{
delete (yypminor->yy200);
}
      break;
    case 239: /* singlesrc */
{
delete (yypminor->yy201);
}
      break;
    case 240: /* seltablist */
{
delete (yypminor->yy131);
}
      break;
    case 241: /* joinop */
{
delete (yypminor->yy301);
}
      break;
    case 242: /* joinconstr_opt */
{
delete (yypminor->yy295);
}
      break;
    case 244: /* indexed_opt */
{
delete (yypminor->yy192);
}
      break;
    case 245: /* idlist */
    case 250: /* idlist_opt */
    case 275: /* vtabarglist */
{
delete (yypminor->yy95);
}
      break;
    case 249: /* setlist */
{
delete (yypminor->yy521);
}
      break;
    case 252: /* insert_cmd */
{
delete (yypminor->yy105);
}
      break;
    case 253: /* upsert */
{
delete (yypminor->yy560);
}
      break;
    case 259: /* likeop */
{
delete (yypminor->yy520);
}
      break;
    case 261: /* idxlist_single */
{
delete (yypminor->yy108);
}
      break;
    case 265: /* trigger_time */
{
delete (yypminor->yy132);
}
      break;
    case 266: /* trigger_event */
{
delete (yypminor->yy552);
}
      break;
    case 267: /* foreach_clause */
{
delete (yypminor->yy3);
}
      break;
    case 268: /* when_clause */
    case 272: /* key_opt */
{
if ((yypminor->yy352)) delete (yypminor->yy352);
}
      break;
    case 269: /* trigger_cmd_list */
{
delete (yypminor->yy430);
}
      break;
        default:  break;   /* If no destructor action specified: do nothing */
      }
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  /* There is no mechanism by which the parser stack can be popped below
  ** empty in SQLite.  */
  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  delete yytos->tokens;
  yytos->tokens = nullptr;
  pParser->yyidx--;
  return yymajor;
}

/*
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3_parseAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3_parseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  /* In SQLite, we never try to destroy a parser that was not successfully
  ** created in the first place. */
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3_parseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
  GET_CONTEXT;

  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0
             && parserContext->doFallbacks ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if(
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3_parseARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */

    UNUSED_PARAMETER(yypMinor);
    parserContext->error(QObject::tr("Parser stack overflow"));
   sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
  yytos->tokens = new QList<Token*>();
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 172, 1 },
  { 173, 2 },
  { 173, 1 },
  { 174, 1 },
  { 174, 3 },
  { 175, 0 },
  { 175, 1 },
  { 175, 3 },
  { 176, 1 },
  { 171, 3 },
  { 178, 0 },
  { 178, 1 },
  { 178, 2 },
  { 178, 2 },
  { 177, 0 },
  { 177, 1 },
  { 177, 1 },
  { 177, 1 },
  { 171, 2 },
  { 171, 2 },
  { 171, 2 },
  { 180, 1 },
  { 180, 0 },
  { 171, 2 },
  { 171, 3 },
  { 171, 5 },
  { 171, 2 },
  { 171, 3 },
  { 171, 5 },
  { 171, 10 },
  { 171, 7 },
  { 171, 7 },
  { 171, 5 },
  { 186, 0 },
  { 186, 2 },
  { 186, 2 },
  { 182, 0 },
  { 182, 3 },
  { 181, 1 },
  { 181, 0 },
  { 184, 3 },
  { 184, 1 },
  { 188, 3 },
  { 189, 1 },
  { 189, 1 },
  { 192, 1 },
  { 193, 1 },
  { 179, 1 },
  { 179, 1 },
  { 179, 1 },
  { 190, 0 },
  { 190, 1 },
  { 194, 1 },
  { 194, 4 },
  { 194, 6 },
  { 195, 1 },
  { 195, 2 },
  { 195, 1 },
  { 196, 1 },
  { 196, 1 },
  { 191, 2 },
  { 191, 0 },
  { 199, 2 },
  { 199, 2 },
  { 199, 4 },
  { 199, 3 },
  { 199, 3 },
  { 199, 2 },
  { 199, 2 },
  { 199, 2 },
  { 199, 3 },
  { 199, 5 },
  { 199, 2 },
  { 199, 4 },
  { 199, 4 },
  { 199, 1 },
  { 199, 2 },
  { 199, 2 },
  { 199, 2 },
  { 199, 2 },
  { 199, 3 },
  { 200, 1 },
  { 200, 1 },
  { 200, 1 },
  { 200, 1 },
  { 204, 0 },
  { 204, 1 },
  { 206, 0 },
  { 206, 2 },
  { 208, 2 },
  { 208, 3 },
  { 208, 3 },
  { 208, 3 },
  { 208, 2 },
  { 209, 2 },
  { 209, 2 },
  { 209, 1 },
  { 209, 1 },
  { 209, 2 },
  { 207, 3 },
  { 207, 2 },
  { 210, 0 },
  { 210, 2 },
  { 210, 2 },
  { 185, 0 },
  { 185, 2 },
  { 211, 3 },
  { 211, 1 },
  { 212, 1 },
  { 212, 0 },
  { 213, 2 },
  { 213, 7 },
  { 213, 5 },
  { 213, 5 },
  { 213, 10 },
  { 213, 2 },
  { 213, 7 },
  { 213, 4 },
  { 215, 0 },
  { 215, 1 },
  { 202, 0 },
  { 202, 3 },
  { 217, 0 },
  { 217, 2 },
  { 216, 1 },
  { 216, 1 },
  { 216, 1 },
  { 171, 4 },
  { 171, 6 },
  { 171, 4 },
  { 219, 2 },
  { 219, 0 },
  { 171, 8 },
  { 171, 7 },
  { 171, 5 },
  { 171, 4 },
  { 171, 6 },
  { 171, 4 },
  { 171, 1 },
  { 220, 1 },
  { 187, 2 },
  { 222, 1 },
  { 222, 3 },
  { 222, 1 },
  { 222, 3 },
  { 223, 9 },
  { 225, 4 },
  { 225, 5 },
  { 224, 1 },
  { 224, 2 },
  { 224, 1 },
  { 224, 1 },
  { 226, 1 },
  { 226, 1 },
  { 226, 0 },
  { 236, 2 },
  { 236, 0 },
  { 227, 3 },
  { 227, 2 },
  { 227, 4 },
  { 227, 1 },
  { 227, 4 },
  { 237, 2 },
  { 237, 1 },
  { 237, 2 },
  { 237, 1 },
  { 237, 0 },
  { 228, 0 },
  { 228, 2 },
  { 238, 2 },
  { 238, 0 },
  { 240, 4 },
  { 240, 0 },
  { 239, 4 },
  { 239, 4 },
  { 239, 4 },
  { 239, 6 },
  { 239, 0 },
  { 239, 2 },
  { 239, 3 },
  { 239, 1 },
  { 239, 3 },
  { 239, 1 },
  { 242, 2 },
  { 242, 4 },
  { 242, 0 },
  { 243, 0 },
  { 243, 2 },
  { 183, 2 },
  { 241, 1 },
  { 241, 1 },
  { 241, 2 },
  { 241, 3 },
  { 241, 4 },
  { 241, 1 },
  { 244, 0 },
  { 244, 3 },
  { 244, 2 },
  { 244, 3 },
  { 232, 0 },
  { 232, 3 },
  { 246, 4 },
  { 246, 2 },
  { 203, 1 },
  { 203, 1 },
  { 203, 0 },
  { 230, 0 },
  { 230, 3 },
  { 230, 2 },
  { 231, 0 },
  { 231, 2 },
  { 233, 0 },
  { 233, 2 },
  { 233, 4 },
  { 233, 4 },
  { 171, 1 },
  { 247, 6 },
  { 247, 3 },
  { 247, 5 },
  { 247, 6 },
  { 247, 4 },
  { 229, 0 },
  { 229, 2 },
  { 229, 1 },
  { 171, 1 },
  { 248, 8 },
  { 248, 3 },
  { 248, 5 },
  { 248, 6 },
  { 248, 4 },
  { 249, 5 },
  { 249, 7 },
  { 249, 3 },
  { 249, 5 },
  { 249, 0 },
  { 249, 2 },
  { 249, 3 },
  { 249, 1 },
  { 250, 0 },
  { 250, 3 },
  { 245, 3 },
  { 245, 1 },
  { 245, 0 },
  { 245, 3 },
  { 245, 1 },
  { 171, 1 },
  { 251, 7 },
  { 251, 7 },
  { 251, 3 },
  { 251, 5 },
  { 251, 4 },
  { 251, 6 },
  { 252, 2 },
  { 252, 1 },
  { 253, 0 },
  { 253, 11 },
  { 253, 8 },
  { 253, 4 },
  { 254, 2 },
  { 254, 4 },
  { 254, 5 },
  { 254, 4 },
  { 254, 5 },
  { 254, 4 },
  { 254, 6 },
  { 254, 1 },
  { 254, 3 },
  { 254, 5 },
  { 254, 3 },
  { 254, 6 },
  { 254, 1 },
  { 254, 1 },
  { 254, 3 },
  { 254, 1 },
  { 254, 1 },
  { 254, 3 },
  { 254, 5 },
  { 254, 1 },
  { 254, 3 },
  { 254, 6 },
  { 254, 5 },
  { 254, 4 },
  { 254, 3 },
  { 254, 3 },
  { 254, 3 },
  { 254, 3 },
  { 254, 3 },
  { 254, 3 },
  { 254, 3 },
  { 254, 3 },
  { 254, 4 },
  { 254, 6 },
  { 254, 2 },
  { 254, 3 },
  { 254, 4 },
  { 254, 2 },
  { 254, 2 },
  { 254, 2 },
  { 254, 2 },
  { 254, 6 },
  { 254, 6 },
  { 254, 3 },
  { 254, 6 },
  { 254, 5 },
  { 254, 4 },
  { 254, 5 },
  { 254, 4 },
  { 254, 6 },
  { 201, 0 },
  { 201, 1 },
  { 255, 0 },
  { 255, 1 },
  { 259, 1 },
  { 257, 5 },
  { 257, 4 },
  { 258, 2 },
  { 258, 0 },
  { 256, 1 },
  { 256, 0 },
  { 235, 1 },
  { 235, 0 },
  { 234, 3 },
  { 234, 1 },
  { 171, 12 },
  { 171, 8 },
  { 171, 7 },
  { 171, 5 },
  { 260, 1 },
  { 260, 0 },
  { 205, 0 },
  { 205, 3 },
  { 214, 3 },
  { 214, 1 },
  { 261, 3 },
  { 261, 1 },
  { 262, 0 },
  { 262, 2 },
  { 262, 2 },
  { 171, 4 },
  { 171, 6 },
  { 171, 4 },
  { 171, 1 },
  { 171, 2 },
  { 171, 3 },
  { 171, 5 },
  { 171, 6 },
  { 171, 5 },
  { 171, 6 },
  { 171, 4 },
  { 171, 2 },
  { 263, 1 },
  { 263, 1 },
  { 263, 1 },
  { 263, 1 },
  { 263, 1 },
  { 197, 2 },
  { 197, 1 },
  { 198, 2 },
  { 264, 1 },
  { 264, 1 },
  { 171, 15 },
  { 171, 12 },
  { 171, 14 },
  { 171, 10 },
  { 171, 7 },
  { 171, 5 },
  { 265, 1 },
  { 265, 1 },
  { 265, 2 },
  { 265, 0 },
  { 266, 1 },
  { 266, 1 },
  { 266, 1 },
  { 266, 3 },
  { 267, 0 },
  { 267, 3 },
  { 268, 0 },
  { 268, 2 },
  { 269, 3 },
  { 269, 2 },
  { 269, 1 },
  { 270, 1 },
  { 270, 1 },
  { 270, 1 },
  { 270, 1 },
  { 218, 1 },
  { 171, 4 },
  { 171, 6 },
  { 171, 4 },
  { 171, 6 },
  { 171, 3 },
  { 272, 0 },
  { 272, 2 },
  { 271, 1 },
  { 271, 0 },
  { 171, 1 },
  { 171, 3 },
  { 171, 2 },
  { 171, 4 },
  { 171, 2 },
  { 171, 1 },
  { 171, 3 },
  { 171, 4 },
  { 171, 2 },
  { 171, 6 },
  { 171, 6 },
  { 171, 6 },
  { 171, 5 },
  { 171, 3 },
  { 273, 0 },
  { 273, 1 },
  { 171, 1 },
  { 274, 8 },
  { 274, 11 },
  { 274, 7 },
  { 274, 5 },
  { 275, 1 },
  { 275, 3 },
  { 276, 0 },
  { 276, 2 },
  { 277, 1 },
  { 277, 3 },
  { 278, 0 },
  { 278, 4 },
  { 278, 2 },
  { 221, 0 },
  { 221, 2 },
  { 221, 3 },
  { 279, 6 },
  { 279, 8 },
  { 279, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3_parseARG_FETCH;
  SqliteStatement* objectForTokens = 0;
  QStringList noTokenInheritanceFields;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  if (parserContext->executeRules)
  {
      switch( yyruleno ){
      /* Beginning here are the reduction cases.  A typical example
      ** follows:
      **   case 0:
      **  #line <lineno> <grammarfile>
      **     { ... }           // User supplied code
      **  #line <lineno> <thisfile>
      **     break;
      */
      case 1: /* cmdlist ::= cmdlist ecmd */
{parserContext->addQuery(yymsp[0].minor.yy283); DONT_INHERIT_TOKENS("cmdlist");}
        break;
      case 2: /* cmdlist ::= ecmd */
{parserContext->addQuery(yymsp[0].minor.yy283);}
        break;
      case 3: /* ecmd ::= SEMI */
{yygotominor.yy283 = new SqliteEmptyQuery();}
        break;
      case 4: /* ecmd ::= explain cmdx SEMI */
{
                                                yygotominor.yy283 = yymsp[-1].minor.yy283;
                                                yygotominor.yy283->explain = yymsp[-2].minor.yy411->explain;
                                                yygotominor.yy283->queryPlan = yymsp[-2].minor.yy411->queryPlan;
                                                delete yymsp[-2].minor.yy411;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 5: /* explain ::= */
{yygotominor.yy411 = new ParserStubExplain(false, false);}
        break;
      case 6: /* explain ::= EXPLAIN */
{yygotominor.yy411 = new ParserStubExplain(true, false);}
        break;
      case 7: /* explain ::= EXPLAIN QUERY PLAN */
{yygotominor.yy411 = new ParserStubExplain(true, true);}
        break;
      case 8: /* cmdx ::= cmd */
      case 381: /* trigger_cmd ::= update_stmt */ yytestcase(yyruleno==381);
      case 382: /* trigger_cmd ::= insert_stmt */ yytestcase(yyruleno==382);
      case 383: /* trigger_cmd ::= delete_stmt */ yytestcase(yyruleno==383);
      case 384: /* trigger_cmd ::= select_stmt */ yytestcase(yyruleno==384);
      case 411: /* cmd ::= create_vtab */ yytestcase(yyruleno==411);
{yygotominor.yy283 = yymsp[0].minor.yy283;}
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
{
                                                yygotominor.yy283 = new SqliteBeginTrans(
                                                        yymsp[-1].minor.yy404->type,
                                                        yymsp[0].minor.yy404->transactionKw,
                                                        yymsp[0].minor.yy404->name
                                                    );
                                                delete yymsp[0].minor.yy404;
                                                delete yymsp[-1].minor.yy404;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 10: /* trans_opt ::= */
      case 14: /* transtype ::= */ yytestcase(yyruleno==14);
{yygotominor.yy404 = new ParserStubTransDetails();}
        break;
      case 11: /* trans_opt ::= TRANSACTION */
{
                                                yygotominor.yy404 = new ParserStubTransDetails();
                                                yygotominor.yy404->transactionKw = true;
                                            }
        break;
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 13: /* trans_opt ::= TRANSACTION ID_TRANS */ yytestcase(yyruleno==13);
{
                                                yygotominor.yy404 = new ParserStubTransDetails();
                                                yygotominor.yy404->transactionKw = true;
                                                yygotominor.yy404->name = *(yymsp[0].minor.yy399);
                                                delete yymsp[0].minor.yy399;
                                            }
        break;
      case 15: /* transtype ::= DEFERRED */
{
                                                yygotominor.yy404 = new ParserStubTransDetails();
                                                yygotominor.yy404->type = SqliteBeginTrans::Type::DEFERRED;
                                            }
        break;
      case 16: /* transtype ::= IMMEDIATE */
{
                                                yygotominor.yy404 = new ParserStubTransDetails();
                                                yygotominor.yy404->type = SqliteBeginTrans::Type::IMMEDIATE;
                                            }
        break;
      case 17: /* transtype ::= EXCLUSIVE */
{
                                                yygotominor.yy404 = new ParserStubTransDetails();
                                                yygotominor.yy404->type = SqliteBeginTrans::Type::EXCLUSIVE;
                                            }
        break;
      case 18: /* cmd ::= COMMIT trans_opt */
{
                                                yygotominor.yy283 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy404->transactionKw,
                                                        yymsp[0].minor.yy404->name,
                                                        false
                                                    );
                                                delete yymsp[0].minor.yy404;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 19: /* cmd ::= END trans_opt */
{
                                                yygotominor.yy283 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy404->transactionKw,
                                                        yymsp[0].minor.yy404->name,
                                                        true
                                                    );
                                                delete yymsp[0].minor.yy404;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 20: /* cmd ::= ROLLBACK trans_opt */
{
                                                yygotominor.yy283 = new SqliteRollback(
                                                        yymsp[0].minor.yy404->transactionKw,
                                                        yymsp[0].minor.yy404->name
                                                    );
                                                delete yymsp[0].minor.yy404;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 21: /* savepoint_opt ::= SAVEPOINT */
      case 37: /* ifnotexists ::= IF NOT EXISTS */ yytestcase(yyruleno==37);
      case 86: /* autoinc ::= AUTOINCR */ yytestcase(yyruleno==86);
      case 108: /* tconscomma ::= COMMA */ yytestcase(yyruleno==108);
      case 130: /* ifexists ::= IF EXISTS */ yytestcase(yyruleno==130);
      case 311: /* not_opt ::= NOT */ yytestcase(yyruleno==311);
      case 327: /* uniqueflag ::= UNIQUE */ yytestcase(yyruleno==327);
      case 393: /* database_kw_opt ::= DATABASE */ yytestcase(yyruleno==393);
      case 409: /* kwcolumn_opt ::= */ yytestcase(yyruleno==409);
{yygotominor.yy451 = new bool(true);}
        break;
      case 22: /* savepoint_opt ::= */
      case 36: /* ifnotexists ::= */ yytestcase(yyruleno==36);
      case 85: /* autoinc ::= */ yytestcase(yyruleno==85);
      case 109: /* tconscomma ::= */ yytestcase(yyruleno==109);
      case 131: /* ifexists ::= */ yytestcase(yyruleno==131);
      case 310: /* not_opt ::= */ yytestcase(yyruleno==310);
      case 328: /* uniqueflag ::= */ yytestcase(yyruleno==328);
      case 394: /* database_kw_opt ::= */ yytestcase(yyruleno==394);
      case 410: /* kwcolumn_opt ::= COLUMNKW */ yytestcase(yyruleno==410);
{yygotominor.yy451 = new bool(false);}
        break;
      case 23: /* cmd ::= SAVEPOINT nm */
{
                                                yygotominor.yy283 = new SqliteSavepoint(*(yymsp[0].minor.yy399));
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 24: /* cmd ::= RELEASE savepoint_opt nm */
{
                                                yygotominor.yy283 = new SqliteRelease(*(yymsp[-1].minor.yy451), *(yymsp[0].minor.yy399));
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt nm */
      case 26: /* cmd ::= SAVEPOINT ID_TRANS */ yytestcase(yyruleno==26);
{
                                                yygotominor.yy283 = new SqliteRollback(
                                                        yymsp[-3].minor.yy404->transactionKw,
                                                        *(yymsp[-1].minor.yy451),
                                                        *(yymsp[0].minor.yy399)
                                                    );
                                                delete yymsp[-1].minor.yy451;
                                                delete yymsp[-3].minor.yy404;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 27: /* cmd ::= RELEASE savepoint_opt ID_TRANS */
      case 28: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS */ yytestcase(yyruleno==28);
{  yy_destructor(yypParser,180,&yymsp[-1].minor);
}
        break;
      case 29: /* cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options */
{
                                                yygotominor.yy283 = new SqliteCreateTable(
                                                        *(yymsp[-6].minor.yy451),
                                                        *(yymsp[-8].minor.yy146),
                                                        yymsp[-5].minor.yy360->name1,
                                                        yymsp[-5].minor.yy360->name2,
                                                        *(yymsp[-3].minor.yy202),
                                                        *(yymsp[-2].minor.yy333),
                                                        *(yymsp[0].minor.yy399)
                                                    );
                                                delete yymsp[-6].minor.yy451;
                                                delete yymsp[-8].minor.yy146;
                                                delete yymsp[-3].minor.yy202;
                                                delete yymsp[-2].minor.yy333;
                                                delete yymsp[-5].minor.yy360;
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 30: /* cmd ::= CREATE temp TABLE ifnotexists fullname AS select */
{
                                                yygotominor.yy283 = new SqliteCreateTable(
                                                        *(yymsp[-3].minor.yy451),
                                                        *(yymsp[-5].minor.yy146),
                                                        yymsp[-2].minor.yy360->name1,
                                                        yymsp[-2].minor.yy360->name2,
                                                        yymsp[0].minor.yy473
                                                    );
                                                delete yymsp[-3].minor.yy451;
                                                delete yymsp[-5].minor.yy146;
                                                delete yymsp[-2].minor.yy360;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 31: /* cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW */
      case 133: /* cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW */ yytestcase(yyruleno==133);
      case 364: /* cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW */ yytestcase(yyruleno==364);
{  yy_destructor(yypParser,181,&yymsp[-5].minor);
  yy_destructor(yypParser,179,&yymsp[-2].minor);
}
        break;
      case 32: /* cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW */
      case 134: /* cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW */ yytestcase(yyruleno==134);
      case 365: /* cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW */ yytestcase(yyruleno==365);
{  yy_destructor(yypParser,181,&yymsp[-3].minor);
}
        break;
      case 33: /* table_options ::= */
      case 186: /* dbnm ::= */ yytestcase(yyruleno==186);
      case 335: /* collate ::= */ yytestcase(yyruleno==335);
      case 418: /* vtabarg ::= */ yytestcase(yyruleno==418);
      case 422: /* anylist ::= */ yytestcase(yyruleno==422);
{yygotominor.yy399 = new QString();}
        break;
      case 34: /* table_options ::= WITHOUT nm */
      case 35: /* table_options ::= WITHOUT CTX_ROWID_KW */ yytestcase(yyruleno==35);
{
                                                if (yymsp[0].minor.yy399->toLower() != "rowid")
                                                    parserContext->errorAtToken(QString("Invalid table option: %1").arg(*(yymsp[0].minor.yy399)));

                                                yygotominor.yy399 = yymsp[0].minor.yy399;
                                            }
        break;
      case 38: /* temp ::= TEMP */
{yygotominor.yy146 = new int( (yymsp[0].minor.yy0->value.length() > 4) ? 2 : 1 );}
        break;
      case 39: /* temp ::= */
      case 154: /* distinct ::= */ yytestcase(yyruleno==154);
{yygotominor.yy146 = new int(0);}
        break;
      case 40: /* columnlist ::= columnlist COMMA column */
{
                                                yymsp[-2].minor.yy202->append(yymsp[0].minor.yy227);
                                                yygotominor.yy202 = yymsp[-2].minor.yy202;
                                                DONT_INHERIT_TOKENS("columnlist");
                                            }
        break;
      case 41: /* columnlist ::= column */
{
                                                yygotominor.yy202 = new ParserCreateTableColumnList();
                                                yygotominor.yy202->append(yymsp[0].minor.yy227);
                                            }
        break;
      case 42: /* column ::= columnid type carglist */
{
                                                yygotominor.yy227 = new SqliteCreateTable::Column(*(yymsp[-2].minor.yy399), yymsp[-1].minor.yy537, *(yymsp[0].minor.yy51));
                                                delete yymsp[-2].minor.yy399;
                                                delete yymsp[0].minor.yy51;
                                                objectForTokens = yygotominor.yy227;
                                            }
        break;
      case 43: /* columnid ::= nm */
      case 44: /* columnid ::= ID_COL_NEW */ yytestcase(yyruleno==44);
      case 47: /* nm ::= id */ yytestcase(yyruleno==47);
      case 55: /* typename ::= ids */ yytestcase(yyruleno==55);
      case 187: /* dbnm ::= DOT nm */ yytestcase(yyruleno==187);
      case 336: /* collate ::= COLLATE ids */ yytestcase(yyruleno==336);
      case 337: /* collate ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==337);
{yygotominor.yy399 = yymsp[0].minor.yy399;}
        break;
      case 45: /* id ::= ID */
{
                                                yygotominor.yy399 = new QString(
                                                    stripObjName(
                                                        yymsp[0].minor.yy0->value,
                                                        parserContext->dialect
                                                    )
                                                );
                                            }
        break;
      case 46: /* ids ::= ID|STRING */
      case 49: /* nm ::= JOIN_KW */ yytestcase(yyruleno==49);
{yygotominor.yy399 = new QString(yymsp[0].minor.yy0->value);}
        break;
      case 48: /* nm ::= STRING */
{yygotominor.yy399 = new QString(stripString(yymsp[0].minor.yy0->value));}
        break;
      case 50: /* type ::= */
{yygotominor.yy537 = nullptr;}
        break;
      case 51: /* type ::= typetoken */
{yygotominor.yy537 = yymsp[0].minor.yy537;}
        break;
      case 52: /* typetoken ::= typename */
{
                                                yygotominor.yy537 = new SqliteColumnType(*(yymsp[0].minor.yy399));
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy537;
                                            }
        break;
      case 53: /* typetoken ::= typename LP signed RP */
{
                                                yygotominor.yy537 = new SqliteColumnType(*(yymsp[-3].minor.yy399), *(yymsp[-1].minor.yy469));
                                                delete yymsp[-3].minor.yy399;
                                                delete yymsp[-1].minor.yy469;
                                                objectForTokens = yygotominor.yy537;
                                            }
        break;
      case 54: /* typetoken ::= typename LP signed COMMA signed RP */
{
                                                yygotominor.yy537 = new SqliteColumnType(*(yymsp[-5].minor.yy399), *(yymsp[-3].minor.yy469), *(yymsp[-1].minor.yy469));
                                                delete yymsp[-5].minor.yy399;
                                                delete yymsp[-3].minor.yy469;
                                                delete yymsp[-1].minor.yy469;
                                                objectForTokens = yygotominor.yy537;
                                            }
        break;
      case 56: /* typename ::= typename ids */
      case 57: /* typename ::= ID_COL_TYPE */ yytestcase(yyruleno==57);
{
                                                yymsp[-1].minor.yy399->append(" " + *(yymsp[0].minor.yy399));
                                                delete yymsp[0].minor.yy399;
                                                yygotominor.yy399 = yymsp[-1].minor.yy399;
                                            }
        break;
      case 58: /* signed ::= plus_num */
      case 59: /* signed ::= minus_num */ yytestcase(yyruleno==59);
      case 350: /* nmnum ::= plus_num */ yytestcase(yyruleno==350);
      case 355: /* plus_num ::= PLUS number */ yytestcase(yyruleno==355);
      case 356: /* plus_num ::= number */ yytestcase(yyruleno==356);
{yygotominor.yy469 = yymsp[0].minor.yy469;}
        break;
      case 60: /* carglist ::= carglist ccons */
{
                                                yymsp[-1].minor.yy51->append(yymsp[0].minor.yy304);
                                                yygotominor.yy51 = yymsp[-1].minor.yy51;
                                                DONT_INHERIT_TOKENS("carglist");
                                            }
        break;
      case 61: /* carglist ::= */
{yygotominor.yy51 = new ParserCreateTableColumnConstraintList();}
        break;
      case 62: /* ccons ::= CONSTRAINT nm */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initDefNameOnly(*(yymsp[0].minor.yy399));
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 63: /* ccons ::= DEFAULT term */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initDefTerm(*(yymsp[0].minor.yy469));
                                                delete yymsp[0].minor.yy469;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 64: /* ccons ::= DEFAULT LP expr RP */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initDefExpr(yymsp[-1].minor.yy352);
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 65: /* ccons ::= DEFAULT PLUS term */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initDefTerm(*(yymsp[0].minor.yy469), false);
                                                delete yymsp[0].minor.yy469;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 66: /* ccons ::= DEFAULT MINUS term */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initDefTerm(*(yymsp[0].minor.yy469), true);
                                                delete yymsp[0].minor.yy469;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 67: /* ccons ::= DEFAULT id */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initDefId(*(yymsp[0].minor.yy399));
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 68: /* ccons ::= DEFAULT CTIME_KW */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initDefCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 69: /* ccons ::= NULL onconf */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initNull(*(yymsp[0].minor.yy338));
                                                delete yymsp[0].minor.yy338;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 70: /* ccons ::= NOT NULL onconf */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initNotNull(*(yymsp[0].minor.yy338));
                                                delete yymsp[0].minor.yy338;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 71: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initPk(*(yymsp[-2].minor.yy309), *(yymsp[-1].minor.yy338), *(yymsp[0].minor.yy451));
                                                delete yymsp[-2].minor.yy309;
                                                delete yymsp[0].minor.yy451;
                                                delete yymsp[-1].minor.yy338;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 72: /* ccons ::= UNIQUE onconf */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initUnique(*(yymsp[0].minor.yy338));
                                                delete yymsp[0].minor.yy338;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 73: /* ccons ::= CHECK LP expr RP */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initCheck(yymsp[-1].minor.yy352);
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 74: /* ccons ::= REFERENCES nm idxlist_opt refargs */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initFk(*(yymsp[-2].minor.yy399), *(yymsp[-1].minor.yy223), *(yymsp[0].minor.yy184));
                                                delete yymsp[-2].minor.yy399;
                                                delete yymsp[0].minor.yy184;
                                                delete yymsp[-1].minor.yy223;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 75: /* ccons ::= defer_subclause */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initDefer(yymsp[0].minor.yy329->initially, yymsp[0].minor.yy329->deferrable);
                                                delete yymsp[0].minor.yy329;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 76: /* ccons ::= COLLATE ids */
      case 77: /* ccons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==77);
      case 78: /* ccons ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==78);
      case 79: /* ccons ::= REFERENCES ID_TAB */ yytestcase(yyruleno==79);
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initColl(*(yymsp[0].minor.yy399));
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 80: /* ccons ::= CHECK LP RP */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initCheck();
                                                objectForTokens = yygotominor.yy304;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 81: /* term ::= NULL */
{yygotominor.yy469 = new QVariant();}
        break;
      case 82: /* term ::= INTEGER */
      case 358: /* number ::= INTEGER */ yytestcase(yyruleno==358);
{yygotominor.yy469 = parserContext->handleNumberToken(yymsp[0].minor.yy0->value);}
        break;
      case 83: /* term ::= FLOAT */
      case 359: /* number ::= FLOAT */ yytestcase(yyruleno==359);
{yygotominor.yy469 = new QVariant(QVariant(yymsp[0].minor.yy0->value).toDouble());}
        break;
      case 84: /* term ::= STRING|BLOB */
      case 352: /* nmnum ::= ON */ yytestcase(yyruleno==352);
      case 353: /* nmnum ::= DELETE */ yytestcase(yyruleno==353);
      case 354: /* nmnum ::= DEFAULT */ yytestcase(yyruleno==354);
{yygotominor.yy469 = new QVariant(yymsp[0].minor.yy0->value);}
        break;
      case 87: /* refargs ::= */
{yygotominor.yy184 = new ParserFkConditionList();}
        break;
      case 88: /* refargs ::= refargs refarg */
{
                                                yymsp[-1].minor.yy184->append(yymsp[0].minor.yy347);
                                                yygotominor.yy184 = yymsp[-1].minor.yy184;
                                                DONT_INHERIT_TOKENS("refargs");
                                            }
        break;
      case 89: /* refarg ::= MATCH nm */
{
                                                yygotominor.yy347 = new SqliteForeignKey::Condition(*(yymsp[0].minor.yy399));
                                                delete yymsp[0].minor.yy399;
                                            }
        break;
      case 90: /* refarg ::= ON INSERT refact */
{yygotominor.yy347 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::INSERT, *(yymsp[0].minor.yy104)); delete yymsp[0].minor.yy104;}
        break;
      case 91: /* refarg ::= ON DELETE refact */
{yygotominor.yy347 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::DELETE, *(yymsp[0].minor.yy104)); delete yymsp[0].minor.yy104;}
        break;
      case 92: /* refarg ::= ON UPDATE refact */
      case 93: /* refarg ::= MATCH ID_FK_MATCH */ yytestcase(yyruleno==93);
{yygotominor.yy347 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::UPDATE, *(yymsp[0].minor.yy104)); delete yymsp[0].minor.yy104;}
        break;
      case 94: /* refact ::= SET NULL */
{yygotominor.yy104 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_NULL);}
        break;
      case 95: /* refact ::= SET DEFAULT */
{yygotominor.yy104 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_DEFAULT);}
        break;
      case 96: /* refact ::= CASCADE */
{yygotominor.yy104 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::CASCADE);}
        break;
      case 97: /* refact ::= RESTRICT */
{yygotominor.yy104 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::RESTRICT);}
        break;
      case 98: /* refact ::= NO ACTION */
{yygotominor.yy104 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::NO_ACTION);}
        break;
      case 99: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy329 = new ParserDeferSubClause(SqliteDeferrable::NOT_DEFERRABLE, *(yymsp[0].minor.yy392));
                                                delete yymsp[0].minor.yy392;
                                            }
        break;
      case 100: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy329 = new ParserDeferSubClause(SqliteDeferrable::DEFERRABLE, *(yymsp[0].minor.yy392));
                                                delete yymsp[0].minor.yy392;
                                            }
        break;
      case 101: /* init_deferred_pred_opt ::= */
{yygotominor.yy392 = new SqliteInitially(SqliteInitially::null);}
        break;
      case 102: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
{yygotominor.yy392 = new SqliteInitially(SqliteInitially::DEFERRED);}
        break;
      case 103: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
{yygotominor.yy392 = new SqliteInitially(SqliteInitially::IMMEDIATE);}
        break;
      case 104: /* conslist_opt ::= */
{yygotominor.yy333 = new ParserCreateTableConstraintList();}
        break;
      case 105: /* conslist_opt ::= COMMA conslist */
{yygotominor.yy333 = yymsp[0].minor.yy333;}
        break;
      case 106: /* conslist ::= conslist tconscomma tcons */
{
                                                yymsp[0].minor.yy406->afterComma = *(yymsp[-1].minor.yy451);
                                                yymsp[-2].minor.yy333->append(yymsp[0].minor.yy406);
                                                yygotominor.yy333 = yymsp[-2].minor.yy333;
                                                delete yymsp[-1].minor.yy451;
                                                DONT_INHERIT_TOKENS("conslist");
                                            }
        break;
      case 107: /* conslist ::= tcons */
{
                                                yygotominor.yy333 = new ParserCreateTableConstraintList();
                                                yygotominor.yy333->append(yymsp[0].minor.yy406);
                                            }
        break;
      case 110: /* tcons ::= CONSTRAINT nm */
{
                                                yygotominor.yy406 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy406->initNameOnly(*(yymsp[0].minor.yy399));
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy406;
                                            }
        break;
      case 111: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
{
                                                yygotominor.yy406 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy406->initPk(*(yymsp[-3].minor.yy223), *(yymsp[-2].minor.yy451), *(yymsp[0].minor.yy338));
                                                delete yymsp[-2].minor.yy451;
                                                delete yymsp[0].minor.yy338;
                                                delete yymsp[-3].minor.yy223;
                                                objectForTokens = yygotominor.yy406;
                                            }
        break;
      case 112: /* tcons ::= UNIQUE LP idxlist RP onconf */
{
                                                yygotominor.yy406 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy406->initUnique(*(yymsp[-2].minor.yy223), *(yymsp[0].minor.yy338));
                                                delete yymsp[0].minor.yy338;
                                                delete yymsp[-2].minor.yy223;
                                                objectForTokens = yygotominor.yy406;
                                            }
        break;
      case 113: /* tcons ::= CHECK LP expr RP onconf */
{
                                                yygotominor.yy406 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy406->initCheck(yymsp[-2].minor.yy352, *(yymsp[0].minor.yy338));
                                                objectForTokens = yygotominor.yy406;
                                            }
        break;
      case 114: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
      case 115: /* tcons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==115);
      case 116: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB */ yytestcase(yyruleno==116);
{
                                                yygotominor.yy406 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy406->initFk(
                                                    *(yymsp[-6].minor.yy223),
                                                    *(yymsp[-3].minor.yy399),
                                                    *(yymsp[-2].minor.yy223),
                                                    *(yymsp[-1].minor.yy184),
                                                    yymsp[0].minor.yy329->initially,
                                                    yymsp[0].minor.yy329->deferrable
                                                );
                                                delete yymsp[-3].minor.yy399;
                                                delete yymsp[-1].minor.yy184;
                                                delete yymsp[0].minor.yy329;
                                                delete yymsp[-2].minor.yy223;
                                                delete yymsp[-6].minor.yy223;
                                                objectForTokens = yygotominor.yy406;
                                            }
        break;
      case 117: /* tcons ::= CHECK LP RP onconf */
{
                                                yygotominor.yy406 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy406->initCheck();
                                                objectForTokens = yygotominor.yy406;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                              yy_destructor(yypParser,202,&yymsp[0].minor);
}
        break;
      case 118: /* defer_subclause_opt ::= */
{yygotominor.yy329 = new ParserDeferSubClause(SqliteDeferrable::null, SqliteInitially::null);}
        break;
      case 119: /* defer_subclause_opt ::= defer_subclause */
{yygotominor.yy329 = yymsp[0].minor.yy329;}
        break;
      case 120: /* onconf ::= */
      case 122: /* orconf ::= */ yytestcase(yyruleno==122);
{yygotominor.yy338 = new SqliteConflictAlgo(SqliteConflictAlgo::null);}
        break;
      case 121: /* onconf ::= ON CONFLICT resolvetype */
      case 123: /* orconf ::= OR resolvetype */ yytestcase(yyruleno==123);
{yygotominor.yy338 = yymsp[0].minor.yy338;}
        break;
      case 124: /* resolvetype ::= raisetype */
      case 125: /* resolvetype ::= IGNORE */ yytestcase(yyruleno==125);
      case 126: /* resolvetype ::= REPLACE */ yytestcase(yyruleno==126);
{yygotominor.yy338 = new SqliteConflictAlgo(sqliteConflictAlgo(yymsp[0].minor.yy0->value));}
        break;
      case 127: /* cmd ::= DROP TABLE ifexists fullname */
{
                                                yygotominor.yy283 = new SqliteDropTable(*(yymsp[-1].minor.yy451), yymsp[0].minor.yy360->name1, yymsp[0].minor.yy360->name2);
                                                delete yymsp[-1].minor.yy451;
                                                delete yymsp[0].minor.yy360;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 128: /* cmd ::= DROP TABLE ifexists nm DOT ID_TAB */
      case 129: /* cmd ::= DROP TABLE ifexists ID_DB|ID_TAB */ yytestcase(yyruleno==129);
      case 136: /* cmd ::= DROP VIEW ifexists nm DOT ID_VIEW */ yytestcase(yyruleno==136);
      case 137: /* cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW */ yytestcase(yyruleno==137);
      case 179: /* singlesrc ::= nm DOT ID_TAB */ yytestcase(yyruleno==179);
      case 180: /* singlesrc ::= ID_DB|ID_TAB */ yytestcase(yyruleno==180);
      case 181: /* singlesrc ::= nm DOT ID_VIEW */ yytestcase(yyruleno==181);
      case 182: /* singlesrc ::= ID_DB|ID_VIEW */ yytestcase(yyruleno==182);
      case 266: /* exprx ::= nm DOT ID_TAB|ID_COL */ yytestcase(yyruleno==266);
      case 325: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW */ yytestcase(yyruleno==325);
      case 326: /* cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW */ yytestcase(yyruleno==326);
      case 339: /* cmd ::= DROP INDEX ifexists nm DOT ID_IDX */ yytestcase(yyruleno==339);
      case 340: /* cmd ::= DROP INDEX ifexists ID_DB|ID_IDX */ yytestcase(yyruleno==340);
      case 348: /* cmd ::= PRAGMA nm DOT ID_PRAGMA */ yytestcase(yyruleno==348);
      case 349: /* cmd ::= PRAGMA ID_DB|ID_PRAGMA */ yytestcase(yyruleno==349);
      case 387: /* cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG */ yytestcase(yyruleno==387);
      case 388: /* cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG */ yytestcase(yyruleno==388);
      case 398: /* cmd ::= REINDEX nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==398);
      case 399: /* cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==399);
      case 402: /* cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==402);
      case 403: /* cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==403);
      case 407: /* cmd ::= ALTER TABLE nm DOT ID_TAB */ yytestcase(yyruleno==407);
      case 408: /* cmd ::= ALTER TABLE ID_DB|ID_TAB */ yytestcase(yyruleno==408);
      case 414: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW */ yytestcase(yyruleno==414);
      case 415: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW */ yytestcase(yyruleno==415);
{  yy_destructor(yypParser,179,&yymsp[-2].minor);
}
        break;
      case 132: /* cmd ::= CREATE temp VIEW ifnotexists fullname idxlist_opt AS select */
{
                                                yygotominor.yy283 = new SqliteCreateView(*(yymsp[-6].minor.yy146), *(yymsp[-4].minor.yy451), yymsp[-3].minor.yy360->name1, yymsp[-3].minor.yy360->name2, yymsp[0].minor.yy473, *(yymsp[-2].minor.yy223));
                                                delete yymsp[-6].minor.yy146;
                                                delete yymsp[-4].minor.yy451;
                                                delete yymsp[-3].minor.yy360;
                                                delete yymsp[-2].minor.yy223;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 135: /* cmd ::= DROP VIEW ifexists fullname */
{
                                                yygotominor.yy283 = new SqliteDropView(*(yymsp[-1].minor.yy451), yymsp[0].minor.yy360->name1, yymsp[0].minor.yy360->name2);
                                                delete yymsp[-1].minor.yy451;
                                                delete yymsp[0].minor.yy360;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 138: /* cmd ::= select_stmt */
      case 215: /* cmd ::= delete_stmt */ yytestcase(yyruleno==215);
      case 224: /* cmd ::= update_stmt */ yytestcase(yyruleno==224);
      case 245: /* cmd ::= insert_stmt */ yytestcase(yyruleno==245);
{
                                                yygotominor.yy283 = yymsp[0].minor.yy283;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 139: /* select_stmt ::= select */
{
                                                yygotominor.yy283 = yymsp[0].minor.yy473;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 140: /* select ::= with selectnowith */
{
                                                yygotominor.yy473 = yymsp[0].minor.yy473;
                                                yymsp[0].minor.yy473->setWith(yymsp[-1].minor.yy321);
                                                objectForTokens = yygotominor.yy473;
                                            }
        break;
      case 141: /* selectnowith ::= oneselect */
{
                                                yygotominor.yy473 = SqliteSelect::append(yymsp[0].minor.yy310);
                                                objectForTokens = yygotominor.yy473;
                                            }
        break;
      case 142: /* selectnowith ::= selectnowith multiselect_op oneselect */
{
                                                yygotominor.yy473 = SqliteSelect::append(yymsp[-2].minor.yy473, *(yymsp[-1].minor.yy462), yymsp[0].minor.yy310);
                                                delete yymsp[-1].minor.yy462;
                                                objectForTokens = yygotominor.yy473;
                                            }
        break;
      case 143: /* selectnowith ::= values */
{
                                                yygotominor.yy473 = SqliteSelect::append(*(yymsp[0].minor.yy166));
                                                delete yymsp[0].minor.yy166;
                                                objectForTokens = yygotominor.yy473;
                                            }
        break;
      case 144: /* selectnowith ::= selectnowith COMMA values */
{
                                                yygotominor.yy473 = SqliteSelect::append(yymsp[-2].minor.yy473, SqliteSelect::CompoundOperator::UNION_ALL, *(yymsp[0].minor.yy166));
                                                delete yymsp[0].minor.yy166;
                                                objectForTokens = yygotominor.yy473;
                                            }
        break;
      case 145: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
{
                                                yygotominor.yy310 = new SqliteSelect::Core(
                                                        *(yymsp[-7].minor.yy146),
                                                        *(yymsp[-6].minor.yy373),
                                                        yymsp[-5].minor.yy511,
                                                        yymsp[-4].minor.yy352,
                                                        *(yymsp[-3].minor.yy551),
                                                        yymsp[-2].minor.yy352,
                                                        *(yymsp[-1].minor.yy163),
                                                        yymsp[0].minor.yy484
                                                    );
                                                delete yymsp[-6].minor.yy373;
                                                delete yymsp[-7].minor.yy146;
                                                delete yymsp[-3].minor.yy551;
                                                delete yymsp[-1].minor.yy163;
                                                objectForTokens = yygotominor.yy310;
                                            }
        break;
      case 146: /* values ::= VALUES LP nexprlist RP */
{
                                                yygotominor.yy166 = new ParserExprNestedList();
                                                yygotominor.yy166->append(*(yymsp[-1].minor.yy551));
                                                delete yymsp[-1].minor.yy551;
                                            }
        break;
      case 147: /* values ::= values COMMA LP exprlist RP */
{
                                                yymsp[-4].minor.yy166->append(*(yymsp[-1].minor.yy551));
                                                yygotominor.yy166 = yymsp[-4].minor.yy166;
                                                delete yymsp[-1].minor.yy551;
                                                DONT_INHERIT_TOKENS("values");
                                            }
        break;
      case 148: /* multiselect_op ::= UNION */
{yygotominor.yy462 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION);}
        break;
      case 149: /* multiselect_op ::= UNION ALL */
{yygotominor.yy462 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION_ALL);}
        break;
      case 150: /* multiselect_op ::= EXCEPT */
{yygotominor.yy462 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::EXCEPT);}
        break;
      case 151: /* multiselect_op ::= INTERSECT */
{yygotominor.yy462 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::INTERSECT);}
        break;
      case 152: /* distinct ::= DISTINCT */
{yygotominor.yy146 = new int(1);}
        break;
      case 153: /* distinct ::= ALL */
{yygotominor.yy146 = new int(2);}
        break;
      case 155: /* sclp ::= selcollist COMMA */
{yygotominor.yy373 = yymsp[-1].minor.yy373;}
        break;
      case 156: /* sclp ::= */
{yygotominor.yy373 = new ParserResultColumnList();}
        break;
      case 157: /* selcollist ::= sclp expr as */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        yymsp[-1].minor.yy352,
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->asKw : false,
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->name : QString::null
                                                    );

                                                yymsp[-2].minor.yy373->append(obj);
                                                yygotominor.yy373 = yymsp[-2].minor.yy373;
                                                delete yymsp[0].minor.yy200;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 158: /* selcollist ::= sclp STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(true);

                                                yymsp[-1].minor.yy373->append(obj);
                                                yygotominor.yy373 = yymsp[-1].minor.yy373;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 159: /* selcollist ::= sclp nm DOT STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        true,
                                                        *(yymsp[-2].minor.yy399)
                                                    );
                                                yymsp[-3].minor.yy373->append(obj);
                                                yygotominor.yy373 = yymsp[-3].minor.yy373;
                                                delete yymsp[-2].minor.yy399;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 160: /* selcollist ::= sclp */
      case 161: /* selcollist ::= sclp ID_TAB DOT STAR */ yytestcase(yyruleno==161);
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy373 = yymsp[0].minor.yy373;
                                            }
        break;
      case 162: /* as ::= AS nm */
{
                                                yygotominor.yy200 = new ParserStubAlias(*(yymsp[0].minor.yy399), true);
                                                delete yymsp[0].minor.yy399;
                                            }
        break;
      case 163: /* as ::= ids */
      case 164: /* as ::= AS ID_ALIAS */ yytestcase(yyruleno==164);
      case 165: /* as ::= ID_ALIAS */ yytestcase(yyruleno==165);
{
                                                yygotominor.yy200 = new ParserStubAlias(*(yymsp[0].minor.yy399), false);
                                                delete yymsp[0].minor.yy399;
                                            }
        break;
      case 166: /* as ::= */
{yygotominor.yy200 = nullptr;}
        break;
      case 167: /* from ::= */
{yygotominor.yy511 = nullptr;}
        break;
      case 168: /* from ::= FROM joinsrc */
{yygotominor.yy511 = yymsp[0].minor.yy511;}
        break;
      case 169: /* joinsrc ::= singlesrc seltablist */
{
                                                yygotominor.yy511 = new SqliteSelect::Core::JoinSource(
                                                        yymsp[-1].minor.yy201,
                                                        *(yymsp[0].minor.yy131)
                                                    );
                                                delete yymsp[0].minor.yy131;
                                                objectForTokens = yygotominor.yy511;
                                            }
        break;
      case 170: /* joinsrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy511 = new SqliteSelect::Core::JoinSource();
                                                objectForTokens = yygotominor.yy511;
                                            }
        break;
      case 171: /* seltablist ::= seltablist joinop singlesrc joinconstr_opt */
{
                                                SqliteSelect::Core::JoinSourceOther* src =
                                                    new SqliteSelect::Core::JoinSourceOther(yymsp[-2].minor.yy301, yymsp[-1].minor.yy201, yymsp[0].minor.yy295);

                                                yymsp[-3].minor.yy131->append(src);
                                                yygotominor.yy131 = yymsp[-3].minor.yy131;
                                                objectForTokens = src;
                                                DONT_INHERIT_TOKENS("seltablist");
                                            }
        break;
      case 172: /* seltablist ::= */
{
                                                yygotominor.yy131 = new ParserOtherSourceList();
                                            }
        break;
      case 173: /* singlesrc ::= nm dbnm as indexed_opt */
{
                                                yygotominor.yy201 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-3].minor.yy399),
                                                        *(yymsp[-2].minor.yy399),
                                                        yymsp[-1].minor.yy200 ? yymsp[-1].minor.yy200->asKw : false,
                                                        yymsp[-1].minor.yy200 ? yymsp[-1].minor.yy200->name : QString::null,
                                                        yymsp[0].minor.yy192 ? yymsp[0].minor.yy192->notIndexedKw : false,
                                                        yymsp[0].minor.yy192 ? yymsp[0].minor.yy192->indexedBy : QString::null
                                                    );
                                                delete yymsp[-3].minor.yy399;
                                                delete yymsp[-2].minor.yy399;
                                                delete yymsp[-1].minor.yy200;
                                                if (yymsp[0].minor.yy192)
                                                    delete yymsp[0].minor.yy192;
                                                objectForTokens = yygotominor.yy201;
                                            }
        break;
      case 174: /* singlesrc ::= LP select RP as */
{
                                                yygotominor.yy201 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy473,
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->asKw : false,
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->name : QString::null
                                                    );
                                                delete yymsp[0].minor.yy200;
                                                objectForTokens = yygotominor.yy201;
                                            }
        break;
      case 175: /* singlesrc ::= LP joinsrc RP as */
{
                                                yygotominor.yy201 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy511,
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->asKw : false,
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->name : QString::null
                                                    );
                                                delete yymsp[0].minor.yy200;
                                                objectForTokens = yygotominor.yy201;
                                            }
        break;
      case 176: /* singlesrc ::= nm dbnm LP exprlist RP as */
{
                                                yygotominor.yy201 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-5].minor.yy399),
                                                        *(yymsp[-4].minor.yy399),
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->asKw : false,
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->name : QString::null,
                                                        *(yymsp[-2].minor.yy551)
                                                    );
                                                delete yymsp[-5].minor.yy399;
                                                delete yymsp[-4].minor.yy399;
                                                delete yymsp[0].minor.yy200;
                                                if (yymsp[-2].minor.yy551)
                                                    delete yymsp[-2].minor.yy551;

                                                objectForTokens = yygotominor.yy201;
                                            }
        break;
      case 177: /* singlesrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy201 = new SqliteSelect::Core::SingleSource();
                                                objectForTokens = yygotominor.yy201;
                                            }
        break;
      case 178: /* singlesrc ::= nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy201 = new SqliteSelect::Core::SingleSource();
                                                yygotominor.yy201->database = *(yymsp[-1].minor.yy399);
                                                delete yymsp[-1].minor.yy399;
                                                objectForTokens = yygotominor.yy201;
                                            }
        break;
      case 183: /* joinconstr_opt ::= ON expr */
{
                                                yygotominor.yy295 = new SqliteSelect::Core::JoinConstraint(yymsp[0].minor.yy352);
                                                objectForTokens = yygotominor.yy295;
                                            }
        break;
      case 184: /* joinconstr_opt ::= USING LP idlist RP */
{
                                                yygotominor.yy295 = new SqliteSelect::Core::JoinConstraint(*(yymsp[-1].minor.yy95));
                                                delete yymsp[-1].minor.yy95;
                                                objectForTokens = yygotominor.yy295;
                                            }
        break;
      case 185: /* joinconstr_opt ::= */
{yygotominor.yy295 = nullptr;}
        break;
      case 188: /* fullname ::= nm dbnm */
{
                                                yygotominor.yy360 = new ParserFullName();
                                                yygotominor.yy360->name1 = *(yymsp[-1].minor.yy399);
                                                yygotominor.yy360->name2 = *(yymsp[0].minor.yy399);
                                                delete yymsp[-1].minor.yy399;
                                                delete yymsp[0].minor.yy399;
                                            }
        break;
      case 189: /* joinop ::= COMMA */
{
                                                yygotominor.yy301 = new SqliteSelect::Core::JoinOp(true);
                                                objectForTokens = yygotominor.yy301;
                                            }
        break;
      case 190: /* joinop ::= JOIN */
{
                                                yygotominor.yy301 = new SqliteSelect::Core::JoinOp(false);
                                                objectForTokens = yygotominor.yy301;
                                            }
        break;
      case 191: /* joinop ::= JOIN_KW JOIN */
{
                                                yygotominor.yy301 = new SqliteSelect::Core::JoinOp(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy301;
                                            }
        break;
      case 192: /* joinop ::= JOIN_KW nm JOIN */
{
                                                yygotominor.yy301 = new SqliteSelect::Core::JoinOp(yymsp[-2].minor.yy0->value, *(yymsp[-1].minor.yy399));
                                                delete yymsp[-1].minor.yy399;
                                                objectForTokens = yygotominor.yy301;
                                            }
        break;
      case 193: /* joinop ::= JOIN_KW nm nm JOIN */
      case 194: /* joinop ::= ID_JOIN_OPTS */ yytestcase(yyruleno==194);
{
                                                yygotominor.yy301 = new SqliteSelect::Core::JoinOp(yymsp[-3].minor.yy0->value, *(yymsp[-2].minor.yy399), *(yymsp[-1].minor.yy399));
                                                delete yymsp[-2].minor.yy399;
                                                delete yymsp[-2].minor.yy399;
                                                objectForTokens = yygotominor.yy301;
                                            }
        break;
      case 195: /* indexed_opt ::= */
{yygotominor.yy192 = nullptr;}
        break;
      case 196: /* indexed_opt ::= INDEXED BY nm */
{
                                                yygotominor.yy192 = new ParserIndexedBy(*(yymsp[0].minor.yy399));
                                                delete yymsp[0].minor.yy399;
                                            }
        break;
      case 197: /* indexed_opt ::= NOT INDEXED */
      case 198: /* indexed_opt ::= INDEXED BY ID_IDX */ yytestcase(yyruleno==198);
{yygotominor.yy192 = new ParserIndexedBy(true);}
        break;
      case 199: /* orderby_opt ::= */
{yygotominor.yy163 = new ParserOrderByList();}
        break;
      case 200: /* orderby_opt ::= ORDER BY sortlist */
{yygotominor.yy163 = yymsp[0].minor.yy163;}
        break;
      case 201: /* sortlist ::= sortlist COMMA expr sortorder */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-1].minor.yy352, *(yymsp[0].minor.yy309));
                                                yymsp[-3].minor.yy163->append(obj);
                                                yygotominor.yy163 = yymsp[-3].minor.yy163;
                                                delete yymsp[0].minor.yy309;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sortlist");
                                            }
        break;
      case 202: /* sortlist ::= expr sortorder */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-1].minor.yy352, *(yymsp[0].minor.yy309));
                                                yygotominor.yy163 = new ParserOrderByList();
                                                yygotominor.yy163->append(obj);
                                                delete yymsp[0].minor.yy309;
                                                objectForTokens = obj;
                                            }
        break;
      case 203: /* sortorder ::= ASC */
{yygotominor.yy309 = new SqliteSortOrder(SqliteSortOrder::ASC);}
        break;
      case 204: /* sortorder ::= DESC */
{yygotominor.yy309 = new SqliteSortOrder(SqliteSortOrder::DESC);}
        break;
      case 205: /* sortorder ::= */
{yygotominor.yy309 = new SqliteSortOrder(SqliteSortOrder::null);}
        break;
      case 206: /* groupby_opt ::= */
      case 320: /* exprlist ::= */ yytestcase(yyruleno==320);
{yygotominor.yy551 = new ParserExprList();}
        break;
      case 207: /* groupby_opt ::= GROUP BY nexprlist */
      case 319: /* exprlist ::= nexprlist */ yytestcase(yyruleno==319);
{yygotominor.yy551 = yymsp[0].minor.yy551;}
        break;
      case 208: /* groupby_opt ::= GROUP BY */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy551 = new ParserExprList();
                                            }
        break;
      case 209: /* having_opt ::= */
      case 221: /* where_opt ::= */ yytestcase(yyruleno==221);
      case 316: /* case_else ::= */ yytestcase(yyruleno==316);
      case 318: /* case_operand ::= */ yytestcase(yyruleno==318);
      case 376: /* when_clause ::= */ yytestcase(yyruleno==376);
      case 391: /* key_opt ::= */ yytestcase(yyruleno==391);
{yygotominor.yy352 = nullptr;}
        break;
      case 210: /* having_opt ::= HAVING expr */
      case 222: /* where_opt ::= WHERE expr */ yytestcase(yyruleno==222);
      case 309: /* expr ::= exprx */ yytestcase(yyruleno==309);
      case 315: /* case_else ::= ELSE expr */ yytestcase(yyruleno==315);
      case 317: /* case_operand ::= exprx */ yytestcase(yyruleno==317);
      case 377: /* when_clause ::= WHEN expr */ yytestcase(yyruleno==377);
      case 392: /* key_opt ::= KEY expr */ yytestcase(yyruleno==392);
{yygotominor.yy352 = yymsp[0].minor.yy352;}
        break;
      case 211: /* limit_opt ::= */
{yygotominor.yy484 = nullptr;}
        break;
      case 212: /* limit_opt ::= LIMIT expr */
{
                                                yygotominor.yy484 = new SqliteLimit(yymsp[0].minor.yy352);
                                                objectForTokens = yygotominor.yy484;
                                            }
        break;
      case 213: /* limit_opt ::= LIMIT expr OFFSET expr */
{
                                                yygotominor.yy484 = new SqliteLimit(yymsp[-2].minor.yy352, yymsp[0].minor.yy352, true);
                                                objectForTokens = yygotominor.yy484;
                                            }
        break;
      case 214: /* limit_opt ::= LIMIT expr COMMA expr */
{
                                                yygotominor.yy484 = new SqliteLimit(yymsp[-2].minor.yy352, yymsp[0].minor.yy352, false);
                                                objectForTokens = yygotominor.yy484;
                                            }
        break;
      case 216: /* delete_stmt ::= with DELETE FROM fullname indexed_opt where_opt */
{
                                                if (yymsp[-1].minor.yy192)
                                                {
                                                    if (!yymsp[-1].minor.yy192->indexedBy.isNull())
                                                    {
                                                        yygotominor.yy283 = new SqliteDelete(
                                                                yymsp[-2].minor.yy360->name1,
                                                                yymsp[-2].minor.yy360->name2,
                                                                yymsp[-1].minor.yy192->indexedBy,
                                                                yymsp[0].minor.yy352,
                                                                yymsp[-5].minor.yy321
                                                            );
                                                    }
                                                    else
                                                    {
                                                        yygotominor.yy283 = new SqliteDelete(
                                                                yymsp[-2].minor.yy360->name1,
                                                                yymsp[-2].minor.yy360->name2,
                                                                yymsp[-1].minor.yy192->notIndexedKw,
                                                                yymsp[0].minor.yy352,
                                                                yymsp[-5].minor.yy321
                                                            );
                                                    }
                                                    delete yymsp[-1].minor.yy192;
                                                }
                                                else
                                                {
                                                    yygotominor.yy283 = new SqliteDelete(
                                                            yymsp[-2].minor.yy360->name1,
                                                            yymsp[-2].minor.yy360->name2,
                                                            false,
                                                            yymsp[0].minor.yy352,
                                                            yymsp[-5].minor.yy321
                                                        );
                                                }
                                                delete yymsp[-2].minor.yy360;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 217: /* delete_stmt ::= with DELETE FROM */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-2].minor.yy321;
                                                yygotominor.yy283 = q;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 218: /* delete_stmt ::= with DELETE FROM nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-4].minor.yy321;
                                                q->database = *(yymsp[-1].minor.yy399);
                                                yygotominor.yy283 = q;
                                                objectForTokens = yygotominor.yy283;
                                                delete yymsp[-1].minor.yy399;
                                            }
        break;
      case 219: /* delete_stmt ::= with DELETE FROM nm DOT ID_TAB */
      case 228: /* update_stmt ::= with UPDATE orconf nm DOT ID_TAB */ yytestcase(yyruleno==228);
{  yy_destructor(yypParser,221,&yymsp[-5].minor);
  yy_destructor(yypParser,179,&yymsp[-2].minor);
}
        break;
      case 220: /* delete_stmt ::= with DELETE FROM ID_DB|ID_TAB */
      case 229: /* update_stmt ::= with UPDATE orconf ID_DB|ID_TAB */ yytestcase(yyruleno==229);
{  yy_destructor(yypParser,221,&yymsp[-3].minor);
}
        break;
      case 223: /* where_opt ::= WHERE */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy352 = new SqliteExpr();
                                            }
        break;
      case 225: /* update_stmt ::= with UPDATE orconf fullname indexed_opt SET setlist where_opt */
{
                                                yygotominor.yy283 = new SqliteUpdate(
                                                        *(yymsp[-5].minor.yy338),
                                                        yymsp[-4].minor.yy360->name1,
                                                        yymsp[-4].minor.yy360->name2,
                                                        yymsp[-3].minor.yy192 ? yymsp[-3].minor.yy192->notIndexedKw : false,
                                                        yymsp[-3].minor.yy192 ? yymsp[-3].minor.yy192->indexedBy : QString::null,
                                                        *(yymsp[-1].minor.yy521),
                                                        yymsp[0].minor.yy352,
                                                        yymsp[-7].minor.yy321
                                                    );
                                                delete yymsp[-5].minor.yy338;
                                                delete yymsp[-4].minor.yy360;
                                                delete yymsp[-1].minor.yy521;
                                                if (yymsp[-3].minor.yy192)
                                                    delete yymsp[-3].minor.yy192;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 226: /* update_stmt ::= with UPDATE orconf */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-2].minor.yy321;
                                                yygotominor.yy283 = q;
                                                objectForTokens = yygotominor.yy283;
                                                delete yymsp[0].minor.yy338;
                                            }
        break;
      case 227: /* update_stmt ::= with UPDATE orconf nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-4].minor.yy321;
                                                q->database = *(yymsp[-1].minor.yy399);
                                                yygotominor.yy283 = q;
                                                objectForTokens = yygotominor.yy283;
                                                delete yymsp[-2].minor.yy338;
                                                delete yymsp[-1].minor.yy399;
                                            }
        break;
      case 230: /* setlist ::= setlist COMMA nm EQ expr */
{
                                                yymsp[-4].minor.yy521->append(ParserSetValue(*(yymsp[-2].minor.yy399), yymsp[0].minor.yy352));
                                                yygotominor.yy521 = yymsp[-4].minor.yy521;
                                                delete yymsp[-2].minor.yy399;
                                            }
        break;
      case 231: /* setlist ::= setlist COMMA LP idlist RP EQ expr */
{
                                                yymsp[-6].minor.yy521->append(ParserSetValue(*(yymsp[-3].minor.yy95), yymsp[0].minor.yy352));
                                                yygotominor.yy521 = yymsp[-6].minor.yy521;
                                                delete yymsp[-3].minor.yy95;
                                            }
        break;
      case 232: /* setlist ::= nm EQ expr */
{
                                                yygotominor.yy521 = new ParserSetValueList();
                                                yygotominor.yy521->append(ParserSetValue(*(yymsp[-2].minor.yy399), yymsp[0].minor.yy352));
                                                delete yymsp[-2].minor.yy399;
                                            }
        break;
      case 233: /* setlist ::= LP idlist RP EQ expr */
{
                                                yygotominor.yy521 = new ParserSetValueList();
                                                yygotominor.yy521->append(ParserSetValue(*(yymsp[-3].minor.yy95), yymsp[0].minor.yy352));
                                                delete yymsp[-3].minor.yy95;
                                            }
        break;
      case 234: /* setlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy521 = new ParserSetValueList();
                                            }
        break;
      case 235: /* setlist ::= setlist COMMA */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy521 = yymsp[-1].minor.yy521;
                                            }
        break;
      case 236: /* setlist ::= setlist COMMA ID_COL */
      case 237: /* setlist ::= ID_COL */ yytestcase(yyruleno==237);
{  yy_destructor(yypParser,249,&yymsp[-2].minor);
}
        break;
      case 238: /* idlist_opt ::= */
{yygotominor.yy95 = new QStringList();}
        break;
      case 239: /* idlist_opt ::= LP idlist RP */
{yygotominor.yy95 = yymsp[-1].minor.yy95;}
        break;
      case 240: /* idlist ::= idlist COMMA nm */
{
                                                yygotominor.yy95 = yymsp[-2].minor.yy95;
                                                *(yygotominor.yy95) << *(yymsp[0].minor.yy399);
                                                delete yymsp[0].minor.yy399;
                                            }
        break;
      case 241: /* idlist ::= nm */
{
                                                yygotominor.yy95 = new QStringList();
                                                *(yygotominor.yy95) << *(yymsp[0].minor.yy399);
                                                delete yymsp[0].minor.yy399;
                                            }
        break;
      case 242: /* idlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy95 = new QStringList();
                                            }
        break;
      case 243: /* idlist ::= idlist COMMA ID_COL */
      case 244: /* idlist ::= ID_COL */ yytestcase(yyruleno==244);
{  yy_destructor(yypParser,245,&yymsp[-2].minor);
}
        break;
      case 246: /* insert_stmt ::= with insert_cmd INTO fullname idlist_opt select upsert */
{
                                                yygotominor.yy283 = new SqliteInsert(
                                                        yymsp[-5].minor.yy105->replace,
                                                        yymsp[-5].minor.yy105->orConflict,
                                                        yymsp[-3].minor.yy360->name1,
                                                        yymsp[-3].minor.yy360->name2,
                                                        *(yymsp[-2].minor.yy95),
                                                        yymsp[-1].minor.yy473,
                                                        yymsp[-6].minor.yy321,
                                                        yymsp[0].minor.yy560
                                                    );
                                                delete yymsp[-3].minor.yy360;
                                                delete yymsp[-5].minor.yy105;
                                                delete yymsp[-2].minor.yy95;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 247: /* insert_stmt ::= with insert_cmd INTO fullname idlist_opt DEFAULT VALUES */
{
                                                yygotominor.yy283 = new SqliteInsert(
                                                        yymsp[-5].minor.yy105->replace,
                                                        yymsp[-5].minor.yy105->orConflict,
                                                        yymsp[-3].minor.yy360->name1,
                                                        yymsp[-3].minor.yy360->name2,
                                                        *(yymsp[-2].minor.yy95),
                                                        yymsp[-6].minor.yy321
                                                    );
                                                delete yymsp[-3].minor.yy360;
                                                delete yymsp[-5].minor.yy105;
                                                delete yymsp[-2].minor.yy95;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 248: /* insert_stmt ::= with insert_cmd INTO */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-1].minor.yy105->replace;
                                                q->onConflict = yymsp[-1].minor.yy105->orConflict;
                                                q->with = yymsp[-2].minor.yy321;
                                                yygotominor.yy283 = q;
                                                objectForTokens = yygotominor.yy283;
                                                delete yymsp[-1].minor.yy105;
                                            }
        break;
      case 249: /* insert_stmt ::= with insert_cmd INTO nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-3].minor.yy105->replace;
                                                q->onConflict = yymsp[-3].minor.yy105->orConflict;
                                                q->with = yymsp[-4].minor.yy321;
                                                q->database = *(yymsp[-1].minor.yy399);
                                                yygotominor.yy283 = q;
                                                objectForTokens = yygotominor.yy283;
                                                delete yymsp[-3].minor.yy105;
                                                delete yymsp[-1].minor.yy399;
                                            }
        break;
      case 250: /* insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB */
{  yy_destructor(yypParser,221,&yymsp[-3].minor);
  yy_destructor(yypParser,252,&yymsp[-2].minor);
}
        break;
      case 251: /* insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB */
{  yy_destructor(yypParser,221,&yymsp[-5].minor);
  yy_destructor(yypParser,252,&yymsp[-4].minor);
  yy_destructor(yypParser,179,&yymsp[-2].minor);
}
        break;
      case 252: /* insert_cmd ::= INSERT orconf */
{
                                                yygotominor.yy105 = new ParserStubInsertOrReplace(false, *(yymsp[0].minor.yy338));
                                                delete yymsp[0].minor.yy338;
                                            }
        break;
      case 253: /* insert_cmd ::= REPLACE */
{yygotominor.yy105 = new ParserStubInsertOrReplace(true);}
        break;
      case 254: /* upsert ::= */
{
                                                yygotominor.yy560 = nullptr;
                                            }
        break;
      case 255: /* upsert ::= ON CONFLICT LP sortlist RP where_opt DO UPDATE SET setlist where_opt */
{
                                                yygotominor.yy560 = new SqliteUpsert(*(yymsp[-7].minor.yy163), yymsp[-5].minor.yy352, *(yymsp[-1].minor.yy521), yymsp[0].minor.yy352);
                                                delete yymsp[-7].minor.yy163;
                                                delete yymsp[-1].minor.yy521;
                                                objectForTokens = yygotominor.yy560;
                                            }
        break;
      case 256: /* upsert ::= ON CONFLICT LP sortlist RP where_opt DO NOTHING */
{
                                                yygotominor.yy560 = new SqliteUpsert(*(yymsp[-4].minor.yy163), yymsp[-2].minor.yy352);
                                                delete yymsp[-4].minor.yy163;
                                                objectForTokens = yygotominor.yy560;
                                            }
        break;
      case 257: /* upsert ::= ON CONFLICT DO NOTHING */
{
                                                yygotominor.yy560 = new SqliteUpsert();
                                                objectForTokens = yygotominor.yy560;
                                            }
        break;
      case 258: /* exprx ::= nm DOT */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initId(*(yymsp[-1].minor.yy399), QString::null, QString::null);
                                                delete yymsp[-1].minor.yy399;
                                                objectForTokens = yygotominor.yy352;
                                                parserContext->minorErrorBeforeNextToken("Syntax error <exprx: nm.>");
                                            }
        break;
      case 259: /* exprx ::= nm DOT nm DOT */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initId(*(yymsp[-3].minor.yy399), *(yymsp[-1].minor.yy399), QString::null);
                                                delete yymsp[-3].minor.yy399;
                                                delete yymsp[-1].minor.yy399;
                                                objectForTokens = yygotominor.yy352;
                                                parserContext->minorErrorBeforeNextToken("Syntax error <exprx: nm.nm.>");
                                            }
        break;
      case 260: /* exprx ::= expr not_opt BETWEEN expr AND */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                delete yymsp[-3].minor.yy451;
                                                delete yymsp[-4].minor.yy352;
                                                delete yymsp[-1].minor.yy352;
                                                objectForTokens = yygotominor.yy352;
                                                parserContext->minorErrorBeforeNextToken("Syntax error <exprx: expr not_opt BETWEEN expr AND>");
                                            }
        break;
      case 261: /* exprx ::= CASE case_operand case_exprlist case_else */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                delete yymsp[-1].minor.yy551;
                                                delete yymsp[-2].minor.yy352;
                                                delete yymsp[0].minor.yy352;
                                                objectForTokens = yygotominor.yy352;
                                                parserContext->minorErrorBeforeNextToken("Syntax error <exprx: CASE operand exprlist else>");
                                            }
        break;
      case 262: /* exprx ::= expr not_opt IN LP exprlist */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                delete yymsp[-3].minor.yy451;
                                                delete yymsp[0].minor.yy551;
                                                delete yymsp[-4].minor.yy352;
                                                objectForTokens = yygotominor.yy352;
                                                parserContext->minorErrorBeforeNextToken("Syntax error <exprx: expr not_opt IN LP exprlist>");
                                            }
        break;
      case 263: /* exprx ::= expr not_opt IN ID_DB */
{  yy_destructor(yypParser,201,&yymsp[-3].minor);
}
        break;
      case 264: /* exprx ::= expr not_opt IN nm DOT ID_TAB */
      case 265: /* exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN */ yytestcase(yyruleno==265);
{  yy_destructor(yypParser,201,&yymsp[-5].minor);
  yy_destructor(yypParser,179,&yymsp[-2].minor);
}
        break;
      case 267: /* exprx ::= nm DOT nm DOT ID_COL */
{  yy_destructor(yypParser,179,&yymsp[-4].minor);
  yy_destructor(yypParser,179,&yymsp[-2].minor);
}
        break;
      case 268: /* exprx ::= expr COLLATE ID_COLLATE */
      case 269: /* exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP */ yytestcase(yyruleno==269);
{  yy_destructor(yypParser,201,&yymsp[-2].minor);
}
        break;
      case 270: /* exprx ::= term */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initLiteral(*(yymsp[0].minor.yy469));
                                                delete yymsp[0].minor.yy469;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 271: /* exprx ::= CTIME_KW */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 272: /* exprx ::= LP nexprlist RP */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initRowValue(*(yymsp[-1].minor.yy551));
                                                delete yymsp[-1].minor.yy551;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 273: /* exprx ::= id */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initId(*(yymsp[0].minor.yy399));
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 274: /* exprx ::= JOIN_KW */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initId(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 275: /* exprx ::= nm DOT nm */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initId(*(yymsp[-2].minor.yy399), *(yymsp[0].minor.yy399));
                                                delete yymsp[-2].minor.yy399;
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 276: /* exprx ::= nm DOT nm DOT nm */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initId(*(yymsp[-4].minor.yy399), *(yymsp[-2].minor.yy399), *(yymsp[0].minor.yy399));
                                                delete yymsp[-4].minor.yy399;
                                                delete yymsp[-2].minor.yy399;
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 277: /* exprx ::= VARIABLE */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initBindParam(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 278: /* exprx ::= expr COLLATE ids */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initCollate(yymsp[-2].minor.yy352, *(yymsp[0].minor.yy399));
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 279: /* exprx ::= CAST LP expr AS typetoken RP */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initCast(yymsp[-3].minor.yy352, yymsp[-1].minor.yy537);
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 280: /* exprx ::= ID LP distinct exprlist RP */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initFunction(yymsp[-4].minor.yy0->value, *(yymsp[-2].minor.yy146), *(yymsp[-1].minor.yy551));
                                                delete yymsp[-2].minor.yy146;
                                                delete yymsp[-1].minor.yy551;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 281: /* exprx ::= ID LP STAR RP */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initFunction(yymsp[-3].minor.yy0->value, true);
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 282: /* exprx ::= expr AND expr */
      case 283: /* exprx ::= expr OR expr */ yytestcase(yyruleno==283);
      case 284: /* exprx ::= expr LT|GT|GE|LE expr */ yytestcase(yyruleno==284);
      case 285: /* exprx ::= expr EQ|NE expr */ yytestcase(yyruleno==285);
      case 286: /* exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */ yytestcase(yyruleno==286);
      case 287: /* exprx ::= expr PLUS|MINUS expr */ yytestcase(yyruleno==287);
      case 288: /* exprx ::= expr STAR|SLASH|REM expr */ yytestcase(yyruleno==288);
      case 289: /* exprx ::= expr CONCAT expr */ yytestcase(yyruleno==289);
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initBinOp(yymsp[-2].minor.yy352, yymsp[-1].minor.yy0->value, yymsp[0].minor.yy352);
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 290: /* exprx ::= expr not_opt likeop expr */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initLike(yymsp[-3].minor.yy352, *(yymsp[-2].minor.yy451), *(yymsp[-1].minor.yy520), yymsp[0].minor.yy352);
                                                delete yymsp[-2].minor.yy451;
                                                delete yymsp[-1].minor.yy520;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 291: /* exprx ::= expr not_opt likeop expr ESCAPE expr */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initLike(yymsp[-5].minor.yy352, *(yymsp[-4].minor.yy451), *(yymsp[-3].minor.yy520), yymsp[-2].minor.yy352, yymsp[0].minor.yy352);
                                                delete yymsp[-4].minor.yy451;
                                                delete yymsp[-3].minor.yy520;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 292: /* exprx ::= expr ISNULL|NOTNULL */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initNull(yymsp[-1].minor.yy352, yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 293: /* exprx ::= expr NOT NULL */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initNull(yymsp[-2].minor.yy352, "NOT NULL");
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 294: /* exprx ::= expr IS not_opt expr */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initIs(yymsp[-3].minor.yy352, *(yymsp[-1].minor.yy451), yymsp[0].minor.yy352);
                                                delete yymsp[-1].minor.yy451;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 295: /* exprx ::= NOT expr */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initUnaryOp(yymsp[0].minor.yy352, yymsp[-1].minor.yy0->value);
                                            }
        break;
      case 296: /* exprx ::= BITNOT expr */
      case 298: /* exprx ::= PLUS expr */ yytestcase(yyruleno==298);
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initUnaryOp(yymsp[0].minor.yy352, yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 297: /* exprx ::= MINUS expr */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                if (yymsp[0].minor.yy352->mode == SqliteExpr::Mode::LITERAL_VALUE &&
                                                    parserContext->isCandidateForMaxNegativeNumber() &&
                                                    yymsp[0].minor.yy352->literalValue == static_cast<qint64>(0L))
                                                {
                                                    yygotominor.yy352->initLiteral(std::numeric_limits<qint64>::min());
                                                    delete yymsp[0].minor.yy352;
                                                }
                                                else
                                                {
                                                    yygotominor.yy352->initUnaryOp(yymsp[0].minor.yy352, yymsp[-1].minor.yy0->value);
                                                }
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 299: /* exprx ::= expr not_opt BETWEEN expr AND expr */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initBetween(yymsp[-5].minor.yy352, *(yymsp[-4].minor.yy451), yymsp[-2].minor.yy352, yymsp[0].minor.yy352);
                                                delete yymsp[-4].minor.yy451;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 300: /* exprx ::= expr not_opt IN LP exprlist RP */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initIn(yymsp[-5].minor.yy352, *(yymsp[-4].minor.yy451), *(yymsp[-1].minor.yy551));
                                                delete yymsp[-4].minor.yy451;
                                                delete yymsp[-1].minor.yy551;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 301: /* exprx ::= LP select RP */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initSubSelect(yymsp[-1].minor.yy473);
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 302: /* exprx ::= expr not_opt IN LP select RP */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initIn(yymsp[-5].minor.yy352, *(yymsp[-4].minor.yy451), yymsp[-1].minor.yy473);
                                                delete yymsp[-4].minor.yy451;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 303: /* exprx ::= expr not_opt IN nm dbnm */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initIn(yymsp[-4].minor.yy352, *(yymsp[-3].minor.yy451), *(yymsp[-1].minor.yy399), *(yymsp[0].minor.yy399));
                                                delete yymsp[-3].minor.yy451;
                                                delete yymsp[-1].minor.yy399;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 304: /* exprx ::= EXISTS LP select RP */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initExists(yymsp[-1].minor.yy473);
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 305: /* exprx ::= CASE case_operand case_exprlist case_else END */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initCase(yymsp[-3].minor.yy352, *(yymsp[-2].minor.yy551), yymsp[-1].minor.yy352);
                                                delete yymsp[-2].minor.yy551;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 306: /* exprx ::= RAISE LP IGNORE RP */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initRaise(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 307: /* exprx ::= RAISE LP raisetype COMMA nm RP */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                yygotominor.yy352->initRaise(yymsp[-3].minor.yy0->value, *(yymsp[-1].minor.yy399));
                                                delete yymsp[-1].minor.yy399;
                                                objectForTokens = yygotominor.yy352;
                                            }
        break;
      case 308: /* expr ::= */
{
                                                yygotominor.yy352 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy352;
                                                parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                            }
        break;
      case 312: /* likeop ::= LIKE_KW|MATCH */
{yygotominor.yy520 = new SqliteExpr::LikeOp(SqliteExpr::likeOp(yymsp[0].minor.yy0->value));}
        break;
      case 313: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
{
                                                yymsp[-4].minor.yy551->append(yymsp[-2].minor.yy352);
                                                yymsp[-4].minor.yy551->append(yymsp[0].minor.yy352);
                                                yygotominor.yy551 = yymsp[-4].minor.yy551;
                                            }
        break;
      case 314: /* case_exprlist ::= WHEN expr THEN expr */
{
                                                yygotominor.yy551 = new ParserExprList();
                                                yygotominor.yy551->append(yymsp[-2].minor.yy352);
                                                yygotominor.yy551->append(yymsp[0].minor.yy352);
                                            }
        break;
      case 321: /* nexprlist ::= nexprlist COMMA expr */
{
                                                yymsp[-2].minor.yy551->append(yymsp[0].minor.yy352);
                                                yygotominor.yy551 = yymsp[-2].minor.yy551;
                                                DONT_INHERIT_TOKENS("nexprlist");
                                            }
        break;
      case 322: /* nexprlist ::= exprx */
{
                                                yygotominor.yy551 = new ParserExprList();
                                                yygotominor.yy551->append(yymsp[0].minor.yy352);
                                            }
        break;
      case 323: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP sortlist RP where_opt */
{
                                                yygotominor.yy283 = new SqliteCreateIndex(
                                                        *(yymsp[-10].minor.yy451),
                                                        *(yymsp[-8].minor.yy451),
                                                        *(yymsp[-7].minor.yy399),
                                                        *(yymsp[-6].minor.yy399),
                                                        *(yymsp[-4].minor.yy399),
                                                        *(yymsp[-2].minor.yy163),
                                                        yymsp[0].minor.yy352
                                                    );
                                                delete yymsp[-8].minor.yy451;
                                                delete yymsp[-10].minor.yy451;
                                                delete yymsp[-7].minor.yy399;
                                                delete yymsp[-6].minor.yy399;
                                                delete yymsp[-4].minor.yy399;
                                                delete yymsp[-2].minor.yy163;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 324: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB */
{  yy_destructor(yypParser,179,&yymsp[-3].minor);
}
        break;
      case 329: /* idxlist_opt ::= */
{yygotominor.yy223 = new ParserIndexedColumnList();}
        break;
      case 330: /* idxlist_opt ::= LP idxlist RP */
{yygotominor.yy223 = yymsp[-1].minor.yy223;}
        break;
      case 331: /* idxlist ::= idxlist COMMA idxlist_single */
{
                                                yymsp[-2].minor.yy223->append(yymsp[0].minor.yy108);
                                                yygotominor.yy223 = yymsp[-2].minor.yy223;
                                                DONT_INHERIT_TOKENS("idxlist");
                                            }
        break;
      case 332: /* idxlist ::= idxlist_single */
{
                                                yygotominor.yy223 = new ParserIndexedColumnList();
                                                yygotominor.yy223->append(yymsp[0].minor.yy108);
                                            }
        break;
      case 333: /* idxlist_single ::= nm collate sortorder */
      case 334: /* idxlist_single ::= ID_COL */ yytestcase(yyruleno==334);
{
                                                SqliteIndexedColumn* obj =
                                                    new SqliteIndexedColumn(
                                                        *(yymsp[-2].minor.yy399),
                                                        *(yymsp[-1].minor.yy399),
                                                        *(yymsp[0].minor.yy309)
                                                    );
                                                yygotominor.yy108 = obj;
                                                delete yymsp[0].minor.yy309;
                                                delete yymsp[-2].minor.yy399;
                                                delete yymsp[-1].minor.yy399;
                                                objectForTokens = yygotominor.yy108;
                                            }
        break;
      case 338: /* cmd ::= DROP INDEX ifexists fullname */
{
                                                yygotominor.yy283 = new SqliteDropIndex(*(yymsp[-1].minor.yy451), yymsp[0].minor.yy360->name1, yymsp[0].minor.yy360->name2);
                                                delete yymsp[-1].minor.yy451;
                                                delete yymsp[0].minor.yy360;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 341: /* cmd ::= VACUUM */
{
                                                yygotominor.yy283 = new SqliteVacuum();
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 342: /* cmd ::= VACUUM nm */
{
                                                yygotominor.yy283 = new SqliteVacuum(*(yymsp[0].minor.yy399));
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 343: /* cmd ::= PRAGMA nm dbnm */
{
                                                yygotominor.yy283 = new SqlitePragma(*(yymsp[-1].minor.yy399), *(yymsp[0].minor.yy399));
                                                delete yymsp[-1].minor.yy399;
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 344: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 346: /* cmd ::= PRAGMA nm dbnm EQ minus_num */ yytestcase(yyruleno==346);
{
                                                yygotominor.yy283 = new SqlitePragma(*(yymsp[-3].minor.yy399), *(yymsp[-2].minor.yy399), *(yymsp[0].minor.yy469), true);
                                                delete yymsp[-3].minor.yy399;
                                                delete yymsp[-2].minor.yy399;
                                                delete yymsp[0].minor.yy469;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 345: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
      case 347: /* cmd ::= PRAGMA nm dbnm LP minus_num RP */ yytestcase(yyruleno==347);
{
                                                yygotominor.yy283 = new SqlitePragma(*(yymsp[-4].minor.yy399), *(yymsp[-3].minor.yy399), *(yymsp[-1].minor.yy469), false);
                                                delete yymsp[-4].minor.yy399;
                                                delete yymsp[-3].minor.yy399;
                                                delete yymsp[-1].minor.yy469;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 351: /* nmnum ::= nm */
{
                                                yygotominor.yy469 = new QVariant(*(yymsp[0].minor.yy399));
                                                delete yymsp[0].minor.yy399;
                                            }
        break;
      case 357: /* minus_num ::= MINUS number */
{
                                                if (yymsp[0].minor.yy469->type() == QVariant::Double)
                                                    *(yymsp[0].minor.yy469) = -(yymsp[0].minor.yy469->toDouble());
                                                else if (yymsp[0].minor.yy469->type() == QVariant::LongLong)
                                                {
                                                    if (parserContext->isCandidateForMaxNegativeNumber())
                                                        *(yymsp[0].minor.yy469) = std::numeric_limits<qint64>::min();
                                                    else
                                                        *(yymsp[0].minor.yy469) = -(yymsp[0].minor.yy469->toLongLong());
                                                }
                                                else
                                                    Q_ASSERT_X(true, "producing minus number", "QVariant is neither of Double or LongLong.");

                                                yygotominor.yy469 = yymsp[0].minor.yy469;
                                            }
        break;
      case 360: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END */
{
                                                yygotominor.yy283 = new SqliteCreateTrigger(
                                                        *(yymsp[-13].minor.yy146),
                                                        *(yymsp[-11].minor.yy451),
                                                        *(yymsp[-10].minor.yy399),
                                                        *(yymsp[-9].minor.yy399),
                                                        *(yymsp[-5].minor.yy399),
                                                        *(yymsp[-8].minor.yy132),
                                                        yymsp[-7].minor.yy552,
                                                        *(yymsp[-4].minor.yy3),
                                                        yymsp[-3].minor.yy352,
                                                        *(yymsp[-1].minor.yy430),
                                                        3
                                                    );
                                                delete yymsp[-11].minor.yy451;
                                                delete yymsp[-13].minor.yy146;
                                                delete yymsp[-8].minor.yy132;
                                                delete yymsp[-4].minor.yy3;
                                                delete yymsp[-10].minor.yy399;
                                                delete yymsp[-5].minor.yy399;
                                                delete yymsp[-9].minor.yy399;
                                                delete yymsp[-1].minor.yy430;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 361: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause */
{
                                                QList<SqliteQuery *> CL;

                                                yygotominor.yy283 = new SqliteCreateTrigger(
                                                        *(yymsp[-10].minor.yy146),
                                                        *(yymsp[-8].minor.yy451),
                                                        *(yymsp[-7].minor.yy399),
                                                        *(yymsp[-6].minor.yy399),
                                                        *(yymsp[-2].minor.yy399),
                                                        *(yymsp[-5].minor.yy132),
                                                        yymsp[-4].minor.yy552,
                                                        *(yymsp[-1].minor.yy3),
                                                        yymsp[0].minor.yy352,
                                                        CL,
                                                        3
                                                    );
                                                delete yymsp[-8].minor.yy451;
                                                delete yymsp[-10].minor.yy146;
                                                delete yymsp[-5].minor.yy132;
                                                delete yymsp[-1].minor.yy3;
                                                delete yymsp[-7].minor.yy399;
                                                delete yymsp[-2].minor.yy399;
                                                delete yymsp[-6].minor.yy399;
                                                objectForTokens = yygotominor.yy283;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 362: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list */
{
                                                yygotominor.yy283 = new SqliteCreateTrigger(
                                                *(yymsp[-12].minor.yy146),
                                                *(yymsp[-10].minor.yy451),
                                                *(yymsp[-9].minor.yy399),
                                                *(yymsp[-8].minor.yy399),
                                                *(yymsp[-4].minor.yy399),
                                                *(yymsp[-7].minor.yy132),
                                                yymsp[-6].minor.yy552,
                                                *(yymsp[-3].minor.yy3),
                                                yymsp[-2].minor.yy352,
                                                *(yymsp[0].minor.yy430),
                                                3
                                                );
                                                delete yymsp[-10].minor.yy451;
                                                delete yymsp[-12].minor.yy146;
                                                delete yymsp[-7].minor.yy132;
                                                delete yymsp[-3].minor.yy3;
                                                delete yymsp[-9].minor.yy399;
                                                delete yymsp[-4].minor.yy399;
                                                delete yymsp[-8].minor.yy399;
                                                delete yymsp[0].minor.yy430;
                                                objectForTokens = yygotominor.yy283;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 363: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB */
{  yy_destructor(yypParser,181,&yymsp[-8].minor);
  yy_destructor(yypParser,179,&yymsp[-5].minor);
  yy_destructor(yypParser,265,&yymsp[-3].minor);
  yy_destructor(yypParser,266,&yymsp[-2].minor);
}
        break;
      case 366: /* trigger_time ::= BEFORE */
{yygotominor.yy132 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::BEFORE);}
        break;
      case 367: /* trigger_time ::= AFTER */
{yygotominor.yy132 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::AFTER);}
        break;
      case 368: /* trigger_time ::= INSTEAD OF */
{yygotominor.yy132 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::INSTEAD_OF);}
        break;
      case 369: /* trigger_time ::= */
{yygotominor.yy132 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::null);}
        break;
      case 370: /* trigger_event ::= DELETE */
{
                                                yygotominor.yy552 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::DELETE);
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 371: /* trigger_event ::= INSERT */
{
                                                yygotominor.yy552 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::INSERT);
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 372: /* trigger_event ::= UPDATE */
{
                                                yygotominor.yy552 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::UPDATE);
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 373: /* trigger_event ::= UPDATE OF idlist */
{
                                                yygotominor.yy552 = new SqliteCreateTrigger::Event(*(yymsp[0].minor.yy95));
                                                delete yymsp[0].minor.yy95;
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 374: /* foreach_clause ::= */
{yygotominor.yy3 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::null);}
        break;
      case 375: /* foreach_clause ::= FOR EACH ROW */
{yygotominor.yy3 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::FOR_EACH_ROW);}
        break;
      case 378: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
{
                                                yymsp[-2].minor.yy430->append(yymsp[-1].minor.yy283);
                                                yygotominor.yy430 = yymsp[-2].minor.yy430;
                                                DONT_INHERIT_TOKENS("trigger_cmd_list");
                                            }
        break;
      case 379: /* trigger_cmd_list ::= trigger_cmd SEMI */
{
                                                yygotominor.yy430 = new ParserQueryList();
                                                yygotominor.yy430->append(yymsp[-1].minor.yy283);
                                            }
        break;
      case 380: /* trigger_cmd_list ::= SEMI */
{
                                                yygotominor.yy430 = new ParserQueryList();
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 385: /* raisetype ::= ROLLBACK|ABORT|FAIL */
{yygotominor.yy0 = yymsp[0].minor.yy0;}
        break;
      case 386: /* cmd ::= DROP TRIGGER ifexists fullname */
{
                                                yygotominor.yy283 = new SqliteDropTrigger(*(yymsp[-1].minor.yy451), yymsp[0].minor.yy360->name1, yymsp[0].minor.yy360->name2);
                                                delete yymsp[-1].minor.yy451;
                                                delete yymsp[0].minor.yy360;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 389: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
{
                                                yygotominor.yy283 = new SqliteAttach(*(yymsp[-4].minor.yy451), yymsp[-3].minor.yy352, yymsp[-1].minor.yy352, yymsp[0].minor.yy352);
                                                delete yymsp[-4].minor.yy451;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 390: /* cmd ::= DETACH database_kw_opt expr */
{
                                                yygotominor.yy283 = new SqliteDetach(*(yymsp[-1].minor.yy451), yymsp[0].minor.yy352);
                                                delete yymsp[-1].minor.yy451;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 395: /* cmd ::= REINDEX */
{yygotominor.yy283 = new SqliteReindex();}
        break;
      case 396: /* cmd ::= REINDEX nm dbnm */
      case 397: /* cmd ::= REINDEX ID_COLLATE */ yytestcase(yyruleno==397);
{
                                                yygotominor.yy283 = new SqliteReindex(*(yymsp[-1].minor.yy399), *(yymsp[0].minor.yy399));
                                                delete yymsp[-1].minor.yy399;
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 400: /* cmd ::= ANALYZE */
{
                                                yygotominor.yy283 = new SqliteAnalyze();
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 401: /* cmd ::= ANALYZE nm dbnm */
{
                                                yygotominor.yy283 = new SqliteAnalyze(*(yymsp[-1].minor.yy399), *(yymsp[0].minor.yy399));
                                                delete yymsp[-1].minor.yy399;
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 404: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
{
                                                yygotominor.yy283 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy360->name1,
                                                        yymsp[-3].minor.yy360->name2,
                                                        *(yymsp[0].minor.yy399)
                                                    );
                                                delete yymsp[0].minor.yy399;
                                                delete yymsp[-3].minor.yy360;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 405: /* cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column */
{
                                                yygotominor.yy283 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy360->name1,
                                                        yymsp[-3].minor.yy360->name2,
                                                        *(yymsp[-1].minor.yy451),
                                                        yymsp[0].minor.yy227
                                                    );
                                                delete yymsp[-1].minor.yy451;
                                                delete yymsp[-3].minor.yy360;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 406: /* cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW */
{  yy_destructor(yypParser,183,&yymsp[-3].minor);
}
        break;
      case 412: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm */
{
                                                yygotominor.yy283 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-4].minor.yy451),
                                                        *(yymsp[-3].minor.yy399),
                                                        *(yymsp[-2].minor.yy399),
                                                        *(yymsp[0].minor.yy399)
                                                    );
                                                delete yymsp[-4].minor.yy451;
                                                delete yymsp[-3].minor.yy399;
                                                delete yymsp[-2].minor.yy399;
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 413: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP */
{
                                                yygotominor.yy283 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-7].minor.yy451),
                                                        *(yymsp[-6].minor.yy399),
                                                        *(yymsp[-5].minor.yy399),
                                                        *(yymsp[-3].minor.yy399),
                                                        *(yymsp[-1].minor.yy95)
                                                    );
                                                delete yymsp[-6].minor.yy399;
                                                delete yymsp[-5].minor.yy399;
                                                delete yymsp[-3].minor.yy399;
                                                delete yymsp[-7].minor.yy451;
                                                delete yymsp[-1].minor.yy95;
                                                objectForTokens = yygotominor.yy283;
                                            }
        break;
      case 416: /* vtabarglist ::= vtabarg */
{
                                                yygotominor.yy95 = new QStringList();
                                                yygotominor.yy95->append((yymsp[0].minor.yy399)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                delete yymsp[0].minor.yy399;
                                            }
        break;
      case 417: /* vtabarglist ::= vtabarglist COMMA vtabarg */
{
                                                yymsp[-2].minor.yy95->append((yymsp[0].minor.yy399)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                yygotominor.yy95 = yymsp[-2].minor.yy95;
                                                delete yymsp[0].minor.yy399;
                                                DONT_INHERIT_TOKENS("vtabarglist");
                                            }
        break;
      case 419: /* vtabarg ::= vtabarg vtabargtoken */
{
                                                yymsp[-1].minor.yy399->append(" "+ *(yymsp[0].minor.yy399));
                                                yygotominor.yy399 = yymsp[-1].minor.yy399;
                                                delete yymsp[0].minor.yy399;
                                            }
        break;
      case 420: /* vtabargtoken ::= ANY */
{
                                                yygotominor.yy399 = new QString(yymsp[0].minor.yy0->value);
                                            }
        break;
      case 421: /* vtabargtoken ::= LP anylist RP */
{
                                                yygotominor.yy399 = new QString("(");
                                                yygotominor.yy399->append(*(yymsp[-1].minor.yy399));
                                                yygotominor.yy399->append(")");
                                                delete yymsp[-1].minor.yy399;
                                            }
        break;
      case 423: /* anylist ::= anylist LP anylist RP */
{
                                                yygotominor.yy399 = yymsp[-3].minor.yy399;
                                                yygotominor.yy399->append("(");
                                                yygotominor.yy399->append(*(yymsp[-1].minor.yy399));
                                                yygotominor.yy399->append(")");
                                                delete yymsp[-1].minor.yy399;
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 424: /* anylist ::= anylist ANY */
{
                                                yygotominor.yy399 = yymsp[-1].minor.yy399;
                                                yygotominor.yy399->append(yymsp[0].minor.yy0->value);
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 425: /* with ::= */
{yygotominor.yy321 = nullptr;}
        break;
      case 426: /* with ::= WITH wqlist */
{
                                                yygotominor.yy321 = yymsp[0].minor.yy321;
                                                objectForTokens = yygotominor.yy321;
                                            }
        break;
      case 427: /* with ::= WITH RECURSIVE wqlist */
{
                                                yygotominor.yy321 = yymsp[0].minor.yy321;
                                                yygotominor.yy321->recursive = true;
                                                objectForTokens = yygotominor.yy321;
                                            }
        break;
      case 428: /* wqlist ::= nm idxlist_opt AS LP select RP */
{
                                                yygotominor.yy321 = SqliteWith::append(*(yymsp[-5].minor.yy399), *(yymsp[-4].minor.yy223), yymsp[-1].minor.yy473);
                                                delete yymsp[-5].minor.yy399;
                                                delete yymsp[-4].minor.yy223;
                                            }
        break;
      case 429: /* wqlist ::= wqlist COMMA nm idxlist_opt AS LP select RP */
{
                                                yygotominor.yy321 = SqliteWith::append(yymsp[-7].minor.yy321, *(yymsp[-5].minor.yy399), *(yymsp[-4].minor.yy223), yymsp[-1].minor.yy473);
                                                delete yymsp[-5].minor.yy399;
                                                delete yymsp[-4].minor.yy223;
                                                DONT_INHERIT_TOKENS("wqlist");
                                            }
        break;
      case 430: /* wqlist ::= ID_TAB_NEW */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy321 = new SqliteWith();
                                            }
        break;
      default:
      /* (0) input ::= cmdlist */ yytestcase(yyruleno==0);
        break;
      };
  }
  assert( yyruleno>=0 && yyruleno<(int)(sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0])) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;

  // Store tokens for the rule in parser context
  QList<Token*> allTokens;
  QList<Token*> allTokensWithAllInherited;
  QString keyForTokensMap;
  int tokensMapKeyCnt;
  if (parserContext->setupTokens)
  {
      if (objectForTokens)
      {
          // In case this is a list with recurrent references we need
          // to clear tokens before adding the new and extended list.
          objectForTokens->tokens.clear();
      }

      QList<Token*> tokens;
      for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
      {
          tokens.clear();
          const char* fieldName = yyTokenName[yypParser->yystack[i].major];

          // Adding token being subject of this reduction. It's usually not includes in the inherited tokens,
          // although if inheriting from simple statements, like "FAIL" or "ROLLBACK", this tends to be redundant with the inherited tokens.
          // That's why we're checking if it's not contained in the inherited tokens and add it only then.
          if (parserContext->isManagedToken(yypParser->yystack[i].minor.yy0) && !yypParser->yystack[i].tokens->contains(yypParser->yystack[i].minor.yy0))
              tokens += yypParser->yystack[i].minor.yy0;

          tokens += *(yypParser->yystack[i].tokens);

          if (!noTokenInheritanceFields.contains(fieldName))
          {
              if (objectForTokens)
              {
                  keyForTokensMap = fieldName;
                  tokensMapKeyCnt = 2;
                  while (objectForTokens->tokensMap.contains(keyForTokensMap))
                      keyForTokensMap = fieldName + QString::number(tokensMapKeyCnt++);

                  objectForTokens->tokensMap[keyForTokensMap] = parserContext->getTokenPtrList(tokens);
              }

              allTokens += tokens;
          }
          else
          {
              // If field is mentioned only once, then only one occurance of it will be ignored.
              // Second one should be inherited. See "anylist" definition for explanation why.
              noTokenInheritanceFields.removeOne(fieldName);
          }
          allTokensWithAllInherited += tokens;
      }
      if (objectForTokens)
      {
          objectForTokens->tokens += parserContext->getTokenPtrList(allTokens);
      }
  }

  // Clear token lists
  for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
  {
      delete yypParser->yystack[i].tokens;
      yypParser->yystack[i].tokens = nullptr;
  }

  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
      if (parserContext->setupTokens)
          *(yypParser->yystack[yypParser->yyidx].tokens) = allTokens;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
      if (parserContext->setupTokens)
      {
          QList<Token*>* tokensPtr = yypParser->yystack[yypParser->yyidx].tokens;
          *tokensPtr = allTokensWithAllInherited + *tokensPtr;
      }
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3_parseARG_FETCH;
#define TOKEN (yyminor.yy0)

    UNUSED_PARAMETER(yymajor);
    parserContext->error(TOKEN, QObject::tr("Syntax error"));
    //qDebug() << "near " << TOKEN->toString() << ": syntax error";
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3_parseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3_parseTOKENTYPE yyminor       /* The value for the token */
  sqlite3_parseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
    yypParser->yystack[0].tokens = new QList<Token*>();
  }
  yyminorunion.yy0 = yyminor;
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif
  sqlite3_parseARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s [%s] (lemon type: %s)\n",
            yyTracePrompt,
            yyminor->value.toLatin1().data(),
            yyminor->typeString().toLatin1().data(),
            yyTokenName[yymajor]);  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;

#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
