# ChangeLog

### 3.3.3
- CHANGE: #4011 SQLite updated to 3.35.4. SQLite3MultipleCiphers updated to 1.2.4 (SQLite 3.35.4). This enables math functions from 3.35. SQLCipher updated to 4.4.3, which is only SQLite 3.34.1, so no math functions for SQLCipher.
- CHANGE: #4028 Open databases are now expanded upon startup only if they were expanded during application shutdown.
- BUGFIX: #4044 SQLite linking restored to dynamic model (separate so/dll/dylib file), so users can replace the SQLite library at any moment with more recent version.
- BUGFIX: #4017 New Table/View buttons are now always enabled, as recently Table/View window got their own database dropdowns.
- BUGFIX: #4012 Fixed Import/Export wizard windows when using Fusion Dark theme.
- BUGFIX: #4010 Fixed result column sizing for EXPLAIN queries.
- BUGFIX: #4059 Fixed crash when using empty string in SQL queries.
- BUGFIX: #4034 Fixed DEFAULT value column rendering in Table Window.
- BUGFIX: #4035 Fixed full value loading for expression result columns. Also fixed smart executor for queries with aliased views as data source.
- BUGFIX: #4043 Portable directory functionality fixed after it was broken in some prior 3.3.x version.
- BUGFIX: #4049 Fixed bringing primary instance of the application to the front when secondary instance is started (and forbidden).
- BUGFIX: #4060 SQL Export plugin now excludes GENERATED columns from INSERT statements.

### 3.3.2
- BUGFIX: #4018 Fixed SQL formatter to not add ' to numbers and star operators. Added unit tests for SQL Enterprise Formatter.
- BUGFIX: #4019 Parenthesis pair highlighting now uses different color scheme than text selection highlighting, to avoid confusion of what is selected and what is not.

### 3.3.1
- CHANGE: #4005 The limit of rows number applied for results with lots of columns can now be disabled in options.
- BUGFIX: #3996 Fixed SQL formatter to not remove the ' from strings.
- BUGFIX: #3998 Foreign Key dropdown behavior fixed to allow custom values.
- BUGFIX: #3987 Further enhancements to HighDPI scaling support.

### 3.3.0
- ADDED: #3409 The Dark theme.
- ADDED: #3763 Generated Columns support added.
- ADDED: #3471 Window Functions support added.
- ADDED: #3470 UPDATE FROM clause support added.
- ADDED: #3470 VACUUM INTO clause support added.
- ADDED: #3266 Added Ctrl+Q and entry in menu for quitting the application.
- ADDED: #3456 Added option to allow multiple instances of the application running at the same time.
- ADDED: #3975 Database dropdowns added to table & view windows, to it's more clear to which database particular object belongs. The same database dropdown in SQL Editor is moved to the left side, to be more consistent across the application. Main toolbar ha snow way less unnecessary buttons.
- CHANGE: Windows binaries are now 64-bit.
- CHANGE: SQLite2 plugin removed due to harder and harder maintenance of SQLite2 library compilation.
- CHANGE: Minumum Qt version now is 5.12.0.
- CHANGE: #3470 SQLite upgraded to 3.34.1. From now on the core SQLite3 library is bounded together with application (no longer a separate library).
- CHANGE: #3494 DbSqliteCipher (SQLCipher) upgraded to 4.4.2 (SQLite 3.34.0).
- CHANGE: #3954 DbSqliteWx plugin migrated to SQLite3MultipleCiphers 1.1.4 (SQLite 3.34.1).
- CHANGE: #3470 Updated list of functions and pragmas for code assistant.
- CHANGE: #3583 When committing multiple rows, all rows are attempted at once, despite errors in prior rows, so that all constraint violations are identified immediately. Also added individual error message to cell tooltip, so user can learn which particular violation caused which row failure.
- CHANGE: #3269 Enhanced handling of big data cells - they are still limited at first, but now there is an indicator (button) showing up when there is more to load and user can press it to load full data for the cell. User can also load full values in entire column using right-click on the column's header and picking option from context menu.
- CHANGE: #3626 Installer (Qt's Installer Framework) was removed. Updates will still be checked and user will be notified about new version being available, but it will be up to the user to download new version. Only portable packages are going to be provided from now, until more suitable installer framework is found & mastered.
- BUGFIX: #3046 HighDPI support fixed.
- BUGFIX: #3385 Fixed "Sort" checkbox for AUTOINCREMENT to have it disabled if AUTOINCREMENT is selected (SQLite does not allow ordering autoincremented primary keys).
- BUGFIX: #3390 Number of primary keys restricted in table/column dialogs, so only one per table is allowed.
- BUGFIX: #3421 Fixed unexpected database list panel shrinking when clicking on some items from that list.
- BUGFIX: #3446 Fixed ResCol_0 appearing when selecting from view that does basic SELECT * from a table.
- BUGFIX: Fixed crash when selected one or more empty lines (new line characters) end executing it.
- BUGFIX: #3564 Fixed inifinite loop of language choice when configuration file could not be created.
- BUGFIX: #3549 Fixed support for numbered bind parameters.
- BUGFIX: #291 Fixed named bind parameters dialog, so user will be prompted only once per unique parameter name when executing query with multiple uses of the same parameter.
- BUGFIX: #3537 Fixed pasting to grid, so pasting to read-only cells is no longer possible.
- BUGFIX: #3489 Default values of literal string are now properly previewed to user right after using them in Table Window (the '' enclosing quotes are removed).
- BUGFIX: #3490 Fixed missing string quoting when using "Go to referenced table" action.
- BUGFIX: #3485 Row limiting message now appears only when it affects number rows displayed, not just because it changes upper limit.
- BUGFIX: #3485 Row limit decreased. Previous one was too high (150 000 cells at once), causeing too long freeze of application on weaker computers. New limit is 50 000 cells at once.
- BUGFIX: #3499 Fixed generator for SELECT queries from grid view context menu to quote multi-word columns properly. 
- BUGFIX: #3481 CSS entered in CSS Console (F11) are now persisted and restored for each run.
- BUGFIX: #3736 Transaction statements are excluded from direct execution of entire SQL file at once from database context menu. Also improved the process to refresh schema afterwards.
- BUGFIX: #3478 Fixed crash when attempting to execute comment as a query.
- BUGFIX: #3525 Fixed crash when editing (adding/deleting) JOIN part in INNER JOIN.
- BUGFIX: #3479 Fixed invalid XML exported for trigger.
- BUGFIX: #3474 Fixed crash when right-clicking on empty are in data view.
- BUGFIX: #3418 Fixed crash when importing file with a lot of error-raising rows.
- BUGFIX: #3413 #3614 #3520 #3403 Fixed import of CSV files with Unix-style line endings.
- BUGFIX: #3464 Fixed crash when trying to edit cell, which has duplicated foreign key (column level and table level).
- BUGFIX: #3459 Fixed "fallback" keywords highlighting used in "ID" context, such as replace() function, etc. Also fixed desynchronized error highlighting when typing quickly.
- BUGFIX: #3453 Fixed parenthesis highlighting.
- BUGFIX: #3936 Cleaned up almost all warnings from Qt 5.12 & 5.15 (fixing few minor bugs on the way) so that any important warnings are not missed.
- BUGFIX: #3445 #3777 Detecting correctly current query boundries when executing a query - especially in context of CREATE TRIGGER.
- BUGFIX: #3440 SELECT resolver improved to work better with CTE statements (WITH ... SELECT ...).
- BUGFIX: #3431 Fixed Index Dialog - it was basically impossible to edit existing index, if index had a collation defined.
- BUGFIX: #3452 Fixed XML export with CDATA quoting if the value contains CDATA end tag.
- BUGFIX: #3451 Fixed XML export to escape properly all unguarded values & fixed VIRTUAL TABLE export to produce appropriate tag names.
- BUGFIX: #3422 Improved handling of SQLite's internal indexes, so SQLiteStudio not only shows them now, but also figures out their DDL, so that user can preview it in dialogs/windows.
- BUGFIX: #3582 Fixed disappearing table (only on the view, not physically) from source database when moving it to another databasein case of failed movement. Now the source database schema is refreshed after failure to show that the table is still there.
- BUGFIX: #3580 Limiting view depth to 1 for query smart executor, so that it's impossible to build up unbilivebly huge queries by expending multi-level views, which result in unoptimized, slow queries.
- BUGFIX: #3959 Fixed SQL export plugin, so it respects table name for INSERT statements, even though CREATE TABLE statement export was not enabled.
- BUGFIX: #3941 Column is no longer resized if user set his own width as desired and then he edits values in cells.
- BUGFIX: #3857 Fixed parser so it accepts string as first part of object path (id.id or id.id.id).
- BUGFIX: #3136 Updated configuration path candidates to include Qt's standard path for app configuration. Even then if all paths fail, the app will ask user for writable directory.
- BUGFIX: #3760 Removed warning about not restored View window from the temporary database.
- BUGFIX: #3720 Fixed which header columns are copied with using "Copy with header" context menu action on the data grid.
- BUGFIX: #3698 Fixed issue with manual page typing in dataview. If the number entered was same as current page, it blocked further page changes due to a dead-lock.
- BUGFIX: #3639 When deleting row that was just inserted but not committed yet, the app will ask for user confirmation whether to permanently delete the new rows.
- BUGFIX: #3586 Fixed "full value loading" query for not editable cells (expression values), so it properly loads the full value for example if copying value.
- BUGFIX: #3588 Fixed transactional commit of all pending modifications to a data view. No more disappearing values in new rows when re-editing violated constraints.
- BUGFIX: #3324 Fixed FK dropdown to work properly with long values (longer than 100 characters).
- BUGFIX: #3980 Fixed detokenizer for expressions, so the SELECT 1='1' no longer returns true.
- BUGFIX: #3787 Field state indicator now shows popup (the message) immediately after pointing it with a mouse, instead of having a delay.
- BUGFIX: #3550 After successful data import, a number of rows imported is included in the notification message.
- BUGFIX: #3415 Fixed release build scripts on all platforms.

### 3.2.1
- BUGFIX: #3399 Fixed start under Linux using the pre-compiled binary distributions (it used to fail due to missing xcb dependency).
- BUGFIX: #3398 Fixed 'export data' checkbox in export dialog to not ignore it anymore.
- BUGFIX: Binary packages now include the MultiEditorImage plugin, which introduces the picture preview for BLOB values. It was introduced in 3.2.0, but missing in binary distributions.

### 3.2.0
- NEW: #3188 New plugin to have images stored in database being visible as another tab in the Form View or cell's editor dialog window.
- NEW: #3207 #1444 #2547 Export, Import & Populate dialog settings are remembered, even after application restart.
- NEW: #3268 Query bind parameters are now supported by the query editor while execution - user will be asked for values for these parameters in a dedicated dialog.
- NEW: #3267 Added Extension Manager window, where all SQLite extensions can be registered for loading into databases.
- NEW: #3161 Added support for table-valued functions (https://sqlite.org/vtab.html#tabfunc2)
- NEW: #3349 Added support for UPSERT syntax from SQLite 3.24.0.
- NEW: #3292 Added possibility to execute huge SQL files directly from disk, without loading them to SQL Editor.
- NEW: #3265 Completely new installer for SQLiteStudio is introduced. It bases on Qt Installer Framework. This addresses numerous issues with automatic updates that SQLiteStudio had. It also allows for some new features, like automatic file association under Windows (#3178). Portable (download & run, without installation) distribution continues to be available.
- NEW: #2659 AutoIncrement option is now always available in PK configuration dialog. When AutoIncrement is enabled, a datatype will be enforced to INTEGER type.
- NEW: #2798 Added filter inputs per column as an option.
- NEW: #3224 Added context menu for SQL history tab to delete individual (or a range of selected) entries. Also a "delete" key can be used.
- NEW: #2651 Only a single instance of SQLiteStudio can be running at the time. If another instance is requested, the first one will be brought to the front of windows stack. If another instance was requested due to associated file being open, then the first instance will not only be raised, but also the requested file will be added to database list as temporary, volatile database (not added permanently to configuration).
- NEW: #3033 Ctrl+Shift+c copies data including headers. Also context menu entry added for the same.
- NEW: #2962 Pasting single value to multiple cells results in pasting the value into all selected cells, not just to first one.
- NEW: #2907 The "Open file's directory" menu item added to database list for database nodes.
- NEW: #3388 Added file association entries in the plist for MacOSX
- NEW: #3163 Added menubar accelerator keys.
- CHANGE: #3257 #3260 #3271 Bug/Feature reports are now completely managed by GitHub. Bug report dialog is no longer present in the application, but instead the menu entry opens web browser on project's GitHub page.
- CHANGE: #3285 SQLCipher and wxSQLite3 plugins can now be linked to system-provided libraries, which is especially useful under Linux. Instructions were added to the wiki page: https://github.com/pawelsalawa/sqlitestudio/wiki/Instructions_for_compilation_under_Linux#linking-with-system-provided-libraries
- CHANGE: #3284 SQLite3 upgraded to version 3.24.0 (excluding SQLCipher plugin, which is still on 3.20.1).
- CHANGE: API of QueryExecutor enhanced to provide custom steps at certain stages of execution. Steps can be injected by plugins.
- CHANGE: #3121 Column widths are kept between data reloads.
- CHANGE: #3024 Edit in editor action in cell's context menu stands now "show in viewer" if clicked on read-only cell. Also "set null" and "erase" are not displayed if none of selected cells is editable.
- CHANGE: #3142 Horizontal scroll position is now preserved between sort request on a data view.
- CHANGE: #2971 Column width is now mostly based on data width, not header width, but if there is little columns to be displayed, the header width is also considered.
- CHANGE: #3323 Disabled automatic line wrapping in SQL editor and all other code edition fields in the application.
- BUGFIX: #3259 #3215 #3327 Stop interpreting "+3" or "0010" as numeric types if entered to TEXT column (or any other column not declared as numeric-ish).
- BUGFIX: #3191 CSV import speed improved. It's 1400 times faster. It's not a joke. The bug used to cause the import to be terribly slow. Also other importing plugins gained around 400% of speed.
- BUGFIX: #3119 Fixed extra "empty" row of data when importing from CSV with a new, empty line at the end.
- BUGFIX: #3235 Crash when opening DB dialog, but file was moved.
- BUGFIX: #3185 Fixed creation of new tables/views if "Data" tab is configured as first.
- BUGFIX: #3279 Fixed reporting rows affected with DELETE statement for SQLite2.
- BUGFIX: #3023 Optimized SQL editor widget to work with huge contents.
- BUGFIX: Fixed random crashes at application close (when saving session). Most frequend on Windows platform.
- BUGFIX: #3252 Fixed first character input when starting to edit FK column data.
- BUGFIX: #3251 Fixed DEFAULT constraint dialog to work wit "literal values in double-quotes"
- BUGFIX: #3084 #3085 Fixed beeps under MacOSX when editing FK cell.
- BUGFIX: #3293 Fixed deault shortcut for code assistant under MacOSX from Cmd-Space to Ctrl-Space, so it does not conflict with Spotlight
- BUGFIX: #3190 Fixed handling WITHOUT ROWID and unusual column name.
- BUGFIX: #3177 Fixed tab indentations when selecting even part of a line.
- BUGFIX: #3171 Pasting object to same database is prevented.
- BUGFIX: #3176 Fixed exporting with Common Table Expression (the WITH statement).
- BUGFIX: #3162 Fixed order of column headers in Index Dialog
- BUGFIX: #3159 Fixed dictionary populating plugin to recognize different new-line characters.
- BUGFIX: #3156 Fixed recognition of double-quoted values.
- BUGFIX: #3093 Columns with AUTOINCREMENT statement are defaulted to null for new rows in Form View, so they get committed this way (unless manually changed) and they become an auto generated values.
- BUGFIX: #3086 #3187 Fixed internal task ordering when drag&dropping tasks on the taskbar, so switching between tasks with keyboard shortcut reflects order of tasks on the taskbar.
- BUGFIX: #3173 Added support for detecting and trimming whitespace in pasted text (thanks to nishanthkarthik for contributing this)
- BUGFIX: #2922 Fixed CTE execution by QueryExecutor, so it understands columns from CTE (not editable columns for now, maybe will become editable in future).
- BUGFIX: #2964 SQL history tab shows now local time of execution, not UTC.
- BUGFIX: #3290 Fixed querying data for FK dropdown from tables/columns with unusual characters in name. Also fixed name-wrapping for objects that have unescaped wrapper character inside of their name.
- BUGFIX: #3305 Introduced dynamic limit for number of rows per page - based on number of columns, so it's less likely to hit the memory limit.
- BUGFIX: #3311 Fixed floating point numbers handling.
- BUGFIX: #3383 Fixed JSON export plugin for quoted names.
- BUGFIX: #3347 #3351 Fixed QCheckBox in several places, so text() of it is not used as a valid data. This is to address issues with automatic accelerator keys.
- BUGFIX: Addressed some concurrency erorrs in SQLite 2 plugin
- BUGFIX: #3139 #3116 #3326 #3341 Various code compiling issues addressed.
- BUGFIX: #3145 #3165 #3179 Fixed various typos in messages/interface.
- BUGFIX: #3333 Fixed unit test to honor new features of TableModifier, but also fixed few bugs in TableModifier.
- BUGFIX: #3277 Open Source license issues addressed (specific exceptions for OpenSSL and icons)
- BUGFIX: #2966 Application icon added to package.
- BUGFIX: Few other bugfixes made on the fly, while working on other issues.

### 3.1.1
- ADDED: WxSQLite3 plugin (with encryption support).
- ADDED: System.Data.SQLite plugin (ADO.NET, includes encryption support).
- ADDED: Support for "Row Value" introduced in SQLite 3.15.0.
- ADDED: New option in configuration dialog to decide whether you want to keep NULL values when entering empty strings in cells (new, more intuitive behavior), or overwrite NULLs with empty string values (as it used to be so far).
- ADDED: Editor window has now "Find" and "Replace" toolbar buttons for those functions (which were already there, available under shortcuts).
- ADDED: New built-in functions: import(), import_formats(), import_options() and charset(). All described on SQLiteStudio's wiki (at User Manual page).
- ADDED: #3106 ScriptingTcl has now "tcl_init" command to invoke full interpreter initialization, which creates [clock] commands and some others. It's not invoked automatically to avoid performane issues.
- ADDED: #3136 Added "--master-config" command line option to have a settings file (regular SQLiteStudio config file) that all running SQLiteStudio instances import settings from. More details in manual on wiki page.
- ADDED: #3127 Added 'select all' and 'deselect all' buttons in tigger's UPDATE OF columns dialog.
- CHANGE: #3135 Re-enabled possibility to close database list panel (and reopen it from the View menu entry).
- CHANGE: #2901 Automatically generated database name includes full file name, except for the file extension only (unlike before, when it took only a file name up to the first dot).
- CHANGE: #3140 The "generate name automatically" checkbox has been removed. Now the name is generated automatically by default, unless user starts to edit the name manually.
- BUGFIX: #3118 #3124 #2943 Fixed double precision numbers formatting.
- BUGFIX: DbAndroid plugin: Fixed 'adb' automatic detection under Linux.
- BUGFIX: #3126 #3092 Fixed problem with database versions in Android plugin.
- BUGFIX: #3155 Fixed crash when confiriming custom FK value with Enter key.
- BUGFIX: #3094 #3095 Fixed default FK value preselection when tabbing through cells.
- BUGFIX: #3154 Fixed crash when mass replacing token to another token containing initial token.
- BUGFIX: Fixed query generation for "UPDATE" and "DELETE" when invoking it from Database List context menu for the table.
- BUGFIX: Fixed Ctrl+click (Cmd+click on MacOSX) handling of object names that require name wrapping (such as names with spaces in it).
- BUGFIX: #3133 Fixed resolving tables with unusual (like cyrillic) characters in their names.
- BUGFIX: #3096 Restored data editing by Return key hit, that got broken in 3.1.0 for MacOSX.
- BUGFIX: #3122 Several tweaks to Android shell mode connection.
- BUGFIX: #3093 Fixed memory leak in Android plugin.
- BUGFIX: #3132 Fixed column resolving in a View that uses same alias for two different columns.
- BUGFIX: Fixed importing Windows and Macintosh end-line format CSV files (handling \r\n and \r properly).
- BUGFIX: #3134 Fixed recognizing CREATE TRIGGER statements properly when CASE-WHEN-END is used inside.
- BUGFIX: #3112 Fixed Foreign Key editing when the foreign table was modified (for example renamed) and the local column was already presented in the data view.
- BUGFIX: #3113 DEFAULT value is now automatically inserted only when committing NULL for NOT NULL column. Also new option is introduced to use DEFAULT always for NULL values, regardles of NOT NULL constraint.
- BUGFIX: Fixed refreshing database list view when changing labels display settings in configuration dialog.
- BUGFIX: Fixed FormView row navigation shortcuts.
- BUGFIX: #3097 Fixed alphabetical ordering when exporting entire database.
- BUGFIX: Fixed "UPDATE OF" column list formatting (indentation) in Enterprise Formater plugin.
- BUGFIX: Fixed SqlSimpleFormatter plugin to add ";" at the end of CREATE TABLE statements while exporting database schema to SQL format.
- BUGFIX: Data view fonts now apply to other tabs in the table window and view window.
- BUGFIX: #3005 Fixed performance issue with lots of big values loaded into the grid. Also fixed editing those values using the inline cell editor.
- BUGFIX: #2938 Fixed query executor to idenfity properly tables in named subselects, to the ROWID is handled correctly.
- BUGFIX: #3168 Fixed data filter field in data view, so it handles the single quote character.
- BUGFIX: #2942 Erasing table data context menu option now honors multiple table selection.
- BUGFIX: #2900 Optimized execution of thousands of queries at once in SQL editor window.
- BUGFIX: #2934 Table foreign key dialog can now refer to the same table. So far only column dialog constraint for FK could do it.
- BUGFIX: #3120 Performance of SQL editor window greatly increased when working with huge sets if queries (like thousands).
- BUGFIX: #3028 Fixed formatter for "NOT EXISTS" expression.
- BUGFIX: #2990 Fixed handling scientific numbers notation.
- BUGFIX: #2987 Fixed "go to referenced row" function when using multi word object names.
- BUGFIX: #3173 Fixed numerous typos in messages and names.
- BUGFIX: #3178 Fixed pagination for query simple execution method.
- BUGFIX: #3177 Fixed ORDER BY with column numbers, instead of names.
- BUGFIX: #3125 Fixed trigger UPDATE OF columns popup dialog positioning.
- BUGFIX: #3166 Fixed crash when trying to print data.
- BUGFIX: Fixed reading long values of not-editable result columns (like expressions or functions that return long values). They used to be truncated.
- BUGFIX: Compilation fixes.

### 3.1.0
- ADDED: SQLCipher plugin is now free, open source and distributed together with other standard plugins.
- ADDED: #2963 Indexed expressions for CREATE INDEX statements (introduced in SQLite 3.9) are now supported and can be edited in Index Dialog.
- ADDED: View window now supports explicit column names for the view (introduced in SQLite 3.9).
- ADDED: #3056 #3063 Implemented index column ordering in index dialog.
- ADDED: Added shortcut (Ctrl+/ by default) to toggle comment of current line or selected block of code (if any) in SQL editor.
- ADDED: #3040 Added new entry in context menu of data grid to generate SELECT/INSERT/UPDATE/DELETE statement together with WHERE clause containing IN conditions for selected cells.
- ADDED: Added new entry in context menu of database list to generate queries like in #3040 for selected table.
- ADDED: #2975 Information message after successful table/view change.
- ADDED: Introduced "loadByDefault" property for plugin descriptor files.
- ADDED: Added options to have "Data" tab placed as a first tab for Table windows and for View windows. By default option is disabled, so by default nothing changes.
- ADDED: Added option in configuration dialog to avoid reopening status panel for each message printed there.
- ADDED: Added option in configuration dialog to prevent displaying tooltips over data view when user holds mouse over it.
- ADDED: #3070 Added option in configuration dialog to have new databases marked as not permanent by default.
- ADDED: #3070 Added option in configuration dialog to bypass database dialog completely when dropping file from file manager onto database list.
- ADDED: #3013 When double clicking on empty space in list of indexes or tables (in table or view window) the action is not ignored, but a dialog opens for adding new item.
- CHANGE: DbAndroid plugin has now JAR file embedded and you can get it from Tools menu.
- CHANGE: SQLite version updated to 3.13.0.
- CHANGE: Qt version updated to 5.6.0. Should still compile with 5.3, but binary distributions on homepage will be made with 5.6.
- CHANGE: Foreign key dropdown (when editing FK cell) uses now more readable set of columns and column headers can be resized.
- CHANGE: Column dialog validates scale and precision fields (against INTEGER PRIMARY KEY and against each other).
- CHANGE: Structure tab in table window has now fully named headers in column list.
- CHANGE: Table and View window options moved from Look & Feel configuration page to Data Browsing page.
- CHANGE: All database list options moved to a separate Database List configuration page.
- CHANGE: Window list in main menu -> "View" -> "Window list" is not sorted alphabetically.
- BUGFIX: Not loading Android plugin by default (needs manual load from configuration dialog), which stops the "ADB" error for people not using the plugin.
- BUGFIX: #2927 Several critical bugs fixed and enhancements to table modification algorithm related to foreign keys.
- BUGFIX: #2954 #2803 #2937 Fixed incorrect recreation of foreign keys chain.
- BUGFIX: #3008 Editing foreign key cell with more than 10 000 possible values will now use simple text editor, not dropdown. It also loads values asynchronously.
- BUGFIX: Fixed importing from CSV with some of lines containing less fields than defined in header (or in first data row).
- BUGFIX: #2989 Fixed multiline value handling in CSV import plugin.
- BUGFIX: #2921 Fixed empty values as NULL handling in CSV import plugin.
- BUGFIX: #3034 Fixed handling empty string as value for DEFAULT constraint.
- BUGFIX: #3064 Fixed locking database executions when counting rows in huge tables.
- BUGFIX: DbAndroid plugin has fix for null pointer in the JAR when client has disconnected
- BUGFIX: Error message details were missing in some cases (when smart execution method failed at parsing stage). This is fixed now.
- BUGFIX: #3026 #3027 #3043 Fixed RAISE() function formatting in enterprise formatter (used to produce invalid SQL).
- BUGFIX: #3015 Fixed error with DEFAULT constraint containing datetime('now', 'localtime').
- BUGFIX: #3000 Fixed compilation errors for Qt >= 5.5.
- BUGFIX: #2956 Fixed unexpected data refresh when clicking in the right side of value filter field in table window.
- BUGFIX: #2991 #2928 #2929 #2941 #2960 Fixed executing "garbage" query, causing application crash.
- BUGFIX: #2920 Fixed removing several databases.
- BUGFIX: #3068 #3066 Fixed database removal confirmation dialog so the message asks about removing it from the list, not deleting it.
- BUGFIX: #3073 Fixed crash when unloading plugin with its own configuration subpage and saving config dialog.
- BUGFIX: #2931 #2962 Fixed incorrect results when executing 2-level queries with an expression and an alias combination as a result column definition.
- BUGFIX: #2942 Fixed deleting multiple tables/indexes/... when selected them and picked "Delete table/index/..." from context menu.
- BUGFIX: #2945 Fixed manual reordering of database objects with Drag&Drop.
- BUGFIX: #3055 Fixed crash when exporting on MacOS using plugin that requires column value length information (such as PDF export plugin).
- BUGFIX: #3047 Fixed copying/moving tables together with indexes or triggers with Drag&Drop across same SQLite version databases.
- BUGFIX: #3012 SQL simple formatter plugin does not load by default from now on. It is still available, but won't load until manually loaded.
- BUGFIX: Table window for new table (just created) will now properly close when that table gets deleted immediately by the user.
- BUGFIX: #2998 Fixed reading decimal values from database when using simple execution method (a fallback in case of some problems).
- BUGFIX: #2999 Fixed working on objects from database that on the list is named "main".
- BUGFIX: Fixed error detection when selecting column from incorrect table alias (http://forum.sqlitestudio.pl/viewtopic.php?f=11&t=1051).
- BUGFIX: #3046 Fixed scale & precision fields in column dialog so it's possible to delete their values from the column.
- BUGFIX: Vacuum invoked from context menu on database list is now executed in SQL editor and is asynchronous.
- BUGFIX: #3001 Order of objects exported by Export Dialog is now alphabetical (in object type groups).
- BUGFIX: #3022 Fixed parsing of some expressions, resulting in this particular bug report in being unable to browse view results.
- BUGFIX: Enhanced floating point numbers handling.
- BUGFIX: Fixed formatting of INSERT and UPDATE statements.
- BUGFIX: Enterprise formatter no longer puts new lines when formating list of elements in "IN" clause.

### 3.0.7
- ADDED: #2951 Implemented dropdown value picking for foreign key columns in grid view.
- ADDED: Context menu entry to go to row in referenced table by current foreign key cell value.
- BUGFIX: #2875 Fixed font misconfiguration after Qt update.
- BUGFIX: #2879 Fixed View updating after table modification, when view uses SELECT with table alias same as table name.
- BUGFIX: #2885 Fixed tokens parsing, causing random problems, such as incorrect formatting performed by the simple formatter.
- BUGFIX: Fixed preventing of setting null or empty value on query results that don't come directly from table.
- BUGFIX: Fixed duplicates while copying mupltiple lines from status field.

### 3.0.6
- ADDED: #2740 Option to configure whether bottom dock area (with status field) should extend to left border, or should it leave space for database list.
- ADDED: #2819 Introduced "compact layout" as an option (enabled by default) to minimize all margins on the interface.
- ADDED: CSS console for SQLiteStudio (under F11 key) to allow customizing all aspects UI look and feel at a low level.
- ADDED: #2805 The 'Save SQL' action in SQL editor now uses the same file if repeated, unless user picks 'select file to save' from drop-down menu.
- ADDED: #2801 Added option to select where to position the new inserted row - above/below selected row, or at the end of data view.
- CHANGE: Database list is by default from top to bottom, making the status field placed next to the database list, instead of being below it.
- BUGFIX: Fixed 'rows affected' counter when using transactions and executing everything at once.
- BUGFIX: Fixed importing from CSV with empty (NULL) values in last column of last data row.
- BUGFIX: #2853 Allow '$' character as a part of an identifier.
- BUGFIX: #2846 Fixed crash when executing query on a database after just removed other database from the list.
- BUGFIX: #2856 Fixed not working updates manual checking if automatic checking was disabled.
- BUGFIX: #2863 Fixed config dialog to honor DbTree presentation options (sorting, labels) immediately, no manual refreshing required.
- BUGFIX: #2862 Fixed loading SQL scripts into editor when using Chinese language.
- BUGFIX: #2855 Automatic updates are now enabled only for portable build and are disabled by default for other builds.
- BUGFIX: #2867 Fixed support for "ISNULL" in query execution.
- BUGFIX: Fixed synchronization bug in DbSqlite2 plugin causing random crashes.
- BUGFIX: Views are recreated after table modification only if they really need to be updated according to the table change.
- BUGFIX: Fixed querying selects with numerous subselects with '*' operators for result columns.
- BUGFIX: #2868 Global configuration directory is not created (even empty) when using portable configuration.
- BUGFIX: #2866 Fixed Search dialog in SQL editor to honor changes of the searched value during the single session of searching.
- BUGFIX: Fixed importing from data source that provides columns with special characters - they are no longer splitted to column name and datatype.
- BUGFIX: Fixed problem with keyboard focus for syntax completer under Gnome 3.
- BUGFIX: #2872 'Enter' key in table name of import dialog now triggers 'Next' action, not clearing the table name.
- BUGFIX: #2864 & #2791 Fixed synchronouse execution in QueryExecutor, which also fixes the misterious bug in export dialog, causing empty files being exported.
- BUGFIX: Fixed encoding detection and connection testing for SQLite2.

### 3.0.5
- ADDED: #2831 Ported 'Erase table data' feature (in table's context menu) from version 2.1.5.
- CHANGE: Data view has now a 'cover' with progress bar when committing more changes at once. This eliminates weird GUI freeze when committing lots of new/deleted rows.
- CHANGE: Populate dialog has now progress bar when working.
- CHANGE: Enhanced SQL formatter to format CREATE TRIGGER statements in a bit more readable way.
- BUGFIX: #2838 Fixed outstanding bug causing database file to be deleted if a user tried "Test connection" on the database under Windows.
- BUGFIX: Fixed crash when closing Populate Dialog while populating was in progress.
- BUGFIX: Fixed warning messages when there was a problem with restoring windows from last session. A message contains now window name that caused problem.
- BUGFIX: #2830 Closing database list made impossible.
- BUGFIX: #2829 Fixed support for DEFERRABLE (and related) keywords in foreign keys.
- BUGFIX: #2827 Release a file after import.
- BUGFIX: #2826 Fixed bug in SQL formatter causing 'expr ISNULL' expressions to disappear.
- BUGFIX: #2834 Removed './lib' form rpath for linux non-portable compilation.
- BUGFIX: #2836 Removed termcap dependency, as it was deprecated and no longer required.

### 3.0.4
- ADDED: Import dialog has now "Ignore errors" option, to skip rows that causes problems (constraint violation, wrong column count, etc).
- CHANGE: Enhanced Copy&Paste capabilities of data grid, so copying and pasting internally in SQLiteStudio will not be limited by TSV format (NULL values will be distinguished, tab characters will be allowed in values), only pasting from outside will be affected by TSV limitations.
- CHANGE: "Invalid database" icon changed, so it's no longer confusing with "Connected" database.
- CHANGE: "Databases" panel cannot be closed/hidden anymore.
- CHANGE: Database dialog reorganized to look a bit nicer, db type moved to top, URL browse button for file is now separated to 2 buttons.
- BUGFIX: #2795 XmlExport plugin: Fixed crash that happend in most exports.
- BUGFIX: XmlExport plugin: Fixed column number attribute incrementing for data rows.
- BUGFIX: #2793 SqlEnterpriseFormatter plugin: Fixed formatting queries starting with EXPLAIN and EXPLAIN QUERY PLAN.
- BUGFIX: #2786 Fixed double plugin names in config dialog for built-in plugins.
- BUGFIX: Fixed dead-lock when fixing path for a database that pointed to inexisting file.
- BUGFIX: Fixed data editing for SQL queries joining the same table several times.
- BUGFIX: Fixed "Ctrl+W"/"Cmd+W" shortcut to work every time, not only every second time.
- BUGFIX: Fixed order of window focusing when closing with "Ctrl+W"/"Cmd+W" shortcut.
- BUGFIX: #2797 Database type is no longer disabled when adding existing database file.
- BUGFIX: SqlExport appends Foreign Key (re)enabling pragma at the end.
- BUGFIX: "Maximized" MDI window state is no longer lost after closing last MDI window.
- BUGFIX: #2812 TableModifier is now much smarter about when to recreate triggers and how to do it.
- BUGFIX: TriggerDialog no longer loses "When" field when editing existing trigger.
- BUGFIX: Columns of Indexes and Triggers tabs in Table Window don't shring after refresh anymore.
- BUGFIX: NumPad Enter key also accepts the Code Assistant choice.
- BUGFIX: Fixed drawing items in SQL code assistant, so they no longer are "black on dark blue" when using classic Windows theme.
- BUGFIX: #2790 Fixed hexadecimal literals evaluation in SQL queries.
- BUGFIX: #2804 Fixed querying SQLite 2 database.
- BUGFIX: Fixed executing query like: SELECT * FROM (SELECT * FROM table); - it used to crash.
- BUGFIX: #2798 Fixed crash when restoring DbList group for inexisting database.
- BUGFIX: #2808 Sorting indicators in data grid fixed to point the right direction and got a little bit larger.
- BUGFIX: #2807 Fixed SQL export plugin when exporting whole database without formatting SQL, so the missing semicolons are appended to each DDL.
- BUGFIX: #2806 Fixed table sorting in Export Dialog.
- BUGFIX: #2809 Fixed crash when trying to paste data into data grid with no rows in it.
- BUGFIX: Fixed rolling back of row marked to deletion, if it was previously already marked as edited.
- BUGFIX: #2814 Fixed executing custom SQL function with same bind parameter used multiple times.
- BUGFIX: #2815 Fixed refreshing data pages after adding/deleting rows in grid view.
- BUGFIX: #2820 Fixed parsing 'IN table.column' expression (used to incorrectly assume a 'NOT' keyword to be present, even it wasn't).

### 3.0.3
- ADDED: Added visual validation indicators to DbDialog, so user is informed why the "Ok" button is disabled at the moment.
- ADDED: Russian translation.
- ADDED: French translation.
- ADDED: #2770 Added SQLite 3 version used by application in the Environment tab of the About dialog.
- CHANGE: Language translations located in a separate directory have now higher precedense, than translations compiled in, so it's possible to test updated translations "on the fly".
- BUGFIX: Fixed support for "function(DISTINCT args)" in Enterprise formatter.
- BUGFIX: #2753 Fixed parsing TEMP and IF NOT EXISTS in CREATE TABLE statement.
- BUGFIX: #2755 Fixed error checking for recurrent expression with LIKE/GLOB operator in it.
- BUGFIX: Switched error message from simple method error to smart method error in QueryExecutor to avoid misleading messages.
- BUGFIX: #2760 Fixed marking "unique" in index dialog when opening existing unique index.
- BUGFIX: #2757 Fixed int64 rounding problem.
- BUGFIX: #2767 Fixed NOT NULL dialog in column dialog, so it doesn't convert to UNIQUE.
- BUGFIX: #2763 Fixed possibility of adding 2 same databases to the list.
- BUGFIX: Fixed copying values from Environment tab of the About dialog.
- BUGFIX: #2774 Fixed handling triggers (when modifying table) in foreign tables, triggers referencing table in its subqueries, etc.
- BUGFIX: Fixed executing SELECT in SQLite2 for columns that need wrapping.
- BUGFIX: Fixed editing data for tables transparently attached in the SQL query.
- BUGFIX: Fixed Shortcut titles translation in configuration dialog.
- BUGFIX: Fixed aggregate functions, so initial and final codes are executed, not only the per-step code.
- BUGFIX: #2781 Portable configuration directory can now be either in the running directory, or in applications directory. It's auto-detected.
- BUGFIX: Optimized loading huge data sets into data grid. It's faster and the progress bar acts more smoothly.
- BUGFIX: Shortcut for closing current window is now displayed in the context menu for taskbar.
- BUGFIX: "Skip first line" option in CSV import renamed to "First line represents CSV columns". Maybe this time it won't confused anyone.
- BUGFIX: #2790 Fixed hexadecimal literals evaluation in SQL queries.

### 3.0.2
- ADDED: Full support for the interface translations.
- ADDED: Polish translation.
- ADDED: #219, #2711 Reset autoincrement feature to context menu of table and to structure toolbar in table window.
- ADDED: #2715 Added "rows affected" to the execution result message for INSERT/DELETE/UPDATE queries.
- BUGFIX: Fixed deleting column from table that is the only column covered by an index or an "UPDATE OF" trigger.
- BUGFIX: #2703 Fixed compilation errors on GCC 4.9.
- BUGFIX: #2707 Fixed crash when importing CSV file with empty value for last column.
- BUGFIX: Valid objects in SQL editor are now highlighted and are Ctrl+clickable (the feature was there, but was broken and it didn't work).
- BUGFIX: Fixed invalid 'modified' status when focusing out NumberMultiEditor in FormView, resulting in uncommitted change on FormView, even there was no change.
- BUGFIX: #2698 Fixed double precision numbers displaying in the Grid View.
- BUGFIX: #2696 Fixed handling foreign keys when the main table was not renamed, just columns changed.
- BUGFIX: #2713 Fixed foreign key actions in Foreign Key dialog, so they are no longer the same for ON UPDATE and ON DELETE, even they were configured differently.
- BUGFIX: #2715 Fixed storing rows affected/selected in SQL Editor history (bug since version 3.0.0 caused "rows" column in SQL history to be always 0).
- BUGFIX: Main window toolbar is updated after creating/deleting database objects (it was not).
- BUGFIX: #2722 Fixed crash when exporting database without data.
- BUGFIX: #2727 Fixed error message when calling SELECT with table from (transparently) attached database and selecting invalid column - message was misleading.
- BUGFIX: #2728, #2729 Fixed DEFAULT constraint dialog, so 1) it works when creating first column for new table, 2) it allows a single word as a default value, even the word is not an explicit string.
- BUGFIX: #2697 Fixed data populate dialog.
- BUGFIX: #2731 Fixed problem with attached databases not detaching after transparent attach in cross-database queries.
- BUGFIX: #2734 Fixed code assistant crash in Trigger Dialog.
- BUGFIX: #2721 Fixed initial selection of database in SQL Editor window, so it's set to the database currently selected in databases list on the left.
- BUGFIX: #2721 Added database name to error message when the SQL query execution failed.
- BUGFIX: #2718 Checkbox in CSV import plugin renamed to "Skip first row of data".
- BUGFIX: Fixed staring edition of data in grid by pressing Enter key.
- BUGFIX: #2745 Fixed crash when ctrl+right_clicking in SQL editor.
- BUGFIX: #2733 Fixed handling of foreign keys when changing table structure.
- BUGFIX: #2749 Fixed handling of function(distinct arg), resulting in incorrect results when executed.
- BUGFIX: Fixed logging SQL queries when --debug-sql is enabled. Queries from query executor were not logged.

### 3.0.1
- ADDED: When the data is being read into the Gird View, columns width gets automatically adjusted, so for small values they are shrinked and for bigger values they're enlarged, but never above the configured limit (a new option in config dialog).
- ADDED: Implemented support for immediate editing of rows just added to the WITHOUT ROWID tables (previously the manual refresh of data view was required).
- BUGFIX: Fixed support for expressions as DEFAULT value in table.
- BUGFIX: Fixed support under Windows for running portable distribution, while having different version of Qt installed in the system (added the qt.conf file).

### 3.0.0
- ADDED: Application has been rewritten from scratch in C++ and Qt (was previously written in Tcl/Tk). This means improvements in all areas, especially in application performance, good looking interface, more friendly interface and more stability.
- ADDED: Database list can now group databases in named groups (groups can be embedded in each other).
- ADDED: Changes made to database schema (modifying/adding/dropping tables, indexes, etc) are now confirmed with user by a DDL dialog (can be disabled).
- ADDED: Form View for data is now configurable and extensible (with plugins). You can configure which editors you want to make available for which data type.
- ADDED: Custom collation editor window, so you can implement custom collations using any scripting language available in SQLiteStudio
- ADDED: Changes made to database schema can now always be tracked down by a DDL history window, which keeps track of all changes you do to the database.
- ADDED: Database conversion utility now previews changes to be made to the database.
- ADDED: Drag&drop of objects between databases will preview changes that need to be made to objects before they can be created in the target database.
- ADDED: Most of the dialogs/forms is validated on-the-fly and user is notified about any problems immediately with a small red icons over the problematic field.
- ADDED: Scripting languages are now provided by plugins. With this version there is support for QtScript (built in), SQL (built in) and Tcl (as a plugin).
- ADDED: Support for sorting data by multiple columns by right-clicking on the data grid header.
- ADDED: Support for "WITHOUT ROWID" tables and "WITH" clause in queries.
- ADDED: If there are any uncommitted changes (in data or schema), user will be asked for confirmation before closing application or MDI window.
- ADDED: Printing (for data, schema and query) support.
- ADDED: Much, much more, it's just hard to put every single detail in the changelog. After all, the entire application was written from the very beginning.
- CHANGE: Table is now edited in the table window directly, not in any special dialog.
- CHANGE: SQL syntax validator now underlines errors, instead of changing background color.
- CHANGE: SQL parsing is done in separate threads, making the UI smooth and responsive.
- CHANGE: Executing queries is done in separate threads, making the UI smooth and responsive.
- CHANGE: Custom SQL functions editor is now a MDI window with more powerful editing capabilities.
- CHANGE: Import and export dialogs are now a "Wizard" dialogs and they become more organized.
- CHANGE: SQLite3 version updated to 3.8.7.4.
- BUGFIX: The new version deals much better with huge databases than the old version did.
- BUGFIX: The MacOS X port doesn't crash all the time, like it was for version 2.1.x. It's just as stable as for any other operating system.
- BUGFIX: SQL syntax assistant got smarter and it deals much better with complex queries.
- BUGFIX: Enterprise SQL formatter deals better with complex queries.

### 2.1.5
- BUGFIX: Fixed conversion dialog: http://bugs.sqlitestudio.pl/?id=2515
- BUGFIX: Fixed conversion dialog: http://bugs.sqlitestudio.pl/?id=2513

### 2.1.4
- BUGFIX: Fixed conversion dialog: http://bugs.sqlitestudio.pl/?id=2021

### 2.1.3
- ADDED: Shortcut for editing cell value in BLOB editor dialog (default is Shift-Return, but can be configured).
- ADDED: Configuration option (on Misc config tab) to define how wide (maximum) can grid column be.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1879
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1878
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1883
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1893
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1907
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1921
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1916
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=2062
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=2093
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=2095
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=2141
- BUGFIX: Fixed few exporting bugs (errors raised, no data exported, ...).
- BUGFIX: Fixed "Vacuum" in database context menu.

### 2.1.2
- ADDED: When dropping a table, SQLiteStudio checks if it's used in any view and if it is, then asks user for confirmation.
- CHANGE: Database convering dialog now proposes database file basing on typed name.
- CHANGE: Database convering works in background, not blocking the UI.
- CHANGE: Main menu reorganized. Now it's also interactive according to what's to what's selected in the databases list.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1711
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1738
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1713
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1699
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1709
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1734
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1703
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1555
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1707
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1760
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1784
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1774
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1817
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1804
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1743
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1700
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1763
- BUGFIX: When editing a cell from query results and committing changes, then all cells representing the same database cell will be updated with new value as well.
- BUGFIX: Fonts initialization optimized. SQL editor widgets should open slightly faster, especially under Windows.
- BUGFIX: Transparent attach/detach mechanism fixed to avoid multiple attaches of the same database.
- BUGFIX: Fixed column edition dialog to not hide under Windows after being open with "double click".
- BUGFIX: When renaming task the old name is typed by in the entry field, instead of "0".
- BUGFIX: Fixed saving custom toolbar order.

### 2.1.1
- ADDED: Setting (on "Fonts" tab) for configuring whether you want keywords to be displayed with bold font or not.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1474
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1518
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1517
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1520
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1361
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1540
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1475
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1622
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1597
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1598
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1479
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1483
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1563
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1532
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1649
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1650
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1533
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1514
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1489
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1485
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1482
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1473
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1627
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1480
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1655
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1680
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1584
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1561
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1683
- BUGFIX: Optimized executing huge SQL directly from a file.
- BUGFIX: Other minor speed optimizations.

### 2.1.0
- ADDED: Support for NULL values in form view, blob edit dialog and query parameters dialog.
- ADDED: Importing engine based on plugins. Currently SQLiteStudio can import from CSV, Clipboard (same as CSV, but from clipboard), DBF (dBase) and from any text files using Regular Expression (RegExp plugin).
- ADDED: Full Foreign Keys altering support - when modifying table, foreign keys will follow table changes.
- ADDED: Support for system tables in table window -> they can be viewed but cannot be modified (SQLite itself prevents that).
- ADDED: Completion hints can suggest columns from Views now.
- ADDED: Option in configuration to define what to do when user opens a view - show edition dialog or data from view (http://bugs.sqlitestudio.pl/?id=386).
- ADDED: Button for adding custom number of rows to table data grid at once.
- ADDED: If application is started first time, it asks for language to use before showing main window.
- ADDED: Support for "BEGIN", "COMMIT" and "ROLLBACK" statements to be executed from SQL editor.
- ADDED: Smart "home" key in SQL editor, which goes either to begining of line or to begining of actual text in the line.
- ADDED: 'Return' key opens selected element from databases tree.
- ADDED: Context menu option to edit selected cell using BLOB editor, even the cell data size is small.
- ADDED: Databases tree filter, so user can easly find any database (in long list) or any table/index/trigger/view in any open database by entering any piece of its name.
- ADDED: Form view of data has now resizable fields (but only for TEXT, BLOB and similar datatypes), so you can see more data at once instead of scrolling a lot.
- ADDED: Grid row (table data grid or query results grid) can select whole row at once by clicking on ROWNUM column or by Control-click on any cell. (http://bugs.sqlitestudio.pl/?id=208)
- ADDED: An entry in "View" menu to restore last closed window (and one before that and so on), also a configurable keyboard shortcut and entry in taskbar context menu to do the same.
- ADDED: Database list tooltips for databases, so you can quickly view what's the path to database file, what's its size, etc.
- ADDED: Tooltips for tables and views to get quick informations about the object.
- ADDED: Tooltips for taskbar to display full button title (even long one), database associated with the window and table (in case of table window).
- ADDED: SQL editor - matching parenthesis pairs highlighting when insertion cursor positioned at the one from the pair.
- ADDED: Context menu entry to reset AUTOINCREMENT sequence for selected table.
- ADDED: Option to make indexes linked to (under) tables in databases tree. This is enabled by default and can be disabled in configuration dialog.
- ADDED: Option to show columns linked to (under) tables in databases tree.
- ADDED: Portable mode for configuration. If there's a "sqlitestudio-cfg" directory next to the SQLiteStudio binary, then it is used to read and store configuration.
- ADDED: Option to display ROWIDs in table data as default (after each table window is open).
- ADDED: Defining order of databases in the list by Drag&Drop of databases.
- ADDED: Drag&Drop of databases and objects between databases. Now you can copy/move tables (also indexes, triggers and views) between databases simply by D&D. It's possible even between SQLite3 and SQLite2 databases!
- ADDED: When modifying a table, all views that reference the table are adjusted to the new form of table (new name, column changes, etc), just like indexes and triggers were adjusted so far.
- ADDED: Help hint about parameters to SQL function in Custom SQL Functions dialog.
- ADDED: Support for multiple value sets in INSERT statements (introduced in SQLite 3.7.11).
- ADDED: When editing the table cell, all the contents of that cell are selected by default. This can be disabled in configuration dialog.
- ADDED: Context menu command to generate SELECT statement for selected cells (in both data grid and results grid).
- ADDED: Now it's possible to export data from view, just like from a table.
- ADDED: Positional parameters (@, ?, $, :, ...) are now remebered and recalled when used again in same or similar query (with same parameters).
- ADDED: Positional parameters dialog has button to copy the value to other parameters in the dialog that are named exactly the same. The button is displayed only if there are more than one parameter with a certain name.
- ADDED: Context menu for table to erase all data from table (after confirmation).
- ADDED: Bug report dialog can now use an account from http://bugs.sqlitestudio.pl to report bugs.
- ADDED: Two new data populating plugins: SQL and Tcl.
- ADDED: New exporting plugins: DBF (dBase), PDF, JSON, Clipboard, XLS (MS Excel).
- ADDED: The "ON CONFLICT" algorithm exposed to user when using Populating Dialog. Now any duplicates, can be ignored (http://bugs.sqlitestudio.pl/?id=576).
- CHANGE: Table window opening speed up. Loading related triggers and indexes postponed to moment of displaying proper tab.
- CHANGE: Displaying and editing huge data volumes (both in table window and SQL editor) is now supported much better and faster.
- CHANGE: Memory usage for exporting minimized. Now it's possible to export any amount of data at once.
- CHANGE: Enabled exporting for cross-database queries.
- CHANGE: Interrupting query execution now actually works! You can cancel query at any moment.
- CHANGE: Dropped "PRAGMA full_column_names" usage, as it is deprecated SQLite3 interface.
- CHANGE: Editing query results now supports editing results from cross-database queries! The only condition is that columns are selected directly, without expression modifiers, such as math operations, etc.
- CHANGE: Introduced support for custom number of table constraints (not column constraints), so for example two or more primary keys defined as separated table constraints is now possible from table dialog. (http://bugs.sqlitestudio.pl/?id=200)
- CHANGE: Trigger DDL support enhanced. Now it supports "UPDATE OF <columns>" statements.
- CHANGE: Supported languages are now displayed in human readable form, by names, not by strange locale symbols.
- CHANGE: Session management improoved. It's easier to write session-aware classes now.
- CHANGE: Using thread pools instead of individual threads wherever it's possible. This made SQL editor windows to open a little quicker and to work more smoothly.
- CHANGE: SQL Editor completion hints display "busy" animated icon if parsing some huge SQL takes a little longer.
- CHANGE: Platform detecting code unified.
- CHANGE: Parser and lexer classes enclosed in UniversalParser and UniversalLexer, preventing many potential memory leaks.
- CHANGE: Switched from BEGIN to SAVEPOINT in most cases (only in SQLite3, in SQLite2 BEGIN usage remains).
- CHANGE: Table grid view menu context reorganized to be more readable.
- CHANGE: Changed icons for "Export table" and "Export database" to fit general schema of icons.
- CHANGE: Enhanced layout of context hints for tables (table data and results data).
- CHANGE: Auto-update checks directory permissions, so it allows automatic update only if privileges are sufficient.
- CHANGE: Session saving now stores the full image of what objects were expanded or collapsed, so it gets fully restored.
- CHANGE: Added shadows for hints under Windows.
- CHANGE: Simplified bug reporting dialog.
- REMOVED: Solaris binaries. Nobody seems to use them. Users still can run SQLiteStudio from sources with some Tcl distribution.
- BUGFIX: Again improved performance for huge table data and huge query results.
- BUGFIX: Column context information in table window fixed to display constraints correctly.
- BUGFIX: Fixed virtual table exporting (http://bugs.sqlitestudio.pl/?id=201).
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1199

### 2.0.28
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1086
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1091
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1128
- BUGFIX: Fixed "maximized" window state, so it's correctly restored on Unixes.
- BUGFIX: Fixed font picker dialog to use proper theming engine.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1110
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1115
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=977
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1198
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1144

### 2.0.27
- ADDED: http://bugs.sqlitestudio.pl/?id=967
- ADDED: http://bugs.sqlitestudio.pl/?id=934
- BUGFIX: Fix for white icons on disabled toolbar buttons on MacOSX.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=815
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=818
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=828
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=829
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=844
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=852
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=913
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=973
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=947
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=983
- BUGFIX: Fixed error when completion hint was invoked for alias name that is also a proper table name.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=984
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1029
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=607
- BUGFIX: Fixed invalid focus when clicked on "data" tab. In result the user was unable to use keyboard shortcut to switch between subtabs.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=959
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=921
- BUGFIX: Added debug details for http://bugs.sqlitestudio.pl/?id=921
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1000
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1071
- BUGFIX: Fixed http://forum.sqlitestudio.pl/viewtopic.php?f=11&t=93
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=834
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=949
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=971
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=981
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=1083
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=965

### 2.0.26
- BUGFIX: SQL editor in Trigger Dialog uses now configured keyboard shortcut for SQL formatting, instead of hardcoded ctrl-f.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=768
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=759 (thanks to Kevin Walzer)
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=771
- BUGFIX: Fixed context menu on MacOSX, so it's now invoked by right-click, not the middle-click.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=784
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=798

### 2.0.25
- ADDED: "Donate" in "Help" menu. Voluntary donations help maintain the hosting server and keep me motivated.
- BUGFIX: Fixed sorting of completion hint for "INSERT INTO table (". Now columns from "table" are first.
- BUGFIX: Tooltips fixed to display in intelligent spot, so it won't go out of screen edge.
- BUGFIX: Fixed formatting of "x BETWEEN y AND z" so there's a whitespace after "AND".
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=715
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=721
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=722
- BUGFIX: Binary distribution for Mac OS X is now deployed with a little different menthod which should result in less critical crashes. Also resolved problem with starting on some OSX machines. Big thanks to Michal Janiak for helping with this!
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=725
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=728
- BUGFIX: Fixed parsing and formatting of CREATE TRIGGER with "CASE ... END" in it.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=747
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=755

### 2.0.24
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=702
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=707

### 2.0.23
- CHANGE: SQLite updated to 3.0.9 in binary distributions. Also a binary for Mac OS X got recompiled with SQLITE_ENABLE_LOCKING_STYLE, so it works with network file systems well.
- BUGFIX: Fixed error checking, that was not running when used "Enter" or "Backspace" or at application startup.
- BUGFIX: Fixed Enterprise Formatter to put whitespace after "BETWEEN" keyword.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=587
- BUGFIX: Fixed AUTOINCREMENT column constraint in Enterprise Formatter (it missed the keyword while formatting).
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=664
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=666
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=583
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=614
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=685
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=676
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=673
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=601
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=680
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=701

### 2.0.22
- NEW: Implemented http://bugs.sqlitestudio.pl/?id=490
- BUGFIX: Completion hint (in SQL Editor) will not disappear if users hits "completion key shortcut" again accidentally.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=479
- BUGFIX: Fixed very slow execution SQL custom functions implemented in Tcl. Discussion: http://forum.sqlitestudio.pl/viewtopic.php?f=11&t=31
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=474
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=486
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=243
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=498
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=499
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=501
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=519
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=522
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=566
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=526
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=508
- BUGFIX: E-mail field in Bug Report dialog is now validated, so only valid or empty value is accepted.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=573
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=523

### 2.0.21
- ADDED: Bug report dialog have new field "e-mail". It is optional and it's only for SQLiteStudio developer to contact reporter about some details of error report. It will never be shared to anyone or used for any other purpose. It won't be published anywhere.
- BUGFIX: Fixed enterprise SQL formatter to not wrap "ALL" in "UNION ALL" with "[]".
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=454
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=461
- BUGFIX: Export dialog and database dialog handles manually typed file names (not picked with file dialog) correctly.
- BUGFIX: Export dialog title changed to 'Output file' to avoid any misunderstands.

### 2.0.20
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=447
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=452

### 2.0.19
- BUGFIX: Fixed help tip text in CSV export plugin configuration.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=432
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=430
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=434

### 2.0.18
- CHANGE: In table and column dialogs the insertion cursor in name field is initially placed at the end of value.
- CHANGE: Added more debug information regarding http://bugs.sqlitestudio.pl/?id=411
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=408
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=416
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=419

### 2.0.17
- BUGFIX: Fixed completion hints for vies, triggers and indexes in case of "DROP" statement.
- BUGFIX: Enabled encoding configuration for SQL export format for entire database.
- BUGFIX: Fixed some problems with switching MDI windows (especially when used Control+click on table name in SQL editor).
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=403
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=402
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=405
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=406

### 2.0.16
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=391
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=397
- BUGFIX: Fixed copying DDL code from DDL tab in various dialog windows.
- BUGFIX: Fixed button names in trigger, index and view dialogs in case of editing existing object.

### 2.0.15
- BUGFIX: Fixed file() SQL function to handle binary files.
- BUGFIX: Fixed "identity encoding" issue while exporting data.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=385
- BUGFIX: Fixed parser support for primary key table constraint with single column in it.
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=389

### 2.0.14
- CHANGE: Updated to SQLite 3.7.8 (http://bugs.sqlitestudio.pl/?id=247)
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=241
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=242
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=268
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=285
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=256
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=266
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=250
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=240
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=245
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=248
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=251
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=253
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=269
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=271
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=323
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=363
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=302
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=304
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=365
- BUGFIX: Fixed completion hint not working when used with alias for table name typed with different case.
- BUGFIX: Fixed deleting any object from database (in database objects tree) with Delete key. It always tried to delete database, instead of selected object.

### 2.0.13
- NEW: Introduced Chinese translation, thanks to Yu Longzhen! It's not yet complete, but already more than a half is done.
- NEW: Home page added to help menu, also manual link updated (http://bugs.sqlitestudio.pl/?id=193)
- NEW: Added Google Chrome to list of predefined browsers under unix systems.
- CHANGE: Datatypes in column edition dialog are now autocompleted while typing, so it's enough to type "t" to get "TEXT" type.
- CHANGE: Datatype list in column edition can now be fast navigated using keys, so if you drop down the list, you can press "i" to select "INT" type fast. (http://bugs.sqlitestudio.pl/?id=190)
- BUGFIX: Fixed bug related to "_toCommit".
- BUGFIX: Fixed bug, when user was able to edit deleted but uncommitted row (even the edition was ignored).
- BUGFIX: Fixed insertion of numeric values in data view - they're now treated as numeric if column type says so (they used to be treated as string and CHECK constraint was not satisfied very often).
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=168
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=172
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=173
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=175
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=176
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=177
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=178
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=179
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=182
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=184
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=185
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=188
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=189
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=191
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=193
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=194
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=195
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=196
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=197
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=198
- BUGFIX: Fixed http://bugs.sqlitestudio.pl/?id=203
- BUGFIX: Fixed several issues related to inserting new rows from Form View of table data.
- BUGFIX: Fixed issue related to table and column names with strange characters in name.
- BUGFIX: Enterprise SQL formatter indents sub-selected datasources better.
- BUGFIX: Some other, minor bugs fixed.

### 2.0.12
- BUGFIX: Fixed error for SQLite2 DDL that uses "REFERENCES" keyword, even it's unsupported by SQLite2.
- BUGFIX: Binary compatibility for MacOS X restored from 2.0.9.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4632

### 2.0.11
- BUGFIX: Removed SQL debug messages enabled in 2.0.10, causing "stdout" related error under Windows.

### 2.0.10
- CHANGE: If query could not be executed by Smart Query Executor, then simple executor adds its signature to eventual error message in status.
- CHANGE: Added <Delete> key shortcut to delete selected database from list.
- CHANGE: Various MacOS X appearance improovements.
- BUGFIX: Significat configuration saving speedup.
- BUGFIX: Fixed nasty bug related to character encoding for SQLite2 under Windows: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3860
- BUGFIX: Column Drag&Drop in table dialog works again.
- BUGFIX: TreeCtrl extension updated to 2.3.1, which fixes 2 major bugs in data grid header.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4495
- BUGFIX: 'removeComments' routine fixed (by maovrn).
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4500
- BUGFIX: Fixed minor SQL formatting error for SQlite 2.
- BUGFIX: Message about "ATTACH DATABASE" limit exceed is now wrapped in nice readable message dialog.
- BUGFIX: Fixed "unknown execution error" in case of problem with transparent attaching database.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4579
- BUGFIX: Removed "-force" from all [focus] calls.
- BUGFIX: Added additional debug routines for some bugs. Hope to fix them with next release.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4553
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4586
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4550
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4510 (UNION SELECTs forbids to edit results data, for now).
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4583
- BUGFIX: Fixed grid to form synchronization when adding new row in grid.

### 2.0.9
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4484
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4485
- BUGFIX: Entering edition mode in grid works now for international characters too.
- BUGFIX: Added all missing encoding systems to binary distributions.

### 2.0.8
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4476
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4465 (unknown option "0")
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4473
- BUGFIX: If updating process doesn't have right to write to disk, then human readable message is displayed.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4479

### 2.0.7
- BUGFIX: Fixed nasty bug with "-notnull1": http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4455
- BUGFIX: Fixed another nasty bug with "-tableAlias": http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4456
- BUGFIX: Added more debug information for bug "row(sql)": http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4458

### 2.0.6
- ADDED: Context menu (with copy/cut/paste) in text fields.
- CHANGE: Removed "autoCommit". Now all changes have to be committed.
- CHANGE: Database add/edit dialog modified for Mac OS X. Now it uses two dialogs to pick file - native OSX dialogs!
- BUGFIX: Commit/Rollback buttons activates when editing starts by typing value.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3972
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3974
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3973
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3977
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3979
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=2&t=4020
- BUGFIX: Fixed error for SQLite2 with "unknown command total_cahnges".
- BUGFIX: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4184
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4163
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4160
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4159
- BUGFIX: Fixed support for "CREATE TRIGGER" defined on "database.table".
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4261
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4155
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4161
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3980
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4009
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4042
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4068
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4023
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3987
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4388
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4059
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4284
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4339
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4372
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3990
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4078
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4238
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=2&t=4019
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4016
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4086
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4273
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3966
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4407
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4070
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=2&t=4106
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4243
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3874
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=2&t=4139
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4166
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4223
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4280
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4357
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4245
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4298
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4067
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4124
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4083
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4152
- BUGFIX: Fixed SQL syntax error marking in SQLEditor under Windows.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=4429

### 2.0.5
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3943
- BUGFIX: Plain text export fixed.
- BUGFIX: Fixed crash when exporting database with virtual table.
- BUGFIX: Foreign keys enforcing is now enabled by default and can be disabled by proper PRAGMA call.
- BUGFIX: Fixed counting "affected rows".

### 2.0.4
- CHANGE: Trigger dialog is now resizable.
- CHANGE: Enterprise formatter enforced to be selected for this one time. It still can be changed in configuration. Many people don't even realize there's such formatter.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3831
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3832
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3847
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3837
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3836
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3838
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3850
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3882
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3894
- BUGFIX: Fixed opening database passed in command line.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3863
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3890
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3875
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3872
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3891
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3873
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3927
- BUGFIX: Fixed recreating of indexes and triggers while table structure is modified.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3899
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3901
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3937
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3893
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3929

### 2.0.3
- CHANGE: Enabled additional keys to enter edit mode in data grid.
- CHANGE: Added transactions tracing for better transaction-related problems debugging in bug reports.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3668
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3768
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3767
- BUGFIX: Various form view key binding fixes.
- BUGFIX: Trying to edit system index caused critical error.
- BUGFIX: Added upper-case file name extensions for database file selector.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3772
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3774
- BUGFIX: Undo mechanism fixed for SQL code formatting - doesn't need to call Ctrl+z twice anymore.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3785
- BUGFIX: Again improved performance for huge table data and huge query results.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=9&t=3780
- BUGFIX: Fixed index dialog for SQLite 2.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=3&t=3798
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3810
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3817
- BUGFIX: Fixed EXPLAIN results displaying.
- BUGFIX: Fixed MDI windows closing in custom order.

### 2.0.2
- ADDED: Character encoding for exporting data can be selected now.
- CHANGE: SQLiteStudio version included in bug reports and feature request reports.
- CHANGE: Various MacOSX user interface improvements.
- CHANGE: Various liftings of user interface.
- CHANGE: Index dialog has now database in a list separated from table list.
- CHANGE: Trigger dialog supports "FOR EACH ROW" and "FOR EACH STATEMENT" (the second one for SQLite 2 only).
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3716
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3718
- BUGFIX: Fixed indentation for 2 or more column constraints for CREATE TABLE in Enterprise formatter.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3724
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3687
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3723
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3726
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3730
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3729
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3734
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3731
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=3&t=3733
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3744
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3722
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3751

### 2.0.1
- ADDED: Support to vacuum databases with custom collation sequences.
- ADDED: Databases list sorting in databases context menu.
- CHANGE: Bug reporting dialog includes OS version in its report.
- CHANGE: "SQLiteStudio" menu renamed to "Help".
- CHANGE: Database adding/editing dialog reorganization. The "file" field is now the most important. Name (alias) is auto-generated, or manually entered (as an option).
- BUGFIX: Fixed updates-checking and auto-update functions. They didn't work in 2.0.0.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3651
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3654
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3668
- BUGFIX: Bug reporting dialog allows using Return key in its fields, instead of sending unfinished report immediately.
- BUGFIX: SQL code in View Dialog is now stored in SQLite as it's written and displayed just like read from SQLite - no formatting changes are applied.
- BUGFIX: Fixed wrong results from queries with custom collation sequences.
- BUGFIX: Performance improved significantly for huge table data and huge query results.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3656
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3660
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3676
- BUGFIX: Fixed switching between pages of query results.
- BUGFIX: Fixed opening tables from SQL editor links (control+click) with different case size.
- BUGFIX: Fixed error with "_colItem(query)" reported on comp.lang.tcl group.
- BUGFIX: Fixed problem with inserting first row to empty table using Form View.
- BUGFIX: The progressbar dialog won't stay any longer after critical error occured, so user was unable to report the bug.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3659
- BUGFIX: Fixed viewing data from View in SQlite 2.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3662
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3679
- BUGFIX: Initial size of application window on Mac OS X is now reasonable.
- BUGFIX: Fixed support for loadable SQLite extensions. Now you can load them with load_extension() in query and use extension as you would expect it.
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3701
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3706
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3708
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3695
- BUGFIX: Fixed: http://forum.sqlitestudio.pl/viewtopic.php?f=4&t=3712

### 2.0.0
- ADDED: Updates checking on startup.
- ADDED: Real SQL parser based on lexer&parser pair! It provides many, many possibilities. Few of them are already implemented and listed in changelog below.
- ADDED: (SQL parser stuff) SQL syntax validation on the fly with error markers.
- ADDED: (SQL parser stuff) Enterprise SQL code formatter. It's very powerful and configurable, but works only on valid code, so if the SQL is marked to be incorrect (see paragraph above) then formatter won't format such SQL.
- ADDED: Table columns can be edited directly from table window by double-clicking on them.
- ADDED: Columns order in TableDialog can be now be managed by drag&drop.
- ADDED: Possibility to display ROWID in table data view. Just right-click and pick it from context menu.
- ADDED: Internal stuff: [final] procedure, so important internal variables are secured.
- ADDED: Internal stuff: Introduced threads. GUI acts more shmoothly.
- ADDED: Possibility to add database only for current session (it won't be on the list after application restart).
- ADDED: Window/task can be renamed now from taskbar context menu.
- ADDED: Tasks order in taskbar at the bottom can now be managed using drag&drop.
- ADDED: Progress bar for export dialog, populate dalog and table dialog (good to keep track on tasks done on tables with lots of data) with possibility to interrupt the process.
- ADDED: Long query executions can be interrupted.
- ADDED: Pending commits (with autocommit as option in configuration). User can modify some data (add, edit or delete rows) and commit them all togather at the end.
- ADDED: Filter entry in form view of table data tab.
- ADDED: Added "(filtered)" information next to "Total rows" in case of filtered table data view.
- ADDED: Edit trigger and edit index buttons added in table triggers and indexes tabs.
- ADDED: "Execute SQL from file" button in SQL editor window.
- ADDED: Context menu for SQL editor window.
- ADDED: SQL functions available while managing databases in SQLiteStudio: md5(), base64_encode(), base64_decode(), file(), sha1(), hmac().
- ADDED: "Create similar table" option.
- ADDED: Quick opening of tables typed in SQL editor. Press Control key and click on table name to open it.
- ADDED: Database integrity checking pragma added to database context menu.
- ADDED: Full informations about installed plugins and used Tcl packages available in About dialog.
- ADDED: Option to open items from database tree by single-click.
- ADDED: While creating an unique index: if there are duplicates in table, then SQLiteStudio proposes to create SQL to select all duplicated rows.
- ADDED: Button in SQL editor to create a view from query typed in the editor.
- ADDED: Support for parameters (?, ?NNN, :VVV, @VVV, $VVV) in queries typed in SQL editor.
- ADDED: Option to place SQL editor results below the query, not in separated tab.
- ADDED: When holding mouse over data grid or results grid, the hint pops up with some context information about cell under mouse cursor.
- ADDED: DDL tab in all Table/Index/Trigger/View dialog windows to see objects DDL before it's actualy created.
- ADDED: New versions checking at startup or on demand and auto-upadte support for binary distributions.
- ADDED: MacOS X port.
- ADDED: Binaries for linux (ix86_64), freebsd (ix86_64) and macosx (ix86_64) platforms.
- CHANGE: Exporting was rewritten from scratch. It was the ugliest code in whole application. Now it's based on plugins, so it's much easier to add new exporting engines.
- CHANGE: (SQL parser stuff) Smart completion hints - now SQLiteStudio knows better if next argument should be a keyword, or a table name, or index, name, etc. Moreover - object names (tables, indexes, etc) already used somewhere in the SQL query appear higher in completion hint, since user seems to be interested in them. It really kicks ass! Try it out!
- CHANGE: Internal stuff: 'Array' class has been completly replaced by Tcl Dicts from Tcl 8.5.
- CHANGE: Small unification in layout of database edit dialog and convert database dialog.
- CHANGE: Configuration settings saving enclosed in transaction - major speed improvement of this action.
- CHANGE: Bug reporting engine completly rewritten. Know it is very simple to report a bug.
- CHANGE: Numerous scrollbars are now shown/hidden dynamically when needed.
- CHANGE: Query execution status field shows icon (info, warning, error) for all messages to identify type of message easier.
- CHANGE: Results as plain text moved to separated tab.
- CHANGE: Context menu in databases list reorganized.
- CHANGE: Refreshing database schema doesn't collapse its branches.
- CHANGE: Executing queries in SQL editor refreshes schema in databases tree, so all new, changed or deleted objects are noticed immediately.
- CHANGE: Balloon hints appears now faster and allows to browse help hints for many widgets placed close to each other very quickly.
- CHANGE: New icons.
- CHANGE: Table window now displays all constraints in "Columns" tab as icons. Therefore "constraints" tab has been removed from table window.
- CHANGE: More intuitive inserting data in form view.
- CHANGE: Plain text results are now configurable (NULL representation, column width).
- CHANGE: Pressing key Right/Left while editing cell and being on the begin/end of the edited value moves keyboard focus to cell on the left/right side.
- BUGFIX: Fixed highlighting of comment which starts in the middle of contents with '/*' and never ends.
- BUGFIX: Closing configuration window in other way than "cancel" or "ok" makes it close as for "cancel".
- BUGFIX: (SQL parser stuff) Detecting symbolic database names (databases from objects tree) in SQL editor has been fixed, so table name same as database name won't be a problem anymore.
- BUGFIX: (SQL parser stuff) All dialog windows for editing SQLite objets (tables, indexes, ...) use now built-in SQL parser, so they read all object definitions correctly.
- BUGFIX: Triggers created for table are recreated after table is edited.
- BUGFIX: File choosing dialog fixes under Unix (filters updating and <escape> key binding).
- BUGFIX: Database adding/editing dialog under Windows unified to Unix version, so now there's only one button for file picking. No more confusion here.
- BUGFIX: Many, many, many other bug fixes not listed here, because I didn't write them down during fixing.
- BUGFIX: Scrolling grids horizontally is now smooth.
- BUGFIX: Added *(*autoindex*)* indexes of SQLite2 to list of system indexes, so they can be filtered out.
- BUGFIX: Many, many other minor and major bugfixes not mentioned here.

### 1.1.3
- ADDED: Port to FreeBSD!
- ADDED: Support for lang/ subdirectory in starting directory, so testing new translations is now very simple.
- ADDED: Ctrl+c shortcut now works for databases tree - you can copy label of any element from the tree.
- ADDED: New translation: Espanol (Spanish).
- ADDED: New translation: German.
- CHANGE: Internal change: [foreach] replaced with [lassign] to adjust code to Tcl 8.5.
- CHANGE: Export dialog suggests same directory for output file as exported database is in.
- CHANGE: Tcl/Tk updated to 8.5.7, SQLite3 updated to 3.6.16, TreeCtrl updated to 2.2.9 - for binary packages.
- BUGFIX: Fixed dialogs: About, ChangeLog and Roadmap.
- BUGFIX: Minor fixes in messages and translations.
- BUGFIX: Toolbar doesn't display undefined (empty) tooltips anymore.
- BUGFIX: Fixed support of some constraints. Caused numerous problems.
- BUGFIX: Indexes for incorrect/not existing columns are now handled properly when user opens index edit dialog.
- BUGFIX: Fixed issue with Ctrl+c (and similar) shortcuts on Windows while having enabled CapsLock.
- BUGFIX: Blob edit widget fixed for Form View to display current row value correctly.
- BUGFIX: Duplicated themes fixed.
- BUGFIX: Fixed error while trying to enter new value of cell in grid while there was no cell selected.

### 1.1.2
- ADDED: SQLite3 engine version used by application in the About dialog.
- CHANGE: MDI windows remembers their position and dimensions in session.
- CHANGE: Renamed "Open editor" to "Open SQL editor" in configuration "Shortcuts" tab.
- CHANGE: SQLite system tables (if enabled to display) are now marked so user can recognize them easly.
- BUGFIX: Copying&pasting cells with NULLs handled properly.
- BUGFIX: Columns with strange names are now handled correctly.
- BUGFIX: Fixed editing table data using form view for SQLite 2.
- BUGFIX: Populating dialog won't allow to enter negative number of rows to insert.
- BUGFIX: Critical error occuring when clicking fast in Unix file choosing dialog.
- BUGFIX: Font choosing dialog doesn't crash anymore if invoked twice without closing first one.
- BUGFIX: Exporting results to some formats was crashing every time. Not anymore.
- BUGFIX: Resizing windows without proper cursor fixed.
- BUGFIX: Fixed changing index table.
- BUGFIX: Fixed support in table edit dialog for column names with dots and commas.
- BUGFIX: Fixed renaming tables in SQLite2 database.
- BUGFIX: Better handling of advanced tables DDL.
- BUGFIX: Rolling back transactions won't cause problems anymore.
- BUGFIX: Fixed current directory of binary distribution.
- BUGFIX: Several fixes of drawing for dark themes of operating system interface.
- BUGFIX: Fixed many problems with Foreign Keys.
- BUGFIX: SrolledFrame widget fixed for uncommon localizations.
- BUGFIX: Exporting database to HTML format fixed.
- BUGFIX: Fixed error occuring sometimes while trying to commit edited value.
- BUGFIX: Tab-key order in Form View fixed.
- BUGFIX: Allow to open read-only database files.
- BUGFIX: Form View shortcuts, additional toolbar buttons.
- BUGFIX: Result grid editing for table name with whitespace fixed.
- BUGFIX: Fixed control-a shortcut for some edit fields.
- BUGFIX: Keyboard/mouse input focus grabbing for some of modal dialogs fixed.
- BUGFIX: Handling of uncommitted grid editions while closing MDI window.
- BUGFIX: Handling of NOT NULL constraint used and no DEFAULT specified in table column editing dialog in case when table already contains some data filled in.
- BUGFIX: Small grammar fixes in tips dialog.
- BUGFIX: Font handling rewritten. Should not cause problems anymore, but if it does, then fixing will be now much easier.
- BUGFIX: Fixed 100% CPU usage for sequence: open 2 table windows, edit data cell in one window, then focus the other one window without committing edition before.
- BUGFIX: Fixed MDI window placement, so they won't appear at exactly same position while creating anymore.
- BUGFIX: Added DATETIME data type support.
- BUGFIX: DEFAULT values handled properly. Now you can use functions and other expressions, as well as literal values.
- BUGFIX: Fixed chosing other database in 'new table' dialog.
- BUGFIX: Fixed crashing when changing configuration while image-type cell in grid is selected.
- BUGFIX: Prevention against duplicated column names in table edition dialog.
- BUGFIX: New trigger dialog doesn't allow to use 'INSTEAD OF' for table triggers.
- BUGFIX: Fixed FK window visibility under Windows.
- BUGFIX: Grid navigation to right/left scrolls a view.

### 1.1.1
- CHANGE: "Export table data" button moved from table structure toolbar to table data toolbar.
- CHANGE: Results in plain text are now formatted so they're more readable.
- CHANGE: Nasty behaviour when trying to edit data cell and commit invalid value (like alpha-characters in INTEGER-PK column) has been modified so application asks user what would he like to do.
- BUGFIX: Windows default font size for few text fields (i.e. "did you know that..." dialog) has been increased, so it's readable now.
- BUGFIX: Taskbar button "more" is now hidden correctly (its frame was visible even when it supposed to be hidden).
- BUGFIX: Formatter plugin is now set up correctly after closing configuration window.
- BUGFIX: Custom SQL function results handled better when they're null.
- BUGFIX: Fixed support for using symbolic database names in SQL editor (it was causing problems sometimes).
- BUGFIX: Fixed switching tasks back to previously active one when executed "Show view data" in some cases.
- BUGFIX: Fixed bug when reading triggers with unusual names.
- BUGFIX: Index dialog uses Grid widget to display columns proposition. Now there's no problem with adjusting header and widgets.

### 1.1.0
- ADDED: Full support for SQLite 2 databases! Binary distribution includes SQLite 2.8.17.
- ADDED: Solaris port.
- ADDED: Selecting multiple cells/rows/columns in data grids is now possible. It enables user to delete multiple rows at once.
- ADDED: Advanced copy-paste routines: copying multiple rows/columns results in clipboard format applicable for pasting into many famous spreadsheets. It's also easy to read when pasted into regular text file. It also can be pasted into other SQLiteStudio grid. User also can copy from spreadsheet and paste into SQLiteStudio grid!
- ADDED: Custom SQL functions can be defined by user, so they're registered in all opened databases.
- ADDED: Support for usage many databases in single SQL query using symbolic names of databases that are displayed in the databases tree.
- ADDED: Support for editing cell values in Results grid, including pasting to it! Even for combined SELECT with JOINs!
- ADDED: Table data filtering. Just type the word you're looking for in filter entry.
- ADDED: sqlite_* objects can be displayed in databases tree as an option (in configuration dialog).
- ADDED: Find&Replace dialog for SQL editor widget.
- ADDED: Populating tables. It's first feature in SQLiteStudio that is based on plugins. Plugins will be described in documentation.
- ADDED: Keramik and Plastik image-based themes (multi-platform).
- ADDED: Database name in DB tree is now labeled with identification of database handler, so you'll know if the database is SQLite 2 or SQLite 3.
- ADDED: String class highlighting for SQL editor.
- ADDED: Execution of SQL directly from file. Available from database context menu or SQL function sqlfile().
- ADDED: Importing schema (not data!) from one database to another. To copy schema and data use "copy file" feature in your operating system.
- ADDED: Configuration of "hint baloon" is now possible (colors, font).
- ADDED: Added sorting of data in table window by custom columns.
- ADDED: Handler of common database errors (such as 'database is locked') to display such errors in dialog window that is less scary than default critical error dialog.
- ADDED: Command line parameters. Database file can be passed as parameter to application so it will be managed with SQLiteStudio.
- ADDED: Duplicating table data row feature.
- ADDED: Navigation buttons for Form View of table data, so user can walk through all rows in grid without switching to grid.
- ADDED: Option to open Data tab in table window when that window was just opened, instead of Structure tab.
- ADDED: GTK and QT themes in linux binary distribution.
- ADDED: Results of query execution as plain text.
- CHANGE: Moved to Tcl/Tk 8.5.
- CHANGE: SQLite3 updated to newest - 3.6.7.
- CHANGE: Foreign Key support upgraded to join it with table editor dialog. Any foreign key-related changes in table editor will also affect FK triggers. Separate creating FK is no more needed, just set it in table definition. It means SQLiteStudio emulates Foreign Keys transparently!
- CHANGE: Optimization of HEX editor. Huge performance gain!
- CHANGE: Added support for img::png package as alternation to tkpng (img::png is still more popular on some platforms).
- CHANGE: printStackTract procedure modified a little to produce more readable stack traces.
- CHANGE: API documentation updated. More classess documented.
- CHANGE: Shortcut edit widget takes Escape key as a way to cancel edition, instead of binding a shortcut with it.
- CHANGE: New rows which user adds to table data appears below currently selected row, instead of end of grid.
- CHANGE: SQL formatter externalized to plugin. Now anyone can write his own SQL formatter as plugin.
- CHANGE: SQL errors are no longer connected with full Tcl stack trace in error/warning dialogs, so they are more readable to user.
- BUGFIX: NULL handling fixed (for SQLite3). Note that setting NULL in SQLite2 databases works, but it cannot be read as NULL, so for NULLs in SQLite2 you'll see just empty cells.
- BUGFIX: Exporting results of query with number of rows greater than 1000 was exporting only 1000 - the ones currently visible in results table.
- BUGFIX: /* This kind of comments */ is now highlighted.
- BUGFIX: Shortcut edits doesn't crash when Control key was pressed and released without any other key togather.
- BUGFIX: ScrolledFrame fixed to fit well into parent widgets. It affects numerous Configuration Dialog tabs as well, as Form View of data, Index dialog and others.
- BUGFIX: Fixed editing tables with name containing whitespaces.
- BUGFIX: Font of grids is now set properly.
- BUGFIX: Fixed indexes for columns with spaces in name.
- BUGFIX: Fixed new index dialog when choosing target table from database with uncommon name.
- BUGFIX: Fixed view edit dialog to support views with spaces in name.
- BUGFIX: Fixed editing table columns with value length specified, as 'VARCHAR(10)'.
- BUGFIX: Fixed validation of integer value for maximum results per page in data preview.
- BUGFIX: Font dialog fixed so it looks a bit better.
- BUGFIX: Total number of rows in table data tab updates on the fly when new rows are added or deleted.
- BUGFIX: Fixed SQL highlighting in editor history tab.
- BUGFIX: Setting Foreign Key for column(s) while creating new table (it worked for editing tables).
- BUGFIX: Fixed restoring session - in some cases it wasn't restoring properly.
- BUGFIX: Fixed creating and opening table with strange names, like '''''''''''.
- BUGFIX: Edit widget (for non-BLOB columns) is now moved correctly when scrolling grid.
- BUGFIX: Exporting dialog doesn't close on input error anymore and lets user to fix input.
- BUGFIX: Add/Edit database dialog doesn't change main window title anymore.
- BUGFIX: Fixed support for strange database names (such as abc';'efg).
- BUGFIX: Refreshing toolbar after changing schema is now performed correctly.
- BUGFIX: Fixed View dialog database selection.
- BUGFIX: CSV exporting fixed in case of spearator character in cell value.
- BUGFIX: Other minor fixes.

### 1.0.1
- CHANGE: SQLite 3 engine updated to 3.5.9 for binary distributions.
- CHANGE: Index dialog modified to use ScrolledFrame instead of canvas, so it looks much better.
- BUGFIX: Fixed common error "item X column Y has no style" that was very hard to reproduce, at last!
- BUGFIX: Fixed running binary application with "[" character in its file name.
- BUGFIX: Granted permissions to load external SQLite extensions using load_extension() SQL function.

### 1.0.0
- CHANGE: SQLiteStudio has been released on GPLv2 licence!
- CHANGE: Removed licence-responsible code. Tbcload extension is no more required.

### 1.0.0-beta6
- CHANGE: Columns in table data view and editor results view can be resized now, but BLOB fileds still can't be loaded whole directly to grid cell (I think the reason is obvious).
- CHANGE: There is a known bug that is not 100%-repeatable. It occurs sometimes when switching to FormView of table data. This change has added some additional logs to debug the bug.
- BUGFIX: A very obvious bug included in beta5 - adding database dialog didn't disappear when database is added correctly.
- BUGFIX: Fixed error while switching from standard BLOB editor to hexadecimal editor.
- BUGFIX: Fixed committing new rows from FormView of table data.

### 1.0.0-beta5
- ADDED: Databases tree refresh button on toolbar and in View menu.
- CHANGE: SQLite engine updated to 3.5.4 for binary distributions.
- CHANGE: Now 'Triggers' tab in table window contains triggers related to the table by 'ON' clause only.
- CHANGE: View dialogs (new and edit) can be resized now.
- BUGFIX: Another fixes related to proper SQL updates and inserts with strange data characters.
- BUGFIX: Fixed support for 'main'.'table' expressions in triggers.
- BUGFIX: Fixed crashes on closing main window (quiting). Sometimes it denied to quit because of error...
- BUGFIX: Fixed errors occuring on few Grid widgets containing images or widgets inside of them.
- BUGFIX: Fixed error when right-clicking on empty tree list on the left.
- BUGFIX: Added handling of settings file from previous versions of SQLiteStudio.
- BUGFIX: Fixed bug when maximizing the only one MDI window, which was in normal mode while application startup.
- BUGFIX: Fixed 'window name "edit" already exists in parent' bug occuring in DataGrid and ResultGrid.
- BUGFIX: Fixed error while closing application and some of MDI windows has closed before it's session was saved.
- BUGFIX: Fixed exporting query results to CSV format (new line characters).
- BUGFIX: Fixed executing queries with semi-colon and white-space at the end of query.
- BUGFIX: Fixed problem with untranslated messages and unsupported localizations so '%s' are substituted correctly.
- BUGFIX: Fixed Tcl core critical error related to exporting large databases/tables (problem with memory allocation).
- BUGFIX: Fixed displaying list of indexes in table window in Indexes tab.
- BUGFIX: Few minor fixes related to object names (like tables, columns) that are surrounded with [] or " characters.
- BUGFIX: Fixed error while clicking on Primary Key column in table structure with no primary key set.
- BUGFIX: Fixed 'Add database' dialog so it doesn't disappear when database cannot be added for some reason, but lets user fix it.
- BUGFIX: Full support for NULL values while exporting to various formats.

### 1.0.0-beta4
- ADDED: New SQL function tcl() to execute Tcl code in separate interpreter and return its results.
- ADDED: Full support for NULL value (which is not same as empty value).
- ADDED: Universal 'Delete' shortcut for databases tree. Deletes selected item (if possible).
- CHANGE: 'New database' label renamed to 'Add database' to be less confusing.
- CHANGE: SQLite engine updated to 3.4.2 for binary distributions.
- REMOVED: Removed date() function while there is standard SQLite date() function.
- BUGFIX: 'View data preview' window is now properly stored in session so it's title is restored in next session.
- BUGFIX: 'View data preview' can not be opened in two separate windows now, so it will not cause problems with doubled tasks on taskbar anymore.
- BUGFIX: Another little bug with 'REFERENCES' in table edition dialog - occured when column reference was wrapped with white-spaces.
- BUGFIX: Detection of 'REFERENCES' constraints in table browsing window on Constraints tab. It used to detect more constraints than there was.
- BUGFIX: Handling table global constraints in table browsing window on Constraints tab.
- BUGFIX: Fixed (finally?) problem with UTF-8 data in database.
- BUGFIX: While editing table schema: renaming a column causes losing data from that column. Fixed.
- BUGFIX: Support for multi-word names enclosed in quotes, instead of square brackets.
- BUGFIX: Yet another fix related to global table contraints. This time - named global constraints.
- BUGFIX: Right-click (context menu) now selects currently clicked node - it's common behaviour.
- BUGFIX: Disabling clipboard pasting to SQL editor on systems that causes problems with that feature.
- BUGFIX: Fixed error with trying to create second editor in Grid widget, while there still is a first.
- BUGFIX: Foreign key wizard dialog now interpretes main table and foreign table as they should be: foreign table/fields determinates cascades on main table.
- BUGFIX: Fixed 'Refresh' shortcut in table data preview, as well as in table structure tab and table DDL tab.
- BUGFIX: Fixed international characters support in various edit widgets.

### 1.0.0-beta3
- ADDED: 'Report the bug' button in critical error dialog. Now it's much easier to report these kind of bugs.
- BUGFIX: Few detection bugs with constraints detection (in table editon dialog).
- BUGFIX: Browsing table data with BLOB columns (broken in beta2).
- BUGFIX: Bugs with exporting whole database to SQL and XML formats.

### 1.0.0-beta2
- ADDED: date() function to read unixtime from database. It formats unixtime value into human-readable format.
- ADDED: Support for 'REFERENCES' keyword in columns and all stuff related to this keyword.
- ADDED: Support for table global constraints.
- ADDED: Support for triggers on views.
- ADDED: ChangeLog dialog.
- ADDED: 'Escape' shortcut in editor window to hide status field.
- CHANGE: SQLite engine updated to 3.4.1 for binary distributions.
- CHANGE: Insertion cursor in SQL editor blinks a little faster so it's easier to locate it.
- CHANGE: PageDown and PageUp shortcuts upgraded (moves cursor too, not just pages).
- CHANGE: Tab and Shift+Tab upgraded to let indent and unindent multiple lines as well as single lines.
- CHANGE: Handling completion for column names entered in function arguments, like 'max(columnname)'.
- BUGFIX: ColorPicker handles incorrect colors passed to it and in that case it uses white color as default.
- BUGFIX: ColorPicker handles HTML color editing much better then before. Now it might be impossible to break it.
- BUGFIX: Better detection of operating system (fixed problems with Windows Vista and Windows 2000).
- BUGFIX: Fixed adding new row to table data grid when there was an error while committing previous row.
- BUGFIX: Shortcuts Ctrl+Left, Ctrl+Right, Ctrl+Shift+Left and Ctrl+Shift+Right are back!
- BUGFIX: Detection of 'language changed' in configuration dialog fixed (it used to detect change even there was no change).
- BUGFIX: Fixed active task changing while setting MDI windows in cascade layout, then pushing maximize button on some window other than the currently active.
- BUGFIX: Fixed formatting of preformatted table DDL code.
- BUGFIX: Refreshing toolbar state after deletion of any object in the tree.
- BUGFIX: Problems with highlighting of first line in SQL editor in View Edit Dialog.
- BUGFIX: Numerous fixes in all dialog windows, so they don't disappear on errors, but let user fix his input.
- BUGFIX: Minor fixes in Polish translation.
- BUGFIX: SQLiteStudio doesn't let to create objects with empty names (or just whitespaces in name) anymore.
- BUGFIX: Changing table in New Index Dialog didn't work.
- BUGFIX: Clear History toolbar button in SQL Editor window has been fixed.
- BUGFIX: Mouse Wheel is now working on Windows platform.
- BUGFIX: Minor memory leaks fixed in Edit Table Dialog.
- BUGFIX: Constraints list in table window displays now correct list of constraints.
- BUGFIX: Using ' (single quote) character in table data grid has been fixed.
- BUGFIX: SQLite objects containing spaces in name are now supported correctly.
- BUGFIX: Fixed execution of multiple SQL statements that are creating some SQLite objects (it tried to create some of them twice).
- BUGFIX: DDL formatting in table window fixed.
- BUGFIX: Fixed critical error while exporting some data as a XML.
- BUGFIX: Fixed critical error while some error occured when trying to create trigger.
- BUGFIX: Fixed critical errors while customizing toolbar.