/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
**
** This version of "lempar.c" is modified, slightly, for use by SQLite.
** The only modifications are the addition of a couple of NEVER()
** macros to disable tests that are needed in the case of a general
** LALR(1) grammar but which are always false in the
** specific grammar used by SQLite.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>

#include "token.h"
#include "parsercontext.h"
#include "parser_helper_stubs.h"
#include "common/utils_sql.h"
#include "common/global.h"
#include "common/unused.h"
#include "parser/ast/sqlitealtertable.h"
#include "parser/ast/sqliteanalyze.h"
#include "parser/ast/sqliteattach.h"
#include "parser/ast/sqlitebegintrans.h"
#include "parser/ast/sqlitecommittrans.h"
#include "parser/ast/sqlitecopy.h"
#include "parser/ast/sqlitecreateindex.h"
#include "parser/ast/sqlitecreatetable.h"
#include "parser/ast/sqlitecreatetrigger.h"
#include "parser/ast/sqlitecreateview.h"
#include "parser/ast/sqlitecreatevirtualtable.h"
#include "parser/ast/sqlitedelete.h"
#include "parser/ast/sqlitedetach.h"
#include "parser/ast/sqlitedropindex.h"
#include "parser/ast/sqlitedroptable.h"
#include "parser/ast/sqlitedroptrigger.h"
#include "parser/ast/sqlitedropview.h"
#include "parser/ast/sqliteemptyquery.h"
#include "parser/ast/sqliteinsert.h"
#include "parser/ast/sqlitepragma.h"
#include "parser/ast/sqlitereindex.h"
#include "parser/ast/sqliterelease.h"
#include "parser/ast/sqliterollback.h"
#include "parser/ast/sqlitesavepoint.h"
#include "parser/ast/sqliteselect.h"
#include "parser/ast/sqliteupdate.h"
#include "parser/ast/sqlitevacuum.h"
#include "parser/ast/sqliteexpr.h"
#include "parser/ast/sqlitecolumntype.h"
#include "parser/ast/sqliteconflictalgo.h"
#include "parser/ast/sqlitesortorder.h"
#include "parser/ast/sqliteindexedcolumn.h"
#include "parser/ast/sqliteforeignkey.h"
#include "parser/ast/sqlitewith.h"
#include "parser/ast/sqliteupsert.h"
#include "parser/ast/sqlitewindowdefinition.h"
#include "parser/ast/sqlitefilterover.h"
#include "parser/ast/sqlitenulls.h"
#include <QObject>
#include <QDebug>
#include <limits.h>

#define assert(X) Q_ASSERT(X)
#define UNUSED_PARAMETER(X) (void)(X)
#define DONT_INHERIT_TOKENS(X) noTokenInheritanceFields << X
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/*
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands.
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3_parseTOKENTYPE     is the data type used for minor tokens given
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3_parseTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3_parseARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3_parseARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3_parseARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3_parseARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned short int
#define YYNOCODE 321
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 78
#define sqlite3_parseTOKENTYPE Token*
typedef union {
  int yyinit;
  sqlite3_parseTOKENTYPE yy0;
  SqliteWith* yy1;
  SqliteLimit* yy4;
  ParserDeferSubClause* yy9;
  SqliteSelect::Core::JoinSource* yy31;
  SqliteExpr::LikeOp* yy40;
  SqliteWindowDefinition::Window::Frame* yy41;
  ParserCreateTableColumnList* yy42;
  ParserCreateTableColumnConstraintList* yy51;
  ParserResultColumnList* yy53;
  SqliteColumnType* yy57;
  SqliteWindowDefinition::Window::Frame::Exclude* yy63;
  ParserExprList* yy71;
  SqliteCreateTrigger::Scope* yy83;
  ParserStubTransDetails* yy84;
  ParserStubExplain* yy91;
  SqliteForeignKey::Condition::Reaction* yy104;
  ParserQueryList* yy110;
  SqliteCreateTable::Column* yy147;
  SqliteCreateTrigger::Event* yy151;
  ParserStubAlias* yy200;
  ParserSetValueList* yy201;
  SqliteSelect::Core::JoinOp* yy221;
  ParserIndexedColumnList* yy223;
  QVariant* yy229;
  SqliteCreateTable::Constraint* yy246;
  SqliteFilterOver* yy247;
  SqliteFilterOver::Over* yy248;
  SqliteWindowDefinition* yy266;
  SqliteIndexedColumn* yy268;
  SqliteSelect::Core::JoinConstraint* yy295;
  ParserWindowDefList* yy299;
  SqliteInitially* yy312;
  SqliteSelect* yy313;
  QString* yy319;
  SqliteWindowDefinition::Window* yy334;
  SqliteQuery* yy363;
  SqliteSelect::CompoundOperator* yy382;
  int* yy386;
  SqliteFilterOver::Filter* yy397;
  SqliteUpsert* yy400;
  ParserOrderByList* yy403;
  SqliteConflictAlgo* yy418;
  SqliteWindowDefinition::Window::Frame::RangeOrRows* yy419;
  ParserFullName* yy440;
  SqliteSelect::Core::SingleSource* yy441;
  SqliteWindowDefinition::Window::Frame::Bound* yy442;
  SqliteWith::CommonTableExpression* yy446;
  ParserOtherSourceList* yy451;
  SqliteCreateTable::Column::Constraint* yy464;
  SqliteSelect::Core* yy470;
  ParserExprNestedList* yy486;
  ParserCreateTableConstraintList* yy493;
  ParserStubInsertOrReplace* yy504;
  SqliteForeignKey::Condition* yy507;
  SqliteExpr* yy512;
  SqliteCreateTrigger::Time* yy532;
  SqliteSortOrder* yy549;
  QStringList* yy575;
  SqliteNulls* yy579;
  ParserFkConditionList* yy584;
  ParserTermOrLiteral* yy590;
  ParserIndexedBy* yy592;
  ParserCteList* yy593;
  bool* yy611;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3_parseARG_SDECL ParserContext* parserContext;
#define sqlite3_parseARG_PDECL ,ParserContext* parserContext
#define sqlite3_parseARG_FETCH ParserContext* parserContext = yypParser->parserContext
#define sqlite3_parseARG_STORE yypParser->parserContext = parserContext
#define YYNSTATE 844
#define YYNRULE 472
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

#define GET_CONTEXT yyParser* yypParser = pParser; sqlite3_parseARG_FETCH

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (3037)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   510,  625,  284,  836,  655,  288,  841,   64,   65,  509,
 /*    10 */   339,  626,  501,  795,  795,   62,   62,   63,   63,   63,
 /*    20 */    63,  351,   61,   61,   61,   61,   60,   60,   59,   59,
 /*    30 */    59,   58,  253,  485, 1085,   61,   61,   61,   61,   60,
 /*    40 */    60,   59,   59,   59,   58,  253,  835,  290,  794, 1085,
 /*    50 */    71,  506,   63,   63,   63,   63,   40,   61,   61,   61,
 /*    60 */    61,   60,   60,   59,   59,   59,   58,  253,  805,  635,
 /*    70 */   836,  347,  785,  836,  592,   70,  452,   54,  817,   88,
 /*    80 */   338,  835,  835,   59,   59,   59,   58,  253, 1085,  836,
 /*    90 */   806,  223,  836,  835,   51,   52,  693, 1085,  635,  508,
 /*   100 */   325,   53, 1012,  348,  261,  415,  622,  621,   88,    2,
 /*   110 */  1012,  835,  681,  117,  793,  286,  498, 1012,  324,  807,
 /*   120 */   833,  634,  834,  833,  510,  810,  157,  466,  453,  439,
 /*   130 */   436,  435,  793,  809,  808,  807,  501, 1012,  563,  682,
 /*   140 */   682,  611,  486,  746, 1078,  327,  677,  434,  366,  575,
 /*   150 */  1012,  254, 1012, 1012,  396,  403, 1012,  296,  425,  303,
 /*   160 */   749, 1012, 1012, 1012, 1012, 1012,  793,  274,  456,  793,
 /*   170 */   748,  783,   12,  356,  565,  506,  273,  586,   77,   69,
 /*   180 */    39,  138,   69, 1012,  701,  440,   22,  701,  768,  834,
 /*   190 */   833,  805,  834,  833,   14,  836,  785,  111,    1,  489,
 /*   200 */   798,   54,  702,  804,  835,  702,  587,  589,  834,  833,
 /*   210 */   588,  834,  833,  806,  223,  570,  659,  701,   51,   52,
 /*   220 */   701,  137,  508,  649,  706,   53, 1078,  836, 1029, 1029,
 /*   230 */    21,  412,  386,    2, 1078,  172,  117,  328,  793,  705,
 /*   240 */   498, 1078,  157,  807,  833,  439,  436,  435,  510,  810,
 /*   250 */   392,   75,  443,  188,  421,  250,  793,  809,  808,  807,
 /*   260 */   501, 1078,  784,  434, 1178,  275,  935,  835,  648,   56,
 /*   270 */   455,  366,  687,  686, 1078,  130, 1078, 1078,  174,  121,
 /*   280 */   326,  445,  321,  444,  159, 1078, 1078, 1078, 1078,  811,
 /*   290 */   793,  700,  812,  793,  162,  783,   12,  245,  319,  506,
 /*   300 */    60,   60,   59,   59,   59,   58,  253, 1078,  840,  526,
 /*   310 */   836,  650,  651,  513,  834,  833,  563,  805,  836,  798,
 /*   320 */   785,  717,  805,   23,  611,   54,  527,  526,  158,  257,
 /*   330 */   835,  797,  699,  695,  835,  835,  242,  241,  240,  806,
 /*   340 */   223,  523,   51,   52,  806,  208,  834,  833,  508,   53,
 /*   350 */  1063,  356,  564,  508,  384,  526,  171,    2, 1063,  523,
 /*   360 */   548,   77,  793,  786,  498, 1063,  431,  807,  833,  798,
 /*   370 */   578,  329,  836,  810,  723,  579,  466,  451,  729,  465,
 /*   380 */   793,  809,  808,  807,  835, 1063,  789,  523,  786,  547,
 /*   390 */   546,  388,  788,  545,  502,  475,  497,  366, 1063,  729,
 /*   400 */  1063, 1063,  754,  407,  798,  729,  692, 1160, 1160, 1063,
 /*   410 */   329, 1063, 1063,   76,  793,  635,  117,  793,  516,  783,
 /*   420 */    12,  786,  787,  835,  519,   88,  370,  108,  835,  834,
 /*   430 */   833, 1063,  319,  117,  464,  361,  479,  834,  833,  731,
 /*   440 */   836, 1163,  792,  836,   64,   65,  509,  339, 1160, 1160,
 /*   450 */   795,  795,   62,   62,   63,   63,   63,   63,  781,   61,
 /*   460 */    61,   61,   61,   60,   60,   59,   59,   59,   58,  253,
 /*   470 */   836,  807,  729,  722,  361,   55,  792,  810,   58,  253,
 /*   480 */   167,   73,  777,  776,  604,  809,  808,  807,  798, 1160,
 /*   490 */  1160,  834,  833,  729,   64,   65,  509,  339,   66,  729,
 /*   500 */   795,  795,   62,   62,   63,   63,   63,   63,  474,   61,
 /*   510 */    61,   61,   61,   60,   60,   59,   59,   59,   58,  253,
 /*   520 */   836,  770,  836,  798,  712,  771,   64,   65,  509,  339,
 /*   530 */  1160, 1160,  795,  795,   62,   62,   63,   63,   63,   63,
 /*   540 */   765,   61,   61,   61,   61,   60,   60,   59,   59,   59,
 /*   550 */    58,  253,  764,  729,  613,  836,  562,  562,   44,  834,
 /*   560 */   833,  191,  834,  833,  566,  805,  246,  685,   45,  454,
 /*   570 */   482,  365, 1160, 1160,  729,  772,  636,  252,  835,  662,
 /*   580 */   729, 1317,  184,  514,    3,  538,  613,  806,  208,  834,
 /*   590 */   833,  765, 1163,  313, 1163,  661,  508,  393,  835,  357,
 /*   600 */  1269,  742,  792,  764,  539,  540,  835, 1269,  130,   64,
 /*   610 */    65,  509,  339, 1160, 1160,  795,  795,   62,   62,   63,
 /*   620 */    63,   63,   63,  742,   61,   61,   61,   61,   60,   60,
 /*   630 */    59,   59,   59,   58,  253,  818,  792,  769,  158,  834,
 /*   640 */   833,  834,  833,  113,  566,  754,  836,   76,   64,   65,
 /*   650 */   509,  339, 1160, 1160,  795,  795,   62,   62,   63,   63,
 /*   660 */    63,   63,  488,   61,   61,   61,   61,   60,   60,   59,
 /*   670 */    59,   59,   58,  253,  834,  833,  541,  775,  836,  357,
 /*   680 */  1268,  330,  734,  473,   87,  814,  836, 1268,  836,   64,
 /*   690 */    65,  509,  339, 1160, 1160,  795,  795,   62,   62,   63,
 /*   700 */    63,   63,   63,  447,   61,   61,   61,   61,   60,   60,
 /*   710 */    59,   59,   59,   58,  253,   63,   63,   63,   63,   56,
 /*   720 */    61,   61,   61,   61,   60,   60,   59,   59,   59,   58,
 /*   730 */   253,  494,   64,   65,  509,  339,  370,  671,  795,  795,
 /*   740 */    62,   62,   63,   63,   63,   63,  813,   61,   61,   61,
 /*   750 */    61,   60,   60,   59,   59,   59,   58,  253,  811, 1086,
 /*   760 */   571,  812,  190,  488,  309,  834,  833,  312,  591,   64,
 /*   770 */    65,  509,  339,  469, 1086,  795,  795,   62,   62,   63,
 /*   780 */    63,   63,   63,  836,   61,   61,   61,   61,   60,   60,
 /*   790 */    59,   59,   59,   58,  253,  107, 1087,  834,  833,  836,
 /*   800 */   758,  798, 1164,  836,  485,  834,  833,  834,  833,  349,
 /*   810 */   802, 1087,  755, 1086,   78,  836,  468,  835,   64,   65,
 /*   820 */   509,  339, 1086,  571,  795,  795,   62,   62,   63,   63,
 /*   830 */    63,   63,  510,   61,   61,   61,   61,   60,   60,   59,
 /*   840 */    59,   59,   58,  253,  501, 1088,  271,  270, 1214,  836,
 /*   850 */  1087,   78,  603,  493,  791,   64,   65,  509,  339, 1087,
 /*   860 */  1088,  795,  795,   62,   62,   63,   63,   63,   63,  538,
 /*   870 */    61,   61,   61,   61,   60,   60,   59,   59,   59,   58,
 /*   880 */   253,  798,  835,  506, 1167,  777,  776,   20,  539,  398,
 /*   890 */   117,  675,   69, 1022,  580,  581,  409,  701,  337, 1088,
 /*   900 */    78,  753,  834,  833,  785,  391,  780,  779, 1088,   54,
 /*   910 */     8,  835,  167,  576,  745,  702,  805,  620,  834,  833,
 /*   920 */   798,  670,  834,  833,  327,  677,   51,   52,   44,  835,
 /*   930 */   701, 1277, 1277,   53,  834,  833,  390,  112,  806,  223,
 /*   940 */  1229,    2, 1170,  236,  235,  484,  793,  508,  498,  836,
 /*   950 */   282,  807,  833, 1164,  117, 1164,  712,  810,   68,  136,
 /*   960 */   399,  775,  782,  835,  793,  809,  808,  807,  807,   85,
 /*   970 */   714,  836,  835,  504,  810,  466,  467,   42,  576,  775,
 /*   980 */  1277, 1277,  809,  808,  807,  816,  759,  772,  499,  252,
 /*   990 */    86,   19,  767,  643,  442,  832,  366,  470,  793,  111,
 /*  1000 */   798,  793,  830,  783,   12,   27,   64,   65,  509,  339,
 /*  1010 */   836,  831,  795,  795,   62,   62,   63,   63,   63,   63,
 /*  1020 */   836,   61,   61,   61,   61,   60,   60,   59,   59,   59,
 /*  1030 */    58,  253,   50, 1229,   48,   64,   65,  509,  339,   74,
 /*  1040 */   544,  795,  795,   62,   62,   63,   63,   63,   63,  510,
 /*  1050 */    61,   61,   61,   61,   60,   60,   59,   59,   59,   58,
 /*  1060 */   253,  501, 1243,  532,  477,  136,  836,  329,  834,  833,
 /*  1070 */   483,  724,    4,   83,  836,  500,  780,  779,  835,  341,
 /*  1080 */   835,  335,  611,  798,  617,  617,   64,   65,  509,  339,
 /*  1090 */   834,  833,  795,  795,   62,   62,   63,   63,   63,   63,
 /*  1100 */   506,   61,   61,   61,   61,   60,   60,   59,   59,   59,
 /*  1110 */    58,  253,  480,  476,  798,  668,  720,  667,  586,   77,
 /*  1120 */   739,  785,  114,  168,  608, 1172,   54,  532,    6,  834,
 /*  1130 */   833,  265,  310,  756,  836,  744,  311,  481,  615,  834,
 /*  1140 */   833,   78,  608,   51,   52,  835, 1172,  587,  589,  775,
 /*  1150 */    53,  588, 1172,  374,  238,  510,  738,  805,    2,  736,
 /*  1160 */   271,  270,  836,  793,  689,  498,  836,  501,  807,  833,
 /*  1170 */   835,   56,  413,  247,  810,  117,  450,  724,    4,  806,
 /*  1180 */   223,  793,  809,  808,  807,  834,  833,  836,  508,    5,
 /*  1190 */   535,  836,  531,  834,  833,  717, 1172,  414,  836,  777,
 /*  1200 */   776,  729,  798,  537, 1172,  536,  506,  844,  835,  733,
 /*  1210 */   416, 1172,  805,  371,  761,  793,  466,  457,  793,  730,
 /*  1220 */   783,   12,  729,   78,  732,  835,  338,  785,  729,  805,
 /*  1230 */    18, 1172,   54,  798,  806,  118,  395,  366,  597,  835,
 /*  1240 */   718,  786,  835,  508, 1172,  641, 1172, 1172,  549,   51,
 /*  1250 */    52,  806,  118,  834,  833, 1172,   53, 1172, 1172,  737,
 /*  1260 */   508,  317,   17,  305,    2,  381,  786,  259,  111,  793,
 /*  1270 */   837,  498,  666,  713,  807,  833,  835, 1172,  843,    3,
 /*  1280 */   810,  834,  833,  487,  432,  834,  833,  793,  809,  808,
 /*  1290 */   807,  111,  754,  836,  529,  665,  713,  836,  406,  786,
 /*  1300 */   170,  602, 1165, 1277, 1277,  594,  834,  833,  110,  754,
 /*  1310 */   834,  833,  338,  842,  549,  640,  639,  834,  833,  602,
 /*  1320 */   707,  793,  529,  594,  793,  835,  783,   12,  631,   64,
 /*  1330 */    65,  509,  339,  492,  757,  795,  795,   62,   62,   63,
 /*  1340 */    63,   63,   63,  704,   61,   61,   61,   61,   60,   60,
 /*  1350 */    59,   59,   59,   58,  253,   64,   65,  509,  339,  298,
 /*  1360 */    16,  795,  795,   62,   62,   63,   63,   63,   63,   11,
 /*  1370 */    61,   61,   61,   61,   60,   60,   59,   59,   59,   58,
 /*  1380 */   253,  395,   64,   65,  509,  339,  743,    4,  795,  795,
 /*  1390 */    62,   62,   63,   63,   63,   63,  117,   61,   61,   61,
 /*  1400 */    61,   60,   60,   59,   59,   59,   58,  253,  422,  728,
 /*  1410 */     4,  559,  834,  833,  166,  168,  834,  833,   56,  496,
 /*  1420 */   757,  836,  727,    4,   64,   65,  509,  339,   49,  559,
 /*  1430 */   795,  795,   62,   62,   63,   63,   63,   63,  165,   61,
 /*  1440 */    61,   61,   61,   60,   60,   59,   59,   59,   58,  253,
 /*  1450 */   607,  836,  667,  709,   64,   65,  509,  339,  842,  676,
 /*  1460 */   795,  795,   62,   62,   63,   63,   63,   63,  708,   61,
 /*  1470 */    61,   61,   61,   60,   60,   59,   59,   59,   58,  253,
 /*  1480 */   164,   46,  725,    4,   64,   65,  509,  339,  163,  674,
 /*  1490 */   795,  795,   62,   62,   63,   63,   63,   63,  696,   61,
 /*  1500 */    61,   61,   61,   60,   60,   59,   59,   59,   58,  253,
 /*  1510 */   246,  685,  836,  454,   64,   65,  509,  339,  124,  657,
 /*  1520 */   795,  795,   62,   62,   63,   63,   63,   63,  460,   61,
 /*  1530 */    61,   61,   61,   60,   60,   59,   59,   59,   58,  253,
 /*  1540 */   834,  833,  419,  691,   64,   65,  509,  339,  458,  189,
 /*  1550 */   795,  795,   62,   62,   63,   63,   63,   63,    7,   61,
 /*  1560 */    61,   61,   61,   60,   60,   59,   59,   59,   58,  253,
 /*  1570 */   834,  833,  726,    4,   64,   65,  509,  339,  690,  316,
 /*  1580 */   795,  795,   62,   62,   63,   63,   63,   63,   15,   61,
 /*  1590 */    61,   61,   61,   60,   60,   59,   59,   59,   58,  253,
 /*  1600 */   612, 1193,   64,   65,  509,  339,  274,  456,  795,  795,
 /*  1610 */    62,   62,   63,   63,   63,   63,  825,   61,   61,   61,
 /*  1620 */    61,   60,   60,   59,   59,   59,   58,  253,  574,  688,
 /*  1630 */   836,  834,  833,   64,   65,  509,  339,  836,   28,  795,
 /*  1640 */   795,   62,   62,   63,   63,   63,   63,  684,   61,   61,
 /*  1650 */    61,   61,   60,   60,   59,   59,   59,   58,  253,  836,
 /*  1660 */  1244,   64,   65,  509,  339,  683,  836,  795,  795,   62,
 /*  1670 */    62,   63,   63,   63,   63,  510,   61,   61,   61,   61,
 /*  1680 */    60,   60,   59,   59,   59,   58,  253,  501, 1242,  420,
 /*  1690 */   477,   64,   65,  509,  339,  116,  168,  795,  795,   62,
 /*  1700 */    62,   63,   63,   63,   63,  798,   61,   61,   61,   61,
 /*  1710 */    60,   60,   59,   59,   59,   58,  253,  123,  600,  280,
 /*  1720 */   302,  255,  679,  805,  258,  168,  506,  421,  297,  401,
 /*  1730 */   337,  279,  115,  835,  353,   44,  835,  448,  337,  476,
 /*  1740 */   835,  823,  835,  835,  836,  806,  208,  785,  836,  834,
 /*  1750 */   833,  835,   54,   37,  508,   25,  834,  833,  293,  133,
 /*  1760 */   300,  127,  525,  821,  299,   44,  350,  836,  260,   51,
 /*  1770 */    52,  352,  178,  835,  263,  805,   53,  104,  834,  833,
 /*  1780 */    78,  510,  122,  441,    2,  834,  833,  333,  835,  793,
 /*  1790 */   525,  498,  805,  501,  807,  833,  477,  806,  223,  805,
 /*  1800 */   810,  713,  256,  754,  568,  835,  508,  793,  809,  808,
 /*  1810 */   807,  358,  835,  556,  806,  223,  167,  354,  759,  176,
 /*  1820 */   956,  806,  118,  508,  798,   78,  766,  623,  647,  836,
 /*  1830 */   508,   36,  506,  713,  267,  836,  638,  331,  438,  717,
 /*  1840 */   731,  793,   82,  247,  793,  478,  783,   12,  703,  836,
 /*  1850 */   318,  266,  835,  785,  433,  366,  836,  367,   54,  584,
 /*  1860 */   712,  836,  332,  834,  833,   81,  634,  834,  833,   24,
 /*  1870 */   169,  838,  366,  160,  449,   51,   52,   80,  826,  754,
 /*  1880 */   264,  517,   53,  824,  835,  289,  834,  833,  156,  561,
 /*  1890 */     2,  835,  324,  397,  717,  793,  835,  498,  835,  517,
 /*  1900 */   807,  833,  698,  616,   10,  510,  810,  835,  429,  380,
 /*  1910 */   187,  152,  822,  793,  809,  808,  807,  501,  247,  101,
 /*  1920 */    99,   64,   38,  509,  339,  835,   35,  795,  795,   62,
 /*  1930 */    62,   63,   63,   63,   63,  836,   61,   61,   61,   61,
 /*  1940 */    60,   60,   59,   59,   59,   58,  253,  793,  834,  833,
 /*  1950 */   793,  713,  783,   12,  834,  833,  506,   34,   33,  836,
 /*  1960 */   819,  805,   32,  555,  379,   98,  805,  644,  834,  833,
 /*  1970 */   552,  836,  805,  835,  835,  834,  833,  785,  717,  835,
 /*  1980 */   834,  833,   54,  806,  223,  835,  378,  697,  806,  223,
 /*  1990 */   836,  835,  508,  376,  806,  118,  555,  508,  694,   51,
 /*  2000 */    52,   97,  653,  508,  836,  805,   53,  595,  596,  590,
 /*  2010 */   585,  510,  410,  337,    2,  656,  552,  247,  835,  793,
 /*  2020 */   387,  498,  805,  501,  807,  833,  835,  806,  223,  836,
 /*  2030 */   810,  583,  105,  168,  805,  835,  508,  793,  809,  808,
 /*  2040 */   807,  366,  577,  377,  806,  118,  490,  835,  408,  336,
 /*  2050 */   147,  383,  754,  508,  834,  833,  806,  216,  295,   13,
 /*  2060 */   815,  292,  506,  181,  471,  508,  192,  624,  558,   92,
 /*  2070 */   534,  793,  619,  835,  793,  533,  783,   12,  834,  833,
 /*  2080 */   394,  337,  287,  785,  836,  366,  557,  803,   54,  139,
 /*  2090 */   834,  833,  515,  375,  835,  835,   90,  247,  790,  262,
 /*  2100 */   835,  759,  754,  582,  243,   51,   52,  109,  836,  834,
 /*  2110 */   833,  835,   53,  503,  754,  239,  369,  510,  368,  382,
 /*  2120 */     2,  315,  610,  834,  833,  793,  835,  498,  805,  501,
 /*  2130 */   807,  833,  839,  179,  805,  180,  810,  829,  827,  805,
 /*  2140 */   828,  835,  719,  793,  809,  808,  807,  835,  834,  833,
 /*  2150 */   806,  194,  835,  836,  177,  835,  806,  204,  836,  508,
 /*  2160 */   512,  806,  226,  285,  554,  508,  430,  553,  506,  759,
 /*  2170 */   508,  511,  715,  836,  805,  614,  835,  793,  836,  805,
 /*  2180 */   793,   72,  783,   12,  836,  835,  103,  835,  836,  785,
 /*  2190 */   175,  820,  835,  836,   54,  801,  806,  224,  800,  173,
 /*  2200 */   710,  806,  232,  834,  833,  508,  274,  836,  754,  836,
 /*  2210 */   508,   51,   52,  835,  754,  343,  606,   23,   53,  754,
 /*  2220 */    43,  569,  472,  510,  342,  805,    2,  834,  833,   67,
 /*  2230 */   836,  793,  186,  498,  253,  501,  807,  833,  835,  799,
 /*  2240 */   805,  836,  810,  752,  495,  805,   84,  806,  231,  793,
 /*  2250 */   809,  808,  807,  835,  754,  251,  508,  283,  835,  754,
 /*  2260 */   269,  550,  806,  233,  268,   47,  334,  806,  237,   57,
 /*  2270 */   835,  508,  834,  833,  506,  751,  508,  834,  833,  488,
 /*  2280 */   750,  161,  836,  793,  747,  601,  793,  389,  783,   12,
 /*  2290 */  1168,  741,  834,  833,  835,  785,  244,  834,  833,  134,
 /*  2300 */    54,  520,  463,  834,  833,  754,  756,  834,  833,  678,
 /*  2310 */   522,  735,  834,  833,  135,  835,  572,   51,   52,  459,
 /*  2320 */   754,  320,  835,  654,   53,  754,  834,  833,  834,  833,
 /*  2330 */   456,  805,    2, 1170,  835,  680,  835,  793,  551,  498,
 /*  2340 */   160,  560,  807,  833,  835,  663,  669,  510,  810,  834,
 /*  2350 */   833,  542,  664,  806,  272,  793,  809,  808,  807,  501,
 /*  2360 */   834,  833,  508,  446,   65,  509,  339,  385,  322,  795,
 /*  2370 */   795,   62,   62,   63,   63,   63,   63,  805,   61,   61,
 /*  2380 */    61,   61,   60,   60,   59,   59,   59,   58,  253,  793,
 /*  2390 */   835,  660,  793,  276,  783,   12,  760,  372,  506,  806,
 /*  2400 */   340,  834,  833,  632,  659,  805,  835,  716,  508,  314,
 /*  2410 */   307,  754,  805,  404,  658,  637,  835,  618,  835,  785,
 /*  2420 */   630,  360,  835,  835,   54,  835,  835,  806,  230,  155,
 /*  2430 */   629,  521,  628,  346,  806,  203,  508,  805,  507,  627,
 /*  2440 */   154,   51,   52,  508,  835,  308,  835,  359,   53,   30,
 /*  2450 */   835,  835,  102,  510,  428,  132,    2,  754,  835,  806,
 /*  2460 */   221,  793,  423,  498,  153,  501,  807,  833,  508,  249,
 /*  2470 */   294,  805,  810,  291,  281,  835,  805,  411,  277,  793,
 /*  2480 */   809,  808,  807,  835,  835,  754,  835,  835,  278,  835,
 /*  2490 */   306,  835,  754,  806,  225,  426,   31,  151,  806,  364,
 /*  2500 */   609,  835,  508,  131,  506,  100,  150,  508,  605,  149,
 /*  2510 */   185,  106,  418,  793,  599,  148,  793,  754,  783,   12,
 /*  2520 */   417,  593,  129,  128,  405,  785,  402,  146,  573,   96,
 /*  2530 */    54,  145,  400,   95,  144,   94,  143,   93,  142,   30,
 /*  2540 */   543,  141,   29,  530,  518,   26,  126,   51,   52,  373,
 /*  2550 */   528,  754,  524,  805,   53,  125,  754,  140,  805,  193,
 /*  2560 */    79,  778,    2,  344,  774,  763,  835,  793,  721,  498,
 /*  2570 */   491,  835,  834,  833,  711,  806,  363,  183,  810,  323,
 /*  2580 */   806,  362,  182,  655,  508,  793,  809,  808,  807,  508,
 /*  2590 */   437,  234,  598,  304,  424,  509,  339,  301,  355,  795,
 /*  2600 */   795,   62,   62,   63,   63,   63,   63,    9,   61,   61,
 /*  2610 */    61,   61,   60,   60,   59,   59,   59,   58,  253,  793,
 /*  2620 */   796,  773,  793,  762,  783,   12,  642,  805,  248,  345,
 /*  2630 */   427,   41,  505,  754,  805,  740,  652,   91,  754,  567,
 /*  2640 */   835,  805,  646,   78,  673,  645,  836,  835,  672,  806,
 /*  2650 */   220, 1318,  633,  805,  835, 1318,  806,  206,  508, 1318,
 /*  2660 */   805, 1318, 1318,  806,  219,  508,  835,  805, 1318, 1318,
 /*  2670 */  1318, 1318,  508,  835, 1318,  806,  218, 1318, 1318,  805,
 /*  2680 */   835,  805,  806,  205,  508, 1318, 1318, 1318, 1318,  806,
 /*  2690 */   202,  508,  835,  805,  835, 1318, 1318, 1318,  508, 1318,
 /*  2700 */  1318,  806,  119,  806,  201, 1318,  835,  754, 1318, 1318,
 /*  2710 */   508, 1318,  508, 1318,  754,  806,  199, 1318, 1318,  805,
 /*  2720 */  1318,  754, 1318, 1318,  508, 1318, 1318, 1318, 1318, 1318,
 /*  2730 */  1318, 1318,  835,  754, 1318, 1318, 1318, 1318, 1318, 1318,
 /*  2740 */   754,  806,  227, 1318, 1318, 1318, 1318,  754, 1318, 1318,
 /*  2750 */   508, 1318, 1318,  805, 1318, 1318,  805, 1318,  805,  754,
 /*  2760 */  1318,  754, 1318, 1318, 1318, 1318,  835, 1318, 1318,  835,
 /*  2770 */  1318,  835,  805,  754, 1318,  806,  229, 1318,  806,  222,
 /*  2780 */   806,  228, 1318, 1318,  508,  835, 1318,  508,  805,  508,
 /*  2790 */  1318, 1318, 1318, 1318,  806,  217, 1318, 1318, 1318,  754,
 /*  2800 */   805,  835, 1318,  508,  805, 1318, 1318, 1318, 1318, 1318,
 /*  2810 */   806,  214, 1318,  835, 1318, 1318, 1318,  835, 1318,  508,
 /*  2820 */  1318, 1318,  806,  198,  805, 1318,  806,  197, 1318, 1318,
 /*  2830 */  1318,  508, 1318,  754, 1318,  508,  754,  835,  754, 1318,
 /*  2840 */   805, 1318, 1318, 1318, 1318, 1318,  806,  196, 1318, 1318,
 /*  2850 */  1318, 1318,  754,  835,  805,  508,  805, 1318, 1318, 1318,
 /*  2860 */   805, 1318,  806,  195, 1318, 1318, 1318,  835,  754,  835,
 /*  2870 */  1318,  508, 1318,  835, 1318,  805,  806,  207,  806,  212,
 /*  2880 */   754, 1318,  806,  211,  754,  508, 1318,  508,  835, 1318,
 /*  2890 */   805,  508,  805, 1318,  805, 1318, 1318,  806,  120, 1318,
 /*  2900 */  1318, 1318, 1318,  835,  754,  835,  508,  835, 1318, 1318,
 /*  2910 */  1318, 1318,  806,  210,  806,  209,  806,  215, 1318,  805,
 /*  2920 */   754,  508, 1318,  508, 1318,  508, 1318, 1318, 1318, 1318,
 /*  2930 */  1318, 1318,  835, 1318,  754, 1318,  754, 1318, 1318, 1318,
 /*  2940 */   754,  806,  213, 1318, 1318, 1318, 1318, 1318, 1318, 1318,
 /*  2950 */   508, 1318, 1318,  805, 1318,  754,  805, 1318, 1318, 1318,
 /*  2960 */  1318, 1318, 1318, 1318, 1318, 1318,  835, 1318, 1318,  835,
 /*  2970 */   754, 1318,  754, 1318,  754,  806,  200, 1318,  806,   89,
 /*  2980 */  1318, 1318, 1318, 1318,  508, 1318, 1318,  462, 1318, 1318,
 /*  2990 */  1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318,  754,
 /*  3000 */  1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318,
 /*  3010 */  1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318,
 /*  3020 */  1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318,
 /*  3030 */  1318, 1318, 1318,  754, 1318, 1318,  754,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     4,  228,   67,    4,  231,   70,  106,   79,   80,   81,
 /*    10 */    82,  238,   16,   85,   86,   87,   88,   89,   90,   91,
 /*    20 */    92,  110,   94,   95,   96,   97,   98,   99,  100,  101,
 /*    30 */   102,  103,  104,  199,  106,   94,   95,   96,   97,   98,
 /*    40 */    99,  100,  101,  102,  103,  104,  212,  112,  129,  121,
 /*    50 */    88,   55,   89,   90,   91,   92,   93,   94,   95,   96,
 /*    60 */    97,   98,   99,  100,  101,  102,  103,  104,  199,  199,
 /*    70 */     4,  114,   76,    4,   59,  113,  207,   81,  208,  209,
 /*    80 */   199,  212,  212,  100,  101,  102,  103,  104,  160,    4,
 /*    90 */   221,  222,    4,  212,   98,   99,  100,  169,  199,  230,
 /*   100 */   129,  105,  106,  204,  234,   24,  236,  208,  209,  113,
 /*   110 */   114,  212,  285,  244,  118,  180,  120,  121,  147,  123,
 /*   120 */   124,  122,  123,  124,    4,  129,  127,  258,  259,  130,
 /*   130 */   131,  132,  136,  137,  138,  139,   16,  141,   78,   42,
 /*   140 */    43,  207,  308,  309,   24,  318,  319,  148,  279,   65,
 /*   150 */   154,  113,  156,  157,   75,   71,  160,  142,  143,  144,
 /*   160 */    31,  165,  166,  167,  168,  169,  170,  152,  153,  173,
 /*   170 */    41,  175,  176,  113,  114,   55,  250,  243,  244,  113,
 /*   180 */    83,   84,  113,  187,  118,   34,  260,  118,  307,  123,
 /*   190 */   124,  199,  123,  124,  113,    4,   76,  121,  113,  207,
 /*   200 */     4,   81,  136,  118,  212,  136,  272,  273,  123,  124,
 /*   210 */   276,  123,  124,  221,  222,  131,  140,  151,   98,   99,
 /*   220 */   151,  116,  230,   15,  136,  105,  106,    4,  162,  163,
 /*   230 */   296,  297,   81,  113,  114,  116,  244,  121,  118,  151,
 /*   240 */   120,  121,  127,  123,  124,  130,  131,  132,    4,  129,
 /*   250 */   258,  113,   44,  115,  199,  104,  136,  137,  138,  139,
 /*   260 */    16,  141,  114,  148,  180,  186,  115,  212,   60,  121,
 /*   270 */   154,  279,  156,  157,  154,  121,  156,  157,  127,  128,
 /*   280 */   129,  130,  131,  132,  133,  165,  166,  167,  168,  155,
 /*   290 */   170,  121,  158,  173,  124,  175,  176,  113,  147,   55,
 /*   300 */    98,   99,  100,  101,  102,  103,  104,  187,  191,  118,
 /*   310 */     4,  128,  129,  196,  123,  124,   78,  199,    4,  123,
 /*   320 */    76,  199,  199,  169,  207,   81,  135,  136,   43,  274,
 /*   330 */   212,  135,  162,  163,  212,  212,  142,  143,  144,  221,
 /*   340 */   222,  118,   98,   99,  221,  222,  123,  124,  230,  105,
 /*   350 */   106,  113,  114,  230,  146,  164,  121,  113,  114,  136,
 /*   360 */   243,  244,  118,    5,  120,  121,   81,  123,  124,    4,
 /*   370 */     7,  199,    4,  129,  121,   12,  258,  259,   35,  207,
 /*   380 */   136,  137,  138,  139,  212,  141,  114,  164,   30,  272,
 /*   390 */   273,  269,  114,  276,   36,   52,  207,  279,  154,   56,
 /*   400 */   156,  157,  279,   40,    4,   62,  100,   42,   43,  165,
 /*   410 */   199,  167,  168,  160,  170,  199,  244,  173,  301,  175,
 /*   420 */   176,   63,  114,  212,  208,  209,  141,  113,  212,  123,
 /*   430 */   124,  187,  147,  244,  262,  263,  313,  123,  124,  316,
 /*   440 */     4,   26,  136,    4,   79,   80,   81,   82,   83,   84,
 /*   450 */    85,   86,   87,   88,   89,   90,   91,   92,  114,   94,
 /*   460 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   470 */     4,  123,   35,  262,  263,  113,  170,  129,  103,  104,
 /*   480 */   115,  113,  137,  138,  170,  137,  138,  139,  123,   42,
 /*   490 */    43,  123,  124,   56,   79,   80,   81,   82,   51,   62,
 /*   500 */    85,   86,   87,   88,   89,   90,   91,   92,  165,   94,
 /*   510 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   520 */     4,  114,    4,  123,  159,  125,   79,   80,   81,   82,
 /*   530 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   540 */    10,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   550 */   103,  104,   22,   35,  118,    4,  117,  118,  121,  123,
 /*   560 */   124,  113,  123,  124,   78,  199,  245,  246,  121,  248,
 /*   570 */    52,  210,   42,   43,   56,  214,  215,  216,  212,   21,
 /*   580 */    62,  192,  193,  194,  195,  199,  150,  221,  222,  123,
 /*   590 */   124,   10,  177,  199,  179,   37,  230,  203,  212,  113,
 /*   600 */   114,   32,  136,   22,  218,  219,  212,  121,  121,   79,
 /*   610 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   620 */    90,   91,   92,   54,   94,   95,   96,   97,   98,   99,
 /*   630 */   100,  101,  102,  103,  104,  119,  170,  114,   43,  123,
 /*   640 */   124,  123,  124,  121,   78,  279,    4,  160,   79,   80,
 /*   650 */    81,   82,   42,   43,   85,   86,   87,   88,   89,   90,
 /*   660 */    91,   92,  165,   94,   95,   96,   97,   98,   99,  100,
 /*   670 */   101,  102,  103,  104,  123,  124,  290,  291,    4,  113,
 /*   680 */   114,  315,  316,  165,  187,  134,    4,  121,    4,   79,
 /*   690 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   700 */    90,   91,   92,  100,   94,   95,   96,   97,   98,   99,
 /*   710 */   100,  101,  102,  103,  104,   89,   90,   91,   92,  121,
 /*   720 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   730 */   104,  115,   79,   80,   81,   82,  141,  212,   85,   86,
 /*   740 */    87,   88,   89,   90,   91,   92,  221,   94,   95,   96,
 /*   750 */    97,   98,   99,  100,  101,  102,  103,  104,  155,  106,
 /*   760 */   118,  158,  113,  165,   67,  123,  124,   70,   26,   79,
 /*   770 */    80,   81,   82,   38,  121,   85,   86,   87,   88,   89,
 /*   780 */    90,   91,   92,    4,   94,   95,   96,   97,   98,   99,
 /*   790 */   100,  101,  102,  103,  104,  113,  106,  123,  124,    4,
 /*   800 */   114,    4,   26,    4,  199,  123,  124,  123,  124,  112,
 /*   810 */   136,  121,   26,  160,   72,    4,   81,  212,   79,   80,
 /*   820 */    81,   82,  169,  181,   85,   86,   87,   88,   89,   90,
 /*   830 */    91,   92,    4,   94,   95,   96,   97,   98,   99,  100,
 /*   840 */   101,  102,  103,  104,   16,  106,   98,   99,  106,    4,
 /*   850 */   160,   72,  170,  207,  170,   79,   80,   81,   82,  169,
 /*   860 */   121,   85,   86,   87,   88,   89,   90,   91,   92,  199,
 /*   870 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   880 */   104,    4,  212,   55,  177,  137,  138,   14,  218,  219,
 /*   890 */   244,  285,  113,  114,  142,  143,  144,  118,  199,  160,
 /*   900 */    72,  114,  123,  124,   76,  217,  218,  219,  169,   81,
 /*   910 */   113,  212,  115,  118,  309,  136,  199,  207,  123,  124,
 /*   920 */   123,   76,  123,  124,  318,  319,   98,   99,  121,  212,
 /*   930 */   151,  152,  153,  105,  123,  124,  237,  121,  221,  222,
 /*   940 */    13,  113,  114,   98,   99,  115,  118,  230,  120,    4,
 /*   950 */   199,  123,  124,  177,  244,  179,  159,  129,  113,  199,
 /*   960 */   290,  291,  114,  212,  136,  137,  138,  139,  123,  121,
 /*   970 */   159,    4,  212,  174,  129,  258,  259,  141,  183,  291,
 /*   980 */   152,  153,  137,  138,  139,  220,  287,  214,  215,  216,
 /*   990 */   113,   14,  114,  228,  229,   21,  279,  161,  170,  121,
 /*  1000 */   123,  173,   28,  175,  176,   49,   79,   80,   81,   82,
 /*  1010 */     4,   37,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  1020 */     4,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*  1030 */   103,  104,  177,  106,  179,   79,   80,   81,   82,  113,
 /*  1040 */   289,   85,   86,   87,   88,   89,   90,   91,   92,    4,
 /*  1050 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*  1060 */   104,   16,  106,  118,   19,  199,    4,  199,  123,  124,
 /*  1070 */   310,  311,  312,   57,    4,  217,  218,  219,  212,  255,
 /*  1080 */   212,  257,  207,    4,  117,  118,   79,   80,   81,   82,
 /*  1090 */   123,  124,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  1100 */    55,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*  1110 */   103,  104,   19,   68,    4,  239,  114,  241,  243,  244,
 /*  1120 */    46,   76,  115,  121,  118,   35,   81,  182,   83,  123,
 /*  1130 */   124,  263,  199,  117,    4,  114,  203,   44,  207,  123,
 /*  1140 */   124,   72,  136,   98,   99,  212,   56,  272,  273,  291,
 /*  1150 */   105,  276,   62,  302,  303,    4,   61,  199,  113,   66,
 /*  1160 */    98,   99,    4,  118,  114,  120,    4,   16,  123,  124,
 /*  1170 */   212,  121,  297,  280,  129,  244,  310,  311,  312,  221,
 /*  1180 */   222,  136,  137,  138,  139,  123,  124,    4,  230,   80,
 /*  1190 */   128,    4,  299,  123,  124,  199,  106,  128,    4,  137,
 /*  1200 */   138,   35,  123,  141,  114,  143,   55,    0,  212,   32,
 /*  1210 */   144,  121,  199,  201,  135,  170,  258,  259,  173,   54,
 /*  1220 */   175,  176,   56,   72,   61,  212,  199,   76,   62,  199,
 /*  1230 */    14,  141,   81,  123,  221,  222,   29,  279,  172,  212,
 /*  1240 */   170,    5,  212,  230,  154,  135,  156,  157,  118,   98,
 /*  1250 */    99,  221,  222,  123,  124,  165,  105,  167,  168,  166,
 /*  1260 */   230,  114,   14,  199,  113,  269,   30,  203,  121,  118,
 /*  1270 */   108,  120,   36,  214,  123,  124,  212,  187,  194,  195,
 /*  1280 */   129,  123,  124,  270,  114,  123,  124,  136,  137,  138,
 /*  1290 */   139,  121,  279,    4,  136,   59,  214,    4,  286,   63,
 /*  1300 */   270,  118,   26,  152,  153,  118,  123,  124,  113,  279,
 /*  1310 */   123,  124,  199,  106,  184,  212,  213,  123,  124,  136,
 /*  1320 */   261,  170,  164,  136,  173,  212,  175,  176,  134,   79,
 /*  1330 */    80,   81,   82,  306,  307,   85,   86,   87,   88,   89,
 /*  1340 */    90,   91,   92,  261,   94,   95,   96,   97,   98,   99,
 /*  1350 */   100,  101,  102,  103,  104,   79,   80,   81,   82,  207,
 /*  1360 */    14,   85,   86,   87,   88,   89,   90,   91,   92,   14,
 /*  1370 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*  1380 */   104,   29,   79,   80,   81,   82,  311,  312,   85,   86,
 /*  1390 */    87,   88,   89,   90,   91,   92,  244,   94,   95,   96,
 /*  1400 */    97,   98,   99,  100,  101,  102,  103,  104,  114,  311,
 /*  1410 */   312,  118,  123,  124,   14,  121,  123,  124,  121,  306,
 /*  1420 */   307,    4,  311,  312,   79,   80,   81,   82,  178,  136,
 /*  1430 */    85,   86,   87,   88,   89,   90,   91,   92,  114,   94,
 /*  1440 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1450 */   239,    4,  241,  164,   79,   80,   81,   82,  106,  114,
 /*  1460 */    85,   86,   87,   88,   89,   90,   91,   92,   38,   94,
 /*  1470 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1480 */   114,  178,  311,  312,   79,   80,   81,   82,  114,  114,
 /*  1490 */    85,   86,   87,   88,   89,   90,   91,   92,  162,   94,
 /*  1500 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1510 */   245,  246,    4,  248,   79,   80,   81,   82,  116,  114,
 /*  1520 */    85,   86,   87,   88,   89,   90,   91,   92,  116,   94,
 /*  1530 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1540 */   123,  124,  277,  100,   79,   80,   81,   82,  121,  114,
 /*  1550 */    85,   86,   87,   88,   89,   90,   91,   92,  113,   94,
 /*  1560 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1570 */   123,  124,  311,  312,   79,   80,   81,   82,  114,  114,
 /*  1580 */    85,   86,   87,   88,   89,   90,   91,   92,  113,   94,
 /*  1590 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1600 */   183,  106,   79,   80,   81,   82,  152,  153,   85,   86,
 /*  1610 */    87,   88,   89,   90,   91,   92,  108,   94,   95,   96,
 /*  1620 */    97,   98,   99,  100,  101,  102,  103,  104,  181,  155,
 /*  1630 */     4,  123,  124,   79,   80,   81,   82,    4,  115,   85,
 /*  1640 */    86,   87,   88,   89,   90,   91,   92,  114,   94,   95,
 /*  1650 */    96,   97,   98,   99,  100,  101,  102,  103,  104,    4,
 /*  1660 */   106,   79,   80,   81,   82,  114,    4,   85,   86,   87,
 /*  1670 */    88,   89,   90,   91,   92,    4,   94,   95,   96,   97,
 /*  1680 */    98,   99,  100,  101,  102,  103,  104,   16,  106,  114,
 /*  1690 */    19,   79,   80,   81,   82,  114,  121,   85,   86,   87,
 /*  1700 */    88,   89,   90,   91,   92,    4,   94,   95,   96,   97,
 /*  1710 */    98,   99,  100,  101,  102,  103,  104,    9,  114,   11,
 /*  1720 */   199,   13,  114,  199,  203,  121,   55,  199,  114,  199,
 /*  1730 */   199,   23,  114,  212,   26,  121,  212,  113,  199,   68,
 /*  1740 */   212,  108,  212,  212,    4,  221,  222,   76,    4,  123,
 /*  1750 */   124,  212,   81,  169,  230,  113,  123,  124,  114,   18,
 /*  1760 */   199,   53,  136,  108,  203,  121,   58,    4,  237,   98,
 /*  1770 */    99,   63,   64,  212,   49,  199,  105,   69,  123,  124,
 /*  1780 */    72,    4,   74,  115,  113,  123,  124,  224,  212,  118,
 /*  1790 */   164,  120,  199,   16,  123,  124,   19,  221,  222,  199,
 /*  1800 */   129,  214,  274,  279,  114,  212,  230,  136,  137,  138,
 /*  1810 */   139,  121,  212,  151,  221,  222,  115,  109,  287,  111,
 /*  1820 */   114,  221,  222,  230,  123,   72,  287,  121,    6,    4,
 /*  1830 */   230,  113,   55,  214,  258,    4,    8,  313,   49,  199,
 /*  1840 */   316,  170,  113,  280,  173,   68,  175,  176,  261,    4,
 /*  1850 */   114,  258,  212,   76,   49,  279,    4,  149,   81,  106,
 /*  1860 */   159,    4,  224,  123,  124,  113,  122,  123,  124,  113,
 /*  1870 */   270,  199,  279,  188,  189,   98,   99,  113,  199,  279,
 /*  1880 */   261,  118,  105,  199,  212,  199,  123,  124,  133,  203,
 /*  1890 */   113,  212,  147,  185,  199,  118,  212,  120,  212,  136,
 /*  1900 */   123,  124,  162,  120,   13,    4,  129,  212,   81,  269,
 /*  1910 */   115,  141,  199,  136,  137,  138,  139,   16,  280,  160,
 /*  1920 */   146,   79,   80,   81,   82,  212,   88,   85,   86,   87,
 /*  1930 */    88,   89,   90,   91,   92,    4,   94,   95,   96,   97,
 /*  1940 */    98,   99,  100,  101,  102,  103,  104,  170,  123,  124,
 /*  1950 */   173,  214,  175,  176,  123,  124,   55,   88,   88,    4,
 /*  1960 */   199,  199,   88,  118,  269,  171,  199,  136,  123,  124,
 /*  1970 */   118,    4,  199,  212,  212,  123,  124,   76,  199,  212,
 /*  1980 */   123,  124,   81,  221,  222,  212,   18,  162,  221,  222,
 /*  1990 */     4,  212,  230,   24,  221,  222,  151,  230,  261,   98,
 /*  2000 */    99,  146,  145,  230,    4,  199,  105,  153,  172,  106,
 /*  2010 */   106,    4,   25,  199,  113,  114,  164,  280,  212,  118,
 /*  2020 */   258,  120,  199,   16,  123,  124,  212,  221,  222,    4,
 /*  2030 */   129,   61,   50,  121,  199,  212,  230,  136,  137,  138,
 /*  2040 */   139,  279,   50,  270,  221,  222,  279,  212,  269,  282,
 /*  2050 */   141,  237,  279,  230,  123,  124,  221,  222,  180,  113,
 /*  2060 */   199,  112,   55,  161,  258,  230,  113,  136,  120,  112,
 /*  2070 */   114,  170,  117,  212,  173,  114,  175,  176,  123,  124,
 /*  2080 */    48,  199,  199,   76,    4,  279,  203,  199,   81,  110,
 /*  2090 */   123,  124,   47,  270,  212,  212,  211,  280,  199,  227,
 /*  2100 */   212,  287,  279,  136,  264,   98,   99,  227,    4,  123,
 /*  2110 */   124,  212,  105,  199,  279,  303,  305,    4,  305,  237,
 /*  2120 */   113,  114,  136,  123,  124,  118,  212,  120,  199,   16,
 /*  2130 */   123,  124,  198,  200,  199,  107,  129,  198,   64,  199,
 /*  2140 */   198,  212,  199,  136,  137,  138,  139,  212,  123,  124,
 /*  2150 */   221,  222,  212,    4,  200,  212,  221,  222,    4,  230,
 /*  2160 */   198,  221,  222,  199,  164,  230,   77,  203,   55,  287,
 /*  2170 */   230,  205,  199,    4,  199,  150,  212,  170,    4,  199,
 /*  2180 */   173,  121,  175,  176,    4,  212,  202,  212,    4,   76,
 /*  2190 */    73,  206,  212,    4,   81,  267,  221,  222,  246,  116,
 /*  2200 */   199,  221,  222,  123,  124,  230,  152,    4,  279,    4,
 /*  2210 */   230,   98,   99,  212,  279,  252,  136,  169,  105,  279,
 /*  2220 */   167,  117,  166,    4,  253,  199,  113,  123,  124,  168,
 /*  2230 */     4,  118,  254,  120,  104,   16,  123,  124,  212,  256,
 /*  2240 */   199,    4,  129,   81,  226,  199,  113,  221,  222,  136,
 /*  2250 */   137,  138,  139,  212,  279,  104,  230,  199,  212,  279,
 /*  2260 */   288,  203,  221,  222,  283,  177,  255,  221,  222,  280,
 /*  2270 */   212,  230,  123,  124,   55,  256,  230,  123,  124,  165,
 /*  2280 */   271,  199,    4,  170,  271,  136,  173,   45,  175,  176,
 /*  2290 */   177,  314,  123,  124,  212,   76,   27,  123,  124,  116,
 /*  2300 */    81,  117,  199,  123,  124,  279,  117,  123,  124,  199,
 /*  2310 */   136,  314,  123,  124,  267,  212,  136,   98,   99,  248,
 /*  2320 */   279,  199,  212,  199,  105,  279,  123,  124,  123,  124,
 /*  2330 */   153,  199,  113,  114,  212,  319,  212,  118,  184,  120,
 /*  2340 */   188,  136,  123,  124,  212,  233,  223,    4,  129,  123,
 /*  2350 */   124,  182,  223,  221,  222,  136,  137,  138,  139,   16,
 /*  2360 */   123,  124,  230,  141,   80,   81,   82,   39,  223,   85,
 /*  2370 */    86,   87,   88,   89,   90,   91,   92,  199,   94,   95,
 /*  2380 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  170,
 /*  2390 */   212,  225,  173,  199,  175,  176,  170,  203,   55,  221,
 /*  2400 */   222,  123,  124,  199,  140,  199,  212,  170,  230,  199,
 /*  2410 */   199,  279,  199,  199,  223,  233,  212,  267,  212,   76,
 /*  2420 */   223,  226,  212,  212,   81,  212,  212,  221,  222,  116,
 /*  2430 */   223,  199,  223,  199,  221,  222,  230,  199,  199,  223,
 /*  2440 */   116,   98,   99,  230,  212,  199,  212,  226,  105,  171,
 /*  2450 */   212,  212,  202,    4,  226,  202,  113,  279,  212,  221,
 /*  2460 */   222,  118,  199,  120,  116,   16,  123,  124,  230,  267,
 /*  2470 */   199,  199,  129,  199,  199,  212,  199,   33,  199,  136,
 /*  2480 */   137,  138,  139,  212,  212,  279,  212,  212,  199,  212,
 /*  2490 */   294,  212,  279,  221,  222,  295,  177,  116,  221,  222,
 /*  2500 */   252,  212,  230,   79,   55,  240,  116,  230,  252,  116,
 /*  2510 */   275,  113,  141,  170,  278,  116,  173,  279,  175,  176,
 /*  2520 */   252,  240,  202,  202,  267,   76,  267,  116,  252,  242,
 /*  2530 */    81,  116,   77,  242,  116,  242,  116,  242,  116,  171,
 /*  2540 */   289,  116,  298,   20,   17,  298,  116,   98,   99,  267,
 /*  2550 */   267,  279,  267,  199,  105,  116,  279,  116,  199,  249,
 /*  2560 */   300,  291,  113,  251,  291,  224,  212,  118,  266,  120,
 /*  2570 */   284,  212,  123,  124,  268,  221,  222,  255,  129,  224,
 /*  2580 */   221,  222,  255,  231,  230,  136,  137,  138,  139,  230,
 /*  2590 */   225,  235,  252,  268,  268,   81,   82,  251,  197,   85,
 /*  2600 */    86,   87,   88,   89,   90,   91,   92,  249,   94,   95,
 /*  2610 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  170,
 /*  2620 */   214,  214,  173,  214,  175,  176,  214,  199,  292,  247,
 /*  2630 */   293,  281,  241,  279,  199,  317,  232,  265,  279,  304,
 /*  2640 */   212,  199,  232,   72,  221,  232,    4,  212,  221,  221,
 /*  2650 */   222,  320,  236,  199,  212,  320,  221,  222,  230,  320,
 /*  2660 */   199,  320,  320,  221,  222,  230,  212,  199,  320,  320,
 /*  2670 */   320,  320,  230,  212,  320,  221,  222,  320,  320,  199,
 /*  2680 */   212,  199,  221,  222,  230,  320,  320,  320,  320,  221,
 /*  2690 */   222,  230,  212,  199,  212,  320,  320,  320,  230,  320,
 /*  2700 */   320,  221,  222,  221,  222,  320,  212,  279,  320,  320,
 /*  2710 */   230,  320,  230,  320,  279,  221,  222,  320,  320,  199,
 /*  2720 */   320,  279,  320,  320,  230,  320,  320,  320,  320,  320,
 /*  2730 */   320,  320,  212,  279,  320,  320,  320,  320,  320,  320,
 /*  2740 */   279,  221,  222,  320,  320,  320,  320,  279,  320,  320,
 /*  2750 */   230,  320,  320,  199,  320,  320,  199,  320,  199,  279,
 /*  2760 */   320,  279,  320,  320,  320,  320,  212,  320,  320,  212,
 /*  2770 */   320,  212,  199,  279,  320,  221,  222,  320,  221,  222,
 /*  2780 */   221,  222,  320,  320,  230,  212,  320,  230,  199,  230,
 /*  2790 */   320,  320,  320,  320,  221,  222,  320,  320,  320,  279,
 /*  2800 */   199,  212,  320,  230,  199,  320,  320,  320,  320,  320,
 /*  2810 */   221,  222,  320,  212,  320,  320,  320,  212,  320,  230,
 /*  2820 */   320,  320,  221,  222,  199,  320,  221,  222,  320,  320,
 /*  2830 */   320,  230,  320,  279,  320,  230,  279,  212,  279,  320,
 /*  2840 */   199,  320,  320,  320,  320,  320,  221,  222,  320,  320,
 /*  2850 */   320,  320,  279,  212,  199,  230,  199,  320,  320,  320,
 /*  2860 */   199,  320,  221,  222,  320,  320,  320,  212,  279,  212,
 /*  2870 */   320,  230,  320,  212,  320,  199,  221,  222,  221,  222,
 /*  2880 */   279,  320,  221,  222,  279,  230,  320,  230,  212,  320,
 /*  2890 */   199,  230,  199,  320,  199,  320,  320,  221,  222,  320,
 /*  2900 */   320,  320,  320,  212,  279,  212,  230,  212,  320,  320,
 /*  2910 */   320,  320,  221,  222,  221,  222,  221,  222,  320,  199,
 /*  2920 */   279,  230,  320,  230,  320,  230,  320,  320,  320,  320,
 /*  2930 */   320,  320,  212,  320,  279,  320,  279,  320,  320,  320,
 /*  2940 */   279,  221,  222,  320,  320,  320,  320,  320,  320,  320,
 /*  2950 */   230,  320,  320,  199,  320,  279,  199,  320,  320,  320,
 /*  2960 */   320,  320,  320,  320,  320,  320,  212,  320,  320,  212,
 /*  2970 */   279,  320,  279,  320,  279,  221,  222,  320,  221,  222,
 /*  2980 */   320,  320,  320,  320,  230,  320,  320,  230,  320,  320,
 /*  2990 */   320,  320,  320,  320,  320,  320,  320,  320,  320,  279,
 /*  3000 */   320,  320,  320,  320,  320,  320,  320,  320,  320,  320,
 /*  3010 */   320,  320,  320,  320,  320,  320,  320,  320,  320,  320,
 /*  3020 */   320,  320,  320,  320,  320,  320,  320,  320,  320,  320,
 /*  3030 */   320,  320,  320,  279,  320,  320,  279,
};
#define YY_SHIFT_USE_DFLT (-101)
#define YY_SHIFT_COUNT (513)
#define YY_SHIFT_MIN   (-100)
#define YY_SHIFT_MAX   (2642)
static const short yy_shift_ofst[] = {
 /*     0 */  1352,  828, 1151, 1708, 1045, 1777, 1671, 2219, 2219, 2219,
 /*    10 */  1753,  244, 2113, 2343, 2343, 2343, 2343, 2343, 2343, 2449,
 /*    20 */  2343,  742,   -4,  120, 2007, 1901, 2343, 2343, 2343, 2343,
 /*    30 */  2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343,
 /*    40 */  2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343,
 /*    50 */  2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343,
 /*    60 */  2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343,  779,
 /*    70 */  1062, 1062,   -1,  518,  518, 1744,   66,   15, 1016, 1744,
 /*    80 */  2226, 2226, 2226, 2189, 2226,  748,  748, 2203,  400,  365,
 /*    90 */   151,   69, 1763, 1130, 1852, 1845, 1293,  682, 1187,  682,
 /*   100 */  1183, 1006,  436,  967, 2278, 2237, 2237, 2237, 2237,  285,
 /*   110 */  2237, 2226, 2203, 2203,  400, 1685, 1685, 1454,  530,  530,
 /*   120 */   956,  845,  191,  223,  306, 1626, 1158,  945,  439,  642,
 /*   130 */   314, 1236,  795, 1236,   88,  797,  343,  466,   85, 2184,
 /*   140 */  2174, 2169, 2154, 2000, 1662, 2205, 2104, 2180, 1447, 2149,
 /*   150 */  2080, 1986, 1967, 1417, 2025, 1955, 1931, 1194, 1857, 1831,
 /*   160 */   368, 1825, 1740, 1701, 1701, 1701, 1289,  811, 1070,  437,
 /*   170 */   437,  799,  684,  674,  551,  516,   84, 1655, 1633, 1508,
 /*   180 */  1162, 2203, 1166, 1166, 1207, 1069,  497, 2571, 2571, 2642,
 /*   190 */  2571, 2571, -101, -101,  447,  739,  690,  653,  -72,  610,
 /*   200 */   610,  610,  610,  610,  610,  776,  415,  927,  569, 1582,
 /*   210 */  1554, 1523, 1495, 1465, 1435, 1405, 1375, 1345, 1303, 1276,
 /*   220 */  1250, 1007, 1842, 1612, 2284, 2514, 2514,  -37,  626,  626,
 /*   230 */   626,  626,  -59,  202,  115,  348,  348,  -17,  566,  486,
 /*   240 */   208,  208,  208,  170, 1093,  358,  116,   97,  752,  363,
 /*   250 */  1110, 1079,  877,  196,  603,  974,  154,  487,  735,  735,
 /*   260 */    76, 1706,  595,  581,  735,  836,  598,  598,  855,  581,
 /*   270 */   345,  345,  375,  253,  134, 2527, 2441, 2439, 2430, 2523,
 /*   280 */  2523, 2425, 2368, 2422, 2455, 2420, 2455, 2418, 2455, 2415,
 /*   290 */  2455, 2411, 2089, 2048, 2399, 2089, 2424, 2048, 2371, 2398,
 /*   300 */  2393, 2048, 2390, 2424, 2048, 2381, 2319, 2444, 2348, 2089,
 /*   310 */  2324, 2133, 2089, 2313, 2133, 2222, 2222, 2222, 2222, 2328,
 /*   320 */  2133, 2222, 2264, 2222, 2328, 2222, 2222, 2152, 2177, 2183,
 /*   330 */  2269, 2269, 2242, 2242, 2061, 2114, 2088, 2151, 2133, 2162,
 /*   340 */  2130, 2061, 2053, 2056, 2048, 2054, 2083, 2117, 2060, 2089,
 /*   350 */  2074, 2074, 2028, 2028, 2028, 2028, -101, -101, -101, -101,
 /*   360 */  -101, -101, -101, -101, -101, -101, 1090,  -65,  238,   60,
 /*   370 */   194,  697,   79,  -38, 1690, 1644, 1066, 1614,   81, 1604,
 /*   380 */  1575, 1294, 1170, 1147,  183,  558,  -29, 1050, 1002,  129,
 /*   390 */   878,  848,  148,  138, 2045, 2032, 1979, 1957, 1961, 1956,
 /*   400 */  1948, 1953, 1902, 1949, 1946, 1909, 1878, 1992, 1912, 1982,
 /*   410 */  1970, 1987, 1904, 1903, 1854, 1836, 1855, 1969, 1968, 1794,
 /*   420 */  1874, 1870, 1869, 1838, 1774, 1759, 1891, 1770, 1795, 1783,
 /*   430 */  1827, 1745, 1755, 1764, 1805, 1756, 1752, 1736, 1729, 1789,
 /*   440 */  1828, 1718, 1668, 1822, 1642, 1725, 1741, 1618, 1584, 1624,
 /*   450 */  1608, 1581, 1551, 1533, 1427, 1474, 1475, 1464, 1445, 1427,
 /*   460 */  1443, 1412, 1402, 1336, 1374, 1366, 1297, 1324, 1430, 1400,
 /*   470 */  1195, 1297, 1355, 1346, 1248, 1216, 1165, 1163, 1177, 1109,
 /*   480 */  1095, 1074,  977, 1021,  926,  830,  816,  807,  873,  787,
 /*   490 */   707,  786,  522,  686,  649,  616,  522,  523,  448,  407,
 /*   500 */   344,  362,  308,  278,  272,  235,  184,  119,  105,  -81,
 /*   510 */    38,  -43,  -89, -100,
};
#define YY_REDUCE_USE_DFLT (-228)
#define YY_REDUCE_COUNT (365)
#define YY_REDUCE_MIN   (-227)
#define YY_REDUCE_MAX   (2757)
static const short yy_reduce_ofst[] = {
 /*     0 */   389, -131,   -8,  117, 1524,  366,  123,  958,  717,  118,
 /*    10 */   -66, 1806, 1767, 1823, 1773, 1762, 1600, 1030, 1593, 1576,
 /*    20 */  1013,  875, 2757, 2754, 2720, 2695, 2693, 2691, 2676, 2661,
 /*    30 */  2657, 2655, 2641, 2625, 2605, 2601, 2589, 2573, 2559, 2557,
 /*    40 */  2554, 2520, 2494, 2482, 2480, 2468, 2461, 2454, 2442, 2435,
 /*    50 */  2428, 2359, 2354, 2277, 2272, 2238, 2213, 2206, 2178, 2132,
 /*    60 */  2046, 2041, 2026, 1980, 1975, 1940, 1935, 1929, 1835,  172,
 /*    70 */   670,  386, -130,  866,  760, -101,  211, 1265, 1113,  216,
 /*    80 */  1882, 1814, 1531, 1027,  699,  858,  688, -166,  361, 1737,
 /*    90 */   765,  868, 2194, 2058, 1964, 1883, 1686, 1528, 1561,   55,
 /*   100 */  1521, 1064,  933,  394,  751, 1779, 1695, 1640,  996, -227,
 /*   110 */   122, 1539,  605, -119,  773,  606, -173,  321, 1638, 1563,
 /*   120 */   893,  525, 2289, 2279, 2239, 1888, 1888, 2275, 2274, 2271,
 /*   130 */  2263, 1211, 2246,  876, 1888, 1619, 1261, 2239, 2234, 2232,
 /*   140 */  1888, 1888, 1888, 1888, 1888, 1888, 1888, 2214, 1888, 1888,
 /*   150 */  1888, 1888, 2211, 1888, 1888, 1888, 2210, 2204, 2124, 2122,
 /*   160 */  2110, 2103, 2082, 1587, 1082, 1059, 2001, 1973, 1943, 1171,
 /*   170 */  1111, 1914, 1899, 1888, 1861, 1761, 1012, 1713, 1684, 1679,
 /*   180 */  1672, 1530, 1098, 1075, 1084, 1152,  824,  931,  710, 1103,
 /*   190 */   646,  189,  851,  -74, 1817, 1817, 1817, 1817, 1817, 1817,
 /*   200 */  1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
 /*   210 */  1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
 /*   220 */  1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
 /*   230 */  1817, 1817, 1817, 1817, 2416, 2427, 2423, 1817, 2335, 2335,
 /*   240 */  2413, 2410, 2404, 2372, 2318, 2391, 2382, 2350, 2337, 2336,
 /*   250 */  2412, 2409, 2407, 2406, 2358, 2401, 2340, 2346, 2326, 2325,
 /*   260 */  2365, 2356, 2352, 2355, 2306, 2302, 2327, 2322, 2286, 2341,
 /*   270 */  2273, 2270, 1817, 2312, 2310, 2260, 2150, 2285, 2283, 2247,
 /*   280 */  2244, 2282, 2251, 2150, 2295, 2150, 2293, 2150, 2291, 2150,
 /*   290 */  2287, 2259, 2321, 2276, 2257, 2320, 2281, 2268, 2236, 2235,
 /*   300 */  2150, 2256, 2150, 2265, 2248, 2150, 2200, 2196, 2202, 2253,
 /*   310 */  2150, 2228, 2250, 2150, 2221, 2216, 2209, 2207, 2197, 2182,
 /*   320 */  2195, 2191, 2166, 2145, 2112, 2129, 2123, 2016, 2071, 2047,
 /*   330 */  1997, 1977, 2013, 2009, 2019, 2011, 1981, 1972, 2018, 1989,
 /*   340 */  1817, 1983, 1978, 1971, 1963, 1952, 1928, 1985, 1966, 1984,
 /*   350 */  1954, 1933, 1962, 1942, 1939, 1934, 1813, 1811, 1812, 1880,
 /*   360 */  1872, 1840, 1817, 1817, 1817, 1885,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   849, 1158, 1158, 1277, 1158, 1158, 1158, 1158, 1158, 1158,
 /*    10 */  1277, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158,
 /*    20 */  1158, 1277, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158,
 /*    30 */  1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158,
 /*    40 */  1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158,
 /*    50 */  1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158,
 /*    60 */  1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 1029,
 /*    70 */  1316, 1316, 1316, 1293, 1293, 1316, 1022, 1316, 1316, 1316,
 /*    80 */  1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316,  896, 1018,
 /*    90 */   886, 1029, 1316, 1316, 1316, 1316, 1316, 1089, 1103, 1089,
 /*   100 */  1081, 1072, 1316, 1316, 1194, 1097, 1097, 1097, 1097,  969,
 /*   110 */  1097, 1316, 1316, 1316, 1316, 1129, 1128, 1316, 1057, 1057,
 /*   120 */  1160, 1316, 1247, 1252, 1316, 1316, 1316, 1316, 1316, 1316,
 /*   130 */  1090, 1316, 1316, 1316, 1030, 1018, 1293, 1316, 1316, 1316,
 /*   140 */  1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1104,
 /*   150 */  1082, 1073, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316,
 /*   160 */  1316, 1316, 1316, 1018, 1018, 1018, 1316, 1316, 1316, 1293,
 /*   170 */  1293, 1316, 1316, 1316, 1316, 1316,  883, 1316, 1316, 1316,
 /*   180 */   855, 1316, 1293, 1293,  849, 1277, 1051, 1277, 1277,  891,
 /*   190 */  1277, 1277, 1270, 1008, 1067, 1160, 1160, 1160, 1160, 1035,
 /*   200 */  1077, 1065, 1069, 1171, 1068, 1160, 1160, 1160, 1160, 1160,
 /*   210 */  1160, 1160, 1160, 1160, 1160, 1160, 1160, 1160, 1160, 1160,
 /*   220 */  1160, 1160, 1160, 1160, 1131, 1143, 1130, 1138, 1147, 1139,
 /*   230 */  1142, 1133, 1132, 1134, 1316, 1316, 1316, 1135, 1316, 1316,
 /*   240 */  1316, 1316, 1316, 1021, 1316, 1316,  991, 1316, 1316, 1221,
 /*   250 */  1316, 1316,  898, 1316, 1006,  858, 1076, 1019, 1047, 1047,
 /*   260 */   936,  960,  920, 1057, 1047, 1037, 1051, 1051, 1166, 1057,
 /*   270 */  1316, 1316, 1136, 1019, 1006, 1261, 1038, 1038, 1038, 1246,
 /*   280 */  1246, 1038, 1194, 1038,  982, 1038,  982, 1038,  982, 1038,
 /*   290 */   982, 1038,  880, 1076, 1038,  880,  973, 1076, 1109, 1093,
 /*   300 */  1038, 1076, 1038,  973, 1076, 1038, 1228, 1226, 1038,  880,
 /*   310 */  1038, 1179,  880, 1038, 1179,  971,  971,  971,  971,  952,
 /*   320 */  1179,  971,  936,  971,  952,  971,  971, 1312, 1316, 1038,
 /*   330 */  1303, 1303, 1060, 1060, 1066, 1051, 1316, 1185, 1179, 1160,
 /*   340 */  1137, 1066, 1064, 1061, 1076, 1316, 1038,  877,  955,  880,
 /*   350 */   866,  866,  854,  854,  854,  854, 1274, 1274, 1270,  938,
 /*   360 */   938, 1024, 1146, 1145, 1144,  907, 1159, 1316, 1316, 1316,
 /*   370 */  1316, 1316, 1316, 1195, 1316, 1316, 1316, 1316, 1316, 1316,
 /*   380 */  1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316,
 /*   390 */  1316, 1316, 1316, 1316, 1316,  850, 1316, 1316, 1316, 1316,
 /*   400 */  1316, 1264, 1316, 1316, 1316, 1316, 1316, 1316, 1225, 1224,
 /*   410 */  1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316,
 /*   420 */  1316, 1316, 1316, 1316, 1316, 1316, 1213, 1316, 1316, 1316,
 /*   430 */  1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316,
 /*   440 */  1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316,
 /*   450 */  1316, 1316, 1316, 1316,  994, 1000, 1316, 1316, 1316,  995,
 /*   460 */  1316, 1316, 1122, 1316, 1316, 1316, 1169, 1316, 1316, 1316,
 /*   470 */  1316, 1062, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316,
 /*   480 */  1316, 1316, 1316, 1316, 1316, 1316, 1309, 1052, 1316, 1316,
 /*   490 */  1159, 1316, 1279, 1316, 1316, 1316, 1278, 1316, 1316, 1316,
 /*   500 */  1316, 1316, 1316, 1316, 1316, 1316, 1316, 1123, 1122, 1161,
 /*   510 */   889, 1316,  864, 1316,  846,  851, 1263, 1260, 1262, 1257,
 /*   520 */  1258, 1256, 1259, 1255, 1253, 1254, 1251, 1249, 1248, 1250,
 /*   530 */  1245, 1241, 1201, 1199, 1197, 1206, 1205, 1204, 1203, 1202,
 /*   540 */  1198, 1196, 1200, 1192, 1191, 1100, 1079, 1070,  989, 1240,
 /*   550 */  1238, 1239, 1190, 1188, 1189,  988,  987,  986,  981,  980,
 /*   560 */   979,  978, 1267, 1276, 1275, 1273, 1272, 1271, 1265, 1266,
 /*   570 */  1177, 1176, 1174, 1173, 1175,  882, 1217, 1220, 1219, 1218,
 /*   580 */  1223, 1222, 1215, 1227, 1232, 1231, 1236, 1235, 1234, 1233,
 /*   590 */  1230, 1212, 1108, 1107, 1105, 1102, 1112, 1111, 1110, 1101,
 /*   600 */  1094, 1106, 1084, 1092, 1091, 1080, 1083,  974, 1075, 1071,
 /*   610 */  1074,  990, 1216,  985,  984,  983,  881,  876, 1040,  875,
 /*   620 */   874,  885,  958,  959,  967,  970,  965,  968,  964,  963,
 /*   630 */   962,  966,  961,  957,  888,  887,  897,  951,  934,  923,
 /*   640 */   890,  925,  922,  921,  926,  943,  942,  949,  948,  947,
 /*   650 */   946,  945,  941,  944,  940,  939,  927,  919,  918,  937,
 /*   660 */   917,  954,  953,  950,  916,  977,  976,  975,  972,  915,
 /*   670 */   914,  913,  912,  911,  910, 1157, 1315, 1311, 1314, 1313,
 /*   680 */  1310, 1156, 1162, 1150, 1148,  992, 1003, 1002, 1001,  998,
 /*   690 */   999, 1013, 1011, 1010, 1009, 1046, 1045, 1044, 1043, 1042,
 /*   700 */  1041, 1034, 1032, 1027, 1026, 1033, 1031, 1028, 1049, 1050,
 /*   710 */  1048, 1025, 1017, 1015, 1016, 1014, 1099, 1096, 1098, 1095,
 /*   720 */  1036, 1023, 1020, 1007, 1291, 1289, 1292, 1290, 1288, 1296,
 /*   730 */  1298, 1297, 1302, 1300, 1299, 1295, 1308, 1307, 1306, 1305,
 /*   740 */  1304, 1294, 1301, 1287, 1286, 1285, 1284, 1054, 1059, 1058,
 /*   750 */  1053,  997, 1161, 1149, 1159, 1153, 1282, 1280, 1283, 1182,
 /*   760 */  1184, 1187, 1186, 1183, 1056, 1055, 1181, 1180, 1281, 1152,
 /*   770 */  1127,  903,  901,  902, 1209, 1208, 1211, 1210, 1207,  905,
 /*   780 */   904,  900,  899, 1125, 1121, 1120, 1237, 1154, 1155, 1119,
 /*   790 */  1124, 1117, 1116, 1115, 1141, 1140, 1126, 1118,  892,  996,
 /*   800 */   993, 1151, 1114, 1039, 1113,  933,  932,  931,  930,  929,
 /*   810 */   928, 1005, 1004,  909,  924,  908,  906,  884,  879,  878,
 /*   820 */   873,  871,  868,  870,  867,  872,  869,  865,  863,  862,
 /*   830 */   861,  860,  859,  895,  894,  893,  889,  857,  856,  853,
 /*   840 */   852,  848,  847,  845,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*      SPACE => nothing */
    0,  /*         ID => nothing */
    4,  /*      ABORT => ID */
    4,  /*     ACTION => ID */
    4,  /*      AFTER => ID */
    4,  /*     ALWAYS => ID */
    4,  /*    ANALYZE => ID */
    4,  /*        ASC => ID */
    4,  /*     ATTACH => ID */
    4,  /*     BEFORE => ID */
    4,  /*      BEGIN => ID */
    4,  /*         BY => ID */
    4,  /*    CASCADE => ID */
    4,  /*       CAST => ID */
    4,  /*   COLUMNKW => ID */
    4,  /*   CONFLICT => ID */
    4,  /*    CURRENT => ID */
    4,  /*   DATABASE => ID */
    4,  /*   DEFERRED => ID */
    4,  /*       DESC => ID */
    4,  /*     DETACH => ID */
    4,  /*         DO => ID */
    4,  /*       EACH => ID */
    4,  /*        END => ID */
    4,  /*    EXCLUDE => ID */
    4,  /*  EXCLUSIVE => ID */
    4,  /*    EXPLAIN => ID */
    4,  /*       FAIL => ID */
    4,  /*      FIRST => ID */
    4,  /*  FOLLOWING => ID */
    4,  /*        FOR => ID */
    4,  /*  GENERATED => ID */
    4,  /*     GROUPS => ID */
    4,  /*     IGNORE => ID */
    4,  /*  IMMEDIATE => ID */
    4,  /*    INDEXED => ID */
    4,  /*  INITIALLY => ID */
    4,  /*    INSTEAD => ID */
    4,  /*       LAST => ID */
    4,  /*    LIKE_KW => ID */
    4,  /*      MATCH => ID */
    4,  /*         NO => ID */
    4,  /*      NULLS => ID */
    4,  /*     OTHERS => ID */
    4,  /*       PLAN => ID */
    4,  /*      QUERY => ID */
    4,  /*        KEY => ID */
    4,  /*         OF => ID */
    4,  /*     OFFSET => ID */
    4,  /*  PARTITION => ID */
    4,  /*     PRAGMA => ID */
    4,  /*  PRECEDING => ID */
    4,  /*      RAISE => ID */
    4,  /*      RANGE => ID */
    4,  /*  RECURSIVE => ID */
    4,  /*    RELEASE => ID */
    4,  /*    REPLACE => ID */
    4,  /*   RESTRICT => ID */
    4,  /*        ROW => ID */
    4,  /*       ROWS => ID */
    4,  /*   ROLLBACK => ID */
    4,  /*  SAVEPOINT => ID */
    4,  /*       TEMP => ID */
    4,  /*       TIES => ID */
    4,  /*    TRIGGER => ID */
    4,  /*  UNBOUNDED => ID */
    4,  /*     VACUUM => ID */
    4,  /*       VIEW => ID */
    4,  /*    VIRTUAL => ID */
    4,  /*       WITH => ID */
    4,  /*    WITHOUT => ID */
    4,  /*    REINDEX => ID */
    4,  /*     RENAME => ID */
    4,  /*   CTIME_KW => ID */
    4,  /*         IF => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
  QList<Token*>* tokens = nullptr;
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3_parseARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

void *sqlite3_parseCopyParserState(void* other)
{
  yyParser *pParser;
  yyParser *otherParser = (yyParser*)other;

  // Copy parser
  pParser = (yyParser*)malloc((size_t)sizeof(yyParser));
  memcpy(pParser, other, (size_t)sizeof(yyParser));

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = malloc((size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)other)->yystack, (size_t)stackSize);
#endif

  for (int i = 0; i <= pParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(otherParser->yystack[i].tokens);
  }

  return pParser;
}

void sqlite3_parseAddToken(void* other, Token* token)
{
    yyParser *otherParser = (yyParser*)other;
    if (otherParser->yyidx < 0)
        return; // Nothing on stack yet. Might happen when parsing just whitespaces, nothing else.

    otherParser->yystack[otherParser->yyidx].tokens->append(token);
}

void sqlite3_parseRestoreParserState(void* saved, void* target)
{
  yyParser *pParser = (yyParser*)target;
  yyParser *savedParser = (yyParser*)saved;

  for (int i = 0; i <= pParser->yyidx; i++)
      delete pParser->yystack[i].tokens;

  memcpy(pParser, saved, (size_t)sizeof(yyParser));

  for (int i = 0; i <= savedParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(savedParser->yystack[i].tokens);
  }

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = relloc(pParser->yystack, (size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)saved)->yystack, (size_t)stackSize);
#endif
}

void sqlite3_parseFreeSavedState(void* other)
{
    yyParser *pParser = (yyParser*)other;
    for (int i = 0; i <= pParser->yyidx; i++)
        delete pParser->yystack[i].tokens;

#if YYSTACKDEPTH<=0
    free(pParser->yystack);
#endif
    free(other);
}

#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  "$",             "ILLEGAL",       "COMMENT",       "SPACE",       
  "ID",            "ABORT",         "ACTION",        "AFTER",       
  "ALWAYS",        "ANALYZE",       "ASC",           "ATTACH",      
  "BEFORE",        "BEGIN",         "BY",            "CASCADE",     
  "CAST",          "COLUMNKW",      "CONFLICT",      "CURRENT",     
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "DO",            "EACH",          "END",           "EXCLUDE",     
  "EXCLUSIVE",     "EXPLAIN",       "FAIL",          "FIRST",       
  "FOLLOWING",     "FOR",           "GENERATED",     "GROUPS",      
  "IGNORE",        "IMMEDIATE",     "INDEXED",       "INITIALLY",   
  "INSTEAD",       "LAST",          "LIKE_KW",       "MATCH",       
  "NO",            "NULLS",         "OTHERS",        "PLAN",        
  "QUERY",         "KEY",           "OF",            "OFFSET",      
  "PARTITION",     "PRAGMA",        "PRECEDING",     "RAISE",       
  "RANGE",         "RECURSIVE",     "RELEASE",       "REPLACE",     
  "RESTRICT",      "ROW",           "ROWS",          "ROLLBACK",    
  "SAVEPOINT",     "TEMP",          "TIES",          "TRIGGER",     
  "UNBOUNDED",     "VACUUM",        "VIEW",          "VIRTUAL",     
  "WITH",          "WITHOUT",       "REINDEX",       "RENAME",      
  "CTIME_KW",      "IF",            "ANY",           "OR",          
  "AND",           "NOT",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "BITNOT",        "SEMI",          "TRANSACTION", 
  "ID_TRANS",      "COMMIT",        "TO",            "CREATE",      
  "TABLE",         "LP",            "RP",            "AS",          
  "DOT",           "ID_TAB_NEW",    "ID_DB",         "CTX_ROWID_KW",
  "EXISTS",        "COMMA",         "ID_COL_NEW",    "STRING",      
  "JOIN_KW",       "ID_COL_TYPE",   "RIGHT_ASSOC",   "CONSTRAINT",  
  "DEFAULT",       "NULL",          "PRIMARY",       "UNIQUE",      
  "CHECK",         "REFERENCES",    "ID_CONSTR",     "ID_COLLATE",  
  "ID_TAB",        "INTEGER",       "FLOAT",         "BLOB",        
  "AUTOINCR",      "ON",            "INSERT",        "DELETE",      
  "UPDATE",        "ID_FK_MATCH",   "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "ID_VIEW_NEW",   "ID_VIEW",     
  "SELECT",        "VALUES",        "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "DISTINCT",      "ID_ALIAS",    
  "FROM",          "USING",         "JOIN",          "ID_JOIN_OPTS",
  "ID_IDX",        "ORDER",         "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "ID_COL",        "INTO",        
  "NOTHING",       "ID_FN",         "ID_ERR_MSG",    "VARIABLE",    
  "CASE",          "WHEN",          "THEN",          "ELSE",        
  "INDEX",         "ID_IDX_NEW",    "ID_PRAGMA",     "ID_TRIG_NEW", 
  "ID_TRIG",       "ALTER",         "ADD",           "WINDOW",      
  "OVER",          "FILTER",        "error",         "cmd",         
  "input",         "cmdlist",       "ecmd",          "explain",     
  "cmdx",          "transtype",     "trans_opt",     "nm",          
  "savepoint_opt",  "temp",          "ifnotexists",   "fullname",    
  "columnlist",    "conslist_opt",  "table_options",  "select",      
  "column",        "columnid",      "type",          "carglist",    
  "id",            "id_opt",        "ids",           "typetoken",   
  "typename",      "signed",        "plus_num",      "minus_num",   
  "ccons",         "term",          "expr",          "onconf",      
  "sortorder",     "autoinc",       "idxlist_opt",   "refargs",     
  "defer_subclause",  "gen_always",    "tnm",           "refarg",      
  "refact",        "init_deferred_pred_opt",  "conslist",      "tconscomma",  
  "tcons",         "idxlist",       "defer_subclause_opt",  "resolvetype", 
  "orconf",        "raisetype",     "ifexists",      "select_stmt", 
  "with",          "selectnowith",  "oneselect",     "multiselect_op",
  "values",        "distinct",      "selcollist",    "from",        
  "where_opt",     "groupby_opt",   "having_opt",    "orderby_opt", 
  "limit_opt",     "window_clause",  "nexprlist",     "exprlist",    
  "sclp",          "as",            "joinsrc",       "singlesrc",   
  "seltablist",    "joinop",        "joinconstr_opt",  "dbnm",        
  "indexed_opt",   "idlist",        "sortlist",      "nulls",       
  "delete_stmt",   "update_stmt",   "setlist",       "idlist_opt",  
  "insert_stmt",   "insert_cmd",    "upsert",        "exprx",       
  "not_opt",       "likeop",        "case_operand",  "case_exprlist",
  "case_else",     "filter_over",   "uniqueflag",    "idxlist_single",
  "collate",       "vinto",         "nmnum",         "number",      
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd_list",  "trigger_cmd",   "database_kw_opt",  "key_opt",     
  "kwcolumn_opt",  "create_vtab",   "vtabarglist",   "vtabarg",     
  "vtabargtoken",  "anylist",       "wqlist",        "wqcte",       
  "windowdefn_list",  "windowdefn",    "window",        "frame_opt",   
  "range_or_rows",  "frame_bound_s",  "frame_exclude_opt",  "frame_bound_e",
  "frame_bound",   "frame_exclude",  "filter_clause",  "over_clause", 
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   8 */ "cmdx ::= cmd",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "trans_opt ::= TRANSACTION ID_TRANS",
 /*  14 */ "transtype ::=",
 /*  15 */ "transtype ::= DEFERRED",
 /*  16 */ "transtype ::= IMMEDIATE",
 /*  17 */ "transtype ::= EXCLUSIVE",
 /*  18 */ "cmd ::= COMMIT trans_opt",
 /*  19 */ "cmd ::= END trans_opt",
 /*  20 */ "cmd ::= ROLLBACK trans_opt",
 /*  21 */ "savepoint_opt ::= SAVEPOINT",
 /*  22 */ "savepoint_opt ::=",
 /*  23 */ "cmd ::= SAVEPOINT nm",
 /*  24 */ "cmd ::= RELEASE savepoint_opt nm",
 /*  25 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt nm",
 /*  26 */ "cmd ::= SAVEPOINT ID_TRANS",
 /*  27 */ "cmd ::= RELEASE savepoint_opt ID_TRANS",
 /*  28 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS",
 /*  29 */ "cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options",
 /*  30 */ "cmd ::= CREATE temp TABLE ifnotexists fullname AS select",
 /*  31 */ "cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW",
 /*  32 */ "cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /*  33 */ "table_options ::=",
 /*  34 */ "table_options ::= WITHOUT nm",
 /*  35 */ "table_options ::= WITHOUT CTX_ROWID_KW",
 /*  36 */ "ifnotexists ::=",
 /*  37 */ "ifnotexists ::= IF NOT EXISTS",
 /*  38 */ "temp ::= TEMP",
 /*  39 */ "temp ::=",
 /*  40 */ "columnlist ::= columnlist COMMA column",
 /*  41 */ "columnlist ::= column",
 /*  42 */ "column ::= columnid type carglist",
 /*  43 */ "columnid ::= nm",
 /*  44 */ "columnid ::= ID_COL_NEW",
 /*  45 */ "id ::= ID",
 /*  46 */ "id_opt ::= id",
 /*  47 */ "id_opt ::=",
 /*  48 */ "ids ::= ID|STRING",
 /*  49 */ "nm ::= id",
 /*  50 */ "nm ::= STRING",
 /*  51 */ "nm ::= JOIN_KW",
 /*  52 */ "type ::=",
 /*  53 */ "type ::= typetoken",
 /*  54 */ "typetoken ::= typename",
 /*  55 */ "typetoken ::= typename LP signed RP",
 /*  56 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  57 */ "typename ::= ids",
 /*  58 */ "typename ::= typename ids",
 /*  59 */ "typename ::= ID_COL_TYPE",
 /*  60 */ "signed ::= plus_num",
 /*  61 */ "signed ::= minus_num",
 /*  62 */ "carglist ::= carglist ccons",
 /*  63 */ "carglist ::=",
 /*  64 */ "ccons ::= CONSTRAINT nm",
 /*  65 */ "ccons ::= DEFAULT term",
 /*  66 */ "ccons ::= DEFAULT LP expr RP",
 /*  67 */ "ccons ::= DEFAULT PLUS term",
 /*  68 */ "ccons ::= DEFAULT MINUS term",
 /*  69 */ "ccons ::= DEFAULT id",
 /*  70 */ "ccons ::= DEFAULT CTIME_KW",
 /*  71 */ "ccons ::= NULL onconf",
 /*  72 */ "ccons ::= NOT NULL onconf",
 /*  73 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  74 */ "ccons ::= UNIQUE onconf",
 /*  75 */ "ccons ::= CHECK LP expr RP",
 /*  76 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  77 */ "ccons ::= defer_subclause",
 /*  78 */ "ccons ::= COLLATE ids",
 /*  79 */ "ccons ::= gen_always AS LP expr RP id_opt",
 /*  80 */ "ccons ::= CONSTRAINT ID_CONSTR",
 /*  81 */ "ccons ::= COLLATE ID_COLLATE",
 /*  82 */ "ccons ::= REFERENCES ID_TAB",
 /*  83 */ "ccons ::= CHECK LP RP",
 /*  84 */ "term ::= NULL",
 /*  85 */ "term ::= INTEGER",
 /*  86 */ "term ::= FLOAT",
 /*  87 */ "term ::= STRING|BLOB",
 /*  88 */ "tnm ::= term",
 /*  89 */ "tnm ::= nm",
 /*  90 */ "gen_always ::= GENERATED ALWAYS",
 /*  91 */ "gen_always ::=",
 /*  92 */ "autoinc ::=",
 /*  93 */ "autoinc ::= AUTOINCR",
 /*  94 */ "refargs ::=",
 /*  95 */ "refargs ::= refargs refarg",
 /*  96 */ "refarg ::= MATCH nm",
 /*  97 */ "refarg ::= ON INSERT refact",
 /*  98 */ "refarg ::= ON DELETE refact",
 /*  99 */ "refarg ::= ON UPDATE refact",
 /* 100 */ "refarg ::= MATCH ID_FK_MATCH",
 /* 101 */ "refact ::= SET NULL",
 /* 102 */ "refact ::= SET DEFAULT",
 /* 103 */ "refact ::= CASCADE",
 /* 104 */ "refact ::= RESTRICT",
 /* 105 */ "refact ::= NO ACTION",
 /* 106 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /* 107 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /* 108 */ "init_deferred_pred_opt ::=",
 /* 109 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /* 110 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /* 111 */ "conslist_opt ::=",
 /* 112 */ "conslist_opt ::= COMMA conslist",
 /* 113 */ "conslist ::= conslist tconscomma tcons",
 /* 114 */ "conslist ::= tcons",
 /* 115 */ "tconscomma ::= COMMA",
 /* 116 */ "tconscomma ::=",
 /* 117 */ "tcons ::= CONSTRAINT nm",
 /* 118 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /* 119 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /* 120 */ "tcons ::= CHECK LP expr RP onconf",
 /* 121 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /* 122 */ "tcons ::= CONSTRAINT ID_CONSTR",
 /* 123 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB",
 /* 124 */ "tcons ::= CHECK LP RP onconf",
 /* 125 */ "defer_subclause_opt ::=",
 /* 126 */ "defer_subclause_opt ::= defer_subclause",
 /* 127 */ "onconf ::=",
 /* 128 */ "onconf ::= ON CONFLICT resolvetype",
 /* 129 */ "orconf ::=",
 /* 130 */ "orconf ::= OR resolvetype",
 /* 131 */ "resolvetype ::= raisetype",
 /* 132 */ "resolvetype ::= IGNORE",
 /* 133 */ "resolvetype ::= REPLACE",
 /* 134 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 135 */ "cmd ::= DROP TABLE ifexists nm DOT ID_TAB",
 /* 136 */ "cmd ::= DROP TABLE ifexists ID_DB|ID_TAB",
 /* 137 */ "ifexists ::= IF EXISTS",
 /* 138 */ "ifexists ::=",
 /* 139 */ "cmd ::= CREATE temp VIEW ifnotexists fullname idxlist_opt AS select",
 /* 140 */ "cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW",
 /* 141 */ "cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW",
 /* 142 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 143 */ "cmd ::= DROP VIEW ifexists nm DOT ID_VIEW",
 /* 144 */ "cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW",
 /* 145 */ "cmd ::= select_stmt",
 /* 146 */ "select_stmt ::= select",
 /* 147 */ "select ::= with selectnowith",
 /* 148 */ "selectnowith ::= oneselect",
 /* 149 */ "selectnowith ::= selectnowith multiselect_op oneselect",
 /* 150 */ "selectnowith ::= values",
 /* 151 */ "selectnowith ::= selectnowith COMMA values",
 /* 152 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 153 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt window_clause orderby_opt limit_opt",
 /* 154 */ "values ::= VALUES LP nexprlist RP",
 /* 155 */ "values ::= values COMMA LP exprlist RP",
 /* 156 */ "multiselect_op ::= UNION",
 /* 157 */ "multiselect_op ::= UNION ALL",
 /* 158 */ "multiselect_op ::= EXCEPT",
 /* 159 */ "multiselect_op ::= INTERSECT",
 /* 160 */ "distinct ::= DISTINCT",
 /* 161 */ "distinct ::= ALL",
 /* 162 */ "distinct ::=",
 /* 163 */ "sclp ::= selcollist COMMA",
 /* 164 */ "sclp ::=",
 /* 165 */ "selcollist ::= sclp expr as",
 /* 166 */ "selcollist ::= sclp STAR",
 /* 167 */ "selcollist ::= sclp tnm DOT STAR",
 /* 168 */ "selcollist ::= sclp",
 /* 169 */ "selcollist ::= sclp ID_TAB DOT STAR",
 /* 170 */ "as ::= AS nm",
 /* 171 */ "as ::= ids",
 /* 172 */ "as ::= AS ID_ALIAS",
 /* 173 */ "as ::= ID_ALIAS",
 /* 174 */ "as ::=",
 /* 175 */ "from ::=",
 /* 176 */ "from ::= FROM joinsrc",
 /* 177 */ "joinsrc ::= singlesrc seltablist",
 /* 178 */ "joinsrc ::=",
 /* 179 */ "seltablist ::= seltablist joinop singlesrc joinconstr_opt",
 /* 180 */ "seltablist ::=",
 /* 181 */ "singlesrc ::= nm dbnm as indexed_opt",
 /* 182 */ "singlesrc ::= LP select RP as",
 /* 183 */ "singlesrc ::= LP joinsrc RP as",
 /* 184 */ "singlesrc ::= nm dbnm LP exprlist RP as",
 /* 185 */ "singlesrc ::=",
 /* 186 */ "singlesrc ::= nm DOT",
 /* 187 */ "singlesrc ::= nm DOT ID_TAB",
 /* 188 */ "singlesrc ::= ID_DB|ID_TAB",
 /* 189 */ "singlesrc ::= nm DOT ID_VIEW",
 /* 190 */ "singlesrc ::= ID_DB|ID_VIEW",
 /* 191 */ "joinconstr_opt ::= ON expr",
 /* 192 */ "joinconstr_opt ::= USING LP idlist RP",
 /* 193 */ "joinconstr_opt ::=",
 /* 194 */ "dbnm ::=",
 /* 195 */ "dbnm ::= DOT nm",
 /* 196 */ "fullname ::= nm dbnm",
 /* 197 */ "joinop ::= COMMA",
 /* 198 */ "joinop ::= JOIN",
 /* 199 */ "joinop ::= JOIN_KW JOIN",
 /* 200 */ "joinop ::= JOIN_KW nm JOIN",
 /* 201 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 202 */ "joinop ::= ID_JOIN_OPTS",
 /* 203 */ "indexed_opt ::=",
 /* 204 */ "indexed_opt ::= INDEXED BY nm",
 /* 205 */ "indexed_opt ::= NOT INDEXED",
 /* 206 */ "indexed_opt ::= INDEXED BY ID_IDX",
 /* 207 */ "orderby_opt ::=",
 /* 208 */ "orderby_opt ::= ORDER BY sortlist",
 /* 209 */ "sortlist ::= sortlist COMMA expr sortorder nulls",
 /* 210 */ "sortlist ::= expr sortorder nulls",
 /* 211 */ "sortorder ::= ASC",
 /* 212 */ "sortorder ::= DESC",
 /* 213 */ "sortorder ::=",
 /* 214 */ "nulls ::= NULLS FIRST",
 /* 215 */ "nulls ::= NULLS LAST",
 /* 216 */ "nulls ::=",
 /* 217 */ "groupby_opt ::=",
 /* 218 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 219 */ "groupby_opt ::= GROUP BY",
 /* 220 */ "having_opt ::=",
 /* 221 */ "having_opt ::= HAVING expr",
 /* 222 */ "limit_opt ::=",
 /* 223 */ "limit_opt ::= LIMIT expr",
 /* 224 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 225 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 226 */ "cmd ::= delete_stmt",
 /* 227 */ "delete_stmt ::= with DELETE FROM fullname indexed_opt where_opt",
 /* 228 */ "delete_stmt ::= with DELETE FROM",
 /* 229 */ "delete_stmt ::= with DELETE FROM nm DOT",
 /* 230 */ "delete_stmt ::= with DELETE FROM nm DOT ID_TAB",
 /* 231 */ "delete_stmt ::= with DELETE FROM ID_DB|ID_TAB",
 /* 232 */ "where_opt ::=",
 /* 233 */ "where_opt ::= WHERE expr",
 /* 234 */ "where_opt ::= WHERE",
 /* 235 */ "cmd ::= update_stmt",
 /* 236 */ "update_stmt ::= with UPDATE orconf fullname indexed_opt SET setlist from where_opt",
 /* 237 */ "update_stmt ::= with UPDATE orconf",
 /* 238 */ "update_stmt ::= with UPDATE orconf nm DOT",
 /* 239 */ "update_stmt ::= with UPDATE orconf nm DOT ID_TAB",
 /* 240 */ "update_stmt ::= with UPDATE orconf ID_DB|ID_TAB",
 /* 241 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 242 */ "setlist ::= setlist COMMA LP idlist RP EQ expr",
 /* 243 */ "setlist ::= nm EQ expr",
 /* 244 */ "setlist ::= LP idlist RP EQ expr",
 /* 245 */ "setlist ::=",
 /* 246 */ "setlist ::= setlist COMMA",
 /* 247 */ "setlist ::= setlist COMMA ID_COL",
 /* 248 */ "setlist ::= ID_COL",
 /* 249 */ "idlist_opt ::=",
 /* 250 */ "idlist_opt ::= LP idlist RP",
 /* 251 */ "idlist ::= idlist COMMA nm",
 /* 252 */ "idlist ::= nm",
 /* 253 */ "idlist ::=",
 /* 254 */ "idlist ::= idlist COMMA ID_COL",
 /* 255 */ "idlist ::= ID_COL",
 /* 256 */ "cmd ::= insert_stmt",
 /* 257 */ "insert_stmt ::= with insert_cmd INTO fullname idlist_opt select upsert",
 /* 258 */ "insert_stmt ::= with insert_cmd INTO fullname idlist_opt DEFAULT VALUES",
 /* 259 */ "insert_stmt ::= with insert_cmd INTO",
 /* 260 */ "insert_stmt ::= with insert_cmd INTO nm DOT",
 /* 261 */ "insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB",
 /* 262 */ "insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB",
 /* 263 */ "insert_cmd ::= INSERT orconf",
 /* 264 */ "insert_cmd ::= REPLACE",
 /* 265 */ "upsert ::=",
 /* 266 */ "upsert ::= ON CONFLICT LP sortlist RP where_opt DO UPDATE SET setlist where_opt",
 /* 267 */ "upsert ::= ON CONFLICT LP sortlist RP where_opt DO NOTHING",
 /* 268 */ "upsert ::= ON CONFLICT DO NOTHING",
 /* 269 */ "exprx ::= expr not_opt IN ID_DB",
 /* 270 */ "exprx ::= expr not_opt IN nm DOT ID_TAB",
 /* 271 */ "exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN",
 /* 272 */ "exprx ::= tnm DOT ID_TAB|ID_COL",
 /* 273 */ "exprx ::= tnm DOT nm DOT ID_COL",
 /* 274 */ "exprx ::= expr COLLATE ID_COLLATE",
 /* 275 */ "exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP",
 /* 276 */ "exprx ::= CTIME_KW",
 /* 277 */ "exprx ::= LP nexprlist RP",
 /* 278 */ "exprx ::= tnm",
 /* 279 */ "exprx ::= tnm DOT nm",
 /* 280 */ "exprx ::= tnm DOT nm DOT nm",
 /* 281 */ "exprx ::= VARIABLE",
 /* 282 */ "exprx ::= expr COLLATE ids",
 /* 283 */ "exprx ::= CAST LP expr AS typetoken RP",
 /* 284 */ "exprx ::= ID LP distinct exprlist RP",
 /* 285 */ "exprx ::= ID LP STAR RP",
 /* 286 */ "exprx ::= expr AND expr",
 /* 287 */ "exprx ::= expr OR expr",
 /* 288 */ "exprx ::= expr LT|GT|GE|LE expr",
 /* 289 */ "exprx ::= expr EQ|NE expr",
 /* 290 */ "exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 291 */ "exprx ::= expr PLUS|MINUS expr",
 /* 292 */ "exprx ::= expr STAR|SLASH|REM expr",
 /* 293 */ "exprx ::= expr CONCAT expr",
 /* 294 */ "exprx ::= expr not_opt likeop expr",
 /* 295 */ "exprx ::= expr not_opt likeop expr ESCAPE expr",
 /* 296 */ "exprx ::= expr ISNULL|NOTNULL",
 /* 297 */ "exprx ::= expr NOT NULL",
 /* 298 */ "exprx ::= expr IS not_opt expr",
 /* 299 */ "exprx ::= NOT expr",
 /* 300 */ "exprx ::= BITNOT expr",
 /* 301 */ "exprx ::= MINUS expr",
 /* 302 */ "exprx ::= PLUS expr",
 /* 303 */ "exprx ::= expr not_opt BETWEEN expr AND expr",
 /* 304 */ "exprx ::= expr not_opt IN LP exprlist RP",
 /* 305 */ "exprx ::= LP select RP",
 /* 306 */ "exprx ::= expr not_opt IN LP select RP",
 /* 307 */ "exprx ::= expr not_opt IN nm dbnm",
 /* 308 */ "exprx ::= EXISTS LP select RP",
 /* 309 */ "exprx ::= CASE case_operand case_exprlist case_else END",
 /* 310 */ "exprx ::= RAISE LP IGNORE RP",
 /* 311 */ "exprx ::= RAISE LP raisetype COMMA nm RP",
 /* 312 */ "exprx ::= ID LP distinct exprlist RP filter_over",
 /* 313 */ "exprx ::= ID LP STAR RP filter_over",
 /* 314 */ "expr ::=",
 /* 315 */ "expr ::= exprx",
 /* 316 */ "not_opt ::=",
 /* 317 */ "not_opt ::= NOT",
 /* 318 */ "likeop ::= LIKE_KW|MATCH",
 /* 319 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 320 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 321 */ "case_else ::= ELSE expr",
 /* 322 */ "case_else ::=",
 /* 323 */ "case_operand ::= exprx",
 /* 324 */ "case_operand ::=",
 /* 325 */ "exprlist ::= nexprlist",
 /* 326 */ "exprlist ::=",
 /* 327 */ "nexprlist ::= nexprlist COMMA expr",
 /* 328 */ "nexprlist ::= exprx",
 /* 329 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP sortlist RP where_opt",
 /* 330 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB",
 /* 331 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW",
 /* 332 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW",
 /* 333 */ "uniqueflag ::= UNIQUE",
 /* 334 */ "uniqueflag ::=",
 /* 335 */ "idxlist_opt ::=",
 /* 336 */ "idxlist_opt ::= LP idxlist RP",
 /* 337 */ "idxlist ::= idxlist COMMA idxlist_single",
 /* 338 */ "idxlist ::= idxlist_single",
 /* 339 */ "idxlist_single ::= nm collate sortorder",
 /* 340 */ "idxlist_single ::= ID_COL",
 /* 341 */ "collate ::=",
 /* 342 */ "collate ::= COLLATE ids",
 /* 343 */ "collate ::= COLLATE ID_COLLATE",
 /* 344 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 345 */ "cmd ::= DROP INDEX ifexists nm DOT ID_IDX",
 /* 346 */ "cmd ::= DROP INDEX ifexists ID_DB|ID_IDX",
 /* 347 */ "cmd ::= VACUUM vinto",
 /* 348 */ "cmd ::= VACUUM nm vinto",
 /* 349 */ "vinto ::= INTO expr",
 /* 350 */ "vinto ::=",
 /* 351 */ "cmd ::= PRAGMA nm dbnm",
 /* 352 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 353 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 354 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 355 */ "cmd ::= PRAGMA nm dbnm LP minus_num RP",
 /* 356 */ "cmd ::= PRAGMA nm DOT ID_PRAGMA",
 /* 357 */ "cmd ::= PRAGMA ID_DB|ID_PRAGMA",
 /* 358 */ "nmnum ::= plus_num",
 /* 359 */ "nmnum ::= nm",
 /* 360 */ "nmnum ::= ON",
 /* 361 */ "nmnum ::= DELETE",
 /* 362 */ "nmnum ::= DEFAULT",
 /* 363 */ "plus_num ::= PLUS number",
 /* 364 */ "plus_num ::= number",
 /* 365 */ "minus_num ::= MINUS number",
 /* 366 */ "number ::= INTEGER",
 /* 367 */ "number ::= FLOAT",
 /* 368 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END",
 /* 369 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause",
 /* 370 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list",
 /* 371 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB",
 /* 372 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW",
 /* 373 */ "cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW",
 /* 374 */ "trigger_time ::= BEFORE",
 /* 375 */ "trigger_time ::= AFTER",
 /* 376 */ "trigger_time ::= INSTEAD OF",
 /* 377 */ "trigger_time ::=",
 /* 378 */ "trigger_event ::= DELETE",
 /* 379 */ "trigger_event ::= INSERT",
 /* 380 */ "trigger_event ::= UPDATE",
 /* 381 */ "trigger_event ::= UPDATE OF idlist",
 /* 382 */ "foreach_clause ::=",
 /* 383 */ "foreach_clause ::= FOR EACH ROW",
 /* 384 */ "when_clause ::=",
 /* 385 */ "when_clause ::= WHEN expr",
 /* 386 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 387 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 388 */ "trigger_cmd_list ::= SEMI",
 /* 389 */ "trigger_cmd ::= update_stmt",
 /* 390 */ "trigger_cmd ::= insert_stmt",
 /* 391 */ "trigger_cmd ::= delete_stmt",
 /* 392 */ "trigger_cmd ::= select_stmt",
 /* 393 */ "raisetype ::= ROLLBACK|ABORT|FAIL",
 /* 394 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 395 */ "cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG",
 /* 396 */ "cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG",
 /* 397 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 398 */ "cmd ::= DETACH database_kw_opt expr",
 /* 399 */ "key_opt ::=",
 /* 400 */ "key_opt ::= KEY expr",
 /* 401 */ "database_kw_opt ::= DATABASE",
 /* 402 */ "database_kw_opt ::=",
 /* 403 */ "cmd ::= REINDEX",
 /* 404 */ "cmd ::= REINDEX nm dbnm",
 /* 405 */ "cmd ::= REINDEX ID_COLLATE",
 /* 406 */ "cmd ::= REINDEX nm DOT ID_TAB|ID_IDX",
 /* 407 */ "cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB",
 /* 408 */ "cmd ::= ANALYZE",
 /* 409 */ "cmd ::= ANALYZE nm dbnm",
 /* 410 */ "cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX",
 /* 411 */ "cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB",
 /* 412 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 413 */ "cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column",
 /* 414 */ "cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW",
 /* 415 */ "cmd ::= ALTER TABLE nm DOT ID_TAB",
 /* 416 */ "cmd ::= ALTER TABLE ID_DB|ID_TAB",
 /* 417 */ "kwcolumn_opt ::=",
 /* 418 */ "kwcolumn_opt ::= COLUMNKW",
 /* 419 */ "cmd ::= create_vtab",
 /* 420 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm",
 /* 421 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP",
 /* 422 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW",
 /* 423 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /* 424 */ "vtabarglist ::= vtabarg",
 /* 425 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 426 */ "vtabarg ::=",
 /* 427 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 428 */ "vtabargtoken ::= ANY",
 /* 429 */ "vtabargtoken ::= LP anylist RP",
 /* 430 */ "anylist ::=",
 /* 431 */ "anylist ::= anylist LP anylist RP",
 /* 432 */ "anylist ::= anylist ANY",
 /* 433 */ "with ::=",
 /* 434 */ "with ::= WITH wqlist",
 /* 435 */ "with ::= WITH RECURSIVE wqlist",
 /* 436 */ "wqlist ::= wqcte",
 /* 437 */ "wqlist ::= wqlist COMMA wqcte",
 /* 438 */ "wqlist ::= ID_TAB_NEW",
 /* 439 */ "wqcte ::= nm idxlist_opt AS LP select RP",
 /* 440 */ "windowdefn_list ::= windowdefn",
 /* 441 */ "windowdefn_list ::= windowdefn_list COMMA windowdefn",
 /* 442 */ "windowdefn ::= nm AS LP window RP",
 /* 443 */ "window ::= PARTITION BY nexprlist orderby_opt frame_opt",
 /* 444 */ "window ::= nm PARTITION BY nexprlist orderby_opt frame_opt",
 /* 445 */ "window ::= ORDER BY sortlist frame_opt",
 /* 446 */ "window ::= nm ORDER BY sortlist frame_opt",
 /* 447 */ "window ::= frame_opt",
 /* 448 */ "window ::= nm frame_opt",
 /* 449 */ "frame_opt ::=",
 /* 450 */ "frame_opt ::= range_or_rows frame_bound_s frame_exclude_opt",
 /* 451 */ "frame_opt ::= range_or_rows BETWEEN frame_bound_s AND frame_bound_e frame_exclude_opt",
 /* 452 */ "range_or_rows ::= RANGE|ROWS|GROUPS",
 /* 453 */ "frame_bound_s ::= frame_bound",
 /* 454 */ "frame_bound_s ::= UNBOUNDED PRECEDING",
 /* 455 */ "frame_bound_e ::= frame_bound",
 /* 456 */ "frame_bound_e ::= UNBOUNDED FOLLOWING",
 /* 457 */ "frame_bound ::= expr PRECEDING|FOLLOWING",
 /* 458 */ "frame_bound ::= CURRENT ROW",
 /* 459 */ "frame_exclude_opt ::=",
 /* 460 */ "frame_exclude_opt ::= EXCLUDE frame_exclude",
 /* 461 */ "frame_exclude ::= NO OTHERS",
 /* 462 */ "frame_exclude ::= CURRENT ROW",
 /* 463 */ "frame_exclude ::= GROUP",
 /* 464 */ "frame_exclude ::= TIES",
 /* 465 */ "window_clause ::= WINDOW windowdefn_list",
 /* 466 */ "filter_over ::= filter_clause over_clause",
 /* 467 */ "filter_over ::= over_clause",
 /* 468 */ "filter_over ::= filter_clause",
 /* 469 */ "over_clause ::= OVER LP window RP",
 /* 470 */ "over_clause ::= OVER nm",
 /* 471 */ "filter_clause ::= FILTER LP WHERE expr RP",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3_parse and sqlite3_parseFree.
*/
void *sqlite3_parseAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3_parseARG_FETCH;
  if (parserContext->executeRules)
  {
      switch( yymajor ){
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
    case 191: /* cmd */
    case 194: /* ecmd */
    case 196: /* cmdx */
    case 243: /* select_stmt */
    case 272: /* delete_stmt */
    case 273: /* update_stmt */
    case 276: /* insert_stmt */
    case 297: /* trigger_cmd */
    case 301: /* create_vtab */
{
parser_safe_delete((yypminor->yy363));
}
      break;
    case 195: /* explain */
{
parser_safe_delete((yypminor->yy91));
}
      break;
    case 197: /* transtype */
    case 198: /* trans_opt */
{
parser_safe_delete((yypminor->yy84));
}
      break;
    case 199: /* nm */
    case 206: /* table_options */
    case 209: /* columnid */
    case 212: /* id */
    case 213: /* id_opt */
    case 214: /* ids */
    case 216: /* typename */
    case 267: /* dbnm */
    case 288: /* collate */
    case 303: /* vtabarg */
    case 304: /* vtabargtoken */
    case 305: /* anylist */
{
parser_safe_delete((yypminor->yy319));
}
      break;
    case 200: /* savepoint_opt */
    case 202: /* ifnotexists */
    case 225: /* autoinc */
    case 229: /* gen_always */
    case 235: /* tconscomma */
    case 242: /* ifexists */
    case 280: /* not_opt */
    case 286: /* uniqueflag */
    case 298: /* database_kw_opt */
    case 300: /* kwcolumn_opt */
{
parser_safe_delete((yypminor->yy611));
}
      break;
    case 201: /* temp */
    case 249: /* distinct */
{
parser_safe_delete((yypminor->yy386));
}
      break;
    case 203: /* fullname */
{
parser_safe_delete((yypminor->yy440));
}
      break;
    case 204: /* columnlist */
{
parser_safe_delete((yypminor->yy42));
}
      break;
    case 205: /* conslist_opt */
    case 234: /* conslist */
{
parser_safe_delete((yypminor->yy493));
}
      break;
    case 207: /* select */
    case 245: /* selectnowith */
{
parser_safe_delete((yypminor->yy313));
}
      break;
    case 208: /* column */
{
parser_safe_delete((yypminor->yy147));
}
      break;
    case 210: /* type */
    case 215: /* typetoken */
{
parser_safe_delete((yypminor->yy57));
}
      break;
    case 211: /* carglist */
{
parser_safe_delete((yypminor->yy51));
}
      break;
    case 217: /* signed */
    case 218: /* plus_num */
    case 219: /* minus_num */
    case 221: /* term */
    case 290: /* nmnum */
    case 291: /* number */
{
parser_safe_delete((yypminor->yy229));
}
      break;
    case 220: /* ccons */
{
parser_safe_delete((yypminor->yy464));
}
      break;
    case 222: /* expr */
    case 252: /* where_opt */
    case 254: /* having_opt */
    case 279: /* exprx */
    case 282: /* case_operand */
    case 284: /* case_else */
    case 289: /* vinto */
    case 295: /* when_clause */
    case 299: /* key_opt */
{
parser_safe_delete((yypminor->yy512));
}
      break;
    case 223: /* onconf */
    case 239: /* resolvetype */
    case 240: /* orconf */
{
parser_safe_delete((yypminor->yy418));
}
      break;
    case 224: /* sortorder */
{
parser_safe_delete((yypminor->yy549));
}
      break;
    case 226: /* idxlist_opt */
    case 237: /* idxlist */
{
parser_safe_delete((yypminor->yy223));
}
      break;
    case 227: /* refargs */
{
parser_safe_delete((yypminor->yy584));
}
      break;
    case 228: /* defer_subclause */
    case 238: /* defer_subclause_opt */
{
parser_safe_delete((yypminor->yy9));
}
      break;
    case 230: /* tnm */
{
parser_safe_delete((yypminor->yy590));
}
      break;
    case 231: /* refarg */
{
parser_safe_delete((yypminor->yy507));
}
      break;
    case 232: /* refact */
{
parser_safe_delete((yypminor->yy104));
}
      break;
    case 233: /* init_deferred_pred_opt */
{
parser_safe_delete((yypminor->yy312));
}
      break;
    case 236: /* tcons */
{
parser_safe_delete((yypminor->yy246));
}
      break;
    case 244: /* with */
{
parser_safe_delete((yypminor->yy1));
}
      break;
    case 246: /* oneselect */
{
parser_safe_delete((yypminor->yy470));
}
      break;
    case 247: /* multiselect_op */
{
parser_safe_delete((yypminor->yy382));
}
      break;
    case 248: /* values */
{
parser_safe_delete((yypminor->yy486));
}
      break;
    case 250: /* selcollist */
    case 260: /* sclp */
{
parser_safe_delete((yypminor->yy53));
}
      break;
    case 251: /* from */
    case 262: /* joinsrc */
{
parser_safe_delete((yypminor->yy31));
}
      break;
    case 253: /* groupby_opt */
    case 258: /* nexprlist */
    case 259: /* exprlist */
    case 283: /* case_exprlist */
{
parser_safe_delete((yypminor->yy71));
}
      break;
    case 255: /* orderby_opt */
    case 270: /* sortlist */
{
parser_safe_delete((yypminor->yy403));
}
      break;
    case 256: /* limit_opt */
{
parser_safe_delete((yypminor->yy4));
}
      break;
    case 257: /* window_clause */
    case 308: /* windowdefn_list */
{
parser_safe_delete((yypminor->yy299));
}
      break;
    case 261: /* as */
{
parser_safe_delete((yypminor->yy200));
}
      break;
    case 263: /* singlesrc */
{
parser_safe_delete((yypminor->yy441));
}
      break;
    case 264: /* seltablist */
{
parser_safe_delete((yypminor->yy451));
}
      break;
    case 265: /* joinop */
{
parser_safe_delete((yypminor->yy221));
}
      break;
    case 266: /* joinconstr_opt */
{
parser_safe_delete((yypminor->yy295));
}
      break;
    case 268: /* indexed_opt */
{
parser_safe_delete((yypminor->yy592));
}
      break;
    case 269: /* idlist */
    case 275: /* idlist_opt */
    case 302: /* vtabarglist */
{
parser_safe_delete((yypminor->yy575));
}
      break;
    case 271: /* nulls */
{
parser_safe_delete((yypminor->yy579));
}
      break;
    case 274: /* setlist */
{
parser_safe_delete((yypminor->yy201));
}
      break;
    case 277: /* insert_cmd */
{
parser_safe_delete((yypminor->yy504));
}
      break;
    case 278: /* upsert */
{
parser_safe_delete((yypminor->yy400));
}
      break;
    case 281: /* likeop */
{
parser_safe_delete((yypminor->yy40));
}
      break;
    case 285: /* filter_over */
{
parser_safe_delete((yypminor->yy247));
}
      break;
    case 287: /* idxlist_single */
{
parser_safe_delete((yypminor->yy268));
}
      break;
    case 292: /* trigger_time */
{
parser_safe_delete((yypminor->yy532));
}
      break;
    case 293: /* trigger_event */
{
parser_safe_delete((yypminor->yy151));
}
      break;
    case 294: /* foreach_clause */
{
parser_safe_delete((yypminor->yy83));
}
      break;
    case 296: /* trigger_cmd_list */
{
parser_safe_delete((yypminor->yy110));
}
      break;
    case 306: /* wqlist */
{
parser_safe_delete((yypminor->yy593));
}
      break;
    case 307: /* wqcte */
{
parser_safe_delete((yypminor->yy446));
}
      break;
    case 309: /* windowdefn */
{
parser_safe_delete((yypminor->yy266));
}
      break;
    case 310: /* window */
{
parser_safe_delete((yypminor->yy334));
}
      break;
    case 311: /* frame_opt */
{
parser_safe_delete((yypminor->yy41));
}
      break;
    case 312: /* range_or_rows */
{
parser_safe_delete((yypminor->yy419));
}
      break;
    case 313: /* frame_bound_s */
    case 315: /* frame_bound_e */
{
parser_safe_delete((yypminor->yy442));
}
      break;
    case 316: /* frame_bound */
{
parser_safe_delete((yypminor->yy442));parser_safe_delete((yypminor->yy442));parser_safe_delete((yypminor->yy442));
}
      break;
    case 318: /* filter_clause */
{
parser_safe_delete((yypminor->yy397));
}
      break;
    case 319: /* over_clause */
{
parser_safe_delete((yypminor->yy248));
}
      break;
        default:  break;   /* If no destructor action specified: do nothing */
      }
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  /* There is no mechanism by which the parser stack can be popped below
  ** empty in SQLite.  */
  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  delete yytos->tokens;
  yytos->tokens = nullptr;
  pParser->yyidx--;
  return yymajor;
}

/*
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3_parseAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3_parseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  /* In SQLite, we never try to destroy a parser that was not successfully
  ** created in the first place. */
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3_parseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
  GET_CONTEXT;

  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0
             && parserContext->doFallbacks ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if(
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   UNUSED(yypMinor);
   sqlite3_parseARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */

    parserContext->error(QObject::tr("Parser stack overflow"));
   sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
  yytos->tokens = new QList<Token*>();
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 192, 1 },
  { 193, 2 },
  { 193, 1 },
  { 194, 1 },
  { 194, 3 },
  { 195, 0 },
  { 195, 1 },
  { 195, 3 },
  { 196, 1 },
  { 191, 3 },
  { 198, 0 },
  { 198, 1 },
  { 198, 2 },
  { 198, 2 },
  { 197, 0 },
  { 197, 1 },
  { 197, 1 },
  { 197, 1 },
  { 191, 2 },
  { 191, 2 },
  { 191, 2 },
  { 200, 1 },
  { 200, 0 },
  { 191, 2 },
  { 191, 3 },
  { 191, 5 },
  { 191, 2 },
  { 191, 3 },
  { 191, 5 },
  { 191, 10 },
  { 191, 7 },
  { 191, 7 },
  { 191, 5 },
  { 206, 0 },
  { 206, 2 },
  { 206, 2 },
  { 202, 0 },
  { 202, 3 },
  { 201, 1 },
  { 201, 0 },
  { 204, 3 },
  { 204, 1 },
  { 208, 3 },
  { 209, 1 },
  { 209, 1 },
  { 212, 1 },
  { 213, 1 },
  { 213, 0 },
  { 214, 1 },
  { 199, 1 },
  { 199, 1 },
  { 199, 1 },
  { 210, 0 },
  { 210, 1 },
  { 215, 1 },
  { 215, 4 },
  { 215, 6 },
  { 216, 1 },
  { 216, 2 },
  { 216, 1 },
  { 217, 1 },
  { 217, 1 },
  { 211, 2 },
  { 211, 0 },
  { 220, 2 },
  { 220, 2 },
  { 220, 4 },
  { 220, 3 },
  { 220, 3 },
  { 220, 2 },
  { 220, 2 },
  { 220, 2 },
  { 220, 3 },
  { 220, 5 },
  { 220, 2 },
  { 220, 4 },
  { 220, 4 },
  { 220, 1 },
  { 220, 2 },
  { 220, 6 },
  { 220, 2 },
  { 220, 2 },
  { 220, 2 },
  { 220, 3 },
  { 221, 1 },
  { 221, 1 },
  { 221, 1 },
  { 221, 1 },
  { 230, 1 },
  { 230, 1 },
  { 229, 2 },
  { 229, 0 },
  { 225, 0 },
  { 225, 1 },
  { 227, 0 },
  { 227, 2 },
  { 231, 2 },
  { 231, 3 },
  { 231, 3 },
  { 231, 3 },
  { 231, 2 },
  { 232, 2 },
  { 232, 2 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 228, 3 },
  { 228, 2 },
  { 233, 0 },
  { 233, 2 },
  { 233, 2 },
  { 205, 0 },
  { 205, 2 },
  { 234, 3 },
  { 234, 1 },
  { 235, 1 },
  { 235, 0 },
  { 236, 2 },
  { 236, 7 },
  { 236, 5 },
  { 236, 5 },
  { 236, 10 },
  { 236, 2 },
  { 236, 7 },
  { 236, 4 },
  { 238, 0 },
  { 238, 1 },
  { 223, 0 },
  { 223, 3 },
  { 240, 0 },
  { 240, 2 },
  { 239, 1 },
  { 239, 1 },
  { 239, 1 },
  { 191, 4 },
  { 191, 6 },
  { 191, 4 },
  { 242, 2 },
  { 242, 0 },
  { 191, 8 },
  { 191, 7 },
  { 191, 5 },
  { 191, 4 },
  { 191, 6 },
  { 191, 4 },
  { 191, 1 },
  { 243, 1 },
  { 207, 2 },
  { 245, 1 },
  { 245, 3 },
  { 245, 1 },
  { 245, 3 },
  { 246, 9 },
  { 246, 10 },
  { 248, 4 },
  { 248, 5 },
  { 247, 1 },
  { 247, 2 },
  { 247, 1 },
  { 247, 1 },
  { 249, 1 },
  { 249, 1 },
  { 249, 0 },
  { 260, 2 },
  { 260, 0 },
  { 250, 3 },
  { 250, 2 },
  { 250, 4 },
  { 250, 1 },
  { 250, 4 },
  { 261, 2 },
  { 261, 1 },
  { 261, 2 },
  { 261, 1 },
  { 261, 0 },
  { 251, 0 },
  { 251, 2 },
  { 262, 2 },
  { 262, 0 },
  { 264, 4 },
  { 264, 0 },
  { 263, 4 },
  { 263, 4 },
  { 263, 4 },
  { 263, 6 },
  { 263, 0 },
  { 263, 2 },
  { 263, 3 },
  { 263, 1 },
  { 263, 3 },
  { 263, 1 },
  { 266, 2 },
  { 266, 4 },
  { 266, 0 },
  { 267, 0 },
  { 267, 2 },
  { 203, 2 },
  { 265, 1 },
  { 265, 1 },
  { 265, 2 },
  { 265, 3 },
  { 265, 4 },
  { 265, 1 },
  { 268, 0 },
  { 268, 3 },
  { 268, 2 },
  { 268, 3 },
  { 255, 0 },
  { 255, 3 },
  { 270, 5 },
  { 270, 3 },
  { 224, 1 },
  { 224, 1 },
  { 224, 0 },
  { 271, 2 },
  { 271, 2 },
  { 271, 0 },
  { 253, 0 },
  { 253, 3 },
  { 253, 2 },
  { 254, 0 },
  { 254, 2 },
  { 256, 0 },
  { 256, 2 },
  { 256, 4 },
  { 256, 4 },
  { 191, 1 },
  { 272, 6 },
  { 272, 3 },
  { 272, 5 },
  { 272, 6 },
  { 272, 4 },
  { 252, 0 },
  { 252, 2 },
  { 252, 1 },
  { 191, 1 },
  { 273, 9 },
  { 273, 3 },
  { 273, 5 },
  { 273, 6 },
  { 273, 4 },
  { 274, 5 },
  { 274, 7 },
  { 274, 3 },
  { 274, 5 },
  { 274, 0 },
  { 274, 2 },
  { 274, 3 },
  { 274, 1 },
  { 275, 0 },
  { 275, 3 },
  { 269, 3 },
  { 269, 1 },
  { 269, 0 },
  { 269, 3 },
  { 269, 1 },
  { 191, 1 },
  { 276, 7 },
  { 276, 7 },
  { 276, 3 },
  { 276, 5 },
  { 276, 4 },
  { 276, 6 },
  { 277, 2 },
  { 277, 1 },
  { 278, 0 },
  { 278, 11 },
  { 278, 8 },
  { 278, 4 },
  { 279, 4 },
  { 279, 6 },
  { 279, 1 },
  { 279, 3 },
  { 279, 5 },
  { 279, 3 },
  { 279, 6 },
  { 279, 1 },
  { 279, 3 },
  { 279, 1 },
  { 279, 3 },
  { 279, 5 },
  { 279, 1 },
  { 279, 3 },
  { 279, 6 },
  { 279, 5 },
  { 279, 4 },
  { 279, 3 },
  { 279, 3 },
  { 279, 3 },
  { 279, 3 },
  { 279, 3 },
  { 279, 3 },
  { 279, 3 },
  { 279, 3 },
  { 279, 4 },
  { 279, 6 },
  { 279, 2 },
  { 279, 3 },
  { 279, 4 },
  { 279, 2 },
  { 279, 2 },
  { 279, 2 },
  { 279, 2 },
  { 279, 6 },
  { 279, 6 },
  { 279, 3 },
  { 279, 6 },
  { 279, 5 },
  { 279, 4 },
  { 279, 5 },
  { 279, 4 },
  { 279, 6 },
  { 279, 6 },
  { 279, 5 },
  { 222, 0 },
  { 222, 1 },
  { 280, 0 },
  { 280, 1 },
  { 281, 1 },
  { 283, 5 },
  { 283, 4 },
  { 284, 2 },
  { 284, 0 },
  { 282, 1 },
  { 282, 0 },
  { 259, 1 },
  { 259, 0 },
  { 258, 3 },
  { 258, 1 },
  { 191, 12 },
  { 191, 8 },
  { 191, 7 },
  { 191, 5 },
  { 286, 1 },
  { 286, 0 },
  { 226, 0 },
  { 226, 3 },
  { 237, 3 },
  { 237, 1 },
  { 287, 3 },
  { 287, 1 },
  { 288, 0 },
  { 288, 2 },
  { 288, 2 },
  { 191, 4 },
  { 191, 6 },
  { 191, 4 },
  { 191, 2 },
  { 191, 3 },
  { 289, 2 },
  { 289, 0 },
  { 191, 3 },
  { 191, 5 },
  { 191, 6 },
  { 191, 5 },
  { 191, 6 },
  { 191, 4 },
  { 191, 2 },
  { 290, 1 },
  { 290, 1 },
  { 290, 1 },
  { 290, 1 },
  { 290, 1 },
  { 218, 2 },
  { 218, 1 },
  { 219, 2 },
  { 291, 1 },
  { 291, 1 },
  { 191, 15 },
  { 191, 12 },
  { 191, 14 },
  { 191, 10 },
  { 191, 7 },
  { 191, 5 },
  { 292, 1 },
  { 292, 1 },
  { 292, 2 },
  { 292, 0 },
  { 293, 1 },
  { 293, 1 },
  { 293, 1 },
  { 293, 3 },
  { 294, 0 },
  { 294, 3 },
  { 295, 0 },
  { 295, 2 },
  { 296, 3 },
  { 296, 2 },
  { 296, 1 },
  { 297, 1 },
  { 297, 1 },
  { 297, 1 },
  { 297, 1 },
  { 241, 1 },
  { 191, 4 },
  { 191, 6 },
  { 191, 4 },
  { 191, 6 },
  { 191, 3 },
  { 299, 0 },
  { 299, 2 },
  { 298, 1 },
  { 298, 0 },
  { 191, 1 },
  { 191, 3 },
  { 191, 2 },
  { 191, 4 },
  { 191, 2 },
  { 191, 1 },
  { 191, 3 },
  { 191, 4 },
  { 191, 2 },
  { 191, 6 },
  { 191, 6 },
  { 191, 6 },
  { 191, 5 },
  { 191, 3 },
  { 300, 0 },
  { 300, 1 },
  { 191, 1 },
  { 301, 8 },
  { 301, 11 },
  { 301, 7 },
  { 301, 5 },
  { 302, 1 },
  { 302, 3 },
  { 303, 0 },
  { 303, 2 },
  { 304, 1 },
  { 304, 3 },
  { 305, 0 },
  { 305, 4 },
  { 305, 2 },
  { 244, 0 },
  { 244, 2 },
  { 244, 3 },
  { 306, 1 },
  { 306, 3 },
  { 306, 1 },
  { 307, 6 },
  { 308, 1 },
  { 308, 3 },
  { 309, 5 },
  { 310, 5 },
  { 310, 6 },
  { 310, 4 },
  { 310, 5 },
  { 310, 1 },
  { 310, 2 },
  { 311, 0 },
  { 311, 3 },
  { 311, 6 },
  { 312, 1 },
  { 313, 1 },
  { 313, 2 },
  { 315, 1 },
  { 315, 2 },
  { 316, 2 },
  { 316, 2 },
  { 314, 0 },
  { 314, 2 },
  { 317, 2 },
  { 317, 2 },
  { 317, 1 },
  { 317, 1 },
  { 257, 2 },
  { 285, 2 },
  { 285, 1 },
  { 285, 1 },
  { 319, 4 },
  { 319, 2 },
  { 318, 5 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3_parseARG_FETCH;
  SqliteStatement* objectForTokens = 0;
  QStringList noTokenInheritanceFields;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  if (parserContext->executeRules)
  {
      switch( yyruleno ){
      /* Beginning here are the reduction cases.  A typical example
      ** follows:
      **   case 0:
      **  #line <lineno> <grammarfile>
      **     { ... }           // User supplied code
      **  #line <lineno> <thisfile>
      **     break;
      */
      case 1: /* cmdlist ::= cmdlist ecmd */
{parserContext->addQuery(yymsp[0].minor.yy363); DONT_INHERIT_TOKENS("cmdlist");}
        break;
      case 2: /* cmdlist ::= ecmd */
{parserContext->addQuery(yymsp[0].minor.yy363);}
        break;
      case 3: /* ecmd ::= SEMI */
{yygotominor.yy363 = new SqliteEmptyQuery();}
        break;
      case 4: /* ecmd ::= explain cmdx SEMI */
{
                                                yygotominor.yy363 = yymsp[-1].minor.yy363;
                                                yygotominor.yy363->explain = yymsp[-2].minor.yy91->explain;
                                                yygotominor.yy363->queryPlan = yymsp[-2].minor.yy91->queryPlan;
                                                delete yymsp[-2].minor.yy91;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 5: /* explain ::= */
{yygotominor.yy91 = new ParserStubExplain(false, false);}
        break;
      case 6: /* explain ::= EXPLAIN */
{yygotominor.yy91 = new ParserStubExplain(true, false);}
        break;
      case 7: /* explain ::= EXPLAIN QUERY PLAN */
{yygotominor.yy91 = new ParserStubExplain(true, true);}
        break;
      case 8: /* cmdx ::= cmd */
      case 389: /* trigger_cmd ::= update_stmt */ yytestcase(yyruleno==389);
      case 390: /* trigger_cmd ::= insert_stmt */ yytestcase(yyruleno==390);
      case 391: /* trigger_cmd ::= delete_stmt */ yytestcase(yyruleno==391);
      case 392: /* trigger_cmd ::= select_stmt */ yytestcase(yyruleno==392);
      case 419: /* cmd ::= create_vtab */ yytestcase(yyruleno==419);
{yygotominor.yy363 = yymsp[0].minor.yy363;}
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
{
                                                yygotominor.yy363 = new SqliteBeginTrans(
                                                        yymsp[-1].minor.yy84->type,
                                                        yymsp[0].minor.yy84->transactionKw,
                                                        yymsp[0].minor.yy84->name
                                                    );
                                                delete yymsp[0].minor.yy84;
                                                delete yymsp[-1].minor.yy84;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 10: /* trans_opt ::= */
      case 14: /* transtype ::= */ yytestcase(yyruleno==14);
{yygotominor.yy84 = new ParserStubTransDetails();}
        break;
      case 11: /* trans_opt ::= TRANSACTION */
{
                                                yygotominor.yy84 = new ParserStubTransDetails();
                                                yygotominor.yy84->transactionKw = true;
                                            }
        break;
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 13: /* trans_opt ::= TRANSACTION ID_TRANS */ yytestcase(yyruleno==13);
{
                                                yygotominor.yy84 = new ParserStubTransDetails();
                                                yygotominor.yy84->transactionKw = true;
                                                yygotominor.yy84->name = *(yymsp[0].minor.yy319);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 15: /* transtype ::= DEFERRED */
{
                                                yygotominor.yy84 = new ParserStubTransDetails();
                                                yygotominor.yy84->type = SqliteBeginTrans::Type::DEFERRED;
                                            }
        break;
      case 16: /* transtype ::= IMMEDIATE */
{
                                                yygotominor.yy84 = new ParserStubTransDetails();
                                                yygotominor.yy84->type = SqliteBeginTrans::Type::IMMEDIATE;
                                            }
        break;
      case 17: /* transtype ::= EXCLUSIVE */
{
                                                yygotominor.yy84 = new ParserStubTransDetails();
                                                yygotominor.yy84->type = SqliteBeginTrans::Type::EXCLUSIVE;
                                            }
        break;
      case 18: /* cmd ::= COMMIT trans_opt */
{
                                                yygotominor.yy363 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy84->transactionKw,
                                                        yymsp[0].minor.yy84->name,
                                                        false
                                                    );
                                                delete yymsp[0].minor.yy84;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 19: /* cmd ::= END trans_opt */
{
                                                yygotominor.yy363 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy84->transactionKw,
                                                        yymsp[0].minor.yy84->name,
                                                        true
                                                    );
                                                delete yymsp[0].minor.yy84;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 20: /* cmd ::= ROLLBACK trans_opt */
{
                                                yygotominor.yy363 = new SqliteRollback(
                                                        yymsp[0].minor.yy84->transactionKw,
                                                        yymsp[0].minor.yy84->name
                                                    );
                                                delete yymsp[0].minor.yy84;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 21: /* savepoint_opt ::= SAVEPOINT */
      case 37: /* ifnotexists ::= IF NOT EXISTS */ yytestcase(yyruleno==37);
      case 90: /* gen_always ::= GENERATED ALWAYS */ yytestcase(yyruleno==90);
      case 93: /* autoinc ::= AUTOINCR */ yytestcase(yyruleno==93);
      case 115: /* tconscomma ::= COMMA */ yytestcase(yyruleno==115);
      case 137: /* ifexists ::= IF EXISTS */ yytestcase(yyruleno==137);
      case 317: /* not_opt ::= NOT */ yytestcase(yyruleno==317);
      case 333: /* uniqueflag ::= UNIQUE */ yytestcase(yyruleno==333);
      case 401: /* database_kw_opt ::= DATABASE */ yytestcase(yyruleno==401);
      case 417: /* kwcolumn_opt ::= */ yytestcase(yyruleno==417);
{yygotominor.yy611 = new bool(true);}
        break;
      case 22: /* savepoint_opt ::= */
      case 36: /* ifnotexists ::= */ yytestcase(yyruleno==36);
      case 91: /* gen_always ::= */ yytestcase(yyruleno==91);
      case 92: /* autoinc ::= */ yytestcase(yyruleno==92);
      case 116: /* tconscomma ::= */ yytestcase(yyruleno==116);
      case 138: /* ifexists ::= */ yytestcase(yyruleno==138);
      case 316: /* not_opt ::= */ yytestcase(yyruleno==316);
      case 334: /* uniqueflag ::= */ yytestcase(yyruleno==334);
      case 402: /* database_kw_opt ::= */ yytestcase(yyruleno==402);
      case 418: /* kwcolumn_opt ::= COLUMNKW */ yytestcase(yyruleno==418);
{yygotominor.yy611 = new bool(false);}
        break;
      case 23: /* cmd ::= SAVEPOINT nm */
{
                                                yygotominor.yy363 = new SqliteSavepoint(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 24: /* cmd ::= RELEASE savepoint_opt nm */
{
                                                yygotominor.yy363 = new SqliteRelease(*(yymsp[-1].minor.yy611), *(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt nm */
      case 26: /* cmd ::= SAVEPOINT ID_TRANS */ yytestcase(yyruleno==26);
{
                                                yygotominor.yy363 = new SqliteRollback(
                                                        yymsp[-3].minor.yy84->transactionKw,
                                                        *(yymsp[-1].minor.yy611),
                                                        *(yymsp[0].minor.yy319)
                                                    );
                                                delete yymsp[-1].minor.yy611;
                                                delete yymsp[-3].minor.yy84;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 27: /* cmd ::= RELEASE savepoint_opt ID_TRANS */
      case 28: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS */ yytestcase(yyruleno==28);
{  yy_destructor(yypParser,200,&yymsp[-1].minor);
}
        break;
      case 29: /* cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options */
{
                                                yygotominor.yy363 = new SqliteCreateTable(
                                                        *(yymsp[-6].minor.yy611),
                                                        *(yymsp[-8].minor.yy386),
                                                        yymsp[-5].minor.yy440->name1,
                                                        yymsp[-5].minor.yy440->name2,
                                                        *(yymsp[-3].minor.yy42),
                                                        *(yymsp[-2].minor.yy493),
                                                        *(yymsp[0].minor.yy319)
                                                    );
                                                delete yymsp[-6].minor.yy611;
                                                delete yymsp[-8].minor.yy386;
                                                delete yymsp[-3].minor.yy42;
                                                delete yymsp[-2].minor.yy493;
                                                delete yymsp[-5].minor.yy440;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 30: /* cmd ::= CREATE temp TABLE ifnotexists fullname AS select */
{
                                                yygotominor.yy363 = new SqliteCreateTable(
                                                        *(yymsp[-3].minor.yy611),
                                                        *(yymsp[-5].minor.yy386),
                                                        yymsp[-2].minor.yy440->name1,
                                                        yymsp[-2].minor.yy440->name2,
                                                        yymsp[0].minor.yy313
                                                    );
                                                delete yymsp[-3].minor.yy611;
                                                delete yymsp[-5].minor.yy386;
                                                delete yymsp[-2].minor.yy440;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 31: /* cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW */
      case 140: /* cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW */ yytestcase(yyruleno==140);
      case 372: /* cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW */ yytestcase(yyruleno==372);
{  yy_destructor(yypParser,201,&yymsp[-5].minor);
  yy_destructor(yypParser,199,&yymsp[-2].minor);
}
        break;
      case 32: /* cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW */
      case 141: /* cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW */ yytestcase(yyruleno==141);
      case 373: /* cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW */ yytestcase(yyruleno==373);
{  yy_destructor(yypParser,201,&yymsp[-3].minor);
}
        break;
      case 33: /* table_options ::= */
      case 194: /* dbnm ::= */ yytestcase(yyruleno==194);
      case 341: /* collate ::= */ yytestcase(yyruleno==341);
      case 426: /* vtabarg ::= */ yytestcase(yyruleno==426);
      case 430: /* anylist ::= */ yytestcase(yyruleno==430);
{yygotominor.yy319 = new QString();}
        break;
      case 34: /* table_options ::= WITHOUT nm */
      case 35: /* table_options ::= WITHOUT CTX_ROWID_KW */ yytestcase(yyruleno==35);
{
                                                if (yymsp[0].minor.yy319->toLower() != "rowid")
                                                    parserContext->errorAtToken(QString("Invalid table option: %1").arg(*(yymsp[0].minor.yy319)));

                                                yygotominor.yy319 = yymsp[0].minor.yy319;
                                            }
        break;
      case 38: /* temp ::= TEMP */
{yygotominor.yy386 = new int( (yymsp[0].minor.yy0->value.length() > 4) ? 2 : 1 );}
        break;
      case 39: /* temp ::= */
      case 162: /* distinct ::= */ yytestcase(yyruleno==162);
{yygotominor.yy386 = new int(0);}
        break;
      case 40: /* columnlist ::= columnlist COMMA column */
{
                                                yymsp[-2].minor.yy42->append(yymsp[0].minor.yy147);
                                                yygotominor.yy42 = yymsp[-2].minor.yy42;
                                                DONT_INHERIT_TOKENS("columnlist");
                                            }
        break;
      case 41: /* columnlist ::= column */
{
                                                yygotominor.yy42 = new ParserCreateTableColumnList();
                                                yygotominor.yy42->append(yymsp[0].minor.yy147);
                                            }
        break;
      case 42: /* column ::= columnid type carglist */
{
                                                yygotominor.yy147 = new SqliteCreateTable::Column(*(yymsp[-2].minor.yy319), yymsp[-1].minor.yy57, *(yymsp[0].minor.yy51));
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy51;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 43: /* columnid ::= nm */
      case 44: /* columnid ::= ID_COL_NEW */ yytestcase(yyruleno==44);
      case 49: /* nm ::= id */ yytestcase(yyruleno==49);
      case 57: /* typename ::= ids */ yytestcase(yyruleno==57);
      case 195: /* dbnm ::= DOT nm */ yytestcase(yyruleno==195);
      case 342: /* collate ::= COLLATE ids */ yytestcase(yyruleno==342);
      case 343: /* collate ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==343);
{yygotominor.yy319 = yymsp[0].minor.yy319;}
        break;
      case 45: /* id ::= ID */
{
                                                yygotominor.yy319 = new QString(
                                                    stripObjName(
                                                        yymsp[0].minor.yy0->value
                                                    )
                                                );
                                            }
        break;
      case 46: /* id_opt ::= id */
{
                                                yygotominor.yy319 = yymsp[0].minor.yy319;
                                            }
        break;
      case 47: /* id_opt ::= */
{
                                                yygotominor.yy319 = new QString();
                                            }
        break;
      case 48: /* ids ::= ID|STRING */
      case 51: /* nm ::= JOIN_KW */ yytestcase(yyruleno==51);
{yygotominor.yy319 = new QString(yymsp[0].minor.yy0->value);}
        break;
      case 50: /* nm ::= STRING */
{yygotominor.yy319 = new QString(stripString(yymsp[0].minor.yy0->value));}
        break;
      case 52: /* type ::= */
{yygotominor.yy57 = nullptr;}
        break;
      case 53: /* type ::= typetoken */
{yygotominor.yy57 = yymsp[0].minor.yy57;}
        break;
      case 54: /* typetoken ::= typename */
{
                                                yygotominor.yy57 = new SqliteColumnType(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy57;
                                            }
        break;
      case 55: /* typetoken ::= typename LP signed RP */
{
                                                yygotominor.yy57 = new SqliteColumnType(*(yymsp[-3].minor.yy319), *(yymsp[-1].minor.yy229));
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-1].minor.yy229;
                                                objectForTokens = yygotominor.yy57;
                                            }
        break;
      case 56: /* typetoken ::= typename LP signed COMMA signed RP */
{
                                                yygotominor.yy57 = new SqliteColumnType(*(yymsp[-5].minor.yy319), *(yymsp[-3].minor.yy229), *(yymsp[-1].minor.yy229));
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-3].minor.yy229;
                                                delete yymsp[-1].minor.yy229;
                                                objectForTokens = yygotominor.yy57;
                                            }
        break;
      case 58: /* typename ::= typename ids */
      case 59: /* typename ::= ID_COL_TYPE */ yytestcase(yyruleno==59);
{
                                                yymsp[-1].minor.yy319->append(" " + *(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                yygotominor.yy319 = yymsp[-1].minor.yy319;
                                            }
        break;
      case 60: /* signed ::= plus_num */
      case 61: /* signed ::= minus_num */ yytestcase(yyruleno==61);
      case 358: /* nmnum ::= plus_num */ yytestcase(yyruleno==358);
      case 363: /* plus_num ::= PLUS number */ yytestcase(yyruleno==363);
      case 364: /* plus_num ::= number */ yytestcase(yyruleno==364);
{yygotominor.yy229 = yymsp[0].minor.yy229;}
        break;
      case 62: /* carglist ::= carglist ccons */
{
                                                yymsp[-1].minor.yy51->append(yymsp[0].minor.yy464);
                                                yygotominor.yy51 = yymsp[-1].minor.yy51;
                                                DONT_INHERIT_TOKENS("carglist");
                                            }
        break;
      case 63: /* carglist ::= */
{yygotominor.yy51 = new ParserCreateTableColumnConstraintList();}
        break;
      case 64: /* ccons ::= CONSTRAINT nm */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initDefNameOnly(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 65: /* ccons ::= DEFAULT term */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initDefTerm(*(yymsp[0].minor.yy229));
                                                delete yymsp[0].minor.yy229;
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 66: /* ccons ::= DEFAULT LP expr RP */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initDefExpr(yymsp[-1].minor.yy512);
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 67: /* ccons ::= DEFAULT PLUS term */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initDefTerm(*(yymsp[0].minor.yy229), false);
                                                delete yymsp[0].minor.yy229;
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 68: /* ccons ::= DEFAULT MINUS term */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initDefTerm(*(yymsp[0].minor.yy229), true);
                                                delete yymsp[0].minor.yy229;
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 69: /* ccons ::= DEFAULT id */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initDefId(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 70: /* ccons ::= DEFAULT CTIME_KW */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initDefCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 71: /* ccons ::= NULL onconf */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initNull(*(yymsp[0].minor.yy418));
                                                delete yymsp[0].minor.yy418;
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 72: /* ccons ::= NOT NULL onconf */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initNotNull(*(yymsp[0].minor.yy418));
                                                delete yymsp[0].minor.yy418;
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 73: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initPk(*(yymsp[-2].minor.yy549), *(yymsp[-1].minor.yy418), *(yymsp[0].minor.yy611));
                                                delete yymsp[-2].minor.yy549;
                                                delete yymsp[0].minor.yy611;
                                                delete yymsp[-1].minor.yy418;
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 74: /* ccons ::= UNIQUE onconf */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initUnique(*(yymsp[0].minor.yy418));
                                                delete yymsp[0].minor.yy418;
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 75: /* ccons ::= CHECK LP expr RP */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initCheck(yymsp[-1].minor.yy512);
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 76: /* ccons ::= REFERENCES nm idxlist_opt refargs */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initFk(*(yymsp[-2].minor.yy319), *(yymsp[-1].minor.yy223), *(yymsp[0].minor.yy584));
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy584;
                                                delete yymsp[-1].minor.yy223;
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 77: /* ccons ::= defer_subclause */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initDefer(yymsp[0].minor.yy9->initially, yymsp[0].minor.yy9->deferrable);
                                                delete yymsp[0].minor.yy9;
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 78: /* ccons ::= COLLATE ids */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initColl(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy464;
                                            }
        break;
      case 79: /* ccons ::= gen_always AS LP expr RP id_opt */
      case 80: /* ccons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==80);
      case 81: /* ccons ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==81);
      case 82: /* ccons ::= REFERENCES ID_TAB */ yytestcase(yyruleno==82);
{
                                                if (!yymsp[0].minor.yy319->isNull() && yymsp[0].minor.yy319->toLower() != "stored" && yymsp[0].minor.yy319->toLower() != "virtual")
                                                    parserContext->errorAtToken(QString("Invalid generated column type: %1").arg(*(yymsp[0].minor.yy319)));

                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
												yygotominor.yy464->initGeneratedAs(yymsp[-2].minor.yy512, *(yymsp[-5].minor.yy611), *(yymsp[0].minor.yy319));
												delete yymsp[-5].minor.yy611;
												delete yymsp[0].minor.yy319;
												objectForTokens = yygotominor.yy464;
											}
        break;
      case 83: /* ccons ::= CHECK LP RP */
{
                                                yygotominor.yy464 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy464->initCheck();
                                                objectForTokens = yygotominor.yy464;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 84: /* term ::= NULL */
{yygotominor.yy229 = new QVariant();}
        break;
      case 85: /* term ::= INTEGER */
      case 366: /* number ::= INTEGER */ yytestcase(yyruleno==366);
{yygotominor.yy229 = parserContext->handleNumberToken(yymsp[0].minor.yy0->value);}
        break;
      case 86: /* term ::= FLOAT */
      case 367: /* number ::= FLOAT */ yytestcase(yyruleno==367);
{yygotominor.yy229 = new QVariant(QVariant(yymsp[0].minor.yy0->value).toDouble());}
        break;
      case 87: /* term ::= STRING|BLOB */
{yygotominor.yy229 = new QVariant(stripString(yymsp[0].minor.yy0->value));}
        break;
      case 88: /* tnm ::= term */
{
												yygotominor.yy590 = new ParserTermOrLiteral(*(yymsp[0].minor.yy229));
												delete yymsp[0].minor.yy229;
											}
        break;
      case 89: /* tnm ::= nm */
{
												yygotominor.yy590 = new ParserTermOrLiteral(*(yymsp[0].minor.yy319));
												delete yymsp[0].minor.yy319;
											}
        break;
      case 94: /* refargs ::= */
{yygotominor.yy584 = new ParserFkConditionList();}
        break;
      case 95: /* refargs ::= refargs refarg */
{
                                                yymsp[-1].minor.yy584->append(yymsp[0].minor.yy507);
                                                yygotominor.yy584 = yymsp[-1].minor.yy584;
                                                DONT_INHERIT_TOKENS("refargs");
                                            }
        break;
      case 96: /* refarg ::= MATCH nm */
{
                                                yygotominor.yy507 = new SqliteForeignKey::Condition(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 97: /* refarg ::= ON INSERT refact */
{yygotominor.yy507 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::INSERT, *(yymsp[0].minor.yy104)); delete yymsp[0].minor.yy104;}
        break;
      case 98: /* refarg ::= ON DELETE refact */
{yygotominor.yy507 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::DELETE, *(yymsp[0].minor.yy104)); delete yymsp[0].minor.yy104;}
        break;
      case 99: /* refarg ::= ON UPDATE refact */
      case 100: /* refarg ::= MATCH ID_FK_MATCH */ yytestcase(yyruleno==100);
{yygotominor.yy507 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::UPDATE, *(yymsp[0].minor.yy104)); delete yymsp[0].minor.yy104;}
        break;
      case 101: /* refact ::= SET NULL */
{yygotominor.yy104 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_NULL);}
        break;
      case 102: /* refact ::= SET DEFAULT */
{yygotominor.yy104 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_DEFAULT);}
        break;
      case 103: /* refact ::= CASCADE */
{yygotominor.yy104 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::CASCADE);}
        break;
      case 104: /* refact ::= RESTRICT */
{yygotominor.yy104 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::RESTRICT);}
        break;
      case 105: /* refact ::= NO ACTION */
{yygotominor.yy104 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::NO_ACTION);}
        break;
      case 106: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy9 = new ParserDeferSubClause(SqliteDeferrable::NOT_DEFERRABLE, *(yymsp[0].minor.yy312));
                                                delete yymsp[0].minor.yy312;
                                            }
        break;
      case 107: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy9 = new ParserDeferSubClause(SqliteDeferrable::DEFERRABLE, *(yymsp[0].minor.yy312));
                                                delete yymsp[0].minor.yy312;
                                            }
        break;
      case 108: /* init_deferred_pred_opt ::= */
{yygotominor.yy312 = new SqliteInitially(SqliteInitially::null);}
        break;
      case 109: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
{yygotominor.yy312 = new SqliteInitially(SqliteInitially::DEFERRED);}
        break;
      case 110: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
{yygotominor.yy312 = new SqliteInitially(SqliteInitially::IMMEDIATE);}
        break;
      case 111: /* conslist_opt ::= */
{yygotominor.yy493 = new ParserCreateTableConstraintList();}
        break;
      case 112: /* conslist_opt ::= COMMA conslist */
{yygotominor.yy493 = yymsp[0].minor.yy493;}
        break;
      case 113: /* conslist ::= conslist tconscomma tcons */
{
                                                yymsp[0].minor.yy246->afterComma = *(yymsp[-1].minor.yy611);
                                                yymsp[-2].minor.yy493->append(yymsp[0].minor.yy246);
                                                yygotominor.yy493 = yymsp[-2].minor.yy493;
                                                delete yymsp[-1].minor.yy611;
                                                DONT_INHERIT_TOKENS("conslist");
                                            }
        break;
      case 114: /* conslist ::= tcons */
{
                                                yygotominor.yy493 = new ParserCreateTableConstraintList();
                                                yygotominor.yy493->append(yymsp[0].minor.yy246);
                                            }
        break;
      case 117: /* tcons ::= CONSTRAINT nm */
{
                                                yygotominor.yy246 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy246->initNameOnly(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy246;
                                            }
        break;
      case 118: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
{
                                                yygotominor.yy246 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy246->initPk(*(yymsp[-3].minor.yy223), *(yymsp[-2].minor.yy611), *(yymsp[0].minor.yy418));
                                                delete yymsp[-2].minor.yy611;
                                                delete yymsp[0].minor.yy418;
                                                delete yymsp[-3].minor.yy223;
                                                objectForTokens = yygotominor.yy246;
                                            }
        break;
      case 119: /* tcons ::= UNIQUE LP idxlist RP onconf */
{
                                                yygotominor.yy246 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy246->initUnique(*(yymsp[-2].minor.yy223), *(yymsp[0].minor.yy418));
                                                delete yymsp[0].minor.yy418;
                                                delete yymsp[-2].minor.yy223;
                                                objectForTokens = yygotominor.yy246;
                                            }
        break;
      case 120: /* tcons ::= CHECK LP expr RP onconf */
{
                                                yygotominor.yy246 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy246->initCheck(yymsp[-2].minor.yy512, *(yymsp[0].minor.yy418));
                                                objectForTokens = yygotominor.yy246;
                                            }
        break;
      case 121: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
      case 122: /* tcons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==122);
      case 123: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB */ yytestcase(yyruleno==123);
{
                                                yygotominor.yy246 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy246->initFk(
                                                    *(yymsp[-6].minor.yy223),
                                                    *(yymsp[-3].minor.yy319),
                                                    *(yymsp[-2].minor.yy223),
                                                    *(yymsp[-1].minor.yy584),
                                                    yymsp[0].minor.yy9->initially,
                                                    yymsp[0].minor.yy9->deferrable
                                                );
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-1].minor.yy584;
                                                delete yymsp[0].minor.yy9;
                                                delete yymsp[-2].minor.yy223;
                                                delete yymsp[-6].minor.yy223;
                                                objectForTokens = yygotominor.yy246;
                                            }
        break;
      case 124: /* tcons ::= CHECK LP RP onconf */
{
                                                yygotominor.yy246 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy246->initCheck();
                                                objectForTokens = yygotominor.yy246;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                              yy_destructor(yypParser,223,&yymsp[0].minor);
}
        break;
      case 125: /* defer_subclause_opt ::= */
{yygotominor.yy9 = new ParserDeferSubClause(SqliteDeferrable::null, SqliteInitially::null);}
        break;
      case 126: /* defer_subclause_opt ::= defer_subclause */
{yygotominor.yy9 = yymsp[0].minor.yy9;}
        break;
      case 127: /* onconf ::= */
      case 129: /* orconf ::= */ yytestcase(yyruleno==129);
{yygotominor.yy418 = new SqliteConflictAlgo(SqliteConflictAlgo::null);}
        break;
      case 128: /* onconf ::= ON CONFLICT resolvetype */
      case 130: /* orconf ::= OR resolvetype */ yytestcase(yyruleno==130);
{yygotominor.yy418 = yymsp[0].minor.yy418;}
        break;
      case 131: /* resolvetype ::= raisetype */
      case 132: /* resolvetype ::= IGNORE */ yytestcase(yyruleno==132);
      case 133: /* resolvetype ::= REPLACE */ yytestcase(yyruleno==133);
{yygotominor.yy418 = new SqliteConflictAlgo(sqliteConflictAlgo(yymsp[0].minor.yy0->value));}
        break;
      case 134: /* cmd ::= DROP TABLE ifexists fullname */
{
                                                yygotominor.yy363 = new SqliteDropTable(*(yymsp[-1].minor.yy611), yymsp[0].minor.yy440->name1, yymsp[0].minor.yy440->name2);
                                                delete yymsp[-1].minor.yy611;
                                                delete yymsp[0].minor.yy440;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 135: /* cmd ::= DROP TABLE ifexists nm DOT ID_TAB */
      case 136: /* cmd ::= DROP TABLE ifexists ID_DB|ID_TAB */ yytestcase(yyruleno==136);
      case 143: /* cmd ::= DROP VIEW ifexists nm DOT ID_VIEW */ yytestcase(yyruleno==143);
      case 144: /* cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW */ yytestcase(yyruleno==144);
      case 187: /* singlesrc ::= nm DOT ID_TAB */ yytestcase(yyruleno==187);
      case 188: /* singlesrc ::= ID_DB|ID_TAB */ yytestcase(yyruleno==188);
      case 189: /* singlesrc ::= nm DOT ID_VIEW */ yytestcase(yyruleno==189);
      case 190: /* singlesrc ::= ID_DB|ID_VIEW */ yytestcase(yyruleno==190);
      case 331: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW */ yytestcase(yyruleno==331);
      case 332: /* cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW */ yytestcase(yyruleno==332);
      case 345: /* cmd ::= DROP INDEX ifexists nm DOT ID_IDX */ yytestcase(yyruleno==345);
      case 346: /* cmd ::= DROP INDEX ifexists ID_DB|ID_IDX */ yytestcase(yyruleno==346);
      case 356: /* cmd ::= PRAGMA nm DOT ID_PRAGMA */ yytestcase(yyruleno==356);
      case 357: /* cmd ::= PRAGMA ID_DB|ID_PRAGMA */ yytestcase(yyruleno==357);
      case 395: /* cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG */ yytestcase(yyruleno==395);
      case 396: /* cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG */ yytestcase(yyruleno==396);
      case 406: /* cmd ::= REINDEX nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==406);
      case 407: /* cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==407);
      case 410: /* cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==410);
      case 411: /* cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==411);
      case 415: /* cmd ::= ALTER TABLE nm DOT ID_TAB */ yytestcase(yyruleno==415);
      case 416: /* cmd ::= ALTER TABLE ID_DB|ID_TAB */ yytestcase(yyruleno==416);
      case 422: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW */ yytestcase(yyruleno==422);
      case 423: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW */ yytestcase(yyruleno==423);
{  yy_destructor(yypParser,199,&yymsp[-2].minor);
}
        break;
      case 139: /* cmd ::= CREATE temp VIEW ifnotexists fullname idxlist_opt AS select */
{
                                                yygotominor.yy363 = new SqliteCreateView(*(yymsp[-6].minor.yy386), *(yymsp[-4].minor.yy611), yymsp[-3].minor.yy440->name1, yymsp[-3].minor.yy440->name2, yymsp[0].minor.yy313, *(yymsp[-2].minor.yy223));
                                                delete yymsp[-6].minor.yy386;
                                                delete yymsp[-4].minor.yy611;
                                                delete yymsp[-3].minor.yy440;
                                                delete yymsp[-2].minor.yy223;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 142: /* cmd ::= DROP VIEW ifexists fullname */
{
                                                yygotominor.yy363 = new SqliteDropView(*(yymsp[-1].minor.yy611), yymsp[0].minor.yy440->name1, yymsp[0].minor.yy440->name2);
                                                delete yymsp[-1].minor.yy611;
                                                delete yymsp[0].minor.yy440;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 145: /* cmd ::= select_stmt */
      case 226: /* cmd ::= delete_stmt */ yytestcase(yyruleno==226);
      case 235: /* cmd ::= update_stmt */ yytestcase(yyruleno==235);
      case 256: /* cmd ::= insert_stmt */ yytestcase(yyruleno==256);
{
                                                yygotominor.yy363 = yymsp[0].minor.yy363;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 146: /* select_stmt ::= select */
{
                                                yygotominor.yy363 = yymsp[0].minor.yy313;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 147: /* select ::= with selectnowith */
{
                                                yygotominor.yy313 = yymsp[0].minor.yy313;
                                                yymsp[0].minor.yy313->setWith(yymsp[-1].minor.yy1);
                                                objectForTokens = yygotominor.yy313;
                                            }
        break;
      case 148: /* selectnowith ::= oneselect */
{
                                                yygotominor.yy313 = SqliteSelect::append(yymsp[0].minor.yy470);
                                                objectForTokens = yygotominor.yy313;
                                            }
        break;
      case 149: /* selectnowith ::= selectnowith multiselect_op oneselect */
{
                                                yygotominor.yy313 = SqliteSelect::append(yymsp[-2].minor.yy313, *(yymsp[-1].minor.yy382), yymsp[0].minor.yy470);
                                                delete yymsp[-1].minor.yy382;
                                                objectForTokens = yygotominor.yy313;
                                            }
        break;
      case 150: /* selectnowith ::= values */
{
                                                yygotominor.yy313 = SqliteSelect::append(*(yymsp[0].minor.yy486));
                                                delete yymsp[0].minor.yy486;
                                                objectForTokens = yygotominor.yy313;
                                            }
        break;
      case 151: /* selectnowith ::= selectnowith COMMA values */
{
                                                yygotominor.yy313 = SqliteSelect::append(yymsp[-2].minor.yy313, SqliteSelect::CompoundOperator::UNION_ALL, *(yymsp[0].minor.yy486));
                                                delete yymsp[0].minor.yy486;
                                                objectForTokens = yygotominor.yy313;
                                            }
        break;
      case 152: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
{
                                                yygotominor.yy470 = new SqliteSelect::Core(
                                                        *(yymsp[-7].minor.yy386),
                                                        *(yymsp[-6].minor.yy53),
                                                        yymsp[-5].minor.yy31,
                                                        yymsp[-4].minor.yy512,
                                                        *(yymsp[-3].minor.yy71),
                                                        yymsp[-2].minor.yy512,
                                                        *(yymsp[-1].minor.yy403),
                                                        yymsp[0].minor.yy4
                                                    );
                                                delete yymsp[-6].minor.yy53;
                                                delete yymsp[-7].minor.yy386;
                                                delete yymsp[-3].minor.yy71;
                                                delete yymsp[-1].minor.yy403;
                                                objectForTokens = yygotominor.yy470;
                                            }
        break;
      case 153: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt window_clause orderby_opt limit_opt */
{
                                                yygotominor.yy470 = new SqliteSelect::Core(
                                                        *(yymsp[-8].minor.yy386),
                                                        *(yymsp[-7].minor.yy53),
                                                        yymsp[-6].minor.yy31,
                                                        yymsp[-5].minor.yy512,
                                                        *(yymsp[-4].minor.yy71),
                                                        yymsp[-3].minor.yy512,
														*(yymsp[-2].minor.yy299),
                                                        *(yymsp[-1].minor.yy403),
                                                        yymsp[0].minor.yy4
                                                    );
                                                delete yymsp[-7].minor.yy53;
                                                delete yymsp[-8].minor.yy386;
                                                delete yymsp[-4].minor.yy71;
                                                delete yymsp[-1].minor.yy403;
												delete yymsp[-2].minor.yy299;
                                                objectForTokens = yygotominor.yy470;
											}
        break;
      case 154: /* values ::= VALUES LP nexprlist RP */
{
                                                yygotominor.yy486 = new ParserExprNestedList();
                                                yygotominor.yy486->append(*(yymsp[-1].minor.yy71));
                                                delete yymsp[-1].minor.yy71;
                                            }
        break;
      case 155: /* values ::= values COMMA LP exprlist RP */
{
                                                yymsp[-4].minor.yy486->append(*(yymsp[-1].minor.yy71));
                                                yygotominor.yy486 = yymsp[-4].minor.yy486;
                                                delete yymsp[-1].minor.yy71;
                                                DONT_INHERIT_TOKENS("values");
                                            }
        break;
      case 156: /* multiselect_op ::= UNION */
{yygotominor.yy382 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION);}
        break;
      case 157: /* multiselect_op ::= UNION ALL */
{yygotominor.yy382 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION_ALL);}
        break;
      case 158: /* multiselect_op ::= EXCEPT */
{yygotominor.yy382 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::EXCEPT);}
        break;
      case 159: /* multiselect_op ::= INTERSECT */
{yygotominor.yy382 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::INTERSECT);}
        break;
      case 160: /* distinct ::= DISTINCT */
{yygotominor.yy386 = new int(1);}
        break;
      case 161: /* distinct ::= ALL */
{yygotominor.yy386 = new int(2);}
        break;
      case 163: /* sclp ::= selcollist COMMA */
{yygotominor.yy53 = yymsp[-1].minor.yy53;}
        break;
      case 164: /* sclp ::= */
{yygotominor.yy53 = new ParserResultColumnList();}
        break;
      case 165: /* selcollist ::= sclp expr as */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        yymsp[-1].minor.yy512,
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->asKw : false,
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->name : QString()
                                                    );

                                                yymsp[-2].minor.yy53->append(obj);
                                                yygotominor.yy53 = yymsp[-2].minor.yy53;
                                                delete yymsp[0].minor.yy200;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 166: /* selcollist ::= sclp STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(true);

                                                yymsp[-1].minor.yy53->append(obj);
                                                yygotominor.yy53 = yymsp[-1].minor.yy53;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 167: /* selcollist ::= sclp tnm DOT STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        true,
                                                        yymsp[-2].minor.yy590->toName()
                                                    );
													
												if (!yymsp[-2].minor.yy590->isName())
													parserContext->errorAtToken("Syntax error <expected name, not literal value>", -3);
													
                                                yymsp[-3].minor.yy53->append(obj);
                                                yygotominor.yy53 = yymsp[-3].minor.yy53;
                                                delete yymsp[-2].minor.yy590;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 168: /* selcollist ::= sclp */
      case 169: /* selcollist ::= sclp ID_TAB DOT STAR */ yytestcase(yyruleno==169);
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy53 = yymsp[0].minor.yy53;
                                            }
        break;
      case 170: /* as ::= AS nm */
{
                                                yygotominor.yy200 = new ParserStubAlias(*(yymsp[0].minor.yy319), true);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 171: /* as ::= ids */
      case 172: /* as ::= AS ID_ALIAS */ yytestcase(yyruleno==172);
      case 173: /* as ::= ID_ALIAS */ yytestcase(yyruleno==173);
{
                                                yygotominor.yy200 = new ParserStubAlias(*(yymsp[0].minor.yy319), false);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 174: /* as ::= */
{yygotominor.yy200 = nullptr;}
        break;
      case 175: /* from ::= */
{yygotominor.yy31 = nullptr;}
        break;
      case 176: /* from ::= FROM joinsrc */
{yygotominor.yy31 = yymsp[0].minor.yy31;}
        break;
      case 177: /* joinsrc ::= singlesrc seltablist */
{
                                                yygotominor.yy31 = new SqliteSelect::Core::JoinSource(
                                                        yymsp[-1].minor.yy441,
                                                        *(yymsp[0].minor.yy451)
                                                    );
                                                delete yymsp[0].minor.yy451;
                                                objectForTokens = yygotominor.yy31;
                                            }
        break;
      case 178: /* joinsrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy31 = new SqliteSelect::Core::JoinSource();
                                                objectForTokens = yygotominor.yy31;
                                            }
        break;
      case 179: /* seltablist ::= seltablist joinop singlesrc joinconstr_opt */
{
                                                SqliteSelect::Core::JoinSourceOther* src =
                                                    new SqliteSelect::Core::JoinSourceOther(yymsp[-2].minor.yy221, yymsp[-1].minor.yy441, yymsp[0].minor.yy295);

                                                yymsp[-3].minor.yy451->append(src);
                                                yygotominor.yy451 = yymsp[-3].minor.yy451;
                                                objectForTokens = src;
                                                DONT_INHERIT_TOKENS("seltablist");
                                            }
        break;
      case 180: /* seltablist ::= */
{
                                                yygotominor.yy451 = new ParserOtherSourceList();
                                            }
        break;
      case 181: /* singlesrc ::= nm dbnm as indexed_opt */
{
                                                yygotominor.yy441 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-3].minor.yy319),
                                                        *(yymsp[-2].minor.yy319),
                                                        yymsp[-1].minor.yy200 ? yymsp[-1].minor.yy200->asKw : false,
                                                        yymsp[-1].minor.yy200 ? yymsp[-1].minor.yy200->name : QString(),
                                                        yymsp[0].minor.yy592 ? yymsp[0].minor.yy592->notIndexedKw : false,
                                                        yymsp[0].minor.yy592 ? yymsp[0].minor.yy592->indexedBy : QString()
                                                    );
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[-1].minor.yy200;
                                                if (yymsp[0].minor.yy592)
                                                    delete yymsp[0].minor.yy592;
                                                objectForTokens = yygotominor.yy441;
                                            }
        break;
      case 182: /* singlesrc ::= LP select RP as */
{
                                                yygotominor.yy441 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy313,
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->asKw : false,
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->name : QString()
                                                    );
                                                delete yymsp[0].minor.yy200;
                                                objectForTokens = yygotominor.yy441;
                                            }
        break;
      case 183: /* singlesrc ::= LP joinsrc RP as */
{
                                                yygotominor.yy441 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy31,
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->asKw : false,
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->name : QString()
                                                    );
                                                delete yymsp[0].minor.yy200;
                                                objectForTokens = yygotominor.yy441;
                                            }
        break;
      case 184: /* singlesrc ::= nm dbnm LP exprlist RP as */
{
                                                yygotominor.yy441 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-5].minor.yy319),
                                                        *(yymsp[-4].minor.yy319),
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->asKw : false,
                                                        yymsp[0].minor.yy200 ? yymsp[0].minor.yy200->name : QString(),
                                                        *(yymsp[-2].minor.yy71)
                                                    );
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-4].minor.yy319;
                                                delete yymsp[0].minor.yy200;
                                                if (yymsp[-2].minor.yy71)
                                                    delete yymsp[-2].minor.yy71;

                                                objectForTokens = yygotominor.yy441;
                                            }
        break;
      case 185: /* singlesrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy441 = new SqliteSelect::Core::SingleSource();
                                                objectForTokens = yygotominor.yy441;
                                            }
        break;
      case 186: /* singlesrc ::= nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy441 = new SqliteSelect::Core::SingleSource();
                                                yygotominor.yy441->database = *(yymsp[-1].minor.yy319);
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy441;
                                            }
        break;
      case 191: /* joinconstr_opt ::= ON expr */
{
                                                yygotominor.yy295 = new SqliteSelect::Core::JoinConstraint(yymsp[0].minor.yy512);
                                                objectForTokens = yygotominor.yy295;
                                            }
        break;
      case 192: /* joinconstr_opt ::= USING LP idlist RP */
{
                                                yygotominor.yy295 = new SqliteSelect::Core::JoinConstraint(*(yymsp[-1].minor.yy575));
                                                delete yymsp[-1].minor.yy575;
                                                objectForTokens = yygotominor.yy295;
                                            }
        break;
      case 193: /* joinconstr_opt ::= */
{yygotominor.yy295 = nullptr;}
        break;
      case 196: /* fullname ::= nm dbnm */
{
                                                yygotominor.yy440 = new ParserFullName();
                                                yygotominor.yy440->name1 = *(yymsp[-1].minor.yy319);
                                                yygotominor.yy440->name2 = *(yymsp[0].minor.yy319);
                                                delete yymsp[-1].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 197: /* joinop ::= COMMA */
{
                                                yygotominor.yy221 = new SqliteSelect::Core::JoinOp(true);
                                                objectForTokens = yygotominor.yy221;
                                            }
        break;
      case 198: /* joinop ::= JOIN */
{
                                                yygotominor.yy221 = new SqliteSelect::Core::JoinOp(false);
                                                objectForTokens = yygotominor.yy221;
                                            }
        break;
      case 199: /* joinop ::= JOIN_KW JOIN */
{
                                                yygotominor.yy221 = new SqliteSelect::Core::JoinOp(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy221;
                                            }
        break;
      case 200: /* joinop ::= JOIN_KW nm JOIN */
{
                                                yygotominor.yy221 = new SqliteSelect::Core::JoinOp(yymsp[-2].minor.yy0->value, *(yymsp[-1].minor.yy319));
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy221;
                                            }
        break;
      case 201: /* joinop ::= JOIN_KW nm nm JOIN */
      case 202: /* joinop ::= ID_JOIN_OPTS */ yytestcase(yyruleno==202);
{
                                                yygotominor.yy221 = new SqliteSelect::Core::JoinOp(yymsp[-3].minor.yy0->value, *(yymsp[-2].minor.yy319), *(yymsp[-1].minor.yy319));
                                                delete yymsp[-2].minor.yy319;
                                                objectForTokens = yygotominor.yy221;
                                            }
        break;
      case 203: /* indexed_opt ::= */
{yygotominor.yy592 = nullptr;}
        break;
      case 204: /* indexed_opt ::= INDEXED BY nm */
{
                                                yygotominor.yy592 = new ParserIndexedBy(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 205: /* indexed_opt ::= NOT INDEXED */
      case 206: /* indexed_opt ::= INDEXED BY ID_IDX */ yytestcase(yyruleno==206);
{yygotominor.yy592 = new ParserIndexedBy(true);}
        break;
      case 207: /* orderby_opt ::= */
{yygotominor.yy403 = new ParserOrderByList();}
        break;
      case 208: /* orderby_opt ::= ORDER BY sortlist */
{yygotominor.yy403 = yymsp[0].minor.yy403;}
        break;
      case 209: /* sortlist ::= sortlist COMMA expr sortorder nulls */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-2].minor.yy512, *(yymsp[-1].minor.yy549), *(yymsp[0].minor.yy579));
                                                yymsp[-4].minor.yy403->append(obj);
                                                yygotominor.yy403 = yymsp[-4].minor.yy403;
                                                delete yymsp[-1].minor.yy549;
												delete yymsp[0].minor.yy579;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sortlist");
                                            }
        break;
      case 210: /* sortlist ::= expr sortorder nulls */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-2].minor.yy512, *(yymsp[-1].minor.yy549), *(yymsp[0].minor.yy579));
                                                yygotominor.yy403 = new ParserOrderByList();
                                                yygotominor.yy403->append(obj);
                                                delete yymsp[-1].minor.yy549;
												delete yymsp[0].minor.yy579;
                                                objectForTokens = obj;
                                            }
        break;
      case 211: /* sortorder ::= ASC */
{yygotominor.yy549 = new SqliteSortOrder(SqliteSortOrder::ASC);}
        break;
      case 212: /* sortorder ::= DESC */
{yygotominor.yy549 = new SqliteSortOrder(SqliteSortOrder::DESC);}
        break;
      case 213: /* sortorder ::= */
{yygotominor.yy549 = new SqliteSortOrder(SqliteSortOrder::null);}
        break;
      case 214: /* nulls ::= NULLS FIRST */
{yygotominor.yy579 = new SqliteNulls(SqliteNulls::FIRST);}
        break;
      case 215: /* nulls ::= NULLS LAST */
{yygotominor.yy579 = new SqliteNulls(SqliteNulls::LAST);}
        break;
      case 216: /* nulls ::= */
{yygotominor.yy579 = new SqliteNulls(SqliteNulls::null);}
        break;
      case 217: /* groupby_opt ::= */
      case 326: /* exprlist ::= */ yytestcase(yyruleno==326);
{yygotominor.yy71 = new ParserExprList();}
        break;
      case 218: /* groupby_opt ::= GROUP BY nexprlist */
      case 325: /* exprlist ::= nexprlist */ yytestcase(yyruleno==325);
{yygotominor.yy71 = yymsp[0].minor.yy71;}
        break;
      case 219: /* groupby_opt ::= GROUP BY */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy71 = new ParserExprList();
                                            }
        break;
      case 220: /* having_opt ::= */
      case 232: /* where_opt ::= */ yytestcase(yyruleno==232);
      case 322: /* case_else ::= */ yytestcase(yyruleno==322);
      case 324: /* case_operand ::= */ yytestcase(yyruleno==324);
      case 350: /* vinto ::= */ yytestcase(yyruleno==350);
      case 384: /* when_clause ::= */ yytestcase(yyruleno==384);
      case 399: /* key_opt ::= */ yytestcase(yyruleno==399);
{yygotominor.yy512 = nullptr;}
        break;
      case 221: /* having_opt ::= HAVING expr */
      case 233: /* where_opt ::= WHERE expr */ yytestcase(yyruleno==233);
      case 315: /* expr ::= exprx */ yytestcase(yyruleno==315);
      case 321: /* case_else ::= ELSE expr */ yytestcase(yyruleno==321);
      case 323: /* case_operand ::= exprx */ yytestcase(yyruleno==323);
      case 349: /* vinto ::= INTO expr */ yytestcase(yyruleno==349);
      case 385: /* when_clause ::= WHEN expr */ yytestcase(yyruleno==385);
      case 400: /* key_opt ::= KEY expr */ yytestcase(yyruleno==400);
{yygotominor.yy512 = yymsp[0].minor.yy512;}
        break;
      case 222: /* limit_opt ::= */
{yygotominor.yy4 = nullptr;}
        break;
      case 223: /* limit_opt ::= LIMIT expr */
{
                                                yygotominor.yy4 = new SqliteLimit(yymsp[0].minor.yy512);
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 224: /* limit_opt ::= LIMIT expr OFFSET expr */
{
                                                yygotominor.yy4 = new SqliteLimit(yymsp[-2].minor.yy512, yymsp[0].minor.yy512, true);
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 225: /* limit_opt ::= LIMIT expr COMMA expr */
{
                                                yygotominor.yy4 = new SqliteLimit(yymsp[-2].minor.yy512, yymsp[0].minor.yy512, false);
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 227: /* delete_stmt ::= with DELETE FROM fullname indexed_opt where_opt */
{
                                                if (yymsp[-1].minor.yy592)
                                                {
                                                    if (!yymsp[-1].minor.yy592->indexedBy.isNull())
                                                    {
                                                        yygotominor.yy363 = new SqliteDelete(
                                                                yymsp[-2].minor.yy440->name1,
                                                                yymsp[-2].minor.yy440->name2,
                                                                yymsp[-1].minor.yy592->indexedBy,
                                                                yymsp[0].minor.yy512,
                                                                yymsp[-5].minor.yy1
                                                            );
                                                    }
                                                    else
                                                    {
                                                        yygotominor.yy363 = new SqliteDelete(
                                                                yymsp[-2].minor.yy440->name1,
                                                                yymsp[-2].minor.yy440->name2,
                                                                yymsp[-1].minor.yy592->notIndexedKw,
                                                                yymsp[0].minor.yy512,
                                                                yymsp[-5].minor.yy1
                                                            );
                                                    }
                                                    delete yymsp[-1].minor.yy592;
                                                }
                                                else
                                                {
                                                    yygotominor.yy363 = new SqliteDelete(
                                                            yymsp[-2].minor.yy440->name1,
                                                            yymsp[-2].minor.yy440->name2,
                                                            false,
                                                            yymsp[0].minor.yy512,
                                                            yymsp[-5].minor.yy1
                                                        );
                                                }
                                                delete yymsp[-2].minor.yy440;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 228: /* delete_stmt ::= with DELETE FROM */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-2].minor.yy1;
                                                yygotominor.yy363 = q;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 229: /* delete_stmt ::= with DELETE FROM nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-4].minor.yy1;
                                                q->database = *(yymsp[-1].minor.yy319);
                                                yygotominor.yy363 = q;
                                                objectForTokens = yygotominor.yy363;
                                                delete yymsp[-1].minor.yy319;
                                            }
        break;
      case 230: /* delete_stmt ::= with DELETE FROM nm DOT ID_TAB */
      case 239: /* update_stmt ::= with UPDATE orconf nm DOT ID_TAB */ yytestcase(yyruleno==239);
{  yy_destructor(yypParser,244,&yymsp[-5].minor);
  yy_destructor(yypParser,199,&yymsp[-2].minor);
}
        break;
      case 231: /* delete_stmt ::= with DELETE FROM ID_DB|ID_TAB */
      case 240: /* update_stmt ::= with UPDATE orconf ID_DB|ID_TAB */ yytestcase(yyruleno==240);
{  yy_destructor(yypParser,244,&yymsp[-3].minor);
}
        break;
      case 234: /* where_opt ::= WHERE */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy512 = new SqliteExpr();
                                            }
        break;
      case 236: /* update_stmt ::= with UPDATE orconf fullname indexed_opt SET setlist from where_opt */
{
                                                yygotominor.yy363 = new SqliteUpdate(
                                                        *(yymsp[-6].minor.yy418),
                                                        yymsp[-5].minor.yy440->name1,
                                                        yymsp[-5].minor.yy440->name2,
                                                        yymsp[-4].minor.yy592 ? yymsp[-4].minor.yy592->notIndexedKw : false,
                                                        yymsp[-4].minor.yy592 ? yymsp[-4].minor.yy592->indexedBy : QString(),
                                                        *(yymsp[-2].minor.yy201),
														yymsp[-1].minor.yy31,
                                                        yymsp[0].minor.yy512,
                                                        yymsp[-8].minor.yy1
                                                    );
                                                delete yymsp[-6].minor.yy418;
                                                delete yymsp[-5].minor.yy440;
                                                delete yymsp[-2].minor.yy201;
                                                if (yymsp[-4].minor.yy592)
                                                    delete yymsp[-4].minor.yy592;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 237: /* update_stmt ::= with UPDATE orconf */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-2].minor.yy1;
                                                yygotominor.yy363 = q;
                                                objectForTokens = yygotominor.yy363;
                                                delete yymsp[0].minor.yy418;
                                            }
        break;
      case 238: /* update_stmt ::= with UPDATE orconf nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-4].minor.yy1;
                                                q->database = *(yymsp[-1].minor.yy319);
                                                yygotominor.yy363 = q;
                                                objectForTokens = yygotominor.yy363;
                                                delete yymsp[-2].minor.yy418;
                                                delete yymsp[-1].minor.yy319;
                                            }
        break;
      case 241: /* setlist ::= setlist COMMA nm EQ expr */
{
                                                yymsp[-4].minor.yy201->append(ParserSetValue(*(yymsp[-2].minor.yy319), yymsp[0].minor.yy512));
                                                yygotominor.yy201 = yymsp[-4].minor.yy201;
                                                delete yymsp[-2].minor.yy319;
                                            }
        break;
      case 242: /* setlist ::= setlist COMMA LP idlist RP EQ expr */
{
                                                yymsp[-6].minor.yy201->append(ParserSetValue(*(yymsp[-3].minor.yy575), yymsp[0].minor.yy512));
                                                yygotominor.yy201 = yymsp[-6].minor.yy201;
                                                delete yymsp[-3].minor.yy575;
                                            }
        break;
      case 243: /* setlist ::= nm EQ expr */
{
                                                yygotominor.yy201 = new ParserSetValueList();
                                                yygotominor.yy201->append(ParserSetValue(*(yymsp[-2].minor.yy319), yymsp[0].minor.yy512));
                                                delete yymsp[-2].minor.yy319;
                                            }
        break;
      case 244: /* setlist ::= LP idlist RP EQ expr */
{
                                                yygotominor.yy201 = new ParserSetValueList();
                                                yygotominor.yy201->append(ParserSetValue(*(yymsp[-3].minor.yy575), yymsp[0].minor.yy512));
                                                delete yymsp[-3].minor.yy575;
                                            }
        break;
      case 245: /* setlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy201 = new ParserSetValueList();
                                            }
        break;
      case 246: /* setlist ::= setlist COMMA */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy201 = yymsp[-1].minor.yy201;
                                            }
        break;
      case 247: /* setlist ::= setlist COMMA ID_COL */
      case 248: /* setlist ::= ID_COL */ yytestcase(yyruleno==248);
{  yy_destructor(yypParser,274,&yymsp[-2].minor);
}
        break;
      case 249: /* idlist_opt ::= */
{yygotominor.yy575 = new QStringList();}
        break;
      case 250: /* idlist_opt ::= LP idlist RP */
{yygotominor.yy575 = yymsp[-1].minor.yy575;}
        break;
      case 251: /* idlist ::= idlist COMMA nm */
{
                                                yygotominor.yy575 = yymsp[-2].minor.yy575;
                                                *(yygotominor.yy575) << *(yymsp[0].minor.yy319);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 252: /* idlist ::= nm */
{
                                                yygotominor.yy575 = new QStringList();
                                                *(yygotominor.yy575) << *(yymsp[0].minor.yy319);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 253: /* idlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy575 = new QStringList();
                                            }
        break;
      case 254: /* idlist ::= idlist COMMA ID_COL */
      case 255: /* idlist ::= ID_COL */ yytestcase(yyruleno==255);
{  yy_destructor(yypParser,269,&yymsp[-2].minor);
}
        break;
      case 257: /* insert_stmt ::= with insert_cmd INTO fullname idlist_opt select upsert */
{
                                                yygotominor.yy363 = new SqliteInsert(
                                                        yymsp[-5].minor.yy504->replace,
                                                        yymsp[-5].minor.yy504->orConflict,
                                                        yymsp[-3].minor.yy440->name1,
                                                        yymsp[-3].minor.yy440->name2,
                                                        *(yymsp[-2].minor.yy575),
                                                        yymsp[-1].minor.yy313,
                                                        yymsp[-6].minor.yy1,
                                                        yymsp[0].minor.yy400
                                                    );
                                                delete yymsp[-3].minor.yy440;
                                                delete yymsp[-5].minor.yy504;
                                                delete yymsp[-2].minor.yy575;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 258: /* insert_stmt ::= with insert_cmd INTO fullname idlist_opt DEFAULT VALUES */
{
                                                yygotominor.yy363 = new SqliteInsert(
                                                        yymsp[-5].minor.yy504->replace,
                                                        yymsp[-5].minor.yy504->orConflict,
                                                        yymsp[-3].minor.yy440->name1,
                                                        yymsp[-3].minor.yy440->name2,
                                                        *(yymsp[-2].minor.yy575),
                                                        yymsp[-6].minor.yy1
                                                    );
                                                delete yymsp[-3].minor.yy440;
                                                delete yymsp[-5].minor.yy504;
                                                delete yymsp[-2].minor.yy575;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 259: /* insert_stmt ::= with insert_cmd INTO */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-1].minor.yy504->replace;
                                                q->onConflict = yymsp[-1].minor.yy504->orConflict;
                                                q->with = yymsp[-2].minor.yy1;
                                                yygotominor.yy363 = q;
                                                objectForTokens = yygotominor.yy363;
                                                delete yymsp[-1].minor.yy504;
                                            }
        break;
      case 260: /* insert_stmt ::= with insert_cmd INTO nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-3].minor.yy504->replace;
                                                q->onConflict = yymsp[-3].minor.yy504->orConflict;
                                                q->with = yymsp[-4].minor.yy1;
                                                q->database = *(yymsp[-1].minor.yy319);
                                                yygotominor.yy363 = q;
                                                objectForTokens = yygotominor.yy363;
                                                delete yymsp[-3].minor.yy504;
                                                delete yymsp[-1].minor.yy319;
                                            }
        break;
      case 261: /* insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB */
{  yy_destructor(yypParser,244,&yymsp[-3].minor);
  yy_destructor(yypParser,277,&yymsp[-2].minor);
}
        break;
      case 262: /* insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB */
{  yy_destructor(yypParser,244,&yymsp[-5].minor);
  yy_destructor(yypParser,277,&yymsp[-4].minor);
  yy_destructor(yypParser,199,&yymsp[-2].minor);
}
        break;
      case 263: /* insert_cmd ::= INSERT orconf */
{
                                                yygotominor.yy504 = new ParserStubInsertOrReplace(false, *(yymsp[0].minor.yy418));
                                                delete yymsp[0].minor.yy418;
                                            }
        break;
      case 264: /* insert_cmd ::= REPLACE */
{yygotominor.yy504 = new ParserStubInsertOrReplace(true);}
        break;
      case 265: /* upsert ::= */
{
                                                yygotominor.yy400 = nullptr;
                                            }
        break;
      case 266: /* upsert ::= ON CONFLICT LP sortlist RP where_opt DO UPDATE SET setlist where_opt */
{
                                                yygotominor.yy400 = new SqliteUpsert(*(yymsp[-7].minor.yy403), yymsp[-5].minor.yy512, *(yymsp[-1].minor.yy201), yymsp[0].minor.yy512);
                                                delete yymsp[-7].minor.yy403;
                                                delete yymsp[-1].minor.yy201;
                                                objectForTokens = yygotominor.yy400;
                                            }
        break;
      case 267: /* upsert ::= ON CONFLICT LP sortlist RP where_opt DO NOTHING */
{
                                                yygotominor.yy400 = new SqliteUpsert(*(yymsp[-4].minor.yy403), yymsp[-2].minor.yy512);
                                                delete yymsp[-4].minor.yy403;
                                                objectForTokens = yygotominor.yy400;
                                            }
        break;
      case 268: /* upsert ::= ON CONFLICT DO NOTHING */
{
                                                yygotominor.yy400 = new SqliteUpsert();
                                                objectForTokens = yygotominor.yy400;
                                            }
        break;
      case 269: /* exprx ::= expr not_opt IN ID_DB */
{  yy_destructor(yypParser,222,&yymsp[-3].minor);
}
        break;
      case 270: /* exprx ::= expr not_opt IN nm DOT ID_TAB */
      case 271: /* exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN */ yytestcase(yyruleno==271);
{  yy_destructor(yypParser,222,&yymsp[-5].minor);
  yy_destructor(yypParser,199,&yymsp[-2].minor);
}
        break;
      case 272: /* exprx ::= tnm DOT ID_TAB|ID_COL */
{  yy_destructor(yypParser,230,&yymsp[-2].minor);
}
        break;
      case 273: /* exprx ::= tnm DOT nm DOT ID_COL */
{  yy_destructor(yypParser,230,&yymsp[-4].minor);
  yy_destructor(yypParser,199,&yymsp[-2].minor);
}
        break;
      case 274: /* exprx ::= expr COLLATE ID_COLLATE */
      case 275: /* exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP */ yytestcase(yyruleno==275);
{  yy_destructor(yypParser,222,&yymsp[-2].minor);
}
        break;
      case 276: /* exprx ::= CTIME_KW */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 277: /* exprx ::= LP nexprlist RP */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initRowValue(*(yymsp[-1].minor.yy71));
                                                delete yymsp[-1].minor.yy71;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 278: /* exprx ::= tnm */
{
                                                yygotominor.yy512 = new SqliteExpr();
												if (yymsp[0].minor.yy590->isLiteral())
													yygotominor.yy512->initLiteral(yymsp[0].minor.yy590->toLiteral());
												else
													yygotominor.yy512->initId(yymsp[0].minor.yy590->toName());
													//parserContext->errorBeforeLastToken("Syntax error <expected literal value>");

                                                delete yymsp[0].minor.yy590;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 279: /* exprx ::= tnm DOT nm */
{
                                                yygotominor.yy512 = new SqliteExpr();
												if (yymsp[-2].minor.yy590->isName())
													yygotominor.yy512->initId(yymsp[-2].minor.yy590->toName(), *(yymsp[0].minor.yy319));
												else
													parserContext->errorAtToken("Syntax error <expected name>", -3);

                                                delete yymsp[-2].minor.yy590;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 280: /* exprx ::= tnm DOT nm DOT nm */
{
                                                yygotominor.yy512 = new SqliteExpr();
												if (yymsp[-4].minor.yy590->isName())
													yygotominor.yy512->initId(yymsp[-4].minor.yy590->toName(), *(yymsp[-2].minor.yy319), *(yymsp[0].minor.yy319));
												else
													parserContext->errorAtToken("Syntax error <expected name>", -5);

                                                delete yymsp[-4].minor.yy590;
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 281: /* exprx ::= VARIABLE */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initBindParam(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 282: /* exprx ::= expr COLLATE ids */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initCollate(yymsp[-2].minor.yy512, *(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 283: /* exprx ::= CAST LP expr AS typetoken RP */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initCast(yymsp[-3].minor.yy512, yymsp[-1].minor.yy57);
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 284: /* exprx ::= ID LP distinct exprlist RP */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initFunction(yymsp[-4].minor.yy0->value, *(yymsp[-2].minor.yy386), *(yymsp[-1].minor.yy71));
                                                delete yymsp[-2].minor.yy386;
                                                delete yymsp[-1].minor.yy71;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 285: /* exprx ::= ID LP STAR RP */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initFunction(yymsp[-3].minor.yy0->value, true);
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 286: /* exprx ::= expr AND expr */
      case 287: /* exprx ::= expr OR expr */ yytestcase(yyruleno==287);
      case 288: /* exprx ::= expr LT|GT|GE|LE expr */ yytestcase(yyruleno==288);
      case 289: /* exprx ::= expr EQ|NE expr */ yytestcase(yyruleno==289);
      case 290: /* exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */ yytestcase(yyruleno==290);
      case 291: /* exprx ::= expr PLUS|MINUS expr */ yytestcase(yyruleno==291);
      case 292: /* exprx ::= expr STAR|SLASH|REM expr */ yytestcase(yyruleno==292);
      case 293: /* exprx ::= expr CONCAT expr */ yytestcase(yyruleno==293);
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initBinOp(yymsp[-2].minor.yy512, yymsp[-1].minor.yy0->value, yymsp[0].minor.yy512);
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 294: /* exprx ::= expr not_opt likeop expr */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initLike(yymsp[-3].minor.yy512, *(yymsp[-2].minor.yy611), *(yymsp[-1].minor.yy40), yymsp[0].minor.yy512);
                                                delete yymsp[-2].minor.yy611;
                                                delete yymsp[-1].minor.yy40;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 295: /* exprx ::= expr not_opt likeop expr ESCAPE expr */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initLike(yymsp[-5].minor.yy512, *(yymsp[-4].minor.yy611), *(yymsp[-3].minor.yy40), yymsp[-2].minor.yy512, yymsp[0].minor.yy512);
                                                delete yymsp[-4].minor.yy611;
                                                delete yymsp[-3].minor.yy40;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 296: /* exprx ::= expr ISNULL|NOTNULL */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initNull(yymsp[-1].minor.yy512, yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 297: /* exprx ::= expr NOT NULL */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initNull(yymsp[-2].minor.yy512, "NOT NULL");
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 298: /* exprx ::= expr IS not_opt expr */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initIs(yymsp[-3].minor.yy512, *(yymsp[-1].minor.yy611), yymsp[0].minor.yy512);
                                                delete yymsp[-1].minor.yy611;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 299: /* exprx ::= NOT expr */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initUnaryOp(yymsp[0].minor.yy512, yymsp[-1].minor.yy0->value);
                                            }
        break;
      case 300: /* exprx ::= BITNOT expr */
      case 302: /* exprx ::= PLUS expr */ yytestcase(yyruleno==302);
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initUnaryOp(yymsp[0].minor.yy512, yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 301: /* exprx ::= MINUS expr */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                if (yymsp[0].minor.yy512->mode == SqliteExpr::Mode::LITERAL_VALUE &&
                                                    parserContext->isCandidateForMaxNegativeNumber() &&
                                                    yymsp[0].minor.yy512->literalValue == static_cast<qint64>(0L))
                                                {
                                                    yygotominor.yy512->initLiteral(std::numeric_limits<qint64>::min());
                                                    delete yymsp[0].minor.yy512;
                                                }
                                                else
                                                {
                                                    yygotominor.yy512->initUnaryOp(yymsp[0].minor.yy512, yymsp[-1].minor.yy0->value);
                                                }
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 303: /* exprx ::= expr not_opt BETWEEN expr AND expr */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initBetween(yymsp[-5].minor.yy512, *(yymsp[-4].minor.yy611), yymsp[-2].minor.yy512, yymsp[0].minor.yy512);
                                                delete yymsp[-4].minor.yy611;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 304: /* exprx ::= expr not_opt IN LP exprlist RP */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initIn(yymsp[-5].minor.yy512, *(yymsp[-4].minor.yy611), *(yymsp[-1].minor.yy71));
                                                delete yymsp[-4].minor.yy611;
                                                delete yymsp[-1].minor.yy71;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 305: /* exprx ::= LP select RP */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initSubSelect(yymsp[-1].minor.yy313);
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 306: /* exprx ::= expr not_opt IN LP select RP */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initIn(yymsp[-5].minor.yy512, *(yymsp[-4].minor.yy611), yymsp[-1].minor.yy313);
                                                delete yymsp[-4].minor.yy611;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 307: /* exprx ::= expr not_opt IN nm dbnm */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initIn(yymsp[-4].minor.yy512, *(yymsp[-3].minor.yy611), *(yymsp[-1].minor.yy319), *(yymsp[0].minor.yy319));
                                                delete yymsp[-3].minor.yy611;
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 308: /* exprx ::= EXISTS LP select RP */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initExists(yymsp[-1].minor.yy313);
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 309: /* exprx ::= CASE case_operand case_exprlist case_else END */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initCase(yymsp[-3].minor.yy512, *(yymsp[-2].minor.yy71), yymsp[-1].minor.yy512);
                                                delete yymsp[-2].minor.yy71;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 310: /* exprx ::= RAISE LP IGNORE RP */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initRaise(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 311: /* exprx ::= RAISE LP raisetype COMMA nm RP */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initRaise(yymsp[-3].minor.yy0->value, *(yymsp[-1].minor.yy319));
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy512;
                                            }
        break;
      case 312: /* exprx ::= ID LP distinct exprlist RP filter_over */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initWindowFunction(yymsp[-5].minor.yy0->value, *(yymsp[-3].minor.yy386), *(yymsp[-2].minor.yy71), yymsp[0].minor.yy247);
                                                delete yymsp[-3].minor.yy386;
                                                delete yymsp[-2].minor.yy71;
                                                objectForTokens = yygotominor.yy512;
											}
        break;
      case 313: /* exprx ::= ID LP STAR RP filter_over */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                yygotominor.yy512->initWindowFunction(yymsp[-4].minor.yy0->value, yymsp[0].minor.yy247);
                                                objectForTokens = yygotominor.yy512;
											}
        break;
      case 314: /* expr ::= */
{
                                                yygotominor.yy512 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy512;
                                                parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                            }
        break;
      case 318: /* likeop ::= LIKE_KW|MATCH */
{yygotominor.yy40 = new SqliteExpr::LikeOp(SqliteExpr::likeOp(yymsp[0].minor.yy0->value));}
        break;
      case 319: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
{
                                                yymsp[-4].minor.yy71->append(yymsp[-2].minor.yy512);
                                                yymsp[-4].minor.yy71->append(yymsp[0].minor.yy512);
                                                yygotominor.yy71 = yymsp[-4].minor.yy71;
                                            }
        break;
      case 320: /* case_exprlist ::= WHEN expr THEN expr */
{
                                                yygotominor.yy71 = new ParserExprList();
                                                yygotominor.yy71->append(yymsp[-2].minor.yy512);
                                                yygotominor.yy71->append(yymsp[0].minor.yy512);
                                            }
        break;
      case 327: /* nexprlist ::= nexprlist COMMA expr */
{
                                                yymsp[-2].minor.yy71->append(yymsp[0].minor.yy512);
                                                yygotominor.yy71 = yymsp[-2].minor.yy71;
                                                DONT_INHERIT_TOKENS("nexprlist");
                                            }
        break;
      case 328: /* nexprlist ::= exprx */
{
                                                yygotominor.yy71 = new ParserExprList();
                                                yygotominor.yy71->append(yymsp[0].minor.yy512);
                                            }
        break;
      case 329: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP sortlist RP where_opt */
{
                                                yygotominor.yy363 = new SqliteCreateIndex(
                                                        *(yymsp[-10].minor.yy611),
                                                        *(yymsp[-8].minor.yy611),
                                                        *(yymsp[-7].minor.yy319),
                                                        *(yymsp[-6].minor.yy319),
                                                        *(yymsp[-4].minor.yy319),
                                                        *(yymsp[-2].minor.yy403),
                                                        yymsp[0].minor.yy512
                                                    );
                                                delete yymsp[-8].minor.yy611;
                                                delete yymsp[-10].minor.yy611;
                                                delete yymsp[-7].minor.yy319;
                                                delete yymsp[-6].minor.yy319;
                                                delete yymsp[-4].minor.yy319;
                                                delete yymsp[-2].minor.yy403;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 330: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB */
{  yy_destructor(yypParser,199,&yymsp[-3].minor);
}
        break;
      case 335: /* idxlist_opt ::= */
{yygotominor.yy223 = new ParserIndexedColumnList();}
        break;
      case 336: /* idxlist_opt ::= LP idxlist RP */
{yygotominor.yy223 = yymsp[-1].minor.yy223;}
        break;
      case 337: /* idxlist ::= idxlist COMMA idxlist_single */
{
                                                yymsp[-2].minor.yy223->append(yymsp[0].minor.yy268);
                                                yygotominor.yy223 = yymsp[-2].minor.yy223;
                                                DONT_INHERIT_TOKENS("idxlist");
                                            }
        break;
      case 338: /* idxlist ::= idxlist_single */
{
                                                yygotominor.yy223 = new ParserIndexedColumnList();
                                                yygotominor.yy223->append(yymsp[0].minor.yy268);
                                            }
        break;
      case 339: /* idxlist_single ::= nm collate sortorder */
      case 340: /* idxlist_single ::= ID_COL */ yytestcase(yyruleno==340);
{
                                                SqliteIndexedColumn* obj =
                                                    new SqliteIndexedColumn(
                                                        *(yymsp[-2].minor.yy319),
                                                        *(yymsp[-1].minor.yy319),
                                                        *(yymsp[0].minor.yy549)
                                                    );
                                                yygotominor.yy268 = obj;
                                                delete yymsp[0].minor.yy549;
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy268;
                                            }
        break;
      case 344: /* cmd ::= DROP INDEX ifexists fullname */
{
                                                yygotominor.yy363 = new SqliteDropIndex(*(yymsp[-1].minor.yy611), yymsp[0].minor.yy440->name1, yymsp[0].minor.yy440->name2);
                                                delete yymsp[-1].minor.yy611;
                                                delete yymsp[0].minor.yy440;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 347: /* cmd ::= VACUUM vinto */
{
                                                yygotominor.yy363 = new SqliteVacuum(yymsp[0].minor.yy512);
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 348: /* cmd ::= VACUUM nm vinto */
{
                                                yygotominor.yy363 = new SqliteVacuum(*(yymsp[-1].minor.yy319), yymsp[0].minor.yy512);
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 351: /* cmd ::= PRAGMA nm dbnm */
{
                                                yygotominor.yy363 = new SqlitePragma(*(yymsp[-1].minor.yy319), *(yymsp[0].minor.yy319));
                                                delete yymsp[-1].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 352: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 354: /* cmd ::= PRAGMA nm dbnm EQ minus_num */ yytestcase(yyruleno==354);
{
                                                yygotominor.yy363 = new SqlitePragma(*(yymsp[-3].minor.yy319), *(yymsp[-2].minor.yy319), *(yymsp[0].minor.yy229), true);
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy229;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 353: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
      case 355: /* cmd ::= PRAGMA nm dbnm LP minus_num RP */ yytestcase(yyruleno==355);
{
                                                yygotominor.yy363 = new SqlitePragma(*(yymsp[-4].minor.yy319), *(yymsp[-3].minor.yy319), *(yymsp[-1].minor.yy229), false);
                                                delete yymsp[-4].minor.yy319;
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-1].minor.yy229;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 359: /* nmnum ::= nm */
{
                                                yygotominor.yy229 = new QVariant(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 360: /* nmnum ::= ON */
      case 361: /* nmnum ::= DELETE */ yytestcase(yyruleno==361);
      case 362: /* nmnum ::= DEFAULT */ yytestcase(yyruleno==362);
{yygotominor.yy229 = new QVariant(yymsp[0].minor.yy0->value);}
        break;
      case 365: /* minus_num ::= MINUS number */
{
                                                if (yymsp[0].minor.yy229->type() == QVariant::Double)
                                                    *(yymsp[0].minor.yy229) = -(yymsp[0].minor.yy229->toDouble());
                                                else if (yymsp[0].minor.yy229->type() == QVariant::LongLong)
                                                {
                                                    if (parserContext->isCandidateForMaxNegativeNumber())
                                                        *(yymsp[0].minor.yy229) = std::numeric_limits<qint64>::min();
                                                    else
                                                        *(yymsp[0].minor.yy229) = -(yymsp[0].minor.yy229->toLongLong());
                                                }
                                                else
                                                    Q_ASSERT_X(true, "producing minus number", "QVariant is neither of Double or LongLong.");

                                                yygotominor.yy229 = yymsp[0].minor.yy229;
                                            }
        break;
      case 368: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END */
{
                                                yygotominor.yy363 = new SqliteCreateTrigger(
                                                        *(yymsp[-13].minor.yy386),
                                                        *(yymsp[-11].minor.yy611),
                                                        *(yymsp[-10].minor.yy319),
                                                        *(yymsp[-9].minor.yy319),
                                                        *(yymsp[-5].minor.yy319),
                                                        *(yymsp[-8].minor.yy532),
                                                        yymsp[-7].minor.yy151,
                                                        *(yymsp[-4].minor.yy83),
                                                        yymsp[-3].minor.yy512,
                                                        *(yymsp[-1].minor.yy110),
                                                        3
                                                    );
                                                delete yymsp[-11].minor.yy611;
                                                delete yymsp[-13].minor.yy386;
                                                delete yymsp[-8].minor.yy532;
                                                delete yymsp[-4].minor.yy83;
                                                delete yymsp[-10].minor.yy319;
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-9].minor.yy319;
                                                delete yymsp[-1].minor.yy110;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 369: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause */
{
                                                QList<SqliteQuery *> CL;

                                                yygotominor.yy363 = new SqliteCreateTrigger(
                                                        *(yymsp[-10].minor.yy386),
                                                        *(yymsp[-8].minor.yy611),
                                                        *(yymsp[-7].minor.yy319),
                                                        *(yymsp[-6].minor.yy319),
                                                        *(yymsp[-2].minor.yy319),
                                                        *(yymsp[-5].minor.yy532),
                                                        yymsp[-4].minor.yy151,
                                                        *(yymsp[-1].minor.yy83),
                                                        yymsp[0].minor.yy512,
                                                        CL,
                                                        3
                                                    );
                                                delete yymsp[-8].minor.yy611;
                                                delete yymsp[-10].minor.yy386;
                                                delete yymsp[-5].minor.yy532;
                                                delete yymsp[-1].minor.yy83;
                                                delete yymsp[-7].minor.yy319;
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[-6].minor.yy319;
                                                objectForTokens = yygotominor.yy363;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 370: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list */
{
                                                yygotominor.yy363 = new SqliteCreateTrigger(
													*(yymsp[-12].minor.yy386),
													*(yymsp[-10].minor.yy611),
													*(yymsp[-9].minor.yy319),
													*(yymsp[-8].minor.yy319),
													*(yymsp[-4].minor.yy319),
													*(yymsp[-7].minor.yy532),
													yymsp[-6].minor.yy151,
													*(yymsp[-3].minor.yy83),
													yymsp[-2].minor.yy512,
													*(yymsp[0].minor.yy110),
													3
                                                );
                                                delete yymsp[-10].minor.yy611;
                                                delete yymsp[-12].minor.yy386;
                                                delete yymsp[-7].minor.yy532;
                                                delete yymsp[-3].minor.yy83;
                                                delete yymsp[-9].minor.yy319;
                                                delete yymsp[-4].minor.yy319;
                                                delete yymsp[-8].minor.yy319;
                                                delete yymsp[0].minor.yy110;
                                                objectForTokens = yygotominor.yy363;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 371: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB */
{  yy_destructor(yypParser,201,&yymsp[-8].minor);
  yy_destructor(yypParser,199,&yymsp[-5].minor);
  yy_destructor(yypParser,292,&yymsp[-3].minor);
  yy_destructor(yypParser,293,&yymsp[-2].minor);
}
        break;
      case 374: /* trigger_time ::= BEFORE */
{yygotominor.yy532 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::BEFORE);}
        break;
      case 375: /* trigger_time ::= AFTER */
{yygotominor.yy532 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::AFTER);}
        break;
      case 376: /* trigger_time ::= INSTEAD OF */
{yygotominor.yy532 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::INSTEAD_OF);}
        break;
      case 377: /* trigger_time ::= */
{yygotominor.yy532 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::null);}
        break;
      case 378: /* trigger_event ::= DELETE */
{
                                                yygotominor.yy151 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::DELETE);
                                                objectForTokens = yygotominor.yy151;
                                            }
        break;
      case 379: /* trigger_event ::= INSERT */
{
                                                yygotominor.yy151 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::INSERT);
                                                objectForTokens = yygotominor.yy151;
                                            }
        break;
      case 380: /* trigger_event ::= UPDATE */
{
                                                yygotominor.yy151 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::UPDATE);
                                                objectForTokens = yygotominor.yy151;
                                            }
        break;
      case 381: /* trigger_event ::= UPDATE OF idlist */
{
                                                yygotominor.yy151 = new SqliteCreateTrigger::Event(*(yymsp[0].minor.yy575));
                                                delete yymsp[0].minor.yy575;
                                                objectForTokens = yygotominor.yy151;
                                            }
        break;
      case 382: /* foreach_clause ::= */
{yygotominor.yy83 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::null);}
        break;
      case 383: /* foreach_clause ::= FOR EACH ROW */
{yygotominor.yy83 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::FOR_EACH_ROW);}
        break;
      case 386: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
{
                                                yymsp[-2].minor.yy110->append(yymsp[-1].minor.yy363);
                                                yygotominor.yy110 = yymsp[-2].minor.yy110;
                                                DONT_INHERIT_TOKENS("trigger_cmd_list");
                                            }
        break;
      case 387: /* trigger_cmd_list ::= trigger_cmd SEMI */
{
                                                yygotominor.yy110 = new ParserQueryList();
                                                yygotominor.yy110->append(yymsp[-1].minor.yy363);
                                            }
        break;
      case 388: /* trigger_cmd_list ::= SEMI */
{
                                                yygotominor.yy110 = new ParserQueryList();
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 393: /* raisetype ::= ROLLBACK|ABORT|FAIL */
{yygotominor.yy0 = yymsp[0].minor.yy0;}
        break;
      case 394: /* cmd ::= DROP TRIGGER ifexists fullname */
{
                                                yygotominor.yy363 = new SqliteDropTrigger(*(yymsp[-1].minor.yy611), yymsp[0].minor.yy440->name1, yymsp[0].minor.yy440->name2);
                                                delete yymsp[-1].minor.yy611;
                                                delete yymsp[0].minor.yy440;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 397: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
{
                                                yygotominor.yy363 = new SqliteAttach(*(yymsp[-4].minor.yy611), yymsp[-3].minor.yy512, yymsp[-1].minor.yy512, yymsp[0].minor.yy512);
                                                delete yymsp[-4].minor.yy611;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 398: /* cmd ::= DETACH database_kw_opt expr */
{
                                                yygotominor.yy363 = new SqliteDetach(*(yymsp[-1].minor.yy611), yymsp[0].minor.yy512);
                                                delete yymsp[-1].minor.yy611;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 403: /* cmd ::= REINDEX */
{yygotominor.yy363 = new SqliteReindex();}
        break;
      case 404: /* cmd ::= REINDEX nm dbnm */
      case 405: /* cmd ::= REINDEX ID_COLLATE */ yytestcase(yyruleno==405);
{
                                                yygotominor.yy363 = new SqliteReindex(*(yymsp[-1].minor.yy319), *(yymsp[0].minor.yy319));
                                                delete yymsp[-1].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 408: /* cmd ::= ANALYZE */
{
                                                yygotominor.yy363 = new SqliteAnalyze();
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 409: /* cmd ::= ANALYZE nm dbnm */
{
                                                yygotominor.yy363 = new SqliteAnalyze(*(yymsp[-1].minor.yy319), *(yymsp[0].minor.yy319));
                                                delete yymsp[-1].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 412: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
{
                                                yygotominor.yy363 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy440->name1,
                                                        yymsp[-3].minor.yy440->name2,
                                                        *(yymsp[0].minor.yy319)
                                                    );
                                                delete yymsp[0].minor.yy319;
                                                delete yymsp[-3].minor.yy440;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 413: /* cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column */
{
                                                yygotominor.yy363 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy440->name1,
                                                        yymsp[-3].minor.yy440->name2,
                                                        *(yymsp[-1].minor.yy611),
                                                        yymsp[0].minor.yy147
                                                    );
                                                delete yymsp[-1].minor.yy611;
                                                delete yymsp[-3].minor.yy440;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 414: /* cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW */
{  yy_destructor(yypParser,203,&yymsp[-3].minor);
}
        break;
      case 420: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm */
{
                                                yygotominor.yy363 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-4].minor.yy611),
                                                        *(yymsp[-3].minor.yy319),
                                                        *(yymsp[-2].minor.yy319),
                                                        *(yymsp[0].minor.yy319)
                                                    );
                                                delete yymsp[-4].minor.yy611;
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 421: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP */
{
                                                yygotominor.yy363 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-7].minor.yy611),
                                                        *(yymsp[-6].minor.yy319),
                                                        *(yymsp[-5].minor.yy319),
                                                        *(yymsp[-3].minor.yy319),
                                                        *(yymsp[-1].minor.yy575)
                                                    );
                                                delete yymsp[-6].minor.yy319;
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-7].minor.yy611;
                                                delete yymsp[-1].minor.yy575;
                                                objectForTokens = yygotominor.yy363;
                                            }
        break;
      case 424: /* vtabarglist ::= vtabarg */
{
                                                yygotominor.yy575 = new QStringList();
                                                yygotominor.yy575->append((yymsp[0].minor.yy319)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 425: /* vtabarglist ::= vtabarglist COMMA vtabarg */
{
                                                yymsp[-2].minor.yy575->append((yymsp[0].minor.yy319)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                yygotominor.yy575 = yymsp[-2].minor.yy575;
                                                delete yymsp[0].minor.yy319;
                                                DONT_INHERIT_TOKENS("vtabarglist");
                                            }
        break;
      case 427: /* vtabarg ::= vtabarg vtabargtoken */
{
                                                yymsp[-1].minor.yy319->append(" "+ *(yymsp[0].minor.yy319));
                                                yygotominor.yy319 = yymsp[-1].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 428: /* vtabargtoken ::= ANY */
{
                                                yygotominor.yy319 = new QString(yymsp[0].minor.yy0->value);
                                            }
        break;
      case 429: /* vtabargtoken ::= LP anylist RP */
{
                                                yygotominor.yy319 = new QString("(");
                                                yygotominor.yy319->append(*(yymsp[-1].minor.yy319));
                                                yygotominor.yy319->append(")");
                                                delete yymsp[-1].minor.yy319;
                                            }
        break;
      case 431: /* anylist ::= anylist LP anylist RP */
{
                                                yygotominor.yy319 = yymsp[-3].minor.yy319;
                                                yygotominor.yy319->append("(");
                                                yygotominor.yy319->append(*(yymsp[-1].minor.yy319));
                                                yygotominor.yy319->append(")");
                                                delete yymsp[-1].minor.yy319;
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 432: /* anylist ::= anylist ANY */
{
                                                yygotominor.yy319 = yymsp[-1].minor.yy319;
                                                yygotominor.yy319->append(yymsp[0].minor.yy0->value);
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 433: /* with ::= */
{yygotominor.yy1 = nullptr;}
        break;
      case 434: /* with ::= WITH wqlist */
{
                                                yygotominor.yy1 = new SqliteWith();
												yygotominor.yy1->cteList = *(yymsp[0].minor.yy593);
												delete yymsp[0].minor.yy593;
                                                objectForTokens = yygotominor.yy1;
                                            }
        break;
      case 435: /* with ::= WITH RECURSIVE wqlist */
{
                                                yygotominor.yy1 = new SqliteWith();
												yygotominor.yy1->cteList = *(yymsp[0].minor.yy593);
                                                yygotominor.yy1->recursive = true;
												delete yymsp[0].minor.yy593;
                                                objectForTokens = yygotominor.yy1;
                                            }
        break;
      case 436: /* wqlist ::= wqcte */
{
												yygotominor.yy593 = new ParserCteList();
                                                yygotominor.yy593->append(yymsp[0].minor.yy446);
                                            }
        break;
      case 437: /* wqlist ::= wqlist COMMA wqcte */
{
                                                yygotominor.yy593 = yymsp[-2].minor.yy593;
                                                yygotominor.yy593->append(yymsp[0].minor.yy446);
                                                DONT_INHERIT_TOKENS("wqlist");
                                            }
        break;
      case 438: /* wqlist ::= ID_TAB_NEW */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 439: /* wqcte ::= nm idxlist_opt AS LP select RP */
{
                                                yygotominor.yy446 = new SqliteWith::CommonTableExpression(*(yymsp[-5].minor.yy319), *(yymsp[-4].minor.yy223), yymsp[-1].minor.yy313);
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-4].minor.yy223;
												objectForTokens = yygotominor.yy446;
											}
        break;
      case 440: /* windowdefn_list ::= windowdefn */
{
												yygotominor.yy299 = new ParserWindowDefList();
												yygotominor.yy299->append(yymsp[0].minor.yy266);
											}
        break;
      case 441: /* windowdefn_list ::= windowdefn_list COMMA windowdefn */
{
												yymsp[-2].minor.yy299->append(yymsp[0].minor.yy266);
												yygotominor.yy299 = yymsp[-2].minor.yy299;
												DONT_INHERIT_TOKENS("windowdefn_list");
											}
        break;
      case 442: /* windowdefn ::= nm AS LP window RP */
{
												yygotominor.yy266 = new SqliteWindowDefinition(*(yymsp[-4].minor.yy319), yymsp[-1].minor.yy334);
												delete yymsp[-4].minor.yy319;
												objectForTokens = yygotominor.yy266;
											}
        break;
      case 443: /* window ::= PARTITION BY nexprlist orderby_opt frame_opt */
{
												yygotominor.yy334 = new SqliteWindowDefinition::Window();
												yygotominor.yy334->initPartitionBy(QString(), *(yymsp[-2].minor.yy71), *(yymsp[-1].minor.yy403), yymsp[0].minor.yy41);
												delete yymsp[-2].minor.yy71;
												delete yymsp[-1].minor.yy403;
												objectForTokens = yygotominor.yy334;
											}
        break;
      case 444: /* window ::= nm PARTITION BY nexprlist orderby_opt frame_opt */
{
												yygotominor.yy334 = new SqliteWindowDefinition::Window();
												yygotominor.yy334->initPartitionBy(*(yymsp[-5].minor.yy319), *(yymsp[-2].minor.yy71), *(yymsp[-1].minor.yy403), yymsp[0].minor.yy41);
												delete yymsp[-2].minor.yy71;
												delete yymsp[-5].minor.yy319;
												delete yymsp[-1].minor.yy403;
												objectForTokens = yygotominor.yy334;
											}
        break;
      case 445: /* window ::= ORDER BY sortlist frame_opt */
{
												yygotominor.yy334 = new SqliteWindowDefinition::Window();
												yygotominor.yy334->initOrderBy(QString(), *(yymsp[-1].minor.yy403), yymsp[0].minor.yy41);
												delete yymsp[-1].minor.yy403;
												objectForTokens = yygotominor.yy334;
											}
        break;
      case 446: /* window ::= nm ORDER BY sortlist frame_opt */
{
												yygotominor.yy334 = new SqliteWindowDefinition::Window();
												yygotominor.yy334->initOrderBy(*(yymsp[-4].minor.yy319), *(yymsp[-1].minor.yy403), yymsp[0].minor.yy41);
												delete yymsp[-1].minor.yy403;
												delete yymsp[-4].minor.yy319;
												objectForTokens = yygotominor.yy334;
											}
        break;
      case 447: /* window ::= frame_opt */
{
												yygotominor.yy334 = new SqliteWindowDefinition::Window();
												yygotominor.yy334->init(QString(), yymsp[0].minor.yy41);
												objectForTokens = yygotominor.yy334;
											}
        break;
      case 448: /* window ::= nm frame_opt */
{
												yygotominor.yy334 = new SqliteWindowDefinition::Window();
												yygotominor.yy334->init(QString(), yymsp[0].minor.yy41);
												delete yymsp[-1].minor.yy319;
												objectForTokens = yygotominor.yy334;
											}
        break;
      case 449: /* frame_opt ::= */
{yygotominor.yy41 = nullptr;}
        break;
      case 450: /* frame_opt ::= range_or_rows frame_bound_s frame_exclude_opt */
{
												yygotominor.yy41 = new SqliteWindowDefinition::Window::Frame(*(yymsp[-2].minor.yy419), yymsp[-1].minor.yy442, nullptr, *(yymsp[0].minor.yy63));
												delete yymsp[-2].minor.yy419;
												delete yymsp[0].minor.yy63;
												objectForTokens = yygotominor.yy41;
											}
        break;
      case 451: /* frame_opt ::= range_or_rows BETWEEN frame_bound_s AND frame_bound_e frame_exclude_opt */
{
												yygotominor.yy41 = new SqliteWindowDefinition::Window::Frame(*(yymsp[-5].minor.yy419), yymsp[-3].minor.yy442, yymsp[-1].minor.yy442, *(yymsp[0].minor.yy63));
												delete yymsp[-5].minor.yy419;
												delete yymsp[0].minor.yy63;
												objectForTokens = yygotominor.yy41;
											}
        break;
      case 452: /* range_or_rows ::= RANGE|ROWS|GROUPS */
{
												yygotominor.yy419 = new SqliteWindowDefinition::Window::Frame::RangeOrRows(
													SqliteWindowDefinition::Window::Frame::toRangeOrRows(yymsp[0].minor.yy0->value)
													);
											}
        break;
      case 453: /* frame_bound_s ::= frame_bound */
      case 455: /* frame_bound_e ::= frame_bound */ yytestcase(yyruleno==455);
{
												yygotominor.yy442 = yymsp[0].minor.yy442;
												objectForTokens = yygotominor.yy442;
											}
        break;
      case 454: /* frame_bound_s ::= UNBOUNDED PRECEDING */
      case 456: /* frame_bound_e ::= UNBOUNDED FOLLOWING */ yytestcase(yyruleno==456);
      case 458: /* frame_bound ::= CURRENT ROW */ yytestcase(yyruleno==458);
{
												yygotominor.yy442 = new SqliteWindowDefinition::Window::Frame::Bound(nullptr, yymsp[-1].minor.yy0->value + " " + yymsp[0].minor.yy0->value);
												objectForTokens = yygotominor.yy442;
											}
        break;
      case 457: /* frame_bound ::= expr PRECEDING|FOLLOWING */
{
												yygotominor.yy442 = new SqliteWindowDefinition::Window::Frame::Bound(yymsp[-1].minor.yy512, yymsp[0].minor.yy0->value);
												objectForTokens = yygotominor.yy442;
											}
        break;
      case 459: /* frame_exclude_opt ::= */
{
												yygotominor.yy63 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::null
													);
											}
        break;
      case 460: /* frame_exclude_opt ::= EXCLUDE frame_exclude */
{
												yygotominor.yy63 = yymsp[0].minor.yy63;
											}
        break;
      case 461: /* frame_exclude ::= NO OTHERS */
{
												yygotominor.yy63 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::NO_OTHERS
													);
											}
        break;
      case 462: /* frame_exclude ::= CURRENT ROW */
{
												yygotominor.yy63 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::CURRENT_ROW
													);
											}
        break;
      case 463: /* frame_exclude ::= GROUP */
{
												yygotominor.yy63 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::GROUP
													);
											}
        break;
      case 464: /* frame_exclude ::= TIES */
{
												yygotominor.yy63 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::TIES
													);
											}
        break;
      case 465: /* window_clause ::= WINDOW windowdefn_list */
{
												yygotominor.yy299 = yymsp[0].minor.yy299;
											}
        break;
      case 466: /* filter_over ::= filter_clause over_clause */
{
												yygotominor.yy247 = new SqliteFilterOver(yymsp[-1].minor.yy397, yymsp[0].minor.yy248);
												objectForTokens = yygotominor.yy247;
											}
        break;
      case 467: /* filter_over ::= over_clause */
{
												yygotominor.yy247 = new SqliteFilterOver(nullptr, yymsp[0].minor.yy248);
												objectForTokens = yygotominor.yy247;
											}
        break;
      case 468: /* filter_over ::= filter_clause */
{
												yygotominor.yy247 = new SqliteFilterOver(yymsp[0].minor.yy397, nullptr);
												objectForTokens = yygotominor.yy247;
											}
        break;
      case 469: /* over_clause ::= OVER LP window RP */
{
												yygotominor.yy248 = new SqliteFilterOver::Over(yymsp[-1].minor.yy334);
												objectForTokens = yygotominor.yy248;
											}
        break;
      case 470: /* over_clause ::= OVER nm */
{
												yygotominor.yy248 = new SqliteFilterOver::Over(*(yymsp[0].minor.yy319));
												delete yymsp[0].minor.yy319;
												objectForTokens = yygotominor.yy248;
											}
        break;
      case 471: /* filter_clause ::= FILTER LP WHERE expr RP */
{
												yygotominor.yy397 = new SqliteFilterOver::Filter(yymsp[-1].minor.yy512);
												objectForTokens = yygotominor.yy397;
											}
        break;
      default:
      /* (0) input ::= cmdlist */ yytestcase(yyruleno==0);
        break;
      };
  }
  assert( yyruleno>=0 && yyruleno<(int)(sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0])) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;

  // Store tokens for the rule in parser context
  QList<Token*> allTokens;
  QList<Token*> allTokensWithAllInherited;
  QString keyForTokensMap;
  int tokensMapKeyCnt;
  if (parserContext->setupTokens)
  {
      if (objectForTokens)
      {
          // In case this is a list with recurrent references we need
          // to clear tokens before adding the new and extended list.
          objectForTokens->tokens.clear();
      }

      QList<Token*> tokens;
      for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
      {
          tokens.clear();
          const char* fieldName = yyTokenName[yypParser->yystack[i].major];

          // Adding token being subject of this reduction. It's usually not includes in the inherited tokens,
          // although if inheriting from simple statements, like "FAIL" or "ROLLBACK", this tends to be redundant with the inherited tokens.
          // That's why we're checking if it's not contained in the inherited tokens and add it only then.
          if (parserContext->isManagedToken(yypParser->yystack[i].minor.yy0) && !yypParser->yystack[i].tokens->contains(yypParser->yystack[i].minor.yy0))
              tokens += yypParser->yystack[i].minor.yy0;

          tokens += *(yypParser->yystack[i].tokens);

          if (!noTokenInheritanceFields.contains(fieldName))
          {
              if (objectForTokens)
              {
                  keyForTokensMap = fieldName;
                  tokensMapKeyCnt = 2;
                  while (objectForTokens->tokensMap.contains(keyForTokensMap))
                      keyForTokensMap = fieldName + QString::number(tokensMapKeyCnt++);

                  objectForTokens->tokensMap[keyForTokensMap] = parserContext->getTokenPtrList(tokens);
              }

              allTokens += tokens;
          }
          else
          {
              // If field is mentioned only once, then only one occurance of it will be ignored.
              // Second one should be inherited. See "anylist" definition for explanation why.
              noTokenInheritanceFields.removeOne(fieldName);
          }
          allTokensWithAllInherited += tokens;
      }
      if (objectForTokens)
      {
          objectForTokens->tokens += parserContext->getTokenPtrList(allTokens);
      }
  }

  // Clear token lists
  for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
  {
      delete yypParser->yystack[i].tokens;
      yypParser->yystack[i].tokens = nullptr;
  }

  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
      if (parserContext->setupTokens)
          *(yypParser->yystack[yypParser->yyidx].tokens) = allTokens;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
      if (parserContext->setupTokens)
      {
          QList<Token*>* tokensPtr = yypParser->yystack[yypParser->yyidx].tokens;
          *tokensPtr = allTokensWithAllInherited + *tokensPtr;
      }
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3_parseARG_FETCH;
#define TOKEN (yyminor.yy0)

    UNUSED_PARAMETER(yymajor);
    parserContext->error(TOKEN, QObject::tr("Syntax error"));
    //qDebug() << "near " << TOKEN->toString() << ": syntax error";
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3_parseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3_parseTOKENTYPE yyminor       /* The value for the token */
  sqlite3_parseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
    yypParser->yystack[0].tokens = new QList<Token*>();
  }
  yyminorunion.yy0 = yyminor;
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif
  sqlite3_parseARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s [%s] (lemon type: %s)\n",
            yyTracePrompt,
            yyminor->value.toLatin1().data(),
            yyminor->typeString().toLatin1().data(),
            yyTokenName[yymajor]);  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;

#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}