'\" t
.\"     srecord - manipulate eprom load files
.\"     Copyright (C) 1998, 2000-2004, 2006-2008 Peter Miller
.\"
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 3 of the License, or
.\"     (at your option) any later version.
.\"
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program. If not, see
.\"     <http://www.gnu.org/licenses/>.
.\"
.TH "Read Me" SRecord SRecord "Reference Manual"
.so etc/version.so
.hy 0
.ad l
.SH NAME
SRecord \- manipulate EPROM load files
.XX "" "The README file"
.SH DESCRIPTION
The \fISRecord\fP package is a collection of powerful tools for
manipulating EPROM load files.
.PP
I wrote SRecord because when I was looking for programs to manipulate
EPROM load files, I could not find very many.  The ones that I could
find only did a few of the things I needed.  SRecord is written in C++
and polymorphism is used to provide the file format flexibility and
arbitrary filter chaining.  Adding more file formats and filters is
relatively simple.
.SS The File Formats
The SRecord package understands a number of file formats:
.TP 8n
Ascii-Hex
The ascii-hex format is understood for both reading and writing.
(Also known as the ascii-space-hex format.)
.TP
ASM
It is possible, for output only, to produce a serices of DB statements
containing the data.  This can be useful for embedding data into assembler
programs.
This format cannot be read.
.TP 8n
Atmel Generic
This format is produced by the Atmel AVR assembler.
It is understood for both reading and writing.
.TP
BASIC
It is possible, for output only, to produce a serices of DATA statements
containing the data.  This can be useful for embedding data into BASIC
programs.
This format cannot be read.
.TP 8n
Binary
Binary files can both be read and written.
.TP 8n
B-Record
Files in Freescale Dragonball bootstrap b-record format can be read and written.
.TP 8n
C
It is also possible to write a C array declaration which contains the data.
This can be useful when you want to embed download data into C programs.
This format cannot be read.
.TP 8n
Cosmac
The RCA Cosmac Elf format is understood for both reading and writing.
.TP
DEC Binary
The DEC Binary (XXDP) format is understood for both reading and writing.
.TP
Elektor Monitor (EMON52)
The EMON52 format is understood for both reading and writing.
.TP
Fairchild Fairbug
The Fairchild Fairbug format is understood for both reading and writing.
.TP
hexdump
It is possible to get a simple hexdump as output.
.TP
LSI Logic Fast Load
The LSI Logic Fast Load format is understood for both reading and writing.
.TP
Formatted Binary
The Formatted Binary format is understood for both reading and writing.
.TP
Four Packed Code (FPC)
The FPC format is understood for both reading and writing.
.TP 8n
Intel
The Intel hexadecimal format is understood for both reading and writing.
(Also known as the Intel MCS-86 Object format.)
.TP 8n
Intel AOMF
The Intel Absolute Object Module Format (AOMF) is understood for both
reading and writing.
.TP 8n
Intel 16
The Intel hexadecimal 16 format is understood for both reading and writing.
(Also known as the INHX16 file format.)
.TP 8n
MOS Technology
The MOS Technology hexadecimal format is understood for both reading
and writing.
.TP 8n
Motorola S-Record
The Motorola hexadecimal S-Record format is understood for both reading
and writing.
(Also known as the Exorciser, Exormacs or Exormax format.)
.TP 8n
The Needham Electronics ASCII file format is understood for noth reading
and writing.
.TP 8n
OS65V
The Ohio Scientific hexadecimal format is understood for both reading
and writing.
.TP 8n
Signetics
The Signetics format is understood for both reading and writing.
.TP 8n
SPASM
The SPASM format is used by a variety of PIC programmers; it is understood
for both reading and writing.
.TP 8n
Spectrum
The Spectrum format is understood for both reading and writing.
.TP 8n
Tektronix (Extended)
The Tektronix hexadecimal format and the Tektronix Extended hexadecimal
format are both understood for both reading and writing.
.TP 8n
Texas Instruments Tagged
The Texas Instruments Tagged format is understood for both reading and
writing (both 8 and 16 bit).  Also known as the TI-tagged or TI-SDSMAC
format.
.TP 8n
Texas Instruments ti-txt
The TI-TXT format is understood for reading and writing.  This format is
used with the bootstrap loader of the Texas Instruments MSP430 family of
processors.
.TP 8n
VHDL
It is possible to write VHDL file.
This is only supported for output.
.TP 8n
Verilog VMEM
It is possible to write a Verilog VMEM file suitable for loading with
\f[CW]$readmemh()\fP.  This format is supported for reading and writing.
.TP 8n
Wilson
The Wilson format is understood for both reading and writing.
This mystery format was added for a mysterious type of EPROM writer.
.SS The Tools
The primary tools of the package are \fIsrec_cat\fP and \fIsrec_cmp\fP.
All of the tools understand all of the file formats, and all of the filters.
.TP 8n
.I srec_cat
The \fIsrec_cat\fP program may be used to catenate (join) EPROM load
files, or portions of EPROM load files, together.  Because it understands
all of the input and output formats, it can also be used to convert
files from one format to another.
.TP 8n
.I srec_cmp
The \fIsrec_cmp\fP program may be use to compare EPROM load files,
or portions of EPROM load files, for equality.
.TP 8n
.I srec_info
The \fIsrec_info\fP program may be used to print summary information
about EPROM load files.
.SS The Filters
The \fISRecord\fP package is made more powerful by the concept of \fIinput
filters\fP.  Wherever an input file may be specified, filters may also
be applied to that input file.  The following filters are available:
.TP 8n
checksum
The \fIchecksum\fP filter may be used to insert the checksum of the data
(bitnot, negative or positive) into the data.
.TP 8n
byte swap
The \fIbyte swap\fP filter may be used to swap pairs of add and even bytes.
.TP 8n
CRC
The \fIcrc\fP filters may be used to insert a CRC into the data.
.TP
checksum
The \fIchecksum\fP filters may be used to insert a checksum into
the data.  Positive, negative and bit-not checksums are available,
as well as big-endian and little-endian byte orders.
.TP 8n
crop
The \fIcrop\fP filter may be used to isolate an input address range,
or ranges, and discard the rest.
.TP 8n
exclude
The \fIexclude\fP filter may be used to exclude an input address range,
or ranges, and keep the rest.
.TP 8n
fill
The \fIfill\fP filter may be used to fill any holes in the data
with a nominated value.
.TP 8n
unfill
The \fIunfill\fP filter may be used to make holes in the data at bytes
with a nominated value.
.TP 8n
random fill
The \fIrandom fill\fP filter may be used to fill holes in the data with
random byte values.
.TP 8n
length
The \fIlength\fP filter may be used to insert the data length into the data.
.TP 8n
maximum
The \fImaximum\fP filter may be used to insert the maximum data address
into the data.
.TP 8n
minimum
The \fIminimum\fP filter may be used to insert the minimum data address
into the data.
.TP 8n
offset
The \fIoffset\fP filter may be used to offset the address of data records,
both forwards and backwards.
.TP 8n
split
The \fIsplit\fP filter may be used to split EPROM images for wide data
buses or other memory striping schemes.
.TP 8n
unsplit
The \fIunsplit\fP filter may be reverse the effects of the split filter.
.PP
More than one filter may be applied to each input file.
Different filters may be applied to each input file.
All filters may be applied to all file formats.
.br
.ne 1i
.SH ARCHIVE SITE
The latest version of
.I SRecord
is available on the Web from:
.TS
center,tab(;);
l l s
l l l.
URL:;http://srecord.sourceforge.net/
File:;index.html;# the SRecord page
File:;srecord-\*(v).README;# Description, from the tar file
File:;srecord-\*(v).lsm;# Description, LSM format
File:;srecord-\*(v).spec;# RedHat package specification
File:;srecord-\*(v).tar.gz;# the complete source
File:;srecord-\*(v).pdf;# Reference Manual
.TE
.br
.ne 1i
.SH BUILDING SRECORD
Full instructions for building
.I SRecord
may be found in the
.I BUILDING
file included in this distribution.
.LP
It is also possible to build \fISRecord\fP on Windows using the
Cygwin (www.cygwin.com) or DJGPP (www.delorie.com/djgpp) environments.
Instructions are in the \fIBUILDING\fP file, including how to get native
Windows binaries.
.br
.ne 1i
.SH COPYRIGHT
.I srecord
version \*(v)
.br
Copyright
.if t \(co
.if n (C)
\*(Y) Peter Miller
.PP
This program is free software;
you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation;
either version 3 of the License,
or (at your option) any later version.
.PP
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See the GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License along
with this program. If not, see <http://www.gnu.org/licenses/>.
.PP
It should be in the
.I LICENSE
file included with this distribution.
.br
.ne 1i
.SH AUTHOR
.TS
tab(;);
l l l.
Peter Miller;E-Mail:;millerp@canb.auug.org.au
\f(CW/\e/\e*\fP;WWW:;http://www.canb.auug.org.au/~millerp/
.TE
.br
.bp
.SH RELEASE NOTES
.XX "" "Release Notes"
This section details the various features and bug fixes of the various
releases.  For excruciating and complete detail, and also credits for
those of you who have generously sent me suggestions and bug reports,
see the \fIetc/CHANGES.*\fP files.
.so etc/new.so
