//
//      srecord - manipulate eprom load files
//      Copyright (C) 2003, 2006-2008 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef INCLUDE_SREC_INPUT_FILE_INTEL16_H
#define INCLUDE_SREC_INPUT_FILE_INTEL16_H

#include <lib/srec/input/file.h>

/**
  * The srec_input_file_intel16 class is used to represent the parse state
  * of an INHX16 formatted file.
  */
class srec_input_file_intel16:
    public srec_input_file
{
public:
    /**
      * The destructor.
      */
    virtual ~srec_input_file_intel16();

private:
    /**
      * The constructor.
      *
      * @param file_name
      *     The name of the file to be read.
      */
    srec_input_file_intel16(const string &file_name);

public:
    /**
      * The create class method is used to create new dynamically
      * allocated instances of this class.
      *
      * @param file_name
      *     The name of the file to be read.
      * @returns
      *     smart pointer to new instance
      */
    static pointer create(const string &file_name);

protected:
    // See base class for documentation.
    bool read(srec_record &record);

    // See base class for documentation.
    const char *get_file_format_name() const;

private:
    /**
      * Read one record from the file.  The read method is a wrapper
      * around this method.
      */
    int read_inner(srec_record &);

    /**
      * The data_record_count instance variable is used to remember the
      * number of data records seen to date.
      */
    int data_record_count;

    /**
      * The garbage_warning instance variable is used to remember wherther
      * or not a warning has already been issued about garbage lines
      * of input.
      */
    bool garbage_warning;

    /**
      * The seen_some_input instance variable is used to remember whether
      * or not the file contains any data.
      */
    bool seen_some_input;

    /**
      * The termination_seen instance variable is used to remember
      * whether or not a termination record has been seen yet.
      */
    bool termination_seen;

    /**
      * The mode instance variable is used to remember what addressing
      * mode the file is currently in.
      */
    enum { linear, segmented } mode;

    /**
      * The address_base instance variable is used to remember the
      * segment base address when in segmented addressing mode.
      */
    unsigned long address_base;

    /**
      * The pushback instance variable is used to remember the previous
      * record in the file.  This is needed in some instances, but not always.
      */
    srec_record *pushback;

    /**
      * The end_seen instance variable is used to remember whether or
      * not the end of file has been seen yet.
      */
    bool end_seen;

    /**
      * The default constructor.  Do not use.
      */
    srec_input_file_intel16();

    /**
      * The copy constructor.  Do not use.
      */
    srec_input_file_intel16(const srec_input_file_intel16 &);

    /**
      * The assignment operator.  Do not use.
      */
    srec_input_file_intel16 &operator=(const srec_input_file_intel16 &);
};

#endif // INCLUDE_SREC_INPUT_FILE_INTEL16_H
