/* 
 * This file part of StarDict - A international dictionary for GNOME.
 * http://stardict.sourceforge.net
 * Copyright (C) 2005 Evgeniy <dushistov@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <cstring>
#include <gtk/gtk.h>

#include "articleview.h"

static std::string xdxf2pango(const char *p)
{
  std::string res;
  for (; *p; ++p) {
    if (*p!='<') {
      res+=*p;
      continue;
    }

    const char *next=strchr(p, '>');
    if (!next)
      continue;

    std::string name(p+1, next-p-1);

    if (name=="abr")
      res+="<span foreground=\"green\" style=\"italic\">";
    else if (name=="/abr")
      res+="</span>";
    else if (name=="k") {
      const char *begin=next;
      if ((next=strstr(begin, "</k>"))!=NULL)
	next+=sizeof("</k>")-1-1;
      else
	next=begin;
    } else if (name=="b")
      res+="<b>";
    else if (name=="/b")
      res+="</b>";
    else if (name=="i")
      res+="<i>";
    else if (name=="/i")
      res+="</i>";
	else if (name=="tr")
	  res+="<b>[";
	else if (name=="/tr")
	  res+="]</b>";
    else if (name=="ex")
      res+="<span foreground=\"violet\">";
    else if (name=="/ex")
      res+="</span>";
    else if (!name.empty() && name[0]=='c' && name!="co") {
      std::string::size_type pos=name.find("code");
      if (pos!=std::string::size_type(-1)) {
	pos+=sizeof("code=\"")-1;
	std::string::size_type end_pos=name.find("\"");
	std::string color(name, pos, end_pos-pos);
	res+="<span foreground=\""+color+"\">";
      } else {
	res+="<span foreground=\"blue\">";
      }
    } else if (name=="/c")
      res+="</span>";

    p=next;
  }
  return res;
}

void ArticleView::AppendData(const gchar *data)
{  
  std::string mark;

  guint32 data_size,sec_size=0;
  const gchar *p=data;
  data_size=*reinterpret_cast<const guint32 *>(p);
  p+=sizeof(guint32);
  while (guint32(p - data)<data_size) {
    if (for_float_win)
      mark+= "\n";
    switch (*p) {
    case 'm':
    case 'l'://need more work...
      p++;
      sec_size = strlen(p);
      if (sec_size) {
	gchar *m_str = g_markup_escape_text(p, sec_size);
	mark+=m_str;
	g_free(m_str);
      }
      sec_size++;
      break;
    case 'g':
      p++;
      sec_size=strlen(p);
      if (sec_size) {
	//AppendPangoText(p);
	mark+=p;
      }
      sec_size++;
      break;
    case 'x':
      p++;
      sec_size = strlen(p);
      if (sec_size) {
	std::string res=xdxf2pango(p);
	mark+=res;
      }
      sec_size++;
      break;
    case 't':
      p++;
      sec_size = strlen(p);
      if (sec_size) {
	mark += "<span size=\"x-large\">[";
	gchar *m_str = g_markup_escape_text(p, sec_size);
	mark += m_str;
	g_free(m_str);
	mark += "]</span>";
      }
      sec_size++;						
      break;
    case 'y':
      p++;
      sec_size = strlen(p);
      if (sec_size) {
	mark += "<span foreground=\"red\">[";
	gchar *m_str = g_markup_escape_text(p, sec_size);
	mark += m_str;
	g_free(m_str);
	mark += "]</span>";
	
      }
      sec_size++;
      break;
    case 'W':
      p++;
      sec_size=*reinterpret_cast<const guint32 *>(p);
      sec_size=g_ntohl(sec_size);
      //enbale sound button.
      sec_size += sizeof(guint32);
      break;
    case 'P':
      p++;
      sec_size=*reinterpret_cast<const guint32 *>(p);
      sec_size=g_ntohl(sec_size);
      //show this picture.
      sec_size += sizeof(guint32);
      break;
    default:
      if (g_ascii_isupper(*p)) {
        p++;
        sec_size=*reinterpret_cast<const guint32 *>(p);
        sec_size=g_ntohl(sec_size);
        sec_size += sizeof(guint32);
      } else {
        p++;
        sec_size = strlen(p)+1;
      }
      break;
    }
    if (!for_float_win)
      mark+="\n";
    p += sec_size;
  }
  AppendPangoText(mark.c_str());
}

void ArticleView::AppendHeader(const std::string& dict_name, const gchar *word, bool is_origin_word)
{
	std::string mark;
	if (for_float_win)
		mark= "\n<span foreground=\"blue\">";
	else
		mark= "<span foreground=\"blue\">";
	mark+= !for_float_win ? "&lt;--- " : "*--- ";
	gchar *m_str = g_markup_escape_text(dict_name.c_str(), -1);
	mark += m_str;
	g_free(m_str);
	mark += !for_float_win ? " ---&gt;" : " ---*";
	mark += "</span>";
          
	if (!is_origin_word || !for_float_win) {
		mark += "\n";
		mark += !for_float_win ? "<b><span size=\"x-large\">" : "<span foreground=\"purple\">";
		gchar *m_str = g_markup_escape_text(word, -1);
		mark += m_str;
		g_free(m_str);
		mark += !for_float_win ? "</span></b>\n" : "</span>";
	}
	AppendPangoText(mark.c_str());
}
