#ifndef __SD_PREFS_DLG_H__
#define __SD_PREFS_DLG_H__

#include <gtk/gtk.h>
#include <list>

class PrefsDlg {
private:
  GtkWidget *window;
  GtkWidget *notebook;
  GtkWidget *categories_tree;
  GtkTreeModel *categories_tree_model;
  GtkWidget *custom_font_hbox;
  GtkWidget *scan_modifier_key_vbox;
  GtkWidget *searchwebsite_treeview;

  GtkWindow *parent_window;
  GdkPixbuf *stardict_logo;
#ifdef WITHOUT_GNOME
  GtkEntry *ePlayCommand;
#endif
  GtkWidget *categories_window;
	const std::list<std::string>& key_combs;

  GtkTreeModel* create_categories_tree_model ();		
  void create_categories_tree(void);
  void setup_logo_page();
  void setup_dictionary_font_page();
  void setup_dictionary_scan_page();
  void setup_dictionary_sound_page();
  void setup_mainwin_options_page();
  void setup_mainwin_searchwebsite_page();
  void setup_NotificationAreaIcon_options_page();
  void setup_floatwin_options_page();
  void setup_floatwin_size_page();
  GtkWidget* create_notebook ();
  
  void write_mainwin_searchwebsite_list();
  
  static void categories_tree_selection_cb (GtkTreeSelection *selection, PrefsDlg *oPrefsDlg);
  static void response_handler (GtkDialog *dialog, gint res_id, PrefsDlg *oPrefsDlg);
  static gboolean selection_init (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, PrefsDlg *oPrefsDlg);
  static void categories_tree_realize (GtkWidget *widget, PrefsDlg *oPrefsDlg);
  static void on_setup_dictionary_font_ckbutton_toggled(GtkToggleButton *button, PrefsDlg *oPrefsDlg);
  static void on_setup_dictionary_font_button_clicked(GtkWidget *widget, PrefsDlg *oPrefsDlg);
  static void on_setup_dictionary_scan_ckbutton_toggled(GtkToggleButton *button, PrefsDlg *oPrefsDlg);
  static void on_setup_dictionary_scan_optionmenu_changed(GtkOptionMenu *option_menu, PrefsDlg *oPrefsDlg);
  static void on_setup_dictionary_scan_hide_ckbutton_toggled(GtkToggleButton *button, PrefsDlg *oPrefsDlg);
  static void on_setup_dictionary_sound_ckbutton_toggled(GtkToggleButton *button, PrefsDlg *oPrefsDlg);
  static void on_setup_mainwin_startup_ckbutton_toggled(GtkToggleButton *button, PrefsDlg *oPrefsDlg);
  static void on_setup_mainwin_searchwebsite_cell_edited(GtkCellRendererText *cell, const gchar *path_string, const gchar *new_text, PrefsDlg *oPrefsDlg);
  static void on_setup_mainwin_searchwebsite_moveup_button_clicked(GtkWidget *widget, PrefsDlg *oPrefsDlg);
  static void on_setup_mainwin_searchwebsite_movedown_button_clicked(GtkWidget *widget, PrefsDlg *oPrefsDlg);
  static void on_setup_mainwin_searchwebsite_add_button_clicked(GtkWidget *widget, PrefsDlg *oPrefsDlg);
  static void on_setup_mainwin_searchwebsite_remove_button_clicked(GtkWidget *widget, PrefsDlg *oPrefsDlg);
  static void on_setup_NotificationAreaIcon_QueryInFloatWin_ckbutton_toggled(GtkToggleButton *button, PrefsDlg *oPrefsDlg);
  static void on_setup_floatwin_pronounce_ckbutton_toggled(GtkToggleButton *button, PrefsDlg *oPrefsDlg);
  static void on_setup_floatwin_size_max_width_spinbutton_changed(GtkSpinButton *button, PrefsDlg *oPrefsDlg);
  static void on_setup_floatwin_size_max_height_spinbutton_changed(GtkSpinButton *button, PrefsDlg *oPrefsDlg);

  void resize_categories_tree(void);

  PrefsDlg(GtkWindow *parent, GdkPixbuf *logo, const std::list<std::string>& key_combs);
  void ShowModal(void);
	void change_font_for_all_widgets(const std::string& fontname);
public:
  static void ShowModal(GtkWindow *parent, GdkPixbuf *logo, const std::list<std::string>& key_combs);
};

#endif
