#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <cstring>
#include <string>

#include "conf.h"
#include "utils.h"

#include "readword.h"

ReadWord::ReadWord()
{	
#ifdef _WIN32
	have_data_file = 
	  g_file_test((gStarDictDataDir+ G_DIR_SEPARATOR_S "WyabdcRealPeopleTTS").c_str(), 
		      G_FILE_TEST_EXISTS);
#else
	have_data_file = g_file_test("/usr/share/WyabdcRealPeopleTTS", G_FILE_TEST_EXISTS);
#endif
}

bool ReadWord::canRead(const gchar *word)
{	
  bool return_val = false;
	if (have_data_file && word && g_ascii_isalpha(word[0])) {
    std::string lowerword;
    lowerword.resize(strlen(word));
    for (std::string::size_type i=0; i<lowerword.length(); i++)
      lowerword[i]=g_ascii_tolower(word[i]);
    
    std::string filename;
#ifdef _WIN32
    filename = gStarDictDataDir+"/WyabdcRealPeopleTTS/"+
      lowerword[0]+"/"+lowerword+".wav";
#else
    filename = std::string("/usr/share/WyabdcRealPeopleTTS/")+lowerword[0]+"/"+
      lowerword+".wav";
#endif
    return_val = g_file_test(filename.c_str(), G_FILE_TEST_EXISTS);
	}

	return return_val;
}

void ReadWord::read(const gchar *word)
{
	if (have_data_file && word && g_ascii_isalpha(word[0])) {
    std::string lowerword;
    lowerword.resize(strlen(word));

    for (std::string::size_type i=0; i<lowerword.length(); i++)
			lowerword[i]= g_ascii_tolower(word[i]);

    std::string filename;
#ifdef _WIN32
    filename = gStarDictDataDir+"/WyabdcRealPeopleTTS/"+
      lowerword[0]+"/"+lowerword+".wav";
#else
    filename = std::string("/usr/share/WyabdcRealPeopleTTS/")+
      lowerword[0]+"/"+lowerword+".wav";
#endif
    play_wav_file(filename);
	}
}
