#!/bin/sh
# Copyright © 2016-2018 Simon McVittie
# Copyright © 2018 Collabora Ltd.
#
# SPDX-License-Identifier: MIT

set -e
set -u

if [ "x${PYCODESTYLE:=pycodestyle}" = xfalse ] || \
        [ -z "$(command -v "$PYCODESTYLE")" ]; then
    echo "1..0 # SKIP pycodestyle not found"
    exit 0
fi

echo "1..2"

if "${PYCODESTYLE}" \
    buildutils/*.py \
    >&2; then
    echo "ok 1 - $PYCODESTYLE reported no issues"
else
    echo "not ok 1 # TODO $PYCODESTYLE issues reported"
fi

# bin_steamdeps.py has unusual whitespace so for now we ignore:
# E117 over-indented
# W191 indentation contains tabs
# E201, E202 whitespace around operators
# E501 long lines
if "${PYCODESTYLE}" \
    --ignore=E117,W191,E201,E202,E501 \
    ./*.py \
    >&2; then
    echo "ok 2 - $PYCODESTYLE reported no issues"
else
    echo "not ok 2 # TODO $PYCODESTYLE issues reported"
fi

# vim:set sw=4 sts=4 et:
