/************************************************************************

LUNAR SOLUTION ELP2000-82B
by Chapront-Touze M., Chapront J.
ftp://ftp.imcce.fr/pub/ephem/moon/elp82b

I (Johannes Gajdosik) have just taken the Fortran code and data
obtained from above and used it to create this piece of software.

I can neigther allow nor forbid the usage of ELP2000-82B.
The copyright notice below covers not the works of
Chapront-Touze M. and Chapront J., but just my work,
that is the compilation and rearrangement of
the Fortran code and data obtained from above
into the software supplied in this file.


Copyright (c) 2005 Johannes Gajdosik

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

My implementation of ELP2000-82B has the following modifications compared to
the original Fortran code:
1) fundamentally rearrange the series into optimized instructions
   for fast calculation of the results
2) units are: julian day, AU

****************************************************************/

#include "calc_interpolated_elements.h"

#include <math.h>
#include <string.h>

#ifndef M_PI
#define M_PI           3.14159265358979323846
#endif

static
const int elp82b_max_lambda_factor[17] = {
  10,
  6,
  8,
  6,
  2,
  8,
  4,
  6,
  5,
  17,
  61,
  65,
  71,
  14,
  12,
  4,
  4,
};

static
const double elp82b_constants[9] = {
   0.000000000000000000e+00,
   0.000000000000000000e+00,
   3.850005584468033630e+05,
  -1.100000000000000039e-04,
   0.000000000000000000e+00,
   2.059999999999999765e-03,
   0.000000000000000000e+00,
   0.000000000000000000e+00,
   0.000000000000000000e+00,
};

static
const double elp82b_coefficients[37514*2] = {
   1.105109918175859036e+02,-5.838964412590721764e+01,
   5.080040976131489572e+01, 9.614724925120368937e+01,
  -8.698011461005885389e-05, 6.730779313583664129e-05,
  -3.671959463259050048e-05,-4.745177936724108978e-05,
  -2.073710617476852945e-03, 1.466252699401424282e-03,
  -9.293946793037631418e-04,-1.314436191718861479e-03,
  -3.617855385138644964e-02, 2.330832543743759783e-02,
  -1.596490289238380531e-02,-2.478029151320104012e-02,
  -4.888948222040911051e-05,-1.047943344937871234e-05,
  -8.383546762404617771e-06, 3.911158578986426675e-05,
   1.356562667407554908e-04, 2.099724870925568287e-04,
   2.435645127248505740e-04,-1.573589614729848534e-04,
   4.827828204186885653e-04,-2.238362904470958883e-03,
  -8.249676567990677986e-03,-1.779337082955210385e-03,
  -3.224692897735538717e-04,-6.998313844223706876e-05,
   3.371915197715221325e-04,-1.553715828108160604e-03,
   1.999785549413613526e-04, 3.112737995141384197e-04,
  -3.028590061097116899e-04, 1.945724519292415405e-04,
   1.066667863979930009e-05,-4.884897096147374320e-05,
   3.907917678270475683e-05, 8.533342914792933510e-06,
  -2.869788353006251795e-04, 1.415085215398184540e-04,
   1.061326882103791807e-04, 2.152367568999624897e-04,
   1.283485105872822541e-05,-3.788491251223879730e-05,
   7.573697831978059582e-05, 2.576645315654172038e-05,
   6.441613291139465154e-06,-1.893424458583573117e-05,
  -1.005076788584516627e-03,-1.775029433476721331e-03,
  -6.086883035380152629e-05, 3.456856209736538263e-05,
   6.168406919232504761e-04, 1.704104755868872444e-04,
   1.604990547881714050e-04,-5.780864587398867969e-04,
  -5.224879927899307366e-05, 2.949682981038594944e-05,
   1.259689022320738174e-03, 1.729741335401906903e-03,
  -2.422819583789297644e-05, 1.769165129660321440e-05,
   9.879616850321245884e-06, 1.546987682836719653e-06,
   7.798022519634351208e-06,-4.938816499914661784e-05,
   2.427330772953540587e-05,-1.762970592571451396e-05,
  -5.414080355369465316e-05, 4.437086188794984852e-05,
   1.901608367360665039e-05, 2.320320153197114252e-05,
   3.654765473947409193e-02,-1.544466540840305421e-02,
   1.451440206371106684e-02, 3.434631578912732131e-02,
   3.680523511731741100e-05,-1.566443956350970033e-05,
  -7.832219782820703909e-06,-1.840261756116304311e-05,
  -3.523476931034968842e-04,-1.422276147997110377e-04,
  -1.048004161136145663e-04, 2.596273930763665539e-04,
   1.409371703099417854e-03, 3.323238526757560807e-03,
   2.982627516132765715e-03,-1.264919983406863086e-03,
  -1.126406036147798665e-03, 2.780267388011208995e-03,
  -4.059194196002010972e-03,-1.644554356170559303e-03,
  -7.864080591295988590e-03,-3.197776219266543554e-03,
   2.433173940957271582e-03,-5.983744531291189904e-03,
  -1.754755426515244808e-05,-9.596007698273946421e-06,
  -9.596007403137128672e-06, 1.754755372545620018e-05,
   3.958165140971294025e-04, 9.399912313512103716e-04,
  -6.174448419976681819e-04, 2.599969625838522216e-04,
   4.156251495074537457e-05,-1.018390088141422857e-04,
   5.555170352670647956e-05, 2.267174961003236882e-05,
  -9.221194991776110084e-06, 3.869051941192209550e-06,
   2.877871154415396159e-05,-8.450512711131214587e-06,
   5.634847925969897537e-06, 1.918980168422871184e-05,
   5.712356171811873570e-04, 1.601003469981675037e-03,
   1.279891424587665483e-05,-2.713278078794343498e-05,
  -1.600287318935258399e-04, 5.732852024484151392e-05,
  -7.230478849981466702e-05,-3.422014853561282659e-05,
   9.435861497991891137e-05,-1.987164062330560503e-04,
  -2.826819083445442071e-05, 1.004536639982653155e-05,
  -8.999766092990618650e-04,-1.830564638149140754e-03,
  -3.207735482481395054e-06, 9.471559168079448499e-06,
   1.434838698250595764e-04,-7.076993092574492407e-05,
   3.692011701249497632e-04, 1.255633089971936128e-04,
  -2.326777466588696695e-04, 6.813003260728280530e-04,
   1.077509338868437420e-04,-5.280376623880682233e-05,
  -9.459199069374451147e-06,-3.244002614972057701e-06,
   9.577844801786732890e-05,-5.408433470577751767e-05,
  -2.674198461106914173e-06, 9.635801087123655327e-06,
  -4.816188890305696436e-05,-1.343251482371243160e-05,
   4.905911561614832225e-06, 8.713898768611781715e-06,
   5.246914253308580800e-04,-1.955223240487321862e-04,
   1.885386053964201180e-04, 5.059503567003624091e-04,
   9.512362726764063815e-06,-3.084632126278553075e-06,
   2.352729345742122220e-05, 4.411877672565321689e-05,
   2.647126604455395213e-05,-1.411637607933857792e-05,
   2.101107698253268364e-04,-6.886660699151413807e-04,
  -4.112870269082327841e-04,-1.254829265125651308e-04,
  -8.432475824207199058e-03, 4.482977288094784976e-03,
   2.985520572879347013e-03, 5.615761230897861958e-03,
   1.224961662262768203e-01, 3.754443833706409828e-02,
   2.912243274806684823e-02,-9.501770490728098095e-02,
  -8.208971494009360548e-01,-1.548876152988108990e+00,
  -1.536117269643426209e+00, 8.141350006345653423e-01,
   1.156742144005537589e-05, 1.631547612630864262e-05,
   2.452458344198792350e-05, 6.555662202971863407e-05,
   5.619640295788665797e-05,-2.102294674145191406e-05,
   2.560360419055462629e-06, 9.666672360462733068e-06,
  -2.376118950173989653e-04, 7.769605414852540841e-05,
  -1.053502578174090850e-03,-2.691099435705993168e-03,
   2.588667917540366827e-03,-1.013403031110916537e-03,
   8.036215187359749875e-04, 1.170695108416202040e-03,
  -3.767667684411345023e-03, 2.586308599798703162e-03,
   1.581568752102565441e-04,-1.224125752990845410e-04,
  -5.468747640246849784e+00, 1.776187280728677820e+01,
   8.008123533096799918e+00, 2.465641272718821497e+00,
   3.369550739601863523e-05,-1.971157606475702523e-04,
  -3.449587357124860227e-04,-5.896819002364533295e-05,
  -4.565627997848878232e-05, 1.000637642674713924e-04,
  -7.278190934297352674e-05,-3.320833725033078203e-05,
   9.557445389734606320e-05,-1.642027764707829453e-04,
   3.289790974747865658e-03, 1.671136929084029695e-03,
   9.545984414322998199e-03,-2.179035873813282842e-02,
  -3.876286724219982216e-02,-1.698135083480585908e-02,
  -2.931001299384914348e-03, 1.570865489246802901e-02,
  -2.429041156762174261e-02,-4.532229420956363115e-03,
   2.320990407147882021e-03, 2.971984704491202351e-04,
  -7.720726947542506881e-06, 1.097287125736922894e-04,
  -8.075655556823045700e+00,-2.497730175968885469e+00,
   1.868032037741952811e+00,-6.039716960244708055e+00,
   6.897785890029436626e-05, 1.188195549905401227e-05,
  -8.182051199673230938e-05,-3.745872602525319512e-05,
   2.913860776511863215e-05,-6.364700723155068099e-05,
  -5.526191093259380449e-06, 8.334339325992234945e-06,
   9.499792835627007110e-05, 5.545623135135909637e-05,
   8.570508479868302928e-05,-1.468149801577493102e-04,
  -8.626434519434027465e-05, 1.692837173671425752e-04,
   3.672718303673445928e-02, 1.614549331385626424e-02,
  -2.436714826427668901e-02, 5.542950574432372463e-02,
  -4.373391003878160377e-02,-8.217911599771405770e-03,
   3.028626127828734226e-04,-1.611767917036850163e-03,
  -1.821503483695584161e-04, 1.408236017634437523e-03,
  -1.496125935204283377e-04,-1.071908102568314529e-05,
   2.721590280072656576e-01, 5.166975902001017529e-01,
  -3.349036027686881356e-01, 1.764030658055885104e-01,
   5.762854011272783210e-06, 8.172485157206295240e-06,
   1.663926528416381052e-04,-1.281087141281399917e-04,
   1.962853698465861861e-05, 2.268745325067988928e-05,
   1.208766487088709825e-02,-3.890571566726516023e-02,
   2.261381520377539131e-02, 7.025914186315831977e-03,
  -2.523298936105592555e-03, 1.324977838574499522e-03,
  -7.066547663504181565e-04,-1.345759278543352203e-03,
   1.909198004088711329e-04, 5.958459226495036446e-05,
  -2.979203773032058569e-05, 9.545907223724016486e-05,
  -4.637703849760315795e-06,-8.859554334272033523e-06,
  -5.975757034175137002e-06,-2.939881506163816559e-05,
  -1.189360349727238038e-03, 3.133945418599718108e-04,
  -9.986782511787816591e-03,-3.067437900345098070e-02,
  -5.434424580135555072e-01, 2.119449839158151216e-01,
   2.890899064562443832e-01, 7.412476881920081473e-01,
  -7.485617692337589967e-09, 1.851578755193190996e-09,
   3.989259459397506287e-06,-9.169831457862654710e-06,
  -8.376497837827893923e-05, 3.291547337051713390e-05,
   6.323587248738947062e-04, 2.760634693467354161e-04,
  -7.601838744627686039e-05, 1.741298501618130724e-04,
  -2.788588908670957970e-04,-7.177211587881602954e-04,
   1.892169247796601133e-03,-7.351716071242725805e-04,
  -2.421632063010807569e-05, 5.489599085342561694e-05,
  -1.006426498721435422e-04,-4.439658781048212596e-05,
   1.998867225759243915e+00, 4.370316303986785833e+00,
  -5.826948668833781118e-05,-9.328408086017604120e-05,
   2.923432186962079152e-05, 6.734569324263303549e-06,
   4.514600952274506443e-06,-1.948379783927461657e-05,
   8.853949787609920814e-06, 2.866369781305927209e-05,
   1.032092001190869043e-04, 3.805327597168916859e-05,
  -5.102693039637364947e-04,-1.108158676170283539e-03,
  -4.356518204253681872e-03, 1.176954121367255503e-02,
   9.964723442819445332e-02,-4.572999372823911141e-02,
  -4.029639886977104402e-01,-1.497433424804340552e-01,
   2.058464133773179050e-01,-5.517797565841854324e-01,
  -3.308471239875210301e-02, 1.508100858275728852e-02,
   2.313095016859353578e-03, 8.662879576053644521e-04,
  -7.031389221383374120e-05,-1.547780715151182099e-04,
  -3.519206908753233556e-06, 9.360298218186402386e-06,
  -2.774744473756509233e+00,-4.595700749332221058e+00,
   7.475129139473542478e-05, 9.385759156601787068e-05,
  -1.206305064179896781e-05,-2.746785045054108855e-05,
  -3.886283212339232846e-05,-9.469967171478905219e-06,
   2.231935501828689384e-04, 3.675416665829248542e-04,
   1.278000366484707221e-03,-5.215686062882484569e-03,
  -6.711470690783935544e-02, 4.063887630420284086e-02,
  -1.352346144750004309e-01,-3.331970551908829820e-02,
  -1.604910597952474149e-01, 6.478216129046830973e-01,
   5.468451420954097836e-02,-3.292161920322292379e-02,
  -5.366007690141613024e-03,-1.336648847045921861e-03,
   2.316065369904152466e-04, 3.858247705873385654e-04,
   9.717947301280607735e-06,-3.880156567884079525e-05,
   2.098285781943352024e-01,-1.436425199891921967e-01,
   1.058579406408166439e-02, 1.546340260315270596e-02,
  -1.647446134629751413e-05, 1.133984670748900267e-05,
   3.736367668233433201e-04, 6.922136314747554420e-05,
  -8.743776235423214756e-05, 4.719635866560449177e-04,
   3.044649894196224844e-03, 4.459739976376685122e-03,
  -1.073656317890444065e-04, 7.329816563260873176e-05,
   1.041198753768918201e-04,-5.502301384402792823e-04,
  -4.133044594252146132e-05, 2.813883855797831189e-05,
  -3.941263350013073617e-03,-5.105565227166138607e-03,
   2.514883156073177444e-06,-1.984125406095339222e-05,
  -1.983147253761479472e-05,-2.590887297786272332e-06,
   4.079078083394395969e-04,-3.538221340760927319e-04,
  -6.972989838909774127e-06,-7.167803897042737321e-06,
  -1.957791382641293694e+03,-1.335494283533484804e+03,
   1.665747316102842206e+03,-2.441931636349261225e+03,
  -1.885582870663255712e-05,-6.667662542910496455e-06,
   6.667662541483904083e-06,-1.885582870259821712e-05,
  -4.636841898859388016e-04,-1.868243048142616530e-04,
   2.167171267698986205e-04,-5.378759763651357094e-04,
  -1.211785443863137683e-02,-5.500990568125400763e-03,
   6.521832150772438781e-03,-1.436661483009563783e-02,
  -3.030607874057892892e-01,-1.536645245786069092e-01,
   1.857376672754678382e-01,-3.663161933424834982e-01,
   2.679159157475857517e-05, 1.349854143570057510e-05,
   8.999027621874978127e-06,-1.786106104601754916e-05,
  -1.532129512306158237e-04,-4.653743358525314479e-04,
  -4.368840203038565915e-04, 1.438332218591895518e-04,
  -4.352560424474475644e-03, 8.611472384000109712e-03,
   9.958967824320397524e-03, 5.033635049598399885e-03,
   2.346563541861575175e-01,-7.692273728009341172e-02,
   4.612187309020020221e-02, 1.406968988658678921e-01,
  -9.378940528873179746e-06,-1.766452587973592212e-05,
   1.023832529181243137e-02, 3.136777154884051039e-02,
  -2.713786803282287885e-02, 8.857700337867608492e-03,
  -2.968877521308353949e-05, 4.310061060703941365e-06,
   1.337295343017913833e-03,-2.629114876885808860e-03,
   1.862658698662302166e-03, 9.474385563187750006e-04,
  -2.472411785668928125e-04, 8.034934384887080301e-05,
  -4.944573364920816207e-05,-1.521483670797472217e-04,
   1.781485451972478510e-05, 9.090157228620493219e-06,
  -4.780988140129753137e-05, 6.413436093792859933e-05,
   1.360140535389925886e-03, 8.979076956482613062e-04,
   5.728953011562900330e-04,-8.678153950718931397e-04,
  -2.199471000230786191e-05, 3.341006931920942368e-05,
   2.056823044734225759e-04,-4.224098095943836260e-05,
   5.229829755299274290e-05, 2.546539904237898866e-04,
   1.299309895105208010e-04, 6.367938561340054588e-04,
  -2.645186990424913090e-04, 5.397221719330464612e-05,
   2.759652805709857812e-05,-4.168701580396886745e-05,
   2.501533334953202962e-05, 1.655998481360016405e-05,
   1.832037775127502710e-02,-3.152941238032477833e-02,
   5.796284477952614298e-05,-1.547770636118794957e-05,
  -6.661818462701345461e-04,-3.859521969030312678e-04,
   2.346456563761983079e-03, 8.832545702659282127e-03,
  -2.320054830858857189e-03, 6.131752289719621420e-04,
   1.814167428955092143e-04, 1.057235841385357637e-04,
  -5.085697799105820278e-06,-1.934258715622525708e-05,
  -6.420621123532811204e-03, 1.468586578786658207e-02,
  -4.583850106398594732e-05,-1.997077415141834810e-05,
  -3.805248532709509541e-03,-9.699001022420031606e-03,
   2.384054701309870020e-03,-9.318340767369570491e-04,
  -2.838479876529996352e-04,-1.245296400311861579e-04,
   1.088554221194937583e-05, 2.795541040213626164e-05,
  -7.031353856838945668e-04,-2.606938465884736872e-04,
  -6.928740974011364664e-06, 1.876146445550176388e-05,
  -2.814219667723142233e-05,-1.039311145879336867e-05,
   4.723893417300402409e-04,-2.172135731940539704e-04,
   2.924388888919387007e-05, 6.359870250673125051e-05,
   6.664965408169355699e-05, 1.454366865783384615e-04,
   1.046496299479353179e-05,-2.811555707286629525e-05,
  -5.871003942036558255e-06, 1.911887320718957183e-05,
  -7.016320213884700507e+00,-3.946689216088255847e+00,
   4.845973050383182823e+00,-8.615043345886725490e+00,
  -4.810492317806335129e-05, 1.363511518222796994e-05,
   8.181069107586383298e-06, 2.886295390066257680e-05,
   7.680356201169608477e-04, 4.294421434184970076e-04,
   3.269606375168342995e-04,-5.847526141475160606e-04,
   8.115163225316347894e-06, 5.843297513089094529e-06,
  -6.444019494028772096e-05, 1.012149413506331690e-04,
   8.748391732051109159e-06,-1.798515059994160357e-05,
  -4.191254016462858147e-03,-1.485912413108160697e-02,
  -1.459928692261529964e-02, 4.117962769010869058e-03,
  -2.079993022804954938e-05,-1.283125723475556351e-04,
   1.974229219081914915e-05,-3.200296686426989023e-06,
   1.737807401709415365e-03,-3.846216886504630729e-04,
  -2.835925698325687631e-04, 9.778195271601281555e-05,
  -1.439069894103052472e-01, 2.566004769606539671e-01,
   2.991782641276370946e-01, 1.677855154346072353e-01,
  -6.496990299956749990e-04, 8.998751422784425670e-04,
  -3.323901274313634290e-04,-2.399816743748595625e-04,
  -1.925778441745571584e-02,-1.229538601067885553e-02,
  -1.725362749182118502e-03,-8.419828935771868708e-04,
  -2.782957800319453036e-04, 6.639709296513719976e-04,
  -9.129625383577247375e-04,-3.826577496180638086e-04,
   8.484843774834917741e-05, 2.999364509157184089e-05,
   7.096923466254974500e+00,-1.992019255514718701e+00,
   1.337741822187768825e+00, 4.765943553704228286e+00,
  -2.451116344113837966e-05,-2.387183659603311177e-04,
   4.284573785883668759e-03,-6.889300211210762749e-04,
   1.519137214315665306e-03, 9.447774499688034802e-03,
   5.771451116990387875e-02, 2.623548168381352186e-01,
  -1.022057871717380606e-01,-2.976559175382402778e-01,
   1.426403950317785101e-02,-5.827720744425677127e-03,
   6.353385056767666761e-04, 1.555066541500264897e-03,
  -1.936766039213929226e-04,-4.061412549220618667e-04,
   2.629747581429959464e-05,-1.443754708377873674e-05,
   2.022111851822878392e-01, 7.239658185857767991e-01,
  -6.332930155277344264e-01, 1.768853279394923539e-01,
   4.391936837671704691e-07, 9.990350790044313052e-06,
  -2.997105236372042033e-05, 1.317581051019603807e-06,
  -7.162531818007252188e-04, 7.261925069095343291e-05,
   2.588947436262002515e-03, 1.623335607181559254e-02,
  -7.820446588733605264e-03, 1.247229781491592882e-03,
  -6.754856585089973053e-02, 1.476934921507518615e-02,
   5.532993992530085836e-02,-1.891961735932511449e-02,
   1.425043208384895463e-03, 3.500726233198003887e-03,
   9.934320158155567483e-05,-4.721816045892820242e-05,
   4.801316202057018231e-06, 8.771964587700112128e-06,
   3.163738083045992272e-02,-5.607637225891685256e-02,
   4.013042897517565127e-02, 2.264093794290463965e-02,
   2.323267867559340266e-05, 1.898005905039885943e-05,
   7.812183892245720337e-04,-1.076234742242103415e-03,
   6.797269602542313450e-04, 4.934009098201656710e-04,
   4.669852370202861799e-03, 2.998347199606275684e-03,
  -6.076096726920597949e-03,-2.984396679033155062e-03,
   2.138819757584667499e-04,-5.066554336496504295e-04,
  -1.883942840310089031e-05,-6.713861589609627930e-06,
  -5.183158252890312200e-03, 1.440576277227122821e-03,
  -8.970127902912765220e-04,-3.227430105884915301e-03,
  -1.086430841862662716e-04, 1.718448824069422913e-05,
  -9.373889309025947391e-06,-5.926322803966755780e-05,
  -9.767533030688170222e-05,-4.494746465878276588e-04,
   2.256207977016011967e-04, 6.625852638059865360e-04,
  -6.486774396463101716e-05, 2.630923398617061008e-05,
   3.829158496262047881e-04, 2.166801060938868418e-04,
  -1.231133339511353796e-04, 2.175651827020380906e-04,
  -2.165439751376352007e-05, 3.363163790712418814e-05,
   3.094055490918273007e-05,-6.279078007089772891e-05,
  -1.066211607649428971e-05,-3.855281158062745625e-05,
   1.927640578618941290e-05,-5.331058037106491324e-06,
   5.903290374967486858e-05, 5.399181673996184081e-05,
  -1.724309155580537644e-03, 2.116163663111901225e-03,
   5.114001656118729450e-02, 3.702193050106708516e-02,
   1.664637565974385822e-02,-2.299436888896187747e-02,
   5.854636725871914527e-01,-9.144120177540011607e-01,
  -1.686299858190947742e-01, 3.444340280715728064e-01,
  -1.673783121795833356e-02,-7.040615745630633693e-03,
  -1.471611166387360597e-04, 4.146152554963572121e-04,
  -3.839819955683892251e-05,-1.120617110315451348e-05,
  -1.399580575316530258e+02,-8.687476251513956527e+01,
   1.078948548971674768e+02,-1.738221075014222379e+02,
   5.241267470943025898e-05,-8.516504562841973214e-05,
  -5.109858417191258238e-05,-3.144733206625761456e-05,
  -1.731816627137062721e-03, 4.111156312838872354e-04,
   2.748475382197319047e-04, 1.157789926717574421e-03,
   2.509441122194712090e-02, 1.548794499145890111e-02,
   1.225800753949181365e-02,-1.986109081142600069e-02,
  -1.099029419364156712e-01,-4.656094109773362133e-01,
  -4.818038260516962490e-01, 1.137254889418030518e-01,
  -3.362681232178614931e-08,-9.999943461714825256e-06,
   3.992688601045613441e-05,-2.417389813009589398e-06,
   6.438876871812721956e-05,-2.746063478806562273e-05,
  -4.529053077911538772e+00, 7.317291660747720528e+00,
   8.550799015769163347e+00, 5.292535052103548132e+00,
  -3.525889667280623674e-05, 3.545151908474971513e-05,
   2.468665487172782571e-04, 2.189613584783051115e-04,
   2.476490508423231929e-03, 9.975127745835493057e-04,
  -3.840708491346060135e-05, 1.136835842240464079e-04,
   2.000015177201366043e+02,-4.693898209384548892e+01,
   3.476116969567661386e+01, 1.481132821108642759e+02,
   5.499564248423723941e-07,-9.984865944557023290e-06,
  -1.499957633020390776e-04, 3.128171753316788726e-07,
  -6.116748254188844863e-04,-1.032124863978556815e-02,
  -4.603194743533107168e-03,-1.083173242923229918e-02,
   8.336990158065778634e-04,-4.119724618141984603e-04,
  -9.869240157224905217e-06,-1.739534704221273518e-05,
   3.301877269482275334e+00, 1.415013441534562411e+01,
  -1.249570628672083750e+01, 2.915823082889245743e+00,
   2.995246621690118228e-05, 1.688125447173092312e-06,
   1.454861905984242882e-07, 1.799858762706052766e-04,
  -8.499372185174356364e-04, 6.870212859591342337e-07,
  -1.666098155013554308e-02, 9.660382439911122630e-04,
   2.062554529053602006e-03,-8.734218315403387408e-04,
   1.104579483675917497e-04, 2.242518397523658887e-04,
   6.220049368706475068e-01,-9.992197136807747793e-01,
   7.205935566489587440e-01, 4.485627570955048049e-01,
   7.069867552270364332e-06,-7.072267867760288770e-06,
  -9.193948226121262846e-05,-9.190827815985029808e-05,
   4.552915152265368109e-04, 4.059091026777678513e-04,
  -3.335671717974582578e-04,-1.353498001232324752e-04,
   1.612442086170878480e-05,-4.732867050609483134e-05,
  -9.078582678455002219e-02, 2.106228220297135315e-02,
  -1.322041823403583699e-02,-5.698464146706538891e-02,
  -3.396585780605465815e-06,-5.990378289419616669e-05,
   1.943837495207635481e-05, 4.606679475742252069e-05,
   6.192242098054753265e-03, 3.865594777769149407e-03,
  -2.186973076709126940e-03, 3.503281521071883575e-03,
  -1.281059937826906276e-04,-5.554029553138531763e-04,
   2.923272634175368557e-04,-6.742649500076139651e-05,
  -2.122531908114914467e-05, 3.390406804357562893e-05,
  -1.695203401816078550e-05,-1.061265953830394975e-05,
  -6.708152857953482776e-05, 6.000057102589151711e-05,
   2.025102238616451229e-03, 2.019250412998622492e-03,
   2.471119211539425111e-04,-2.478280561421394531e-04,
  -5.857312102741552007e-02, 6.586822560348563893e-02,
   1.682493225336741283e+00, 1.332232446873560461e+00,
   4.078900970717588836e-01,-5.151295681288212691e-01,
  -2.978834211524211112e-05, 3.557340864366682066e-06,
   2.827913988917936839e-04, 2.227471124264036092e-04,
  -2.475089654323369079e-05, 3.142281208965041394e-05,
  -4.281592021442405332e-04,-3.624616780524816863e-03,
   7.845022520143068480e-04,-9.266961961539305472e-05,
  -1.737759960521174582e-02, 2.200407694293556038e-02,
  -1.191233307652748985e-02,-9.407699995989837749e-03,
   6.061448986015340740e-02,-7.081624826587772092e-03,
   3.752111635930253930e-02, 3.211584040097259507e-01,
   4.298350843755254641e-02, 3.720351899836372156e-01,
  -2.080250084424395685e-01, 2.403440573995381177e-02,
   1.794979888232242637e-02,-2.260963435643081540e-02,
   1.412808264406529256e-02, 1.121629116402195203e-02,
  -2.304892638258958498e-03, 2.633157617397221574e-04,
  -1.441421967313904183e-04,-1.261725792309598788e-03,
   1.486515882181223464e-04, 1.183243941346099324e-04,
  -5.604998330139116897e-05, 7.041590280929208305e-05,
  -1.122347891864790795e-06,-9.936817156898212653e-06,
   1.700702602776345174e+01,-2.419783205355516742e+01,
   1.640677765811361956e-05, 1.143755423494130621e-05,
  -5.076563576729237420e-05,-2.855120252075643615e-04,
  -2.383273178595321246e-03, 3.409433073960927568e-03,
   5.418038723652349870e-02,-9.562206196414813411e-03,
  -5.324509008540198041e-01,-3.732088210356286351e-01,
   1.282789846565418168e+00, 7.323044298436888866e+00,
  -1.739882979559449927e+00, 3.024883682864513701e-01,
   1.054164546214487880e-01, 7.429144817924598909e-02,
  -1.674705105056737472e-03,-9.706179854028525525e-03,
  -4.385799934816969506e-04, 6.206417299632135823e-04,
   5.913933739032091968e-05,-1.012614304825831181e-05,
  -3.804398565414072397e+00, 6.990353601004002826e+00,
   1.716773547229713228e-05, 5.749146770394047962e-05,
   3.806091178507562409e-04,-7.036210357797666052e-04,
  -8.962125108009193208e-03, 2.663750448403476127e-03,
  -5.456318950889942759e-02,-2.960495920483751167e-02,
  -2.515716592804091878e+00,-8.503823165117079697e+00,
   1.088409292399434181e+00,-3.204768490626035415e-01,
  -1.087203107930933554e-01,-5.934956150370756384e-02,
   3.405558154617558710e-03, 1.162077419130585001e-02,
   5.330768959732114795e-04,-9.735656270931250609e-04,
  -9.599987747579330672e-05, 2.800042007957511179e-05,
  -3.455206663420394286e-01,-1.632125430763858298e-01,
   4.612657973978904298e-04,-9.764988809905409501e-04,
   1.810572330821640547e-05, 8.496045167388724276e-06,
   1.017458264071530967e-05, 2.822193948131939952e-05,
  -4.327130581264505816e-04, 1.560018499982403445e-04,
  -9.187441343226345966e-03, 1.951429390426425228e-02,
  -2.735800721920363110e-02,-1.288030649876967595e-02,
   4.011402962783068293e-01,-1.440405739955775422e-01,
   1.261842233686072748e-02, 3.514119344545605511e-02,
   2.482717716039396089e-02, 6.942012459587340589e-02,
  -1.633349586726053860e-09, 5.841455887694380352e-10,
   4.312438026589313252e-03,-9.099313230830678723e-03,
  -1.102114074547201486e-03, 3.925694115226077132e-04,
   1.083724990708600085e-04, 5.153058747129172921e-05,
  -3.343424024135534532e-06,-9.424516740652188570e-06,
  -3.537961015232998514e-03, 8.751306138097129581e-03,
  -8.427578479769564160e-04,-2.859186905259696520e-04,
  -5.334071525831341064e-06, 1.927557213047943088e-05,
   1.951189922232588714e+01, 1.458109382286201949e+01,
  -1.845148946426187919e+01, 2.469112450013843585e+01,
   1.475614945761779724e-06, 9.890528829736278173e-06,
   8.933164073648409531e-05,-1.205005318747035832e-04,
  -7.229948330201834013e-05,-5.359836481456377544e-05,
  -1.711338086579910090e-03, 2.530887323182128522e-04,
   1.697008804623521198e-04, 1.147485221492291910e-03,
   1.459822834916044837e-02, 1.085114229163891726e-02,
   8.453032901851228326e-03,-1.137201054300734059e-02,
  -2.556007077823116425e-02,-1.743708847554498453e-01,
  -1.667921282521719339e-01, 2.444914246639491584e-02,
  -1.487326669821318559e+00, 1.995597685636876006e+00,
   1.151994535335865572e-01, 8.585859806440081232e-02,
  -2.810206512904902354e+01, 4.082671596889101195e+00,
  -3.480473230136504004e+00,-2.395698088176742857e+01,
  -4.153414932643181290e-01,-2.884792157688462755e+00,
   2.589703932343965231e+00,-3.728558036687428801e-01,
  -1.979713615321918577e-05,-2.841372930627352278e-06,
  -1.740258719025016554e-01, 2.322560013349418973e-01,
  -1.700686331772942317e-01,-1.274298274396951092e-01,
   2.649089677252509240e-02,-3.779530632116568419e-03,
   2.406694654678925242e-03, 1.686862890283890443e-02,
  -1.886781904310056227e-03,-1.417503126085562209e-03,
   8.108597160574618429e-04,-1.079303044231076474e-03,
   2.799497318514117676e-05, 1.980264573128484151e-04,
  -1.089170071699518483e-04, 1.539758240643310371e-05,
   1.203351646110122082e-05,-1.597480771653937741e-05,
   4.000045901328066225e-05,-2.999938797253794159e-05,
  -1.276357741264922806e-03,-1.513517584425112285e-03,
  -9.173507113347100926e-05, 7.736069233128056667e-05,
  -1.527269875562996905e-05, 1.291296529538350673e-05,
   1.693842237447598241e-04, 1.428995689666282181e-05,
  -2.560143574085837626e-06, 2.989056146813015439e-05,
   3.985127922467432068e-04, 3.413284709788115697e-05,
   3.218477779841731606e-05, 3.826408338111234947e-05,
   3.963800713625426769e-02,-3.750112777285947302e-02,
   1.999335492010422468e-05, 5.155182234841946442e-07,
  -1.032273507502025025e-04,-1.088306668963057568e-04,
  -9.251439004812952581e-05, 3.418538778358781987e-03,
   4.647845557889336565e-03, 1.317232804575796173e-04,
  -1.441216597879725050e-04,-1.527242037975672518e-04,
  -5.921198221631560426e-07, 1.999123293136772860e-05,
  -1.045674203068461816e+00,-9.858995131063800210e-01,
  -9.309943773171089343e-02, 9.874401910341977506e-02,
  -2.998405284920997624e-05, 9.780463873371151122e-07,
   1.458654652256793915e-04, 1.368251254750071802e-04,
  -2.052432069587462288e-05, 2.188040812205682088e-05,
  -3.633519867870252184e-05,-1.159372697938181951e-03,
   2.098969415066837029e-04,-6.578253123659459697e-06,
  -2.370237107334974974e-03, 2.520385020954516754e-03,
  -3.787863788721114065e-04,-3.562207851146904653e-04,
   2.278850702775732373e-03,-6.850682684579477877e-05,
  -1.423017810849033261e-03,-4.733608733061279300e-02,
  -2.437416951009614349e-03,-8.468040750834911201e-02,
   5.524416859705676142e-02,-1.590132557753961033e-03,
  -6.106523920321367711e-03, 6.460209717897269152e-03,
  -3.902286978240302167e-03,-3.688643220136701532e-03,
   8.496361375070537797e-04,-2.336968553059497699e-05,
   1.209717185778845200e-05, 4.398088437499294364e-04,
  -5.806738594440584710e-05,-5.502888959068153693e-05,
   2.751444478945380817e-05,-2.903369296599100753e-05,
  -7.780848083434593221e+00, 9.258870402127337584e+00,
   2.304077838885600183e-05, 1.921256180824479085e-05,
  -2.508597310649990497e-05,-2.788640480572483716e-04,
  -1.584193205730814128e-03, 1.894927359712020179e-03,
   1.810820247494021248e-02,-1.605660558052355918e-03,
  -6.064166977692398569e-02,-5.082924534863211136e-02,
  -6.885904818667046290e-02,-7.880118549962450425e-01,
   8.196810912086188727e-01,-7.057164928328914233e-02,
  -4.804682864477868853e-02,-4.048177765299658393e-02,
   4.191352667203002559e-04, 4.942052366998826891e-03,
   2.581176950599184026e-04,-3.055607082682646977e-04,
  -2.989590114679625338e-05, 2.497017144712155568e-06,
   6.977692623577613773e-01,-1.054279000272361211e+00,
   1.012617042051539454e-05, 4.896387109507049137e-05,
   1.869202955525600522e-04,-2.839966189831510403e-04,
  -1.586782141344114053e-03, 3.260481330645923913e-04,
   4.530880368115682705e-02, 2.990425848287794203e-02,
   2.635923583514860336e-01, 1.291190207512115773e+00,
  -2.322804066468185658e-01, 4.711035521479862292e-02,
   2.617791100395474788e-02, 1.737383904574725177e-02,
  -7.011601269531698077e-04,-3.479921072525569287e-03,
  -2.049899661524634922e-04, 3.080126579412673636e-04,
   3.922202975460874821e-05,-7.850629396971053997e-06,
   5.651409551575014428e-02, 3.292670540018760583e-02,
  -7.198470526368599531e-04, 1.235517024707213267e-03,
   2.597061957282632581e-05, 1.504248953668156646e-05,
  -6.164123774433944846e-05,-2.319338687224479850e-04,
   2.899229816133308416e-04,-7.705304764506491809e-05,
  -5.023113732671261405e-06, 8.646844109525819179e-06,
   1.755220413606240881e-03, 1.019640420455543038e-03,
  -6.517666664358663653e-02, 1.723295927909581846e-02,
  -1.502964735187844059e-03,-5.684353449452604970e-03,
  -4.082661251128257528e-03,-1.552119576533911305e-02,
   1.450654671962588063e-04,-3.815770194211242099e-05,
  -1.321773800269142015e-03, 2.261993613652233098e-03,
   3.385815579390021447e-04,-8.859755422021546210e-05,
  -3.451020913813093971e-05,-2.022487244069698199e-05,
   8.022506180643012479e-04,-1.577622865132854773e-03,
  -1.516275813019462930e-04,-7.686187386754075629e-05,
   5.959022329951473062e-04, 1.825062989577798086e-03,
  -4.944961824523693783e-04, 1.607595948813150897e-04,
   8.907896186156074008e-05, 4.544159497274065872e-05,
  -6.159105726914100858e-06,-1.902801662403872204e-05,
   1.556711180793944008e-04, 6.827679779862692020e-05,
  -1.490115992194226979e-04, 5.826055227230198132e-05,
  -2.177685334025601440e-05,-5.590857410627622529e-05,
  -4.028307557808210281e-06, 9.152744846203529202e-06,
   1.438586478233070953e-01, 1.175013304642878731e-01,
  -9.338869305416230837e-02, 1.143371828359073944e-01,
   1.989255952247582864e-05,-2.070283952687714225e-06,
  -3.802632220661828128e-04,-3.089766476888990729e-04,
  -2.585313712634166520e-04, 3.181792959990983644e-04,
   4.717149349384798561e-05,-5.171895398748757323e-05,
  -5.852820694630903171e-06, 8.108297596690704659e-06,
   9.651133053978319968e-04, 9.389866103093788899e-03,
   1.030498071167981408e-02,-1.059171013464542442e-03,
  -4.717906564044346365e-07, 3.999721757293286565e-05,
  -2.999791317328138413e-05,-3.538429922276206210e-07,
  -1.018875506214993133e-03, 4.620081527081985971e-05,
   2.961905361124835372e-05,-4.765675521266193227e-06,
   4.298999093138967442e-06, 1.953250129392521928e-05,
   1.578253485712440563e-01,-1.937324571960052644e-01,
  -8.440809007133390218e-02,-6.876357441883482191e-02,
  -2.625053013121767624e-05,-3.018128008932081401e-05,
   4.295062818507758496e-05,-4.189562672293158563e-05,
   3.840084758658784134e-04, 3.936784470586762188e-04,
   9.312572172126007755e-03, 8.515564934425007629e-03,
  -4.082486197424952008e-03,-2.954803316099890390e-03,
   3.234451967517050475e-04,-5.052907687633180142e-04,
   3.873861274984252093e-04, 2.479724348304884057e-04,
  -3.486502545101366436e-05,-1.960688655294790756e-05,
  -2.508310165492633637e+00, 2.545732339888693296e-01,
  -2.376533793244138826e-01,-2.341598831435568240e+00,
   1.983819112126643543e-05, 2.538931475267810525e-06,
  -3.225337533507043525e-05, 4.588185498245119800e-04,
   6.538848632287899872e-03, 8.548216162581083119e-05,
   1.401175901796167798e-04,-1.071811586744919088e-02,
  -4.637385358358796575e-03,-1.052392465187709653e-01,
   1.785402385012271192e-02, 1.118750276869305837e-01,
  -5.030571232446581255e-03, 1.100467518542169862e-03,
  -8.548097994966831863e-06,-3.907595193957251906e-05,
   3.229192271976620809e-05, 1.155670075166410232e-04,
  -9.461779646971456845e-06, 3.236468123148549610e-06,
  -1.338911368295427713e-03,-1.336215491841766939e-02,
   9.073920206316815271e-03,-9.092227259315340719e-04,
  -5.984687645443420508e-05,-4.283850913335913677e-06,
  -2.869537681751233870e-05, 1.999623124703672154e-03,
  -1.869642751814743625e-03,-2.683010744107368274e-05,
   6.163855258916182099e-03,-2.637241110170606816e-04,
  -1.432061717362233082e-03, 2.266660909134670635e-04,
  -2.549322504248256497e-05,-1.172544113294849848e-04,
  -4.181327141168119494e-04, 5.105937407583722261e-04,
  -2.785072506157988876e-04,-2.280736783577299567e-04,
   1.004585495790598929e-04,-9.749145285507870514e-05,
   6.964296409267024812e-05, 7.176250795581145463e-05,
  -1.840505428938470122e-04,-1.691640203245262639e-04,
   7.276726603043523283e-05, 5.295093132958592010e-05,
  -2.444463372394730657e-05,-3.166164686339069953e-05,
   7.779550100369335116e-04,-6.748924010561895221e-04,
  -1.637917595283387706e-02,-1.683459234578936481e-02,
   5.733345428445348361e-04,-5.578244583651591464e-04,
  -9.998779073041747385e-06,-1.562595549156807004e-07,
  -9.064611178812642667e-02, 9.887618512968915363e-02,
   8.703847180355286928e-03,-1.199333797618789069e-02,
   8.078071501377506606e-04, 5.185467220888788625e-04,
   1.473854969776865929e-05,-2.612996656726531959e-05,
  -2.836370602455203730e-04,-2.528203297574020030e-04,
   1.596770180005502380e-04,-1.791403405648041910e-04,
  -2.486911181553407441e-05,-1.677877461277978700e-05,
   6.842392326142043260e-05, 3.534420590964715129e-04,
   1.963568886830657095e-04,-3.801332732569372743e-05,
   2.784969609008776988e-03,-4.116468118098653983e-03,
  -2.517920114462793291e-03,-1.703482401785171843e-03,
  -6.726847567351416923e-02, 1.293359666992114493e-02,
   8.949669772546893151e-03, 4.654781332254321474e-02,
  -5.586756373984084842e-07,-2.999479757444909966e-05,
   7.847354825923635868e-01, 5.323699207898741070e-01,
   4.370814770280264661e-01,-6.442763394649987374e-01,
   3.394539774299953439e-05, 3.671116958188014919e-05,
  -9.719921272668665064e-05, 1.007598923130315717e-04,
   8.242037274018043002e-06,-1.822275559770522948e-05,
  -2.474622331552594812e+00,-1.295992102230014176e+01,
  -1.414709811909226822e+01, 2.701306965677637617e+00,
  -7.067451940312380916e-06,-1.870965320553469904e-05,
   5.332916322289291322e-06, 8.982935127174045164e-05,
   9.982424126096098240e-05,-5.926284872862001379e-06,
   9.540207340327748063e-06,-2.398033501112854435e-04,
  -2.299614888915363473e-04, 3.989407319129867359e-06,
   2.171232743115432406e-03,-8.172578326812227458e-04,
   1.215356379472790088e-05, 2.742792166912176368e-05,
   1.645675299795202153e-04,-7.292138275276535654e-05,
  -1.779300481215541851e-05, 9.132851677029151684e-06,
  -1.190487580602963789e+02, 1.750013292605094932e+02,
   2.035290862332481936e+02, 1.384554337249987839e+02,
  -3.725336682539906013e-06, 9.280186776230453939e-06,
  -1.318824475962541640e-04, 2.915057602858098489e-04,
   3.279430918779705374e-04, 1.483673515979415684e-04,
  -2.658247978335733785e-05,-1.390581779570689408e-05,
   6.178568658116369728e-04,-6.949534548302202519e-04,
  -3.885786931796419877e-04,-3.454706380987907768e-04,
   4.248769886212112244e-05, 4.235618271917702054e-05,
  -1.568102436647392082e-05,-1.241392262010889218e-05,
   6.960378422474778233e-06,-7.180050989787435778e-06,
   3.174535126407655017e-05, 3.862942755362022647e-05,
  -2.719759067172631585e-04, 2.508419965520587215e-04,
  -1.355939325985473623e-05,-1.470179765380547948e-05,
   1.469956338892810903e-02, 1.421639573086538530e-02,
  -3.661173194805844022e-01, 4.245910707749174784e-01,
  -3.579317970131272730e-01,-3.086382147418824662e-01,
  -1.234979347509504244e+01,-9.475820839827148845e+00,
  -1.393067234005712196e+00,-8.355281739488051862e-01,
  -2.488743568956807706e-01, 4.743935133959301109e-01,
  -6.854407723794421203e-01,-3.595930943381990263e-01,
   5.974378604125807346e-02, 2.711370353462665139e-02,
  -1.016904330179181637e-03, 2.630171690271895790e-03,
  -1.305800248262115482e-04,-5.048620710648459486e-05,
   1.142095259620409190e-04, 3.681366150088208073e-05,
   4.506142165873636259e+03,-8.544583597833725435e+02,
   6.891483194234098164e+02, 3.634349486008986332e+03,
   2.483216578694956108e-04,-1.058743737339500881e-04,
   4.705418882155182591e-05, 1.103626285170197048e-04,
   3.390556856407673541e-06, 9.407663057500886025e-06,
  -4.440652686933160315e-06,-8.959944403512407285e-06,
   7.598656186381637194e-03,-2.859259486468277833e-03,
   1.500054406823924172e-03, 3.986485924857701389e-03,
   9.242348258508038274e-05, 2.958560514580547171e-04,
  -1.376880830978421250e-04,-3.108183189070519480e-04,
   1.779394707018969459e-05,-9.131015697242428442e-06,
  -1.876627156201370918e-03, 1.090050199594472393e-04,
  -1.206015059812991561e-04,-2.076271911949470993e-03,
   2.995264024288021062e-05, 1.685034860349464190e-06,
   1.685034859988940922e-06,-2.995264023647163388e-05,
  -8.202384118060372916e-08,-8.998747478672659427e-05,
   5.743757452107262526e-06, 4.966899687261020895e-05,
  -9.998890681278261829e-06, 1.489467819281651146e-07,
  -2.978935637925748004e-07,-1.999778135827785531e-05,
  -2.963915240234127449e-05,-4.639034907261144985e-06,
   4.507398038377452229e-05,-4.577666964096081706e-04,
  -8.492558104785358220e-03,-3.487276412904470797e-04,
  -1.600033955972107912e-05, 3.896559874187099297e-04,
  -5.287543602610177487e-03,-3.290194023029376358e-01,
  -1.785478160249127366e-01, 1.308916916717603462e-02,
   6.398515113260193621e-01, 8.728139155997212129e+00,
   2.164110053761398333e+01, 1.651623270650090092e+02,
  -4.829021440101073637e+01,-1.935505600983409238e+02,
   8.943071523524462663e+00,-2.782237096370251628e+00,
   1.771439675079580778e-01, 5.694019296383290296e-01,
  -8.595596366836581737e-02,-2.292493734281318418e-01,
   1.823097394115875264e-02,-8.050471517839746793e-03,
  -1.730851415869871844e-04,-3.382745128808023428e-04,
   3.451128406150911246e-05,-2.022303816012389435e-05,
   3.552074443215136768e+01, 1.886410832088855045e+02,
  -1.677844912900466454e+02, 3.159348925171750722e+01,
   1.954879315233165455e-05, 4.601326258519308592e-05,
  -3.681520748109675555e-05, 1.564098773860317474e-05,
   4.667366844304342960e-04, 1.245203732638314664e-03,
  -1.057955704101528347e-03, 3.965509616329101995e-04,
   4.839516453455836992e-06, 1.940564558309592144e-05,
  -7.637919489575480320e-05, 2.375333008431746153e-05,
   9.147081554145670371e-05,-4.038059551278459552e-05,
   2.268511199724003566e-06, 3.993562140416406293e-05,
   1.148859002741217632e-06,-1.996697580986716631e-05,
  -5.999375207333545204e-05,-2.193859059445752657e-08,
   1.558961920081388810e-06,-9.877734443268666991e-06,
   7.462657301503636438e-04, 7.444350770895470366e-05,
  -2.368957913733399205e-05, 5.594799995706931312e-04,
  -1.864267122206471339e-02,-7.893705504848857156e-04,
  -2.911209673586909741e-01, 4.306588913331237112e-03,
   4.585590851494570908e-01, 6.366655562992713513e+00,
  -4.120440102220999989e+00, 2.967751631909285037e-01,
  -3.307999395435736290e+01, 4.291480307798599902e+00,
   1.467646061443077876e+01,-3.641822582035717737e+00,
   2.929469858524015313e-01, 9.458901723541158768e-01,
  -1.728975549221079639e-03, 5.354725004661462255e-04,
   2.845912037202933190e-02,-1.062917442012152949e-02,
   1.385525113356258706e-03, 3.148514852205530797e-03,
   6.235696390125347599e-05,-3.180580219107466644e-05,
   5.044736105865202817e-06, 8.634271111227630354e-06,
   8.118414539579246636e+00,-1.186874218647730572e+01,
   8.620914161560916611e+00, 5.896846841396750527e+00,
   4.973485130976834775e-05,-1.091876792361952533e-04,
   8.189217996185064606e-05, 3.730178553410709575e-05,
   5.063451846918584778e-05, 6.193662518569830692e-05,
   5.894554132989788490e-05,-5.408718108133665130e-05,
  -1.480588395860226890e-03,-1.613581679353983875e-03,
   7.134415808432020834e-03, 6.935267885218496763e-03,
  -4.101989065248617602e-03,-1.874268907029368395e-03,
   2.141621248012803131e-04,-5.497404674101265048e-04,
  -9.509903057831286361e-06,-3.092206951458965786e-06,
  -1.041447880974236462e+00, 1.947256338463563829e-01,
  -1.230816793577787227e-01,-6.582757062947872662e-01,
  -9.368297554863548363e-06, 3.497856618493341181e-06,
  -1.998099860264310342e-05,-8.716047505460012708e-07,
  -8.716047503595163796e-07, 1.998099859836802649e-05,
  -1.256818091406152531e-05,-9.298959437050458845e-04,
   1.952593785578609568e-04, 5.248420419987035335e-04,
  -7.326476594665009461e-05, 3.212902225064716982e-05,
   6.403533471048930559e-02, 4.392137571979889271e-02,
  -2.501225656846954928e-02, 3.646671341636932573e-02,
  -5.583548134975076525e-05, 5.729222479919622531e-05,
   2.500507365281058451e-05,-5.454123478266254140e-05,
   9.313259022445831612e-06, 3.641868528768072529e-06,
  -1.036808707575366745e-03,-5.584618129380415630e-03,
   2.929957820448879369e-03,-5.439594455148536335e-04,
  -2.323417778389352199e-04, 3.378177820192726022e-04,
  -1.647888484323050383e-04,-1.133372369682071444e-04,
   2.950294922136852601e-05,-5.438380939337575547e-06,
   8.830674843958643422e-05, 1.212417912145179487e-04,
  -1.709135767859213144e-03, 1.400900717446433054e-03,
   5.089735266772885125e-02, 5.532717220587082124e-02,
   5.482679607471407229e-03,-5.043703959914775346e-03,
  -1.521918334643607151e+00, 1.569626632970887892e+00,
   4.174118618980820372e+01, 3.608573373260206552e+01,
   6.749992434761108662e+00,-7.807869256226527277e+00,
   3.430098473118714313e-05, 2.057771723177443616e-05,
   1.543328792052876743e-05,-2.572573854288615430e-05,
   4.659751133856490922e-05, 5.221995592382772068e-05,
   7.162108373082645544e-05,-8.349018612353683211e-05,
  -1.106807518066185670e-03, 8.398192360390915423e-05,
  -9.079215870434860370e-06,-1.196560396846564611e-04,
   8.165330735790742728e-03, 7.022656650131888813e-03,
  -1.225868726674633410e-03, 1.425332903292810200e-03,
  -6.809258354171368773e-03,-9.128523072536570693e-02,
   2.901900675463843851e-02,-2.164620854914155006e-03,
   2.972186753186975561e-01,-3.429133734163911651e-01,
   2.145966685563675258e-01, 1.860007293407017481e-01,
  -3.327640874857989983e-02, 2.354020434154057394e-03,
  -1.277916939420642222e-03,-1.806462076790645022e-02,
   1.864390680709608096e-03, 1.620127157835289612e-03,
  -7.805480476798501346e-04, 8.982298080138375425e-04,
  -1.247250339481774323e-05,-1.795690985133068071e-04,
   7.980771910258600702e-05,-5.543281420249075841e-06,
  -6.568927157576488139e-06, 7.539840581766573221e-06,
   3.802743318509092205e+02,-4.943013088329804532e+02,
   1.703939897261324502e-05,-3.618230794748541015e-05,
   5.482104268247979832e-04,-1.044712914671459391e-03,
   2.615272000071356957e-04,-2.616699861142395456e-04,
  -6.937137024203863047e-05, 9.360181127627616277e-06,
   7.313284473931577333e-04, 5.581758396982428516e-04,
  -1.492722219208410033e-03,-1.117069783422069452e-02,
  -8.131977010971806752e-02, 1.062644229442785138e-01,
   1.502535748583503583e+00,-1.988284640375062584e-01,
   1.699361502215891662e+00, 1.310805801570855245e+00,
  -1.865173970525098660e-02,-1.452266680117388076e-01,
  -6.282929335905428937e-03, 8.123871344324870222e-03,
   7.241693255763940627e-04,-9.206645672719585395e-05,
  -3.951244482734156410e-05,-3.063929998818982965e-05,
  -6.044193996425244109e+01, 1.004830356453039855e+02,
  -6.403344485015164081e-06, 1.894722088872734635e-05,
  -2.236062469568969081e-04, 5.781688920327101742e-04,
  -9.322157928406697085e-06,-3.619029090494324043e-06,
  -2.486788008199934685e-05, 3.133031343965936587e-05,
   1.938645320059070667e-05,-4.915834852932547929e-06,
  -1.717792391932380480e-04,-1.024333288072869940e-04,
   5.624728125110811531e-04, 2.230161018700974832e-03,
   1.281090682830652965e-02,-2.142146617857638990e-02,
  -2.464432098714527120e-01, 6.182120578420299134e-02,
  -1.301305002580926962e+00,-7.850181046129923734e-01,
   3.305226587144194372e-02, 1.339314276822137495e-01,
   6.139157293549358553e-03,-1.014740398881558599e-02,
  -9.614659149049075825e-04, 2.359730092400098790e-04,
   6.839510519960140191e-05, 4.149830821534123765e-05,
  -5.080998894237303887e+00,-2.673853499207041295e+00,
   1.463674277657996299e-02,-2.781351853611037026e-02,
  -2.855236215661072764e-05,-9.206661462101427588e-06,
  -6.678674990302270204e-05, 2.096497167637240077e-05,
   5.989991906253369899e-06, 1.908192853963805772e-05,
   4.785031393000815838e-04, 2.502515186325486368e-04,
  -2.224471805512778333e-04, 4.253387743813446783e-04,
   1.392954185608209208e-03, 4.457358226755464038e-03,
  -1.916567956702463355e-02, 5.989402739197257665e-03,
   5.782050314999973017e-02,-1.095339175866838072e-01,
   1.238110636424357607e-04, 6.535708895536311330e-05,
  -1.272862474123567268e-02, 3.924310601785618163e-03,
   1.157701206904645456e-03, 6.130164437159504572e-04,
  -3.520834414708623456e-05,-1.147195740175787195e-04,
  -4.690850987883432951e-06, 8.831529709482556517e-06,
  -5.989578053466476648e-02, 1.315309151837731894e-01,
  -1.279008514283996867e-02,-4.963822149055174132e-03,
  -8.007790861408746507e-05, 2.473487988619826861e-04,
  -2.902241296478612722e-05,-7.596021702273776236e-06,
   4.540502167133621952e-02,-4.016690589471531569e-01,
   1.409948665812418955e+00, 1.593818301426755124e-01,
  -1.198035889569972986e-06,-1.996408550390681868e-05,
   2.994612824945304381e-05,-1.797053833970412027e-06,
  -5.042986262561776995e-06,-2.999263866638256877e-04,
   5.498598395858810516e-04,-9.245387337240429184e-06,
   1.362736786661616949e-04,-5.177815568116498832e-03,
   1.047558854737287368e-02, 2.757044874935372794e-04,
  -8.275910457700686154e-07, 2.998858270535369359e-05,
   3.922131296178507751e-05, 7.854209528236091753e-06,
  -3.772089142323535832e-04, 1.872237024400311752e-03,
  -1.587972335938458686e-03,-3.199366922370433975e-04,
   3.900031138792424748e-06,-1.961605865398167894e-05,
  -5.880291456476561846e-05,-1.192548679628895297e-05,
   5.962743399651715710e-06,-2.940145728981451707e-05,
  -8.449472804486369683e-07, 9.964239263148113928e-06,
  -4.791704005920155848e-06, 1.941750686158366692e-05,
   3.128498068817654764e-05, 3.900320474704708140e-05,
   2.340192285632793499e-05,-1.877098841940279123e-05,
   1.910304882335697220e-04,-1.729493159126103052e-03,
  -1.689734090889413211e-03,-1.866389159530500988e-04,
  -3.468606624037959968e-02, 2.774941912275325634e-02,
   3.025448934568478188e-02, 3.781734013498011526e-02,
  -1.013713775626566652e-04, 9.654194606931736534e-05,
   1.103348829486182223e-04, 1.158542947713649157e-04,
  -1.663451321061659119e-04, 1.110164353380448918e-04,
   3.885801010581077335e-05, 5.822417919249016837e-05,
   1.067629006865734633e-08,-6.477947014165892153e-09,
  -7.750352751892939686e-05, 7.805897264120915469e-05,
  -9.225151309898130714e-05,-9.159507795462859862e-05,
   7.486859238940317529e-06, 6.629248730911672935e-06,
   1.216551659810066521e+00, 1.359466753097024472e-01,
  -9.577859284346880442e-02, 8.570978718865256418e-01,
   1.699534568758645915e-04,-3.074738979903628319e-06,
   1.447095441040369339e-06, 7.998691083749292921e-05,
   3.988463030213744952e-03, 9.987403567301399436e-05,
  -5.606961672172185602e-05, 2.239136447284535009e-03,
   3.529754655113876306e-04, 7.064673064541766346e-05,
  -6.279639801100563652e-05, 3.137524924065371356e-04,
  -3.884722180640626601e-05,-9.533800753305917566e-06,
   9.533800754603334872e-06,-3.884722181169282225e-05,
  -6.104874794721580715e-09,-2.262269742219492225e-09,
  -9.034628881501479254e-10, 2.438050472452928934e-09,
   2.230924298797692034e-05,-7.682641258436174840e-05,
  -2.729070404857237902e-04,-6.260637333768874296e-05,
  -4.606039513592437382e-04, 2.007815730252647882e-03,
   2.627365961975571679e-03,-4.844855015771384193e-02,
  -5.130464700087616777e-06,-1.599052292927611099e-04,
   1.399662358942952604e-06,-9.901562769631784230e-06,
   2.979945889790449557e-03,-8.737083763126266600e-06,
   2.961231720974365709e-06, 1.009983483605445941e-03,
  -9.600532005299517390e-06,-1.597077907033218631e-04,
   9.931458105745027815e-06,-1.168819872277764145e-06,
  -2.001898228703016702e+00,-2.508883830001020776e+00,
   2.546832998702150963e+00,-2.032178775253277614e+00,
  -1.497235034993984679e-05,-1.326004242069595385e-05,
   1.989006362678831104e-05,-2.245852552010460987e-05,
  -3.812088579505995751e-04,-3.681307393012682493e-04,
   4.514769213254293855e-04,-4.675159751565106069e-04,
   2.938343071015582397e-05,-2.714063369675063982e-05,
  -1.957407531587554138e-05, 2.273445787100120442e-05,
  -8.140094500146001499e-03,-8.569184355109548193e-03,
   1.006987704004535036e-02,-9.565642109443418806e-03,
   4.812823292517394430e-05, 6.390362422256955005e-05,
   3.993976512916250671e-05,-3.008014557074491479e-05,
   7.707245595536384251e-04,-6.526254730865345671e-04,
  -4.312197245665170208e-04, 4.592197471092186972e-04,
  -2.300594469947470509e-05,-1.925425946757258248e-05,
  -7.035951470550499964e-04,-1.057176712919885618e-03,
   8.240965414042081055e-04,-5.484705822126752185e-04,
   4.555638772066387572e-06, 8.902030969303885419e-06,
   4.313746046972292270e-05,-2.528160401206275843e-05,
  -7.994511144240958901e-05, 6.006272056081636540e-05,
  -7.246407370840350572e-05,-1.197725409486868772e-04,
   8.554876222020787763e-05,-5.175820569627643316e-05,
   9.317415196482393310e-06,-3.643621631041142878e-06,
  -1.027009461359705994e-08, 5.438292753732106050e-09,
  -8.246534471949930456e-06, 5.656383049523917393e-06,
   2.582953529692505476e-05, 5.415565624184134398e-05,
  -1.121956228391123413e-03, 6.160588949048902661e-04,
   1.580500039323431624e-02, 2.525109628283583874e-02,
   7.357484170981316851e-03,-4.605148184976762954e-03,
   2.490125092652544780e-01,-1.764092406947328218e-01,
  -1.533727671325366693e-01, 1.374169838386071485e-01,
  -8.610896288942524249e-03,-8.571490816904312610e-03,
   4.232899632335257434e-05,-4.252359421964117689e-05,
  -2.522694126851344988e-04, 2.841728319627213331e-04,
  -3.138049374247687027e-05,-2.480452804143293106e-05,
  -2.892184145125551884e-04, 2.301703179978584874e-04,
  -4.075606916560891441e-02,-5.121166711839481023e-02,
  -2.086734349699720883e-05, 2.155351420391173815e-05,
  -2.873801894581295806e-05,-2.782312466969576479e-05,
  -2.685667601946120967e-04, 2.544669208313011968e-04,
  -4.607882012308413505e-04,-4.863201627000910223e-04,
  -3.198252033844443043e-05, 2.402328850429750914e-05,
  -1.201164425798798965e-05,-1.599126017699601255e-05,
   3.249177912557116472e-04,-2.156480419338131175e-04,
   1.548262717147390311e-04, 2.332773800438668968e-04,
  -2.398572444338530724e-05,-3.201070165875332979e-05,
  -4.515716760326621455e-05, 2.146695626422572009e-05,
   2.146695625963271104e-05, 4.515716759360451630e-05,
   9.603773689904599017e-06, 1.754330444679953182e-05,
  -9.009090686145132879e-03, 5.622909626391948447e-03,
  -3.552704327657236257e-03,-5.692183868418650323e-03,
  -4.384589294410879724e-03,-4.906287193296917162e-03,
   5.862954810634582979e-04,-5.874882527560283977e-04,
   1.415649922044322273e-05, 1.412775741759550448e-05,
  -2.987960515262253473e-05,-2.659340507876149299e-05,
  -3.864871112844132667e-03,-4.418883611931672078e-04,
  -1.260896016108655816e-04, 1.102812614435073457e-03,
   3.854600764656626447e-04, 4.856179848649328618e-04,
  -1.253200681930092630e-04, 9.947301083133227868e-05,
   8.040432719969193651e-06,-6.953669129168373367e-05,
   2.980143913651414763e-05, 3.445899738460229437e-06,
   8.360449128146748741e-05,-2.355979170569575407e-04,
   1.696358071436541439e-04, 6.019711692076485846e-05,
   9.685874426407420357e-03, 2.826052059187838996e-03,
   5.689303223415742572e-02,-2.465567172985387578e-01,
   1.958403280649333722e-01, 4.519021107770182510e-02,
   4.862568171605708695e-06,-4.976299255446905734e-05,
   2.985779554301557043e-05, 2.917540903973222491e-06,
   1.428565363958033600e-04,-1.009851116293390260e-03,
   6.930382054265003420e-04, 9.803924164641846591e-05,
   2.771111097603695659e-05,-8.561452367908262552e-05,
   8.561452366076225155e-05, 2.771111097010715336e-05,
   6.968033660717833902e-06,-1.873021542220159054e-05,
   1.872573799036296387e-05, 6.966367962002584670e-06,
   2.223522827786819789e-06,-9.749663903658983206e-06,
  -9.316690073436670024e-05, 5.848015556777484442e-05,
  -2.658188890228998613e-05,-4.234859125539510940e-05,
   4.967887845774466996e-04, 1.153026243912234867e-04,
  -7.913019635685599623e-05, 3.409375482913096309e-04,
  -1.056777334912547825e-05,-1.698005201527702420e-05,
  -3.467748742822243657e-01,-5.940916849089986768e-02,
  -5.995129254173808304e-05,-2.417130367714193035e-06,
  -1.305333142134531893e-03,-1.091462739423516062e-04,
  -6.471898317299934750e-06,-7.623288802776022960e-06,
  -1.148626336538616192e-05, 1.395154804804924105e-04,
   9.032560587810090449e-05, 1.069475968058920774e-04,
   8.459754135607381330e-07,-9.964152026120975437e-06,
  -5.417148644111151670e-04,-1.417451076185754068e-04,
  -5.038039923110516583e-06, 1.935505499173651662e-05,
   4.540452985392016679e-05, 7.770009520842768088e-05,
   2.543731680345116832e-06,-9.671061427703197839e-06,
   1.577717873115243427e-04, 2.661466979941905657e-05,
  -1.662052807703312020e-03,-2.339749007766824852e-03,
  -6.605081443477962312e-03, 3.885233611831533790e-02,
   2.083641739850797259e-02, 2.949166684314506390e-02,
   5.477763376172571034e-04,-3.173048589775147050e-03,
  -2.207154008062618949e-04, 1.555173564433261712e-04,
   1.970411341588604391e-05, 3.427523084371531619e-06,
   2.835633337682142915e-02, 1.574089890216313079e-03,
  -7.996206666428484181e-05, 2.463308355777182072e-06,
   1.583839103471688817e-04, 2.259515360313620166e-05,
  -2.995803398789076598e-05,-1.586253050518251291e-06,
  -1.002381534811753311e-04,-1.115899303767200877e-04,
  -6.123681893106050500e-05, 1.078259888624288117e-03,
   1.045082994516925105e-04,-9.315586576331600331e-05,
  -1.996635956720912855e-05,-1.159519569872205305e-06,
   6.205290466637416483e-06, 3.749941821669360714e-03,
  -1.499997945145869864e-04, 2.482151295044738124e-07,
  -1.399999899500911930e-04, 5.286181939530634474e-08,
   1.413844393869034282e-05, 1.414582634533982740e-05,
   1.597199220869024181e-04,-9.396548019068565164e-06,
   2.312269249014671055e-06, 1.986588560623616244e-05,
   1.294072806725601232e+01,-5.071628689300842652e+00,
   4.250950130362525670e+00, 1.084669107983766345e+01,
   2.494255498521012466e-05,-1.666940163322515778e-05,
   1.111293441977238432e-05, 1.662836998658234709e-05,
   4.614148610464301713e-04,-2.803723691513886345e-04,
   2.336431006187629814e-04, 3.845114949549559595e-04,
   8.506892709951627274e-03,-4.679312278513653688e-03,
   3.937173922724085916e-03, 7.157700565278824097e-03,
  -3.255218036030893804e-06,-9.455345342074988110e-06,
   1.364478177881043308e-01,-6.756298469155869180e-02,
   5.682085715105091722e-02, 1.147533963827267744e-01,
  -6.337637546693192001e-06, 1.896930020656388668e-05,
   1.896930020250527072e-05, 6.337637545337209990e-06,
   1.790040750842675075e-05,-8.920505088404986999e-06,
  -5.352303051897828388e-05,-1.074024450275809885e-04,
   5.308762176218674057e-03, 1.781196179066953404e-03,
  -7.601882146587177419e-04, 2.265701267617476530e-03,
  -7.020178573845763104e-02,-1.413228644606384921e-01,
   9.702121829175268386e-02,-4.819505183818862531e-02,
  -9.857463535065479066e-02, 2.925570117022179839e-01,
  -2.644326638511077521e-01,-8.909837184301455659e-02,
  -2.283641234201788661e-02,-7.727029453520955007e-03,
   5.538075839500809089e-03,-1.636719313844189200e-02,
   1.283427011158653607e-03, 2.600310166329232280e-03,
  -1.649852932955116636e-03, 8.143127869945938208e-04,
   9.972670758010537524e-05,-2.934964636227720873e-04,
   1.704182555006243812e-04, 5.790615438033411614e-05,
  -2.691861932697851457e-05, 1.324341094768333464e-05,
  -8.248274889355521565e-05,-2.779884442536467368e-04,
   1.916650357244015140e-05,-5.713592635779955866e-06,
  -4.396701615155831585e-05,-2.380969320946010184e-05,
   1.909266219049980749e-05,-3.514925675571901984e-05,
  -8.561291317145306281e-04, 3.081984436834877693e-04,
  -1.364882558629725798e-03,-3.791439391601918174e-03,
   1.272211076370049784e-05,-2.716887736604170736e-05,
   6.798261112371207272e-06, 1.880913729675078694e-05,
  -3.385409827366740146e-04, 1.223602104430508578e-04,
   4.592027084980198812e-04,-9.774042493042752171e-04,
   1.312261037159082998e-03, 6.165246600358101001e-04,
  -4.703222132405482261e-04,-2.216998479316696006e-04,
   9.805993817947422999e-05,-2.080279602583041390e-04,
   3.037376351713295299e-05, 8.471310774620384562e-05,
  -4.706610292409733160e-05, 1.687548382916741790e-05,
   4.275372026994730643e-06,-9.039977545922941521e-06,
   1.135918160289852742e-02, 2.666927074446256984e-02,
   1.182636770982126582e-05, 2.757058263425161732e-05,
   2.230125732981465167e-05,-5.570147144833239352e-05,
   2.602038879051540854e-03,-1.112208791780227050e-03,
  -3.212066252367361263e-02,-1.290780818851507139e-02,
   1.559694214397840768e-03,-3.866966390518792977e-03,
  -4.326093739444234723e-04, 1.836079204398056379e-04,
   4.634634530823578775e-05, 1.876209680632127448e-05,
  -6.275381562269207771e-03,-1.104007420121987278e-02,
   2.897908566857640102e-05,-1.061076763076640385e-04,
  -1.068460181933206590e-02, 6.091392920388323876e-03,
   2.294925088876748759e-02, 6.299181504169830935e-03,
  -6.780531327378931271e-04, 2.457987864969487981e-03,
   3.218792693036361531e-04,-1.824185759126769777e-04,
  -4.818267264451571663e-05,-1.335777140212532578e-05,
   7.473037000122941670e-04,-4.832082060141668794e-04,
   3.912540507041933446e-05, 8.318814703766726974e-06,
  -8.318814701986790573e-06, 3.912540506204818916e-05,
  -4.896032583133836172e-04,-7.550771815811630231e-04,
   9.229559207093845626e-05,-5.984583259590563859e-05,
  -3.347213067644843210e-04, 1.564450551442224131e-03,
  -4.889343562309235485e-05,-1.046097279896749891e-05,
  -2.052839390222627311e-04,-4.419569424700782933e-05,
   2.167632027071212552e-05, 3.361751239341654197e-05,
  -1.770079823309595173e-05,-2.422151403011849605e-05,
  -3.226518281003652147e-05, 2.364229215272757939e-05,
   4.941081614421441513e-05, 7.653185478128735346e-06,
   1.710727001386078916e+00,-7.570794458541477701e-01,
   6.359273067702736482e-01, 1.436966781449532604e+00,
  -2.040954406332787488e-05,-4.564483005913241615e-05,
  -3.651586403949310294e-05, 1.632763524716888463e-05,
  -1.215387494664124613e-04, 3.175241875703065271e-04,
   3.828995258779634842e-04, 1.465624710438338590e-04,
   1.826785271931410319e-04,-8.140273397105951211e-05,
  -9.361270270463708165e-04,-2.100793157970869997e-03,
   9.317539734522237160e-02, 3.580125585856571563e-02,
  -1.547968482900563027e-02, 4.028701647839883632e-02,
  -1.108757379957256761e+00,-2.496770817813706245e+00,
   1.733769621423356222e+00,-7.699264382552098995e-01,
  -1.574037526692982691e+00, 4.080972894734378187e+00,
  -3.692817835501669865e+00,-1.424325522921436660e+00,
  -2.634443767689325089e-01,-1.019976139383080016e-01,
   7.324068029354283138e-02,-1.891695759249365782e-01,
   1.321087488914618642e-02, 2.995514396624800874e-02,
  -1.902159120499589962e-02, 8.388938537061576065e-03,
   1.217100453193383034e-03,-3.131700756399060422e-03,
   1.808181631143731746e-03, 7.027295562081369755e-04,
  -2.929460345015280826e-04, 1.287489543678238719e-04,
  -6.839999535166073276e-05,-1.556323893780663873e-04,
   2.794859932273108540e-05, 1.090301774269103471e-05,
  -1.307201849447845791e-06,-9.914193024386813672e-06,
  -9.823417912710289229e-06, 1.870951766412658473e-06,
  -5.612855298037063116e-06,-2.947025373182549852e-05,
  -1.883496547795296723e-06,-9.821020352002291011e-06,
  -1.123592193799034470e-05, 1.654551474579704089e-05,
  -4.963654422677103375e-05,-3.370776580675902460e-05,
   4.959345275134871144e-05, 3.377113329753301759e-05,
  -2.814261107525613023e-05, 4.132787728394824426e-05,
  -1.296790414749745754e-03,-5.179797024892917462e-03,
  -2.562824237929681834e-05, 4.293242588706134335e-05,
   3.199987602970328997e-04,-8.054788628101453398e-05,
  -5.576614581056150597e-04,-3.338592833535170175e-04,
   3.191285533914937737e-04,-5.315145115902014834e-04,
  -9.703707002971566841e-05, 2.416209924754177138e-05,
   8.566783010951012031e-06, 5.158510331799397644e-06,
  -6.357403382149761674e-03, 1.983459593426109384e-03,
  -1.724062365359965709e-02,-5.525980942038694749e-02,
   3.815416096184681173e-05,-1.201082850170982568e-05,
   1.501353562392502654e-05, 4.769270119210432230e-05,
  -6.205533583203420725e-05,-3.239035805256635568e-05,
   2.729886646871829484e-04,-5.230075949765394198e-04,
   1.285850331296688924e-04, 4.102981188202440839e-04,
  -6.307178202462126147e-03, 1.976632796782646240e-03,
   1.061699275373877323e-02,-2.027747662014523986e-02,
   2.390066742767651617e-02, 1.251404292766203526e-02,
  -6.480198376070126810e-03,-3.403490288153019142e-03,
   1.264686533009698769e-03,-2.407945645085026072e-03,
   3.588851912123733855e-04, 1.155490727465791284e-03,
  -5.252249347604929933e-04, 1.631302152934044336e-04,
   6.525577586375166104e-05,-1.238615505975110916e-04,
   5.308352167328998111e-05, 2.796676107848141213e-05,
  -9.553755736202609709e-06, 2.953938275078838686e-06,
   1.459909438270940163e-01, 3.884106741410719432e-01,
   9.347069984303593769e-06,-3.554192272307569648e-06,
  -8.207957140324015149e-05,-3.691807089028897447e-05,
   2.054437921286730439e-04, 5.423749686622416537e-04,
   3.702144378015741850e-04,-8.202918997953917435e-04,
   4.912687356935431515e-02,-1.853683722139255058e-02,
  -5.427166537625311982e-01,-2.457738952265924037e-01,
   2.352150891657571463e-02,-5.176404522844896966e-02,
  -5.749931013107911250e-03, 2.152834921499714813e-03,
   5.459095149610529874e-04, 2.489021890454149659e-04,
  -2.096658344422137779e-05,-5.621745617400793129e-05,
  -7.203937312577837759e-02,-1.405122582612025051e-01,
   9.169939166926605823e-06, 1.777391953607491236e-05,
   5.821543163092784490e-04,-1.819040224932175166e-03,
  -1.900845546771352812e-01, 9.776143172374519852e-02,
   3.225509068114638667e-01, 1.036815214911327998e-01,
  -9.244356482336547887e-03, 2.863341168698620154e-02,
   3.748623614762020776e-03,-1.915843487244115904e-03,
  -4.756009073158458411e-04,-1.542197629072621123e-04,
   2.269754411519545877e-05, 4.455133545853318556e-05,
   9.606333463671746717e-03,-5.639587802172339563e-03,
   4.050185540499187951e-05, 6.898985219591705065e-05,
   7.552005720225071946e-04, 1.949471802465667792e-04,
  -1.924486958969966145e-04, 7.455217615488224500e-04,
  -7.777645000975382666e-03,-1.320957562718858523e-02,
   1.378688439323110968e-03,-8.117557710130745077e-04,
  -5.709081823051416482e-03, 2.200011614785153669e-02,
  -6.678453878470267660e-04,-1.733074470490239788e-04,
  -2.428595929228319263e-03,-6.335380891298802390e-04,
   2.071108780345845611e-04, 3.538217802977896382e-04,
   1.521925686235977780e-05,-5.803769654765353363e-05,
  -2.052167279161695149e-04,-3.078490954127585991e-04,
   2.136997565904699028e-05,-1.079042359702886672e-04,
  -4.987843703005304195e-04, 3.334178944772417017e-04,
   7.354820385637072166e-04, 1.466355305360630469e-04,
  -1.770998133086527855e-05, 8.824033409535802304e-05,
   1.665555986637713140e-05,-1.107214186765719908e-05,
   3.196217443123910263e-05,-2.405035146576959271e-05,
  -3.613673011847671199e-05,-4.789714747606978694e-05,
  -1.113841985031142072e-05, 7.922080284393859121e-05,
  -9.900814053175247919e-06,-1.404948783567409077e-06,
  -2.734641755751490155e-01, 9.378731817303255502e-02,
  -7.932549497084952217e-02,-2.312965282179413884e-01,
  -3.280334568679801320e-06,-9.446661056559842919e-06,
  -1.746398917659742559e-05, 3.598623461880512121e-05,
   3.598623461110561205e-05, 1.746398917286088204e-05,
  -6.048344391672511250e-04, 2.091623269328079886e-04,
   3.039385490785130334e-04, 8.788987221980250428e-04,
   2.411302755692775954e-02, 1.174003825587148844e-02,
  -1.050124765861850350e-02, 2.156865835149650648e-02,
   1.164342074657427895e-01, 3.380900052112872922e-01,
  -2.240381589319903610e-01, 7.715609771140222173e-02,
   2.787903591002793835e-01,-5.707580940902264865e-01,
   5.200641145480014993e-01, 2.540285678841120443e-01,
   2.240171215681268641e-06,-9.745852088167208531e-06,
   4.552586786434559968e-02, 2.230945742179506891e-02,
  -1.620184487817576124e-02, 3.306234818431134925e-02,
  -3.099995919379402580e-05,-2.527849936177196212e-05,
   1.895887451727254605e-05,-2.324996939037105579e-05,
  -2.158927796254095800e-03,-6.321279064848214432e-03,
   4.069080080516383584e-03,-1.389726667797676731e-03,
  -3.397045273150268475e-04, 6.909843923319482434e-04,
  -4.038216713620433325e-04,-1.985284349573362148e-04,
   7.573932999443896150e-05,-2.575953982495571751e-05,
   1.287976990972207094e-05, 3.786966498911702107e-05,
   4.814842952901596880e-04, 3.001435327393089415e-03,
  -2.961519174521879013e-05, 4.789615631125834696e-06,
  -1.215832874352512779e-04,-8.784932574120047093e-05,
  -6.453666165396595772e-05, 8.907872530835587294e-05,
   2.962732955494167821e-05,-4.713951998363949553e-06,
  -4.980982644746124446e-04, 1.093839364710729622e-04,
   4.223116985736964125e-03, 1.923067782283651578e-02,
   3.373396720509906264e-05, 2.149463785704009981e-05,
  -8.413413625495606656e-05,-3.807969040857104074e-04,
   3.515101681957663159e-04,-7.766345804988096166e-05,
  -1.009526413807914497e-02, 1.579907857713825151e-02,
  -1.306900010726292846e-02,-8.350803969942742835e-03,
   1.540730803950707143e-03, 9.872666359271276785e-04,
   7.013739293251541928e-05,-1.094565924416571645e-04,
  -6.823489397896141239e-05,-3.126244700114734335e-04,
   7.815991107931178803e-05,-1.705955149865973208e-05,
  -2.162373319651765221e-05, 3.365136197311812576e-05,
  -3.051797899687577753e-02,-1.088787443888707684e-01,
  -8.732690009892885296e-06,-4.872383933057512886e-06,
   2.723504640605339453e-06, 9.621981213482033623e-06,
  -3.076497545725626450e-04, 5.497440379806293976e-04,
  -1.953882483018948724e-03, 5.503525921172516518e-04,
   1.499025347827339649e-01, 8.414059286034168694e-02,
  -8.300264349968866293e-03, 1.474337160839500789e-02,
   1.887859216703529231e-03,-5.265545840141394986e-04,
  -1.741490065098794029e-04,-9.833601925392737944e-05,
   5.348626315453881524e-06, 1.927153850987601660e-05,
   9.631572112296002061e-03, 2.359906243396802869e-02,
  -3.802372589023908136e-06,-9.248889808741351143e-06,
   7.405458823076067551e-04,-1.771355767347421997e-03,
   2.736212080339071526e-02,-1.120819184201302804e-02,
  -4.699860259593859751e-02,-1.971913271302007040e-02,
   2.165347877344472004e-03,-5.142473054144470861e-03,
  -8.151454426170203762e-04, 3.314744301527756541e-04,
   1.105359392598175038e-04, 4.670980766337983663e-05,
  -3.755073044373589703e-06,-9.268194345794592896e-06,
  -1.679083746906621455e-03, 7.999512574072028918e-04,
  -1.290310307408937225e-05,-2.708338846367460662e-05,
   2.829387629121556981e-05, 9.972789367408018855e-06,
   2.326984232611568773e-05,-6.601904600962463731e-05,
   9.487145441229465938e-04, 1.984802773697464957e-03,
  -1.984905027898044793e-04, 9.487634205395767233e-05,
   1.177655293476836040e-03,-3.327573180066758281e-03,
   1.131244668098425676e-04, 4.003567162952139931e-05,
   4.522695794322131911e-04, 1.607121681881631600e-04,
  -3.860550628816020684e-05,-8.129953803211199522e-05,
  -3.360375183043356144e-06, 9.418486005148935140e-06,
   3.366516912530073620e-05, 6.137309172401939484e-05,
   7.885291508928845303e-05,-4.338453390231899239e-05,
  -1.152251941750574303e-04,-3.351349918048416172e-05,
   5.610105927393749072e-06,-1.919704955151758545e-05,
  -1.994627180092245055e-03, 5.892845857508500909e-04,
  -3.853023556617788010e-04,-1.304182342012752405e-03,
   4.851728820065259572e-05,-1.208605583533423601e-05,
   7.251633499648949871e-06, 2.911037291416320016e-05,
   6.427041841801598029e-05, 2.773649791111257497e-05,
   1.981178421798439842e-05,-4.590744171733204950e-05,
  -2.284441742406942302e-04,-5.763859691725032154e-04,
  -5.113099651442372558e-04, 2.026520231505762068e-04,
  -1.712841943422352062e-03, 3.955068136300629589e-03,
   4.973658734778133896e-03, 2.153968275541584803e-03,
   6.510848953211022120e-04,-2.570885703231661780e-04,
  -1.079404850654888150e-02,-2.733626754835161501e-02,
   4.791478481552275271e-05,-1.428892564478345461e-05,
  -8.573355385035741604e-06,-2.874887088316262915e-05,
  -1.423204380874451819e-05,-6.853793788133675949e-05,
  -1.561395952284768966e-05,-2.561648430247355526e-05,
   1.088477839406629455e+00, 4.730445993701343221e-01,
  -2.049625954097044067e-01, 4.716198923056881820e-01,
   9.719369703917995210e-06, 2.352414197916903700e-06,
   2.594115745730140319e-04, 7.476125571789539730e-05,
  -3.045825561610762165e-05, 1.056860799387366375e-04,
  -3.244720727721410892e-03,-1.756697996556042972e-03,
   1.199696478351699276e-03,-2.215907365929505046e-03,
  -1.146449290765026538e-05, 1.638796516347502835e-05,
   1.576561883859999179e-05,-2.552342576214997855e-05,
  -8.502171470468808921e-05, 1.810156339097200725e-04,
  -1.855841712252652258e-05,-7.455545178343056184e-06,
   1.606096556184671696e-05, 1.191827945725278619e-05,
  -3.624033990393745884e-04, 5.515865362150949641e-04,
  -1.991157013792833538e-04,-1.151153206606655668e-04,
   3.723732862907099504e-03,-6.440964386768941070e-03,
   3.471629253709395454e-03,-6.884143132654716758e-03,
   7.512917200449590119e-03,-2.040048100036896683e-02,
   8.934378434026321592e-03, 2.722175590066518505e-03,
  -2.695945325320722990e-03, 8.848288795827132652e-03,
   3.001986520660031906e-04,-1.233980060982986212e-03,
   6.884977797711697720e-05, 1.263756592472206889e-05,
  -1.126518981046081969e+01,-2.863646037361818841e+01,
   2.013443146430978814e+01,-7.920608525351320317e+00,
  -5.567081419165338360e-06,-8.307081585754653901e-06,
  -1.716989360384994182e-04,-2.817571321757251102e-04,
   1.878393723107685341e-04,-1.144667399289966118e-04,
  -3.646848235755751136e-03,-6.609889318096215036e-03,
   4.491221303918734899e-03,-2.477923865342753548e-03,
   1.172126828411626303e-04,-5.619555410453256841e-05,
  -4.994201124867480917e-04, 3.139999053901346908e-04,
  -2.318880784583590991e-05,-3.259262478980327725e-05,
   9.998526245867347950e-03, 3.368490372886548401e-02,
  -2.547935738434757916e-02, 7.562913808090420201e-03,
  -9.931382048099248968e-06, 1.169465952771599299e-06,
   1.387537223472137395e-05, 7.878752468092853583e-05,
   2.067988043942397018e-04,-3.641960323396203420e-05,
  -1.109516894127244311e-03, 2.614632530428587752e-04,
   2.605961324918462749e-03,-9.384253406435189276e-04,
   7.446719884595249779e-05, 1.747852706728292304e-04,
  -4.858597774032004596e-05,-1.939830227781864035e-04,
   1.454872670525078724e-04,-3.643948329744256087e-05,
  -1.895789350647132402e-05,-1.286063045003233340e-04,
   1.385032634168856605e-04,-2.041680715698864927e-05,
   3.819464161643711282e-03,-7.880324365156836592e-04,
   1.705521836511395082e-03, 6.396434110186345612e-03,
  -7.712436108921974509e-02, 2.056415804474252124e-02,
  -2.196733026732168992e-09,-2.487755647987259009e-08,
   6.019969706626621120e-01,-1.979485929475435224e-01,
  -2.192214982565066084e+00, 1.010443714919758929e+00,
  -2.468527017115852148e-05, 1.704809187495514002e-05,
  -1.909174353679216814e-05, 5.958634803824990761e-06,
  -7.974865774037206978e-02,-1.498705906253738063e-01,
   1.309172029548231510e-02,-6.966324191561196026e-03,
  -5.400613473931182781e-03, 3.282371253250057717e-03,
  -3.460449163423286179e-04,-5.023257677009521516e-04,
  -7.897859143501998242e-06, 6.133825963409942653e-06,
  -1.536235333146066928e+01, 3.522570485926350159e+01,
  -3.188249254264660593e+01,-1.390433825198523010e+01,
  -7.773735220054040773e-06, 3.923097712883341452e-05,
  -3.923710194906646174e-05,-7.774948871465492696e-06,
  -2.033444113998565336e-04, 8.354810083047135849e-04,
  -7.577605978067128868e-04,-1.844283487133563577e-04,
  -6.694681939441248875e-05,-2.040527462706914465e-05,
   6.883619123052188557e-05, 1.264241418832720086e-05,
  -4.842088638895171611e-03, 1.672111448717432738e-02,
  -1.508837331518618659e-02,-4.369280592206432889e-03,
   1.543245507334536416e-05,-3.690310732728583460e-05,
   5.535466097908518486e-05, 2.314868260506532262e-05,
  -1.555917663157227243e-03,-5.485973676334523867e-04,
   1.306140706024796908e-03, 2.986141224279415343e-04,
  -1.501596785328069577e-05, 8.872583082638063623e-05,
   1.035982831520436756e-02,-1.907695528334765397e-02,
   1.641442795284826089e-02, 8.913930601506315707e-03,
   3.922763415693928426e-05, 3.100310820626426243e-05,
   5.167961985600591588e-04,-7.367313123494674890e-04,
   5.238954055432676121e-04, 3.674978238191317225e-04,
   3.723177276081025052e-03, 2.306351927081663929e-03,
  -1.619081976927033706e-03,-7.629964975350355750e-04,
   4.487311462351153090e-05,-1.112874884399675562e-04,
  -1.183607882679511960e-04, 1.971781817014258797e-04,
  -1.714564957411161871e-04,-1.029207482007755162e-04,
  -6.611892681169875027e-05,-4.501432683365887784e-05,
   1.770735849413792456e-05, 9.297819914371410578e-06,
   3.067626297572550125e-05, 2.567035040361025132e-05,
  -1.014773168652877833e-04, 1.363855725397664271e-04,
  -6.418072627557989875e-04,-4.775349603061817953e-04,
  -4.626066731408784959e-03,-3.047884402955404123e-03,
   1.509130515242545489e-01,-2.602675488748468213e-01,
   2.783476796670195097e-01, 1.613966009394628420e-01,
  -5.871037467335811222e+00,-2.970137953649760298e+00,
   2.812414889857269173e+00, 1.039813501533349838e+00,
  -5.892706257716288920e-02, 1.925206375071949194e-01,
  -5.259083511307635454e-03,-1.609709728692181865e-03,
   6.449662196022064135e-03, 1.577780462400434113e-03,
  -1.308867979089548439e-04, 7.079811827301101196e-04,
   1.984220222727859769e-05, 2.507391228304900378e-06,
  -1.811820630391052012e+00,-7.929124345047390277e-01,
   5.703319258902044275e-01,-1.303219756093195514e+00,
  -8.740783179950691625e-05,-2.139213141581232562e-05,
   1.426340004000460683e-05,-5.827997441453030100e-05,
   2.927773930370065975e-06,-9.561806304911507059e-06,
  -1.536119268616648308e-03,-4.469555560958736332e-04,
   3.184552812297283472e-04,-1.094483080068891449e-03,
  -2.766252536405007485e-05,-1.160968089498097547e-05,
   8.008635255901472977e-05,-2.262171261130236895e-04,
  -3.809580747639100903e-05, 1.656572992724095238e-04,
  -9.857654487480981142e-06,-1.681263811971847291e-06,
   7.024891390642806961e-05, 3.826525670212015253e-05,
  -1.435043571421351204e-05, 2.634511329311572272e-05,
  -1.635862720434751513e-05,-1.150631635186437507e-05,
  -5.276921182845574574e-06, 8.494357116935670091e-06,
   8.548878468982552963e-06,-1.808083728488718475e-05,
   4.889143440222673944e-04, 3.647464442724983953e-04,
  -2.989723001333725243e-04, 4.007492007004520747e-04,
   3.042763797843667413e-03,-4.605480776370064928e-03,
  -5.706151398430977378e-02,-3.318389491180939038e-02,
   9.742520469981903394e-03,-1.675279437563714086e-02,
   2.142302344128795000e-01,-4.221271237515287211e-01,
  -7.397619081122538964e-02, 1.993026706904059142e-01,
  -1.702320798396518911e-02,-5.234282059776877716e-03,
   2.057298236465746039e-05,-6.690853753092136202e-05,
  -1.624240754187743772e-04, 6.603034772934302530e-04,
  -8.847935023723530921e-05,-1.647436134108538815e-05,
   7.947990924507425392e-02, 2.035652141727909425e-01,
  -1.296862173804076701e-01, 5.063462748101264094e-02,
   5.181942455362007320e-06, 8.552629559925811501e-06,
   9.615609411535552928e-05, 1.753397150656879730e-04,
  -1.139740999456999808e-04, 6.250326274903546817e-05,
  -2.708471970295580104e-05, 1.290030846965753567e-05,
   2.543799857855987855e-05,-1.590308864080137419e-05,
   2.821046647860516533e-06, 9.593836344789031590e-06,
   1.433068048217374085e-06, 9.896783112162176729e-06,
  -8.818762561768688597e-04, 1.796015510553003122e-04,
   2.500595150235907903e-03, 9.475460308638425366e-03,
  -3.867534886174674169e-03, 1.020651099231540543e-03,
  -4.595937317764073327e-02, 1.498237567603380102e-02,
   2.571315678662476623e-02,-1.177226056771528764e-02,
   1.280921055553041954e-03, 2.422116963975064034e-03,
   1.027044872487965381e-04,-6.206277708064465357e-05,
   1.130395853765181424e-05, 1.649910668427381042e-05,
   8.640990478215364312e-03,-1.967637501409732689e-02,
   1.138096743471378632e-02, 4.998015699831999392e-03,
   5.612086701896197234e-06,-1.919647058316710313e-05,
   8.336425335562154028e-05, 5.523043782607325267e-05,
  -1.941494571616122643e-05,-4.802070682373688382e-06,
  -1.845332612422698800e-03, 7.177760634405131986e-04,
  -3.842640896131407934e-04,-9.879056887842441268e-04,
   1.555661237082769878e-04, 6.855487389850575982e-05,
  -3.629338655827930935e-05, 8.235769598929542289e-05,
  -3.613200191548307230e-06,-9.324418715169074820e-06,
  -1.142103569497387411e-05,-1.294934099755146661e-04,
  -2.968483424843986642e-05, 4.337120662680678364e-06,
  -4.626092435789202193e-05,-3.166266236399486295e-04,
  -1.256455814824773178e-02,-6.129383033687110099e-02,
   2.311033136579490263e-02,-6.130450529869364493e-03,
  -1.302315241808069401e-01,-4.909416793149028457e-01,
  -6.477312944590092277e-05, 2.652484858797840510e-05,
  -8.336178166252396367e-05,-2.035677397576109464e-04,
  -9.850647727305433503e-06, 1.721841848873554765e-06,
   8.609209242525682146e-06, 4.925323862598910356e-05,
  -2.601025956776521993e-06,-9.655809855841962410e-06,
  -4.994019124387373028e-05, 8.663704345443303564e-05,
  -5.198222606153786137e-05,-2.996411473991320842e-05,
   4.056781643614438626e-04,-1.087236956011328149e-04,
   1.863838799732152340e-04, 6.954497809887712689e-04,
   5.491585691918698551e-04,-9.415388848538288908e-04,
   3.800709358566498096e-04, 2.216788012519047512e-04,
  -1.063944508395243076e-04, 2.793243330889821547e-05,
  -1.015724847378983863e-05,-3.868889120609469355e-05,
   1.143319038227049500e+00, 3.492060983488288528e+00,
   3.756699915717727538e-05, 7.061673085992355517e-05,
   6.940876170735014788e-04, 1.452483727494640556e-03,
  -1.277417028678008357e-04,-5.451886537334125083e-04,
   3.718835552506007826e-06, 1.965121528388047006e-05,
  -8.959913838179356664e-06, 1.788071430375202006e-05,
   1.423757553121637572e-04,-4.721932550667397262e-05,
  -1.036414903240683461e-03,-5.209981366897562492e-04,
   2.132334805695002087e-03, 6.457007053281463294e-03,
   4.001282812406157206e-03, 2.037088606718987383e-03,
  -1.234904916600320214e-04,-3.804631113458921345e-04,
  -1.364500676816392099e-05, 2.671729384306653252e-05,
  -4.975322577545482350e-01,-1.083060988919598788e+00,
  -2.268519213750057513e-05,-3.293755582066224148e-05,
  -4.248982621997799509e-04,-6.777244876804243553e-04,
   8.439566920408461052e-05, 2.353049904287409563e-04,
  -9.070995030728213734e-06, 4.209162523888101313e-06,
   1.217303673419794412e-04, 2.632161160995644600e-04,
  -3.026687492587173435e-03,-1.127831361664099205e-03,
   1.411401949613896639e-04, 3.093238010546451623e-04,
   1.051113891879348604e-05,-2.809832661618526047e-05,
   7.508769181592674091e-02,-3.983245018378401420e-02,
   3.139746245429262317e-04, 5.918699386285409614e-04,
   4.893332185527961802e-05,-3.472074325540302440e-05,
  -1.840965597809645702e-05, 7.815661633421538263e-06,
  -1.764395602631678726e-05, 9.417580142552524263e-06,
   4.237911063241918234e-05, 7.939780210143774467e-05,
   1.062415066525317114e-04,-3.439598221434529983e-04,
  -3.538367499268080490e-05, 1.865463867278954543e-05,
  -1.492618657778620227e-03,-2.462945694682240790e-03,
   2.884718094571258359e-04,-1.981812361602050987e-04,
   3.325726440620306069e-03, 2.865525974317466393e-03,
  -5.313350519892289479e-03, 6.166669041099323220e-03,
   8.354592949372378725e-06, 5.495523328155140934e-06,
   9.731377597129723582e-05, 7.020349342231979952e-05,
  -9.360222250695169558e-05, 1.297483254381909409e-04,
  -2.101222921753012041e-05,-1.282779775528438673e-04,
   8.881636232169350630e-05,-1.454832543334897878e-05,
  -3.036712450381149481e-04, 4.220741830939486240e-04,
  -3.571388914982583616e-04,-2.569520150173877941e-04,
  -3.108314969161357004e-05,-2.517613558528131493e-05,
   3.374993408840862329e-05, 2.146955860719540596e-05,
   1.085697888868441250e-04,-1.764162797440794699e-05,
  -9.623252516492417479e-06,-5.922324717628136735e-05,
  -2.996706045646279286e-05, 1.405448952684015778e-06,
  -9.369659686928788705e-07,-1.997804030935831652e-05,
   1.037806408863807073e-05, 9.945374316976773432e-05,
  -4.329300252730264224e-06,-1.952580752034880019e-05,
  -3.182535239938895844e-06,-1.974516319118550811e-05,
   1.974516318696088724e-05,-3.182535239258003327e-06,
   1.478054170783202096e-05, 1.347351427145264555e-05,
   1.260790697769772838e-05,-1.552548490842463344e-05,
   4.479551156156499642e-04, 3.839795641292661999e-04,
  -1.692114677770814775e-04, 1.974041060842977413e-04,
   6.064121147522900377e-06,-7.951505185068142616e-06,
  -1.281983628491374823e-03,-1.681127023341482188e-02,
   1.145679118338687776e-02,-8.736650192531309140e-04,
  -3.997095953297345429e-05,-1.523940067304439210e-06,
   3.299421629370505229e-04,-6.270045769073746510e-06,
  -1.229007323461923538e-03, 1.647026179891285084e-04,
  -1.891808858194762166e-05,-9.819422545752985840e-05,
   1.963884509830321728e-05,-3.783617717699042605e-06,
  -3.731446070836780954e-02, 4.341914156997705304e-02,
  -3.481872791321449084e-02,-2.992325522002883820e-02,
  -1.645454548541304662e-05, 2.508481476966433350e-05,
  -2.508481477600497481e-05,-1.645454548957217151e-05,
   2.275275344973427534e-04,-2.105453257183695370e-04,
   2.037555411765223402e-04, 2.201900980982974068e-04,
   2.283563049711484672e-14,-1.620884718825919737e-14,
  -3.635835212049774896e-03,-3.504701718812869727e-03,
   4.122787765445415538e-03, 3.152531424881909686e-03,
  -2.188238874701536418e-04, 3.228178400259643522e-04,
   1.716855316508475462e-05, 1.025869300728208259e-05,
   1.346234558737451070e-02,-1.009311166746733541e-03,
  -1.854085645627274299e-04,-2.473007585012430148e-03,
   1.059785553278008245e-05,-1.094882890805441765e-04,
  -3.347348703725350552e-03,-1.319032299689257661e-04,
   1.106413052436088992e-04,-2.807778321826848514e-03,
   1.859137934713828708e-04, 1.048828382332397426e-02,
  -3.223187949054472784e-04,-2.428693675027158733e-03,
   2.357200953530340078e-04,-4.510165154102004331e-05,
  -2.436811566329213262e-06,-9.698553984497079307e-06,
  -3.674457805947174889e-05,-4.986462702912604524e-04,
   8.875934370354364835e-04,-6.540557560607868515e-05,
   2.985672664918515584e-05, 2.928459143599873942e-06,
   7.723668683442764724e-06,-1.898429479986650178e-04,
   1.998346820522659819e-04, 8.130177559419361896e-06,
  -4.499369617678402374e-04, 7.400697057687237588e-06,
   5.948853034348745242e-05,-7.817587921485349913e-06,
   1.866720298843737776e-06, 9.824222886614735969e-06,
  -6.537132846732241758e-06, 7.567423216932856974e-06,
  -4.540453927069119998e-05,-3.922279705369515162e-05,
  -1.471398972868764853e-05, 1.354616204923278062e-05,
   4.309176393390048412e-05, 4.175044763478087787e-05,
  -7.928211881974020093e-06,-6.094543162085735325e-06,
  -1.180158260441830617e-05,-1.614690831184382747e-05,
  -3.166539321769122855e-04, 2.604240135670260145e-04,
   9.291827106880253245e-04, 1.006705115659980825e-03,
  -1.043446806950356536e-03, 9.630950687136183123e-04,
   1.765092219759831649e-03,-1.826461343719630592e-03,
  -1.642807162858073795e-04, 2.142737725803118046e-04,
  -4.962202048107144248e-05,-3.372914288883892606e-05,
  -2.816271317264530324e-02, 1.229769471196179159e-01,
  -8.370340511159723995e-02,-1.916875516058063125e-02,
  -1.052021637793033831e-06, 1.997231209634015660e-05,
  -2.294264569820571710e-05, 2.388757977029777482e-04,
  -1.692026549790316475e-04,-1.625094129128346263e-05,
  -4.941698622333723113e-05,-7.613243238101531879e-06,
   2.997760513876756403e-05, 1.158960803537608474e-06,
  -3.944962548093712876e-04, 2.822356673540332272e-03,
  -1.921183371747264617e-03,-2.685343252543718443e-04,
   1.902423740481721617e-05,-1.386887953458664348e-04,
   6.935058364634161590e-05, 9.512967245554619275e-06,
  -2.486554973801758175e-03, 1.884169511476851966e-03,
  -1.177606612177434491e-03,-1.554097739537498891e-03,
  -3.902255722417953836e-05,-5.811402608394665447e-05,
   2.139735680712693113e-04, 2.511970796842461135e-04,
  -2.169010995055744166e-05, 2.072532581970013728e-05,
   8.280393171175634906e-03, 1.146615635478584385e-03,
  -8.476176656404841919e-04, 6.121151075537094831e-03,
  -2.905384348041001026e-05,-7.474903278025533415e-06,
   7.474903276426175122e-06,-2.905384347419374727e-05,
  -1.702488893371859123e-04, 8.633054132212478844e-04,
   6.994502834363624405e-05,-8.671167597445697973e-04,
   6.998086781906955294e-05, 1.636502150904369971e-06,
  -4.485432148014570353e-03,-5.935196580229199111e-03,
   4.315776823339189695e-03,-3.261580951091989054e-03,
  -8.889108518264963690e-06, 4.580802304237686058e-06,
   1.524211718426046836e-05, 2.583946330211352928e-05,
  -9.474469875414487710e-05, 5.588776299699762997e-05,
   1.138258401956202112e-03,-7.622132634954466822e-04,
  -5.943784099407460695e-04, 5.049922223941328463e-04,
  -4.829441555276796594e-05,-5.067197871029473655e-05,
   4.471646100739214516e-04,-3.370412443083160370e-04,
   2.106515344703031791e-04, 2.794788853399739095e-04,
   1.723927280542036613e-05,-1.013940201098140980e-05,
   7.218760945098077607e-05, 1.081004272040175481e-04,
  -4.525526455279199904e-05,-5.340375483294041901e-05,
  -7.921557173246884256e-05,-1.117556240634379499e-05,
   6.984726502470354021e-06,-4.950973232220007660e-05,
   3.919699808478291631e-06,-1.961213791026912302e-05,
  -8.294859000616092076e-07, 9.965538276560829896e-06,
   6.008840727539586247e-06, 7.993361815347879465e-06,
  -5.008002847450530904e-06, 1.936284864062949517e-05,
   4.840712159121670862e-05, 1.252000711594749874e-05,
  -6.571218080448734027e-04,-1.304603981279365914e-04,
   3.189059716971362436e-04, 2.613419682210621467e-05,
  -7.396625255483562076e-07, 2.999088026964696183e-05,
   6.127383734597942215e-06,-1.903825539719920457e-05,
   1.068246802676377314e-04, 1.690833560990740770e-04,
  -7.608685053533476494e-05, 4.807068932465525726e-05,
   3.037382759666352756e-03,-1.342066657794037388e-02,
   6.427485026038462328e-03, 1.454676792149255712e-03,
  -1.823619927829466764e-05, 5.716153458298968188e-05,
  -3.810768971383969052e-05,-1.215746618292867295e-05,
   1.345609445443339276e-04, 3.864705754592564368e-05,
  -7.101629666754559044e-04,-1.185897925803872793e-04,
   1.838423558594859549e-05,-1.690038898234069687e-04,
   1.192962547355834208e-04, 1.297704126142891808e-05,
  -1.997374524367570675e-05,-1.024451531670547849e-06,
  -2.475251825485953183e-01, 1.559412472674631955e-01,
  -9.763185300433599445e-02,-1.549708153610378503e-01,
  -7.420395581970278032e-06, 6.703560949754689603e-06,
  -1.540362228574254123e-04, 1.275370391565919996e-04,
  -7.652109542930983466e-05,-9.242037126462722223e-05,
   1.361333387495062721e-05, 1.465186475535185199e-05,
   4.532894370822266434e-04,-2.336517199286359419e-04,
   1.557678131591361508e-04, 3.021929578091713409e-04,
   8.133811302547964750e-06, 1.827131942949230566e-05,
  -2.540797215001097973e-05,-4.306315073498764027e-05,
   1.622390779324909757e-04,-7.796461756216804427e-05,
   1.169469263182299949e-04, 2.433586168466683860e-04,
  -3.396800776775270141e-03,-6.143434163926506618e-03,
   1.809875746879803862e-02, 2.538936859737044027e-02,
  -2.238076914432437624e-03, 1.796579952033498882e-03,
  -1.752783506402632826e-04,-2.183517798491242798e-04,
   9.372782691261895077e-05, 1.039956463619421962e-04,
  -1.406804581682994066e-05, 1.421583929620666815e-05,
   5.573021212117770240e-01, 1.268777949621210654e-01,
  -9.378866467641042148e-02, 4.119603574872074958e-01,
   3.994727886324452362e-05, 2.053024944363178013e-06,
  -1.539768707942887799e-06, 2.996045914102314563e-05,
   5.873023664781133139e-04, 5.565009262625216543e-05,
  -4.150176174706725346e-05, 4.379881818124008500e-04,
  -7.550122469032312629e-06, 4.942666942757334891e-05,
   2.241112664685584878e-06,-5.995188223202658513e-05,
  -5.808658544133417975e-04,-1.861308888703150886e-04,
   1.342578670821622405e-04,-4.189837116650174404e-04,
  -9.113201028220344789e-06,-4.116985185696407274e-06,
   3.230876000216197568e-05,-8.399416742451440649e-05,
  -1.501801472645489088e-05, 5.809009583118265115e-05,
   9.382621757758640617e-06, 3.459249767049809413e-06,
   2.694791992951654666e-05,-6.460502775691969661e-05,
  -3.433918967343575247e-03,-1.207239437284976600e-03,
   1.081209476383555943e-03,-3.075434428297840490e-03,
  -2.244815250538748780e-02, 7.778518394661786128e-02,
   9.896654003412837242e-03,-5.880273033959531465e-02,
   5.059375760648896804e-03, 5.568977967617508599e-04,
  -2.188232314370678494e-05, 1.987993056243351846e-04,
   1.102438343205947262e-05,-2.097065099506476688e-04,
   2.999968443048923835e-05,-1.376011303064319671e-07,
  -2.098633505050357395e-01,-3.340608793236128915e-01,
   2.427107227280278501e-01,-1.524754577020071278e-01,
  -2.677631310196616025e-05,-2.971580482950908776e-05,
   2.228685361736342267e-05,-2.008223482217784143e-05,
  -3.756445241445112242e-04,-4.548760196357145495e-04,
   3.315189174688693702e-04,-2.737740848533393189e-04,
   8.060508725849615576e-05,-5.916352337240012900e-05,
  -4.400313891783352719e-05, 4.077958477616517804e-05,
   9.596906821210174072e-05, 1.867674234199113656e-04,
  -1.245227235875015330e-04, 6.398508655900664419e-05,
   3.526883256513341240e-06, 9.357408535215606008e-06,
  -4.570423224263620910e-05, 2.027617210203081820e-05,
   1.723822650226577541e-05,-1.014118075258408856e-05,
  -9.897981399262787468e-04, 4.063800812165378577e-04,
   3.023784132661151944e-05, 6.312929585582528324e-05,
  -7.079649970197385463e-03, 3.391029941719613146e-03,
   8.234660643561655946e-02,-4.539349827109858543e-02,
  -3.436954041944604438e-02, 2.443411187815756544e-02,
  -2.243709372600388892e-03,-2.802409651210254187e-03,
   4.683759950999203661e-05,-3.749985694107516937e-05,
  -1.041152687234778656e-04, 9.359492853569242540e-05,
  -1.419786022570268167e-05,-1.408619057841437300e-05,
   1.936432389342920141e-02,-1.213056901810420814e-02,
   7.538459198411457361e-03, 1.203382671971748967e-02,
   3.859382151556464902e-05,-3.178862911206992826e-05,
   1.907317746316115550e-05, 2.315629290438430329e-05,
   5.906790393064195903e-06, 8.069066070643153297e-06,
  -9.456535082017023669e-06, 3.251760176055625817e-06,
   1.893108898508660834e-05, 4.627757415680658245e-05,
   8.482739895350143410e-04,-4.049774288073312726e-04,
   3.149905344969164064e-03, 5.731424730620545555e-03,
  -1.764054327958767491e-03,-2.488079156667869028e-03,
   2.422391412109123712e-04,-1.934381320950572642e-04,
  -6.675848450258070493e-06,-7.445337297207355974e-06,
  -3.098861814154215896e-03,-7.138309633631481936e-04,
   4.085447062574389760e-04,-1.773562166078207405e-03,
   7.746530523384761481e-06,-1.843885204806059111e-05,
  -1.696585240978411562e-04,-6.013306063255082108e-05,
   1.336290240527804591e-05,-3.770189436384266629e-05,
   2.461605982332647257e-04,-8.448652522596179076e-04,
  -8.087346514319976450e-05, 4.731365808306993784e-04,
  -4.968569041653103727e-05,-5.597514433445971668e-06,
   2.013226590130110264e-04, 3.222904948927057334e-04,
  -1.696254155555439581e-04, 1.059585691697111494e-04,
   1.289040323347506144e-05, 2.708943529271911054e-05,
  -8.769838480431960668e-05, 4.805198541905927683e-05,
   4.899029729105834494e-05,-3.464030558949678231e-05,
   9.028738065059165215e-06,-3.896770315213038128e-05,
   1.948385157189648750e-05, 4.514369031563667739e-06,
   9.597208532444653569e-06, 2.809553057831717354e-06,
   3.505359242184238151e-05,-7.191137363674369272e-05,
  -3.595568681067889662e-05,-1.752679620717114550e-05,
   5.534474914782297385e-04, 2.316831911356954574e-04,
  -7.123275537202591098e-04, 2.017931627819041264e-03,
   2.545983547272237871e-03, 8.987292765714478392e-04,
  -3.528617422012422095e-02,-1.023213266356945601e-02,
   1.444362965868460635e-02, 2.449874607806986487e-03,
  -1.460968583974989340e-04, 1.311870876625572399e-03,
   4.992765814589365092e-05, 2.688671059609137316e-06,
  -4.830724419644508486e-05, 1.290000602111014973e-05,
  -1.806000842496776812e-05,-6.763014185784759998e-05,
   4.979675870280649835e-06,-8.671956424414542633e-06,
  -2.413723499887289762e-04, 6.511724283739844430e-05,
  -3.907007479129792122e-05,-1.448224057974843097e-04,
   9.454506865743177057e-06, 2.847125392260789096e-05,
   8.492322657831092832e-04, 4.890958486603412666e-04,
  -3.293910639225222821e-04, 5.719319031429625664e-04,
   1.812659487332673083e-05, 8.451423448052120926e-06,
  -4.929502133649416425e-05, 7.529940812432496977e-05,
   4.936797627363465768e-05,-9.829955699963418907e-05,
   9.177920096800658623e-06, 3.970614901591766328e-06,
  -1.762796943502268894e-04,-6.567564249928790898e-04,
   3.090606639532708340e-04,-8.295483272653458385e-05,
  -3.414688277183604380e-06,-9.398931001431220272e-06,
   7.373560678531504588e-06, 4.945331738235231512e-05,
  -3.956265391957494742e-05, 5.898848544866932375e-06,
   2.349687730721113760e-04,-4.888430253248931650e-05,
  -9.494435275249576999e-05, 3.139378711159695871e-05,
  -3.676182808621404495e-06,-9.299767736755390070e-06,
  -2.500905420472701460e-05, 4.329604003619351752e-05,
   6.927366573813203347e-05, 4.001448769810848753e-05,
   7.679674859584426365e-06, 6.404888293410506117e-06,
   2.382442845776201404e-05,-3.213092912476550719e-05,
   3.213092914038532329e-05, 2.382442846934370559e-05,
  -1.086747820355791133e-04,-7.134277519481150871e-05,
   2.679175223611329556e-05, 1.349822252293297202e-05,
  -9.892538893209512006e-06, 1.462078741496893680e-06,
   6.073020583909383828e-06, 2.937887710834622177e-05,
  -9.444560208684587470e-04,-1.019861395628058687e-03,
   6.089816134556128892e-04,-5.639554099134685018e-04,
  -3.700704251329193188e-05,-3.362259365990975546e-05,
   2.017355619162954143e-05,-2.220422550322444406e-05,
   4.451136738687935622e-05, 4.023354537385753744e-05,
  -2.011677268262460468e-05, 2.225568368867795365e-05,
  -9.457018407508145872e-06,-1.897528621233304433e-04,
   1.298388474820587183e-04,-6.470987351165457646e-06,
  -1.678645099726383820e-04, 1.852365338892962977e-04,
  -1.185506010711234514e-04,-1.074325789731036287e-04,
   1.498109943975195176e-04,-7.274572005029248654e-06,
   4.850118491544804605e-06, 9.988231247993227329e-05,
   4.722546494774885526e-07, 9.988842552871023635e-06,
   7.136012571862488673e-06,-7.005521006621886782e-06,
   1.999946542173347414e-05, 1.462287416590031395e-07,
  -2.805851716191645222e-05,-2.850823766342704013e-05,
  -3.435432195156122962e-07, 3.999852469849763482e-05,
  -1.988581921630517801e-05, 2.134055785687850518e-06,
   2.334357585622547348e-05, 1.884349930996488743e-05,
  -2.108656204849919825e-06,-1.988852857829728860e-05,
  -1.798903843162574074e-04,-6.330394336713292567e-06,
   3.165166675650675167e-06,-8.994432564897713580e-05,
   4.386275174413121563e-07, 1.999518956901742619e-05,
   2.207536888024486370e-03, 2.371606138655638681e-03,
  -1.346837654122988231e-03, 1.253662551802234336e-03,
  -6.927014640738887675e-05, 5.745995837710736958e-05,
   2.905956361545652153e-04,-3.032430714644229449e-04,
   3.801586975182694362e-05, 3.247758684096047717e-05,
   3.061387101696573629e-04,-8.394465917338797198e-03,
   5.386446072203240377e-03, 1.964389002445796257e-04,
  -1.855778345690706231e-06,-1.991371604527054581e-05,
  -7.505066800442860372e-06, 4.943353085023252511e-05,
  -3.954682467172470440e-05,-6.004053439069610876e-06,
   1.065317510108468139e-03, 9.996495272646680396e-05,
  -1.079766985352126514e-03, 2.230678603584064704e-05,
  -8.545515212736708052e-06,-1.096675620671349059e-04,
  -6.346443668901525538e-03, 5.892282090030058483e-03,
  -3.803443757700817988e-03,-4.096603181461083883e-03,
  -1.277871767094549214e-05, 1.538519985850900391e-05,
   1.090990473792831006e-05, 1.676227844325852489e-05,
   8.056118641958279718e-06,-5.924436886885732774e-06,
   7.109324262741805345e-05, 9.667342368281525928e-05,
  -1.204794703413455655e-03,-1.456206300394833827e-03,
   8.004391104456388658e-04, 7.690185175235961365e-04,
  -7.155744950959695011e-05, 8.354358913343124427e-05,
   4.546781257204974940e-03, 1.716321438270188298e-04,
  -1.075057469344710425e-04, 2.847981178258446495e-03,
   1.991606997315360436e-05,-1.830343362445808511e-06,
   4.150747736961758763e-06,-1.956454173304621340e-05,
   4.942390518475700155e-05, 7.568196369555293284e-06,
   1.362275346228469137e-05,-8.896302931352836571e-05,
  -1.231052384572419703e-04, 1.294149759327739438e-03,
  -1.162650683800927756e-05,-5.998860306156767646e-04,
   5.982457462551238331e-05,-4.584786895429301842e-06,
  -1.130932298747858286e-05, 2.897811316466977977e-04,
  -1.598782896949116036e-04,-6.239589191230729035e-06,
  -1.526262718687624281e-06, 9.882839779817553704e-06,
  -8.958459511358298042e-05,-8.637147580967121125e-06,
   3.999344683294036695e-05,-7.240237708615275982e-07,
   3.672888458552169889e-05,-3.392622933813050409e-05,
   1.357049173234872346e-05, 1.469155383106529353e-05,
   6.354902790093247406e-06, 7.721088688032606652e-06,
  -2.365657165227595982e-05,-3.225471465787185506e-05,
  -1.612735732548534570e-05, 1.182828582360726231e-05,
   3.470841377016345994e-04,-2.864146989177170761e-04,
  -1.387464171367883570e-04, 1.440466287110818899e-04,
  -1.517311444809695853e-05,-1.302983491625858665e-05,
   6.577928842635679131e-06,-1.888731987713507506e-05,
  -1.801220472095282256e-05, 8.692553197449231497e-06,
   1.978021189724133770e-05,-2.956893183771158232e-06,
   2.368897437712311901e-05,-3.223092448193201512e-05,
   1.611546223751801087e-05, 1.184448718602731994e-05,
  -1.186355656888389028e-04, 1.804445640872501789e-05,
  -1.052593295641856641e-05,-6.920408032262405059e-05,
   1.368534300975131725e-04, 1.008535232338972815e-04,
  -5.932529964116156564e-05, 8.050160755045363849e-05,
  -1.938399907914669423e-05,-1.285467240425060709e-04,
   6.921746742778827320e-05,-1.043753806154928511e-05,
  -3.565683995614204001e-05, 4.825546356985987160e-05,
  -2.412773177976766640e-05,-1.782841997425646134e-05,
  -9.369644882377899101e-07,-9.956008113083341421e-06,
  -1.914703307173397186e-05, 2.309526195023398355e-05,
   2.987159000568356031e-05,-2.772744224111947324e-06,
  -1.538052589262104780e-05,-1.278434289537063451e-05,
   4.131084075650732290e-06, 1.956870318544141720e-05,
   1.639011695084060044e-05,-2.512695895522909406e-05,
  -1.957396337766579897e-05, 4.106087881402218611e-06,
   4.807384822558096737e-01,-2.811583743325400397e-01,
   2.511867903477844610e-01, 4.294915868722409824e-01,
  -5.006235394356688844e-06, 1.936330568824162383e-05,
   1.206691780022907563e-04,-7.098726867735048556e-05,
  -5.070487777031167098e-05,-8.619173600071664606e-05,
  -6.677920961497153113e-04,-1.735627720243323102e-04,
  -1.635008486918684812e-04, 6.290783051960782994e-04,
  -3.511153314487370104e-03,-5.985986896952569074e-03,
  -3.639890823614279868e-03, 2.135022169228565064e-03,
  -3.446840834484158483e-02, 1.319267388485488302e-01,
  -1.104001130252781210e-01,-2.884416161791457725e-02,
   2.730781718307464124e-05, 1.242107563199218705e-05,
  -1.167658745504133733e-01,-3.066670447097205945e-02,
   2.793608314799494313e-02,-1.063688204050869945e-01,
  -3.321584691822345814e-05, 7.277848244353766127e-05,
  -1.708058716631442056e-06, 1.992692990454222879e-05,
   7.470252928839895765e-03, 1.281052403797182555e-02,
  -9.683471286832874211e-03, 5.646761953483125061e-03,
   3.803167529389427028e-04,-1.440594450244255626e-03,
   9.378356303158647510e-04, 2.475884879687698038e-04,
  -1.210302569183878077e-04, 7.036987810340383581e-05,
  -4.021110978969854395e-05,-6.915971833387794191e-05,
   9.665470837176558960e-06, 2.564892492033434588e-06,
  -1.910218901915155190e-05, 5.925063263510853686e-06,
  -1.821379463035798158e-04,-4.870257563566300304e-04,
  -1.172207291036377400e-02, 5.164404951737599364e-03,
   5.507085927299354595e-03, 1.249988398793583193e-02,
  -1.865739413402197328e-05,-7.204279570350008416e-06,
   4.447792476018876877e-05, 1.006067303747889066e-04,
  -1.829213280081593766e-05, 8.086895413330634873e-06,
   3.613865646409288469e-04,-9.323609873480410244e-04,
  -1.025649774409858998e-04,-3.975456432953049945e-05,
   1.975621460771278658e-03, 7.686619326817814351e-04,
  -1.595324768911577382e-04, 4.100317338944492723e-04,
   4.824086547130642332e-05, 1.098763799994214045e-04,
  -2.746909501000375451e-05, 1.206021637228222614e-05,
   3.637856640419569068e-06,-9.314826840245354219e-06,
   6.120684614122789448e-03, 1.198716784305949544e-02,
   1.371077235432143838e-05, 2.668360396587896575e-05,
   5.514684584136540411e-05,-1.713385240313239951e-04,
  -8.543977709053087854e-04, 4.376347388865721032e-04,
   9.809703269465083406e-03, 3.171173661550203728e-03,
   6.213002591571027862e-03,-1.913575429945232539e-02,
  -1.559531637225798888e-03, 7.937921615544297517e-04,
   1.426092337847640115e-04, 4.650383225197057818e-05,
  -4.524758187188501585e-06,-8.917766724212437956e-06,
  -1.011926690488568030e-02,-1.523464673119690610e-02,
   7.835819207065717381e-06,-3.922499122031823665e-05,
  -1.140175365348336869e-03, 7.594359775101587910e-04,
  -7.842569183105739528e-04,-1.577097383348007595e-04,
  -1.676404140537969328e-03, 8.281661235358762918e-03,
   1.217139402744494116e-03,-8.062186508119607853e-04,
  -1.763707917275207226e-04,-3.593616909036660966e-05,
   1.102326104330297036e-05, 1.668795122150107347e-05,
   1.240007861820390444e-03,-9.298502173558388087e-04,
   4.439304051433015977e-04, 5.920063061814033207e-04,
   1.980414787570879121e-05, 2.792082899388735004e-06,
  -7.812441428726483940e-05,-1.039065728145701408e-04,
   6.394250633460771065e-05,-4.807656262867776966e-05,
  -1.831293198582627208e-05, 1.287036771187220448e-04,
   2.079059399175959394e-04, 2.958242858631096107e-05,
  -5.938730599211074343e-04,-8.527473000513762142e-05,
   9.949312831383677375e-06,-6.928932938198897591e-05,
   7.186960994364223715e-05, 9.609765423644146874e-05,
   2.867942832434998052e-06,-1.979330452223389457e-05,
  -3.867736219862086364e-05,-4.587005177669064800e-05,
   4.514510937242795750e-03,-6.491059133814740256e-02,
   1.566955070227613045e-01, 1.089812256656095234e-02,
   8.688373452031696343e-06,-1.297093371679764145e-04,
  -1.197316958163721949e-04,-8.020037030568791248e-06,
  -2.236943208788845072e-03, 1.953560823396360661e-03,
   2.196934720341066523e-03, 2.515620780250606842e-03,
   8.291418370375451541e-02, 5.660255545482859724e-03,
  -3.604828546830590816e-03, 5.280528660777138172e-02,
  -1.519902684916043245e-01,-1.744871863396540712e-01,
   1.927343751566313323e-01,-1.678848174592902365e-01,
  -7.694875442166876790e-05, 4.667857305951492359e-05,
   1.070830282532804923e-03, 1.557258638380963709e-03,
   7.333114349686833044e-04,-5.042528400474664396e-04,
  -9.699375564300357841e-03, 9.475207455871678328e-03,
  -5.538312846569001194e-04,-5.056768551394653574e-04,
  -1.262045241528750711e-05, 1.551528861586092960e-05,
  -2.491000441067369852e-03, 2.164242467137819561e-03,
  -5.817264850135321456e-03,-6.695557234239441630e-03,
  -1.097259426593544891e-04,-7.772235005483598769e-06,
  -2.119683800980282142e-05, 2.992502195806404368e-04,
   3.274478214580473065e-05, 3.778596617030512952e-05,
   5.869760166794407458e-06,-1.911925510014220690e-05,
   7.380292112586833621e-04, 1.812062656986464877e-04,
   3.557340290420301938e-03,-1.915135130286110127e-02,
   1.416688789259174658e-02, 2.631482253821705933e-03,
  -2.539167833490330124e-05, 1.376781124338479227e-04,
  -6.927199854117857590e-04, 4.750386855511438489e-04,
  -2.771060566373213514e-04,-4.040868867103181335e-04,
   3.931794390363163057e-05, 7.355221611250140736e-06,
  -5.516416211119245159e-06, 2.948845794205892716e-05,
  -2.551315906386750557e-02,-3.245953421862495230e-03,
   9.923227853648471748e-06, 1.236749353982113039e-06,
  -1.350157004046120151e-04,-1.736905147871826613e-04,
  -3.523219293867553841e-04, 2.797782543235513824e-03,
   1.662727326883686393e-02,-1.289092573434506318e-02,
   1.682113713950929464e-03, 2.175395029129277655e-03,
   3.441708019880811761e-05,-2.677857151728793984e-04,
  -1.583734689212711193e-05, 1.221386275583739346e-05,
   4.199642536774619503e-04, 5.177984038888484336e-06,
   3.635802937011866200e-05,-3.289657237642938832e-03,
  -2.093559365068069895e-04,-2.148572505903441224e-04,
  -9.524005483874944464e-07, 6.999352060951576223e-05,
   7.171072492897733372e-06,-6.969628347451928248e-06,
   8.952717273418021917e-06, 1.997932701388718596e-04,
   1.997816741452035588e-04,-9.207882697041495918e-06,
   2.762451051332610163e-06, 5.993637342455821279e-05,
   3.376077453966693642e-05,-3.688102628291995403e-05,
  -9.990539039548749605e-06, 4.348904451150464747e-07,
   9.948138195606376751e-06,-1.017126561012700063e-06,
   8.006828320592373083e-04, 6.318441559085611302e-04,
  -9.477678438381471112e-04, 1.201026288274829141e-03,
   5.506152057330921827e-05, 4.322301410399977692e-05,
  -1.852414890516134799e-05, 2.359779453580963370e-05,
  -2.248139191226038224e-04,-1.876521208558557278e-03,
   1.270868290210314631e-03,-1.522545440508470669e-04,
   3.992283111326166934e-05,-2.483456217018701554e-06,
  -1.378288263757307527e-04, 2.456042752653656111e-05,
  -2.313383077390921453e-06,-9.728733665654606713e-06,
  -4.285892550363526801e-03, 5.445437456667615202e-03,
  -4.502504417019080780e-03,-3.543746538719775782e-03,
   2.112011061581531632e-05,-2.130588948473219389e-05,
   2.130588949011765986e-05, 2.112011062115374825e-05,
  -4.270406091534981554e-04,-3.775082544455327636e-04,
   5.000704332704626132e-04, 3.492798795787819622e-04,
  -2.099552505105429514e-05, 3.404684898181145966e-05,
   1.529253507935028188e-03,-1.812291436513228341e-04,
  -6.590030498304615808e-05,-5.560820436430811801e-04,
   5.334330399117062872e-07,-9.985762324025670482e-06,
  -3.999768919275779313e-04, 1.496029347010673035e-06,
  -1.271642807190292293e-06,-3.399851337666670191e-04,
   7.722718369230137131e-05, 1.267590583584861288e-03,
  -5.050846632852096251e-05,-2.855558683034379393e-04,
   2.919504102322358308e-05,-6.902867434058751727e-06,
  -1.629828536450717976e-05,-1.390480703734311909e-04,
   1.887080954634441936e-04,-2.211910156103471454e-05,
  -7.389256974582895796e-08,-2.999990898399581914e-05,
   2.999990899157880706e-05,-7.389256976445144053e-08,
  -5.989356677700520201e-05, 3.572205952630000517e-06,
  -3.721230538998818871e-05, 3.339527398842404536e-05,
   1.489478561573527994e-04, 1.480267330369857890e-04,
  -1.480311344047438918e-04, 1.489522849134173146e-04,
   2.122399820626742089e-04,-2.394706593258664280e-04,
  -4.542890164183947636e-03, 2.468459631032304813e-02,
  -1.680714855665418894e-02,-3.093144765510013380e-03,
   1.140138621029143732e-05, 1.643193209831930721e-05,
   3.141234046353890254e-04,-1.731682531816381961e-03,
   8.363256317292390831e-04, 1.517076311597770333e-04,
  -3.206959930384752078e-02, 2.219104327966269982e-02,
  -1.386086582288916652e-02,-2.003116335462373082e-02,
   8.885591731592587528e-02, 1.623551489918063223e-02,
  -1.200273795709334498e-02, 6.569020435157532645e-02,
  -4.056295145327867835e-02,-5.878023798028689240e-02,
   4.272305299103095616e-02,-2.948224069783829046e-02,
  -1.270966283838699670e-04, 5.870644814202656336e-05,
   3.929277925903984676e-03,-2.704106715743801424e-03,
   1.678016429357663411e-03, 2.438288724624413251e-03,
  -6.784224073697231634e-04,-1.257511584097682224e-04,
   7.107699725362830439e-05,-3.834575219441674907e-04,
   5.092781129533936936e-05, 7.420483836426236719e-05,
  -4.122491019354757020e-05, 2.829322849135729260e-05,
   9.382264772907420434e-05, 3.460217873351397654e-05,
  -7.297371664232314204e-05, 2.391028925383762848e-04,
   4.686336805450223917e-04, 1.430260464442222024e-04,
   1.763633784593929938e-05,-9.431839024489828305e-06,
   1.414775853370777451e-05, 2.645450676324879370e-05,
  -4.209766735640518539e-04,-1.278937076946267944e-04,
   1.191767746412847507e-04,-3.922838977690287126e-04,
   8.468082030835208396e-05, 1.588298160345035404e-04,
  -1.067672068838820907e-03, 5.692340951269862087e-04,
   1.412829813443677266e-04,-7.509406888993993211e-05,
  -2.868220510086042950e-05,-8.793810923153624150e-06,
  -6.334221022297268321e-03,-1.544114685328602321e-03,
   1.944301979541023493e-05, 4.687107982038161302e-06,
  -4.638101806726672494e-04,-7.595514064708470178e-04,
  -2.570251776625668248e-03, 1.060244116428497516e-02,
   1.269176975449337608e-02,-7.727827380262198079e-03,
   6.331208238831885970e-04, 1.042799695925594348e-03,
   4.047186109533751678e-05,-1.651057399352028434e-04,
  -1.710904785436527466e-05, 1.035762914556410774e-05,
   2.857447173273881726e-03, 3.587394507112315290e-04,
  -8.932734720132725270e-05,-1.098294322909540081e-05,
   2.552262314906859723e-03, 3.272160575197523812e-03,
   1.157740565143294776e-03,-9.317956845830746224e-03,
  -5.974669387531409900e-03, 4.647939238098133460e-03,
  -3.861815880913988560e-04,-4.977254856177028113e-04,
  -1.258347123230598528e-05, 9.920512210438394611e-05,
   7.908557052620158168e-06,-6.120026580453060266e-06,
  -1.760900197773527728e-05, 2.593865754954964315e-04,
   1.303649655606179046e-06,-1.995746721343762836e-05,
  -2.933108797271693352e-04, 2.570101931131055380e-04,
  -2.636127536833296774e-05,-3.008460005169187959e-05,
   7.981872726390542433e-04, 5.316257605242429810e-05,
  -2.658275880020204053e-06, 3.991157186407270891e-05,
  -4.211422686977711193e-04,-4.818655642445932095e-04,
   4.522775734132560390e-05,-3.942651348869397325e-05,
  -9.976162864650901042e-06,-6.900539819175978891e-07,
   9.999430313770178773e-06, 1.067398709669942463e-07,
   1.401773211160134995e-05, 1.426545430217280031e-05,
   2.819060293357168062e-07,-2.999867545393669925e-05,
  -2.142501882528369066e-05, 2.099925161371803362e-05,
  -1.908247522802885605e-05, 5.988250092611787890e-06,
  -3.813423358151164056e-05, 1.207394831985679773e-05,
  -6.036974160749910709e-06,-1.906711679335059391e-05,
   1.419575436534580091e-04, 7.379740892192838085e-05,
  -5.073769882935336552e-05, 9.759962038861912396e-05,
  -5.111432821307197079e-06, 8.594955178083452772e-06,
   8.197128064635149342e-06,-1.824300116461024919e-05,
  -3.607570198258810241e-05,-1.144488687714239136e-04,
   5.722443467143921599e-05,-1.803785108135893235e-05,
   3.877380364295679736e-05,-9.828130484337024262e-06,
  -1.870052710196783074e-05, 7.091564433082919491e-06,
   1.773358899709782355e-05, 9.247692745265996970e-06,
  -1.717683986070861059e-05,-1.024481197482764285e-05,
  -2.628633306215945624e-04,-2.603745578550124666e-04,
   1.548218043265528715e-04,-1.563016581703978143e-04,
  -2.999905210867948133e-05, 2.384797281387380358e-07,
   4.130983998306411785e-04, 4.071019590341521050e-04,
  -2.316255237979710673e-04, 2.350372704368372913e-04,
  -1.134233808557884262e-05,-1.699908385548705349e-03,
   1.089937228564424572e-03,-7.272413409766956856e-06,
  -2.411915929393075185e-06,-1.985403388607816450e-05,
  -1.377494744494506132e-03, 1.394218445431778071e-03,
  -8.962821494118920198e-04,-8.855312124469588448e-04,
   1.253248510286604569e-05, 1.558643053990473569e-05,
  -1.851523742896099447e-05, 2.360478728879381236e-05,
   1.119943455596556989e-03,-6.042198687300931684e-06,
   3.776389148996228042e-06, 6.999674343863875525e-04,
   2.172162258490363283e-06,-1.988169285930210890e-05,
   9.928549076193421283e-06,-1.193278358816065768e-06,
   3.294275839036772958e-07, 7.999932173129322257e-05,
  -3.999966085708840045e-05, 1.647137919166655783e-07,
   7.046422947626964800e-06,-7.095627078923760215e-06,
   8.174538425004479816e-05,-7.360497279006775987e-05,
  -1.482856437384096315e-05, 1.342064374800458814e-05,
   1.897530142707077412e-04, 9.578636132495555209e-06,
  -2.546249793208470798e-04,-2.820601819143244175e-04,
  -1.498969203388508001e-05, 2.895998364709271135e-04,
  -1.997192605639588607e-05,-1.059325067132418933e-06,
  -3.310182686433821650e-05, 3.747357813504572179e-05,
   4.620839675110505516e-05,-5.258121403783354205e-05,
  -2.195473012170687883e-04, 1.402199425333166504e-05,
   1.875750883384547346e-04, 1.652661410000091262e-04,
  -9.369488473943990100e-06,-1.497070884067604635e-04,
   9.981262272087951652e-06,-6.118851655283571222e-07,
  -2.943683400915765821e-05, 5.785568556097068283e-06,
   4.149219138938479751e-05, 2.789978590790012742e-05,
  -1.673987154115841932e-05, 2.489531482830437822e-05,
  -7.663956798040728736e-06,-3.925893231097562271e-05,
   1.962946615128794079e-05,-3.831978398200518637e-06,
  -1.118110251812893663e-05, 1.658260976080335749e-05,
   2.873045035806477188e+01,-6.657975045511533381e+02,
   4.884284268168005383e+01, 2.107663151965093906e+00,
  -1.622167298125712520e+01, 7.695440519990355277e+00,
  -7.146931322539978204e+00,-1.506543809059189876e+01,
  -3.660635329891013487e-05, 1.037312185388498991e-04,
   5.658021852225155357e-05, 1.996694435995048349e-05,
   1.398666008274395941e-03,-6.678987676688389729e-04,
  -4.352110280863490739e-04,-9.113879241537186596e-04,
  -2.164087821893249247e-02,-7.668079285802193064e-03,
  -5.774437622203861670e-03, 1.629663657707769789e-02,
   1.502656409127122172e-01, 3.157119145834013096e-01,
   3.000012629332831637e-01,-1.427880291080499409e-01,
   3.612317524793318135e-01,-1.015348266479930706e+00,
  -8.019960093569905579e-01,-2.853271468575286907e-01,
   1.188278819908848094e+00, 4.244659994122902957e-01,
  -3.139614028989305972e-01, 8.789247804305153622e-01,
   1.986870101696983865e-05, 2.287951026193912059e-06,
  -3.934587303701055083e-02,-8.321377099418067469e-02,
   5.337252684337039088e-02,-2.523607138283091855e-02,
  -2.292198815602389944e-03, 6.391157615278664564e-03,
  -3.689744467728982291e-03,-1.323332705578264849e-03,
   4.522771821236592051e-04,-2.131433509723044170e-04,
   1.151016624288278773e-04, 2.442387027490398703e-04,
  -3.763437229809136195e-05,-1.355190099611549931e-05,
   2.146248103735573856e-04, 7.706198526349252852e-04,
  -9.629925030402217265e-06, 2.695281786536035958e-06,
  -6.098472926686085226e-05,-3.436368417918779446e-05,
  -1.033196386350137869e-04, 1.828135326705058886e-04,
  -9.636778347046619122e-06, 2.670674650700351674e-06,
   1.609025123119890135e-04,-5.488574643319873227e-05,
  -1.090836879839133557e-02,-3.197886626217442269e-02,
   9.456238223395564853e-06,-3.252623350834326812e-06,
  -1.078046292475961403e-04,-5.270827160879282047e-05,
   2.300675255457520498e-04, 6.716550490755078236e-04,
  -7.568307760638735403e-05, 2.592434675292846870e-05,
   3.523060994492243660e-05,-7.182481546226141900e-05,
   1.400511208370331740e-03, 6.869612373945060014e-04,
   1.408627689719010173e-03, 6.931757626464672218e-04,
   2.481259919592923059e-03,-5.042258567703497910e-03,
   9.005301504369999602e-05, 2.651061496246127545e-04,
  -3.503275351742663347e-04, 1.190015804610425484e-04,
   8.853490454235512762e-06,-1.793364733613217642e-05,
   1.793364733229514427e-05, 8.853490452341247242e-06,
  -3.026620959634343522e-01,-7.450977137362787550e-01,
  -9.224717811589735976e-06,-3.860645191744389564e-06,
   6.437802836597136846e-05, 1.573328999949750204e-04,
   7.202415118433980060e-04,-1.714809242283216791e-03,
  -1.478758303494749626e-02, 6.028798001157588925e-03,
   5.851198296691524810e-03, 2.466373195404264820e-03,
  -1.349891362755189540e-02, 3.191075374525809832e-02,
   2.938341161384946769e-03,-1.189197848559047808e-03,
  -2.485217133122784674e-04,-1.055042716404032031e-04,
   7.479462392235882664e-06, 1.854879085878993769e-05,
   3.848270235516062510e-01, 7.043182078578364980e-01,
  -3.372036667305969510e-05,-6.134278169070654511e-05,
  -2.600553303663778390e-04, 8.928578066463723579e-04,
   1.473195474425182533e-02,-8.073729284401602938e-03,
   5.364741210495389129e-02, 1.569979721099680828e-02,
   2.870454143618809961e-02,-9.762291072193488017e-02,
  -8.921772766237593896e-03, 4.859912844281770450e-03,
   8.918548397580557119e-04, 2.634744438109123694e-04,
  -3.817890738475909925e-05,-7.030199872112571447e-05,
  -3.044317327035892667e-02, 1.896654377334380803e-02,
   3.172720054498188942e-05, 5.092528586741165611e-05,
  -5.847003440129835278e-05,-1.346310589549789761e-05,
   3.141391310875882352e-05,-1.364300774580364244e-04,
  -3.337997329797914121e-04,-5.342599308106913639e-04,
   1.255089302411149755e-03,-7.841660020711598532e-04,
   4.134740441275311749e-13,-1.785279915799849234e-12,
   3.224471885353341876e-03, 7.467934965342673060e-04,
   6.417823933261230032e-03, 1.495018552078762131e-03,
  -4.432465164269913985e-04,-7.134831257375805029e-04,
  -2.053055579043974513e-05, 8.762702932802413308e-05,
   4.783553532625995893e-04, 6.782222239815177125e-04,
  -4.898713510094986068e-05, 3.464477723352636131e-05,
  -2.069457066332544245e-04,-3.562596952590110267e-05,
   3.418110603314256302e-05,-1.970471778017634915e-04,
  -2.453773535045732689e-05, 1.725976659838752400e-05,
  -5.480711974474784836e-05, 4.354514461342557475e-05,
   2.324267099114633861e-02,-1.480816879710213640e-01,
   1.063540368950823406e-01, 1.669316390164604647e-02,
   3.548927360808005902e-05, 4.837883272062709590e-05,
   4.031569394404639384e-05,-2.957439468087547408e-05,
   8.999299532782039561e-05,-5.830745080671421174e-04,
  -6.423732388117798240e-04,-9.914529117511779004e-05,
  -5.027875081253997680e-03, 3.678431840321451981e-03,
   4.014979461247585382e-03, 5.487886159442672586e-03,
   4.139018599156742834e-02, 6.442384717769743599e-03,
  -5.859508790025889577e-03, 3.764540139452500489e-02,
   1.613615511399220936e-01, 2.211496522612652893e-01,
  -1.717288353324992189e-01, 1.253017174631020636e-01,
   2.689459001130008116e-05,-1.329214156123739672e-05,
   3.477519905515874077e-05,-3.592611206175450332e-05,
  -1.814378410449608847e-02, 1.320311117600831904e-02,
  -8.519649855696295737e-03,-1.170774717920606244e-02,
   2.528444788707872801e-03, 4.001702647138303225e-04,
  -2.344746337206112571e-04, 1.481509792185675342e-03,
  -1.527075305989553165e-04,-2.104158228226227104e-04,
   1.133055137700546440e-04,-8.223053275635485056e-05,
  -3.151660022543274088e-06, 1.975011491364803717e-05,
  -2.935524454518902019e-04,-9.957093247296221834e-05,
  -2.375640040317634691e-03, 8.586951403425802098e-03,
  -7.787046761949614239e-03,-2.154340838138777380e-03,
  -1.738208450683789209e-05, 9.892579956570793988e-06,
   9.641357179298759870e-06, 2.654097161217781383e-06,
  -2.388687443098450104e-05, 8.677221454112506106e-05,
  -5.724511982571899331e-04,-1.008839375943131967e-03,
   2.000391070023114712e-04,-1.135092753439735603e-04,
   1.740675360069741289e-04,-9.847840035501967263e-05,
   8.863332739692370260e-05, 1.566656734112517341e-04,
   9.634546192674135412e-06, 2.678716047144291799e-06,
   3.358343795163510476e-02, 7.256319736268525104e-03,
   6.845861951392048382e-05, 1.460881269534049602e-05,
  -2.390996262507611781e-04,-3.693459222710320411e-04,
  -3.191050761718135145e-04, 1.486062333097595963e-03,
  -1.109786827958224482e-02, 7.164214121228720117e-03,
  -2.305767060911337839e-03,-3.581825641089808263e-03,
  -9.347129369219476364e-05, 4.299397165906473396e-04,
   3.366123963411353216e-05,-2.160835357111940783e-05,
  -1.344380733613528486e-02,-1.329591094559684277e-03,
  -9.953931459485940665e-06,-9.587744781000995941e-07,
  -2.542243015577191141e-05,-3.088203432183122518e-05,
   2.535467996036348793e-04,-2.597539367630913396e-03,
   1.609800627959496674e-02,-1.321759873580262944e-02,
   1.634585492644849642e-03, 1.995990331679603491e-03,
   3.489065013091799280e-05,-3.482457679097745160e-04,
  -3.097921473854295626e-05, 2.530391771925777637e-05,
   3.979801931261520820e-05,-9.591224210449943036e-04,
  -1.469031506454096288e-05, 1.357183271723170439e-05,
  -1.357183271432791451e-05,-1.469031506139786586e-05,
   6.994346522422138779e-05, 2.812768484502289280e-06,
   2.812768483900482112e-06,-6.994346520925649757e-05,
   9.351131124328050399e-04, 1.014774863901690390e-03,
  -4.412291038203474064e-05, 4.065917823220271032e-05,
  -1.619696829216868189e-04, 1.488726787392969243e-04,
   3.996345841217073454e-05, 1.709383110529330824e-06,
  -2.999633162303681660e-05, 4.691357167155096434e-07,
   1.318956551535803174e-03, 1.239443688685567136e-03,
  -7.600996993349136291e-04, 8.088616589926477972e-04,
   4.382868227782383202e-05, 4.097617120265335409e-05,
  -2.048808560650535517e-05, 2.191434114445117267e-05,
  -1.516974605603417946e-05,-4.597327905812620993e-04,
   3.797825478935963270e-04,-1.253163778197249732e-05,
   2.680675531595576137e-03,-2.859957120760736691e-03,
   1.867727321354228833e-03, 1.750645453283940006e-03,
  -7.625654944817832899e-06, 6.469110190943986394e-06,
   2.385039274830788876e-05,-3.211166088247889436e-05,
  -4.747451975295505569e-03, 1.505813676531308131e-04,
  -9.859095977379057039e-05,-3.108325113652647513e-03,
   1.594556756556511081e-04, 1.318663999343619042e-05,
  -1.236247499076892372e-05, 1.494896958899557312e-04,
  -4.946858741514937420e-05, 7.270409641098693334e-06,
  -1.064869199181953367e-05,-3.498263428504871713e-04,
   1.999074052090882433e-04,-6.085168908692284333e-06,
  -3.428650155248352197e-05, 3.639279885487238232e-05,
  -2.183567932048105240e-05,-2.057190093861025520e-05,
   2.397045734059621646e-05,-1.803932301619595247e-05,
  -3.229682775204170491e-05,-3.816955480948925754e-05,
   6.870519864879408333e-05,-5.813428994666324607e-05,
  -3.698752961201829314e-04, 3.510970936971307592e-04,
   9.997090304722820592e-06, 2.412165815548568440e-07,
   9.651347888990203345e-05, 1.014157205222422024e-04,
   2.463539068117100159e-05,-9.696435463377133098e-04,
   9.996441529486476156e-05, 2.667520113219774437e-06,
  -6.875293665917209043e-06,-7.261565740761335115e-06,
   1.476764682845156705e-04,-1.763201299170594433e-04,
  -4.979721480500247090e-05, 4.498599211321100243e-06,
  -3.146460481126297885e-04,-2.628479527043174808e-04,
   4.700901922949994702e-05, 5.278892581916977585e-04,
  -4.980854341084950268e-05, 4.371384276081966014e-06,
   1.604058668761881420e-05, 1.194569289396752019e-05,
   1.049544863995165687e-03,-3.818243314122572816e-03,
   2.622631061013205606e-03, 7.208993072965436772e-04,
   4.971750401719150830e-06, 8.676502633146922504e-06,
   7.352007390438443054e-05,-2.701643488039339076e-04,
   2.315783355245303033e-04, 6.301962645254020662e-05,
   4.150262458079600342e-03,-2.371119167025999026e-03,
   1.379018630861699986e-03, 2.413750153197115247e-03,
  -1.236542068522950705e-02,-3.381981728773570187e-03,
   2.500870645556407465e-03,-9.143845263428127673e-03,
   5.266163584810469936e-03, 9.244964775960436143e-03,
  -6.777317270238798937e-03, 3.860529734417589374e-03,
   6.584067712473995200e-05,-2.376983878270411997e-05,
  -7.217006503975351237e-04, 4.098788354512808776e-04,
  -2.567920198888562315e-04,-4.521506155999409902e-04,
   1.253065529142558801e-04, 3.461600262778864756e-05,
  -2.130215555879142088e-05, 7.711172521614596646e-05,
  -9.854719518232530590e-06,-1.740357731091418125e-05,
  -3.619725334014103988e-05,-1.702230450408076786e-05,
   2.985698292812181655e-05,-7.421967778446524652e-05,
  -1.484393555371707149e-04,-5.971396584346767253e-05,
   2.413224659525148037e-04, 9.672094003962881622e-05,
  -7.068514525259644128e-05, 1.763621564428481539e-04,
  -2.748913281306937737e-05,-6.437660671134448902e-05,
   3.862481572396159733e-04,-1.649298935678759621e-04,
  -3.680666481996290183e-05, 1.566107993820686295e-05,
   1.449667652524516161e-03, 4.890437495964561820e-04,
   1.337093797336422053e-05, 2.685550255929772812e-05,
   8.151706895503468787e-04,-2.426630799481055943e-03,
  -3.134992472208353222e-03, 1.555870775076782916e-03,
  -1.374515167458605070e-04,-2.778476875694599292e-04,
  -1.604300014417675297e-05, 4.735633163974955573e-05,
  -4.595456836376074668e-04,-9.849764151681612530e-05,
  -2.934972857797358325e-05,-6.212361257950222290e-06,
  -2.941905828154320920e-04,-4.528026699406047066e-04,
  -2.853976471393806081e-04, 1.339885601746412325e-03,
   9.734893508669097617e-04,-6.307194138738485669e-04,
   5.969412270837501762e-05, 9.239378612264715674e-05,
   4.216513586647672878e-06,-1.955047347696765232e-05,
   6.137002859610222186e-06,-3.952641137139996445e-05,
   4.030452424797174041e-05,-2.958961515708945962e-05,
  -1.186026516375563068e-04,-1.825954612087775044e-05,
   5.907622950048454282e-05, 8.068456548811601145e-05,
  -8.075995086775703048e-06, 5.897313232174015285e-06,
  -2.929108402433911671e-05, 6.483239609871177657e-06,
   3.883193434996102324e-05, 4.573927059584922538e-05,
  -3.049284705737528007e-05, 2.588795622776848745e-05,
  -1.467809990906918110e-05, 1.358504262265611615e-05,
   2.398111060183227134e-04, 9.427901238004888671e-06,
   4.321186972406330160e-06,-1.099150914932601325e-04,
  -2.251936236057678134e-03,-2.439370154490066740e-03,
  -1.278467468606818641e-03, 1.180233845969336616e-03,
  -1.907057408211633746e-03, 4.697985676981851488e-02,
   2.671716600067923150e-02, 1.084532241076311288e-03,
  -4.544008286241282564e-05,-5.324658551923358026e-05,
   3.042662029019487253e-05,-2.596576163010896613e-05,
  -2.932900784460181265e-05,-6.309461058702662414e-06,
   4.924198693390188786e-01,-4.534202809971794590e-01,
  -2.861275603605100692e-01,-3.107379660591121362e-01,
  -5.065423444802620540e-05,-3.215817981671198911e-05,
   1.607908991242030597e-05,-2.532711723041493367e-05,
  -1.907817391755389758e-05, 2.392351191934262834e-04,
  -1.495252995748532214e-04,-1.192412585568967644e-05,
   2.609764594295943402e-05,-1.479570465493053240e-05,
   1.246640254864176886e-04, 1.932734042075350011e-04,
  -1.585753631228073955e-05,-1.218763890606781038e-05,
  -9.670576362406636761e+00,-4.049306508821818307e-01,
  -2.929630782774068631e-01, 6.996560555925151803e+00,
   2.390902950793310559e-05, 1.073701927709327990e-04,
  -6.832648628794419396e-05, 1.521483695495525031e-05,
   2.208243994233692695e-04,-1.879623477090593673e-04,
   1.231526803556853801e-04, 1.446838529545114342e-04,
  -1.638146308036153164e-04,-4.538705604463185074e-05,
   3.257892129635432785e-04,-1.505052787952731704e-03,
   2.465984869481605045e-04, 1.893893334415477307e-03,
  -3.930571891791456978e-05, 7.420273603169418433e-06,
   1.298547880276814156e-05, 6.878500809163345551e-05,
   9.965329790013099398e+01, 1.085024506952970285e+02,
   9.546551619959531365e+01,-8.767961888477792343e+01,
   3.759332305979724734e-05,-5.904864143603129860e-05,
   3.374208083361773634e-05, 2.148189889960717738e-05,
  -1.694383834040751708e-04,-1.372992796066527940e-05,
   8.884397409586989000e-06,-1.096406287718688818e-04,
  -8.972182868661317953e-06, 4.415873024816312670e-06,
   3.099861740370862253e-04, 5.484055374168923108e-04,
  -5.710340269767251453e-03, 3.672929724697631890e-03,
  -5.560342939145308631e-03, 7.215560982937200586e-03,
  -1.073308210972790267e-04,-7.334219880816550397e-05,
  -1.692563193522257962e-05, 2.476939610100034359e-05,
  -8.065325582679896854e+01, 7.388572594685363981e+01,
  -7.076152158361877298e+01,-7.724289136825075275e+01,
   8.204019425501191708e-07,-9.966290215153279460e-06,
   9.582622616464757067e-05,-5.400438947678677285e-05,
  -1.472899347082974009e-05,-2.613535442558857509e-05,
   3.795199370673849656e-03, 5.917030431232377270e-03,
   5.285673899352643854e-03, 4.083933693480723028e-03,
  -3.504230101079009417e-04, 5.114144383449126339e-04,
   8.558432367106486729e-06, 5.172352986568499870e-06,
   7.622629810963566399e+00, 3.386853938779065820e-01,
  -2.552676153761649358e-01, 5.745185856586963347e+00,
   2.889030104819922698e-05, 8.083965941567213104e-06,
  -1.347327656639598805e-05, 4.815050173669656726e-05,
  -3.018068350337740099e-04, 1.377238088327795412e-03,
  -1.708779581691182098e-04,-1.339060320420603885e-03,
   1.474631984287920006e-04,-2.744871531232801514e-05,
  -3.682527878423063061e-01,-4.030149337024817591e-01,
   2.621287361933706261e-01,-2.395187617242252875e-01,
   2.527271277977145576e-05,-1.616446685638522893e-05,
  -1.224773950766890149e-04, 1.580998828118748505e-04,
  -2.472608105812011266e-05,-1.698884679745137381e-05,
  -1.802289207796621811e-03, 3.942761149616842709e-02,
  -2.301525106911147742e-02,-1.052058114669724917e-03,
   1.984233546959359939e-05,-2.506336591942080953e-06,
   2.121122423119994362e-03,-1.933199371871295504e-03,
   1.030590950987107703e-03, 1.130772959587351576e-03,
  -2.097640201162936739e-04,-9.857078630321160819e-06,
   4.693947757213122368e-06,-9.988977350146215962e-05,
   1.345327503139724507e-05, 1.479896587365426548e-05,
   6.169036279994416733e-05,-2.215577345721467554e-04,
   9.771441324881829623e-05, 2.128230122690370489e-05,
   1.175304926513428931e-02,-7.407955826794461462e-02,
   1.833762091530634908e-01, 2.909344589278047705e-02,
  -3.540916931363363539e-05,-4.843749300406066834e-05,
  -9.866461285584513592e-05, 6.323162659337748471e-04,
   5.033866681456711928e-03,-3.670042342029266984e-03,
  -5.101963942150592596e-02,-8.027703085619239745e-03,
   2.953227825705555132e-05,-1.876908216336114490e-04,
   1.773405160071862552e-01, 2.438957735103695068e-01,
  -6.219307137157654465e-03, 4.522157645605211392e-03,
   6.704309009468190084e-02,-4.861732717633442113e-02,
  -1.456465297742531029e-01,-2.008459531766723094e-01,
   2.643256724267795815e-02, 4.228259637205973587e-03,
   5.156992283882323030e-03,-3.223845198961479419e-02,
  -9.727443420124674963e-04,-1.345021633694552191e-03,
   6.482015867127526509e-04,-4.687912894206466602e-04,
  -2.229050098873744558e-05, 1.382149645273350917e-04,
  -5.923461781289619490e-05,-9.553012667197228395e-06,
   8.110437321236802096e-06,-5.849855251054440586e-06,
   4.815319669841153782e+00, 4.842820971234069183e-01,
  -1.973815033185008703e-05, 3.225743554172635168e-06,
   1.623046555729050199e-05, 1.168640183262610421e-05,
  -1.596038242396029310e-05, 1.205264256837227422e-05,
  -3.962691446327285607e-05,-5.450472467635886186e-06,
   4.829206830170421533e-05, 6.377990388157962363e-05,
   8.251618295663955131e-06,-5.942988133508819194e-05,
  -3.850131436939730427e-06, 3.981427492644175564e-05,
   4.092999762806311657e-04,-3.366810436802561055e-04,
  -6.428949732151600406e-03,-6.299829038538664943e-04,
   4.743602048517057274e-02, 5.781787981418311240e-02,
   7.836319461886982751e-02,-7.893056012565229373e-01,
  -5.209528559098492551e+00, 4.262977830979231442e+00,
  -3.209528291747423268e+00,-3.932408044831752658e+00,
  -3.170901971195022595e-02, 3.112957705880100567e-01,
   1.875920017114369315e-02,-1.527088968556745974e-02,
  -1.899847057004085561e-03,-1.959730114757172429e-04,
   9.454921994390386142e-05, 1.164504409963921253e-04,
   1.038779074962622681e-06,-9.945900564223424280e-06,
  -6.459435797241133592e+00, 9.033287079505146477e-02,
   9.620952174646886076e-06,-2.727137556698850862e-06,
  -8.728303283133866870e-06,-4.880237883303903325e-06,
   2.999242732435935605e-05, 6.740201725633527574e-07,
  -2.762319035715052340e-05,-2.893024981732143056e-05,
  -4.748836375418069401e-07, 1.999436134340867435e-05,
  -1.781433556160000785e-07,-9.998413121333298478e-06,
  -9.728062718614537553e-05, 1.006812913499404507e-04,
   1.859673469035728714e-03,-3.075825904580437161e-05,
  -1.698613369075141835e-02,-1.645440103006432647e-02,
   4.597583802008945071e-03, 3.012419843281892162e-01,
   3.924013018318604828e+00,-4.040480681103780114e+00,
   3.805421809185453252e+00, 3.705185790524803124e+00,
  -8.116881992732477222e-03,-6.387611057731030773e-01,
  -4.313895259233825608e-02, 4.419292048700781267e-02,
   5.479423802551417443e-03,-6.262902700725169987e-05,
  -3.287463145259093725e-04,-3.217269369523135213e-04,
   4.060800167316339717e-07, 3.999793868463738094e-05,
  -2.936477143227250036e-02,-4.123533212788147995e-01,
   1.576221745408699360e-01,-1.122469224619338651e-02,
   5.150631029559744867e-06, 6.981024996372191900e-05,
   6.928249105211515104e-04,-8.021661707655044831e-04,
  -1.135202983555947846e-04,-9.804663100600996529e-05,
  -2.422516224101683643e-02, 1.756237658430021562e-03,
  -3.629606663380965676e-03,-5.006600893075160985e-02,
  -6.084449038975436874e-02,-5.268675852929420589e-02,
   2.190536435643034574e-01,-2.529707213488634476e-01,
  -1.726562420748151416e-01, 1.988755551486049433e-01,
  -5.149712019128184146e-03,-4.470785382978818487e-03,
   4.327209240316760852e-02,-3.025978567735231571e-03,
   2.092762415688379516e-05, 2.992691673203839043e-04,
  -3.967376168998804423e-03,-3.453222090594528990e-03,
   3.766495908676870043e-05, 5.486856649674357522e-04,
   3.287509806907780105e-05,-3.767264162424128766e-05,
  -1.147432751166045650e-02, 1.479138873751166539e-03,
  -1.529180930260163219e-04,-8.157320611987279452e-04,
  -1.941520092357934524e-05, 4.801038751878996508e-06,
   6.415521841001790015e-01,-7.419801253588258483e+00,
   1.061709510381010579e+00, 9.180057955534393077e-02,
  -2.794122746352163298e-05,-2.862320397145415782e-05,
   2.146740298902651066e-05,-2.095592060782854420e-05,
  -1.014009783700204755e-07, 9.999485878863253156e-06,
  -7.146873642888959405e-06, 6.994440444565892619e-06,
   7.998854217463643838e-05, 9.133053042359681083e-07,
  -7.992045180429242290e-07, 6.999543745245712144e-05,
  -1.269429835908911287e-07, 9.999194241483514025e-06,
  -5.813652751581689019e-05,-6.869512575588841491e-05,
  -3.816660662358172337e-05, 3.230031172869670823e-05,
  -9.947533542401280297e-05, 1.185755113481862504e-03,
   6.576442364330542132e-04, 5.517107222649776996e-05,
   1.156852496439766433e-02,-9.765086157088580937e-03,
  -6.049966272316435398e-03,-7.167288104698458194e-03,
  -1.223956425452518522e-06, 9.924813885841563346e-06,
  -1.923995183373719831e-01,-1.638826073049132886e-02,
  -1.155690197550416319e-02, 1.356789722915617280e-01,
   1.653894439893666579e+00, 1.964424124979051056e+00,
   1.619558177889965478e+00,-1.363543764015368254e+00,
  -8.896205062207755976e-01, 7.470527224833516389e-01,
  -7.495283672755505000e-01,-8.925686038676695633e-01,
   6.487603908896834304e-02, 5.692985937140348195e-03,
  -4.433413580207628234e-03, 5.052222434815796526e-02,
  -2.189400928369393279e-03,-2.613998870971504310e-03,
   1.747778547034592282e-03,-1.463882795037121324e-03,
  -1.330217704828747965e-05, 1.493973429183907925e-04,
  -8.964535055663893346e-05,-7.981924586915893134e-06,
  -1.353693278501568104e-04,-3.566018284752934105e-05,
   7.605091712928519890e-06,-2.902003756093272035e-05,
  -8.635308107124905694e-05, 5.041722568139747461e-05,
   3.521702600253658879e-05, 6.049595920007105171e-05,
  -2.559731556092852961e-06, 9.666838902182163976e-06,
  -7.068399055634838049e-04, 3.478585755230168951e-03,
   5.467746120818041226e-03, 1.111032305549243104e-03,
  -3.932485816100610832e-06, 1.960957815217266660e-05,
   1.165664024842378275e-04,-7.751630393152875620e-05,
  -9.801416033703889367e-04,-1.978591465935825868e-04,
   2.613907060492202342e-03, 3.941613899669296588e-03,
  -2.583325592793135140e-04, 1.713149278045402477e-04,
   3.336087066692210732e-04,-2.206218570193017989e-04,
  -1.307193830626451631e-03,-1.976645691832439825e-03,
   3.918507840020659153e-04, 8.014436192945503107e-05,
   3.606582457024557381e-05,-1.763370659307436823e-04,
  -1.101085441828560208e-05,-1.669613982270514216e-05,
   1.782380906313054889e-02, 2.572858088825622554e-03,
   7.542841536634350515e-06,-6.565481060304991556e-06,
  -1.369454858183706323e-06, 1.995305975010842902e-05,
   7.989603539778908570e-06,-6.013836984584163295e-06,
  -1.584050316742876489e-04,-2.245278413882617163e-05,
   1.014533434791814286e-03, 1.351433809874555197e-03,
   2.224428997653253061e-03,-1.555045046096504950e-02,
  -9.072856958423465568e-02, 6.792974001248811011e-02,
  -3.701490653714419043e-02,-4.956981876244644786e-02,
  -4.093040983855528343e-04, 2.810121059507284576e-03,
   1.283135404388232670e-04,-9.555961170989040767e-05,
  -5.726097545208854583e-02,-1.669140591305413217e-03,
   3.998586336978173167e-05, 1.063358158452675903e-06,
  -3.368952071373308124e-04,-3.557578161448508684e-04,
  -1.493212035060461371e-04, 5.357490304854414624e-03,
   6.913659809022811020e-02,-6.530362882578649719e-02,
   3.773997349647788963e-02, 4.005747005801244681e-02,
   1.605727495842389381e-04,-5.277133792404092687e-03,
  -2.696105869192498431e-04, 2.533632444189572890e-04,
   1.998995458999683279e-05, 6.338102948553595360e-07,
  -1.451188661260191201e-04,-5.187495237278451528e-03,
   3.418348022001188070e-03,-9.562742061180071695e-05,
   2.056990770619159545e-05,-2.183755702817418080e-05,
  -5.996897611315076849e-04, 1.754271054339673287e-05,
  -2.894551661765098349e-05,-9.894896175438011154e-04,
   9.450641183822090818e-05, 8.924847700314402518e-05,
   3.089386784926771105e-03,-3.271393189304073329e-03,
  -1.856139299340037055e-03, 1.960468826280266797e-03,
  -7.987812334312130338e-05,-7.562727950946892782e-05,
   3.498434245990233852e-04,-9.339632934624848314e-06,
  -2.175858226300242512e-05,-2.065342823611025219e-05,
  -1.594049711907295970e-04, 1.359440916127677173e-05,
   3.449850442245387781e-06, 3.985095396507013930e-05,
  -5.795376167124180358e-05, 6.884938374718805633e-05,
   5.349561913869466746e-05, 4.514663589867714383e-05,
  -8.370113270744075016e-07,-9.964909033119628295e-06,
  -1.417066649762413075e-06,-9.899086933153539698e-06,
   1.307549198206952104e-02,-1.005016691910255583e-01,
   2.108988083268878086e-02, 2.743840673993983882e-03,
  -3.794444674648886209e-06, 2.975906903132268167e-05,
   2.769108229507073662e-04,-2.139985672882722587e-04,
  -1.283969769062616093e-04,-1.661436942781082283e-04,
  -4.125463970879537576e-03,-5.313748166944555918e-04,
  -3.665980836002676480e-04, 2.846177760351073852e-03,
   3.138720172499260413e-02, 4.072193827380339581e-02,
   3.083843978742472833e-02,-2.376930891608892635e-02,
  -1.423736199139947686e-02, 1.094475728443805584e-02,
  -1.165166018079934022e-02,-1.515692851687872218e-02,
   9.418005510909156471e-04, 1.237537750899263701e-04,
  -1.016083891594429995e-04, 7.732680222182022368e-04,
  -3.042253436561583418e-05,-3.967958420614968771e-05,
   2.380775051859596180e-05,-1.825352061546405181e-05,
  -3.858611330589482429e-05, 1.552582302231991708e-04,
   1.649630057480545246e-04, 4.099802774979907741e-05,
  -1.941569620460749000e-05,-4.799035412495973628e-06,
   4.129519122536559004e-05, 6.851064292635945558e-05,
  -1.545407750181961999e-05,-2.571325510670770993e-05,
  -6.484756718969937996e-04,-1.223522520340942208e-04,
   2.261307553334567969e-05, 3.299467858493552633e-05,
   6.076284525223393335e-05,-3.243204034700018323e-04,
  -1.783056444085358207e-03, 1.218683023512031867e-03,
  -6.138374100580587956e-04,-9.005730151878830678e-04,
  -7.466413436323192439e-06, 3.929698042341030174e-05,
  -3.091535091033369609e-04,-2.238045747403875256e-05,
  -6.556531357469598414e-06,-7.550622263000439763e-06,
  -7.801396636913538206e-06, 1.097104873915156337e-04,
   1.436037767360381434e-03,-1.243760145384121846e-03,
   5.425242966074426661e-04, 6.280141874908427109e-04,
   5.877744399386951204e-06,-7.977752273227161771e-05,
   1.060905653298610185e-06,-6.998571547126895636e-05,
   6.999195865441572566e-05, 1.061000293015453681e-06,
  -1.999807333602306286e-05,-2.776019579244455145e-07,
   2.776019578650518289e-07,-1.999807333174433353e-05,
   2.090298099216391961e-05, 2.151895410193613528e-05,
   5.021089289377466688e-05,-4.877362230461367839e-05,
  -2.872751132485511515e-05, 2.783397372062281505e-05,
   2.196753552618152050e-04,-1.260818484182790787e-03,
   3.349047166038335278e-04, 5.835123256976190140e-05,
  -8.867162733166996074e-05,-1.533280316040474156e-05,
  -1.022328729010366018e-05, 5.912262168953195425e-05,
   6.217306774724971809e-04, 8.828952790627864113e-04,
   5.967737812848446406e-04,-4.202452727235214723e-04,
  -3.396060037601088293e-05, 2.112292943356694643e-05,
   3.133684014111898632e-05,-2.485965506538563983e-05,
  -3.895021267963082201e-05,-9.103896540027595416e-06,
   9.933497486748395368e-06, 1.151359058140995442e-06,
   1.079955803601553515e-05, 1.683358387945752880e-05,
   1.601882432911688556e+04,-1.599837839916475241e+04,
   1.477287543158823792e+04, 1.479175516856718423e+04,
  -2.618317321051538108e-04, 1.838808791340381993e-04,
  -2.126131635750334338e-04,-3.027442176118165604e-04,
  -1.054141463606597511e-05,-1.699642837394180569e-05,
   6.204902973629235544e-06, 7.842141231057184056e-06,
  -1.446093425555382132e-04, 6.845170109095975448e-05,
  -1.129771595194527245e-03,-2.071896891624199974e-03,
  -6.809522246512179910e-02, 4.234435365613546665e-02,
  -2.006582925771825221e-04,-3.226846059211231741e-04,
  -1.611115341588541305e+00,-2.288383069140308645e+00,
  -3.097374851574035048e+01, 2.456640601136463431e+01,
   4.950190903979075330e+01, 6.241286091820812487e+01,
   6.649133238566938644e+02, 7.465102257433206887e+02,
  -7.534724631382588313e+02,-6.728422946633123729e+02,
   2.807047432649767416e+01,-3.529904520088160069e+01,
  -8.081871986550318021e-02,-6.426858823445898150e-02,
  -8.327770800271442342e-01,-5.879013941444033442e-01,
   4.810891448825030392e-02,-7.714549382191915328e-02,
  -1.368604453730800589e-03,-7.485469646145054582e-04,
   8.150628039061143357e-05,-1.716209612274092328e-04,
  -7.690250849038958449e+02,-9.821869551086760408e-01,
   7.278989645708470180e-01,-5.699246565218222713e+02,
   1.969877160476644632e-05, 3.458091563745425386e-06,
  -1.244732540466129554e-04, 4.220079734043004826e-04,
  -6.621173255925852721e-04,-1.548298121975106266e-04,
   1.905770656207325013e-03,-8.149875997208681083e-03,
   2.238685145703450327e-02,-1.284101403577447009e-01,
  -1.363425618123432548e+00,-1.581727576776636168e-01,
  -5.094892959881541783e-01, 4.391721864807673903e+00,
   1.853269494434802267e+00,-3.170555024279560286e+01,
   3.454855004585656975e+00, 6.181547491124588589e+01,
  -3.972143879181357029e+00, 4.505336672873903048e-01,
   1.149468661059716576e-04, 1.013432566278479278e-03,
   1.994681934943804552e-02, 1.161672168993381771e-01,
  -1.263640285750623239e-02, 2.920879331290848844e-03,
   7.291506559451625766e-05, 2.495550920111477161e-04,
  -3.769179237468131284e-05, 1.339136989198326672e-05,
   2.549441135506645395e+01, 2.559228212483199272e+01,
  -1.644366464379020698e+01, 1.638078029027280991e+01,
  -2.635708021079290460e-05, 1.432844453392722873e-05,
   4.742847378777850109e-05, 7.648882189027367024e-05,
   2.804505174498970717e-04,-1.738991356766178456e-04,
  -1.194854032149563578e-03, 8.389457217747923979e-04,
   3.526359449042163613e-02, 4.457776983301890011e-02,
   8.705521394974072465e-04,-6.886570984820069088e-04,
  -1.182163348105789158e+00, 1.050243035209900588e+00,
   2.657453403908566880e+00,-2.968270389193611081e+00,
   2.569744219015129283e-01, 2.048872596978040250e-01,
  -1.620897967168740328e-04, 2.032968368501190948e-04,
   6.823253722106859161e-03,-9.639156778896805847e-03,
   1.297170581581542741e-03, 8.112349787318599674e-04,
   1.923910349641800243e-05,-3.506931560002443231e-05,
   4.939330613410672539e-03,-1.933676133919940865e+00,
   1.116933441392233606e+00, 2.853064917870750967e-03,
  -1.946880442622567797e-05,-4.578826710218432655e-06,
   5.909524405351638523e-05, 1.038037235629513746e-05,
   4.124296004394267128e-04,-3.515848522573746665e-03,
   2.681629883936115428e-04, 3.145708737043577689e-05,
   9.140682973607155981e-02, 5.460111089166884944e-03,
  -2.628577317034292427e-01, 1.435432560489305516e-02,
  -2.899416485187061680e-03,-2.585766334688383711e-02,
   3.975088449801665553e-05,-4.457261596616997119e-06,
  -1.074492830824600332e-03, 1.830863426075410804e-04,
  -3.583376980649595370e-05,-1.559325723976987487e-04,
  -7.873969643749352543e-02, 7.823846978618660686e-02,
  -4.150162522310356372e-02,-4.176750108559447450e-02,
  -1.805643641628589674e-04, 1.424623090892758947e-04,
  -1.238814406887990058e-05,-1.570139759249188969e-05,
  -3.753750174836980539e-03,-4.236140332569161664e-03,
   1.315718368214234546e-02, 1.180976132611000033e-02,
  -1.255047717226523201e-03, 1.569992517765374067e-03,
   8.154648872240794258e-05, 5.788065460105124932e-05,
  -1.062635873785156473e-05, 1.694345006114415195e-05,
   6.650014502411009595e-03, 2.547999812483699091e-05,
  -1.260589341932349441e-05, 3.290007073141560691e-03,
   1.986080523509499570e-05, 2.355507464140856192e-06,
  -2.192519972268557851e-05, 3.593351966401037373e-04,
  -6.390256071419519361e-05,-1.198296861312403948e-03,
   1.490887672057555154e-04,-1.652452405010174785e-05,
  -2.886179845981845233e-04,-2.912099157740997372e-04,
   1.349507412223085751e-04,-1.337496041234668650e-04,
   1.498563975393589584e-05,-1.324502175027493731e-05,
  -5.351444641845537345e-05, 5.946715730843886997e-05,
  -7.803002941996311552e-06,-6.254050294584857062e-06,
  -1.532613957028436026e-07, 2.999960851318875680e-05,
   1.843114186813109336e+04,-1.053728160765063194e+03,
   4.690940772636965761e+01, 4.089138110714085315e+02,
   3.127787967630674792e+00,-3.588107740132019940e-01,
   6.204291960842312825e+00,-1.073484879315663498e+00,
   9.518437966935751338e-02, 4.094060501289167875e-01,
  -2.922065535847374518e-05, 6.793622011576522776e-06,
   5.680043814153677706e-03,-1.667473252175196135e-03,
   1.982220889555779168e-04, 5.556717459447312090e-04,
   2.118409696938817284e-04,-1.674019222086648665e-04,
   4.988085093888304122e+00, 6.312077257332115110e+00,
   1.550017798228380201e-04, 1.961490460128533127e-04,
  -2.120424347976424678e-03,-2.683318949455832606e-03,
  -1.559029966731897588e-05,-1.252767162257990851e-05,
   1.798651431868354949e-03,-5.470402422472377254e-04,
   9.782390376210302568e-06,-2.074810479881974776e-06,
  -1.197178599256448712e-04,-1.206964540275466360e-04,
   5.725950491067020105e-05, 1.792621257781284308e-05,
  -8.919127816407003417e-02, 2.849053307670102453e-01,
   1.493851048151070708e-05,-4.771625409222516755e-05,
   3.585242515562569294e-05,-1.145190098213404021e-04,
   2.800777605216003894e-05,-1.269470932341975461e-04,
   1.515719459225473194e-03,-5.691633730391059028e-03,
  -1.018698283597042588e-05, 6.925478597685247480e-05,
  -4.768311065933742744e-03, 1.320548407210026670e-02,
   5.645968289662186938e-05, 2.030527535427442213e-05,
  -8.962951375756127568e-06,-4.434580322401586207e-06,
   8.463850380703552738e-06, 1.812079569812165899e-05,
  -2.606671600315197841e-05,-1.485012851159950801e-05,
   1.689489134904547567e-04,-3.403766511240083163e-04,
   2.532356815374456238e-05,-1.070453964258279308e-04,
  -1.937269092528560261e-04, 4.717731283480818753e-04,
  -8.387681121946317689e-06, 1.815617816052005567e-05,
  -6.196233731780927839e-05, 3.256790988249043926e-05,
   1.050180875254797842e-03, 3.272921160814402193e-04,
  -2.899948723236019248e-05,-7.683081430010887708e-06,
  -4.559479678449989117e-06, 8.900064329082211552e-06,
  -1.280413806725086141e-04,-5.661629478761160626e-05,
   1.964797143051566570e-05, 3.735936116375684762e-06,
  -7.644132727034516454e-03,-1.458863032815211833e-02,
   2.057707843005966123e-04, 3.546242861512974797e-04,
  -4.000367635313658283e-06,-9.164990931928684967e-06,
  -3.659351329081506976e-04,-7.782618315859349137e-04,
   2.556806458893766623e-05, 7.580418242535113258e-05,
  -1.577606112044474399e-05,-2.551697269512964302e-05,
  -1.158287749017706458e-05,-2.767375921423667935e-05,
   7.615430899451518547e-05,-2.450553450892074649e-05,
   3.745605318083350182e-04, 9.702084353433838111e-04,
  -2.697835526197451053e-04,-3.970098673029037370e-04,
  -1.825032543607301756e-05,-2.381019994618747965e-05,
   2.909709702521131236e-04, 5.587807212767311989e-04,
   1.505983886770603655e-05,-4.767810035308381393e-05,
   5.071059687067379370e-06,-8.618837140252744478e-06,
  -3.290866202671629084e-04,-1.691212475153140943e-04,
   2.279318773789284179e-03,-5.137032794079838920e-03,
  -2.194731532570297924e-05, 5.584187810231818979e-05,
   9.656112992697421816e-06,-1.751455057580011236e-05,
   9.324326128857114061e-06,-3.613439115678097422e-06,
   5.133661646106565035e-04,-2.681297294414206143e-03,
   1.288679953001059346e-04, 1.711840492954497069e-05,
   2.084721362689553621e-03,-3.851452192950225568e-04,
   1.136328362803440528e-07, 9.999354358083270282e-06,
   1.646224521924445020e-03, 1.907968768983033621e-03,
  -5.659771362445659956e-05, 1.991729932706742093e-05,
   1.468352417408830819e-05, 1.357917957127618023e-05,
  -3.508605635180099633e-04, 8.060313249387092351e-05,
  -7.153172105250359329e-07, 9.974383253531352958e-06,
   2.991470662531673004e-05, 2.260603353361960677e-06,
  -8.574173914628869478e-06, 5.146216249021979584e-06,
  -1.206374614801625699e-03,-1.669808458704838926e-03,
   2.033607467450215898e-04,-5.238708508122198005e-05,
  -6.729592098287310019e-06,-7.396795940856352159e-06,
   1.571886100560631960e-06,-9.875686005886593732e-06,
  -1.973917984760718296e-05,-3.219437675094608516e-06,
  -1.348364572473616757e-05,-1.477129980637466201e-05,
  -1.100254775244017222e-05,-1.670161498045245199e-05,
   3.110089939120946092e-05, 3.915014759943910290e-05,
   1.041650706648182518e-04,-9.040186049265764179e-04,
  -3.333406383271508044e-06, 9.428064588448935369e-06,
   2.878108214557167054e-05, 8.464591574899268153e-06,
  -1.367724751717821173e-02, 1.083676152519019199e-02,
  -8.766031044068066689e-06,-2.869070755025806307e-05,
  -3.658557671162999084e-06,-1.966252668826604504e-05,
   1.805294876693116498e-05,-8.607615280584894802e-06,
   1.058810195347154097e-04,-9.159262908274448754e-05,
  -1.133775817644374820e-04, 8.213113875533621753e-05,
   9.040652121959274942e-06,-4.273945391522133001e-06,
  -1.530569445082804721e-04,-2.810223687498722379e-04,
  -2.336122084648010707e-04, 2.330779613266735300e-04,
   1.157477677255126062e-05,-9.932786387849890694e-05,
   4.527966909270533802e-01, 5.275885030504823270e-02,
  -1.887229413691479435e-04,-2.199207586784740704e-05,
  -1.175482442371524820e-04, 2.206409079857195180e-04,
   1.135423778178292802e-05,-1.646454628572354968e-05,
  -3.665485653393802388e-06, 9.303989194144855090e-06,
   1.999988220129804279e-05, 6.864352993374073339e-08,
  -1.642421294148961076e-04, 2.390073700228939006e-04,
   1.969758841144616919e-05,-2.262752772119087873e-05,
  -9.423797775603839162e-06,-3.345449967422042923e-06,
  -2.998672962116073060e-05,-8.922144514643047292e-07,
  -2.263975882028105603e-03,-1.652670735357187758e-04,
   1.060588858900318608e-05,-1.695627102984768899e-05,
   2.417739525280729026e-06,-9.703326006473003969e-06,
   1.768592550835413073e-04, 3.347840933041583569e-05,
   2.537533425766115309e-03, 4.072150698582772000e-04,
  -1.523414208062418084e-05, 2.584416597739914773e-05,
  -3.244630264215223358e-06, 9.458983795764672721e-06,
  -2.214617325884637685e-04,-6.208623840204659998e-05,
  -9.989921653593424020e-06,-4.488489223171186596e-07,
   3.918471910296108623e-05, 8.034786171519233365e-06,
  -7.530154524574706051e-05,-2.701253937716164284e-05,
  -7.396216807645496433e-04, 2.503010141678019967e-03,
  -3.872083867914603156e-02,-9.074665392373917200e-03,
   9.736149367588262563e-06, 2.281971842948703639e-06,
  -4.369993083578146108e-03,-7.774926312539204691e-06,
  -9.401199101264187780e-06,-1.697398522900806287e-04,
   1.449752283627409434e-03, 1.726798080758457305e-04,
  -5.562080189802813611e-05,-7.075539835390873386e-05,
   2.782393849730234068e-05,-1.121732795715346864e-05,
   1.449212803113981746e-04, 3.075675901536200013e-04,
   1.311180017515332918e-02,-7.119487071892826625e-03,
   5.726094041403008612e-05, 1.054570277549149199e-04,
   1.717743768248202740e-01, 2.773320245958707519e-01,
  -7.371660221258361661e-05,-1.190204291633655123e-04,
  -8.852919772254876150e-05, 1.620435591444064282e-05,
  -1.296953589041309539e-04, 8.894598289335867595e-06,
  -1.125473275062299147e-05,-1.653272484232572845e-05,
   1.987558853327494238e-05,-2.227325853113920338e-06,
  -3.303696132450343372e-05, 2.255125687058849479e-05,
   1.468251229680389203e-05, 2.616149522971121175e-05,
  -9.905054132730605189e-06, 1.374737294058890301e-06,
   3.485679779362933583e-05,-1.962150981892161412e-05,
  -1.586204846991876084e-05,-2.546360968790458006e-05,
  -7.488798429345811685e-05, 3.213904009276922612e-04,
   3.202471926027803621e-03,-1.989239443356120764e-03,
   6.811240640070169374e-05, 1.614620990528890465e-05,
   5.782485028571293206e+00,-4.055786105793653284e+00,
   5.742132618885487391e-06, 8.187057651386810876e-06,
  -1.612965454026042342e-02,-2.299744212759011197e-02,
  -2.456117295416043039e-03, 1.722639785665646241e-03,
   6.698523503515510742e-06,-7.424943290884470073e-06,
  -4.944113943785568308e-07,-9.987770390487993321e-06,
   1.769257329956467684e-04, 7.288328237695892216e-04,
   7.288329472868747055e-04,-1.769252241743040428e-04,
   1.513107937587702649e-06, 9.884862384940374210e-06,
  -2.996065157895783633e-05, 2.650206325862746023e-05,
   5.300423109957739110e-05, 5.992121064817193787e-05,
  -6.146759549521404326e-02,-2.317133582762854679e-02,
  -3.370061691017109395e-02, 8.939888153592241704e-02,
   2.807148321042003724e-05, 1.058261925834554655e-05,
   1.411015901112739766e-05,-3.742864428056004965e-05,
   5.035317624118850225e-04, 1.653957806063413236e-04,
   2.995867203630528061e-04,-9.120569044649078734e-04,
   6.217030655554604846e-06,-1.900916962489141405e-05,
  -1.070603776558677953e-04, 5.420401771255489769e-05,
   6.323780266634063823e-05, 1.249038843028228555e-04,
  -4.432688814419437004e-03,-1.893058338911087109e-03,
  -2.580374160250619494e-03, 6.042066632627524601e-03,
  -3.132580840584876840e-05, 7.361177709932055849e-05,
   6.441027625809908066e-05, 2.741014980541619692e-05,
   6.679907459654156653e-04,-2.686789223302928748e-04,
  -2.574837437759556211e-04,-6.401578880956775410e-04,
   9.287116682623897937e-06,-3.708026931311166317e-06,
  -2.164458420623817424e-04,-1.036879812413497550e-04,
  -1.382507423935939734e-04, 2.885944078245802403e-04,
   3.771960665036705565e-05,-1.331282367274448197e-05,
  -9.984533817270057008e-06,-2.828973461260799108e-05,
  -8.823931924709382146e-06,-4.705127563424246821e-06,
  -3.725824843675298273e-05,-8.192571588594874609e-05,
  -6.372002653323455973e-05, 2.897858206682794993e-05,
  -3.409929878170356657e-04, 9.080879815632465031e-04,
   7.489382469902904071e-04, 2.812321144448315618e-04,
   8.315735172573980594e-03,-3.769011613091151694e-03,
  -3.818542201011666370e-03,-8.425036228948393560e-03,
   4.103382914316359856e-04,-1.847227289343836493e-04,
   1.929329272002636316e-04, 4.285754141361095156e-04,
  -4.674104896783941185e-05,-1.775596636024180574e-05,
   1.420474698306359989e-05,-3.739284909106480308e-05,
   9.394396297690266434e-05, 7.440930935173329080e-04,
   6.250381572357610474e-04,-7.891325616982303333e-05,
   1.852443608960941478e-05,-7.539580065360163270e-06,
   9.222408968335092503e-06, 3.866157371444220484e-06,
   2.298568894797396489e-05,-1.927843623292583081e-05,
   2.236773464578511571e-03,-1.717336445824591950e-03,
  -1.705156754719452667e-04,-2.220909822985756064e-04,
  -2.775772259739503407e-06,-9.607033275786062022e-06,
  -3.190285896132220248e-05,-1.873024495037210865e-04,
  -1.774444258456305044e-04, 3.022376112125256669e-05,
  -2.975192157960825367e-05,-3.850086014732753883e-06,
  -2.566744780580047046e-06, 1.983461169852753094e-05,
   1.769018053756237819e-04, 2.297950200827792756e-04,
   1.743272331919618068e-04,-1.342014000211449770e-04,
   6.606850978426658177e-06,-4.956157301931469859e-05,
   2.973694727091657478e-05, 3.964084636675570231e-06,
  -2.022462068255668956e-03, 1.292148281919300746e-03,
  -1.292148634905501941e-04,-2.022461842733219175e-04,
   1.937864042746917712e-05, 9.810437449565058985e-05,
   9.810438802446990359e-05,-1.937857193769052964e-05,
   3.293793609506920550e-06, 3.986415587539728257e-05,
   2.989811604423299023e-05,-2.470355643541629525e-06,
   3.907955506641446554e-05, 8.531610387909182577e-06,
   6.398738483939159829e-06,-2.930965959908364495e-05,
  -1.996072969483488871e-04,-3.115396074417723922e-04,
  -2.273397389609446945e-04, 1.456593391759331577e-04,
  -8.681357690419564272e-06, 3.904656231540739789e-05,
  -1.952328494565314185e-05,-4.340661807931298170e-06,
  -2.595362523259963839e-05, 1.504690457488739974e-05,
   1.697147053775327509e-06,-9.854932362926787612e-06,
  -1.307557389541112844e-04, 9.221136985515564558e-05,
   5.763209189623290553e-05, 8.172234690501837086e-05,
   2.246428676674696711e-03, 3.898181635244453414e-04,
   2.564595760527686426e-04,-1.477913558314840727e-03,
  -1.886332314318401107e-02,-2.682087135042071288e-02,
  -2.019540450264981427e-02, 1.420358183608457295e-02,
   5.752584310600734225e-06, 8.179717216959903891e-06,
   1.942950116661279727e-05,-4.742835061078138533e-06,
   2.975890210568087486e-05,-3.795753609561938916e-06,
  -1.512631739423257038e-05,-3.702964382881555178e-05,
   2.777222693151689022e-05,-1.134475258718002781e-05,
  -8.463626227999242191e-02, 4.840666185632638285e-01,
   4.459941981416468693e-01, 7.797943846931347511e-02,
   3.617319204817833888e-05,-2.068610649132542935e-04,
  -1.871600111119919863e-04,-3.272812613882802960e-05,
  -1.196006400393172611e-04,-7.277147038631045389e-05,
  -6.237565339865829743e-05, 1.025147689998394754e-04,
  -1.662171173903361784e-05,-1.112289076025077363e-05,
  -1.818149695650360365e-04,-1.408663083993650354e-04,
  -1.102432723806060747e-04, 1.422899184581096757e-04,
   3.264673410446061605e-05, 2.311256697800242831e-05,
   1.733442950694905350e-05,-2.448504755291714685e-05,
  -1.551139065145921078e-05, 3.686999810222159514e-05,
  -1.843500446560305368e-05,-7.755682455670523682e-06,
   1.734662832907452177e-06,-1.992463161155381407e-05,
  -1.992463130879773336e-05,-1.734666310411652787e-06,
   2.423544935509847672e-04,-1.854228761360271135e-03,
  -1.794734749465851228e-03,-2.345787267843112167e-04,
  -5.341950760644859856e-04, 2.432022948228173762e-03,
   2.129240974753983384e-03, 4.676888617753331267e-04,
  -1.025776821575635708e-05, 3.866236142854984596e-05,
   2.899677241415066093e-05, 7.693321100925876876e-06,
   4.228887967295954999e-04,-2.382764164914479097e-03,
   1.506458382332795647e-03, 2.673633151710533263e-04,
  -1.394267516240629324e-04, 9.726346144139570748e-05,
  -5.721381516232542654e-05,-8.201572626375542706e-05,
   9.843893651305884608e-06, 1.760044823798450898e-06,
   5.883004479560403378e-03, 5.911502202779952454e-03,
  -8.255996782526247126e-05, 3.583087652697915996e-05,
   7.805499989244933044e-06, 6.250933523714466678e-06,
  -4.781234385199137029e-05, 1.462804755867793415e-05,
   1.999981240224317069e-05, 8.662491027576584406e-08,
  -4.938724062190375918e-04, 5.510807984092875927e-04,
   1.563157918927906705e-05, 1.247612648418160535e-05,
  -2.325255951029766253e-03,-5.525258022940264611e-04,
   1.035696901371229188e-03,-4.358638770131109674e-03,
   1.536279827454486969e-04, 4.016197740619404451e-04,
  -3.735997898250609028e-05, 1.429097513911150995e-05,
  -3.972086157102551255e-06,-9.177283452119930444e-06,
   9.500273761680263509e-06, 2.845601515414850825e-05,
   1.187327353452890963e-04, 5.293899845506649634e-05,
   3.665007585350758742e-05,-8.219958600827707710e-05,
   2.943710509422205120e-05,-5.784189110992672767e-06,
  -6.709469888906835424e-05,-2.615306891762135999e-04,
  -4.552571256030384767e-04, 1.167944758439337752e-04,
  -4.130167062597915496e-06,-1.956889675058436572e-05,
  -3.913779350116873145e-05, 8.260334125195827604e-06,
   3.443866534474380922e-05, 2.034645741333714826e-05,
   2.543307176667143447e-05,-4.304833168092975644e-05,
   3.780469379127299358e-06,-1.963945139950403135e-05,
   2.069456133038367305e-05,-8.758844176798094995e-05,
   4.866024542665608104e-05, 1.149697851687982815e-05,
   1.839508591057425043e-05, 7.849892632551908419e-06,
   6.808696557779076331e-04,-4.200196564934474859e-04,
   4.042689193749437961e-04, 6.553370436862355954e-04,
  -9.478713476685362047e-06, 3.186532728045221431e-06,
  -7.072488907492412418e-05,-1.763462221464913828e-04,
   6.266986879862003403e-05, 3.118473255879791555e-05,
  -6.141236501789896964e-04, 1.434033522024793540e-03,
   3.420532786878613396e-02, 1.238950948943672893e-02,
   9.535631272793524944e-05,-2.632625564392555135e-04,
  -3.760893663417937165e-05,-1.362233038970503128e-05,
   2.862093992611809169e-05, 8.991206690180093510e-06,
  -1.849334324043388562e-05,-7.615527282565424821e-06,
   5.429714306320421267e-05,-1.505052167041858423e-04,
  -1.128789125281393682e-04,-4.072285729740316628e-05,
  -2.163854478725768873e-03, 1.014807269829316391e-03,
   9.298861593833484184e-04, 1.982778790129470243e-03,
   2.874386811300978073e-05, 8.590113264788746888e-06,
  -2.302723029181036676e-02, 7.705272912160822385e-02,
  -8.590113264788745194e-06, 2.874386811300978073e-05,
   2.577033979436624744e-05,-8.623160433902934898e-05,
   1.575169942535205593e-05, 1.232412127550535899e-05,
  -2.791906940441827092e-03, 8.889069894610771624e-04,
   5.633424126580518549e-05,-2.065074480511664673e-05,
  -1.351087711570614607e-04, 3.668269287319012945e-05,
   3.045979665404470479e-06, 9.524810122933814789e-06,
   7.339040624031773917e-05,-1.421754137390889960e-04,
   1.426770129258451946e-05, 1.401544504557675693e-05,
  -7.342926335248252607e-06, 2.908747897008466467e-05,
   8.790587175512913938e-06,-4.767135105040331720e-06,
  -1.916987721367310383e-04,-5.702263376300390645e-05,
   8.796668512243561899e-06,-4.755904024021367944e-06,
   2.097353674593419905e-03, 3.879330813899412554e-03,
  -1.026144515529729345e-05,-1.716690837992752302e-05,
   8.744483800746012816e-06, 1.798705098281790812e-05,
   4.401008417241368716e-03,-2.331670154980607437e-03,
   1.280869203291257815e-04, 5.039779170168075034e-04,
   1.979863037553441368e-03, 3.738330819638463649e-03,
  -9.725891718176244674e-05, 5.138777119734882083e-05,
   1.957062586031445471e-05, 9.806625619159524724e-05,
  -3.737292450716282868e-05,-7.073375795037267376e-05,
   8.808576259842651555e-04,-1.994113798845332814e-03,
   2.904658944197656122e-05,-7.503042168964248398e-06,
   1.633023653928823899e-05,-1.154657414867697197e-05,
  -5.454123130634491896e-06, 8.381678881696543661e-06,
   1.849413205084809108e-04,-1.191499390204600156e-04,
   8.123859478667727781e-05, 1.260963548921460460e-04,
  -5.095926056379663821e-05, 1.763468711348370314e-04,
  -1.428534399005730766e-04,-4.172223973519680041e-05,
  -1.217125728288496675e-03, 7.118321161188195540e-04,
  -6.361052952551151524e-04,-1.087644267832273744e-03,
  -9.481944387112137013e-04,-2.719576877631614434e-04,
   3.138415077677521672e-05,-2.479990080666936365e-05,
   2.444061652372266969e-04,-8.914621464050121206e-04,
   4.080161295340568178e-02,-1.935598048150693681e-02,
   1.797585964115148288e-02, 3.789237482873857726e-02,
   1.174537131076779984e-04,-5.571916436217674124e-05,
   5.143307479585547013e-05, 1.084188120993950869e-04,
  -1.417993149594741801e-04, 2.868674855695985842e-04,
   5.655467096196794603e-05, 2.003919141042222337e-05,
   1.335946094028148507e-05,-3.770311397464529509e-05,
   6.751911974185126801e-06,-1.882582494056649698e-05,
  -1.842256387601424279e-04, 7.785187231799573404e-05,
  -7.395927870209592159e-05,-1.750143568221353173e-04,
   1.556460293652398949e-05, 2.564650337625674879e-05,
   1.721312573457144904e-05,-1.018372733559938948e-05,
   7.526890517738733113e-06, 6.583761776824459318e-06,
  -2.341560074053113078e-05,-4.417815796959943364e-05,
  -3.534208172525063924e-05, 1.873331949563945308e-05,
   9.365808503699554562e-06, 1.767149204430766657e-05,
   1.767149204430766657e-05,-9.365808503699552868e-06,
  -3.660985949674604075e-05,-1.611577449670087038e-05,
   1.011895075821080989e-05, 1.725128504062537824e-05,
   9.260261421129456716e-07, 2.998570452038976919e-05,
   2.998608994209082403e-05,-9.134604451423187947e-07,
  -3.781910261478845826e-04,-7.945889174543086398e-04,
  -7.584712393882037411e-04, 3.610005249593443251e-04,
  -7.808709876925439526e-06,-1.841260573786358785e-05,
   1.152956848699530261e-05, 1.634224741287699720e-05,
  -9.732301920214741651e-06, 2.298325332450663954e-06,
   1.220887685187093717e-05,-4.848652726289902115e-05,
  -2.909191635773942421e-05,-7.325326111122512666e-06,
  -1.560561676508466673e-05,-1.250858606643086876e-05,
  -1.407183804011772363e-05,-2.195495009654376255e-04,
  -9.998759477747427117e-06,-1.575084320156011710e-07,
   2.043465254015111278e-05, 4.563359481306832185e-05,
   3.650687585045462767e-05,-1.634772203212095257e-05,
   6.241001512634724588e-06, 2.934365178568085425e-05,
  -2.000642130212292987e-05, 3.463730801725160450e-05,
   2.868625679600021481e-05, 8.780584891334487999e-06,
  -1.910502621979365417e-05, 5.915908479768520961e-06,
   9.160422574607644005e-06,-4.010817654122246843e-06,
   1.238551969037841568e-04,-1.164469415653535198e-04,
   1.394142404031248105e-06, 9.902341488621869335e-06,
  -2.513624723696917492e-06,-9.678930248143108143e-06,
  -2.963461534867634244e-05, 4.027144860985257507e-05,
  -1.408060548639167239e-05,-1.420339921063253088e-05,
  -6.921053127769094494e-05,-7.217965336755064278e-05,
  -3.909921385640986849e-05,-3.116490776194799596e-05,
  -5.879089842071001735e-05, 1.198458438519067897e-05,
  -1.672015049890056905e-05, 1.097435953913097945e-05,
  -1.513502610583119097e-05, 2.590233550813147032e-05,
  -2.033193223567846602e-05, 2.205929580842912966e-05,
  -1.898197306497568224e-05,-6.299579236785406497e-06,
   2.475289824553814858e-04, 2.330866852580890396e-04,
  -6.783327216065947326e-05,-1.728141163151609695e-05,
   9.759467651750954823e-06,-2.180089712472109533e-06,
   6.885164746865487860e-07,-9.976269095412633697e-06,
   1.195897292091819799e-04,-4.648637398933955591e-04,
  -1.326959218196340287e-05,-1.496388730659168672e-05,
  -1.967185292820348356e-05,-3.608074607201469034e-06,
   1.404048870611246351e-06,-9.900941711217943849e-06,
   7.494212325980694465e-05,-1.299372085328598164e-04,
  -1.961014217282702239e-05,-3.929672246067243567e-06,
  -2.762683546273732526e-07,-1.999809180387547634e-05,
  -6.265488267260517990e-06, 7.793821705224004734e-06,
   4.009518223667748495e-03, 5.711949002540361604e-04,
   1.850492984823532303e-05, 7.587329656202471556e-06,
   5.320551899049865124e-04,-3.762567909672218710e-03,
  -1.218473328310821028e-05,-3.809897997085375307e-05,
   4.574351219032346452e-05,-2.018739934943896309e-05,
  -2.859341818965365059e-05, 9.078349862810077537e-06,
  -8.846465249768543872e-06, 9.960793167506611296e-05,
   6.974594007774331502e-05, 5.958510105037843229e-06,
   1.973814534835185042e-05,-3.225774047780822581e-06,
   6.621445370813148958e-06, 7.493761485484918828e-06,
   1.493467615599925274e-05,-1.330246022792127787e-05,
  -1.985109033818026881e-05, 2.436023888513007933e-06,
   4.226226240817941367e-06, 2.970082510236747602e-05,
  -4.152888180202226133e-06,-9.096896160929653107e-06,
   3.769303758930202535e-05,-1.657686186142946392e-04,
   9.458293446336050878e-06,-3.246642124256462825e-06,
   4.999810313275238364e-05,-4.355262640261562548e-07,
   5.994114218660411214e-05, 2.656966948478876530e-06,
   2.760941763740718548e-06,-5.993644300905111820e-05,
   9.155445314467244858e-06, 2.856882603632497516e-05,
   2.179045482772947439e-08, 9.999976258775738217e-06,
  -9.498092285255681582e-06,-3.128297131150829512e-06,
  -1.100572205078279193e-05, 2.790831564499931221e-05,
   1.984474539916891782e-05,-2.487183154125194613e-06,
   1.286124984098362513e-04, 1.894268335743015425e-05,
  -4.822820327101514563e-05,-1.319243757800824654e-05,
  -3.589720425145062838e-04, 2.718589143220296464e-05,
  -1.034791560990136316e-06,-9.946316223874225292e-06,
  -3.463190364557195135e-06, 1.969787583722768524e-05,
   6.979797264764173192e-05, 5.314415704388876742e-06,
   3.139607385205423149e-07, 9.995070217595655683e-06,
  -1.451049528619969508e-06,-9.894162686427376006e-06,
  -3.587336760442948137e-05, 1.769467424728326691e-05,
   1.936359843516439292e-05, 5.005102960149691357e-06,
   2.254909672751531874e-04, 1.225034983169762462e-03,
   1.276861947978759840e-05, 4.834213851889869538e-05,
  -2.356032048425195477e-04, 8.361297667188854468e-05,
   7.358875539873420673e-05, 2.073275068071414086e-04,
  -5.127632351249176063e-05,-7.396444177469526119e-05,
   1.257997352066879384e-06,-2.997361243931389555e-05,
   5.026444982505734162e-05,-6.223732870058204622e-05,
  -4.692964213575605108e-05,-3.738460497330245137e-05,
   1.539912696475713783e-05, 1.276193123015829833e-05,
  -7.750402643653335043e-05,-1.982740240488249222e-05,
  -2.119943346675507895e-05,-2.122696447183687087e-05,
  -2.122806334306120131e-05, 2.119833311142603249e-05,
   5.457771318228260137e-05,-9.550535704238007832e-05,
  -1.959916918039685771e-05, 2.271282825713658401e-05,
   1.449367227744902922e-04, 8.884450681606912521e-05,
   8.887202751253777907e-05,-1.449198493161331282e-04,
  -2.755940686169475775e-05, 2.899101746113047658e-05,
   2.899656283163376517e-05, 2.755357225390412971e-05,
  -5.406537670827317547e-05, 1.505886285261689929e-04,
   1.317917062922535501e-04, 4.723289269752987480e-05,
  -1.976059250337909020e-05, 3.085285062258937703e-06,
  -1.246414063738048947e-05,-1.564113800756199404e-05,
   2.430749875865418190e-05, 1.758253406361055427e-05,
   3.726385154267923035e-05, 1.453978570011136737e-05,
   6.584649151796812914e-06,-7.526114239615389252e-06,
   9.998941758628849288e-06,-1.454775156105816238e-07,
  -2.008321040902756082e-08,-1.999998991661395086e-05,
  -3.990206025567033022e-04, 4.613919794873827095e-04,
   1.348351713971231339e-05, 1.477141718126884244e-05,
   4.311072220740236305e-04, 3.728894783653978039e-04,
  -4.946735471347093805e-06, 1.937859149103764384e-05,
   2.951209383263102130e-05, 5.388535757882851598e-06,
  -7.905655634128320585e-05,-1.617098045866654198e-04,
  -1.257741422113354461e-04, 6.148874003427588861e-05,
  -4.896676530094156782e-05, 9.850002992873912924e-05,
   4.408290241651145001e-06,-1.950812592601768421e-05,
   1.074505501545144838e-04, 5.342639115167866691e-05,
   1.787588622592354600e-05, 8.969542443059007030e-06,
  -7.659747108263871671e-05,-2.308305490493679389e-05,
   1.702358724267985071e-05,-2.470217555987463644e-05,
  -9.153802754574380627e-06,-4.025903020484533565e-06,
  -1.316004835050719618e-05, 1.506031631182801115e-05,
   2.220723976033794919e-05, 2.017023803099173552e-05,
   5.196647584530800992e-06, 8.543702586243870841e-06,
   2.406674934887082883e-06, 9.706076228723235560e-06,
   1.201424178786927959e-05, 1.598930874874256787e-05,
   1.710475777805966591e-05,-1.036471231409282257e-05,
   1.874163591601095606e-05, 6.982197590421528255e-06,
   9.624444761756835559e-06, 2.714786000385926708e-06,
   1.994688200457888849e-05, 1.456673709314127027e-06,
  -1.437784543979434410e-05,-3.732663339372284151e-05,
  -1.681971019352144997e-08,-9.999985854857446061e-06,
  -6.896507717077591496e-06,-7.241421221575861739e-06,
  -3.207217400391673782e-05,-2.390346532748939534e-05,
   1.770693496471712395e-06, 3.996078883782893054e-05,
   6.056027291145340814e-06, 1.906107377481402267e-05,
  -9.999893319417747095e-06, 4.619091105756257362e-08,
  -1.910449980681239114e-04, 6.212904462378652723e-04,
   7.029286899806462393e-06,-1.872402535995423427e-05,
   2.867318362337716031e-04, 8.823181749895293413e-05,
   1.177042544237326176e-05,-3.822900842168852701e-05,
  -3.822900842168852701e-05,-1.177042544237326345e-05,
  -1.085108863903418047e-05,-2.796880182181251924e-05,
   2.569238360044386694e-05, 7.576213714598898003e-05,
  -2.108373149713562909e-06, 9.775211642801751103e-06,
   3.910084657120700441e-05, 8.433492598854255024e-06,
  -7.485874922376613782e-06,-1.991223431586290442e-05,
  -2.958746515990068611e-05, 4.958014260937857179e-06,
   8.594656018674741926e-05,-3.289577310112437808e-04,
   2.805815940978255299e-04, 7.330736015928460613e-05,
  -2.802070686294636935e-05,-5.878913509473639154e-05,
  -2.004831441033695346e-05,-4.197060978858822844e-05,
  -9.050132591732887094e-04, 2.543806400007780390e-03,
   2.016202109635796026e-03, 7.173068054188288731e-04,
   7.509925445984887304e-06,-1.853647808500171219e-05,
   1.853647808500171219e-05, 7.509925445984890692e-06,
   2.921863152826298350e-05, 6.802321046201541725e-06,
   6.148193044742439231e-05,-3.547111109458767390e-04,
  -3.251518517003871146e-04,-5.635843624347171700e-05,
  -1.834914771449252369e-05,-2.373412686727139153e-05,
  -9.286222198510019264e-06, 1.771344340550136336e-05,
  -6.925915508848432727e-05,-1.015723566868830927e-05,
  -2.708268112362385431e-05, 1.290458767865553622e-05,
   1.302640957447120498e-05,-1.517605527131886165e-05,
  -1.676606429400543091e-05, 2.487768253051871853e-05,
  -4.092869851961455143e-05,-6.873748349692838271e-05,
  -6.922000892611432832e-05, 1.042067004892932538e-05,
  -1.955658760584601388e-05, 1.487196687772497357e-04,
  -1.153385939335146578e-07, 1.999966742245354285e-05,
  -1.555574381797911928e-05,-1.257055425466213989e-05,
  -1.885583138199316833e-05, 2.333361572696871110e-05,
  -1.449117423543491983e-04,-3.873740992666800079e-05,
  -1.677391536764492663e-05,-2.487238957637736457e-05,
  -2.487238957637733747e-05, 1.677391536764496729e-05,
   1.299543690129602671e-04,-3.444121723074185590e-06,
  -1.982922881979448499e-05, 2.608003913385086126e-06,
   1.214627684585736446e-06,-9.925959882441491651e-06,
   1.550535409149118618e-05, 1.263265587663487217e-05,
  -1.795990493118131636e-04,-8.800103116607731429e-05,
  -1.319721144326213440e-05, 1.502776131437517248e-05,
  -1.382833410097349667e-04,-2.185675179859418891e-05,
   1.697327541802632511e-05, 9.854901278847913242e-05,
   9.991660104611772614e-06, 4.083238346086082380e-07,
   4.454764462584843640e-04,-3.868471737377846345e-04,
   7.806208378609809099e-06,-6.250048859786779870e-06,
   1.221542426885578991e-05, 1.583614252057138636e-05,
   1.097568731523028938e-03,-1.575354842434849474e-03,
   2.023290221648797003e-05, 2.215016180297643613e-05,
  -1.815397134699088221e-05,-2.388374602805502434e-05,
  -6.135625901635956237e-05, 3.369583771799413005e-05,
   8.868562073192526408e-06, 4.620455253969148260e-06,
  -1.466280599136226059e-05, 1.360154845815986682e-05,
  -7.905212742095581724e-06, 1.837138022855685539e-05,
  -1.004627317977536082e-04,-8.250599687133429699e-05,
   1.992628955670176164e-05, 1.715512897788408329e-06,
   4.644444316578605860e-06,-1.945325517722421479e-05,
  -1.387050330911362402e-05, 3.751811746279213336e-05,
  -1.013164043206520018e-05, 1.724383548272662270e-05,
   1.555662509304454432e-05, 1.256946362079372435e-05,
   4.460558512017829589e-06,-8.950051271409863177e-06,
   2.786181579747885930e-05,-1.112291420749785232e-05,
  -2.332562858916436777e-06, 9.724152945588813142e-06,
   3.986268066138546224e-05,-3.311599385252669478e-06,
   1.460924544612959576e-05, 1.365906100340509383e-05,
   1.473010862202628846e-05,-2.613472594046677394e-05,
   2.790516450781906410e-05,-1.101370935659531821e-05,
  -2.699743115737963795e-05,-1.308199949940937891e-05,
  -8.593228514393043660e-06, 5.114335118020947139e-06,
  -5.543132916578140195e-05,-5.768334028915795257e-05,
   7.256629443756130517e-06,-6.880503551049996424e-06,
   3.126948765237805441e-05,-2.494432083576893954e-05,
  -1.709004942847120782e-05,-1.038894655546995523e-05,
   1.058423166323599058e-04,-2.154005664103399674e-04,
   4.019068302739970296e-06,-9.156805664526843002e-06,
   1.273189401102639143e-06,-1.995943357785786481e-05,
   5.930066270586371287e-06, 8.051975784020582458e-06,
   9.824561807652724409e-06,-1.864935732836781465e-06,
  -4.882075210297328775e-05,-1.079509907782366937e-05,
  -1.707571684830789475e-05,-2.466616901986228526e-05,
  -3.986005993625643256e-05,-1.755311243679537445e-04,
   2.080909351242886943e-05,-2.160975768468935903e-05,
  -1.855239711966097184e-05,-7.470512774528620399e-06,
   9.478869977276257081e-06, 3.186067160919686526e-06,
  -2.555956354353862448e-06,-9.667837768324318536e-06,
  -9.816841687751834804e-06, 1.905155971992248743e-06,
  -2.890958699003303743e-05, 6.375135904485261247e-05,
  -5.464402203844505768e-05,-2.477964599145700007e-05,
   8.503579545888689193e-06, 5.262046646196092140e-06,
  -5.924961600938493918e-04, 3.536216908986828094e-04,
  -8.467660724668591568e-06, 5.319654298157447430e-06,
   3.228719786466243704e-04, 5.409747548682967240e-04,
   2.440563202170570525e-06, 1.985053277008481172e-05,
   1.966974411358455961e-05, 3.619553357267382186e-06,
   1.959512327294035602e-05, 1.789302409988827928e-04,
  -1.033099206810425396e-05,-1.712514533920127195e-05,
   6.439338989393493258e-05,-1.243120723741973318e-04,
  -1.465787849404148009e-03, 1.667293009803364964e-03,
  -1.154326386331831360e-04,-5.979386204436833754e-05,
  -1.309042493336095439e-05,-4.825599211563308047e-05,
   7.666183274470129701e-05, 4.714831280357173081e-05,
   9.626344846645446625e-06,-2.841361442853518123e-05,
  -2.841361442853519817e-05,-9.626344846645397497e-06,
   2.347094797872527049e-05, 1.868460866542224867e-05,
  -2.041759238137942436e-05,-3.439653938040623891e-05,
  -1.619169492805012036e-05,-1.174006027910232164e-05,
   1.463686890242292149e-05,-1.362945592213001331e-05,
   5.996943103924961649e-05, 1.915030242237735143e-06,
   1.915030242237830858e-06,-5.996943103924960971e-05,
  -3.919894945765439753e-05, 7.965071337800827173e-06,
   1.666640634002242681e-04,-6.799330828049201983e-05,
   6.516884636889619205e-06, 1.890846938886043451e-05,
  -1.416143928163645731e-05,-5.830483374020137228e-05,
   9.947483686883675121e-06,-1.735072241433143462e-05,
   2.933541708501634002e-04,-7.657305860711148722e-04,
  -3.858531865692537463e-05, 3.179894941886487916e-05,
  -6.912475797360989474e-04,-2.641529547610352345e-04,
  -1.770058696072140622e-06, 2.994773601146603402e-05,
   1.960093813664647003e-05, 3.975326925343127989e-06,
   1.975907672345286934e-05,-3.094977711826541260e-06,
   9.040496193555143346e-05, 9.341810775985292658e-05,
   3.123207942276077175e-04, 1.983827651108742462e-04,
  -2.901052929746158148e-05,-7.641281952730403045e-06,
  -1.169427165565417289e-03,-3.660743691702774831e-05,
  -1.806391499683362075e-05, 2.395193050647837591e-05,
   1.889020969592895979e-05, 8.799522701626396898e-05,
   2.949331292667331988e-05,-5.490400040919102873e-06,
  -2.959218504846143322e-06,-1.977986415121641290e-05,
   2.686916669128448744e-04, 5.364744058495211996e-04,
  -1.333027411045084894e-05,-1.490985553720236055e-05,
  -3.561738353837373033e-05,-1.820444972748103870e-05,
   9.981345620070101657e-06, 6.105240476077949564e-07,
  -9.425816317047977039e-06,-3.339758487865868479e-06,
   2.988658138149909678e-05,-2.606195182067459633e-06,
   1.922806893415847726e-05,-5.502850630650420640e-06,
  -4.383606140227108342e-05, 2.404994221898088994e-05,
   2.580529587501733161e-05, 1.529989231343847106e-05,
  -7.149056799450239909e-06, 6.992209012768018139e-06,
  -3.139808509079476089e-06, 9.494293155696853728e-06,
  -2.293577374848977978e-06,-3.993418964778903729e-05,
  -7.130453756489972270e-06, 2.914029219528448711e-05,
   1.534909003918624910e-05,-2.577606321704215459e-05,
  -3.684216231398581697e-05, 1.557005301083780010e-04,
  -1.265066807130570733e-04,-2.993425688011368551e-05,
  -1.547945561064561815e-05,-1.266437736322050510e-05,
  -1.481736397779735350e-05, 1.343300877500917351e-05,
  -1.733325151136493874e-05,-9.977895171015033310e-06,
   1.108960271486073538e-05, 1.664393918597858411e-05,
  -3.647602299564640677e-03,-2.314605250190785151e-03,
   2.014563828869762787e-03,-3.174764964435887113e-03,
  -4.516797158556406036e-05, 6.602919311066642884e-05,
  -5.777554397183304053e-05,-3.952197513736864937e-05,
   5.086930415186557584e-04, 3.544451854807725041e-04,
   1.879811737762889466e-04, 2.762387202563508113e-05,
  -3.315777541594331452e-04, 4.758741356142257321e-04,
   5.996519488911805199e-06,-8.002609200698290322e-06,
   2.715527249821313534e-05,-1.275112448169922396e-05,
  -3.574138324633023201e-06, 2.978633134906662916e-05,
  -1.985755423271108272e-05,-2.382758883088721097e-06,
  -1.144693970756631329e-05,-3.832711274452254039e-05,
  -5.879541719402917083e-07,-1.999135587927187161e-05,
  -2.673201693009343645e-04, 3.794637116931996891e-05,
   1.940279295127482018e-05,-4.850940701550602492e-06,
   1.469770353500428516e-07,-1.999945993648527963e-05,
  -5.904120371985482083e-05,-1.269414678633841735e-04,
   9.973972474980194935e-05,-4.638951720845719369e-05,
   9.378625225086915874e-05, 3.470070444150003572e-05,
  -1.139851305621658054e-05, 1.643392527995853490e-05,
   2.908788901471838300e-05, 7.341301837373643293e-06,
  -7.341301837373693267e-06, 2.908788901471836945e-05,
   1.798400624257081161e-04, 7.586299935898230139e-06,
  -2.853870655454209419e-05,-9.248904161777012791e-06,
  -1.016173470948706603e-05,-1.722611818414136812e-05,
  -2.809427634686332992e-05,-9.597245248792008008e-05,
   5.819827637855550651e-06, 8.132011206685139135e-06,
   4.627384331887972384e-05, 1.894020655905764749e-05,
  -1.169639334604561330e-05, 1.622326670848322054e-05,
  -7.997692132589910525e-06,-6.003075924249955693e-06,
  -3.983271484787661302e-05,-3.654425789060445077e-06,
   3.183049676075804928e-05,-3.855929817778548999e-05,
  -1.956411097526317665e-05,-4.152777594283978920e-06,
   2.596806246630496874e-05, 1.502197496157156982e-05,
  -3.379088771148103796e-05,-2.140504397729843237e-05,
   1.901314532065718257e-05,-5.690782288065123536e-05,
   1.042502911488630466e-08,-9.999994565936921409e-06,
  -2.679467373003391570e-06,-1.981969865050955737e-05,
   4.889540925437345787e-05,-1.045174405768389977e-05,
   7.848920553225786640e-06,-1.839550070395339572e-05,
  -7.801926580258840803e-05,-1.769164106647712502e-05,
   1.182396300492080004e-04, 2.047901086054764147e-05,
   8.601993103265613486e-07, 9.962934163513966342e-06,
   1.064529718698377807e-05,-4.885363494972298895e-05,
   1.731023225735304788e-05, 4.690795091662493911e-05,
  -5.569704342899366123e-06,-8.305323204589208633e-06,
   4.985356361267065232e-05, 3.823897895786553547e-06,
  -7.077912368684159949e-06, 7.064216623322631364e-06,
   5.042665397238060901e-06,-1.935385040997005294e-05,
  -3.941452999826834842e-05, 1.879586788319447411e-03,
  -1.945863032143136054e-05, 4.621872565732652226e-06,
   1.299022909135699169e-04, 5.039326880273529245e-06,
   1.192793358273269941e-05, 4.855640431957372583e-05,
   1.231557280116044603e-05, 2.735556006700131583e-05,
   1.032554652674315629e-05,-3.864431509192603920e-05,
  -4.996968205202360598e-05,-1.740941015563228364e-06,
   1.686103223937689350e-04,-2.169237613239512590e-05,
  -1.150004623780255601e-05,-2.770828281450157397e-05,
   3.984579921198812952e-05, 3.577880829278107201e-04,
  -4.636565717007737651e-05, 1.871432165981051272e-05,
  -1.683019924714215473e-05, 1.080483194230691171e-05,
  -1.209843402567224954e-05,-1.592569917229557787e-05,
   3.201313413066799146e-06,-1.974212735323421547e-05,
  -1.580661160222856246e-05, 1.225361292257485580e-05,
   1.960551065302917282e-05, 7.756045353164176274e-05,
   7.070058698652313298e-05,-3.743563809742096770e-05,
  -1.304083585512064549e-03, 3.490931136502096587e-04,
  -4.580105300687222468e-05,-7.747427665658893818e-05,
  -1.959815321761045480e-05,-2.271370490384747891e-05,
  -4.297497973570563526e-05, 2.555682133434614714e-05,
  -9.524965758280486440e-06,-1.758621696964939423e-05,
   8.328979364951518170e-06, 5.534266233044072300e-06,
   9.479222959104155170e-06, 3.185016811822611393e-06,
   9.751377377832491853e-06,-2.215996217301988189e-06,
  -4.547070735445309070e-05, 2.079458517705236087e-05,
  -6.294273480305194457e-02,-8.261423446061019749e-02,
   2.053802449028541155e-04, 4.777226758315368158e-04,
  -2.538554535322770211e-03, 1.931797316281445766e-03,
  -3.574480607817663493e-04, 4.439942385249550142e-04,
  -3.191411578838704326e-05, 2.411408744790947194e-05,
   9.243861524362053370e-05,-7.651864094351052065e-05,
   3.248781101105245280e-05,-3.800713269519472059e-05,
  -4.403278539052617538e-05,-5.441611719657939503e-05,
  -3.247287053080637285e-05,-2.335621286701864010e-05,
   7.993515407490198594e-06,-6.008636403562526834e-06,
   1.690933966411854066e-04, 1.245288047495307377e-04,
   6.509678763407145032e-05,-8.867022183193522971e-05,
  -2.058509513287121593e-05,-2.182324124346889745e-05,
  -2.182178144260038652e-05,-3.352327332870974028e-05,
   4.460472244694843754e-05,-4.013002286855433718e-05,
  -8.138759200359121839e-04, 5.091227619992034093e-04,
  -3.570066515396110577e-05,-3.500660662738888890e-05,
  -1.465462047275203938e-04,-1.209305994360388608e-04,
   9.438050618713836207e-05, 7.411018858334889503e-05,
   2.503285053049186413e-04,-2.724621798191545290e-04,
   5.036719617592528409e-05,-9.779133678080006498e-05,
   9.651135907368780078e-05, 1.399484103866482031e-04,
  -1.234838915176306032e-04, 8.515708153560709430e-05,
  -1.901577713914162811e-04,-1.464241167958675528e-04,
   2.094962367931844135e-05,-3.407511214500900606e-05,
  -1.416498339887376737e-04, 1.812052000660109693e-04,
  -9.736495404913961816e-06,-2.280494952875213229e-06,
   2.851014154677734388e-05, 2.805658263193720999e-05,
   8.166281082852250674e-05,-7.369657609132833527e-05,
   2.502619488574527482e-05, 1.654356580488913761e-05,
  -4.230290242721466347e-04,-4.935042498533883824e-04,
   1.761269580262759865e-05,-2.428565310145280377e-05,
  -1.566518154012133484e-04, 2.320780229394937117e-04,
  -2.226340509802464016e-04, 4.139252098436685292e-04,
   5.795989020759156635e-05, 3.925112899171092913e-05,
   2.082129738753246131e-04, 7.104475709011461916e-05,
  -1.063402716038534706e-05,-1.693863826735156518e-05,
   1.693863826735158212e-05,-1.063402716038531826e-05,
   5.267136784893908474e-05,-4.610560713103933119e-05,
  -2.753239410646646235e-05,-4.173688146910608892e-05,
  -1.350666691056374438e-04,-1.475025250519741054e-04,
  -1.531300245959629541e-05, 3.695283420351405429e-05,
   1.981478299194623610e-07, 1.999901841184957601e-05,
  -2.779854382648390003e-05, 1.128011352456410037e-05,
   8.901826084619576874e-06, 5.933597131891570048e-05,
  -7.543937109475410850e-05,-1.296491468881611040e-04,
   1.091812353082126973e-05, 1.675692628633685175e-05,
  -9.517289447587860883e-05, 5.515541820241484650e-05,
  -3.259678050632700003e-05,-2.318296574259515270e-05,
   7.894000829720280304e-03,-1.144095609135926950e-02,
   4.754871393788261445e-05, 3.728738801640344217e-05,
   9.318516310670364633e-06,-1.769647574427661300e-05,
   2.719646428341141462e-04,-4.665139151709332818e-04,
  -3.457124326377752140e-05, 4.903905728291193020e-05,
  -4.429518745119599259e-05, 5.420273395930696000e-05,
  -8.733646886070174718e-06, 2.870058208589917824e-05,
   3.096740071729652010e-05, 2.531837460846140842e-05,
   2.633637915249864049e-03, 1.261091325542424823e-03,
   4.999549596936528659e-05,-6.711056378688940547e-07,
   3.022674876643828860e-04,-6.313749804205597092e-04,
   5.935195453107913551e-06,-8.048195756404485907e-06,
  -8.242734065733373756e-05, 4.525546746108804271e-04,
   1.863339307000447639e-06, 9.824864712910153471e-06,
   8.408142947500510980e-06, 5.413236755804924114e-06,
   4.998456971397626615e-05, 1.242091183708604500e-06,
   1.029187891725912205e-07, 1.999973519131779023e-05,
   1.391676872310147247e-05, 2.657674826437020482e-05,
   3.408320133409181246e-05, 2.093646070422988640e-05,
   1.319304414535667719e-05, 1.494186855322274048e-04,
  -2.058199641958356025e-04, 1.898371468876019000e-04,
  -7.355968428435197314e-04, 8.060573676014702300e-05,
   2.953731250507540926e-07, 9.999956377263351963e-05,
   1.298403682105885558e-04, 1.203013499002791083e-03,
  -2.240327972542422238e-05,-2.489941626977315299e-04,
   4.379657859971727960e-04, 7.401256449386675812e-04,
  -1.991828228539054609e-04, 1.806109298878998289e-05,
  -1.127454746331431711e-05,-1.651921848930731690e-05,
   5.685577947195727270e-05, 4.083405858638302786e-05,
  -7.413182517984994563e-05,-9.436351252207690707e-05,
  -3.378258012376466907e-05, 2.141815305252580982e-05,
   1.651591872233334709e-04, 1.453356214963416582e-04,
   1.660771098789500167e-05,-6.804924009760371666e-05,
   2.212909778905557123e-06, 8.501712705617960053e-02,
  -5.873963707011684227e-05,-1.223335754692699836e-05,
   7.232160558934891056e-04,-9.732792360418602282e-05,
  -6.343478795021568601e-06,-3.799470493065805195e-04,
  -3.058052434700516862e-05, 4.389360221383775164e-04,
  -1.764931065463324993e-04,-3.535793180638433810e-05,
   4.473300472206184894e-04,-3.168593028563249786e-03,
  -2.998797731872638746e-05, 8.492445652177281671e-07,
  -9.731444009378399255e-07, 9.952536861269258847e-06,
   3.653752778155517449e-06,-1.966342011543568990e-05,
   8.497344992568701320e-05,-2.965658118743229554e-05,
  -2.065983826368467235e-05,-2.175249601582289181e-05,
  -2.833762677199403316e-05,-2.282476262941877064e-04,
  -2.108140825410932480e-05, 4.533844093066689563e-05,
   1.999898837259772832e-05,-2.011568360780648791e-07,
   4.914632984801862260e-05,-9.199905568523745539e-06,
  -6.574967869312841413e-05,-7.471124277856381560e-04,
   1.189699113769237773e-04,-1.568949288431288074e-05,
   1.616178489239432348e-04,-9.989830283441990580e-05,
  -2.504907498551819169e-05,-1.650890191290404650e-05,
   1.943389712971106006e-05,-4.724790191300380491e-06,
   2.968566777318747222e-05,-4.331411878353150735e-06,
   3.600902512700873088e-07, 9.993514647557198171e-06,
  -1.454056374331826073e-04, 3.293284084354853453e-04,
  -5.899692188250183020e-05,-1.092534706039020548e-05,
  -7.612856141593018653e-04,-1.155171574879444642e-04,
  -6.908462481121473424e-05, 4.547827114289786999e-04,
  -2.974650424194038038e-05, 3.891720106100011117e-06,
   5.805121549061523732e-05, 3.911593511680569273e-05,
   1.142720258699429164e-05,-1.641398918714737838e-05,
  -8.323229300993692653e-07,-1.998267345827456592e-05,
   1.835361401718713355e-05, 7.946373544461150586e-06,
   1.157700203227520375e-04,-3.158009490912878659e-05,
   1.599520019227378912e-04,-3.918811160091082620e-06,
  -4.112863984752944873e-05,-4.368563819257094622e-05,
   2.078183989636101740e-03,-2.524688358039497548e-03,
   2.407684232707066503e-03,-1.130777005237453394e-03,
  -2.906752686594868060e-04,-2.600151691531383787e-04,
  -1.715727513269729365e-05,-1.027754396832857901e-05,
  -4.092235904010209480e-06, 1.957686403145125192e-05,
  -6.337430370139667955e-05, 4.882312597901879191e-05,
   9.037748509245804287e-06,-5.931542043923844124e-05,
  -1.783095304270918696e-02,-1.512221920184666883e-02,
   2.416192562043387691e-04,-3.556966896546299170e-04,
   2.199082124664674190e-03,-2.593074971723783803e-03,
  -1.601216891668577279e-06, 1.993579956926321402e-05,
  -3.906051308517419088e-04,-1.664790566933959173e-03,
   5.951394912194558537e-05, 3.685227075650116880e-05,
   3.114718674923010563e-05,-9.502553739710491707e-05,
  -2.103390116108242878e-05, 3.402315390944548701e-05,
   4.810797995874626807e-04,-5.883555272357750450e-04,
   1.992575484614343294e-05,-1.721712464783680674e-06,
   1.144366420709971535e-06,-9.934305486301065692e-06,
   3.442406376736731398e-04,-2.898247459655970684e-04,
   5.827860833462930021e-05,-6.858282445757740557e-05,
   9.998842130977677136e-05, 1.521710872202326974e-06,
   8.632902368221580854e-04,-1.078423247502674509e-04,
  -3.121585943120068021e-07, 2.999837590623861115e-05,
   5.695758189401667694e-06, 8.219387972827650734e-06,
  -9.928253415228599011e-05,-2.294405770832617366e-04,
   6.665513207476028571e-05,-4.423904800169489168e-05,
  -7.052895752766429483e-04, 2.239790503732272007e-04,
   3.432273810521942864e-05, 2.054141302248992595e-05,
  -1.871114043170984422e-05,-7.063513555224002465e-06,
  -1.658384311838865966e-05, 2.499952294394181424e-05,
  -4.749544321214699303e-06,-8.800103905114827079e-06,
  -2.700366186743936446e-04,-7.402853892182459622e-05,
  -1.231289050013525691e-06, 2.899973860697287664e-04,
   5.360083037997576030e-06,-4.971186487978268575e-05,
   1.999981819918071277e-04, 8.527602077927940170e-07,
  -6.999965236404091210e-05, 2.206103202954596347e-07,
  -5.403642320848456911e-04, 1.469914850709215699e-04,
   2.432982121684140130e-06, 2.990118054518191404e-05,
   1.684678025600875044e-05,-2.482309398535472223e-05,
  -3.780187695686544190e-05,-1.307738882720880861e-05,
   3.180837404060143144e-04, 1.353115935198946282e-03,
  -3.051824444105803095e-04, 1.255534771465253703e-04,
  -6.133952499660469708e-04, 1.436880903870979228e-04,
   2.032719111625770758e-05,-2.206366473011983054e-05,
  -4.399365815910696127e-04, 7.470219405357934151e-06,
  -1.127743642148457494e-06, 4.998728032487458794e-05,
  -2.376580175081055140e-06,-1.599823486096869896e-04,
   6.153984430915998343e-04,-2.892831765596384796e-04,
   2.260443289023448459e-04, 4.793787243621566046e-04,
  -2.485356974437381839e-05,-3.134166669086930335e-05,
   2.931385011933960414e-05, 2.721577100103713277e-05,
   2.655890481825329022e-05,-2.183909901412028616e-04,
   5.927595944114791927e-05,-9.293042146218161807e-06,
  -2.543723637468827290e-05,-1.680861297240740287e-04,
  -1.485649204130010061e-04,-3.388634893621304193e-04,
  -5.916159989994824417e-05, 9.995253737571848924e-06,
   1.616378826576035462e-05,-1.177845273793073075e-05,
   1.517402145888296233e-04,-7.664794372020647308e-05,
  -9.291476726064368957e-06,-3.697088076987642199e-06,
  -9.957181950680021868e-06, 1.734515862138631743e-05,
   1.421856146675222997e-02,-9.460495844239342903e-04,
  -1.046895749072492786e-05, 2.297616176149911164e-04,
  -3.683538681962533762e-05,-5.587872173536618040e-04,
   1.695909209747528077e-05,-9.855145455663935725e-05,
   8.493555138943137287e-06,-5.278211922775803800e-06,
  -1.158291721376501916e-05,-1.630447879630214097e-05,
  -1.749050250003216845e-05,-9.699604234007104238e-06,
   2.839467563698059007e-05, 9.682065661348359100e-06,
   1.899291851490573038e-04,-5.186967188552127880e-06,
   1.162412660839997338e-05, 3.827374662339562731e-05,
   1.185557738484549180e-03,-3.961727511066372013e-04,
  -1.272002760132836011e-04, 7.949899233414511640e-05,
  -4.221120709988306617e-04,-1.261238042368322421e-03,
  -1.062577238196035610e-04,-1.058739634125257893e-04,
   2.198462711697927790e-04,-8.222958879742848210e-06,
  -3.946251860148834793e-06,-1.099291912835543146e-04,
   2.628621844400740856e-05,-2.284929642678608245e-04,
   8.738998982067853192e-05, 2.151719496453252914e-05,
  -2.985893892728358660e-05,-2.905815915839972095e-06,
  -3.887293560235340702e-05, 9.428408012771052465e-06,
   2.795306716291403259e-05, 1.575392841045865063e-04,
  -4.519686395151224512e-05, 2.138325253436653813e-05,
   3.433962386911194718e-05,-3.634267783925556250e-05,
   2.320904951787986902e-05,-1.900894580129577357e-05,
  -2.896476899400220317e-05,-7.812948043094146951e-06,
   1.623170291973211605e-05,-3.655860801952886077e-05,
   1.127878599888078694e-06, 3.998409546136957160e-05,
   3.301980995482067804e-05,-2.257636265095698227e-05,
   9.965937468169458810e-06, 1.734012947992419522e-05,
  -1.232387837489185901e-04, 4.137876484487275488e-05,
  -1.650848939021209985e-05,-2.504934685881559232e-05,
  -4.543385898800896114e-05, 5.325189628039284209e-05,
   1.495716233095551252e-05, 1.327717195058667346e-05,
  -6.924233224823964799e-05, 1.982561459950848439e-04,
   5.928420803087480753e-06,-1.910114726348969091e-05,
   2.964052761190686620e-05, 4.630240046454046026e-06,
   1.246735219864971311e-05, 2.728672074755089156e-05,
   1.805605243150082659e-05,-3.569284200775966857e-05,
  -5.003391685880450896e-05,-9.796227418637359224e-05,
   1.480626158771515639e-05,-1.344524517426702481e-05,
  -5.936589727804018993e-05,-3.709029846702745919e-05,
   1.582577846799089938e-04,-2.430112622661911945e-04,
  -1.880429146540290219e-06,-9.821608128246706775e-06,
   6.523516408945542566e-06,-1.890618241904531817e-05,
  -9.840978253800859999e-07, 9.951459765787238333e-06,
   5.694681128316095780e-05,-4.070701026457299325e-05,
   7.740098405580095439e-06, 6.331735676095178666e-06,
   2.379554088145483703e-05,-5.507968985169589456e-05,
   1.821668133844424789e-05, 8.255454016199061259e-06,
   4.337079833850638634e-05, 2.487918510483436380e-05,
  -9.287117669202534919e-06, 3.708024460327371999e-06,
   4.172693873070033014e-05, 4.311452869004114206e-05,
   2.901964195698701710e-05, 7.606601125882623469e-06,
   4.137612868140065029e-05, 1.441804979022480958e-04,
   1.768635338542014906e-05, 9.337714063197548686e-06,
  -2.990591204263898524e-05, 4.007039337089094268e-05,
  -3.038961663437206637e-05, 3.970480072756815872e-05,
   1.402272460424528413e-05, 1.426054678732530267e-05,
  -2.096874568500372282e-06, 1.988977418283014340e-05,
  -3.501147131011247287e-05,-1.934416906204997327e-05,
  -1.203089863357783560e-05, 1.597677933967215345e-05,
  -1.997779739806760133e-05, 9.421311595332197359e-07,
   2.769530259614844028e-05, 2.886122336471158090e-05,
   1.394950118960060056e-05,-3.748881722009020086e-05,
  -1.758010243747382841e-05,-9.536246551339098046e-06,
   9.053992971199007072e-06, 4.245610825014346455e-06,
   8.731797991266281749e-05,-4.873982338880408771e-05,
   3.914075424832270153e-05, 8.246293523299335138e-06,
   6.831262557055784476e-06,-1.879717669961549699e-05,
  -8.580518059856617782e-06, 2.874673389838356143e-05,
   6.500702301772075503e-05,-6.224216383106812847e-05,
  -2.212892150212734322e-05,-2.025613075472919826e-05,
   1.895365977289799689e-05, 6.384260428054946218e-06,
  -1.979976448429183764e-05,-2.822999533576954599e-06,
  -3.518629629604500607e-06, 1.968804829153132191e-05,
  -8.284185006150501083e-06,-5.601096212695443548e-06,
   1.968804829153131513e-05, 3.518629629604537030e-06,
  -1.611743006172662609e-05, 1.184180932988497931e-05,
  -3.983952670585926844e-05, 3.579401046701277390e-06,
  -1.371515819114468101e-07,-1.999952973056064832e-05,
   5.463965207880726104e-05, 3.760512045196862563e-04,
   1.269189604817680674e-05, 1.545690055290108939e-05,
   4.779049809020245330e-05,-1.469926162398492169e-05,
   1.101142776478282329e-03,-1.201825522199332936e-03,
   8.719752943650034273e-06, 4.895498810305909860e-06,
   9.243998094758867828e-06,-5.928362758151776773e-05,
  -1.999411673842708679e-05,-4.850730358923813309e-07,
   1.434517345807612967e-04,-7.086324749664537281e-05,
   4.572774127729400072e-05, 3.884551039279651990e-05,
  -2.435999300864466721e-05,-3.172681422107777527e-05,
   5.279619212273985054e-05, 1.187963050660193674e-04,
   8.956626554923437851e-05,-8.825195497213172659e-06,
   2.565656616574654784e-05,-1.554800992354550673e-05,
  -2.576200213798803728e-05, 5.418781455126512361e-05,
   1.680439913553284930e-05, 1.084491446225846816e-05,
  -8.440000336786951238e-06,-1.813191645455703487e-05,
  -1.728305940294949224e-05, 1.006458432694163240e-05,
  -3.343980819774938231e-04,-1.033340271046033352e-04,
   6.135053201518662555e-05,-3.370626383112728628e-05,
   7.971982467156841980e-05,-2.579626880489491224e-04,
  -2.866045818668123643e-05,-8.864430976069282128e-06,
   5.909620650712854752e-06,-1.910697212445415649e-05,
  -2.425173397777304291e-04, 9.373014406866574165e-05,
   1.010121083211053384e-05,-5.543608085593737230e-06,
   2.901597292804670818e-04, 7.620584953851006172e-05,
  -7.112545956927587149e-05, 2.708157473284359936e-04,
   3.229112282054272373e-05, 5.933321167929397574e-05,
  -4.192814873375837122e-05, 2.006003959263183390e-05,
  -2.985257633170012356e-03,-1.066366195825888506e-03,
   7.905238360223502047e-04,-2.213045879479345109e-03,
   3.789733740557572124e-05,-1.279811773535278158e-05,
  -1.947848426694636983e-05,-4.537471835981228984e-06,
   3.705374282751071709e-05, 1.506718760992569242e-05,
  -1.130039070744429812e-05, 2.779030712063302596e-05,
  -3.979365101377989534e-05,-4.057750484381046120e-06,
   9.771532916173011489e-06,-2.125357491846344388e-06,
  -4.182526378183254510e-05, 9.390690322386209023e-04,
  -5.339893449864821571e-05, 2.735971115361193734e-05,
   8.464646367980362097e-05,-5.324449442434106881e-05,
   3.546322979363059047e-04, 6.193491148306570770e-05,
  -5.677366885947513690e-05, 3.250796064416140306e-04,
  -1.585231699907654147e-05, 1.219442683199128108e-05,
   2.438829477643938355e-05, 3.170506391568229899e-05,
  -1.032694547242473108e-05, 2.816654393441918807e-05,
  -2.816654393441920840e-05,-1.032694547242467856e-05,
  -3.528646761621564727e-04,-5.929473166453967789e-04,
   5.413866804153616777e-04,-3.221807912784917130e-04,
  -3.644672277909153218e-06, 1.966510523711074895e-05,
  -5.696729094147789356e-06,-2.945415552393057634e-05,
   1.099449198853589116e-05, 1.670691910299502837e-05,
   1.242297288099131420e-04, 6.455210670315442438e-05,
  -5.994124193864359252e-05, 1.153561767520620948e-04,
   1.639554674175608450e-05, 1.145364776125455780e-05,
   1.176073046961277010e-05,-1.617668751077060968e-05,
   5.420147722326316324e-05, 1.611278990951476751e-04,
  -1.983613711271943661e-07,-1.999901629496922539e-05,
   1.433966866934330265e-04,-4.317619412389812374e-03,
   3.757928007080021254e-03, 1.248082273072537098e-04,
   7.999993163835424884e-05,-1.045842179667762861e-07,
   9.151119072104073275e-08, 6.999994018355995757e-05,
  -2.427883004296458406e-06,-2.990159500958850932e-05,
  -5.567913692203757791e-05, 5.974109420755673375e-04,
  -5.686998413861444024e-05,-1.388013144897185024e-04,
  -5.476317450698216238e-04,-5.098501536512452432e-05,
  -9.991260598342631562e-06,-4.179852341962147807e-07,
  -1.968353829824898396e-05,-3.543772010353603817e-06,
   3.543772010353567818e-06,-1.968353829824898735e-05,
  -1.943890939479650946e-05, 4.704126012437605500e-06,
   1.910867023353829496e-06, 1.990850539892583110e-05,
  -6.408462522695142922e-06, 1.894549044219261781e-05,
   7.653552944334840024e-04, 2.943319100652101467e-04,
  -2.650355893254113327e-04, 6.909096441582878757e-04,
   9.725652510586698011e-06, 1.747603167894012100e-05,
   5.158714788309918463e-05, 4.731560179567891939e-05,
  -2.032013056618181031e-05, 2.207016750668929224e-05,
   2.310349405885161155e-04,-3.626608005109744574e-04,
  -4.987560222524531150e-05, 1.529186850683286704e-03,
   2.420159577576827932e-05,-3.184780623381012972e-05,
   5.834283142859197430e-05,-1.400407158275408287e-05,
   2.551824291558864367e-05, 3.080291022778546575e-05,
   5.653282967491101748e-07,-1.999200850132109113e-05,
  -1.904729937731514995e-05,-1.487857533046458138e-04,
   9.078807919946064480e-06, 1.782064103091481768e-05,
   4.220786088857042193e-04, 1.584755390563827131e-03,
  -1.838535813756601140e-05,-7.872649246183604491e-06,
   2.159473117830120522e-03, 4.770590497053811422e-05,
   5.168653920699666946e-04,-5.701023136560246939e-05,
   2.576267966035147226e-05,-1.537154308188063985e-05,
  -3.794084038306988851e-05, 3.256520583423991544e-05,
   2.545325682234932842e-05, 4.303639990909471664e-05,
  -2.144818957664168949e-05, 3.376351823913555339e-05,
   2.411934691566112242e-05,-1.379066970975738424e-04,
   9.573036135736965224e-06,-2.398090010386263050e-04,
  -3.722466303016574942e-06,-9.281338514616635038e-06,
   2.148414076999816632e-05, 3.374065345210289213e-05,
   1.144772860179030282e-04, 1.117808167172490641e-04,
  -4.622233601208814753e-05,-3.825566171935364056e-05,
  -5.688349319107894990e-05,-1.908581154628943331e-05,
  -1.374677656075297698e-04,-2.650685607297196454e-05,
  -9.729104434376444673e-06, 2.311823285849640236e-06,
   2.737121556107523156e-05,-1.228073933886527907e-05,
   8.762968762173294741e-05,-6.649088544543157032e-05,
  -6.900972192452378532e-05, 1.173278653602375080e-05,
  -5.452382221929250492e-06,-2.950036488089579425e-05,
   5.368171368665778384e-04,-2.680062715056678239e-04,
  -1.492686858295890306e-05, 1.331122061672311537e-05,
  -1.824991860238071325e-05, 3.559410725115154140e-05,
  -2.679600213068940569e-05, 7.537887150795035589e-05,
  -8.676037646017949478e-07,-9.962292091062619135e-06,
  -5.478288370037491880e-06,-1.923508140182182826e-05,
  -3.361048071054750433e-05,-6.140305844504744817e-05,
   1.620845000641258724e-05, 1.171691718796475378e-05,
   6.165957667098480907e-05, 3.313754071676027797e-05,
  -9.981160004160797780e-06,-6.135511155077831821e-07,
  -1.982310465711277254e-05, 2.654151795424279736e-06,
  -4.692549122177580269e-05, 1.726262649758263118e-05,
   3.006660205799254092e-05,-3.994996171069903232e-05,
   1.013620517463941327e-05, 4.896179474506232986e-05,
   3.993890869538214701e-05,-2.209880589970543485e-06,
  -1.627878589715467487e-05, 1.161899865369637388e-05,
   2.778018303846384466e-06,-2.987109998482637987e-05,
   3.221197249852224330e-05,-5.062004373520875275e-05,
   3.374669582347246795e-05, 2.147464833234822432e-05,
   3.969250739189806763e-05,-4.950238069438431432e-06,
   1.814525296879771044e-05,-8.411289716704448301e-06,
   9.698281637456104533e-06,-2.437895256277793067e-06,
  -2.094930415927060400e-05,-2.147385981239440463e-05,
  -1.942090945325354760e-05,-4.777894516262057211e-06,
  -1.945666861464054269e-05,-4.630123801807220899e-06,
   1.250968462643721192e-05, 2.726733926416511291e-05,
   3.529711416374918531e-03,-2.676945520012046463e-03,
   5.055301939900857340e-04,-2.166546167621319699e-04,
   1.975892758186257626e-03, 2.605522559516056623e-03,
  -1.481181610687284880e-05,-1.343912585015045186e-05,
   7.224659858005348500e-06,-6.914064646510484184e-06,
   3.776421875946195400e-05, 4.662471213302556941e-05,
  -5.299313299892437267e-05,-4.573541138940713377e-05,
  -5.442499034602786079e-05, 4.402181761166584805e-05,
  -1.287737345268800699e-04, 1.783741161043289202e-04,
  -5.826301465607958890e-06, 8.127374190466105366e-06,
  -1.256624618464357874e-04, 1.805794719304857048e-04,
  -1.558060097299624196e-04,-1.087404585792558462e-04,
  -2.184998439882985635e-05, 2.055670649133493460e-05,
  -3.458395167688544676e-05, 2.009851453244374417e-05,
  -1.361931511628650675e-05,-1.464630519152492299e-05,
   4.339584361114101358e-04, 6.957586332398176671e-04,
  -1.146576234142148603e-04, 1.115958305359303717e-04,
   7.423066936491704959e-05,-9.428577689999889200e-05,
  -8.829950214817654480e-05,-8.126006350221592791e-05,
  -2.664960633029937243e-04,-1.377673700264570771e-04,
  -8.527589086806302418e-06,-5.223047421437226313e-06,
  -8.651725283677206592e-05,-6.793206136706038563e-05,
  -1.279753649638956836e-05,-1.536954975344356186e-05,
  -3.495878733472065642e-04, 2.989787932422255769e-04,
  -7.434084965855976019e-05,-5.072906535747939927e-05,
   4.582827139224128466e-04, 2.457172238975279649e-04,
   5.621974553181833959e-05,-8.270030358068580854e-05,
  -6.986753186472804448e-06, 7.154388856590906147e-06,
   1.456886956288160702e-04,-4.257637889322836607e-04,
   2.600555035019427313e-05, 3.039262000854007999e-05,
  -4.446671876671144365e-05, 4.028288621886709487e-05,
  -8.831991738461353211e-06,-5.934640614166750855e-05,
   4.945505452659101957e-05,-7.361900690168895346e-06,
  -5.139169787818210588e-05, 3.096600376538200981e-05,
  -2.096322566308762462e-05,-3.406674580582161636e-05,
   3.454365649512707736e-05,-4.905849361677002091e-05,
   4.905847552974704591e-05, 3.454368218208954248e-05,
   1.847289785145615575e-05, 7.664988256329333241e-06,
   2.065756319380754238e-03, 1.335868986328276470e-03,
  -1.350303732125493182e-05, 1.475357526502632158e-05,
   1.208577027240980263e-04, 7.066410469434637233e-05,
  -4.899486346502286975e-05,-3.463384694260468385e-05,
  -5.381517283928052506e-05,-2.653162588833115357e-05,
   1.260559240726386277e-05,-1.552736423421347120e-05,
  -3.246714721848448898e-04, 6.760831569779900260e-04,
  -6.072778457037831458e-07,-4.999631200016774695e-05,
  -4.957951462134780034e-04,-2.380906822854602723e-04,
   7.278487562962091591e-04, 1.335521918878967106e-04,
   7.331226040821483698e-06, 6.961503519167665688e-05,
   1.999985032573001773e-05,-7.737537332403436588e-08,
   2.659450085586399171e-05,-1.388281398807351040e-05,
   2.097997413104069756e-05,-3.405643383357780687e-05,
  -6.047882212100462766e-05,-6.665067197602647946e-05,
  -8.554380276605735433e-05,-7.954132622783717868e-04,
   2.999806380522962711e-05,-3.408341787032588755e-07,
   6.561767947134640499e-04,-7.093669064429518507e-05,
   1.493668084091411485e-04,-1.376795357585575652e-05,
   1.291802524943042800e-04,-7.623950659276194778e-05,
   6.078121868636870951e-06, 6.973561811979583534e-05,
   1.574304293247812402e-05,-1.233517730825749582e-05,
  -7.533590807642399494e-06,-1.852687263255744282e-05,
   1.323145542277789022e-05,-1.499761939092473681e-05,
   7.827585417200128308e-05, 1.651940233917652070e-05,
   7.991292308653778764e-02,-1.897258416716117099e-05,
  -1.238959273952082781e-05, 5.870688197944779862e-05,
  -9.077347878281178404e-05,-6.837381220837144809e-04,
   4.799429870170988238e-04,-7.397919511924062209e-06,
  -3.690720966888661890e-04,-2.618754371231119541e-05,
  -5.929628960709439186e-06, 2.940815363786573902e-05,
   9.802670615345687526e-05, 1.976777379230702623e-05,
   2.476823147036085414e-04,-2.736718065270670925e-05,
  -1.113085154870655382e-05, 1.661638179028927537e-05,
   4.293711947985555340e-06, 2.969114409563441219e-05,
   2.650688158622007459e-04, 1.176372511469505792e-04,
   7.113811616939980597e-05,-4.645851573477880088e-04,
   3.756257856465701353e-04, 5.749147030122792279e-05,
   3.853034569582777868e-06, 2.975153986948574902e-05,
  -5.839598687823303619e-05, 6.848290820721062171e-05,
  -1.639938116524883226e-05,-1.144815694323247255e-05,
  -3.741284299059256032e-05,-3.317045642377067493e-05,
  -2.997558028431034254e-05, 1.210201065470126390e-06,
   7.969807996501164100e-06,-1.834345007077202325e-05,
   6.252920221835772774e-06, 1.899739426077580207e-05,
  -5.016106054373023432e-06,-2.499496722943466732e-04,
   3.637871728992154714e-04, 2.975884621990514903e-04,
  -1.182856574417421756e-03,-2.526845924142879628e-03,
  -2.154998611301394632e-04, 2.629825276570491683e-04,
   1.957158056759665537e-05, 4.117430519884106753e-06,
  -5.930388964000573139e-05,-9.113104496603828024e-06,
  -2.978905710453959993e-03, 3.505156311525177339e-03,
  -3.553867934223835820e-04,-2.420748377278317113e-04,
  -2.613810398427801000e-03,-2.221012201918462926e-03,
  -2.044972411787296905e-03, 4.775854217088770087e-04,
  -1.910453455920180338e-05,-5.917496030946200058e-06,
  -2.514516826443667969e-05,-1.636216712276116983e-05,
  -5.877406201884461789e-04,-4.818308451941414943e-04,
  -1.696262215124939065e-06,-1.992793753747586007e-05,
  -1.930861407773264900e-05,-2.296034456181319098e-05,
  -6.850833604417160385e-05,-5.836615365482686861e-05,
   4.202305542391153326e-07,-3.999779251760381929e-05,
  -1.116472271678698526e-04,-9.031250725484959215e-04,
   2.999834455322290407e-05, 3.151572085828909714e-07,
  -9.170523014377571756e-05, 6.074661113409645117e-05,
  -2.295671919667536024e-04, 9.898941545690482407e-05,
  -4.417936519249279445e-05,-6.669470512108406179e-05,
   1.989717483597381275e-04, 6.292934477290138646e-04,
   2.058688477852137910e-05,-3.429548330488849025e-05,
  -7.087405354163442467e-06, 1.870210376791272782e-05,
   2.497832194345654384e-05, 1.661575857097825494e-05,
  -8.801464936275192575e-05, 1.879950790717230106e-05,
  -4.514996532995338771e-05, 1.638947242308427907e-04,
  -2.199962857839486967e-04,-1.278374462815186856e-06,
   2.991559931259145724e-05, 2.248759161955230343e-06,
   8.730570845064416551e-07,-1.399972777282729641e-04,
  -1.156694263226727766e-06,-1.996652344253797295e-05,
   1.019532641925615903e-04, 3.764379522849439622e-04,
   1.614343714016196364e-05, 1.180633039100801099e-05,
  -1.312565809504130016e-05, 3.778514390037541234e-05,
   8.083643924341246938e-04,-1.882737609031285143e-04,
   1.251625349135974984e-04, 3.053429872356699004e-04,
   1.406803865705465032e-04, 6.038286419460090924e-04,
  -2.203768162911872108e-05,-2.035535773239083323e-05,
   6.339763934288471777e-07,-2.999330048415103879e-05,
   4.998579901173913362e-05, 1.191594376463467296e-06,
  -4.688437048822762833e-05,-9.950806903926239498e-05,
   8.143036918020716826e-05,-3.832877476746639260e-05,
   3.399236265603834017e-05,-3.666768715177397817e-05,
   2.725319307990308387e-05,-2.927906192058623457e-05,
   2.933414972141913511e-05, 2.719389012483072160e-05,
   6.122560871484956013e-05, 1.585920074830259063e-04,
  -1.399341242497288110e-04, 5.402259592486701459e-05,
  -1.191018493974799067e-04,-1.465433280978756058e-05,
  -3.369145210520192192e-05,-1.666279870101145108e-04,
   4.670300089190819367e-06, 1.944706397060760137e-05,
   1.850053625743590944e-04,-4.327835277283472885e-05,
   1.478966084893457242e-04,-2.503184366660168942e-05,
  -1.375176866746771124e-04, 5.990731050251989616e-05,
   9.910607054335354740e-06, 5.917583854762481250e-05,
  -7.645352459116404136e-05,-1.518382645369350875e-04,
  -5.383293015792796107e-06,-2.951305060996095152e-05,
   1.733242732613674212e-05, 9.979326780108385123e-06,
   4.926610479289172283e-05, 7.584015103614548305e-04,
   2.297480594417719221e-04, 1.076239670055145314e-05,
  -5.588221591937052530e-04, 3.630143790657676709e-05,
  -1.631926102716183406e-05, 1.156208110710856843e-05,
  -9.721934904320164502e-06, 1.747810006025144025e-05,
  -6.392076553745240059e-06,-1.895102523166122786e-05,
   1.895102523166121430e-05,-6.392076553745274787e-06,
  -2.599570515609518496e-06,-9.996620545531562747e-05,
   1.915433282320270673e-05,-5.754262254883720262e-06,
  -9.823310094242268043e-05,-2.940242470940718092e-04,
   1.117297977134273647e-04, 1.778101580419875984e-04,
   8.444703070459262792e-04,-2.810158367739420395e-04,
   2.954741767433411443e-05,-2.696201232805979395e-05,
  -2.679420854910393479e-05, 1.349334607231007197e-05,
   1.773361242762794089e-06, 2.199928525882208523e-04,
  -1.899915543303424290e-04, 1.791447219581814637e-06,
   3.980366368737257491e-05, 3.958327558772519550e-06,
   2.162880571632424623e-05,-8.736243336403525786e-05,
  -2.968756089653927769e-06, 2.985274672923988573e-05,
   9.378752450793090484e-06, 3.888494570481927393e-05,
   6.893870316358956631e-05,-1.214311352670658724e-05,
   4.219989204752632451e-06, 9.065963330599305313e-06,
   1.516450916963758366e-04,-1.303984898854191709e-04,
   1.370949471141259797e-05, 1.456192826372077930e-05,
  -1.897929213736094221e-05,-2.323330518812829473e-05,
  -3.653784733911665010e-05,-1.627838173232851589e-05,
   3.998550335831823363e-05,-1.076810652771116033e-06,
   1.735284366828357278e-05,-9.943782812597565119e-06,
   1.585762778347473835e-05, 4.741872669189642179e-05,
   6.076655141524231821e-05, 5.203293408120200696e-05,
   2.264522223581134821e-04, 7.949459723195994004e-05,
  -1.909413653746958717e-05,-5.950962097717388952e-06,
   4.668092663005119042e-06,-2.963458977090113034e-05,
  -3.564229554844405747e-05, 1.815562634660025152e-05,
  -2.122360055415199802e-05, 3.390514385042185761e-05,
   8.384838495284954577e-05, 5.449264483211247649e-05,
  -1.889783527162056882e-05,-6.547657752715362589e-06,
  -1.161251859785687103e-05,-1.628340909682086195e-05,
  -1.835324281470159186e-05,-7.947230850088884044e-06,
  -9.973822912666226365e-06, 1.733559507218526940e-05,
   4.003162158193384956e-05, 2.995779153276903806e-05,
  -3.959200495464962907e-05, 5.698521182815700903e-06,
   1.547309782655649946e-05,-1.267214439823870372e-05,
  -1.463821239938100947e-05,-4.780923276680570374e-05,
  -1.922123813066292869e-03,-1.765655698952514879e-03,
  -9.251975028318930924e-06,-1.773135522387849012e-05,
  -4.906631542175826278e-06, 8.713493381493169802e-06,
  -1.999348090396116043e-05,-5.106087963799045116e-07,
   3.754210980777910830e-05, 9.268543570152031129e-05,
   3.890388142734979918e-05,-4.567809113663472311e-05,
  -5.927471636057859235e-05, 9.300967711639300498e-06,
  -6.859380615020439678e-05, 1.396029218276542280e-05,
  -7.967044602673710446e-06,-7.960230021989947891e-05,
  -7.791924067869820725e-06,-3.923373445544728111e-05,
  -1.555026770469100880e-06, 1.993945565312966488e-05,
   1.679053448400484561e-05, 1.086636791855697132e-05,
   1.828428158777447676e-05, 8.104631195740576212e-06,
  -2.014970333742943141e-05,-3.455415250608217972e-05,
   2.591561437956163818e-05,-1.511227750307206763e-05,
   9.831457741303956306e-05, 2.079284585334471522e-04,
  -1.356055164348568336e-04, 6.411820266067797826e-05,
  -9.962093529158825891e-06,-8.698807483166078576e-07,
   3.691500104899908487e-05,-3.372362224839431963e-05,
   3.372362224839425186e-05, 3.691500104899915263e-05,
  -1.148778680934125036e-05,-1.637164482338672279e-05,
  -1.233268930642695506e-05, 4.845518315382929780e-05,
  -2.907310989229759088e-05,-7.399613583856119167e-06,
   8.906542956211087970e-06,-1.790735861508242326e-05,
  -4.310646723974563901e-04, 4.028439501976833993e-04,
  -3.004228547265268105e-04,-3.214748953774838316e-04,
  -7.075794732544585467e-06,-7.066337729184355416e-06,
   6.834389850231854661e-05,-5.855861625333014882e-05,
  -1.169749095959210160e-05, 2.762550823514856401e-05,
   3.903907750222001790e-05, 4.556259900154576098e-05,
  -2.031802102008738810e-05,-4.568564349801026281e-05,
   3.654851479840818314e-05,-1.625441681606997824e-05,
  -3.568222281273079172e-05, 7.160152913969529756e-05,
  -7.158825291049437922e-05,-3.570885107677219207e-05,
  -1.952885790813280599e-05, 4.315519528858470561e-06,
   6.572031684112094056e-05,-6.148853514520147268e-05,
  -1.491290443543653248e-07,-9.998887964575359897e-06,
   9.057771389601252990e-06,-3.896096479110497114e-05,
  -3.070862791986506699e-04,-4.240303206055407500e-05,
  -2.784703336093587341e-05,-1.115987154921258886e-05,
   2.463885403585110287e-05,-1.783057118316741659e-04,
   5.018557335166613364e-05,-8.649513412536301510e-05,
   6.056048027177287343e-06, 1.906106718661161676e-05,
  -8.982096308751535421e-05,-9.397975627778145042e-05,
  -2.339963459407723870e-05,-1.877384086604719620e-05,
  -3.793163942801532431e-05,-1.269609114267195858e-05,
   1.530620753750613078e-05, 1.287322845360830733e-05,
   4.138777746896013087e-06, 9.103324599386665165e-06,
   9.615189165258535893e-06,-2.747387361893999596e-06,
   1.993822083333529930e-05, 1.570780061356256602e-06,
  -8.619942114525500437e-06,-2.873493688773702076e-05,
  -2.694598988440359951e-05, 1.318763167326184305e-05,
  -6.600955377504438833e-06, 7.511816564866000732e-06,
   2.900712036701688597e-05, 7.654212435867863842e-06,
   1.392894719875876794e-05, 1.435215767521351867e-05,
   9.964263110066984055e-06,-1.734109168055339984e-05,
  -5.092627156970595229e-05,-3.172561841806333230e-05,
   7.733411868947952478e-06,-1.844435796836569203e-05,
   1.057401507963228475e-05,-1.697616579489341350e-05,
  -1.715226013316013094e-05,-1.028591135118350656e-05,
   8.111492472686177132e-06,-1.828123873990916240e-05,
  -1.673292914223719756e-05, 2.489998157270139844e-05,
  -1.130434386284261101e-05, 1.649884268155232185e-05,
   3.301391505176037432e-05,-3.755105075700478691e-05,
   2.253063391141162645e-05, 1.980834509871908571e-05,
   7.932473299204195597e-06, 1.898343379564335076e-04,
   8.353787122090209900e-06,-5.496748194960342606e-06,
  -2.906878995555634175e-05,-7.416565951958272204e-06,
   9.990324573356348427e-06,-4.397896303829002683e-07,
  -3.377074197389439033e-05,-3.687189968706044041e-05,
  -3.687189968706062337e-05, 3.377074197389419381e-05,
  -5.397796621421991833e-03, 3.797866721432615906e-03,
  -2.286691572297429333e-05,-6.615968685928304727e-05,
  -8.173293572267828570e-06, 1.825369201508356210e-05,
  -1.977955302065862291e-05,-2.961297401976770571e-06,
  -1.012897138187086695e-05, 7.935618399813112057e-05,
   9.316531476306190459e-06,-3.633488853842271916e-06,
   1.517031751039471951e-05,-2.588168206731957045e-05,
  -2.762483306990345442e-06,-1.980829841199389067e-05,
   1.980829841199389406e-05,-2.762483306990341631e-06,
   2.745366950267824125e-05,-1.209528961363533015e-05,
  -1.209528961363532846e-05,-2.745366950267824125e-05,
  -3.400609825712910339e-05, 2.106146436804623380e-05,
   2.582766444974735767e-05, 7.571612608335993042e-05,
  -5.424114914731884722e-06, 8.401129530710923319e-06,
   3.811886433508556994e-06, 3.981795476688918830e-05,
  -3.981795476688918830e-05, 3.811886433508559535e-06,
   1.730126430707355811e-05,-1.003325736621873850e-05,
  -6.877144968968031862e-06, 7.259812468362920003e-06,
   1.891721398233142199e-05,-6.491457089643637576e-06,
   1.616562223580743008e-05,-1.177593553519925098e-05,
  -8.172341245359066681e-06,-5.763058091794931581e-06,
  -4.881354080553355450e-06, 6.982959531846266959e-05,
  -9.677646622166998714e-06, 2.518562259794208489e-06,
   2.302731242607916002e-06, 2.991149325634407996e-05,
   9.018773009552153436e-06, 1.785109894102247129e-05,
  -3.548462553635929124e-05,-1.662553498403716509e-04,
   2.937684478831751702e-06,-1.978307382341862059e-05,
  -2.967461073512792411e-05,-4.406526718247674775e-06,
   6.493166451802890649e-05, 2.310495162144213233e-04,
  -1.519846558020420728e-05,-1.300025553623266421e-05,
   3.705487941001707637e-07,-1.999656704515029911e-05,
   4.108611294275124379e-06, 1.957343386410659877e-05,
  -9.174196131457700839e-06,-3.979211648247246228e-06,
  -1.590473685061280928e-06,-9.872709529664468216e-06,
   7.316757325400183334e-06,-4.946175352978504365e-05,
  -7.124216658088857552e-06,-4.948985286913479205e-05,
  -9.903284096807795441e-05,-1.387430754277060762e-05,
  -9.999998592441609890e-06,-5.305767224989338795e-09,
  -5.999708566317992717e-05, 5.913644604216720610e-07,
   2.489379265851318830e-05,-1.674213508113451038e-05,
   1.674213508113446972e-05, 2.489379265851321879e-05,
  -1.265244875594911494e-05, 1.548920722561622084e-05,
   3.999682521991339350e-05,-5.039566724435658681e-07,
   3.466023752033626482e-06,-2.979910534479749822e-05,
  -9.912935929194023683e-06, 1.316700901379747546e-06,
   2.045975920263220019e-04, 1.761812286738593072e-04,
  -1.692811754194143876e-05,-1.065076694356864858e-05,
  -4.233329615157964176e-06, 9.059741738561124863e-06,
   6.188175404663766982e-05, 5.070156325116064556e-05,
  -1.913856031414432071e-05,-5.806505756637122443e-06,
   2.741048209097344458e-05,-1.219284509622032817e-05,
   1.332760493012816708e-05,-1.491224150912341677e-05,
   1.900103395095360716e-03, 2.799324297744015485e-04,
  -5.406291483791589703e-07,-1.999269166780508658e-05,
   1.990251974974334933e-05, 1.972234167404069762e-06,
  -9.829323833859710080e-06,-1.839671973238016277e-06,
   1.826689187310993220e-05, 5.715173366833337700e-05,
   1.491367807006398400e-04,-1.606924522960727930e-05,
  -2.714770007236932370e-05,-1.276723857303053086e-05,
   1.756073128833224450e-07, 1.999922903693194691e-05,
   6.103551225035524443e-06, 2.937254947128981061e-05,
  -3.981479766941741811e-05,-3.844721907154496866e-06,
   2.551654315400961521e-04, 2.949416934700085837e-04,
   1.870262877470929254e-05, 7.086019821833411187e-06,
   1.678949710657254453e-05, 1.086797068952581502e-05,
  -2.613119050283236854e-05,-1.473637957249620722e-05,
   1.993851024898621538e-05,-1.567102118903469327e-06,
  -1.567102118903503420e-06,-1.993851024898621199e-05,
  -2.861066056063717335e-05, 9.023862935794213692e-06,
  -8.900507608379467606e-06,-4.558614297478920420e-06,
   1.966230380477428850e-05,-3.659755331816411383e-06,
   8.563475024784680600e-06, 1.807392861278059497e-05,
  -8.313677923489861367e-06, 5.557225871284820186e-06,
  -7.988881547904929289e-06,-6.014796057518837310e-06,
   3.745382787100015629e-06,-1.964617285320718567e-05,
   7.876020447871960928e-06,-6.161842411544032986e-06,
  -5.135264660384242001e-06,-4.973559144986424053e-05,
   1.550824922843959904e-04, 2.086849793033994371e-04,
   7.740340357085064127e-06, 1.844145143844378489e-05,
   1.932441035483350761e-05,-2.294705132338365573e-05,
  -7.640002004974592487e-06,-6.452160054120187170e-06,
  -1.898527251632131261e-05, 6.289628564630399777e-06,
  -9.626739780272424826e-06,-1.753071251269954693e-05,
  -9.998309694456290999e-06,-1.838566119054481989e-07,
  -9.399362904849262616e-06, 3.413499228496123892e-06,
  -1.769674498992559604e-05, 9.318004977544461906e-06,
   1.944724195516498482e-05, 4.669558901788352235e-06,
  -4.303045365453987905e-06,-1.953161029159769405e-05,
   1.982934218099801588e-06, 9.801427033176799490e-06,
   6.440135908419864698e-06, 1.893474714595051451e-05,
   1.416759375633947673e-06,-1.994975671208933283e-05,
  -1.996858568788392290e-05, 1.120529172149221427e-06,
  -4.616259707563653642e-06, 8.870746660362042953e-06,
  -5.196609005336347348e-06, 8.543726051650836178e-06,
  -1.791923595008816476e-05, 8.882622527444696071e-06,
  -9.863311260921151560e-06, 1.647753309869542696e-06,
   1.783805764598744129e-05, 9.044539757136848849e-06,
  -1.709035062686420668e-06,-9.852877709304447003e-06,
   4.368970124855776503e-06, 8.995115343791746190e-06,
   1.960035946710841516e-06, 1.990372475411578381e-05,
  -1.464891176551124691e-05,-1.361651145067143266e-05,
  -3.027897271275731291e-05,-2.984680616271363665e-04,
  -9.783483117655733169e-06, 2.835989171500034628e-05,
  -5.387001964449413845e-06,-2.951237384276327949e-05,
   1.863531772433484664e-04, 2.351010279248245461e-04,
  -1.377639466269264113e-05, 1.449865338911630609e-05,
  -1.206510976026440327e-04, 6.183391566505207649e-04,
   4.088812070636981552e-04,-3.212727167223092110e-04,
   1.234333943277043697e-06,-9.923528592011722409e-06,
  -1.845487210877381812e-05,-7.708287452398375868e-06,
  -2.950679276491969454e-05,-4.036519764262381512e-05,
  -1.843570317441624239e-05,-7.754021438248607400e-06,
  -1.435428311881832690e-05,-1.392675684230924087e-05,
   1.467970696285188463e-05,-2.616306945839493782e-05,
   5.749092911992052053e-05,-5.563086435539426673e-05,
  -1.102800200516608673e-05,-1.668481860177247619e-05,
   9.637343434911856214e-06, 2.668634766610328179e-06,
   7.426514436181332202e-06,-2.906624990137513916e-05,
   2.016088541120860482e-06, 9.794661147500773705e-06,
   6.153595551853254722e-06, 7.882465463559726248e-06,
   1.234595924593426920e-05, 1.573458897771817152e-05,
   1.334088165133815934e-05,-1.490036498764338657e-05,
   2.264621744948470939e-04, 1.646659756083976539e-04,
  -3.994678978922427509e-05,-2.062519220644363372e-06,
   1.433689164227176700e-05,-1.394465983944241058e-05,
  -1.437623354008734668e-05, 3.732725424138330736e-05,
   2.984519813433844423e-05, 3.043706346230059352e-06,
  -8.969125893272775985e-06,-4.422078777071236285e-06,
   8.628596546983222958e-06, 5.054435836904967696e-06,
   9.947932655569902035e-06, 1.019134868526221943e-06,
  -1.888565826165541247e-05, 6.582697928962465530e-06,
  -1.729047107212157631e-05, 1.005184610427989823e-05,
  -1.956995479325237733e-05,-4.125150832400971273e-06,
   2.970573928311470385e-05,-1.162650809729370811e-04,
   4.424590581393113991e-05,-7.837282576700126070e-05,
  -2.034588642531655366e-04,-5.200471667850875345e-05,
   8.589643356996676601e-06,-5.120354186929150004e-06,
   1.937286450290091677e-05, 4.969116717510439807e-06,
   1.479482028492907200e-05,-1.345783387981332262e-05,
   2.905259748543521779e-05, 2.749448270743211215e-05,
   8.980076938573405509e-06,-4.399797515488880507e-06,
  -1.979211002396957260e-05,-2.876174681601109258e-06,
   1.861090925238345825e-06, 3.995668080018653829e-05,
  -7.153698337800060745e-06, 6.987460203232406535e-06,
   1.282686677016644485e-05,-1.534508028197962472e-05,
  -1.026900309427252339e-05, 1.716238839584460253e-05,
  -2.289381373501993369e-06, 1.986853625526204185e-05,
  -1.691347626116681308e-06, 1.992835525595701304e-05,
   1.130651892953235456e-04, 4.020277315823690846e-05,
   5.302898843372167447e-06,-8.478163943741719389e-06,
   1.446051314972643666e-05,-2.628485418347586823e-05,
  -2.166942424720507512e-06, 2.992163699612617223e-05,
  -1.124082501045814938e-07,-1.999968410713800641e-05,
  -8.236420689703446055e-06, 5.671099912911518735e-06,
  -4.905538397080378484e-05, 9.673122736583434676e-06,
  -6.974990964769359146e-06,-7.165856616021969108e-06,
   4.681428698909144498e-06, 8.836527900540451914e-06,
   5.542014052962821703e-06,-8.323826057574881904e-06,
  -1.128579515009356833e-05, 5.892903213043740752e-05,
   1.907005723379675470e-05,-6.027679246585380451e-06,
  -3.589765286285972763e-04, 2.712659016098232308e-05,
   9.918178036817156950e-05,-1.276614440619317262e-05,
   2.336305454620286445e-05, 3.091183716349954458e-04,
  -2.978959639243083211e-06,-3.988891825391810181e-05,
   1.994374036090751790e-05,-1.499073185908049603e-06,
   1.342802259801222442e-05,-1.482188277875901555e-05,
  -2.516285741192184785e-05,-7.593965108470864119e-05,
  -1.998675534520980574e-05,-7.277436160677471426e-07,
   1.100370421833786540e-05,-1.670085307627528241e-05,
   4.172180195953182158e-06, 1.955998242362441596e-05,
  -1.695719997754427315e-05,-1.060440327984430147e-05,
   5.755477001632319517e-06,-8.177682097249896139e-06,
   4.975214491417765143e-04,-4.972331086992008866e-05,
   2.170539398606277165e-06, 9.761596115343941377e-06,
   1.979661121023295028e-05,-2.845028047467915468e-06,
  -9.984051539089701968e-06, 5.645483724186773546e-07,
   2.178432094579527162e-06, 1.988100685602481996e-05,
   6.666823819707828549e-06, 2.924984547236064087e-05,
   3.899964346784457012e-05,-8.889758679571031208e-06,
  -1.771649612682638678e-05, 9.280396811998167857e-06,
  -1.646857496733795736e-05,-1.134839365483809898e-05,
  -1.003691218617693199e-05, 1.729914430736309846e-05,
   1.061166758535585686e-04,-5.602902021087625506e-05,
   2.115177806580485497e-06,-9.773741496814276365e-06,
  -1.460749026781884947e-05,-1.366093803790858573e-05,
  -1.164780474838829596e-06,-9.931932664161303501e-06,
   9.999306326771069758e-06, 1.177836295758989402e-07,
   9.163731249423550559e-06,-1.777712095892747103e-05,
   1.430989360390361620e-05,-3.735273678119126444e-05,
  -7.302030918852338987e-03, 5.432801531269292571e-03,
   5.811212423731190063e-05, 5.498164254209970096e-05,
  -7.730139240406899324e-06, 6.343890551067339620e-06,
  -2.970926731299267380e-05,-4.166465615500151926e-06,
   2.225698059107752242e-04, 2.955717873830989405e-04,
  -7.793514947470067493e-05,-1.040486063162599932e-04,
  -9.992688436488336555e-06,-3.823320693746646400e-07,
  -1.426728141419808108e-06, 9.897699066474024957e-06,
   2.903111223641494586e-05,-7.562706018131241875e-06,
   5.997666296134285118e-06, 1.907951778741315331e-05,
   6.912665028137825485e-06, 1.876739359124650377e-05,
  -1.052090653964429946e-06,-9.944501257269803754e-06,
   7.370618779130581813e-06, 1.859230966858952877e-05,
  -1.995419501552556077e-05,-2.240156470611762623e-05,
  -3.475855683039774180e-04,-1.535717184471185805e-04,
  -3.540954472495235682e-06, 1.099429926890464277e-04,
  -3.953708754253789341e-05,-6.067842174422064284e-06,
   2.398723441030486774e-04, 7.826783152011146155e-06,
  -4.573155971648285131e-04, 6.194856290421725401e-04,
   2.362763118097542850e-05, 1.848607705208971021e-05,
   9.930346554215361223e-06, 1.178226342085055927e-06,
   1.312501756103364857e-04,-4.871746506393605935e-05,
  -1.999779993914176375e-05,-2.966438842479675142e-07,
  -9.994273287606411584e-06,-3.383806327745901959e-07,
  -6.423627042851626332e-05,-6.303730293591666722e-05,
  -9.444226875071431464e-06, 1.762970727868669161e-05,
  -1.200085677465398518e-04,-8.998857520499004979e-05,
   4.706728436693835602e-06,-2.962847798020036005e-05,
   7.864617336574561342e-06, 1.838879534252450341e-05,
   3.058651762711399774e-05, 2.577721744964426974e-05,
  -3.639932281922234411e-06,-9.314015942815451868e-06,
   1.242097584855902461e-05,-1.567543807903031154e-05,
   2.311199149802897301e-05, 1.912683583332686350e-05,
  -3.135087615806060954e-05,-2.484195169711806277e-05,
   1.316610533305674422e-05, 1.505502143335753768e-05,
  -1.528630444238056544e-05,-2.581334725476059274e-05,
   3.325437179500521424e-05,-3.733827468589786847e-05,
  -9.436610505620423561e-06, 1.763378524779107880e-05,
  -2.609836457099305707e-05,-1.479443701935070118e-05,
   2.080551169711081190e-05,-3.416329438185646824e-05,
  -1.510792578757885921e-05, 1.310536448928490394e-05,
  -1.533385060410049180e-05,-1.284028915761351027e-05,
   1.343644612414412502e-05, 1.481424704644054454e-05,
   2.432504659277951221e-05,-1.755824900891617856e-05,
   2.962849878308516883e-05,-2.687288707714005547e-05,
   8.633072305071311911e-06,-1.804078885679367278e-05,
   2.829930904951077987e-05, 9.957364476621175892e-06,
  -8.819900734305018630e-06,-4.712679814819357460e-06,
  -9.998410243616390802e-06, 1.783047961969476626e-07,
   2.542988358289066466e-05, 1.591606172897767766e-05,
  -4.161925331516026451e-06,-9.092765120406730926e-06,
   4.666660127484905640e-06,-8.844336224643575923e-06,
  -9.950864080663663892e-06,-9.901030492618960237e-07,
   1.903343381718478693e-05,-6.142344595254050302e-06,
   8.641600965680745546e-06, 5.032169785484749176e-06,
  -5.424343163943381963e-06, 1.925036366513060927e-05,
   9.670972573445404399e-06, 2.544069473042507962e-06,
   5.916765943586326009e-05,-9.959321105462033065e-06,
  -2.427720339034360575e-06, 9.700833673217931422e-06,
   1.761429250510077266e-05,-9.472945663559502230e-06,
  -8.999729730658882843e-06,-4.359456935799987567e-06,
   9.163347743550795957e-06, 4.004130134094365147e-06,
   1.876530495066826420e-05, 6.918332899508752042e-06,
  -8.892462763110252043e-06, 4.574287486231883005e-06,
  -1.385350765444936244e-05, 2.660977876022484044e-05,
  -9.973414384590928899e-06,-7.287012510176982162e-07,
   3.144437345909986728e-06,-9.492761125070333693e-06,
  -8.724281511822699393e-06, 4.887423871782420300e-06,
  -1.939837153396725363e-05, 4.868591359948895391e-06,
   7.079733481034124379e-06, 7.062391509787916758e-06,
   9.371706356959455571e-06, 3.488713223944575940e-06,
   1.985910964059546879e-05, 2.369760385103985926e-06,
   3.382183641615918149e-06,-2.980873754143884805e-05,
  -9.985305132318668525e-06,-5.419238087503434160e-07,
   1.089998879111094727e-06, 9.940417619171569284e-06,
   1.162038844048776831e-05, 1.627779384597858716e-05,
  -1.731233754940209160e-05, 1.001413843401230638e-05,
  -9.923983494793059827e-06,-1.230671196979496663e-06,
   1.586291520632990545e-05,-1.218063714083904410e-05,
  -8.232600586650190929e-06, 5.676644042098020651e-06,
   9.476971637287025149e-06,-1.761212674795572172e-05,
  -1.970133203539995795e-05, 3.443474412700555619e-06,
   9.687879920662436549e-06,-2.478907550278063301e-06,
  -2.990365162735260675e-05,-2.402419478345088212e-06,
  -9.948943599426009313e-06, 1.734988533839461282e-05,
  -1.307199457933578110e-06,-4.998290937487711444e-05,
  -1.160816574786952382e-05, 2.766316120709975517e-05,
  -1.875412571363090433e-03,-1.312542843997135239e-04,
   1.449920187431118958e-06,-1.994737404898398685e-05,
   5.163577969327053837e-06,-2.955228354213393599e-05,
   2.718156330957855625e-06,-9.623493448871555620e-06,
  -6.969686247435898541e-06,-7.171016218940166548e-06,
  -1.037823345913710247e-04,-6.024306621317274075e-05,
  -9.369378036720535667e-05, 5.763224375730903535e-05,
   9.155594857566014537e-05, 2.000437641910777771e-04,
  -5.976612632225739279e-05, 5.292461094044283991e-06,
  -3.044409207056973654e-03,-1.558195295842831419e-03,
   1.362281852213469407e-03,-2.661632610848055878e-03,
  -2.726976591281390740e-05,-1.250439391015545279e-05,
   8.336262606770301298e-06,-1.817984394187594052e-05,
   5.566116507052691143e-04, 3.158852169683722122e-04,
  -2.912067739501588066e-04, 5.131263146687578807e-04,
   1.961832886846663973e-05,-3.888595171612558007e-06,
   4.927256179688849326e-06, 8.701847306159656107e-06,
  -7.793836295376465356e-06,-6.265470118105461325e-06,
  -1.364256796859423882e-05,-2.671853924192500531e-05,
   4.708467784460090670e-04, 6.713444058208981957e-04,
   1.379184267849008971e-05,-4.216084755648314309e-05,
   7.602086555826963752e-04, 1.871492131957051396e-03,
   1.363382259711268454e-05,-2.672300285129759916e-05,
  -2.672299809219409088e-05,-1.363383192519957144e-05,
   3.703999365571610094e-05,-1.510095592949370717e-05,
  -9.999806994014183694e-06, 6.212956192524293720e-08,
  -1.851339819846449094e-05, 7.566643056540451932e-06,
   1.621701376923001200e-06, 9.867628116426259278e-06,
  -1.843913038084873027e-05, 7.745867982225197189e-06,
   7.745867982225195495e-06, 1.843913038084873027e-05,
  -5.781024296982642503e-05,-6.897808208242408516e-05,
  -5.364959585458839485e-05, 4.496355040073382251e-05,
  -8.476497595019604503e-06, 5.305562036356457302e-06,
   1.331607320125901247e-06,-9.910944553622884728e-06,
   9.856821039520383154e-06,-1.686143230828370429e-06,
  -5.591457028342616497e-06,-1.920248963807032010e-05,
  -2.880746237001511909e-05,-8.374372322757268628e-06,
  -1.755210754402902750e-07,-9.998459498946640108e-06,
  -1.962007633244016035e-05,-3.879768641197770083e-06,
  -3.860781807233097836e-05, 1.046118462191513599e-05,
  -3.412987970696521674e-05, 2.086028070731753189e-05,
   1.042728392784919365e-05, 1.706668538082360012e-05,
   9.031020077325698886e-06,-4.294260863401307826e-06,
  -5.621036450359164936e-05, 2.845002546964999781e-04,
  -7.526718772425796886e-05,-4.934420383470900667e-05,
  -3.837882520477367185e-05, 5.854114600775618595e-05,
  -1.289933762688252232e-04, 1.107280853206144933e-04,
   9.121184272349143138e-05, 1.062092262799473611e-04,
  -2.002424714544935255e-05, 2.233896878233110217e-05,
   6.727247904717400342e-06, 7.398928005358301134e-06,
  -2.563550646698651638e-06, 9.665826818322939293e-06,
  -9.889384809456116209e-06,-1.483262650543941569e-06,
   1.888560025978811954e-05,-6.582864333061333028e-06,
  -1.627595143120940158e-06,-9.866657693975663018e-06,
  -9.903904312713936338e-05,-1.503039185665518021e-04,
  -1.419536518925983615e-04, 9.353694839129084106e-05,
  -5.241855945377126507e-06, 8.516040526436830261e-06,
   1.501790173905041401e-05,-1.320843016244650534e-05,
  -1.359147995239910364e-05, 1.467213933629085170e-05,
  -9.074076587364406066e-05,-2.221848631402790033e-04,
  -2.036707208759008358e-04, 8.317594278330060862e-05,
   8.552588967805504160e-06, 5.182009450760543130e-06,
   3.466569946614722741e-06,-1.969728135569037472e-05,
  -1.077433610312537632e-04,-1.314966469294518380e-04,
  -1.237614438595725601e-04, 1.014056458674460280e-04,
   1.905333164133849477e-05, 6.080341550042183294e-06,
  -6.344643511723433230e-05, 1.018555343165729673e-04,
   9.336757312352491852e-05, 5.815923219079864164e-05,
   7.255332187647042318e-06, 6.881871463990940087e-06,
   1.222318865289107363e-04, 1.032442052397300263e-04,
  -1.451971280753026513e-05, 1.375419717711076204e-05,
   9.678870236462160462e-05,-1.145947079693154363e-04,
   1.244474175635023489e-06,-9.922262041801634214e-06,
   1.054692468606671375e-04, 1.539367030807461340e-06,
   1.101382180843804036e-05, 6.912811099091290500e-05,
  -1.676267534805849226e-05,-1.090929489818623016e-05,
   1.540586914948646115e-05,-1.275379142643086343e-05,
  -1.275379142643087528e-05,-1.540586914948645098e-05,
  -5.714115586959726928e-06, 8.206636525328992420e-06,
   1.733359313750504915e-07,-9.998497619887417793e-06,
  -2.872682715830897181e-05,-2.783467983319805206e-05,
  -1.787451220798410114e-05,-8.972280274636285080e-06,
  -8.972280274636286774e-06, 1.787451220798410114e-05,
   1.950834181340385854e-05, 4.407334760532571140e-06,
  -2.982171508087880932e-06, 9.544980518384983188e-06,
   7.399393084852515625e-04, 9.477328651451828278e-06,
   7.043960484187203639e-06,-5.499548914417411302e-04,
  -9.376118756345135181e-06,-3.476837221802736222e-06,
   1.046572905980469798e-04,-3.386519636257772975e-05,
  -1.847216440893502569e-05,-5.708571749614148625e-05,
  -2.854551127502624112e-05,-9.227880907735528336e-06,
  -3.940202450545667793e-05,-6.890607003116042488e-06,
   9.214826220233871820e-06, 3.884195892445480819e-06,
  -6.890607003116045029e-06, 3.940202450545667793e-05,
  -1.842965244046774364e-05,-7.768391784890965027e-06,
   5.782886002990138974e-05,-1.599446615683291161e-05,
  -1.181855971900331604e-05, 1.613448623812832518e-05,
  -2.775884989281364145e-05,-5.319253944519137189e-05,
   6.399337261738628226e-05, 6.328387046516953255e-05,
   8.602426615069419101e-06, 5.098848530045317813e-06,
   2.654449767995658170e-06, 9.641260105877645498e-06,
   6.385545406246685663e-05, 2.867892931188652342e-05,
   7.141154269245320247e-05,-5.477583016517353925e-05,
  -6.694768846594468929e-05,-8.728119504834255566e-05,
   1.995935787429164968e-05, 1.274375629848574792e-06,
   1.284074320092288245e-04,-1.786379898140238120e-04,
  -1.948907396109732953e-04,-1.400628416600484749e-04,
   2.776613634236863712e-05, 1.135965107813596535e-05,
   7.573100718757311645e-06,-1.851075756157909141e-05,
  -1.246527930554440402e-04, 1.404479149429950328e-03,
   1.235147538650661425e-03, 1.095926902909707772e-04,
   2.969169079815946974e-05,-4.289929783398824127e-06,
  -6.197468771671281938e-06,-8.978636522782375729e-05,
  -7.981010242473223924e-05, 5.508861130374486951e-06,
   2.741113724611449936e-04, 1.321878570628735091e-03,
   1.184794695487195694e-03,-2.456858350524156599e-04,
  -6.709273889417146485e-07,-1.998874324310480338e-05,
  -1.998874324310480338e-05, 6.709273889417134838e-07,
   2.702082465338837957e-03, 2.070032620718537304e-04,
   1.909624188854718333e-04,-2.492696001235090563e-03,
  -2.481921550141751324e-05, 3.136887855652791771e-05,
   2.352665891739591796e-05, 1.861441162606315526e-05,
   4.592969826390211926e-04,-2.542207188036923240e-05,
  -1.941000394681982223e-05,-3.594763577021226541e-04,
  -1.592940441881815595e-05, 1.209355509607231404e-05,
  -1.182654847048984512e-05, 1.612863141358107685e-05,
   2.292345843077129398e-05,-9.733712063530902702e-05,
  -8.760340857177811619e-05,-2.063111258769416865e-05,
   3.557511164206105138e-05,-3.682857741369531513e-04,
  -2.986092412393635820e-04,-2.885344080784027878e-05,
   1.988444736813613220e-05, 2.146800611101116807e-06,
   4.860615788673593407e-06, 8.739245628479440166e-06,
   1.148011893036282615e-04, 1.253821635419987096e-04,
   7.374779002039262132e-05,-6.753712658314743416e-05,
   9.050605713233420341e-06,-4.252826850882433797e-06,
  -3.713945847221813474e-05,-1.485464992486812691e-05,
  -1.485464992486812860e-05, 3.713945847221813474e-05,
  -1.357737730669808757e-04,-3.413916441795218024e-05,
  -2.682588208660364790e-05, 1.066788266258850355e-04,
   1.160872288692085802e-04,-7.825442667011229994e-05,
  -4.472422471418010544e-05,-6.633056402380069715e-05,
  -4.591577600416980707e-05, 1.979246103785236823e-05,
   2.374927994996166593e-05, 5.509965246585815890e-05,
  -3.872970987378814391e-05, 9.219549649029608112e-05,
   6.453388509711006536e-05, 2.711784789161917429e-05,
  -4.733493879224728011e-05,-9.929452940386093393e-05,
  -5.415736238130443113e-05, 2.582595786994302560e-05,
  -1.547780688769295380e-05,-2.569897846116231654e-05,
  -8.607250589304978072e-05, 2.629683876991515036e-05,
   1.169294528693853755e-05, 3.825277807580335749e-05,
   1.934994572636198639e-05,-2.292552290323702851e-05,
   8.986068027567760665e-06, 5.932327183664033650e-05,
  -1.971778136181642283e-05,-2.260993361705435962e-05,
  -8.451097674721627282e-06, 5.345928178746393861e-06,
   5.931631477376738902e-06,-3.955775205969866323e-05,
   3.988974722748163709e-06, 9.169955324933497663e-06,
  -2.868563052264124356e-05,-8.782630671872363013e-06,
  -1.293099093244131696e-05, 2.707008447539683147e-05,
   2.485772513057526786e-05, 1.679563935468867251e-05,
  -4.638471562305550729e-06,-1.799402250236607987e-04,
   2.029113712299180039e-05,-2.209682679155412156e-05,
  -2.533960806735687887e-05,-3.095002848129130014e-05,
  -1.997337936796876457e-05,-1.031560285780575201e-06,
  -1.277540647202851820e-05,-2.714385730647823669e-05,
  -4.293582430109351642e-05, 2.562254849903942405e-05,
   2.269685998034775234e-06, 9.739020765473544881e-06,
  -2.928159583961393539e-05, 6.525959323004085033e-06,
  -6.706669959038763940e-04, 3.251554363778233047e-03,
   1.224246076690217830e-04, 6.791329352259458827e-05,
   1.851628402809880485e-06, 9.827078521000417392e-06,
   2.980485267090982892e-05, 7.424062740350030837e-05,
  -9.391800249416005800e-06,-1.765769203704350209e-05,
  -2.314322350067521728e-05,-1.908903365804027262e-05,
  -1.999768305573076330e-05, 3.044214226016453771e-07,
   1.878370501113329409e-05, 6.868218550302986546e-06,
   1.017189943011629065e-05,-1.722011794337076926e-05,
   1.848659958248418170e-04,-4.386984827520569642e-05,
   7.530189163797499407e-06, 1.852825548068211435e-05,
  -7.861519260150694633e-05, 7.693927145631135767e-05,
  -9.921069283872550911e-06,-1.253947472823559140e-06,
   2.946103620627010686e-05, 5.661037506751033608e-06,
  -1.216412238385304404e-05, 1.587558271782946038e-05,
   1.078042613420307222e-05,-1.684584258400248353e-05,
  -1.915464695593757625e-05,-5.753216491093601408e-06,
   2.667878291203612353e-06,-2.988113828861485365e-05,
  -2.490561545942783462e-04,-2.969574217267302238e-03,
  -2.961309966998933261e-05, 4.802533491322868435e-06,
  -6.088995068074004381e-06,-2.937557044656274429e-05,
   5.356222153916935886e-06, 8.444577208948322755e-06,
  -1.161424916728055512e-04,-3.018147822808375547e-05,
   2.295471167244095666e-05,-3.275791831046507608e-05,
   6.155149476499691901e-06,-7.881252116380086322e-06,
  -3.193314466881879668e-04,-2.067431150072444800e-05,
   2.759377197204229188e-05,-1.177215988486961430e-05,
  -9.096502914873446236e-06,-4.153749477243291100e-06,
  -1.718460892121620280e-03, 4.083110598826410371e-03,
   1.004832361770876051e-04, 4.475622020881157002e-05,
   5.937737486296982534e-05,-8.046320497210113286e-05,
  -4.700471390387320971e-06,-8.826413128114403737e-06,
  -8.098372988871206521e-06, 3.917162691200253656e-05,
   1.740988224441828724e-05, 9.843576597735646203e-06,
   2.168727136887538756e-06,-2.992150769272376858e-05,
  -4.754239912286257417e-05,-1.942671364015088507e-04,
   3.448482959916356636e-05, 2.026811603274099850e-05,
   7.254024844611248029e-06,-6.883249490884575321e-06,
   9.350742883604301172e-06, 3.544517953787727847e-06,
  -1.997045582045255010e-05, 1.086689616842358313e-06,
  -1.196588549499011292e-04, 9.042036942997078440e-06,
   2.914334369011609689e-06, 2.985810870074656579e-05,
   1.569097230950826765e-05,-1.240134621653007502e-05,
  -3.114724179985786504e-04, 3.124513551391018985e-03,
   9.857834517865480097e-06,-4.901859951710554631e-05,
  -1.771194438662178111e-05, 9.289081011877180937e-06,
   2.311820682947614970e-08,-9.999973277389944659e-06,
  -9.052114524479415854e-07, 9.958945337050359586e-06,
   8.966017884021737697e-06, 4.428377050726640977e-06,
   1.937650504439322402e-05, 4.954901842075581911e-06,
   1.418679528478097676e-05,-1.409733448378509318e-05,
  -5.387909679092359384e-06,-8.424394891619389845e-06,
   2.201681894553854640e-03,-5.100949276298959644e-04,
   2.274360992086044551e-05,-3.290483562894272533e-05,
   7.160663918966975019e-06, 6.980321786250583626e-06,
   1.489340272648872651e-05, 1.334865368591972299e-05,
  -1.468295659361767024e-05,-1.357979328524331623e-05,
  -5.056876592063527922e-06, 8.627166344324188366e-06,
   6.294661921184853393e-05, 3.062226526236326899e-05,
   2.016631785846174956e-05,-4.575281001240784085e-05,
   4.999919269275973855e-05,-2.841303790183800745e-07,
   3.140110983555856924e-05,-5.112700168301664811e-05,
  -6.425386424414325548e-06, 1.893975737164951584e-05,
  -2.256593344113702016e-06, 1.987228689605959151e-05,
   1.139751013810582816e-05, 2.775061733821024195e-05,
  -1.466748778121064630e-04, 3.140828264651917401e-05,
   2.931439713675125031e-05, 1.368965526246326988e-04,
  -4.652599218531202458e-05, 1.831207391783586536e-05,
   1.680696750875495214e-03,-1.138489539520040530e-03,
   1.817697235219575976e-05, 4.657894026389513230e-05,
  -1.229928277988365995e-05, 1.577110151829786959e-05,
  -2.225621233122125134e-05,-2.011618782641470509e-05,
   8.969862912234034794e-06,-1.787572542124454562e-05,
  -1.787572542124455917e-05,-8.969862912234004301e-06,
  -2.858863856946729093e-05,-2.797659280084634185e-05,
   5.883401183919107005e-06, 8.086135696923424588e-06,
  -2.797659280084629441e-05, 2.858863856946733837e-05,
  -1.385443214947276703e-04, 1.708960824055529471e-04,
   1.087588996027801858e-04, 8.815612149585744304e-05,
  -3.045414284582025890e-05, 2.593347611729625109e-05,
   1.297160085150669876e-05, 1.522292913171413039e-05,
  -3.779212978524599718e-06,-1.963969320694575665e-05,
  -8.919375398803804206e-06, 4.521586280854705620e-06,
   2.164547561783919686e-04, 3.945216578690615805e-04,
   3.945131196252732106e-04,-2.164703176962948824e-04,
   3.629129754501873639e-05,-1.682087163315020020e-05,
  -1.682087163315019004e-05,-3.629129754501874317e-05,
   6.224179653287964184e-05,-6.500737469210406778e-05,
  -6.500737469210406778e-05,-6.224179653287965539e-05,
  -2.497568991154868823e-04,-1.473821269496967056e-04,
  -1.168796619401307909e-04, 1.980887291714517257e-04,
  -1.984443854114578882e-05,-3.473036508570976602e-05,
  -1.908036343558983724e-04, 1.455814999118385563e-04,
   1.577033703127292158e-04, 2.067115066753812504e-04,
  -3.852005134937897641e-05,-1.077987217183984912e-05,
  -8.084904128879888535e-06, 2.889003851203422892e-05,
   4.508960012634310923e-04, 2.590227712859390075e-04,
   2.390979427254826028e-04,-4.162116934739362511e-04,
  -1.851622644227161112e-05, 7.559719461628297690e-06,
  -1.894283685001352011e-05, 4.627276663517938419e-05,
   5.554788787301979778e-05, 2.268109681753552407e-05,
   6.422702299056707494e-06, 1.894066775955092317e-05,
   1.894066775955091978e-05,-6.422702299056710882e-06,
  -9.119525216879991684e-05,-1.214983128625141020e-04,
   7.110947951765184951e-04,-9.916554201092628393e-04,
  -1.370852198560680735e-05, 1.456284398632818105e-05,
   1.456284398632817427e-05, 1.370852198560681413e-05,
   2.760641480510102382e-05,-4.168795823266833246e-05,
  -1.430026190509810282e-06,-2.996589770212893284e-05,
  -2.413257995720254423e-05, 4.379062210804074038e-05,
  -1.983751765601481451e-05, 2.544188131271057283e-06,
   6.362592608571716902e-06, 7.714753093738551971e-06,
   7.095329236030185243e-04, 1.716479837439199342e-04,
   1.340747579179175312e-04,-5.540071834274821029e-04,
   3.968740266112182062e-07,-1.999606188745677797e-05,
  -8.313503961610806866e-06, 1.819026255666150165e-05,
   3.638868132983795760e-05, 3.429087154149779002e-05,
   3.429087154149779002e-05,-3.638868132983795082e-05,
   3.379704370720616399e-05,-4.957579890080639527e-05,
  -4.131316575067194523e-05,-2.816420308933854566e-05,
  -1.293363358666675702e-05,-1.525519984286819112e-05,
  -2.321914252350332344e-05, 1.899661602689383560e-05,
   9.999689644408407387e-06,-7.878461468632992881e-08,
  -4.247892226771870616e-06,-8.989969639342355965e-05,
   1.599497889426465059e-04,-8.255946352298347134e-05,
  -6.878270942884765079e-05,-1.333001833593139122e-04,
   1.894400457548448208e-05,-2.326208697954727805e-05,
   2.809556222353436837e-05,-2.847172954605162062e-05,
  -1.423585741762286689e-05,-1.404778856564662529e-05,
  -6.061906210606540085e-02,-5.062289099660392984e-03,
  -4.679287557244294835e-03, 5.593461785064792607e-02,
  -2.576097059685560406e-05, 5.649726195615623840e-04,
   5.251184652475091204e-04, 2.917365046927617985e-05,
   2.198208253552601222e-04, 8.877203395903055742e-06,
   8.473547662377240258e-06,-2.098289755729971259e-04,
  -2.777588275336785920e-04,-3.535581602956134310e-05,
  -3.156773616751914032e-05, 2.479989476454646288e-04,
   1.157371639198077201e-04, 5.920227096826232056e-05,
   7.748890123112590141e-05,-1.513124918372333932e-04,
   4.123078541103630610e-06,-1.957039149694994780e-05,
  -4.662002228620759230e-05,-5.221660197708681306e-05,
  -4.475708740893163343e-05, 3.996001910246357213e-05,
   5.438900591500967318e-06,-1.599075306555503570e-04,
  -1.499133099895784123e-04,-5.098969304532231717e-06,
  -5.781681065084552651e-04,-1.438131301591209950e-03,
   4.433414765589933405e-05, 4.042874412623914269e-05,
  -1.354627663833917047e-03, 5.445951637463043163e-04,
  -1.663193742838295201e-04,-1.282102403781984598e-04,
   3.490405048650625222e-04,-3.718477187822218045e-04,
  -1.159997412945605377e-04, 1.504794338758457537e-04,
  -4.195171270000444888e-03, 7.403634346473726311e-04,
   6.831059040532963490e-04, 3.870176523602965150e-03,
   8.081564779350481785e-04, 3.221538563662058570e-04,
   2.962334311413386350e-04,-7.431323935034926751e-04,
  -7.122800245870590367e-06, 7.018954099965740050e-06,
  -7.367112699227001184e-06,-6.762074421129086428e-06,
   2.995941160181136405e-07, 1.999775595824809923e-05,
   1.999775595824809923e-05,-2.995941160181083995e-07,
   2.634634449000637042e-05,-1.434817521547290579e-05,
  -1.581326762168007517e-05,-1.224502213657144094e-05,
  -6.995962279990958755e-06,-2.917287287493201014e-05,
  -1.949739123649799169e-05, 4.455528584907892562e-06,
  -3.619618722501788226e-05,-3.449399991841266039e-05,
  -2.759519993473013102e-05, 2.895694978001430581e-05,
  -2.617533846206175199e-05,-3.891206132504374253e-04,
  -3.591882583850191952e-04, 2.416185088805698203e-05,
  -7.512262431024837206e-05, 2.750620505888229969e-05,
   2.406792942652200376e-05, 6.573229627146730692e-05,
  -2.452046420360684130e-04,-9.591531074463364656e-04,
  -8.816457856324909402e-04, 2.253901255079022027e-04,
   9.267467638784688275e-05,-1.425180843135630281e-04,
  -1.257512508649085271e-04,-8.177177328339430831e-05,
  -2.554633085052838973e-05, 7.581150954884979289e-05,
   1.042228982298100360e-04, 3.517936162835620358e-05,
   6.407662637396125847e-05, 3.033054334372066148e-04,
   3.130944197376501624e-04,-6.612022632405432985e-05,
   1.998992735649447364e-05, 6.346686395859957011e-07,
   6.346686395859925247e-07,-1.998992735649447364e-05,
  -7.563237080260001531e-06, 1.851478989531828834e-05,
   4.562887473721897628e-05, 1.323556035467149275e-04,
  -3.938160837595475140e-05, 7.006348672663302715e-06,
   1.229016318648067281e-04,-4.236966939884618887e-05,
  -1.390740011015006693e-05,-1.437303802876058535e-05,
   2.980753317771429783e-05, 3.392781434083471852e-06,
   2.477201951177239272e-06, 9.688316184615554410e-06,
  -7.545672719404956558e-06,-1.852195516708827054e-05,
   2.162936722164189804e-05,-2.078871024357603037e-05,
  -2.974064486118372177e-05, 3.936247355152653594e-06,
  -4.920735088830080825e-05,-8.867729052899732544e-06,
  -1.419151322748581597e-05, 7.873119427719928360e-05,
  -1.220217721376432821e-04, 4.484068603834088623e-05,
   5.226083224839125338e-05, 1.406015839622921958e-04,
   1.732524953044566770e-05,-9.991783059484037242e-06,
  -6.908298513459086012e-05,-1.662153457563227089e-04,
  -1.477469740056201676e-04, 6.140709789741412349e-05,
   3.779138933936392850e-05, 1.310766538330188952e-05,
   9.830749037476443818e-06,-2.834354200452293452e-05,
   1.193591704976228901e-04, 1.238500779650105209e-05,
   4.108080909038612624e-06, 2.699687457303989149e-04,
   1.135292381345910970e-05,-1.094125729561543249e-04,
  -8.282638068909821524e-06, 5.603383497445611499e-06,
   3.987331432130464352e-05, 1.131817953782075504e-04,
   7.536581573316528191e-05,-2.683270055127842541e-05,
   9.598807212891405841e-07,-2.998463988446247011e-05,
  -3.998180277457832096e-05,-1.206419037781521010e-06,
   4.834790459945519412e-05, 8.753559345113267178e-05,
   2.105487888716774044e-05, 7.717960919210915284e-05,
   7.878203410601939240e-05,-4.351311413950969436e-05,
  -8.421961400442665936e-06, 5.391712730612957715e-06,
  -3.563328793721756254e-05, 1.817329884152422325e-05,
   1.817329884152421986e-05, 3.563328793721756254e-05,
   6.500910974347273433e-06,-2.928716709590757156e-05,
  -1.952477806393838330e-05,-4.333940649564850367e-06,
   1.472573054635223860e-05,-4.778234883172057993e-05,
   9.853047722204411540e-06, 1.708054619724575725e-06,
  -4.778234883172055282e-05,-1.472573054635232669e-05,
   5.411197350011728743e-06, 2.950794712004252681e-05,
   2.998766878818505882e-05, 8.600701425533188038e-07,
  -2.628569051393909903e-06,-9.648348290876223462e-06,
   2.886179226456522196e-05, 2.769470973447967909e-05,
   2.774276268430086643e-05,-2.881560547069180698e-05,
   9.834170421866820450e-06,-1.813585430488393872e-06,
   3.229803630936099214e-04, 1.348468948694032043e-04,
   1.232885895948829691e-04,-2.952963319713005600e-04,
  -4.999602938947814943e-05,-6.301152961462185494e-07,
   2.339852300524138068e-06, 2.990861232507673352e-05,
   7.413796176272167527e-06,-6.710858831527616653e-06,
   6.311095443936871915e-06,-2.932865619658560555e-05,
  -1.732115394063375816e-05, 2.449444071957691463e-05,
   2.448208205778141776e-05, 1.733861753762557436e-05,
   2.021564730526046434e-05, 2.216591085494379928e-05,
   1.776103659732998917e-05,-2.417737742163746017e-05,
  -1.847110180332610084e-05,-7.669315365217634246e-06,
  -1.143562327588477767e-05, 1.640812360667856228e-05,
  -1.668394577830012779e-05, 1.102932243008342836e-05,
  -1.540901110174642546e-05,-1.274999517122478927e-05,
  -1.274999517122487228e-05, 1.540901110174635770e-05,
   5.199218978333846496e-05,-4.687016323348271022e-05,
  -1.673796125695512340e-05,-1.094717557001207963e-05,
  -9.167131307036924741e-06,-3.995460373917314071e-06,
   2.845320829580781774e-05,-9.508676967663442896e-06,
   2.612765413340225182e-06, 2.988600771088124465e-05,
  -7.122300715006799693e-06,-2.914228598660396270e-05,
  -1.943415444774443675e-05, 4.723731671170071074e-06,
  -7.623857021155477053e-03,-7.832094491320846369e-03,
  -7.222828359555298443e-03, 7.031155700765253855e-03,
   1.988998709171076315e-05,-2.094854050185658632e-06,
  -2.094854050185621786e-06,-1.988998709171076654e-05,
   3.424019084877170656e-05,-3.643637373065122521e-05,
  -3.643637373065124554e-05,-3.424019084877167945e-05,
   1.039307917709004365e-05,-5.909301062916609744e-05,
  -5.901280325000754783e-05,-1.083923671555793447e-05,
   7.930442728810631694e-05, 1.030087754150366239e-04,
  -8.572528315735154284e-06,-5.148957008552218117e-06,
   1.318720093042895442e-04, 4.092795782372354602e-04,
  -2.950620215198674462e-04, 9.507051833565062873e-05,
  -1.857494634178479730e-05,-6.749052799022848929e-05,
   4.820751999302035724e-05,-1.326781881556056175e-05,
  -1.544055206275064820e-05, 4.755617049340166055e-05,
   6.940924998938743060e-06,-3.939319179958774815e-05,
   3.939319179958774815e-05, 6.940924998938740519e-06,
   3.506365573700745821e-05,-8.288872086331544749e-05,
  -2.968065934292992821e-05, 4.365599726148327573e-06,
  -5.820799634864360249e-06,-3.957421245723992235e-05,
   1.705920409682098044e-05,-1.043951893446275615e-05,
  -1.984502595042336830e-06, 1.990130019496892777e-05,
   9.933685104219276113e-06, 1.149739209652379707e-06,
  -2.968542897617616641e-05, 4.333048176561216198e-06,
   9.999215718368161565e-06,-1.252398400633661150e-07,
   8.807569038927003747e-06, 1.795624480854876728e-05,
   1.906459503537301410e-05,-6.044933096174907347e-06,
  -8.634492362529964070e-05, 2.538807129620469666e-05,
   9.955477023212443480e-06, 1.734613724263385257e-05,
   2.806811035857023139e-06,-9.598010825634197322e-06,
  -1.751911470084489426e-05, 9.647829812897838322e-06,
   5.371520341095885121e-06,-1.926516984677771420e-05,
   6.045220553172044744e-06, 2.938461006145064167e-05,
   1.850677417261800572e-05,-7.582829928444867411e-06,
  -1.435602667382145250e-05,-1.392495953820071383e-05,
   6.144467517780104410e-04,-8.279607013289956726e-05,
   2.532744060738237649e-05,-5.439228577913892305e-05,
   5.228483428770336256e-06, 1.930448033579443466e-05,
   1.846118740651961893e-05,-2.364708353140745060e-05,
   1.303392040039953373e-05, 3.781688669094864999e-05,
  -4.183578932942852148e-06, 9.082822651127608684e-06,
  -8.885559549079126906e-05, 1.430675190170276702e-05,
   1.397113352514489548e-05, 2.654820950690596839e-05,
  -2.912082772271628781e-05, 2.742220619760340778e-05,
  -1.217588967531767430e-05, 1.586655950779791818e-05,
   1.381929288501008086e-05, 2.662756361664187052e-05,
   2.851771314286745678e-05, 4.106994079739006808e-05,
   7.183183389223057540e-06,-1.866552641627848618e-05,
  -3.616740923225470698e-03, 9.908002292420856148e-04,
   4.573268904797785702e-05,-2.021190620503089292e-05,
   5.177703810163632875e-03,-1.764166447424108785e-03,
   1.285283943470378835e-05, 4.831981496721323040e-05,
  -1.980558732015014962e-05, 2.781853860990488477e-06,
  -1.315085900078556301e-05,-4.823955749736369311e-05,
  -5.164822787487249615e-06,-8.562978779248052119e-06,
  -1.440767024268495868e-05,-7.869192486003917563e-05,
  -8.864773431919983760e-06, 4.627719957033442600e-06,
  -1.874692079899436785e-05,-6.967995447489359872e-06,
  -2.860525171132382007e-05, 9.040994111921860524e-06,
   1.629475210611628486e-05, 2.518890735621970038e-05,
  -2.999217476355078889e-05, 6.851663685757405702e-07,
   1.997889896902941599e-05, 9.184748147420326099e-07,
  -1.161857871854213043e-06, 9.932274980366301143e-06,
   9.436724551276405926e-06, 1.763372421649315699e-05,
   9.979148930964351380e-06, 6.454352125760183338e-07,
   9.650482293982427996e-06, 2.620723467581359642e-06,
  -8.395476929742814838e-06,-5.432859939493763194e-06,
  -6.614905697137066653e-06, 7.499534826773163903e-06,
  -1.299866353133356296e-06, 1.995771398392090094e-05,
  -9.465839924610922989e-06, 3.224573541050332454e-06,
   7.259538846723288764e-05, 5.319689439517641388e-05,
  -5.262010138497257543e-05, 7.301455286609107259e-05,
  -1.139510426457194690e-05, 2.775160533734101267e-05,
  -1.850107022489400958e-05,-7.596736176381298215e-06,
  -1.255021467364871024e-03,-1.118977946758826505e-04,
   1.058308192522049157e-04,-1.185284707442227619e-03,
  -3.357209409518742515e-07, 9.994362983692678612e-06,
  -2.104541483963939970e-04, 2.701815880370597809e-03,
  -2.492450074142618047e-03,-1.941458933546068484e-04,
  -3.133715427942903008e-05,-2.485925907317558848e-05,
   1.864444430488165324e-05,-2.350286570957180475e-05,
   2.090560062927295876e-05, 3.694089276971109143e-04,
  -3.595008546503875263e-04, 1.895087084122914836e-05,
  -1.207320045999657657e-05,-1.594483711590489997e-05,
  -1.611351358644454144e-05,-1.184713804678020944e-05,
   9.730776378422736081e-05, 2.304775709940149375e-05,
  -2.074298138946134031e-05, 8.757698740580462473e-05,
   1.791499550494217647e-04, 1.747265308389570407e-05,
  -1.746740012534703720e-05, 1.791504672973560203e-04,
  -2.172194948374163702e-06, 1.988168929206615186e-05,
  -8.745446399071468845e-06, 4.849450203988889577e-06,
  -8.121965177373415522e-05, 7.418468956431213798e-05,
  -6.744288203891356953e-05,-7.383398717586088153e-05,
   4.241264097945260017e-06, 9.056029971874021716e-06,
   1.359853503955372583e-05,-1.466560073021318774e-05,
   1.490207171320537690e-05,-3.712045606743651901e-05,
   3.712045606743651901e-05, 1.490207171320537351e-05,
   2.451253073585945780e-05,-9.694914046510957851e-05,
   1.066444780445895135e-04, 2.696210864522777359e-05,
   5.021662939846222392e-05, 7.468795171818209857e-05,
  -6.638763096676454059e-05, 4.463947193483236333e-05,
  -1.973380202336576925e-05,-4.594101716007826229e-05,
   5.512993971525472127e-05,-2.367888821275991265e-05,
  -8.620700748639753888e-06,-5.067890942236426135e-06,
  -5.528343975750516290e-05,-2.331826083948581991e-05,
   2.720024738793986617e-05,-6.449919799528416973e-05,
   4.515860056635118375e-05,-2.146394173698639465e-05,
   2.575676791635819637e-05, 5.419030269801841242e-05,
  -2.022473614512409438e-05, 4.572701660791037752e-05,
  -4.572701660791040463e-05,-2.022473614512402323e-05,
  -1.164406657502856493e-05,-3.826768497827249887e-05,
   3.826768091372419292e-05,-1.164407993296977446e-05,
   7.633670207456147035e-06, 6.459650080600065598e-06,
  -1.978415393974242536e-05, 2.930401489314111723e-06,
   7.544934290697482552e-06,-6.563075997507364227e-06,
  -1.358146059789065360e-08, 9.999990777192148444e-06,
  -1.005982231587238588e-05,-1.728583162515116023e-05,
   1.728583162515117717e-05,-1.005982231587235539e-05,
  -9.791250442735060459e-06,-2.032588194308059932e-06,
   3.295823165578946941e-06, 2.981840957632102108e-05,
  -3.975787943509467219e-05, 4.394430887438810221e-06,
   3.227488854385828534e-05, 4.789136995007362788e-04,
  -6.086327903700855784e-04, 4.081821267918881623e-05,
  -3.462063402259528644e-05, 3.607508419773290177e-05,
  -4.329010103727940758e-05,-4.154476082711441826e-05,
   3.983756040892216723e-05,-3.601219330376513300e-06,
  -9.949405081546203362e-06,-1.004658411253599869e-06,
   1.430585794121692293e-04,-9.183813399983731935e-05,
   4.324836234014771001e-05, 2.258972756694849833e-04,
   8.979420730303063196e-05,-6.082790052300160033e-06,
   5.406924490933338366e-06, 7.981707315824946268e-05,
  -1.995471028348788490e-05,-1.345190507721082354e-06,
   4.252004546786848170e-06, 2.969714560920129863e-05,
  -1.234081917543508773e-03, 2.542475580849037908e-04,
  -2.441724344283345799e-04,-1.185107515065759922e-03,
   1.998958383769686473e-05,-6.453975485607989098e-07,
   6.453975485607646050e-07, 1.998958383769686812e-05,
   1.648476211376709698e-05,-6.803126206423417744e-05,
   5.831251280688593756e-05, 1.412978592006133829e-05,
  -3.122092629528277574e-05,-1.467148723247391814e-04,
   1.369338808364232215e-04,-2.913953120893059611e-05,
  -9.479867306526131398e-06,-3.183098467006169059e-06,
   1.090690857250706057e-04,-5.003932992254392852e-05,
   3.700580646860834752e-05, 8.204005294737385539e-05,
  -2.854415068888404582e-05,-7.473440614235374996e-05,
   9.480939887777224912e-05, 1.411069731956414788e-04,
   4.660211760342419004e-05,-1.811746767284604638e-05,
  -1.575538021429982041e-05,-1.231941533932718088e-05,
   1.786425468085603197e-05, 8.992686178084575332e-06,
  -8.992686178084573637e-06, 1.786425468085603535e-05,
   2.801308292079615275e-05,-2.855288400972131436e-05,
   2.855288400972131436e-05, 2.801308292079615275e-05,
  -1.241646597490954557e-04,-1.009115318949789584e-04,
   8.829495466848564069e-05,-1.086462193547942193e-04,
  -3.661904205929201946e-05,-1.609489852903094287e-05,
   1.609489852903087510e-05,-3.661904205929204656e-05,
  -2.589455943704615010e-05,-3.048723981539300232e-05,
   1.523948383055777242e-05,-1.295214779788156447e-05,
  -4.510190913910618862e-06,-8.925143019586752202e-06,
  -4.917499936793717340e-04, 2.679215252948852384e-04,
  -2.352168462843884117e-04,-4.298523411870945718e-04,
   1.677450726743000842e-05, 3.631275128567013695e-05,
  -3.631275128567016406e-05, 1.677450726742994743e-05,
   6.492782747623467856e-05, 6.232477211523766703e-05,
  -6.232477211523766703e-05, 6.492782747623467856e-05,
   1.222287430528469770e-04,-2.065432990240088191e-04,
   1.979392908340440527e-04, 1.171325622707696602e-04,
  -2.863604825945737553e-05, 4.098751932091070945e-05,
  -2.254523633516923711e-05,-1.979172348713888199e-05,
  -3.279001545672861228e-05,-2.290883860756584079e-05,
  -2.776231659603154312e-04,-3.667770136229520929e-04,
   3.024858721903854139e-04,-2.300049936962714149e-04,
   1.082906055401348144e-05,-3.850625205752319631e-05,
   2.887968904314239723e-05, 8.121795415510108538e-06,
  -2.595984369628532608e-04, 4.505648139018885172e-04,
   1.033302275252981508e-04,-1.349920889517979244e-04,
  -4.159059820632822002e-04,-2.396293264272484507e-04,
  -7.536064676924273795e-06,-1.852586648945777031e-05,
   3.056623110928114524e-04, 1.243806720411227550e-04,
  -1.281613807899179436e-04, 3.149200858535727864e-04,
  -1.894885528099715042e-05, 6.398506352253351771e-06,
  -6.398506352253319584e-06,-1.894885528099716059e-05,
   1.498322158190516842e-05, 2.599044191674184100e-05,
  -1.983314385682261442e-05,-3.473681627257426015e-05,
   2.605261220443069172e-05,-1.487485789261696166e-05,
  -1.616602052947788850e-05,-1.177538875114106181e-05,
   9.226917852523386365e-04,-1.257683167292341980e-03,
   8.646140846365430940e-04, 6.303445306287613296e-04,
  -7.565924633948001551e-06,-6.565547052560957811e-06,
   1.372711022908530382e-05,-1.454532381071461975e-05,
   4.425459089085185296e-05,-6.664481363979745797e-05,
   4.165308093613569179e-05, 2.765901025936628400e-05,
  -6.228984466353467031e-06, 7.823027068720089639e-06,
   2.996769966783062336e-05,-1.391753073897933574e-06,
  -2.625795585591394733e-05,-1.450929888963882445e-05,
   2.518849905885662737e-06, 1.984075087166863768e-05,
  -7.722872999926429780e-06, 6.352734263843197220e-06,
  -1.307998467758186996e-04, 5.445102387314882482e-04,
  -5.250070814710554572e-04,-1.263628284158142259e-04,
   1.999553869772427363e-05, 4.224123433460553215e-07,
   4.807224603647982806e-05,-5.088279828201421366e-05,
   4.361382709886924952e-05, 4.120478231698280173e-05,
   4.953259344005515267e-05, 3.386033353501122597e-05,
  -2.821694461250928834e-05, 4.127716120004600573e-05,
  -6.143796949667959165e-07,-1.999056121249257506e-05,
  -2.369650567622961357e-05, 1.839770688799062721e-05,
   3.114783481576805214e-06,-3.987854214816404939e-05,
   6.991360167777892231e-05,-3.476823326093445967e-06,
   3.993505745397578409e-05, 2.278417465622441532e-06,
  -3.160335708598509415e-04,-6.133700205337488725e-04,
   5.155773526143878028e-04,-2.656689546618859932e-04,
  -3.991033831412964575e-04,-3.175161248900149427e-04,
   2.553323643596472044e-04,-3.207886901225047351e-04,
   1.934323562379082118e-05, 5.083230823256975811e-06,
  -3.554476050754793180e-05,-3.516489727641843943e-05,
   3.516488486895423678e-05,-3.554477278241054958e-05,
   5.186315701456310941e-03,-6.123090021125341537e-02,
   5.655826463642674162e-02, 4.784499067250687007e-03,
  -5.649392572836121462e-04,-2.648252329719986530e-05,
   2.984429931771122205e-05,-5.250807768561307825e-04,
   2.165820907875588003e-05,-5.195487676623829817e-04,
   4.596008262442629537e-04, 1.915934538523826305e-05,
  -4.975047730016181314e-05, 3.868137665704338233e-04,
  -3.669771796321617320e-04,-4.719904267275009904e-05,
  -4.620285730207189165e-05, 8.868650391758818314e-05,
  -7.119789759454601540e-05,-3.648094541149585104e-05,
   1.367001334547370234e-05, 2.670450776806363260e-05,
   1.812721885353118489e-05,-8.450085007630612778e-06,
  -3.734007265198281672e-05, 3.325235291441261133e-05,
  -3.325235291441267909e-05,-3.734007265198275574e-05,
   1.599004537609729256e-04, 5.643127416155450608e-06,
  -5.290431952645724622e-06, 1.499066754009120890e-04,
   1.531689468814384806e-03,-6.135367724294183084e-04,
  -1.353876333111886577e-05, 1.472079778625979513e-05,
   5.614751925249247952e-04, 1.401729506067093825e-03,
   1.284225561715721196e-04,-1.661554906295889013e-04,
  -1.375164149069257272e-04,-1.311077252916328136e-04,
   1.503311581886755861e-04, 1.161918365361844387e-04,
  -7.317581975546745467e-04,-4.176377609880544718e-03,
   3.871045818683558921e-03,-6.781624212919340131e-04,
  -3.231857577415629939e-04, 8.077443692115790583e-04,
  -7.427534429531767101e-04,-2.971823059692519438e-04,
  -7.009851252322863749e-06,-7.131758928925430227e-06,
   6.771478060812008049e-06,-7.358470280699764110e-06,
  -1.999812228475804447e-05, 2.740530676051180120e-07,
  -2.740530676051547520e-07,-1.999812228475804447e-05,
   1.431451439649032709e-05, 2.636464825467374343e-05,
   1.226520859412163091e-05,-1.579761558409005479e-05,
   2.918178420919229475e-05,-6.958697462035213992e-06,
   4.430623204487717634e-06, 1.950306586206012550e-05,
   3.454020095843351269e-05,-3.615210253568980017e-05,
   2.892168202855184285e-05, 2.763216076674681083e-05,
   3.891537265945260748e-04,-2.567833868444040080e-05,
   2.370308186256039421e-05, 3.592188245487933540e-04,
  -2.741023724815728403e-05,-7.515769351170731598e-05,
   6.576298182274388623e-05,-2.398395759213762480e-05,
   9.594654964862126597e-04,-2.439794275189312973e-04,
   2.242639182244706786e-04, 8.819329311135897529e-04,
   1.423996055078352271e-04, 9.285662254902937003e-05,
  -8.193231401384942899e-05, 1.256467107422075294e-04,
  -8.508210889794938351e-05,-2.934339355762183860e-05,
   1.921626134158615907e-05,-5.683955752864251141e-05,
   4.661911778666483161e-06,-2.963556273411947165e-05,
  -4.306275456167586377e-04, 9.033225866813286763e-05,
  -8.006209968653126702e-05,-3.816936732430653068e-04,
  -6.601989274539787111e-07, 1.998910046440781392e-05,
  -1.998910046440781392e-05,-6.601989274539597587e-07,
   1.974151203498988763e-05,-3.205105703771642001e-06,
  -1.850511515302082630e-05,-7.586877695958932169e-06,
  -1.324137720437980131e-04, 4.545979512858689368e-05,
   5.128339394716434926e-06, 2.955841902153427794e-05,
  -4.221266690511640563e-05,-1.229556454692410218e-04,
   1.439078860815266128e-05,-1.388903176018629678e-05,
  -3.430848356658876766e-06, 2.980317566222786242e-05,
  -9.691472124305504008e-06, 2.464826173142720886e-06,
   2.076106861726303182e-05, 2.165590057857895022e-05,
   1.308098078575896255e-06, 9.914074813961515893e-06,
   1.290675542605929540e-05,-6.879982314201024500e-05,
   3.935795713479065748e-05, 7.138011640224571275e-06,
  -1.321878953790055580e-04,-3.562672596735056351e-04,
   3.000161469816831810e-04,-1.113117763323588232e-04,
   9.969647387258574877e-06, 1.733799674050403065e-05,
   1.663034418403719578e-04,-6.887064129254223189e-05,
   6.121834781559310856e-05, 1.478252816358861907e-04,
  -1.315592123182876175e-05, 3.777461762270952790e-05,
  -2.833096321703213746e-05,-9.866940923871600114e-06,
   5.362553444203360230e-04,-6.348390016867927661e-05,
   5.173006274132393745e-05, 4.369485102489522395e-04,
  -1.253744125913196464e-05, 1.193432552207028470e-04,
  -2.999910180013661055e-05, 2.321447501894236836e-07,
  -1.093979839523109420e-04,-1.149265448753765317e-05,
  -5.592800478603905997e-06,-8.289787862576939589e-06,
   9.229044441636276563e-06, 3.850290728542788496e-06,
  -7.943980996561974783e-06, 6.073974475272531627e-06,
   4.996259311938971661e-05, 1.933724071917015211e-06,
  -1.257482152865688721e-06, 3.998022934695628244e-05,
  -1.311773867732610231e-04, 7.274952370523312826e-05,
   2.220371859752407839e-04,-5.999573354994783937e-05,
  -4.341245953573030683e-05,-7.883754408312438364e-05,
  -5.380951942948743997e-06,-8.428840738065713510e-06,
  -1.812777377178322356e-05,-3.565646951226450831e-05,
   3.565646951226451508e-05,-1.812777377178321678e-05,
   2.927884035304836145e-05, 6.538310758958070494e-06,
  -4.358873839305371012e-06, 1.951922690203224548e-05,
   4.776350240031006445e-05, 1.478674536385796279e-05,
  -1.478674536385805596e-05, 4.776350240031003734e-05,
  -2.951483414538731383e-05, 5.373505873289731760e-06,
   1.187500861048314877e-06, 9.929241748744438602e-06,
  -2.434362948315289333e-05,-3.173937150585955889e-05,
  -8.983691970365583811e-07, 2.998654586286683370e-05,
   1.685000864997021183e-05,-1.077391333248643997e-05,
  -6.940957888584376327e-06, 7.198826542492764320e-06,
   4.445207575105417943e-05, 5.407414318713279572e-05,
  -3.524250563029797221e-05, 3.546781353422305137e-05,
  -1.352592900808476486e-04, 3.228078754411439354e-04,
  -2.951386289747600982e-04,-1.236656366453466732e-04,
   6.939688863197937376e-07,-4.999518383989422015e-05,
   2.991157635240124864e-05,-2.301651605797534478e-06,
   6.701384579964413057e-06, 7.422361127795871725e-06,
   2.932057184915250740e-05, 6.348548372556159290e-06,
  -8.044673460613735618e-06,-1.831074080729933317e-05,
   1.736987150765664916e-05,-2.445991749388165461e-05,
   3.281660201835577214e-05,-5.023017650744269352e-05,
   3.928500380106033128e-05, 3.093038112197577937e-05,
   7.692900096688575948e-06,-1.846129161522478426e-05,
   1.691968055007427710e-05,-1.066416476257931058e-05,
  -8.997800522747617164e-06, 1.786167925344206780e-05,
  -1.639350483479908347e-05,-1.145657013383234000e-05,
  -1.100800497421639907e-05,-1.669801863957598876e-05,
  -6.209572236831968778e-06, 2.935031878252033124e-05,
   8.250898561853935663e-05,-3.594811945289581910e-05,
   1.304971215687390953e-05, 1.515602232192660005e-05,
   5.979900552983896455e-05, 4.907029411190589032e-06,
  -4.089191175992154703e-06, 4.983250460819913826e-05,
   1.276966490716023044e-05,-1.539271445063672116e-05,
   1.539271445063679231e-05, 1.276966490716014743e-05,
   1.711245968435794250e-05,-1.035199128434834769e-05,
  -8.038033347682624428e-05, 5.948951159787923274e-05,
  -1.342291689512804241e-05,-1.482650673714095860e-05,
   4.025531059948306693e-06,-9.153966336260554754e-06,
  -1.804198762730758172e-05, 8.630566751730744842e-06,
   2.574614232947734838e-06, 2.988931851935575575e-05,
  -9.144719765034568578e-06, 4.046492359931763400e-06,
  -2.180420979956759174e-06, 2.992065781947590131e-05,
   1.158555846805510901e-05, 1.630260209240465470e-05,
   2.915135870317625815e-05,-7.085074859078759352e-06,
   4.698906836987220121e-06, 1.944017166944044301e-05,
   7.819906476523974526e-03,-7.593356484349882141e-03,
   7.021925088913885844e-03, 7.231802544710531737e-03,
   2.069449178178979678e-06, 1.989264638249356592e-05,
  -1.989264638249357270e-05, 2.069449178178940714e-06,
   5.093315927091035240e-05, 4.801888468804829001e-05,
  -3.428669885804234209e-05, 3.639261300618462468e-05,
   5.231290860391156770e-05,-2.938298135654031243e-05,
   1.704817796825411688e-05, 4.700382567369102294e-05,
   7.913306636095497927e-06,-6.113884042335688000e-06,
  -7.480192614117289827e-05,-1.183413361660688289e-04,
   1.826983172107205048e-05,-3.558389030001792057e-05,
   1.779191326302882305e-05, 9.134977966085035866e-06,
  -6.885843261772815405e-06,-1.877725119857264762e-05,
  -4.804213235151623489e-06,-8.770378280963369438e-06,
  -2.384460506814880390e-05,-1.820535111290118367e-05,
   1.820536775957145908e-05,-2.384459235841024174e-05,
   1.823828820079712466e-04, 1.040984358694521493e-04,
  -9.418429911998083741e-05, 1.650130837214976035e-04,
  -1.279927192260370749e-05,-1.536810457575196414e-05,
  -2.780996371070869983e-04,-1.369693098504424730e-04,
   1.237145222312255235e-04,-2.511866178543347284e-04,
   2.691490193350325502e-06,-9.630985439668104863e-06,
   1.997612812077587666e-05, 9.768855113815944602e-07,
  -2.936691158139616956e-05, 6.130620210913374740e-06,
  -6.130620210913421327e-06,-2.936691158139615940e-05,
   1.950972429709860490e-05,-4.401210952817463259e-06,
  -1.323163332745043683e-06, 9.912075403006125916e-06,
  -8.683425074154668910e-06,-4.959650086603086313e-06,
   1.853266576808840308e-05,-7.519328396095250798e-06,
   5.763371439996701470e-05, 6.912564621371025491e-05,
  -5.376439149955241069e-05, 4.482622231108545512e-05,
   1.993570352623141349e-05,-1.602412217316282164e-06,
   2.878590493701781690e-05, 8.448175954427878352e-06,
   7.514095958918965920e-05, 4.953621091702279435e-05,
  -3.852816404657318135e-05, 5.844296856936978237e-05,
  -6.773717205999464667e-06, 1.881799020121827150e-05,
  -1.881799020121827150e-05,-6.773717205999468055e-06,
  -9.688258050004683384e-06, 2.477429304040676414e-06,
   1.368538304342935546e-04,-1.169231760407731641e-04,
   9.094024803171245797e-05, 1.064418681155616340e-04,
   2.008111143832663124e-05,-2.228786583326244271e-05,
  -8.793645363167408742e-06,-4.761491491837862768e-06,
   3.952118535708342475e-05,-4.514505408094063543e-05,
   3.762087840078380752e-05, 3.293432113090292285e-05,
   5.620599664510565702e-06,-8.270964841619370746e-06,
  -2.718399813082653633e-06, 1.981439634347290056e-05,
  -2.985335975097979966e-05, 2.962585286296288744e-06,
  -2.962585286296290862e-06,-2.985335975097979966e-05,
   3.863441380147001453e-05,-1.036253203694846859e-05,
  -1.163474409984294914e-05,-2.765199323251706927e-05,
  -9.878032062586617498e-05, 1.848942570312349414e-05,
  -1.083824547368791267e-05,-6.915585611538680507e-05,
   2.561839446286189143e-05,-1.561082525509805457e-05,
  -1.526381262326074472e-05, 4.761319170358133330e-05,
  -3.808889065027663276e-05,-1.221623546888604765e-05,
   5.600684683537340796e-06, 4.968533315854478823e-05,
  -4.968492051714218030e-05, 5.604344136940916257e-06,
   1.673517103577173547e-05, 1.095144056293357118e-05,
   3.231107442788869701e-06, 1.973727298015494407e-05,
  -8.169537572729035127e-06,-5.767031805683803850e-06,
  -8.346615843263178040e-06, 1.817509295615810899e-05,
  -1.817860190508141733e-04,-1.409036666579583047e-04,
   1.652698032111856114e-04,-2.135085294468021581e-04,
  -7.201995894573919632e-07, 9.974031910483613942e-06,
  -5.678717186067532905e-06,-1.917686551865714235e-05,
  -7.399126859547218568e-04,-1.136737275139447144e-05,
   8.448722990900286610e-06,-5.499351044258068543e-04,
  -7.200277497807319296e-06,-6.939452712899597902e-06,
   2.809925462499742999e-07,-9.996051379867551279e-06,
  -1.681949220049751715e-04, 5.341446135755188035e-04,
  -1.876844139842390885e-05, 6.909819641201038073e-06,
   8.764235265947363369e-06,-4.815410699319898555e-06,
  -6.060748820659329336e-05, 7.954075919481568425e-05,
   8.547796438275298122e-06,-5.189910986694101043e-06,
   7.158668327533420934e-05, 5.454673938593384273e-05,
  -2.965459764097596801e-05,-1.162781356866019963e-04,
  -1.804800900538491230e-05,-8.617967912538615518e-06,
  -9.949743011792116479e-06, 1.001306146637458050e-06,
  -2.797105304387061919e-06, 2.986931873873540210e-05,
   1.038654145581990168e-04,-1.825156860619203377e-04,
  -1.651332397703083774e-04,-9.397347031456190259e-05,
  -2.629813811450874813e-06,-9.648009085666443428e-06,
   7.675872511275843460e-06,-6.409444686604283142e-06,
  -4.678798004661614001e-06, 8.837921092178551555e-06,
  -9.785200749704869475e-06, 1.744275913632861415e-05,
   3.999558174776318806e-05,-5.945087535033860398e-07,
   9.513715332875749688e-07,-1.997735949032429392e-05,
   6.426233025439436703e-06, 1.893947013785632837e-05,
   2.912566213712533108e-05, 7.189979490514838181e-06,
   4.936930831205992482e-05, 3.409796763428534974e-05,
   3.409796763428543783e-05,-4.936930831205986383e-05,
   6.168122145874606032e-06, 2.935905770275284873e-05,
   2.935905770275283518e-05,-6.168122145874656854e-06,
   7.615580812100006472e-06,-1.849332119697201166e-05,
  -2.341281168777066557e-04,-6.170770007764824492e-04,
   9.974943602707887007e-06, 7.074603330201777016e-07,
  -1.022271300093076397e-05,-1.719000113148923663e-05,
  -2.154278511850671145e-05, 2.087841970403521050e-05,
   9.616976535215845704e-06, 2.741124280492920962e-06,
  -1.074071617752636158e-05,-5.903081412274290978e-05,
  -1.954202543065496588e-03, 3.185787511375275279e-04,
   6.921236742039327814e-05, 4.243932706771685729e-04,
  -1.844900823673452210e-05, 7.722311511516605914e-06,
   6.859295540012514368e-03,-5.733556025257311763e-03,
   2.565451223695162713e-04, 3.068950963902973908e-04,
  -2.533241176639540560e-05,-1.607074715431089062e-05,
  -6.029978050795278377e-05,-6.681269692725117599e-05,
   2.569005248156991150e-05,-1.549261770954745972e-05,
  -7.611522128798329933e-06, 1.849499204873615116e-05,
   2.371618894603682684e-05, 1.837232652322184134e-05,
  -2.426611999553911049e-05,-1.763959807824705121e-05,
  -2.601120301540433850e-04,-1.036423261469078153e-04,
  -2.701576525220682969e-06, 2.987811045361430724e-05,
   9.928866570378865888e-05, 1.190633708414572619e-05,
   1.060202026642167325e-05,-1.695868999275545943e-05,
   2.032314848596028045e-04,-5.288632679399320771e-05,
   1.535315818471836246e-05,-2.577364028916007986e-05,
   5.833090197196931720e-04,-2.380138389120486876e-04,
   6.044772638783222756e-05, 1.481420682133936524e-04,
  -8.135136149733736863e-05, 1.260236326350321252e-04,
  -7.805563815032290581e-06,-1.841393965259630722e-05,
  -2.002184648770900018e-04, 5.656081384865863440e-04,
  -2.074752798541584168e-04,-7.317108889061749036e-05,
   1.573159213137713275e-05,-1.234977769079238076e-05,
  -1.561818006361099961e-05,-1.249289604137583423e-05,
   2.523072089778183893e-05, 4.316724131767322992e-05,
  -4.316724131767327735e-05, 2.523072089778176778e-05,
  -7.255267588383383767e-05,-8.268076694186717946e-05,
   7.516433358351526286e-05,-6.595697807621298751e-05,
   1.465476855569033887e-05, 1.361020788155529092e-05,
  -1.835990244080363577e-05,-7.931833480612965052e-06,
  -7.219039194055515050e-05, 3.447531452313424660e-05,
  -9.875107291065566268e-06, 1.575517689505167164e-06,
  -3.017489601638009299e-05,-6.316229611406355639e-05,
  -2.175540543320317167e-05,-3.356638697323490622e-05,
   3.356662998135206163e-05,-2.175503049170461096e-05,
   1.844421738179502406e-05, 7.733747162475016016e-06,
  -3.364693723330052004e-05, 2.163061753206171198e-05,
  -2.163061753206165438e-05,-3.364693723330055392e-05,
  -3.635071840706449850e-05, 5.982161207532191979e-05,
  -4.272972291094436685e-05,-2.596479886218870824e-05,
  -2.268633162022408838e-05,-1.962983335683776890e-05,
   2.398901829127943761e-04,-1.963484151758451441e-04,
   1.773468800088432134e-04, 2.166750658269865431e-04,
   1.204283098802108635e-05,-3.814407190893441345e-05,
   3.814410133500776716e-05, 1.204273778443501724e-05,
   9.951938886863407138e-06, 9.792407222618648920e-07,
  -1.079549523655421567e-06,-1.997084306748153900e-05,
   1.997084306748153900e-05,-1.079549523655387474e-06,
  -7.469370248338950055e-06, 6.648947893706864212e-06,
  -8.278136633011702394e-06,-5.610031540480826859e-06,
  -6.891132241741839432e-06, 7.246536857480689680e-06,
  -9.667028708914110650e-06, 2.559014642597886617e-06,
  -1.975655210116590240e-04,-1.690203091565972184e-04,
   1.365200240916905844e-04,-1.595690540863240999e-04,
  -4.097078858072083314e-04, 4.916700604138792355e-04,
  -4.456166862884284544e-04,-3.712489311786908706e-04,
   8.941063282062817062e-06, 4.919407878379417585e-05,
  -3.935525803339399363e-05, 7.152878100805124636e-06,
  -9.964184015896384016e-06, 8.455985438463254732e-07,
   8.876105923601666154e-06,-4.605946551253435867e-06,
  -6.544779201132215747e-06,-1.889883237685405901e-05,
  -1.276490467555857283e-04,-7.877639787645971748e-05,
   6.302038754961600492e-05,-1.021196883715192534e-04,
   5.883732727901670719e-06, 8.085894458043512047e-06,
   1.679644864742506802e-05,-1.085722399301095393e-05,
   8.992849612580932972e-06, 4.373631882715210235e-06,
   6.297228730483113652e-05,-1.470866786340551140e-04,
   1.103142670871496393e-04, 4.723094829690607479e-05,
  -2.283430083674912623e-05,-1.945751025431666388e-05,
  -1.760500221735198867e-05,-9.490200046734083387e-06,
   2.972464781549530706e-05, 4.055282017908266909e-06,
  -1.422790127441505370e-05, 1.405584665986003757e-05,
   3.119697232583185320e-05, 2.503495391849726756e-05,
  -6.019027379530783661e-06, 1.907278976459550089e-05,
   3.871667690322524427e-05, 1.005081735836767503e-05,
   1.586111625438456688e-05,-2.546419036931859130e-05,
   7.100824825047145436e-06,-7.041185042590074679e-06,
  -2.403711754364699639e-05,-1.795040334345993896e-05,
  -2.582567042687347223e-05, 5.415749945300755373e-05,
  -1.837770935225768211e-05,-7.890487878701833244e-06,
   1.788507299273079583e-05,-2.408576683530527400e-05,
   2.408576683530524011e-05, 1.788507299273084326e-05,
  -1.974811632881176145e-05,-3.164158887242925414e-06,
  -8.480332454234956911e-06, 7.954925493972680691e-05,
  -6.960182430111790943e-05,-7.455605539210862188e-06,
   2.753205579403739285e-05, 1.191578380779090742e-05,
  -1.973745676881740480e-05, 3.229984566381716365e-06,
  -5.450997563491437228e-06,-8.383711920313723982e-06,
   1.592746013284144780e-05, 1.209611564580739266e-05,
   1.887988133340023515e-05,-3.526400545650940999e-05,
  -9.490790174702227219e-05,-5.561016261419820069e-05,
   2.022219655751484634e-05,-3.451177721284771861e-05,
   7.625412140714685182e-06,-2.901470471475181475e-05,
   3.672089088027859313e-07,-2.999775254277053165e-05,
  -1.099018751428416886e-04, 4.645195376648485215e-06,
  -3.354678209856597519e-06,-7.992963239067419625e-05,
  -1.027827758896320599e-05, 3.865691412676672468e-05,
   2.673704178527449822e-04,-1.758211012855071312e-04,
   1.593378307498842582e-04, 2.423044689887523368e-04,
  -3.175602178848661573e-05, 2.432190535647163596e-05,
  -2.432191089894246598e-05,-3.175601754351297366e-05,
   9.796410471801924525e-06, 2.007571136465555951e-06,
  -7.835570692038170673e-06,-6.213198204634427591e-06,
  -9.770843550536247575e-06, 1.745080560635939022e-05,
   4.710714879669677393e-05, 1.676056479495454776e-05,
  -2.333902608504317003e-06, 1.986335567355165888e-05,
   5.136938133905397802e-05,-1.302351206888635279e-04,
   4.651235738378001113e-05, 1.834667846242271776e-05,
   2.973030256411054729e-05,-4.013615508047814931e-06,
  -2.654923901048048421e-05,-1.374595864534895978e-04,
   7.855182553307539864e-05,-1.515291079038230724e-05,
  -2.981430226496627729e-05,-3.332773687670174624e-06,
   1.017800979193229470e-05,-1.721650709857636564e-05,
  -2.794334335249293200e-05,-1.091648122266003123e-05,
  -1.337498775326738691e-05, 6.871033184754638803e-05,
  -2.998602463622331910e-05, 9.156017233536402488e-07,
   1.853376889711613089e-04, 4.183229669560442035e-05,
  -1.100899285530094317e-05, 4.877296460450126174e-05,
   1.724892849308051816e-05,-1.012296724486428158e-05,
   1.106906336471690086e-05, 3.843794786702175450e-05,
   9.995877098923467525e-06,-2.871254485715173319e-07,
   1.603061843115211299e-04,-5.658557476495771591e-05,
   2.994073051896634798e-05, 8.487374538684290483e-05,
  -1.326178507880559366e-05,-1.497080680937301247e-05,
   1.167693472232580902e-05,-4.861737544839851168e-05,
   1.999018508446928267e-05, 6.264984346843207657e-07,
  -9.990491055421012721e-05,-4.359913663740856178e-06,
  -1.719861428388042235e-05, 2.494077137273711421e-04,
  -5.985781238956159353e-05,-4.128231574905532537e-06,
   1.261043376195405002e-05, 1.552343262089185926e-05,
  -4.552481141579456722e-05, 2.067586867718841686e-05,
   9.843085333546602780e-05, 1.855030110581819605e-04,
  -8.834257031329196923e-05, 4.685712614364079601e-05,
   1.563022463123139581e-05,-2.560656318167761188e-05,
   1.696429725298418211e-05, 1.059304577127812514e-05,
   9.505951115850001730e-06, 1.759650230537507148e-05,
  -1.060374211011751511e-06,-4.998875480078115942e-05,
   3.999100384062493160e-05,-8.482993688093325990e-07,
   5.187739656095446393e-06,-1.931546937717473205e-05,
  -1.474931291082471194e-05,-1.392208955891987340e-04,
  -1.536495783010218349e-05,-1.280304928051054922e-05,
  -3.188727549172533761e-04, 2.683591197409350188e-05,
  -7.528394293081908236e-06,-8.968457659691488493e-05,
   5.187973130215812420e-07, 1.999327010141166514e-05,
  -3.788797259239266174e-05,-5.886001641894183096e-05,
  -2.092214723317171901e-04, 1.543579460712939100e-04,
  -6.535259611095166408e-05,-8.848185227242266130e-05,
   9.907059226801585909e-06, 1.360212291021365269e-06,
   9.919177523207794685e-06, 1.268825150715932995e-06,
   1.381125559361303710e-05, 3.597349708034067476e-04,
  -3.720533386587742926e-05, 1.468887783081452248e-05,
  -1.051393889458919706e-04,-4.375450935527496529e-04,
   1.361248490531612469e-04,-3.271124378946884271e-05,
   1.413480522273532906e-05,-1.414946222707188609e-05,
   6.782909791419289801e-05,-5.915415011769532979e-05,
  -1.160291889969707461e-05, 1.629025085770788539e-05,
  -1.978686488929816347e-04,-1.981110743630096747e-04,
   1.203015991995455710e-04,-1.201146337047734525e-04,
   1.942001540746227000e-05,-4.781527117347355386e-06,
   2.074063181391044830e-04,-3.290317911662306343e-05,
   1.778824225203377434e-05, 2.415736818411642377e-05,
   1.458966100651997333e-04, 3.400208510834049915e-04,
  -3.966844297142335012e-05, 3.043706017707580288e-05,
   8.350809964072632109e-05, 7.159886377865590289e-05,
  -1.999040113313197350e-05, 6.195664100610986924e-07,
   2.083489467533735523e-04,-2.812307173598927769e-04,
   1.446263010969079527e-04, 1.071598480356636461e-04,
   3.794476676719155047e-05, 1.138428507855606937e-04,
   1.830204862130991531e-05, 8.064429072365129466e-06,
  -6.967982664484082510e-04, 4.322871451645224957e-04,
   4.974094962470240310e-04, 8.327567430188012512e-04,
  -1.716928977738556728e-04, 1.025746014080305919e-04,
  -9.585251741137349471e-06, 2.850078781195958147e-06,
   3.972046400937760116e-04, 2.114910728328121131e-04,
  -8.458894190812218787e-05, 1.588858423739016924e-04,
  -4.945466625221687871e-06,-8.691510792653854271e-06,
   3.716761717101057123e-05, 3.344500312197923336e-05,
  -2.235562190726004742e-06, 1.987466381329245038e-05,
  -5.495408779718918574e-05, 2.408419054854912274e-05,
  -9.863682008871115851e-06,-1.645532505869232013e-06,
  -1.175010323503367093e-02,-1.376753696076576071e-02,
   7.940183246684228360e-06,-6.078938230404643225e-06,
  -1.396177986881838218e-05,-1.432022007144645178e-05,
  -1.235415683651438319e-03, 1.016734030407190261e-03,
  -1.526177490155970155e-04,-1.852237098360040883e-04,
  -1.709672676051242086e-05,-1.037795423368105758e-05,
  -1.553465396479621671e-04,-6.904674227944516041e-05,
   2.244962445571107955e-05,-1.990010959260121839e-05,
  -4.207456721086383274e-05,-7.955960529074100650e-05,
  -5.170680780337069682e-04, 5.972776596178098162e-04,
   1.294035323361649672e-05, 1.524950026031119223e-05,
  -2.304975785086596767e-03,-2.072941540459939409e-03,
   1.669085470545574241e-04,-1.861223708212868082e-04,
   1.227793469341115844e-05,-5.873033559979314895e-05,
  -2.611378462367198213e-05,-1.476720192279068220e-05,
   5.772366506966535152e-05,-2.019108181621903642e-04,
  -1.330252770875719265e-05, 2.688945437448940175e-05,
  -1.269509280835196926e-05,-1.545427509096852336e-05,
  -7.949989312526189577e-04,-1.551666823361042696e-04,
   5.364961667127370477e-05,-2.748121515345079615e-04,
   1.436591429687600756e-05,-1.391475858269965097e-05,
   3.132741348553624958e-05,-2.487153321181148901e-05,
  -2.715762054445107314e-04,-1.874736371769665836e-04,
   5.422314931794259066e-03,-8.247145007846111778e-03,
   2.757577489504848102e-04, 1.812668306496293162e-04,
   9.866001546812482178e-05, 4.864361569445030642e-05,
  -6.749677654662682559e-06, 1.882662613316967438e-05,
   2.674820957441938077e-04, 3.678761281048204522e-05,
  -2.860356964047093594e-05,-9.046314377840811551e-06,
  -2.473967638800816875e-05,-1.696904276076382188e-05,
   4.718601334211453463e-05,-1.058949233979078735e-03,
   3.096920570978026438e-04, 1.381411490220623099e-05,
   2.629987007896888166e-05, 3.013829513806906609e-05,
   1.608478174608968998e-06, 9.869792194459142034e-06,
   7.427882530053518305e-07, 9.972375123870805863e-06,
  -5.209436515089644935e-06,-8.535910683415722696e-06,
  -2.672435051637237088e-06,-9.636290307726345212e-06,
   5.321968316539060859e-04, 4.699643947976740060e-04,
   2.683882040049307048e-05,-1.340439179933491295e-05,
   2.136667210553741514e-05, 2.105861636324783212e-05,
   7.162794090677244139e-05,-1.651346059475599997e-04,
  -2.694557808043406260e-03,-1.249102965776766700e-03,
  -2.718522979119512156e-03,-5.315381566728515778e-04,
  -2.091309557078927330e-05, 4.541632342723301408e-05,
   3.566817394505690362e-05,-1.145765306134950321e-04,
  -3.923355578432394735e-05,-7.792823655026546965e-06,
  -2.229596069763607654e-05,-3.320978977002817065e-05,
   1.095771546670032019e-05,-5.899091855320475359e-05,
   9.947740195147984144e-06, 3.698662494267486228e-04,
   8.033917606661591159e-06,-4.935034111218860545e-05,
   7.554521865346055583e-06,-2.903324300497635524e-05,
   1.442218557015027955e-03,-1.500187781629033084e-04,
   3.619380914171131946e-05, 3.481235530380174950e-04,
  -4.995824143326490569e-05,-2.043064584298265961e-06,
  -1.100773505575862248e-05,-3.845555576171306859e-05,
   3.671662643855716460e-07,-9.993257173429349215e-06,
  -8.133149779876894616e-06, 5.818236387264480541e-06,
  -3.714157628263037590e-05, 1.484935389980147044e-05,
  -6.790742425702371685e-06, 7.340695968895992788e-06,
   1.192477526122324825e-04,-1.341542011760350456e-05,
   2.862727577827098567e-06, 1.979405948296478844e-05,
  -1.216409091328276384e-05, 2.742325458900514573e-05,
  -1.221449224571177390e-05, 1.583686140557677058e-05,
   2.790791438686120673e-04, 2.268989769837039748e-05,
   2.184327289241762662e-04, 7.202182262854314547e-05,
   1.397501513763156829e-05, 3.747931365304024498e-05,
   1.114054230426226666e-03,-3.810483325205534302e-03,
  -2.591689188724105022e-04,-7.570648248667948509e-05,
   2.919827181667349270e-05,-6.889188843372665183e-06,
   6.592524891672537134e-06,-6.968887009812023642e-05,
  -7.085772652823176540e-04, 4.492503895415257415e-05,
   8.999005845029528744e-05, 1.337677133107078597e-06,
  -1.795900632991753182e-06, 9.837415357522514878e-06,
   4.887679364923464302e-04, 1.898079530540544438e-03,
  -3.582475438059577982e-04, 9.251322801090857524e-05,
  -3.172802058087100805e-06,-4.989923172855669018e-05,
   3.619304114408881132e-05,-1.703125869518441822e-05,
   1.962310786979326569e-05,-3.864406491359007022e-06,
  -8.030887819020751902e-06, 1.831679122658508023e-05,
  -6.916849975996154914e-06,-7.221993243527856325e-06,
   1.082532188525232605e-05, 5.901535737484504552e-05,
  -7.983538142059478531e-05, 5.129510057320308189e-06,
   1.827244022492805500e-05, 2.379323282419669710e-05,
   1.177915661175806576e-05, 1.616327533378294823e-05,
   2.684025400191516385e-05, 1.340152099997149679e-05,
   1.651053253033438721e-05, 2.504800023085216335e-05,
   3.999311249359403130e-05, 7.422621334363286268e-07,
   9.287007095676657551e-06, 3.708301390778723438e-06,
  -1.675853229791152295e-05, 1.091565825866018885e-05,
  -2.048489053179152329e-05, 1.080757570406079473e-04,
  -3.567064885908539424e-05, 1.809985662848824750e-05,
  -1.887063069706357583e-05, 6.625654465412602703e-06,
  -1.721112635413010928e-05,-1.018710604745862500e-05,
   2.160559115543914110e-03, 2.904897730387421260e-04,
   3.618838654399758186e-05,-2.675638254311337762e-04,
   8.692880216122560207e-06,-4.923854012405470636e-05,
   7.953114392355614584e-05,-8.648534338869201619e-06,
  -7.636644192878183851e-04,-3.251525281266285771e-03,
   9.195306180810918688e-06, 6.939341715351060526e-05,
  -5.201722738111299918e-06, 2.954559325103857118e-05,
   9.119624464097831159e-06,-4.102736846768066346e-06,
   1.536897069587195164e-05, 1.279823189934567702e-05,
  -2.524146494539448570e-03, 1.065966450740459502e-03,
  -1.325691685203983440e-04,-3.130901077290852816e-04,
   6.785640578576686787e-05, 1.719035176595709813e-05,
   2.269935653713849082e-05, 3.293537934804862885e-05,
   1.161293486759039274e-05, 2.766115947969469030e-05,
  -3.408392730038221793e-05,-2.093527883220713554e-05,
   6.176079123407188022e-06,-7.864861515717483620e-06,
   5.815486331350846257e-05, 1.476522512483801181e-05,
   3.304371827818825107e-06,-2.981746345388080484e-05,
   5.341545453093337486e-05,-2.732744439668279070e-05,
   1.839947594384219666e-05,-7.839597246796060030e-06,
   3.693146641157828695e-05,-4.728706788002894599e-05,
   1.688581836904686740e-05, 1.071770208615445312e-05,
   1.297959450878900037e-05,-6.878611870419361178e-05,
   1.552899167520768091e-05,-1.260358748735178882e-05,
  -8.759692341225759082e-06,-1.797964933159350762e-05,
  -4.784091319049873326e-06, 2.961608465430553378e-05,
   4.017091997683639152e-06, 3.979777596653042283e-05,
  -2.474039108127861503e-05, 1.696800074096502605e-05,
  -1.279590983505404489e-05, 1.537090405581816317e-05,
  -5.884714591549509419e-05,-1.170527306817012541e-05,
  -6.663772522636647437e-05,-2.143393516494998722e-05,
  -4.076876613530121986e-06, 3.979169608194718801e-05,
   4.352831142173206122e-06, 9.002936245899285456e-06,
  -9.983681970629803136e-06, 5.710466787587864488e-07,
  -1.240779947256797104e-03,-7.289125162223193677e-03,
  -1.305793068905795754e-03, 1.956542972188603843e-04,
   8.401431831434043416e-05, 2.737963404780254585e-05,
   6.257194467923106180e-06,-4.960693013471598553e-05,
  -6.551097645782471418e-05,-3.234320824586552089e-04,
  -9.800973928110419181e-05, 1.985172551820078455e-05,
   2.607113489185487284e-05, 2.285176052855681077e-04,
   1.987110165119009320e-05,-2.267006653733170918e-06,
  -5.865258754813843310e-06, 8.099304892339809358e-06,
   7.692788045498805846e-06, 6.389132342269228744e-06,
   7.941521621735148876e-06,-1.835571394229908843e-05,
  -1.099378701010063152e-04, 3.696581887942317318e-06,
  -1.820245334152969358e-05,-2.384681723730516041e-05,
  -1.898380554746724978e-04, 1.626699501862441909e-04,
   5.187894583863584619e-04,-1.498582592558341951e-04,
   3.127974549655676280e-05, 1.054588901974159635e-04,
  -1.778120985108199740e-06, 9.840644580631792342e-06,
  -2.301233093146472924e-03,-3.773688679661786789e-03,
   3.500458095496137602e-04,-2.134664639158936482e-04,
  -4.899826935542683228e-05, 7.549284469519638627e-05,
  -4.177638345267601874e-05, 2.747241863424073461e-05,
   2.142328250928301945e-06,-9.767826250772201007e-06,
   1.729062411329144181e-05, 1.005158284912702739e-05,
   7.468027947085208293e-06,-6.650455516846519747e-06,
  -4.718903568246101256e-06,-3.972067407677763073e-05,
   6.104226466226686358e-06, 7.920758754628099205e-06,
  -7.430374711031738810e-05,-9.422819729447232410e-05,
   1.401543788283843692e-05,-1.426770832868044309e-05,
  -1.182018600715648392e-05,-1.613329485121443426e-05,
  -1.310887561875809931e-04,-4.915015769245247506e-05,
  -1.033773870378867284e-05,-2.816258437168346463e-05,
  -3.742535272801501616e-04, 6.583538044521295340e-05,
   1.247569843279447209e-05, 4.841855996014306945e-05,
  -9.675856040133052534e-06, 2.525432614547602071e-06,
   4.432781505069765312e-06, 8.963841148096693282e-06,
  -2.185174390733883739e-05,-2.055483612700621763e-05,
  -3.970962158693730574e-05, 3.578032223910543189e-04,
   3.979884918494116342e-05, 4.006445251629985219e-06,
  -5.332154490523094258e-05,-5.963902119350586282e-05,
  -2.215250831513384936e-04, 2.445948436390116732e-04,
  -9.908337704431450371e-04,-3.159880367188299733e-04,
  -7.311882572673873454e-05,-6.821757342754732219e-05,
  -1.822325470476049211e-05, 5.716566266532230632e-05,
   2.650494738384395457e-06, 9.642348139421052686e-06,
  -8.965880899903640937e-05, 7.829301940422901096e-06,
  -6.788422666550328255e-06,-5.961474077525008954e-05,
  -1.744898020053284164e-05, 9.774103025925850641e-06,
  -3.928219074218245962e-05,-7.543837915464186853e-06,
   7.851766029802934141e-06,-2.895427032776396226e-05,
  -1.799967461824281318e-04, 1.082295587418909861e-06,
   1.803250030786405565e-07, 2.999945804332579432e-05,
  -2.963045281944760054e-05,-2.687073251168434413e-05,
   1.826052172359143577e-01, 2.190959188932649071e-01,
  -2.488489063864592074e-05,-4.336752492248817370e-05,
   1.477770399133473012e-03,-1.222756814560629424e-03,
   1.544403940768285070e-03,-1.824162551235645720e-03,
   2.777712319815928512e-04, 3.015678077703721647e-04,
   2.942132521490799056e-05,-2.709955022871448838e-05,
  -2.813391804892711231e-04,-3.639344247548249563e-04,
   3.164640767037613008e-05,-2.446435941446984354e-05,
  -1.294257484848122377e-05,-1.524761477384122785e-05,
  -2.381790347251987679e-05, 2.890202544358677411e-04,
   1.893580786688026313e-04, 1.560506465412929682e-05,
   3.076509955085090717e-03,-2.603089047373435307e-03,
  -1.989053956710637103e-03,-2.339216781193253179e-03,
  -3.061072085995294702e-05,-2.574847118634506293e-05,
  -1.931135338975879635e-05, 2.295804064496470518e-05,
  -2.203904425164779718e-05, 2.035388239314333495e-05,
   2.035385162081257936e-05, 2.203907267100739894e-05,
   3.161397731151263240e-05,-2.450625304992920842e-05,
  -1.837967323440261135e-05,-2.371049581507279062e-05,
  -1.038233712724618525e-05,-1.709406551339398477e-05,
  -1.363629071918497685e-05,-1.463050154375678765e-05,
   7.360613978424377713e-05, 3.133905209259473635e-05,
  -1.998860430819323733e-05, 6.750539315334500927e-07,
   3.133824274892229239e-05,-7.360648437066954965e-05,
   9.908101543646401587e-06,-1.352598906103284475e-06,
   4.019227811016821941e-07, 9.991919639290114483e-06,
   1.670616005556697340e-04,-2.370451889825605488e-04,
  -1.721195991196237409e-04,-1.203114441726140475e-04,
  -5.510555058555498736e-05, 2.373559130636607306e-05,
   1.190587533126321230e-05, 2.753634203369100737e-05,
   2.260172405225301166e-05, 1.972719112965167591e-05,
   6.023759801201402590e-05, 3.565714214211512968e-05,
   2.039767992180698171e-05,-3.440835151249639032e-05,
  -3.255887250561945168e-03, 2.747340002932536183e-03,
  -2.002542307675318767e-03,-2.367151244993387187e-03,
   3.054485000391936658e-05, 2.582657813644826389e-05,
  -1.936993360233619368e-05, 2.290863750293952494e-05,
  -4.418246565894654048e-05, 4.059445440323111183e-05,
  -2.706297988387905068e-05,-2.945496765920407707e-05,
   3.959598443730799410e-05,-3.053126293556268243e-05,
   2.442503246301373681e-05, 3.167677049796467875e-05,
  -1.010985482903132708e-04,-4.334839712828143056e-05,
   3.152610700238649372e-05,-7.352621693840964657e-05,
  -1.667509776267200980e-04, 2.372638014121267191e-04,
  -1.718117182639538059e-04,-1.207507079365904471e-04,
   5.516600017144709185e-05,-2.359475418570618064e-05,
   1.183549862324300041e-05, 2.756666414964300995e-05,
  -2.255125987133476626e-05,-1.978485982299410352e-05,
  -6.014632013981579682e-05,-3.581089462215077845e-05,
   2.048550486285691512e-05,-3.435613614063528555e-05,
   3.088528044435216464e-04, 2.664479662845573114e-05,
  -1.633048357329930776e-05, 1.892968972441497850e-04,
  -1.286451026285672511e-05,-1.531353570201389062e-05,
   3.778669351222490208e-05,-1.312119634077551002e-05,
  -4.049416684610955292e-04,-1.256352755058842566e-03,
  -3.521634264695390005e-04, 1.134941454755865141e-04,
   4.276828834428443810e-05,-2.590122607329900550e-05,
  -3.108147128795880253e-05,-5.132194601314132301e-05,
   8.785162383566401398e-06,-1.796721797870694248e-05,
  -2.179115225389776853e-04, 1.418258380717159932e-04,
   9.423514415430873752e-06,-3.346248057476691914e-06,
   1.034668208397777829e-04,-1.220435044781545463e-04,
  -4.843614391341495619e-06, 8.748679879158315697e-06,
   3.959861515238385809e-06, 9.182564825806239587e-06,
  -1.933724301485227151e-05,-5.105980080704104248e-06,
  -9.999596203919432067e-06, 8.986522442022152501e-08,
   7.529182667461828375e-06,-6.581140354071808100e-06,
  -1.752204089624356795e-05, 5.738447597417238680e-05,
   1.427312203931463355e-05, 1.191481346360522442e-04,
   2.998398614238115075e-05,-9.800892885319831137e-07,
   7.699332172532910297e-06, 2.899517691094502970e-05,
   9.057362031729179730e-05, 9.325459400275712288e-05,
  -2.426593409580595921e-05, 3.179881196614115630e-05,
  -4.976544095130613085e-05, 4.837446322396011356e-06,
  -2.125344348730334661e-05,-2.117288690594655213e-05,
  -1.001855114775277514e-05, 1.730978431118832867e-05,
  -9.499833930585320399e-05, 3.123004209299096905e-05,
   1.527380162502170062e-06, 9.882667141981199972e-06,
  -3.506212485734170746e-05, 6.058586799318946671e-05,
  -8.713467218121955741e-04, 8.104658477611134931e-04,
   9.675494523895860672e-06,-2.526817309989234635e-06,
  -4.646724627173469055e-03, 1.087919345536329623e-02,
  -1.272877632209862034e-05,-2.997298421134304640e-04,
   2.574886578386144181e-04, 1.099981412773368069e-04,
  -3.893805058063889898e-05,-5.817068176478256162e-05,
   1.999431923796497672e-05,-4.766531342010172334e-07,
   2.814504564947116778e-05,-2.842281487448391962e-05,
  -9.936800508486107156e-06,-1.122495280413349832e-06,
   2.176209151051783814e-05, 3.356205257560758573e-05,
  -2.996582877193742890e-05,-1.431469877757493382e-06,
  -9.956564159422187266e-06, 9.310371310047655923e-07,
   2.083914730754171012e-04, 1.586371013965351710e-03,
   3.009094048679699079e-03,-7.384447305260908115e-05,
   1.972086249225924061e-05, 3.329802180521049080e-06,
   4.305320522335728075e-06,-9.025752888261169308e-06,
  -8.581325911684790540e-06,-5.134281410036580203e-06,
   1.277474004581693972e-05,-2.714417095366519113e-05,
  -3.993954156836831471e-05,-2.198412906753373136e-06,
   2.077280655752719932e-02, 1.461678855712002581e-02,
   6.345208700401843913e-05,-8.985450826104650151e-05,
   1.759375929719446146e-06, 9.844013223168885141e-06,
   9.850682087417548605e-06,-1.721645263296442404e-06,
  -5.617924021947401935e-06, 8.272782463211899090e-06,
  -1.327247345960429358e-05, 1.496133176773042949e-05,
  -1.922732725100896340e-03,-4.517875481664593816e-03,
  -6.956054983847392316e-05, 7.831341275234046849e-06,
   8.963332031623107306e-05,-8.115903467139054498e-06,
   2.976991992004835249e-05,-6.335417798341248991e-05,
  -2.246033527664583084e-05, 3.309884196253184708e-05,
   2.951248564316854731e-05, 6.993775898548378750e-04,
   3.029369363040181648e-06, 1.976924179786047141e-05,
   8.930491036296620152e-05,-9.447027566945366290e-05,
  -1.728576208367281930e-04,-5.020202106156600251e-05,
   2.497950836266859691e-05, 1.580380465646148691e-04,
   1.952264517301036719e-05,-6.722251353117297660e-05,
  -9.578450871884594162e-05, 1.640893899357582912e-04,
   2.082937572392928421e-05, 2.159020858980721912e-05,
   8.608529932713968714e-06, 3.698998421362160441e-04,
  -2.843353272064334764e-06, 1.979685182472811956e-05,
  -2.021699573164894952e-03, 2.310331325993066412e-03,
  -2.258541977792622699e-05, 1.974585560199554525e-05,
   3.010203682075656824e-05, 2.634136251680645402e-05,
  -1.919173623732598703e-05,-2.305812785542028025e-05,
   5.986170533782591337e-04, 2.779525560320149575e-04,
   6.770420908150849581e-05, 1.778032824914607096e-05,
  -2.580965922791950227e-03, 4.363887590828468936e-03,
   1.627879812654702582e-05,-3.653766182386509944e-05,
  -9.309601317641640235e-04, 1.892438455159117783e-04,
   4.914307744646862795e-06,-8.986573083990863234e-05,
  -8.184434484847378629e-06,-5.745870879443866697e-06,
   3.734084856657978748e-05,-1.434088659489909123e-05,
  -8.487626028968764955e-06,-5.939663462177274046e-05,
   1.931803158491861511e-04, 1.424126594387194146e-04,
   1.686081000536774674e-06, 2.995258137222281110e-05,
   9.413906735675432711e-06, 1.764591624064913169e-05,
   7.791676439486670564e-04,-3.870371850655738286e-04,
  -1.196557625114860052e-04,-2.420382170191204773e-04,
   1.995810741291845875e-05, 1.293811614729635446e-06,
  -1.228104395060165669e-04,-1.578530834299382590e-04,
   5.962994949307913960e-05, 6.741119434821512895e-05,
  -4.623874604404390142e-06,-2.964152127747063086e-05,
   9.029692577830648534e-04,-1.380994757230707580e-03,
  -1.019604546367596149e-04,-6.327768714377355989e-05,
   2.468390036139007904e-05, 4.348223847675010146e-05,
  -1.231946768520382571e-05, 2.735380624251803702e-05,
   2.463945972572720200e-06,-1.984764394693341622e-05,
   2.639416802809106634e-05, 1.426001031222962892e-05,
   6.995320206143502029e-05, 2.559203265088973908e-06,
   2.030657176059031072e-04,-8.464227273177167630e-05,
   4.923315864872399982e-04,-1.017108454859636576e-03,
  -4.416888340733290974e-04,-3.106621538825468025e-04,
  -2.053785745500927485e-05, 2.186770246637081082e-05,
  -4.989309875983066607e-06,-8.666417192901450838e-06,
  -9.471974974299848145e-06, 3.206507459251793863e-06,
  -2.568573156339481796e-06, 1.699805942804664396e-04,
  -3.998024422222837130e-05,-1.257009121277646328e-06,
   1.339053162183057530e-06,-9.909941302997085557e-06,
  -2.398461068438611921e-05,-7.631997412419917726e-05,
  -2.023253683796554729e-04,-2.348711248962645493e-04,
  -7.690117755922240577e-07,-6.999577573603280641e-05,
  -3.129631495608824150e-05, 7.362432118647566190e-05,
  -2.799648419308016110e-04,-4.437035345956743018e-06,
  -5.291974817762725987e-06,-1.928717196812859032e-05,
   1.593813782221279512e-05, 1.208204298784564115e-05,
  -3.369371634907807667e-06,-1.971414047798885849e-05,
   7.054113692638414714e-06,-7.087981377750031837e-06,
  -1.761877027819371363e-05,-9.464614830210358717e-06,
   2.999994352411537989e-05,-5.821125224406825418e-08,
  -7.977423352315120037e-06, 6.029984797488084615e-06,
   3.362747543433272364e-04, 4.847878810277077982e-04,
   1.807391413213637287e-04,-1.254327022527064808e-04,
   7.308532039235332285e-05,-1.075106317679654490e-04,
   9.175152139795993253e-06,-1.777122908556403219e-05,
  -1.579869961667729804e-05,-4.743839257839583255e-05,
   6.079578815620410382e-04, 2.815798541206300802e-04,
  -4.669925336594104215e-05,-3.767200200498567654e-05,
   4.056487305412119184e-05,-9.140290517321116904e-05,
   7.453219127206712132e-06,-2.905941370093072162e-05,
  -3.628076761122329161e-04, 9.318640405950006896e-04,
   2.558587101786791856e-05,-3.074675924804151953e-05,
  -1.255347859320656245e-05, 1.556952713507718210e-05,
   3.127799958536509479e-05, 2.493364678377194644e-05,
   3.775023294733519807e-06, 2.976153892399079672e-05,
  -1.983904279052075810e-05, 2.532267986585629265e-06,
   6.735930804705070752e-06,-2.923400821293969210e-05,
  -2.663632715713865377e-05,-1.272419194903074314e-04,
   1.383179468860903158e-05, 1.444581100846079349e-05,
  -5.990535737567688739e-04,-7.373159538279661519e-04,
   3.366196802496333935e-04,-3.421800562111044358e-04,
   1.487448931117177440e-05, 1.336972579119843794e-05,
   1.365854704345684917e-04, 3.073124250933593045e-05,
   8.777260048110736910e-05,-1.989901014583166463e-05,
   9.403156065196433929e-06, 3.403036293306247420e-06,
   1.541246501446811844e-05,-1.274581979230038649e-05,
  -1.992332447012390434e-05,-1.749611973599325009e-06,
  -5.681161236458803521e-05, 1.929872276954587408e-05,
  -2.372969322393888740e-05, 5.510809069000439697e-05,
  -7.690555142273548250e-06,-6.391819897623047804e-06,
  -3.067464736618273646e-04, 2.868912701635130901e-04,
   1.233460064990155806e-04, 1.310944799781623609e-04,
   3.410868124397343641e-05, 3.655951126310382025e-05,
   1.814294770800052963e-05,-2.389212105412071474e-05,
   2.827784522191768954e-04,-9.800185441921631553e-04,
   2.290174629523642760e-04,-3.989373405221206793e-04,
  -1.248842138430708473e-04,-3.611001430071925767e-05,
   3.981655405925355463e-05, 3.826489624517441595e-06,
   6.221284918808365485e-05, 3.208677914501171027e-05,
  -1.989573087012723823e-05,-2.039581609905843308e-06,
  -1.772728776465666881e-05,-9.259766115245784247e-06,
   5.034235368075771741e-06, 3.968194141242102895e-05,
  -9.241091833181875595e-06,-3.821285350598572516e-06,
   8.813652645190303797e-05,-8.143680190793961234e-05,
  -6.996448799786822599e-05, 2.229443696564885317e-06,
  -3.713001862141382652e-04, 1.963063211344614036e-04,
  -1.766972518448799376e-05,-2.424419130234437808e-05,
  -7.163028231013136092e-06, 6.977895568271915944e-06,
   1.477686903393136801e-04,-2.139261885684032403e-04,
   1.575601540012519863e-05, 1.231860295289273441e-05,
  -4.432692064133952271e-06,-6.985951074166324621e-05,
   7.403633072679337625e-06,-6.722069422813834994e-06,
  -3.014779508519517277e-05,-5.187591398232017345e-05,
  -1.218062883394658281e-05,-2.741591291950040284e-05,
  -1.004484374369349713e-06, 9.949422653684375403e-06,
   6.755723695181588243e-06, 7.372936820179733942e-06,
   1.716820347415036435e-06,-1.992617695130457679e-05,
  -2.277599284579805681e-04,-1.795143865789468622e-04,
  -8.666647381856618299e-05, 1.099496353602674639e-04,
  -3.373859100685921221e-06, 9.413664258338449713e-06,
  -2.454497816577109638e-05, 3.158392070091710992e-05,
   1.171183953319448425e-05, 1.621211937868404852e-05,
  -8.224764321038746445e-04,-1.115012046288315679e-04,
  -2.277832131743202007e-05, 1.886296585321614453e-04,
   7.320726005008853455e-06, 1.861201146463184331e-05,
  -2.185841145025911377e-05, 1.281491703011423380e-04,
  -9.596426123873060717e-06,-2.812224324097684585e-06,
  -6.782249730595004376e-05, 1.732365028463682765e-05,
   3.402454592837421475e-05,-2.103164934968139536e-05,
  -2.521349730500909115e-06, 1.984043335052193649e-05,
   5.183684561265410729e-05, 1.619041118592417453e-04,
  -1.855854317698170630e-05, 2.357075465801012053e-05,
  -1.784361932118153050e-04,-1.891045344566747962e-04,
  -1.810486736834590205e-08,-9.999983610675448233e-06,
  -9.489811716413846989e-05,-3.153327383418106332e-05,
  -2.830992431799460367e-05,-9.927143854574574050e-06,
  -3.706149125578169634e-05, 1.504811835073133570e-05,
  -2.927966542488149887e-05, 6.534614954761985663e-06,
  -2.822130139769707952e-05, 2.834710121723808709e-05,
   1.088172150505470163e-04,-1.912035923005710896e-04,
  -7.797552660607462200e-05,-4.494237700105935593e-05,
  -2.653083800350530095e-05,-1.400409350267838173e-05,
  -9.690321075064878173e-06, 2.469347578238727576e-06,
  -5.996143194424499723e-06,-3.899539027459424643e-04,
  -8.992532414635808781e-05, 3.665525497446310499e-06,
   1.800427099766204039e-05, 8.708973868530413341e-06,
  -2.989829629669190120e-05,-2.468173120998497943e-06,
   9.826902961902506760e-06, 1.852559898451807653e-06,
  -7.654871552062925046e-04,-1.836880348638467424e-03,
   9.592119862205850307e-05, 1.868130714241045883e-04,
  -9.442995718605610747e-06, 3.290870987807958060e-06,
  -1.904824366806855590e-05,-6.096262228766589558e-06,
  -1.830559697414896932e-05,-8.056371355643193643e-06,
   9.576225254786314473e-06, 2.880262118209522696e-06,
   6.932326840030592768e-05,-9.710018449989927091e-06,
  -1.764340307550466469e-04, 1.138904420551929155e-04,
  -4.607695105194670659e-05, 7.731050757663221766e-05,
  -1.997601966283638511e-05, 9.791008272768313393e-07,
  -9.937937575018816626e-07, 5.999176921851488887e-05,
   1.848353461805495734e-05, 2.362962014132186659e-05,
   1.731040998902839596e-05, 1.001747004047159657e-05,
   1.584556996786945396e-04, 6.157752219223644290e-05,
   2.536367200097983671e-05,-6.524326894497784542e-05,
   7.999155847553413243e-06,-1.833067117501571737e-05,
  -5.729921205950044571e-06,-8.195608761623752366e-06,
   2.266934764543638160e-04,-3.885958997512458280e-05,
  -1.175726102439774225e-05,-6.900555639370047523e-05,
   5.775551650291955285e-06,-8.163516591200748081e-06,
  -5.773425960568488328e-05,-4.462810272325985327e-04,
  -3.954377095212459304e-05, 6.024133040189904841e-06,
   1.824325969140930484e-05, 2.381561411830063408e-05,
  -2.678048416396249022e-05, 1.352056463110007515e-05,
   2.119973625207117223e-05,-2.122666207491463703e-05,
  -1.362507981843002556e-05,-5.843250122955041738e-05,
   5.306049220227684712e-07,-1.999296022145608347e-05,
   6.556785334858431815e-05, 1.568466021540107990e-04,
  -3.978669479826642800e-05, 4.125399014592317804e-06,
   9.405991401174425962e-06,-3.395191564703347796e-06,
   5.274028850616243480e-05, 4.602675274540612386e-05,
   4.841834386691519021e-05, 1.247653706703732429e-05,
   2.887892688760567301e-05,-8.124505020019749305e-06,
   1.184173100582992815e-05,-1.611748760773732428e-05,
   2.656273227055187434e-06,-9.640757882201473971e-06,
  -3.307788384158887409e-05, 1.463073942101435665e-04,
   3.901900882813933748e-05, 8.804371077458326080e-06,
  -1.168099536040710834e-06, 9.931542854657652826e-06,
   9.665441179548432883e-06, 2.565004250423264022e-06,
   4.407195328758640058e-05, 1.328821392566239385e-04,
   4.746977749978733972e-05,-1.570414671737003151e-05,
   1.030559620889085998e-05,-1.714044009876334590e-05,
   5.927126280712676420e-05,-9.322950458331923413e-06,
  -1.975711526334375827e-05, 3.107474291277277420e-06,
   1.824809175973770228e-05, 8.185789340570218684e-06,
   7.172926572491702421e-06,-6.967720171307287265e-06,
   1.765599722611024803e-04,-3.502250983522922818e-05,
   9.479909558956947134e-06, 4.909308825847073484e-05,
   2.899276408888500100e-04,-1.097358785841076666e-04,
   3.116060058952233535e-05,-2.508021074274019099e-05,
  -5.355822917811873931e-06, 1.926953971616969329e-05,
   1.722080601213507098e-05,-3.610323863993938946e-05,
  -8.112697064924340158e-07,-2.998902868489287417e-05,
   1.775788186515358361e-05,-9.200958192669367406e-06,
  -1.069071557298464799e-05,-1.690291692393782055e-05,
  -9.344361996208886423e-06,-3.561305783530402305e-06,
  -1.296440555645365813e-04,-9.613472670130557120e-06,
  -3.691615104993091172e-06, 4.986353354824131430e-05,
  -1.088224819042251218e-06, 9.940611990376672837e-06,
  -1.158364310500468325e-04, 5.900780661563130911e-05,
   1.988741597767406394e-05,-2.119123812087070908e-06,
   5.979094672732538875e-06, 3.955060589794423602e-05,
  -2.948331376541775338e-05,-5.543844280815261461e-06,
   2.988206819843738558e-05,-2.657442414039702208e-06,
   1.504815602596495710e-05, 1.693326696187661816e-04,
   2.731771602265772625e-05, 1.239928995166374062e-05,
  -9.711405358248173932e-06,-1.748395281301653371e-05,
  -1.623385036989231911e-05,-1.168169945547081282e-05,
  -1.970514217735069496e-05,-3.421603684004735559e-06,
  -1.906632315527475983e-05, 6.039480220899275588e-06,
  -6.584705188224072832e-06, 7.526065212591170812e-06,
  -7.440380613412860618e-06,-9.972281953659127790e-05,
  -3.988872124372097144e-05, 2.981596475166228087e-06,
   1.328120294666930033e-05,-1.495358312543795495e-05,
  -5.345770232907314732e-05,-7.240355006279878115e-05,
   2.516536605355911466e-06, 9.678173562914841704e-06,
  -1.883793736476801250e-05, 6.718044048759817779e-06,
   2.841083595192777596e-06,-1.979717767776827770e-05,
   2.988478196271418869e-05, 2.626748377944256052e-06,
  -9.809406348948979500e-06, 1.943076704919149188e-06,
  -7.147750032545556551e-06, 6.993544843085301485e-06,
  -3.465623768836592991e-06, 9.380269286799546133e-06,
   1.015069915510281293e-06, 9.948348258209800362e-06,
   5.536010273844022079e-06, 8.327820257900229390e-06,
   6.849504531050805889e-05,-1.443706230198677026e-05,
  -4.426124861269568383e-06,-1.950408723094858098e-05,
   5.001069560372139663e-05,-4.897887631655018566e-05,
  -1.961517437312419021e-05, 3.904476189187489445e-06,
  -8.012043601205085089e-06,-1.832504180984012733e-05,
  -6.436490453454611167e-06, 7.653207866155712819e-06,
  -3.594866029211512171e-06,-9.331502463806194605e-06,
   9.302755443450479592e-06,-3.668615700690450122e-06,
   8.938264552865476020e-06, 2.863751781811734782e-05,
   3.200811821085325186e-05, 2.398917190317424150e-05,
  -3.999980619397774728e-05, 1.245168431161749251e-07,
  -1.840816587367403957e-05, 7.819170618889355334e-06,
   7.401153777931865738e-06, 1.858017553080177213e-05,
  -1.857657429242237347e-05,-3.542472141821460026e-05,
   5.767831917502670556e-06, 1.915025104199517987e-05,
   4.561310831371848274e-07,-2.999653220682344394e-05,
   9.199859388735687354e-06,-3.919513646805154865e-06,
   3.728639235127800133e-05, 3.331253435910509623e-05,
   3.331253435910516399e-05,-3.728639235127794035e-05,
   2.499432385404504696e-05,-1.659167788619085975e-05,
  -4.037460867669402851e-06,-9.148710824047192071e-06,
   1.046736008370815097e-05, 1.704213522062283617e-05,
   1.566696014021326503e-05,-1.243166762606565268e-05,
   2.010666944188506782e-05, 2.226481178799329810e-05,
   7.364523855786594810e-06,-6.764893818645653023e-06,
  -1.980403021314151770e-04,-2.253442671374130638e-04,
  -3.432432922953019964e-05,-2.053875417212102657e-05,
   2.183199810342716966e-05,-2.057580761019971584e-05,
   1.189597400826993485e-05, 3.819012702773540879e-05,
   2.051143664564091375e-04, 1.755793173274856390e-04,
   2.573302073128754214e-05,-3.062371048784137223e-05,
  -7.897354715226628883e-05,-1.277414772846999204e-05,
   1.762408094620904824e-05,-9.454722143007228413e-06,
  -1.190888667922493138e-04, 1.967684980024442384e-04,
  -3.643413794531196961e-05,-1.650919719980286436e-05,
  -9.263258837505025526e-04, 6.368326326718107278e-02,
  -2.238260202262603245e-05,-1.584266995386091450e-04,
  -3.578294837566541118e-05, 3.492249426293123093e-05,
   1.397210004330993261e-05, 1.431015095586830775e-05,
   3.478513404221068048e-05, 3.591649272500637108e-05,
  -1.436358060457371611e-05, 1.391716753567024701e-05,
  -4.633901602883034704e-06,-1.945576921981750069e-05,
   3.765108148095468318e-06,-9.264122226802987131e-06,
  -4.999958871762551210e-05,-2.028005628593556520e-07,
  -3.399094604279742312e-04, 7.845935990271180169e-06,
   5.693020001765368367e-06,-4.967483792886997942e-05,
  -2.850232783008292930e-04, 2.947231426723188278e-04,
   2.395781073007954078e-05, 1.805611544662045177e-05,
  -1.781769075811090650e-05,-9.084596636523233738e-06,
   3.420236841735188523e-05, 8.324781074985535098e-05,
  -1.017744185028440925e-04,-6.357647157878412237e-05,
   5.827843228055227593e-05,-9.329321696094031874e-05,
   8.896811420106137059e-06, 4.565823754271405407e-06,
  -6.500909287739394757e-06, 7.598564234944894093e-06,
  -1.263147963255757290e-05, 1.550631233698983926e-05,
  -1.971004350893091380e-05, 3.393255792900158345e-06,
  -1.240955037748925262e-04,-2.054271285198589771e-04,
   9.846198396931682417e-06,-1.747105356943302603e-06,
   1.966236226547344039e-04, 7.375060009334582763e-05,
  -7.023935310101606019e-06, 1.872603355650918127e-05,
  -2.760875576637305162e-05,-1.173697597478851897e-05,
  -5.886897674482795385e-06,-8.083590524647390590e-06,
   8.457112839536438226e-06, 5.336407257635790362e-06,
   2.766463049598415528e-05, 4.164934836849988034e-05,
  -8.896690516745146523e-06, 4.345797038112907563e-05,
  -9.685485852059537481e-04,-1.772657225211785167e-03,
   4.412007978245300950e-06, 8.974084109250360952e-06,
  -7.361702544052944728e-06,-6.767963922250503676e-06,
  -3.333648466744176880e-06,-1.972021267380690075e-05,
   9.857697327723529421e-05,-1.260261097530953949e-04,
  -9.451976296627808154e-05,-7.393249900279719546e-05,
   5.625197468704687868e-06, 8.267838498548359344e-06,
  -9.007949283822989835e-06, 4.342447432044849791e-06,
   6.405079057246558200e-06,-7.679515757547578214e-06,
   7.983485328190712877e-06, 6.021956659970546990e-06,
   9.843425619927657284e-06, 1.762660507571395160e-06,
   2.910735333151734527e-05,-7.263744353582806810e-06,
  -7.263744353582825444e-06,-2.910735333151734188e-05,
  -8.953145830205941984e-06,-4.454343918363958338e-06,
  -1.773027211274521508e-07,-9.998428063704855614e-06,
   5.233261540216096077e-06,-1.930318558299886329e-05,
  -1.930822390205905572e-05, 5.214641861907247813e-06,
   6.429873695904647071e-04, 5.711105344389429692e-04,
   5.246400501244492332e-04,-5.906376366313066759e-04,
  -5.751908802709187118e-06,-8.180192242564753781e-06,
  -6.413445694107735209e-06, 7.672529851928303843e-06,
   7.684417897757441087e-06,-6.399196947479045952e-06,
  -8.563214486214593946e-06,-1.807405205434256323e-05,
  -1.995062080655554299e-05, 1.404538868466495798e-06,
   4.943373007367192160e-06, 2.958991489190250274e-05,
   4.904274543149227171e-05,-8.714820204996684525e-05,
  -8.714816781165031761e-05,-4.904280627240284869e-05,
  -6.372986377354465752e-07,-9.979671860654566227e-06,
   5.245176646244858138e-06, 8.513995651260785065e-06,
   2.808012743869301323e-05,-2.848695215404343673e-05,
  -1.678528324391817390e-05,-1.087447775396317038e-05,
   6.961402192468915186e-06,-7.179058400284051106e-06,
  -3.490571462893275981e-06, 9.371014398795634638e-06,
  -1.996508977077606812e-05,-1.181181800085327198e-06,
  -1.156315030848925792e-06, 1.996654540849349975e-05,
  -2.011591325504570874e-06,-9.795585757837801740e-06,
   1.759679334193665042e-06, 9.843958992235378181e-06,
  -3.507759931002649482e-05, 1.922399611540818822e-05,
  -1.114512648061964923e-05, 1.660681052252330439e-05,
  -1.972262842743978094e-05,-3.319326424614531571e-06,
  -7.369021942678943768e-06, 1.859294262908150474e-05,
   1.355268382978219465e-05, 1.470798290079099563e-05,
   1.472937840392249052e-05,-1.352942762403723287e-05,
  -1.885217294289710699e-06,-9.820690187217545939e-06,
  -1.844616818549868619e-05, 7.729093043319908781e-06,
  -1.275720417474653795e-04, 1.792355270708989709e-04,
   1.710884576585855747e-04, 1.217733125771257508e-04,
   9.864463109662034246e-06,-1.640843550774068716e-06,
  -2.352680519812772042e-03, 2.859971532961557913e-04,
   2.642841980573163623e-04, 2.173994908608849891e-03,
   4.865109258625814764e-06,-3.970303152029620235e-05,
  -3.974851407460710818e-05,-4.478351131919087548e-06,
  -1.993841136696330465e-05, 1.568359704196886914e-06,
  -3.163964602938840130e-06,-9.486270499587817095e-06,
  -7.629997132116163769e-06, 3.926554652317855101e-05,
   2.944915989238392173e-05, 5.722497849087072428e-06,
  -9.939839591430974856e-06, 1.095257456775045058e-06,
   7.542945032375910285e-05, 2.665329292705796978e-05,
   2.665356939025387292e-05,-7.542935263383162572e-05,
   7.780474557131816340e-06, 6.282055051161561436e-06,
  -4.921478698487162354e-06,-1.938502121279048776e-05,
   4.701089818872851245e-06,-8.826083758660465290e-06,
  -1.777314814483957681e-05,-9.171434185643243382e-06,
  -9.171434185643212889e-06, 1.777314814483959375e-05,
   1.168706130306335235e-05,-1.622999069927149340e-05,
  -1.622999069927147308e-05,-1.168706130306338115e-05,
   1.431564828747901167e-05, 1.894599224482824485e-04,
   1.794883475825834022e-04,-1.356219311445351388e-05,
  -2.997877820948985361e-05,-1.128209672984733178e-06,
  -1.128309086371819925e-06, 2.997877446804006311e-05,
  -1.163811635539804507e-05, 1.626512366071087006e-05,
   1.626512366071089039e-05, 1.163811635539801797e-05,
  -9.142570724227077285e-06,-4.051345523712582279e-06,
  -6.990177507508909510e-06,-7.151043169602359026e-06,
  -5.352096205025987467e-06, 8.447192800696954297e-06,
  -1.594100715410194533e-05, 1.207825694845372521e-05,
   1.207825694845369472e-05, 1.594100715410196566e-05,
   4.252085097269451301e-06, 1.954276777546054536e-05,
   7.568501130451134948e-06, 6.535884839741281018e-06,
   3.722308004859746305e-05,-1.464384893720587924e-05,
  -1.464384893720594362e-05,-3.722308004859743594e-05,
   7.639543147229103145e-06, 6.452703348335863743e-06,
  -2.657778004528694281e-06,-9.640343151498472312e-06,
   7.707800398370666793e-06, 6.371013500133005265e-06,
   8.818674763279823250e-06,-1.795079316964828708e-05,
   2.895971835306974880e-05,-7.831648160564620207e-06,
  -1.044162471150998040e-05,-3.861311271296299094e-05,
   3.425599975131802441e-06, 9.394959542774892667e-06,
  -1.923672234111154029e-05, 5.472523510317723393e-06,
  -7.160503199762812874e-05,-3.567519295839412897e-05,
  -1.783190367178790812e-05, 3.580535171507294619e-05,
  -2.077791476820982101e-05, 2.163973793475808968e-05,
  -1.446933834766708840e-05, 1.380718102223371047e-05,
  -2.181570194004596512e-05,-2.059308497683323558e-05,
  -3.435465350232682090e-05, 3.632847069083783645e-05,
  -1.937224365185533117e-05,-4.971536572645409314e-06,
  -1.134675374611062639e-06, 2.997853418354959077e-05,
   6.591604678883301150e-06,-6.968895714356273207e-05,
   4.112801309866211867e-05, 2.843389770250075160e-05,
  -8.525916762970722206e-06,-5.225776817937679112e-06,
  -1.799235153050648254e-05, 3.572499526105890925e-05,
   9.683500612053049474e-06, 2.495959914815988736e-06,
  -4.616199459899086298e-06, 1.945997694105590261e-05,
  -1.798849296399797571e-05, 8.741517081387844204e-06,
   8.741517081387874697e-06, 1.798849296399795877e-05,
  -1.545770017364808262e-05, 1.269092216277446302e-05,
  -1.126019494581486261e-05,-1.652900510563916158e-05,
   3.136205664069834840e-06, 1.975257487095432671e-05,
   8.431157758614224386e-06,-5.940467640556052538e-05,
   4.950388351565849197e-05, 7.026059839491522270e-06,
  -3.196280472972635330e-06, 3.987209288635466163e-05,
  -2.990406966476600808e-05,-2.397210354729315032e-06,
   1.285754494812644183e-05,-1.531938438407066830e-05,
  -1.962215888161872386e-05,-3.869222250596562105e-06,
  -5.965832505506042069e-05, 3.661808640036709299e-05,
  -3.515984269130050188e-05,-1.355130453569802990e-04,
   2.585464380786461815e-05,-1.521635283398908971e-05,
  -7.886840157468471039e-05,-1.340802867890247660e-05,
  -2.008126807017395338e-06, 5.996638580677460424e-05,
  -4.309262088481684012e-06, 1.953023963633766037e-05,
   1.952405007953842141e-05, 4.337218981291557937e-06,
  -1.067889654520607452e-03,-1.802840014215814635e-02,
   7.976503651110768785e-05,-6.126903816909288198e-06,
   1.869142518889687146e-04, 2.346551990491306755e-04,
   7.576291502465531085e-07,-3.999282433225611390e-05,
   9.521039376496049693e-08,-1.999977337323898718e-05,
  -1.999977337323898718e-05,-9.521039376495283393e-08,
   2.689430941831903840e-04,-2.386654753355780471e-05,
   4.928138016235947941e-06, 8.701347923909836531e-06,
   1.997878675653608023e-05,-9.209124479876361695e-07,
  -1.994265840044179159e-05,-1.513398798495777774e-06,
  -8.775455673262612475e-04, 2.415509357640955950e-04,
   2.957173215731107789e-04, 1.059505198534497735e-03,
  -3.802806157716331307e-05, 1.240429492891376665e-05,
   1.240422192025382578e-05, 3.802808539162989289e-05,
  -1.947757210069469205e-05, 4.541385808565461855e-06,
   2.999974372071830965e-05, 1.240027871561509179e-07,
  -2.942843176686439161e-05, 5.828156118619926273e-06,
  -6.111730667506845708e-06, 1.904328617250332782e-05,
  -1.575901962521450829e-05, 1.231475945571427008e-05,
   9.943476441033977190e-06, 1.061732671910543021e-06,
   3.056339305295819061e-08,-1.999997664696149434e-05,
  -5.999084421666560894e-05, 1.048146064133420806e-06,
   9.956157849736494674e-07, 5.999173900803936278e-05,
   8.437234591677796709e-06,-5.367780960974060839e-06,
  -5.767649382656934443e-06, 2.944035021189009285e-05,
   1.962675718414772972e-05, 3.845829225863461272e-06,
  -6.093131099590942909e-07, 9.981419615166571099e-06,
   2.875469155706123956e-04,-3.061319508738464179e-04,
   5.721454490197842770e-04, 5.456680063368665994e-04,
  -9.250827410710363514e-08,-9.999572101806243504e-06,
  -1.659435102177196972e-07, 9.998623042770272086e-06,
  -9.476305963490736100e-06, 3.193685220291743747e-06,
   2.977907764966034325e-05,-3.634079571982409326e-06,
   1.734714672237248716e-05, 3.604270384686035028e-05,
   1.156340602180894644e-04,-3.207435295495857292e-05,
   1.196995320707716854e-03, 1.031310914420976131e-03,
  -8.482811787268980733e-05, 9.850984934602753879e-05,
   5.273405285593873960e-04, 1.562432940599561284e-04,
  -7.107464920754621930e-05, 2.396839465630192119e-04,
   9.672700247441710206e-06,-2.537492841988149512e-06,
   7.250965168469698800e-06, 4.947144129824438091e-05,
   1.646853255341114872e-05, 1.134845520488305851e-05,
   9.272965017571054824e-06,-2.853089763366907139e-05,
   7.916501891593438601e-06, 6.109746132238026612e-06,
   2.936044423334815932e-05, 5.232556081324358648e-05,
   5.232549932075823419e-05,-2.936055382368203733e-05,
  -1.972787968667297513e-05,-3.287972485918313035e-06,
   3.820572654219833436e-06, 9.241386508193867122e-06,
   7.211377306465464160e-05,-3.014956114678611393e-04,
  -3.960816521477869085e-05, 5.585091612390570879e-06,
   1.698067843329690698e-05, 2.473169140889812603e-05,
   2.627698419635457392e-07,-1.999827372575329340e-05,
  -1.999818501817671721e-05,-2.694364095150820648e-07,
   7.454344887669770787e-06,-6.665788947729410160e-06,
  -1.635194312018768622e-05,-1.151581331014647500e-05,
   2.004088876425076833e-04,-9.075394070723726220e-05,
   2.555242930564854796e-05, 1.571856725595031259e-05,
  -1.512236320881480566e-05,-5.806301861753903194e-05,
  -8.092431015205172952e-07,-1.998362143363012868e-05,
   3.845518260903907426e-06, 1.962681811463729586e-05,
   1.962681811463729586e-05,-3.845518260903906579e-06,
  -1.986072073481856703e-05, 2.356219831328968572e-06,
  -1.057591203000633290e-05, 1.697498408640100507e-05,
  -2.525177069895148779e-07, 9.996811231970761087e-06,
  -1.881717511513249423e-05, 6.775981160425287894e-06,
   6.775981160425320081e-06, 1.881717511513248406e-05,
  -9.925863288362529187e-06, 1.215416793012587413e-06,
  -7.713183179248913864e-05, 1.168361267944772249e-04,
   1.335266943461494197e-04, 8.815113100233025727e-05,
  -4.557576543878887452e-07, 9.989608849222619160e-06,
   9.091453809100522222e-06, 4.164789026708511853e-06,
   9.711280020662540314e-06, 2.385590149267178147e-06,
  -1.820268832860918464e-05, 8.286261980622811800e-06,
  -8.286325519941131217e-06,-1.820265940398744012e-05,
  -7.189616229708294939e-07, 1.792646566443013199e-06,
  -1.343645092610676588e-04,-3.932147824068238519e-05,
  -8.545011468804711814e-06, 4.926441696598059066e-05,
  -2.628257806557845075e-05, 1.446464967521766826e-05,
   6.937815086545654657e-05,-9.309789605031361907e-06,
  -9.309789605031480492e-06,-6.937815086545653302e-05,
   7.251179206681167256e-05, 1.197582565473440114e-04,
  -1.542257507047690447e-06,-2.996033113605313901e-05,
   9.621116833188182407e-06,-2.726556598008376916e-06,
  -1.190870566963695570e-04,-5.213705905970973816e-05,
   1.795554469066320603e-05, 8.808996245974700821e-06,
   5.230483498923823477e-06,-1.930393851957381529e-05,
  -1.435733715427988557e-05, 1.392360836271741788e-05,
   1.250651589830103328e-05,-1.560727587010441415e-05,
   2.457054289288767508e-05, 1.721303058583139299e-05,
  -1.710874851238607168e-05, 1.035812359165150525e-05,
   1.080605378426193883e-05, 1.682941477329613742e-05,
   1.738289355459456749e-04, 2.445066485128031034e-04,
  -2.853924671555747771e-05, 2.802697623555816062e-05,
   1.267993464290244501e-06, 9.919283874076657961e-06,
   1.160595814318269550e-05, 1.628808569411062837e-05,
  -9.361333711247356965e-06,-3.516451499262260939e-06,
   2.662627720854120628e-04,-1.149092520269447582e-04,
   2.763104567110480041e-05,-1.168440478250050423e-05,
  -1.734541265122840267e-06,-1.992464219502036824e-05,
  -2.706810791529904170e-06,-9.626690778188384245e-06,
   8.929300172683667808e-06,-4.501954956028707562e-06,
  -1.217817010470439483e-05, 1.586480926140885746e-05,
  -1.258278117369577853e-05, 1.554585532979408380e-05,
  -1.977657391061220842e-05, 2.981128034501811516e-06,
   6.678845279488756072e-05, 4.403751325024015859e-05,
  -2.868463766927551180e-05, 5.269906604279036162e-05,
   9.390472322873075290e-06,-3.437881550221699792e-06,
  -3.191043353844523332e-05,-1.260227131567499023e-04,
   4.013926444118702877e-03,-6.732714914539187105e-04,
   4.084427876777131514e-05, 4.395161990121166799e-05,
   2.572801829013433186e-05, 1.542948718728245038e-05,
   3.366402910797167830e-02, 2.643053431578020959e-02,
   3.042062973759555939e-05,-3.968104442133695833e-05,
  -5.553803935644606015e-04, 4.423263709572208260e-04,
   8.705628911587774454e-06, 4.920571638918295292e-06,
  -2.631847431682834072e-06,-2.988433333866333006e-05,
  -2.988333024883605823e-05, 2.643212673811898098e-06,
   9.311533999313695160e-06, 3.646276810614509783e-06,
   4.476256707908885412e-06,-8.942210346715219967e-06,
   5.473813357136763638e-04,-3.687460824365616286e-04,
   1.616297076095749865e-05,-1.177957453308195774e-05,
  -2.921569155140873238e-05,-6.814937063021524851e-06,
   5.787554931884626009e-05,-5.523061461763570775e-05,
  -1.736322955011299407e-05,-9.925636482870153012e-06,
  -7.056362625118072744e-07, 9.975072804998888623e-06,
  -6.644410982353291189e-06,-1.886403463465816937e-05,
   1.117340609457409173e-05,-4.873556192602825098e-05,
   6.678732076296110010e-06, 1.885191072154368007e-05,
  -7.252440419519390173e-05,-8.270556689928520706e-05,
  -6.544324105756926238e-04,-1.371903137975887931e-03,
   3.850367543146349965e-05,-3.189775820129863679e-05,
  -1.736377994295648482e-05,-2.446424219330290700e-05,
   4.101568550377998922e-06,-1.957491086637561741e-05,
   2.209950816048784003e-05, 2.028821675417855327e-05,
   1.917911692126360318e-06, 1.990782797648214307e-05,
  -1.866206371140504330e-05, 7.192174777593986749e-06,
  -1.535736385646481819e-04, 2.577113453808636519e-04,
   2.243852035335620616e-05,-1.991262926767882588e-05,
  -1.033368946191227105e-05,-1.712351780752901733e-05,
  -2.506509034455714743e-05,-1.648457600362193223e-05,
   1.193759054232102851e-05, 4.855403105864524880e-05,
  -8.869298614791237397e-06, 2.865895221534908721e-05,
  -1.913395550136188367e-04, 5.821661865129518345e-05,
  -7.422780038410163116e-06, 1.857154642191596335e-05,
  -1.784366361209689599e-05, 9.033474907162203127e-06,
  -3.139750041187678285e-05, 3.891268389466598512e-05,
  -3.219446964522910858e-06, 1.973917833250979906e-05,
   1.657937296658071013e-05, 1.118590148512907269e-05,
   1.305836034472515118e-05, 1.514857171839344364e-05,
  -1.800055865567872128e-05, 8.716644313236025546e-06,
   1.487524051900566117e-05, 1.336888998764416031e-05,
   1.461493479356669377e-05, 9.892625374985041767e-05,
   1.897660981263324517e-03,-2.058854730230065370e-03,
   4.204749822545081041e-05, 6.805885609515276700e-05,
   4.077294848321127833e-04, 4.401779949049473644e-04,
  -1.057267481678210420e-05, 1.697700053656656983e-05,
   2.027402512680177520e-05,-2.211252823984200929e-05,
   6.770193885645564196e-07, 2.999235977290729379e-05,
   6.999986335965093398e-05, 1.383099063602539143e-07,
   8.910238005979876884e-06, 4.539565912814985169e-06,
   2.136598607675000241e-04,-3.960422501410834520e-04,
   2.643509450820072295e-04, 1.418399726249606281e-04,
   2.266757824424728269e-05, 8.797080088850737622e-04,
  -1.029658089477119643e-03, 2.653712068646647997e-05,
   1.353470386974439346e-05,-2.677334105333748049e-05,
   4.592200985109028697e-04,-2.677500931160730217e-05,
   3.091230580227649795e-05, 5.992031619993226773e-04,
   7.226562997704395039e-06, 2.911660672606287110e-05,
  -2.911660672606287110e-05, 7.226562997704396733e-06,
   1.431761291075358189e-04,-2.521915860090939774e-04,
   2.434380978402972883e-04, 1.383397720104302924e-04,
   6.315998121536257860e-05,-3.017974110019908883e-05,
   2.586547706987325421e-05, 5.413849920295040272e-05,
   7.006083099431796570e-06,-5.958955277230948097e-05,
   5.958955277230948097e-05, 7.006083099431793182e-06,
  -9.954415377370830304e-06,-1.596900423147754196e-04,
   2.097324232403377866e-04,-1.059767152424640000e-05,
   4.832484906837425717e-05,-1.283389896013085526e-05,
   1.283389896013085864e-05, 4.832484906837425717e-05,
   6.040173645863206747e-05, 5.245598376526703477e-05,
  -7.212738354691330077e-05, 8.305203515072018825e-05,
   1.701388193316517424e-05,-1.051322127439139389e-05,
  -1.929648600401534853e-05,-5.257910982209554587e-06,
  -6.939070236532248956e-05,-9.215770464113482441e-06,
   1.316156276371128918e-05,-9.913008254620234410e-05,
  -1.230544669127013747e-05, 3.806016266029756259e-05,
  -6.721348686501333355e-05,-1.955369999377816234e-05,
  -1.591492620267746103e-05,-2.543059425108525523e-05,
   5.086132738561758453e-05,-3.182963048125169592e-05,
   2.721005888437260311e-05, 1.263379181041763192e-05,
  -1.684504941515496370e-05, 3.628008145251313530e-05,
  -1.833547210612344771e-05, 7.988145131729205726e-06,
  -1.997015481978459004e-05,-4.583877088746855549e-05,
  -1.986996772921136655e-05, 2.276923898618265695e-06,
  -4.799037435530808442e-05, 3.601283061961928905e-05,
  -4.801710749282606658e-05,-6.398716580707718387e-05,
  -1.800867470346976748e-04, 3.232162798227539743e-04,
   3.143537702365732970e-05,-5.110593968787303877e-05,
   3.047049370782378702e-05,-2.591426273698465435e-05,
   3.239282842123101868e-05, 3.808811713477955590e-05,
  -8.811755203933367928e-06, 4.727892789177142619e-06,
   7.662019654822688046e-05,-2.300750922875144651e-05,
   1.546837741323142646e-05,-1.267790598647236624e-05,
   1.821798786835245966e-06,-9.832652194615938552e-06,
   1.519733240825821714e-05, 1.300158019907213250e-05,
  -3.596364301144369294e-05, 1.751046490946020991e-05,
   1.726214607741446215e-05, 1.010041151646825564e-05,
  -3.448612181195681738e-05, 2.026591725954876919e-05,
   7.389013280923513036e-06, 6.738136443731008146e-06,
   9.833294777570622750e-06, 1.818327203063937351e-06,
   9.846848015320659256e-06, 1.743440323950209349e-06,
  -1.107336939867755594e-05, 1.665474377348482497e-05,
  -3.434986440350665055e-07, 9.994098692805975220e-06,
  -2.944538277303334540e-05,-5.741901544745529304e-06,
   3.827934363163689591e-06,-1.963025518202223140e-05,
  -5.655400225689778785e-05,-3.047977113246206683e-04,
   2.654634792979636932e-04,-4.928631817268955902e-05,
  -4.236936028882346125e-05,-2.654877226381419062e-05,
   2.123901781105135114e-05,-3.389548823105877171e-05,
   2.957599650811074620e-04,-5.025975582135366594e-05,
   6.208730139865024976e-05, 3.647535702430247250e-04,
   4.560088818362981720e-05,-3.899434570375672463e-05,
   5.199215319522864444e-05, 6.080144740155350448e-05,
   7.645071345179429447e-05,-2.356455840264440590e-05,
   1.727185395554947336e-05, 5.746027376316762786e-05,
   2.466322610634794749e-04, 7.505148418270725461e-04,
  -9.021393975647612126e-04, 2.977322746386250893e-04,
   6.946062833431773816e-05, 8.673010515488566844e-06,
  -7.434040187131954689e-06, 5.953767753696903689e-05,
   2.336597769397349058e-05, 4.420442383296872688e-05,
  -1.257449828704626244e-04, 6.154834914851135960e-05,
  -1.353369387405712861e-03, 1.156196912828037727e-03,
  -3.471321296639539135e-05,-7.207629877809820177e-05,
   2.672582151797342806e-06,-3.991061644026429447e-05,
   2.440383059913780523e-05, 1.744858309687595890e-05,
   3.991069805102479559e-05, 2.671363150139996657e-06,
  -1.411264243980817752e-05,-1.417156742799204804e-05,
  -6.766640235220269316e-06,-7.362919253061124982e-06,
  -6.444276653243449489e-05, 1.012281079623942334e-04,
  -1.602755224792151451e-04,-1.020380169055367590e-04,
   1.110514707516649319e-05, 1.663357172825250752e-05,
   6.830879224538051551e-04, 9.621802794683251975e-04,
  -8.813384718549348556e-04, 6.242135035614082648e-04,
   3.242237262173099907e-05,-5.048554004442884231e-05,
   4.207030248890195024e-05, 2.702017114106219711e-05,
  -1.553105771567255987e-04,-6.912759668355893019e-05,
   1.057284566219225257e-04,-2.375320893276237639e-04,
   7.894799642944309140e-06,-6.137763322071520561e-06,
   4.440287940853939147e-04,-5.411454795367608150e-04,
   5.025082781657380909e-04, 4.122928939175462973e-04,
  -5.922504789352936894e-05, 9.612164272896731810e-06,
  -8.004589469968888171e-06,-4.935510659918853282e-05,
  -7.049899460663231236e-06,-7.092172981149028432e-06,
  -4.098712559898793251e-04, 3.961130564791809448e-04,
  -3.465516870330215206e-04,-3.604191007904085776e-04,
  -5.925044870763181121e-05, 9.454328529530390743e-06,
  -9.454328529530380579e-06,-5.925044870763181121e-05,
   1.718170909944321753e-04, 8.111033992168334493e-05,
  -9.368272323601259800e-05, 1.990566436145366929e-04,
  -8.187531813856698500e-06, 5.741456504850007495e-06,
  -7.664332447162897251e-06,-6.423239691881816204e-06,
   6.960552606852718201e-05,-2.505096220521750116e-04,
   3.275952718817239724e-04, 9.100185624886661460e-05,
   1.044881527417472929e-05, 2.812156217862323758e-05,
  -1.808497410945942777e-05, 8.540123620895795264e-06,
   5.188283926862946957e-05, 6.089475338176156087e-05,
  -6.089475338176146601e-05, 5.188283926862957799e-05,
   9.877978044210024882e-06, 4.901454426757536015e-05,
  -2.959620435286034341e-05, 4.905577224316274115e-06,
   7.435946066519373770e-06, 6.686307358760519173e-06,
  -1.333480775396837578e-05, 1.490580095683237520e-05,
   6.327418696592572271e-03, 3.602051564103685415e-03,
  -3.055020421090005617e-03, 5.350817355733448674e-03,
  -6.999321842928178834e-05, 7.036688667862698882e-05,
  -4.665151726731381186e-05,-7.076782313949524033e-05,
   2.941099631120593148e-04, 1.496640557990565194e-04,
  -1.133817826782597995e-04, 2.228106176929184508e-04,
  -8.488174538234316487e-06,-5.286860411290492288e-06,
   5.913818354143536837e-06,-8.063916695638357159e-06,
  -6.221506579250761797e-05,-1.141458960647904547e-04,
   7.598299842531403709e-06,-1.850042808972233749e-05,
   1.053654525446457644e-04,-5.742927311103633136e-05,
  -1.946672453554878170e-05, 4.587661262240614544e-06,
   8.737260649813334817e-05,-2.158767318916854521e-05,
   1.918904283481648952e-05, 7.766453910945187106e-05,
   4.862916357826701326e-04, 6.017013352000196824e-05,
  -7.238945710909306405e-05, 5.855422841259637357e-04,
  -1.278069023780189322e-05,-2.714136984467356331e-05,
   3.881731306691643029e-05,-9.654854026084447888e-06,
   7.241140519563389703e-06, 2.911298480018730916e-05,
   9.980477668550742811e-06,-6.245522456607957156e-07,
   7.738059615218917245e-05,-4.595914859015347856e-05,
   4.085257652458074861e-05, 6.878275213527934421e-05,
   1.567719835735937944e-04, 1.543455382134541784e-04,
  -1.471457705280042772e-04, 1.498269742593766362e-04,
  -6.826562069956434900e-05,-1.548563949287242543e-05,
   1.106117106633745617e-05,-4.876115764254597228e-05,
   2.991149272795324518e-05,-2.302738106168415928e-06,
   1.225028369043210133e-06, 1.996244738239876597e-05,
   3.321740824461456897e-04,-2.228460880317651056e-04,
   1.726835217336449479e-04, 2.574498034989845590e-04,
   2.701502406752590737e-05,-4.207360781571977461e-05,
   3.342242801122215412e-07,-9.994413145882227284e-06,
   1.999411443028900062e-05, 4.851681651852142989e-07,
   7.484682820509508904e-05,-6.631705894893848586e-05,
   4.643305050251999986e-05, 5.238293444463020898e-05,
   3.700130411695587521e-05,-4.723244111460410405e-05,
   3.148829838169947608e-05, 2.466753058222614754e-05,
   7.754267784680498980e-03,-4.554378001383126997e-05,
   4.349829478787137693e-04, 1.428340728019554355e-02,
   3.604850114022061398e-05,-7.124384918800986347e-05,
   1.202674350421087342e-04, 2.613186011935327829e-05,
   9.972845176028498443e-06,-7.364503343506126663e-07,
  -1.475240011311709667e-06,-1.994551746405755812e-05,
  -4.974119581154025884e-07, 3.999690714722732549e-05,
   3.116769955293372863e-04, 1.084317778965441419e-04,
  -5.957248027897795622e-05, 1.804192883075720114e-04,
  -6.283431015265834739e-06, 4.960361372598165556e-05,
  -4.960361372598165556e-05,-6.283431015265831351e-06,
  -1.865783187876929493e-06, 1.991278114919751313e-05,
  -2.829194996305349626e-05,-9.978254721547113196e-06,
  -3.982034170790662122e-05, 3.786870246727815991e-06,
  -1.952900876275015688e-06,-1.990442609490271982e-05,
   4.020626627645796275e-05,-1.130639471808169317e-04,
   1.036417714700347794e-04, 3.685625057643662864e-05,
   5.218468397573963963e-05, 2.961011243396726011e-05,
  -2.961014886574222550e-05, 5.218466330396876498e-05,
   1.825935750271982121e-04, 2.463241682490532099e-03,
  -2.253823418209651656e-03, 1.669730503098088383e-04,
   2.119727426781015112e-03, 3.912704389057821038e-03,
  -2.493723405169299983e-05,-1.667736063803511748e-05,
  -3.455452572917004986e-03, 1.872097090516742840e-03,
  -2.990239114088780555e-05,-2.418057910256592727e-06,
   2.056099324552757967e-04, 1.237923894095954811e-04,
  -4.538767567603534678e-04, 6.095866547691993235e-04,
  -9.807925870128356084e-05, 1.627281752266850003e-04,
  -2.776581838151138092e-04, 8.370145136431304898e-05,
  -1.233421386477038585e-04,-4.119304757283813521e-04,
  -1.161600721077299797e-05,-1.628092062750966800e-05,
   6.471674137902159107e-05, 4.702917589412805897e-05,
   5.584829060833838973e-05, 4.220152172761760861e-05,
  -3.617273290938652651e-05, 4.786996337857577134e-05,
   6.854893415727896476e-05, 3.737660279184038480e-04,
  -2.754065468872449207e-04, 5.050974095799503380e-05,
   5.359808982778448361e-05,-2.696747609274449350e-05,
   1.349537861250052989e-05, 2.679318488170570812e-05,
   7.167728433602409106e-06, 1.867146670998632595e-05,
  -7.472821910056301681e-05, 2.856034436168881677e-05,
  -4.635442375366890410e-05, 2.150610782974578521e-04,
  -5.863919605181077766e-05,-1.270608855617258104e-05,
  -1.999509808453211841e-05, 4.427782627230470638e-07,
  -2.964322403172776714e-05,-4.612945805534397692e-06,
   3.075297203689601850e-06,-1.976214935448517809e-05,
   2.707242112321131999e-04, 8.268061450259970961e-04,
  -7.397294983473853358e-04, 2.473868817757431809e-04,
   5.844649251021983845e-05, 1.356493690559658634e-05,
  -1.423414384357369427e-05, 3.738166862300896934e-05,
  -1.908643221927645546e-05, 6.734766592198251857e-05,
  -5.772657079027073020e-05,-1.635979904509410226e-05,
  -5.649372756436813711e-05,-1.170831275029965543e-04,
   7.672866912377167769e-05,-2.264312996241396209e-05,
   8.103190699141107065e-05,-3.916414239243988667e-05,
  -1.561962982074700565e-05,-1.249108339027607835e-05,
   2.994671146659384106e-05,-1.787308685307875382e-06,
  -8.759893898778774239e-06,-1.797955113127517777e-05,
   1.834864537696912875e-05,-2.373451522214493315e-05,
  -1.696531588176700578e-04,-1.085383357097498381e-05,
   4.469274357561445386e-06,-6.985717992244492257e-05,
  -1.956757220837063244e-06,-9.806686554525030609e-06,
  -2.612391763168506295e-04, 1.259130364866697363e-04,
  -1.041739188057932015e-04,-2.050555891475382576e-04,
  -2.913043535995352940e-05,-5.245395824663348487e-05,
   5.245353116650828661e-05,-2.913120437201565491e-05,
   2.686390788772583430e-05, 1.335404257143812601e-05,
  -2.199863299671253505e-04, 2.452473770513004824e-06,
  -3.150404094742234145e-05,-2.379232973123547134e-04,
  -1.998244743226618985e-06,-1.799889080414295223e-04,
   3.092285734569748192e-04,-1.097259171462131987e-03,
   1.303757014644469000e-05, 1.516646843126422337e-05,
  -1.179392925347673046e-05,-1.395023413164237262e-04,
   4.982204193477678925e-05,-4.214752359195413412e-06,
   1.624497089322972279e-04, 2.280572122687899090e-04,
  -1.547795580651111749e-04, 1.101965898073478591e-04,
   2.968469039092507160e-05, 4.338105161809797804e-06,
   4.778919672089926751e-04,-2.919233935078156643e-04,
   2.763064272941932807e-04, 4.522773023665002255e-04,
   1.985912209006256485e-05, 2.369656053521093062e-06,
  -1.089590677164842092e-05, 1.677138085023252139e-05,
  -4.036744572623359985e-05, 2.162648129621173312e-04,
  -9.983513924790022025e-06,-5.739771019158690659e-07,
  -1.966043754201067214e-04,-3.669767793293932329e-05,
  -7.170161556991939390e-06,-6.970565489731442890e-06,
   5.950686720631615260e-06, 1.909422236051781652e-05,
  -1.195581594526169896e-05, 4.854954649719219129e-05,
   8.757627852661410207e-05,-2.074597405351003568e-05,
   1.190290691900632128e-04,-1.069209085621102847e-04,
   6.949638873994081812e-05, 7.190446406244210061e-05,
  -2.168026198031270033e-05,-2.073562732267841659e-05,
   3.180952408716322742e-04, 1.200642233757345296e-04,
  -1.165318988686235487e-04, 3.087398849291631366e-04,
  -3.198394630838865296e-05, 2.402139002102318435e-05,
  -2.401219506013245786e-05,-3.199085007301542133e-05,
   1.991505084880514179e-05,-1.841398840421512485e-06,
   2.602979520706009644e-05, 6.498037981943865485e-05,
   6.293043727078577855e-05, 4.939392740922408221e-05,
  -2.428374644045478301e-05, 3.178521132249556211e-05,
  -9.554178685718680788e-06, 2.952570006174092955e-06,
   1.217519819065009389e-05,-1.586709012448063132e-05,
   3.851246084533209652e-05, 1.080695885236741521e-05,
  -1.375847827964780587e-05, 4.806978547308548281e-05,
  -5.573489105427026423e-05, 9.483470840978330189e-05,
  -8.621337128162109853e-05,-5.066808277660948389e-05,
  -1.219271586476386459e-04,-1.184642054973297065e-04,
  -7.516377073156618651e-04,-3.277815689468451194e-04,
   3.999246402735381287e-05,-7.764154949585326319e-07,
  -6.042217632517076458e-05, 3.534346627214105907e-05,
  -2.884524300097530814e-05, 5.261132916221263181e-05,
  -1.299281725830372406e-05,-2.704046411754659532e-05,
  -7.768404170371994203e-05,-4.544435789594459765e-05,
   4.035884757725757409e-05,-6.907360872457505359e-05,
   1.775230930789923373e-06,-9.841166350711015568e-06,
  -3.761867242710854680e-05,-4.674222378986587784e-05,
  -4.695237520905027202e-05,-1.718937061758113040e-05,
   1.655003232946059005e-05,-1.122926666767734059e-05,
  -1.782161539185456159e-05, 9.076895109276778408e-06,
   4.066489646171900799e-05,-4.411764041466489326e-05,
   3.969653210155476045e-06,-1.960208798549538113e-05,
   1.508131825207600899e-05,-1.313597502203772803e-05,
   1.975015752151978323e-05, 3.151393005506549789e-06,
   9.799673858448044214e-06, 1.743463197971354222e-05,
  -4.385385619705693648e-06,-8.987123731566097216e-06,
   4.964766385808741956e-05, 3.369138574523702196e-05,
   1.997748673025042580e-05, 9.486959168607546958e-07,
   2.476689752174365236e-05,-1.692928785116043220e-05,
   5.238327525059392360e-06,-8.518211358037858076e-06,
  -2.164545115622088244e-05, 4.507188085984050201e-05,
   1.038554034772830758e-06, 9.945924065508296300e-06,
  -4.777903388359942876e-05,-1.473648265868955157e-05,
  -9.371258449510513433e-06,-1.766860252177511207e-05,
  -1.994207771744325953e-05,-1.521031331515901900e-06,
   3.721906707485758333e-06,-9.281562932005177065e-06,
   1.073115245339386530e-05, 1.687727368451489185e-05,
   9.001398786024241612e-06,-5.932094756403475885e-05,
   2.400173569208886263e-05,-1.799768551139583472e-05,
  -3.985367280771125975e-06,-9.171523735855398671e-06,
   7.447571771283602359e-04,-1.514488267230762453e-04,
   1.195593217463058658e-04, 5.879673193159320977e-04,
  -4.163352899880145490e-05,-1.125462094568535843e-04,
   1.031673586687825234e-04,-3.816406824890115521e-05,
  -1.544737316638681874e-04,-1.270349016051858454e-04,
   2.155261441789969846e-04,-2.629609879342071146e-04,
   2.337262997903416938e-06, 1.986296054667157775e-05,
   1.541385863521189451e-05, 2.573738452084251235e-05,
  -5.861689163640623111e-05,-5.444318152795453366e-05,
   4.784195806223948507e-05,-6.411822711812077669e-05,
   6.411822711812079024e-05, 4.784195806223948507e-05,
  -1.575239418996237357e-05,-9.875151683535823301e-05,
   8.887636515182238803e-05,-1.417715477096629986e-05,
  -1.652613489291802361e-05,-3.642645831673836806e-05,
   3.967994294096424335e-06,-1.960242386242115419e-05,
  -7.334424370950646806e-05, 2.494406180129461270e-04,
   9.221173382022432096e-06, 6.938998459041967510e-05,
  -6.938998459041962089e-05, 9.221173382022806485e-06,
  -2.206304513341603935e-05, 2.032786362215289048e-05,
  -2.032786362215293114e-05,-2.206304513341600208e-05,
   3.511705545634616945e-05, 1.915182539801123438e-05,
  -2.393978174751411667e-05, 4.389631932043266607e-05,
   4.900061467948737528e-05, 9.946846788425292804e-06,
  -1.193621614611045233e-05, 5.880073761538482730e-05,
  -4.972520769030148964e-05, 3.357683308706140436e-05,
  -2.328346268533319988e-05,-1.891772622121106143e-05,
   2.522363496161469549e-05,-3.104461691377764727e-05,
   3.283264971430153466e-06, 1.972866369340254818e-05,
  -1.415648373875262925e-04, 1.812716106163434783e-04,
   4.096864367071492676e-06,-9.122264102612898963e-06,
  -1.339832365328801230e-04,-1.046350434996531290e-04,
   3.691627648519455184e-05, 1.540092628606058833e-05,
  -1.925115785757582266e-05, 4.614534560649315083e-05,
  -3.698942504313293259e-04, 8.845535475313835334e-06,
   3.614308057433395763e-05,-1.713702793944164914e-05,
   5.998893091198919986e-05, 1.152461728903461918e-06,
   7.344390677588634850e-06, 6.786746317267883435e-06,
   2.129966239062942141e-05,-6.668076470801159988e-05,
  -1.007676383306841169e-05,-1.727596106306576889e-05,
   1.993115643796155955e-05,-1.658011774838631212e-06,
  -1.992447930639230637e-05, 3.468450842046266058e-05,
  -1.735260770918798414e-05,-9.944194572263244093e-06,
   6.108390200919026534e-05, 3.418708696762041169e-05,
  -9.766514600095020182e-06, 1.745322871465709408e-05,
  -1.199642214504111960e-04, 2.930114638833051041e-06,
  -5.688969769638041631e-05, 4.078679070501193573e-05,
   1.777404211032390123e-05, 3.583410982653863371e-05,
  -2.400470994504970055e-04,-2.815624087931540708e-04,
  -1.237983686312380525e-04, 3.967321419098901930e-05,
   8.155245654375331400e-06,-1.826176246469086845e-05,
   6.566679073218019460e-06,-7.541798588490715735e-06,
   2.485081057937238246e-05, 4.338706274395806296e-05,
   6.287868469910581006e-06, 1.798901406695350622e-04,
   9.999264724526296791e-06,-1.212640459660335036e-07,
  -1.696727391945379546e-05, 1.058827727924723216e-05,
   4.117656352870991740e-06, 2.971607151289788623e-05,
  -6.489300383439954922e-06,-7.608480829540550907e-06,
  -2.844789729551958104e-05,-2.811969308978264502e-05,
  -1.690030997973613483e-05, 3.625437246166083357e-05,
   2.889371042081327457e-05, 8.071771683972887894e-06,
   6.973069325370824881e-06,-7.167726570089883358e-06,
   2.709727149098855432e-04,-4.786165351889017810e-04,
   5.743455958147465840e-04, 3.251570952143036900e-04,
   1.818793227874076541e-05,-3.562582096491167144e-05,
   4.453252618689818444e-05, 2.273442568910039022e-05,
   5.548096924779942919e-05, 2.284430019336846116e-05,
  -6.194347909223655842e-06, 4.961481687943125461e-05,
   4.188148929595704413e-05,-4.296441381367416777e-05,
   3.580367817806180648e-05, 3.490124107996420231e-05,
  -8.882587276284615576e-05, 1.449014589017885080e-05,
   1.669585667605634512e-05, 2.492485446000808279e-05,
   4.161415570148196573e-04, 7.271058662788076540e-03,
   5.882344726085982046e-05,-1.182379179235001017e-05,
   3.623036621258798258e-06, 4.986856330035002705e-05,
   5.490254726804706144e-07,-3.999623196040282507e-05,
  -1.408274033813741868e-05, 3.743896933101387609e-05,
  -1.871625178301143745e-05,-7.049958808030106856e-06,
  -9.954840249427121193e-06,-9.492921617635968167e-07,
   1.994047078514334437e-05,-1.541954884827963954e-06,
   2.112028835278452477e-04,-1.139883414631664787e-04,
   2.354565362859940844e-05,-3.233577268602103001e-05,
   2.059488549919389090e-05,-3.429067936444382268e-05,
   2.951503423875059796e-04, 2.231283831979652031e-04,
  -4.520723168670166657e-05,-1.534806378773064775e-04,
   4.121695315596506429e-05,-5.657881911580499583e-05,
   7.870594713299445568e-05,-1.433087177733034612e-05,
  -8.954499361654314420e-06,-1.788342643852493187e-05,
  -5.608238774714969187e-05, 2.132523820683732878e-05,
  -1.955843746844237289e-05,-4.179416680953161629e-06,
   6.290628960375213131e-06,-2.933305281219274481e-05,
  -3.929820804906724761e-05, 7.459949338449042203e-06,
  -2.706373052025990309e-05, 1.294428407934377366e-05,
  -1.974861356157763800e-05,-6.715647595277368567e-05,
   9.108166609022776497e-06,-4.128111071941084467e-06,
   1.773675887832877485e-06,-2.994752199840448233e-05,
   1.555422497576563197e-06,-9.878292405777058937e-06,
   2.059720460277504879e-07, 1.999893935978243759e-05,
   5.955435060540792565e-05,-7.299268728314398935e-06,
   6.878728509495896146e-06, 2.920073790322169876e-05,
   1.684535787149419022e-05, 2.482405926075122851e-05,
  -1.857571372776846663e-05, 7.412345074535737310e-06,
  -5.535270605718284956e-06, 1.921876112868545986e-05,
  -2.985671625375524373e-05,-1.469985594981894415e-04,
   1.371986555316435040e-04,-2.786626850350478008e-05,
   1.330050362975914835e-04,-1.625104929519210508e-04,
   2.634494248086610379e-05,-1.435074930726115626e-05,
   9.930606129903050568e-06,-1.176036518451692346e-06,
   5.063580234225354830e-05, 4.833234446161523471e-05,
  -6.929341549920264593e-06,-7.210008715982847862e-06,
  -2.403562666581921846e-06, 2.990355976314214073e-05,
   1.437682879375784703e-05, 1.390348135665939533e-05,
   1.948185557924425094e-05, 4.522975037458171678e-06,
  -1.105601612665606508e-05, 1.666626855079207707e-05,
  -8.099103536548466755e-05, 3.924859475735166617e-05,
  -7.758608233274648142e-06,-6.309040995473309963e-06,
   1.783837800557447459e-05, 9.043907901468084488e-06,
   9.999999999558788132e-06,-9.393749892079486956e-11,
   1.992515808761055441e-05,-1.728604981980510540e-06,
   1.907554207145909311e-05,-6.010299050795580375e-06,
  -2.387717493576689949e-06, 9.710757188338500174e-06,
   2.985050800045190576e-05,-2.991182394130580005e-06,
  -1.239427541319970467e-05,-1.569655812532650009e-05,
   4.137920794954104324e-06,-1.956725866069865163e-05,
  -6.643649696221182403e-06,-7.474083135335076558e-06,
   4.938778976707290652e-05,-7.800398831047628228e-06,
  -1.969158028491309952e-05,-3.498809209262742120e-06,
   3.688994536051480377e-05,-1.546389120817372027e-05,
  -1.977022382809676894e-05,-3.022953818197498523e-06,
   2.940704381430054735e-05, 5.935130504361970898e-06,
  -1.080493595238129264e-03,-8.259137912938504904e-04,
   1.207816635801179025e-06,-2.997567645565787675e-05,
   1.998378430377192009e-05, 8.052110905340826805e-07,
   2.165081087415805946e-05,-2.076637639289626234e-05,
  -9.216193386391627860e-05, 6.005146081872715581e-05,
  -4.913336873531640170e-05,-7.540498708122318023e-05,
   6.635532254679753831e-06,-3.944578192528454350e-05,
   1.062227376139190818e-04,-5.498333656789158646e-04,
  -1.448605704075978189e-05, 4.785555507369917115e-05,
  -4.785555507369919148e-05,-1.448605704075970566e-05,
   7.478145413294758057e-06, 2.905300915873635528e-05,
   2.790630861415709080e-05, 1.101081012148615146e-05,
  -1.471955629717239559e-05, 3.719320720796168004e-05,
  -4.731123667539372169e-05,-1.617550259636096993e-05,
   1.616129093563171929e-05,-4.731609319559116294e-05,
  -5.977072538913525914e-05, 5.240265876516396099e-06,
  -4.366305779057295765e-06,-4.980898888598092231e-05,
  -1.997291181159158770e-05,-1.040573767872974456e-06,
  -1.536431295981051281e-05, 2.576699220462098870e-05,
  -7.900608744236243167e-06, 6.130283963284069382e-06,
  -2.576699220462101581e-05,-1.536431295981046538e-05,
   3.593978749074519622e-05,-1.755937570416657149e-05,
   7.705527597724960476e-06, 1.845602461096915403e-05,
  -1.354960925881419958e-05,-2.676580073402356694e-05,
  -1.790724479790189343e-04,-1.278008543586526885e-04,
   1.219917246150779063e-04,-1.709327912526996689e-04,
  -1.101802503226362245e-05, 3.845260881121607808e-05,
  -3.549075313312195502e-05, 3.521940433970730813e-05,
  -3.521940433970724036e-05,-3.549075313312202956e-05,
  -4.172074941002972492e-04,-3.374305544384881110e-03,
   4.271355166946083458e-05, 1.121407709255661355e-04,
   3.116271154243821593e-03,-3.852974087998520909e-04,
   6.940531588794833040e-05,-9.105060488217863758e-06,
  -4.529113625938462692e-06, 3.974276197955218870e-05,
   1.214077422193123931e-06, 9.926027201903132166e-06,
   1.636458815713413541e-05, 2.514359271161114830e-05,
  -3.825535668712556735e-05,-1.168450618300992615e-05,
   1.168450618300985500e-05,-3.825535668712559445e-05,
  -9.490303725997342615e-06, 3.151846314197595124e-06,
   2.060873486512168184e-04, 4.034854056730923850e-05,
  -3.456491653432015567e-05, 1.766501246673080636e-04,
   1.082561564306791028e-06, 9.941230329264364075e-06,
  -2.836889855740099486e-05,-9.757335427251226189e-06,
   9.770794318168104321e-06,-2.128750429724886900e-06,
  -2.675212709688098382e-05,-2.973758053023692951e-05,
   2.973758053023697355e-05,-2.675212709688093299e-05,
  -1.575239726366761044e-04, 4.428162124908703958e-04,
   7.733497811166948022e-06,-1.844432193399031154e-05,
  -4.145513478637933625e-04,-1.474692509790166564e-04,
  -6.291987021294778791e-06, 7.772444874288789372e-06,
  -9.044515965246351666e-06, 1.783806970931563207e-05,
   1.413044968782756401e-04, 7.505357527778001739e-05,
  -7.068045928938897226e-05, 1.323037137598224154e-04,
   9.194126277086947207e-06,-1.776142004460734059e-05,
   1.776142004460735753e-05, 9.194126277086915020e-06,
  -8.693209723581061063e-06, 4.942479610664643088e-06,
   4.900807230181991549e-05, 3.461515346289240443e-05,
  -2.884596121907707710e-05, 4.084006025151654655e-05,
  -1.621505094017592567e-05,-1.170778044752718808e-05,
   1.170778044752721688e-05,-1.621505094017590534e-05,
   4.811138467004835153e-06, 1.941270065321428685e-05,
   9.110368550057475949e-06, 4.123249311177247165e-06,
   4.802060168614775324e-06,-1.199038790787729442e-04,
   3.029306321337966166e-04, 5.863727757280503064e-04,
   1.099118899238146784e-04, 4.401869304653129085e-06,
   3.722984491474777742e-05,-3.337571943230332062e-05,
   2.670057554584259822e-05, 2.978387593179827479e-05,
  -3.529705424796789114e-05,-3.541352794365469641e-05,
   5.669212352542948744e-05,-5.644469089451589766e-05,
  -1.625024638464073933e-05,-1.165888041102020308e-05,
   1.165888041102017259e-05,-1.625024638464076304e-05,
   1.992390876397966186e-05,-1.742945657389963800e-06,
   5.426212349157078487e-06,-8.399774969715274186e-06,
  -1.894780516347924475e-04, 1.407366152367364944e-05,
  -1.333294249611157188e-05,-1.795055226013823316e-04,
  -4.063018959968696264e-06, 9.137388955874369055e-06,
  -4.024888731239278938e-05, 2.966525021155741405e-05,
  -5.335465187595775214e-05,-7.247952209552266649e-05,
  -1.638463520504948655e-05,-1.146925146630995514e-05,
   8.440350302178491906e-06, 5.362880455176625718e-06,
   2.337951764258937038e-05, 4.419726410989544983e-05,
  -8.842291216290633956e-05, 4.670533807426033274e-05,
  -1.228869529000544244e-05, 2.736764454733724643e-05,
  -1.595642030318372047e-05, 1.205788750603298811e-05,
  -1.950787855444366734e-05,-4.409384798934762475e-06,
   1.459629628981913496e-05, 3.724175257180860029e-05,
  -3.724175257180862739e-05, 1.459629628981907059e-05,
   5.660576452841731732e-05,-1.989440680576759276e-05,
   3.641134514424264795e-05, 1.037989110963445394e-04,
   3.903478901389300149e-06, 1.961537286075410377e-05,
  -1.101827298271619649e-05, 2.790336288833921764e-05,
  -3.720688332282768646e-05,-1.468495261829221268e-05,
  -9.647351390243279098e-06,-2.840648889168056248e-05,
  -1.303237910118252061e-05,-1.517092927157269154e-05,
  -1.129560891146697152e-05,-5.892715180050014858e-05,
   1.276891699676995862e-04,-2.440237433037867305e-05,
   1.837549027810163820e-05,-2.371373772814804878e-05,
   1.882581393923392094e-05,-6.751942648256562268e-06,
   2.589494418549942133e-05, 1.514766865329017606e-05,
  -2.523914649929225401e-05, 4.316231555404858027e-05,
  -3.982527657594584012e-05,-3.734614524876660844e-06,
   3.734614524876658303e-06,-3.982527657594584012e-05,
  -1.692053734211287325e-05, 1.066280526194509070e-05,
  -8.992618373584078406e-05, 3.644376312595397924e-06,
  -6.833571209152670228e-06,-1.698625983097204603e-04,
  -1.963171353951474160e-05, 3.820448076133696736e-06,
  -3.820448076133697583e-06,-1.963171353951474160e-05,
   9.802945686338158116e-06,-1.975412835511636533e-06,
   1.366710844607905816e-05,-2.670599458404637974e-05,
   4.658613991008933694e-05, 3.781179139207215570e-05,
  -9.804920263872182469e-06, 3.877967945482670766e-05,
  -3.877967945482671444e-05,-9.804920263872180775e-06,
   8.063430780793297189e-06, 1.830248846587139073e-05,
  -1.295516038099252941e-05, 1.192986329322459702e-04,
  -2.087691547718737903e-04,-2.270330407313889373e-05,
  -4.837764759899155796e-07,-9.988291161218660030e-06,
  -1.344094181600111681e-05,-1.481016823330756990e-05,
   5.184218142258903807e-05,-4.703603113940804323e-05,
   4.600277176223155264e-05, 1.958941015426527229e-05,
  -1.567152812341215211e-05, 3.680221740978527464e-05,
   9.643729759072085624e-06,-2.645463349583108332e-06,
   1.354394821508175372e-04, 3.544215956623379227e-05,
  -6.085442827118619840e-05, 2.321567112098787955e-04,
  -2.500742471626125793e-05, 1.657192532750873960e-05,
  -4.971018476754626426e-05,-7.502597903644052174e-05,
   3.223220475584306449e-05,-2.368723235368386891e-05,
   1.696146286121354548e-05, 1.059758357398863271e-05,
  -1.202738652846227382e-06,-9.927407503117299480e-06,
   2.223107582295233886e-06,-9.749758595859769848e-06,
   2.965404469758158892e-06, 2.985307984665465530e-05,
   2.944069773315304632e-05, 6.350783665804651411e-05,
  -9.980333337907967915e-05, 4.625250962298458360e-05,
  -3.264183963541748694e-06,-2.982188966266485550e-05,
   2.967251892308949603e-05, 4.420590544135006969e-06,
   5.473182723853202387e-06, 8.369245537759951786e-06,
  -9.996480567129348120e-06,-2.652852634530160742e-07,
   1.821912583254673042e-05,-8.250057811787047304e-06,
  -9.253373851938326484e-06,-2.853725761800289317e-05,
   4.756210679678260207e-05,-1.542225654861980371e-05,
  -7.407798555793700503e-04, 2.101076047357821339e-04,
  -1.523911918800703569e-04,-5.388663328111819749e-04,
  -3.245883208435386571e-05,-2.337571859258492387e-05,
  -1.584405597223530619e-05,-4.742326317693327262e-05,
   7.856650827541329261e-04,-8.260329156522404261e-04,
  -1.377946814947696359e-04,-1.308152351668374739e-04,
   3.987984096714925294e-05,-3.098109816466256976e-06,
  -1.498831994747198515e-05,-1.324198871590719373e-05,
   2.513803744422376282e-05,-1.637312045557608677e-05,
  -7.048087603492257116e-05,-3.784766985363668246e-05,
   2.370938525562794273e-05,-4.402118865728426369e-05,
  -9.608085043078466020e-05, 1.402443231667406629e-04,
  -5.764456905072685387e-05,-3.971276443356698560e-05,
   5.438367007197231467e-04,-1.047206590387152973e-03,
  -2.107220012075930460e-04,-9.217504112864368087e-05,
   5.656978248188083074e-05, 4.122935495436094890e-05,
  -3.808293290634139641e-05, 1.223479551325236190e-05,
  -1.193335248369377377e-03,-1.110338229999848370e-03,
  -6.820037644395459883e-05, 7.313486619187104540e-05,
  -2.448876437339875039e-04,-1.900790413128591741e-04,
  -9.531481079012579587e-05, 1.526927858284160187e-04,
   4.177383264998554900e-05,-2.747629716193580117e-05,
   4.524712339465407372e-06, 2.965682009665044212e-05,
   2.944808463467344891e-05, 5.728028574397087923e-06,
   1.220668588840910379e-06,-5.998758178320090631e-05,
   9.581792646825686979e-06,-2.861686508553518067e-06,
  -6.266319400886582298e-05, 4.973252574128166341e-05,
   3.715204074372032729e-05, 4.711396681003356915e-05,
  -7.027120919206582901e-05, 7.114743255160317983e-05,
   7.197292029360752318e-05, 6.942549059538592380e-05,
  -3.987484663748381197e-05,-3.016614999692778694e-05,
   1.015127030028743042e-05,-2.823033317710760634e-05,
  -5.920353376384971772e-05,-9.743797507784476337e-06,
  -2.780583896286330308e-06,-3.990323737738221661e-05,
  -1.396606544561934768e-04, 9.741745062755654641e-06,
  -7.380814241033488307e-06,-6.747116505541998810e-06,
   6.047684691032263674e-06, 3.954017589588916011e-05,
   1.487350931197656333e-05, 2.605338213642417787e-05,
   4.342229490764731907e-05,-2.478919734386948268e-05,
   1.213923436086262077e-05, 1.589462139001908802e-05,
   5.560866863278415660e-05,-4.251677284189389941e-05,
  -1.249354758404733361e-05, 1.561765887593736350e-05,
  -1.809624311364981114e-05, 5.720599605960621320e-05,
  -8.635613685560584557e-06, 1.096605041766348932e-04,
  -3.415359027525743431e-05, 2.082143778200345788e-05,
  -2.082143778200340028e-05,-3.415359027525746819e-05,
  -2.565554711483480503e-05,-1.554969138724275515e-05,
  -4.826103944315934141e-04,-1.307180446096936155e-04,
  -1.445267291071978902e-05,-3.729772440425483532e-05,
  -8.174901944947765206e-05,-1.490540097382453118e-04,
  -4.080064939954630623e-05,-4.399212439261488973e-05,
   4.399212439261482196e-05,-4.080064939954637399e-05,
   4.501809149182436540e-05, 2.175710087382349021e-05,
   4.500514486560112155e-06,-1.948705645694758822e-05,
   6.820639896094062265e-05, 1.574443205647625932e-05,
   7.895166720634398669e-06, 4.937272873209852390e-05,
  -3.987432399202357649e-05,-3.168325453474356786e-06,
  -3.903133457718784704e-05, 8.749566910631664316e-06,
   3.433002223294145863e-06, 9.392257222566760641e-06,
  -1.315086883705692748e-04, 4.801525677378487241e-05,
  -4.128256090949205973e-05, 2.820904402410827290e-05,
  -2.820904402410833727e-05,-4.128256090949201229e-05,
  -1.656787901713552085e-05,-1.120291858729503736e-05,
   2.240563475934483794e-05,-3.313589490312339372e-05,
  -2.791286281874897664e-05,-1.099418433817175315e-05,
   1.465771075390022218e-05,-3.721762372122914447e-05,
   1.968262761412332612e-05,-3.548826595334000581e-06,
   9.804519441083114692e-06,-1.967586981412325592e-06,
   1.967049658059978726e-05, 9.804627256694979404e-05,
   8.718535345304685624e-06, 1.799964281403030862e-05,
  -1.799964281403029507e-05, 8.718535345304714423e-06,
  -1.347690972885679523e-05, 1.477744579283731097e-05,
  -2.955503741943962137e-05,-2.695365954996693943e-05,
  -1.499924703268205193e-05, 2.598119682486891760e-05,
  -1.299089291194460705e-04,-7.499113370951748499e-05,
  -6.780591089810359071e-06,-7.350073773288563571e-06,
   1.565885176118170545e-05, 1.244187934041062321e-05,
  -7.470042675865849486e-05, 9.391403644862837219e-05,
   1.462840904367660004e-05,-1.363853543643454162e-05,
   6.137436305494023598e-05, 6.582695162014103474e-05,
  -1.300401713693014788e-05,-2.703507977244430397e-05,
   3.685319602205357904e-06,-9.296150785653218806e-06,
   7.476055212074937044e-06, 6.641430453298986420e-06,
   9.900520068291688360e-06, 1.407018968370205091e-06,
   6.734256185562667379e-05,-1.910443306463434983e-05,
  -9.729065861464517408e-06, 2.311985610527385744e-06,
   9.572130879775520606e-06, 2.893840082044604818e-06,
  -1.080466729102040344e-05, 1.683030495060484081e-05,
   1.505420577638234685e-07, 1.999943341919576255e-05,
   9.741832833672171084e-06, 2.257585666322955540e-06,
  -5.169568956784731198e-06, 1.932034049392110825e-05,
  -4.830084672349984205e-05,-1.292393925213882671e-05,
   9.693054337530779063e-06,-2.458596674868766183e-06,
   6.001994832504362570e-06, 1.907815656793367958e-05,
  -3.815626704357460264e-05, 1.200413617464509618e-05,
  -1.561738057124409976e-06, 1.993893112082313564e-05,
  -9.942054466471332184e-06,-1.074966504463030264e-06,
   6.451725113007631273e-06,-5.965211851280880336e-05,
   3.844416631134477351e-06, 9.231492878524938760e-06,
  -2.696922610472217679e-05, 1.314004731012685448e-05,
  -2.628031114286644499e-05,-5.393834671394860517e-05,
  -1.994926365676779305e-05, 1.423685201427520207e-06,
  -4.542542171365144791e-07,-9.989677327432238226e-06,
   7.991756316712907452e-05,-3.630853539862814823e-06,
  -1.714871526597471684e-05, 1.029182028246343456e-05,
  -1.698653928700069945e-05,-2.472766634867070855e-05,
   5.769771520490959179e-05,-3.963551009048759218e-05,
  -5.724739735521215206e-06,-8.199228924755332831e-06,
   1.463638101504816104e-05,-4.780979346098807118e-05,
   4.781649408538654768e-05, 1.461447547407000746e-05,
  -4.480734316907979131e-04,-1.418809353395720878e-04,
   2.990693637693530357e-03, 2.361176940837755238e-04,
   8.879421948571203924e-06,-4.920524225993844257e-05,
  -3.590444714731494348e-05, 3.479756708515219856e-05,
  -2.277584343814753867e-05,-4.451135760321169900e-05,
   2.824737868103606075e-06, 1.979951655916127460e-05,
  -2.357121493861798627e-06, 4.994440887890430099e-05,
   5.955127388857458007e-05,-7.324327835916091307e-06,
   7.810990487172971746e-05,-1.728706918275435935e-05,
  -3.673762927229367383e-05,-1.659829707995718186e-04,
   1.729955660326969164e-05, 2.450969892369688085e-05,
  -1.071963074978830811e-04, 2.467694589732074507e-05,
   2.998884885803289782e-05,-8.178900721117315040e-07,
   8.852073016348151581e-05, 1.625054864686407372e-05,
  -1.241571081697797137e-05, 7.903069103145420678e-05,
   1.325354368617333973e-04,-8.193499606248049946e-04,
   1.784822386617419159e-04, 2.332574719688525766e-05,
  -4.792535711704337448e-06,-2.961471933772188693e-05,
   3.787937808354351863e-05,-1.285117566621682213e-05,
  -5.902169125766421715e-05, 1.079073496500418558e-05,
  -8.955617130280128400e-05, 8.927047752942296029e-06,
   1.273781917860333495e-05, 5.863231159158919739e-05,
   4.652344638645059135e-05, 1.213901517270946214e-04,
   1.867545043086858974e-04,-7.157342467995385577e-05,
   7.379315664905498423e-06,-6.748755464356398316e-06,
  -2.911993255556077150e-06,-9.566624027293845934e-06,
   7.872981126982480824e-05,-1.419918368842966641e-05,
  -4.976186489568817678e-05, 4.874095003513697777e-06,
  -3.900227886885281659e-06,-3.980939866953986969e-05,
  -5.989288826578867040e-05, 3.583564591542053513e-06,
   2.388401926152783433e-06, 3.992863053297908817e-05,
  -8.412149504952332805e-07, 4.999292307324170901e-05,
  -6.999953923851816881e-05,-2.539810921195983978e-07,
   4.999463145373301285e-04,-7.326839737634583882e-06,
   1.386068627414178240e-05, 7.879010963318821181e-05,
  -7.034390164686515379e-06,-1.872210872233578583e-05,
  -1.207536967848292625e-07, 1.999963546029559269e-05,
  -1.232487822268383258e-04,-3.382450852260848544e-04,
  -1.947911862897615698e-05,-7.759229302861383678e-05,
  -6.565932446927865069e-05, 2.426629576672108271e-05,
  -2.177451757557180405e-04, 1.228293060922818099e-04,
   1.030739680809405052e-04, 1.829638136464400891e-04,
   1.634638107314826565e-05,-1.152370712103619392e-05,
  -9.876030156158108536e-06,-1.569722381396038259e-06,
   3.839009858185510040e-07, 4.999852617860938244e-05,
   1.151454528076089729e-06, 1.996682629938401318e-05,
  -2.995023944907602146e-05, 1.727181792114129193e-06,
   1.644107757473197473e-05,-2.509364397973409990e-05,
   6.864620842851444442e-05, 1.370029446358552324e-05,
   2.853359329699198038e-04, 9.789557045101883546e-04,
  -3.224120939447522836e-03, 9.066216837463558992e-04,
  -3.327685686906398229e-05,-2.219573826021178643e-05,
  -3.053953866813960594e-06,-2.984415128261100526e-05,
   3.088130539867137668e-05, 9.511227563713314716e-05,
  -2.092435318600697005e-04, 6.794957229242873397e-05,
   2.259640211261264984e-06, 9.741356482320681515e-06,
   2.922540228585242207e-05,-6.773172168939162660e-06,
  -7.711008790849417627e-05, 2.130808162984884933e-05,
  -1.864543107027238512e-05,-6.747108936576999745e-05,
  -3.953888148355894945e-05, 6.056141595857817934e-06,
  -9.084181340020580211e-06,-5.930832698181278285e-05,
  -3.377884137194351878e-05, 2.142404900034251732e-05,
  -4.983294936935906121e-04, 2.080089318156545081e-04,
  -2.802133135327058958e-07,-9.996073253979236324e-06,
  -3.010777192927367729e-04,-3.865904899832431308e-04,
  -1.815071047547989333e-04, 1.412627726031541865e-04,
  -1.069912222925223607e-05,-1.689759697482221069e-05,
   1.999992129993532090e-05, 5.610700841671890517e-08,
  -8.728280079140283252e-06, 4.880279383404490374e-06,
   4.286027245165020236e-05, 2.574872900494925990e-05,
  -3.089847480593910781e-05, 5.143232694198024147e-05,
  -2.248095363211355147e-05,-1.986471051364103037e-05,
  -1.830175266552011589e-05, 2.377069307719333811e-05,
  -1.939523305703940248e-05,-4.881079251879245570e-06,
  -2.873856257542058986e-05, 8.607846484378948611e-06,
   2.391361816443955449e-05,-3.206460457085642726e-05,
   5.413167582407794313e-06, 4.099642638288424740e-04,
  -4.399613106133115452e-04, 5.834823340701068827e-06,
  -3.236735710836659009e-05,-5.052082930652930943e-05,
   5.894096752428419546e-05,-3.776191662642767376e-05,
  -7.704166373645969095e-06,-6.375407476168305864e-06,
   2.504258944177144546e-04,-3.495523872112558331e-04,
   1.306667929177864110e-05,-1.514139664250967570e-05,
  -1.569801775693389304e-04,-3.093903441122264699e-05,
   8.843269451822429958e-05, 6.541909920081767714e-05,
  -2.935903380094319261e-05, 6.168235912728629934e-06,
  -6.224354194877780806e-06,-2.934718751186742792e-05,
   7.167890327300431336e-06,-6.972900992828804773e-06,
   3.991302040606024631e-05, 2.636437381281570948e-06,
  -4.514747637851388453e-06, 6.985425580282503385e-05,
  -1.985561295255408202e-05, 2.398881880870055662e-06,
  -4.797666728895899379e-06,-3.971123762813802562e-05,
  -5.041454280568285345e-02,-4.493995753733312504e-02,
   2.966517286503613643e-05, 4.024894432016228643e-05,
  -3.177722764947923050e-04, 3.461466571191562647e-04,
  -2.947375006311530633e-04, 4.725132764505428308e-04,
   3.932353645518243680e-06, 4.984512608878203550e-05,
  -7.568953101701075508e-06,-6.535361424148605123e-06,
  -1.960581874376867085e-05, 2.270708857133580365e-05,
   4.186768477734342185e-05, 4.297786606364962771e-05,
  -1.432600406972589450e-05, 1.395584491867823787e-05,
   6.385387021725429428e-07, 1.998980410924098595e-05,
  -1.973280235906020453e-05,-3.258298798187184415e-06,
  -3.292975066781448919e-06, 1.972704527316637292e-05,
   1.990191564808121606e-05,-1.978320888192825503e-06,
  -4.886296685249396846e-06, 8.724912876569070413e-06,
  -6.980607269249293706e-05, 5.206939144102965089e-06,
   5.205294375819195614e-06, 6.980619535872918224e-05,
  -1.757033567586772349e-05, 9.554229651695103216e-06,
   4.254410911021953758e-04,-4.755804022500855323e-04,
  -1.915845374193781312e-05,-5.740526998284139137e-06,
  -5.479997492786467395e-06,-3.962284224382514006e-05,
  -4.998023219431406135e-05, 1.405841314819281709e-06,
   1.774800485712318092e-05,-9.219995856372821582e-06,
   1.843996073662658027e-05, 3.549602580616131924e-05,
  -2.272544844012003339e-04,-5.008546688606832151e-04,
   4.005407597472802352e-04,-1.821183675005669722e-04,
   4.870173035987605955e-05, 1.131995847845419048e-05,
  -9.998402947587295859e-06,-1.787134513059475214e-07,
   2.311506591636231336e-04,-1.912312023918233926e-04,
   3.181579633851553010e-06, 9.480377156709591304e-06,
   1.708973353323774396e-05,-2.465645975729138334e-05,
  -3.955738174139570396e-05, 5.934100586061369099e-06,
   1.545924109833931033e-05, 1.268904506507155763e-05,
  -1.815190970960419556e-05, 8.396914546092333427e-06,
  -3.843991874945152650e-05, 4.606921582288508522e-05,
   6.043026962003396357e-05, 5.242311049193858582e-05,
  -5.802228845496600019e-04, 1.945312675187429226e-03,
   4.976529688287161440e-05, 3.161066516638959939e-04,
   3.185263937620950119e-05, 3.854100887067110013e-05,
   8.518627533824956269e-05, 3.394750336828850383e-04,
  -2.941495676480641603e-03, 4.104913948497492752e-04,
  -3.870357943473545461e-05, 1.010113552721290805e-05,
   1.344023500642047746e-03, 7.310956365085865801e-04,
   2.427633215620668975e-05,-4.371109352374435406e-05,
   2.521164684349532447e-05, 4.317838421523983636e-05,
   9.971694420535533285e-05, 6.321839376624070576e-04,
  -5.262750874700448946e-06,-1.929516657691349816e-05,
  -2.963388472109198618e-05, 4.672566354481332064e-06,
  -1.198774743312113336e-05, 1.600918209902360293e-05,
   1.096668506123212545e-05, 7.924475893564034124e-05,
   5.685413488574975103e-07,-1.999191738514941220e-05,
  -4.149869373597337243e-04, 6.005712628995733609e-04,
   2.018775695636345019e-05,-2.219131517217488267e-05,
  -5.758908077137568578e-05,-3.979318755651482385e-05,
   1.898130733751631437e-04, 6.301584860870269595e-05,
  -6.928949218578374044e-05,-9.948179362889136615e-06,
   2.331634356785258527e-04,-5.201296110226621885e-04,
  -2.863753644557801253e-05, 8.938204871683751908e-06,
   1.773153192180412611e-05,-9.251636379908223883e-06,
  -7.600862581539883595e-06,-2.902114553246558040e-05,
   4.249934006425915597e-05, 2.634019920392510270e-05,
   3.524356973327988276e-04,-2.284492925039248706e-04,
   1.961906105237305059e-04, 3.018430790035211628e-04,
  -3.718624932932382190e-05,-1.473712525621478641e-05,
   6.098556573821605289e-05,-3.436219974899347625e-05,
  -7.030910729885540920e-05,-8.459686419033531459e-05,
  -6.692400220189251585e-05,-6.017622395332799731e-05,
   8.449851339100928683e-05,-7.042727621248335472e-05,
   1.697323600697581017e-04,-3.399866555398167321e-04,
  -2.668905145108884037e-05,-1.370016542386013079e-05,
   7.848016030772097629e-06,-1.839588661578300463e-05,
   2.620027656344628419e-05,-1.461319636489318614e-05,
   9.285425921780375916e-05,-2.641554211919809993e-04,
   4.829987857457542682e-04, 2.630820650826031382e-04,
   1.945133449190103329e-06, 1.990518665737254182e-05,
  -1.520919655699620710e-05,-1.298769956884800988e-05,
   2.270145861569345460e-05,-7.671143185158231742e-05,
  -1.987150309873182656e-05, 2.263485055636864707e-06,
   3.789423103248817345e-06, 2.975970887869308819e-05,
   2.916315645208817077e-05,-7.036355999452278571e-06,
   6.835228768020395249e-06,-7.299290903151237173e-06,
   2.195046032531640606e-04, 2.464096774695974617e-04,
  -2.165165182900380696e-04, 1.929264038631301695e-04,
  -4.962160360058342671e-05, 6.139743977281644834e-06,
   1.589588101802032720e-05,-2.544250315242077413e-05,
  -1.870963457939865071e-06, 9.823415685954337495e-06,
   5.088474551379596308e-05, 3.179217944709393338e-05,
   1.139844417127004180e-04, 3.751728998000792187e-05,
   5.913713644616680395e-05, 3.745395964310647741e-05,
   1.839350610228953075e-05,-5.711111041877086323e-05,
   5.088574216873408045e-05,-3.179058420251377657e-05,
  -2.286219794892552665e-05, 1.279739032183676954e-04,
  -6.305379017781687981e-06,-1.898004729820551456e-05,
  -1.286674595017962385e-04,-1.258756722538300059e-04,
  -3.137300379013257612e-04, 4.020863878800583799e-04,
   1.754367887599721102e-05,-9.603089684882114369e-06,
  -1.872043779290363515e-04, 2.214825520988109823e-04,
  -1.603784041254072666e-04,-1.355683130019236964e-04,
  -1.796700065121581427e-06, 9.837269381082950387e-06,
   4.971824662531228867e-05,-2.958514761709067653e-04,
  -1.977890885768508777e-04, 4.592161543760613887e-04,
   1.577906507476272173e-04, 2.649736848519738632e-05,
   2.999419713392481639e-05,-5.900324493249896408e-07,
  -1.400819997485609206e-05, 1.427481465604516540e-05,
   1.999855421796562570e-05,-2.404770074026804579e-07,
   4.362571849314372266e-06,-8.998220205105551329e-06,
  -7.175868051798202623e-05, 8.337080886208425514e-05,
  -6.600650307246487536e-05, 4.520112335047311549e-05,
   2.031764489104458652e-05, 2.207245582352380131e-05,
   1.414467218617697480e-05,-2.645615710464374281e-05,
  -1.956753097634008286e-04,-1.208766857131561779e-04,
   8.408568212859239945e-05,-1.361234662391805209e-04,
  -3.599460147301661826e-04,-6.234298667131704414e-06,
   7.273934787668023565e-06,-4.199370070292742993e-04,
   1.441360840003944328e-05, 3.731283817790215733e-05,
  -1.153668834990047903e-05, 1.633722197673982159e-05,
  -1.221050062081232953e-06, 2.997514031236370077e-05,
  -2.293120634445248169e-05,-1.934321006420967011e-05,
   7.091722865253342943e-05,-1.654410670911073860e-04,
   2.389673014017608399e-04, 1.024432958312059352e-04,
  -2.673634057783103615e-05,-1.780032811284843527e-04,
   2.572018301340959915e-04,-3.804232610752938704e-05,
  -3.426870786030662968e-05, 2.063142412886126629e-05,
  -1.793951546304470705e-05,-8.841594027729382413e-06,
  -8.718178243385585596e-05,-1.574780518410607807e-04,
   1.029978066643135831e-05, 1.714393531903940756e-05,
  -1.546421360573349348e-05, 1.268298456816246545e-05,
   1.056029104905778667e-04,-3.079001942056874505e-05,
   4.754255916811233224e-05, 1.632167426085527119e-04,
  -3.818560396937338932e-05,-1.191048485554537100e-05,
   1.191048485554538456e-05,-3.818560396937338255e-05,
  -8.952335944890061985e-05,-3.280023904074221377e-04,
   3.376452246554023781e-04,-9.217213389849912477e-05,
   9.756792112618823309e-06, 1.745866568988418187e-05,
  -7.974385975167226211e-06,-3.919705560777565171e-05,
  -1.142795317121529223e-05,-2.773809449685595216e-05,
   1.939129103380115185e-05,-4.896716455179233159e-06,
  -1.234144310959574252e-05,-1.573813146382415504e-05,
  -3.592643983203499358e-06,-2.978410497580801601e-05,
   4.770574387144965853e-05,-6.421963875382392538e-05,
   7.224703739600704157e-05, 5.366903751233071589e-05,
   1.357204871381134642e-06,-1.995389673565289658e-05,
  -2.251317151320982634e-05,-1.982818974129503355e-05,
   6.545545873886902910e-06,-7.560147433274178903e-06,
  -8.485219044462876965e-06,-2.877500751985105260e-05,
  -1.659256260631027690e-05,-1.116632733514802566e-05,
   6.757898948388318212e-04, 4.465512490562763628e-04,
  -5.183666915923253226e-04, 7.841530291005876065e-04,
  -9.989018615546911247e-06,-4.685158463246141358e-07,
  -2.087076505146862320e-05, 4.543579168636105469e-05,
   1.721846592096840220e-04, 1.711359822811335312e-03,
  -7.924214400594991703e-05, 1.098556386082644760e-05,
  -1.574899469329649586e-06, 4.997519076163196996e-05,
  -8.248103759589529469e-06,-5.943036920944581782e-05,
  -5.286441345152090461e-05, 7.283785959531386832e-05,
  -2.585990113944255391e-05,-1.520741638340509446e-05,
  -4.856410841288365547e-05,-3.523531430343260885e-05,
   7.638792885311330636e-05,-4.759080084986699595e-05,
  -3.365713485398821230e-05, 4.967088959763506906e-05,
   1.982142700288523496e-05, 2.666651752533888806e-06,
  -1.067013006331222822e-05, 1.691591926062549581e-05,
  -2.656945353550911170e-04, 4.802513802626946575e-05,
   1.919412468493344887e-05, 5.620104765858773684e-06,
  -2.582391793721170524e-05, 1.526844007658135038e-05,
   8.695797701792594832e-06, 4.937924901160266461e-06,
   9.703620331522983019e-07, 9.952808524462657683e-06,
   1.704633020648476399e-05,-1.046052706566381493e-05,
  -9.523598120492482455e-06, 1.758695763454702973e-05,
   7.207803985273309790e-06,-1.865603285025726606e-05,
   1.984862727458835125e-05, 2.456012075391226456e-06,
   1.599259471572524611e-05, 1.200986737056479479e-05,
  -1.898969296655166807e-05, 6.276269675220955060e-06,
   1.269967791584340698e-05,-1.545050746201688210e-05,
   1.932383361136939829e-06, 9.811518462786538965e-06,
  -1.182037090608777682e-05,-1.613315938192249162e-05,
  -1.451462196887663673e-05,-1.375956936464959950e-05,
  -1.879846139011820473e-05,-6.827726515044025826e-06,
  -5.949900242342182059e-06,-8.037330844638439838e-06,
   6.537127859112869683e-06, 1.890148034820580917e-05,
  -7.626684841928532482e-06,-6.467895973336117971e-06,
  -1.632466402617669479e-06,-9.865852899994229683e-06,
   3.658378578181886346e-05,-1.617487613151916243e-05,
  -3.029203801055638488e-06, 1.399672244646283726e-04,
  -5.402979669854088336e-06,-8.414737707566613130e-06,
  -1.806198005469521404e-05,-8.588648118522051477e-06,
  -2.079579560776561938e-05, 2.162255500721494756e-05,
   1.891356377060594718e-05, 6.502084703787099503e-06,
  -2.554507983823127508e-05, 3.078065782367866049e-05,
   9.986928576552732564e-06,-5.111336487010268571e-07,
   1.180366672935872276e-05,-1.614538484342290556e-05,
  -9.969320287690577490e-06,-7.827215350564090259e-07,
   1.280092821005529787e-06,-1.995899201787530689e-05,
  -1.644212264658681497e-05,-1.138668533308078642e-05,
   1.308271071547880499e-05,-1.512754706933996426e-05,
   3.253185859862576521e-06, 9.456044720769366999e-06,
   2.516589656104266888e-05,-4.320506509981093541e-05,
  -8.548541423683481469e-06, 1.808099664088149011e-05,
   3.950620776954711570e-05,-6.265743983708198303e-06,
   7.489931751680817707e-05,-2.810857939342280561e-05,
   3.162215181760049326e-05, 8.426173220640925849e-05,
  -9.999316454566944452e-06,-1.169206629589518705e-07,
  -1.675738619973578139e-05, 2.488352884445662518e-05,
  -1.821698462276624775e-05, 8.254784749095403636e-06,
  -1.387814351496230760e-05,-1.440128926791312333e-05,
  -9.823886972245410689e-06, 1.742100010781662638e-05,
  -7.668999912984070458e-06, 6.417666268562922442e-06,
   2.904092870081398468e-05,-7.524922603870327715e-06,
  -9.499175919152485448e-06, 3.125005097114808438e-06,
   7.829216047519044655e-06, 6.221203748573926952e-06,
   1.210802950634837054e-02, 3.065244113182054395e-03,
   5.553812299382163901e-05,-2.270499712228875419e-05,
   8.769867424710997000e-06,-4.805145716104031933e-06,
   1.176051077939231742e-05,-1.617684722706489391e-05,
   7.646490588250178517e-06,-6.444469076952844236e-06,
   5.969865560604332061e-05,-5.325476991623410820e-05,
   3.909285767997161628e-06,-9.204210166230171605e-06,
  -9.536507768386722525e-06,-3.009155958653475366e-06,
  -2.835342414149778315e-05,-5.287800430663330814e-05,
  -1.700802009752626614e-04,-2.471289647860287872e-04,
   9.073050874105561368e-06,-1.782357281343705235e-05,
   1.742043455584451746e-05, 3.600733897256972230e-05,
   5.870349085634699161e-06, 1.911907428754823111e-05,
  -1.748731646111064002e-05,-9.705347133872592000e-06,
  -2.459512917308557742e-03, 7.792279573990823884e-04,
   3.988764910901217278e-05,-2.995905298289740677e-06,
  -2.412735844327173890e-06,-9.704571383914843301e-06,
   1.501713951586223894e-05, 1.320929675498014055e-05,
  -2.312588781376473067e-06,-9.728922506025613687e-06,
  -3.964843179123802934e-05,-5.291678041561637850e-06,
  -1.979247170290374336e-05, 4.591577140688975802e-05,
  -2.574760805964917737e-05, 1.539677496122772039e-05,
  -3.856933236965554185e-06, 1.962457811025731136e-05,
  -2.980539457113899303e-05,-3.411517911241030568e-06,
   5.016268396309837564e-05, 3.160438342028180523e-04,
   3.044892960538204881e-06, 9.525157576589739209e-06,
   4.096486095290225566e-05, 4.383925372436652044e-05,
   5.996434370916515062e-05, 2.068207806074143438e-06,
  -1.378805204049497710e-06, 3.997622913944343375e-05,
   4.133753459194184406e-04, 2.017940122649856439e-04,
  -1.842853897766299733e-05,-7.771032823811496488e-06,
   2.767285238186645684e-05, 1.158504385194238342e-05,
   7.984318877939553210e-05,-5.006516307554396846e-06,
   9.998165047198881677e-05,-1.915611885811084599e-06,
   3.677218103251373805e-06,-1.965904542497220046e-05,
   3.962561116358813274e-06,-9.181400187287405720e-06,
   7.848751373577063885e-06,-5.948442738966033268e-05,
  -1.889785320497144516e-05,-6.547605993288728790e-06,
  -4.767233053678170205e-05,-1.507809342031781434e-05,
  -1.390958316369925259e-05, 2.658050970564963174e-05,
  -6.106565615307635592e-07,-1.999067529034123043e-05,
   8.076364427817109924e-06, 5.896807409869378634e-06,
   1.778116815443989089e-05, 9.155875657933149915e-06,
   8.867350912808864613e-06,-3.900474442666056147e-05,
  -3.999281522157293841e-05,-7.581099215313779485e-07,
  -2.794968510628579456e-04, 7.734022398433173455e-05,
   1.348911033213164208e-04, 1.737941030206662267e-04,
   1.614600919767577311e-03, 7.262689850866942999e-03,
  -1.217110482653671540e-04, 8.767223465924354423e-05,
  -5.031935637936777914e-05, 4.866171363162397561e-05,
   8.735930238482273575e-05, 1.458367316105140508e-04,
  -1.871799536063338543e-02,-1.995510585487601449e-02,
  -1.466475364324350598e-04, 8.599127896651865145e-05,
  -1.156009021671018926e-04, 1.507860451704737281e-04,
   1.619017800618717190e-05,-2.525624944697793227e-05,
  -2.063373588633559557e-04, 2.037765794621517867e-04,
   3.369241355745246580e-05, 2.155971402114586030e-05,
  -7.660730415549559726e-07,-3.999266347838066745e-05,
   5.670136621115311572e-05, 1.962027190914295932e-05,
   5.585451747123106486e-08,-1.999992200666987784e-05,
  -4.809670839884813492e-05, 1.314789209006377870e-04,
  -1.690443268722485097e-04,-6.183862508423361448e-05,
  -8.582082759558531189e-06,-1.806510048430642657e-05,
  -1.352278744983831194e-05,-1.473547486803514984e-05,
  -8.781011086414200866e-06, 4.784751226581265574e-06,
  -1.583445656246306973e-04,-2.548077678116328652e-04,
   6.485880098987499424e-05, 4.683306453944469479e-05,
  -8.331650265242507755e-06, 5.530244466358107903e-06,
   6.385862903669898801e-05,-6.341983520597688586e-05,
  -1.611475477240553747e-05,-1.184544970126643156e-05,
   4.646355330594186469e-06, 1.945279882540964863e-05,
   2.963087725896906987e-05,-4.691600245535604389e-06,
   1.425547129568384515e-05,-1.402788430726223454e-05,
  -2.780157671472457734e-05, 1.127263643409491862e-05,
   1.242646461507097588e-05, 3.802082294178269693e-05,
   2.360124570521214064e-05,-1.851975164958227709e-05,
  -3.728943949306067970e-05, 4.700529440704915597e-05,
   2.469300219944297513e-05, 3.146832760694957506e-05,
   5.607611908722117333e-05, 4.189831581478888241e-05,
  -1.999058864896767414e-05, 6.134863223942499717e-07,
  -1.531520046835927403e-05,-2.579621357125824152e-05,
  -4.449085934725167252e-05, 2.281585927689485095e-05,
  -2.568995345032782886e-05,-1.549278192320505809e-05,
  -1.902901029417243274e-05, 3.518375715048464847e-05,
   1.054049655807509342e-05, 1.699699774399017816e-05,
   3.868440116148467100e-05,-3.167833813155803541e-05,
  -2.858070280213310742e-05,-4.102613103055345579e-05,
   1.203422468926242012e-05,-1.597427419723183799e-05,
   1.541284883985757584e-05,-3.691130031087635870e-05,
  -3.761568596541618151e-05,-1.360368219825766222e-05,
  -2.300684033664359966e-05, 1.925318928708147901e-05,
   4.453245166143619062e-05, 4.021020702535426007e-05,
   5.646005710436181890e-05,-5.667682023342703425e-05,
   4.395024826874239468e-05, 2.384063080364918902e-05,
   4.846311874254741772e-05, 1.230146827601280417e-05,
   1.181893386584606051e-05,-5.882442351842266139e-05,
  -1.755199704408990039e-05,-9.587877750798636133e-06,
  -2.229381662710292993e-05,-2.007450473105399088e-05,
  -4.501918494902792538e-05, 6.613072649325137282e-05,
  -1.875263190944051754e-05,-6.952610766397994971e-06,
   8.902226526875788991e-05, 6.461452070873004204e-05,
  -6.095481009721237072e-06, 5.968957288555621775e-05,
   7.990168829094139230e-05, 3.964871783203204649e-06,
   1.240173221789218081e-04, 5.563449503676379509e-04,
  -4.294602122963264040e-04, 9.572839732490171470e-05,
   9.829709139126821478e-06,-1.837612102748195270e-06,
   3.208256534593994575e-05,-5.070215972543471171e-05,
  -5.070215972543476592e-05,-3.208256534593985766e-05,
  -2.516462744455636219e-05, 1.633222353437157738e-05,
   1.464159968430816143e-05, 1.362437369879684586e-05,
   2.794360956747790454e-05,-4.146269026896780898e-05,
  -9.070819489180844742e-05,-4.209540805681419155e-05,
   1.029644147675702670e-05,-4.892834856109204103e-05,
  -7.287432357802213143e-05, 1.424406296077271989e-04,
   2.820828246622591587e-06, 9.593900562495743695e-06,
   9.870616932323288760e-06, 1.603409297507287953e-06,
  -5.993961612983203274e-05, 2.691174131931957351e-06,
  -4.156770931016909597e-06, 1.956326290338738307e-05,
   1.088065097466725878e-05, 1.094605473874832806e-04,
  -4.215685016970150031e-06,-1.955065215888445587e-05,
  -1.577611892816355410e-05,-8.860651257985747715e-05,
  -1.191919954387885755e-05,-1.606028275695039375e-05,
   5.907100838657166724e-05,-1.051741261877560109e-05,
  -5.706374226345047772e-06, 8.212021260865376228e-06,
   1.258403931577800286e-05, 1.554483690808474000e-05,
  -1.792872066595398088e-05, 2.405329447876516238e-05,
   6.290954143276754741e-05, 3.069836472385624942e-05,
   3.933263904338442802e-05,-1.343612425734550528e-04,
  -2.184267418521716514e-04,-7.203997809442178610e-05,
  -3.624567230505254729e-05, 1.691896093602520928e-05,
  -5.954693741558613978e-07, 1.999113344021400296e-05,
  -1.521067802640526421e-05,-7.854066000472005615e-05,
  -1.454219999968605888e-04, 3.677556140853699483e-05,
   3.738412599991558592e-05,-1.422768861138152867e-05,
   3.602179697809458386e-04,-5.290019038216153954e-04,
   4.375928407540627179e-04, 2.990192397167605251e-04,
  -6.220630453907747539e-05,-3.209946534744072190e-05,
  -3.108307001025991209e-05, 9.504652944078117159e-05,
  -3.975286312761723198e-05,-4.439580290627784498e-06,
   1.882657104272611958e-04, 2.561293183762139290e-05,
   2.438148655015161462e-05,-1.747979157784142491e-05,
  -1.420742544032152701e-06,-9.898560027780660639e-06,
   5.580150512898821480e-05,-3.353896122800160864e-04,
  -2.566282244983278561e-05,-3.068256090857408592e-05,
  -9.913960564291881582e-06, 1.308963685388330265e-06,
   9.435872423123251430e-05,-3.311240192819324651e-05,
  -5.212390788456180072e-06,-3.965893319629787059e-05,
  -8.105644440808505702e-05,-1.937262316257636215e-04,
   2.674123657007644575e-05, 1.359802436765011056e-05,
   8.278518102086539915e-06,-5.609468605262488494e-06,
  -4.433380344748635458e-05, 1.537352070017783802e-04,
  -3.500154203258737211e-03, 1.050208648571369398e-02,
  -1.354767268280678537e-04,-3.529952532192287247e-05,
  -7.299312752301724896e-05,-1.075732463691997078e-04,
  -1.475918610700776299e-04,-2.677018016134554145e-05,
  -1.867981740609364299e-05,-7.145937424509190331e-06,
   3.835429083847909933e-06, 2.699727569288108047e-04,
   2.804734848436155355e-05, 2.851922584848301821e-05,
   1.980915388026281018e-05,-2.756342240736611717e-06,
   4.899662972526003463e-04, 5.746960638153080807e-06,
   6.507367287780214764e-05, 1.239573196636358182e-04,
   5.768031716355103425e-05,-1.652213702618883585e-05,
  -2.573182775554840878e-05,-3.062471290247124471e-05,
   2.480155544017748981e-04,-1.502939944734327943e-04,
   5.065389012290836578e-06, 4.974275659987254200e-05,
   1.447145044383751553e-04,-8.920600991612336885e-05,
   1.101956593081520843e-04, 1.787649760709342131e-04,
   5.019495444591356858e-06,-1.935987255850943664e-05,
  -5.818776389817813586e-05,-1.463503100542932139e-05,
   1.694526623934591240e-05,-2.995210475944514589e-04,
  -2.459762185978528294e-05,-1.717431217961910852e-05,
  -1.990292042509296815e-05, 1.968186615241857023e-06,
  -3.949038570224896474e-04, 6.364702435119075070e-05,
  -1.971076875299936798e-05, 3.389040449121811549e-06,
   6.322562422454214313e-06, 1.897433014401746904e-05,
   1.038969934955239090e-04, 7.326700585820270775e-04,
   1.553690258239447309e-05,-1.259383413203397890e-05,
   1.840969582141886805e-05,-7.815567782498772378e-06,
  -1.455467356756260549e-04, 1.059063158370143775e-04,
   3.315166250227327092e-05, 7.280774185026871106e-05,
   9.418141178820524798e-06,-3.887542432869132779e-05,
   2.556325959563762566e-04, 3.076556124705091453e-04,
  -2.902152295108503599e-05,-7.599421399004305307e-06,
   2.904960242771345595e-06,-2.985902218740456245e-05,
   2.976780071209920945e-05,-3.725324249611825361e-06,
   1.015431815081207188e-03,-9.642732455525931262e-05,
  -6.867112404698872874e-06,-2.920347183506151196e-05,
  -1.965975729442355545e-04,-6.090561503773162487e-04,
   5.144313989524168057e-05,-3.088046887141763938e-05,
  -2.570775922623929090e-05, 1.546321815036277194e-05,
  -1.062729126678453855e-03, 3.204790216367539449e-04,
  -2.724748779002761367e-05,-4.192343508268730367e-05,
   2.580672758012669777e-05, 4.282537579058855876e-05,
   2.159596436583473552e-05, 3.366918952261246006e-05,
  -1.608191165573759536e-04,-1.644299600124780490e-04,
  -9.214576550322018571e-05, 6.007626735929554263e-05,
   2.990064875550117542e-05, 2.439508967014879533e-06,
  -3.666083735586247723e-04, 4.099979273565902802e-04,
   9.611250390409522244e-06,-2.761134899430455989e-06,
   5.433329116505098924e-05, 2.545375161295073980e-05,
  -2.121145967745934963e-05, 4.527774263754230242e-05,
   1.903844183225395639e-05, 6.126804436236125616e-06,
   1.993755272650545013e-05,-1.579237562184721735e-06,
  -4.029260282663373071e-05,-1.444870449467880187e-04,
  -1.724275913127510231e-04,-7.709531281174511128e-04,
   1.348547524982945587e-04,-3.760579381722605353e-05,
   1.789615276012721632e-05,-8.929037819731255876e-06,
  -1.814474225930309484e-05, 8.412391357007854546e-06,
   3.741069675409685127e-05,-1.415767524606378770e-05,
   9.934577907642102960e-04,-4.951177819164799109e-04,
   1.772392696927184902e-05, 4.675320751336658857e-05,
  -3.232779334611032021e-05,-3.814333201715846032e-05,
  -7.352964799055438814e-04,-1.543839074074275335e-03,
   5.234379017043098889e-05,-4.647717322077464058e-05,
  -5.353087058244190177e-06,-8.446564919945775027e-06,
  -5.220845840799811691e-05, 4.662914186064686327e-05,
   1.758868973863740755e-04,-2.305727636296080749e-04,
  -1.062026321979831427e-04,-1.196703844492024647e-04,
   3.330114599832832749e-05, 4.991025621250627718e-05,
  -6.354545485668824890e-04,-4.168902933694422388e-04,
  -8.539215148494907181e-07, 1.998176213566954675e-05,
   3.991020789354532750e-06, 1.959774867322621651e-05,
  -2.622287884606802673e-05, 1.457259843076855074e-05,
   3.155618702281385831e-04,-1.265729278247107318e-04,
   6.678691356239141973e-05, 2.096445031021935458e-05,
   4.255744417682571091e-05, 7.930235775269462285e-05,
   1.415173517831483894e-03, 2.012183866953629833e-03,
  -7.928820364836301521e-05, 4.258380868611584275e-05,
   4.595224918596513925e-05,-5.280521560178468948e-05,
   2.268267710470588637e-03,-1.537062651174802511e-03,
   6.885477147673796350e-05, 5.795705690324685200e-05,
   2.667759296754164091e-05,-1.372246455481568539e-05,
  -1.225200864046472303e-04,-1.029020331548302522e-04,
   3.321428266131449094e-04, 1.846107871426541538e-04,
   1.479379023278605456e-04,-1.761089919760839455e-04,
   4.398646379506810397e-04,-9.534249316440787485e-04,
  -5.408735957030909373e-06,-1.925475461664264006e-05,
  -1.903725690403910940e-05, 9.817119154604172907e-05,
  -6.869603918983122461e-05,-1.344820432731342630e-05,
  -1.496087620669981234e-04,-1.746917808964701933e-04,
   1.443106016101268745e-04,-1.235898469249122663e-04,
  -4.966698845545282549e-05, 6.271515173995768769e-05,
   2.989587180213521391e-05, 2.497368453051455374e-06,
  -1.887845950853183911e-05, 6.603314817932266290e-06,
   9.999997508427036906e-05, 7.059139683448073336e-08,
  -1.559264243642853578e-07, 8.999986492739967068e-05,
   8.137174722177039742e-05, 1.605572756186286970e-04,
   2.998077356358647553e-05,-1.073879196629837950e-06,
  -1.741302763643953863e-04, 9.838011411489261469e-05,
  -2.680696438846894361e-02, 2.567646899936511934e-02,
  -9.930971569191772463e-05,-1.736017867684272161e-04,
  -2.135046209474752765e-05,-1.079080987152528342e-04,
  -1.146070900111864746e-05,-1.639061161737651666e-05,
   9.531039978729122638e-08,-9.999545786069105610e-06,
  -1.921313516856306303e-05,-5.554767051328544353e-06,
   9.320487862561957753e-05, 5.841960801292253868e-05,
   3.197183392254124724e-03, 3.458629548866777072e-03,
  -6.804872300972023241e-05, 1.107671941359280281e-04,
  -8.470175824784412853e-06, 5.315648737194519906e-06,
   1.203028968610439823e-04,-1.960286025222875974e-04,
  -1.704169687937198913e-04, 4.487293803030511282e-04,
   2.727133596140979971e-04, 1.674139285961347102e-04,
   4.837351637705531110e-05, 1.264922579918477181e-05,
   1.391942266896356974e-03, 4.061978897377863909e-04,
   3.989235656758232155e-05,-2.932556475990151731e-06,
  -1.940887314884064569e-05, 4.826556028081794405e-06,
  -4.655830908420433375e-05,-5.227163528358086262e-05,
   1.594745325897137299e-05,-1.206974459352489119e-05,
  -3.088339199257192076e-04, 1.849908373496224497e-04,
  -1.861412868461039362e-05, 7.315340956699458623e-06,
   2.068011267143424973e-04, 2.173322203210523488e-04,
   2.240031514473526681e-03, 1.729496693886819168e-03,
  -1.743288520697491102e-04, 1.649528761072189739e-04,
  -6.176385506478637569e-05, 1.366939143032200083e-04,
  -5.797814317232095720e-03, 7.245947083915154317e-03,
  -1.552972935920827883e-04,-6.915743346144685960e-05,
  -9.889058408128633098e-05,-6.797538069082098816e-05,
   3.772705709255869968e-04, 1.605207659883344353e-04,
  -6.151469557059317198e-04,-1.359934663346902886e-04,
  -2.192609161730516877e-04, 5.152908408257941440e-04,
   5.049407970349997950e-05, 3.240907149081244349e-05,
  -2.718557823419916913e-04, 1.991530676039719901e-03,
   1.143027130608249800e-05, 2.773713932382622428e-05,
  -1.754329707581604245e-05, 9.603787154537751623e-06,
  -7.590118165513113191e-06,-1.850378626750611577e-05,
   3.119246116185469433e-06, 9.501068553939703574e-06,
  -7.011861858058797711e-06,-7.129782134364292460e-06,
  -2.558347910440959331e-05, 1.566797998831495183e-05,
  -3.245067613604916333e-05, 2.338703953717207097e-05,
  -1.405878119335425527e-05,-1.422500162943360638e-05,
  -1.754027965287918367e-05,-2.433800710203677594e-05,
  -7.699017482426764500e-05,-9.204625457088792188e-05,
   7.620814430561951292e-07,-2.999031896919653400e-05,
   1.030549504659400087e-04, 1.943699492834801736e-04,
  -6.055681901849162231e-04, 9.893872684829561285e-04,
  -1.855019824171335902e-04, 7.475971187286281573e-05,
  -2.749937569128470304e-04,-9.207841038461722063e-05,
  -2.496397169770850355e-02,-1.444111204429938781e-02,
   9.253987174863999288e-05,-2.853705873714830628e-04,
   1.498438363119244791e-04,-3.382999035165767899e-04,
   6.323379166976935098e-06,-7.746926868806887768e-06,
   1.265420804311000794e-05,-1.548776997510261402e-05,
  -1.579627083201661549e-04, 6.201997926315020891e-04,
   6.249845977190092753e-05,-8.276436084004636659e-04,
  -7.750273497081843583e-04,-1.983244997581179935e-04,
  -2.647852311850067191e-05, 5.384132068832474005e-05,
  -2.819777951300402909e-03, 3.538792675621151821e-05,
  -2.779138733369485427e-05, 1.129773384659707650e-05,
  -5.806615705592874917e-06, 1.913852695605286816e-05,
  -2.231073024297044725e-05,-2.005570532355828030e-05,
   2.582123988706152822e-05,-1.527296862744184113e-05,
  -9.414667861129301306e-06,-3.371057558781671856e-06,
  -1.974710350959057352e-05, 3.170473621009285486e-06,
  -9.148426826512882741e-06,-4.038104332473277514e-06,
  -8.819303838177543339e-06,-1.795048411073937980e-05,
  -3.282629733253337106e-05, 2.285681962645094096e-05,
  -9.999264678874790331e-06, 1.212678102674107334e-07,
  -4.705571488302591734e-06,-3.972225568832256218e-05,
  -7.785813170318198282e-06,-6.275437297662984723e-06,
  -9.997513471104625349e-06, 1.732194343585850794e-05,
   1.476756958629558344e-05, 3.717416964121616796e-05,
  -1.333402954125998835e-05,-2.687384706722887492e-05,
   1.603202908243057080e-06, 3.996785884226225347e-05,
  -6.686398127332051031e-06, 1.884919308837411519e-05,
   6.616798726436100742e-05,-7.497864670280038693e-05,
   1.991258346923785173e-05, 1.867891747568770094e-06,
  -1.387597026397543944e-04,-9.821275336394425415e-05,
  -6.095675877374204590e-04,-2.256709019346141252e-04,
   7.634810670397477940e-05,-1.052186609053663987e-04,
  -8.829421738489006549e-03, 6.453883258755072072e-02,
  -3.774011367405315232e-03, 9.454588208837837529e-03,
  -5.951602638117645810e-02,-8.139256955957803463e-03,
   3.794476993006557267e-04,-2.048031971037492469e-05,
  -2.488156161662012276e-04,-2.430615460811597997e-05,
   1.886985712427400019e-05, 3.494909562379396777e-04,
  -6.076098459776125875e-06,-7.942356546208826756e-06,
   2.775521585416416001e-06,-1.980647570692190619e-05,
  -2.238047896032721714e-04, 1.682599659771600805e-04,
   1.263457392214209030e-04, 1.677401388475421233e-04,
   6.035443947714377551e-06, 7.973293946293332827e-06,
   1.316463630575258624e-05,-1.505630601898290950e-05,
   7.346031178613281871e-05, 3.167937171542638313e-05,
   8.420121548218510669e-06,-5.394585536742033082e-06,
  -1.103931219343149382e-03,-1.159131699141545911e-04,
   1.146818738941121803e-03,-8.547970527262595784e-05,
   1.287479190014329965e-04,-1.223243219213906085e-03,
   1.031461237324889913e-05,-1.713501594950003954e-05,
  -6.369866144170316597e-04,-3.928695464534445909e-03,
  -5.966596333275608671e-05,-6.322406153847284093e-06,
   1.823474354815724752e-05,-8.215480980011929173e-06,
  -3.999168684470606679e-05, 8.154650911987818667e-07,
   4.833730656735243123e-05,-5.063106550146645739e-05,
   1.882071188237766126e-05, 2.336195206399774337e-05,
  -1.831029473724887831e-05, 8.045688698618414710e-06,
   1.473078235740108695e-05, 8.878628301229239369e-05,
  -6.310728236513621222e-06, 7.757235920408099515e-06,
  -6.905629382683026857e-05, 1.145549138633881968e-05,
   3.897313672124341115e-05, 9.005254805238370583e-06,
  -1.010636303828137957e-06, 1.997444903523961358e-05,
  -1.099441673614260379e-05, 1.670696862485913280e-05,
  -2.008261725658493102e-04, 6.139094731759496689e-05,
   3.356322805421010935e-05, 7.261893501409315711e-05,
  -4.660669140250694374e-05,-1.530614788786240825e-04,
   2.449469739027621018e-05, 4.358910184620458481e-05,
  -2.239654478886777259e-05, 1.995982919566797952e-05,
   4.626985702327894345e-05, 3.819817182857478843e-05,
  -1.328337505639364829e-05,-1.495165365808006892e-05,
   2.567180277271070797e-05, 4.290639279173958970e-05,
   3.883814620578620311e-05, 9.570705266487690180e-06,
   5.179515101203046418e-05, 3.028633902671234787e-05,
  -3.995395450067298752e-04,-2.336079654458686483e-03,
   1.843186689143546395e-03,-3.155357807983931516e-04,
   9.102192741793989730e-06,-4.141266387378722613e-06,
   7.836451049563545300e-05,-1.609358551657904859e-05,
   1.992849550183830719e-05, 1.689694360886147418e-06,
  -2.029280868852560691e-05,-2.209529170504204322e-05,
   6.593034318572964507e-05, 4.531213796999556548e-05,
  -9.029615664941131512e-06,-1.784561685522385527e-05,
   1.872897917798637147e-05,-6.297215458748021445e-04,
   1.214578138801814225e-05,-2.743136880424438889e-05,
   2.213835108454229202e-04,-8.413615995074617913e-04,
   4.546064819447136608e-05, 2.081656709783117677e-05,
   6.904847348853798965e-05,-4.040183546452645374e-05,
  -1.352332815060725175e-02,-3.126339030078703098e-03,
   3.709139917977837160e-05, 3.352951098489711948e-05,
  -3.234559499914477585e-06,-9.462432289930164096e-06,
  -3.555162634031590823e-05,-1.354107893210823512e-04,
   1.137061664072697983e-05,-2.776164759537197817e-05,
  -2.653903985137185781e-05,-2.259844171478150258e-03,
   2.544803817273811122e-04, 2.144956814324215210e-03,
   2.249815008225118998e-03,-2.885184162246547430e-05,
   2.802938420759189782e-05, 1.069362524793150096e-05,
  -7.536420921910003430e-06, 6.572850195143442552e-06,
   5.392089899791401193e-03,-1.720745917492631435e-03,
  -4.749961058808437286e-05,-9.921586059688412504e-05,
   1.078222784802341886e-05, 1.684468944900167374e-05,
  -1.742377923444328008e-05,-6.779684297361774812e-05,
   3.995906243063299817e-05, 1.809234552172497575e-06,
  -2.725896355247472570e-05, 2.927368965547142555e-05,
   3.626047213080522495e-06,-1.966854803000239263e-05,
  -7.999999994140270093e-05, 3.061955218309284444e-09,
  -2.714749837550944677e-08,-7.999999539383319952e-05,
   2.747132099817141155e-05,-6.438421019640937638e-05,
   2.789423655632633357e-05, 1.104135711494323804e-05,
   7.746233603095270534e-06, 6.324228408768746854e-06,
   2.826098849443188510e-04, 2.252339151400551721e-03,
   1.456996972878527312e-04,-3.565947574247377516e-05,
  -1.776247580431721245e-03, 2.214600031844479418e-04,
   3.646003081885618142e-05,-1.645193461839846715e-05,
   5.846680012229333689e-05, 9.317528257783713481e-05,
   9.090843131633576037e-05,-7.833043543606191294e-05,
  -7.619319165187010820e-05, 4.790195764163915218e-05,
   2.120360347025817039e-05, 2.122279905846671694e-05,
   1.654404235696922955e-05, 1.123808980613734607e-05,
   3.977266727073338275e-05,-9.175039475757875167e-05,
   2.831374792867091263e-05,-9.916233066627854186e-06,
  -4.918617899068340771e-06,-1.399135704567750795e-04,
   2.541177649141755242e-05,-3.089080147147753416e-05,
  -3.592026652332920572e-05, 3.478123708111882699e-05,
  -1.214791369888943935e-05, 2.743042458228334311e-05,
   5.514017225149942802e-06, 3.961812229322270748e-05,
  -5.760620452788809201e-05,-1.052688234943809309e-04,
  -3.961812229322271426e-05, 5.514017225149875039e-06,
   1.657411338791647167e-05, 1.119369310837527039e-05,
  -9.647653058635285455e-06, 5.921927718623561055e-05,
  -1.969343664204488759e-05,-3.488345342101871874e-06,
  -8.373392752263024018e-05, 3.299438409237105029e-05,
  -1.808398291531622615e-05,-4.661512160145622654e-05,
   3.832382877682531750e-05, 1.145792947633106008e-05,
   3.484511476678666514e-04, 3.289069304448588669e-05,
  -1.166815101103966211e-05, 3.826034829929772469e-05,
   3.231044877723749287e-05, 7.318493629028799939e-05,
  -2.769813296753917525e-05, 5.322418087779763423e-05,
  -1.404748617213100550e-04,-3.958115880370088793e-04,
   5.830528863568601146e-04,-7.507392978372114979e-03,
   2.829559349398935611e-04,-9.967917978339660391e-05,
   8.764118899666946676e-05,-4.815622484425105776e-05,
   1.983312224023681212e-03,-3.832396404839147190e-04,
  -8.617462653232014699e-03, 2.596023385902261355e-03,
   3.762830505740383268e-04, 1.964283855722154856e-03,
   1.665616774795061631e-04, 1.278952993476029608e-04,
   3.959858065027744873e-05,-5.652646325702010854e-06,
   1.165128420059297475e-05,-1.625569366336031220e-05,
  -8.391465409719030415e-06,-2.880248788347091742e-05,
   3.671109824869745516e-03, 7.477422861771616802e-03,
   4.927276997640018304e-05,-8.701835518356318367e-05,
  -1.511162927128720289e-05, 1.310109387674082183e-05,
   1.082830365407060010e-04,-5.171831394703552527e-05,
   3.655528000429414697e-06, 2.977645235816511090e-05,
  -3.282083848469895075e-05,-2.286465746870712862e-05,
   1.192693863881943479e-05,-1.605453626567382734e-05,
   9.028616557457502898e-06,-1.784612235356477467e-05,
  -1.188692499194837033e-03,-5.576865031478173281e-05,
   2.369364540054851056e-05,-1.278225769089055049e-04,
   5.026963734003438204e-05,-1.108861111033163397e-03,
   2.309000791564466172e-04,-9.583920620261147895e-05,
  -9.105011174076336122e-05,-1.552735558683271324e-04,
   6.517309914571412085e-05, 1.570110414835304558e-04,
   8.239668511159654575e-06,-2.884627987845580062e-05,
   1.059838521232812973e-04,-1.198641860153000223e-04,
  -1.670748204342666055e-04,-1.099363651248192538e-04,
   8.734379363747111059e-05, 8.228646129841082435e-05,
  -1.923663937089004704e-05,-4.615139982399583702e-05,
  -2.577076948665541390e-04,-3.444915102824770318e-05,
  -1.786724505698049969e-05,-3.578772909914522908e-05,
  -5.177944357604229132e-05, 3.031318562862459585e-05,
   6.307801161970517711e-07, 1.999005043627980678e-05,
   7.999948408448806188e-05, 2.873085723456573155e-07,
   4.454795924861192297e-04, 2.871374804486539231e-04,
   3.053194534156956772e-05, 5.165075327291373267e-05,
  -2.326381178699136630e-04, 3.496848668643585695e-04,
  -3.494510126628593938e-04, 1.241766479555999995e-03,
  -1.719438142072189231e-05, 1.389401066919078258e-04,
  -6.628118086030091154e-04,-1.917824454333817090e-04,
   4.969235836879248424e-05, 3.161181258956017215e-04,
   8.943471903823926655e-05, 1.007129736186969837e-05,
  -1.483751526204683346e-04, 2.201849415497627826e-05,
   1.682688207058713546e-05, 2.483658671763399096e-05,
   2.621942609936576997e-05,-1.457880979435211395e-05,
  -1.538851930141212997e-06, 1.994071048726952415e-05,
   1.179599705410373519e-05, 3.822112574872143202e-05,
   1.314371328439328497e-06, 9.913245079739361462e-06,
  -3.998559788809447258e-05,-1.073294708649464447e-06,
  -4.497941297367080010e-02, 9.543207629531404168e-03,
  -2.002735072139467178e-05,-7.745259984714685116e-05,
   2.990580880101985708e-05,-3.966408211535975086e-04,
  -7.642505308221100456e-05, 2.364764811521920674e-05,
  -2.195472783590860996e-03, 5.768875596784829151e-04,
  -1.757557623598766349e-06,-1.992262510814601204e-05,
   9.460467034554669204e-04,-1.630816816231786960e-04,
   1.983740404001238134e-05,-2.545073860087479483e-06,
   9.766804159703004073e-06,-2.146983117308587658e-06,
  -8.420899896851185196e-05,-5.393370460779763173e-05,
  -3.586160533654203557e-05,-1.661744422668122011e-04,
   4.720287195803859602e-05,-1.648905330554224565e-05,
  -6.667235024999256077e-06,-1.885597987698924282e-05,
  -2.836987091300644158e-05,-4.117220451201697933e-05,
  -5.033474618022526378e-05, 6.218048992226016790e-05,
  -3.884103189008436015e-05,-3.148609600622868628e-05,
  -5.425631091065331234e-06, 8.400150431014032719e-06,
  -8.497704503946317598e-07,-1.998193909963785701e-05,
   1.424845070548436013e-04,-4.612856520006229920e-05,
   1.955590231274804630e-05,-4.191262904454411269e-06,
   9.319291963391216182e-06,-3.626402804580857636e-06,
  -8.745220377643307387e-06,-1.798669287407922413e-05,
   6.124625276056583900e-06, 7.904996219346903681e-06,
   7.525796920497397925e-06,-6.585011823180874420e-06,
   9.987168255449243833e-06, 5.064289065080489501e-07,
   1.995946930759980077e-05,-1.272629152181236016e-06,
   2.532120880370332850e-05, 1.608839285694059146e-05,
   1.781889778060880130e-05,-2.413476500577982993e-05,
   1.825000898563984154e-05,-8.181514042282459490e-06,
   6.849512302118075386e-05,-1.443669360737815064e-05,
  -4.783604013787098886e-06, 8.781636102645108558e-06,
  -4.690045135538338148e-05,-1.733054132626322535e-05,
  -7.919369376989683268e-06, 4.936885241395426747e-05,
   5.435359113693996179e-05, 4.668465348811302548e-04,
  -4.296527193523393996e-05, 2.557313839815909031e-05,
  -4.042445040960199187e-03,-1.148960565427797030e-02,
   6.706474862327538398e-04, 6.586592056668517372e-04,
   1.031040574857139402e-02,-3.627731150433554860e-03,
   1.654337616051192278e-05,-1.123907047810475548e-05,
  -7.999936884116879343e-06, 1.833033032572371285e-05,
   4.411129294753107923e-05,-2.354132185110035052e-05,
  -1.110679283562128472e-02, 7.673926824422533030e-03,
   2.259469133042000844e-05, 3.300727076998404821e-05,
   7.918548576854826518e-05, 4.277451161146135348e-05,
  -1.576888834292251309e-05,-1.230212015989287129e-05,
   1.062337035377632685e-04, 1.453079496540042343e-04,
   1.875639842921898408e-05,-2.341361821599540207e-05,
   2.261437500952530880e-05,-4.459360988895782964e-05,
   3.127538319824332700e-05,-5.120400771231720083e-05,
  -1.772024366308005210e-05,-9.273239160135540694e-06,
  -3.634873380219305259e-05,-1.660685688231740926e-04,
  -1.377344109905193742e-04, 2.508449778438251641e-05,
   1.172242451339868002e-04,-2.566079407904154383e-05,
  -6.605768694083289250e-05,-2.315992219388731053e-05,
  -4.312921948075346362e-04,-3.726755193168711277e-04,
  -2.674852581075165656e-04, 2.699104234651845719e-04,
   3.103151262683993545e-04,-3.529936577461801261e-04,
  -6.070215617972570991e-05,-3.486041071376220959e-05,
  -1.753527513762418829e-05,-9.618426370660591510e-06,
  -1.524940887202309034e-04, 4.866678054950690632e-04,
  -4.802251578995165860e-05,-1.392257078286347175e-05,
   1.807464474363222801e-04, 7.587692150707939232e-04,
  -9.947576941303379623e-06, 1.022601093706293135e-06,
  -9.566633351714621774e-06,-1.756358523519220086e-05,
  -7.264434702606525728e-06,-4.946946521291256199e-05,
   1.530213641375589501e-05, 1.287806744720674101e-05,
  -8.313218751678917473e-06, 5.557912736516653895e-06,
   4.500713628828886630e-05,-5.361303650351648066e-05,
  -2.921322814259407662e-05, 6.825489102529536815e-06,
   1.708019757331137979e-03, 8.227094606530569593e-05,
  -1.765464184307575246e-05,-9.397532729004932117e-06,
   4.381461866213550230e-05,-2.408898485805593129e-05,
  -2.687503791109602491e-05,-2.962654784609829747e-05,
   7.612732123252216251e-03, 6.139601747638344202e-03,
  -1.792142150699337002e-04, 1.883673674415702471e-04,
  -4.973911337609503852e-03, 6.176172439755841723e-03,
  -1.490528044274614869e-03, 1.790873013150539369e-03,
  -8.691080988687117752e-04, 3.380051939317029776e-03,
  -1.363001761150931315e-03,-1.129214859581408568e-03,
   4.850492759700674198e-05,-1.213556751079792409e-05,
  -2.872064774255676206e-05, 1.979270683692555737e-04,
   7.340799851736022326e-05, 4.743535240236708135e-04,
  -1.386544245428960275e-04,-1.936364001623523787e-05,
   2.529301534582412578e-05, 1.613268033266342918e-05,
   3.226234876653192094e-05, 5.058795164924802674e-05,
  -3.869962181020210348e-06, 2.974934272748682500e-05,
  -1.328850605751625236e-05,-1.494709358903442336e-05,
  -3.781138088449486365e-05, 3.076853904162621237e-04,
   3.733188325582445602e-05, 1.436420873468126962e-05,
  -3.917013168470661580e-05,-8.105602001254619699e-06,
  -3.035507766833967207e-05, 7.401735782739794040e-05,
  -1.559160948912310856e-05,-7.846592708646657087e-05,
   2.775541326317210078e-05, 4.391237149535316838e-04,
   5.885015545234506177e-05,-1.169013272956389326e-05,
   3.927046569226997903e-05,-6.969813860005335930e-05,
  -4.400453065678187713e-05, 5.443896841120653450e-05,
   5.227357310705973314e-05, 2.945290400997636231e-05,
   1.099392561858258954e-05,-2.791296472059307316e-05,
  -9.694029732109783444e-04, 6.370697571928173259e-04,
  -1.067940253467513534e+00, 1.067818124452311057e+00,
  -6.010283845754473128e-04,-9.212843648595304708e-04,
   1.037899868404368146e-02, 7.890140634219897434e-03,
  -3.060952038062106665e-04, 3.160786709141165450e-04,
   2.793327932355745848e-04,-2.426379826474242335e-04,
   1.499525323049583211e-04, 3.773334775822395284e-06,
  -2.024578246451554011e-03,-2.131826194602916107e-03,
  -4.193943489798534683e-05, 1.446241474814932210e-05,
   1.438509911689504224e-05, 1.389492437536475161e-05,
  -1.313466911139505794e-05,-1.508245561353205595e-05,
   2.495626045808704000e-05,-1.664887575628220057e-05,
  -3.067131228752117169e-05,-2.567626535462961952e-05,
   2.434938902844780236e-05,-3.173495318952441986e-05,
   4.575342325059690580e-06,-1.946962358671881134e-05,
  -1.080993716031789967e-05,-2.798473259815033797e-05,
   1.590841597730383903e-05,-1.212115098054074895e-05,
  -2.996002615378173749e-05,-4.002994919887751022e-05,
   2.417374666629617792e-04,-2.531066913603301628e-04,
   3.207801350516113482e-05, 1.771186072934255700e-04,
   2.064944564078080775e-04,-5.739860969334046248e-04,
   1.780125269098794324e-04,-2.667471205391837023e-05,
   4.858978451162274840e-06, 1.940078164433435158e-05,
  -4.882083931895052180e-04, 4.186364555699214219e-05,
  -5.943407259488492262e-06,-2.940537213074950138e-05,
   4.437690136138182427e-05, 5.181029729943287645e-04,
   6.793088409671374755e-05, 4.225393456045064400e-05,
   6.593254905431616061e-06,-7.518576311510175185e-06,
   2.453987476469804898e-05,-3.158788607255851391e-05,
  -1.970809440693680538e-05,-3.404557951814933806e-06,
  -3.433671382254817155e-06, 1.970304293348325333e-05,
   9.186458903960862050e-06,-1.776538693093506000e-05,
  -3.340408312013721723e-03,-3.337269869332248028e-03,
  -2.404103888579118913e-05, 3.196917967811930525e-05,
  -4.304859090345087685e-05,-4.179496167275819734e-05,
   2.619213701288429004e-05, 3.023196915019425566e-05,
  -2.295437096137434451e-05,-1.931571520207352614e-05,
  -3.077568465028555764e-05, 3.940630957481528124e-05,
   1.846338728653581097e-05,-3.548384604164813550e-05,
   3.126050172777396362e-07, 2.888456007730447867e-04,
   1.455489737889855097e-05,-1.371695893008840992e-05,
  -8.628393269477192408e-06, 5.054782842738221073e-06,
   2.603336386669041552e-04, 3.913136805408798467e-04,
  -9.704934047970636057e-04, 1.226171340937178521e-03,
   8.631661883071548651e-06, 5.049199256944584597e-06,
  -1.771142127107848367e-05, 9.290078393554530525e-06,
  -9.097795786967769995e-06, 4.150916985273437935e-06,
   1.707612802705149875e-05, 1.041181307956238213e-05,
  -1.041836706906928858e-04,-7.775450315842329335e-05,
   2.987965640065290041e-05, 2.684424217392275936e-06,
  -4.921856012561376526e-06,-3.969603674665285405e-05,
  -6.395918376057140454e-05,-1.466602291443780143e-04,
   3.838222023755733702e-05,-5.853892012700305378e-05,
  -4.635853729438567383e-03, 1.791580363603743984e-03,
  -3.801930441147888994e-05,-1.243110984857353916e-05,
   3.945551479031163093e-03, 5.365465825659036618e-03,
  -8.187514644807812245e-05,-7.346060436795875958e-05,
  -4.116846159888299175e-03, 3.027156701562204628e-03,
  -1.510846507090628712e-05, 1.310474277508737476e-05,
   4.547968901728060464e-05, 2.077493410077264096e-05,
  -3.960161737969632146e-04,-3.052395618054996461e-04,
  -2.074474244153979958e-05, 4.549346833375289551e-05,
   1.970686040515856244e-05,-3.411693563553700706e-06,
   2.721578262683384277e-05,-1.262145696854880785e-05,
  -1.396339820226936584e-05, 6.859317393622239812e-05,
   2.641827782442322763e-06, 3.991266397984374284e-05,
  -2.639033403097602545e-05,-3.005911292326353512e-05,
   1.548593255370835932e-04, 4.023169514449491277e-05,
   2.178606636234527036e-06, 9.759798826028890501e-06,
  -1.061256494180711900e-04,-6.615416438408036701e-04,
   3.863315911207261641e-04,-5.336573528143382408e-05,
   5.329833164385658914e-04,-8.676856803098409975e-05,
   2.507527464418368693e-05, 3.116457285955895838e-05,
   8.893599776373876508e-05, 9.481765817487927304e-05,
   3.116669976047638734e-04,-3.383248181910870748e-04,
  -6.569700063091100473e-05, 6.151344656334971285e-05,
   1.972970099829184074e-05, 3.277025864713604441e-06,
   2.481606351314968298e-05, 1.580637940570557391e-04,
  -2.852955912281400388e-05, 9.277082313845243358e-06,
   2.782058161504009005e-05, 2.874048083454578661e-05,
   9.441552260418012866e-06, 1.763113980756194848e-05,
  -1.295468956711186191e-06, 1.995799990435408416e-05,
   2.990783449202516741e-05, 2.349773605611789668e-06,
  -1.127156733068156980e-05,-1.652125206846962968e-05,
   1.359223301687480451e-04, 3.441295107390498868e-04,
   4.888460758511641642e-05,-1.050214936330552925e-05,
   2.499072051448315737e-04, 1.262790117822397635e-04,
  -2.947924024705503689e-04,-1.483153378637592059e-04,
   3.405788012034433650e-03, 3.267875153227635387e-03,
   1.305017332108969886e-04,-2.589774075647369210e-04,
   4.505076321321810944e-07, 1.999492542805275755e-05,
   1.152651968368914603e-05,-1.634439793879011963e-05,
   5.246650835690257047e-06,-1.699190179320971428e-04,
  -1.187883453470057990e-05,-6.898473229706123552e-05,
   1.599237815831502712e-04, 4.938024315943477169e-06,
  -6.934234200654959719e-03, 7.051922081723981496e-04,
   4.668215319886075826e-02, 1.687916386312111883e-02,
  -6.513498760003618359e-04,-6.376820786178196386e-03,
   9.885667712256556794e-06, 3.875917406089619577e-05,
  -2.678988576269064788e-04, 1.750148624608736621e-04,
  -1.940697162820582378e-05, 4.834196129866300468e-06,
  -7.983996667985451687e-06,-6.021278701870327182e-06,
   1.706158295054964352e-05, 3.617875602092357685e-05,
  -2.943463116431683455e-06,-2.985525121117232165e-05,
  -5.459819300731445069e-05, 1.503962676409758572e-04,
  -4.492334174158019760e-06, 8.934144260514937351e-06,
   2.919025157349539341e-05, 6.923092739235102325e-06,
  -6.910584443202375947e-05,-1.115267973793427019e-05,
  -2.374908559114856969e-06,-8.996866015083165359e-05,
   1.115267973793426510e-05,-6.910584443202375947e-05,
  -1.784564394582440600e-04,-1.604783450060663901e-04,
  -2.383574326753440225e-06, 8.996843098236649745e-05,
   8.462203199803604173e-04,-6.216197954154422918e-04,
   6.619549197296111235e-07, 2.999269603893997896e-05,
  -7.496494850808826771e-07,-7.999648758320280096e-05,
  -5.468892334675919294e-03,-6.688679478515713317e-02,
   7.878519406309649614e-03,-1.499777304936379847e-03,
   6.188351318426844189e-02,-5.059535153793633631e-03,
   2.325166068940624515e-05,-1.177257842411114384e-04,
   3.199705236892518766e-05,-3.842120039379638198e-05,
  -2.295849700633894279e-05,-1.931081083771279185e-05,
   3.289368898353252119e-04,-2.646738569377626307e-05,
   5.571183440192567203e-06, 2.947815996760524087e-05,
   1.684975015769383724e-05, 2.093229225852326423e-04,
  -1.522297964143046546e-05,-1.297154157517885944e-05,
  -2.723968924670435238e-05,-1.373244309281599653e-04,
  -2.084485165934610632e-05,-2.157526730540912306e-05,
   2.343762275730258826e-06,-2.990830617729569441e-05,
  -2.777033097094404809e-05,-1.134939283680963049e-05,
  -2.942609530416796844e-05, 4.042406356553017704e-05,
   3.610897286422965607e-06,-2.978189753502793970e-05,
  -8.809098580220145816e-05,-4.732840817517890310e-05,
  -2.620785913919569463e-06, 5.994273501595836530e-05,
   6.508683709515340060e-05,-2.576244625319890535e-05,
   1.835010406827592214e-02,-2.956879572595818781e-02,
   2.576477499490284641e-05, 6.508591529249648975e-05,
  -1.314128914914518352e-04,-4.827682621979100544e-05,
   1.188741369365789929e-04, 7.395227898843593616e-05,
   2.311172900640910561e-05, 1.912715301173459814e-05,
   1.281117435528138401e-05,-2.712699415045059169e-05,
   4.431725085667985285e-05, 1.847592522081265324e-04,
  -9.999924761306412579e-06,-3.879134195812406378e-08,
  -1.653107714568636697e-04, 3.965285412598435540e-05,
   9.438402806337501142e-05, 5.649473644979715974e-05,
  -1.358026649116979783e-05, 2.675025910208741762e-05,
  -2.113339319706487840e-04,-1.680415698505140654e-04,
   1.024581342269714193e-03,-5.222385212455996984e-04,
  -3.357509265754857214e-06,-1.971616421950198573e-05,
  -3.506162650782731528e-05,-2.273118614296790868e-04,
  -1.585873263943611826e-04,-6.123773270695414758e-05,
   2.935067486024444430e-05,-6.207888952632355882e-06,
   1.887317380661498155e-04, 1.130501262561445333e-04,
   8.421360148658603082e-06, 2.879376135982558146e-05,
   3.977223406776413822e-05,-4.262557595972398990e-06,
   4.500466313159240785e-04,-9.517368145232554940e-05,
   1.391107991046459068e-02,-1.386454371650388271e-03,
   9.136264707079319797e-05, 4.304101145654196992e-04,
   4.311592470477302919e-05, 6.738706876584219289e-05,
   4.895166907358452136e-06, 4.975979643194998757e-05,
   2.830286829377678622e-04, 2.383165219503517002e-04,
  -3.497634214488953326e-05, 1.252064514718136221e-04,
   2.740544339698121551e-04,-5.739483619182008403e-05,
  -1.959971687554621264e-05, 3.981343793046391402e-06,
   2.252850135497359949e-04, 1.083820218942942051e-04,
   1.251689870213783034e-04,-3.511017926530746045e-05,
   2.971549561711752584e-05,-4.121810309690278585e-06,
  -2.620761628482521657e-04,-6.493138583717758885e-05,
   4.121774005360576537e-06, 2.971550065283662436e-05,
   1.018356656127289862e-04,-1.101339966096411238e-04,
   3.686486531690456089e-04, 3.159383668769442938e-05,
   1.714442780628578321e-03,-1.381519162029557738e-04,
  -2.903193775569665292e-05, 3.387582420992135451e-04,
   4.620626609993870159e-04, 4.712728480510685615e-04,
   1.292237319780335618e-02, 1.006561825903870729e-02,
  -4.355699868838506443e-04, 4.270582940606612002e-04,
  -1.023171294650005044e-04, 9.555733890205566337e-05,
   3.056618179315028958e-04,-1.509361074447995808e-03,
   1.692497701897286225e-03,-4.266562026863362882e-03,
   1.411379241339787930e-03, 2.856722547170532206e-04,
  -3.958558581108154341e-05,-5.742943147333063969e-06,
  -1.138883816392930251e-02,-5.907898549892965333e-03,
   1.122209850980455281e-04, 4.250235880070946749e-05,
   1.875784380641923278e-04, 7.468027380596551365e-04,
  -5.973138632558065784e-05, 5.671109911140480268e-06,
  -1.054178031447658221e-05, 1.699620156980123989e-05,
   3.597869649003436807e-05, 1.747951369111821351e-05,
  -1.562650374718920941e-04,-3.463830799330535780e-04,
  -1.974856750580602499e-05,-3.161341719685240707e-06,
   8.461247774656158584e-06, 3.909484986664965215e-05,
   9.750497665081557974e-05,-2.219863798353200423e-05,
  -5.979560431712884492e-04, 1.206174549347490256e-04,
   3.266980762987424959e-06,-1.973136682275888627e-05,
  -1.998943428216801496e-05, 6.708518850744093836e-05,
   5.196606813825093568e-04,-7.832960974146788114e-04,
  -7.667958762690393914e-05,-2.280878868699436404e-05,
   5.905750143046056258e-05, 1.059299413721867030e-05,
   6.001016945754672230e-06,-7.999237189680356042e-06,
   9.400579614705599194e-07, 1.997789506001760733e-05,
   2.919723441754942323e-05,-6.893584145179301555e-06,
   9.214873261627743015e-05,-6.007171611677003759e-05,
   5.414792473528933463e-05, 2.584573943344322094e-05,
  -2.516911097639556961e-05,-1.632531324838467322e-05,
  -1.613651631993503989e-03,-2.832618648982722018e-03,
  -5.952651950274172711e-05, 7.522863543206717544e-06,
   1.959798835952989999e-03,-1.943396131157336957e-03,
  -6.435525824041341773e-04, 5.552837776137261802e-04,
   1.288704218318976720e-03, 1.299284971700540720e-03,
  -1.969984227385881197e-05, 2.262556550420530984e-05,
   2.395585283291893296e-04, 2.121596368415844714e-04,
  -5.631466403068107439e-03,-3.225939576482354625e-03,
  -1.926120424998371914e-04, 2.167962201793216363e-04,
   4.028974014388393932e-05, 2.960974230111277614e-05,
  -7.978650236048034743e-05,-5.840722650585782195e-06,
   4.351544461052871116e-05,-2.462531381217319290e-05,
   3.998813556605917594e-05,-8.062846280284943019e-05,
  -3.099893840369556002e-04,-2.565498857697083790e-06,
  -8.053514700902213351e-06,-2.398648388175356465e-04,
   2.285265384893048607e-06,-2.799906740627633775e-04,
   4.677730313175376765e-06, 8.838486245800250608e-06,
   4.997958520431899443e-05,-3.319700382269788957e-05,
  -3.317404889221954459e-04,-6.837749980875746682e-04,
   4.404523225980466007e-05, 6.678336256269120123e-05,
   4.961965416705371094e-05, 6.155478888111741694e-06,
  -6.330059980545027845e-03, 1.020639214623376458e-02,
  -5.674835638178933779e-03,-2.370388255044791892e-03,
  -9.449924571614261304e-03,-5.861171008493183676e-03,
   2.426932343127566588e-05, 1.763519039273843658e-05,
  -8.234670695380185879e-06, 4.931724037837728706e-05,
  -1.701655596814029088e-05,-1.050889256692393572e-05,
  -1.945044750455414981e-05, 4.656188556382071981e-06,
  -3.888736416980430996e-06, 2.974689444428191493e-05,
  -2.270636463077186873e-06, 1.987068720634855971e-05,
   4.896015968745583407e-04,-1.975541287552408639e-05,
  -1.919986869118729233e-05, 4.616670924206279640e-05,
   1.231140320697643625e-05,-1.576164176332054605e-05,
   1.479613333664242060e-05, 1.345639023974479129e-05,
  -3.988132009673545385e-05,-3.079010773239535080e-06,
   1.550667860737110559e-05, 3.687198012810947165e-05,
  -2.154023946188842094e-04, 8.063379187692024976e-05,
  -3.687199636664511394e-05, 1.550663999511530769e-05,
   2.696407347591785490e-04, 2.817691859634944597e-04,
  -6.369411801979212810e-04, 6.072116047705932752e-04,
  -2.809067193830835766e-04, 2.705391191776774173e-04,
   1.207930009045647983e-03, 4.234443213068052520e-04,
  -2.992789043706358776e-04,-2.078791472735437085e-05,
  -4.448490918531932195e-04, 1.274601618340958070e-03,
  -4.713215599872966109e-06,-1.943670750690852298e-05,
  -1.408279506160851425e-05, 3.196899668166843910e-04,
   2.835466204436405617e-05, 7.894909835712818260e-04,
  -3.097408231477795110e-04,-1.267369226926301909e-05,
  -6.586940967041059376e-05, 2.369010066824577833e-05,
   1.651537580131870047e-05,-2.504480708931926884e-05,
  -2.182507325667167259e-05, 2.058315275512755677e-05,
  -1.996846717629640632e-05, 1.122639135774738723e-06,
  -4.872420940363230888e-05, 1.122280793700886063e-05,
   3.116480982274359458e-05, 3.909929192085483888e-05,
  -4.498812855869382509e-05,-3.969972655808144685e-05,
  -1.565704424549943822e-05, 1.244415386816126592e-05,
  -2.110880234561630600e-05, 4.532569319418847592e-05,
  -9.798074632945275782e-06,-9.951883104964223421e-05,
   2.727665744372887691e-05, 4.190446227667729600e-05,
  -2.916279381293791250e-06,-3.989354978652865963e-05,
  -2.992026880990537351e-05, 2.185752580463685565e-06,
   4.739489502239467919e-05, 1.592871387828245690e-05,
   1.911445665393894015e-05,-5.687387402687361774e-05,
   1.685094699470778571e-05, 1.077244565461105994e-05,
  -1.965616793035466993e-05, 3.692568522545873317e-06,
   8.041541377297688526e-06, 1.831211654280327062e-05,
   4.138349717853379592e-05, 4.344428801665744562e-05,
  -1.540399098083864322e-05, 4.756802562501666473e-05,
   1.733282687700379117e-03,-1.354891554523147230e-03,
   1.505778567275963246e-05,-3.705756455345163666e-05,
  -3.154391721943318049e-04,-9.694394589325667534e-05,
  -4.740312878239332818e-04,-2.981515355720699002e-04,
   3.910665209295371227e-05,-1.859318954942391921e-04,
  -1.143201161103822095e-06,-2.997821027188332668e-05,
  -8.560427744799690899e-04, 1.207307238552240590e-03,
   9.099874056163298171e-04,-2.317762481709388211e-03,
  -9.536073987608701145e-04,-6.778885815740864950e-04,
  -4.695582903516820616e-05, 3.735170838957777305e-05,
  -1.580380962605699025e-04,-2.497919394886170030e-05,
   2.925558004821218923e-03, 9.630733930633158905e-04,
   2.335572397405623769e-05,-1.481705441632974972e-04,
  -7.196020379044527557e-05, 3.495324120074683037e-05,
  -1.351587249323640151e-05, 1.474181775584597603e-05,
  -3.281803695140175511e-06,-1.972890682492480104e-05,
  -2.471547350374348747e-05,-1.700427503558306884e-05,
  -1.683063175902668838e-07, 2.999952787934269058e-05,
  -1.186246964113182151e-04,-1.811577769025080859e-05,
  -1.999999925458352692e-05,-5.460463209876055268e-09,
  -4.290031088847108880e-06,-9.033030125972418882e-06,
  -4.247980502656249898e-04, 1.146586956603098874e-04,
  -3.844970607549885391e-05,-4.606104756415931517e-05,
  -8.465636694645461285e-03,-7.424324572260579576e-03,
  -3.111152049565349496e-03, 2.836341468244845711e-03,
   6.857396241705002345e-03,-7.818958804358167730e-03,
  -2.887175908297879472e-05, 2.768431916183657521e-05,
  -5.340318895739302182e-06,-5.976186906457837776e-05,
  -2.076315622652696538e-05,-2.165389903719038093e-05,
  -3.954235599051475806e-05,-6.033413852820143433e-06,
   6.534925021862935909e-05,-3.844859886860156552e-04,
   5.426223722464131811e-06,-2.950518761360055469e-05,
   3.953169531217830171e-05,-5.776889358249038457e-05,
  -7.695405350333579038e-05,-2.692175210668981060e-04,
   4.955464448658318099e-05, 3.382805359178017203e-05,
   1.190476831734723532e-05,-4.856208903363080996e-05,
  -3.401150728826394365e-05,-3.664993004059310358e-05,
  -1.058147117762614220e-05,-2.807191599654479180e-05,
  -1.828736193344122444e-06, 5.997212455745713658e-05,
   7.193513144930992784e-05, 1.758560117350854290e-04,
   6.016748633477057308e-05,-5.272450652358158789e-05,
   1.845288279657008687e-05, 2.365356456215527044e-05,
   6.755100741413623089e-05, 7.373507576001609701e-05,
   1.598423421389790053e-04, 5.788286153539385352e-05,
  -1.644128071870088267e-05,-1.138790096237557838e-05,
  -8.210008144935168823e-05,-7.320912938978184435e-05,
  -9.666957873048276552e-06,-2.559282219824529169e-06,
  -8.316875613375967742e-06, 5.552439106521757645e-06,
  -1.695359765226911352e-05, 1.061016148062673376e-05,
  -2.376975040300616430e-05, 3.217139981068260177e-05,
   1.095683146807900112e-03, 1.039027642462479360e-03,
   6.916834428851096196e-05,-1.217199250262092814e-04,
   1.566235565065745140e-04,-1.075595720855743658e-04,
   3.441406684704694706e-05, 2.038803578197233746e-05,
  -5.362825396795726402e-06,-1.926759205929694780e-05,
  -1.070554251962672898e-02,-5.354648388126355754e-03,
  -3.481052547168793018e-03,-7.919426518692228951e-04,
   4.280475971260965483e-03,-8.559347256622872394e-03,
   4.224159774645931529e-05,-5.581798473454879751e-05,
  -5.321376866585660574e-05,-2.771813168986498737e-05,
   4.784298844327346598e-05, 3.620840312436881631e-05,
  -1.493001850219909910e-05, 5.297896701026964415e-04,
   1.422505458110939552e-04,-4.269247969097670378e-04,
  -4.895020268147602140e-04,-2.208541926796442836e-05,
   2.275950665843185018e-05, 6.619671333733114047e-05,
  -1.831774962635789958e-05, 4.652375789450015087e-05,
  -1.273661866013500401e-05,-1.542006955581915769e-05,
   1.280472361438267446e-04,-2.244783543968255943e-05,
  -3.419505259278921423e-05, 4.930211332363329719e-05,
  -1.608299816110969458e-05, 4.734276259524513903e-05,
  -1.704697098474363456e-03,-1.646483465587519077e-03,
   1.306287914535299863e-03,-1.352039897465683775e-03,
  -8.550332690587772154e-06, 5.185731470127053440e-06,
   9.709142077986170804e-06,-2.394276531538996908e-06,
   1.866773831306081397e-05, 2.091686294506781040e-04,
  -2.707813612080015194e-05,-1.291412189130248865e-05,
  -4.717915300508725477e-04, 3.866687887226697004e-04,
   8.840701374376401913e-04, 1.463734945982704885e-03,
  -3.487855955303243295e-04,-4.252629872802910849e-04,
   1.713637786823012077e-05, 2.462406452146422128e-05,
  -5.492578574725574662e-05, 2.414866580261852629e-05,
  -9.198192234463303170e-06, 1.775931472827313383e-05,
   4.507183944716681363e-06,-1.948551495055976708e-05,
  -7.006128404011761738e-06, 1.873270308275075429e-05,
  -6.060053233090140646e-04,-3.699426281481188092e-04,
   3.535383849519533320e-05,-3.535683955977463879e-05,
   3.613719336565222190e-05, 3.455579916097240728e-05,
  -1.986061169918164511e-04, 2.357138717667923511e-05,
  -3.455579285384182856e-05, 3.613719939677636936e-05,
  -2.633297753477149725e-05,-6.485810893136816568e-05,
  -1.499879101896186065e-04, 9.951696738220528003e-05,
  -1.974939786634384779e-05,-3.156150173368368641e-06,
  -1.089809487679699061e-05, 1.676995909524919530e-05,
  -1.820937565233076962e-05, 8.271555981331651534e-06,
   3.996214492544890122e-05, 1.739819806019765205e-06,
   2.092594763553194172e-05,-2.149662102645378856e-05,
  -4.997920833505298894e-05,-1.441781606683248419e-06,
  -1.296354345684748075e-05,-1.522979123436782282e-05,
  -1.791910897226230072e-05,-8.882878679808071506e-06,
  -6.076457510648243477e-04, 8.685428263550770646e-04,
  -9.287060837327227157e-06, 1.771300372618328674e-05,
   1.787869290068151934e-04, 6.430578524761226984e-05,
   1.352708479560045638e-04, 1.029650314100059042e-04,
  -2.683352012013839752e-05, 7.536552393476827257e-05,
   1.450791973080820478e-05,-1.376663593927093246e-05,
  -1.815017707210597836e-05, 5.718890689855156499e-05,
  -2.578280723335923887e-04, 3.450380368179245191e-03,
  -4.798227503549076312e-05,-1.406062880594321173e-05,
   3.564516921134841504e-06,-5.989402490331521541e-05,
  -2.763708954361949847e-04, 4.493470992223912549e-05,
   4.973801453513479942e-04, 5.111742374447253353e-05,
  -4.115516753056085695e-05,-2.262879850666655907e-04,
   7.960034486580351370e-05, 2.157864339972398492e-04,
  -3.378238850993392332e-05,-6.130864724134666268e-05,
   1.755569430054503561e-05, 9.581106284026425711e-06,
   8.969520296171857253e-05, 7.400713861250956722e-06,
   5.915446715946424608e-05, 1.044066521591410242e-04,
   6.160697053950552060e-04,-2.367659563671472601e-04,
  -9.570614513268643536e-05, 5.422484471016178438e-05,
   9.158808857748628607e-06, 4.014501252612243194e-06,
   1.245890475186204769e-05, 3.801020510841831082e-05,
  -8.909920714267337055e-05,-8.038240657349706830e-05,
  -2.933212217075637044e-05, 2.719607708769451954e-05,
  -4.673945055743532065e-04, 4.939052299367825000e-04,
  -4.047142539844287727e-05,-2.936092175355319467e-05,
  -1.945570095900157941e-05,-4.634188191464073758e-06,
  -7.840005361497780862e-05, 2.895745700042885230e-04,
   2.689481789021951862e-06, 2.987920159084776075e-05,
   5.570134654016194387e-05, 1.174621640938595479e-04,
   1.791555191192677494e-05, 3.576357084647808192e-05,
   8.225694423177749002e-05, 7.303283594144655878e-05,
   4.977072208483144188e-05, 4.782804946312573072e-06,
   8.907274716375681572e-06,-1.790699464251370820e-05,
   3.369071782369922566e-06, 9.415378660746405199e-06,
   1.317536015060169892e-05,-1.504692277184729934e-05,
  -6.623850668652871056e-04,-3.299182068238567145e-04,
  -3.499826960826495938e-05, 1.765647788332293667e-04,
  -6.698568542320447786e-05, 1.342122123667719357e-04,
  -5.886264448887531278e-05,-1.162708406163287392e-05,
   2.859246630904697551e-05, 9.081347387145457406e-06,
   1.948202126621235015e-05, 4.522261312977150911e-06,
  -1.674069712810857032e-03, 1.410340265658441750e-04,
  -7.983138018706026855e-06, 3.919527404387282654e-05,
   3.197064561400805594e-05, 5.077280590063451674e-05,
  -3.242522250076888303e-05,-1.770553725414047801e-04,
   7.865913436579150705e-06, 1.838824096558025042e-05,
   1.474714999831705997e-04,-2.742547525046215562e-05,
  -9.897905441183062740e-06,-1.425295715772250690e-06,
   1.429491597680372125e-05,-2.637527966138220449e-05,
  -3.748435614078104387e-03, 1.804114865276294300e-03,
   3.627139615277552250e-04,-1.911506790802535479e-04,
   1.641989375173943266e-05,-1.141871661709793233e-05,
   5.744563324142908399e-06,-2.944486359647319369e-05,
   1.908100113035890777e-05,-5.992945508115531221e-06,
  -5.072726191068534343e-05,-2.550034213477237041e-04,
   7.573852087710472570e-05, 2.576191870471555975e-05,
  -7.250223421382981496e-06, 6.887253468548233056e-06,
   3.121645899743621445e-04, 4.283144508023729218e-04,
  -4.653436158979614898e-05, 1.829079526510821136e-05,
  -7.029095613095401570e-06, 1.872409717081074745e-05,
   2.407249200493698010e-04, 1.222763790240147491e-04,
   3.981145887863395930e-05,-3.879141909602860595e-06,
   1.798285986426715537e-04,-7.853350254060630854e-06,
   4.974387025688069275e-05,-5.054440806520574009e-06,
   6.009639612338807396e-05,-5.280552218263567338e-05,
   3.279924502768760198e-05,-3.773870063494118787e-05,
   3.154603771653775076e-05,-6.248877902781247557e-05,
  -6.014636008095237998e-06,-1.907417504612255271e-05,
   2.569745069794200504e-05,-1.548034326579485187e-05,
   1.494025346552358663e-05,-1.329619593665460944e-05,
   1.758218238056043767e-05, 9.532411171194312286e-06,
   6.350564910272490288e-06,-1.896497628051287002e-05,
   1.681200288299825735e-05, 1.083312323672441021e-05,
   1.604689888641817376e-04,-4.946207674702984445e-04,
  -1.398445789744293783e-04,-6.594977745571389385e-06,
  -1.142913706766981378e-04,-3.657160905458747054e-05,
   2.346440425968115559e-06,-4.994491182620490878e-05,
  -3.078489645762335947e-05, 3.939911356989404226e-05,
  -4.302216868685714319e-07, 9.990741178718823490e-06,
  -2.089123606741979001e-04,-9.062315518439721749e-04,
   7.643688981943279527e-06, 2.900989518676892631e-05,
  -7.645304205044252258e-05, 2.355700238216372586e-05,
  -1.868109292162652320e-03, 3.978286974761303723e-04,
  -1.311773054399661234e-05,-2.698008794231587375e-05,
   2.999775903525674745e-05,-3.666781458883938236e-07,
  -1.426164750148221523e-05,-2.639328343619766853e-05,
   5.789037506639245040e-05, 9.353450953884564893e-05,
  -4.130890078503878898e-05,-5.651172193387687769e-05,
  -9.991479762097292780e-06, 4.127131735239737508e-07,
  -1.611407336685966111e-05, 1.184637664129687240e-05,
  -2.042062425301149718e-06, 9.789278883103351756e-06,
  -5.629902348519496706e-05, 8.264635475696110642e-05,
  -7.443273463690817222e-05,-5.059415000246185798e-05,
  -2.540869440988579897e-05, 1.594986671997726134e-05,
  -9.995957405566224135e-05, 2.843159265777793176e-06,
   3.417529907810380675e-04,-1.661472036846113392e-04,
   7.023201484602542638e-06, 3.937860638604008274e-05,
   1.173216110379135557e-04,-1.494511277423777814e-04,
   9.912929621734194792e-06, 1.737048722156476777e-05,
   3.101636895711284341e-05,-1.569649160058267693e-04,
   1.871710470906878834e-05,-7.047694042008000727e-06,
  -3.578510035356377382e-05,-1.040164726987286855e-04,
  -7.838501761419851713e-06,-6.209499990838061783e-06,
  -5.030125191297603934e-05,-3.270755350048861046e-05,
  -9.708249875045829821e-06,-2.397891649694088059e-06,
  -3.910659607467246459e-05,-8.406791507609331283e-06,
  -6.351145361254132507e-06, 1.896478190225820093e-05,
   3.649577864736062473e-04, 6.087539808728663457e-05,
   2.206641006457644684e-05, 3.336275688341656796e-05,
  -1.117129333573468350e-05,-1.094312670364689223e-04,
   1.353874211617184727e-05,-7.884606814491002696e-05,
   2.984601098355150307e-05,-3.035725344909026903e-06,
  -3.161100454899098473e-05,-2.451008754377820346e-05,
  -3.990019173861448164e-05, 2.823950994936124598e-06,
   5.392251116663943945e-04,-2.136264940225450308e-04,
  -2.792023360057837173e-05, 2.864368264886927649e-05,
  -1.012907378603056116e-04,-2.610367530132775182e-04,
   4.469094832184382311e-05, 2.242139911098959930e-05,
   6.062105665219239209e-05,-3.500124984013685251e-05,
  -6.722478565037618927e-06, 2.923710454102132516e-05,
   3.000118918702394632e-05, 5.196083763147393147e-05,
   4.339913359134539258e-05,-6.720502364794284783e-05,
  -2.901484130260775939e-05,-2.753432374663461775e-05,
   4.977072255345446638e-05, 4.782800069735217304e-06,
  -6.000573033354926472e-05,-2.220344845449403809e-04,
   1.834197915806030270e-04,-4.956995114510555372e-05,
   6.429280560222719397e-05, 2.768456515450843877e-05,
  -2.751064762808839726e-05, 6.436741619082712450e-05,
  -4.044246053808553348e-06, 2.972615134618428938e-05,
  -5.940544285727465337e-05,-2.325317039866415375e-04,
  -1.804328839868599182e-05,-8.627846994577705915e-06,
  -2.840031362123721155e-05,-9.665515310389209829e-06,
  -8.027440949151563117e-05,-8.919652000380096915e-05,
   1.144544525368901585e-05,-1.640127382079842035e-05,
  -1.018250811115694958e-04,-4.161313322284557285e-05,
  -9.964611557381259266e-05, 8.405453649291315943e-06,
   1.605822672249394641e-05,-1.192196940647732904e-05,
  -5.692810044188947340e-05, 4.073317296845585376e-05,
  -1.208867431562578633e-05, 3.812956796622182440e-05,
   1.223344091505195608e-06, 2.997504677617333471e-05,
   5.095259229865785626e-05, 4.799826390659094711e-05,
  -1.986358180227955361e-05,-2.331977269217825422e-06,
  -4.537264703925159163e-06, 2.699618736581270028e-04,
  -1.472154781901627354e-05, 1.353794776959998686e-05,
   8.720195349806147945e-05,-2.226700038446860247e-05,
   5.998993557504812217e-05, 1.098922063467624724e-06,
   1.231398958246665742e-05, 4.845993871810923764e-05,
  -2.554700381687238360e-06,-9.668169731640373452e-06,
   1.915443807540009001e-04, 3.281931598945449311e-04,
  -2.786392159314488755e-05,-1.111763794387432199e-05,
   1.214638417012568283e-04,-6.961706083405144079e-05,
  -2.196751629553084538e-05, 5.583393437512340157e-05,
   1.933106554019576310e-05, 2.294144513932493942e-05,
   2.049418352059245778e-05, 2.190863852055340447e-05,
   4.925967948877810020e-05, 8.572279548804640639e-06,
   3.858175503033347029e-05,-1.241428539174902845e-04,
   1.063799062349270892e-05,-1.693614937034039171e-05,
   1.054997324267959986e-04, 3.114171571822032511e-05,
   2.472608263327933230e-05,-5.466827999500480106e-05,
   4.157724232686712310e-06,-5.985577106014866111e-05,
   5.466819799990913777e-05, 2.472626392002501828e-05,
   1.509894212128847251e-05, 3.704081460791569985e-05,
  -9.105319059097704984e-04, 1.316497182690528093e-04,
  -3.704156297697229803e-05, 1.509710608769095739e-05,
   3.097842065041042631e-05, 9.508068917506974584e-05,
  -5.922161718715766458e-05, 3.732023657129937653e-05,
   7.407974283046258209e-06,-1.857745722701912978e-05,
  -3.757623601687293659e-05, 5.905951647960098794e-05,
  -8.019567354726090408e-06, 6.953910079547340770e-05,
   2.135365883828889771e-05, 5.607157260339651404e-05,
   3.155851649371932654e-05, 2.457763285419581106e-05,
   1.998341980202497859e-05, 8.142069859906805284e-07,
   1.916802155319450825e-05,-5.708498028051756787e-06,
  -9.996445058617032468e-06, 2.666199355846020400e-07,
  -1.201721131505957392e-05, 1.598707703769529571e-05,
   1.521054886506435884e-07,-1.999942158964409801e-05,
  -1.883531076598773414e-04, 2.496210798123147577e-05,
  -1.918051124620915099e-05, 5.666391120814411642e-06,
   3.097401790063632795e-05, 7.376049223731537339e-05,
   3.841860176654980054e-06, 2.975298489871281004e-05,
  -1.944051189945213013e-04, 1.571834905730433722e-04,
   3.589786739319851191e-05,-3.480435485137363454e-05,
   5.584276141766174805e-05, 7.058035135397180114e-05,
  -2.559318114927444814e-05,-3.074067466176406412e-05,
   4.969743578736318814e-05,-6.269102707852945505e-05,
  -1.768419688306215596e-05,-9.341797503751340262e-06,
   1.861935833026926438e-05, 7.302019951289689274e-06,
   9.342235775977268461e-06,-3.566879687633212824e-06,
  -9.590667320873550548e-06, 5.922853282279013726e-05,
  -4.935711068565848950e-05,-7.992222767394360335e-06,
   6.319935179468477902e-06,-2.099048794557366304e-04,
   2.998260929021093779e-05,-1.021342327800440189e-06,
   1.542794705509829080e-05, 3.690499220518931808e-05,
   2.956047784447937980e-05, 2.694769284384182615e-05,
   3.825114523672428239e-05, 1.169828568975067908e-05,
   4.937096142222247030e-05,-7.906210738743343823e-06,
   3.199305672200441629e-05,-2.400925491519069154e-05,
   1.100748525448802665e-05,-2.790762025634268840e-05,
   2.351091035825545006e-06, 9.719689858285642100e-06,
   1.995974169055686478e-05,-1.268349969939798188e-06,
  -3.596946748410713727e-05,-1.249247669956192236e-04,
  -6.869823421300310284e-05, 4.099454373468950334e-05,
  -2.878250015171574490e-05, 8.459768614831206723e-06,
  -1.256892654320879393e-04,-1.144648791339166458e-04,
   1.329319539743791283e-05, 2.689406916265249010e-05,
  -3.407390268680382219e-05, 3.659192746618061343e-05,
   4.930472127013414312e-06,-4.975631060081469015e-05,
   7.010703212569629514e-06, 7.130921431713148498e-06,
  -1.996894860071979044e-05,-1.114042989211430890e-06,
   2.621696278861045156e-05, 1.458323908261175312e-05,
  -2.940763299224846580e-05,-5.932210531768038562e-06,
   1.947632513517254019e-05,-4.546730608805236198e-06,
   9.081476412937996434e-06,-1.781928130316289910e-05,
   7.978984019604273004e-07,-2.998938742522342694e-05,
  -1.258083470109284613e-05,-2.723458459796620712e-05,
  -2.393437485491940129e-05,-1.808716949398666760e-05,
  -1.991534662008624220e-05,-1.838197215159349547e-06,
  -1.339654318644493101e-02, 5.978422087283226383e-03,
   3.551358772339410536e-05,-1.840611547863349793e-05,
  -1.705359020516210476e-05,-1.044868705218025163e-05,
  -7.154854956266615868e-06, 6.986275871649148010e-06,
   5.872707686659577614e-06, 2.941957349158973823e-05,
   7.692283916943937455e-06,-6.389739285849278526e-06,
   8.184244396539766867e-05,-3.744081149989600182e-05,
   3.749914477207594077e-05, 1.392171474218925972e-05,
  -3.197414134061923765e-05,-3.844026906162473732e-05,
  -8.542005322085366681e-06,-1.808408540892973365e-05,
  -1.911708785742616493e-05, 5.876814770898358278e-06,
   6.636298954218283980e-05,-9.997976604805659871e-05,
  -2.666341747247963603e-05, 1.374998795229536630e-05,
  -2.474074827983836742e-05,-1.696747991169209732e-05,
   2.889292772961571170e-05,-8.074572881038569582e-06,
  -1.061107632479897249e-04,-2.899148017830539947e-05,
   1.054941178365320833e-05,-2.808397961505667436e-05,
  -1.958849665068631191e-05,-4.036186190706670783e-06,
  -1.940822259497315230e-05, 4.829171326840002391e-06,
  -1.520731976848864038e-05, 1.298989705343867257e-05,
  -7.186731566057054970e-06, 1.866416055967798268e-05,
  -5.708402279991332888e-05, 1.847740081772799624e-05,
   3.276502500273945762e-05, 5.026383527517432016e-05,
   1.812744273479094463e-05,-8.449604718380323643e-06,
   3.329781674404285022e-05,-3.729953619122012328e-05,
   1.661177699099058099e-05,-1.113772262186466807e-05,
   6.355335584583162139e-05, 2.934230667028579241e-05,
  -1.056755643492311555e-05,-1.698018701294880096e-05,
   1.317431777405155181e-05,-2.695250176121521732e-05,
   7.626152948357939110e-06,-6.468523108735991541e-06,
  -6.494325823428523511e-04, 2.715365521424714909e-05,
  -2.516498006962498586e-05,-5.294022325019940006e-04,
  -1.464616608658574732e-04,-2.957177402463615238e-04,
  -8.185954298797336760e-06, 5.743705443178768109e-06,
  -3.738046263919028120e-05, 3.320694223923816458e-05,
   2.207665493964807763e-05, 3.335597857469800771e-05,
   3.344521115568448595e-05, 2.194123630864218489e-05,
  -1.375546221997868316e-05, 4.807064862381970602e-05,
  -6.209758453993924752e-06,-3.951504650058065208e-05,
   1.907349976452657835e-05, 6.016777105112392797e-06,
  -4.444757423747230040e-06,-1.949984952362566112e-05,
   9.999949343810422191e-06, 3.182956527403950214e-08,
  -1.247770237074952106e-04, 6.348774964273955017e-05,
   3.447548438206846175e-04,-2.398835085248157966e-04,
   6.170233455908773750e-06,-7.869448462223008767e-06,
  -1.269016993075380007e-05,-1.545831773281271989e-05,
   5.722770431537678376e-06, 8.200603550222269338e-06,
  -1.534789510398409788e-05,-1.282349858178730522e-05,
  -2.972210554283934823e-05, 2.676931904438958150e-05,
  -2.095585276837673501e-05, 4.539661038833314993e-05,
  -1.984562079002662353e-05,-2.480188593325728221e-06,
   1.990378226659365380e-05, 1.959451832536864108e-06,
  -7.122439221319544513e-06, 7.019320447066728433e-06,
   3.909880589129779077e-05,-4.551135438409427295e-05,
  -2.304412959713241565e-06,-9.730862290213836518e-06,
  -4.817045623987298860e-06, 8.763336776389735124e-06,
  -9.786277463890638093e-06,-2.056398161773697593e-06,
   1.101896431355989673e-05,-1.669078864093885705e-05,
   7.865571697785504962e-04,-1.047581891152169755e-03,
  -1.081456127276838497e-05, 1.682394913441960966e-05,
  -2.527377835892478529e-05, 2.587686923247553995e-04,
  -6.995215891419649455e-06,-4.950825137926434955e-05,
  -2.406844760812160231e-05, 3.194854972819745857e-05,
   7.685936858899991260e-04, 4.076318756059508510e-04,
  -3.194852452376052557e-05,-2.406848106455146923e-05,
  -3.226534984765813712e-05, 2.364206419093364724e-05,
  -8.360372018856346459e-06, 1.816876935035292856e-05,
   3.880400420772579795e-02,-1.671782715187208846e-03,
  -7.420442654899269709e-05, 5.092841132938617169e-05,
  -5.766781570708952277e-05, 1.656571856495091016e-05,
  -3.968015288395426845e-05,-5.048313293171866644e-06,
  -1.603659442821930532e-06, 9.870576294799005091e-06,
  -7.995980832200118250e-05,-2.535557751034464575e-06,
   6.289921952495238357e-05, 1.898517531737641017e-04,
   2.885720668688337271e-06,-7.994793691035626221e-05,
   6.040005647912104166e-06, 7.969838880001897270e-06,
  -2.406062806309167980e-06,-2.990335870386628736e-05,
   1.658322999578305947e-05,-2.499992965804025941e-05,
  -5.396014952536363997e-05,-1.925832346368717496e-04,
  -4.206767035201751625e-05,-2.702426892913084035e-05,
   2.537047154843084600e-05,-4.308525470982225612e-05,
  -9.666923651856838915e-04,-2.559411477111649493e-04,
   7.379828622369135509e-05, 1.187709481712782410e-03,
   2.592603456166201023e-04,-7.779357770348081314e-04,
   3.682652033992852604e-04,-6.418572582477221613e-04,
   1.099527594765432100e-03, 8.985761338636496544e-04,
   5.311683180546905971e-04, 2.999336891630397894e-04,
  -2.418792994047763752e-05, 5.490850612787189617e-05,
  -7.946097857034104290e-06, 2.892852448443297399e-05,
   9.976171407024103617e-06,-2.829268463857176645e-05,
   2.661596560862051369e-04,-8.694272523951040933e-05,
   1.759789537446581820e-05, 9.503371948385193132e-06,
  -4.805313151761574446e-06, 8.769775682051808734e-06,
  -7.329864077259790865e-06,-4.945981290511415553e-05,
   1.978708116906162379e-05,-2.910570186229312342e-06,
   4.999916582495574996e-05, 2.888196817694681508e-07,
   2.067312270475266299e-05,-3.424356870471067442e-05,
   3.200344247988344743e-05, 2.399540934088835063e-05,
  -4.041062602191212581e-05, 1.129910673660407543e-04,
   3.887130686884954772e-06, 4.984867315208176594e-05,
  -1.035794308435834311e-04,-3.703108837341022514e-05,
   9.686658608058756187e-05, 2.483675705667147269e-05,
   4.860608149433295801e-05, 3.517739105968865850e-05,
  -2.481937686893450801e-05, 9.687104072857790097e-05,
   8.942992170706310858e-07,-1.997999571847669157e-05,
  -1.312703425407590885e-02,-8.918417507451327150e-03,
   1.036744832906924887e-02,-1.524959133669986054e-02,
  -8.996881945764399063e-03,-6.112842096098650146e-03,
   7.356100191080724125e-03,-1.154679451297861703e-02,
  -2.478306933738003487e-05,-1.690560481670542436e-05,
   2.254080642227390593e-05,-3.304409244984004424e-05,
  -4.626601542249390159e-02, 3.249648738795702079e-03,
   1.995086464898233327e-05,-1.401070932532362991e-06,
  -1.481697825251777911e-04, 2.336055535387617738e-05,
  -3.129821900401303942e-03, 3.559703242805103171e-04,
  -9.742408042470584661e-06, 2.255102111658022996e-06,
   4.898214298836009234e-04,-1.322750266620934178e-05,
   9.973601233310930785e-06,-7.261394073445406391e-07,
  -3.286352945257723285e-05, 3.768273387003109913e-05,
  -3.949979167848828452e-05,-6.306065124626285760e-06,
  -1.769502890915590325e-04, 3.299386595132026062e-05,
  -4.782106084831865942e-06,-1.941987284699398062e-05,
   2.217704747897328584e-05,-2.020342953845620493e-05,
   3.367238256409373813e-05, 3.696174579828874761e-05,
   1.183738478480723347e-04, 5.373669273077212019e-05,
  -6.613746797633492341e-05, 1.456908896591659942e-04,
   2.283266045368763809e-03, 1.157711607467976815e-03,
  -1.401916399668252933e-03, 2.764892476813737496e-03,
   2.998891540089385448e-05,-8.154465513027191416e-07,
  -2.767499345683012460e-06, 2.987207638199333547e-05,
   3.528135819901465769e-02, 1.984580972479634692e-02,
  -2.436602626784531433e-02, 4.331728019987719086e-02,
   1.045890065188181570e-04, 5.883145175334885362e-05,
  -6.863669371224030550e-05, 1.220205076052878408e-04,
   2.890437199364634556e-05,-8.033509796652569214e-06,
   1.826042768778531392e-04, 4.892433278632258854e-05,
  -8.983512357011352910e-05, 2.531254943355048083e-04,
   3.516018126433668733e-01, 2.182462697181757338e-01,
  -2.710477015239504683e-01, 4.366666302782747366e-01,
   1.019554346403209709e-03, 6.328577523664569117e-04,
  -7.857983758550173437e-04, 1.265946646783985526e-03,
  -5.956810824189706329e-05,-3.676466347570223720e-05,
  -3.151256869345906336e-05, 5.105837849305463149e-05,
   2.240494203541074341e-04,-5.197939244535737118e-05,
   3.389960376871158977e-05, 1.461191871874612793e-04,
  -1.696557450944125207e-05,-1.059100002665458092e-05,
   7.496145844991324975e-06,-1.854205483409590547e-05,
   2.607674779163279372e-05, 5.515356177572850751e-05,
  -8.909313735403146450e-05, 4.541370441089651570e-05,
  -4.908772317615261310e-02,-3.668288202120179725e-02,
   4.641629686560032331e-02,-6.211263144710954531e-02,
  -1.441871764312576722e-04,-1.077499798272898757e-04,
   1.376805297793148690e-04,-1.842391698843847672e-04,
  -4.012831633477236123e-05,-2.982814489934702034e-05,
  -2.386251591947762034e-05, 3.210265306781788763e-05,
  -6.929825179604027585e-05, 9.886976181452075300e-06,
  -5.649700675115395004e-06,-3.959900102630874261e-05,
   9.005892005083677689e-06, 1.785760088009500802e-05,
  -7.280186249537261203e-04,-5.946334011140694872e-04,
   4.681156561961824741e-04,-5.731210451763375010e-04,
  -8.366876874916596440e-06,-5.476803023661333124e-06,
  -4.449856077599319188e-06, 8.955377205269045673e-06,
   1.391508581627035278e-05, 5.829967007078697518e-05,
  -2.946761883322427544e-05, 5.626672222531371811e-06,
   1.190163753521383686e-05, 4.845774285400496705e-05,
   3.864140802717199797e-05,-1.000727113751424609e-05,
  -9.830189446444107893e-05,-8.506901636143375479e-05,
   2.171786439520809287e-05, 7.699567758070159315e-05,
   7.699567758070157959e-05,-2.171786439520815724e-05,
   2.756737340977244368e-04, 1.167905814836374921e-03,
   1.216568557121224274e-03,-2.871601396851284900e-04,
   6.526557502903703378e-05, 4.452419619893537646e-04,
   4.254534303453824922e-04,-6.236488280552425414e-05,
  -5.112189538135520935e-06,-4.973796857659325342e-05,
  -4.973796857659325342e-05, 5.112189538135517547e-06,
   4.736693602254246789e-05, 5.154001718894132849e-05,
  -3.926266070572372469e-05,-7.644833177200034899e-06,
   5.733624882899978317e-06,-2.944699552929280030e-05,
   9.968901723688463264e-06,-7.880345318837277062e-07,
   6.834612419072168068e-06,-1.879595895614439021e-05,
   2.576895784562181118e-04,-2.655109812325219358e-04,
  -3.013905882958195699e-04,-2.925127574768317815e-04,
   6.648753053554603755e-06,-7.469543683040373377e-06,
  -1.378692795372939649e-04, 2.433231924555267903e-05,
  -4.980459079001033025e-05, 4.416190240424243570e-06,
  -4.973197017033407916e-05, 5.170216917789984772e-06,
  -3.878735869625069035e-06,-9.217125802205580423e-06,
   8.214554899755286644e-06,-5.702726347888914083e-06,
   1.838938640155149825e-06,-1.991527817224113985e-05,
   7.411895440608185946e-05,-5.449829177118758463e-04,
   4.214133343507176703e-04, 1.265337964000537495e-04,
  -1.997685422297008594e-05,-9.619227381668266920e-07,
  -9.232656496168959652e-06, 3.841621275418637542e-06,
   9.914494532753410154e-06, 1.304913085229336629e-06,
   9.670361906932311666e-06,-2.546389716628715977e-06,
  -3.050797866666558523e-05, 3.961392731949557356e-05,
  -4.753684696417374931e-05,-3.660940016860048059e-05,
   1.917111572084149884e-05,-5.698098105342163966e-06,
  -1.258538395222625610e-06, 5.998679922372713452e-05,
  -4.330885139194902271e-04,-7.768100868943151596e-05,
  -2.982807948853136753e-06,-9.544781649689979805e-06,
   3.997389280475599976e-05,-1.444954682291730715e-06,
   1.806193352864577526e-06, 4.996736600594499800e-05,
   2.400640450956997649e-06,-1.985540040959207157e-05,
  -3.914759515250837435e-05, 8.213756374236049832e-06,
   6.160317280677046268e-06, 2.936069636438127568e-05,
   1.100820459106855900e-05,-3.845542135617782383e-05,
  -2.884139165325785018e-05,-8.256762531609371605e-06,
  -8.287698922939780915e-06,-5.595895510345311707e-06,
  -8.165336944652803592e-07, 1.998332486664326218e-05,
   9.029936791164900253e-06, 4.296538321435824559e-06,
  -3.850303473570298904e-05, 1.084049427568915564e-05,
   1.084049427568915394e-05, 3.850303473570298904e-05,
  -1.709927911116426515e-05, 1.037374830418116106e-05,
   1.270381030322981870e-05, 2.717743924249582416e-05,
  -1.097458837789118158e-05,-3.846502840159949792e-05,
  -2.884877130119962174e-05, 8.230941283418391268e-06,
   1.188605931462581167e-06, 9.929109524005261527e-06,
  -9.170788702369160069e-06,-3.987058386391926318e-06,
   4.496256678381245528e-06,-8.932170838162023949e-06,
   6.797475942585647969e-05,-1.671622209103885162e-05,
  -6.727018441328347674e-06,-3.943028306885494345e-05,
  -4.596674763414421463e-06,-1.946459814944529021e-05,
  -2.996488262201656022e-05,-1.451140740510699398e-06,
  -3.907156935572512915e-05, 8.568107613747690966e-06,
   8.892119826223352937e-06, 3.899910518199213469e-05,
  -9.462754045963896716e-06,-1.761976974496528276e-05,
   1.431313129651581452e-05, 2.636539915284233902e-05,
   1.266508785944541501e-05,-3.794200244468560481e-05,
  -2.845650183351420361e-05,-9.498815894584062953e-06,
   1.992053486914764914e-05, 1.781092509408946043e-06,
  -9.249357820831245736e-06, 2.853855952745736990e-05,
   2.853855952745736990e-05, 9.249357820831247430e-06,
  -9.095099800012262155e-06, 1.781233167296794459e-05,
   1.781726108808853607e-05, 9.085439302471082378e-06,
  -3.129792925634572925e-05,-2.490862549930803212e-05,
  -2.428899523437281409e-05, 1.760808650889172304e-05,
  -1.455603544476553005e-05, 1.371575124193821147e-05,
   2.948578335821073313e-05,-5.530694328261425719e-06,
  -5.479856722968074977e-06,-2.949527369419957873e-05,
   1.970286143185515792e-05, 3.434712709545664299e-06,
  -3.141515263458179078e-06,-2.983506128449310338e-05,
   1.919003403868347606e-06, 9.814144177458455985e-06,
   8.073677182052495620e-06,-5.900486146073464881e-06,
  -1.646037753969422813e-05,-1.136028042130694305e-05,
   5.465488799648913785e-06,-8.374272038864768989e-06,
  -8.195599764130155431e-06,-5.729934075204510199e-06,
   2.598662192331216081e-05,-1.498984593032336033e-05,
  -1.498984593032335863e-05,-2.598662192331216081e-05,
   1.465481370094737671e-05, 3.721876456023930579e-05,
   2.791407342017945901e-05,-1.099111027571057912e-05,
  -2.222842816728897870e-05,-3.325502941228099349e-05,
  -3.325502941228100027e-05, 2.222842816728897870e-05,
  -1.622792244845392770e-05,-1.168993297700911340e-05,
   2.359760848897243904e-06, 2.990704814481047867e-05,
   2.990704814481047867e-05,-2.359760848897241786e-06,
   1.378215019097531936e-05, 1.449318240116362602e-05,
  -1.999698284718088925e-05,-3.473859662585154815e-07,
  -9.734842127895661516e-06,-2.287542075011493778e-06,
  -2.380825601596101116e-05, 3.214291438993136500e-05,
   2.793949893961333695e-05, 1.092631680866636747e-05,
  -1.003315460520719390e-06,-9.949540596765265124e-06,
   9.141460230238977218e-06,-1.778858355403709971e-05,
  -8.684281011768330729e-06,-4.958151198646532224e-06,
  -8.342257405548279464e-06, 1.817709386507026316e-05,
  -8.778670319537730315e-06,-4.789044520660394259e-06,
  -1.096769045529924708e-04,-8.424761579640089953e-06,
  -9.955292166829419703e-06, 1.296182554961802476e-04,
   1.994173866306815499e-05,-1.525470122255045306e-06,
  -1.525470122255079399e-06,-1.994173866306815160e-05,
  -1.548509530528369293e-05, 2.569458743366549776e-05,
  -9.115733098357415104e-06,-4.111375691847089857e-06,
  -9.970825763442221361e-06,-7.633043921508953292e-07,
  -1.235266803055596170e-05, 1.572932269765232969e-05,
   5.018304004960254574e-06, 8.649660392974967807e-06,
   2.363462813395179538e-03,-9.891559206196874968e-03,
   3.277418019936657916e-05,-2.293148735384270114e-05,
  -8.099605003042123760e-06, 5.864844311206821372e-06,
  -7.122552993012500608e-05,-8.382674922823184411e-05,
  -9.141567597656282936e-05, 7.773785555151411944e-05,
  -2.779735581563519376e-05,-2.876294507971971720e-05,
  -2.889617099101588431e-05, 2.765883768450822750e-05,
  -1.647366707990747641e-05,-1.134100052642502581e-05,
  -8.045556487643672105e-06,-5.938772668164259339e-06,
  -1.246355438321852581e-06, 9.922025908118037006e-06,
   1.999988920911356750e-05,-6.657043775429415887e-08,
  -1.679207127371994497e-06, 9.858005042775292402e-06,
   1.011059739502989666e-06,-9.948756615937298919e-06,
  -9.643036204477996233e-06, 2.647990324590821939e-06,
  -4.766845348844050126e-06,-8.790744304107807127e-06,
   9.297354709363106134e-06,-1.770760275724197807e-05,
  -1.623482142347783529e-05,-1.168034988122295919e-05,
   1.804384608228984453e-05,-8.626680622269119453e-06,
  -8.113295137995646928e-06,-1.828043878039518745e-05,
  -2.998179575187923647e-06,-1.977399603608046594e-05,
  -1.978487405190807277e-05, 2.925535634740184474e-06,
  -5.940356297987680317e-06, 8.044387301277713305e-06,
  -6.688679671570876980e-06, 7.433812228669387878e-06,
  -9.554573812010609348e-06, 2.951291119296955870e-06,
   2.378481835069679087e-06,-9.713023430438309566e-06,
   8.531687457712485695e-06,-5.216350172669726746e-06,
   6.139609725286483555e-06,-7.893363821664857804e-06,
  -1.402456466080367468e-05,-1.425873718373884508e-05,
   3.808535218573997700e-07, 9.992744897919131306e-06,
  -1.665678220583770040e-05, 1.107030291127070473e-05,
  -9.846564091499146522e-06,-1.745043149036610619e-06,
  -1.936550755212832528e-05, 4.997711200985995050e-06,
   5.028489172825858300e-06, 1.935753849637843700e-05,
  -1.997833566632628154e-05,-9.306470886406138340e-07,
  -7.567932211063173257e-07, 1.998567647142541787e-05,
   3.504299789547764383e-06, 1.969060392636486965e-05,
   9.987094849966144319e-06,-5.078744508042783272e-07,
   7.583526043665249544e-06, 1.850648893618265362e-05,
   1.848470785721572515e-05,-7.636463542333406311e-06,
   2.867666163187851427e-05,-8.811871404573872759e-06,
  -6.058027845797979954e-06,-1.906043804899395296e-05,
  -9.998889577996047096e-06,-1.490208275444836601e-07,
  -3.459796235332555616e-07, 1.999700722858547902e-05,
  -1.766899792432031761e-05,-9.370512918211274542e-06,
  -1.062948115769205788e-05,-1.694149138412169196e-05,
   9.700830725669615023e-06, 2.427732116998153890e-06,
   9.957784014277928884e-06, 9.178984284717692364e-07,
  -1.811459574838139225e-05,-8.477111587841865527e-06,
   4.408984726522860225e-06, 1.950796897888881385e-05,
   1.950796897888880369e-05,-4.408984726522893260e-06,
   5.663694202813582363e-06, 2.946052558894725166e-05,
   2.946052558894726183e-05,-5.663694202813528153e-06,
  -1.225660987668629016e-05,-5.873478964234669225e-05,
  -5.876551399825447855e-05, 1.210844187007384563e-05,
   7.452938110141049414e-06,-6.667361811571888230e-06,
  -1.921902150489100095e-05,-5.534366485383612943e-06,
   1.155187219665393552e-05,-1.632648917410518645e-05,
  -1.632648917410518645e-05,-1.155187219665393721e-05,
   9.998756398907003202e-06, 1.577037580917739447e-07,
  -4.878338793788134637e-05, 3.493109018198791642e-05,
   3.488680140348136160e-05, 4.881507029426518612e-05,
   7.552284523816778164e-06, 1.851926020313224093e-05,
   4.440728574249692604e-07,-9.990135099051385912e-06,
  -1.973497528775817133e-05, 3.245111768733765564e-06,
   7.981376206359904954e-06, 6.024751766882348345e-06,
  -2.701053997841778117e-05,-1.305491210519224123e-05,
  -8.698280462711203452e-06, 1.800943966346584132e-05,
  -2.143434878175806966e-06, 1.988481045730684096e-05,
   1.403012671461980944e-05,-1.425326434090491600e-05,
  -2.376441962103296375e-05,-1.830989787179228352e-05,
  -2.953513570125139445e-05, 5.260775523500819170e-06,
   5.260775523500876768e-06, 2.953513570125138428e-05,
  -1.827552858782567494e-03, 5.886004997922317933e-04,
   5.595111465560868771e-04, 1.742368295418478090e-03,
   2.745610921079737370e-05,-4.178710407535760350e-05,
  -3.338474129089173887e-05,-2.203313524989642373e-05,
  -1.969859540942131793e-05, 3.459095097843573612e-06,
  -3.576709972849798677e-05,-1.456733145672592844e-04,
   5.371232126204580682e-06, 8.435037963543959782e-06,
  -1.998363721876220397e-05, 8.088532060281787509e-07,
   5.177727440382231248e-06, 8.555181970777295329e-06,
   9.295545304410897586e-06,-3.686846551410096075e-06,
  -1.580657290246116259e-05,-2.549808332167695618e-05,
  -2.537271503367566461e-05, 1.600704007054049437e-05,
  -1.981286313742248656e-05,-2.729552032434128254e-06,
   4.772658619147655613e-06, 1.942219683004668833e-05,
  -7.738773547378737435e-06, 6.333354875766170205e-06,
   1.719331211389787058e-05, 2.458434498932385190e-05,
  -5.718621371020405336e-06,-8.203497401408055257e-06,
  -8.006109947097352959e-06, 5.991844750574636340e-06,
  -2.945155987477033086e-05,-5.710133180830222996e-06,
  -5.710133180830277206e-06, 2.945155987477032070e-05,
   4.422617542010252609e-06, 8.968860244038994858e-06,
  -1.143276991485059638e-05, 1.641011188487412798e-05,
   1.641011188487406699e-05, 1.143276991485068447e-05,
   8.807443310048906340e-06, 4.735920432215346531e-06,
  -5.500804489147990295e-05, 2.396069692677848517e-05,
   1.996724743898247811e-05, 4.584003740956641299e-05,
   9.993480220261370591e-06, 3.610444394319885149e-07,
   1.726173373045317280e-06,-1.992536889209806786e-05,
   5.199004280337392673e-06,-8.542268697075356066e-06,
  -1.889654319755568849e-05, 6.551385745238323658e-06,
   1.934296504800199093e-06, 1.990624266484053860e-05,
   1.990624266484054198e-05,-1.934296504800167329e-06,
  -8.208681324917494528e-06, 5.711177716193988020e-06,
   3.874099370994834730e-07,-9.992492859173659621e-06,
  -9.661145960037753516e-06, 2.581135164776579947e-06,
   1.987159234551488942e-05, 2.247487080393731885e-05,
   5.177854864063046960e-06, 1.931812151858194391e-05,
   1.075988530474452009e-06,-2.998069793520970479e-05,
  -2.998069793520970479e-05,-1.075988530474507066e-06,
   8.540736052206592333e-06, 5.201521670294046775e-06,
  -2.874662682978303114e-05, 8.580876756439197850e-06,
   5.720584504292700311e-06, 1.916441788652204899e-05,
  -2.511518774124126718e-05, 3.113241630073394274e-05,
   2.334931222555035541e-05, 1.883639080593107405e-05,
   2.375168357736260971e-06,-9.713834220965913285e-06,
   6.219381079241800576e-05, 7.830664019811417193e-05,
   7.830664019811428035e-05,-6.219381079241787023e-05,
   2.904039320975835967e-05, 7.526988921382884343e-06,
   5.017992614255292087e-06,-1.936026213983889628e-05,
   4.163000655307711123e-06, 9.092272848078613911e-06,
  -1.999489235784784091e-05, 4.519730059174626102e-07,
  -8.610543088712702416e-06,-5.085130059046859249e-06,
  -2.764201808543040122e-05,-2.891226100056408426e-05,
  -2.633357552661614713e-06, 1.982587773592483675e-05,
   9.520464673401018236e-06, 1.758865408160963632e-05,
   4.621843590722876015e-06, 1.945863720364028818e-05,
   1.941342823329793172e-05,-4.808201766834539028e-06,
   2.699809426371174988e-06, 1.981693793352740614e-05,
  -2.488575525813912001e-05, 3.131611702034595135e-05,
   9.606230034119046170e-06, 2.778550797014372126e-06,
  -9.058670883085805839e-07,-9.958885721722052215e-06,
   1.989018630180758315e-05,-2.092961748189893203e-06,
  -2.092961748189856781e-06,-1.989018630180758654e-05,
  -9.521459081327141412e-06, 3.056438607695717758e-06,
  -5.228718240828222575e-06,-8.524113183084222511e-06,
  -2.486253367579098800e-05,-3.133455631120631122e-05,
  -2.754957964771293240e-05, 1.187521205007815712e-05,
   1.786554726439507545e-05, 8.990117960497828839e-06,
  -1.674486438143764312e-05,-1.093661359138472268e-05,
  -4.104899992991804521e-05,-4.376047994199319240e-05,
  -4.364190635494426013e-05, 4.117504110145217539e-05,
   1.407771986177261418e-05, 1.420625930684967169e-05,
   9.440928173585134725e-06, 3.296797722215676958e-06,
  -2.744639481057252878e-07, 9.996232767457459694e-06,
  -1.899341692591396296e-06, 2.993981464763574940e-05,
   8.982240233311912994e-06, 4.395379436530224659e-06,
  -3.997751270827457889e-05, 1.341073323776438112e-06,
   1.341073323776506510e-06, 3.997751270827457889e-05,
   2.999877524005820366e-05,-2.710795021224083405e-07,
  -3.093004219229452994e-07,-2.999840551177676223e-05,
  -1.745116186835762625e-06, 1.992371876669724197e-05,
  -9.438409127735516711e-06,-3.304002593443123620e-06,
   8.474344194743484360e-06, 5.309000891789095327e-06,
   1.919499581826766569e-05,-2.305541445163558002e-05,
  -9.582712819183224006e-06, 2.858603684504294046e-06,
  -4.243946794083393205e-06,-9.054773084345587206e-06,
  -9.710420352267461189e-06,-2.389086976706767576e-06,
  -6.786006416270795054e-06, 7.345074330347625753e-06,
  -3.267937482936020849e-06, 9.450956809107837609e-06,
  -2.976933180949365782e-05,-3.713069298608524017e-06,
   8.069644878712540370e-06, 5.905999621695592853e-06,
   9.182871075807304555e-06,-1.776724173317574112e-05,
  -1.776724173317575806e-05,-9.182871075807268980e-06,
  -1.281018335731032011e-05,-2.712746214359333842e-05,
  -2.712746214359331470e-05, 1.281018335731037263e-05,
   2.728970811249711474e-05, 2.924503087935981815e-05,
   2.667007902579974932e-05,-1.373706245008721993e-05,
  -8.324783902865505626e-06,-2.882183153393606527e-05,
  -2.882183153393608221e-05, 8.324783902865453110e-06,
   2.472248257599779639e-05,-3.144517220941055131e-05,
  -2.597052419404054078e-05,-3.042255533459928076e-05,
  -4.730824815146773448e-06, 8.810181415180478977e-06,
  -5.023421872403322977e-06, 8.646689117336178864e-06,
   1.950152248871628221e-05, 4.437411477662756786e-06,
   4.437411477662722905e-06,-1.950152248871628898e-05,
   2.232504568811315963e-06, 9.747611161214660808e-06,
  -6.459341662771094613e-06,-7.633931181481109853e-06,
   9.691092783194224684e-06,-2.466317227673848509e-06,
  -5.364080833133723055e-05, 1.293161385193694298e-04,
   1.936806631201191205e-04, 8.116526802364997244e-05,
  -1.795308592086270545e-05,-8.814006235425603223e-06,
   5.965857211032608533e-09, 1.999999911021367623e-05,
   9.255552595949331699e-07, 1.997857220777891890e-05,
   1.997631423091502409e-05,-9.730723240036905528e-07,
   1.795990126590670856e-05,-8.800110596968808898e-06,
   8.838756849975826465e-06, 4.677218975738192380e-06,
   1.286393314748014470e-05,-1.531402050335448645e-05,
   4.045905678583894686e-06, 1.958649144793428031e-05,
   1.958649144793427353e-05,-4.045905678583915862e-06,
   1.357014896771563925e-06, 1.995390965625383625e-05,
   1.995390965625383963e-05,-1.357014896771527291e-06,
  -5.169227543679001999e-06,-8.560320473070524871e-06,
  -1.574510043739847228e-05, 2.553608842826627002e-05,
   2.553608842826618532e-05, 1.574510043739861119e-05,
  -2.168975937799042810e-04,-3.681621670524591220e-05,
  -3.905265612487817512e-05, 2.266602965885115373e-04,
   8.422876894561061604e-06,-3.910313471857556396e-05,
   2.912785750423427178e-06,-9.566382763204191533e-06,
  -7.004063608031356006e-06, 7.137443027769174488e-06,
   9.255249430240036299e-06,-3.786866512572301385e-06,
  -9.497300236396070183e-06,-3.130700915090928119e-06,
  -1.022818866748991987e-05, 1.718674362938572768e-05,
   1.901723071685536759e-05, 6.192328791488125530e-06,
   1.886699279417210340e-05,-2.332459180574566690e-05,
  -2.332459180574566690e-05,-1.886699279417210678e-05,
   2.660153462380915288e-05, 1.386933147841967642e-05,
   9.246220985613120438e-06,-1.773435641587276746e-05,
   1.083228852761336030e-05,-1.681254071384025007e-05,
   1.057470780318410111e-05,-3.857687850095284203e-05,
  -5.804659970079308648e-05,-1.518526467256624393e-05,
  -1.743564686759145881e-05, 9.797868049154784541e-06,
   8.644877146313165783e-06, 1.803513512910708463e-05,
   2.666468626540277888e-05,-1.374752728193839165e-05,
  -1.574801176064274144e-05,-3.676955432945384629e-05,
   1.195464889543677682e-03, 2.434413643330201628e-04,
   1.065451119206116035e-04,-6.513433342913891406e-04,
  -1.999915443265537032e-05,-1.839075278532744282e-07,
   9.359995122945756382e-06, 3.520012968503335563e-06,
  -3.280490900610341658e-06, 1.972912515675778438e-05,
  -1.169373052216833586e-05, 1.622518617689512656e-05,
   1.621339150291766231e-05, 1.171007839312433320e-05,
   1.531934286006249839e-05, 1.285759442259135164e-05,
   9.329883756795259934e-06,-3.599065029238562244e-06,
  -1.514539533476920003e-05,-1.306204425630044351e-05,
   3.344961149694872357e-05, 3.716346984208008071e-05,
   2.718714143104854618e-05,-2.934040457812679893e-05,
   8.788984231968832174e-06,-4.770089744460083241e-06,
  -5.462738580938210111e-06,-8.376066331896448101e-06,
  -1.675142518528820849e-05, 1.092656186829562199e-05,
  -1.108778226516998289e-05, 2.787581540404122379e-05,
   2.785933179376789449e-05, 1.112913437805265059e-05,
   9.697704081371332684e-06,-2.440191703566304231e-06,
  -3.208321377733994062e-06,-1.974098968991106921e-05,
  -5.824605771897058681e-06,-8.128589521065968600e-06,
  -1.461343843651910902e-05,-1.365457494988643032e-05,
  -2.769310318142014658e-06, 1.980734511139320363e-05,
   1.719031723633519246e-07,-9.998522355794952233e-06,
  -9.773342341773906316e-06,-2.117021367508924417e-06,
   7.081206385491497525e-08, 9.999749279437591498e-06,
   3.969955662667842529e-05, 4.893383660122429338e-06,
   6.537494488090675723e-06,-4.957076926796864254e-05,
  -1.539255622811854380e-06, 9.880824465986738785e-06,
   9.666221198726905795e-06,-2.562063179799164096e-06,
  -6.405812587868143297e-06,-7.678903898937012229e-06,
   3.894827517730931814e-05,-9.112181995142052285e-06,
  -9.112181995142120048e-06,-3.894827517730930458e-05,
   1.748714232416499317e-05, 9.705660891170543096e-06,
   2.512134783098972116e-06, 1.984160222440577910e-05,
  -3.948899912929402774e-05,-6.373299598058729934e-06,
   1.861183209266045890e-05, 7.321182018951196067e-06,
  -2.322503621364811017e-05, 3.256681889400212752e-05,
   1.658767006617794559e-06,-9.861465003626806650e-06,
   9.906172619760731309e-06,-1.366654318949315635e-06,
  -1.845702824589865487e-05,-3.548715413117962882e-05,
  -2.661536559838474533e-05, 1.384277118442394118e-05,
   1.703898365185190162e-05, 2.469155799280239275e-05,
   2.469155799280242324e-05,-1.703898365185185757e-05,
   2.653094371740913178e-05, 1.400389322523093693e-05,
   1.592434227371709521e-05,-1.210021996285632573e-05,
  -3.314551572715164653e-05, 3.584708841554376134e-04,
   4.280502085298985046e-04, 4.090255465750735123e-05,
  -1.155414967060328314e-05,-1.632487749997831117e-05,
  -1.632487749997829085e-05, 1.155414967060331025e-05,
  -3.966183540185823017e-05,-5.190261318653003705e-06,
  -5.641643193998491538e-06, 3.960014977334821751e-05,
  -3.059234999335776017e-06, 1.976464219809807415e-05,
   2.192979069279773837e-05,-2.047154806481624528e-05,
  -2.047154806481623173e-05,-2.192979069279775192e-05,
   8.256963941198709116e-06, 5.641147620275885859e-06,
   2.428787048490314303e-05, 1.760963790963831398e-05,
   1.760963790963831398e-05,-2.428787048490313965e-05,
  -1.336189362954547354e-05, 1.488152541350221125e-05,
  -3.593552116364970973e-06, 1.967451100248666801e-05,
   3.905344386002912162e-05,-1.239952762111184114e-04,
  -1.239442818645680538e-04,-3.921498429269740455e-05,
  -2.512259461892706951e-06,-2.989462413873321473e-05,
  -2.987160801241535050e-05, 2.772550225442831475e-06,
  -7.619791424070115374e-06,-1.849158669919018965e-05,
  -2.618031697368607841e-05, 1.464892498299191352e-05,
   9.468669435704559311e-06, 1.761659158626759867e-05,
   5.999880057249103825e-06,-1.907882174817471737e-05,
  -1.908592598108130648e-05,-5.977242628895507978e-06,
   9.816113004585781809e-06, 1.908906881228602678e-06,
   1.997970905243726098e-06,-1.989995256933542616e-05,
   2.342334751051958338e-07, 9.997256357578321017e-06,
   5.057475101648924287e-06, 8.626815495662418009e-06,
   1.699840306852493286e-05, 2.471951239648472720e-05,
   2.470340058955182249e-05,-1.702180951932346042e-05,
  -6.458431181279621880e-06, 7.634701479211555695e-06,
  -1.746618943341984951e-05,-9.743317026346465370e-06,
  -5.199041955993464814e-05, 2.994989605961872068e-05,
   2.478501374419234569e-05, 4.342468300057234827e-05,
   2.110684709156382638e-04, 1.339779854503506291e-04,
   1.339165333265344212e-04,-2.111074657651955194e-04,
   4.958385430776874263e-05, 6.437498892113560427e-06,
   7.783741812069644913e-06,-5.949296902494477773e-05,
  -5.781265399137893554e-07,-3.999582190309192376e-05,
  -2.994790738133226181e-05,-1.767156891491161161e-06,
   7.859370181225784700e-08, 1.999984557515471160e-05,
   2.125361906430264308e-07,-9.997741163266179613e-06,
   1.815721335211031051e-05,-8.385439957804664572e-06,
  -8.397559634032953577e-06,-1.815161128365359132e-05,
   9.505047835108630742e-06, 3.107099234381925723e-06,
   6.214208422425806848e-06,-1.901009241646795089e-05,
  -1.976188886229946436e-05,-3.076970684638451822e-06,
  -5.132490906076296738e-06, 6.981158598040186928e-05,
   6.932528114598444100e-05, 9.695637886710317143e-06,
   1.957515321878782082e-05, 4.100411742859602262e-06,
   1.566701995903180372e-05, 1.243159223926280555e-05,
  -2.123774122619472717e-06,-9.771877172585210168e-06,
  -4.571602455344042442e-06, 1.947050207340047842e-05,
   1.947046457167337223e-05, 4.571762172643287220e-06,
  -4.131923196298353866e-06,-9.106437871082830943e-06,
   2.970210002140439868e-05, 4.217256729022897311e-06,
   2.709882379189815230e-06,-1.981556301221231022e-05,
   1.978015306763321139e-05, 2.957286699155243110e-06,
  -1.953532035090202094e-06,-9.807329533969803153e-06,
   7.295311715785631202e-06,-6.839475635567460550e-06,
   7.466591775598019798e-06, 6.652067893262366458e-06,
  -1.992815487913361306e-05,-1.693706914806472635e-06,
  -2.970682434188237625e-05, 4.183848410320894755e-06,
   8.828927869791562089e-06, 3.901345963472116723e-05,
  -5.913355154243352304e-06,-1.910581667502814831e-05,
  -1.909405267818341009e-05, 5.951231160252223793e-06,
   9.822176949559187310e-06, 1.877455717599806906e-06,
  -1.429961266620133746e-05, 1.398288516711105414e-05,
   3.358009267066956646e-05,-2.173424432155956473e-05,
  -2.176497527338573581e-05,-3.356018252853979915e-05,
   1.738133980770431214e-05,-9.893888340238810665e-06,
   3.220268326107276285e-06,-9.467305419593806772e-06,
   8.390899475796860112e-06, 1.815469101877176077e-05,
  -4.469492094947441225e-04, 2.848445262454998936e-04,
   3.014376273673215526e-04, 4.719484683809872902e-04,
  -3.455090947244759454e-05,-6.087885227750873519e-05,
  -8.082173600261085457e-06,-5.888842831596270003e-06,
   5.134073890150394053e-05, 8.581450069217672679e-05,
   9.431804241147723059e-05,-5.660483085096874948e-05,
  -1.732489196369101339e-05, 9.992403036629110677e-06,
   3.920288417766698002e-06,-9.199529266300765135e-06,
  -2.761765342482181540e-05,-1.171602404002432774e-05,
   6.428132117219271266e-06,-7.660229597314567335e-06,
   1.820604386765595231e-05, 8.278886802522859707e-06,
  -1.943964702703706256e-05, 2.284951035502094026e-05,
   2.288183637747140026e-05, 1.940158663601063884e-05,
  -1.414441474526179762e-05,-1.413985613484170875e-05,
  -9.750059864738232552e-06, 2.221785910933069874e-06,
   1.232039496399815830e-05, 1.575461417906160109e-05,
  -9.039814468775681229e-06,-4.275716825295363709e-06,
   1.106265004088441845e-05, 3.843979414711946641e-05,
  -5.010046377637630613e-06, 1.936231998738581321e-05,
  -4.112919531371761082e-05, 1.020215138725458790e-04,
   7.419753250288525976e-05, 2.991197369755606427e-05,
   6.700201358237676471e-06, 7.423429245239023422e-06,
  -1.639362075719184519e-05,-2.512467310174141971e-05,
  -1.628058057049387109e-05, 1.161648381773321007e-05,
  -1.080262006917134500e-05, 1.683161904396414930e-05,
   1.603985881075219828e-04,-5.632311189124331654e-05,
  -5.303833726126273650e-05,-1.509534192410379118e-04,
  -5.609513223692183929e-06,-8.278487868760968528e-06,
   1.098565055164773922e-05, 1.671273412572227103e-05,
   1.926970927929721604e-05,-5.355212814759729359e-06,
  -8.073267506301839272e-06, 5.901046667472721362e-06,
   3.302317561354505933e-06, 1.972548348517647041e-05,
   1.972548348517647041e-05,-3.302317561354504663e-06,
   9.835969591961025638e-06, 1.803802147137559684e-06,
   3.961539672487759197e-05,-5.533565065177987520e-06,
  -3.572306576274956435e-06,-2.978655108811865661e-05,
   3.973873787436085669e-06,-9.176509528220869752e-06,
   1.120982677320418517e-05, 1.656320571974986659e-05,
   1.656320571974988692e-05,-1.120982677320415468e-05,
  -9.693214021539399623e-06, 2.457967032454261083e-06,
  -2.938637645440755319e-05, 6.036628105146236565e-06,
   4.246470058845143573e-06, 4.981934857100534409e-05,
  -2.445591109126867167e-05,-1.737551186860294958e-05,
  -1.160671214904286336e-05, 1.628754840635203955e-05,
   1.932923990556107183e-05,-5.136193597720534944e-06,
  -5.139725659401259104e-06,-1.932830101550812496e-05,
   9.939422270609535678e-06,-1.099038182462824304e-06,
  -7.469259161264758130e-06,-6.649072685860976294e-06,
  -5.745169608809397938e-06, 8.184926766075116661e-06,
  -4.777423932689288502e-06, 1.942102521926604306e-05,
  -1.527005087324275002e-06,-9.882725103092050833e-06,
  -5.323873894119514155e-06, 1.927839118701331816e-05,
   2.537079727990831856e-05,-1.601007949330036410e-05,
  -2.171768214673659410e-05,-3.359080651269509072e-05,
  -1.890821288236157593e-05, 6.517628832274494210e-06,
   6.514295624265587016e-06, 1.890936150481222145e-05,
   9.852611954131460645e-06, 1.710566479651074029e-06,
   2.697894805173290804e-05,-2.953195493058150770e-05,
  -1.938002921069374691e-05,-2.290009754985024472e-05,
   7.058047763525351598e-06, 7.084063930244757677e-06,
  -5.900731767093663880e-06,-8.073497669090622136e-06,
  -1.759162969593921225e-05,-9.514965298988209270e-06,
   9.931517123340507326e-06,-1.168318290875529213e-06,
   7.855481667089804227e-05, 1.513739666526580676e-05,
   1.034335009130893689e-05,-5.910173524431088464e-05,
  -5.487338382171132486e-06,-8.359971141071690994e-06,
   1.379047462362968799e-05,-1.448526180830107319e-05,
  -1.448526180830107319e-05,-1.379047462362968799e-05,
  -5.656279875048935111e-06, 8.246605239437401890e-06,
   3.641062462899527554e-06, 9.313574187242191845e-06,
   4.228067212546610987e-06,-9.062198830647468195e-06,
  -8.597321996481453951e-06,-5.107450879726223203e-06,
  -9.962411963161895938e-06,-8.662262269457958405e-07,
  -2.662717714536985968e-05,-1.382003752777441099e-05,
  -8.717669911693062048e-06, 1.800006198074777464e-05,
   1.312912658459918103e-05, 2.697454420607642216e-05,
   1.785577282170149806e-05,-9.009515910401967318e-06,
   9.999316255634394128e-06, 1.169376748775856308e-07,
  -5.450631919357243151e-06,-8.383949646776511726e-06,
  -2.497713660317108322e-04,-4.787632658325543709e-04,
  -4.876695174810232380e-04, 2.543195661364378891e-04,
   5.470286051564062901e-05,-2.464948379594115847e-05,
   5.502675506745110043e-05,-2.391769693651009810e-05,
  -1.308801530312309339e-05,-2.699451528413162344e-05,
   3.179446136666300222e-07,-9.994944283118360601e-06,
  -9.970008373792254512e-06,-7.739076343546051219e-07,
   2.871686784731760709e-05, 8.679948216417903285e-06,
  -3.003267189697508755e-06,-3.988709548447074598e-05,
   2.976342684540936616e-05,-3.760109362500662626e-06,
  -2.506739575000440622e-06,-1.984228456360624410e-05,
  -2.870413017566607203e-05,-8.721978609146919032e-06,
  -5.814652406097913551e-06, 1.913608678377739378e-05,
  -5.633959049681659052e-07, 1.999206305147783447e-05,
   9.911357686124009557e-06,-1.328528817041819177e-06,
  -7.007857059593035340e-06,-7.133718485636511398e-06,
  -1.459242575487369360e-05, 1.367702857306728732e-05,
   1.503118468024322602e-05,-1.319331221143581444e-05,
  -5.206370807011419820e-07, 9.986437654649380575e-06,
   1.892310651921644293e-05, 6.474259777178252252e-06,
  -7.575030129620099083e-06, 6.528316669352653739e-06,
  -3.426388559212904728e-06,-9.394671970925590795e-06,
  -2.706894408970375848e-05, 1.293337797593854041e-05,
   2.966917128192349541e-06,-9.549733124775731943e-06,
   8.810121194690166908e-09,-1.999999805954402025e-05,
  -1.999999805954402025e-05,-8.810121194691391136e-09,
  -1.152100581452800267e-05,-1.634828507891919434e-05,
  -1.702679076525147607e-05, 1.049230176064085405e-05,
   3.085995357905270874e-06,-9.511920555334088070e-06,
   1.844657386319024643e-05,-7.728124786121568374e-06,
   2.156832936036599067e-05,-2.085203032327486599e-05,
  -2.087436827023422735e-05,-2.154671087007570498e-05,
  -1.224079253016387841e-06, 3.998126598773899806e-05,
   3.995519921467951505e-05, 1.892631954520918878e-06,
  -1.028379939156951163e-05, 1.715352646174991673e-05,
  -9.972362645165170931e-05, 7.429557680739336724e-06,
   8.178678306822753609e-06, 1.096955296315830152e-04,
  -1.616016552867961041e-07,-9.998694159989522702e-06,
   2.166626850530765589e-06, 1.988229685148471874e-05,
  -4.734524927263115167e-06, 8.808193555611968837e-06,
   2.281962627061517900e-04,-2.874831624539017562e-05,
  -2.652648200045158204e-05,-2.083178959011436544e-04,
   1.999405557337736357e-05,-4.875876625774247190e-07,
  -4.590242888336519165e-05, 1.982339583945195863e-05,
   1.804986459551881210e-05, 4.662834318398453441e-05,
  -8.199055061981560741e-03, 4.514985724295764863e-03,
   4.316852672092732525e-03, 7.840107333923804211e-03,
  -1.132546539738454446e-05, 5.892142083769403909e-05,
   5.891473936606147013e-05, 1.136017101231520931e-05,
  -3.702896617248502671e-05, 1.512797620955822884e-05,
  -3.445431319899856164e-04,-7.220041760256871305e-04,
   2.738483607400993500e-05, 1.225033686065832982e-05,
   4.836632028955832087e-05, 7.589926917729748952e-05,
  -1.148761048542241930e-05,-1.637176854634870963e-05,
   1.350754497852674251e-04,-3.444628033116314304e-04,
  -3.071879280518851219e-04,-1.205635801525063890e-04,
   2.017567113206972744e-05, 3.453899671922403561e-05,
   2.596708394382101447e-05,-1.502366637856927523e-05,
  -8.819724482225369314e-06, 1.795027743678728134e-05,
  -8.947353608141446393e-06,-4.465967242477071470e-06,
  -3.319823158400150159e-03, 4.422632044037809983e-03,
   3.446547687455479587e-03, 2.587935284757963712e-03,
  -2.063280300767678996e-05, 2.177814133589925298e-05,
  -2.367249267887851802e-04,-2.001532139058583915e-04,
   1.659383300906037316e-05, 1.116443935302702471e-05,
  -2.590208191690053640e-05,-1.513546009773651946e-05,
  -1.952308353870400265e-05, 4.341567590258719892e-06,
  -2.881126666253951272e-06, 1.979138977265114694e-05,
   7.101760863742832159e-06, 7.040240950010921273e-06,
   3.832566039190250226e-05, 1.145180140958424745e-05,
   8.573699076812718161e-06,-2.874876839345054185e-05,
  -5.428896977769985309e-06, 1.924907991579753250e-05,
  -3.035041729245681294e-06, 2.984608050819634014e-05,
   2.984608050819634014e-05, 3.035041729245682988e-06,
  -1.955582867173264830e-05,-4.191606489383193424e-06,
   2.072919387446582249e-06, 1.989228506766249098e-05,
   1.488263120610941330e-05, 1.336066197397937153e-05,
  -6.342031221233050185e-07,-2.999329569086880241e-05,
  -2.999329569086880241e-05, 6.342031221233031127e-07,
   1.213092957931774410e-05,-1.590096058550029615e-05,
   9.999026458318282316e-06,-1.395345328259730957e-07,
   6.336199904978341763e-06,-1.896978046167515662e-05,
  -1.851964299208387976e-05,-7.551345803613983949e-06,
  -2.217745228296254132e-06, 1.987665983263710407e-05,
   1.210393639044993833e-05,-2.744985835766628713e-05,
   6.877673986390604688e-06, 7.259311299078307043e-06,
  -1.628394413866264984e-05, 1.161176831016337568e-05,
   1.487680649577319451e-05, 2.605149954392876324e-05,
   1.534164303688037687e-05, 1.283097770744458745e-05,
   1.287932100597689447e-05, 1.530108134822511046e-05,
   1.530108134822511385e-05,-1.287932100597688939e-05,
  -9.849661838981156974e-06, 1.727472621409194921e-06,
   9.918575613035975760e-06,-1.273521813118261043e-06,
  -6.992958320224401268e-06,-7.148323854695193132e-06,
  -1.697084500814319516e-05, 1.058255260840130573e-05,
   1.058255260840130403e-05, 1.697084500814319516e-05,
   1.834677230055335660e-05, 7.962157129299076742e-06,
  -2.256198101219808404e-05,-1.977263292546577083e-05,
  -1.977263292546577422e-05, 2.256198101219808404e-05,
  -5.879719235724503075e-06, 8.088813368415127204e-06,
   7.722204367238277788e-06,-1.844905308438907671e-05,
   9.318466239802473771e-06, 3.628524071528474272e-06,
  -9.380848301775112882e-06,-2.849560817282345660e-05,
  -2.850888883109953373e-05, 9.340409927621390654e-06,
  -1.049745730184587578e-05,-1.702361272456357077e-05,
  -1.702361272456359110e-05, 1.049745730184584528e-05,
   1.542318723128026874e-05,-3.690698166511145842e-05,
  -2.791296411350535932e-05,-1.099392715994434586e-05,
  -1.232151486155181583e-05,-1.575373833464799458e-05,
  -1.575373833464799797e-05, 1.232151486155181413e-05,
   9.858075892510913236e-06,-1.678791141713334801e-06,
  -7.533425393271151179e-07, 2.999053975870458218e-05,
  -1.998032260660924115e-05,-8.869659158162320356e-07,
  -8.869659158161978367e-07, 1.998032260660924454e-05,
   2.900328582954066954e-05,-7.668729431266002738e-06,
  -1.185083606595119340e-05,-3.820415794829079445e-05,
  -1.588316303566167046e-06, 9.873056837668156094e-06,
  -5.623902864578475083e-06,-1.919301218073354113e-05,
  -1.919301218073354113e-05, 5.623902864578474236e-06,
  -6.050306235140347615e-06, 2.938356333838736169e-05,
   2.942715000874139862e-05, 5.834624440615785055e-06,
  -5.962234071109434000e-06, 8.028185653141177528e-06,
   9.969178942134692046e-06,-7.845197382464183907e-07,
  -6.067735207957145398e-06,-7.948747665268867974e-06,
   1.061536687834746295e-04,-7.504264523461551088e-05,
  -5.770568491346507217e-05,-8.167039811748127878e-05,
   1.072670903457895262e-05,-1.688009814211642362e-05,
   8.905630535525888274e-05, 1.207020069280991101e-04,
   1.367283384054070996e-04,-1.010215891623987523e-04,
  -1.649212003369793076e-05, 1.131414940656607179e-05,
  -9.928148602829732071e-06, 1.196605749664470987e-06,
   1.200679144084077617e-05, 1.599490416651980890e-05,
   3.562937057640703126e-05,-3.507916692752354208e-05,
  -2.807692150106720828e-05,-2.849011195174406850e-05,
  -1.865256431869768440e-05,-7.216775203430275826e-06,
   1.565220353744235222e-06, 9.876744668372509483e-06,
   6.215281227660945106e-06,-7.833918512537992019e-06,
   5.833065901840101650e-06,-8.122520679246703320e-06,
   5.177177138481473044e-06,-8.555514997753484676e-06,
  -2.609458000753747968e-05,-1.480111124984287411e-05,
  -1.480111124984286902e-05, 2.609458000753748307e-05,
   2.168907140130910553e-05,-2.072641265991091592e-05,
  -1.381760843994058972e-05,-1.445938093420609294e-05,
   6.279645886951157217e-07, 2.999342695450696531e-05,
   2.999344732439497568e-05,-6.269909080233581409e-07,
  -9.122176509598748008e-06,-4.097059400072791704e-06,
   1.873466913758364014e-05,-2.343100877694494685e-05,
  -2.364747105442046503e-05,-1.846069101443243481e-05,
  -3.504300098778298544e-05,-1.928699255379752190e-05,
  -2.543736924108909716e-05, 3.086973025623150076e-05,
  -9.954695776059419029e-06, 9.508059771082493747e-07,
   3.172062651235609650e-06, 9.483565707930543133e-06,
  -9.957492557498848150e-06, 9.210548123510672484e-07,
  -9.955147692358279248e-06, 9.460625895434441204e-07,
   4.476476600208000026e-06, 8.942100270506377294e-06,
  -1.930900402996308516e-06, 9.811810415703552343e-06,
   5.983305295622544864e-06, 8.012493852688763233e-06,
   8.717601422279104608e-06, 4.899329080831104780e-06,
   8.840402771778657149e-06, 4.674107276553273863e-06,
   1.670463319610806006e-06,-9.859490468469193515e-06,
  -1.665321544163805347e-06,-9.860360244663674730e-06,
  -1.998122212270101103e-05,-8.664655118836714873e-07,
  -9.042956235100755866e-07,-2.998636772644030189e-05,
   8.224504320960815930e-06, 5.688367839239731021e-06,
  -7.215671641330415849e-06,-6.923444429220186831e-06,
   9.216748045076231163e-06,-3.879633420000331809e-06,
  -7.658992217849102139e-05,-2.310808994037999277e-05,
  -4.822974057159879803e-05, 8.760075413143586162e-05,
  -1.682642410671846133e-05, 2.483689698373860502e-05,
   2.416677972752515307e-05, 1.777545379452461006e-05,
   9.372051431280950789e-06, 3.487786112912415318e-06,
  -4.921939246500958689e-06,-1.938490428281124217e-05,
   6.959533523094698897e-06,-7.180869943183840941e-06,
  -9.921209426527025674e-06,-1.252838183881421228e-06,
   9.175595400662610280e-06,-3.975984034593091650e-06,
  -2.539530498165722467e-05, 1.597117669079569556e-05,
   9.908222188223061761e-06, 1.351714862241374142e-06,
   1.167110598808246042e-05, 1.624146806834116883e-05,
   1.585457762920171397e-05,-1.219148753022438279e-05,
   9.857993351941810446e-06,-1.679275758495631486e-06,
   4.095227213583918169e-07,-2.999720472211854787e-05,
  -2.999720472211854787e-05,-4.095227213583863112e-07,
  -2.981925382278543130e-06, 9.545057412845822097e-06,
  -4.687805629143474060e-06, 8.833146573185048360e-06,
  -1.885669056631126100e-05,-6.665224743876832218e-06,
  -2.906293582621544724e-05,-7.439473177670757015e-06,
  -4.959648785113851562e-06, 1.937529055081029590e-05,
   3.586541987216830692e-05, 3.483779065028485227e-05,
   2.770509427524014799e-05,-2.885182405325624732e-05,
  -7.640033253021179488e-05, 7.913904971171350784e-05,
   8.639071470382054445e-05, 8.328651999551359608e-05,
  -2.823526489468135629e-06,-9.593106804537920355e-06,
  -1.317691520977534644e-05,-1.504556099168094254e-05,
   9.824765839699588866e-06,-1.863860562132277260e-06,
   1.998280070903977524e-05,-8.292622159483439013e-07,
  -2.368281582357740285e-05,-1.841532608091727173e-05,
  -1.837463425877451314e-05, 2.371440102250676712e-05,
  -3.675958621464790877e-06,-9.299856354443261194e-06,
  -9.041546037692980298e-06, 4.272053984710210956e-06,
   2.998138582231205649e-05,-1.056647610921301313e-06,
  -1.520286013417832857e-05, 2.586257999002828157e-05,
   1.724171999335221030e-05, 1.013524008945218517e-05,
  -5.654085026628043905e-06,-8.248110238815954396e-06,
  -1.880725244378863854e-04, 1.141434428758859019e-04,
   1.198187482553477888e-04, 1.963249030727421286e-04,
  -1.830452909542392307e-05,-3.556605424551308832e-05,
   1.988293076566828818e-05, 2.160801741863777930e-06,
   3.553581673741215561e-05,-3.517393536135896101e-05,
  -2.814071615487701339e-05,-2.842710140500864145e-05,
  -3.510236733214274797e-05,-1.917873321362278686e-05,
  -1.158215859109457893e-05, 1.630501770531802013e-05,
   1.145139296555788804e-06, 2.997813629950140605e-05,
   1.998444920803590512e-05,-7.885365251103491093e-07,
  -1.918164081267002222e-05, 5.662566179190469789e-06,
   9.298254724509695367e-06, 3.680008026911511234e-06,
   1.920997822136773805e-05, 2.304293246821196629e-05,
   2.304711283122080499e-05,-1.920496264367565367e-05,
  -2.404905930579680298e-06,-9.706514691951107228e-06,
  -9.282543206749541877e-06,-3.719461199532527592e-06,
   1.701188396736042574e-06,-1.992751760854348739e-05,
  -6.741233844957287297e-06, 7.386187531304793249e-06,
  -1.793117618540599121e-05, 8.858494263018358613e-06,
   8.858494263018324731e-06, 1.793117618540600476e-05,
  -9.775181663461749950e-06, 2.108512140425373811e-06,
   4.193449867578538856e-06, 1.955543347021757023e-05,
   2.165753197720179206e-06,-1.988239203633619491e-05,
   9.432046983527795055e-06,-3.322121265174442076e-06,
   3.364597408454245836e-06, 1.971495585282967520e-05,
   1.401848282517939774e-05, 1.426471658604370331e-05,
   2.154412230563765236e-05,-2.087703987829036734e-05,
   4.900699148841229312e-06,-8.716831296551910726e-06,
   9.393991144509460916e-06, 3.428254712952036978e-06,
  -1.640413756113987180e-05, 2.511780784374305548e-05,
   1.689337281684537062e-05, 1.070579071676025002e-05,
   2.665178838108720504e-06,-9.638299733920785263e-06,
  -2.441578934031069672e-05,-1.743184530936328104e-05,
  -2.341089721676535847e-05, 3.243346869371280049e-05,
  -9.334159441379494553e-06, 3.587961471770018056e-06,
   1.040764682806963048e-05, 1.707866761495674415e-05,
  -1.902207891523899312e-05, 5.690483734923086991e-05,
   4.709601355630142414e-05, 1.679182858132707767e-05,
  -2.302651469448524976e-05,-3.270748570319423413e-05,
  -2.453061427739570440e-05, 1.726988602086389243e-05,
   1.196064339703689243e-04,-9.710867772335312438e-06,
  -8.575078106846098093e-06,-1.096652544585635419e-04,
  -1.481512899184568920e-05,-1.343547367810206320e-05,
  -1.342027546686954519e-05, 1.482889767964360546e-05,
  -6.405117865255209963e-06, 7.679483389668120643e-06,
   3.949228746480626601e-05,-6.352891530406160097e-06,
  -4.764668647804644637e-06,-2.961921559860469273e-05,
  -2.434159215155436276e-05, 4.367478553499017991e-05,
   4.368557220257690522e-05, 2.432222813258358942e-05,
  -9.234803788394518146e-06, 3.836456566918783223e-06,
   1.140763713772946328e-05, 1.642759309618714643e-05,
   1.642759309618712271e-05,-1.140763713772949546e-05,
   1.233894905077897680e-05, 2.734502397735794085e-05,
   2.734502397735800522e-05,-1.233894905077882941e-05,
  -8.320097740861526558e-06, 5.547609717933565445e-06,
  -9.984697176670179468e-06, 5.530120163202282247e-07,
  -1.976595561476847754e-04, 3.931039301043685310e-04,
   3.397486626984015938e-04, 1.702082436154246615e-04,
  -9.055989817307720295e-07,-1.997948674226363082e-05,
  -2.747388609636397348e-05, 1.204929801955360093e-05,
  -3.454732295282524876e-05,-2.016141058540284756e-05,
  -1.999687802889485669e-05,-3.533682180138342068e-07,
  -3.533682180138660235e-07, 1.999687802889485330e-05,
  -1.607747220514898091e-05, 1.189600300490303411e-05,
   1.191232806571092822e-05, 1.606538017150156857e-05,
   1.672013411260749656e-06,-9.859227715828669522e-06,
  -9.877445903432784539e-06,-2.832730242054048888e-05,
   9.348421067408658260e-06, 3.550637062053789893e-06,
  -8.859565305198923661e-06, 4.637682891586652014e-06,
  -1.159156393483917708e-06, 9.932590621557165733e-06,
  -8.197516770768683593e-06,-5.727191178314741309e-06,
  -5.322676787776152865e-06, 1.927872173700499679e-05,
  -2.379568099851991960e-05,-1.826925192274380210e-05,
  -1.826925192274380549e-05, 2.379568099851991621e-05,
  -1.757970569711039997e-05,-9.536977907229533146e-06,
   1.260419765053532070e-05,-1.552849643675265553e-05,
  -1.543463207428625022e-05,-1.271896743967112268e-05,
   9.242019972556165023e-06,-3.819040039967238212e-06,
   9.530000818638065287e-06, 3.029700380690775360e-06,
   9.695144640776570688e-06,-1.749297488692021894e-05,
  -3.977008211491308870e-05,-4.282589003520017566e-06,
  -4.135872063070843780e-06, 3.978560747654747836e-05,
  -9.715931786027788943e-06,-2.366573372886394037e-06,
   3.860933162699200683e-06, 1.962379155803407966e-05,
   7.415929983985165848e-06, 6.708500761916166849e-06,
  -1.708134604195080537e-05,-1.040325032838927878e-05,
  -1.522398752353030531e-05,-1.297035866440838542e-05,
  -1.297408882521187134e-05, 1.522080875497463530e-05,
  -1.387162015452324565e-05, 1.440757281045716588e-05,
   1.995782563596231718e-05, 2.239833020304248876e-05,
   1.703610574852626276e-05, 7.816502479322214373e-05,
   7.816771471018426330e-05,-1.702375919082633394e-05,
   8.508649725674287363e-06, 5.253844292114383057e-06,
   1.880244971164422973e-05,-6.816735644066735622e-06,
   1.411511796074456536e-05, 1.416910176949358512e-05,
   6.191883471286094516e-06, 7.852425044405967843e-06,
  -7.910541195124243157e-06, 1.836908647702009076e-05,
   9.453448862087026274e-06, 3.260721486405349505e-06,
   2.698820250364334999e-05, 1.310102765520090400e-05,
   1.998903236849777930e-05, 6.622574810057590002e-07,
   6.622574810057246953e-07,-1.998903236849778269e-05,
   3.467897949304015907e-05,-1.993410096596534765e-05,
  -1.495057572447386843e-05,-2.600923461978019553e-05,
   5.253237207424176370e-04, 4.158545279606108377e-04,
   3.969584112527941243e-04,-5.020199395797518170e-04,
  -2.425825566858449172e-06, 1.985233916492401622e-05,
   1.986680248138473093e-05, 2.304378260105229689e-06,
  -3.297243501791139125e-05, 3.758747835369660354e-05,
  -5.675947487598738940e-06, 8.233080840002822266e-06,
  -1.971934488474989775e-05,-3.338777817748296870e-06,
   2.193368694685558590e-06,-9.756491878189279748e-06,
   1.696254732385968004e-07,-2.999952044948099914e-05,
  -2.999952044948099914e-05,-1.696254732385453432e-07,
  -2.965851473817776742e-05, 4.513590978953696802e-06,
   5.934050144186509092e-06, 3.955738930827311969e-05,
  -8.283524413132768089e-06, 5.602073124927365161e-06,
   1.122160754328889096e-05, 1.655522649027798570e-05,
  -8.210378386089792625e-06, 5.708737755163535725e-06,
  -2.602419087683397863e-05, 1.492452643155256687e-05,
   1.492452643155251944e-05, 2.602419087683400574e-05,
  -1.965059862223263403e-06,-9.805026248709337221e-06,
   6.689494861933263402e-06,-1.884809429338065953e-05,
  -9.580326776333531217e-06,-2.866590109985516713e-06,
  -1.970567892416511240e-05,-3.418511099545377932e-06,
  -8.259540679856225098e-06, 2.884059617549193709e-05,
  -9.420956363665060926e-06,-3.353443184835371738e-06,
   4.633363480153769571e-06,-8.861825029912144010e-06,
   2.258453176369920839e-05,-1.974687127153214533e-05,
  -1.974687127153214872e-05,-2.258453176369920501e-05,
   1.093080349962625350e-05,-2.793774391128529502e-05,
  -1.862516260752353453e-05,-7.287202333084153753e-06,
  -1.505303613312031109e-05,-4.768024856452590671e-05,
  -3.558497256746271200e-05, 1.826772365055171962e-05,
   9.954895000669342208e-06, 9.487178324710513388e-07,
   7.043356283303076968e-06,-7.098671162017231724e-06,
   1.542483865531061316e-05,-1.273084256668173338e-05,
   1.049661497075817104e-05, 1.702413211167181687e-05,
   1.158814846877366392e-05,-1.630076118056020902e-05,
   2.914106654665964973e-05,-2.740069781087982114e-05,
  -2.738485572536888493e-05,-2.915595439872842122e-05,
   9.375482058180247965e-06, 3.478553747858480667e-06,
  -9.996540562137231506e-06, 2.630148086041134748e-07,
  -3.352553584404366400e-06,-9.421272974693889726e-06,
  -5.281871206428196308e-05,-1.296540923221109639e-04,
  -9.260998034280078770e-05, 3.772786159996418544e-05,
   1.890995370463898555e-05,-6.512576363345794461e-06,
   9.780935313522591705e-06, 2.081659048136059757e-06,
   5.020662966772495503e-06,-8.648291355758039368e-06,
   7.958661104702000649e-06,-6.054726535567360494e-06,
  -1.805224072701926721e-05,-8.609100111727527142e-06,
  -7.343169152435620750e-06, 6.788067972458580816e-06,
   1.574455764002415025e-05, 1.233324388471894238e-05,
  -3.957116283320675315e-06, 9.183748184716214778e-06,
   2.196392461683593198e-05,-2.043492146855349723e-05,
  -1.782386623872868832e-05,-9.072474431152050946e-06,
  -5.242367083398770523e-06,-8.515725885847729457e-06,
   5.421235258235215618e-06, 8.402988056332544005e-06,
  -9.991235865242823302e-06,-4.185760206766463359e-07,
   1.063816645632191311e-06, 1.997168731340634603e-05,
  -5.996642407284965274e-05,-2.006983785474529835e-06,
  -1.672486487895710956e-06, 4.997202006070804056e-05,
   6.470572102950710792e-06,-7.624414512637415508e-06,
   1.992381619833856609e-05,-1.744003467548671444e-06,
  -1.247474638934768310e-05, 1.563268059295836289e-05,
  -1.491752620994918978e-05, 2.602820415963189382e-05,
   3.473896860625652014e-05, 1.982937367073211581e-05,
   3.407190732880787224e-06, 1.970763941495204304e-05,
   1.970763941495203966e-05,-3.407190732880820682e-06,
  -1.913783890836973249e-05, 5.808883018041394079e-06,
  -1.927230326598806774e-05, 5.345870071726933301e-06,
   7.971689908075023904e-06, 2.892148267308394533e-05,
   3.834546471444538983e-06, 9.235597076439197716e-06,
   2.227235520033816658e-05, 2.009831320857472707e-05,
   2.009831320857471352e-05,-2.227235520033818013e-05,
  -4.131034048859767956e-07, 9.991463635367524505e-06,
  -1.804259199067660379e-05, 8.629303231314364506e-06,
   7.574431053191086767e-07, 9.971272734320557206e-06,
  -3.299036347163222736e-06,-3.986372234475973241e-05,
  -4.955406969534636394e-05, 6.662895513870494392e-06,
  -2.960143147426314822e-06, 9.551835035570131844e-06,
   1.023530450804029454e-06,-9.947481360438777663e-06,
  -2.935582099162383534e-05, 6.183508220075183414e-06,
   6.123652263863933447e-06, 2.936836534353375026e-05,
  -1.629837351090799934e-05,-1.159150641197823535e-05,
   9.608178205270393458e-06, 2.771806554535691306e-06,
  -4.444567116160937439e-06, 8.958003301514287536e-06,
   1.497692603013443885e-05,-2.599407022164635067e-05,
  -2.599407022164635406e-05,-1.497692603013443376e-05,
  -2.242770141470237905e-06, 9.745254336985238286e-06,
  -1.998566262719098728e-05, 7.571587363964770172e-07,
  -8.304788904414200880e-06,-5.570500987623894557e-06,
   1.277085516315056696e-05,-1.539172694670194009e-05,
   1.051098323830760108e-06, 9.944606191983681122e-06,
   1.332281931112727433e-05,-1.491651720754728544e-05,
   3.231812813771579504e-05, 2.356986622096491550e-05,
   2.237544673229740661e-05,-1.998347776364568060e-05,
  -9.993883730707099925e-06, 3.496969789803011515e-07,
  -1.109825227802599037e-05, 1.663817286763456335e-05,
   1.864220685643140011e-05, 7.243488353136366985e-06,
  -2.297028730325372481e-06,-9.732608027248391776e-06,
  -2.835775031038019174e-05,-9.789688316495686243e-06,
  -1.917252598793007962e-05, 2.307410338977759084e-05,
   3.716923553099191598e-05, 1.477998410153570321e-05,
   1.477998410153589464e-05,-3.716923553099184144e-05,
  -9.429810784843024003e-06, 3.328463393528342373e-06,
   2.689615879205420047e-05,-1.328896693624472865e-05,
  -1.328896693624458296e-05,-2.689615879205427162e-05,
   5.039068479272120629e-06, 8.637580035010164182e-06,
   1.943522992072381335e-05,-4.719304814122722116e-06,
  -1.106032453729964656e-05,-2.788672123304580035e-05,
  -1.859114748869719798e-05, 7.373549691533101095e-06,
  -1.145282897499883663e-06,-9.934199871388449057e-06,
  -1.999707606740921606e-05,-3.419777101649822719e-07,
  -2.247832479418510163e-05,-1.986768518089421139e-05,
  -1.989740961938024381e-05, 2.245201751376910574e-05,
  -2.319423638581350278e-07,-1.999865502327213777e-05,
  -1.632325791311121983e-05, 1.155643764756475487e-05,
  -1.184735302556437765e-06,-1.996487921984194160e-05,
  -1.996487921984194499e-05, 1.184735302556406001e-06,
   1.511068041568084743e-05, 2.591654562967756557e-05,
   2.591654562967755880e-05,-1.511068041568085759e-05,
  -9.999220676437555995e-06,-1.248433574672205940e-07,
  -1.355503824547602188e-05, 1.470581307387260421e-05,
  -9.672528695388814111e-06,-2.538146693333536767e-06,
   2.548568372291816490e-06,-9.669787963122762817e-06,
   2.885768688752428569e-06,-9.574567304845483479e-06,
  -2.998198722548569967e-05, 1.039443125337984148e-06,
   6.929620835586598043e-07, 1.998799148365713537e-05,
  -1.115959461353112830e-05, 1.659709155429490082e-05,
   9.984476672152188897e-06, 1.732946120291247930e-05,
  -1.038912394973200390e-05, 1.708994159021922816e-05,
   1.708994159021922816e-05, 1.038912394973200390e-05,
   2.217145258614455039e-06,-9.751116187504047357e-06,
  -9.291070233256206912e-06, 3.698109506315417891e-06,
  -4.266223549134168005e-06, 1.953968619576100350e-05,
  -2.623386169781336927e-06, 9.649758805493535485e-06,
   2.959612919230095364e-05, 4.906030659569025359e-06,
   9.675106242501556482e-06,-2.528303620277327908e-06,
  -1.634632661681291327e-05, 1.152378436697223959e-05,
   1.152252617209831921e-05, 1.634721354278182004e-05,
  -5.108905774597186493e-06, 8.596457513783658917e-06,
   1.716489679560275467e-05, 1.026480969118796346e-05,
  -2.280365621790038563e-06, 1.986957303595017192e-05,
   1.953556967441039561e-05, 2.276755405168190112e-05,
   2.276755405168186724e-05,-1.953556967441043627e-05,
   5.612496848222794704e-06, 8.276465376517273760e-06,
  -1.067695404589799433e-06,-1.997148032878429060e-05,
  -2.965305719079447776e-05, 4.549307556043230543e-06,
   9.660334897198991257e-06,-2.584169049028984649e-06,
  -2.817025068630507367e-06,-1.980061538848495867e-05,
   1.015991060149579098e-06,-9.948254227033813749e-06,
   1.493596366199675112e-05,-2.601762843703308623e-05,
  -2.599679557969720046e-05,-1.497219488209514494e-05,
  -1.876250219698628120e-05, 6.925930356860728247e-06,
  -3.344942855192240977e-06,-9.423977785176406566e-06,
  -4.767138004992400598e-06,-3.971491401528344219e-05,
  -3.971491401528344219e-05, 4.767138004992406528e-06,
  -8.845860892641622687e-06, 4.663769405538137829e-06,
  -7.809624001613200902e-06, 1.841221803459395948e-05,
   1.191537526543873918e-05, 2.753223260623392966e-05,
   2.753223260623392966e-05,-1.191537526543873749e-05,
  -2.991557029375973694e-05,-2.249145170752678502e-06,
  -1.499430113835111448e-06, 1.994371352917316022e-05,
   5.072231657299585673e-06, 8.618147481604612425e-06,
   1.011762496886929049e-07, 2.999982938895651258e-05,
   2.999982938895651258e-05,-1.011762496889575233e-07,
  -2.971916962622482089e-05, 4.095235857392836234e-06,
   4.095235857392682921e-06, 2.971916962622484122e-05,
   5.888910022446336173e-06, 8.082124643157337018e-06,
  -1.741260036617863142e-05,-9.838767630539702535e-06,
   7.303900309803156454e-06,-6.830303087305670829e-06,
  -1.794531132387962809e-05, 8.829824544634938256e-06,
   1.540437210286657916e-05, 3.691483875240993275e-05,
  -1.923406761029199113e-05,-5.481846692741109935e-06,
  -3.332423155560884771e-06,-9.428412162834293658e-06,
  -9.969394048391058393e-06, 7.817814962666748539e-07,
  -4.193005448829195735e-05, 4.291701912538739295e-05,
   3.160610430063054616e-05, 3.874344036011339633e-05,
  -9.292818923921884744e-06, 3.693713097575300401e-06,
   1.475246365082297622e-05,-1.350425178346238060e-05,
  -1.350425178346238060e-05,-1.475246365082297622e-05,
  -2.306430456443974861e-06, 9.730384296089628621e-06,
  -3.119908703558652424e-06, 9.500850997750621084e-06,
  -9.424701517532500019e-06,-3.342903125341893424e-06,
  -3.202993045150867736e-06, 9.473163967371998702e-06,
  -2.310874651889867560e-05, 1.913075624028722077e-05,
   1.913075624028726481e-05, 2.310874651889863833e-05,
   1.453101168096403731e-05, 1.374225962233601456e-05,
   5.598681396384239693e-06, 8.285817196980696072e-06,
  -9.991094516555904285e-06,-4.219364421883400943e-07,
  -9.343581156222031513e-06,-3.563353922513533611e-06,
  -1.997657731241098055e-05,-9.676563859485453326e-07,
   5.780861545327931291e-07, 9.983276836687316442e-06,
   1.462808292068897454e-06, 8.998811139200920274e-05,
   6.999075310632190544e-05,-1.137751998411270576e-06,
   6.607047539638565631e-06,-2.926340586481614519e-05,
  -2.926340586481614519e-05,-6.607047539638567325e-06,
  -3.639631767661304448e-05, 1.038041813203257490e-04,
   1.135613792767182736e-04, 3.877902960066615908e-05,
   4.016743243137496601e-06,-9.157825818321141601e-06,
  -1.371771450811488782e-05, 1.455418526314181612e-05,
  -1.693954216504122651e-05, 1.063258723165676353e-05,
   2.275766857204512372e-05, 1.954708472291839618e-05,
  -2.072865039977589321e-07,-2.999928386320681038e-05,
  -2.999928386320680699e-05, 2.072865039978103893e-07,
  -2.938454753670939105e-05,-6.045524465492304963e-06,
  -6.045524465492299033e-06, 2.938454753670939444e-05,
   7.529860765878772520e-06,-6.580364491916809585e-06,
  -7.211132195171494825e-06,-6.928172375436479742e-06,
  -1.056203864658639885e-05, 3.858034913823377252e-05,
   2.893526185367532939e-05, 7.921528984939801255e-06,
   3.100349573884016872e-06,-9.507251575493161857e-06,
   2.334150989673965411e-05,-3.248344063889176895e-05,
  -3.248344063889172152e-05,-2.334150989673971171e-05,
  -5.136337487682669328e-05, 1.409319116497841562e-04,
   1.315718907639655772e-04, 4.784179721535455410e-05,
   1.287798116886856968e-06, 2.997234685522878400e-05,
   2.997234685522877045e-05,-1.287798116887121242e-06,
  -9.999720401946818454e-06, 7.477889333608084228e-08,
  -9.893230287181466496e-06, 1.457393044032847706e-06,
   7.235786067838229519e-06,-6.902419864111295292e-06,
   9.974323005292725974e-06, 7.161568166877247567e-07,
   2.450937648807779295e-05, 1.730001341518726927e-05,
   1.153334227679151228e-05,-1.633958432538519756e-05,
  -9.881554542985703283e-06, 1.534561766107385671e-06,
   5.722205080883765204e-06,-8.200998049768578994e-06,
  -3.320316669132756753e-06,-1.972246174331894293e-05,
  -1.856467051672506665e-05, 7.439960255635716282e-06,
   1.016302957483951157e-06, 2.499979342480625503e-04,
   2.299980321783030477e-04,-9.514168950984931946e-07,
  -9.345081955504126460e-06, 3.559416138204577150e-06,
  -8.667879451968758938e-06,-4.986769074875813110e-06,
  -8.977751560909376564e-06,-4.404540488017935336e-06,
  -3.436124820021675924e-05, 2.047692902080536508e-05,
   1.311489986662655169e-05, 2.698146403530317852e-05,
  -7.892455197762028354e-06,-6.140777715511216872e-06,
   2.739686049659869058e-06, 1.981146436660599668e-05,
   1.981146436660600007e-05,-2.739686049659850000e-06,
   2.233702922531104596e-06,-9.747336623605241691e-06,
  -6.286496591896186664e-05, 3.078954465411533976e-05,
   2.199253189579659140e-05, 4.490354708497280351e-05,
   2.878729851368292929e-06,-9.576685984349757815e-06,
   3.543967033646801924e-05,-3.527080614959727817e-05,
  -2.820537043628851476e-05,-2.836295257112245573e-05,
  -1.443341840438987064e-05,-1.384472582479768000e-05,
   9.498104778057223777e-06, 3.128259200425463370e-06,
  -1.237002235285735481e-05,-1.571567838147018754e-05,
   9.518884143079506968e-06, 3.064448510030726798e-06,
  -1.560291860509346816e-05, 1.251195152655364820e-05,
  -2.738821035853027087e-06, 9.617632730228835240e-06,
  -7.253490950566320810e-06, 6.883812100141353188e-06,
  -1.494913829182817951e-05,-3.710152644207239211e-05,
  -3.710152644207236500e-05, 1.494913829182824219e-05,
   2.188170220108016225e-06,-4.995209616310242960e-05,
  -3.996167693048195045e-05,-1.750536176086344370e-06,
   1.022557543520983877e-05, 1.718829854926988245e-05,
   1.999510911499749482e-05, 4.422798654067698387e-07,
   6.364256825184462529e-05, 4.050303982496984267e-04,
   3.062425634254601226e-04,-4.811956303420700340e-05,
   2.937642439411851245e-05,-6.084873853798351302e-06,
  -4.056582569198939267e-06,-1.958428292941233486e-05,
  -2.516304887690964578e-06,-1.984107380441347651e-05,
  -1.198681226184913577e-05,-2.750120600626785743e-05,
  -1.833413733751192189e-05, 7.991208174566057760e-06,
  -1.909293710571064964e-05,-5.954809205791355326e-06,
  -1.436063748378876207e-05, 1.392020441872895896e-05,
   2.509316659997034592e-05, 1.644180616556869208e-05,
   7.597573026528514138e-07,-1.998556401108224237e-05,
  -5.920507606703040905e-06, 8.059006742705422107e-06,
  -1.390136261544776959e-05,-2.658480990027634524e-05,
  -1.768887097982943502e-05, 9.332943986703668530e-06,
  -6.860014681745620832e-06, 7.276001550730630498e-06,
  -4.186591475618220086e-06,-9.081434458073287246e-06,
  -1.674269799811761429e-05,-1.093992978696977090e-05,
   9.805665178735657096e-06, 1.961869109428817922e-06,
   4.206556045001610586e-05, 1.016390113294400518e-04,
   1.087194875111880353e-04,-5.079441933229112826e-05,
  -8.457536265490179139e-05, 8.512936057431563547e-05,
   1.033017396232088352e-04, 9.449206628505253626e-05,
  -1.141495408159492553e-04,-3.701192147819316994e-05,
  -5.178243959762386634e-05, 1.300714378690357570e-04,
   5.495151689304257525e-06,-8.354837395876510807e-06,
   1.936208642920648237e-05, 5.010948922902552537e-06,
   5.010999612709124800e-06,-1.936207331050652532e-05,
   1.881537405082854813e-06,-1.199852483307563733e-04,
  -1.197887042275900870e-04,-7.118029184749189906e-06,
  -1.999970555920272005e-05,-1.085243990812041398e-07,
   1.917107330104961385e-05,-5.698240823779102060e-06,
  -5.150052458810911154e-04, 7.623482268115467980e-04,
   2.134803185134300039e-03, 1.448797171478153874e-03,
   1.774356825480024496e-04,-2.258171556580470629e-04,
   4.508760672415057231e-05, 6.509659661419823205e-06,
  -2.354750828729874212e-05,-3.291587988394957141e-04,
  -2.285580067156748516e-06,-1.986897389792980365e-05,
  -6.420083975282179067e-09,-1.999999896956301847e-05,
   5.654354781993941703e-07, 1.999200547018716370e-05,
  -1.990024807089914893e-05,-1.995025492738056756e-06,
   1.995022019489508279e-06,-1.990024841909648388e-05,
   1.626035532818516304e-05,-3.796519469785466323e-04,
   1.845527632949247273e-05, 9.828226073713443030e-05,
   3.157641247869824179e-05,-6.247343575452776721e-05,
  -7.139821229088889811e-05,-3.608732854708371942e-05,
   7.239398344694727375e-04,-1.290856737236286940e-03,
  -1.508906861769443528e-03,-8.462269686703973110e-04,
   1.052591797022711839e-05,-1.700602983897328864e-05,
   1.139430620277085554e-02,-1.840902730068858309e-02,
  -2.150412473138172201e-02,-1.331002327335219226e-02,
   3.157775391068135348e-05,-5.101808951691986252e-05,
  -5.952110443640649837e-05,-3.684071289579491352e-05,
   2.129790642298064185e-05,-4.523714383112576869e-05,
   7.237943012980122177e-05, 3.407665027676904052e-05,
  -3.108114477929140257e-05, 3.903435452394433296e-05,
   1.950185848848095524e-05, 3.492388173578738132e-05,
   3.770776720563997781e-03,-5.059381674044034945e-03,
  -3.127034632134981619e-04,-2.330591000031631186e-04,
   1.195174871811093016e-05,-1.603607503658965367e-05,
  -9.136452315679365770e-06, 1.779115620423015660e-05,
  -7.958147973055987616e-04, 9.768719508663602918e-04,
   4.264123595051572883e-04, 3.473794750143486924e-04,
   6.524758698351897803e-06,-7.578095006548892820e-06,
   4.338426585331246489e-05,-5.493455630447109591e-05,
   3.139117503112634342e-05, 2.479100905903570439e-05,
  -3.650667622432772632e-05, 3.416522487928486015e-05,
   2.733217990342773837e-05, 2.920534097946231929e-05,
  -1.292384918693454906e-04,-1.104418952179702512e-04,
  -9.744697962723977605e-05, 1.140354601057421633e-04,
  -1.999977123139114104e-05, 9.565924952293106283e-08,
   9.565924952297026457e-08, 1.999977123139114104e-05,
  -6.357875346859653604e-05,-4.855674783069079234e-05,
  -1.419854093892001286e-03, 2.035563946732879415e-05,
   2.536607893333759920e-05, 1.769818228530700916e-03,
  -5.990099117102126123e-05, 3.445469014406200074e-06,
   4.593749591955052262e-06, 7.986800025471035771e-05,
   5.765874014547563710e-07,-1.999168694654064867e-05,
   9.271449213265928429e-05, 5.919478818766953288e-05,
   1.342955692515669652e-03, 9.413129171214840380e-04,
   1.532775155110573204e-04, 1.284756912367377899e-04,
  -4.427885584466853688e-05,-4.048929395639127681e-05,
  -3.034776395176360062e-05,-2.605788216889542278e-05,
  -3.780724423317057226e-05, 9.257760141358919548e-05,
  -2.156615286807787960e-05,-4.510987752666478182e-05,
  -1.456222747029568820e-06,-9.893402615431845209e-06,
  -9.999970942225366475e-06,-2.410714932023345488e-08,
   1.722699972127919363e-05,-3.610028366374767292e-05,
  -3.869898155890445605e-05, 4.585181377332387851e-05,
  -8.312885541093791559e-06,-1.819054518096348445e-05,
  -7.951889497622814391e-05,-8.760441870111320949e-06,
   3.881456724762298306e-05,-9.665886890490370825e-06,
   9.838185058302681188e-06, 1.791679312430068121e-06,
  -7.331908814226887347e-04, 1.169115533811188696e-03,
   4.416094562747903330e-06,-2.967318838299767979e-05,
  -1.974262831057090706e-06,-6.997215364896170451e-05,
  -4.964969896031300710e-05,-5.908247891743669313e-06,
  -9.898806436833209753e-05,-1.419024709478107793e-05,
  -7.797631815480080060e-06, 2.896889604507242778e-05,
   1.828944246922893052e-05, 8.092978077615512847e-06,
   5.322828335089828764e-06,-8.465665863661573016e-06,
   1.597418921475966439e-05,-1.203433749448036930e-05,
  -9.501880672850626707e-06,-1.759870062473101516e-05,
   2.833633715932270926e-05, 9.851497165060094682e-06,
  -2.995111040632012181e-05, 1.712012099379727868e-06,
   3.098440019355903616e-06, 9.507874076072621680e-06,
  -1.980854038418830825e-05,-1.183537989582420641e-04,
   1.378531011899816966e-04,-2.442380994653907392e-05,
  -3.285725962322166453e-05, 2.281228813714677615e-05,
   7.009760182801582490e-05, 2.085337531862910634e-04,
  -3.093563872575017795e-04, 2.029744458373678362e-04,
  -3.263803779702183450e-05,-6.192542683551058140e-05,
  -2.773095194246970991e-04, 1.385620093548138858e-04,
   2.999419441381617963e-05, 5.901707093701063092e-07,
  -4.242417024832898672e-06,-9.055489925310942974e-06,
   4.959073769821955896e-05,-3.377512005228679761e-05,
   1.102130695904135912e-05,-1.668924183162873989e-05,
   4.659272505132458283e-06,-2.963597779259048996e-05,
   1.945235540929498072e-05,-4.648211379710731485e-06,
   1.505906003338776546e-05, 1.316148589296904992e-05,
   2.087116730465327465e-04, 2.933247987029348166e-04,
  -8.404049929843640586e-05,-1.924504987722024834e-04,
  -2.914365796563195862e-05,-2.739794153549235175e-05,
  -2.797537442194376932e-05,-1.083413245036510840e-05,
  -9.473247533515866510e-06,-3.202745879512697120e-06,
   3.255571281119970040e-04,-5.396810479782260998e-05,
   5.784636587585592659e-05,-3.941824393547498350e-05,
  -5.755195875256791528e-05, 5.556772483863922234e-05,
   5.370178068109571668e-06, 8.435709070184613847e-06,
  -2.401237121305798653e-05, 1.798349322924509551e-05,
  -2.470550579683547041e-05, 5.467758209104101600e-05,
   1.837589932306433118e-05, 7.894702278655218092e-06,
   1.541941963964628078e-04, 4.271006670152908199e-05,
   2.873281628890482622e-05,-8.627008062361219285e-06,
   1.483536648334662743e-06, 5.998165652108191113e-05,
   4.717686447314683139e-05, 1.318117728371875452e-04,
  -5.703935617703292281e-05,-1.861482868332599167e-05,
   1.890438670741792331e-04,-3.411193578817244975e-04,
  -6.277097308035336587e-05, 4.959642062231461141e-05,
  -2.940335737560792534e-06, 9.557950917975194482e-06,
  -7.095330429618460911e-06,-2.914886423335444929e-05,
   1.756088280371581172e-05,-6.776145951168818478e-05,
   1.760163876231268776e-04, 3.765941168028458171e-05,
  -1.124853658922248889e-05, 3.838581019857368281e-05,
  -4.466372262028000041e-06,-2.966566228515700844e-05,
  -1.435134974098712938e-05,-1.392977963256665216e-05,
  -6.550410811775930818e-05,-2.468221666902912183e-05,
   9.990151683129326515e-06, 4.436996146812497649e-07,
  -6.295789017149364312e-06, 1.598760865190649552e-04,
  -1.159661439519558724e-04, 3.513571593932792326e-04,
  -1.999629521235105818e-05,-3.849386710974121782e-07,
   8.290907744175718500e-06,-5.591140203712219149e-06,
  -2.139316152907470163e-06,-9.768486392369557430e-06,
   2.674086058229723531e-05, 6.469100691222962637e-05,
   2.529787846123759208e-05,-1.612505334442187931e-05,
  -1.855469141668727637e-05,-7.464812551666085939e-06,
   5.746714510195006511e-05, 2.227050229200756577e-04,
   2.933149043734612415e-05,-6.297909869462472783e-06,
   4.886931225107285634e-04,-3.576355701987760674e-05,
   1.972305645001305732e-05, 3.316782216184590525e-06,
   2.583921588043265076e-06,-2.988851533995698636e-05,
  -1.526786880459650149e-04,-7.476107420685519037e-05,
  -5.379984111294591932e-05, 4.478366997267835677e-05,
   8.119942201267727855e-05, 8.835527072454218002e-05,
   3.672823757386904306e-05, 9.301094862819879927e-05,
   1.288648794067543855e-04, 1.396203525832915779e-04,
  -1.502401394317924269e-06, 9.886495337092491385e-06,
   1.082232993534900322e-04, 1.178461602134108123e-04,
   7.101977589687934597e-06,-7.040022323513638364e-06,
   4.104713072471430726e-04, 3.352809358237080514e-04,
   2.385249232438511836e-05,-3.211010136880836942e-05,
   8.129991718472267018e-05, 3.860470781857098583e-05,
  -2.932998235454111993e-05, 6.355904447899060562e-05,
  -5.831242378080483415e-05,-6.855407524580743638e-05,
   9.997033864489333666e-06, 2.435444769512930744e-07,
  -2.771769403230283643e-06,-9.608188922753155457e-06,
  -1.886656140816475894e-04,-1.131604431312910683e-04,
  -6.644754766849319616e-04, 8.586233682082308955e-05,
  -9.996075854620634180e-05,-7.735682560387719753e-04,
  -2.955922485715739535e-05, 5.123692598508260642e-06,
  -5.123733870967060909e-06,-2.955921770310413613e-05,
   1.406328190146779273e-04, 7.630471948696782697e-05,
  -1.168447857050386094e-04,-7.711871402936905384e-05,
   2.430244757254738892e-05, 1.758951511507880010e-05,
   3.311983228469598823e-05, 2.242937157910603779e-05,
  -7.660955024525757917e-06,-6.427267546336743956e-06,
   9.937560952199812704e-06,-1.115742945894605282e-06,
  -8.084162011556916518e-06, 2.889024618397877399e-05,
   3.324418398722308281e-05,-4.994821549388586853e-05,
  -1.546902193717442515e-05,-2.570426735597061078e-05,
  -6.283543899265550929e-06,-7.779272206704345561e-06,
  -1.999029426351455293e-05, 6.230050225296849725e-07,
  -1.789176694253263983e-05, 8.937822759156519275e-06,
  -1.890418136964974781e-03, 1.256669911883734727e-03,
  -2.986602079387221391e-05, 2.832102035589931586e-06,
  -1.706777113018144586e-05, 1.042550663746107032e-05,
  -9.978278778072327852e-06,-6.587508080233652041e-07,
  -1.998334576177902556e-05,-8.160221597409758666e-07,
   5.049735042641007770e-04,-1.913158644525702159e-04,
  -3.107935988986843386e-06,-9.504774268143373323e-06,
  -1.338180087472475435e-05, 1.486362692444935873e-05,
  -4.219640087855088743e-04, 4.405069526008221310e-04,
   6.978514340732842006e-06, 7.162425398996214338e-06,
  -9.858409972153156856e-03, 9.441093836042050921e-03,
   1.665823606092840499e-04, 1.864143694403370001e-04,
   6.762307296505816218e-05,-5.938956139560571957e-05,
   1.468959632810768854e-05,-2.615751822549771508e-05,
   3.998153656307120471e-05, 5.745847834789744328e-05,
   4.695610599624424134e-05,-8.829000005475975510e-05,
   4.667786145749090797e-04,-9.628175969390715587e-04,
  -9.890454838539382401e-06,-1.476110797607328374e-06,
  -3.127867724354137241e-06, 9.498233704165406305e-06,
  -2.927447572728533531e-05,-6.557825164837936170e-06,
   2.956760805189746118e-05,-5.075091535072882329e-06,
   4.161860227916952713e-06, 9.092794919235947266e-06,
   2.977309400170172801e-05, 6.335268639580985902e-05,
   1.837990963308270228e-05,-7.885361239646143444e-06,
  -7.924222098656578213e-06, 6.099729840834162337e-06,
  -4.389062499794080002e-07,-9.990363422004677922e-06,
   4.653243373362281029e-05, 5.229467096010836664e-05,
  -1.057776049636645994e-05,-1.697383229802596163e-05,
  -9.776537839727416704e-06,-2.102214990998300245e-06,
  -2.598223524449606948e-06, 2.988727546159061738e-05,
  -1.497370637606530512e-05, 1.325851112920984332e-05,
  -1.638206723335748207e-05,-1.147291912120691331e-05,
   1.291005057227515412e-06,-9.916315139315259099e-06,
   3.968273419533417147e-05, 5.027982376903904848e-06,
   1.689497866458881974e-06,-9.856246595902057379e-06,
   7.819736190061788570e-06, 2.896293710792878027e-05,
  -6.120848772373430792e-06, 7.907920732135261370e-06,
  -4.796617135407949659e-06,-1.941629377755474105e-05,
   2.015938597406027974e-06, 1.989814040485916134e-05,
  -1.637837897878248389e-06, 9.864962595989595730e-06,
   1.990992796903717530e-05,-1.895987412339885319e-06,
   5.310258952246479442e-05,-2.793053859145241087e-05,
   5.057890193376062083e-06, 8.626572134501066203e-06,
  -2.329527698665194741e-05, 1.890317619118978308e-05,
  -1.510976090664783368e-05,-2.591708172892806457e-05,
  -1.344680743148791210e-04,-3.554129105562263847e-04,
  -3.635692895916855399e-04, 6.868312504390802786e-05,
   5.214626919084706619e-06, 2.954331846788300716e-05,
   8.392977662998789925e-07, 2.998825735616332869e-05,
  -6.906473641728348658e-06, 7.231916885315509084e-06,
   1.209388132208308817e-05, 1.592915674376298800e-05,
  -1.439377063254176838e-04,-1.240239359872835981e-04,
   3.658518524560862190e-07,-9.993305380206013796e-06,
  -1.209490252683720677e-04,-1.047441324687483309e-04,
  -6.253354003145376514e-06, 7.803560963518239404e-06,
  -7.399956614965408309e-04,-2.533962568165144702e-06,
   1.470762161979650805e-06,-9.891251622665807403e-06,
   2.574281805595345607e-06, 9.662974344650863251e-06,
   1.244494778456752199e-05, 1.565641321118563267e-05,
   2.787403213214825485e-05,-5.313227204530187285e-05,
   2.656613602265093304e-05, 1.393701606607413251e-05,
   1.938684386880965246e-05, 4.914293927554354475e-06,
   4.914293927554316359e-06,-1.938684386880966263e-05,
  -2.554799459362600583e-05,-1.572577413814838011e-05,
   1.554462695881370131e-05, 1.258429865790391592e-05,
   3.705153131438907268e-05, 1.507262509514670143e-05,
   1.507262509514676920e-05,-3.705153131438904558e-05,
   4.503536610212372955e-06, 1.948635825392925822e-05,
   1.948590305150524861e-05,-4.505505772645124511e-06,
   5.775847685610869899e-06, 8.163307143102211061e-06,
  -4.091503340756615107e-06,-9.124669879649207309e-06,
   4.049181246262137287e-06, 9.143529473617888803e-06,
  -3.218665364823999247e-05,-7.323946563792120047e-05,
  -6.408453243318097757e-05, 2.816332194221011538e-05,
  -9.569626631337682784e-06,-2.902110634829868204e-06,
  -8.455470645169502206e-06, 2.878376306476755360e-05,
   9.148864221722111998e-06,-4.037113257327949114e-06,
   4.595076487568465197e-05,-3.858143604558474647e-05,
  -3.215727139047354073e-05,-3.828720278003385451e-05,
   1.179466694984308173e-05, 1.615196060985412795e-05,
   1.615196060985410763e-05,-1.179466694984310884e-05,
  -9.491620524154628633e-06, 3.147878623048642166e-06,
  -2.358674826600576767e-06,-1.986042932724166508e-05,
  -1.986042932724166169e-05, 2.358674826600610648e-06,
  -1.756564149762264977e-05, 9.562857249640255888e-06,
   1.156086480806972602e-05,-1.632012269836029795e-05,
   1.591665917526919325e-05,-1.211032454966913816e-05,
   4.735333910531167460e-07,-9.988782014217636811e-06,
  -1.834527297233252410e-05,-7.965611060716297975e-06,
   5.947768094955285163e-07,-1.999115405740464947e-05,
   1.742924827770922199e-05, 9.809245866730543231e-06,
   9.790142446163277990e-06,-1.743998597716845130e-05,
   1.910455843675977798e-05,-5.917418942109036623e-06,
  -1.400486500054762293e-06,-9.901446235937675511e-06,
   2.397700653246142514e-05, 1.803061723131801612e-05,
   1.803061723131806017e-05,-2.397700653246139126e-05,
  -1.986001567431586230e-05, 2.362155248058077970e-06,
   2.362155248058041548e-06, 1.986001567431586569e-05,
  -1.844909114469287650e-05, 7.722113437059506262e-06,
  -1.983040804353416732e-05, 2.599022282885529915e-06,
   2.599022282885520174e-06, 1.983040804353416732e-05,
  -9.371480841118333294e-06, 3.489318965722686675e-06,
   1.978401646395488303e-05, 2.931329485738887078e-06,
  -9.783510265940801060e-06,-2.069523345176606081e-06,
   5.692833380970301131e-06,-1.917267973175660085e-05,
  -8.642889352758708794e-06, 1.803608781404576693e-05,
   1.803608781404578387e-05, 8.642889352758673219e-06,
   1.999177255742778218e-05, 5.736113772211243878e-07,
   5.736113772210901888e-07,-1.999177255742778218e-05,
   1.724209950233688591e-06,-9.850233502182328843e-06,
  -1.969826439559925935e-05,-3.460979601365279141e-06,
  -9.774907447023053499e-06, 2.109783022524652353e-06,
   7.000327247650692375e-06, 7.141107646983015732e-06,
   1.990557496380644437e-05,-1.941155676467538772e-06,
   1.855406323311305675e-05, 7.466373787967109278e-06,
  -9.165660852431379533e-06, 3.998832471885624077e-06,
   1.342290047320189472e-05, 1.482652160442618406e-05,
   1.482652160442620947e-05,-1.342290047320186762e-05,
  -9.792521414444473567e-06,-2.026456105531632932e-06,
  -3.792967529191065596e-05,-1.270195781170061828e-05,
  -4.274996717438986254e-06, 2.969384453158408179e-05,
   5.817304549393548940e-07,-1.999153795178840309e-05,
   9.826337230599890756e-06,-1.855558306959522969e-06,
  -1.038114957713889749e-05,-1.709478673330173457e-05,
  -1.985181500366722197e-05, 2.249234183139170150e-05,
  -4.780194803417511481e-05, 1.466198363585302868e-05,
   1.174642531002041308e-05, 3.823638963652441805e-05,
   1.844562533132620397e-05,-7.730388485473234107e-06,
  -7.730388485473200225e-06,-1.844562533132621752e-05,
   9.489654447655063513e-06, 3.153800637976421325e-06,
   9.726213320108655883e-06,-1.747571956892594007e-05,
  -1.585376445925304652e-05, 3.672408137000195963e-05,
   3.672408137000193252e-05, 1.585376445925311428e-05,
  -6.769321008934188091e-06, 7.360454678754719278e-06,
  -1.664129658489658746e-05, 3.637399136709510393e-05,
   3.637914793018470863e-05, 1.663002092222790724e-05,
   2.858368768631209186e-06,-9.582782893424734993e-06,
  -1.442362689638123387e-05,-1.385492645790615145e-05,
   5.833363903743596620e-06, 2.942739991175743114e-05,
   2.830619740160965909e-05,-9.937765778136787469e-06,
   5.739559961267644613e-06, 8.188861425803551147e-06,
   2.325955152994918753e-06,-9.725735582785315179e-06,
  -9.983494244708582957e-06,-5.743193065452599839e-07,
   6.988929337693266952e-06, 7.152263048345633390e-06,
   3.401951807204440533e-05, 2.103978113350621885e-05,
   1.577983585012961840e-05,-2.551463855403332941e-05,
   6.274938094637629634e-06, 7.786215506166361731e-06,
   2.835251706209336619e-05,-9.804834330252832917e-06,
  -6.318800857546587185e-07,-3.999500878306225536e-05,
   4.749728287901811160e-05, 3.666071629292768632e-05,
   3.054520823187584065e-05,-3.958522772539454598e-05,
   6.218851953202521050e-05, 3.213390792317232544e-05,
   2.754334964843352490e-05,-5.330444531316442548e-05,
   1.777132447976387207e-05,-9.174967369693769892e-06,
  -1.999357535452343719e-05,-5.068969747326501485e-07,
   4.980666174395285635e-06, 2.958366043036653404e-05,
   5.918909099594070647e-07,-9.982467888789195963e-06,
   1.371856030642055529e-05,-1.455338802887844395e-05,
  -1.455338802887846767e-05,-1.371856030642053157e-05,
  -8.292360511978600049e-06,-5.588985340773226683e-06,
   6.245770637451267481e-06, 7.809631818744825461e-06,
   1.851000825283282195e-05,-2.360888803988999419e-05,
  -2.362563874261097984e-05,-1.848862336691510025e-05,
   3.242043901405670031e-05,-3.806461787718130413e-05,
  -3.045169430174508803e-05,-2.593635121124530807e-05,
   8.630715697786154879e-06,-5.050816423508943089e-06,
   1.868874421116504593e-05, 7.122558515705224988e-06,
   2.457582803504319908e-05,-1.720548390461555145e-05,
   3.571098872891211549e-03,-4.896003762257043410e-03,
  -4.524353000749852492e-03,-3.300034836877605710e-03,
   4.571126330839317918e-06, 7.986929825701179772e-05,
   7.987448424451635371e-05,-4.479594476345941104e-06,
   2.021880242910399669e-05,-2.216303292270393183e-05,
   4.891548770323726015e-06,-8.721969423676309465e-06,
   1.744393884735263587e-05, 9.783097540647419843e-06,
   4.688396727640530087e-06, 8.832832848200489407e-06,
   1.805108332734115865e-05,-2.396160242365660665e-05,
  -7.033095602220520350e-06,-1.872259507253271768e-05,
  -1.872259507253273123e-05, 7.033095602220485621e-06,
  -5.148240125937260457e-06,-8.572958859442258628e-06,
  -5.380495198404194946e-06,-1.926266522109413095e-05,
  -1.925346908577170118e-05, 5.413310277753664741e-06,
  -3.293370004072257884e-05,-3.762142211065006757e-05,
  -3.009713768852010420e-05, 2.634696003257800954e-05,
  -4.542624654960119677e-06,-1.947728321004108844e-05,
  -1.947728321004114604e-05, 4.542624654959880814e-06,
  -1.747860164009260172e-05,-9.721033109034874368e-06,
  -1.877858087694046297e-05, 2.339583083047503125e-05,
  -6.708777204661951100e-06, 1.884123956692362238e-05,
   1.882985246420582843e-05, 6.740671789684000015e-06,
  -3.995738095093598449e-04,-2.659713720575540281e-04,
  -2.493481613039561797e-04, 3.746004464150253324e-04,
  -1.983712492313524498e-05, 2.547248473142453487e-06,
   2.580201923631057516e-06, 1.983286560316714940e-05,
  -4.200910622615825136e-05, 2.711521702069434036e-05,
   2.711521702069426244e-05, 4.200910622615830557e-05,
   9.293192492505419157e-06,-3.692773117487849714e-06,
   1.686653262015314563e-05, 3.627009894352798899e-05,
   3.627009894352798899e-05,-1.686653262015314224e-05,
  -1.160034743697366548e-05,-1.629208210578066626e-05,
  -3.552484561325733381e-06, 9.347719157181731152e-06,
   1.270388403787113955e-05,-4.835919075369565128e-05,
  -3.868735260295654135e-05,-1.016310723029684557e-05,
   1.194723273477378417e-05, 4.855165939472254322e-05,
   3.884132751577805762e-05,-9.557786187818956527e-06,
   1.926294002367041119e-05, 5.379511283051334719e-06,
   7.660081333794928229e-06,-1.847493312463259238e-05,
  -8.264424349918186405e-06,-5.630212266378540006e-06,
  -3.083775135626751662e-04,-1.174874849884109446e-04,
  -1.331521573124781635e-04, 3.452108095107003717e-04,
   2.177422703787001927e-05, 5.590959700179648500e-05,
   1.696402221884673949e-05,-2.474311924876235406e-05,
   1.568657572158518908e-03, 1.158366704161398327e-03,
   2.965195667388366581e-04,-4.392905035861947752e-04,
   3.124990168997658250e-05, 5.121956310206871575e-05,
  -4.517352851055035443e-06, 8.921520230267089769e-06,
   5.831130519370179041e-06, 8.123910195593601620e-06,
   1.408959930845081231e-05,-1.419447749398696511e-05,
   4.896444557834696580e-05,-1.012339217876591062e-05,
  -8.098713743012796599e-06,-3.917155646267756044e-05,
  -4.875389070707379553e-06,-8.731012622212103161e-06,
  -1.776490558179201707e-05, 9.187389709270793209e-06,
   4.151599759584753283e-06, 2.971134832746935038e-05,
  -4.519715608950488683e-06,-8.920323470267729930e-06,
  -1.777620756856076935e-04,-1.897383578719502595e-04,
   1.211737357694982930e-04,-1.192347506378229130e-04,
  -4.797711289116593156e-03,-5.152044874249758245e-03,
   3.812925535339657581e-03,-3.550450515350803832e-03,
  -9.813787665568973122e-05, 8.525817946398237381e-05,
  -5.902489347506460722e-05,-6.794160691547762403e-05,
  -3.041809147892367840e-05,-2.597575236215172664e-05,
  -1.020119872798118110e-01,-1.194868467707785459e-01,
   9.636658098323619415e-02,-8.227336245469353548e-02,
  -2.190566488678423376e-03, 1.743966300901219095e-03,
  -1.407620376507540691e-03,-1.768107710418335586e-03,
   1.720183563215300197e-05,-1.020278642746143979e-05,
  -2.488715802288578630e-04, 1.675199586747536020e-04,
  -7.024876839799046270e-04,-6.543019592333113076e-04,
   4.089415598044948875e-05,-4.390521616672292290e-05,
  -1.412818379726244478e-05, 1.415607369967997123e-05,
  -1.916073563742464619e-05, 2.308389503166060486e-05,
   6.068136282647711459e-04, 7.567543990966581723e-04,
  -6.538856954261475403e-04, 5.112078807266800216e-04,
   1.614408088045004579e-05,-1.180545011956288546e-05,
   4.047203300555711724e-05, 1.129690866759446559e-04,
  -3.305825717555088239e-05, 6.170212016223702617e-05,
  -1.625761857783713276e-05,-1.164859812069954388e-05,
   3.995909621418364184e-06,-9.166935491070948700e-06,
   1.302907294490415898e-05, 1.517376875388466401e-05,
   9.713868133710823530e-08, 9.999528192699298887e-06,
   3.953296124315788109e-06, 9.185393282460462520e-06,
   4.381221115076238852e-05, 2.409336327873326159e-05,
  -1.927469062298666755e-05, 3.504976892060987829e-05,
   9.952918068771057409e-06, 9.692378017445561280e-07,
  -9.009052778445777638e-06, 4.340157604877779732e-06,
   1.596921985588927793e-05,-1.204093091061781894e-05,
  -9.623296796956254951e-06, 2.718852470747813291e-06,
   4.715142257099598630e-06,-8.818584551690464957e-06,
  -2.844359043528371115e-06, 9.586950590855174189e-06,
   9.909095428559126697e-04, 6.030740235469327342e-04,
  -4.887015594283281202e-04, 8.029762050100364579e-04,
   8.161179211222803517e-06, 2.886858420294117570e-05,
   2.886858420294098596e-05,-8.161179211223469284e-06,
  -2.185312049485013229e-06,-9.758299608352657593e-06,
   5.897611071840345313e-07,-1.999130265481599599e-05,
  -1.999130255188295982e-05,-5.897645963245842472e-07,
   2.037599412352633123e-05, 2.201860266860775241e-05,
   1.478126867214361455e-05,-1.347271674317788798e-05,
   3.176483194738644724e-06, 9.482085979020806821e-06,
  -4.158856286404323699e-06,-9.094169252275617697e-06,
  -3.822892954482295735e-05,-5.863914175580131670e-05,
   4.188239403867452244e-05,-2.731053037912667617e-05,
   6.677062608274901029e-06,-7.444248445959953552e-06,
  -9.030180577172464617e-04, 5.551201558550830552e-04,
  -5.079431789479984128e-04,-8.263738421321198272e-04,
  -7.767014034097321763e-06, 6.298689783926118121e-06,
   4.643697149861998152e-06,-8.856414442671681992e-06,
   6.920032882190487842e-06,-7.218943475980570107e-06,
   1.685275934059209734e-05, 1.076961014188006175e-05,
   8.400932187704464893e-06,-1.815005064394011920e-05,
  -2.997018643709708928e-07,-9.995507930690295453e-06,
   8.741866709056837122e-06, 4.855900167948656396e-06,
  -1.542479449332063028e-05, 1.273089607367940428e-05,
   3.198698003565501012e-04, 2.051421722120071417e-04,
  -1.619517901487414616e-04, 2.525304291914501169e-04,
  -5.488386970116652319e-06, 8.359282772239120290e-06,
   1.751238875271459775e-05, 9.660033135232785269e-06,
   8.133206980273996337e-06, 1.827158844260734624e-05,
  -1.237997119926411025e-05, 2.732647641217929104e-05,
  -8.742913025871270347e-05,-2.135760244514930115e-05,
  -1.893353157850307834e-05, 7.772722420082829554e-05,
  -8.219110577615156346e-06,-5.696158469787746357e-06,
  -1.045659090853726667e-05, 1.704874501456033511e-05,
  -9.626005812413617355e-06,-2.709245669809085662e-06,
  -1.999462910574513740e-05,-4.634726784714514250e-07,
  -4.634726784714121968e-07, 1.999462910574513740e-05,
  -3.398416429984038544e-06, 9.404826727187191960e-06,
  -2.435463729641561907e-05, 1.751718134175819417e-05,
  -1.028566180674610091e-07,-9.999471011814561641e-06,
   9.932331975684068274e-06, 1.161370537254939730e-06,
   7.779418629748165704e-06,-6.283362617510402653e-06,
  -6.856518370837157237e-06,-2.920596096399453477e-05,
  -2.920596096399457204e-05, 6.856518370836999689e-06,
  -6.499618683851281350e-06, 7.599668214108518847e-06,
   1.053056947592294059e-06, 3.998613598567793160e-05,
   1.473286950533590174e-05, 1.352562590561869403e-05,
   8.594517349626893088e-06,-5.112168965024762923e-06,
  -1.866655986963755253e-05, 2.348530482308536872e-05,
   2.348530482308553474e-05, 1.866655986963734585e-05,
   7.774181400338056261e-06,-6.289841298048610370e-06,
  -8.476108220253359205e-06,-5.306184075072541652e-06,
  -1.515211441033013927e-05,-1.305424945740910128e-05,
  -1.256291973384457394e-06, 9.920772675432584846e-06,
  -2.999922663506076362e-05, 2.154096057765601677e-07,
   1.436064038512165241e-07, 1.999948442337384354e-05,
   1.958013212089586651e-06,-9.806435859234620070e-06,
   5.705592578095482663e-06,-8.212564357908055878e-06,
   9.005397427321400175e-06,-4.347737017805139358e-06,
  -3.751197731524326715e-05, 1.388710041371757763e-05,
   7.221599529827046264e-06, 1.865069704410003785e-05,
   2.706378140924307874e-05, 1.294417768082271041e-05,
   1.294417768082265790e-05,-2.706378140924310246e-05,
  -4.743333190099431803e-06, 9.988744060314941168e-05,
   1.098062091193400885e-04, 6.526594735369568491e-06,
  -1.069742864009521580e-05,-1.689866919287050649e-05,
   2.883485766236212331e-06, 9.575255079417632808e-06,
  -1.557830484161849973e-05,-3.684177544936733826e-05,
  -3.687360746885746758e-05, 1.550280852725141140e-05,
   1.908619935665202574e-05, 5.976369643699745103e-06,
   4.549079765567140508e-07, 1.999482579901273055e-05,
   6.022110980441109274e-06,-7.983368921655233243e-06,
   7.473670185786414891e-06, 6.644114233973349182e-06,
  -9.569703106542264649e-06,-2.901858448070020138e-06,
  -5.905584810258976515e-06, 1.910821990790451575e-05,
  -1.985775550475633373e-05, 2.381080912803999607e-06,
  -1.720769412483450774e-05,-1.019290257513216846e-05,
  -1.377681118456927547e-04, 1.483617183561336495e-03,
   1.672695125015331939e-03, 1.564960662443088128e-04,
  -9.481881061314544439e-06,-1.760948413608657076e-05,
  -3.990277173566943370e-05, 2.787258117049973658e-06,
  -5.194810998940768248e-06,-8.544819406241657020e-06,
  -1.761708066740922250e-05, 9.467759437057762922e-06,
  -1.284139595839243157e-05,-1.533292372118842179e-05,
   6.769972864530131040e-06, 7.359855121775543980e-06,
  -1.387690160138821410e-05, 1.440248596407541312e-05,
   1.440248596407543683e-05, 1.387690160138819038e-05,
   5.791076799308685628e-05,-3.932356736679501442e-05,
  -2.939446879156781735e-05,-4.044706669786507307e-05,
   3.081866665390516255e-06, 9.513259055484337947e-06,
   2.871971551576302689e-05,-8.670521362273460799e-06,
   4.302247093049186585e-07,-9.990741048566092179e-06,
  -1.998234537721617536e-05,-8.401626185729900960e-07,
   7.081467871756807747e-06, 7.060652433116653949e-06,
  -8.234939405993096400e-06, 2.884763028360600083e-05,
   1.923175352240405250e-05, 5.489959603995228193e-06,
   2.816422962557770257e-06, 1.980070104051817110e-05,
  -1.998894185462637383e-05, 6.649838587259088059e-07,
  -2.186915793907561270e-06, 2.992018381144002524e-05,
   8.646335582005756673e-06,-5.024030354540185399e-06,
  -1.120517448904977418e-05,-1.656635339083252075e-05,
  -2.878144107218017848e-06,-1.979182372845125730e-05,
   6.233370361538813603e-05, 6.491925287300331861e-05,
   5.804909768360602896e-05,-5.504818124260933221e-05,
  -8.940747154682355724e-06, 4.479178531387130032e-06,
   8.923670062283242557e-06, 1.789882992319637259e-05,
  -1.764178498070187898e-05, 9.421646495951843455e-06,
   9.421646495951811268e-06, 1.764178498070189592e-05,
  -4.207102456495632370e-06,-9.071950667885514931e-06,
  -7.737953834884954082e-06, 1.844245294013757932e-05,
   9.882261435402068958e-06,-1.738795298252112105e-05,
  -2.599196451118307181e-05,-1.498058012392710401e-05,
   1.343810583243437301e-05, 1.481274153005760603e-05,
   1.842120641510273154e-05,-7.788398693709637496e-06,
  -7.788398693709800127e-06,-1.842120641510266378e-05,
   1.800775846831200024e-06, 9.836524098962468008e-06,
  -1.585488835539518049e-05,-2.546806854156699482e-05,
   4.197818183407927786e-05,-2.716306775577782617e-05,
   1.989067944399556701e-05,-3.470390282455580689e-05,
  -2.481413602964633471e-05,-1.685997191878467304e-05,
   1.528724730848590640e-05,-1.289573843287736998e-05,
  -2.604896081983400582e-05,-3.035542192437379252e-05,
  -9.853338414892243301e-06,-1.706376887328476195e-06,
  -1.428109950005171627e-05, 2.638276325689981047e-05,
   3.611924688272016874e-06,-9.324912870705607840e-06,
  -6.545366426822707873e-05, 8.840711415865928728e-05,
   1.038640345720962237e-04, 7.818095882250611979e-05,
   4.146738622411186385e-06, 2.971202717414958431e-05,
   2.971202717414957753e-05,-4.146738622411237207e-06,
  -9.983573883517080400e-06,-5.729332529673186933e-07,
   1.938442118968407478e-05, 4.923841502417307053e-06,
   4.923841502417274019e-06,-1.938442118968408155e-05,
   4.636098968487906255e-06, 8.860394255019659557e-06,
   1.999589646230797560e-05, 4.051230290411516598e-07,
  -2.897719649086279275e-05,-7.766729268484198314e-06,
  -7.766729268483942510e-06, 2.897719649086286052e-05,
   5.463120101359723261e-06,-8.375817497899493689e-06,
  -1.668023651447816120e-05,-1.103493134645927397e-05,
   9.466521385125517454e-06,-3.222572398715234092e-06,
  -1.246854051789843307e-05,-1.563763081011715033e-05,
   1.999760109291009446e-05, 3.097588236694373039e-07,
   4.631062110300594964e-05,-3.814874012406989525e-05,
  -1.871054387272947807e-05,-2.345027820702060323e-05,
   2.255508747234804640e-05, 1.978049617968993923e-05,
   3.769507399136683677e-05,-4.668063192358668022e-05,
   4.180555834060668998e-05,-2.742800196569430279e-05,
  -4.992127271557204063e-05,-4.907001661358473764e-05,
  -1.667460000775540171e-04,-9.108112569647105821e-05,
  -8.692918010816780793e-05, 1.576176311385300887e-04,
  -8.419259969475769895e-06,-5.395930092799837728e-06,
  -8.127847054803904715e-06,-5.825641788997630468e-06,
   1.434735067266496941e-06, 9.896541582126345437e-06,
  -1.919955031088842523e-05, 5.601541561004813644e-06,
   5.601541561004846678e-06, 1.919955031088841507e-05,
   9.982202893486764552e-06, 5.963433518238216350e-07,
  -1.538334791026553985e-05, 1.278094703344509097e-05,
   1.967643936597575713e-05, 2.264592091033348887e-05,
  -1.676624864113346299e-06,-9.858444556066485074e-06,
  -1.999554955385666614e-05, 4.218981384915196747e-07,
   1.995977361250517499e-05,-1.267847521408692624e-06,
  -1.933368552614188932e-06,-2.993763661413109225e-05,
  -1.598060339924046969e-04, 7.876007847786592746e-06,
   8.368287972899605723e-06, 1.697939096563908813e-04,
  -4.475714069709796124e-06, 1.949276746812011446e-05,
  -1.753339433001346623e-05,-2.434296784018439476e-05,
   5.240581607620146514e-05, 2.921695469051051748e-05,
  -8.038165770653687189e-06, 5.948772229922022114e-06,
   9.018351000780408262e-05, 6.298360518954358299e-05,
  -2.969620149309262197e-05, 4.258593298454729021e-06,
   5.495502968232700866e-05, 5.813729192708031726e-05,
   7.146172438597386551e-05,-9.640135864075313667e-05,
  -4.508316859005664911e-06, 3.974512648236014161e-05,
   9.532353341734032268e-05,-2.526131904252689798e-04,
  -2.621056817701937383e-04,-9.849168281526062116e-05,
   7.567373932334366734e-06, 6.537189898436966776e-06,
   5.759855106446682080e-06,-8.174599020914732786e-06,
   1.312432409337671696e-05, 1.509145841501116969e-05,
   8.840118680318492296e-06,-4.674644555245249121e-06,
   1.747613026551089623e-06,-1.992349991114585750e-05,
   8.136780071599683219e-06, 5.813158355525701163e-06,
  -7.367802323975491484e-06,-6.761323015122215117e-06,
  -6.523410555475980365e-05,-6.200412464078868197e-05,
   5.511477745847892404e-05,-5.798587160423084171e-05,
   7.408726409240521231e-06, 6.716455389044288647e-06,
  -3.092421051631510465e-05,-2.537110963167804560e-05,
   5.672126308450134240e-05, 1.956267655763867502e-05,
   1.956267655763817696e-05,-5.672126308450151181e-05,
   1.793839605642341583e-05,-8.843864931289537133e-06,
   1.998753840939292625e-05,-7.059095785173275998e-07,
  -8.698607743597916171e-06, 4.932973071385893252e-06,
  -3.323827433197913626e-06, 9.431445869765726548e-06,
   5.102055542560852400e-05,-7.414110144894267822e-05,
  -6.569479621250193409e-05,-4.565297088468441158e-05,
   5.202884328032788414e-02, 2.878352075252574305e-02,
   1.888828157456371674e-03,-3.423511091204462561e-03,
  -4.024989772054212854e-04,-1.199773868218081122e-04,
   3.255583760429386930e-05, 2.324042680078929505e-05,
   6.471783036576300361e-05, 2.667587735667418684e-05,
  -2.233232502574293437e-06, 9.747444413252417630e-06,
   3.478490211542855271e-05, 6.074545731838762864e-05,
  -8.310954818693133762e-06, 5.561297510621185253e-06,
  -2.046224117028726402e-05, 8.764300705868667107e-05,
   1.757386854917875095e-04, 3.893474568580875184e-05,
   1.998276222818375121e-05, 8.301889735914168579e-07,
   2.955935420367729628e-05, 5.122946326240926900e-06,
   3.624737687648769361e-04, 7.424800978737750360e-05,
   8.260553928305771677e-05,-4.015922370760610259e-04,
  -9.536220767127006568e-06,-3.010065361518855339e-06,
   9.998001786324441729e-06,-1.999006769705546771e-07,
  -6.736806064796235111e-06,-7.390226251294657803e-06,
   4.041166860723269588e-06, 9.147074417746476482e-06,
  -1.823999361513155786e-06,-9.832244216311941009e-06,
  -1.375045593400233138e-05,-1.452325588864494741e-05,
  -4.974820007511986146e-06,-8.674742987135610303e-06,
  -1.261568193868984533e-05, 1.551916780055602428e-05,
  -4.175532794242073288e-05,-1.544554712155606958e-04,
  -1.641929800766281334e-04, 4.405298279976056428e-05,
   7.722500102191246331e-04, 3.041873135365146560e-04,
   3.408363874565690675e-04,-8.652921801250463164e-04,
   8.039832665621645161e-05, 4.044884511182385430e-05,
   3.595452898828826050e-05,-7.146517924996997743e-05,
  -9.798416203001669163e-06,-1.997758722357220621e-06,
  -1.782655753523548856e-04, 9.067185144406110292e-05,
   9.957102600520809088e-05, 1.961774981496863118e-04,
   9.425893825994434235e-06, 3.339539725932304561e-06,
   6.565999097133686269e-06,-1.889147045246715673e-05,
  -4.927041013964772920e-05, 9.834849609765723157e-05,
   1.190841293234331475e-04, 5.214374500627901791e-05,
   6.450344536330478035e-06, 7.641534882641808435e-06,
  -1.932993117454440688e-04,-5.133591412196366000e-05,
  -3.817121563543569997e-05, 3.680257576541525930e-04,
   4.347154597964953498e-06, 4.981066398775860752e-05,
   2.992053797372309305e-05, 2.182064930975805972e-06,
  -3.292398367534627254e-05, 5.490136713224413184e-04,
   6.288660218071860002e-04, 3.778262320702376579e-05,
   2.556439847055709541e-05, 1.569909331262726480e-05,
   1.565286992380936787e-05,-2.559272676266255433e-05,
   1.384251273947705380e-05,-1.443554089937109141e-05,
   6.547615642906728008e-06, 7.558354939585937202e-06,
  -1.917404512828152320e-05, 5.688232890680871873e-06,
   3.123278265788757562e-06, 9.499743832043661631e-06,
   9.876557235630649488e-06, 1.566402621075398455e-06,
   9.997351900790143455e-06, 2.301194728129924557e-07,
  -2.765592482571473354e-05, 1.162539556464275582e-05,
   2.059026607484464982e-05, 2.181836251800536760e-05,
   9.094000535381265219e-06,-4.159225199780034715e-06,
  -3.967881551003876620e-05, 5.058814062634391399e-06,
   1.602083819169126373e-06, 1.993572991982878382e-05,
  -9.913560863627498372e-06, 1.311987424921909611e-06,
   1.890153529381109526e-04,-6.636062057829788348e-04,
  -6.790684560333123395e-07, 7.999711786078309060e-05,
   7.999300544122413617e-05, 1.057866002992284260e-06,
  -9.868882936375490984e-06,-1.614047579260502266e-06,
  -7.935886877124161403e-05,-1.010791508417305678e-05,
  -2.451897884104177822e-05, 7.614998146153777929e-05,
  -3.658975199158024545e-06,-9.306551482259500343e-06,
   2.952599589972722727e-05, 1.059632746102596231e-04,
  -1.196865122042394284e-03, 8.668263746820549520e-05,
  -2.404369728217952944e-05, 1.794158914374400620e-05,
  -4.983867162519832017e-05,-4.013329121272267987e-06,
  -1.184984832395724516e-05, 4.998595613716908448e-04,
   3.698960754150512490e-04, 8.768887759728620471e-06,
  -1.722531499216656503e-05, 1.016309615327149107e-05,
  -7.970917330226432243e-04, 6.815254321710510798e-05,
   8.668465445977352360e-05, 1.016309879259859328e-03,
  -1.155442889173547252e-05, 1.632467987391570858e-05,
   7.779214547983063188e-07,-9.969695993868844675e-06,
   6.405382800797622954e-06,-7.679262410885957622e-06,
   3.645522732759356520e-06, 9.311829251276827155e-06,
  -6.392139102747191408e-06, 7.690289831412749777e-06,
   1.842635314488571922e-06,-9.828768747803542940e-06,
  -7.755701518111422869e-06,-6.312613877148213580e-06,
   1.723756066879722485e-05,-1.014231246755566196e-05,
  -1.645941095745566662e-05,-2.508162257378075617e-05,
   8.643165463186958247e-06,-5.029482157834162544e-06,
   5.388107424091146632e-06,-8.424268418471356432e-06,
  -1.567716047263122863e-05,-1.241880185506512843e-05,
   4.246037752335792051e-06,-1.954408256751232763e-05,
   1.999803373573010162e-05, 2.804401979047772629e-07,
  -6.454635024705184570e-06,-2.929740068159373653e-05,
  -2.929682151888904742e-05, 6.457263266304048765e-06,
   1.305227007687705416e-05, 1.515381951325341323e-05,
   4.099787705946331178e-05,-2.862121724555285191e-05,
  -1.161553859537383580e-05,-1.628125496205316759e-05,
   1.511089607475021409e-05, 1.310193954413233636e-05,
   2.149148185807267714e-05,-2.093122565795259339e-05,
  -1.312671345859894837e-05, 2.697571859609744016e-05,
  -1.494473839045563719e-06, 3.997207209970992650e-05,
   3.992636455639059234e-05, 2.425987079561102549e-06,
   1.541925009973288451e-05,-1.273761070067253747e-05,
  -2.671505858970348019e-05,-6.470166647427800404e-05,
  -2.772928563183332866e-05, 1.144931082415887976e-05,
   1.754092052768651817e-05, 9.608127134951212841e-06,
   9.302819727135295924e-07,-1.997835267110990672e-05,
  -1.997835267110990672e-05,-9.302819727135258866e-07,
  -3.211360953430786128e-06,-9.470330555306933156e-06,
  -6.236514261045209668e-05, 9.479507313078976236e-04,
   1.068570813679539785e-03, 5.528486368117515681e-05,
   2.668950487583685163e-06, 9.637256004425057336e-06,
   1.914993139865294551e-05, 5.768893085062858478e-06,
  -2.629065584220812227e-03, 5.693102439493594744e-04,
   3.703841627373556243e-04, 1.546258572164871913e-03,
   8.391908681603763929e-06, 3.910979249087910754e-05,
  -9.238628748015549448e-06, 1.773831273983917482e-05,
  -2.867445976306742415e-04,-1.206390291626065203e-03,
  -1.809828373470656398e-03, 4.290935312732626532e-04,
   2.996084128803703164e-05, 1.532315017565134111e-06,
  -8.006590015077731808e-06, 2.891184041756002883e-05,
   1.718402920003273546e-05, 1.023274843101414239e-05,
  -1.709965906847557270e-05,-1.037312198626340159e-05,
  -1.924416676736994392e-05, 5.446287306932518227e-06,
   5.446287306932551261e-06, 1.924416676736993715e-05,
   9.841077837240013208e-06,-1.741129481116736056e-05,
  -1.719080877030719520e-05,-1.022135479389739742e-05,
  -3.721831393005725120e-05,-1.465595811278494081e-05,
  -1.465595811278487644e-05, 3.721831393005727831e-05,
   7.036102527691955424e-06,-2.916321760745557557e-05,
  -1.962013248377130373e-05,-3.879484671868438169e-06,
  -2.876491942239135804e-05,-6.381676433840352341e-05,
  -6.372147057974478993e-05, 2.897540659170667313e-05,
  -3.435758180481212162e-05, 2.048308015230237427e-05,
   1.497632697169488442e-05, 2.599441537016911622e-05,
   4.092405401518403889e-05, 2.872667406718535518e-05,
   4.584185057030992837e-05,-6.556313549769700170e-05,
   3.123363800972774146e-06,-9.499715709786947811e-06,
   2.280248395049291530e-04, 2.913840636835708956e-04,
   3.305452274121579667e-04,-2.591135902168097225e-04,
   5.878931271393822916e-05, 1.199236051087445887e-05,
   1.292051086277589829e-05,-5.859232372115727932e-05,
   5.649010611635199421e-06, 8.251586460168306635e-06,
  -1.582862994278423047e-05,-2.548439667981948725e-05,
  -1.698959778654638469e-05, 1.055241996185606217e-05,
  -1.959083584083517459e-05,-4.024816897381549145e-06,
  -3.177472764823086515e-05, 2.429746247822502905e-05,
   1.822309685866864304e-05, 2.383104573617324712e-05,
   9.412589770989626120e-06,-1.764661876403129833e-05,
   9.554964410982841406e-06, 2.950026288840715552e-06,
  -6.912569803897624893e-06, 1.876742866527651834e-05,
   9.976901087245761059e-06,-6.792972069089917438e-07,
   2.432958705039286594e-05,-3.175013691241907078e-05,
   8.892600002497952883e-06,-4.574020681585669616e-06,
  -6.230783043046108879e-05, 6.494408569722810232e-05,
   7.175795889401837121e-05, 6.964765132697850903e-05,
  -7.512028012171975092e-05,-4.132274718776988141e-04,
  -3.499186506882873290e-04, 1.202370072003140154e-04,
  -1.990995129518777703e-05, 1.895742446444293066e-06,
   1.765225586241571604e-03,-7.028361328774295229e-04,
  -1.558686986945941088e-03,-3.889292336238738598e-03,
  -9.659869188533805326e-06, 2.585909368175004825e-06,
   8.796598040180421689e-06,-4.756034369040450401e-06,
   1.420663396184880273e-05, 3.739213221352915049e-05,
   1.884178371537470288e-05,-6.707248796864530428e-06,
  -1.929654511761087413e-05, 5.257694031037559687e-06,
   9.459022933441260601e-06, 3.244516164951610388e-06,
  -2.997856620274524204e-05,-1.133829099829760936e-06,
  -1.235220672135969530e-05, 2.733903782346402327e-05,
   9.340008634666620987e-06,-2.850902030418360464e-05,
  -5.164407250951748974e-06,-1.932172087952615744e-05,
  -2.659006742573902826e-05, 1.389130354915089759e-05,
   1.731855792540762468e-05,-2.449627627588121497e-05,
  -1.633085085058749697e-05,-1.154570528360505602e-05,
   7.557845855365071077e-06,-1.851699127899943348e-05,
   9.552787854609518924e-05, 2.632003503426286607e-04,
  -1.974002627569714278e-04, 7.164590890957172058e-05,
  -5.959661216509659181e-05,-3.671843976046722089e-05,
  -4.189204781582957481e-05, 6.815465009664600164e-05,
  -1.657474635025091985e-07, 9.998626294563793768e-06,
  -1.163722287193480026e-04, 2.928317576513441516e-05,
   3.481392906687630882e-05, 1.356023242534083512e-04,
   1.387336965702423654e-04,-1.440588818364071954e-04,
  -1.585366401863578384e-04,-1.525324021918664631e-04,
   6.879436776692912910e-06, 7.257640776139657396e-06,
   3.573911307789142219e-05,-9.339548059946847542e-05,
  -9.310034421748681623e-05,-3.650103980142851891e-05,
  -2.869901641419348481e-05,-8.738790354382746696e-06,
  -1.441972595880376959e-05, 4.787558358153977341e-05,
  -6.042799027745749773e-06,-7.967721124027562387e-06,
   2.879239719755529500e-03, 3.890447099779419538e-03,
   4.541168828727635935e-03,-3.361589753225765944e-03,
  -4.272157263250900332e-05, 5.545148538862829264e-05,
   4.720094510572673424e-05, 3.704147379797639763e-05,
   1.544836024463895122e-05, 2.571669041210122058e-05,
  -1.714454295910502828e-05, 1.029876918487846507e-05,
   1.391334665469942252e-05, 1.436728174938336905e-05,
  -1.436700977288428050e-05, 1.391362749917675712e-05,
  -9.964739483517420917e-06, 8.390274284127921931e-07,
   5.142487338917432309e-06, 5.977921732482848708e-05,
  -6.879463895929881189e-06, 7.257615070021093249e-06,
   4.696150349242257587e-06, 8.828712924164645141e-06,
   2.376143388755177404e-05, 1.831377240241633485e-05,
   1.831377240241612478e-05,-2.376143388755193667e-05,
  -9.739691224018738524e-06,-2.266807195323941818e-06,
   1.811095427915151616e-05,-2.391638214903089106e-05,
  -1.601379658029306808e-05,-1.198158249502101606e-05,
   1.943370906192560087e-05, 4.725563680285226996e-06,
   6.572931711454308386e-06,-1.888905949793579189e-05,
  -8.136507070660396401e-06, 5.813540460777185053e-06,
   1.628346513461554983e-05, 3.653558215233144242e-05,
  -2.206853130874728569e-05,-3.336135377760982219e-05,
  -3.917145645393998847e-05,-8.099197446480951816e-06,
  -8.099197446480885747e-06, 3.917145645394000202e-05,
  -9.425699509085248826e-06,-3.340088137224844113e-06,
   9.366027090991056075e-06,-3.503931581926453854e-06,
   9.828805770933598225e-06, 3.877363249835205655e-05,
   2.952386187310217886e-05,-5.323681066516248038e-06,
  -9.135960282342503588e-04, 5.375335312281484708e-04,
   6.519012658677388267e-04, 1.113159799651442568e-03,
   1.622611490864024408e-05,-1.169244178824948469e-05,
  -1.967552931692491335e-05,-3.587972421692827642e-06,
  -3.638092583005689273e-02,-6.212075607836642366e-02,
   2.980156649491276857e-02,-1.742116627695438832e-02,
  -1.026850658510895690e-05, 3.865951076399666634e-05,
   9.367730045044487592e-06,-3.499376202006698097e-06,
  -5.316104964811235072e-05,-1.186334809415576843e-04,
  -1.555855846115041668e-04, 6.850639284837932647e-05,
  -1.040415628468010833e-04, 7.794455208925854420e-05,
   7.647390726509499916e-06,-6.443400893635016117e-06,
  -2.619857623720865076e-05,-6.995095671991506713e-04,
   9.569946630524863555e-06, 2.901055237134552658e-06,
  -2.067867022815404046e-06, 9.783860484284951893e-06,
  -5.596227810896079130e-05, 2.163847103783739231e-05,
   9.965643179383899860e-06, 2.829639475306349418e-05,
   2.308951475279081358e-06, 9.729786384335812301e-06,
  -7.275949414013214533e-06, 3.933269073079950464e-05,
  -3.848222890285418425e-06,-1.962628799815908497e-05,
   7.712027403331282640e-05, 2.127118551060888191e-05,
   2.127118551060893612e-05,-7.712027403331281285e-05,
  -1.937997852559740713e-06, 9.810411017050908971e-06,
   1.942756391314112330e-05, 4.750764191245119180e-06,
   1.903873042872072366e-03, 5.973957435119959386e-03,
  -4.811557937278942987e-03, 1.533430864502211260e-03,
   1.604370948653459209e-04,-5.621333108051857668e-05,
   3.328464039371534651e-05, 1.256667526192232359e-04,
  -3.763670370245106919e-04,-5.052205987896679325e-04,
  -5.598863144449810116e-04, 4.201515380160065387e-04,
  -1.895432095128425111e-04,-1.116842501321054138e-04,
  -1.222961865904005293e-04, 2.065033722374672205e-04,
  -3.881759035632294079e-05,-9.653739116461796025e-06,
  -7.660734301097934796e-06, 3.925956125541881365e-05,
  -6.087737120101521285e-06, 7.933439150616714591e-06,
   3.029816678620557435e-06,-1.976917324760832679e-05,
  -1.728426015749581247e-05,-1.006252208981440755e-05,
   1.620139325921481074e-05, 2.524905654594382894e-05,
  -3.276824379476656925e-05, 2.293996945522688583e-05,
   6.891665874178822481e-05,-7.246029359496071497e-05,
   1.297154030914375994e-05,-2.705067729296733645e-05,
  -1.948063500328843961e-05,-3.493572469362348024e-05,
  -7.616017160727158305e-06,-6.480453889004183452e-06,
   1.533977915000644596e-04,-1.974059714469214111e-04,
  -2.168691126959186913e-04,-1.608346603145134341e-04,
   1.898975956855905164e-05,-5.691563081903178265e-05,
  -6.587689079304935428e-05,-2.366928937337680599e-05,
  -5.506809885251250168e-05, 2.382235271273412807e-05,
   8.872284534517547048e-06, 2.865802797016153206e-05,
  -3.384609107800182563e-06,-6.991812655661902944e-05,
   2.773385187028734897e-06,-4.992302409314133046e-05,
  -4.992302409314133046e-05,-2.773385187028738285e-06,
   4.801877292295861759e-06, 8.771657452826881656e-06,
   1.450759925983463131e-05,-1.090391194192068204e-04,
  -1.384437188560645477e-04, 2.081674108267078047e-05,
   1.397821383129966939e-05,-1.430417904272952934e-05,
   4.366939369179940328e-03,-3.489690608908805475e-03,
  -3.976975304353243777e-03,-4.963191254481779877e-03,
   3.631122418316535004e-05, 1.677781267984322939e-05,
  -1.427129948613438950e-05,-2.638806569222269373e-05,
   1.693686047586315821e-05,-1.063685842818002683e-05,
   1.601954362689768230e-05, 2.536482253014836206e-05,
   1.402877125786510913e-05,-1.425459845083325591e-05,
   2.137089494796635131e-05, 2.105433088756292632e-05,
   2.512266750786435563e-05,-1.639669409635053510e-05,
  -2.161416852528320605e-04,-4.060575967717704334e-04,
   4.373796097797331511e-05,-2.422789238644756783e-05,
   1.969528444309095157e-05,-4.595754313173996871e-05,
  -3.929074258958647288e-05,-7.499169737968070503e-06,
  -9.994179251922942530e-06,-3.411467139413852131e-07,
   7.172319069272728048e-06,-1.866970377827529513e-05,
   1.037859648446535862e-06,-3.998653332498488259e-05,
  -2.998959807363723229e-05,-7.899413786440086928e-07,
  -9.954870666749305962e-06,-9.489731335998032896e-07,
   9.936496616405685660e-06,-1.125182203982260240e-06,
  -2.359669660740119592e-07,-1.999860794132736315e-05,
  -9.302529603122354970e-06,-3.669188327550421558e-06,
   1.816856425262631175e-05,-8.360817723057320074e-06,
  -1.035766675248246705e-05,-3.863571844090024870e-05,
   2.897678883067520008e-05,-7.768250064361793112e-06,
   1.928812823978766068e-05, 2.297755663697743776e-05,
  -1.196189818631913255e-06, 2.997614267910068039e-05,
   2.997614267910068039e-05, 1.196189818631915161e-06,
  -1.108959680184475467e-04, 3.001700922431338610e-04,
   3.318692612046143515e-04, 1.111880994868761279e-04,
   9.365404413037904685e-06,-3.505595552862619104e-06,
   7.199825168987277786e-06,-6.939922012243173049e-06,
   4.400824936627158548e-06, 8.979573479690479665e-06,
  -1.776325378036595665e-05, 9.190582959438136533e-06,
   9.211193577596926878e-06, 1.775257482383998131e-05,
   2.827128113473622602e-05, 1.003666593051236668e-05,
  -3.502143095177252027e-05, 3.568612299045988823e-05,
  -1.101179362224172046e-05,-1.669552039384087865e-05,
   9.917201761644873744e-06, 1.284176474954998225e-06,
  -9.573971448373233976e-06, 2.887744917012953349e-06,
  -4.564636534290269208e-04,-5.950974147971282296e-04,
  -7.132356771034955569e-04, 5.489033329346053400e-04,
  -9.774332605361261929e-05,-5.046030332823193173e-05,
  -5.523230240970056855e-05, 1.065335288560525698e-04,
  -3.523167600551105250e-06,-9.358808153735547643e-06,
   4.968482294478205631e-05,-5.605209090271197792e-06,
  -2.260057286835916941e-06,-1.987189324297561520e-05,
  -1.126568087696801609e-04,-1.136153309982051654e-04,
  -1.348757035601205756e-04, 1.338228104217008513e-04,
  -1.642025547560627960e-06,-3.996628269055252911e-05,
   1.066788717286579136e-06, 9.942935272477141458e-06,
  -5.000237136625509639e-05, 1.833023809385767857e-04,
   1.760332294701429470e-04, 3.758060832812580424e-05,
  -3.999915163277094284e-05,-2.605161388436274241e-07,
  -4.604146737522739733e-06, 3.973413938692215965e-05,
   4.978451838428200242e-05,-4.636995713291943290e-06,
  -3.709596570633552345e-06,-3.982761470742560329e-05,
  -3.962149809551268999e-05,-4.505704038956935331e-05,
  -3.050681237352952918e-05, 2.587149780755389322e-05,
   1.293084789761005191e-03, 1.193956333577043949e-03,
   6.587830424313570639e-04,-7.119725437156161022e-04,
  -4.266440942749835919e-06, 9.044196021871037458e-06,
   1.220176284694948369e-04,-8.724504766850848614e-05,
  -7.320060610176753395e-05,-1.309262054224969514e-04,
  -1.024477080758360763e-05, 2.819653650894171008e-05,
  -2.275104411379996394e-06,-1.987017614208085861e-05,
   1.952911577885668509e-05, 4.314352430668001692e-06,
   8.135497109634119218e-06,-5.814953721151606575e-06,
   5.893827800400790000e-06, 2.941534963006938138e-05,
  -2.999842934674711286e-05, 3.069800127395605637e-07,
   8.242899082284486337e-06, 1.822236578272079622e-05,
  -2.948505261296800834e-05,-5.534588730023977712e-06,
  -1.130367105817752934e-06,-1.996803120505587589e-05,
   9.028610091578516427e-06,-4.299325506896004636e-06,
   3.989410647379814967e-05,-2.908654097216930248e-06,
  -2.181490572912642311e-06,-2.992057985534861395e-05,
   2.059324253627466594e-04, 2.449323093922416497e-04,
   2.603121679735270256e-04,-2.187180267031555716e-04,
  -1.583879808216235113e-05, 1.221198081035547155e-05,
  -3.555636968791322479e-06, 9.346520515473364562e-06,
  -4.763053037058889095e-06,-1.942455471217201837e-05,
  -1.941880876885746749e-05, 4.786425179457460043e-06,
  -1.590500362826530195e-05,-1.212562821402947724e-05,
  -1.828131563405582832e-05, 8.111319170642097173e-06,
  -2.471576373391799675e-06,-1.984669519669437306e-05,
  -9.413078272043925272e-05,-2.530600635114862648e-04,
  -2.453501318349458741e-04, 8.604250582459041150e-05,
  -6.790337586458697768e-06, 7.341070457496391576e-06,
   1.993718857028433893e-05, 1.583828246030336649e-06,
  -1.412769905735584080e-05,-1.415655746800001312e-05,
  -4.990967984819025865e-06,-2.958192418647765195e-05,
   5.282708978439717594e-04,-4.277684526848526985e-05,
  -4.702448291774634858e-05,-5.780905621148978851e-04,
  -8.820703165612913841e-05,-1.087176138738090000e-04,
  -1.081398069791038633e-04, 8.891446533901082368e-05,
   2.628443062389802802e-07,-9.996545046698772594e-06,
   3.230135553451972023e-05, 1.973743205957465897e-04,
   1.047705345666407104e-04,-7.696190672417322612e-05,
   3.626475679602845018e-05, 4.780028676195267418e-05,
   9.440044566927323542e-06,-1.763194710105568414e-05,
   1.509551010789242148e-03,-6.409803006529743918e-04,
  -5.901759807911982235e-04,-1.389889316347581432e-03,
  -1.544076020690125184e-06, 9.880072329812659887e-06,
  -3.700095867700697893e-05, 1.519635012042109248e-05,
   1.139726259031581724e-05, 2.775071900775523420e-05,
  -8.170476161124647020e-06,-5.765701978119739007e-06,
   2.641384527631738470e-06,-9.644847732192960354e-06,
   7.343374755664515004e-06, 6.787845549058194126e-06,
  -1.503585487173670482e-04, 5.186446826369737117e-04,
   6.056939193647747693e-04, 1.733057299818379791e-04,
   1.987939623656992622e-05,-2.193081227280356893e-06,
  -9.262510460912118195e-06, 3.769071498591343130e-06,
  -4.477301059546591119e-03,-2.157469634127666576e-03,
  -2.422468885971570951e-03, 5.026732984404448483e-03,
   1.275932782954645400e-05,-1.540128414575100971e-05,
   1.601989570685941828e-05,-2.536460016521741289e-05,
  -2.833587935571354289e-05,-9.852813869065380931e-06,
   6.565390527970538723e-06,-1.889168195834438485e-05,
  -1.979671362940441833e-05,-2.844315291129555502e-06,
  -3.093308788717010637e-06, 2.984009786742741448e-05,
  -1.752762107878226216e-05,-9.632367274903288606e-06,
   5.138693773187416833e-06,-8.578684415771738945e-06,
   1.577089042722170173e-05, 4.744764499037404582e-05,
   4.744764499037401872e-05,-1.577089042722178304e-05,
   4.529305596418534606e-06,-8.915457969967204813e-06,
  -1.842823909481361978e-05, 7.771743939707677283e-06,
  -7.589658520500877719e-07,-1.998559408262416169e-05,
   3.224313666497687092e-05,-2.367234965109345498e-05,
  -1.759147917418101782e-05,-2.430102591382420394e-05,
  -9.806401534914969745e-06,-1.958185112806585791e-06,
   9.720215103223681880e-06, 2.348918548409509533e-06,
   1.415376912735525163e-04, 4.966972869819733872e-05,
   5.860309601641107066e-05,-1.701930584286307098e-04,
  -3.907139190050675763e-06, 9.205121582552300115e-06,
   1.736573577757423423e-05,-9.921250974724821786e-06,
   1.051768727343646931e-05, 2.809587611052897097e-05,
   9.999409861097086508e-06, 1.086389883714060079e-07,
   3.087171943651276766e-05,-3.933111921917859666e-05,
  -3.146489537534274587e-05,-2.469737554921038286e-05,
   1.681798117391608303e-05, 1.082383985625269044e-05,
   9.978602962652768484e-06,-6.538217752089671516e-07,
  -9.385472713269291025e-06,-1.766105608247925962e-05,
   2.995445122388428719e-04, 7.983160519239056098e-05,
   3.182816415675860825e-05,-5.086224499970903276e-05,
   1.805262779955253008e-05, 8.608288420517942169e-06,
  -9.724601256994652509e-06,-1.747661667464438351e-05,
   8.031500477948292377e-06,-5.957768044554635973e-06,
  -4.639889389108608026e-06, 8.858409928245439000e-06,
   1.918140301991682836e-05, 5.663371627178077191e-06,
   1.239514560512146989e-05,-3.803104475856321139e-05,
  -1.992339673036507068e-05,-1.748788930797112598e-06,
  -9.834359659660295758e-06,-1.741509029791250710e-05,
  -3.061264017409840154e-05,-1.056544663588396363e-04,
   1.929771782150083287e-05,-5.253388133550504934e-06,
  -1.073814352158608212e-04, 2.385848635144079390e-05,
   6.624252057603489594e-05,-4.485452561039515452e-05,
  -5.234844153188851360e-04,-1.989071816658335924e-04,
   2.971400435532516604e-05, 4.021290769357169372e-05,
   1.696751476478267152e-05, 1.058789132485227795e-05,
   2.648091137941644449e-05, 5.384014610414326218e-05,
  -6.268592466271428988e-05, 6.457921375474085619e-05,
   1.866507564942597488e-05, 2.348648443256686388e-05,
   1.007416293921122160e-04,-1.369347439747207378e-04,
   1.366248964296998101e-05, 1.460603905087680064e-05,
  -1.170579968323874516e-06, 1.996571417549993364e-05,
  -2.283631877489572699e-03, 6.415693684093205784e-03,
   1.484970180061279960e-05, 2.606695909447201133e-05,
  -8.125714475495679858e-05,-2.044438221768317507e-04,
   1.973860358361081258e-05, 3.222968906003654063e-06,
  -7.460234977926746677e-06,-6.659196203305496419e-06,
   1.428663344929090762e-04, 1.744158596707466851e-03,
   2.812817832534854595e-05, 1.043099152033939456e-05,
  -3.771308887856405058e-05, 3.282869061107264024e-05,
   1.115868140154264167e-05,-4.873893545594596105e-05,
  -3.020792723298250800e-06,-1.977055414809783334e-05,
   1.795729452765513102e-05,-3.574262963531149026e-05,
  -4.836585221160511280e-05,-1.267849911642434784e-05,
   2.999788871410818210e-05,-3.559110787556156011e-07,
  -3.244450964539938548e-05,-5.047131654583211340e-05,
   3.077424359521780257e-05,-3.940743497288545951e-05,
  -2.122020439189733492e-05,-2.120620016801928197e-05,
  -8.447881796434992575e-05, 1.475239957272925467e-04,
  -1.523811296505959403e-05,-1.295376058386454728e-05,
  -1.112532375007556338e-06,-1.996903281870607055e-05,
   1.150909783924471434e-03,-4.968441070322454113e-03,
  -1.772378637744937688e-05,-2.420469781770761696e-05,
   1.040280795852067930e-04, 1.938508670545836983e-04,
  -1.997731204041894057e-05,-9.523673869534116476e-07,
   8.170571978385797205e-06, 5.765566194747644102e-06,
  -1.228336111037591893e-03,-6.107707458475810681e-03,
  -2.913371796663064356e-05,-7.157267456286855928e-06,
   1.785921035418267379e-05, 2.410494981378419113e-05,
  -5.531215453547276163e-06, 4.969311477062431272e-05,
   5.254352745273048735e-06, 1.929745520083520457e-05,
   6.923702649849052340e-06,-1.876332437539982454e-05,
   9.379034696938223645e-06,-3.468963556111386199e-06,
  -2.050310677037592004e-05,-3.434563455175293684e-05,
  -3.434563455175297750e-05, 2.050310677037585566e-05,
   1.359075922894361533e-05,-1.467280694280695678e-05,
  -9.817612404740474008e-06, 1.901180336077032071e-06,
  -5.150531573153815399e-06, 8.571582380981104975e-06,
  -5.981219900912869121e-05,-4.743506054848595434e-06,
  -3.191357500392789978e-06, 3.987248722245311801e-05,
  -5.094781346257900148e-06,-8.604836025969499403e-06,
  -2.114713581411742371e-03, 6.714877993574621187e-03,
   7.812185389129020809e-03, 2.458832943873788795e-03,
  -1.323130599527556702e-06, 9.912079772509594749e-06,
  -1.224062845139158009e-05, 2.738917697038344796e-05,
  -1.825731999556176442e-05,-8.165186255050198549e-06,
  -5.728339019558004179e-06, 2.944802424742633235e-05,
  -1.962914191330039063e-05,-3.833638969375434894e-06,
  -2.030583690696388026e-04,-5.354716379770607166e-05,
  -3.338453940127208600e-05, 1.359612905534693405e-04,
  -3.043248740965116247e-05, 3.967195117537607949e-05,
  -1.696260223374736594e-05, 1.059575978680476333e-05,
  -2.196965778068203396e-05, 2.042875759804588346e-05,
   2.042875759804588007e-05, 2.196965778068203735e-05,
   2.222080479442390373e-05, 3.326012378642189858e-05,
   3.324608948604181995e-05,-2.224179700217812441e-05,
   8.214777051925032373e-06, 1.823506067955809931e-05,
   3.473592408531764814e-06,-9.377321354170950040e-06,
  -5.358483079147761247e-05, 2.699381242152936326e-05,
   2.249484368460787895e-05, 4.465402565956463866e-05,
  -1.058991850278205495e-05, 2.806873039708839839e-05,
   1.166947137031764069e-05, 1.624264257863654887e-05,
   1.965473772898773666e-05,-3.700173618184158906e-06,
  -9.771140281978580802e-06,-2.127161862645990606e-06,
  -1.649607700470405837e-05, 1.130837934696541962e-05,
   1.292162075200199305e-05,-1.526537641663092137e-05,
  -1.526537641663090105e-05,-1.292162075200201676e-05,
   6.506582840356249881e-07, 9.978809738511693907e-06,
   3.428849469229759629e-04,-2.914273720391205125e-04,
  -3.258293477895379191e-04,-3.792561616098601130e-04,
   1.051415772973019104e-04,-1.932491881572481296e-04,
  -2.285260072568660612e-04,-1.239994516408632612e-04,
  -2.119817328019416475e-05, 3.493574637095690706e-04,
  -1.699057931792118256e-04,-5.658749344413646827e-06,
  -2.976269408898686816e-05,-3.765905012793903006e-06,
  -5.248970362396190251e-06, 3.965410836388439758e-05,
   7.449256112218615835e-06,-6.671475352167136484e-06,
  -4.073783023489947871e-05,-5.692476778830554815e-05,
   5.710088213192968939e-05,-1.842523432023247855e-05,
  -3.378234990174399622e-06,-9.412094790808334560e-06,
   1.755319230664034141e-05,-2.432869581062869702e-05,
   2.878136997989358577e-05,-8.463612826711785817e-06,
  -2.397521559936128068e-05,-1.803299855720460814e-05,
   4.936279875734549615e-05, 1.093769358632879792e-04,
   3.638937608472396431e-05,-1.660762801138440398e-05,
   2.891665906092531297e-05,-7.989169465858510431e-06,
   6.517203817342752274e-08,-2.999992921000715191e-05,
   4.819168870124918030e-05, 1.332520694480548313e-05,
   2.364014227951195899e-03,-1.324966690164062957e-03,
  -9.237718898512443824e-05,-1.660314878425372780e-04,
   6.229463474113163271e-06, 1.900509891646686702e-05,
   6.414798087681949955e-05,-2.801850369714984826e-05,
   2.064587068328932462e-03, 1.786163552782594989e-03,
   4.490681296239296496e-04,-5.238681274481827915e-04,
  -1.999085541071034399e-05, 6.047313023757538218e-07,
   9.626633973607324210e-04,-8.587078568301866662e-04,
  -9.982399865347966388e-05,-1.119605702594895103e-04,
  -6.857490079062739802e-03,-4.477826461080876459e-03,
  -1.260692556729952013e-04, 1.923708469962560940e-04,
   1.271789703787994608e-05,-1.543551408064806332e-05,
   3.111080864154172653e-05,-1.158970128418734303e-04,
   2.760480292920422453e-04,-2.894779534333829238e-04,
   1.329938466990710118e-03,-1.279351470081654649e-05,
   7.454657289394744812e-06, 3.399182667711426456e-04,
  -9.952125445101611608e-07, 9.950354365109296054e-06,
   2.714292094519595855e-01, 7.942090629226186693e-02,
   6.551313348535780547e-03,-2.247461664654809912e-02,
   1.317210967441263684e-03,-8.543156718991230586e-04,
  -6.529021109860389535e-05,-1.006836050938768443e-04,
  -4.402989010579571889e-06, 8.978512559033124089e-06,
   2.211148445560434921e-04, 9.331787351283101157e-05,
  -3.101331293220945846e-05, 7.374397887942344364e-05,
   2.858031813056860688e-04, 4.915833149679864518e-05,
  -1.350802035556040920e-05, 7.885133724974971393e-05,
   1.130360064352050172e-06,-9.935908922937954302e-06,
   4.951411384239612428e-06, 8.688125534545549744e-06,
  -1.020276996997091130e-02, 4.763516027039246467e-03,
  -1.144051902164307954e-04,-2.445638003702556903e-04,
   3.265689881023264900e-05,-3.283801561606581590e-04,
   5.976700503672430524e-05, 5.282528650198884383e-06,
   1.834992726756183375e-05,-7.954883360250529950e-06,
  -6.327727841517034079e-06,-1.897260815923025140e-05,
  -1.866757679588239174e-04, 2.348449651514447709e-04,
   2.427103619529480116e-01,-3.449931449563838071e-02,
   8.603296485688652351e-03, 6.028924688183903008e-02,
  -9.732349105224222024e-06,-1.747230325097527979e-05,
  -8.924732303252237142e-07, 2.998672192042926303e-05,
   2.898957091188178394e-04,-7.776749610072209327e-06,
  -6.921612595259364018e-06,-2.499041641891570193e-04,
   1.064469262145596289e-04,-2.773178500335130617e-05,
  -6.090821420086841431e-05,-2.321426058328396119e-04,
   9.757359222422136286e-06, 2.189507023193509041e-06,
  -8.291710747614795864e-06,-5.589949273284087181e-06,
   4.074008908091056617e-04,-1.349860924009561609e-03,
  -4.787608387605122613e-05,-1.441806480403345683e-05,
   6.078985180070680256e-05, 7.940147302190371785e-05,
  -1.676526007989804376e-05, 1.090532229938102603e-05,
  -1.663907513021415096e-05,-1.109689951342666726e-05,
  -2.749943323897504656e-04, 5.556780697071960580e-04,
   6.310510926842742227e-05,-6.268315125966624933e-04,
  -5.580279382814649315e-07, 9.984418101226398334e-06,
  -2.210110511997961328e-03,-3.647074509193745694e-04,
  -2.755590502983428110e-05, 1.677518169737268695e-04,
  -2.515680615158860598e-06, 1.984115296656205013e-05,
  -8.637111662264814708e-05,-6.811776723702057772e-05,
  -1.869415652740500462e-05, 7.108340996947245670e-06,
  -9.869252973311720068e-06, 1.611783406285658385e-06,
  -2.788298699312473687e-05,-6.420700145888481522e-05,
   9.968548799978030009e-06, 7.924864809298567957e-07,
   9.585012654374036280e-06,-1.755356181563985719e-05,
  -2.923422168172881230e-05, 6.735004280884837045e-06,
   4.490002853923232320e-06, 1.948948112115254041e-05,
  -7.069350507341724176e-06,-2.915517592820093644e-05,
  -2.915517592820093644e-05, 7.069350507341722482e-06,
   5.083691052351922993e-06, 3.967563591531000900e-05,
   3.966970883794787437e-05,-5.129736904797410607e-06,
   5.010013248247420107e-06,-8.654465162699851171e-06,
  -2.901810836321305250e-06,-9.569717543909446404e-06,
  -1.337963827423107092e-05, 1.486557364015028790e-05,
  -7.457629925542159104e-06,-1.855757947291774841e-05,
   7.334847068929107598e-06, 6.797059546261316552e-06,
  -1.288960797496938488e-05, 1.529241662562218039e-05,
   1.529241662562218717e-05, 1.288960797496937979e-05,
  -9.621480348211254661e-06,-2.725273547551631319e-06,
  -9.251142545374280878e-06, 3.796888410944663775e-06,
   1.918784817249867387e-05, 5.641496477809704984e-06,
  -7.802018798103198060e-06, 6.255277985353195940e-06,
   9.929109363173113756e-06, 1.188607274985315799e-06,
   1.963194603014190124e-05, 3.819253208363614827e-06,
  -4.080346117430999191e-06, 1.957934563671538523e-05,
  -7.881009288242439714e-06,-3.921593671708782392e-05,
  -1.627746793319105595e-05,-1.162084496428452073e-05,
  -1.444001136420536638e-03, 3.673700015191747612e-04,
  -8.691854142625187862e-05,-3.493496345444387953e-04,
   6.260313884055413723e-06, 7.797978588910271967e-06,
   4.704803177717617392e-05,-8.824104887122444772e-05,
   3.573957852874375509e-05, 1.796336623764484625e-05,
   2.832644699946021871e-04,-9.879898804480290078e-05,
   8.342761953467220674e-05, 2.356689039707572111e-04,
   7.155114254473138270e-04, 3.105533771420833302e-04,
  -3.813787881840830299e-04, 8.809938818875193362e-04,
  -1.450338570428920473e-05, 2.626122242228300265e-05,
   1.750748161485533736e-05, 9.668923802859472077e-06,
   3.854493022036202609e-06, 1.962505754241434806e-05,
   2.828575028505418243e-05,-9.995815665144952371e-06,
  -2.418674298142732979e-05, 1.774828059138055790e-05,
   1.184716223366052005e-05, 1.611349580349738885e-05,
  -1.723848232331952511e-05, 1.014074588916418556e-05,
  -4.497120195033474437e-05,-2.185385538394104231e-05,
   1.748308430715283046e-05,-3.597696156026779956e-05,
   1.699883431242679845e-05, 1.053753443736538439e-05,
  -1.994957606988304781e-05, 1.419300754579413409e-06,
   1.419300754579376775e-06, 1.994957606988305120e-05,
  -7.406196674524488655e-06,-6.719244810115376579e-06,
   7.746118040918079157e-06,-6.324369952506216764e-06,
  -1.560375567034759853e-05,-1.251090760017414783e-05,
   1.012409246561621675e-05,-3.869758069631295383e-05,
  -1.775911851601474152e-05,-9.198571059362558534e-06,
  -2.980333325982683821e-05, 3.429479057189211168e-06,
   7.758590921562009033e-06,-6.309062284670805475e-06,
  -8.065012160806496249e-04,-1.481748577203070188e-04,
  -1.758243947417957175e-04, 9.437615070629238679e-04,
   3.401754023170000421e-04,-2.294924986934968915e-03,
  -2.668697358714333667e-03,-4.099443957308607635e-04,
   5.879331303929452986e-05, 1.197273326619782700e-05,
  -1.101107022447424433e-05,-1.669599749975115245e-05,
  -9.452034785775819249e-05, 3.264818281081488332e-05,
   1.915163095087556820e-05, 3.511716150148621197e-05,
  -6.081763104570027487e-07,-9.981488945813592176e-06,
  -1.817718492143917646e-05,-2.386608364042588904e-05,
  -2.386608364042592292e-05, 1.817718492143913242e-05,
   5.329362808424126271e-06,-8.461553761348190568e-06,
   1.240253943617136976e-05, 4.843735145044797164e-05,
   6.618222889592121059e-07,-9.978075528769904219e-06,
   8.527954166610211316e-06, 5.222451314487818739e-06,
  -4.373860240843652290e-05,-6.698458523687902629e-05,
  -6.725655174822063327e-05, 4.331923645378483892e-05,
  -8.663925664967112841e-05,-6.777639122284704243e-05,
  -7.964784285032340755e-05, 1.027434724412708533e-04,
   6.722100432149053512e-06,-7.403604917883012032e-06,
  -3.486458935569816556e-05,-1.960766199878349268e-05,
  -2.288505059606787487e-05, 1.075930967079924422e-04,
   6.072647218407004485e-06,-1.905578536195172738e-05,
  -7.043096078347530929e-04, 1.494923954977523436e-04,
   7.307440712649677993e-05, 3.422866211570516526e-04,
  -5.914923191436465764e-06,-4.964890415345949598e-05,
  -2.716802596530863660e-05,-1.272392884090113534e-05,
  -1.271876488342237963e-05, 2.717044386535158741e-05,
   6.999010640750889502e-06, 1.873536362205590987e-05,
   1.990615406067072039e-05, 1.935208131659929377e-06,
  -2.696151269347442432e-05, 1.315586687678229530e-05,
   2.536627917100257293e-05, 5.437418395726745360e-05,
   2.894028560730043297e-06, 9.572073897002614663e-06,
   1.915218564376803347e-05,-5.761404782398617301e-06,
   8.156604624860338789e-06,-5.785309066394547915e-06,
  -1.214851594853231208e-04, 1.189174336454735745e-04,
   2.285599452282778695e-04, 1.943202290994084942e-04,
  -4.831543649613162842e-04, 4.926072062189378086e-04,
   1.037754108738842256e-03, 2.160240954052375199e-04,
   2.905150438184834916e-07, 9.995779159691112363e-06,
   3.703553885961889192e-04, 8.506988972466049143e-05,
   9.395009800125577186e-05,-4.093572755986565307e-04,
   6.045278665380816233e-06, 7.965839934237415974e-06,
  -1.782816565618267936e-05, 9.064022800926111595e-06,
   8.998441833881761854e-06, 4.362114689258714724e-06,
   2.793455964179434982e-05,-2.862971144840678557e-05,
  -3.582038008110638498e-05,-3.488409911184575153e-05,
  -1.999807692088883501e-05, 2.773435887367089833e-07,
   1.994450046556643010e-05, 1.488926183200687149e-06,
   1.480113703101888610e-05, 1.345088631239598001e-05,
   9.729513149217385848e-06,-1.747388262176457520e-05,
   1.924292709217956552e-05, 5.450665732280942154e-06,
   7.385309320994823438e-06, 6.742195950373067543e-06,
  -3.632169076766191470e-06,-3.299800105276041876e-04,
  -3.499772815414545516e-04, 3.987781946577803217e-06,
   1.940370277820878341e-05, 4.847300124289070508e-06,
   4.864210886377581714e-06,-1.939947041681411278e-05,
  -9.178815867921466141e-06,-1.776933705186530525e-05,
   1.979752331409552566e-03,-3.131623027186574679e-05,
  -4.013276296529417531e-05,-2.229638841009182800e-03,
  -1.485978889466960258e-05,-1.338606267749609753e-05,
  -1.001289845691369169e-05,-3.872650080360393087e-05,
   3.918107788805472619e-05, 8.052523550427498870e-06,
   6.284483259578278790e-06,-7.778513364395563462e-06,
   5.881947124082550787e-06,-8.087193458147085611e-06,
  -1.760862594413362066e-05,-2.428860416655482683e-05,
  -1.617900502199493752e-05, 1.175754211126894700e-05,
   3.024604988730716378e-05, 3.981427465387918417e-05,
   3.184689195392400272e-05,-2.420279886449273164e-05,
  -4.068632694914854567e-06, 9.134890694139142001e-06,
  -3.330335553362730823e-05,-2.215595879669429868e-05,
  -1.257448903814994336e-05, 2.723751503770942134e-05,
   5.597611704899376713e-06,-2.947315292263746794e-05,
  -2.947315292263743744e-05,-5.597611704899535955e-06,
  -1.863440405359559294e-05, 7.263538088792554425e-06,
  -5.230303716914456324e-05, 4.652302981194454738e-05,
   4.769267284388323323e-05, 5.123874468609005491e-05,
   7.129185309861119355e-06, 7.012468667855880353e-06,
   2.367716500426857019e-05,-1.842259095134665873e-05,
  -4.053520512861520875e-05, 4.423683018912054788e-05,
   5.543267919108010047e-05, 2.296122988210333235e-05,
  -9.210266697340699880e-06,-3.894995168656421125e-06,
   1.599651482127209361e-05, 3.996800114010867484e-04,
   2.098559079035573229e-04,-7.778040754179383083e-06,
  -4.998018213207407689e-05,-1.407619993003571808e-06,
   9.462622232577698163e-04, 1.919423821055491136e-03,
  -9.389537634646638511e-04, 4.919002236994247370e-04,
  -6.706337225667712151e-05, 4.361770399232805509e-05,
   9.969144403765187762e-06,-7.849585064684938597e-07,
  -1.378004941918961002e-05, 1.449517981967426819e-05,
   1.961027170799960228e-05, 2.270324301808951755e-05,
   3.927821119963021363e-06, 9.196315634512141645e-06,
   5.756171878916052470e-06, 8.177192996400173766e-06,
   3.760930506325252688e-07, 9.992925198222286643e-06,
   9.915629725689412529e-06, 1.296258902775413535e-06,
   1.293698812375908317e-05, 1.525235517176663849e-05,
   2.290624466841108796e-05,-1.937276323065165301e-05,
   1.324084696779199120e-05, 2.691988060106347474e-05,
   6.286852560725100954e-05,-3.078227554893276269e-05,
   7.700369896929358516e-05, 6.379992433417468873e-05,
   1.107713145947462771e-04,-1.289562556177549393e-04,
  -9.999855799790525717e-06,-5.370273173496404771e-08,
  -5.358279395798463142e-06,-8.443271991151396819e-06,
  -9.843259163711508145e-06, 1.763589815124095351e-06,
  -9.998367110072014927e-06, 1.807073109483592546e-07,
   4.685681469207213581e-03, 1.251754436432374286e-03,
   1.461248391256387809e-03,-5.468121536602000080e-03,
   3.588447438452592138e-05,-6.010245001783456247e-05,
  -5.178896031988575226e-05,-3.029692375448865920e-05,
   2.770988995536104155e-05, 1.149617321815312681e-05,
  -7.664296033160270435e-06, 1.847318506149071618e-05,
   1.972889337709191675e-05, 3.281884537173543919e-06,
  -3.281856990438563505e-06, 1.972889795944795339e-05,
  -2.425317827743738496e-05, 1.765738778650000109e-05,
   6.721742422784535780e-06, 7.403929956566221400e-06,
  -1.540923846567949563e-04, 4.307594445606906014e-05,
   4.038432825986738617e-05, 1.444614344072467989e-04,
   5.767167412469400435e-07, 9.983356038946298409e-06,
   1.997372132664502442e-05,-1.024917735979733349e-06,
   4.479537190853915586e-06,-2.966367722578838791e-05,
   2.227114163460849453e-07, 2.999917331569370446e-05,
   2.998226527582734832e-05,-1.031391744158159792e-06,
  -5.577808501091991601e-06, 8.299882669360208025e-06,
   1.776286838924203836e-04,-2.912130935666518749e-05,
  -2.971551374147416916e-05,-1.876618987516652580e-04,
  -3.090318965188037455e-06, 9.510516741660210826e-06,
  -1.104091130970275007e-05,-1.194909966376181735e-04,
  -1.690602850284002529e-04, 1.784993070339688668e-05,
   1.658695745327287113e-05,-1.117465178174763302e-05,
  -1.114254594086828906e-05,-1.660854207796818360e-05,
   7.157168360031838103e-04,-3.344389490797860056e-04,
  -3.797528721776237621e-04,-7.827437358886019233e-04,
   1.985104110505697366e-05,-2.436425054324159209e-06,
  -7.639451617163284030e-04,-1.088709231103609544e-03,
  -9.082251060139374553e-05, 4.184819671216097456e-05,
   5.289533190106169566e-05,-2.832108513239783067e-05,
  -1.999775820548928360e-05, 2.994440762246415043e-07,
   3.208148169463293870e-05, 1.052177671891821293e-04,
   2.345394667178873042e-05,-3.240235154301136133e-05,
   6.996003101329165200e-06, 7.145343980956600777e-06,
  -1.681326586328410583e-05,-1.083116295743561628e-05,
  -1.083116295743558748e-05, 1.681326586328412277e-05,
  -9.396682368236188102e-06,-3.420871302823180517e-06,
   2.665772079719194498e-05, 4.230089741245403220e-05,
   3.334297588206356082e-05,-2.209628836090187813e-05,
   1.092482598547673441e-05,-1.675255733274930243e-05,
   2.136457507942607652e-05,-3.381648905010049496e-05,
  -5.991014464588060098e-06, 8.006731273440907942e-06,
   1.790816438799478286e-04, 1.815942799912893596e-05,
   1.191988105948785965e-05,-9.928704062226683497e-05,
  -6.579850057353710671e-06, 1.888665066184955923e-05,
  -2.963522980592836934e-05,-4.664027696081446700e-06,
   1.606872809507623248e-02,-4.970752197254233937e-03,
   6.764031827721778264e-04, 2.177355904379361506e-03,
  -7.110793928419826713e-05,-1.761921138154451426e-04,
   9.815723269105981944e-06,-1.910909915284178560e-06,
   9.127995571222422195e-06,-4.084078458078868076e-06,
  -5.502457024852218698e-06, 5.974715864950947309e-05,
  -3.820030811666383602e-05, 3.226044729683622052e-05,
   9.745421656103298740e-05, 1.140292755149978219e-04,
  -9.863601030496922491e-06,-1.646017834405226381e-06,
   3.036745166625809771e-06,-9.527758329899787428e-06,
   1.686024743293610361e-05, 1.075788345819806412e-05,
  -1.608845066712844839e-05, 6.812607250628333066e-05,
  -3.260681500126712093e-06,-9.453462654219957139e-06,
   9.625844812893735538e-06,-2.709817639267778045e-06,
   9.993608566265918652e-06,-3.574742288004320750e-07,
   8.820464805221836868e-06,-4.711623989649739926e-06,
  -1.315815394012237494e-05,-2.696039660108957129e-05,
  -8.425716308661755435e-06, 5.385842987495210547e-06,
  -3.198311101422452468e-06,-9.474745700994718510e-06,
  -1.672139629336931198e-06,-9.859206309840613599e-06,
   2.792294253968113834e-05, 1.096855869864703428e-05,
  -1.053500095876476510e-05, 3.858774099113377617e-05,
   1.582001752639597180e-06,-9.874070612196635897e-06,
   1.306975188710468719e-06, 9.914222907323359132e-06,
   1.811060848666757499e-05, 8.485626685321740213e-06,
   8.485626685321709720e-06,-1.811060848666759193e-05,
  -9.996032688951985920e-06, 2.816566729253005850e-07,
   9.999754571514616578e-06, 7.006075558072285626e-08,
   9.498936780393721059e-06,-3.125731921019998506e-06,
  -2.996049689606969163e-05,-1.539034028408247842e-06,
  -1.251793334915152804e-06, 1.996078689447543076e-05,
   9.554264718887318965e-06, 2.952291598305467081e-06,
  -9.032643255849030699e-06,-4.290845582465655548e-06,
   3.383956998329248347e-05, 9.410039055894428605e-05,
   1.167624673606691449e-04,-2.768620984982728922e-05,
  -7.123091794826765271e-06, 7.018658225221658150e-06,
   2.694997671495832748e-05,-1.317948235186814589e-05,
  -1.456592647811640167e-06, 9.893348162191659636e-06,
  -9.212224759434697519e-06, 3.890361806009611068e-06,
  -8.149852195519603903e-06, 1.826417009314095074e-05,
   3.130678286613230839e-06,-1.975345168485063656e-05,
   1.058852814629169316e-04, 1.329973953486265177e-04,
   1.326522904416830499e-04,-1.063173073425741392e-04,
   2.455739364311068396e-05,-1.723178509201258145e-05,
  -1.724932359355236850e-05,-2.454507762393343421e-05,
  -1.371978417058437680e-05,-4.808084361065831326e-05,
  -1.463245407552271805e-05,-1.363419552917291249e-05,
  -3.209783109123207664e-05, 6.220714781469034737e-05,
   8.000526650543297391e-05, 4.122083613167794823e-05,
  -7.144201066003042950e-06,-6.997170222920191480e-06,
  -3.242445676971125393e-05,-3.806119550393978582e-05,
  -2.141665229022071118e-05, 2.100778438293253515e-05,
   3.798972119262685653e-05,-1.252122532767772434e-05,
  -1.251521797696833826e-05,-3.799170065934096713e-05,
  -9.293610864454691383e-06, 3.691720073365493896e-06,
   1.184884480174294377e-05,-2.756093026122683905e-05,
  -2.756093026122685938e-05,-1.184884480174289633e-05,
   5.222426325322211183e-05,-8.527969469726163826e-05,
   2.763183513838258579e-05,-1.168253769029851780e-05,
  -8.753714957429535153e-06,-1.798256028612373514e-05,
   1.658899432285920847e-05,-5.766112440246153330e-05,
   9.283846470660189510e-06, 3.716207032608701787e-06,
  -2.627434440681278034e-03,-2.005865120739482726e-02,
  -1.675690392055752525e-03, 2.194577635264671994e-04,
  -3.341186883198381404e-04, 6.296588056583412099e-05,
   3.581958383371444367e-06, 3.983929685799933267e-05,
  -3.140419767847031208e-07,-1.999753428892715235e-05,
  -4.834406717508804590e-06,-1.940691917048416524e-05,
   1.969155294619769479e-05,-3.498963070267088922e-06,
   1.574925176124738948e-05, 2.553352832964622107e-05,
   1.281673362321384530e-04,-7.793031453265132906e-05,
  -1.498284019675204969e-05,-1.324818854178151780e-05,
   5.870726320716606288e-05, 1.238778619142766587e-05,
   3.364757515042314908e-05,-4.967736593758395825e-05,
  -9.908981774953901900e-06,-1.737273957047740544e-05,
  -7.932708067555634154e-06,-6.088689737122246522e-06,
  -9.792458008675999188e-06,-2.026762479502051851e-06,
   4.508939126430306277e-06, 8.925775481948104779e-06,
  -1.784122784877866021e-05,-2.411826255864971651e-05,
  -1.808407586533630280e-05, 8.542025526580981773e-06,
  -1.906470079932113032e-05, 6.044599526218777476e-06,
  -9.030098956006950598e-05, 4.296197486699395140e-05,
   6.414315843038918157e-05, 1.355937138165851194e-04,
   2.020521378428083899e-06,-1.989767557679326457e-05,
  -2.895465990132852180e-05, 7.850329292354442623e-06,
  -4.614263072944229872e-06,-1.946043617942987865e-05,
  -2.836853031209683471e-05, 9.758406013875584872e-06,
  -1.926770805120142768e-05,-5.362408642920431221e-06,
   1.219669542685092821e-04,-8.731587522589097502e-05,
  -1.001713698968434478e-04,-1.373524541207392043e-04,
   9.408615971607198561e-06,-3.387911672227885093e-06,
   3.210402522932552191e-06,-9.470655502168174539e-06,
   3.917821564613988472e-05,-8.066437800204016647e-06,
  -2.839730108208282490e-05,-9.674362576084152566e-06,
  -1.929487161231953265e-05, 5.681292044477300346e-05,
   1.880631717846898446e-05,-1.991138428994398914e-04,
  -2.190419584488591297e-04,-2.050903310466566231e-05,
   3.840138752296324153e-07, 9.992623946873570583e-06,
   1.274313611506697643e-05,-1.541468397187810589e-05,
   8.178466762209378972e-06, 5.754361947204611443e-06,
  -5.023032812264619906e-06,-8.646915135868571845e-06,
   9.995982652454423704e-06, 2.834269073857334515e-07,
   3.068039384511386136e-05,-2.481102848200950886e-04,
   4.280749945250613249e-05, 4.204185998054424140e-05,
   1.401395332684805393e-05,-1.426916648416873963e-05,
  -9.508708277463190193e-06,-3.885337137101622338e-05,
  -2.880122798244966155e-05, 8.395788629006726591e-06,
  -2.757832520650306646e-05,-1.180830126666650166e-05,
   1.029822832632996717e-05,-1.714486784255787451e-05,
  -1.109347600782198623e-03,-3.805128958103854976e-05,
  -9.837082504754478791e-06, 2.598138406778873442e-04,
  -5.555082841547076014e-06,-1.921304386669507713e-05,
   1.847448534081459209e-05,-7.661161229998149857e-06,
  -3.713358324842661143e-05,-9.284986265542977428e-05,
   3.776875111671301803e-06, 9.259331206455350861e-06,
   1.998879653371543280e-05,-6.693378322835134755e-07,
  -5.102588848549145117e-05,-4.792033706336162587e-05,
   6.374817558510478692e-06,-1.895683784537143018e-05,
  -1.795376069191032979e-05,-8.812631673774616852e-06,
  -1.058895991042645082e-05, 2.806909204116480862e-05,
  -1.946235303520910638e-05, 4.606171331256243053e-06,
   4.604517062594490051e-06, 1.946274447811192757e-05,
  -2.152818981311879995e-05, 2.089346891663344623e-05,
   2.299580100377429617e-06,-9.732005515922612798e-06,
  -7.734477001056950119e-04, 1.833542651590415158e-03,
   1.695338665015719585e-03, 7.151411125803901897e-04,
  -6.999348632586653270e-05, 9.549198661322237694e-07,
   8.872662926978212902e-07, 6.999437662073890295e-05,
  -4.894587326397148852e-06, 8.720264612055785724e-06,
  -1.098286003684563852e-05,-2.791732052706812089e-05,
  -1.861154701804540150e-05, 7.321906691230457300e-06,
  -6.011199976661750479e-06,-7.991587754669392463e-06,
   7.175198272984148113e-06,-6.965380803901917480e-06,
  -1.512649815022152399e-08,-9.999988559446142074e-06,
  -4.493039070883087400e-05,-6.619108694342316782e-05,
  -9.991741143837856449e-05, 6.645683479864035925e-05,
   9.917952101490592535e-06,-1.278368535492932105e-06,
  -1.235612186286040088e-05,-1.572660969535847835e-05,
   8.611879529451764431e-06,-5.082866412784193896e-06,
   1.191956729599682208e-05,-1.606000982179659332e-05,
   2.456601605025342498e-06,-1.984855431899731660e-05,
  -8.850373005967001838e-06,-4.655201140149654867e-06,
  -3.765047939144894193e-05, 1.033558967915913340e-04,
   1.109938137955659683e-04, 4.561110938264087167e-05,
  -9.421683981070403849e-06, 1.764176496161428488e-05,
   3.238123390499189870e-06,-9.461213289420233766e-06,
  -2.952699169159604775e-05,-5.306294530500356528e-06,
   5.950328993750329619e-05,-7.704445899181770768e-06,
   2.998280325400142857e-05, 1.015632331033878705e-06,
  -6.176022116260228006e-06,-1.902253271306070427e-05,
   1.060720146861424933e-05,-2.806220370897887439e-05,
   1.552804897789763631e-06,-9.878704214085981682e-06,
   7.810639099605925733e-06,-6.244510938072504079e-06,
  -9.865752215110860980e-06,-1.633074777845512274e-06,
   5.665513689617919903e-04, 6.065637199235702614e-04,
   6.796436861794256283e-04,-6.348105700415224237e-04,
  -1.491217516016391323e-04, 1.620812139820755504e-05,
   1.784917538262749978e-05, 1.590012796745995103e-04,
  -3.960371620662432818e-05, 2.062317765588638960e-04,
   6.857951692058894284e-05, 1.403031927429500674e-05,
  -5.858115687559051443e-05, 1.297104695533301879e-05,
  -1.109450729663259092e-05,-1.664067029434109911e-05,
  -3.166931150800084279e-05, 2.443470295725335057e-05,
  -1.674056909076336363e-05, 1.094318721933323887e-05,
   2.167779345668035992e-05, 3.361656244843464679e-05,
  -1.765701205229594631e-05,-9.393078589316484600e-06,
  -1.314833172140448549e-05, 2.696518816815318849e-05,
   5.391338350753998175e-06,-8.422201065498802843e-06,
  -9.976846467400063005e-06,-6.800989383368482949e-07,
   8.461423029978438671e-06,-2.878201383342990859e-05,
  -1.918800922228661702e-05,-5.640948686652260542e-06,
   4.182880769555808854e-06,-1.955769691113144033e-05,
   5.133278289967485396e-05, 3.106357029986812505e-05,
   3.106390179186834964e-05,-5.133258229882029590e-05,
   9.665134306562114509e-06,-2.566160329386318254e-06,
  -2.585556924595804548e-06,-1.983216819688847729e-05,
   9.896271405649605604e-06, 1.436597461268114873e-06,
   9.989814654136220320e-06, 4.512240862423419350e-07,
  -7.925213743521388097e-06,-6.098441368046405606e-06,
  -1.540987282275620892e-06, 1.994054558420769004e-05,
  -8.926260443223461014e-06, 4.507978981732736611e-06,
  -6.942762230388823952e-06,-7.197086397444900436e-06,
   9.439815318051400186e-06, 3.299982842543600731e-06,
   6.499114817932372557e-05,-6.225873961407496732e-05,
  -7.551635600587779931e-05,-7.998299804079316531e-05,
   6.252319002768403248e-06, 7.804390244447103752e-06,
   9.996826054998089847e-06,-2.519302008718973257e-07,
  -9.999393435407273281e-06, 1.101404736414250175e-07,
  -2.784545856825814440e-06,-9.604493967473466790e-06,
  -2.614344100140753491e-05, 1.471463532018117518e-05,
  -5.585139468849153761e-04, 7.310691972276181245e-04,
  -1.973764161708183631e-05,-3.228854811793064024e-06,
  -7.455735704394681313e-06, 6.664233272193760550e-06,
   1.991700057036513495e-05,-1.820189078111087669e-06,
  -1.025703349684648213e-06,-3.998684699546147209e-05,
   8.653113373808474649e-06, 4.924554425468376771e-05,
   3.842574193306975565e-05,-1.111136161292236310e-05,
   2.765180713663929700e-05, 1.163518637917347726e-05,
   7.329351987274783500e-06, 6.802984598441422913e-06,
   1.587340288389052090e-07,-9.998740096036530257e-06,
  -2.270017339323157657e-06, 2.991399373669741512e-05,
   2.991371657533979582e-05, 2.273666785226264140e-06,
   6.504567221908260666e-06, 7.595433184201982883e-06,
   4.668189861393129512e-05, 1.791090008343075468e-05,
  -2.186493774174678499e-05, 4.496581476576997575e-05,
   2.697948885946200917e-05, 1.311896264504802423e-05,
   2.365541615168350684e-06, 3.992999139577802257e-05,
  -5.052201330438792974e-07, 1.999361779711633782e-05,
  -8.813859012315538812e-06, 4.723969656022801324e-06,
  -4.022065236363474218e-06,-9.155489677479650598e-06,
  -1.834069457944165180e-05, 7.976147086384482318e-06,
  -1.215174628480136921e-05, 1.588505782897299234e-05,
   2.463073326610205614e-05, 1.712679125738775476e-05,
  -4.545804800100222847e-06, 1.947654124118001207e-05,
   8.388865853094446676e-06,-2.880324512444363646e-05,
  -3.838401985891179397e-05,-1.125464435114079238e-05,
  -1.116191957072523582e-05,-1.659552805718037587e-05,
   7.250494852561592837e-06,-6.886967721209231106e-06,
  -4.534148215726769616e-05, 2.107486644755253522e-05,
   2.409126731710925791e-05, 4.381336370396118993e-05,
   6.794011726856612104e-06, 7.337670247110785374e-06,
  -3.944260321024486064e-06, 9.189276931292899453e-06,
   6.080444947128376250e-06,-7.939029490116598071e-06,
  -2.187816247217740623e-06, 9.757738470998804925e-06,
   7.099110033333961677e-05, 5.531964997595076425e-05,
   6.803554627731253765e-05,-8.643589788246353793e-05,
  -2.402004066003065084e-05, 1.797324808404074617e-05,
   3.048034661213582289e-05, 2.590267303588686287e-05,
   1.323628115945006816e-05,-1.499336056619686632e-05,
   1.726983798344866748e-06, 9.849747558199364286e-06,
   9.826291588577976984e-06, 1.855799993598911330e-06,
  -1.758779712066366145e-05, 9.522047702168642656e-06,
  -2.698018013006271280e-06, 1.981718190867444722e-05,
   2.573731656691759609e-06, 9.663120891272275714e-06,
   4.388920567970041812e-06, 8.985397946003812858e-06,
  -5.735719073284396220e-07, 1.999177368987363436e-05,
   2.996853837062981679e-05,-1.373574871671908116e-06,
  -9.502353527279821087e-06,-1.759844531322562192e-05,
   7.629478353948658377e-06, 1.848759205647476685e-05,
  -4.382330548634711238e-05, 2.407317794247986449e-05,
   1.844906209667007658e-05, 3.549129622531715320e-05,
   8.106818509502976793e-06, 1.828331188964351736e-05,
  -5.645923886302830428e-06, 8.253698775099268622e-06,
  -4.232609045811735838e-06,-9.060078402823712525e-06,
   1.868555302277919697e-05,-7.130926183386508327e-06,
  -6.583067518642283731e-06, 7.527497727996797100e-06,
  -5.136566513682234270e-05,-1.515307508232300671e-04,
  -1.610014227496814516e-04, 5.457601920787515917e-05,
   5.414568302331917701e-06,-8.407285536924653357e-06,
   9.815220918558400040e-06, 1.913488520972521562e-06,
   5.691861135872876587e-06,-2.945509661858096938e-05,
   7.734874666495529999e-06, 1.844374457352968604e-05,
   3.227699466022555216e-06, 9.464774490553788444e-06,
   6.844040507106424302e-06, 7.291029388027896643e-06,
   1.847996240740897185e-05, 7.647940207712873015e-06,
   9.995764322939564562e-06,-2.910250852565485360e-07,
   2.196928484360258014e-06,-2.991945028296152752e-05,
  -2.991945028296151397e-05,-2.196928484360419374e-06,
  -9.135633112686159454e-06, 4.066965408064372882e-06,
   1.139493488475667726e-05, 2.775167488589031891e-05,
   1.769648561130890730e-05, 2.422466505462432426e-05,
   3.148605936519803614e-05,-2.467038843738025557e-05,
  -1.980568151832826681e-05, 2.781183128553411455e-06,
   2.745183484880247446e-06, 1.981070336041456019e-05,
   1.625553137005647902e-05,-1.165151062639989989e-05,
  -1.626798330771053660e-05,-2.520620398037061482e-05,
   3.468081853893875070e-05,-1.993090127087088602e-05,
  -1.594237201701423403e-05,-4.739030253618478275e-05,
  -3.905351479413452642e-05, 6.981993255671560940e-05,
   6.107374033229332963e-05, 3.420523705258606554e-05,
  -8.411763461560557080e-06,-5.407609034199382302e-06,
   1.735212991033323264e-05, 9.945028284269426117e-06,
  -8.079903875280517093e-06,-5.891956667035740680e-06,
  -9.486114339758513911e-06, 3.164432766393988265e-06,
  -4.567717473670905655e-06, 2.965022693135284498e-05,
   1.975884669232999641e-05, 3.096445928641430379e-06,
   3.052618783183365963e-06, 9.522684420086392412e-06,
  -9.176766884420261858e-06, 3.973279445119315191e-06,
  -4.511366741919154488e-06,-1.948454695700944055e-05,
  -1.947211909483893309e-05, 4.564710062688436162e-06,
  -8.324395393015490531e-06, 5.541158844568750209e-06,
  -9.945641181955068084e-06, 1.041259564085451173e-06,
   3.087724657254177299e-06, 1.976021144727415645e-05,
  -6.212968834739933128e-06,-5.967745820876212972e-05,
  -2.999703498842498986e-05, 4.217723357535934050e-07,
   1.476810100810901691e-05, 1.348714916556829256e-05,
   8.338296257366912374e-06,-5.520218793162183923e-06,
  -1.945480148330973712e-05,-4.637962833508843675e-06,
  -8.417017202867452776e-06,-5.399427877713839277e-06,
  -4.673271895236319667e-06,-8.840844404987248929e-06,
  -1.603850858279092363e-05,-1.194848285096237541e-05,
   1.321157870823311163e-06,-9.912342905709104691e-06,
   9.774451261958590033e-06,-2.111895482166707917e-06,
  -3.551681979227918120e-06,-1.968211256746662827e-05,
  -6.557827801217533807e-06,-7.549496309660560705e-06,
  -1.916434934845006197e-05,-5.720814107324390711e-06,
  -5.720814107324392405e-06, 1.916434934845006197e-05,
   3.798651968199299382e-05, 3.251191047061920695e-05,
   2.596168668501833726e-05,-3.043009734570268778e-05,
  -9.741135658294912063e-07, 9.952442050113477492e-06,
   1.404133098125676637e-06,-9.900929766579904295e-06,
  -2.930144353187931421e-05,-6.436257215811682893e-06,
  -7.073521658768452555e-06,-7.068613113117283564e-06,
  -1.925936979112849744e-05, 5.392279225760389467e-06,
  -7.488852892506413933e-05,-2.813731038034432557e-05,
  -2.490508664232336439e-05, 6.541969626449182693e-05,
   4.103864382104519177e-06,-9.119117124661461088e-06,
  -1.215736948111589655e-05, 2.742623501867567465e-05,
   1.827372323735992332e-05, 8.128409379723192709e-06,
  -4.532630969957587288e-06,-8.913767805489513995e-06,
  -1.985697743825887900e-05, 2.387560892726704962e-06,
  -2.799515307649480922e-06, 2.986909295646984102e-05,
   2.175815289308526447e-05,-2.065388057196820067e-05,
  -2.065388057196819728e-05,-2.175815289308526447e-05,
  -1.403430965884185898e-05,-1.424914567262676981e-05,
  -1.421739875787094730e-05, 1.406646979734751088e-05,
  -1.123983491689876926e-05,-5.893781562834563985e-05,
  -2.223315326775039495e-05, 2.014167063013195183e-05,
   1.425532838237961259e-06, 9.897871292712653047e-06,
   3.892891095064412473e-05,-9.194557748843614815e-06,
  -5.448639760821312832e-06,-2.950105633289759309e-05,
   1.923817111654383807e-05, 2.301939990726470709e-05,
   1.534626660484313354e-05,-1.282544741102923215e-05,
  -2.971556790960483329e-05, 4.121289095618444774e-06,
   9.094572086848299995e-06,-4.157975295395558986e-06,
   1.627011059464106882e-05, 5.775191339893552398e-05,
  -4.111368555346866451e-06, 9.115736317056622617e-06,
  -2.600873446336793743e-05,-1.495144580346720213e-05,
  -1.991372952613066773e-05,-1.855633681552415366e-06,
  -1.446934654837388159e-05, 1.380717242823674323e-05,
   2.061233754967401518e-05, 2.179751226030848357e-05,
  -1.520899447046180410e-05, 3.699576309792058779e-05,
   2.774682232344045609e-05, 1.140674585284630395e-05,
   4.531195177250722915e-07, 9.989728860317312431e-06,
   8.241807737900236805e-06, 1.822285941370036040e-05,
  -1.989424081060968972e-05, 2.054064889304127138e-06,
   2.054141277689884694e-06, 1.989423292342005987e-05,
  -2.959126441988639257e-05, 4.935288242075195680e-06,
   4.935288242075035591e-06, 2.959126441988641968e-05,
  -1.876065379115514890e-05,-6.930935674814478527e-06,
   9.326120724688462260e-04,-9.622030566805344146e-04,
  -8.903970090451662203e-04,-8.630140012093791150e-04,
   1.527395778603198457e-05, 2.582065478547189958e-05,
   2.994412335524019003e-05,-1.830157503101606862e-06,
  -1.981470032576728438e-05,-2.716183167615522710e-06,
  -2.716183167615483747e-06, 1.981470032576729116e-05,
   1.954452924196372477e-05, 4.243981233467576952e-06,
   4.243981233467543071e-06,-1.954452924196373154e-05,
  -9.998157978578147499e-06,-1.919297668266981978e-07,
  -5.606171320530321336e-06,-8.280751362338041474e-06,
   1.942233355334733137e-05,-8.787930905134905019e-05,
  -8.781011269803918869e-05,-1.973281804400118077e-05,
  -1.940599201200134724e-05,-4.838127120088923651e-06,
  -4.771069969286123236e-06, 1.942258714353410068e-05,
  -1.397033697553743465e-05, 1.431187216229699406e-05,
   8.145152216788353734e-06,-5.801421839975763504e-06,
  -5.476681723263462286e-06,-2.949586339306025414e-05,
  -3.999770772911067111e-05, 4.282247267972354006e-07,
  -1.940762590410793684e-05,-2.287671429130937807e-05,
  -2.288968242225351650e-05, 1.939232937551284644e-05,
   6.557981901003649896e-06,-7.549362448982600813e-06,
   7.178722758991083766e-06,-6.961748311275226627e-06,
  -1.340011799509990075e-05,-1.484711546790823193e-05,
  -8.499747809006797876e-07, 9.963811663807824493e-06,
   1.383550520692234439e-03,-6.294346325808957646e-04,
  -7.218170328460584784e-04,-1.561211123164740842e-03,
   1.414096783847480285e-05,-1.414330331256532579e-05,
  -1.337835423941978129e-05, 1.486672922483620239e-05,
   1.486672922483620069e-05, 1.337835423941978298e-05,
   6.083432018505223768e-06, 7.936740822039326708e-06,
   9.870019887913849640e-06,-1.607080400037625716e-06,
   5.145120879978065664e-03,-6.230098805830750971e-03,
   1.440999641032838747e-05,-1.386910247472139190e-05,
   1.089493663466344553e-05,-1.677201108175964663e-05,
   2.499108783650158647e-05, 1.659655171257759919e-05,
  -7.837955372837745723e-06, 6.210189656798246411e-06,
   1.407220736582836779e-05, 1.421171980631217895e-05,
  -1.916053692985960704e-07,-9.998164200614829020e-06,
  -4.999999836509937281e-05, 1.278632316967979715e-08,
   1.278632316967673493e-08, 4.999999836509937281e-05,
   7.489101015081742728e-05, 4.991329080104978637e-05,
   4.990251982452596454e-05,-7.489818766273849849e-05,
  -2.608992035605817804e-06,-9.653660474563284513e-06,
  -9.671881790284041384e-06, 5.921532489681005239e-05,
   4.934610408067503236e-05, 8.059901491903445465e-06,
  -8.079244131394838240e-06, 5.892861296969586906e-06,
   1.442790278196227876e-05, 1.385047368555477263e-05,
   4.873948387393284508e-06, 8.731816942482613781e-06,
  -1.860254443746470126e-05,-7.344749175577825904e-06,
  -6.566387860515267867e-06, 2.927255626803504607e-05,
   9.935926378191835807e-06, 1.130206621442148001e-06,
   7.980755487608272032e-05, 5.545645562154756095e-06,
   6.548158573568729060e-06,-8.976147068367028585e-05,
  -4.182657271222659022e-06, 9.083247114963251940e-06,
   1.902092995669097020e-06,-1.990934560039145663e-05,
  -1.990984553341071468e-05,-1.896852876668480253e-06,
   2.997677883961508724e-05, 1.180139992037020160e-06,
   6.942797838407675936e-06, 7.197052047540139671e-06,
   9.686811030918545968e-06,-2.483081160831193269e-06,
   1.922880311253380851e-05, 5.500284616218529185e-06,
  -8.829311270917481646e-07,-2.998700439565133631e-05,
   7.527370401929337249e-06, 3.928534962084667865e-05,
   3.928059119076728994e-05,-7.552162319747588405e-06,
   3.413216706453552968e-05, 2.085653785935326899e-05,
   3.169113869630592404e-05,-2.440638703559995968e-05,
   9.620139954163507324e-06, 2.730001330092528683e-06,
  -2.218460656470490659e-05, 6.639159006658337185e-05,
   6.639159006658337185e-05, 2.218460656470488287e-05,
  -1.541116124594368603e-05, 1.274739616751293720e-05,
   6.401652299703274431e-06, 1.894779269027671681e-05,
  -1.256290886386267055e-06, 9.920772813081793216e-06,
   5.556995622120761494e-03,-5.754980421837305356e-03,
  -5.048508985783040700e-05,-4.848974842218496044e-05,
  -3.999809546243802256e-04,-4.060975694802537099e-04,
   1.544170136126458097e-05,-1.271038390724369949e-05,
   1.216223632720714228e-05,-1.587702766644824473e-05,
  -1.020964091258382488e-05,-1.719776823998086542e-05,
   1.624866904086832428e-05,-1.166107861221796610e-05,
  -1.491048538718158887e-05, 2.603223819648714605e-05,
   2.603223819648717654e-05, 1.491048538718153805e-05,
   1.917919236556072675e-05, 5.670853569333032831e-06,
  -5.866259841396394022e-06, 2.942085986971183022e-05,
   2.942085986971182006e-05, 5.866259841396448232e-06,
  -3.105012292555335167e-06,-1.975750233868340730e-05,
  -1.975750233868340391e-05, 3.105012292555351260e-06,
  -6.482755751562225002e-06, 1.892019761698029702e-05,
   9.991602768263187600e-06,-4.097244454940638059e-07,
  -1.802904574738648983e-05, 8.657569487947823812e-06,
   7.818418334444251190e-06, 2.896329288509208824e-05,
  -1.518947903202119294e-05,-1.301075427236209742e-05,
  -1.301075427236212452e-05, 1.518947903202116922e-05,
   7.128206993409438845e-06, 8.971727071784512232e-05,
   9.971730873538627656e-05,-7.513876401143262509e-06,
  -9.203376590177936046e-06,-3.911247798256301039e-06,
   2.995756168027305719e-05,-1.595148323083251525e-06,
  -1.067792826453049537e-06,-1.997147512027530570e-05,
   2.618076073581025106e-06, 9.651200840980493683e-06,
  -6.090225107795121964e-06, 7.931529369319759509e-06,
   1.672138559008576477e-05, 2.490773502243173076e-05,
   1.663374721366866701e-05,-1.110488422414974836e-05,
   3.239038630033097473e-07, 9.994752937793488037e-06,
  -4.017264312556822293e-06, 1.959238595585176257e-05,
   2.859215212012509023e-05, 9.082336546265297987e-06,
  -6.048456280173136496e-06, 1.906347755858920438e-05,
   1.406516670261154185e-05, 1.421868790105991484e-05,
  -9.919062828051808641e-06, 1.736698570890069518e-05,
   9.781655149299409757e-06, 2.078273932903057781e-06,
  -1.664618644868337934e-05,-2.495805434555486147e-05,
  -1.765831275850887950e-05, 9.390633126828170819e-06,
   8.402004279276662288e-06,-5.422759822361366420e-06,
   4.987199632429309138e-06,-8.667631731118769945e-06,
  -6.326002988293376122e-06,-1.897318334365910526e-05,
  -1.897318334365910526e-05, 6.326002988293374428e-06,
   4.935448340506984772e-05,-4.964005406744320285e-05,
  -2.127430888604709081e-05,-2.115192145931564757e-05,
  -1.998809741105931701e-05,-6.898999101347489077e-07,
  -6.898999101348565868e-07, 1.998809741105931362e-05,
  -1.855282381139564457e-05, 7.469453033744228985e-06,
   1.974210810059030954e-05,-3.201432139622286067e-06,
  -3.201432139622319948e-06,-1.974210810059030615e-05,
   3.879770995602783859e-04, 1.325660975392796632e-04,
   1.423584880159883327e-04,-4.163340736593652033e-04,
   9.885102674401454422e-06,-1.511537335477104081e-06,
   8.009633937016408839e-06, 1.197323922929588712e-04,
   1.814886764739038187e-06,-2.994505278057086722e-05,
   1.097542993726829681e-04,-7.348045264659336028e-06,
   1.609765289830736885e-06, 2.995677979542621483e-05,
   9.615762858746489353e-06,-2.745378779759100553e-06,
  -6.813969010230984369e-05, 1.603067786343352708e-05,
   1.607969508800466413e-05, 6.812813960381420848e-05,
  -4.471108090555601705e-06, 1.949382446936896772e-05,
   1.950398380486504686e-05, 4.426580592236180744e-06,
   6.934453671453243547e-06, 2.918755474990100498e-05,
   1.945322540407674604e-05,-4.644569019638228235e-06,
  -8.745720787118342455e-06,-4.848955342521329795e-06,
  -3.644419995223591966e-05, 1.648697333780361999e-05,
   1.690355323223697610e-05, 4.705602924307289317e-05,
  -9.881242693691399232e-06, 1.536568523812185684e-06,
  -6.871984513236581023e-06, 7.264697436909303949e-06,
  -3.741641075088418127e-05,-1.414256718283915182e-05,
  -2.269685297161349081e-05, 3.293710468734251459e-05,
  -1.872050800361657654e-05, 7.038649024246610889e-06,
   7.009561173548273688e-06, 1.873141885053784846e-05,
   5.548975328838001897e-06,-2.948234849532762729e-05,
  -1.998882278816350110e-05,-6.685533212807827574e-07,
  -1.774187657094676752e-05, 9.231782912378853399e-06,
   9.231782912378853399e-06, 1.774187657094676752e-05,
   3.194605508106196026e-05, 2.407175865527393820e-05,
   1.805381899145546890e-05,-2.395954131079645495e-05,
  -1.694661669699145046e-06,-9.855360055586631469e-06,
   5.812702302057810359e-06,-8.137105870495470967e-06,
   7.493950890636353936e-06,-6.621231007050775130e-06,
  -1.210722895888721842e-06,-9.926436927184438210e-06,
  -1.584752898560833091e-06, 9.873629436559944951e-06,
  -1.056146588440383898e-05,-2.807944868355812158e-05,
  -2.807476203725120832e-05, 1.057391774848463678e-05,
  -3.747260909367164292e-06, 9.271355654764236473e-06,
  -1.854914260776830469e-05, 7.478590008596171464e-06,
  -1.335816577420734774e-05,-2.686185784991044706e-05,
  -1.790790523327364831e-05, 8.905443849471531841e-06,
  -1.105007933647759433e-05,-1.667020535738990104e-05,
  -2.693795283147690998e-05, 1.320404094393550564e-05,
  -9.294797724492317716e-06,-3.688730846886562938e-06,
  -2.202460428814140823e-05, 2.036950676748907433e-05,
  -2.454979531335482065e-05,-1.724260856345064834e-05,
  -1.149507237563373450e-05, 1.636653020890323974e-05,
   2.683052261112870241e-06,-9.633339533315387525e-06,
   9.914973675456628950e-06,-1.301267464821156796e-06,
   9.607259796880172016e-06,-3.882911998996694083e-05,
  -3.593002604242789491e-05,-1.757934096007167499e-05,
  -2.800948782214856551e-06,-9.599723220979296847e-06,
   1.934553736041266905e-05, 5.074463935912609827e-06,
   3.798961282497046214e-05,-1.252155411316182775e-05,
  -9.391165584871393257e-06,-2.849220961872783983e-05,
  -6.269003459865833248e-06, 7.790994520610975086e-06,
   9.868768460212827833e-06, 1.614747373030393425e-06,
  -2.972619240947842537e-05,-4.043944217551381322e-06,
  -4.008848427553184584e-06, 2.973094573478792562e-05,
  -4.810867030891050381e-04, 2.665625332091052057e-04,
   2.471580258317967516e-04, 4.461086305676330668e-04,
   7.083794718495260535e-06, 1.870347166667778483e-05,
   1.984678771639539687e-05, 2.470833329129446337e-06,
  -3.164262721153375336e-06, 9.486171062737539720e-06,
  -1.513436586920810335e-05,-2.590272128053245623e-05,
  -1.726413671857290769e-05, 1.009700863436407746e-05,
   1.838049142817570710e-05,-7.884005001188129470e-06,
  -9.337857632329515760e-06,-1.768627758569749000e-05,
   4.821777706184662713e-05, 1.323049414096305033e-05,
   1.058439531277043383e-05,-3.857422164947730306e-05,
   2.040820270091086594e-06,-1.989560385173532310e-05,
  -8.862637931877679573e-06,-4.631808382094724941e-06,
   2.485269067826638884e-05,-1.680308799150950330e-05,
  -1.120205866100636941e-05,-1.656846045217757110e-05,
  -9.891909229117948937e-06, 1.466332773585577410e-06,
   8.862816898738977138e-06, 4.631465925538786218e-06,
   1.990921063413949698e-04,-1.903505168226979856e-05,
  -4.952463242889219296e-06,-8.687525990052128827e-06,
  -5.579696206541513374e-06,-8.298613754278859518e-06,
  -7.973674852376605156e-05,-1.026744901855260671e-04,
  -9.477894458227831384e-05, 7.359994336865632902e-05,
  -9.935973323824645161e-06, 1.129793834398575845e-06,
  -9.710223730470581976e-06, 2.389886002345301052e-06,
   9.838074941923262028e-06, 1.792283860637492963e-06,
   5.574996283723492675e-05,-4.233133170178944024e-05,
  -4.233272310779045674e-05,-5.574890630567691177e-05,
   1.802972650164794530e-06,-2.994577248331987341e-05,
  -1.996384832221325233e-05,-1.201981766776490582e-06,
   1.073898876759846226e-05, 1.687228853029114462e-05,
   2.239094623843677806e-05,-1.996610944945043689e-05,
  -1.853530402916469912e-05, 7.512822675029067284e-06,
  -6.463034597399210682e-06, 1.892694332936042094e-05,
  -3.567510127549129062e-06, 2.978712593537406877e-05,
   2.978712593537406877e-05, 3.567510127549123557e-06,
  -9.736807783465742402e-06,-2.279160851682245756e-06,
  -8.169213872122995103e-06, 5.767490330422171932e-06,
  -2.609591334646045751e-05, 6.495385520978739970e-05,
   7.461687345654964208e-06, 6.657568772133907667e-06,
   2.032202107959883738e-05,-2.206842675045823652e-05,
  -1.627381631396394651e-05, 2.520243842526673008e-05,
   3.049195533908038969e-05, 2.588900653944695463e-05,
  -1.012622164903775120e-05,-1.724701815139530656e-05,
  -1.965122623360508028e-05,-3.718777691079626543e-06,
  -9.826225323539551198e-06, 1.856150826584425033e-06,
   5.321427355626165519e-06,-8.466546574536369982e-06,
  -2.998708935693762009e-05, 8.800408507783235376e-07,
   8.800408507783290433e-07, 2.998708935693762009e-05,
  -8.405414095660673009e-06,-5.417473016127435855e-06,
  -4.003917954441822992e-06, 9.163440457279046448e-06,
   1.909820790532757955e-05, 5.937883023846393726e-06,
   8.883103881584979288e-06,-4.592435674995338978e-06,
   1.676067081282767601e-06, 9.858539401911435216e-06,
  -6.910401165861555999e-06,-7.228164063360714349e-06,
  -2.705454454508197503e-05,-1.296347250771085288e-05,
   4.167829134543467510e-06,-9.090060522639586271e-06,
  -1.293732777074013690e-05,-1.525206707802047814e-05,
  -1.697798950942000623e-05, 2.473353739799514137e-05,
  -9.941483933387598544e-06,-1.080230161676790846e-06,
   1.165984955080013031e-05, 1.624955102311156200e-05,
   2.841477903074655768e-05, 2.815315848415317896e-05,
   1.706953628475567337e-05,-2.467044651041828233e-05,
  -1.995689959738700047e-05,-1.312310351942183632e-06,
  -1.312310351942215395e-06, 1.995689959738700047e-05,
  -4.692313846426760176e-06, 3.972382396958570964e-05,
   3.860636205048622612e-05, 1.046655670346160505e-05,
   1.963608146705007207e-05,-3.797934256852374180e-06,
  -3.797934256852372910e-06,-1.963608146705007207e-05,
   8.720425216846240514e-06, 4.894301179677463754e-06,
   2.163053472587496927e-05, 6.657416892063103980e-05,
   7.807637758879890761e-05,-1.743786863728764391e-05,
  -2.379737679947463704e-05,-1.826704293157013000e-05,
  -1.217802862104683973e-05, 1.586491786631636145e-05,
  -1.825834844094438892e-05,-3.558978381795910664e-05,
  -3.558978381795907276e-05, 1.825834844094444991e-05,
   1.160300464684087738e-05,-1.629018978297641120e-05,
   7.194455237465565350e-06, 6.945488739901916185e-06,
   4.989367483251797578e-05,-3.259020053169754564e-06,
  -2.607216042535598161e-06,-3.991493986601439282e-05,
   1.906398091848048574e-05,-6.046869565305009046e-06,
  -6.046869565305042080e-06,-1.906398091848047558e-05,
  -9.978183207687053190e-06, 6.601968447608203810e-07,
   2.775666182860991768e-05, 1.138278191533990186e-05,
   1.138278191533995268e-05,-2.775666182860989735e-05,
  -9.889484845811775105e-06, 1.482595522878464285e-06,
   1.998536024744846542e-05, 7.650985424810817795e-07,
   9.575049378516553713e-06,-2.884168753552707527e-06,
   2.918897986222569148e-06,-9.564519566921584240e-06,
  -1.436651921136575298e-06,-9.896263499801054579e-06,
   1.391856019650598027e-05,-2.657581009219172455e-05,
  -1.771720672812781411e-05,-9.279040131003989106e-06,
  -2.422653584786389161e-05,-1.769392440393498188e-05,
  -1.769392440393498188e-05, 2.422653584786388823e-05,
   2.976009338143595210e-05,-3.786402240678084546e-06,
  -1.900633601195957304e-05,-3.519601101546152586e-05,
  -6.757714954185432814e-06,-1.882374268305797582e-05,
  -1.961511187318964116e-05, 3.904790161104030538e-06,
   9.668028629284662786e-07, 1.997661863840408420e-05,
   1.990055336838072260e-05, 1.991977819211529382e-06,
  -1.781574390802851874e-05, 9.088413998247703188e-06,
   1.846469501219851712e-05, 7.684727588307294240e-06,
   7.684727588307278993e-06,-1.846469501219852389e-05,
  -1.811338461218212368e-05, 8.479699162774814521e-06,
   8.479699162774816215e-06, 1.811338461218212368e-05,
  -2.769757284783732258e-06, 9.608769150280772279e-06,
   9.094046757079922406e-06, 4.159124136166673225e-06,
   1.923304971232252245e-05,-5.485416917913399130e-06,
  -5.485416917913398283e-06,-1.923304971232252583e-05,
   9.974455707536007015e-06, 7.143061937309538607e-07,
  -4.962240914917091549e-06,-2.958675658301062851e-05,
   7.922766725542395089e-06, 6.101620064592539456e-06,
   8.532510874671804169e-06, 5.215003180594181899e-06,
   9.276977213589926791e-06, 2.852959329851257058e-05,
   2.852959329851257058e-05,-9.276977213589925097e-06,
   7.220118311393548729e-04, 8.430889132794926969e-04,
   9.295917036628121655e-04,-8.206456387998844635e-04,
  -4.894344942227148466e-06,-8.720400655158887202e-06,
   1.975532954477025280e-05,-1.385991592852479069e-04,
  -8.977866414114910585e-05,-6.308047640177427585e-06,
   4.918442591784920250e-05, 4.980855596312347444e-05,
   2.367578847688172624e-05, 1.842435996169078339e-05,
   1.842435996169078000e-05,-2.367578847688172963e-05,
   9.960206120370283117e-06,-8.912317542246639787e-07,
   1.689928709816498013e-06, 1.992847563050766896e-05,
   1.992847563050766896e-05,-1.689928709816496742e-06,
   7.698084330231662399e-06, 6.382750006434667899e-06,
   2.896020335404132952e-05,-7.829854512861227889e-06,
   1.086338160467255582e-06, 9.940818346650975341e-06,
  -2.772578964362808209e-06,-9.607955343691646933e-06,
  -1.934763086536244508e-05, 5.066476082808883388e-06,
   1.930596301853294529e-05,-5.223006024028536168e-06,
  -2.578024899460584852e-05, 4.284132072866246523e-05,
   3.427305658292993966e-05, 2.062419919568473506e-05,
   8.014796675313536675e-06, 1.832383786910873007e-05,
   7.932873847218861873e-06,-6.088473743403271079e-06,
   1.963439147090618653e-05, 3.806661472630111529e-06,
   3.805818464568373198e-06,-1.963455489219835762e-05,
   4.927301615402510756e-06, 8.701821578890929989e-06,
  -1.694014598357197537e-05, 1.063162518410381053e-05,
   9.890825006598009174e-06, 1.473628409354105293e-06,
  -3.039092711040688682e-06, 1.976774937856354524e-05,
   2.399637828888015568e-05, 3.200271596313289927e-05,
   2.400203697234967615e-05,-1.799728371666011422e-05,
   4.352711390698733675e-09, 9.999999052695134026e-06,
  -9.999911421488960351e-06,-4.208993198702305806e-08,
  -2.107975891933609920e-05, 2.134581373250198400e-05,
   2.134581373250198062e-05, 2.107975891933609920e-05,
  -1.455312582466769969e-06, 9.893536540960159496e-06,
   3.713226028264056859e-06,-1.965227601228474504e-05,
  -3.326499721666225700e-06,-1.972141981708605598e-05,
  -1.972141981708604920e-05, 3.326499721666264664e-06,
  -7.778317078819628930e-06,-6.284726200984644787e-06,
   1.100279798823896942e-06, 9.939284902059103777e-06,
   9.666187213542835440e-06,-1.750899268241154442e-05,
  -9.666974659533925126e-06, 2.559218812827261975e-06,
   7.444721853578015734e-05,-2.928500729530031455e-05,
  -2.983141915930045878e-05,-7.422995642557068312e-05,
  -1.090202150094506392e-05,-1.676740669253691036e-05,
  -1.717159851201270862e-05, 1.025359471318439924e-05,
  -4.748405319864817735e-06, 5.981181026284256637e-05,
   3.946045507794411711e-05, 6.547708380918819326e-06,
  -3.673287801971127247e-06,-9.300911607143148179e-06,
  -8.283236945725193430e-06, 1.820406508725381427e-05,
  -4.907871058801273404e-05, 9.554065470682473113e-06,
   1.109238148599526070e-05, 3.843122523377507001e-05,
   1.091424314636217950e-05,-1.675945394522405834e-05,
   3.362234306639678760e-06, 1.971535899919794332e-05,
   4.122756859380287341e-06, 9.110591412111114883e-06,
   9.939825949271725739e-06,-1.095381256998877270e-06,
  -1.332148928559786746e-05, 1.491770502502651323e-05,
   1.491770502502651153e-05, 1.332148928559786915e-05,
   4.188811407251124233e-08, 9.999912268910136686e-06,
  -2.948250474663124734e-05,-5.548145083256746312e-06,
  -5.548145083256748853e-06, 2.948250474663124734e-05,
  -8.934643655657912979e-06, 3.898938500087443149e-05,
   2.924203875065582362e-05, 6.700982741743428805e-06,
  -1.050629868171597607e-05, 1.701815759741850563e-05,
  -1.964966289726273826e-05,-3.727029383293914954e-06,
  -3.727029383293916225e-06, 1.964966289726273826e-05,
  -1.620394853009890089e-05,-1.172314173052197475e-05,
  -1.399222536459230785e-05, 1.429047337726989699e-05,
   6.228548577007127026e-06,-2.934629759652591333e-05,
  -1.956419839768394335e-05,-4.152365718004752480e-06,
   1.206250771298523584e-05, 1.595292787152790160e-05,
   8.781107128644360943e-06,-4.784574964954694357e-06,
  -3.432628180116553549e-06,-9.392393932170313412e-06,
   4.733894878372883339e-06,-8.808532186494807953e-06,
  -9.796911851757059481e-06, 2.005122980991957751e-06,
  -8.011728662502584338e-06,-5.984329857087973500e-06,
   5.333949737674490410e-07, 9.985764357422001502e-06,
  -1.420589451226281168e-05, 1.407808797765028228e-05,
  -8.650724230692848645e-07,-1.998128248393593891e-05,
  -2.297000898115238690e-06, 1.986765680381201625e-05,
   9.897998015784870930e-06,-1.424652687330772184e-06,
   8.542894782762946190e-06,-2.875793714317217230e-05,
  -2.875793714317215874e-05,-8.542894782762998706e-06,
  -1.588883766274058447e-05, 1.214680360123914804e-05,
  -1.812003898636487968e-05,-8.465470284196674147e-06,
  -8.465470284196706334e-06, 1.812003898636486274e-05,
   4.833201059764671147e-06, 8.754437018785940500e-06,
  -1.105038335472976005e-05, 1.667000383063877653e-05,
   1.546055657022235848e-05,-1.268744223785686326e-05,
  -5.130952167667250524e-06,-8.583316949356511102e-06,
  -1.039411239200856244e-06, 1.997297234454158490e-05,
   1.997297234454158490e-05, 1.039411239200857302e-06,
  -1.672382154172920776e-04, 9.017416095556093957e-05,
   9.961420139718706621e-05, 1.848702541784390490e-04,
   5.740287532961245175e-06, 1.915852549229532330e-05,
   2.694530286023291877e-05, 1.318903536162988939e-05,
   1.318903536162984365e-05,-2.694530286023294249e-05,
  -2.271329893887812611e-03, 1.136952291493174101e-03,
   1.282993291089432140e-03, 2.567260838913628697e-03,
  -7.626356141334771545e-06,-1.848888022584184050e-05,
  -9.049850268766609679e-06, 2.860245112071524806e-05,
   2.860245112071523111e-05, 9.049850268766662195e-06,
   8.187494722356298497e-04, 3.225667399374548285e-04,
   3.434876095515095409e-04,-9.285021605169208221e-04,
  -9.907331772595463789e-06,-1.358225735185589412e-06,
   5.968458803256055121e-05, 6.144098907368730937e-06,
   2.320597160198961404e-05, 1.901270317465803106e-05,
   1.267513544977201901e-05,-1.547064773465974834e-05,
   3.960603598865733275e-05,-5.600170824642780498e-06,
  -5.600170824642778804e-06,-3.960603598865733275e-05,
   4.815963237093837357e-06, 1.941150427192495185e-05,
   1.841153777924620427e-05, 7.811227599000669704e-06,
   1.489533353524943312e-05,-2.604091086874024075e-05,
  -2.604091086874026786e-05,-1.489533353524938908e-05,
  -9.240056579417352603e-06,-3.823787966031341381e-06,
   2.413369137816225734e-06,-9.704413913505347230e-06,
   1.807828475674049098e-05, 8.554274969522809627e-06,
  -5.008105409134165776e-06, 1.936282211380875001e-05,
   9.954746185179730959e-06, 9.502780585963281946e-07,
  -1.988999648004905176e-05,-2.094764908918514919e-06,
   4.616454976162370201e-06, 8.870645041543805790e-06,
  -3.980974014623925116e-05, 4.489080740517937553e-05,
  -8.718760656945068400e-06, 4.897265829716294393e-06,
  -1.088927229042585189e-05, 1.677568922533330105e-05,
   1.677568922533330105e-05, 1.088927229042585189e-05,
  -1.336011620485054741e-05,-2.686088782957275561e-05,
  -2.686088782957277932e-05, 1.336011620485050505e-05,
   2.927107946841391668e-05, 6.572967880173868713e-06,
   6.572967880173870407e-06,-2.927107946841391668e-05,
   4.439712157380287279e-06, 8.960410479414973519e-06,
   2.324389803098548046e-07,-1.999864925739817378e-05,
  -1.999864925739817378e-05,-2.324389803098560222e-07,
   1.825434710400307013e-05,-8.171830382880861473e-06,
  -8.171830382880861473e-06,-1.825434710400307013e-05,
   1.677892198412584337e-05, 1.088429037882665731e-05,
   5.720637165704880435e-06, 1.916440216699587387e-05,
   1.916440216699587387e-05,-5.720637165704878741e-06,
   2.111784675422385773e-05,-2.130813338763198425e-05,
  -2.130813338763200458e-05,-2.111784675422384078e-05,
  -7.001226920563143307e-06,-7.140225599151748550e-06,
   7.453625512004611558e-06, 6.666593337439595399e-06,
   1.337023720464249797e-06,-9.910215314054278578e-06,
  -8.097799846066378870e-06, 5.867336504159903719e-06,
  -9.603478612319748544e-06,-2.788045649324484055e-06,
   4.604514068511432057e-06, 8.876849114008884890e-06,
  -4.177414816326254621e-06, 9.085659329533432821e-06,
   9.460348029694328500e-06,-3.240650421915123162e-06,
   8.368291121312940845e-06, 5.474641879516414011e-06,
  -1.805819944737153784e-06,-9.835599337467418123e-06,
  -9.994499544415894681e-06, 3.316306027351904777e-07,
  -1.017898111997042541e-06,-9.948059279758683892e-06,
  -4.536274798078481350e-06, 8.911913989504052357e-06,
  -1.605686614115046381e-05,-1.192380181507458252e-05,
   9.777899790593589142e-06, 1.997608386938869347e-04,
   2.297753119954566118e-04,-1.016395579440282934e-05,
  -9.483942454086279625e-06,-3.170936064883672158e-06,
  -3.017088300268544639e-04, 3.603772771469181493e-04,
   3.828510767159024812e-04, 3.215976571081856990e-04,
  -7.879059667313455549e-06,-6.157955728885553121e-06,
   3.472726340552151191e-06,-1.969619688578572641e-05,
   3.910509655575661439e-06, 9.203690250853161723e-06,
  -3.649196527978668578e-06, 1.966426618768644924e-05,
   1.966592075118653321e-05, 3.640269359271497806e-06,
   9.963454606374455753e-06,-8.541500492979254967e-07,
  -1.927633683573709431e-05, 5.331307362664934752e-06,
   9.787278227985251979e-06, 2.051629812613838968e-06,
  -9.989340744650725232e-06,-4.615966716311095302e-07,
   9.688791230472094707e-06,-2.475343307973066276e-06,
   3.322593229136740493e-05, 3.736358418794252865e-05,
  -9.959890470092779412e-06, 8.947523812514031337e-07,
   3.878818140210072830e-06, 9.217091180799791381e-06,
  -2.354857529639637024e-06,-9.718778010382762839e-06,
  -8.543159599088381414e-06, 5.197540193640070827e-06,
   9.264747294358163890e-06,-3.763569790994063629e-06,
  -6.402533312464748167e-06,-7.681638313717927157e-06,
   1.930947473363449129e-05, 5.210008206436075856e-06,
   5.090056100521561570e-06, 8.607632014296570644e-06,
   6.651298554117433287e-06,-7.467277117128797670e-06,
  -2.298984858966990868e-06, 1.986742732761946173e-05,
  -7.761704900109054790e-06, 6.305230927065486931e-06,
   1.184626431386309017e-05, 1.611415594457537686e-05,
   1.650682261748364000e-05, 4.719666097379062028e-05,
   4.965372046481747150e-05,-5.874354773229737549e-06,
   9.728812328698794310e-06,-2.313052241727009867e-06,
   1.783772189466419615e-05,-9.045201910881684818e-06,
  -2.089785293839185821e-05,-2.152393417954410207e-05,
  -1.706749688970128113e-05, 1.042595558786038106e-05,
  -1.907028573078562844e-06,-9.816478086435173630e-06,
  -1.289330868156951056e-05,-1.528929662351294496e-05,
  -1.528929662351296868e-05, 1.289330868156948176e-05,
  -1.395123477965893276e-05,-1.433049364546926724e-05,
   2.841807556740572101e-05,-9.613167066332411613e-06,
  -9.613167066332409919e-06,-2.841807556740572101e-05,
  -7.851594684880525599e-06, 6.192936371734808219e-06,
   9.342357819072487487e-06,-3.566560020582179829e-06,
   3.998297277015794792e-05,-1.166999768983884050e-06,
  -8.752498267379184904e-07,-2.998722957761845755e-05,
   2.369714683058950055e-06,-1.985911509410464421e-05,
  -9.647262987644556113e-06,-2.632549495683500815e-06,
  -4.028442430524513519e-06, 9.152685484815358910e-06,
   6.514452368325945118e-06, 7.586956592785575237e-06,
  -2.265172476682851316e-05,-3.296815683485881395e-05,
  -3.296793543886420477e-05, 2.265204699136221333e-05,
   4.632947768221250717e-06, 8.862042370522369651e-06,
   3.576992377586627911e-06,-1.967752844060165925e-05,
  -1.967752844060165587e-05,-3.576992377586659251e-06,
   1.975846552063119464e-05, 3.098877259593913538e-06,
   8.542786219114173116e-06, 5.198153865990597714e-06,
  -7.713723080553109356e-06,-6.363841311389077376e-06,
   7.817252160600195467e-06,-6.236230324289793684e-06,
   5.108958702371982175e-06,-8.596426058395292334e-06,
  -1.156412187604994033e-06,-1.996653978165367180e-05,
  -1.996653978165366502e-05, 1.156412187605103935e-06,
   8.805063666880240771e-06,-4.740343217762347994e-06,
   4.007656254556424094e-06,-9.161806118081455407e-06,
  -6.364863828383088764e-06,-7.712879387501181099e-06,
  -9.786182733885598722e-06, 2.056848924690239909e-06,
   2.041524851925835451e-05,-2.198221162433206235e-05,
  -9.238301235297165898e-06,-3.828026944250376096e-06,
   3.466513713403698714e-06, 9.379940440897485535e-06,
  -6.053800644064375105e-06,-7.959365412011548316e-06,
  -6.402341022222341526e-06, 7.681798580747155284e-06,
  -9.556367142598007084e-06,-2.945479084270198793e-06,
  -4.710018256542610783e-04, 1.351195035157879885e-04,
   2.112194206249317881e-04, 2.535475425849521912e-04,
   5.939748104491459875e-04,-8.481700626584848788e-05,
  -2.828286798954296729e-05, 2.685145794520031148e-04,
   5.345342154968197316e-06,-8.451468348536837045e-06,
  -1.676081292807304134e-05,-1.091215606514769933e-05,
   9.984049431661029479e-06,-5.645856411113435053e-07,
  -1.893415482354498104e-05,-6.441877142419621378e-06,
  -6.441877142419651871e-06, 1.893415482354497088e-05,
  -9.903034517848582644e-06,-1.389211048868923270e-06,
  -8.399514346378450039e-06,-5.426615772742953660e-06,
  -1.630992665138556740e-05, 2.517908442788225807e-05,
  -1.562943914425868252e-05, 1.247880731624278392e-05,
   5.145672830964994608e-06,-8.574500050537565854e-06,
  -2.810100730004630621e-06,-9.597048186147002426e-06,
   2.210981787754881467e-06, 9.752515549037399663e-06,
   9.240559180458372552e-06, 3.822573221332261161e-06,
   1.242815643424247759e-05,-1.566974561522928256e-05,
  -9.318907197714300768e-06, 3.627391437436634423e-06,
  -1.062035774685154661e-05,-1.694721219932323965e-05,
   8.466239086537963383e-06,-5.321916546656555053e-06,
  -7.285588108413199425e-06,-6.849832546460402374e-06,
   1.690487927469959216e-05, 1.068761230153079193e-05,
   1.068761230153080379e-05,-1.690487927469958200e-05,
   6.826748848593699751e-07,-1.998834547934326267e-05,
   5.684350690961228678e-04,-1.180246403180999250e-03,
  -1.363451467695159843e-03,-6.489222566994557644e-04,
   1.859226974333486420e-05, 7.370719489376528459e-06,
   7.468601584800851629e-06,-1.855316658599039063e-05,
   5.793114419783595646e-06,-1.914261803723031461e-05,
   9.721212584222568181e-05,-2.732211605810122242e-04,
  -2.829066821275175343e-04,-9.981888201938419124e-05,
   9.741708456685884522e-06,-2.258122305132015958e-06,
   1.335127343834094767e-05,-1.489105428015933176e-05,
  -4.202040281624723717e-06, 9.074296527643519188e-06,
   2.429213319171725019e-03,-7.069813646473946086e-04,
  -7.635552909413481247e-04,-2.797674626841990635e-03,
   1.610832632844622395e-06,-9.869408200543884090e-06,
   4.189972632159448898e-05, 1.955617880215240040e-04,
   1.350766723039320476e-05, 3.765027126054953179e-05,
   1.999972442927070381e-05,-1.049893005630645604e-07,
  -1.049893005630278204e-07,-1.999972442927070381e-05,
  -8.669297713618644716e-06, 2.872008490852084013e-05,
   1.913840987695364162e-05, 5.807001582720929720e-06,
  -6.682472941239678101e-06, 7.439392138447841083e-06,
  -5.498628390800497838e-06, 8.352549659827396083e-06,
   3.734091434684710532e-06,-2.976670222173451253e-05,
  -2.976005772403793464e-05,-3.786682487604422163e-06,
  -1.517816872238488716e-05, 1.302394695300995211e-05,
   1.302641308402660694e-05, 1.517605225888143994e-05,
  -9.182043910401064773e-06, 3.961069253051093268e-06,
  -7.890405505172879257e-06,-1.837774471919603004e-05,
  -9.593645141280349368e-06, 1.754884534387342508e-05,
   2.981707868847250137e-06, 9.545125362448331771e-06,
   2.464498194979038677e-06, 9.691555532882483541e-06,
  -8.318041838651779319e-07,-9.965345041678405971e-06,
   1.103413453108633971e-06,-2.997970111177726261e-05,
  -3.999050391559166959e-05,-8.715483790630309924e-07,
  -9.704404653196852616e-06,-2.413406374196294471e-06,
   3.625111015149333672e-06, 1.966872060221109270e-05,
  -4.642004685486692886e-07, 9.989220085922583965e-06,
  -9.432276518975201779e-06,-3.321469504539980754e-06,
  -2.805857777387015008e-06, 9.598289542052626622e-06,
   2.922814970331293985e-05,-6.761306450733300416e-06,
  -3.612612128143609663e-06,-9.324646567650149128e-06,
  -1.662232949938312194e-05, 1.112196754238825003e-05,
   9.812280665662885984e-06, 1.928509304685446290e-06,
   1.788435871654198164e-05, 8.952637225870870453e-06,
   8.952637225870839960e-06,-1.788435871654199858e-05,
  -9.727316418503808497e-06, 2.319335097459239787e-06,
   8.915137105509163168e-06, 1.790308158921177748e-05,
   3.350203844497948743e-06,-9.422108797944925821e-06,
  -8.046090168099649873e-06,-5.938049596189825657e-06,
   1.760982209040942251e-05,-2.428773694571250894e-05,
  -2.428773694571247506e-05,-1.760982209040946655e-05,
  -8.827498235446185011e-06,-4.698433239197351651e-06,
   2.767733292606383612e-05, 2.887845636629186050e-05,
   2.887845636629186389e-05,-2.767733292606383273e-05,
   7.948378602542800826e-06, 6.068218650529969329e-06,
  -2.143954057634774271e-05,-2.098442517380780679e-05,
  -2.098442517380776952e-05, 2.143954057634777659e-05,
  -5.944020334369892973e-06, 8.041680313503966464e-06,
   1.624842957819933108e-05,-1.166141227477603561e-05,
   7.082006662622072795e-06, 7.060112012608339401e-06,
  -9.130011352268782541e-06,-1.779446241692744145e-05,
  -1.779446241692744145e-05, 9.130011352268780847e-06,
   8.022750360545678112e-06,-5.969545765999638716e-06,
  -9.922179701392796713e-06,-2.831166455673824945e-05,
  -2.831166455673823928e-05, 9.922179701392820430e-06,
  -6.455410185254593595e-06,-1.892954514350810515e-05,
  -5.459321921016706645e-07,-9.985086781877616476e-06,
  -1.967210474586115535e-05, 3.606701383240236924e-06,
   3.407388752709112736e-07, 9.994193164977307610e-06,
  -1.641514904188093638e-05,-1.142553639584748284e-05,
  -9.007181032887462402e-06,-4.344040727340430453e-06,
  -6.121712733210993052e-06,-1.904007965351097074e-05,
  -1.337937688386901797e-05, 1.486580889825344912e-05,
   7.684535404585361566e-06, 6.399055837830619203e-06,
   3.289294582129496130e-06, 9.443544946256864089e-06,
   7.737267661324513486e-06,-6.335194482967504774e-06,
   1.272681088156163604e-05, 1.542816530845338019e-05,
   4.849493021106682843e-06, 8.745422656352155823e-06,
   1.774414261792160740e-05,-9.227426659413672454e-06,
  -1.012902365404477116e-05,-1.724537270736128610e-05,
  -2.089922530028617731e-06,-9.779172961885825328e-06,
  -4.518336870363569120e-06,-8.921021910404276835e-06,
  -2.676307282859611102e-05, 1.355499659798041445e-05,
   3.378182351119520310e-06, 4.988574830552895190e-05,
   3.989406858024540633e-05, 2.909173785574949145e-06,
  -1.940159978474416497e-05, 4.855710637240988804e-06,
   4.855710637241021838e-06, 1.940159978474415481e-05,
  -9.104456264253512289e-06, 4.136287723586816102e-06,
  -9.486277365604458035e-06, 3.163944017017458415e-06,
   9.491817150041397962e-06, 2.845883706672112123e-05,
   1.939208159637486794e-06, 1.990576478595071456e-05,
   1.990576478595071117e-05,-1.939208159637521099e-06,
   1.979161410897179867e-05, 2.879585206509513869e-06,
   1.863024095796009000e-06,-2.994209647333472140e-05,
   5.225235308918287194e-06,-1.930535977303799656e-05,
  -6.003468574540958359e-06, 7.997397393808762349e-06,
   7.848199756970728610e-06,-6.197238140872481636e-06,
  -8.862256658970539617e-06, 4.632537847717202994e-06,
  -9.324326336801041235e-06, 3.613438579087583494e-06,
   1.962588145467181853e-05,-3.850295719443999043e-06,
  -9.996318242096794064e-06, 2.713330107504268759e-07,
  -1.986665995054539993e-05,-2.305606733464197102e-06,
  -8.657577819480287190e-06,-5.004632483973521756e-06,
  -7.527328989917692367e-06,-6.583260459494574028e-06,
   6.060733464695514530e-06, 7.954087620206350129e-06,
  -2.751472131013799329e-05,-2.903343092411639893e-05,
  -1.512068415051237131e-05, 1.309064210879069376e-05,
   6.693296699727425890e-06,-1.884674452762115696e-05,
   3.007532614039637269e-05, 5.191796180079482807e-05,
   1.969569095379565093e-05,-3.475594604175266503e-06,
  -9.996924615168582411e-06, 2.479883840757520625e-07,
  -9.903523846205872653e-06, 1.385718379625400628e-06,
   1.760103934545026113e-05,-9.497547786661140169e-06,
  -2.560203452804511948e-05,-1.563764138304704832e-05,
   1.919623816997207430e-04,-1.074729920127411210e-04,
  -1.047628549204661775e-04,-1.934547601609052183e-04,
   5.978795022314463718e-06, 1.908543974031376387e-05,
   2.969991542695907410e-06,-9.548777421026987422e-06,
  -2.855675775481607704e-05, 9.193018358121117883e-06,
  -1.875351818682551217e-05,-6.950219825041857180e-06,
  -4.346615324476185249e-04,-7.070851095945154124e-04,
   8.447659872723412792e-04,-5.162077360402365445e-04,
   1.782539301622530368e-05,-9.069474285597057373e-06,
  -2.597824780258929111e-05, 1.500435407164416158e-05,
  -2.703588332337260509e-05, 1.300234643920023564e-05,
   9.863971194041188069e-07, 9.951232120839673242e-06,
   1.967107680043324308e-05,-3.612303629466541991e-06,
  -1.922002905949343762e-05,-5.530866383508808862e-06,
   1.609696025703166245e-05, 3.661813581387702503e-05,
   3.661788014934850958e-05,-1.609754184240403936e-05,
  -5.078022861885707777e-06,-8.614736433238459466e-06,
   6.756612968210685320e-06, 7.372121892495213056e-06,
   1.970892430007251782e-06, 9.803855518587578348e-06,
   8.833669191882383403e-06, 4.686820735678723374e-06,
  -1.667914774547411651e-05,-1.103657693692413720e-05,
   9.921861527607170707e-06, 1.736538694722892503e-05,
   1.736538694722892503e-05,-9.921861527607170707e-06,
  -6.791668377264814345e-06,-1.881151882898510474e-05,
  -1.880567631045290602e-05, 6.807829206617217371e-06,
  -9.409283722000308202e-06, 3.386056679812084524e-06,
  -3.924608309509096814e-07, 9.992295757040487952e-06,
   1.770271654398732650e-05,-9.306654982497069155e-06,
   2.660193787620394686e-05, 1.386855800833618972e-05,
   2.800920033464365864e-05, 1.074638062855572113e-05,
  -1.572962321587932202e-05, 1.235228535480258014e-05,
   1.235228535480260724e-05, 1.572962321587930169e-05,
  -4.728584597470436018e-06,-8.811383983493477221e-06,
  -2.983769024133705756e-05,-3.116446864944008575e-06,
  -4.364288190179428278e-06, 3.976119953664703974e-05,
   9.588370748662825883e-06, 2.839567992879744331e-06,
  -7.963868422237854589e-06, 6.047875639700502579e-06,
   5.774169292656308776e-06, 8.164494410540370787e-06,
   1.068302760001751939e-05, 1.690777694722946255e-05,
   1.690777694722947949e-05,-1.068302760001749228e-05,
  -9.764974599957584693e-06,-2.155289090164755485e-06,
  -8.621825778021372649e-06, 5.065976732422501889e-06,
   1.992849624639539245e-05,-1.689685579451052868e-06,
  -2.696969919032600193e-06, 9.629452386082674390e-06,
   5.583850470573479342e-07,-9.984398136053208576e-06,
   3.312558094731602397e-04, 2.346735943537381006e-03,
   2.641271429377988183e-03,-3.150955987499027308e-04,
  -8.585336741834927117e-06, 5.127571845357143903e-06,
  -1.796339990311887549e-04, 1.147285457342149900e-05,
  -2.782057702076106180e-05,-1.122566230704903781e-05,
   1.732196294908628945e-05,-9.997479661918892059e-06,
  -1.618018870012315837e-05,-1.175591313460621297e-05,
  -9.987790819849735991e-06,-4.939985211772989097e-07,
   4.722213256982139880e-07,-9.988844128304127988e-06,
   9.854804856071707169e-06,-1.697887289764993602e-06,
   4.297737735101215075e-06,-9.029365999907584274e-06,
   6.098970336519952379e-06, 1.904737674416741720e-05,
   8.282985358543411207e-06,-1.820417956267613674e-05,
  -1.999493364305504438e-05,-4.501428771241847048e-07,
   6.474366368438076314e-06,-7.621192828372601120e-06,
   1.622019351836581885e-05, 1.170065477769357875e-05,
  -2.829778530504847473e-05,-9.961693973887302488e-06,
  -6.641129315924835856e-06, 1.886519020336566450e-05,
   1.041353421129547815e-05, 2.813464599439948163e-05,
   1.683779647616396810e-05,-1.079298892000173926e-05,
   1.207520371652889622e-05, 1.594332008097205532e-05,
   2.391479360461463952e-05,-1.811305183696780422e-05,
   1.755727633194300964e-05,-9.578206920076112423e-06,
  -5.307279002492891702e-06,-8.475422679117429250e-06,
   9.722909446757759352e-06,-2.337740766241786343e-06,
  -9.953113847752671344e-06, 9.672252755558256922e-07,
   5.321250947459042122e-06, 2.952429996382922444e-05,
  -9.796996809841789110e-06, 2.004707836057366677e-06,
   5.304272513064821426e-07, 9.985922437665509067e-06,
   8.743452329526938763e-06,-4.853044545570334462e-06,
  -7.138292578471147557e-06,-2.913837296528657884e-05,
   9.954247958228997083e-06, 9.554829072745728638e-07,
  -8.403786218157549497e-06, 2.879889541630902894e-05,
   1.919926361087269048e-05, 5.602524145438364072e-06,
   2.420205810405266128e-06,-9.702711159015329400e-06,
  -9.829383757153494777e-06,-1.839351775655509265e-06,
  -3.601213602953634514e-06, 2.978307003292141690e-05,
   3.583836394449739751e-06, 9.335744035577319872e-06,
  -9.236907577947629422e-06,-3.831388572887598109e-06,
  -3.268561388005175841e-06, 9.450741053104867492e-06,
   1.679173818011207061e-05, 1.086450776107995695e-05,
   1.086615183797266818e-05,-1.679067432338925839e-05,
   8.865678567347150900e-06, 4.625985683125421966e-06,
   6.829437100760937663e-06,-7.304710048095684809e-06,
   2.279586719282194736e-05, 1.950252391172035331e-05,
   1.997501054523097974e-05,-2.238300591336898915e-05,
   7.441967796055765823e-06,-6.679604428592227582e-06,
   7.421547073336576996e-06, 1.857203917286007940e-05,
   1.857203917286008279e-05,-7.421547073336576149e-06,
  -5.503874247595306836e-06,-8.349093859015910762e-06,
  -7.983578539847950567e-06, 6.021833084541556273e-06,
  -7.771439150346032195e-06, 6.293229181625991255e-06,
  -8.704493867302705155e-06, 4.922579254221267470e-06,
   8.178679644185062720e-06, 1.825127938742358163e-05,
  -9.071703914105389864e-06, 4.207634501094999682e-06,
   4.780280035253638400e-06, 8.783445951593000966e-06,
   5.086326936013429066e-06, 8.609836136651164977e-06,
   2.991141810979003438e-05, 2.303707156156104976e-06,
   2.303707156156110058e-06,-2.991141810979003438e-05,
   9.543512358469856185e-08,-9.999544596489702068e-06,
   9.650344740258686235e-06, 2.621229939200588272e-06,
   1.997437955651658643e-05, 1.012008563309771009e-06,
  -1.497196811499473530e-05, 2.599692617913858418e-05,
   2.599692617913858079e-05, 1.497196811499473699e-05,
  -2.957430611903807898e-06, 9.552675236590756766e-06,
  -8.486353462732764528e-06,-5.289783067911539838e-06,
  -6.106349554051198337e-06, 7.919122118248888027e-06,
  -9.778904440439336186e-06, 2.091178601830994983e-06,
  -7.964662523823866442e-06, 6.046829820790035708e-06,
   1.158119367711743943e-05, 1.630570308245232191e-05,
   1.711677268526531621e-05, 2.463769658147764422e-05,
   2.463769658147761373e-05,-1.711677268526536026e-05,
  -1.117848150285559118e-05,-1.658437672299792597e-05,
  -1.658437672299790903e-05, 1.117848150285561998e-05,
  -2.303944598460992382e-05, 1.921415958927794924e-05,
  -9.189890056150690784e-06,-1.776361226653697218e-05,
   3.637699648581049689e-06, 9.314888151057602755e-06,
   1.971332879101395883e-05,-3.374117362715797157e-06,
  -9.465590934980595635e-06, 3.225304365732511460e-06,
   2.959610075742106214e-05,-4.906202192794397516e-06,
  -3.892834469961030681e-06,-1.961748811110849684e-05,
  -1.098026904400644611e-07,-9.999397150287217401e-06,
   9.905715556296814720e-06, 1.369963254156589623e-06,
  -9.727604131361573480e-06,-2.318128094717216189e-06,
   3.819193455667483939e-05, 1.189016967156763139e-05,
   8.539892705358415506e-06,-2.875882877623784858e-05,
   6.159553676765636273e-04, 1.737785516985034526e-04,
   1.916632023533328317e-04,-6.628462995775607049e-04,
  -2.284063780437280781e-05, 6.616876351186754750e-05,
   4.581361057837898927e-06,-8.888820554928895446e-06,
   8.694101934993319833e-03, 1.855988023653548560e-03,
   2.150587215537765832e-03,-1.011388029533499648e-02,
   4.738287879948865905e-05, 1.596442284183704997e-05,
  -9.542761453756875783e-06, 2.844179501783760481e-05,
  -1.801222614742334133e-04, 6.557102797130817933e-04,
  -9.030215632464647880e-06, 4.917779179295458686e-05,
   2.986991929879294439e-05, 2.790684697990226928e-06,
  -2.848703251435097504e-06, 2.986444189643033026e-05,
   6.735328247513862061e-06,-2.923414704413730504e-05,
  -2.923414704413730504e-05,-6.735328247513856979e-06,
   1.177225326084386610e-05, 1.616830396679104666e-05,
   2.183020193355992682e-05,-2.057771327285897549e-05,
   1.457854166660849365e-05, 2.621957518486827172e-05,
   3.525864706924663420e-05,-1.888988636403899089e-05,
   3.448551597508920573e-05,-2.026694816522377340e-05,
  -3.495778580312794811e-05,-1.944101879384478891e-05,
   2.220449234543610957e-06, 2.991771390325161030e-05,
   2.991771390325161030e-05,-2.220449234543608839e-06,
   9.905097558103435505e-06,-1.374424375676374373e-06,
   2.352778897007198666e-06, 1.986112865528537108e-05,
   1.986631187869280599e-05,-2.308603980441256994e-06,
  -7.816469991692117953e-06,-6.237210664149210688e-06,
   6.619135171397402100e-06, 7.495802130710889531e-06,
   5.907575010910178162e-06, 8.068491649030172592e-06,
  -9.356577701781167475e-06, 3.529086809718836757e-06,
   9.297225706665733565e-06, 3.682606978665233222e-06,
   1.186150663447968999e-05, 2.755548330841239819e-05,
   2.753569311057988580e-05,-1.190737607199686697e-05,
  -3.710877166168761706e-05,-1.493114415444209947e-05,
  -6.623889052564921748e-06, 1.887125045722489171e-05,
   7.708366029825847044e-06, 6.370329124168305447e-06,
  -7.132200547539811191e-06,-7.009401925248175850e-06,
  -1.180521712121529695e-06, 9.930073941678866660e-06,
   8.741033786894429725e-06,-4.857399338778934251e-06,
  -5.157868861077454181e-06, 8.567169241466377635e-06,
   5.882041878002337226e-06,-8.087124541233846334e-06,
  -9.995815258023243589e-06, 2.892703363114515233e-07,
   1.032593558051892753e-04,-2.055176523773501163e-04,
   8.664729523936044115e-06, 4.992240206263222880e-06,
  -9.177235956233869584e-06,-3.972195891897606191e-06,
   2.355434300977708116e-05,-3.232944362926411057e-05,
  -2.423051190128606611e-05,-1.768847910368877356e-05,
  -3.434805398137760187e-06,-9.391597940548972794e-06,
   6.565021682377261189e-06, 7.543241366277261378e-06,
   2.738306640070697321e-05,-1.225429208459113266e-05,
   8.269290280061857191e-06,-1.821040467051939421e-05,
  -1.821121281105417475e-05,-8.267510384057364899e-06,
  -3.198453775204965124e-06, 9.474697538596000613e-06,
   4.809763552759264258e-06,-1.941304135282642164e-05,
  -1.941304135282641147e-05,-4.809763552759299833e-06,
  -1.738941167089504795e-05,-9.879694415321717727e-06,
   5.882105872277063731e-06, 8.087077995625100942e-06,
  -9.333428757492228100e-06, 3.589861784082652203e-06,
   7.994653969556809894e-06,-6.007121432687169322e-06,
   4.523720011329275173e-05,-2.129778687821591937e-05,
   4.610542051223556896e-06,-3.973339781586643761e-05,
  -7.442035207720546773e-06, 6.679529322268734351e-06,
   3.502295838526193653e-06, 9.366638877390443780e-06,
   8.519391181612531239e-06, 1.809474989864913143e-05,
   1.809722484684172359e-05,-8.514132536133940269e-06,
  -9.603520511100319205e-06, 2.787901324092275513e-06,
  -9.993036499150436677e-06, 3.731240097436805077e-07,
  -4.685601619624203698e-06,-1.944338287084259107e-05,
  -9.977650210700554487e-06, 6.682037660079321631e-07,
   7.087414368372823805e-06,-2.915078999908891929e-05,
  -2.915078999908890574e-05,-7.087414368372877168e-06,
   2.026399540358284997e-06,-9.792533119823274750e-06,
  -1.849960957588011253e-05,-7.600292464109841197e-06,
   9.731984297788553217e-06, 2.299669895353907241e-06,
   1.018598000398266660e-05,-1.721179279908009282e-05,
   1.159909714695426230e-05,-1.629297226952521104e-05,
  -3.137607071497418575e-05,-2.481012266170684962e-05,
  -1.860759199628009487e-05, 2.353205303623066811e-05,
  -1.682288201219318691e-05,-1.081622118874364250e-05,
   9.182368219414604389e-06, 3.960317396760602565e-06,
  -1.484606919056157975e-05, 1.340127716260873026e-05,
   1.340127716260875906e-05, 1.484606919056155265e-05,
  -2.008742262205972710e-06, 9.796170400928499411e-06,
  -1.200059102118700991e-05,-1.599955671705331363e-05,
  -1.599955671705333396e-05, 1.200059102118698450e-05,
   1.661842609908099574e-05, 2.497654727918539915e-05,
   1.665103151945691244e-05,-1.107895073272069771e-05,
   9.462685740085001018e-06, 3.233817957831265941e-06,
   1.892252735981012383e-05,-6.475952309679049401e-06,
  -6.475952309679082435e-06,-1.892252735981011028e-05,
   9.053033114480495562e-06,-4.247657169325177603e-06,
  -8.495396501285134078e-06,-1.810602767826097146e-05,
   9.450255551424300172e-06,-3.269964833568431789e-06,
  -5.725720441005794565e-06,-1.916288405828956703e-05,
   1.976162020741896024e-05, 3.078695629277216076e-06,
   5.963736330087627715e-06,-1.909015057523625163e-05,
   4.172476465907605053e-06,-9.087928264541220052e-06,
  -1.740528456482435486e-05, 9.851703873822394473e-06,
   9.851703873822397861e-06, 1.740528456482435147e-05,
  -5.031677938581428667e-06,-8.641887358811901719e-06,
  -6.595330239414247694e-06,-1.888125046264330548e-05,
  -1.993190633590817890e-05,-1.648972351673445171e-06,
  -1.648972351673446442e-06, 1.993190633590817890e-05,
   1.977827227461017545e-05,-2.969839361209046336e-06,
  -2.318286306484142416e-06, 9.727566427486791656e-06,
   1.161015756247596415e-05,-2.766232530671422447e-05,
  -1.844155020447616546e-05,-7.740105041650611711e-06,
  -9.585431529571567747e-06,-2.849474055311836877e-06,
  -8.580844925843374068e-06,-5.135085233823098634e-06,
   3.491508172504969645e-06,-9.370665434286459442e-06,
   6.376879894284023703e-06,-7.702947670462016554e-06,
   7.289325793373154962e-06,-6.845854912139523999e-06,
   1.672075148238634786e-05,-1.097344384704613891e-05,
   8.962208831502615681e-06,-4.436080799595125444e-06,
   9.599036509166902867e-06,-2.803301285213722312e-06,
   3.730123805533128821e-06, 9.278263651966086952e-06,
   9.077010488958701972e-06, 1.782155662626959679e-05,
   1.782155662626957985e-05,-9.077010488958732465e-06,
   9.484903290839505677e-06,-3.168060852228368633e-06,
  -9.510082297435668282e-06,-2.845273861504373181e-05,
  -9.996652730261534751e-06, 2.587164288455779460e-07,
   9.998943078507957911e-06,-1.453867695419033960e-07,
  -7.167447902036613523e-06,-1.867157439991579940e-05,
  -9.561896495561288307e-05,-3.262775100138182670e-04,
  -3.640899790259775871e-04, 1.088048122688662196e-04,
  -8.343520803284469210e-04,-3.707270775928242588e-03,
  -4.398882564306433839e-03, 9.949533584248332427e-04,
   1.954416709273472025e-05,-4.245648672613563572e-06,
  -4.245648672613571196e-06,-1.954416709273472025e-05,
   4.061933662390311323e-04,-1.917448030383980036e-03,
  -2.087817477337016326e-03,-4.697000972174657186e-04,
   9.400660007303311412e-06, 3.409925428376423216e-06,
   1.941395412181899264e-05, 4.806077959824145920e-06,
   7.115947522754223694e-06, 1.869126242000277883e-05,
   1.869126242000277883e-05,-7.115947522754218612e-06,
  -3.033865055490491552e-05, 5.176452726054172655e-05,
   3.361935223559007194e-05, 3.700998723668146723e-05,
   7.805098322281389935e-06,-6.251435049612228175e-06,
  -1.902042013103478034e-05, 6.182525215389493047e-06,
   6.182525215389492199e-06, 1.902042013103478034e-05,
  -9.963185389395496627e-06,-8.572846064966628410e-07,
   9.557150690901063711e-06, 2.942935723288793670e-06,
   2.953548947472871440e-05,-4.034420480674008125e-05,
   7.010250203591586788e-06,-7.131366775243307137e-06,
   7.770269539253491230e-06, 6.294673247067663636e-06,
  -1.127965465958682160e-05, 1.651573161444752204e-05,
   2.593604734637760894e-05, 1.507718302755720430e-05,
   1.005145535170480061e-05,-1.729069823091840822e-05,
  -8.451534394024754889e-06, 1.812654314497435197e-05,
  -1.800014786463081151e-05,-8.717492578226089972e-06,
   1.133686634809246227e-05,-1.647651241633036812e-05,
   1.602274649817380590e-05, 1.196961129925525776e-05,
  -1.255766578684623381e-07, 1.999960575868931271e-05,
   6.945346899192379180e-06,-7.194592167029262207e-06,
   5.680152444318680181e-06, 8.230180326657524136e-06,
  -8.564247475855258108e-06,-5.162718777185800449e-06,
  -1.979864248934193357e-05, 2.830857746200660525e-06,
   8.141442983918531268e-06, 5.806626054741578492e-06,
   3.181555898801581393e-05,-2.424397257629380770e-05,
   6.896867736704260299e-06,-7.241078332845728276e-06,
  -8.964473359294888475e-04, 9.689077220793124385e-04,
   1.103627869277602628e-03, 1.030585040718997930e-03,
   1.368347366604139823e-05, 1.458638229413831047e-05,
   1.451378207732168951e-05,-1.376045529086940481e-05,
  -1.841343686129625099e-05, 7.806749833000704703e-06,
   1.405610629169835075e-05, 1.422764477756167778e-05,
   1.422764477756167947e-05,-1.405610629169835075e-05,
  -1.986107113684841086e-05,-2.353264391658314520e-06,
  -1.757917338227201232e-05,-9.537959068690703016e-06,
  -9.537959068690699628e-06, 1.757917338227201571e-05,
  -8.794579305889075680e-06,-4.759766258171471592e-06,
  -1.162673881133518139e-05,-1.996617613480683418e-04,
  -2.197276122589722188e-04, 1.094424099564563554e-05,
  -1.799583426099048296e-04, 6.095075819951807986e-05,
   6.865651024550306354e-05, 2.090126398113500159e-04,
  -7.829860945501179530e-06,-6.220392075594221491e-06,
   7.517420748231561548e-06,-1.853343965091363337e-05,
  -1.857160616311719019e-05,-7.422630566185252891e-06,
  -1.447734076916284912e-05, 1.379878995613511479e-05,
   1.372464142956926215e-05, 1.454765333755760951e-05,
   5.637082375217765395e-02,-1.076748508364547448e-02,
   9.105021575332940612e-03, 4.772928615963857590e-02,
   8.215163006641223314e-03,-1.578081796660083230e-03,
   1.227827129430871965e-03, 6.368073711719985167e-03,
   1.964985406160925027e-05,-3.726021384460712284e-06,
   5.472109147609525298e-02,-6.307021601092560603e-02,
  -2.621408145781660694e-05, 3.021294314235135523e-05,
   7.641916250353322771e-05,-1.051670651975159833e-04,
   2.308248402853731868e-03,-2.904494673901675001e-03,
   1.057781538142416061e-05,-1.697379809460765560e-05,
  -3.780131924667777185e-04, 3.995072293727297487e-04,
  -3.589867435802998266e-05, 3.480352251333363145e-05,
   8.093647885564450746e-06,-5.873062566029592459e-06,
  -1.394134255321646961e-04, 1.138591093474192574e-04,
   1.864460493272775024e-04,-2.722827036193272376e-04,
   3.423997208923809318e-05, 2.067907907350316694e-05,
  -2.752842655819656811e-06, 5.993681554197136097e-05,
  -8.990522331295706178e-05,-4.129263983729320680e-06,
  -7.487465751601376466e-05, 2.817420206251891317e-05,
  -1.408710103125945997e-05,-3.743732875800688233e-05,
  -1.767457653745052289e-03, 5.793905782958811736e-04,
  -3.488803482211757243e-04,-1.064275576448633345e-03,
  -3.569069595601210426e-02, 1.001794001656534927e-02,
  -6.729072198879882186e-03,-2.397351845979771648e-02,
  -1.059071096617569845e-04, 2.972682497497136203e-05,
  -1.891707043861814286e-05,-6.739543342111807491e-05,
   6.743753704167271918e-04,-2.723020268006089151e-04,
   3.213038008272214277e-04, 7.018547192716675280e-04,
  -5.027593776748832122e-01, 1.179941717203190493e-01,
  -8.738404975492047866e-02,-3.723332248785079512e-01,
  -1.460321185299416754e-03, 3.427273490191676524e-04,
  -2.536182382741841799e-04,-1.080637677121568411e-03,
   1.774795410851376119e-06, 2.994745567238761257e-05,
   1.173358976478179819e-05, 2.761019505964794666e-05,
   4.893017421315902678e-04, 1.600736264684687047e-04,
  -1.435554666794493608e-04, 4.324506787889132288e-04,
   7.044051176555826688e-02,-1.023360651023120030e-02,
   8.724012967699245127e-03, 6.004959614967793347e-02,
   2.078183123176066129e-04,-3.019187085063995845e-05,
   2.587874644340580597e-05, 1.781299819865199191e-04,
  -1.384547155236843423e-04,-8.404357136835332773e-05,
   8.092795605963932690e-05,-1.289524522580633506e-04,
   1.263509213248389419e-02,-1.282359857311350659e-03,
   1.197542354937988947e-03, 1.179938525128023698e-02,
   3.979556577160282002e-05,-4.038928684445199525e-06,
   3.029196513333867456e-06, 2.984667432870211841e-05,
   9.983172881904143052e-06,-5.798786166205317685e-07,
   2.991970411897386674e-05,-2.193468816875254609e-06,
   6.755742223458409916e-06, 8.974603640119833059e-05,
  -4.865107909535363391e-04, 4.459901907954528458e-04,
  -2.121954338371401596e-05, 2.120686159210454313e-05,
   7.655980668463700369e-06,-6.433192054035859837e-06,
   6.217823722058663926e-05,-3.850115151734301647e-04,
   3.159068842448658262e-04, 5.101804079637877224e-05,
   2.334455503057352495e-06,-1.986329070180077911e-05,
  -1.974636345938835959e-05, 3.175079546992829361e-06,
  -7.937698867482063873e-06,-4.936590864847090405e-05,
  -1.489866584031682617e-04, 1.740619481269948968e-05,
  -9.399345198857710602e-05,-8.045279553771086728e-04,
   3.605811934215497617e-06, 1.199458132670543450e-04,
  -2.999743679099262772e-05,-3.921555436328342143e-07,
  -6.535925727213934277e-07, 4.999572798498771287e-05,
  -1.333712131483277377e-05,-3.771102219555223881e-05,
   2.828326664666419436e-05,-1.000284098612453205e-05,
   1.841886711839870296e-05, 7.793929309069409637e-06,
  -4.974724315016968649e-05,-5.021135226011706599e-06,
  -1.488886995966562120e-05, 1.335370927211487239e-05,
   2.003056390817234417e-05, 2.233330493949839708e-05,
  -4.666396088715339772e-06, 8.844475538053242557e-06,
   1.855548062014297583e-05, 7.462850591797917073e-06,
   3.098099385230528811e-05,-7.375756245920429876e-05,
   5.959515386625090816e-06,-8.030204004667553780e-06,
  -2.129646432325554350e-06, 9.770599064196782788e-06,
   1.269556955101808100e-05, 1.545388345288208071e-05,
   6.947733922408599471e-05,-5.720925916616368225e-05,
   4.203931859008693256e-06,-1.955318278247333795e-05,
  -1.064869431397797346e-05,-2.804648479591432200e-05,
  -2.804648479591432877e-05, 1.064869431397795313e-05,
   3.657550561427835888e-05,-1.619359098717429045e-05,
  -1.619359098717429045e-05,-3.657550561427835888e-05,
   2.770922508061120129e-06, 9.608433194559886354e-06,
  -2.673124716275120870e-05, 6.469497990666590208e-05,
   6.906278405164597905e-05,-1.141629795668072318e-05,
  -6.784635567131250614e-04, 1.742580615699651286e-03,
   2.758200884006280218e-03, 1.074210353453631086e-03,
  -2.774820827557451385e-05, 2.881036163423392833e-05,
   1.440775945294760987e-05, 1.387142629818573672e-05,
   5.373121072909989478e-03,-5.117222873380697888e-03,
  -4.758320051645859375e-03,-4.996838028804310473e-03,
  -5.939442950762348534e-05,-3.704459128488184888e-05,
  -3.704459128488174724e-05, 5.939442950762354633e-05,
  -5.718645094006847490e-06, 8.203480864169271421e-06,
   2.164922514839569433e-05, 1.281846755680025450e-04,
   2.563693738069854717e-04,-4.329831606210722946e-05,
  -1.149222499407337136e-05,-1.636852970445407343e-05,
  -2.056982208566295357e-05,-2.183763767819616057e-05,
  -5.095067625371549981e-05, 4.800029780417066131e-05,
  -3.284221341837617386e-05, 2.283394442013538786e-05,
   4.567216485098824663e-05, 6.568145368233071373e-05,
  -1.722466882694125161e-05, 1.016419125175231746e-05,
   4.139901752367087688e-05, 6.845525069762576611e-05,
   8.859406548648032586e-06, 1.793072546233900836e-05,
   3.585607138716970487e-05,-1.772969668883791602e-05,
  -2.948095008033885856e-06,-9.555560466220999359e-06,
  -1.925783362959040525e-05, 5.397762860205778786e-06,
   9.129469686388987966e-06,-1.779474032531255147e-05,
   7.706091294670708403e-06,-3.925068352217831597e-05,
   7.000651362157089368e-07, 9.975465342782526617e-06,
   9.788740185570023904e-06,-1.744077307860539299e-05,
   1.398191663031114855e-06,-9.901770552453248721e-06,
  -3.872837543865981422e-07, 9.992497750492028026e-06,
  -4.573333110828440517e-06,-8.892953629554147221e-06,
   2.383368617697875590e-05, 1.821964333397588061e-05,
   6.902243239801870422e-06,-1.877122900234850061e-05,
   3.956389209301703887e-06,-1.960476943053707666e-05,
   2.364670405546340031e-04, 3.040819517618783933e-03,
  -7.994465316017894331e-05,-2.975303530514660197e-06,
  -6.433828201305033763e-06,-7.655446079497395086e-06,
   3.231442894670663376e-06, 9.463497071298881684e-06,
  -1.034088452167174807e-04,-3.750480943752372033e-05,
  -5.913688283622640131e-06, 8.064012083581244275e-06,
  -6.673348890915221704e-05, 1.230716923504834913e-04,
  -3.904444158692211983e-06,-9.206265030491696532e-06,
   3.124137392650626777e-04, 3.098348842826150569e-04,
   8.014467875049889102e-06,-5.980660889884438004e-06,
   8.794986293587556906e-04, 2.970119452261406643e-05,
  -1.027637708604886160e-05,-3.865741939117677488e-05,
  -4.599578829427077550e-06,-1.946391210912868706e-05,
   3.816785834019519383e-05, 3.229883263715257980e-05,
  -3.054347446242646223e-06, 9.522130101906349490e-06,
   2.172388382868887735e-05,-2.068992197659599524e-05,
  -1.289427878312863535e-07, 9.999168653316449411e-06,
   5.347482967133736113e-06,-8.450113958770887033e-06,
  -9.842091169406396893e-06, 1.770096441749050620e-06,
   1.658225579041443159e-05, 2.500057585139324324e-05,
  -3.121557976114859958e-05,-2.501174884280125981e-05,
  -5.011374291024918708e-05, 6.235874254285000366e-05,
   6.205699737389994402e-05,-6.518380992958125008e-05,
  -1.206681404357734473e-04,-1.050675967354943537e-04,
   2.197998445917861140e-06,-9.755449904117322101e-06,
   9.985153323652744663e-06,-1.732907132835301707e-05,
  -2.594871648805110567e-05,-1.505536823271834561e-05,
   1.471329241080556079e-04, 8.515810380353213565e-05,
   1.544875716762180557e-04,-2.687630744681742908e-04,
   3.003763093973610149e-04, 7.664249965143905428e-05,
   5.466569795667921341e-05, 5.840942960609287653e-05,
   5.110825090533121953e-05,-4.783248571209434307e-05,
   1.170618102448285294e-04, 2.639190372450915580e-05,
   7.285790547908026237e-05,-3.218566848912748544e-04,
  -1.810249162849752219e-05,-8.502928721339325467e-06,
  -5.469121280719623754e-05, 1.179358776695114508e-04,
  -2.517276903690035590e-05, 3.108587619828128633e-05,
  -1.480343632427427009e-04,-1.191042707014140469e-04,
  -1.938335274213690221e-05,-4.928045908257535456e-06,
  -1.439972917370050791e-06, 1.994809459565601817e-05,
  -1.993901636223937307e-05,-1.560649386105235094e-06,
   1.988169694289865100e-06,-9.800366384309689051e-06,
   8.493934142630581806e-06, 1.810671374879093152e-05,
   5.530359753784956563e-05,-2.327041253118558898e-05,
   1.781124654629631743e-05,-9.097224657391264730e-06,
  -4.980088677599911213e-05,-9.808094451178637856e-05,
  -1.366712941878901094e-05,-1.460169762219694824e-05,
  -5.264946117185140230e-05,-2.877558406555306460e-05,
   2.752384829949148048e-05,-1.193472977434260965e-05,
  -3.024220737705432755e-04, 6.812407281074789615e-05,
  -5.635861664462749733e-06, 1.918950398783249447e-05,
   5.824456568801864459e-05, 1.440730952725322182e-05,
  -4.914603389830956937e-06, 2.959470684971659106e-05,
  -8.433625735285976000e-06, 5.373449260681828965e-06,
   7.474903368235112351e-05,-2.850582332708071241e-05,
   9.616475069504564572e-05, 2.522941551517983850e-04,
   4.994466231462326042e-06,-1.936634470060838599e-05,
  -9.867190076289818410e-06, 1.624364490614022234e-06,
  -1.667078533449165950e-05,-2.494163018592204862e-05,
  -8.166696914347126716e-07, 1.998331930924119625e-05,
   3.996663861848239249e-05, 1.633339382869427673e-06,
   2.639031440209250795e-04, 6.483480011350931929e-04,
   1.343035671792850317e-03,-5.465850201861800241e-04,
  -1.821964467869281431e-03,-1.726425636342847521e-03,
  -3.095116420214038232e-03, 3.266535526413486684e-03,
  -2.069018319079291509e-05,-7.727817492365765886e-05,
  -1.062547491881921726e-04, 2.845923883301125615e-05,
   1.375406414480619040e-05, 2.666131503696989076e-05,
   1.772964671656373695e-05,-9.255248635549491714e-06,
   2.579529623149445607e-05,-1.531674548751946728e-05,
  -7.638673767971990429e-05,-1.290932465570901119e-04,
  -8.429366461702453232e-06,-1.813686249201680242e-05,
   4.257671372706238954e-06, 9.048327717431425965e-06,
  -1.281030816641721133e-06, 9.917608585078070856e-06,
  -2.777183494378628886e-05, 1.134571213521173382e-05,
   2.626708315056310635e-05, 6.488482367057340800e-05,
   2.859854008839838799e-04,-1.196342362420851256e-04,
   2.462115883365852652e-05,-5.471561511751246823e-05,
  -8.221444605719079989e-05,-3.661672923008369698e-05,
  -7.428804423343159200e-05,-5.080636263276197502e-05,
  -8.459993570002151452e-05, 1.238662620714463139e-04,
   4.178367180223882120e-05,-4.305954912354276811e-05,
  -7.894250672649522733e-05,-7.660339830410435081e-05,
  -3.339228945116278574e-06, 9.426003928075652643e-06,
   1.079736459563866512e-05, 1.683499087581721040e-05,
   1.750067968044286015e-05, 9.681229814570793159e-06,
   6.740215763593234571e-05,-1.889309784077049611e-05,
   1.977854598577267179e-05, 2.968015951553470122e-06,
   4.336708130785394332e-05,-5.494812334227607275e-05,
  -4.709839143623670445e-05,-3.717178397816044637e-05,
  -3.507320398050780423e-06,-9.364758599420324809e-06,
  -1.416430932247319152e-04,-1.550394599504587598e-04,
  -1.476566285242462094e-04, 1.348981840235544735e-04,
   7.857503552824284942e-06,-6.185437568786363376e-06,
  -2.097854849178227318e-04, 9.489484590533602543e-06,
   1.772695597377682251e-06, 1.992128385217774609e-05,
  -2.343113499333674324e-05,-4.416992090692523082e-05,
   9.087014567170906257e-06, 4.174465984533081742e-06,
  -3.520107420340550230e-05, 1.899695699122203859e-05,
   1.424771774341647982e-05, 2.640080565255415213e-05,
  -6.812920210429721695e-06,-1.880383254037108106e-05,
   1.913425539944192802e-05,-5.820676104107451796e-06,
  -3.997838999100385883e-06, 1.959635893060933178e-05,
  -6.912996161224718344e-06, 7.225682256707135423e-06,
   7.828249707084508337e-06, 6.222419667905027816e-06,
   3.376125387227267398e-04, 2.557814101033602325e-03,
   3.377887718710440761e-05, 2.577964069881085482e-04,
  -4.626958460808687501e-02,-4.502353984523085884e-02,
   3.726157531680854978e-02,-3.829281792855944444e-02,
   2.150058297725790290e-05, 2.092187686700329878e-05,
  -1.394791791133553195e-05, 1.433372198483860306e-05,
  -7.741025094527735422e-05,-6.330602695312024381e-05,
   4.431420940973713948e-05,-5.418718339598362229e-05,
  -2.148740725981904479e-03,-1.917632209915853423e-03,
   1.451540763909655880e-03,-1.626477608425204620e-03,
   1.166122256572402633e-04, 1.236995910553663892e-04,
  -1.164230679008420601e-04, 1.097527642501815203e-04,
   3.269751265440634148e-05, 3.782687756364431120e-05,
  -3.782687756364430442e-05, 3.269751265440634826e-05,
   8.454946590172985428e-04, 8.740012341651486527e-05,
   3.992830782212977307e-05, 2.393790814012472333e-06,
  -1.797281231831727324e-05,-6.765336663737098698e-05,
  -2.900463965811213708e-04,-1.318473772143499007e-03,
   5.176331792216120475e-06, 2.955005227029036381e-05,
  -3.224854706550640132e-03,-1.840968256439089526e-02,
  -8.627219653693527914e-06,-4.925008711715060861e-05,
  -7.415880445403181452e-06, 8.936591396884462315e-06,
   1.723620506536997006e-04, 1.972483542008513727e-03,
   3.660569538592906102e-06,-9.305924492124665920e-06,
   2.333189920481613429e-05, 5.294861872414579262e-04,
  -9.339606320457854094e-07,-3.998909498272983781e-05,
  -6.059909523552157189e-06, 1.905983988826668736e-05,
   7.431262913292690479e-06, 6.691511900424346334e-06,
  -9.923198552471200153e-06,-1.236984433302816121e-06,
  -4.878508978821818128e-04,-4.765091971980766651e-03,
   4.915958474839346584e-05, 9.128813031578677769e-06,
  -7.841916351659410024e-05,-1.582513170111634677e-05,
  -9.996302926911403359e-06,-2.718966594545155997e-07,
  -3.462834389863779744e-04, 5.087022590639270583e-05,
   1.809363364652868085e-05,-8.521761640952257372e-06,
   4.426799990366967613e-04,-1.855651326431508605e-04,
  -5.730609853519490267e-06, 8.195127253846967908e-06,
  -1.413281816962794950e-04, 3.955077054349553705e-04,
   4.190034955013876823e-05, 4.294602085847052785e-05,
   3.521684195979098641e-05, 1.896771052022635064e-05,
   1.786196624528528461e-05, 3.579036409220070548e-05,
   2.984870510978908826e-05,-3.009120015694079539e-06,
   1.192729217852924940e-05,-1.605427361446151095e-05,
  -7.032856160241556259e-06,-7.109074076794558224e-06,
  -9.930653746594469942e-06,-1.175634367160650875e-06,
  -2.941043964890874810e-05,-5.918280126683461416e-06,
  -8.070665939059402293e-06, 5.904604245849710649e-06,
   8.541279357023917926e-06, 5.200629475868966128e-06,
  -3.032924517477706837e-04, 1.020474826383591766e-04,
  -3.688105394352414853e-05, 1.548508508258388699e-05,
   3.549711202140845502e-04,-5.996252007677751458e-05,
   1.354738550569752520e-05, 1.471286328217647316e-05,
  -8.689603308712777721e-06,-4.948817468568421153e-06,
   6.126546811353023213e-06,-7.903507080296703007e-06,
  -1.497979066950063465e-05, 2.599241950065329487e-05,
   1.565806725545155874e-05, 1.244286662404430656e-05,
  -2.884292849857738366e-05, 8.251392344686605401e-06,
  -1.025514714859670747e-03,-9.601858989950008477e-05,
  -2.550262841295440172e-06, 1.983673762089693319e-05,
  -2.157748331514804455e-02,-2.963210047314871181e-03,
  -6.465601433800448328e-05, 3.744590762819400209e-04,
   4.132451314320447367e-04, 7.502307210260104680e-05,
  -1.317056142764293411e-05,-1.505112326973253464e-05,
   4.935832032902323250e-05,-7.984748856259190554e-06,
  -2.331454796632340636e-05,-1.887940288054696761e-05,
   1.258626858703133828e-05,-1.554303197754891837e-05,
   9.907268335920433613e-05,-1.358688382252663962e-05,
   1.573646735128123952e-04,-2.891988122738348957e-05,
   2.649929811775648890e-05,-2.996309729093886277e-05,
   1.686350739620438537e-05, 1.075277258655459659e-05,
   1.989187865507977890e-05, 2.076815728845847577e-06,
  -6.180559819593908115e-05, 3.286438850248291294e-05,
   6.117992185508980025e-05, 7.910130948223996581e-05,
   7.150649368735193391e-06,-1.867801417724612132e-05,
  -4.653871169676470699e-05,-1.827972411185180130e-05,
   8.012348206115272502e-04, 1.135835710936935377e-03,
   2.935038846167253632e-05, 6.209242880490315501e-06,
   1.330711748183099716e-05,-5.850573155106043432e-05,
  -1.932952833836229829e-05,-5.135108004360654765e-06,
  -3.369233443242603521e-06, 4.988635350479062193e-05,
   5.982111101639495863e-05, 4.629759903510136649e-06,
   5.759342974381186824e-05, 1.682251022721064292e-05,
   4.002122810232242592e-06,-2.973185182614461504e-05,
  -6.978645396609812384e-05, 5.463592484589788969e-06,
   7.832442494409149898e-06, 1.097207949505096076e-04,
   1.513896297258365669e-05,-1.306949884711502848e-05,
   4.739534635997036197e-06,-2.962324782049031923e-05,
   4.999791077684920520e-05, 4.570754316592834458e-07,
  -1.586368010672984158e-05,-6.817876248122535813e-05,
  -1.463935514199644374e-04, 3.269446593309364383e-05,
  -8.557118837468872955e-05, 8.412830510680419278e-05,
   1.928849122441165080e-05,-5.287164295328333409e-06,
   4.543940591956722221e-06, 5.982769094572151737e-05,
   9.304311729865554013e-05,-3.664666865280700000e-05,
  -7.195107605399433612e-05,-1.866093316387803906e-04,
  -3.992565187742745967e-05, 2.437687872241557302e-06,
   4.613954427818969052e-05,-1.926505784577283527e-05,
   7.515769924842895041e-06,-1.853410916221297978e-05,
  -8.756734418019731283e-06,-7.951930333153246755e-05,
   9.467244831260148658e-06,-3.220446444979022736e-06,
   3.207738218488549644e-03,-7.311056843219758362e-04,
  -1.522564489646874526e-05, 1.296841306739707832e-05,
   7.333227073672131272e-05, 1.308525050146010877e-04,
   2.608172485417825258e-04,-1.482375217787116923e-04,
  -1.355286079328403743e-04,-8.504114552254364210e-05,
   6.006665472266097547e-04,-2.209065391582219361e-04,
   6.761983627108703781e-05,-1.809855636981526862e-05,
  -7.095577382256959423e-05, 1.869900482946628621e-04,
   2.939669379376905927e-05, 9.558155885941273179e-05,
  -8.774382497722591674e-06, 4.796896057208189863e-06,
  -2.100301916132622511e-04, 1.532557294553659659e-04,
   3.022797529025050682e-04, 3.856513334414915246e-04,
   2.988679169413924674e-05, 2.603782293343542157e-06,
  -3.282003454936858881e-05, 3.772062210751901435e-05,
   4.573390153079901253e-05, 5.299443603597626127e-05,
  -1.419748718742706831e-05,-2.642785192865368662e-05,
   1.670194042756764120e-03, 1.552047634430018478e-03,
   1.493387895505749095e-05,-2.601882509560512447e-05,
  -6.103335429340709851e-06, 1.904597848987955018e-05,
  -5.293617433150919890e-04, 5.591745208022326757e-04,
   9.912555485231462721e-06, 1.319561954668157892e-06,
   9.622181307058105636e-06,-3.882542500596872714e-05,
   8.140559206149693667e-06, 2.887440554905280717e-05,
   3.185766724424964275e-05, 3.853685298197899971e-05,
   5.012995083629233437e-04, 6.489212609516591557e-04,
  -3.507198543015398434e-05, 1.923423609055131326e-05,
  -2.314289796496156004e-05, 1.908942832521126344e-05,
  -6.813460187624732290e-04, 9.511401593437886562e-04,
  -1.051498834434803041e-03,-7.298973908586403429e-04,
  -2.105282794053303484e-05,-3.401144565740056705e-05,
  -6.431082120548855152e-05,-2.764268937487239337e-05,
   6.953357186692940746e-05,-8.067365333649050398e-06,
   3.449436917931231195e-04, 5.927773184030297381e-05,
   5.197391937529143122e-05,-2.997852072352314204e-05,
   1.860793459578996621e-05, 7.331082462965685437e-06,
  -1.423152921285107384e-05, 8.886767452940223799e-05,
  -8.002204568136936285e-06,-5.997059450237954224e-06,
   1.074732499730944894e-04, 2.344142786224306309e-05,
   1.087130813527683541e-03,-2.184432785479708226e-03,
   1.774041028332056527e-05, 9.234600315089657634e-06,
   3.519906555677155874e-05, 1.900067851236103341e-05,
  -6.823576053053462644e-05, 1.561668930405965661e-05,
  -6.599609379323670985e-05, 1.002223308651036291e-04,
   6.340656777053617539e-06,-1.598743133578237193e-04,
  -3.552751633025863270e-05,-9.347617655532989667e-05,
   4.935922250535865197e-03, 9.682827772221094765e-04,
   4.804257912961195734e-06, 6.983494186942341953e-05,
  -4.982119437505633659e-05,-4.224759288155343617e-06,
  -8.916099503642476671e-06,-4.528042583848609791e-06,
  -1.602158333325365084e-06,-1.993572393154951778e-05,
   1.793536658455217671e-05,-8.850007089134407780e-06,
   6.276948095002071661e-05,-3.098374188610834401e-05,
  -3.918121715939705410e-04, 1.155371465023616057e-03,
   3.984052231069630577e-05, 3.568302399028200814e-06,
   2.942440173353018038e-02, 9.564945510760945735e-03,
  -1.791264781142733504e-05, 3.576502549116619212e-05,
   7.391822480955942106e-04, 4.395561444233755119e-04,
   1.103109019187105970e-05,-1.668277702239067154e-05,
  -5.147655197858251759e-05, 1.408906121655956547e-04,
   1.137785447824690623e-04, 1.124919674784990385e-04,
  -5.400232824169347171e-04,-1.042825702005834747e-04,
  -1.862140829367468287e-04, 3.774010222596617116e-05,
  -5.758434655885238528e-05, 3.980003808277053737e-05,
   8.341530616899721555e-07,-3.999130141255312343e-05,
  -1.947093161517172007e-05,-4.569772646128744713e-06,
   1.818981606181823343e-05,-8.314480839909337543e-06,
  -2.150149659422618848e-04,-1.275482827044251697e-04,
  -1.171781816201954135e-05,-2.196877164010811300e-04,
  -2.506369945963404577e-05,-6.535909247684777593e-05,
  -2.630805957511087593e-06, 9.647738595853651137e-06,
  -2.091798481036127061e-05, 2.150436959023665964e-05,
  -3.466106917875353815e-05,-6.081620082992410372e-05,
   8.303251772795509867e-04,-4.971132677768285574e-03,
  -1.582925846724798186e-04,-6.199562595623835885e-05,
  -1.671587620679950063e-05,-1.098086893824684314e-05,
   9.949838803343026588e-06, 1.000353831146477098e-06,
  -8.000207509149333436e-04, 2.006381518581525168e-03,
   1.397110443133902624e-05, 4.097618921287930088e-04,
   1.578850767373268847e-04, 3.346226270646508239e-04,
   5.037235298605809500e-04,-2.446683581193047959e-04,
  -2.669391558981646251e-03,-1.905977099767344014e-03,
  -6.580829281076302920e-04,-1.258048478131410116e-04,
  -9.698622646662129014e-05, 2.436538273381416600e-05,
  -8.855729080074542506e-06,-4.645004032325711920e-06,
   2.670406780495278114e-05,-2.978074483065332366e-05,
  -1.397352043635225675e-04,-8.606547593813585999e-06,
  -1.389861810110254914e-05,-1.438153033858722085e-05,
   7.410524352775466139e-06, 6.714471596255491954e-06,
   5.557155275355732231e-05, 1.175236253889344249e-04,
  -1.998591438210341957e-05,-7.504840512840820508e-07,
  -2.899387450610867753e-04,-5.960210768263945008e-06,
  -9.043537403239209884e-06,-2.860444775268722800e-05,
   2.022466915843460395e-05,-3.451032827186470832e-05,
   1.702938049806369280e-05,-1.048809800927547151e-05,
   2.573113150773027121e-04, 3.729459924961023943e-05,
   1.011887679071180523e-03,-5.029744774279699873e-04,
  -8.282809398918211967e-05,-2.038124305485787156e-04,
   4.154141375665892683e-05,-1.545131416517639433e-04,
  -2.793677426923752886e-05, 1.093328145753451672e-05,
   6.642966045722037416e-03,-3.793876924121828819e-03,
  -8.398228860029300366e-04,-1.455024920798853472e-03,
  -2.016979903179550198e-06, 1.989803487960984245e-05,
  -2.011865810309931835e-04,-1.114628171771179496e-04,
  -2.996495501558193896e-05,-1.449645099378070903e-06,
   3.171931922910960341e-04,-3.331493340293265287e-04,
  -1.284523374390627041e-04,-1.999992516088907324e-05,
   8.423474890417626969e-05,-3.169395963035190366e-05,
   5.616309080347369484e-04,-1.183499354938597576e-03,
   5.367650382176652197e-06, 8.437317664679863590e-06,
   2.028474750787598649e-04, 4.016875674627880407e-04,
  -4.566698789869014924e-03, 1.306813744421472800e-03,
  -2.156072957260983853e-05, 2.085988830978697980e-05,
   8.841699482462612135e-06,-3.901056716149895267e-05,
   1.255006695262765029e-03, 2.517105378120542097e-04,
   3.043116807441357330e-06,-1.976713029491807615e-05,
   1.474373215640725071e-04,-6.214689219914606294e-05,
   5.988743063342500121e-05,-3.673642895915311140e-06,
  -2.047426688079336757e-04, 5.958023494158149521e-04,
   1.639317769813857135e-03, 4.501524736936598678e-04,
  -4.093892359325123235e-06, 2.971935472634389781e-05,
  -8.966753822753467836e-06, 4.426886703105930432e-06,
   5.947938121035106415e-05, 3.690803721188294130e-05,
  -8.549737315091696999e-05,-6.921126486557562408e-05,
  -4.063089646755066041e-05, 2.913983960565293330e-05,
   2.404162871005627918e-03, 5.355081781791756583e-03,
  -2.854662951904443071e-05, 5.277395136904589816e-05,
   8.599981682688830141e-06,-5.102971198960133887e-06,
   8.325476393806975801e-05,-4.727247024237429189e-04,
  -5.400545265089329181e-05,-2.338448440397438647e-04,
  -2.470259206965213562e-04,-3.272280466342026759e-04,
  -1.879878221868841416e-05,-6.826843128000256832e-06,
   2.742877855688312291e-05, 1.215162980334195954e-05,
   5.466003442409728900e-05,-1.609729189545760391e-04,
   5.699226807818955336e-04,-9.388180354975397246e-06,
   1.464764677900554862e-05,-1.291721581604855112e-04,
  -2.077589771496613955e-04, 3.059750665865572285e-05,
  -2.134905624955038062e-04, 1.962696607358187337e-04,
   1.731350088922363473e-02,-8.229920227976236791e-03,
   2.641781444696644662e-05,-9.644739021790922086e-05,
   8.643978565422404125e-05,-2.023071018428463437e-04,
   3.004949643095517110e-05, 3.996282978276204112e-05,
  -3.370219975786451633e-02, 3.990156176744209110e-02,
  -1.703199123715030687e-05,-3.619269642479868397e-05,
  -2.882908210521073716e-05,-8.299640050690031506e-06,
   5.146658261157594384e-04,-3.457153271531114244e-04,
  -1.263231030579274161e-04, 8.088555887064292882e-05,
   1.794492563700936951e-05, 8.830608352894151283e-06,
   1.691621675093554170e-04,-2.477582714735004671e-04,
   9.862521043543531101e-06, 3.876507034258626735e-05,
  -1.016916340237985497e-04, 1.837357111983672626e-04,
  -8.833182084061370288e-06, 4.687738716035402028e-06,
  -8.831023119481393874e-04, 2.915995655549769527e-04,
   3.489828010437924960e-05, 1.954763529832413132e-05,
   1.969996171446333728e-05,-3.451305325333985979e-06,
  -1.395312612944155202e-05, 1.432865210743479021e-05,
  -7.396687383786408600e-06,-6.729711416289333784e-06,
  -4.823393852547779807e-04, 2.845148808622193002e-04,
  -1.223980142774361724e-03,-1.852099514090442588e-03,
   1.852800849824199944e-05,-7.530796842902634885e-06,
  -2.047682869140986757e-05, 3.436130798940363243e-05,
   3.078448813123980487e-04,-1.665278626829623109e-04,
  -8.553533641460304353e-05,-2.799475351634094725e-05,
   1.115785307250585608e-05, 3.841226776450944901e-05,
  -1.098024795649137981e-04, 6.589042525032654741e-06,
  -1.330306335293101401e-04, 6.930260127001279112e-05,
  -1.732518987230130276e-04, 2.325591958811150601e-04,
   6.397293700653796126e-04, 1.861002621579594207e-05,
  -6.015179305024850485e-05,-7.988592988029916977e-05,
  -3.435023604032806229e-06, 9.391518132854638368e-06,
  -1.978180461790986604e-05, 4.592036809585524321e-05,
   2.573707300933863388e-06, 1.899825677022213579e-04,
   1.974704268064355088e-04, 6.506961122804440353e-04,
   1.106415876775816742e-04,-1.901537248548763241e-04,
  -7.319655191024510769e-06, 1.861243261598300559e-05,
   1.585584596286683187e-05,-1.218983793172984108e-05,
  -1.008983154595554591e-04,-1.109933778989720968e-04,
   1.232949313079005757e-03,-1.141155550912323173e-03,
  -1.642195350121263518e-05,-1.141575416711528998e-05,
  -9.109704456311605068e-06, 1.780486688292435893e-05,
  -4.705188107308300958e-05, 1.691509643733824793e-05,
   4.519777233744990373e-03,-2.207377121680950856e-03,
  -1.335147643937359126e-05,-6.871490432860145740e-05,
  -8.477514972212298893e-06, 7.954955524637404582e-05,
   1.911566316053103543e-05, 5.687346852384788808e-05,
   1.171462194802429599e-04, 1.231940065972641032e-04,
  -8.992302363775881791e-04,-3.361323875860626367e-04,
   4.630649271748383806e-05, 1.886024210357907261e-05,
   1.099851876303760509e-04,-1.805132103469590166e-06,
  -8.767392631263045408e-06, 1.797589570645297417e-05,
  -7.020018084288580395e-05, 1.094163361186350786e-04,
   4.446281675388517553e-05,-5.406531167310909956e-05,
  -1.271821468568803243e-04,-1.128038187335647337e-04,
   2.789909480546403373e-04,-6.745843541793516366e-04,
  -3.884263990618854221e-05,-9.552451262276596110e-06,
  -8.811285337306035343e-05,-1.833371403882936109e-05,
   4.816339943486034302e-05, 1.342709778314341269e-05,
   2.959471009180510400e-05,-4.914583866616708649e-06,
  -3.648207018336428178e-05, 1.640300445455292254e-05,
   5.814241633118464903e-05,-3.898024401118073694e-05,
  -1.006058586995468287e-03, 1.670432913807879316e-03,
  -1.071083720665149929e-05, 6.917570358393624404e-05,
   7.830708266211182641e-06,-1.840326079936628780e-05,
   2.039357486997770056e-05,-4.565196714296783061e-05,
  -1.080040958288790842e-05,-1.683303754055883659e-05,
   1.362175587846412527e-04, 3.232300541027711391e-05,
   1.705691005876800305e-05,-3.618095934669366093e-05,
  -1.239305041981587464e-05,-2.732054723631833893e-05,
  -1.073853586561785301e-03,-9.291062773592645343e-04,
  -9.786461308331973453e-06, 1.744205191657567991e-05,
   4.747660236558998175e-05, 1.568350177159603636e-05,
   4.956389107184328507e-05,-6.589438657310175744e-06,
   1.732213427696526007e-05,-1.288407686413379897e-04,
  -1.167633359996601898e-04,-1.623771023458371078e-04,
   4.994066048027221273e-05, 2.435247583753499671e-06,
  -3.293864580911313870e-05,-2.269461637176962317e-05,
  -1.696987704079195886e-04, 1.400083116177043292e-04,
   1.439005469358311056e-05,-2.632349380146348998e-05,
   1.125119927553266257e-06,-3.998417318325618320e-05,
  -1.161083885893593329e-05,-2.766203934983506345e-05,
   5.060967265165881423e-04, 1.475623970871032566e-03,
  -4.798446579561970620e-05, 1.405315061859804231e-05,
  -1.784641238048240088e-05,-9.028043262289149330e-06,
   1.685996387461846912e-05, 1.087002374337175026e-04,
   6.373027082256237270e-04, 5.869632090928356404e-05,
  -1.024820821435513187e-04, 1.095327477949968852e-04,
   3.016201047418115398e-05, 5.186765007358041857e-05,
   2.510577831591369660e-05, 1.642254228650964889e-05,
  -3.929963785619126416e-05,-7.452413325374447807e-06,
  -2.914911823885243323e-05, 7.094286849106156136e-06,
   1.819683266205436437e-05, 2.385110649569934657e-05,
   1.861037271181125634e-05,-7.324890956694918291e-06,
  -8.418399644187431500e-05, 8.551640043333498141e-05,
  -6.876296923516648256e-06, 1.878074920283095541e-05,
   1.486262897589211625e-06, 1.994469911027112611e-05,
   9.553681091554826720e-06, 1.757063395557678496e-05,
  -2.414441623549004429e-06, 9.704147136481086622e-06,
  -9.992594881849735204e-06, 3.847694468515984275e-07,
   1.799367862952970271e-05, 8.730837839360327025e-06,
  -1.043568345703523487e-04,-5.924230817967943434e-05,
   1.089668568481421079e-05, 1.677087478596048383e-05,
   1.884705457348722331e-05,-6.692423619586133983e-06,
  -3.272969216411907014e-06, 9.449215444068361278e-06,
  -1.863193000409812354e-06,-9.824892459626410947e-06,
   9.444069047864896851e-06,-3.287789503474975663e-06,
  -2.734378017622562408e-05,-2.919448039740133829e-05,
  -1.254293850920901686e-05, 1.557801956457243418e-05,
   4.868601462809040673e-05,-1.118941317487040163e-03,
   1.990781094605003498e-05,-1.918088458943032442e-06,
   4.658749006156840926e-06, 8.848505958501280745e-06,
   4.863972840775757111e-04,-1.312790037302979376e-03,
   2.384695518750000512e-06,-5.995259149763965053e-05,
   6.709724100000709888e-05, 4.356558561739951063e-05,
   2.688907043630964696e-05,-5.363746723206809372e-05,
   2.235197801229963865e-05, 3.317211297065162566e-05,
   9.410528286700163631e-06,-3.382596246260569525e-06,
   4.947105614567372342e-05,-7.253592477634669104e-06,
  -8.863578573693037515e-05,-4.920809867153952541e-04,
   9.019764248756156726e-04,-1.874256793763491276e-03,
   1.213582433524076822e-03, 1.513544739028807031e-03,
   4.896137863275384043e-05, 1.013821495038034913e-05,
   4.033752510037836415e-05, 4.983702279117165589e-04,
  -1.481989833983787266e-04,-1.343021270110308864e-04,
  -1.090594556443330961e-04, 1.676485464731553878e-04,
  -6.396190689523312744e-04,-2.551035406223851106e-03,
  -8.956809697809304356e-05,-3.589952033157586798e-04,
   6.450772823649080813e-03, 4.980966771387904807e-03,
  -3.605860580977780327e-04, 4.669878956734380658e-04,
   8.412113049582582174e-06, 5.407065196670228194e-06,
   3.023336788144037829e-04, 2.132940380192304992e-04,
  -3.458847908622925355e-05, 4.902690194680346653e-05,
  -4.586531455519642000e-05,-3.868297972949973768e-05,
   2.921844005039065485e-05, 7.447336947541536754e-05,
   5.131166967336181581e-04, 1.494359814613997360e-03,
  -1.784843239138627196e-05,-4.595505741460020389e-05,
   6.323236589874489839e-03, 2.137430183721733892e-02,
   1.702082527557062920e-05, 5.753513280543025147e-05,
   4.350039592157471375e-06,-1.952119759509294517e-05,
  -6.600703421307370583e-04,-3.233312101149440725e-03,
  -2.576177602792922643e-06, 9.662469092259397415e-06,
  -8.982901068541541262e-05,-5.628772058267055445e-04,
   4.895000721818934436e-06,-8.720032564927272711e-06,
   1.478479048032666384e-05,-2.610383057048988107e-05,
   1.740255371365990490e-05, 9.856526986884472488e-06,
   3.848181611900812928e-06,-1.962629609177005453e-05,
  -8.145471697094125175e-06,-5.800973265913106522e-06,
   9.999519972364682161e-06, 9.798123432499514415e-08,
   6.746413025125451118e-06,-1.882779624104790627e-05,
   1.785653616624638087e-06,-9.839280520517512175e-06,
   1.027747958909319649e-03, 4.678443558808605303e-03,
  -4.987967985737847085e-05,-3.466631985866473903e-06,
   7.971178703174187105e-05, 6.784615553311060359e-06,
   9.962157316356575303e-06,-8.691499319238140869e-07,
   3.382294760688444517e-04,-9.000456387425567913e-05,
  -5.232760307317234902e-05, 2.935680426436985618e-05,
   9.533145225064299422e-05,-4.090377906890552530e-04,
   3.522551442034928368e-05, 3.548468872375471140e-05,
  -4.652187890506334969e-05,-3.789082716361074314e-05,
  -2.839895287221958615e-05, 2.816912273680973353e-05,
  -3.714912025768956179e-05,-1.483047079764224196e-05,
  -2.182459651063151860e-05,-3.352144070812187836e-05,
  -2.931126962101064876e-05, 6.391359261097615297e-06,
  -1.001987705839764214e-05, 1.730901683327498096e-05,
   7.797250277322167097e-06, 6.261220976199402718e-06,
   9.999934545660815315e-06, 3.618124513368687278e-08,
   2.989331231362156530e-05, 2.527820982641235971e-06,
   7.345133787335516574e-06,-6.785942060329002218e-06,
  -9.078340210336449887e-06,-4.193296915958654182e-06,
   3.448070014024020463e-04,-1.597126538001416890e-04,
  -3.358387466856973006e-04, 9.855118581011613934e-05,
  -1.513726139183330776e-05,-1.307146960197332923e-05,
  -8.487521743992301049e-06,-5.287908343121871205e-06,
   2.795528418347325143e-05,-1.088586635143250164e-05,
   8.198215368833290098e-04,-1.710694777732996809e-05,
   1.364301087438954159e-07,-9.999069297961092306e-06,
   1.204701718462182491e-02, 2.680987755034359705e-04,
   1.248081267740636505e-05,-2.196456904082379061e-04,
  -1.297223183768336340e-04,-8.492356265454779039e-06,
  -2.887601649306669428e-05, 8.134843052704849491e-06,
  -8.608687528278321220e-05, 2.624976007598029656e-05,
  -1.797911826997682512e-05,-8.760782284373102498e-06,
  -1.999896175034822861e-05, 2.037864276847794812e-07,
   5.765734506864973421e-05,-3.969421317565888430e-05,
   9.197172156280525467e-06, 3.925815116346953115e-06,
   7.945566528685716709e-06,-1.835396340135364945e-05,
  -8.348075988911279519e-05,-8.620303201359159439e-05,
  -4.975648793619035102e-06, 1.937118785935848238e-05,
   2.899197642496231542e-05, 7.711374908174896647e-06,
  -1.131116683555135390e-03,-1.269084334543308171e-03,
  -2.986663683122108654e-05,-2.825598059163425634e-06,
  -6.546143286840033484e-06, 5.964183102544856982e-05,
   1.978888569539230993e-05, 2.898275855521296298e-06,
  -1.914936766940276705e-06,-3.995413642138471804e-05,
  -7.994511390704164377e-05, 2.962897634097043435e-06,
  -3.947787113909928736e-05,-6.441870095296221549e-06,
  -5.875176714347342916e-07, 2.999424649804945467e-05,
   4.907778521094894621e-05,-9.558817855151404533e-06,
  -2.213742930531519950e-05,-1.179403841936771559e-04,
  -1.355079504127591594e-05, 1.470972310240176224e-05,
  -1.331560704484555633e-06, 2.997043453289045326e-05,
  -4.972425625495546081e-05, 5.243885953329197732e-06,
   2.685555562199159506e-05, 7.535767467374584311e-05,
   1.700555826282782075e-04,-5.900083742589463096e-05,
   9.428194306749689815e-05,-1.166658270935292806e-04,
  -1.856023575007932809e-05, 7.451016635431527494e-06,
  -2.104335536266491795e-05,-9.776081625621076100e-05,
  -1.058300761948301438e-04, 5.656849805851705442e-05,
   1.159285249228879312e-04, 2.214962236906158977e-04,
   3.938746665009754534e-05,-6.973340009454133729e-06,
  -4.364327822050053420e-05, 2.439803816227821407e-05,
  -5.354473305074910092e-06, 1.926991477991639253e-05,
   2.594633334837859274e-05, 1.171613749739000733e-04,
  -3.291895831577049819e-03, 1.159103892688504367e-03,
   1.364705243806991136e-05,-1.462046373247340351e-05,
  -1.056582554866732912e-04,-1.457269125711269488e-04,
  -3.069158255592334948e-04, 2.240595367782727949e-04,
   1.623624792902583758e-04, 7.770730543983895525e-05,
  -6.608848739709649719e-04, 3.329131769041016671e-04,
  -6.511655539732724100e-05, 2.568723833320373803e-05,
   5.665172749465995560e-05,-2.229138438318060099e-04,
  -5.769812905146703822e-05,-1.164943170457694526e-04,
   2.626913548404764018e-04,-2.461569663691745482e-04,
  -4.215334320760484197e-04,-4.269772425342917375e-04,
  -2.998880717141331120e-05, 8.194171317404231935e-07,
   2.830720299729048102e-05,-4.121531582397724503e-05,
  -5.147572450258229462e-05,-4.743679781492684579e-05,
   7.814036571134306847e-04, 5.914459608871769141e-04,
   3.892904343126390666e-06,-1.961747424556147386e-05,
   5.882345330058729241e-04,-7.838240454205028847e-04,
  -9.998357582670177902e-06,-1.812336863327957966e-07,
  -5.134503670527980733e-06, 3.966909215065723141e-05,
  -1.137832747471932865e-05,-2.775848814107222516e-05,
  -3.604212112454053749e-05,-3.465494921138897099e-05,
  -6.925998925756494734e-04,-7.073933762795625840e-04,
   3.265134574281049656e-05,-2.310605161388356237e-05,
   6.453463321338381029e-04,-1.162939427313994722e-03,
   1.504406964723715859e-03, 8.129327675095748178e-04,
   2.479290528514364138e-05, 3.138967740391571695e-05,
   7.660451280122456622e-05, 2.305967516004991496e-05,
  -6.816106713676724216e-05, 1.593953972914866025e-05,
  -4.193422989035526906e-04,-2.349545382161139840e-05,
  -4.826327401656132176e-05, 3.564626742314428153e-05,
  -1.932222303646322577e-05,-5.162528152869476533e-06,
   7.984742545168846314e-06,-1.197340548318955505e-04,
  -2.251373798104118365e-04,-4.704423675757076167e-05,
  -1.263317783831962790e-03, 3.488284417454216076e-03,
  -1.867717581376148931e-05,-7.152838850543390743e-06,
  -2.785141277364173876e-05,-1.114893746113170636e-05,
   7.555081021713843672e-05,-2.630731980901762407e-05,
   5.830780868461639849e-05,-1.161903586636953660e-04,
   1.402251978430075406e-05, 1.894818432961292948e-04,
   5.527292372795623583e-05, 1.065124589076955485e-04,
  -6.160458822733658711e-03,-4.910673002787047667e-04,
  -1.447734772786383923e-05,-7.867913575253936045e-05,
   4.997806538484579365e-05,-1.480871496139614984e-06,
   9.374063635231561943e-06, 3.482374328332501457e-06,
   3.863786184962777490e-06, 1.962323001742808997e-05,
  -1.680987186827771987e-05, 1.083642965981348476e-05,
  -5.882928399277069465e-05, 3.793567377677551093e-05,
   3.279845703811701610e-04,-1.484192077054678023e-03,
  -2.804851009782579133e-02,-5.690824306914121430e-03,
   1.375335063999196843e-05,-3.756122130833118675e-05,
  -4.375192897410091629e-04,-1.974256090392604180e-04,
  -4.528942105808550243e-06, 8.915642624187806114e-06,
   3.734836605581467707e-05,-1.555798815816520622e-04,
  -1.497760680983776420e-04,-1.169064986431043145e-04,
   6.182203388213462509e-04, 4.694265296742270468e-05,
   2.092450796798118681e-04,-6.794480576018437632e-05,
   5.992839702708182409e-05,-5.299610579810984146e-05,
   3.729076031319405946e-06, 3.982579555956967075e-05,
  -1.712369714233785779e-05, 1.033339228798996182e-05,
   2.552903888760678255e-04, 1.150079012394628785e-04,
   3.968777696758411702e-05, 2.265499511352216241e-04,
   3.234828025911049758e-05, 6.207728058056378312e-05,
   1.514115013484364750e-06,-9.884708176063735421e-06,
  -3.769126031700974449e-05, 4.668371124616600774e-05,
   3.042189533138137675e-05, 5.171564835179460389e-05,
  -3.101050078545248916e-04, 6.022020830593625453e-03,
   1.740210483218568576e-04, 4.600733355631428492e-05,
  -9.999017938696398258e-06, 1.401437177601922905e-07,
   6.643822067742040241e-04,-2.482638975630939004e-03,
  -6.914564431657466549e-05,-4.648858783314951601e-04,
  -2.379825511949634775e-04,-3.819218576184617796e-04,
  -5.485137528247672990e-04, 3.487587460725394793e-04,
   3.322600562732023945e-03, 1.843997153070697824e-03,
   7.678936610521215319e-04, 5.691507107936747567e-05,
   1.122677860650465919e-04,-4.237858199672246890e-05,
   9.327416624593327100e-06, 3.605454078373490395e-06,
  -2.313598117184499547e-05, 3.263014519146419573e-05,
   1.398058738672007225e-04,-7.370049676112216564e-06,
   1.544711568980498150e-05, 1.270380324413838204e-05,
  -8.127484972297730194e-06,-5.826146927865325978e-06,
  -8.833189962031124764e-05,-1.568358234252215067e-04,
   1.994122322798015545e-05,-1.532193255390717359e-06,
   6.569959313991049306e-04,-6.289949224773300803e-05,
  -2.982594115596729433e-05, 8.491415214297777536e-05,
  -1.572147390646450710e-05, 1.236265579106510937e-05,
  -2.998663268280718540e-04,-8.954665523623777488e-06,
  -1.181753751570010884e-03, 7.691281236895481863e-04,
   1.248592843146249895e-04, 2.280573592770898108e-04,
  -2.811627555177732848e-05, 1.777905370066037256e-04,
   2.650868025172857753e-05,-1.404599128974582005e-05,
  -7.387032565636753555e-03, 5.416396391903207340e-03,
   1.195756905845965804e-03, 1.615631586136419317e-03,
  -2.639339997494490434e-07,-1.999825839526473293e-05,
   2.402123562313614223e-04, 9.948881300818451768e-05,
   2.993490555559661214e-05,-1.975203629378807627e-06,
  -3.133684821566983685e-04, 4.149701126476544079e-04,
   1.498835697696091396e-04, 5.908935024071766851e-06,
  -8.310423982417601693e-05, 7.206722780325213232e-05,
  -4.230884651474816878e-04, 1.239796818296912692e-03,
  -6.294274025130369524e-06,-7.770592930823822718e-06,
  -2.810860633952695013e-04,-4.255474414973618052e-04,
   5.311788098745720381e-03,-2.201682809585277234e-03,
   1.904417405787726857e-05,-2.318015173490618977e-05,
  -4.338520120352422649e-06, 3.976401945434210263e-05,
  -1.564998847701652316e-03,-1.252142431694598667e-04,
  -7.704359838022416817e-07, 1.998515520066989105e-05,
  -1.829489591072778077e-04, 1.031003315298432906e-04,
  -6.901741999081421463e-05, 1.168741792747897895e-05,
   1.858259691456501015e-04,-8.089305960285343841e-04,
  -2.311003172675416776e-03,-3.672387995353418332e-04,
   4.184408424378322369e-06, 9.082440538643330786e-06,
   9.568744956631334304e-07,-3.998855325214391738e-05,
   1.702756735669931886e-05,-1.049104141222728170e-05,
  -9.944306162295450441e-05,-4.702209581732053371e-05,
   7.631060485000006142e-05, 4.771468943027029657e-05,
   4.454418509732026906e-05,-4.019720853511685627e-05,
  -3.547012727505028003e-03,-5.976721568796503764e-03,
  -5.570508847848870032e-06,-5.974085228029507892e-05,
  -7.962362457500759806e-06, 6.049858188038995526e-06,
  -3.340850082765024867e-05, 5.690200981269895493e-04,
   9.691449409781587173e-05, 2.733268754326299301e-04,
   4.100016509803891757e-04, 4.242624732324969290e-04,
   1.945419429961105188e-05, 4.640509040286516146e-06,
  -2.863497739870418150e-05,-8.946399799679243580e-06,
  -4.018378623872399970e-05, 1.857020821733578180e-04,
  -5.849707299852931110e-04, 7.687161413989798361e-05,
   1.704956548734230089e-07, 1.299998881969967996e-04,
   2.222237330355488632e-04,-5.930103267014082385e-05,
   1.897287744529807323e-04,-2.193239433909803797e-04,
  -1.706778641507828223e-02, 1.065387567457351005e-02,
  -1.678192925164793755e-05, 1.087123123229042726e-04,
  -5.701898812217895076e-05, 1.916998565297398029e-04,
  -3.440879450073725399e-05,-3.627719477862137833e-05,
   2.808058533552213604e-02,-4.220138418600104246e-02,
   2.104636991488943512e-05, 3.401544227855397552e-05,
  -4.776598735296638744e-04, 3.630992222790148838e-04,
   1.318230437550958886e-04,-1.073437708259872736e-04,
  -1.883460741257107326e-05,-6.727374199070755480e-06,
  -1.444844648278698876e-04, 2.742703764962669578e-04,
  -1.421494268665729259e-05,-3.738897436965941463e-05,
   8.009016656022572244e-05,-1.941277033819627479e-04,
   7.533326172434567621e-04,-3.484106310047434718e-04,
  -3.689873058630512183e-05,-1.544291685917110685e-05,
  -1.917825835802636366e-05, 5.674011486839971830e-06,
   8.115475038460771452e-06, 5.842864443072435161e-06,
   5.112902731860004789e-04,-3.849444850174957495e-04,
   8.102878547056388000e-06, 5.860320746482514974e-06,
   1.746243949065146971e-03, 2.085433305179851694e-03,
  -1.754898208113915453e-05, 9.593395015105806001e-06,
   1.642878212069437017e-05,-3.647046912271287273e-05,
  -3.442061949473220156e-04, 2.406700965219529581e-04,
   1.173589106105904148e-04, 2.503769358977476361e-05,
  -1.546297673289403978e-05,-3.689032868595748733e-05,
   1.576249695970520959e-04,-2.746577797056558171e-05,
   1.731536065744372719e-04,-1.188184688096299239e-04,
   1.409046149409124457e-04,-2.419625786942129363e-04,
   6.221571078952505679e-05, 6.503234065412513069e-05,
   1.441937514668181812e-05,-4.787568924181933070e-05,
  -3.591628513387141531e-05,-2.676004866628280913e-04,
  -4.231513038105735153e-04,-8.728361668053242085e-04,
  -9.529864205029351385e-05, 2.093278978621101918e-04,
   5.150709913732262039e-06,-1.932537677212478627e-05,
  -1.436326162130205342e-05, 1.391749674323768664e-05,
   1.203533687824524969e-04, 1.054280163083560676e-04,
  -1.296821302446639216e-03, 1.509421912362677535e-03,
   1.761629043377070737e-05, 9.469229712761159163e-06,
   7.021218587452803046e-06,-1.872705234539614720e-05,
   4.481749468148329795e-05,-2.216736724275610577e-05,
  -5.216094135661277463e-03, 3.332935938166233913e-03,
   2.418064972851861896e-05, 7.625808926734719054e-05,
  -5.920675109516244705e-07,-8.999805251260983526e-05,
  -3.781280719238123739e-05,-9.257532939305051503e-05,
  -1.226477474811663525e-04,-1.027498420329494037e-04,
   8.641228339179919974e-04, 2.130533452014737915e-04,
  -4.815436162265500467e-05,-1.345947460767215236e-05,
  -1.387652452935724857e-04, 1.855280837540919489e-05,
   6.661596317959169067e-06,-1.885797270378109682e-05,
   5.727263319937795049e-05,-1.167040937003047303e-04,
  -2.709147440235337774e-05, 4.202442164630742415e-05,
   1.309624948372622956e-04, 9.191748988087114643e-05,
  -2.323815535447181294e-04, 8.176177674024355177e-04,
   3.967823970968768212e-05, 5.063328306614493875e-06,
   8.962854382953189313e-05, 8.168484008534361137e-06,
  -4.939035688442015512e-05,-7.784127878549436657e-06,
  -2.884175015079369988e-05, 8.255510174373944553e-06,
   1.748101289428931213e-05,-9.716696361916987178e-06,
  -5.332109690344655705e-05, 4.535262533760599278e-05,
   7.884663329008751971e-04,-1.728676037284559075e-03,
  -1.894419877223642640e-05,-6.412279850255753937e-06,
   2.887644953027638270e-06,-1.299679249146698209e-04,
  -5.681787032369162301e-06, 1.917595619829169401e-05,
  -2.404360000881110233e-05, 6.574119940049997005e-05,
   1.264849175022936640e-05, 1.549243868615847482e-05,
  -1.886709057450491065e-04,-2.243411075444712657e-05,
  -1.282220749596287953e-05, 3.788919364318108255e-05,
   1.542584229443424846e-05, 2.573020383726572015e-05,
   1.238830463036974874e-03, 8.457535597628865198e-04,
   7.735387648934151730e-06,-1.844352943231628521e-05,
  -1.179766702520663421e-04,-2.194322848250012469e-05,
  -4.848994630989488170e-05, 1.219529035585099346e-05,
  -5.849473140490803967e-06, 1.912547160147107811e-05,
  -2.874163420128545106e-06, 1.499724614208701608e-04,
   1.547539686674770008e-04, 1.701505485787969875e-04,
  -4.989280308458144325e-05, 3.272338668778161622e-06,
   3.531046335352162712e-05, 1.879284911235138669e-05,
   1.526363569928817555e-04,-1.584365567788620008e-04,
  -3.062131540248581656e-05, 8.463057983389625060e-05,
   5.261110136823129508e-06, 5.976889425217950952e-05,
   1.468781782092644489e-05, 2.615851692392509467e-05,
  -6.709754410164423108e-04,-1.408329491828098695e-03,
   4.607017781470994829e-05,-1.943035553254255973e-05,
   1.875905210697444047e-05, 6.935269572829727706e-06,
  -4.268306640956493804e-05,-1.542016726299577775e-04,
  -7.398147582447772838e-04, 1.655667488422105714e-05,
   1.071684140954248348e-04,-1.446199537417694990e-04,
  -3.587693642137278281e-05,-4.809205166154564652e-05,
   4.365702678996727717e-05, 2.437342839774657977e-05,
   3.989291941484729214e-05, 2.924889837327263063e-06,
   2.815064527004665414e-05,-1.037020592273846824e-05,
  -2.079657198282098613e-05,-2.162180829078237090e-05,
  -1.765429673935910537e-05, 9.398181028191279808e-06,
   1.867632105788685521e-05,-2.347754313685169574e-05,
   4.691057485415452411e-06,-1.944206726838809611e-05,
  -3.749668794618605477e-06,-1.964535527626475619e-05,
  -1.149395024304951798e-05,-1.636731828401653474e-05,
   1.292731598267868223e-06,-9.916090208083014175e-06,
   9.883633436886212739e-06,-1.521114750853743637e-06,
  -1.887148641058127986e-05,-6.623216790597004584e-06,
   1.380358674438376823e-04, 5.870348625956783888e-05,
  -1.273704779950940354e-05,-1.541971508663544647e-05,
  -1.796151850767127722e-05, 8.796809245321976462e-06,
   2.174719697465680391e-06,-9.760665665693851124e-06,
   2.970792258624773276e-06, 9.548528334570470559e-06,
  -9.007825538455675418e-06, 4.342704119410593459e-06,
   2.604336040269539341e-05, 3.036022692496414470e-05,
   1.068579048080326805e-05,-1.690603092983016965e-05,
   7.915654340585019655e-05, 1.117199284656071427e-03,
  -1.955949246593500216e-05, 4.174476551021923514e-06,
  -5.636854663714194201e-06,-8.259895247529690059e-06,
  -4.062410545357346544e-04, 1.661044311753811760e-03,
   1.289882384090296649e-06, 1.995836174226766550e-05,
   5.891824182246535626e-06, 7.978274505057779496e-05,
  -9.185799619505049445e-05,-3.952351875820383419e-05,
  -2.059958582015703981e-05, 5.635296854681202581e-05,
  -2.598752978084073169e-05,-3.040803012182664102e-05,
  -8.963698231365268854e-06, 4.433070495381183646e-06,
   3.959274161082931423e-06,-2.973758813551262217e-05,
  -4.899436781374263755e-05, 9.977570973523548984e-06,
   2.973758813551262217e-05, 3.959274161082929729e-06,
   1.840363670980959784e-04, 5.815759757635581432e-04,
  -8.979341451892637477e-06, 4.401298341435471836e-06,
  -8.484132764494615314e-04, 2.341002971451401106e-03,
  -1.619481595471852905e-03,-1.633180749925721266e-03,
  -4.905719170598091163e-05,-9.663950637427626817e-06,
  -1.115585670239290086e-04,-6.098808786341538592e-04,
  -9.994467225973982638e-06, 3.326031703576443212e-07,
   1.955520578636470207e-04, 1.391380345746368768e-04,
   1.082756320102232656e-04,-2.141877389413005515e-04,
   7.634604758575061077e-05,-2.390148568675815944e-05,
  -8.911845235161817847e-06,-2.864575037426186278e-05,
   1.909716691617456389e-05,-5.941230156774580807e-06,
  -7.405751880664376298e-05, 3.025696462310135962e-05,
  -1.007045168724742760e-03, 3.616075609665186344e-04,
  -3.041558924017460032e-05,-8.470473381796897602e-05,
   1.643521631277292485e-04,-4.345533885768558031e-05,
   2.930696396094982343e-05,-6.411073497596817099e-06,
  -4.662226111761993778e-06, 8.846674385485466853e-06,
   1.992855987448041507e-05,-1.688934968922503204e-06,
  -2.997790512560465575e-05, 1.151175173571008761e-06,
   9.598755601373545437e-06, 2.804262987863301990e-06,
   2.074810206706109099e-06,-9.782390434149936223e-06,
  -8.271694070177692076e-06,-5.619526422162923895e-06,
  -8.163751012279931942e-06,-3.915805369792398972e-05,
   2.936854027344298890e-05,-6.122813259209950651e-06,
  -8.378495927854970134e-06, 5.459011447773094884e-06,
   4.724185124972824889e-05,-3.698928886175766186e-05,
   2.154499874766950266e-06, 9.997678795745355048e-05,
   8.997910916170821034e-05,-1.939049887290111963e-06,
   8.053438098097564403e-06, 2.889882583774141281e-05,
   2.889882583774139926e-05,-8.053438098097613531e-06,
  -1.110339378045850418e-05,-2.786960076061505959e-05,
   2.078415808518505498e-05,-2.163374153238493196e-05,
   1.273250717867515393e-05,-1.542346462196434373e-05,
  -8.822816988733326867e-07, 9.961002911546266877e-06,
  -4.199207165093003383e-06,-2.970465719688802735e-05,
  -9.930938774501047424e-06,-1.173224214339118117e-06,
   1.916957792223883490e-05, 2.307655265162484237e-05,
  -1.489719492398511940e-06, 9.888414222410382571e-06,
  -6.301834974335285691e-06, 7.764462373934501524e-06,
   6.512905024154540685e-06,-7.588284927857055786e-06,
   2.528852856914324680e-05,-1.613971259990790020e-05,
   7.920231565830835178e-06,-6.104910477936336035e-06,
   5.083902280276046927e-07, 9.987068607757036335e-06,
  -7.051142185330046553e-06, 7.090937447352010108e-06,
   1.935407976940260545e-05,-5.041785029094444555e-06,
  -1.396713274410084928e-05,-1.431499922838509877e-05,
  -4.869908188271456703e-07,-9.988134958158008170e-06,
   1.752551103748674439e-05,-9.636205833985195501e-06,
  -3.756313875115385765e-06, 9.267691517935610409e-06,
  -1.209395988314503916e-05,-1.592909709760344537e-05,
  -9.929219741651872409e-06, 1.187684858028733473e-06,
   3.154959085837151876e-06,-9.489269369487495509e-06,
   9.857487130492535013e-06,-1.682244771777895210e-06,
   1.805025406339188119e-05,-8.613264668347588786e-06,
  -1.578084564063597788e-05, 1.228677788789316890e-05,
  -9.477468424222786728e-06,-3.190233889209390329e-06,
  -1.061798317134460166e-05,-1.694870004965109189e-05,
  -4.166225208475238663e-05, 1.544806031553041018e-04,
   2.265986678910225657e-05,-1.966037733870183414e-05,
   2.436991974728629203e-06,-1.985097151564901049e-05,
  -7.614644285721678355e-06, 6.482066985300769690e-06,
  -5.917035060865667643e-06, 1.910467733536702601e-05,
   2.090906611306036852e-05, 2.151304149300304271e-05,
  -1.600465706853059834e-05,-1.199378806377424640e-05,
  -9.770940610502606109e-06,-2.128078848640479660e-06,
   5.180443781168806767e-06,-2.954933167146339007e-05,
   1.994843612166095711e-05,-1.435233883383600071e-06,
  -9.772338451026475975e-06,-2.121650583529121094e-06,
   2.083269205840251453e-05,-3.414672666010276468e-05,
  -1.836439721544005357e-05, 7.921421268531147835e-06,
  -2.329896152292129402e-05,-3.251397225737626427e-05,
  -1.096151297430503419e-05, 2.792570918193739218e-05,
  -1.380684694145631488e-05,-2.663401917727023133e-05,
  -1.999668466466394907e-05,-3.641461547149523071e-07,
   5.638376316765767063e-06,-8.258856610362896625e-06,
  -5.428028776475843358e-06,-1.924932475703369200e-05,
  -1.991978973485062742e-06,-9.799592836908757094e-06,
   9.291914735489536457e-06, 3.695987087151742688e-06,
  -4.393474221728211769e-05, 5.449530646120789775e-05,
  -8.790819806766438427e-06, 1.796445064912820916e-05,
  -1.770232975789630671e-05,-9.307390673153189691e-06,
   8.911344475019506529e-06, 4.537393486081995589e-06,
   3.341121972913145809e-05,-2.199296242464159805e-05,
  -3.548149209341309445e-06, 9.349365603518276232e-06,
  -2.227490361235126535e-05, 2.009548877386316634e-05,
   2.845025931182259060e-06,-1.979661151437034521e-05,
  -5.931096442602149226e-06, 8.051216988042996550e-06,
   8.443942752369199456e-06, 5.357222302155444882e-06,
   4.972441760235571785e-05,-5.242355778324941615e-06,
   2.330395526363485375e-05, 1.889247652031107911e-05,
   6.748978766047125886e-06, 7.379111438069290247e-06,
  -6.090273009682560090e-06,-1.905015943942549100e-05,
   3.194937516956988659e-06, 3.987220051944388412e-05,
   8.324649839090733262e-06, 5.540776575221801299e-06,
   5.190724212008235987e-06, 8.547302624505083717e-06,
   9.849744272417302202e-06, 1.727002538499169474e-06,
   2.673940469796135672e-05,-1.360162624095523869e-05,
   8.234376915873842069e-06,-5.674067042900006496e-06,
   3.768880816487702412e-06, 9.262588050383705615e-06,
   9.397239541836495614e-06,-3.419340432502244530e-06,
   2.986751883387069305e-05, 2.816259701870453694e-06,
   6.623379159451813595e-06,-7.492052356339977200e-06,
  -2.822897362303761841e-05,-1.015505037849869718e-05,
  -9.428191500699426315e-06,-3.333047408324565792e-06,
  -3.317192612578356391e-07,-9.994496602216169521e-06,
   9.864839055160892092e-06,-1.638581830661005686e-06,
  -1.061616083534695953e-05, 2.805881553305565609e-05,
  -1.615588107447888568e-05,-4.731794064313550737e-05,
   7.652959964635869613e-06, 6.436785205339741049e-06,
  -9.688870444011221108e-06,-2.475033235971958009e-06,
  -8.751524794781944319e-06, 4.838472255404269524e-06,
   1.922221550148591206e-05,-5.523262732700188812e-06,
   6.550638802304338463e-06,-7.555734992821333350e-06,
   8.294968704868870482e-06,-5.585113623306698853e-06,
   6.430907287701729935e-06, 2.930261816727278016e-05,
   2.284392787030790794e-06,-9.735581625900000625e-06,
   2.686925524105906543e-05, 1.334328006117011576e-05,
  -7.462155139281787851e-06,-1.855576030986848086e-05,
  -1.906424928638987974e-05,-6.046023415963836386e-06,
   7.807826561823543157e-06, 6.248027239095774400e-06,
  -7.801327009682267456e-06, 6.256140734350686753e-06,
  -8.400282302544157076e-06,-5.425426917539617470e-06,
  -4.864819878766270787e-06,-8.736906062626548911e-06,
  -6.084638492326356482e-05, 3.460805457939009126e-05,
   7.215268045570453183e-06,-6.923865035554198631e-06,
  -3.290970674327593007e-06, 1.972737975557615323e-05,
  -1.847487803842491247e-05,-2.363638892608862276e-05,
  -1.095980087779522318e-04,-2.576592254740899001e-04,
   8.309646495929579507e-06,-5.563252206460289785e-06,
   5.957042939056557136e-05, 3.676090235866961102e-05,
   1.681232634956364254e-05,-1.083262123014407224e-05,
   8.850712455472076653e-06, 2.866469760926410940e-05,
   3.303670891171646348e-06,-9.438525236647150949e-06,
   2.993215925858729254e-05,-2.016393344208199718e-06,
  -2.975189706621728922e-05,-3.850275439655087403e-06,
   8.117048602158700383e-06, 4.933673602894899415e-05,
   1.642478666079381149e-05,-1.141167749050987299e-05,
   5.768545722330903123e-06,-1.915003603780885696e-05,
   5.684617938616580927e-06, 8.227096625903854786e-06,
  -4.561047529392862324e-06, 8.899260948787786248e-06,
   6.783787673521594235e-06,-1.881436219489187285e-05,
  -2.884287065746032872e-05, 8.251594526939266954e-06,
   5.328029826832528845e-04, 1.364587177274845687e-04,
   3.122827497775389135e-05, 2.499589650150181594e-05,
  -7.941421973295085824e-06, 6.077319889726556772e-06,
  -1.272773684712141673e-05,-1.542740142572390259e-05,
   2.596477036942561073e-05,-1.502766447798851871e-05,
   2.598479263772488580e-05, 1.499301676029339451e-05,
  -2.204310420945897268e-05, 2.034948541882404107e-05,
   9.976042723881902691e-06, 6.917886753069759505e-07,
   1.193724804589670332e-06,-9.928495409220239228e-06,
   1.703449880220683763e-05, 1.047978294420327434e-05,
  -2.875562651150408174e-05, 2.780492661257864202e-05,
  -1.234102219470847267e-05,-2.734408841394631099e-05,
   9.677149681382977658e-06,-2.520470996482472167e-06,
  -5.442028555075839181e-06, 8.389536650241132134e-06,
  -2.879970573342865298e-05,-8.401008848222740470e-06,
  -9.913155119522829126e-06,-1.315049647837805268e-06,
   3.824999283035554563e-05,-1.170205317359947615e-05,
   2.081765623391667231e-06, 9.780912630693759050e-06,
  -4.985079420177289481e-05, 3.859833863327027984e-06,
  -1.075685927207448039e-05, 1.686090088342806560e-05,
   1.857957909261835684e-05,-7.402650926603182691e-06,
  -2.261964985598015638e-05,-1.970663442581855503e-05,
   1.677760744099606499e-05,-1.088631657429791466e-05,
   9.738370459873527609e-06,-2.272474595295332978e-06,
   7.015000640957782884e-06,-7.126693904424541178e-06,
  -2.636413012526700388e-05,-1.431546865240495352e-05,
   1.501546146270394755e-04,-1.872260444121096772e-04,
   3.409803445633932982e-05,-2.091229414039253625e-05,
  -9.036781888506518898e-06,-4.282122499364138224e-06,
  -1.937832362542385621e-05,-3.499257883420912001e-05,
   3.786972104778523166e-06,-1.963819854970484238e-05,
   1.257278313622300086e-06,-9.920647722910792122e-06,
   3.395515527078541164e-06, 1.970965434261516034e-05,
  -9.985424058235315876e-06,-5.397280585770578441e-07,
   7.398809360054083336e-06, 6.727378393815535213e-06,
   2.879902356794253712e-06,-5.993084483315191285e-05,
  -1.962645872338062222e-05,-3.847352073756284272e-06,
  -4.827725671309040141e-08,-2.999996115508292424e-05,
  -2.601027393839415824e-05,-1.494876749600761119e-05,
  -4.442325881595525978e-06,-2.966927266991401178e-05,
  -1.604574691856456493e-05, 2.394630117697206767e-04,
   1.474729137128054193e-05,-1.350989997041260640e-05,
  -6.740572391761126658e-06, 7.386791172859003960e-06,
  -1.019503481636152117e-05,-1.720643092257009919e-05,
  -8.356808951354417032e-05, 5.492152961322426620e-05,
   1.570664392756695250e-06, 9.875880384316441092e-06,
   7.899010064301249313e-05,-1.267138510214087162e-05,
   8.718832648072356219e-06, 1.799949880565866468e-05,
  -4.943102858777583848e-05,-1.309831035391759472e-04,
   2.268835879864880537e-05,-3.294295637953241674e-05,
  -1.483531414421259634e-04,-1.486315761345904820e-04,
  -4.149092202986724872e-06,-4.982755295909196974e-05,
   8.485256536339459235e-06,-5.291542451167570233e-06,
  -3.248437662908195556e-05,-3.801006807439252832e-05,
   1.057272446821197829e-05,-2.807521143854969762e-05,
  -1.927616651158109038e-05,-5.331923163156020076e-06,
  -2.155217999510562887e-05,-2.086872150991930580e-05,
  -1.392979476353580740e-05,-1.435133505447386795e-05,
   3.913424102860303475e-06, 9.202451401183927890e-06,
  -1.380283904596623280e-05, 1.447348037864942966e-05,
   1.268358033586150527e-06, 9.919237263955201601e-06,
  -3.958698294186726056e-05,-5.733304593365924856e-06,
  -1.999999634403401962e-05, 1.209291635059477773e-08,
  -2.407240852841040158e-06,-1.985460126712226928e-05,
   7.710803991559625045e-06, 3.924975798401498730e-05,
   1.222214549846766036e-05,-1.583095573281306318e-05,
  -7.047266775443253745e-06, 7.094789002904431232e-06,
   1.748477715313015286e-05, 9.709921107062503834e-06,
   4.248873419143068441e-06, 1.954346629101653320e-05,
   2.976619975500663967e-05, 3.738094721250739603e-06,
  -1.882121002031712472e-05,-6.764765581386709917e-06,
  -8.644873821581371045e-06,-5.026545196149849564e-06,
  -3.353782631315143530e-05,-2.179940839080014308e-05,
  -1.620766709997645792e-05, 2.524502975194009788e-05,
  -2.099785276732967821e-04, 3.002984541175314667e-06,
  -3.748841782045656847e-05,-1.395057451572783157e-05,
  -2.879848030140754066e-05,-4.087355541581184638e-05,
   7.490356834804712014e-06, 6.625296558441317210e-06,
  -1.051593815150785038e-01, 1.690812169834853343e-02,
   4.144741236359950943e-05, 2.566751098341281119e-04,
   1.488689478522893582e-04,-1.170571670751241250e-03,
  -2.156398581061900002e-04, 2.497988222469077913e-04,
  -2.021867127966334090e-04, 5.674974157202550864e-05,
  -1.731708015467359573e-05,-1.000593498462837568e-05,
  -8.602398099029437772e-06,-5.098896640040345971e-06,
  -6.386053281600049127e-06,-7.695344273297021230e-06,
  -3.995301261527738876e-05,-1.938242235502546267e-06,
   4.398404572657026011e-05, 2.377821947755921948e-05,
   1.037508325699220701e-05, 2.814884806542676139e-05,
   9.183794364773651463e-06, 2.855972550753161038e-05,
   5.764748022069040781e-05,-3.970853842947517931e-05,
   1.421393741516453982e-05,-2.641900798966126241e-05,
   2.167333467996506084e-05, 2.074286778269156966e-05,
   5.104447056206417071e-06,-1.933764774346626052e-05,
  -9.634370698613572710e-06, 2.841089405917554409e-05,
  -1.515855596069210335e-05, 2.588857240534066261e-05,
  -8.803529606370799371e-06, 4.743191591086409489e-06,
  -1.992503888118529580e-05, 1.729978492136332566e-06,
   4.176617070085553973e-06, 9.086026075786375809e-06,
  -9.537676560122956851e-06,-3.005449356499145454e-06,
  -1.514546734635680925e-05, 1.306196075864721258e-05,
   7.629655393073214411e-06,-6.464391586448706460e-06,
  -1.156604091033910059e-05, 3.829133972140910170e-05,
   1.941216634962136732e-05,-4.813293842539426623e-06,
  -2.942532109025792259e-06, 1.978235336827629192e-05,
   1.265002848854835728e-06, 9.919665709709634983e-06,
   8.720590611236472882e-06, 4.894006476417282578e-06,
  -6.006403595120239942e-06,-7.995193296758164314e-06,
   4.181184144005024560e-06, 5.985413685915052460e-05,
   1.758180012592136971e-05,-9.533116192103783260e-06,
   1.135128964222781160e-05, 1.646657898466623548e-05,
  -9.169182127754944676e-06, 2.856442016054341814e-05,
  -2.995693824311653668e-05, 1.606813958771192619e-06,
  -2.675842930134619282e-04, 1.870961957425239979e-03,
  -3.966605422748741884e-05,-5.157920319472551957e-06,
   1.605225844124011345e-05, 4.735319417880525634e-05,
  -1.424799650323154103e-05,-1.403547632408326313e-05,
   1.927023830459457710e-05, 5.353308853796497994e-06,
   4.633906450034568206e-05, 1.878007191766855005e-05,
   2.867281514536099648e-05,-8.824379391206897165e-06,
  -1.714762988016487572e-05,-2.461623020474249530e-05,
  -3.068066478258766591e-05, 2.566508929457455478e-05,
   1.889379205155205830e-05, 6.559315658870848841e-06,
   9.571656748654146178e-06, 3.198568170089328738e-04,
   1.325710155190834024e-05, 3.773922705146979438e-05,
   1.496429283490773141e-05,-1.326913486068813758e-05,
   2.029819864114044182e-06, 2.993125174995606497e-05,
  -1.688188736412826578e-05,-1.072389290439281113e-05,
  -1.336149869496732478e-05, 2.686020015979751643e-05,
   1.562232033289670486e-03, 7.590911083273445097e-03,
  -2.675623744082851886e-04, 4.105001532289612068e-04,
   6.237899987450498793e-06, 1.900233153448715871e-05,
   1.565347020387496189e-05,-1.244864934747536345e-05,
  -1.917015433735346571e-05,-5.701331658660823142e-06,
   9.999621124036127561e-06, 8.704812307265448514e-08,
   3.614378560393325480e-05, 1.713554090820909712e-05,
  -8.590309651570368385e-06,-5.119236279967647939e-06,
  -2.001085201905804953e-06,-1.989963964534819719e-05,
   9.565256144855758947e-06, 2.916483307563949513e-06,
   2.752631229144428149e-05,-1.192904571346273131e-05,
   2.809203415621570240e-05, 2.847521056930063426e-05,
   7.003171494855356173e-06, 1.873380871615928112e-05,
   3.744861875231444114e-04, 6.449880118560603621e-05,
  -1.945133497621984173e-05,-4.652479730518635608e-06,
   1.407448589214831860e-05,-1.420946328584292545e-05,
   3.945790957623166905e-06, 9.188619794002756260e-06,
   8.950786622940635345e-03, 2.632929704832049061e-03,
   2.884306607820008274e-05,-9.575007853369408412e-05,
   3.054043689650071407e-06, 1.976544502766655782e-05,
   1.970534593325003788e-05, 3.420430038890762097e-06,
   3.742729611133561215e-05, 1.411373465084286404e-05,
   1.601002787585719187e-05, 2.537082985269255417e-05,
   1.091157491888364176e-04, 1.391952869025902520e-05,
   2.051777744826009398e-05, 2.188654400730433944e-05,
  -1.499264423978506095e-05, 1.323709253194370818e-05,
  -9.066469096909948071e-06,-4.218902477514375949e-06,
   9.862183871498904773e-06, 1.654487620004116563e-06,
   1.653227922141433124e-05,-1.125538732097621014e-05,
   6.330596416844007899e-06, 2.932445308964929116e-05,
   2.017200757549653093e-05,-2.220563240203058558e-05,
  -2.891166202355407441e-05, 8.007234168911329133e-06,
   1.512320541885153944e-05, 1.308772928583180446e-05,
  -1.469959784016886157e-06,-1.994590730534395005e-05,
   3.294338437509064792e-05,-5.014711782261302756e-05,
   1.560316699992821110e-06,-9.877520528742197173e-06,
  -3.173107345143863484e-05, 2.435444471999734004e-05,
  -2.087984968858430811e-05,-4.543161759152018037e-05,
   9.476252147031832731e-06,-3.193844900096842604e-06,
   2.228965508612365510e-05,-3.321402228188633508e-05,
   6.336722359152712564e-06,-7.736016400125720349e-06,
  -1.998226570489319983e-05,-8.420554014131723524e-07,
   4.298052947457364836e-06,-9.029215960472596281e-06,
  -9.725796528515897509e-06, 2.325700300104923086e-06,
   9.204419639680631740e-06,-3.908792536917439793e-06,
   1.836845938182309274e-05,-7.911997215514885465e-06,
   7.838101376453847331e-06,-2.895797242233012908e-05,
   2.996918962581904199e-05,-1.359291422653828399e-06,
   2.409911255794268186e-04,-4.266418608059468240e-04,
   2.221350801579339879e-04, 2.162313718294092734e-04,
   1.099307869066170154e-05,-1.670784908062434342e-05,
   1.995304802775174180e-05, 1.369625643098291755e-06,
   2.997686604206562254e-05, 1.177922873558747237e-06,
   3.240976774664743824e-03, 8.106106929104977057e-03,
  -5.704450072578463003e-03, 2.271310055773883251e-03,
   3.917311555422308360e-05, 8.091169122907148717e-06,
   1.121651285209180910e-04, 2.345612584036117331e-04,
  -1.462980285580106698e-05, 1.363704030940713363e-05,
  -2.115009650790776721e-05,-2.127612318318794837e-05,
  -1.836152794133958863e-03,-8.002039922206966027e-03,
   2.635332532267593305e-05, 5.390271091918482862e-05,
   7.251948716164237536e-03,-1.662179237664781258e-03,
   1.438981399393128200e-04,-4.234767197858627986e-05,
   2.885238527093482561e-05, 1.267578000131650278e-04,
   1.590522536493989644e-05, 1.212533735986230693e-05,
   7.319168150823527815e-06,-6.813939945433223101e-06,
   3.792579585790480654e-05, 1.271353642951207400e-05,
  -9.535152322134056774e-06, 2.844434689342860491e-05,
   2.814898870959659134e-04,-2.699322942196808622e-04,
   3.045239242995761791e-04, 3.035871860424711613e-04,
  -6.397284078225282415e-05, 2.841611588955340312e-05,
  -2.437519750074676440e-05,-5.482563038214507490e-05,
   9.157370078647570949e-06, 3.893767549870806593e-05,
  -2.983904924251932331e-05, 3.103407853071702412e-06,
  -9.816587092545577664e-06, 1.906467375663057608e-06,
   1.138129407856555765e-05,-1.644585495184755061e-05,
   9.646132629996713188e-05,-2.636688317665308515e-05,
   3.596578478711408222e-06, 5.989210818836209984e-05,
   2.331359774630586778e-05,-1.888057626566101255e-05,
   1.267963368397906761e-05,-1.546696122837655174e-05,
   5.740396686714395390e-06,-8.188274902515083945e-06,
   5.337780898461923818e-07,-9.985743885700261419e-06,
  -8.015410404799325929e-06, 2.890939632788334064e-05,
  -4.517224567687891970e-06, 8.921585184544110134e-06,
   7.383318876640568210e-06, 6.744375609783538615e-06,
  -1.105010906346561299e-05, 1.667018565240097197e-05,
  -7.110379619319905294e-06, 7.031536223981224289e-06,
  -2.253649788351663014e-05,-3.304703107914916621e-05,
   3.970965488273027445e-05,-4.810749327750905986e-06,
   1.269314905838506645e-04, 9.740840157892866600e-05,
  -5.001650549148192124e-05, 7.482211690683818303e-05,
   1.984934122030626496e-05, 2.450235319280715364e-06,
   2.987708904025369806e-06, 9.543248687150907882e-06,
   5.028193848833540676e-05, 3.273723662521402651e-05,
  -1.962335664437175840e-05,-3.863143021917628493e-06,
   2.795109925949136031e-05,-2.861356409443013808e-05,
  -1.984075713506088461e-05,-2.250209670914091824e-05,
  -1.755993057320963478e-05,-9.573339974327539010e-06,
   5.311306887243469849e-06, 1.928185725363405312e-05,
  -8.627824932970158529e-06, 5.055752854523102370e-06,
   1.694431408683243537e-05, 1.062498094712512577e-05,
   3.497919333016806211e-05,-6.063378624142422117e-05,
   9.875610652915228120e-05, 1.572359447463354991e-05,
  -2.226026441968855131e-05,-7.684061834710564508e-05,
   9.605077293388210378e-05,-2.782533052461052481e-05,
   3.973629345900383565e-05,-4.585518742730122904e-06,
  -3.655934383322906653e-05,-1.623004554780226703e-05,
  -9.427609692346910139e-06,-3.334692712794780175e-06,
  -2.841714743455058543e-04,-1.165867305128804720e-03,
   1.457413512629285660e-03,-3.548885081339872875e-04,
  -9.039056265592707758e-07,-2.998637948499742562e-05,
   2.443177398780648196e-04,-4.362440165559572001e-04,
  -9.279016313224147747e-05, 3.728251099231400710e-05,
   5.124008274527748677e-06,-8.587464072854755827e-06,
  -1.537934282446520806e-06, 9.881030216676585620e-06,
   1.944915767942951724e-06, 9.809041882651276550e-06,
  -6.750075454620044288e-06,-7.378108250556914628e-06,
   2.157501006468869558e-05,-4.594937637669401550e-04,
   3.397718465424137067e-05, 3.668175190706661509e-05,
   7.235357319274931729e-05, 1.080044464188464063e-04,
  -2.291111628225162754e-05,-1.936700159294526768e-05,
  -5.693792978213263582e-06,-1.917239477794178420e-05,
   7.856823847619218035e-06, 6.186300916337804258e-06,
  -1.487098312373709599e-05, 1.337362557175601996e-05,
   1.258774638891133621e-05,-1.554183518277200355e-05,
  -1.982854014418353162e-05,-2.613234729315803010e-06,
  -7.151917816715556830e-06, 6.989282620050972957e-06,
   5.453662238821152284e-07,-9.985117709964593590e-06,
  -3.629667317762800263e-06, 3.983497853849509801e-05,
  -9.912094973870925007e-06, 1.737096350894108704e-05,
   1.723841169085485513e-05, 1.014086595792483444e-05,
   9.995857237771910519e-06, 2.878160559852919934e-07,
  -6.484053965868984732e-06,-1.891975275123062412e-05,
  -1.864592601546976753e-05,-7.233909249197684240e-06,
  -3.736376435582563521e-06, 9.275747470237821879e-06,
  -1.553812511326114394e-05, 1.259232575677120016e-05,
  -1.739251128221444415e-05, 9.874236745087862767e-06,
   4.626415149793348400e-07, 9.989292408805423092e-06,
   9.465082832095015708e-06, 3.226795156433117559e-06,
  -1.099199303891375237e-05, 4.877679867552268522e-05,
  -8.781833828012859135e-05,-1.969617886080706439e-05,
   6.807724444858851982e-05, 1.629382669255823496e-05,
  -7.009127498590958748e-06, 2.916971257500656364e-05,
   9.426878944319852524e-06,-1.763898957903028779e-05,
   1.966800923332199822e-05, 2.265324287597607334e-05,
  -1.839105025455041572e-06, 9.829429927790625740e-06,
  -2.624821161914654814e-06, 2.988495129438836957e-05,
  -6.974173060265164185e-05,-6.007579591412983683e-06,
  -4.258476094310904997e-06,-9.047949013681639638e-06,
   1.971905590718939238e-05, 3.340484115983659054e-06,
  -7.346367434359384970e-06, 6.784606511757621657e-06,
  -1.399704932302823579e-04, 2.874199866306613313e-06,
  -6.530867790690434196e-06,-7.572830771945340934e-06,
  -9.215926634749004961e-06,-3.881584246531808845e-06,
  -8.954029368309885276e-06,-4.919172042195154302e-05,
   8.910312904860062623e-05,-1.267408354668784046e-05,
  -6.985416091249437411e-05, 4.516215585126845886e-06,
  -5.753203366610711563e-06,-8.981592648869364591e-05,
  -7.394196365940195262e-06,-6.732448299238311119e-06,
  -1.355448518911196330e-05, 3.763344166108309626e-05,
  -9.198359511663383578e-06, 3.923032283093242095e-06,
  -3.986378284035856497e-05,-3.298305270397838346e-06,
   1.096199176437920439e-05,-2.792552124057279977e-05,
  -9.950813899885409681e-06, 9.906072530762795939e-07,
   1.661419350817648679e-05, 1.113411757046180812e-05,
   6.828748776862844443e-05,-1.538892505178382955e-05,
   2.216027986297357654e-05, 9.751370158287854376e-05,
  -1.052746130741007044e-04,-4.785574739172907249e-04,
   6.544124551968584459e-04,-1.436813783453504329e-04,
  -1.117739295713573501e-04,-8.430058521847426909e-05,
  -5.507240633061432809e-05,-2.381239301195305799e-05,
   6.117462369497667913e-06, 7.910540699457906271e-06,
   1.982587335872742291e-06, 9.801497204796675683e-06,
   1.114226224544681007e-05,-1.660873240357886636e-05,
  -1.815031992737773230e-05,-8.400350381611165158e-06,
   2.906225769103232143e-05, 7.453445631317125099e-05,
  -1.024848634817216884e-04, 3.996064009913841088e-05,
   1.121295840772696192e-04,-4.274291022682619504e-05,
   7.429766959682122427e-05, 1.964175559680997373e-04,
   7.683006126679086745e-04, 1.264956192353757511e-03,
   1.990652988984712804e-05, 1.931338329921240718e-06,
  -9.133318126837349852e-06,-1.779276538354800875e-05,
   2.722271233042948286e-05,-1.260650361419384953e-05,
  -7.481894027087560603e-05, 6.634852053168291115e-05,
  -1.255436499115960712e-04,-1.683412960829118975e-04,
   4.885306327752260701e-05, 8.725467442150232973e-05,
  -2.966658060630942488e-04, 1.661005704774507050e-04,
   8.094657766733589910e-06,-5.871670600387898858e-06,
   1.171064947759498216e-05,-1.621297902339062646e-05,
   2.972815970713686261e-05,-4.029456592018873803e-06,
  -2.962473235615812532e-05,-4.730246592514800864e-06,
   1.781788994524197991e-05, 9.084205958653997529e-06,
  -3.625092325908900903e-06,-9.319801802003968859e-06,
   5.190356070328772862e-05,-3.010017252974019585e-05,
   4.514766340032377661e-05, 7.785684613115962532e-05,
  -7.393044380347645018e-05,-9.452137048848271886e-05,
   1.883763142950252271e-04,-1.487089917006428831e-04,
   1.169590920330830108e-05,-1.622361574705121715e-05,
  -1.188539451572437523e-04, 6.492100890471118064e-04,
  -8.449917140889157260e-04,-2.070966033547536750e-04,
   1.396832323861342250e-05, 1.431383756724982271e-05,
  -1.425164517951152631e-06, 9.897924332746389648e-06,
   2.680087672434969519e-05,-2.969365263496916060e-05,
   2.952409687991333631e-05, 5.322377610193740949e-06,
  -2.991003760028034160e-05, 2.321562135678524113e-06,
  -2.321562135678465245e-06,-2.991003760028034498e-05,
  -2.874079222310605490e-05, 8.600398966806519063e-06,
  -8.600398966806564803e-06,-2.874079222310604135e-05,
   4.941372351821426973e-05, 6.291489432610912794e-05,
  -9.437371274016517222e-05, 7.411883933007038189e-05,
  -9.250336442082080911e-06, 1.773221011911059984e-05,
   1.100542252329996369e-04,-1.161381397662464331e-04,
   2.253923941470637685e-04, 2.128338992281414389e-04,
  -1.731637303168097352e-04,-1.661755773354411600e-04,
   2.626019161754697471e-04,-2.746638556872228157e-04,
  -4.248232420393067369e-04, 1.136206078196306743e-02,
  -1.410073317337610585e-02,-5.112963653797988504e-04,
   1.994996194181976508e-04, 1.413866514188298898e-05,
  -1.767333142735416355e-05, 2.493745242727470296e-04,
   3.894678354527733074e-06, 4.984808402049945524e-05,
   9.934280631823882320e-06,-1.144582163135927196e-06,
  -8.704129091359774689e-07, 1.998105055715563395e-05,
   5.693090617632893616e-06, 2.945485900864949660e-05,
  -3.743552231855515046e-05,-1.409190082057631500e-05,
   1.056889131333549692e-05,-2.807665465127392196e-05,
  -7.620122948539712711e-05, 7.933077980780123262e-05,
  -1.081435454802474086e-04,-1.039469748042801806e-04,
  -2.835124457573988597e-05,-9.808513190416765594e-06,
   1.557101004994588373e-04, 1.088777507227644517e-04,
  -2.620545069728348695e-04, 3.780574498343134641e-04,
  -1.282151268251184933e-05, 3.788942877020169898e-05,
  -3.788942877020171930e-05,-1.282151268251177988e-05,
   1.959855426980305860e-04,-2.778302846223903956e-04,
   4.167558423777171584e-04, 2.939635484954544633e-04,
  -1.292308832532277144e-02, 1.625069665833926702e-01,
  -2.030290330344767524e-01,-1.614560760966721187e-02,
   2.891237653154751699e-03, 3.299164030177973881e-04,
  -4.135929069140087963e-04, 3.616426538359437167e-03,
  -7.749931881526254496e-05,-1.984579510048144698e-05,
   2.752951526783667545e-05, 7.895201870687778298e-04,
   9.999999396339717708e-06,-3.474651825499542595e-09,
   1.991548682471324728e-05,-1.836677580489604435e-06,
  -3.643683056152578899e-06,-9.312549263564011995e-06,
   8.678057809520692376e-05,-8.288022240234212709e-05,
   4.799169698944521909e-05, 5.095877765481893976e-05,
  -3.723745109098554475e-05, 1.460726655628833098e-05,
  -1.095544991721619911e-05,-2.792808831823917720e-05,
   3.328339207132257157e-05,-2.218593726274871732e-05,
   2.218593726274871054e-05, 3.328339207132257835e-05,
   2.166168932466857526e-05,-2.075502868226251159e-05,
   3.487363269458157065e-05, 3.583056994639369718e-05,
  -1.133811887669888336e-04,-8.212615925382387946e-05,
   1.173698942771425255e-04,-1.619392105617795965e-04,
  -1.843195696936207774e-06, 9.828663674314828342e-06,
  -1.211638058348075926e-04, 2.412868254912087891e-04,
  -3.494549287477115686e-04,-1.731509537193827723e-04,
  -2.952832279100162295e-05,-5.298882254816960309e-06,
   8.850263477024116894e-06,-4.921049518534896132e-05,
   4.464863972266981023e-04, 2.250553200693624180e-04,
  -3.237064938995557416e-04, 6.431283742825042674e-04,
  -1.816642444628721129e-05,-8.365466086079035587e-06,
   9.985479850394328468e-06,-5.386948648064962039e-07,
   2.052497948096104741e-04,-1.667414921886754961e-03,
   2.114043192120423648e-03, 2.602333219426162430e-04,
  -2.963107846269185053e-05,-4.690329320825906530e-06,
   6.253772427767662768e-06,-3.950810461692250125e-05,
  -8.070271249257610506e-06, 5.905143686939887961e-06,
   2.002617922793231958e-03,-1.735517633245862871e-03,
   1.255298266732423869e-03, 1.452799456751885073e-03,
  -9.875981614821449569e-06, 3.876164324617455018e-05,
   1.495664401972358614e-05, 2.600574551262214466e-05,
  -2.600574551262212095e-05, 1.495664401972362680e-05,
  -5.396249402283850264e-05, 4.458754578169915747e-05,
  -4.458754578169925911e-05,-5.396249402283842132e-05,
  -2.789034127345347574e-05,-1.105119286096743709e-05,
   6.250664686488769165e-05, 4.992914076677292868e-05,
  -5.577437552258453652e-05, 7.063440404693539679e-05,
  -6.447232855111878800e-06, 2.929903050464239983e-05,
   9.405317089296889985e-05,-1.765049603976556519e-04,
   2.470471211491189704e-04, 1.317866454992027022e-04,
   3.996716510159783109e-05, 1.620405425077467162e-06,
  -1.590702934148179016e-06, 3.996835828721630938e-05,
  -3.899904166505503765e-04,-1.265206501751002836e-04,
   1.621540015696899275e-04,-5.045850570269961840e-04,
  -1.194831212335868590e-06, 3.998215074722754437e-05,
  -2.337209336110252997e-04, 7.126531591117735024e-04,
  -9.216407216310505343e-04,-3.024539307587134282e-04,
  -2.776257114943095873e-05,-1.136836149903687353e-05,
   1.724204500423395011e-05,-5.746922553916984096e-05,
   8.408227126836279608e-06, 5.413106001505470256e-06,
   1.648434454857592068e-06,-9.863197445455422312e-06,
   7.776392579880436610e-06, 6.287107319235174771e-06,
   3.015474400591012377e-02,-2.396829761263671171e-02,
   1.934143571360521369e-02, 2.426457839189621532e-02,
  -1.141563558726348370e-04, 4.765168689709529362e-04,
  -3.027819604963273982e-04,-6.650627337327227830e-05,
   6.367729665860364112e-05,-6.360190162449694913e-05,
   1.914842836866469935e-04, 1.446850686871720810e-04,
  -1.386335911717468490e-04, 1.835230977256676439e-04,
   1.136203117258980748e-05,-1.645916910518564077e-05,
  -5.836475960067088884e-05, 1.048501542047311247e-04,
  -1.222292354250035596e-04,-6.826429526054636824e-05,
  -3.996570089728424332e-05, 1.656125535342578978e-06,
  -4.102685484250582795e-08,-1.999995791988527593e-05,
   2.440418796229814854e-04, 8.968590184684663801e-05,
  -1.282919690163339930e-04, 3.470463523593238990e-04,
  -2.191800970679645946e-06,-1.987953743186515515e-05,
   9.063759541708562401e-05,-6.032286683315114762e-04,
   7.309851009495038241e-04, 1.151554696479663412e-04,
  -1.985951157539798386e-05, 2.366389652325583435e-06,
  -1.094720164524870488e-03,-1.835422604814503187e-04,
   2.322080202859513279e-04,-1.380608356962567109e-03,
   9.702820057405134907e-06,-3.880535121518186823e-05,
   7.907017928226919281e-05, 1.216169183419017053e-05,
  -1.878182894803651377e-05, 6.873347173444516780e-06,
   9.519506565158911078e-06,-3.062514449908182913e-06,
   4.079930104893248375e-06,-9.129850510232124166e-06,
   1.459757518692797477e-05, 1.367153241820333614e-05,
   2.576216990129743265e-05, 1.537239740498159079e-05,
  -2.605651853924625949e-04, 3.034893476901480967e-04,
  -2.450284344888007857e-04,-2.058180417066674168e-04,
  -9.947457192916751154e-06,-1.023765302737310595e-06,
  -2.228618563176067819e-04,-8.906510539302356106e-05,
   9.650089224482922309e-05,-2.414282042263327782e-04,
  -9.892747925358293511e-06,-1.738198891051651940e-05,
  -7.537434481249053169e-05, 3.826469758721317421e-04,
  -5.092631241733528401e-04,-1.051240712548563228e-04,
   9.670813297189215376e-06,-2.544674865460868245e-06,
   8.699805426604706113e-04, 5.818538664746978801e-06,
  -8.797859294650334970e-06, 1.009961681288865359e-03,
  -1.318037310043003130e-05,-4.823150179015226233e-05,
   3.249308246820053776e-05,-1.619674102895923536e-03,
   1.959605581224374733e-03, 3.931877457755517753e-05,
   7.996893476466820786e-05,-2.229231393158049606e-06,
   6.740856501406357900e-06, 1.097932641541704449e-04,
   4.785359611829994121e-06, 8.780679551462192522e-06,
  -3.511929331230981803e-05, 1.914772146350450310e-05,
   8.796825270638480490e-06,-4.755614067379338770e-06,
  -1.074020223858624502e-05,-1.687151611071948117e-05,
  -8.345678815405743506e-06,-5.509051198717234160e-06,
  -9.871933629428720854e-06,-1.595282550570371672e-06,
   9.938833746707297759e-06, 5.917110429724387586e-05,
  -4.930925358103651804e-05, 8.282361455589679921e-06,
   1.769571388685259246e-05, 9.319962984618145271e-06,
  -7.598071402058949641e-06, 1.850052191072495031e-05,
  -3.623285019014982989e-05,-3.445548674882071443e-05,
   2.067329204929239342e-05,-2.173971011408992911e-05,
   2.970197889251150250e-05, 4.218109750682310777e-06,
  -1.597767296658407317e-05, 3.667034178423878217e-05,
   2.096445734046646658e-04,-9.470739954417374930e-04,
   9.078150749166160639e-04, 2.019202559282718659e-04,
   5.945875455282474849e-05,-8.040927000473433887e-06,
   8.042089280097546557e-06, 5.945859735993559752e-05,
  -6.086299055552055453e-04,-4.086120487530296188e-05,
   5.486967081832150387e-05,-7.179062050325857791e-04,
   1.176007718307941039e-05, 2.759892361393855416e-05,
   1.693169226802942323e-04, 1.218290515309905552e-03,
  -1.416152986649434412e-03, 1.985213298461578526e-04,
   1.830060682960226484e-05,-8.067700395299457186e-06,
   2.400069045723300914e-03,-3.099493115992390971e-04,
   3.649311915022910549e-04, 2.826539443465935289e-03,
   1.678742326093474117e-05, 9.858084205492580882e-05,
  -1.273358349714497149e-04, 2.618368064508345700e-05,
  -1.595290053176539813e-05, 1.206254387032848385e-05,
  -3.016373757164847038e-05,-3.987667157259645894e-05,
  -7.605987520704575710e-06,-1.849726882096074023e-05,
  -1.832041897468017971e-05, 8.022608590239114110e-06,
  -2.038117954431453564e-05, 2.201380295138517833e-05,
  -3.184280168945144142e-06, 9.479470439094301513e-06,
   1.000317712320366560e-06, 9.949842434652829884e-06,
   1.414248689028553332e-05, 1.414178434845129094e-05,
  -1.041855891041480717e-05, 1.707201306906178180e-05,
   1.768475818789800268e-04, 1.470541831555887910e-04,
  -8.311758178359384536e-05, 9.995732888811897411e-05,
  -2.511364843783389276e-06, 1.984169969083820565e-05,
   2.939085768147904225e-06, 9.558335359646598348e-06,
  -2.576689326650370728e-05, 1.536447888451170370e-05,
  -9.709977750735544104e-06,-2.390885208499293283e-06,
   5.205449387720546221e-06, 8.538342735676509722e-06,
  -3.425698295874206290e-05, 9.394923692380081394e-05,
  -6.717036928201122910e-05,-1.970130682260042452e-05,
  -4.212336852573958274e-04,-4.272729600670666702e-04,
   2.627836721979528393e-04,-2.604702317466601699e-04,
  -6.361403800007370312e-04,-7.018131469642016563e-05,
   5.775934462359189140e-05,-5.670660085992222134e-04,
  -1.427663749698617959e-05, 1.400634219843454571e-05,
  -9.993223167680791044e-06, 3.680906422715931293e-07,
  -3.260568258199096717e-05, 5.036734520860168161e-05,
  -4.196709124431177512e-05,-2.718019964039281725e-05,
  -1.947135214699339292e-05, 2.282249867056137624e-05,
  -6.134472257611306662e-05,-1.038189204823503986e-03,
   1.108681332350943240e-03,-5.408977071995780818e-05,
  -3.691133295155650225e-05, 1.541277067043234824e-05,
   4.951186837682874072e-07, 9.987735353371332385e-06,
  -1.716296970020493584e-03, 5.083549062401902362e-04,
  -5.661150270852018758e-04,-1.907777181986492106e-03,
   9.812478348644594443e-04, 3.453295916450516059e-03,
  -4.040152387236496320e-03, 1.147679697436196442e-03,
  -1.437554635917099373e-04, 4.282950720627727597e-05,
  -5.194451344544972029e-05,-1.407187532737392188e-04,
  -7.715170460809721615e-07, 3.999255882595669301e-05,
  -1.999654903957410581e-05,-3.715191891516589765e-07,
  -2.143351200387131684e-05,-2.099058272606799520e-05,
   4.197237356357650648e-05,-4.287563244361048797e-05,
   9.393071828342745730e-06,-1.765701564895930854e-05,
   2.648316213018803923e-05, 1.409404567844783984e-05,
   1.089149667055242318e-04,-1.556840712068339766e-04,
   1.065206802994125775e-04, 7.452076669325358724e-05,
   9.355632576206594994e-06,-3.531591581570829531e-06,
  -1.371163992056755581e-06, 4.998119555699810689e-05,
  -2.854207381120187320e-05,-5.277641540078204776e-05,
   2.638820770039094596e-05,-1.427103690560107890e-05,
   8.153951184853594719e-05,-8.804151297826761757e-05,
   5.777700203888457014e-05, 5.533369710582086991e-05,
   2.277991237982927015e-05, 1.952115754680805961e-05,
   2.875507437338993869e-05, 8.552525812928785069e-06,
  -8.552525812928630909e-06, 2.875507437338998613e-05,
   4.826089127845248561e-06,-2.960926989525567452e-05,
   2.973049594939696264e-05,-4.012182772867010294e-06,
   2.518135604802527842e-03, 2.284511561762340125e-03,
  -1.807451794453163261e-03, 1.992289640270219608e-03,
  -6.163842196879415708e-05, 6.557976011847615420e-05,
  -4.371984007898373914e-05,-4.109228131252982204e-05,
   1.695505336466565896e-05,-1.060783509493524204e-05,
   2.440119877937976485e-06,-9.697722154263441671e-06,
  -2.544614728269552710e-05,-1.589004683653786801e-05,
   9.306155973326124417e-07,-9.956603567984480575e-06,
   8.500240336821878763e-06,-1.810375414703443189e-05,
  -2.165160676872270376e-04, 3.899733879715536888e-05,
  -2.150100040751670868e-05,-1.180580661432160131e-04,
  -1.951358415077552910e-05, 4.384065874345652722e-06,
  -4.384065874345757754e-06,-1.951358415077550539e-05,
  -1.522617510730945580e-04,-6.113234488878657768e-04,
   5.435041872366091304e-04,-1.349192293791841041e-04,
  -2.946773513778465218e-05, 5.626063086152852540e-06,
  -5.626063086152794942e-06,-2.946773513778466234e-05,
   2.349069701755856620e-03,-3.824546199128103286e-04,
   3.662051504100741878e-04, 2.321291405190898261e-03,
   9.861884541124105690e-06,-2.833272371830031772e-05,
  -5.558908188823810583e-06, 1.921193742828212767e-05,
  -1.199229484378075640e-05,-2.749881569049528133e-05,
  -1.129129480717675285e-03,-2.419497182427421747e-03,
   2.591052717616280140e-03,-1.210803788618655718e-03,
  -1.515574375289975218e-05, 1.305003568180716452e-05,
  -4.883033873622869524e-03, 2.210334859031914609e-03,
  -2.531764497895563036e-03,-5.593725818021082208e-03,
  -6.982782528881244883e-05,-1.439585871542058636e-04,
   2.018328561756018119e-04,-1.102882503623973161e-04,
  -7.733809112669246224e-06, 1.844419140566466210e-05,
   2.345285561413946364e-05,-3.240314126041374086e-05,
   5.671450006776872818e-05, 4.103005583792276466e-05,
  -2.921545597939159491e-05, 6.815946883319434084e-06,
  -3.219903937097050138e-06,-1.973910379515410063e-05,
   5.956075268778177740e-06,-8.032755902717881496e-06,
   8.082955772090982794e-06, 5.887769185898940934e-06,
  -1.012884648720330324e-05, 6.926331257483047071e-05,
  -8.905283045335349139e-05,-1.302280262640408560e-05,
   6.034940535144581532e-06,-7.973674983172366950e-06,
   6.784942028119494780e-06,-2.922267204885716261e-05,
  -3.897285988184246962e-06,-1.961660424044647918e-05,
  -6.428361270420365987e-06, 7.660037296055383367e-06,
  -5.826483671718426864e-06,-8.127243568590679644e-06,
  -5.512565625452982725e-06, 3.961832429854996118e-05,
   9.042842724704433879e-05, 8.049364568372002499e-04,
  -5.448073421193549981e-04, 7.539867354830679497e-05,
  -1.979787749670625893e-05, 2.836202853360809061e-06,
  -1.456060582552562655e-05,-1.371089924088384763e-05,
  -1.799831567464510115e-05,-8.721274727688865799e-06,
  -4.985721018560781200e-04,-1.025195522449650828e-03,
   7.374213407093959576e-04,-3.586220381771829417e-04,
  -5.473937248764248033e-04,-1.917292621534673303e-04,
   1.198510935064512137e-04,-3.394638646237739163e-04,
   6.146409624473490893e-06, 1.903212149835587085e-05,
   2.301915733740257476e-05, 5.540864910351005272e-05,
  -4.617387425292508572e-05, 1.918263111450205585e-05,
   5.112963178770094964e-05, 4.780963034006976839e-05,
  -4.097968314863132105e-05, 4.382539867517216801e-05,
   2.984699627546767738e-05,-3.026022691953696585e-06,
  -4.585111797201230320e-06,-8.886886395536184856e-06,
   1.016440140667812257e-05, 2.822560794817216627e-05,
   2.475548618116784057e-06,-2.989768651650726247e-05,
   1.988205667959929768e-05, 2.168829681925484590e-06,
   3.466130238378385057e-04, 9.725950702111341964e-05,
  -5.719117141394733530e-05, 2.020622921583848915e-04,
  -2.497433144315533773e-03, 4.046327837363478314e-04,
  -3.298984229397218374e-04,-2.013148536631583115e-03,
   2.671428946895259071e-05, 2.977157601083639307e-05,
  -1.834023446302093224e-05, 2.374101513923571250e-05,
  -5.223049444655535747e-06,-2.954183058814540528e-05,
   2.954183058814541544e-05,-5.223049444655484925e-06,
  -2.127048354605922190e-02,-7.366040611968430185e-02,
  -6.684431997604376463e-06,-1.884989042062056272e-05,
   6.777163001144043131e-02,-1.956777364935590943e-02,
   3.642241573453788741e-04, 3.569884636876221847e-04,
  -3.436482214288310005e-04, 3.206335913606076361e-04,
  -6.549580750988092510e-05,-1.568767006238613838e-04,
  -8.561787901262565782e-06, 5.166796680129184433e-06,
  -3.674971427280226213e-06,-9.300246502575830611e-06,
   3.544237562403497032e-03,-2.290585100197789232e-03,
   2.342430271549112569e-03, 3.617888945632569738e-03,
  -1.520512009399691569e-05,-3.699735562073499970e-05,
  -4.473441531685324983e-03,-6.919965380158549749e-03,
   7.686462493531893113e-03,-4.963949469477652553e-03,
   4.211932249958397125e-05,-2.694369447896927900e-05,
   2.155495558317547877e-05, 3.369545799966714448e-05,
  -1.269442714762196133e-05,-1.545482188165617853e-05,
   1.659044381091646719e-04,-1.116947510659401996e-04,
   1.910137278868749827e-04, 2.812716760691678637e-04,
  -4.516332010620631345e-06, 2.965809746375926135e-05,
   4.496770429989405197e-05, 2.186105143851252018e-05,
  -4.138390151167400060e-05, 7.992104038156702336e-05,
  -3.170404434020777670e-06,-1.974711461770406329e-05,
   3.892166091563161232e-05,-9.225199811852031762e-06,
   5.747743570144432156e-06,-2.944424296618718272e-05,
   2.944424296618717256e-05, 5.747743570144482131e-06,
  -1.394323151311651704e-05,-1.433828075368991126e-05,
  -2.772274009369986287e-05,-1.146515074899437221e-05,
   3.897570469460042321e-06, 1.961654771960635036e-05,
  -2.998751385154997678e-05, 8.654553732563906456e-07,
  -1.792504282205444391e-05,-8.870898479157254360e-06,
   2.968496866708353557e-05, 2.681049487111845494e-05,
  -8.974501423221268703e-06, 4.411159054556911587e-06,
   3.866985276444466252e-05,-1.022949105166877730e-05,
  -6.346349329548924170e-06, 7.728120740990913375e-06,
   7.563062470071989750e-05, 2.607697465924407935e-05,
  -1.583267150788595509e-05, 4.742706519407854796e-05,
  -7.525722739643883835e-05, 2.713576467691111317e-05,
  -2.360732125450095681e-05,-6.589912278010070276e-05,
   4.278206925421065409e-04,-4.323719501531472802e-05,
   1.905864130927241996e-05, 1.990898495439797646e-04,
  -7.144294613113118904e-05, 5.473486501403184036e-05,
  -3.040824448651981596e-05,-3.969053624288839917e-05,
   1.639549675563861897e-05, 1.145371931452153311e-05,
  -1.145371931452167880e-05, 1.639549675563851732e-05,
  -1.998023147905573886e-03, 3.625948634555307536e-03,
  -2.890069049253934583e-03,-1.592953511733616019e-03,
  -1.651885475288525026e-04,-9.387621512027441136e-05,
   5.328545841623818558e-05,-7.253040687443682369e-05,
   3.469208864067721527e-05, 1.148758416106162677e-04,
  -7.658389440707771964e-05, 2.312805909378413594e-05,
  -6.804788537793186702e-03,-1.567682853627985762e-02,
   1.263135921267250633e-02,-5.482851852862102512e-03,
  -1.500374345562017190e-05,-2.597860046880768676e-05,
   4.999764236054982520e-05,-4.855495716749324579e-07,
   3.884396573399483910e-07, 3.999811388843986287e-05,
  -5.356474215890952750e-05, 7.232439697259522484e-05,
  -5.667381517939811599e-05,-4.108623459276138762e-05,
   6.436235596715067172e-05,-6.290856169360243872e-05,
   2.781787015494538028e-05, 2.874310526095952755e-05,
   5.063536937304815785e-03, 1.598966442596518739e-03,
  -1.282875971292788981e-03, 4.062244360237279688e-03,
  -3.738076530679885220e-07, 9.993010949584105120e-06,
  -1.192035854864173408e-04,-1.728887075756609343e-04,
   8.653932145904603371e-05,-6.790394569837524495e-05,
  -2.814448114050473025e-05, 2.842337385553963047e-05,
  -3.126212518367997058e-05,-2.495354742316055658e-05,
   2.611395675250498608e-03,-1.037647641197623908e-03,
   8.341853152412588611e-04, 2.121917731637077819e-03,
   2.241547091766587653e-05,-3.312924181956592530e-05,
   6.527246048643640131e-06, 1.890489510736481304e-05,
   3.912197505607080362e-05, 8.334930576326017452e-06,
  -1.990869688091660334e-05, 1.908871002394243546e-06,
  -1.908871002394209664e-06,-1.990869688091660673e-05,
   5.227842294538082198e-03, 6.200142332514535504e-03,
   9.262125142849415388e-06, 1.772605533778445381e-05,
  -6.061959962728218770e-03, 5.127986096927338727e-03,
   5.816201900196024612e-05,-8.134604812537371186e-05,
   4.680748640520915452e-05, 3.753743753143200696e-05,
   9.991989915722941935e-06, 4.001718681904740087e-07,
   9.679116585647797380e-03,-8.527877937766097094e-03,
   9.184210968120999977e-03, 1.043361245652942200e-02,
   6.067350974234640281e-05, 7.949040958219675797e-05,
  -7.949200857288677563e-05, 6.067141479352608079e-05,
   2.011061882790560781e-05,-2.226124458242818927e-05,
   1.461169245149350211e-04, 1.508305153816587004e-04,
  -2.787693404380593080e-04, 2.582395299556778170e-04,
  -3.598131921945443834e-05, 1.747411420438011999e-05,
  -2.260732554108089732e-05, 6.624884023044924305e-05,
  -1.040917090055208958e-04,-3.556565922782762938e-05,
   2.997929924817323356e-05, 1.114278505796388132e-06,
  -1.114278505796439377e-06, 2.997929924817323017e-05,
  -9.444465238414863459e-06,-3.286651238019221881e-06,
  -8.136299987536886312e-06,-5.813830278981944190e-06,
  -5.212425515151068087e-06, 8.534085788706493098e-06,
   5.250366796683246246e-05,-4.629648852805803909e-05,
   1.489002149148762234e-05, 1.335242524723642643e-05,
   1.424025840041102245e-05, 4.792927123052804919e-05,
  -1.917170849221122849e-05, 5.696103360164375946e-06,
   3.427537182705049573e-07,-9.994124268219390107e-06,
   1.370719242712949226e-05,-8.895005832356516872e-05,
   2.986334285043091554e-05, 2.860201705757251154e-06,
   8.075819109065970913e-05,-1.381235482159522674e-04,
   6.878201630567383159e-05, 4.085381540230998001e-05,
   1.821178402216167881e-05, 8.266252036451381344e-06,
   1.347871735013410972e-05,-5.598377659452737727e-04,
   2.898408405319749981e-04, 9.606620619043663702e-06,
   9.445868628804995816e-05, 1.762882769350695251e-04,
  -1.058248827496000293e-04, 5.657821304206600284e-05,
  -2.063650743349157798e-05, 2.177463113229353390e-05,
   7.698074674422101128e-04, 6.064622519746885052e-04,
  -3.848689857472564063e-04, 4.860821574691650258e-04,
  -6.175484802942466590e-06,-1.902270715352120055e-05,
   2.988135183358071645e-05, 2.665485433792943677e-06,
  -3.991991654006755053e-07,-9.992028824335096989e-06,
   2.994982253701722766e-05,-1.734396148858417781e-06,
   1.476369854136242792e-05,-2.611576545651635801e-05,
  -1.854534308008235841e-05,-3.544108138928666257e-05,
   3.544108138928682520e-05,-1.854534308008204670e-05,
  -4.949608889017466070e-04,-1.500471165486892385e-03,
   3.110031420563033562e-05, 2.515492906591207343e-05,
  -1.886619679943392887e-05, 2.332523565422285505e-05,
   2.507844216944408780e-05, 6.535343708141024542e-05,
  -5.601723178406611825e-05, 2.149580757380872538e-05,
   9.710792772520461817e-06, 2.387572769396649036e-06,
  -2.941394778913581767e-05, 5.900819897098377766e-06,
  -7.838600924059338905e-05, 6.209374811793542904e-05,
  -6.209374811793529352e-05,-7.838600924059349747e-05,
   5.888225209677531573e-06, 2.941647164226393097e-05,
   1.092513216888607802e-03,-1.071127849943089494e-03,
   7.807614096940628965e-04, 8.030016320858503675e-04,
  -1.516238365513018344e-05,-1.304232041833971675e-05,
   2.317170518985644568e-05,-1.905445036190705295e-05,
  -1.883230816360322230e-05,-6.733807929476714460e-06,
  -1.604497715615652432e-05,-1.290060413626370071e-04,
   6.313739002327671336e-06, 5.966688109672304896e-05,
  -1.808175370308835286e-05, 3.567982879752719193e-05,
  -7.564072693588312739e-06, 2.903075617833802968e-05,
  -1.935383745222534635e-05,-5.042715129058908758e-06,
  -1.465710161676482028e-02, 1.729445784625323335e-02,
  -8.270144450680157200e-05, 5.621806717140336398e-05,
  -1.610237761938074566e-02,-1.363537439907192873e-02,
   1.174194307479933537e-04, 1.086861411718034910e-04,
  -1.121263267008594029e-04, 1.277798374571362011e-04,
   7.966874043843425306e-06,-6.043915781141719862e-06,
   2.721000476176593276e-04, 3.199399382485211812e-04,
  -2.781446248668466935e-05, 4.154943653741662555e-05,
   5.245838502898495046e-04, 1.281084853359710791e-04,
  -8.196963192333096479e-05, 3.402660421528331831e-04,
  -1.982249828512378537e-05,-2.658676688930905076e-06,
  -1.982036992291729682e-05, 2.674497358143297141e-06,
   1.617689399807809708e-02, 1.364015031350259560e-02,
  -1.415700921129264128e-02, 1.678751590293737703e-02,
  -6.436067928831438697e-05, 8.920595810564863515e-05,
  -8.109632555058957591e-05,-5.850970844392231227e-05,
   3.331058562839923372e-05, 2.214508715478633684e-05,
  -1.828883561419511635e-04, 2.250596569527618315e-04,
  -3.365617656974338213e-04,-2.834187323918898271e-04,
  -6.329565304227087691e-05,-1.019493026261213153e-04,
   7.405287889293292090e-05,-3.026831887747668233e-05,
  -7.760474662260916741e-05,-1.942944419278717319e-05,
   3.006527780851778184e-05,-1.367336062213552806e-04,
   9.960034557766653151e-06,-8.931470249035328819e-07,
   2.813471723436739271e-05, 1.041334173751109205e-05,
   2.067556623298794894e-06, 1.989284317561100548e-05,
  -1.989284317561100887e-05, 2.067556623298761013e-06,
  -4.265472595724847467e-06, 1.953985014106096962e-05,
  -8.737373662257273495e-06, 1.799050587076675314e-05,
   2.871641843861528749e-05, 8.681434907799279879e-06,
  -5.672928328702086072e-05,-4.100961372338118372e-05,
   6.868239260522276551e-06,-1.878369743847628457e-05,
   5.953798388526806024e-05,-7.431586296179341836e-06,
   7.431586296179224945e-06, 5.953798388526808057e-05,
  -1.549118163860987594e-04,-7.001663476602987474e-05,
   2.238579325669328644e-05,-6.632402475927244253e-05,
   7.675626543135145375e-05,-4.699442219063792975e-05,
   2.610918823281316976e-05, 4.264164970804401822e-05,
  -2.900421494951301547e-04,-2.607212141660984295e-04,
   9.562811347423818447e-05,-1.022509849016537417e-04,
   3.588051076997173671e-05,-4.585985051729736593e-04,
   1.594013820230059898e-04, 1.382748744912496855e-05,
  -8.951067754716946758e-04,-1.639629851663634450e-04,
   1.200775649474587645e-04,-6.286345348422156401e-04,
   4.914610111830789680e-06,-2.959470573343635252e-05,
   5.107592900068421695e-04,-1.752853321636082639e-04,
   9.720698948844462149e-05, 2.838147304045253450e-04,
   7.305542270401251025e-04,-6.681246301056452614e-04,
   5.194816938922802458e-04, 5.683649969085069389e-04,
  -1.997970680247001626e-05, 9.007308628738136373e-07,
   6.567402463850040066e-06,-1.889098263399277349e-05,
   2.986107335403860688e-05, 2.883799255275162225e-06,
  -9.496125333833347341e-06, 3.134262854983370456e-06,
   3.875211877054428691e-05,-9.913288596304944725e-06,
   1.184001649594547040e-05, 2.756472400325711902e-05,
   9.012928210454291912e-06,-1.785405066289432602e-05,
  -2.217985914024977862e-06,-6.996485216510633898e-05,
   5.996987328437688812e-05,-1.901130783449452476e-06,
   1.255590788067422481e-05,-1.556756812389215050e-05,
   3.090348056474405496e-06,-1.975980133730713688e-05,
  -1.478823805140135999e-05, 1.346506648090104951e-05,
  -1.271469401898124162e-05, 1.543815260980674318e-05,
  -3.280751351240775957e-05, 3.773151278617361203e-05,
   1.297117530253216419e-04,-8.652232492134933679e-06,
  -4.919911682426198102e-06, 7.984857211645758743e-05,
   2.191598187217513782e-05,-3.346176532370178210e-05,
   1.727305894722237778e-02,-1.517173472631857568e-02,
   1.208325066765839235e-02, 1.374354587806702298e-02,
  -7.649015435564350920e-05, 1.629394252065774062e-04,
  -1.069243661272286950e-04,-5.447182692264276757e-05,
   3.408481632770829213e-05,-3.658176179336351260e-05,
  -1.422422755184384620e-05, 1.405956437992893393e-05,
  -3.308852831093538998e-06, 9.436709857898794573e-06,
   3.377237277634921890e-05, 2.143424449462369614e-05,
  -2.143424449462375374e-05, 3.377237277634918502e-05,
   1.109277384357558684e-05, 2.787382945444140598e-05,
   2.495849233198046621e-02, 1.576401156160677983e-02,
   3.501074599073957097e-05, 3.569660579343522319e-05,
  -1.427133380257214479e-02, 2.257771315912135771e-02,
   1.781074840443324964e-04,-2.160502814795616845e-04,
   7.673381258796525719e-06, 9.970516145143716179e-05,
   5.413722336527297392e-05, 2.586814733023110117e-05,
  -1.290013610161428983e-06,-3.997919289937702515e-05,
   3.997919289937703193e-05,-1.290013610161360373e-06,
  -3.316054479160889719e-06, 9.434181612161015909e-06,
   1.388110133157335388e-05, 4.803451910681101822e-05,
  -3.842761528544879425e-05, 1.110488106525875459e-05,
   5.319819854400858871e-06,-8.467556714703625544e-06,
  -1.970962583557150580e-02, 3.200841685278689452e-02,
  -3.201532154917993700e-02,-1.971748427418201430e-02,
  -1.186450960927743558e-05, 3.819991376601999434e-05,
  -3.317411521102793087e-05,-2.234900624111608577e-05,
  -3.395227769027555541e-05, 7.243785501823213010e-05,
  -2.846362470275343721e-06,-9.586355965006100816e-06,
  -3.272641721046677730e-04,-2.121277012948718621e-04,
   3.040468887029833104e-04,-4.583181094720518512e-04,
   4.480148088430913240e-05,-2.219971420025229901e-05,
   4.713772529254042080e-07, 2.999629649615806508e-05,
   3.487935127457958675e-06,-1.099446874957887491e-04,
   1.599231903058977156e-04, 4.957136510489749398e-06,
   4.500093469652123296e-06, 1.948715368555383417e-05,
   6.205425751498155157e-06,-7.841727567484321128e-06,
  -9.682194258822696367e-06, 2.501022657718402300e-06,
  -3.215393242192304010e-06, 3.987055613228970434e-05,
  -3.987055613228971112e-05,-3.215393242192230742e-06,
   7.691666602015775309e-06,-1.846180556942996089e-05,
   2.769270835414492101e-05, 1.153749990302371040e-05,
   7.097125206519000495e-05, 1.089177734821055821e-04,
  -4.195467328548383492e-05, 2.719936377028530914e-05,
   2.270018316210455738e-06,-5.995704309623740304e-05,
   4.996420258019784039e-05, 1.891681930175300161e-06,
  -7.428056282634542553e-05, 1.964240259902065979e-04,
  -6.876941432347902726e-05,-1.306780982436142273e-05,
  -7.027190420614325486e-04, 4.782111959419839170e-04,
  -3.049251905087938517e-04,-4.334981293998576798e-04,
  -2.161268957118902149e-05,-2.080604838741411167e-05,
  -5.345899483645153100e-04, 1.486813232086540548e-03,
  -1.051446369283936264e-03,-3.858244840852225886e-04,
  -7.564270359905963539e-05,-2.604191606285550210e-05,
   1.955076384964565903e-05,-5.672537027552476289e-05,
  -2.588219252507961265e-04,-1.487652920210043913e-03,
   1.083713890717496325e-03,-1.885847370970057419e-04,
   1.080019183193094362e-03,-9.559181898255462995e-03,
   7.055131682194151939e-03, 7.969422481587475939e-04,
   1.185352659047035590e-04,-1.869199660018219878e-05,
   1.273266003890404522e-05, 7.898024669709317967e-05,
  -8.006883439168740665e-04,-1.220859605325548287e-03,
   9.448814922324143967e-04,-6.197571828035924359e-04,
   6.060603009641779852e-05,-5.221981535731528418e-05,
   3.290212816350402466e-05, 3.764903667177097151e-05,
  -6.945143756234286811e-05,-3.970513594642373513e-05,
   2.456868239920558265e-05,-4.354744361230594854e-05,
   5.024626467582640623e-06,-1.935854149623023710e-05,
   1.745674314273364328e-05,-9.760231495647119366e-06,
  -2.050205275429120496e-05,-3.434626373945586549e-05,
  -2.627993920127045673e-05,-1.446944351305634854e-05,
   9.205555614351499757e-06,-1.775549903075330680e-05,
  -2.880152816286324490e-05, 8.394758810340855325e-06,
  -3.798113155824431390e-05,-5.879994596558177681e-05,
   3.427497082509743420e-05,-4.924658744460086674e-05,
   6.229479077904917956e-06,-1.900509380187177585e-05,
   1.380071604083470550e-04,-4.072517939506525310e-04,
   2.747224981896162184e-04, 9.288460038378969501e-05,
   2.714380097334838474e-05,-1.277552616212934759e-05,
   1.277552616212934929e-05, 2.714380097334838135e-05,
   8.329375902528003356e-06,-2.882050480256003180e-05,
   3.842766342216640153e-05, 1.110471449037275252e-05,
   4.559743449170980486e-06,-1.947328271447170095e-05,
   2.920999569438854980e-05, 6.839309287771855614e-06,
   4.107806506756115023e-05,-2.850600937180110991e-05,
   3.602213066033248338e-05, 1.738982756354802615e-05,
   2.565073595163561409e-03, 3.584654117131549195e-04,
  -2.507316921090681585e-04, 1.883383555883432793e-03,
  -2.976018562054771356e-05, 3.785677195766322133e-06,
  -1.370298866111822905e-05,-2.668760202328536658e-05,
   2.883244030356441241e-05,-8.287966345334330987e-06,
   8.287966345334480065e-06, 2.883244030356437175e-05,
   9.774203653554283146e-04,-4.197707639818244567e-03,
  -1.204896736557535672e-05, 1.596315712581004653e-05,
   3.536771259239057490e-03, 7.717830393449774239e-04,
  -3.457849815800032408e-05, 2.010789559196009575e-05,
   1.233437415905163596e-05,-1.895992173351581289e-04,
  -8.640266233545094399e-06,-5.034461184025604586e-06,
  -4.462314881375497875e-06, 1.949583919454238087e-05,
  -1.949583919454238765e-05,-4.462314881375461453e-06,
  -9.750454529082991210e-06, 2.220053259785672710e-06,
  -7.569090262766327293e-02,-3.244086557737938664e-02,
   3.132080946651669834e-02,-7.301581605626386584e-02,
  -5.557955958442873897e-05, 5.754052968474426881e-05,
  -3.027660274695135898e-05,-5.180084290919692770e-05,
  -1.089612025003650303e-05, 1.677124215723881667e-05,
  -1.533038031856090921e-04,-4.580331788012777358e-05,
   2.393398192093547643e-04,-4.616453735724353039e-04,
   6.016069253559486315e-04, 3.169686220491897645e-04,
   7.357862341883191062e-06, 4.945565550832277949e-05,
  -5.902057151608273728e-05,-1.079685777969513640e-05,
  -1.677593564327787550e-06,-1.992951780231839919e-05,
   8.777165329941976363e-06, 1.797112597393008693e-05,
   1.478882044595749938e-04,-2.508144696230547058e-05,
   2.892553848655464769e-05, 1.877852848954434100e-04,
   2.774427585338114368e-05,-2.881414856232077280e-05,
   1.529757841001530092e-05, 1.288348147006211408e-05,
  -1.959164283720678110e-05, 4.020886834931359529e-06,
  -4.020886834931360376e-06,-1.959164283720678110e-05,
   1.588835525558848736e-05, 2.544720352557847950e-05,
  -7.743525645130533091e-06,-1.844011416947318808e-05,
  -1.844011416947317452e-05, 7.743525645130563585e-06,
  -1.995562653890473655e-05, 1.331528985700669343e-06,
  -1.331528985700635038e-06,-1.995562653890473994e-05,
  -1.529351444766030780e-07,-3.999970763445133518e-05,
   3.999970763445133518e-05,-1.529351444765344683e-07,
   1.908069144646124210e-04,-4.075447477179580517e-04,
   5.071667971601267295e-04, 2.374486046670706125e-04,
  -8.851408135106606764e-06,-4.653232642558139033e-06,
   2.118568482076953641e-04, 5.930156715890005166e-05,
  -2.314151624726890291e-05, 7.657982910517226692e-05,
   1.794247813001097007e-04,-2.888022642837272309e-04,
   1.194728788871654622e-04, 7.298103322379513233e-05,
   4.457962875515559566e-04, 1.671575804444790959e-03,
  -1.112317745518233338e-03, 2.919747129551372223e-04,
   2.438210520967637636e-03, 1.416873126092354574e-03,
  -9.796630833876316270e-04, 1.720656921947962947e-03,
  -1.053745169573968435e-05, 1.699888560347274303e-05,
  -4.389511672495655104e-03, 6.547730159676157257e-05,
  -4.513313729758844904e-05,-3.289690410953236780e-03,
  -1.876112227102419956e-05,-2.340983321452077141e-05,
  -2.382685055823397392e-03, 1.065322451070967527e-03,
  -8.202096829411568805e-04,-1.835035715186373933e-03,
  -1.638957136991443344e-05,-2.512731482491675176e-05,
  -2.169253222347595198e-04, 2.352517897346282933e-04,
  -1.596796298435487088e-04,-1.513354413646296861e-04,
   4.124784080438459216e-05, 2.825978819765190313e-05,
  -1.577770186665250964e-05, 2.551595821847633236e-05,
  -9.574683263771330852e-05,-1.154666360462870456e-04,
   8.467553310061062388e-05,-7.021434393432295919e-05,
   1.901642276664702869e-02,-1.382987189570465680e-01,
   1.114611125974514921e-01, 1.532711579320256493e-02,
   1.656992555066886478e-03,-2.080280568887560159e-04,
   1.630657188786106360e-04, 1.299811359900582535e-03,
   7.206281072434006014e-06,-3.299213080616422776e-04,
   3.999445201600828579e-05, 6.661891167009605086e-07,
  -1.825369300214828419e-05, 8.173291367822565424e-06,
  -2.967757268980629720e-05,-4.023980217696483317e-05,
   3.219095909613425350e-05,-2.374325488367194455e-05,
  -5.985612667402251944e-05, 5.307771754308365959e-05,
  -3.054147628605042588e-05,-3.958810713167049285e-05,
  -1.055740865617572798e-05,-1.698649824026441095e-05,
  -4.952337207385760056e-04, 6.887352062604390653e-05,
  -3.173899324211108960e-05,-2.277995529143488735e-04,
  -2.719541029306399554e-04,-4.665200594821093953e-04,
   2.423550289860416820e-04,-1.402285275012716127e-04,
  -1.405211054678233093e-04,-1.278820508050323881e-04,
   3.994308939885451006e-05,-4.477219683324815732e-05,
  -2.811138821401834814e-05,-1.047615638871195527e-05,
   2.990684141727607885e-05, 2.656277162575284702e-05,
  -6.285656313812030201e-06, 1.898658802167032419e-05,
   1.075819270312971640e-05,-2.800466549991852087e-05,
  -5.885638738207416711e-07, 2.999422598712014171e-05,
   7.629904628300224743e-06,-6.464097412867693784e-06,
   2.129501992504080031e-06,-9.770630545871702194e-06,
  -3.387516227868116468e-05,-1.869558059558274821e-04,
   1.476268407520753669e-04,-2.657660417663206838e-05,
   1.526711144380645500e-05, 5.802512652431181440e-05,
  -8.703768578954601456e-05, 2.290068235665174688e-05,
  -6.216612234428599547e-06, 1.900930646622208336e-05,
   5.692285414922015202e-06, 1.917284242763879192e-05,
  -4.793208371548528978e-05, 1.423078882886363300e-05,
   1.473237741694262502e-04,-1.496519480811255368e-04,
   8.888800779679957619e-05, 8.061589216721537607e-05,
  -1.629421213353153230e-05,-1.159735534281302978e-05,
   1.889676719020357066e-05,-2.330047617022549001e-05,
  -1.390329520785650576e-05, 2.658379924621750401e-05,
  -1.772253283081168628e-05,-9.268863471904308939e-06,
   1.679869218130743664e-05, 1.085375239249912628e-05,
   3.322500880906489873e-02, 9.329463523566608116e-03,
  -7.661579389922862186e-03, 2.728471735700975162e-02,
  -3.777554338371548151e-07,-3.399997901482179142e-04,
   4.599832695300728113e-04,-3.923232394902990023e-06,
   6.914903531727714994e-05, 1.088167793540850921e-05,
   1.777040023191477338e-05, 4.673556328533511582e-05,
  -3.678963744110618221e-05, 1.570103744826941450e-05,
   9.601791562095440081e-06, 2.842192109619040032e-05,
   1.637975876971103362e-01,-6.225214167919104202e-01,
   2.953973557572213226e-06,-3.989077638027573508e-05,
   5.785782781985704393e-01, 1.522306437507821020e-01,
  -1.439512153320181580e-04,-1.080650156361203989e-04,
   9.709158663931679125e-05,-1.143381992330648759e-04,
  -1.000538926147921654e-04,-4.570797055905718970e-05,
   1.825555776697646872e-04,-1.266914938368657361e-03,
  -2.988920633349649689e-05,-2.575916293995760815e-06,
  -3.720616082366599186e-05, 3.340211964476958578e-05,
  -2.930565767950917179e-05,-2.722459233802088289e-05,
   3.285268306684288494e-05, 6.181182099978590474e-05,
  -5.298153628318973753e-05, 2.815948886384569492e-05,
   3.353026146633782427e-05,-2.181104229510870805e-05,
   1.090515831265422345e-05, 1.676536674743348796e-05,
   7.436674617580049272e-04, 3.210275787567263965e-04,
  -3.745632220437817021e-04, 8.621498667239823948e-04,
   1.948201209373507184e-05,-2.281339967605793882e-05,
   1.974507120432110702e-05,-3.183105894608193857e-06,
   8.136021981815027507e-06,-5.814219320891040493e-06,
   5.956895782623435894e-05, 1.804204513448969330e-04,
  -2.483128939346889038e-04, 7.707598008316164455e-05,
   2.120467166942438306e-05, 2.122173177174546584e-05,
  -2.122173177174543196e-05, 2.120467166942441694e-05,
  -7.494898125759244002e-04,-1.322370984574641230e-03,
  -2.365290151821157691e-05, 1.845373267850665888e-05,
   1.707222115972730313e-05,-1.041821792214769465e-05,
   9.432186385584045456e-06,-3.321725453375547095e-06,
  -4.559116797654653076e-06,-1.947342943667969590e-05,
   2.993405085409771901e-03,-5.735889294141137754e-03,
   7.154347233959651269e-03, 3.733659820596126923e-03,
  -1.469242909805665374e-04,-8.551755796243142678e-05,
   1.056393363065333041e-04,-1.814947123877584374e-04,
   1.462848826211786059e-06,-1.994643008940825244e-05,
   1.907189255368390316e-06, 2.993931577615305828e-05,
   4.051122033088114596e-03, 1.217090905819291202e-03,
  -8.191828930929943115e-04, 2.719290236010822072e-03,
   2.960679217457494634e-03,-3.322179792141791588e-03,
   2.348802298770255158e-03, 2.098958732631865057e-03,
  -3.179058960858368254e-05,-2.427670513761312767e-05,
   2.427670513761318188e-05,-3.179058960858364188e-05,
  -1.893825502452782528e-03, 1.418412933409236333e-02,
  -1.057654804796336577e-02,-1.409088850684139197e-03,
  -9.997605570423205915e-05, 2.188215214344354037e-06,
   7.473236787646666893e-06,-9.972036267440950719e-05,
   1.295140095688976888e-03, 4.932809760424453245e-03,
  -3.849490941727858138e-03, 1.010850874043826234e-03,
   8.928514907787802595e-06,-4.503512134036166113e-06,
   1.022458984580874907e-03, 1.295020318315448678e-03,
  -1.032001733532632694e-03, 8.068905886089148584e-04,
  -1.748662294591102302e-05, 9.706596620213395947e-06,
   4.905931841179795130e-05,-1.095133931396969512e-04,
   1.003853461160325041e-04, 4.497535197376847899e-05,
   1.151712208482565752e-05, 4.865548169408274765e-05,
  -3.895988133967446317e-05, 9.062430468615226953e-06,
  -6.832107684265029698e-05, 3.636374986976187245e-04,
  -3.538868689589454684e-04,-6.606121387345364560e-05,
   8.999472741021270446e-05,-9.741859994435221829e-07,
   8.614194808423206514e-07, 7.999536209354906908e-05,
  -1.698156727048903811e-05,-1.056533828317179728e-05,
   1.998262993483635892e-05, 8.333671984077356715e-07,
   2.779378571015924030e-05,-1.129183226486065003e-05,
  -5.517011874334972095e-03, 6.900579529625851423e-04,
  -4.334651143438315066e-04,-3.352090093456154551e-03,
  -1.321111888290198372e-03, 5.976314739187569376e-04,
  -3.641374725076610363e-04,-7.901290408001293173e-04,
  -1.111237538238806260e-05, 1.662874358936644950e-05,
  -1.354853456607909529e-05, 3.763558437319341159e-05,
  -1.561050803673280239e-04, 1.689118228055989598e-04,
  -5.192020835578523897e-05,-4.694988779850115809e-05,
  -5.948671091672696879e-05, 7.831425432815946019e-06,
  -6.611790098269195785e-06, 1.887549288618523656e-05,
  -4.824262009630736074e-05,-3.567421486512858952e-05,
   1.154513374303080904e-05, 2.597435463815328961e-04,
  -9.990228794777058759e-05, 4.419599846222681230e-06,
  -1.171251466039458216e-04, 1.090032111132704332e-04,
  -5.431751091855968594e-05,-5.873336366676226706e-05,
  -1.999610483330371629e-05,-3.947043140476531068e-07,
   2.746591393921965911e-05,-4.178066025667114431e-05,
   5.396339367607952105e-04, 1.062789456856159584e-04,
  -5.108614256671892680e-05, 2.139864622765956048e-04,
   2.849994860440912729e-05,-9.367653363892057433e-06,
  -2.899954116013570330e-04, 1.631333858995834139e-06,
   1.664772185697317296e-04, 3.442870455427808829e-05,
  -4.020407941019570255e-06, 1.959174111680191620e-05,
   1.957385439356634058e-05,-4.106607380729713672e-06,
   1.613584438454322660e-05,-1.181670537831103188e-05,
  -6.828463770081944514e-07, 3.999417108561455111e-05,
  -8.816126057524378357e-04,-7.992866903548418323e-04,
   7.723094215071203261e-04,-8.520787272613588106e-04,
  -6.971421762825152381e-05,-7.169329020543544026e-05,
   1.075398623035688558e-04,-1.045714015193898382e-04,
   9.859338410763043685e-06, 1.671360554175088755e-06,
   7.922834136243114478e-06,-6.101532532862611368e-06,
  -1.641168958160423363e-05, 3.647816394882098931e-05,
  -1.420297684000843648e-03, 1.200980636322601311e-03,
  -9.218208587161188898e-04,-1.066933130255067743e-03,
   5.698694095729128453e-05,-1.877467870111754756e-05,
   1.195302263270625490e-05, 3.817230998959863982e-05,
   3.551069819992862199e-05,-1.841168958443484274e-05,
   1.380876718832607869e-05, 2.663302364994649021e-05,
  -2.471329976326476670e-05, 1.700743410426798263e-05,
  -1.700743410426793859e-05,-2.471329976326479719e-05,
  -2.948534308452976956e-05, 5.533041043365986126e-06,
  -1.207987178663290142e-05,-1.593978348719048773e-05,
  -1.351249987158374410e-01,-1.477158156884125079e-02,
   1.309299868289661578e-02,-1.197563955932611779e-01,
  -5.913739052152555139e-05,-9.275111342892106148e-05,
   7.168814050979727408e-05,-5.441333026242342277e-05,
   1.633962095480510630e-05,-1.153329038276995657e-05,
   1.153329038276992946e-05, 1.633962095480512324e-05,
  -2.421834066275684106e-05, 1.770513980579251662e-05,
   1.988593746230710640e-05, 2.246217912948810088e-05,
  -1.130257731029079898e-03, 3.470593243445419321e-03,
   3.158366594974449848e-06, 1.974904353258024391e-05,
  -3.459174526676903234e-03,-1.133009970825333895e-03,
   3.417627697646101248e-05, 3.649632984326261137e-05,
   2.044352300127828920e-05, 2.195591873040628878e-05,
  -2.195591873040628539e-05, 2.044352300127828920e-05,
  -1.898337484634898587e-05,-6.295353798080353159e-06,
  -2.195053794670883871e-04, 9.704322946506639973e-05,
  -1.212309065633076756e-04,-2.744140435433991437e-04,
  -1.764064361480793068e-05, 2.426535993665324213e-05,
  -2.426535993665320486e-05,-1.764064361480797811e-05,
  -1.486444768599135170e-05,-1.338088917039620429e-05,
  -2.528082233321934328e-05,-5.441396899837575637e-05,
   4.997988988181824131e-05, 1.417958885625076915e-06,
  -2.780315519850611356e-05, 1.126874265425306733e-05,
  -3.503101196610560733e-05, 6.060386291838635930e-05,
  -6.926155762101290849e-05,-4.003544224697798312e-05,
   9.950722872809662103e-06, 9.915212093256751872e-07,
   2.010464079491037844e-05,-5.296185451988134332e-04,
   1.896202156353471880e-04, 1.200724041586751734e-05,
   5.608696652602130489e-02, 1.843837807153779831e-02,
  -1.373059582342309182e-02, 4.176065538678477851e-02,
  -1.886493235900834218e-05, 5.695712709652796723e-05,
   1.274668929843114338e-05, 1.541174590788665371e-05,
   1.080568882832494068e-02,-9.795861092387868081e-04,
   7.595770382798143179e-04, 8.405750574631516009e-03,
   1.435254097741937968e-05, 5.825808585502528867e-05,
  -8.926094821376105888e-05, 1.151013136242450006e-05,
   8.957867165754026390e-03,-4.961271595136265526e-03,
   4.053136285292884521e-03, 7.288874141651933113e-03,
   7.905500300840992184e-05, 1.155435264276640216e-04,
  -7.531850151700483157e-05, 4.926584343369086683e-05,
  -1.720460944681226071e-05, 1.019810834334772239e-05,
  -1.541194680656642909e-05,-1.274644639229173190e-05,
  -9.970305714527972324e-05,-6.677799335024291020e-05,
   5.509524585087005095e-05,-8.345366309894484155e-05,
  -1.742087895381136283e-06, 2.994937611645301958e-05,
  -1.989738456346491720e-05,-2.023385166889424567e-06,
  -9.997547362955095781e-06, 2.214649531407159091e-07,
  -8.633267783419890874e-06, 5.046452950317106783e-06,
   1.475462055161225661e-04,-6.188794097232616610e-05,
   5.801625088558165256e-05, 1.383261169598179734e-04,
  -7.626446650576717602e-06,-6.468176828589891931e-06,
  -1.767857971703017431e-05, 2.423773543853900185e-05,
  -2.501321774672541793e-05, 1.656318018844511476e-05,
   1.013496320641713926e-05,-1.724188275115484084e-05,
  -2.348694049529589326e-03, 1.798730764349418254e-02,
  -1.230431357864950927e-02,-1.616158209539308999e-03,
  -8.680235695349399817e-05, 4.965229931552225589e-05,
  -2.482614965776113133e-05,-4.340117847674699908e-05,
  -2.376525896708339382e-05,-3.217471781115512048e-05,
  -6.914977591793467849e-05,-4.022820516129725442e-05,
   2.011410258064862382e-05,-3.457488795896733924e-05,
   5.426235924374240953e-05,-4.422212533679314056e-05,
   7.714355407919277346e-04, 2.461968157065209939e-03,
  -1.679394047845349713e-03, 5.265317009085125491e-04,
  -1.688252808616360967e-05, 2.479879524129946305e-05,
  -2.066541286087549836e-04, 4.552955865467577619e-04,
  -1.730194629051321994e-04,-7.851283625000171000e-05,
  -9.518582956334215717e-06,-6.934981311080357167e-05,
   3.962846463474489810e-05,-5.439190260762447582e-06,
  -1.731216570819428232e-04, 7.828723937655612493e-05,
  -4.533881500323290930e-05,-1.002217134861633813e-04,
   2.160109861066498819e-04, 2.360916217938127681e-04,
  -1.031232335602803640e-04, 9.468684544366160654e-05,
  -1.237266918323194338e-04, 8.480392519353248458e-05,
  -5.089102275396213725e-05,-7.423007344099632544e-05,
  -3.690748083813726212e-05,-1.542199267872121956e-05,
  -3.763914603827969165e-05, 4.672573900441869194e-05,
   3.686309946671851505e-05, 1.552777826048586077e-05,
  -2.803327152630772878e-05, 2.853306305906018039e-05,
  -5.528639506635951325e-06, 8.332715356092766282e-06,
  -7.661322134357495322e-04,-6.110985448649333598e-04,
   3.626522631547093238e-04,-4.653851480534885944e-04,
  -1.578563527022358064e-05, 3.579965197277637425e-03,
  -2.379976954484583178e-03,-1.047359166138043649e-05,
  -4.814894422207554952e-04, 5.217929829251690809e-04,
  -2.059475438440293250e-04,-1.896987326911057838e-04,
  -9.965787253395524167e-05, 8.264892135166145733e-06,
  -4.132446067583076255e-06,-4.982893626697762083e-05,
   3.263149063803392927e-04,-4.048685982809612448e-04,
   1.547281350902918445e-04, 1.267249155118298004e-04,
   1.510616809112420285e-05,-7.856082793353632481e-05,
   3.510313147227435253e-03,-1.786662898653057410e-03,
  -1.992804244902097568e-05,-1.695029247540631457e-06,
   1.311974838696880431e-03, 2.663934365233296478e-03,
   7.867082531814825915e-05, 7.688238578349011439e-05,
  -5.715798257665677249e-05, 6.951952982987300511e-05,
   1.127742365840558820e-04, 4.101184661635456100e-05,
  -4.308650786497795760e-05, 1.226521619866571648e-04,
   1.636918911170711063e-05, 1.149128573420613618e-05,
   1.442455145049076982e-05, 1.385396388952074190e-05,
  -7.768240644946788927e-06,-2.897679135587991243e-05,
   2.613730696231660576e-06,-2.988592330592408644e-05,
   7.806415029671762043e-05,-4.478826228434725496e-05,
   3.483531511004775655e-05, 6.071656134189153451e-05,
   1.198653186114419528e-05, 6.698927698176341747e-04,
  -2.298943034178520597e-04,-6.972033851077591172e-06,
   1.164893158005179269e-04, 2.881387346968825467e-05,
  -7.430845007998826722e-06, 3.930372173811405654e-05,
   4.802145143431810767e-04, 1.291107253562670185e-02,
  -1.041278970798146554e-02, 3.875699902666270968e-04,
   1.285325333324284275e-04,-5.549223256590215430e-05,
   2.959960770130844640e-05, 5.219064306874022596e-05,
   4.562814758549237472e-06, 2.965098179620980750e-05,
  -1.851952631650128711e-03,-7.551631943654051656e-04,
  -6.673512125996546517e-05, 2.112873849565337773e-05,
   7.481781757996121230e-04,-1.843998215090558333e-03,
  -4.985928752196437202e-05, 3.748526083954658272e-06,
  -1.245159175954409140e-05, 1.565112975646338960e-05,
  -9.774581651929740647e-06, 2.111291910124816335e-06,
  -1.861996496465914155e-04,-2.091164519388338447e-04,
   2.622990935622898775e-04,-2.163311940437650507e-04,
  -1.991601039768921875e-06, 4.996031950756912036e-05,
  -4.996031915996840153e-05,-1.991609759489674886e-06,
  -1.704968549975495752e-05, 1.045505735801796533e-05,
  -1.671837475572102483e-05,-4.712213859246278331e-05,
   6.830152605503144531e-06, 7.304041031205850338e-06,
   6.661598675702033876e-06,-7.458089774458665981e-06,
  -1.523871405427429706e-05,-2.584147042975811485e-05,
   5.515396319228963812e-05,-8.341486884353148824e-05,
   4.001876593073589746e-05, 2.997496244169410513e-05,
  -1.196940955530588968e-04,-8.562913624182412015e-06,
   3.057345644308779844e-06,-6.993320125384812314e-05,
   6.002936659825490635e-04,-6.893913802375341293e-03,
   5.329843217298326809e-03, 4.639733602471381212e-04,
   1.388926628274942505e-04, 1.757350883255808484e-05,
  -1.238645292470362670e-05, 9.922991375560145195e-05,
  -1.607475104272140798e-02,-2.760010831345643956e-02,
   2.238099688337830129e-02,-1.305446584530407968e-02,
   2.789039155422417334e-04,-1.105106596451495087e-04,
   8.333949456348316667e-05, 2.250656096472830017e-04,
  -4.173514760270352364e-05,-5.619766413811653561e-05,
  -5.669996726220426889e-06, 2.945931324937242540e-05,
   4.242129499766573259e-05, 4.243151812887467834e-05,
  -3.536350995812455642e-05, 3.534716627173422709e-05,
   2.061155712483463565e-04, 2.828716516177749523e-04,
  -1.944137433338826164e-04, 1.407241855649099581e-04,
   9.693949733575016640e-05, 1.144671737062293460e-04,
  -9.204049552577613937e-05, 7.699705957612656537e-05,
   4.524838469979261529e-05,-3.940283850256950178e-05,
   3.965712200161711839e-05, 4.502568905134995768e-05,
  -6.269784174371973743e-06, 2.933751534139854294e-05,
  -2.992451797013866028e-05,-2.126787308324078859e-06,
  -1.528502730397490424e-05, 3.696441451337680950e-05,
  -3.696441451337683661e-05,-1.528502730397483648e-05,
   3.876726968055904931e-05, 9.853872412143722102e-06,
  -1.801388068099347883e-05,-1.186402128403811051e-04,
   8.952939202455392168e-05,-9.191733444445723347e-06,
   2.525573306795177118e-05, 3.101850975144304894e-05,
   3.746138345358290453e-05, 1.402300787076813542e-05,
  -2.994928369304926063e-05, 1.743676080369761832e-06,
   1.833230957847290657e-05,-2.374713510129233753e-05,
  -3.854540750860264531e-05, 1.068885213649057805e-05,
  -2.580347926191041159e-03, 5.272447683932159589e-03,
  -3.940232246428454141e-03,-1.935631639596072226e-03,
  -6.605513187245892000e-05,-2.316720857833460032e-05,
   1.323840490190548420e-05,-3.774578964140510489e-05,
  -3.570026757817722652e-04,-4.183886823094702147e-04,
   2.053180519228480893e-04,-1.753410891793667726e-04,
   6.679333830544828033e-05, 2.094397187770110535e-05,
  -1.494804702100384560e-05, 4.771326744478791626e-05,
  -2.142187972234553498e-05,-1.787207404560572238e-04,
   1.290626622684904194e-04,-1.558297815469088569e-05,
   2.518657725791044475e-06, 6.399950440146082295e-04,
  -3.599973233880327450e-04, 1.388219525940364010e-06,
  -8.552528984020807325e-05, 6.917676486905413656e-05,
  -4.466698018709183411e-05,-5.389676132167817201e-05,
   9.551245714010811260e-06,-2.843894697963675024e-05,
  -6.959264034169659885e-05,-7.540849439636289621e-06,
   4.980575721336352260e-06,-4.975132023860306962e-05,
   2.436457343867705889e-05, 5.483035255359309200e-05,
  -3.635971508242012544e-05, 1.667246589815767836e-05,
  -3.969931386398357079e-05, 4.895352768588005554e-06,
   5.748131209394791144e-06, 1.915617361582374142e-05,
  -2.791160336494391807e-04, 3.781457916727424227e-04,
  -1.671154084913835294e-04,-1.271709095853215221e-04,
  -9.230866897975878449e-03,-7.838571063137284370e-03,
   5.793766051666836281e-03,-6.821640194158064101e-03,
  -3.023520631630119112e-04, 3.105315318917077193e-03,
  -2.279475481049762949e-03,-2.192978141545233375e-04,
  -3.338518721580737065e-04, 3.164536734761491579e-04,
  -1.649949639230863555e-04,-1.742890182427436578e-04,
  -4.998203652763070945e-05, 1.340158405036402183e-06,
  -9.424548358337043954e-07,-2.998519266041847040e-05,
   2.250937748816611095e-04,-1.087786399507001872e-04,
   6.004240670920166852e-05, 1.264709824290410596e-04,
  -1.133754864417281689e-06, 2.997856901033486900e-05,
   1.961278335339456020e-04,-2.400705581975451765e-04,
   1.319236637580830740e-04, 1.072200864607198703e-04,
   2.696523147951288536e-05,-1.779687508841265521e-04,
   1.285321504748607299e-04, 1.948040796050627831e-05,
   9.235497063445261804e-05,-5.975415800686505603e-05,
   4.347687527493288343e-05, 6.715475646838375715e-05,
   6.818793071549722820e-05,-9.874414466052429753e-05,
   6.582981853855000604e-05, 4.545805749459141487e-05,
  -1.465315616939052599e-03,-1.925941365346962777e-03,
   8.962099759580355424e-06,-4.436301150658029750e-06,
   1.630849209304656260e-03,-1.323000701628830296e-03,
   3.430873999260204991e-05,-8.320402850896120833e-05,
   2.990568382990955025e-05,-2.376988570752177227e-06,
  -5.779807337955718917e-05,-1.610536288356529129e-05,
   8.020827785023039113e-06,-5.972128736305207163e-06,
   1.348493233043204450e-04, 2.791337672234709376e-04,
  -1.800876983658048069e-05, 8.699667175994097292e-06,
   1.634343060112412593e-06,-7.998330402503927108e-05,
  -2.707962311837279479e-02,-1.100394982571665896e-02,
  -1.460398203639608268e-05, 3.723873935407348009e-05,
   1.866953357370899989e-04,-1.343311267503375598e-04,
  -1.378278050636873864e-05, 1.449258298279716499e-05,
  -2.204372627157032472e-05, 2.034881156392383386e-05,
  -1.773764917032709244e-05, 9.239902700266635266e-06,
  -2.004219949959372364e-05, 2.232286359807999766e-05,
   1.989088383238790320e-05, 2.086322210601620536e-06,
   9.945901193499126871e-05,-1.962343113344739809e-04,
   3.498283337543572257e-05, 1.939591114195208171e-05,
  -2.688516373643932831e-05,-1.331119719878147421e-05,
   1.086342819906282141e-06, 9.940817837463780167e-06,
   1.040738033092898814e-02,-6.033849073965345984e-03,
   3.970141073513951818e-03, 6.876160255287647009e-03,
  -2.879938230027175494e-05,-2.775960336753380544e-05,
   2.805098871328675129e-04,-2.093184254209502890e-04,
   4.323884093131235423e-02, 1.238914485947947425e-01,
  -9.498164819080434640e-02, 3.314885378045932113e-02,
  -1.046402380180527780e-04, 3.391785057348509268e-05,
  -2.926457456803865795e-05,-8.510925140871411997e-05,
   9.289682471279803587e-06,-1.771162893645857761e-05,
   4.657929657379564843e-04, 4.675862627035132181e-04,
  -4.662620940852425289e-04, 4.811441152287373318e-04,
   3.836434546546779056e-05,-1.132152803318709633e-05,
   5.330597492198095651e-06, 1.927653315241543831e-05,
   2.603444178534792682e-05,-1.490663747883237201e-05,
   6.483672626094861126e-05, 4.686362051488145657e-05,
   3.277121805834384352e-06, 1.972968506260869861e-05,
  -8.905709466988797501e-05,-1.299360954310277219e-05,
   8.662406362068631116e-06,-5.937139644659196301e-05,
  -1.816363014085100098e-06, 9.833657783402049518e-06,
   2.211598518909944341e-05, 2.027025404664514781e-05,
   9.171426677811442396e-06, 3.985590632958756076e-06,
  -1.641292871807247108e-06,-1.993254017201407069e-05,
  -5.938265119006326236e-06,-8.045931106863443667e-06,
   2.445585014671211767e-06, 9.696345390713742500e-06,
  -8.401197570773291700e-04,-1.292238126984702128e-04,
   8.588178017795499526e-05,-5.938217913090301477e-04,
  -4.036150210146641475e-04, 1.989847099938389533e-04,
  -1.223411146947231876e-04,-2.294180717712808449e-04,
   1.784398741508913110e-05, 9.032835276375895223e-06,
   4.756306577851952128e-03,-3.516984003002405351e-02,
   2.815485335014369581e-02, 3.798991028141858461e-03,
  -3.498513286585522319e-04,-1.020038410284871846e-05,
   6.227536452691133752e-06,-2.799307374864903994e-04,
  -5.890730810486339155e-06,-8.080797641222491848e-06,
  -8.854811655576992515e-05, 3.386136899985376682e-04,
  -2.323802603542554288e-04,-5.999512144906843716e-05,
  -1.981103798611282690e-03,-4.040448952669485269e-03,
   3.303842059027686361e-03,-1.620810799877548617e-03,
  -1.929380674228127162e-05,-4.612752997279934326e-05,
  -2.742857186793003503e-04,-5.627916602597898344e-05,
   5.379990225199446867e-05,-2.441425209128386155e-04,
   1.784572338820437022e-06, 7.998009315803224922e-05,
  -6.992256197390232168e-05, 3.291705789676395517e-06,
  -2.035847883940895427e-05,-9.790573190240363832e-05,
   9.790592732526030048e-05,-2.035753901091313811e-05,
   6.658606877484535390e-06,-7.460760983379353259e-06,
  -3.606749961623869233e-05,-3.462853550805494724e-05,
   4.095139054658789593e-05,-4.385183704590757338e-05,
  -7.712758254088840685e-05,-2.124467018803649773e-05,
   3.949140517219236533e-05,-6.358373811418949218e-06,
  -9.881353053982341181e-06, 1.535858659692970832e-06,
   8.348170697280927658e-06,-5.505274380906012979e-06,
  -1.280973505000988935e-06, 1.995893551468828998e-05,
  -2.990212986095695821e-05,-2.421286802191403391e-06,
  -2.922961060633799769e-05,-6.754988068224338409e-06,
   7.021068644617305002e-05, 9.731628593795168939e-05,
  -7.143262663011379517e-05, 5.474833196292613343e-05,
   1.605940630088725432e-07,-9.998710394192159473e-06,
   1.439874242418069800e-05, 2.631874268657412332e-05,
   7.315603142622463824e-06, 2.909436286739498897e-05,
  -2.909438329629939314e-05, 7.315521895805852748e-06,
   3.164660945582865366e-05, 2.446409838825573172e-05,
  -2.774392868070218893e-05, 4.159656742280678593e-05,
  -1.640481408630762748e-04,-1.460817650317577454e-03,
   1.300142240859351785e-03,-1.604062141353102954e-04,
   1.119053445247406050e-05,-2.783472541032138561e-05,
   2.000933365934630119e-05, 2.235232798857763809e-05,
  -1.782465145053495939e-05, 3.580896257456982245e-05,
  -3.580750340097047641e-05,-1.782758256717628976e-05,
  -3.816994022525170679e-05,-1.196058791200132103e-05,
  -1.650075914343748169e-05,-5.768643642738095875e-05,
   6.746245774000026721e-05,-1.867663769736610277e-05,
  -1.617588650840026476e-05, 1.176183215606116251e-05,
   4.132319022390843350e-05,-1.126605252505005869e-04,
   6.547157759532460698e-05, 2.476837756453556224e-05,
   1.446763702740591506e-05, 1.380896371358956736e-05,
  -1.380896371358959616e-05, 1.446763702740588796e-05,
  -8.239374406151884822e-06,-5.666807689982897819e-06,
  -1.029077241010424413e-04,-3.885872257735357565e-05,
   2.875841734222673064e-05,-6.381969470289177695e-05,
   1.883413046143166586e-05,-6.728709368205157040e-06,
   1.203334686018989170e-04, 4.919203527234673566e-05,
  -2.612083927690548799e-05, 6.494383539236092359e-05,
  -9.318216896020110554e-06, 3.629164349919323901e-06,
   2.885831688435662153e-04, 5.487437969218474966e-04,
  -3.894926518682794250e-04, 2.046838394710615309e-04,
   9.056791421819903703e-06, 4.239637855011844723e-06,
   1.080222961071416934e-03,-1.973732087790564058e-03,
   1.729313414612874966e-03, 9.435969023051944248e-04,
  -1.736928943260087805e-05,-9.915028220158503820e-06,
   1.080360246041443821e-05,-1.683098849970871943e-05,
  -9.780511928910630578e-06,-1.744538868608082528e-05,
  -3.853028179307462501e-05,-1.074324834238985552e-05,
   6.715941255561318342e-06,-2.923860689314471410e-05,
  -8.294082240574439830e-06,-5.586429967930117101e-06,
  -9.661847740197811348e-06,-2.578506979869254405e-06,
  -1.169582340038559983e-03, 1.659209796821946997e-03,
   7.766264161123539320e-06,-6.299614351660592387e-06,
  -1.578000314885068299e-03,-1.111222302792121705e-03,
  -1.400896747379075347e-04, 9.630619415088145698e-05,
  -8.497393942168528637e-05,-1.236099899650499603e-04,
   3.069246856890592745e-04,-2.066330983039071814e-04,
   3.909198823135791339e-05, 5.806734414556406808e-05,
  -2.999588169485846716e-05,-4.970727794344771983e-07,
  -2.034068902910063327e-05, 2.205122150406696300e-05,
   1.883644336707952460e-05, 3.528722716903109338e-05,
  -2.450506764054001966e-05, 1.276695016827924904e-04,
   6.684022714840709738e-06, 7.437999754469843604e-06,
   1.963559207535112971e-05,-4.598307866868428864e-05,
  -6.877144520568307935e-05, 8.585154817661548447e-05,
  -3.951491767340815057e-05,-3.063611073984059269e-05,
   1.382174618822198404e-05, 1.445542570484768323e-05,
   1.153978903472211662e-06, 1.996668056263587037e-05,
   1.889816222280345443e-04, 1.964552010155094089e-05,
   3.805676753621561772e-05,-1.231594270425311294e-05,
  -2.461247547413575228e-05, 3.153135028880092922e-05,
   8.415833120026150645e-04, 1.055574501851342262e-03,
  -6.750443625772761152e-04, 5.328368498449023152e-04,
   2.852612632993567287e-05,-5.278503686281322741e-05,
   3.133568359364145308e-04, 3.229667062901669743e-04,
   1.428514007887737303e-01,-7.404246952043894159e-02,
   5.346048313031162569e-02, 1.031379932104249664e-01,
  -6.324234039157110919e-06,-2.932582588466975314e-05,
   1.229971876629619432e-03, 8.317613853268101127e-06,
   7.948498864343507596e-05, 9.767712816111829167e-04,
   2.728328069265393400e-05, 5.343802573679024785e-05,
  -2.778669463952459630e-05,-2.877324453393839026e-05,
   9.994530057633579649e-06, 3.307097323317187571e-07,
  -9.972606127470355617e-06, 7.396803541670692851e-07,
   1.707097139988117835e-05, 2.466945348937505013e-05,
  -3.989089867590651743e-05, 2.952321599785499590e-06,
   2.541730725457632545e-05, 5.435034951061917661e-05,
  -4.917128945203417346e-05, 3.438290699787139085e-05,
   1.386099595770893988e-05, 1.441779425086849035e-05,
   3.830038263696502316e-05, 1.153606041341967332e-05,
   5.544847903753757322e-06,-1.921600014894456754e-05,
  -1.996700572508937883e-05, 1.148338963132433252e-06,
   1.984546994669380047e-05,-2.481395291942275492e-06,
  -7.377564652052564736e-06,-6.750669581958854948e-06,
   2.923578965683755915e-05,-6.728194642038086898e-06,
  -8.758631937118950959e-06, 2.869296719738270631e-05,
  -1.912864479825514771e-05,-5.839087958079269864e-06,
  -3.682296037285229587e-05, 1.454100051213098215e-04,
  -7.765918967093102991e-05,-1.921068087430427161e-05,
  -7.621534923016904945e-05, 1.519579564936412715e-04,
  -7.417153866394026731e-05,-5.097629696460517681e-05,
  -1.275356086129818441e-02,-1.487375324914029040e-03,
   1.183213823886935254e-03,-1.014120826366182379e-02,
  -4.389426535489396569e-05, 2.359518880385451834e-04,
  -1.574274142097753884e-04,-2.857637582381317680e-05,
  -6.257786710555980798e-03, 1.865745289472538204e-03,
  -1.522878672580954551e-03,-5.139108925543227867e-03,
   5.716506268923650864e-08, 9.999836606445514314e-06,
  -5.880913882910198114e-05, 1.189475473389049001e-05,
  -9.885950704949009876e-03, 8.671244354723155190e-03,
  -7.371598800181278048e-03,-8.392164865466235704e-03,
  -5.216321707183582961e-06,-8.531704861700582370e-06,
  -1.335048887608290661e-04, 5.335507892196943028e-04,
  -4.729427880706604456e-04,-1.281605212690332474e-04,
  -4.547416787470485853e-05,-2.078701652722585934e-05,
   6.498422776303369023e-06,-1.891482226774604474e-05,
  -6.518636641324900638e-06,-7.583361809802855046e-06,
   5.225389382803375982e-05,-2.948780391634099534e-05,
   1.289879541857341014e-05, 2.708544030932097838e-05,
  -6.206173484238355843e-05, 1.254923944641812600e-04,
  -1.075098511886652503e-04,-5.330695918349737306e-05,
  -1.791910297278770324e-06, 6.997706093775662875e-05,
  -5.998033794664855539e-05,-1.535923111953136385e-06,
  -7.471833963121867541e-06,-6.646179145007948605e-06,
   9.545936038401756218e-06, 2.979111470009573045e-06,
  -1.999997049542039871e-05,-3.435378164819648007e-08,
   3.435378164823568181e-08,-1.999997049542039871e-05,
   3.433854382181005530e-05,-3.634369832856352141e-05,
   3.634368634214831087e-05, 3.433855650815191405e-05,
   1.987558520594779972e-05,-2.227355544386455543e-06,
   1.839253405583242423e-05, 7.855869843947555867e-06,
  -1.722322543247883345e-04,-8.022499965846949721e-05,
   7.601143087263540995e-05,-1.631632997236038152e-04,
   1.047054686680480531e-05, 1.704017747296207309e-05,
   2.741751358033253823e-04,-7.302246194885708133e-04,
   6.646387463322141849e-04, 2.497105061344890220e-04,
  -2.110225683453145502e-04,-1.143218074076291640e-04,
   1.047963743296561164e-04,-1.934366044143625630e-04,
  -1.184396659076095127e-04, 1.075734425390107346e-04,
  -1.008579508845993587e-04,-1.110300578373250299e-04,
  -7.636953244139210999e-05,-1.405976333893396572e-04,
   1.318133052013296697e-04,-7.159086933332431846e-05,
  -3.951350811358683539e-03,-1.093995779505147229e-03,
   1.006374298228925046e-03,-3.633195669361098321e-03,
   1.342179994623580253e-05,-2.683011901209580104e-05,
   1.714037817238714176e-05, 1.030569920517547880e-05,
  -9.207789090762634032e-04,-1.308764937643885386e-02,
   1.188062140637798775e-02,-8.360233240245884935e-04,
  -1.050501828031643486e-04,-7.657975641787945025e-05,
   7.068902284854812707e-05,-9.696938717305292202e-05,
  -5.594774717621954133e-06,-2.947369158858554366e-05,
   4.172803525260463888e-05, 4.311346743138836030e-05,
  -3.592943104141758015e-05, 3.477176994402239379e-05,
  -3.035264733021884702e-03,-1.696113217730094277e-04,
   1.557135858495977342e-04,-2.785651320460236571e-03,
   1.000403252106406900e-03, 4.847854508251554957e-03,
  -4.475698720715743338e-03, 9.235913389500026958e-04,
   1.705057830634873386e-04,-1.045360126554815381e-04,
   9.931144541669229746e-05, 1.619791246094611794e-04,
  -4.620511869076057547e-07,-1.999466200516221136e-05,
   4.537783484126023219e-03, 4.398968180288769653e-03,
  -4.073272213476800650e-03, 4.198922894614499565e-03,
  -3.874829523428487067e-05, 3.160015215844215941e-05,
  -2.528012172675378377e-05,-3.099863618742784911e-05,
   2.481350156354104690e-05, 1.686090567425563777e-05,
  -2.137539652559194148e-01,-3.906650032155058461e-01,
   3.597790410391037419e-01,-1.968483013108898450e-01,
  -2.386264848035649869e-03,-5.092544305446892018e-04,
   4.695982202759647851e-04,-2.200449388537179148e-03,
  -4.730899003727961053e-05, 1.618207222986533012e-05,
  -5.308712140135733899e-04,-7.513825617698049195e-04,
  -1.564835891160682509e-05, 1.245507380040500988e-05,
  -4.505381263314431166e-03,-1.626542244202485409e-03,
   1.500893938048492721e-03,-4.157369046251402182e-03,
   8.091943618511102240e-04,-6.846929857595842944e-04,
   6.265620358747807893e-04, 7.404863369438021217e-04,
  -1.205773595784005474e-05, 1.595653482341987279e-05,
  -3.161589612375147873e-05,-3.873545033031314087e-05,
   3.098650612801100710e-05,-2.529498839649341353e-05,
  -4.477391012487307912e-06, 8.941642450987284354e-06,
   6.954955735405152326e-05,-7.928371324269310665e-06,
   5.668394001237710862e-06, 4.967765402519257715e-05,
  -3.695960955869902442e-05, 1.529664215664745783e-05,
  -1.529664215664739346e-05,-3.695960955869904475e-05,
  -2.635817114754907009e-04,-3.891332437297681957e-04,
   1.487065582834653241e-04,-1.014216915826507697e-04,
  -9.871020213826019299e-06,-1.600924713482228948e-06,
   1.703700601943833491e-05,-1.047570646274617956e-05,
   1.047570646274614906e-05, 1.703700601943835185e-05,
   9.124837308825948911e-07,-1.997917349243643378e-05,
   1.997917349243643378e-05, 9.124837308825937264e-07,
   1.920017928290566246e-05,-5.599385279142722281e-06,
   5.599385279142723975e-06, 1.920017928290566246e-05,
  -1.296492114134046710e-05, 1.522861844681989102e-05,
  -6.488525855308167619e-06,-2.928991348954444127e-05,
  -2.342572499351275770e-05,-1.874127553098538942e-05,
  -5.781718227663950986e-03,-3.483422790288084447e-03,
   3.224766368994064474e-03,-5.353819371757403620e-03,
  -2.442392291821102849e-05, 5.480394136634048698e-05,
  -4.566995113861704425e-05,-2.035326909850926664e-05,
   1.576946232146032807e-05,-1.230138439737752144e-05,
   1.230138439737749433e-05, 1.576946232146034840e-05,
   8.104599673354380158e-04,-2.562316166023245853e-04,
   2.381370538554914644e-04, 7.532534391431789126e-04,
   4.118374074487486658e-03, 1.980882374748520192e-03,
  -1.851058557453657280e-03, 3.847919206126551150e-03,
   6.879312287230238999e-03, 1.742090590224179558e-02,
  -1.632336152888409081e-02, 6.445957523700165254e-03,
   3.346946496948669338e-04,-6.934547508422090776e-04,
   6.482987186215259526e-04, 3.132231974705698501e-04,
  -3.549606422870794415e-06, 1.968248699333279136e-05,
   2.877746884502498719e-05, 8.476867751334588719e-06,
  -1.538103452289609982e-04,-2.339708907119597667e-04,
   2.172587590149193152e-04,-1.428237782419202460e-04,
  -5.589826216645106365e-05,-4.213530926397365828e-05,
   3.611597100675927394e-05,-4.791280244609913625e-05,
  -9.623320303588557776e-06, 3.882514270848905040e-05,
  -3.882012724103268319e-05,-9.643532599106640032e-06,
  -3.799597829750803727e-05,-3.250085588435015879e-05,
   1.631625415531064911e-05, 4.726288025860578230e-05,
  -5.671545631032693470e-05, 1.957950498637278300e-05,
   6.434412166384577574e-06, 7.654955262644070409e-06,
   4.094172663563505773e-05,-2.870148114806848875e-05,
  -4.779951993924469335e-06,-1.942040316099996649e-05,
   6.372850974330165647e-06, 8.977408741089480454e-05,
  -1.187319553323263748e-04,-5.062634914577214843e-04,
   2.433658078432531196e-04,-5.721086935889722446e-05,
  -2.471254561721649052e-05, 3.145298219751180264e-05,
  -3.678795040256883964e-06, 9.298734701655992288e-06,
   1.154938392422732547e-05, 2.768775416986360465e-05,
   8.996763573908669721e-06,-4.365575013121423935e-06,
  -1.881222441426848139e-05, 6.789713733818307655e-06,
   1.216836631008033283e-05, 1.695639432820070453e-04,
  -3.964878748620363042e-05, 5.289012277719022610e-06,
   3.981218024206586515e-05,-3.871731443845322313e-06,
  -7.947481820934335200e-06,-1.835313413850392917e-05,
   7.717866274809436642e-07, 9.970172786950164313e-06,
  -2.771762832311443930e-04, 3.417210968233720366e-04,
  -2.055479954570073407e-04,-1.750714755852765688e-04,
   6.363430288798957240e-05, 2.916634183368905896e-05,
  -2.811046221161250650e-04, 3.641156291962081349e-04,
   8.214011827562369555e-03, 1.239543906832934507e-02,
  -8.232565575102107278e-03, 5.444425043256975391e-03,
  -9.107455341962930918e-06, 4.129680035323668368e-06,
  -4.967158597224215211e-02, 3.690349505131128305e-02,
  -2.910465298868496892e-02,-3.920826538382220922e-02,
  -2.342957270879298000e-04,-4.529961503901974175e-04,
   3.070962778251065911e-04,-1.459173606736530995e-04,
  -1.018786429642846677e-04, 9.602469530155149685e-05,
  -1.374175388304527728e-05,-1.453148995174996317e-05,
  -1.183924706074439427e-06,-9.929668790566308924e-06,
  -1.601022599707564153e-05, 1.198635322033200330e-05,
   1.473174266453130617e-06, 2.996380746134676937e-05,
   9.627141098120592247e-04, 5.111570627202311748e-04,
  -4.440948824138773402e-04, 8.398093446811630150e-04,
   6.125196418420474011e-05, 3.388505398515543525e-05,
  -2.565643098330247542e-05, 6.512869988875131480e-05,
   1.634878306268334704e-05,-1.152029914408988535e-05,
   3.208498637531403374e-06,-1.974096088069066552e-05,
  -1.420987031931731009e-05,-3.739090244308347025e-05,
  -1.477314693307058151e-05, 3.717195353615286238e-05,
   2.097739652621892557e-04, 9.431269001665583407e-05,
   3.717407035215561308e-05, 1.476781952263046501e-05,
  -1.201737535341709997e-06,-9.927528740635850580e-06,
  -5.100289638840814488e-03,-8.262635511744000419e-03,
   6.092680587131415158e-03,-3.760963076552599309e-03,
  -1.148962110572643362e-04, 3.462456764617529624e-05,
  -2.292529814565234672e-05,-7.664483482226933065e-05,
   8.224354596879067674e-05, 3.655132208935014157e-05,
  -3.099319106446186565e-05, 6.276481584169399039e-05,
  -3.454163792533459327e-05,-3.615072958371777192e-05,
   1.447701676273677305e-05,-1.379912988747618608e-05,
  -6.145638865289770100e-04, 2.257855449176142046e-03,
  -1.755180305407057564e-03,-4.813959861810112781e-04,
   9.983197211842174075e-06,-5.794596012377995341e-07,
  -3.769184596096148697e-06, 1.964162028653826595e-05,
   4.180302372928480304e-04, 3.384279941244353312e-03,
  -2.761564829820859369e-03, 3.196242961611144733e-04,
   4.995476912585265680e-05, 2.126274108095772712e-06,
   2.431737006247674691e-06, 6.995774907136767247e-05,
   2.411993533096024652e-03, 4.092039491048803622e-03,
  -3.495416420623370657e-03, 2.065348408002026966e-03,
   5.341055395346364087e-03, 3.507880736832638419e-03,
  -3.056737204566179443e-03, 4.668271378382038254e-03,
  -6.179197631613438839e-05, 6.543509504040081462e-05,
  -3.083721689047722026e-05,-2.547677480470530003e-05,
  -1.494937932621749361e-03, 1.267580600044277209e-03,
  -7.345009730641084845e-07,-6.999614638192995931e-05,
  -1.203785398342042696e-03,-1.417921265352378463e-03,
  -1.313288823197183759e-06, 1.199928134200830659e-04,
  -1.099934030536097904e-04,-1.204692776663331758e-06,
  -9.333472675043908242e-07,-9.956347868482804832e-06,
  -2.952273164218983920e-05, 5.329945251430155865e-06,
   1.582689115333709500e-06,-3.996867642497315011e-05,
   3.996894269640064422e-05, 1.575950421758872559e-06,
  -5.857849518114186633e-05,-1.298306213159820707e-05,
   1.483293729114473058e-05,-6.841040835513969155e-05,
  -1.940413419522499981e-05, 4.845572838550656724e-06,
   1.564482194117773587e-05,-1.245951629995497696e-05,
  -2.264830365971585242e-05, 4.457638771072978782e-05,
  -3.564690682855313687e-05,-1.814657084841243321e-05,
   9.455889619841984905e-05, 8.921107078012492197e-05,
  -8.921095525457300155e-05, 9.455900519023332119e-05,
   8.020129096539437347e-06,-5.973066990654091061e-06,
   3.647756382262463916e-05,-3.419630590526331502e-05,
   3.419440226446103802e-05, 3.647934831896290707e-05,
   9.672924555194865187e-04, 3.539001349181467330e-04,
  -3.657211614021297838e-04, 1.005558567216588081e-03,
   2.368139429229629468e-05,-4.403625284209359918e-05,
   4.403623217616172244e-05, 2.368143272116742662e-05,
  -9.857348938877826737e-06,-1.683054335784854457e-06,
   1.919998044676334210e-04,-5.600067039233139573e-05,
   6.690601557551159660e-05, 1.884770147254285230e-04,
   5.914934771745909529e-03,-4.224294568222846887e-04,
   3.969013582012256933e-04, 5.826497173418864264e-03,
   5.698867401074219136e-06,-8.217232523482196583e-06,
   1.644970945667401950e-05, 1.137572234150471118e-05,
  -6.932654519268607281e-06, 7.206823247205703985e-06,
  -3.557192921678751700e-06,-9.345928446011054434e-06,
  -3.188828470151842100e-06,-1.974414781619984494e-05,
  -2.061047527413618273e-05,-2.179927312949266830e-05,
   2.179920837966742598e-05,-2.061054375847074955e-05,
   1.996756820605834204e-02,-8.393558240484664049e-03,
   8.353238802094421073e-03, 1.969150836058995713e-02,
   2.774835680572115460e-05, 1.140301252224115391e-05,
   3.974811546708649404e-05,-4.481887639729479146e-06,
  -1.656787523723655012e-05, 2.501010815896972546e-05,
   1.091482797055834891e-04,-4.986635175458207944e-05,
   5.402188106746370764e-05, 1.182439696810488623e-04,
   4.192837284263781932e-04, 1.334209694046447801e-04,
  -1.561341046262955487e-04, 4.749969909089372510e-04,
  -2.286495153831381025e-05,-6.616036571203760179e-05,
   8.505630073697275305e-05,-2.941811865061477326e-05,
  -1.364368377735138594e-06, 9.906487719158409521e-06,
  -4.478343224452193257e-07, 2.999665722075778502e-05,
   3.224971160135281696e-05,-1.259363176435994067e-04,
   6.584025923449528619e-05, 2.377099627559721843e-05,
  -6.271837508199738770e-06,-7.788713261556038376e-06,
  -3.562673195522392391e-05,-6.025558870503736048e-05,
  -1.083111873088249177e-05,-1.681329435409748934e-05,
  -3.562332193879086807e-04,-4.058298823454553465e-04,
   2.398527292673404516e-04,-2.118269771842290700e-04,
  -6.657199862589395281e-06,-7.462016482797377495e-06,
  -2.973626949939350250e-05, 3.969165688081025571e-06,
  -9.827495526292093811e-06,-1.741896471322876730e-05,
  -1.447418758381610723e-04, 3.936736438790838766e-05,
   1.250918476894303337e-05, 4.840991940105296074e-05,
  -1.592214742554861728e-04,-8.395547710488910275e-05,
   3.913963272019808600e-05,-6.977169304616306759e-05,
  -9.135453003472693422e-06, 3.894282345209887418e-05,
  -3.736557884486678719e-04,-2.127941534883051372e-04,
  -5.749272912476951705e-06,-1.915583099157691999e-05,
  -3.078348633321955491e-03, 3.129835409686082016e-03,
  -1.899419497185137959e-03,-1.847892197535602309e-03,
   1.664704686415964939e-05, 1.108493710863856955e-05,
  -3.356780864357354621e-02,-3.235160927787718299e-02,
   2.421388853184563289e-02,-2.511970744589503424e-02,
   2.141635524771284610e-04,-2.241293661936700273e-04,
   1.255082422102849556e-04, 1.290258932822572785e-04,
  -9.530534261117343687e-05,-7.291701906802587868e-05,
  -4.129033335515502992e-05, 3.274066406953594259e-04,
  -2.766217773746482752e-04,-4.336349019729069564e-05,
   5.608895544562077560e-05, 4.188113032165161710e-05,
  -4.188532005492831632e-05, 5.608582676484513241e-05,
  -6.863199833036533041e-05,-1.377130368486333240e-05,
   2.216730968339003242e-05,-6.639736727763143889e-05,
   7.742936176842613592e-05,-2.011700614242065889e-05,
  -1.290449128872306588e-06, 5.998612123688106017e-05,
  -1.411164776368460957e-05,-2.647378698625671252e-05,
   2.647408745980913740e-05,-1.411108405369256712e-05,
   4.150995936406995329e-06, 9.097759764685624576e-06,
   1.856018743480484788e-05, 7.451136986052018650e-06,
  -1.725166758646435138e-05, 1.011829854699569886e-05,
   3.053306873333952969e-05,-5.165008919377742677e-05,
   3.515443524473564092e-05, 1.908312559890776964e-05,
  -8.255324815800685307e-06, 5.643546064809376050e-06,
   4.892916055133529878e-04, 2.037000853563035593e-04,
  -1.210339181884555703e-04, 2.962275994028075888e-04,
  -2.012970265591087609e-05, 3.456580783063828519e-05,
  -6.838211064586162402e-02,-1.218309116916439228e-01,
   9.815505753150054191e-02,-5.509390420897593982e-02,
  -1.627805452927756896e-03, 4.155110196115872293e-04,
  -3.265899129687188131e-04,-1.278960135714590817e-03,
  -1.931080635784016529e-04,-2.675990952544496024e-04,
   3.255685088237265582e-05,-2.323900730717538845e-05,
   4.683274519645969639e-05,-1.425015578067955011e-04,
   1.045011423916499790e-04, 3.434401314407065228e-05,
   1.887966520716673159e-03, 8.764939619289637549e-05,
  -7.428525736820182129e-05, 1.508171641603746685e-03,
   3.526373961456926537e-06,-2.979202387693656958e-05,
   5.956964928614514497e-05, 7.173345378947511030e-06,
   2.008040571502909665e-03,-5.795455661104368435e-04,
   4.759646323385405232e-04, 1.684030186416751382e-03,
   5.647163969980257640e-06, 1.918618094087921522e-05,
   2.616358429307922596e-03,-2.783355631138317333e-03,
   2.382849923956540435e-03, 2.239403099019984539e-03,
   3.362281311640900671e-05, 3.700684312581978215e-05,
  -5.943689842373616437e-03, 1.918017077759383987e-02,
  -1.797735933032722222e-02,-5.568388591710964584e-03,
   1.205448872397581200e-04, 4.867165664279361509e-05,
  -3.305744338048735299e-05, 8.370905230108553513e-05,
  -7.366022373981537568e-06, 3.931592189413855506e-05,
   1.619853494646134785e-05, 1.173062085263480356e-05,
  -8.150810357617108376e-05,-2.468935581407829226e-04,
   2.412479061847769453e-04,-6.557017432843277658e-05,
   5.638063085544677009e-06, 1.918885730426432882e-05,
  -3.691880603067459199e-06, 9.293547095307273369e-06,
  -5.861242045582601971e-05, 3.826988591973415436e-05,
  -3.827207506963968857e-05,-5.861099103294418143e-05,
   1.941651288545295128e-05,-4.795730118453246352e-06,
  -1.064722087470269982e-05, 2.804704418731669252e-05,
   4.852278608031161935e-06, 8.743877418516522677e-06,
   8.064403412744977672e-06, 5.913154623084631953e-06,
   2.491802943199602673e-06,-9.684571136207417090e-06,
   2.546755072105725369e-05,-1.585572011200930189e-05,
   8.037398361360919465e-07, 1.998384353110802257e-05,
   3.669324287185056320e-05,-1.592500949913023284e-05,
   1.592474052318379081e-05, 3.669335960728137394e-05,
   1.428958381021524094e-04,-1.538856050872967635e-04,
   1.758698045108511056e-04, 1.633089460541430949e-04,
   3.437195389273570039e-06,-3.985204747382443616e-05,
   1.992532862591565068e-05, 1.726638106050726335e-06,
   3.331898480247796413e-04,-9.746201953444348989e-04,
   1.031412155684448620e-03, 3.525464013521604589e-04,
  -2.719932963416533608e-04,-3.067966695833773509e-03,
   3.237621979236963207e-03,-2.833794621381882845e-04,
   1.664526611082492653e-04, 1.865301895404128157e-04,
  -1.836156695248139363e-04, 1.840795640611806274e-04,
   4.231889938490887072e-05,-2.662913357302410682e-05,
   2.662913357302410682e-05, 4.231889938490887072e-05,
  -6.677019825897059987e-07, 2.999256864729071365e-05,
  -1.699375945236066921e-04,-4.605862300399586373e-06,
   2.447830655948510584e-03, 1.379936621660097758e-03,
   7.162635942895645839e-06, 3.935348328102023820e-05,
   1.122333810071536539e-05, 2.782151473009747677e-05,
  -7.993090686352882627e-05, 3.324173276753492471e-06,
  -1.014870976246460474e-05,-1.723379500160239378e-05,
   1.407182468390146536e-06, 9.900496831000726283e-06,
  -1.476049134491340085e-05, 1.349547684436295454e-05,
   1.533817407572186608e-05,-1.283512430881967360e-05,
  -5.202766317839939127e-05,-1.191348910445425409e-04,
  -3.889888834081590535e-05, 9.320755647947047550e-06,
   2.848976313064754932e-05,-7.475515632222031685e-05,
   5.482972710136651488e-05, 2.436598091581118446e-05,
  -3.980957889348392810e-05,-3.898387913417417316e-06,
   1.507282330638164125e-04,-3.812886042848118314e-04,
  -8.505283559008535192e-04,-5.984993866401124539e-04,
   2.839263849481483276e-04,-4.356441299160081866e-04,
  -7.576925442350331982e-06, 1.850919233356940159e-05,
  -1.449962976214228567e-05, 1.377536702817016437e-05,
  -2.534509631147493971e-03, 3.222772242902156772e-03,
  -2.284089648124253483e-03,-1.770602857597272086e-03,
  -2.266011083961672737e-05,-6.623080383580047493e-05,
   1.709194616047303523e-05,-1.038582574702132581e-05,
  -1.815232956198158110e-02,-6.162940164662447304e-03,
   5.006001575005704016e-03,-1.475385875732312946e-02,
   9.162313961104012240e-05, 1.187653160136234643e-04,
  -8.703985361123210511e-05, 6.726116177509340805e-05,
  -3.919449122627578617e-05,-7.986980500376272287e-06,
   3.273686811176096335e-05,-2.298472245282001604e-05,
   1.723854183961505608e-05, 2.455265108382068863e-05,
  -1.181440231530083725e-05, 1.613753072598823380e-05,
  -1.144682669728991068e-07, 2.999978161613608063e-05,
  -2.956448476184787865e-04, 1.978027837032797498e-03,
  -1.819788410808667600e-03,-2.719745206567419178e-04,
   7.837893314993198699e-06,-2.895802873786102502e-05,
  -7.671296615397060921e-06,-6.414920750765173433e-06,
  -1.915008177344427947e-05, 2.309273409690583060e-05,
  -2.466313409718915405e-05,-1.708010001446320209e-05,
   1.708010001446319870e-05,-2.466313409718915405e-05,
  -7.536972830846349305e-06, 3.928350850607776376e-05,
  -3.928341510611762090e-05,-7.537459625129007155e-06,
   3.452362360188116717e-06, 1.969977649959401005e-05,
  -2.962527679740446367e-05, 4.726835588125391505e-06,
   5.394317420061857214e-05, 4.461091746603871672e-05,
  -4.089940699851740360e-05, 2.876175424360665918e-05,
  -8.875796970832720400e-05,-1.490042996881869881e-05,
   1.325723319554935775e-05,-7.889388929441129529e-05,
   2.202826823629663183e-05,-2.036554439512396018e-05,
   1.517706995543476114e-05, 3.700887120094099387e-05,
   7.573469085988588223e-06, 2.902830628892383714e-05,
  -3.824658898829449996e-06,-9.239696115544316303e-06,
  -2.736076077698605124e-05, 1.230401437355068047e-05,
  -1.230401437355082955e-05,-2.736076077698598348e-05,
  -4.289862279899386979e-05,-2.568478463895781775e-05,
   1.489586913971844989e-05,-2.604060449706157662e-05,
   5.979392254875111860e-05,-1.040417552054652368e-04,
   6.141249039805202854e-05, 3.359324371222831756e-05,
   2.450713046468667869e-04,-1.123583577504887925e-03,
   8.890361787200491261e-04, 1.942026594227095606e-04,
  -2.826175453014745763e-05,-1.006346018413595881e-05,
   8.624974971835813525e-06,-2.873342664450597315e-05,
  -2.994241353115256136e-04,-5.881710526649073373e-04,
   4.188695324727583131e-04,-2.344105688019481964e-04,
   2.970813526983707029e-05,-4.174529768616196139e-06,
  -1.067578880575453066e-03,-1.424315742294966812e-03,
   1.217837716597846643e-03,-9.261594333762101020e-04,
   6.500121382868699887e-05,-6.224823050334292549e-05,
   3.255967218264871230e-05, 2.323505427922327741e-05,
   3.787845446987111314e-02, 1.996935369444641228e-02,
  -1.853189809108489461e-02, 3.515446419932529570e-02,
   1.606253117998476202e-04,-3.772260717516774989e-04,
   3.245765555875522327e-04, 1.309582359491781123e-04,
   8.388389527427846841e-05, 3.261122680326336153e-05,
   2.600885409702550794e-03, 2.179336724703027114e-04,
  -2.036861147241113290e-04, 2.642160473299946279e-03,
   2.672205532794289227e-06,-3.991064165846627858e-05,
   1.999641040339786009e-05, 3.789076125943553587e-07,
  -1.279771723485446542e-04,-2.284389103613685684e-05,
   1.645827041959759020e-05,-1.390292247507530154e-04,
   4.819706167283423134e-05, 1.098956015776109856e-04,
  -1.007389456011078697e-04, 4.417765090152518437e-05,
   9.207865995576306102e-05, 6.017906929116599308e-05,
  -5.470557119252804866e-05, 8.370961999973028811e-05,
   4.973731872939606783e-05, 5.118508143049813789e-06,
  -2.827880544386850156e-05, 1.001544620413056268e-05,
  -1.962966640194308972e-05,-4.598560858516963267e-05,
   6.437985201923741797e-05,-2.748153296272044148e-05,
  -1.536143305746281605e-04,-1.431874206839025047e-04,
   1.909165609118703224e-04,-2.048191074328371678e-04,
  -4.707631187771324087e-04,-1.684698370606072459e-04,
   2.426565504653655934e-04,-6.778774214533550861e-04,
   4.964763644791060979e-05,-3.369142613686898274e-05,
   6.361320539121834475e-05, 6.366600427115456646e-05,
  -8.050473546218425030e-06, 5.932105501559909819e-06,
   1.575565031820622543e-04, 3.676628187688290401e-04,
  -3.564496343968367141e-04, 1.582518819425584125e-04,
   8.387283841102930891e-06,-1.815636168864163621e-05,
  -1.525387953516085639e-05, 1.293519072634032923e-05,
  -2.843483076338691528e-05, 9.563493057327179724e-06,
  -9.563493057327232240e-06,-2.843483076338689834e-05,
  -2.998748349346418059e-05, 8.665066238716006883e-07,
   1.829962847363899778e-05,-2.377232840356158287e-05,
   2.377232840356158626e-05, 1.829962847363899778e-05,
   1.970433254369720590e-05, 3.426263125826038055e-06,
   2.024320148069469648e-05,-2.214074962172690329e-05,
   1.833016606905647498e-05, 8.000313236418356801e-06,
  -1.351649269596302857e-05, 1.474124910582472309e-05,
  -7.759376025345687217e-06,-6.308096677864931940e-06,
  -4.455110061419802119e-06,-1.949748687243143275e-05,
  -1.937765035078492816e-05, 4.950420879352059186e-06,
   4.310853742137651119e-06, 9.023111437519644484e-06,
  -1.647645841696016315e-05,-1.133694482804704614e-05,
  -4.001647472851863941e-05,-2.997802112051143036e-05,
  -1.950442838695046015e-05, 4.424621260438133293e-06,
   1.527684663186722734e-05, 1.290805783169594530e-05,
   1.021761718971107006e-04,-6.292876843266587833e-05,
  -1.641319012763561703e-05,-2.511189339404905807e-05,
   2.862287120995055738e-05, 8.985056688668331196e-06,
  -5.990037792445553848e-06, 1.908191413996704051e-05,
   6.499933873751914076e-07,-3.999471850877774049e-05,
   1.708804754280842137e-05,-4.698934593261241689e-05,
  -4.226821699706489137e-05,-2.670950826745102668e-05,
  -1.944176843970557369e-05,-4.692295806624761532e-06,
  -1.077820832885121932e-03,-4.288382587862493364e-04,
   2.798640257260400616e-04,-7.065947403599990607e-04,
   7.650585556642184063e-05, 2.338491103360887188e-05,
  -1.200912866292680898e-05, 4.853638664710497572e-05,
  -9.264309081318600200e-06,-3.764648356194469020e-06,
  -4.413387312584497843e-04, 3.111593230021910544e-04,
  -2.007791346344214465e-04,-2.866840405314757942e-04,
   7.271712575607978653e-04,-4.045160313532388321e-03,
   3.111984594404971789e-03, 5.487730716663516851e-04,
  -9.498354949050814917e-07, 2.998495977206937224e-05,
  -1.748057814084192775e-05,-9.717478472418627792e-06,
   1.988897814175117918e-05,-2.104411670026546759e-06,
   4.146938329975225847e-07, 1.999570026342848225e-05,
   6.693341602451681028e-06,-1.884672858065530897e-05,
   3.427719785455824158e-05, 2.061731571372637107e-05,
  -2.116650095556148583e-04, 1.509898133313021019e-04,
  -9.889345590788370063e-05,-1.382753932505543940e-04,
  -2.856992369441849994e-05,-9.152019454475851518e-06,
  -1.962870667303831274e-05, 3.835866830824712086e-06,
  -6.717966793924632199e-06, 7.407355949036472166e-06,
   1.042505785692960421e-05,-1.706804525069201780e-05,
  -2.676659665201292976e-05,-1.354803689353000930e-05,
   6.136464251016335508e-06,-4.962200929523106867e-05,
  -2.967493362284881811e-05, 4.404351766096428212e-06,
  -6.792715905701072847e-06,-1.881114059871000194e-05,
  -1.418711780902853717e-05, 1.409700990539289424e-05,
  -4.631805353760474332e-06, 8.862639514550720116e-06,
  -4.460731266425163147e-06,-1.899476292996802262e-04,
  -1.835896828247120426e-05,-7.933995437559588973e-06,
  -3.088795187029031613e-06,-5.992044178986488635e-05,
  -3.329474472477630308e-05, 4.991452668023589254e-05,
  -3.327635112015722555e-05,-2.219649648318425852e-05,
  -2.372919942854031448e-05,-1.835551945548155836e-05,
  -7.626926107679484054e-04,-3.011643761801363357e-04,
   1.974413735624781471e-04,-5.026100914284968406e-04,
  -6.877866033084335009e-07, 1.998817024112786497e-05,
  -1.998817024112786158e-05,-6.877866033084678057e-07,
  -3.071652595237488767e-04, 4.182706470346698801e-05,
  -1.508924393218059590e-05,-2.595617743766503180e-04,
   2.365802962899731598e-07, 9.997201096477321202e-06,
  -2.999874152584288862e-05,-2.747851263616863927e-07,
  -6.756954374623858972e-04, 3.479018191854061021e-04,
  -3.038161129508254433e-04,-5.746266348782061700e-04,
  -1.988979328711978955e-05,-3.470441071385083987e-05,
   2.602830803538815362e-05,-1.491734496533979811e-05,
  -2.023256966587111058e-02, 2.628482498925324706e-02,
  -2.415325303145160127e-02,-1.859168545341368523e-02,
   4.791630041035433037e-04, 2.265012483375482711e-04,
  -2.254473083720041589e-04, 4.574642184344241227e-04,
  -3.094712732144834049e-05, 5.140306713173899931e-05,
   6.270568077616742479e-04,-2.564449211787930404e-03,
   2.555689758911011602e-03, 6.207655404396849848e-04,
  -1.874841803016306094e-05,-6.963965922249812455e-06,
  -3.799308454797076240e-04,-1.127720068391564355e-03,
   1.228186470882030451e-03,-3.945351603372543271e-04,
  -2.999927933903993144e-05,-2.079402275942216150e-07,
   2.079402275942197885e-07,-2.999927933903993144e-05,
   8.328170104322031890e-05, 1.125351423838245852e-04,
  -1.290786187897183311e-04, 9.454475221469767004e-05,
   5.209250312750518882e-05,-2.977198545463272483e-05,
   2.976969427788552728e-05, 5.209381251743080309e-05,
   2.756452495648387393e-05,-9.612594324074734138e-05,
   8.651334891667260317e-05, 2.480807246083548213e-05,
  -1.244624584224035789e-05,-7.902588793828586953e-05,
   3.956493591626572765e-05,-5.883523259220328796e-06,
  -1.116239307160250471e-05,-1.659520957731599439e-05,
   1.656954503991233573e-05,-1.120045432874562117e-05,
   8.608081500486663653e-06, 5.089295912106042720e-06,
  -1.999678054131618824e-05,-3.588425594022686729e-07,
  -3.691232862122098936e-05, 1.541038597047426689e-05,
  -2.311557895571130208e-05,-5.536849293183151793e-05,
  -7.003620124152168858e-05, 7.137878197095461595e-05,
  -9.279240067152976987e-05,-9.104707780930851367e-05,
  -5.197619045749853235e-06,-1.931281326620382539e-05,
  -5.698246939270005352e-06,-8.217662795412089934e-06,
  -1.489127659177945872e-05,-2.604323101051636441e-05,
   2.604323101051634069e-05,-1.489127659177950107e-05,
  -5.862620201932698455e-05,-1.276590916421782705e-05,
   1.158752220142415427e-05,-2.767181470795694733e-05,
   7.172762495427551916e-06, 6.967889076627722138e-06,
  -2.961506266490986552e-05, 4.028582956019972639e-05,
  -2.011988733381436114e-05,-7.742861314575262674e-05,
  -1.036990214576626335e-05, 1.710161189733974422e-05,
  -1.926743210544402680e-05,-5.363400046808448616e-06,
  -1.631162067471066663e-06, 9.866068634955036222e-06,
   7.706927577977705653e-05, 9.198003441389153315e-05,
   1.980660787686207668e-05,-2.774578240422341985e-06,
  -3.098259321822440381e-06, 1.975856242682499472e-05,
   1.301977173491467997e-05,-1.518175035925425990e-05,
  -2.151412876624327931e-04,-8.132789400292094362e-05,
   3.102403810659840224e-05,-8.448377986075393401e-05,
   1.246306667774419752e-06,-9.922032034309354208e-06,
   9.005688607311577900e-05,-3.070663727450693384e-04,
   8.795095725252324349e-05, 1.909526429156796620e-05,
  -3.859469293050546559e-05, 8.130467192972364596e-05,
  -5.226873258490162452e-05,-2.946149341034910244e-05,
  -3.639978154312267702e-03,-2.702943509018601652e-04,
   2.052626603144207099e-04,-2.702215246844826696e-03,
  -2.881417496114112447e-05, 4.086249284256588722e-05,
  -4.392271872014493980e-05,-2.389131181477964654e-05,
  -3.157296014915595751e-05,-9.488492075888460510e-05,
   7.553382407097483956e-05,-2.635605094119797593e-05,
  -1.022347406644076988e-05,-8.941745119389622450e-05,
   5.758555536254932224e-05, 1.684944549790192933e-05,
   1.891187578429771214e-05,-2.328821492341767713e-05,
   2.883002370400279067e-05, 8.296368677116350643e-06,
   7.907592963007683745e-06, 6.121272215102950774e-06,
  -4.149456313829047970e-03, 3.361192095019897592e-03,
  -2.700371971876133845e-03,-3.333480345450653103e-03,
   8.855900146801310628e-06, 4.644677877946385550e-06,
  -2.686153025965355790e-05, 1.335882450329056232e-05,
  -2.792376048334847455e-05,-1.096647621018649108e-05,
   7.310984140124326258e-06,-1.861584032223231750e-05,
   3.152656840651561076e-05,-2.461860037673328040e-05,
   1.822226021139119432e-05, 3.560827477972429889e-05,
  -1.027103288816024876e-05,-3.865883965421531914e-05,
   1.773556247460994972e-04,-3.074056555954598661e-05,
   6.777896302479111091e-05, 4.249720192299723335e-05,
  -3.779249018241146618e-05, 5.892136866886521870e-05,
  -1.486682857192589690e-05,-1.337824383889633796e-05,
   1.271113183390566023e-05, 1.544108569696671791e-05,
  -1.703752433031163093e-05, 1.047486346899277038e-05,
  -9.642266980710719154e-06,-1.149959576110165960e-03,
   8.199711760089878343e-04,-6.875355586250324382e-06,
   2.170084500170775641e-04, 1.769387821286942674e-04,
  -9.574645096128344009e-05, 1.154669525375920787e-04,
  -4.458467653311106197e-04, 7.470747364513041517e-04,
  -4.899067561339771762e-04,-2.913612367736720301e-04,
   1.628594769358476815e-05, 1.160895808080212890e-05,
  -1.494992320293398839e-05, 1.391994963935802999e-04,
  -9.945685409830647508e-05,-1.040837032720201375e-05,
   9.600454136381073825e-05, 2.736478175274276625e-04,
  -2.365754786912807779e-04, 8.082105469487114080e-05,
  -1.943637836724953076e-05, 4.714572723494092934e-06,
   3.446172297595456475e-03, 3.718708982333203752e-03,
  -3.396290559529025702e-03, 3.146761896816156149e-03,
   1.151892053898421759e-04,-3.363698799917667432e-05,
   3.837933721054168898e-05, 1.136970820877982347e-04,
  -1.710439445373771296e-03,-7.307509176932082710e-04,
   7.256414085203392612e-04,-1.701747497791789975e-03,
  -1.511644116769302855e-05, 2.591318595664522800e-05,
  -1.026546210387823191e-03,-8.427857342408806086e-05,
   7.533517185638652607e-05,-1.107440568103484728e-03,
  -1.005158307151566321e-05, 5.915205556661932491e-05,
  -4.446230089424831489e-04, 2.287146255029017048e-04,
  -2.369694824674029574e-04,-4.852272296348703311e-04,
  -3.418833688163375298e-05,-8.325357422518219874e-05,
   7.400317708905079664e-05,-3.038963278367456643e-05,
   6.259553172115062277e-05,-7.798589236872542879e-05,
   9.358381810655736746e-05, 7.511370706201888974e-05,
   3.140884766105762606e-05, 2.476861499164769578e-05,
  -1.857255515028690700e-05, 2.355971551588752238e-05,
  -1.099910801295167755e-04,-1.400818311637776456e-06,
   1.273471192397972359e-06,-9.999189102683343723e-05,
  -5.491499367260916422e-05, 2.417319734617859729e-05,
  -1.993526036669856328e-05,-4.585395723502975633e-05,
  -2.626393347366804556e-05, 3.016961714193170678e-05,
  -3.016961714193169662e-05,-2.626393347366805573e-05,
  -2.747019158365887270e-06, 9.615294365934449997e-06,
   1.037868797465316409e-05, 2.814751917886885185e-05,
   2.754060501136042509e-05,-1.189601091157154013e-05,
   3.230302687318920007e-02,-1.318432989688956940e-02,
   6.660189968960120209e-05, 1.672249591351013080e-04,
   4.091658259987340546e-04, 1.149340387715829708e-03,
   6.137275512443689186e-05,-3.366578275394624512e-05,
  -3.324380712256045067e-05,-6.160234807211489708e-05,
   1.996209211116761059e-05, 1.230804023904683934e-06,
  -1.209001468157161475e-05,-4.851630184792924810e-05,
  -4.722035683461346461e-05,-1.643891421024435285e-05,
  -6.607855688068149796e-06,-7.505747344912791278e-06,
   2.281131081670053509e-06, 3.993490254136397946e-05,
  -1.918725581829864538e-04, 4.399828649121650579e-04,
  -7.818250186633668629e-07,-9.969390635349385650e-06,
   1.231842858478373080e-05, 2.735427420352408269e-05,
  -1.799598757908277131e-05,-8.726077644251091045e-06,
   6.411613366035743247e-06,-1.894442435241757165e-05,
  -8.025320422686243712e-05, 8.921559959626741752e-05,
   6.372158796472561149e-06, 1.895773172804535151e-05,
  -9.999590596924822045e-06,-9.048698189625864298e-08,
   1.172407358989293951e-05,-4.860602944552018170e-05,
   2.986883338503591725e-05,-2.802283393406860467e-06,
   3.619800890127717005e-06, 9.321858265165298659e-06,
   6.039812577084854953e-05,-3.040593139559595072e-04,
   3.332753475667068707e-04, 6.728701735320683809e-05,
   2.959008430345027779e-05, 4.942358841151203413e-06,
   1.576093244200214882e-04, 2.755541427495544846e-05,
  -1.558091475539438408e-05, 7.846805143104507293e-05,
  -5.688092851806956493e-05,-1.909345361432186733e-05,
   3.975716552275684251e-07,-2.499996838733580516e-04,
   1.499654564374588517e-04, 3.218986720169322853e-06,
  -1.751850748491996302e-05,-9.648932350307118787e-06,
   3.294225754623934972e-03,-7.106171103853090509e-04,
   5.585962953128130112e-04, 2.590457523076338756e-03,
  -1.480982653510842390e-05, 1.344131831332025405e-05,
  -2.125390522618638962e-05,-3.388615517635908109e-05,
   8.632149114252951120e-06,-1.804123060296336953e-05,
  -3.735115852927868205e-05,-1.431401259328399228e-05,
   1.235334251506028346e-05,-1.572879298311234339e-05,
   2.403362254430753585e-05, 5.497622201823032159e-05,
  -2.630752379684897057e-05, 1.441922992667171690e-05,
   5.946059262602603493e-05, 8.027323623834940736e-06,
  -8.027323623834898384e-06, 5.946059262602604171e-05,
   9.470073218155355388e-06,-3.212119742907583478e-06,
  -9.095231379620212958e-06, 1.781226448689699501e-05,
   2.805571515622298320e-05,-1.062435160717490614e-05,
   5.658615362095596594e-05, 1.708742438707062125e-04,
   2.381758634209684661e-05,-1.824068476885563406e-05,
   5.406836993800566723e-06,-8.412259727473330519e-06,
   1.343330628145731903e-05,-1.481709426131045983e-05,
   1.763168210716624599e-05, 9.440539501100224861e-06,
   1.589651544909860713e-05,-1.213675395550924843e-05,
   7.996694586612831382e-05,-2.299471427025218683e-06,
   2.155808049956798725e-06, 6.996679563658565520e-05,
   3.563947989569282753e-05,-3.506889608705279608e-05,
   2.104133765223179081e-05, 2.138368793741558539e-05,
   5.934702670362035012e-04,-1.707969241649696587e-02,
   1.376169482593113738e-02, 4.781793784137270743e-04,
  -2.382029707866498716e-06,-2.990528271845697511e-05,
   9.769723203301900570e-06, 1.196016409106951436e-04,
  -7.973442727379672626e-05, 6.513148802201697339e-06,
   3.057394395104949363e-03, 2.548085460258513874e-03,
  -2.041835348582891809e-03, 2.450919910824786874e-03,
   1.576994230193032840e-04,-1.674242873043777999e-04,
   1.099738087684962786e-04, 1.020086338745412652e-04,
   6.708181352519191753e-05, 2.000075733994533572e-05,
  -1.714383745981989032e-05, 5.749859856684575099e-05,
   8.859629218861691949e-05,-1.583341436422405706e-05,
   1.771836501627008386e-05, 9.841778061483716421e-05,
  -1.718555675718436603e-06,-1.992602736095321322e-05,
   1.184258156876316940e-03,-7.835385235404247360e-04,
   6.945427488409410032e-04, 1.051289860139661926e-03,
   2.043564971813126532e-05, 2.196324704131521644e-05,
  -6.215452798541555145e-04, 9.794291526654796270e-04,
  -9.535997689697057978e-04,-6.062569427403892300e-04,
  -1.874144805437322461e-05,-6.982701828463692449e-06,
   1.987372553562604202e-05,-3.471361452419793100e-05,
  -1.185434583384859322e-04, 7.709393286667580881e-04,
  -8.329330395203390436e-04,-1.087315578634340089e-04,
   2.928560155614966877e-05, 6.507959856548291472e-06,
   1.722315988530826944e-04, 5.643015828052503659e-04,
  -6.791561974802006905e-04, 2.069948294625609773e-04,
   3.934922333630765768e-05,-7.186001866781060189e-06,
   3.382017681978570445e-06, 1.971197494922272814e-05,
   1.633658898607438803e-04, 1.892394938431386190e-04,
  -2.268843059464987718e-04, 1.962740729571165832e-04,
  -3.660910926752300275e-05, 1.611747866877949093e-05,
  -5.784435748129372975e-06,-1.914524230914205774e-05,
  -6.444175185892554345e-05,-2.733606806679895947e-05,
   3.905056176121809639e-05,-9.206005445432503776e-05,
   4.657230173638579131e-06,-2.963629880922633708e-05,
   1.319195266207692042e-05, 4.822833591325250866e-05,
  -2.893164039561066354e-05, 7.934745365736019696e-06,
   1.907269901272202334e-05, 2.315668699037304958e-05,
   9.027692144059107934e-06, 4.301252672430843371e-06,
  -9.240486963399540481e-06, 3.822747791738704298e-06,
   6.527910464409399454e-06,-7.575380186410070933e-06,
  -8.409905115115581635e-06, 5.410498678934575269e-06,
  -2.012674270110556543e-05, 2.224666780089759493e-05,
  -2.224666780089759832e-05,-2.012674270110556543e-05,
  -9.682726105262201373e-07, 9.953012014044027077e-06,
  -9.962691372521604547e-06, 8.630067299179159361e-07,
   7.687560564864186614e-06,-6.395421218461302925e-06,
   2.009902249307465191e-05, 3.458365646982515930e-05,
   1.768513703033765968e-05, 9.340017570549841630e-06,
   1.389513667569908542e-05, 1.438489404770303588e-05,
   9.256062797116062813e-06,-3.784878002768910251e-06,
   6.491543237891090998e-06,-2.928924489280306483e-05,
   1.366156818073110884e-05,-1.460690093220445539e-05,
  -9.989816424743342476e-06, 4.511848844189719062e-07,
  -1.182368365345310693e-04,-7.496699598027504693e-05,
  -1.902210206355362489e-05, 6.177348386140200150e-06,
   1.454064777787201888e-05, 2.624060902875285060e-05,
   2.262192560573295859e-06, 2.991458648918428331e-05,
   2.695995211920044631e-04, 1.470027799199539838e-05,
  -1.365168254721649357e-05, 2.295944937572110456e-04,
   1.365173358040034031e-05, 5.842627979128715691e-05,
  -5.842627979128712980e-05, 1.365173358040044704e-05,
   2.758695434069765981e-06, 9.611950868686472464e-06,
   2.662771226804150807e-06, 7.995567302820798304e-05,
  -7.987093213681915383e-05,-4.542488260373385148e-06,
   1.126344221733903146e-05,-3.838143912644059741e-05,
   6.734515322165534755e-05,-1.909529621534485452e-05,
   7.272202612212535987e-06, 2.910524126625527880e-05,
   3.247656476810992046e-06,-9.457945200128177436e-06,
   5.531941603583176513e-05,-2.323278307595884071e-05,
   6.599600439154823111e-06, 4.956253901933906856e-05,
   1.708422806539252996e-04, 4.378503341793465119e-04,
  -2.347804248577797337e-04, 8.589617048274299997e-05,
  -2.828877900733402985e-05,-9.987240974073749935e-06,
   1.706258326875998146e-05,-3.617828426275397917e-05,
  -9.548046599098341427e-06,-2.972340179294188585e-06,
   9.946166011071554174e-06, 1.036234375131888109e-06,
  -3.722403595787892162e-05,-4.705710517027728593e-05,
   2.937616241838594537e-05,-6.086138477607066584e-06,
  -8.243542259410582300e-06,-5.660742973966568562e-06,
  -2.784075700577712997e-06, 9.604630263235161439e-06,
   2.922496810174087594e-05, 6.775045346876156792e-06,
  -1.501011301270320491e-05, 2.597492073800953649e-05,
   2.942680070307728303e-05, 5.836385900655511839e-06,
  -7.316327601971774650e-07,-1.998661335755025744e-05,
   5.581103183736252075e-06,-8.297667579054314723e-06,
   1.537540366765176566e-05, 1.279050280703462956e-05,
  -5.217751176582951459e-05, 2.962274912844388048e-05,
  -1.995488391363451887e-05,-2.240095105109089671e-05,
  -3.369326703072927909e-07,-9.994322206917266005e-06,
  -1.662398479280083777e-05,-1.111949322625480932e-05,
  -6.900297304299248471e-06, 1.877194441479839311e-05,
   2.114463820007520767e-05, 2.128154776767705761e-05,
  -9.700620146761410230e-05, 2.195217457948634755e-04,
  -1.189076123055505738e-04,-5.254502579495868398e-05,
   4.594537706951853169e-04,-4.012508350072009925e-04,
   2.508089039181809077e-04, 2.854731050648391623e-04,
  -2.360694483085409580e-05,-3.229105380369323730e-05,
   2.421826872175912977e-05,-1.770523821135043291e-05,
   8.997073271960819048e-06,-1.786204558663336150e-05,
  -4.666352727515426382e-06, 5.981826771331989854e-05,
  -5.981826771331988498e-05,-4.666352727515528873e-06,
  -1.053811639158653369e-05, 1.699847354668575315e-05,
   4.977562180035367546e-05, 4.731540382175394780e-06,
  -3.785232305740101355e-06, 3.982049744028295663e-05,
  -1.842013138218991249e-04,-3.995871319077808352e-04,
   3.632388721107938402e-04,-1.675037963381080573e-04,
   5.069371143625648300e-04, 4.532270535633943910e-04,
  -4.396905358341174873e-04, 4.922115731043985674e-04,
  -3.176971924007164841e-05, 2.430401076791692284e-05,
  -2.304959773659999894e-05,-1.920198021509563345e-05,
   4.594224655766980373e-04, 1.390359598212912665e-04,
  -1.419314782041005655e-04, 4.689940889763952376e-04,
   2.232633911933517532e-05,-5.569142287218422212e-05,
   3.715032846388208518e-05, 1.482744398153884752e-05,
   4.361896733872146084e-04,-5.778034986355716458e-05,
   6.686678762534438685e-05, 5.055975006985962902e-04,
  -2.002044598404625365e-06,-4.995990209584081032e-05,
   2.889408667520035660e-04,-1.792014941918759329e-04,
   2.267801583921992255e-04, 3.653365020903454963e-04,
   1.325460476739364685e-05, 2.691310930494998700e-05,
  -2.691310930495001411e-05, 1.325460476739359434e-05,
   6.795922578464756107e-05,-9.890168669315652777e-05,
   1.318685992934726678e-04, 9.061276135499649639e-05,
  -6.530366095628428692e-06, 4.957170885350904298e-05,
  -6.940049132235571777e-05,-9.141761548827874055e-06,
  -2.983351921610550149e-05, 3.156125976931810721e-06,
   8.644008805353604302e-06,-5.028032594660596170e-06,
   4.600079630447820116e-05,-6.545171303605357561e-05,
   4.907678700210996099e-05, 3.451766182042942778e-05,
  -4.694478609974023009e-06,-1.944124148763387089e-05,
   7.370139483289633740e-06,-6.758775332621674190e-06,
  -7.452464941579322249e-06, 2.905960712560531420e-05,
   2.456534483645876187e-04, 4.641533482144557501e-05,
   1.110866449607098052e-05, 1.663122283879727754e-05,
   2.300043428198149709e-05,-1.926084169604875770e-05,
   7.007911190171578974e-05,-1.548835629596207342e-04,
  -6.259327240530557794e-06,-1.899528421729857136e-05,
  -1.922805154523557814e-05, 5.502911390687997740e-06,
   1.868712876342388962e-05, 2.793757169450831091e-04,
  -2.790082455272721069e-05, 1.102469905611642769e-05,
  -7.349799370744286541e-06,-1.860054970181814046e-05,
  -1.846589397596417204e-05, 7.681846110698275809e-06,
  -6.292832760238240254e-06,-3.950190192701704003e-05,
   1.988070762328195387e-05, 2.246680805983749228e-05,
   1.080943504200933183e-05, 2.798492655113785863e-05,
  -1.865661770075857355e-05, 7.206290028006222912e-06,
   1.959807795343028553e-05, 3.989403530763691015e-06,
   9.781451773270793786e-05,-5.032216331516129788e-05,
   2.744818267132007213e-05, 5.335351223716995996e-05,
  -5.020741118448884611e-06, 8.648245985257163333e-06,
   6.678192317470567634e-05, 2.098034168186276109e-05,
  -3.180011685856548831e-05, 5.087978545337607157e-05,
   5.307566444413687977e-06,-3.964630800513629471e-05,
   1.153558042637493752e-05, 1.633800429142542198e-05,
   1.996637606088993934e-05,-1.159235521851029726e-06,
   1.159235521850995422e-06, 1.996637606088993934e-05,
   2.395490780960443948e-04,-5.609957568318455715e-04,
   3.490676323057734926e-04, 1.501725277021110781e-04,
  -3.165323382182573536e-05, 2.445552675001762648e-05,
  -1.468848880855489733e-05,-1.357380921189618121e-05,
  -2.550498217332938336e-06, 9.669279127390082489e-06,
  -1.001149778011475791e-06,-2.998329033181628089e-05,
   1.998886022121085506e-05,-6.674331853409673436e-07,
   1.997131000860377143e-05,-1.070876528943853865e-06,
   9.868752968925746796e-06,-1.614842047483055836e-06,
  -1.499534819491580137e-05,-3.708287384377370317e-05,
   1.734219907793840715e-05,-9.962335626807217057e-06,
  -1.707665883392777591e-05,-1.041094246788620285e-05,
   1.041094246788623673e-05,-1.707665883392775558e-05,
   1.587662718016776724e-05, 1.216275911880023266e-05,
  -1.953422150885953323e-05,-4.291175834524804565e-06,
   7.082070386567886576e-05,-3.720790109600136851e-05,
  -1.579132877799985590e-05,-2.550752703468357990e-05,
  -1.507029075120678999e-03, 3.047763666484150195e-03,
  -2.411318900835987371e-03,-1.192325944727836264e-03,
   8.136708365002392823e-05, 3.846293928302945314e-05,
  -2.564195952201933840e-05, 5.424472243334942101e-05,
  -2.993629637571934535e-05,-1.954011081108019692e-06,
   4.943826346256081419e-06,-2.958983915228442408e-05,
   7.625865012396373982e-06,-2.901458569086777379e-05,
  -1.351680747975033596e-04, 3.646356476726501114e-05,
  -3.385902442674676037e-05,-1.255132123119672447e-04,
  -2.515944672084598443e-06,-9.678327459174396378e-06,
   3.067575762975279863e-04,-2.242761453745500499e-04,
   2.130508528375050451e-04, 2.901884458506433857e-04,
  -3.293475995411274132e-05,-5.015278244290113035e-05,
   5.015251802408487422e-05,-3.293516260539549998e-05,
  -2.047394637157191531e-06,-2.993005471427909037e-05,
   1.148755369416191785e-04,-2.332458167092706406e-04,
   2.422161850352908409e-04, 1.192950950666025957e-04,
  -3.428679409801113306e-05,-2.060135312256428553e-05,
   1.028672404228476389e-05,-1.715177275029845490e-05,
   9.390755530147882834e-06,-2.898479147942468960e-04,
   2.998428501498862867e-04, 9.709027448350058561e-06,
  -2.978949055159492895e-05,-3.547710906547549943e-06,
  -1.052017242112441946e-04,-2.486616118804455184e-04,
   2.949494319921606013e-04,-1.241162059019766098e-04,
  -3.814474330327619468e-05, 1.204070422887158278e-05,
  -9.099491995937197646e-06,-2.858669700080572183e-05,
  -1.547484781313338584e-04,-1.419609401069043815e-04,
   1.764864352177094231e-04,-1.909254780906551648e-04,
   2.279248598984918842e-05,-1.950647539671194520e-05,
   1.950647539671190116e-05, 2.279248598984922908e-05,
  -1.583471568818310465e-04,-1.050056089332412348e-04,
   7.184594295432313201e-05,-1.083427915507263593e-04,
  -5.622028661191901981e-05,-2.095899265884882849e-05,
   2.794575528547559170e-05,-7.496022119447296264e-05,
   3.963242329965025124e-05,-5.410270177850649168e-06,
   6.763399741353239129e-06, 4.954045239941459137e-05,
   7.174135870324917124e-06, 1.866900571841246872e-05,
  -4.690697360359259786e-05,-1.731288038865478303e-05,
  -3.989645241259118718e-05, 2.876297079553319600e-06,
  -2.157222809664991500e-06,-2.992233930944338869e-05,
   6.797752418442658925e-06, 7.334204936975581342e-06,
  -2.982281928959644855e-05,-3.255679594197509770e-06,
  -7.958225434867661620e-06, 6.055299160885895443e-06,
  -1.577932753120476670e-05, 2.595207367873768865e-04,
  -2.998952139055802071e-05,-7.928472521633592439e-07,
  -9.670255562973451694e-06, 2.546793542237183189e-06,
  -9.956344963070864066e-06,-9.333782600497216267e-07,
   1.881425553507056099e-05,-6.784083479812639046e-06,
  -5.186743673798796793e-05, 3.016237733055563241e-05,
   9.260702725973326142e-06,-3.773510967408234338e-06,
   2.821489964983772125e-05, 1.019408837265928567e-05,
   4.439348743396141531e-06, 8.960590534920514737e-06,
   2.597568689291006403e-04, 7.366389240428469494e-05,
  -4.413117833457533252e-06,-1.950703439757102547e-05,
  -3.017273052782101491e-06,-9.533942695703335370e-06,
  -1.534387368652668531e-05,-1.282831011052952699e-05,
  -2.619682598342123699e-04, 6.536536421863338388e-05,
   9.547457429489389499e-06, 2.844021899761124970e-05,
   2.857957055946328082e-05,-9.121849956925387741e-06,
  -1.357081633394780912e-05, 3.762755564782617571e-05,
  -6.348288284532203420e-07, 9.979829275020926942e-06,
   1.129297423352632016e-05, 7.919891876131208899e-05,
  -3.985319627145728386e-05, 3.423849726361177293e-06,
  -1.996963853485231378e-05,-1.101606457561660759e-06,
  -1.736613447414460796e-05, 6.781163154965323659e-05,
  -5.883164182586389285e-05,-1.178295039764075252e-05,
  -1.368749626592940535e-05, 6.864876143070731485e-05,
  -6.739909090232932057e-05,-1.890403516552876048e-05,
   9.428242204830519186e-06,-3.332903978072661580e-06,
   3.985752361444794436e-05, 3.373101143417534687e-06,
   4.716410883801231386e-06, 3.972097013386205726e-05,
   4.980815544561603637e-05,-4.375802909792627980e-06,
   3.894957960797689156e-05, 9.106604656065336872e-06,
  -4.652467814144306734e-06,-8.851810167324609106e-06,
  -1.840222869464202120e-05,-7.833133413270442787e-06,
  -1.902362854978946729e-05,-6.172645850819169032e-06,
   3.609983905820290966e-05,-3.459482071021394221e-05,
  -8.624618623261172320e-06, 5.061220564576946733e-06,
   5.029369089172207377e-06, 4.974641139383703415e-05,
  -3.979712911506960699e-05, 4.023495271337980540e-06,
  -2.999993414175736072e-05, 6.286087989495111715e-08,
  -6.286087989489231454e-08,-2.999993414175736072e-05,
  -1.144834666590174399e-04,-1.994831718760598806e-04,
   1.908103345122115751e-04,-1.095053251825587123e-04,
  -1.057158626272489696e-04,-7.565815480816738352e-05,
   8.148107285149355653e-05,-1.138456620472189860e-04,
  -1.468321795422810596e-04,-3.066449169419468778e-05,
   3.312304329184051835e-05,-1.667419083586572893e-04,
  -1.753154006548828848e-04, 4.079841042513663717e-05,
  -4.760585623621336278e-05,-2.045328395442086206e-04,
  -4.057275684067049843e-06,-2.972437575498396037e-05,
   2.972437575498396715e-05,-4.057275684066999021e-06,
  -1.351010932269317282e-04, 1.031876669417809093e-04,
  -1.335368586891054336e-04,-1.748368021082686576e-04,
  -2.637881328320832667e-05,-4.247538357413187780e-05,
   3.398030685930554696e-05,-2.110305062656659289e-05,
  -5.753973421671662575e-05, 1.053051707480198311e-04,
  -1.404067470392882414e-04,-7.671991518403372171e-05,
  -2.459103281710212638e-05,-1.718374537137368029e-05,
  -3.733659488030862001e-06, 2.976675640420765014e-05,
  -3.968895988077489789e-05,-4.978600564640702498e-06,
  -1.059407277370081658e-05,-2.806716270066376062e-05,
   3.685121495271048074e-05,-1.555596208883036537e-05,
   8.089639270131271427e-06,-5.878582863169489722e-06,
   9.860998692030809159e-06,-1.740002025274013108e-05,
  -8.915763298723739146e-07, 9.960175281992346912e-06,
   3.285281815399317497e-06, 9.444941682901306784e-06,
  -6.820969095511834711e-06,-7.312617903191201085e-06,
  -1.861535809128907055e-05, 7.312211917954689969e-06,
  -1.227770550318143652e-05,-1.578790510413425298e-05,
  -7.168097956154906895e-06, 2.913105510775344296e-05,
  -6.738889903710933896e-07, 2.999243027213127898e-05,
  -4.494208712260742516e-06, 8.933201444646798618e-06,
  -1.433559552793727074e-05, 2.635319147388765520e-05,
  -9.272833080696074849e-07,-9.956914465163167104e-06,
  -7.136059518399750491e-06,-7.005473185292791889e-06,
  -1.634991413021817213e-05, 2.515313713902287999e-05,
  -9.164884108164344709e-05, 6.435064023989128714e-04,
  -2.560104349974887846e-05, 4.294865040631621689e-05,
   4.813642456584304309e-06, 8.765206574871412120e-06,
   8.735769157147258476e-06, 4.866861127362758864e-06,
   1.617357092666593500e-05,-1.176501608499140327e-05,
   1.922840180887459729e-05, 5.501687366296648197e-06,
   2.372237388711089177e-05,-1.836433982369416364e-05,
  -7.897034616086818322e-05,-1.945859307021775928e-04,
  -1.107689376530340814e-04, 4.615454962642630006e-05,
   2.887628922317844651e-05,-8.133874888351086394e-06,
   1.306933207064183756e-05, 3.780466319420519290e-05,
  -1.150926766530509617e-05,-1.635655091418611415e-05,
  -9.959051253914704273e-06, 9.040454202638123898e-07,
   1.991969587993871159e-05,-1.790451353919667379e-06,
  -3.243278329610089784e-05,-3.805410053684305004e-05,
   1.182543660206392462e-05,-2.757098201317042201e-05,
  -8.950886118933911459e-04, 4.890975126278627625e-04,
  -3.431067777797351258e-04,-6.556506226959655636e-04,
   8.142912245547105198e-06, 2.887374205331409948e-05,
  -3.397085201531667892e-05,-4.945686214625281523e-05,
   3.878377555609252336e-05,-3.155659603972900748e-05,
  -2.601186237960094610e-05, 4.270108916110572762e-05,
  -3.681841449933221469e-06,-9.297528894149975143e-06,
   2.004437128236255097e-06,-1.989930229427524448e-05,
   1.476969902636258503e-05,-1.348539916615982774e-05,
  -9.727430625059704656e-06,-2.318856061649917480e-06,
  -2.112988404086180990e-05,-2.129619685342275736e-05,
  -9.496858552928268563e-06,-3.132040489149719909e-06,
  -1.619947537259239334e-05, 3.657289977090649882e-05,
  -3.657267075256407513e-05,-1.619999240816318036e-05,
  -9.469065431180503743e-06,-3.215089401559837026e-06,
   1.982901322908999962e-05, 2.609642573337163718e-06,
  -4.781256568603108070e-06, 2.961654243197861229e-05,
  -1.402923065629537380e-04, 5.308548501470253787e-05,
  -4.954645268038787435e-05,-1.309394861254239062e-04,
  -5.733023540835821373e-05, 5.579645246807570115e-05,
  -4.882189590956613094e-05,-5.016395598231352087e-05,
  -1.910122652736273715e-05,-2.313316115774871983e-05,
   2.313316115774861819e-05,-1.910122652736286251e-05,
  -2.815683301773825036e-05, 7.488119092543338501e-05,
  -8.424063764060112027e-05,-3.167830440388089689e-05,
  -4.493132128686445041e-05,-2.193573266195049008e-05,
   2.193573266195088649e-05,-4.493132128686426068e-05,
   6.510313602611712111e-06, 9.978785405446721497e-05,
  -1.197454003214657819e-04, 7.812752514441046969e-06,
  -4.997958517725305949e-05,-1.428658640020953980e-06,
   1.428658640021394860e-06,-4.997958517725304594e-05,
   5.638809993880799165e-05, 1.059263054453000498e-04,
  -1.324040926070051822e-04, 7.049224255842334065e-05,
  -4.615521054138265546e-05, 1.922749437343928479e-05,
  -1.538199549875136549e-05,-3.692416843310615418e-05,
   8.693484493482184770e-05, 6.739683031240029988e-05,
  -9.190487206000681416e-05, 1.185474356181261948e-04,
  -1.376080718260277113e-05, 1.451344844215970806e-05,
   7.760865700063582717e-05, 1.941381875257054508e-05,
  -2.426752741436637127e-05, 9.701075771888898369e-05,
  -1.578260623898383074e-05, 1.228451628291438928e-05,
  -2.903351395349946742e-05,-7.553480489943145384e-06,
  -8.292960982609010940e-06, 5.588094321047614220e-06,
   4.311165055498594051e-04, 3.082832441805393028e-04,
   7.044746240710543640e-07,-9.975154911280323261e-06,
  -2.594570113841542999e-05, 4.274132183772547241e-05,
   7.817157208167990434e-06, 4.938514000367709059e-05,
   9.869754428864211835e-06, 1.608709891159773428e-06,
  -6.645748507212406693e-06,-7.472216992224200328e-06,
  -2.513766634543530137e-02, 3.425356997006441442e-04,
  -2.133243038957976790e-05,-9.769814437170100776e-05,
  -7.933267885150536937e-05,-5.139127611436048989e-04,
  -4.959195807460513121e-05, 6.374770139119326330e-06,
   2.629430392754280701e-05, 3.014315147701061135e-05,
   6.670030480769813307e-06, 1.885499120619263771e-05,
  -7.427045280483217190e-06,-6.696192828888068488e-06,
  -3.173446823181807252e-07,-1.999748215032593596e-05,
  -4.678256648928613096e-05,-1.764628778739376930e-05,
   2.500154320546481458e-05, 3.122375437620012725e-05,
   8.332923453305259378e-06, 1.818137472033826249e-05,
   2.693084598057867519e-05,-1.321852997766201761e-05,
  -2.960939359929342946e-04,-2.835989793144751397e-04,
  -1.575076388230195294e-05,-1.232531691779048400e-05,
   1.971026525707385464e-04,-1.185349920891663934e-04,
  -3.619589430985728349e-05,-5.991541734069487834e-05,
   1.621511702054755205e-05, 2.524024524464746816e-05,
  -2.662220332024691351e-05, 1.382961642184750630e-05,
  -1.755428297892862518e-06,-9.844717948776236498e-06,
  -9.984007016436391877e-06, 5.653352065358451448e-07,
   3.060831501805233788e-06, 9.520047821180140245e-06,
   6.377079150090832031e-05,-4.830410077154608645e-05,
   2.747905591522621063e-05, 4.177201797864057525e-05,
   1.628033789813285103e-05,-1.161682391717371602e-05,
   1.966210122063372797e-05, 3.660843562562287583e-06,
  -6.644416890232100087e-06, 2.925494358546600288e-05,
  -3.709586646892329420e-02,-1.137251459662117631e-02,
   9.200393738261276183e-03,-2.986495027722234005e-02,
   2.704718958608746254e-04, 3.965412381448166755e-04,
  -2.714805578401820294e-04, 2.046907587429964851e-04,
  -8.850663690102900973e-05,-1.632713154443889012e-05,
   4.664506662296477927e-05, 1.800660322601620305e-05,
  -1.888196646518050994e-05, 6.593280094747891175e-06,
  -1.439648354043460683e-05, 2.631997837518100121e-05,
   2.999952413871919088e-05,-1.689717443970429721e-07,
   1.689717443970714536e-07, 2.999952413871919088e-05,
   6.083048994208818704e-06,-2.937680232656466421e-05,
   2.937680232656466421e-05, 6.083048994208817010e-06,
  -3.856682801058461998e-05,-1.061130421776634533e-05,
   7.958478163324757301e-06,-2.892512100793846329e-05,
   9.503284106048312085e-06, 3.112489550139815760e-06,
   3.245360275398179986e-05, 2.338297817402105493e-05,
  -2.338297817402100410e-05, 3.245360275398184052e-05,
   2.472888633960094128e-05, 1.276263381140550247e-04,
  -1.178087880475413605e-04, 2.282738396683849807e-05,
  -2.997396716432084885e-05, 1.249516879524062238e-06,
  -1.249516879524223810e-06,-2.997396716432084208e-05,
   2.248136413730260702e-05, 3.308456235959612266e-05,
  -3.308456235959600069e-05, 2.248136413730278320e-05,
   4.331258910524713617e-05, 2.498038480488296332e-05,
  -1.998430784390594578e-05, 3.465007128419795424e-05,
   5.971008976270280038e-05, 5.891110296877390916e-06,
  -5.892329596714564299e-06, 5.970996945170614796e-05,
   6.631243187722404451e-05,-2.242011102846103119e-05,
   2.562404219713407968e-05, 7.578527865937746742e-05,
   5.856785763561914908e-05,-5.449592693012798958e-05,
   6.811987033007712103e-05, 7.320985771201498835e-05,
   1.823487606020051353e-05, 2.382203381470873025e-05,
   3.125146006409081686e-05,-7.364337202941306706e-05,
   9.205416731062097480e-05, 3.906443754552471154e-05,
   1.751473158246921792e-05, 9.655784670033574298e-06,
  -2.753814603793940563e-04, 5.064633529992271720e-05,
  -4.697393313901978179e-05,-2.557214296953833196e-04,
  -2.978581839555415949e-07,-3.999889099090437342e-05,
   5.999833773378805647e-05,-4.466197289688727382e-07,
   1.589975605904095379e-05, 1.213250828406849222e-05,
   6.200735438590825807e-08, 9.999807752552149139e-06,
   8.345749616842944294e-06, 1.817549073155841772e-05,
  -5.277506413956452185e-07, 9.986064252772785757e-06,
  -7.640324429818374361e-06, 6.451778251545890488e-06,
   1.968094770397082240e-05,-3.558131177116104275e-06,
  -1.759297044657463191e-05,-2.429994631405492768e-05,
  -8.961945605223044800e-06, 4.436612555658129272e-06,
  -1.004355160062063066e-04,-6.320701757910802444e-04,
   1.392994879629695430e-05,-1.435118554449579718e-05,
   1.208040235275317879e-05, 2.746022357876198140e-05,
   1.199410985985009788e-05, 2.749802408664751212e-05,
  -8.011247181386812417e-06,-5.984974402511831918e-06,
  -2.324570698064542170e-05, 3.255206762972166339e-05,
  -3.768853568742809515e-06, 1.964168380708167827e-05,
  -2.865412586498415279e-05, 8.884878778781744643e-06,
  -2.884013634747481283e-05, 8.261146134711706986e-06,
   1.524168680331426510e-04, 1.853890458979914587e-04,
   3.849989069548385854e-05,-3.190232619160858908e-05,
   9.688854172271441754e-06,-2.475096933143887200e-06,
  -1.171383904052703463e-05,-1.621067472169572296e-05,
   9.505997521029881550e-06,-3.104192508555767325e-06,
  -1.695650602862098149e-05,-1.060551287309295418e-05,
   2.790528649508147114e-05, 6.419731291594237986e-05,
  -3.983300931471564813e-05, 3.651214720305677156e-06,
  -7.288952734153426329e-07, 9.973400206569111475e-06,
  -9.102718061852594863e-06, 4.140111578982209069e-06,
   1.561355224739030854e-05,-2.561673254374985867e-05,
   1.062002407803826414e-05,-2.805735355627625191e-05,
  -1.870490237085083461e-05,-7.080016052025511121e-06,
   9.795250034155671972e-05, 5.005304862680525646e-05,
  -2.348126167799097325e-05, 6.594414568412962688e-05,
  -4.997359664972064167e-05, 1.624696245773401558e-06,
  -1.619767765019573553e-03, 2.742968106806218119e-05,
  -2.539523522218436143e-05,-1.499785011936047427e-03,
  -3.115639695077931915e-05, 2.508543260630498385e-05,
  -2.508692797711191470e-05,-3.115519290056153410e-05,
   1.825894379323122024e-05,-8.161554481569253017e-06,
   3.547477850613001379e-06, 9.349620361245165089e-06,
   1.267636947724364946e-05,-1.546963661100045402e-05,
   7.765190013646302954e-06,-2.897760901199351538e-05,
   1.874078734768583511e-05, 6.984474897142848397e-06,
  -6.480378150830312911e-06,-3.947156823616514810e-05,
   4.933958329004827702e-05,-8.099723499255326585e-06,
   2.993030234762403513e-05,-2.043771361921681541e-06,
  -2.908560008021556661e-05,-4.066974142988574135e-05,
   4.915105905815386582e-05,-3.441182054849569995e-05,
   2.644999341994089349e-05,-1.415619468943131912e-05,
  -4.230984926410579459e-05,-2.664351056540122516e-05,
   3.730094580629540963e-05,-5.923376943902702635e-05,
   1.226175928157588082e-05,-1.580029301376046629e-05,
  -3.958462224143312195e-05,-5.749581028478393384e-06,
   1.006185143287387729e-05,-6.927307662968905692e-05,
  -1.927916170245185670e-05, 5.321082977243799957e-06,
  -1.015936619395981132e-05,-3.868833517401630128e-05,
   1.193395479447394514e-05,-4.855492480648541628e-05,
  -1.521939956045415029e-06,-9.883506400574266986e-06,
   1.972668631137927293e-05,-3.295124758251455531e-06,
   1.433473564896720562e-05, 2.635365921222760415e-05,
   3.513820894712511319e-05,-1.911298699806434598e-05,
  -5.247077045422701389e-06,-1.929943477098223969e-05,
   4.949201033009039346e-06, 8.689384853651164393e-06,
   8.563345095635659207e-05,-2.769317745050703771e-05,
   6.483381937253281972e-06,-7.613524719582770126e-06,
   1.591221887600277081e-05, 1.211615823774933887e-05,
   8.130532891927692830e-06, 5.821892724302116724e-06,
  -9.926889628485015651e-05,-1.380061093951556468e-04,
  -1.316082973150250210e-05,-1.505963348751887186e-05,
   1.760851576110357598e-05,-9.483679280267075999e-06,
  -2.093449970785910936e-07, 1.999890433679300889e-05,
  -1.372634821339810852e-05, 1.454604292323319929e-05,
  -1.870436451551352793e-04, 2.083618842472869975e-04,
   2.198862834539024890e-05, 2.040833710737600888e-05,
  -3.490993173570045531e-05,-1.952681915235388781e-05,
  -1.064065265295482574e-05, 1.693447699573758688e-05,
   1.983141419815914608e-05,-2.591333807337808171e-06,
   8.208132699696452886e-06,-1.823805246138342318e-05,
   1.211515603929253294e-06,-9.926340208830036700e-06,
   4.997835480337924416e-06,-8.661503363243323362e-06,
  -3.535558013804133488e-05, 3.535509797896955856e-05,
   9.999676931563351889e-06, 8.038199027001641005e-08,
   9.684277089919012088e-06, 1.749899360665263759e-05,
  -1.488255361949135801e-07, 9.998892486659525424e-06,
  -3.795414811658180763e-05,-1.262864366211075451e-05,
   9.471482746583064191e-06,-2.846561108743635233e-05,
  -3.998833124806684225e-05, 9.661076518075729271e-07,
   1.221561193483727753e-05,-5.874333004739739473e-05,
  -5.603769131188798954e-06,-1.919890026861787816e-05,
   2.699819216303384211e-05,-1.308042888929480497e-05,
  -1.473686595586705400e-05,-1.352127145644249874e-05,
  -1.981494729022566570e-05, 2.714380939658005054e-06,
  -2.714380939658001242e-06,-1.981494729022566570e-05,
  -3.745896849012933244e-06, 1.964607484452187102e-05,
  -1.999999258497607094e-05,-1.722210504832382920e-08,
  -2.735030441300035525e-05, 1.232724010134520573e-05,
  -1.232737375999994877e-05,-2.735024417041399776e-05,
  -1.987392202963389465e-05, 2.247281075344231526e-05,
  -3.745467302688927625e-05,-3.312321645687225707e-05,
  -1.194450540413770073e-05, 3.817497597445905022e-05,
  -4.771870954451471576e-05,-1.493066506911999944e-05,
   3.342184765014350916e-06, 2.981324874944872669e-05,
  -3.975100611015487548e-05, 4.456176974765505508e-06,
   9.616251320324434122e-06, 1.753646801794359647e-05,
  -1.565405878768982731e-05, 3.680965149891467122e-05,
  -6.891673506462611963e-06,-7.246022100457694118e-06,
   1.126331091764410240e-05,-2.780535608785615406e-05,
   3.548316185058309207e-04, 7.281445752792039530e-04,
   8.353586823685302991e-04,-4.087491550957786943e-04,
  -4.472819545108208290e-06, 1.949343185067468093e-05,
   2.153046186732783965e-05, 3.371111406909510819e-05,
  -4.213889258636892759e-05, 2.691307733415972418e-05,
  -7.971160128447272582e-06,-2.892162869215100871e-05,
  -1.167581101334951471e-05, 1.623808600730228252e-05,
   8.636677242039620273e-04,-9.447105705814608494e-04,
  -1.189779333672242953e-06, 3.998230139870848570e-05,
   2.707724192750238950e-05,-1.291599665529171553e-05,
  -2.979026892432670693e-05, 3.541168933600119811e-06,
  -1.380638728149491499e-05,-2.663425745601659500e-05,
  -1.577118427946390652e-05,-1.229917665631283716e-05,
  -6.252388812685418343e-06,-2.934122754989992196e-05,
   2.767741819803080030e-05,-1.157413158259890848e-05,
  -5.816071756084129058e-05,-5.493023696297011756e-05,
  -6.883628196173625494e-06,-3.940324431892434671e-05,
   8.362040819188445024e-06,-1.816800135783312647e-05,
   9.249965707648802424e-06,-3.799754519350060826e-06,
  -3.508844545682221852e-04,-2.308248243633280320e-04,
  -1.098918230064727581e-05, 1.671041209435424713e-05,
  -2.533560051115371953e-05,-1.606571961473333442e-05,
  -9.389564159717285252e-06,-3.440361156993933277e-06,
   1.749067840783676375e-05,-9.699287027077449399e-06,
  -9.874323918632472088e-06, 1.580419928349007872e-06,
   2.494134763297092121e-06, 9.683970868528724469e-06,
  -1.054034499899338889e-05, 1.699709173071073151e-05,
   2.397033455288773187e-05, 1.803948617401938590e-05,
  -3.148455840006328854e-05,-2.467230395307670426e-05,
   7.964245480356860630e-06, 2.892353356574219465e-05,
  -4.062316412706019620e-06,-9.137701317238341729e-06,
   6.987606531827934278e-05, 4.163591674931285104e-06,
  -2.356696422081397925e-05, 1.856335630792217071e-05,
  -9.614126909042885365e-06,-2.751102283961377453e-06,
   5.144270919630861766e-06, 1.932709178085105322e-05,
   1.895560876927923307e-05, 2.325263202706360981e-05,
   2.682130350065035842e-05, 1.343940767020633352e-05,
  -1.343910339130518250e-05, 2.682145596416811794e-05,
   2.996930946290832950e-05, 1.356646717621543265e-06,
  -1.807892879305338634e-06, 3.995912315525651569e-05,
   1.867526055614782102e-05,-7.157837883047469196e-06,
   1.073864890955699812e-05, 2.801216556421995592e-05,
   3.809227272360937830e-04,-8.154127027922833046e-04,
  -1.494645734774858774e-05,-3.710260654929694544e-05,
  -3.491631998543585916e-06, 2.979611561909952390e-05,
  -1.840129136854775030e-05, 7.835335089822902555e-06,
  -2.757689066621695902e-05,-1.181165107779246646e-05,
  -8.923444843208177104e-06, 1.789894220701942687e-05,
   3.482894961685712529e-06, 1.969440130305728063e-05,
   2.816327738206197962e-06, 9.595222669172944662e-06,
   2.011522966727645489e-05,-3.457423224646819616e-05,
  -9.554406433895672431e-06, 2.951832938350845811e-06,
  -6.748239494168023748e-06, 7.379787512479671863e-06,
  -1.992572917259684823e-05, 1.722009564527157895e-06,
   8.508745635118917500e-06,-5.253688962704660866e-06,
   4.524798477697196789e-06, 4.979484108556055154e-05,
   3.847901359281353590e-05,-1.092545252719864034e-05,
   8.194089395398981103e-06, 2.885926019461015362e-05,
   1.816683249714234717e-05,-2.387396483663266030e-05,
  -1.283551384570411848e-05,-2.711548606086082824e-05,
   8.926421008222971013e-06, 4.507661032504065227e-06,
   1.172993583191332617e-05,-1.619903100124189265e-05,
   4.079303256233161077e-06,-1.957956294056855683e-05,
  -6.312800044557610778e-06,-2.932828933977284518e-05,
  -1.160077890315657000e-05,-1.629177488305302772e-05,
   1.726565668083121811e-05,-5.746213622360091456e-05,
   3.772627230876200342e-05,-1.329392258459247040e-05,
  -3.467797397836527206e-05,-1.993585013877815918e-05,
  -8.292733295311894047e-06, 5.588432203474024802e-06,
   2.476522791069230236e-06, 2.989760583834957564e-05,
   9.758880358887565983e-06, 2.182717146338138117e-06,
  -4.308090919477164236e-06,-9.024430875657390557e-06,
   4.661831600363309639e-06,-8.846882283033615511e-06,
   6.361155215849467359e-06, 7.715938330486522194e-06,
  -1.166030656548225835e-04, 2.835004550079479719e-05,
  -1.653752654213025121e-05,-6.801845496531317033e-05,
  -7.629307683047591369e-06,-1.848766248819442066e-05,
  -1.672161143647987434e-06, 2.995336169964356323e-05,
  -1.866825691541489467e-05,-7.176084150848844849e-06,
  -1.997174764203321255e-05, 1.062683453781484048e-06,
   5.538428847288756413e-06,-1.921785123013287889e-05,
   8.757803134176403046e-06,-2.869322017939098662e-05,
   1.370897887550176038e-05,-1.456241388613325213e-05,
  -9.740720139298614765e-06, 2.262381746713492903e-06,
  -6.874542446707780751e-06,-7.262276925896796087e-06,
  -1.649651830273611404e-05, 3.643988040440710049e-05,
   2.395065323777321970e-05,-1.806560847256308687e-05,
   4.638228653486837333e-05,-1.867306873005527637e-05,
   1.490174064170882123e-05, 3.712058897495086563e-05,
  -2.312368243430458523e-06, 2.991074979178513397e-05,
  -6.770654564629014463e-06, 7.359228000712323918e-06,
  -3.015083074086462618e-05,-7.410079220653267222e-05,
   4.631299512908290997e-05,-1.884426921304041127e-05,
   1.696982007999079585e-05,-1.058419607021436600e-05,
   1.139608972721630907e-05,-2.775120067545249470e-05,
   4.994926072730028336e-05, 2.251966428741287211e-06,
  -1.801573142993098294e-06, 3.995940858184022398e-05,
   2.197635419815710287e-06, 2.991939836563515284e-05,
  -2.995031102276231330e-05,-1.725940219069695097e-06,
   6.227127622208497682e-06,-7.824505196926381307e-06,
   1.419030950915274797e-05, 1.409379707653154667e-05,
   3.547185464754766472e-05, 6.034689327432896452e-05,
  -4.312742873244117991e-05, 2.529871322672770553e-05,
  -4.308067703511384854e-06, 9.024441958479325249e-06,
  -6.998095437414022751e-07, 2.999183666604112044e-05,
   9.972093085206774297e-06, 7.465651344465835348e-07,
   1.994686440600259894e-05, 1.456914674422147511e-06,
  -1.192089726873288458e-05, 1.605902264486593563e-05,
  -1.905699546639574491e-05,-6.068848638232141092e-06,
   1.984427140514812005e-05,-2.490962143193013349e-06,
   1.465532110346135693e-05, 1.360961290244657494e-05,
   7.029279863270716669e-04,-4.024826033981692796e-04,
   3.395646108782545483e-06,-1.970963184597596867e-05,
  -1.079130999330048288e-05,-3.851684863314356358e-05,
   3.851684863314357036e-05,-1.079130999330047611e-05,
   3.989425668515936892e-05, 2.906593115421757139e-06,
  -6.422980143755290626e-06,-1.894057354128763886e-05,
  -8.294489792235636288e-06,-5.585824834928039828e-06,
  -5.317357870687668746e-06,-8.469102979361859093e-06,
  -1.466258215126347232e-05,-3.721570481204743153e-05,
   2.719364217357946834e-05,-1.266908936488018108e-05,
   9.013535654340751324e-05,-4.330839988723671305e-05,
  -3.897755989851304039e-05,-8.112182088906676192e-05,
  -4.087085872943806256e-06,-2.972029153738541606e-05,
  -1.981352769159027511e-05, 2.724723915295905424e-06,
  -4.946023930179724743e-05,-7.326986297854746936e-06,
  -1.567662073320824273e-05, 2.557818528330627042e-05,
  -2.751649293521540068e-05, 1.195167839871207863e-05,
  -7.967785599141386882e-06,-1.834432862347693379e-05,
   9.250111577379224390e-04,-1.974019847433239067e-03,
   1.402725079747858339e-03, 6.594409379515076561e-04,
   2.008497115166386635e-06, 3.994954241713375088e-05,
  -1.188513157310840552e-03,-5.267223888340205129e-04,
   3.837085660076687598e-04,-9.126158755864038127e-04,
  -2.442837976423962440e-05, 7.617909333993211417e-05,
   6.993205887025961314e-04,-5.175429588127486652e-04,
   3.920868960868181233e-04, 5.058338323174960864e-04,
   1.785495260098258802e-05, 2.410810377480288556e-05,
  -1.765250917799897511e-05,-9.401538157166733283e-06,
   7.081873968620117739e-05, 5.554013061974265623e-05,
  -3.054988209279875565e-05, 6.298178073154245716e-05,
  -2.645046588001740754e-05,-1.415531189094874758e-05,
   1.647384133413647305e-05,-2.507214693036271627e-05,
   4.876174496659269273e-06,-1.098918692273369676e-04,
   9.990206799890042179e-05, 4.424568853919753633e-06,
  -2.090287283773739234e-04,-2.017401082923368251e-05,
   1.922328073255643566e-05,-1.990740200977448779e-04,
  -4.957931397426314761e-05, 6.472374049870337633e-06,
   4.164292488734764946e-05,-6.830715048094688504e-05,
   1.245563314261579969e-05,-9.922125378675967816e-05,
   6.939715896000814722e-05, 9.167023959789793690e-06,
   6.197334669228456032e-06, 1.901559999047043009e-05,
   2.707564211450497362e-05, 2.944332868558249396e-05,
  -2.208249651418690181e-05, 2.030673158587869125e-05,
   1.697964021303552043e-05,-3.621728617988746144e-05,
  -2.716296463491561810e-05,-1.273473015977659289e-05,
   3.507224210568868605e-05,-1.923376805724655354e-05,
  -1.532736345329468306e-05,-1.284803212833026083e-05,
  -1.966248830376787584e-05, 2.265803508039017041e-05,
  -6.999418708023497830e-05, 9.020947716650750190e-07,
  -1.150226762310426292e-05,-3.831054475632639011e-05,
   7.999957943372413692e-05, 2.594039846727272312e-07,
   1.056090509712879150e-05, 3.858065944912604988e-05,
   1.160165233227208192e-05, 1.629115291073918580e-05,
  -5.553833840726589966e-06,-8.315944304142504042e-06,
   1.219711440306210606e-06, 9.925336467968537188e-06,
  -6.100450521969407033e-07, 9.981374907010058921e-06,
  -9.028290417158467044e-06, 4.299996760864433138e-06,
   5.274766537152332034e-06, 8.495695261633270096e-06,
  -3.926149325717480609e-05, 7.650826570823408468e-06,
  -1.467676602346261627e-05, 5.817725104448072442e-05,
  -3.878483402965382531e-05,-9.784510682308383180e-06,
  -4.872985444477907069e-05,-1.119827155371068059e-05,
   6.719738582582500954e-06,-2.923773440918006757e-05,
  -1.074323135598393320e-04, 3.644973223539239664e-04,
  -2.494507259075087638e-04,-7.330985843811806059e-05,
   4.747834113810858779e-05,-9.888608633790566590e-04,
   7.459122328714704216e-04, 7.819808727006908645e-05,
  -1.485439134711452191e-05,-1.339205203494853919e-05,
   2.751482678438987417e-05,-1.195551366629730555e-05,
   2.403310868298924922e-05,-1.795577029903275057e-05,
   3.427375811407171306e-06, 9.394311845333911903e-06,
  -2.618847726961987278e-05,-1.463433149476269463e-05,
   9.410601799704083870e-06,-3.382391722939002350e-06,
  -7.554679901557598931e-06,-1.851828317055881384e-05,
  -3.678766836065643164e-06,-1.965875567185938730e-05,
   6.924993911556740587e-06,-2.918980060440465188e-05,
  -3.118474533693250440e-06, 2.983747838847490018e-05,
  -4.397525807373157772e-06, 8.981189607924280419e-06,
  -9.632988119425348316e-06,-2.684313672246614396e-06,
   6.499851581988391553e-06,-2.928740223051752865e-05,
  -1.471173047759226536e-05,-2.614507575729477321e-05,
  -1.761499957891360282e-05,-9.471630790675574174e-06,
  -8.616597534300085521e-06, 5.074864227927059180e-06,
  -2.238501794902970775e-06, 3.993731475342598058e-05,
   4.037404986410814627e-05,-2.949467913998233851e-05,
   9.725145470638423397e-06,-2.328421262340855653e-06,
  -4.384718759943262344e-06, 8.987449103956118564e-06,
   1.573146435229195143e-05,-1.234994045866487949e-05,
   3.998767914616793314e-06,-9.165689017473333493e-06,
   1.249201353153031045e-05, 1.561888593748170318e-05,
   1.583078242380091242e-05, 2.548305962497981222e-05,
   6.570742111005202068e-06, 7.538258957522148781e-06,
   7.416243696634323851e-06, 1.857415756991772092e-05,
  -2.754742827172266696e-05, 1.188020183390394633e-05,
  -1.188020183390394124e-05,-2.754742827172267035e-05,
  -1.945344014624576968e-05, 4.643669505513226502e-06,
   1.907238074556282084e-05,-6.020323304963331021e-06,
  -3.058976496604784629e-06, 3.988286176784735111e-05,
  -2.991214632588550825e-05,-2.294232372453612930e-06,
  -6.757739795143234911e-07, 9.977140348246655129e-06,
   9.748276533147201423e-06, 2.229597415071065905e-06,
  -1.802431582685990909e-06, 4.996750184259501806e-05,
  -3.997400348737244641e-05,-1.441889451912138940e-06,
  -7.267291964463216840e-06, 1.863294038801306243e-05,
   1.734990770534691759e-05, 9.948904593770299155e-06,
  -3.272792615923788349e-06, 9.449276612162158282e-06,
   1.240154626657341048e-05,-1.569081419805993247e-05,
   1.806533235314320745e-06,-1.991824384000017443e-05,
  -5.890169766313145295e-06,-8.081206600750321300e-06,
   4.874815087772928419e-05,-1.111835356526053224e-05,
   5.921275923675120379e-06, 8.058442246222613747e-06,
   9.686794263127554896e-06, 2.483146573168628861e-06,
  -6.410929382676582776e-06,-1.894465582823647162e-05,
  -9.957011500658153919e-05, 1.252429327250688840e-04,
  -8.554052497290794295e-05,-6.915792497869865864e-05,
  -2.185832094954690046e-05,-3.349945977574264410e-05,
  -2.154770375295448799e-06,-9.765089074337680560e-06,
   9.562654798953618997e-06, 2.925001401033737587e-06,
  -2.399569420636548796e-05, 1.800573962809075577e-05,
  -1.800554697773016640e-05,-2.399583876493489428e-05,
   1.078508995413683400e-05, 3.851859076707216302e-05,
  -7.196160652642864504e-04, 2.350996838675487374e-05,
  -1.460371351638000687e-05,-4.597681280292616104e-04,
  -5.651688677514734231e-06, 8.249752426130844770e-06,
  -4.323877548309118925e-05, 3.069697188563113720e-04,
  -1.979909005843695502e-04,-2.827725739512754115e-05,
  -3.523085497531157676e-04, 1.894166987645396697e-04,
  -6.192282846393225705e-05,-1.143046950699157357e-04,
  -6.927208572364851505e-06, 5.959877332122662903e-05,
  -5.536852976560313963e-05,-8.327260000501677921e-05,
   4.389454908366606425e-05,-2.394302739299337523e-05,
   4.871199946130149643e-05, 1.127568660801474008e-05,
  -1.127561009137108890e-05, 4.871201717304848925e-05,
  -8.192550243165710300e-06, 1.824505742696376040e-05,
  -2.872278784741042574e-05, 5.267828260557335534e-05,
  -2.633914130278667767e-05,-1.436139392370521118e-05,
   3.912950777385810076e-05, 8.299495248241221885e-06,
  -5.301171807437758503e-03, 2.497434176915797749e-03,
  -1.837996543888943375e-03,-3.876321542990506571e-03,
  -3.757789820898948196e-05,-1.139644750182916642e-04,
   6.671792307556114268e-05,-2.118298233213408463e-05,
  -5.227599183164896644e-05,-6.055758150733375739e-05,
   3.784576825367081131e-05,-3.267564575168244070e-05,
  -1.847226135699917208e-05, 7.666522051016040943e-06,
  -1.010225066559316013e-05, 4.896881182435942149e-05,
   1.750374157049089732e-02, 4.949255603974083047e-03,
  -4.370564545535977029e-03, 1.506898356072179992e-02,
   1.043991254667929180e-05,-1.195450050232868891e-04,
   7.967146893717781567e-05, 7.242723064725795365e-06,
   2.999988276069356905e-05, 8.387099999853063316e-08,
   3.558746978688421566e-05,-3.512167413674358453e-05,
   3.512165550318312385e-05, 3.558748817654495440e-05,
   8.081027401637983504e-06,-5.890415616403996883e-06,
   2.951715058057058505e-06, 1.978098526909211635e-05,
   1.090807179367305859e-05, 1.676347129159334556e-05,
   1.686739424486313795e-05, 1.074667443390549417e-05,
   1.929333729174167080e-06, 2.993789690946027413e-05,
  -2.492084838387836912e-05,-1.670183570233364716e-05,
   9.537425277879269802e-06,-1.757946299148155443e-05,
  -1.729359208259361147e-05, 2.451390774399005601e-05,
   6.620854454729903111e-05,-2.272506609293619814e-05,
   1.183325622041775142e-05, 6.899256515902234331e-05,
   9.139361968499283284e-01, 6.865345242502295386e-01,
  -6.358625909397380704e-01, 8.464776756910977751e-01,
  -8.366468920091053862e-05,-7.141582304304169913e-05,
   6.492544013742857108e-05,-7.605713130904413017e-05,
   1.310203566274705585e-04,-1.234247388055183801e-04,
   1.958578284704913172e-03, 1.147550043650541734e-03,
   2.277331634558848507e-05,-4.451265059085734093e-05,
  -3.424407338391369801e-06, 1.970465514493393547e-05,
   2.285442237995093939e-05, 1.075996067728818420e-04,
  -9.781784972249626584e-05, 2.077662811110452584e-05,
   1.978769390335329394e-05, 2.906401552985235634e-06,
  -8.001167429019729249e-04, 4.334895589606952847e-04,
  -4.001466574577633483e-04,-7.385679742077769271e-04,
  -2.981442303042500667e-05, 1.876462101385553455e-04,
  -1.678934234098798976e-04,-2.667954976589374862e-05,
  -4.726266758896837506e-05, 1.631687017704923308e-05,
  -1.631062562369145803e-05,-4.726482298458103721e-05,
  -2.307905735994639381e-04,-6.584611710367150607e-05,
   6.035942068814458071e-05,-2.115578888488717777e-04,
  -6.592834480482493364e-05,-2.618271440307442664e-04,
   2.424325407692076782e-04,-6.104476370817124087e-05,
  -2.928096489935948623e-05,-6.528789670565112509e-06,
   3.073158175607983383e-06,-2.984217986052114689e-05,
  -4.004610830908272336e-03,-2.096065860838383470e-03,
   1.865995194852874354e-03,-3.874023997445805948e-03,
   2.286397012741962830e-05,-4.446615420758201075e-05,
   3.557292336606560589e-05, 1.829117610193569857e-05,
  -9.159042561376427175e-07,-1.997901697765906164e-05,
   3.499753097781076549e-06,-9.367589244548022110e-06,
  -4.888003126970788515e-05, 1.052342829463760855e-05,
  -1.052297614192087690e-05,-4.888012861190694477e-05,
  -7.171975485047926834e-06,-6.968699135554036433e-06,
   1.265508367105455139e-06,-9.919601230532712024e-06,
  -3.083855356692753849e-05,-2.547515679833474217e-05,
   2.591333183503405761e-05,-3.047128538817177394e-05,
  -1.338733201136192098e-05, 4.817446773569548148e-05,
   1.879783892856902870e-05, 6.829440066035784246e-06,
  -8.835585635572802891e-06,-1.794247548351284865e-05,
   1.794247548351283171e-05,-8.835585635572836772e-06,
   8.323714832404674271e-06, 3.912436288796031588e-05,
  -1.956077332582550443e-05, 4.168470570325948184e-06,
   1.987960975601151841e-05, 2.191144894499602568e-06,
   1.772559798818654976e-05, 9.263000375752825373e-06,
  -1.578364529801779014e-04, 8.758924900412356400e-04,
  -5.611252379038896140e-04,-1.001921523239382721e-04,
   1.967720864623148528e-05, 3.578751163838147913e-06,
   1.644214934384883420e-05,-1.138664678272631047e-05,
   1.138664678272628336e-05, 1.644214934384885114e-05,
   2.700821796026801473e-05,-1.305971525764081457e-05,
   5.621270697644070912e-06,-2.946864971022269462e-05,
   2.965976771305174552e-05, 5.215647782594040881e-05,
  -5.215647782594040881e-05, 2.965976771305174891e-05,
   2.635951376430459406e-05,-1.432396712190574254e-05,
   1.432203943093045928e-05, 2.636056119544637411e-05,
   2.279284033443449879e-05, 1.950606135253798185e-05,
  -1.885512738593870968e-05,-6.669645512321036905e-06,
  -3.962302511700395392e-04, 3.668808908320620181e-04,
  -2.375495406737085618e-04,-2.570412724169215480e-04,
   1.941063891591841405e-04, 1.035505175630878696e-04,
  -7.057615319629760369e-05, 1.323593842536777837e-04,
   6.113136801251535361e-05,-1.904283483227180000e-04,
   1.422990366702398164e-04, 4.744453775432676740e-05,
  -1.360118370033127494e-02, 3.317800770064840542e-03,
  -2.685964588581779555e-03,-1.095554627706371922e-02,
  -3.179780312072390334e-05,-3.184162365783122471e-04,
   2.381573003122926561e-04,-2.968333384174448467e-05,
  -8.248808708555113573e-06, 5.653065972520162876e-06,
   3.122417179310395090e-05, 2.500102189580921834e-05,
  -2.500102189580926917e-05, 3.122417179310391024e-05,
   6.993609566259408690e-05,-3.884510938937473353e-05,
   3.120937575717816552e-05, 8.441548948414182854e-05,
  -5.281639732224298334e-02,-2.288190931497990216e-02,
   1.834522115034491543e-02,-4.228168588106365200e-02,
  -3.055968652910999407e-04, 1.706181582489194330e-04,
  -1.130305952105518192e-04,-2.117169916335209605e-04,
   2.749499818736261868e-05, 1.200104473272749374e-05,
   5.568423861472950807e-05,-9.486445893957267024e-05,
  -9.013994184900704854e-06,-4.329885545205127889e-06,
  -8.277363164275035345e-06,-5.611172697993065783e-06,
  -1.239959977056842718e-04,-3.905115302999303807e-05,
  -6.508864067076600244e-05,-2.575788919208841000e-05,
  -9.642033796413694658e-06,-2.651638035029692910e-06,
   1.194509224471001395e-05,-1.604103398367351862e-05,
  -5.957558651324791788e-06,-8.031655801640478646e-06,
   1.775805433516399777e-05, 9.200625317301169221e-06,
   9.986006313643042964e-06,-5.288458224107531817e-07,
   2.927176265001581377e-05,-6.569924760690893871e-06,
  -5.879495356882045607e-05,-1.196467445609145125e-05,
   2.537195636685064029e-06,-2.989251809903585596e-05,
  -1.988708351972879961e-05,-2.122241522384109793e-06,
  -1.850030018880596453e-05,-7.598611249699911811e-06,
  -2.271531753418188284e-05,-1.959628406921294622e-05,
   9.731483441297492676e-06, 2.301788442006069341e-06,
  -2.523803036208816792e-06, 9.676281219271336585e-06,
   6.080099636258372556e-06,-1.905340883971083340e-05,
  -2.408329766049942827e-05, 1.788839774255321011e-05,
  -1.669711314468268570e-05, 2.492401277149537578e-05,
   2.802918882612974935e-05, 1.069413735413769495e-05,
  -5.331852741002681838e-05,-2.751607956861259230e-05,
  -4.494959658123175678e-06, 8.932823611369766770e-06,
   2.980053970081784586e-05,-3.453669575969793355e-06,
  -3.399519940002072409e-06,-2.980676540950943695e-05,
  -4.706127728970908477e-06,-3.972218979108039073e-05,
   5.115789307952321332e-06,-8.592362873892182761e-06,
  -1.915979204695622743e-05,-5.736058639640375979e-06,
  -7.023016854249146987e-06,-7.118794439013703488e-06,
  -6.421163854201018698e-06,-2.930475481483341856e-05,
   3.140387471779327919e-06,-9.494101670357836477e-06,
   2.852672312418280453e-05, 9.285799254572229348e-06,
  -9.285799254572227654e-06, 2.852672312418280453e-05,
  -1.164581581669439268e-05,-1.625961174086364153e-05,
   2.009807374073451302e-05, 3.458420783987972604e-05,
  -3.458419030098853570e-05, 2.009810392114168748e-05,
  -1.367322785576134767e-05, 1.459598711990497769e-05,
   1.760079911676674087e-05,-9.497992969634333406e-06,
   2.568794003336914797e-06, 9.664434663673831033e-06,
  -9.060185998125202815e-06, 4.232378725891154184e-06,
   2.888351955842507216e-05,-8.108162425486822129e-06,
   2.866492716212737665e-06, 6.994128408535189520e-05,
  -4.995375496155550515e-05, 2.149968660438869353e-06,
  -7.642174719883503386e-06, 6.449586463547372773e-06,
   4.249114633423702205e-05, 4.236156846957459172e-05,
  -4.236156846957459850e-05, 4.249114633423700850e-05,
   1.240752533684242234e-05, 1.568608666989996432e-05,
  -3.473384479126445022e-05, 9.893904992600325524e-04,
  -6.295667684776749644e-04,-2.335988074836006841e-05,
   5.605626793088796426e-06,-1.919835795729950124e-05,
  -4.414459015888605751e-05,-6.671772747706550396e-05,
   6.671437574704739369e-05,-4.414965536311439700e-05,
   9.999831563650187356e-06,-5.804049125808827544e-08,
  -2.385063276405210335e-04,-2.673446605848778755e-05,
   6.083909262010068923e-06,-9.981475866870404847e-05,
   4.398975837393034020e-05, 2.376764940424748709e-05,
  -2.376764940424748709e-05, 4.398975837393034020e-05,
  -8.307635713234915419e-05,-5.566254472819564587e-05,
   5.009629025537607925e-05,-7.476872141911423877e-05,
  -8.608152038179939670e-05,-6.848336913994415858e-05,
   4.372900675335137841e-05,-5.466053391950493018e-05,
   3.664984996990028386e-05, 1.602462159253067995e-05,
   4.515240152814044772e-06, 3.974434055764941381e-05,
  -4.643331734426893107e-03,-9.524024380817930433e-04,
   6.933693201761306118e-04,-3.410225650281589662e-03,
  -9.397257882156934990e-06, 1.765478814079170529e-05,
  -1.247697209420178773e-05, 3.800427827706388530e-05,
  -1.900214022735288415e-05,-6.238482730601838401e-06,
   8.613983278635468400e-05,-1.348329678066119636e-04,
   1.264059073186986955e-04, 8.075609323720750270e-05,
  -4.284578767240308517e-05, 2.577282442285578856e-05,
  -2.097529966555753710e-05,-3.405931302801132863e-05,
   1.540283413305614069e-05,-1.275745666931935057e-05,
   5.071721976269438509e-04, 2.601468084644824796e-04,
  -1.236684118104655660e-04, 2.400127578281560821e-04,
  -2.649507622736793001e-05, 1.170385019372085258e-04,
  -7.802759735158784854e-05,-1.765485914807823935e-05,
   2.547551720276641503e-04, 5.542560800975981916e-04,
  -2.816071641578325800e-04, 1.296048035181703094e-04,
   1.111564172434766767e-02,-4.985588138881852371e-02,
   4.260892693926259661e-02, 9.522339265358158514e-03,
  -9.301824376817352007e-06, 2.852150177081926453e-05,
   1.137061462934064782e-04, 3.835247443258968527e-05,
   1.109143473289311113e-05,-1.094393899634221024e-04,
  -7.308932934460143929e-07, 9.973253982206391454e-06,
   2.154387062449803235e-05,-2.087729959824523681e-05,
  -1.657750921667114959e-05, 1.118866337732900088e-05,
  -1.118866337732897208e-05,-1.657750921667116653e-05,
  -2.940585557913239450e-06,-1.978264281072152658e-05,
   1.245386631413945962e-05, 1.564931991587949184e-05,
  -7.370200279991734153e-03,-1.069674005633537706e-02,
   1.005858464273601087e-02,-6.974415745058164771e-03,
  -1.601400288305053810e-05,-2.536832102567391402e-05,
   2.632116997954719612e-05, 3.011969473463806099e-05,
   4.905709978801528855e-05,-3.454563590945621172e-05,
  -1.909521662303841167e-05,-2.313812226865519979e-05,
  -3.998711647740674176e-05, 1.015143252110899708e-06,
  -5.958956623247344549e-07,-2.999408122212818612e-05,
   1.798100827656899192e-04, 8.266446382560624923e-06,
  -7.801424242246129162e-06, 1.598096923837615587e-04,
   1.588545419352020778e-05, 1.215122812992873149e-05,
   1.267638273544046638e-07, 9.999196514324261759e-06,
   2.122338148357988310e-03, 2.932589433252528240e-03,
  -2.697647331726174373e-03, 1.952331650522178084e-03,
   2.372197047985837324e-05,-1.836486091841503770e-05,
  -3.437190821937465940e-05,-3.631214570028718332e-05,
   3.630597811333193176e-05,-3.437842278572801228e-05,
   1.614034921680639537e-06, 9.868885006503793703e-06,
   1.792055504853069586e-04,-4.236571381143696855e-04,
   3.868186149358723868e-04, 1.636195561022376298e-04,
   1.806131364705279327e-05, 3.569018001275399654e-05,
  -2.607047870822330239e-05, 1.484352181674131624e-05,
   2.623389461288155804e-05, 1.455275827601846667e-05,
  -2.147157788505395229e-05, 2.095164296961128566e-05,
  -6.941317074261529504e-07,-4.999518157955570413e-05,
   4.999518157955570413e-05,-6.941317074261560208e-07,
   9.878735686526442865e-06,-1.552604661769676856e-06,
   1.483442674524679971e-05,-2.607565498966241550e-05,
   2.607565498966244260e-05, 1.483442674524675059e-05,
   5.635595002789025763e-05,-7.017126831156707256e-05,
   6.236915331975387766e-05, 5.010078556447029001e-05,
  -1.551516440734901174e-04, 9.125769743584946701e-05,
  -1.117257038369008220e-04,-1.536794296649656789e-04,
   2.744111316745725438e-05, 1.212374975536876408e-05,
  -1.212374975536871495e-05, 2.744111316745727471e-05,
   2.835395402161349315e-05,-9.800678106142864834e-06,
   1.047415778876955472e-04,-3.360359893814662710e-05,
   2.011482823927439266e-05, 6.704769708874786037e-05,
   1.143115137524466826e-05,-2.773677663745811013e-05,
  -2.584314205432367017e-05,-1.523587899532046669e-05,
   1.015725266354694617e-05,-1.722876136954913152e-05,
   4.626363818419291595e-06, 8.865481251439251737e-06,
  -2.197597189704326324e-06,-9.755540302402714934e-06,
   1.464736722394412421e-04,-8.628709834438020177e-05,
   5.565760592125400686e-05, 9.488008696831170218e-05,
  -2.885603926464343975e-05, 4.083294010914908850e-05,
  -4.082869404189814713e-05,-2.886204675405178077e-05,
   2.135706527100167623e-05, 2.106835928614694123e-05,
   4.233762170026865990e-06,-2.969975181525343229e-05,
   1.927190797829481068e-05, 5.347294912022048054e-06,
   9.395076128082225579e-06,-3.425280214455383189e-06,
  -9.733196340150534803e-06,-2.294534594221722873e-06,
   1.971801057454360072e-05, 2.260973372205402361e-05,
  -2.260973372205402022e-05, 1.971801057454360072e-05,
  -5.009020882448089713e-05,-4.889755597082429963e-05,
   3.486893041646330099e-05,-3.583514603865653491e-05,
  -2.812283827712272084e-05,-1.044538018641740163e-05,
   1.243140746894206971e-05,-1.566716657028741032e-05,
   6.170688236171743206e-05,-7.869091859418828462e-05,
   7.082182673476946158e-05, 5.553619412554568750e-05,
   1.733466918370686079e-05, 9.975432035327779390e-06,
  -6.441751727767912241e-06,-1.893419749231002393e-05,
  -2.398575997215415833e-05, 1.801897107379351589e-05,
  -9.735533816548084591e-06, 2.284596530429106489e-06,
   1.412663474035439499e-05, 1.415761953552264221e-05,
  -7.299597354021047810e-06, 1.862030822701839642e-05,
   2.593582360395340345e-05,-1.507756790681486317e-05,
   1.507756790681487673e-05, 2.593582360395339667e-05,
   1.577642392845945759e-05, 4.744580537865842121e-05,
  -4.174205184503483108e-05, 2.752455463338915567e-05,
  -3.686240088486548120e-06,-9.295785819931239372e-06,
  -1.949574475187211675e-05,-4.462727481019977815e-06,
  -1.887933461132736140e-05,-2.331460324846933277e-05,
  -2.987700748398196585e-05, 2.713747188314637616e-06,
  -2.605592765067050280e-05, 1.486904954134676120e-05,
  -1.486904954134676289e-05,-2.605592765067050280e-05,
  -8.267978797433487250e-06,-3.913617925405072978e-05,
  -9.876354141350735576e-06, 1.567682644741655036e-06,
   6.937376663923057124e-06,-7.202277766294203003e-06,
   5.680353135373670070e-06,-1.917638100000755173e-05,
  -1.424339495860864018e-05, 1.404014601252715020e-05,
  -3.001884719437510467e-06,-9.538799092716419340e-06,
  -3.109647809103702186e-06,-1.975677328167068264e-05,
   5.774729962411242129e-06,-8.164097859606404722e-06,
   1.632484080431005150e-05, 1.155420151780007995e-05,
  -8.193683055094732215e-06,-5.732674593298792387e-06,
  -3.505931696870659620e-05, 1.925731792560328901e-05,
   1.784984736597504710e-05,-9.021249858605717852e-06,
   2.862164528344960483e-05,-8.988961078366459789e-06,
  -3.570089125721374261e-05,-1.804013202392376237e-05,
   1.353009901794281924e-05,-2.677566844291030695e-05,
  -4.416003131891689556e-06, 8.972118832200274752e-06,
   9.744475825155749367e-06, 2.246150238286653203e-06,
  -1.067557683884570391e-05, 1.691248234760057842e-05,
   1.301811370545101411e-06, 2.997174147685648817e-05,
  -2.540732442497492424e-05,-1.595204894563932257e-05,
   4.669427530252931923e-06, 8.842875467839406809e-06,
   2.793375864961156695e-04,-1.561105786630909902e-04,
   1.072544542289050317e-04, 1.920845700415827839e-04,
  -1.546314206043372652e-04, 4.332310281615163179e-04,
  -2.732371359231710066e-04,-1.238606779914535846e-04,
  -8.986162018276309461e-05, 4.988909512992423175e-06,
  -5.031624622398211349e-06,-5.978865070947224423e-05,
  -1.338586762799592433e-04, 8.764619093022285210e-05,
  -6.204147701243864759e-05,-9.083421783730538201e-05,
   3.966679970406737643e-02,-3.475705110099820694e-02,
   2.819613565840732236e-02, 3.222623673240005565e-02,
   3.174680387725997179e-04, 4.017517091288016280e-05,
  -2.504436543865807310e-05, 2.286324118749897508e-04,
  -2.575699207096383316e-05, 1.538107146645857902e-05,
   6.634018741566412921e-05, 8.774382903460823248e-05,
   9.401783520720360720e-06, 3.406826474816568813e-06,
  -7.070969636909427204e-06,-3.937005700267533670e-05,
  -1.961252264524920697e-05, 3.917774303043382970e-06,
   7.872555088594997814e-05,-9.056648186665805251e-05,
  -1.782693382561310758e-06, 1.992039167044092507e-05,
  -1.092456948907590786e-05,-1.675272459865415105e-05,
  -8.569896556982590933e-06, 1.807088467681142703e-05,
  -1.914000861547765473e-05, 5.801729931618773787e-06,
   9.243186380131625541e-06, 3.816216128857122002e-06,
  -2.004336400038575584e-05,-2.232181801619304349e-05,
   3.733059229063110949e-07,-1.999651576370051277e-05,
   9.999900653802640271e-06,-4.457481438610742304e-08,
   1.952373290137317537e-05,-2.277770518721845648e-05,
   1.032061193110407843e-05, 1.713140301807041611e-05,
  -8.328758761011886838e-06, 5.534598223978661372e-06,
   1.226342132813387488e-05, 1.579900304856832427e-05,
  -2.313294228327271858e-05,-3.263229966335154858e-05,
  -2.989295865091171964e-05,-2.531999821264241828e-06,
  -9.417799265525767796e-06, 3.362299361190543545e-06,
  -3.882273888534201885e-05, 9.633013310514670064e-06,
  -1.919225178818352923e-05,-5.626497249529785985e-06,
  -8.600860151539025585e-06, 5.101490434536569130e-06,
   2.386146847949423256e-05, 1.818324289014759906e-05,
   8.548219347970473326e-06, 5.938794444985432758e-05,
   3.858475719055335921e-06, 9.225625459851512426e-06,
   1.388479569791535419e-05, 1.439487576977138582e-05,
  -4.755275817177936074e-05,-1.545105790087757900e-05,
   7.497838147006107973e-06,-1.898520013671736381e-04,
   1.336219997726962410e-05,-1.488125034287965113e-05,
   8.365501822152464909e-06,-5.478903107699916572e-06,
   6.337731302152339457e-06,-3.949472321642118986e-05,
  -6.812573132302847474e-06,-1.880395828853663028e-05,
  -2.846146391200797112e-05,-9.483937578109000960e-06,
   9.984629760182253157e-06, 5.542278882218877670e-07,
  -5.708558433715272732e-05, 1.847257591365708088e-05,
  -4.475805455791669751e-05, 2.228713871699444281e-05,
   9.673663939240363357e-06,-2.533816487167262301e-06,
   1.515487795723041914e-05,-1.305104111178306143e-05,
  -5.368560822884747211e-06,-8.436738391759404928e-06,
  -1.664032952047557267e-05, 6.799337786468611234e-05,
  -5.828003816973096408e-05,-1.426313958897906156e-05,
  -2.287351009299559937e-06, 2.991267332353055161e-05,
  -1.994178221568703666e-05,-1.524900672866377173e-06,
  -7.476585812311830426e-06, 2.905341055007376291e-05,
  -1.936894036671584645e-05,-4.984390541541210402e-06,
  -9.634887950479140685e-06,-2.677486541835806771e-06,
   1.350367419879620312e-05,-2.678900489254436101e-05,
   8.952319467562601217e-06, 4.456004505237811192e-06,
  -9.570873839665152734e-06,-2.897994814559412393e-06,
   1.033246557226981876e-05,-2.816451943843279812e-05,
  -3.402078067424565608e-05, 2.103773947730301177e-05,
  -2.103265059334964170e-05,-3.402392700759377758e-05,
   2.225300814817066414e-05,-2.011973231326525646e-05,
  -5.899099642426886307e-05,-1.095729623912298634e-05,
   1.096275300395419296e-05,-5.898998259513468654e-05,
  -1.979739346591874991e-04,-2.839579538522843269e-05,
   1.773367328479645344e-05,-1.287847694093835417e-04,
  -3.680585567920507440e-05,-1.566298144420556201e-05,
   1.566090652104696850e-05,-3.680673860774720871e-05,
   2.974499194254463585e-05, 3.903262012465311004e-06,
   4.999851932917998611e-05,-3.847920082531654670e-07,
   3.606285963447085908e-07, 4.999869945324076742e-05,
  -5.277366562719467021e-05,-2.854715776165907593e-05,
   2.378485383012638783e-05,-4.398045848191583297e-05,
   7.670134155660890646e-06,-3.925772588974257474e-05,
   3.925772588974256119e-05, 7.670134155660958408e-06,
  -1.031874949708862178e-04, 7.907174515358396686e-05,
  -7.298817276385115781e-05,-9.525086160552153269e-05,
  -1.104902011484650050e-05,-1.667090742886293787e-05,
   1.631172199760239723e-05, 1.157271469763832447e-05,
  -1.157271469763829398e-05, 1.631172199760242095e-05,
  -9.206240665764877176e-06, 1.775514384070197205e-05,
   2.701539754530931910e-05,-1.304485705053510044e-05,
   2.074940580736578982e-05,-2.166707545196755095e-05,
   2.837226037035971482e-05,-4.117055794468318551e-05,
   4.117055794468313807e-05, 2.837226037035978597e-05,
   1.359435127993980571e-05, 1.466947897089733194e-05,
  -2.351075571090482762e-05, 1.863449398030856376e-05,
  -6.971827210716781094e-05,-6.273956836869901252e-06,
  -7.281611553167737684e-06,-6.854059613745283199e-06,
  -1.818735009154008857e-05, 8.319873595659783388e-06,
  -6.628136036977423689e-07, 9.978009727733944982e-06,
   2.871991738852338341e-05,-6.383702957685602529e-05,
   4.556442699574258967e-05, 2.058841889387439457e-05,
  -1.431084232523202389e-05,-2.636664165081225737e-05,
  -3.684581006645223466e-04,-6.874871839203205688e-04,
   3.877079958483347234e-04,-2.080444903266310522e-04,
  -8.374380103355755697e-06,-2.880746010818238274e-05,
  -2.694242449352843969e-05,-2.956527967752916472e-05,
   1.287714954796945735e-05,-1.530290885809721079e-05,
   4.999687355890710945e-05,-5.591371340336014751e-07,
  -7.527296000691396753e-03,-1.340062367645533485e-02,
   9.062236097116104644e-03,-5.082123268883378259e-03,
  -1.160459870759839521e-05,-2.766465775742771901e-05,
  -1.167248225844134934e-05,-1.624047899313231513e-05,
   1.815181980228188922e-05,-8.397108899227589943e-06,
  -6.978486064007828225e-05, 5.483906039024805056e-06,
  -5.483906039024685624e-06,-6.978486064007828225e-05,
  -3.371003672157819875e-05,-3.692740749402602439e-05,
   3.439230881167050881e-05,-1.357098710286126786e-04,
   7.754471637944990322e-05, 1.966766284108701734e-05,
  -1.146416585864863807e-01,-1.773535523087696464e-01,
   1.322839763947647462e-01,-8.550058297572785126e-02,
  -2.671377853175137168e-05,-5.372498521690387090e-05,
   3.581672830163395863e-04,-1.780904191041542920e-04,
  -2.859360124123067320e-04,-3.474774766884166657e-04,
   6.179860797988007072e-05,-5.080287444376650719e-05,
   5.775752897487221352e-06,-3.958081199858295290e-05,
   4.999203290493346252e-05,-8.925502966500883077e-07,
  -9.111707668033337324e-06, 4.120289234058999106e-06,
   5.899160447474675125e-06,-8.074645875513700307e-06,
  -5.898141771235633897e-06, 1.911051866502857093e-05,
   3.662732813504181639e-05, 1.607603289645721548e-05,
  -3.495552605602436386e-05, 1.944508159269592873e-05,
  -9.314617574724026980e-06,-1.769852817147918417e-05,
   2.737687770610977781e-05,-4.183905552309599880e-05,
   2.510339317718364457e-05, 1.642618796287591393e-05,
  -1.526730656661079476e-04, 7.477255526001701051e-05,
  -5.210449802463980573e-05,-9.687683565022294082e-05,
  -7.687787660083142242e-05,-6.395148230766301706e-05,
   3.837088938459778855e-05,-4.612672596049887378e-05,
  -1.394865806918257859e-06,-1.995129944090585724e-05,
   2.979108928526897032e-05,-3.534260770957975607e-06,
   5.298877318001411671e-07, 2.999531995148055889e-05,
  -2.999531995148056228e-05, 5.298877318000898157e-07,
   4.906836126179703951e-05, 9.607076718845109682e-06,
  -1.013938027522740334e-05, 4.896113731965720598e-05,
   1.141287948806588789e-05,-1.642395146701563371e-05,
  -1.263798827514470275e-05, 1.193326495656461329e-04,
  -8.944252438382272949e-05,-1.000174144083309319e-05,
   4.099659681441015823e-06, 9.121008195170475310e-06,
  -5.289488691717293592e-05, 4.584900149424724536e-05,
  -1.798756555707500376e-05,-2.400932080109575051e-05,
   4.785858647106565529e-05, 5.108381055668743514e-05,
  -4.651640647588870079e-05, 5.230892780940839807e-05,
   1.944319845676680447e-05,-2.284648843412879972e-05,
   1.531751812503123761e-05,-1.285976821289324663e-05,
   1.285976821289324832e-05, 1.531751812503123761e-05,
  -9.163353918484510606e-06, 4.004116002889348748e-06,
   5.947901143113950011e-05,-1.042221051369352153e-04,
   6.093965225718700311e-05, 3.444355938013843023e-05,
  -1.714891386844808821e-06,-9.851860105143875408e-06,
   7.753332006022474715e-05,-1.971254119688154328e-05,
   1.970444888347342805e-05, 7.753537704943843333e-05,
  -7.157249315551882741e-06, 6.983822895451467387e-06,
  -1.056086909395499956e-05,-1.698434702837722113e-05,
   1.698434702837724146e-05,-1.056086909395497076e-05,
  -7.985582830338410003e-06, 1.833658820118411509e-05,
  -3.964261872681522780e-06,-9.180665978283034445e-06,
   1.807455052187847069e-05, 8.562162310541817988e-06,
   2.529957659830633202e-05, 1.612238890321253336e-05,
   1.522831334097986218e-05,-1.296527951063666023e-05,
   3.038357922038608476e-05, 6.306217657010041941e-05,
  -4.516371302921926700e-05, 2.145318217454767688e-05,
  -3.575211935389718034e-05, 1.793839350958415386e-05,
  -1.345379513218806965e-05,-2.681408951542290728e-05,
  -1.221154646555217166e-05, 2.740215562541860141e-05,
   9.230197479464575562e-05,-3.847525762108137552e-05,
   3.463501010372313185e-05, 8.306874306930974892e-05,
   3.944630474585155864e-04, 9.080192201653778262e-04,
  -5.773293331034784091e-04, 2.521722449800788092e-04,
   6.344224212253617926e-05,-6.383636827440527812e-05,
   5.674423569919481209e-05, 5.639230191182326466e-05,
   7.860326811414257452e-06,-6.181849433443214971e-06,
  -8.972440427897709301e-06, 2.862682854889494609e-05,
  -9.613990858010518733e-06,-2.751577689633745294e-06,
   9.807527993781980732e-06,-1.952535441722586515e-06,
  -3.402122698116597101e-05,-7.240549782092507605e-05,
   6.335481059330942460e-05,-2.976857360852022379e-05,
  -6.416271816718532080e-05, 4.778227283625537624e-05,
  -3.865619294696260357e-05,-4.588789324916975668e-05,
   3.998608217725912426e-05,-1.055098153481817369e-06,
   9.942903013453575919e-06, 1.067089342583741018e-06,
   9.178686730810806864e-06, 3.968842387603422604e-06,
   1.509121016182768369e-05, 1.312460955044183251e-05,
   7.690481130042069000e-07, 9.970384395793608576e-06,
  -9.585733112452581625e-05,-2.848459354954914098e-05,
  -6.328059440417699245e-05, 2.992601496781759521e-05,
  -2.992601496781759860e-05,-6.328059440417699245e-05,
   7.267234118828160155e-06, 6.869301875892476848e-06,
   1.616184478489570125e-04, 5.272074842881092715e-05,
  -3.952067112912081132e-05, 1.133054127281829293e-04,
   8.677962415855718569e-05,-2.385994197183974246e-05,
   1.420906464874148303e-05, 5.829324559336085978e-05,
   2.888098204434990063e-04, 3.580347575521039679e-04,
  -2.175875192163181221e-04, 2.065324949766703761e-04,
  -3.168594619552287457e-04,-4.472226927877159293e-05,
   3.070192352734515685e-05,-2.178471755422159526e-04,
   3.624321553691139930e-04,-1.185851142747055848e-03,
   9.772027532452592837e-04, 3.255376768515206697e-04,
   1.553034064890132464e-05,-1.260192522311901418e-05,
   6.999034932887847557e-06, 7.142374255681063513e-06,
  -2.723565444873227005e-05, 1.257851846400243183e-05,
   6.624858043869177181e-06,-7.490744682512005374e-06,
   8.999484304517138818e-06, 4.359963560942877825e-06,
  -1.339812570967237187e-05,-2.684194902513258765e-05,
   8.381398467636634589e-06, 5.454554035546653533e-06,
   7.937279353536819170e-06, 6.082729359746177261e-06,
   1.491707703686795297e-05, 1.332219248758052215e-05,
  -1.035415251414295652e-05, 1.711115208610650826e-05,
  -1.631373361895325591e-05, 3.652207682224320825e-05,
  -7.817439517171506373e-06, 6.235995461461252256e-06,
   2.183184029043682946e-05, 2.057597505667372001e-05,
   1.654511815684534947e-05, 3.641783993012252449e-05,
   2.778825225539203618e-05,-1.130544278614064155e-05,
   3.133776520462327949e-05,-2.485848893195043944e-05,
  -7.673920884393101499e-06,-1.846918889015095595e-05,
  -7.502267894797428946e-06, 6.611805837643129939e-06,
   2.081319650457782240e-04,-2.794790021062330129e-05,
  -1.712355216792976569e-05, 1.033363252453791534e-05,
  -3.990889505933507776e-05, 2.698165143756100291e-06,
   4.100346802597777931e-06, 1.957516682172661030e-05,
   5.866183007665697307e-06, 1.912035294968621467e-05,
   4.234869224193600451e-06, 1.954650563793892075e-05,
  -2.931975845690839129e-05, 6.352303836290342655e-06,
   7.493415325719251797e-06, 4.943529838846202732e-05,
   2.998327906450315198e-05, 1.001487164234802919e-06,
   2.996876061948027751e-05,-1.368717257978464660e-06,
  -1.480793342739404137e-07,-5.999981727064476105e-05,
  -6.663657801815084348e-05,-2.143750148760099290e-05,
  -9.760545293896455473e-06,-2.175259884656488135e-06,
  -9.402867388817878151e-06,-3.403833848516299076e-06,
  -1.844703007614539574e-05, 7.727035742753311442e-06,
   1.156184497344994345e-05,-1.631942832362428056e-05,
  -1.456415493258561553e-05, 1.370712920708206329e-05,
   3.608186135580782143e-07, 9.993488376343369673e-06,
   2.539485395581299546e-05, 3.090471473032762364e-05,
  -2.242380174069785043e-05, 1.992920258048164089e-05,
  -2.779455701989090743e-05, 1.064305529444812816e-04,
  -6.772809531123772915e-05,-1.768912393285484319e-05,
   3.882101164734161965e-05,-5.824885453532082275e-05,
   4.992758960170353138e-05, 3.327515284057858824e-05,
   2.922843353534111601e-05,-6.760079368627778883e-06,
   1.757705064366321115e-05, 2.431146418194714002e-05,
   2.640263470541678368e-05, 3.004830911403038368e-05,
   4.356202066084975157e-04, 7.064948942450822826e-04,
  -4.431132147148651073e-04, 2.721225439853482706e-04,
   2.004538655494230351e-05, 2.232000174424138167e-05,
  -2.540431748628809298e-05,-1.595683718836151711e-05,
   1.308137705201921409e-05,-1.512870035472000331e-05,
  -2.296831627151351056e-06,-1.986767637335874737e-05,
  -5.309330838076377794e-07,-3.999647622054371338e-05,
   4.783403334937209175e-06, 1.941955335571113483e-05,
   2.989146575130536383e-05,-2.549563734943411811e-06,
   7.833297744851117446e-07, 1.998465397409735243e-05,
   1.757617595027987764e-06,-9.844327320322504327e-06,
  -1.704738762206262171e-07, 9.998546827290770951e-06,
  -8.850558025086845552e-06,-1.793509472081402062e-05,
  -9.994420185090061869e-06, 3.340137180780900835e-07,
   6.720669540738012104e-06,-7.404903843008114256e-06,
  -9.124428201279465351e-06, 1.779732592272491076e-05,
   2.683832619959157208e-05, 1.340538126292260990e-05,
  -3.520090341964997092e-06, 9.359966024746284896e-06,
   1.992147368331877673e-05, 1.770561008504791241e-06,
  -1.514559499052222898e-04, 3.485126902112845970e-04,
  -6.469966521494536853e-05,-2.671990496004779888e-05,
  -2.250917397200380955e-05, 1.983272767669808548e-05,
  -3.255261379159378552e-03, 6.219620032876074615e-03,
  -3.834952488134619076e-03,-2.010482383347362602e-03,
  -2.294325541464513294e-05,-1.932891696340891568e-05,
  -5.550859028783303569e-05, 2.277710263087665243e-05,
  -2.277710263087654401e-05,-5.550859028783308312e-05,
  -4.768715192110426632e-02, 7.527634184558598673e-02,
  -5.137842451640983049e-02,-3.254734849740569674e-02,
  -9.326361764097191077e-06,-2.851348761981224099e-05,
  -1.043498444928961448e-04, 2.161275316897604286e-04,
  -1.801319178207199252e-05,-8.690507569888772916e-06,
   1.040015620230786356e-05, 1.708323010930887483e-05,
   1.999999369855756087e-05, 1.587632381729675359e-08,
  -7.912177635161171422e-06,-4.937000552025142105e-05,
   4.102728521295717298e-05,-2.857904596123995306e-05,
  -5.489176941578515876e-06,-2.949354058949251952e-05,
  -3.833621104234258281e-02, 2.487619188937427103e-02,
  -1.863948255526139478e-02,-2.874573516318735741e-02,
  -1.514504917515529657e-04,-3.265926339466534794e-04,
   1.725288937629052639e-04,-7.958505397967728645e-05,
  -9.971449280675673417e-05, 8.340875208448604984e-05,
  -8.281507639723464757e-05,-3.523724054633378249e-05,
   1.175128729586963159e-05,-2.760266738722787005e-05,
  -7.652013445323856407e-06,-6.437910393332836221e-06,
   7.113766150856685967e-04,-3.199114119709649175e-04,
   1.377547089163074889e-04, 4.493591438608803804e-04,
  -1.927435951527571066e-07,-9.998142322778147184e-06,
   6.095073824868565764e-05, 3.442393799291716959e-05,
  -1.967082171023839230e-05, 3.482899328496323778e-05,
   1.132421851854828584e-04,-6.384518379969473904e-05,
   4.512587142971239942e-05, 7.786947879438430346e-05,
   1.919953169520026149e-05, 6.731551071398774431e-05,
  -3.846600420744932425e-05, 1.097116768227024540e-05,
  -1.483225173078435281e-05, 1.341656843587974320e-05,
   9.944165349573249872e-06, 1.055260868385979586e-06,
   1.930187060282697234e-05, 2.296601382982523464e-05,
   1.386789735355798789e-05, 1.441115619897235900e-05,
   7.057934089519550635e-06,-1.871324574701026760e-05,
   6.273128616107773951e-04, 5.812549920385835523e-05,
  -3.033255829901897136e-05, 4.489765427135771684e-04,
  -1.980143258893092637e-05, 2.253670933002474301e-05,
  -2.253670933002470912e-05,-1.980143258893096703e-05,
  -9.036489726029703758e-06,-4.282739010418405836e-06,
   4.641242464158203829e-05,-1.859803319949367145e-05,
   1.109132630976131030e-05, 2.787440547689576387e-05,
   1.324018843834132175e-04, 2.353077580780567378e-04,
  -1.480266854172327046e-04, 8.359485871982578315e-05,
  -8.081297290758521543e-06,-5.890045339246464324e-06,
  -1.784248885878134288e-05, 9.035795002337301471e-06,
  -1.843917536530960906e-05,-7.745760895312952992e-06,
   6.625061982884024238e-05, 2.260210990802583443e-05,
  -2.260207521927928961e-05, 6.625063166326823833e-05,
   1.338862080853049532e-04, 2.459156019542851706e-04,
  -2.283503754019965376e-04, 1.243225886706323475e-04,
  -3.640422503488654906e-06, 9.313824348574189553e-06,
   1.499673251982011678e-04, 3.130714438745707067e-06,
  -4.249094449615995591e-06, 1.499398052431649556e-04,
   6.812708900312414574e-05,-1.608414573300054768e-05,
   2.902033057426648244e-06,-9.569650157325655765e-06,
  -5.130893725918394410e-05,-3.110294129713659863e-05,
   3.110236816886608895e-05,-5.130928467917191145e-05,
   6.873591066938390020e-04,-2.458403108626564079e-04,
   1.587173024575664032e-04, 4.423898935335134649e-04,
  -9.380912283805535983e-07,-9.955902010728886388e-06,
   1.666683922369635204e-06, 9.860130055071006895e-06,
   1.320673167560341604e-05, 3.775688332540986960e-05,
  -1.243851319481375282e-05, 2.729987892834772643e-05,
  -2.729987892834772643e-05,-1.243851319481375112e-05,
  -1.628448200360965296e-06,-9.866516936525328906e-06,
   1.860809714403404352e-05,-7.330669865584738418e-06,
  -1.971923698164169630e-05, 3.339415047857122176e-06,
   1.384631156948605579e-04, 8.017459443035347287e-05,
  -5.434358836246476444e-05, 9.563877040139623646e-05,
   6.827718592980391225e-05, 1.543456774603633612e-05,
  -1.323175405045522183e-05, 5.852282191374799192e-05,
   3.316417080038466985e-06, 9.434054152443112305e-06,
   1.209887066302612535e-05, 2.745209151739382264e-05,
  -2.037518359411354536e-05, 3.442167766838459124e-05,
  -3.442167766838459124e-05,-2.037518359411354197e-05,
  -7.928492860094328641e-05,-1.067239882797335326e-05,
  -1.859787816450361937e-06,-8.998078233310590640e-05,
   1.395431948791590882e-02,-1.877063565564658035e-03,
   1.490602853830949896e-03, 1.121134261059535293e-02,
  -8.615986897351375076e-05,-3.081825384061643225e-04,
   2.423178008751020803e-04,-6.149864534324623504e-05,
   9.999970654261836975e-06,-2.422630599398650244e-08,
  -1.273122863383470253e-04,-1.542452000786499213e-04,
   1.146242717770384748e-04,-9.675368891976995900e-05,
  -1.298808747563288382e-04, 1.520886530038675433e-04,
  -1.140501668397726363e-04,-9.742976672362518723e-05,
   4.546104507620982063e-04, 1.828369165619511422e-04,
  -1.379988160186705387e-04, 3.433020925911246281e-04,
   1.340676046312176072e-07,-1.999955064188664350e-05,
  -1.733628423526805123e-05,-3.604792988389203680e-05,
  -3.792216894829908868e-06,-2.975935300073855155e-05,
   2.395487734463388468e-05, 3.203379233564996784e-05,
   2.324784029984457503e-04, 3.005890752161366822e-04,
  -2.058797904688639880e-04, 1.587876313712647007e-04,
   3.316727438194322136e-05,-2.235915718610370612e-05,
   1.676936788957780162e-05, 2.487545578645739908e-05,
   2.054416880358115796e-05, 3.432108867984759627e-05,
  -3.432108867984759627e-05, 2.054416880358115796e-05,
   3.999985585892802735e-05,-1.073837277310093053e-07,
  -4.555413558702316404e-06,-8.902146219265953859e-06,
   6.557263981530829348e-05,-2.449956954013366949e-05,
   3.320857219604031234e-06, 3.986191048265253216e-05,
   2.802546470009237135e-05, 1.070389313959535650e-05,
   5.673751197688640004e-06, 1.917833536433042056e-05,
   2.732539240638253100e-05, 1.238236366115984657e-05,
   1.495680953020764130e-04, 4.666148142394419994e-04,
  -3.702533084095206532e-04, 1.225254569948806957e-04,
  -3.638551329800609850e-03, 4.567991267549250528e-03,
  -3.670952241836351621e-03,-2.918939814068913143e-03,
   6.996274486819765840e-05, 2.283490859951458783e-06,
  -1.258043971154626301e-06, 4.998417074801423282e-05,
  -5.435902530140458799e-06, 8.393507233738026224e-06,
   5.032372694165510897e-03, 2.943488587886380816e-03,
  -2.359597142129646764e-03, 4.030037385292300003e-03,
  -6.432857307414827368e-05, 2.760135297850389399e-05,
  -1.938739406875441683e-05,-4.608827346758420635e-05,
   8.131248704768028311e-06, 5.820892929886983796e-06,
   3.664545186652156875e-05, 4.284356554460639743e-04,
  -3.191341660644585144e-04, 2.352411635625538069e-05,
  -1.020944667989798500e-05,-1.719788354682982753e-05,
   1.346408369080862608e-04,-2.680892482676060186e-04,
   1.944550448061296800e-04, 7.929209008120608403e-05,
  -1.152415326384285515e-04, 1.382728793189250669e-04,
  -1.088502845264462842e-04,-1.032066643124933349e-04,
  -2.301360169019489501e-04,-1.924510683901387172e-04,
   1.465854977581976899e-04,-1.503751703140562433e-04,
   1.580152016002259446e-04, 8.620438540607988350e-05,
  -6.331948179802593553e-05, 1.359803045474948979e-04,
   3.204963939658873441e-06,-1.974153505038264087e-05,
  -2.557462029803322703e-05,-1.568243592722211530e-05,
   1.045495728481474184e-05,-1.704974686535548582e-05,
  -4.775945378174211673e-05, 1.479981670392032616e-05,
   1.021803852117216423e-05,-3.867288053377769899e-05,
   3.996242232894534226e-05,-1.733436356781244275e-06,
  -2.253253641846760159e-06, 3.993648517365423458e-05,
   1.805831932013166212e-05,-2.395614959320799473e-05,
   1.597076639547197842e-05, 1.203887954675447021e-05,
   2.284619161849828130e-04, 1.198418074920917266e-03,
  -1.070726477632494896e-03, 2.040723263962075814e-04,
   2.387094610033249588e-04, 1.267721496712705771e-03,
  -1.120312020350762569e-03, 2.109525469331726430e-04,
   4.247799150541283451e-03, 3.695010470439934278e-03,
   1.616451560111866438e-05, 1.177745453742833867e-05,
   3.362972539507081684e-04, 2.679629768927283928e-04,
  -6.529480052672343045e-05,-6.194020523194444208e-05,
  -3.509818800759444082e-06,-9.363822509308661609e-06,
  -7.757160456756866194e-05,-2.376607796099574536e-04,
   2.091414860567625560e-04,-6.826301201946042576e-05,
  -1.016872848392463098e-03,-3.640655107285253184e-03,
   3.187981059554017855e-03,-8.904362772960459178e-04,
  -2.690139810562071660e-06,-9.631362717685856113e-06,
  -2.722006531383815215e-06,-9.622405127778806185e-06,
  -8.292035556614915301e-03,-3.553536613470915234e-02,
   3.137707582516658517e-02,-7.321715144810429614e-03,
  -2.499654456639190475e-05,-1.071222327985203244e-04,
   8.764546319878936122e-05,-2.045171828159338123e-05,
   5.479587574668989211e-06,-1.923471133164033866e-05,
   1.045999775876747329e-03, 7.265086680065544270e-03,
  -6.512843372592819376e-03, 9.376946219712402287e-04,
   2.850135629091954747e-06, 1.979587651244017676e-05,
  -1.979587651244018353e-05, 2.850135629091915783e-06,
   6.979173512654085274e-06, 6.965121059307057103e-05,
  -4.975086470933612700e-05, 4.985123937610140531e-06,
   2.999671799036804229e-05,-4.437452042898554748e-07,
   1.085457721051557423e-04,-8.841841074174308700e-05,
   6.315591294857086837e-05, 7.753277152038703555e-05,
   3.993293064892287832e-05,-2.315394089203015102e-06,
  -9.995986436102389361e-06,-2.832934331343874450e-07,
   1.098792638413180454e-05, 1.671123794866496935e-05,
  -3.086881646950936188e-05,-2.543847813395580450e-05,
   1.194254256988088309e-05,-1.604293230574083782e-05,
  -5.888858241557823808e-05,-8.178827175560985513e-04,
   6.682701474379279657e-04,-4.811460826391119071e-05,
   3.591950859870991505e-06, 4.987081199479583953e-05,
  -2.992248719687750236e-05, 2.155170515922596766e-06,
   9.379500588619623996e-04, 1.025840965784093192e-03,
   5.647792047386791841e-05, 5.665901957276928233e-05,
  -1.927019805395511625e-05,-2.299259591610622121e-05,
   6.909032094808835488e-05, 1.124844661676189710e-05,
  -8.034604726258409111e-06, 4.935022924863456147e-05,
  -1.259942891075719416e-05,-7.900161005399053058e-05,
   3.950080502699526529e-05,-6.299714455378590305e-06,
  -4.590905950270546710e-06,-3.973567141191615453e-05,
   2.980175355893711420e-05,-3.443179462702904527e-06,
  -1.078862898313578511e-04,-9.337882781800295332e-04,
   5.264976462078889679e-04,-6.082950384108464734e-05,
   6.042078313277550388e-06, 2.099130612650299628e-04,
  -1.399420408433532995e-04, 4.028052208851708446e-06,
   3.006624657393856892e-06, 1.977271372800282258e-05,
  -1.791190522957278379e-05,-8.897395745205629802e-06,
   4.335343206257114327e-04,-3.219440834051821268e-04,
  -1.132837146731135213e-05,-6.907726109146630745e-05,
  -4.786103755853390613e-04, 6.534769379114006198e-04,
   3.772425955704058087e-05,-1.329963311046709689e-05,
  -3.839153797378194900e-05, 1.122897199246925077e-05,
  -4.693128529175263962e-05, 1.104420864564959311e-04,
  -9.887820405267716431e-06, 1.493655794743683001e-06,
   8.959250991662392173e-06,-4.442051515729691553e-06,
   4.521994343822046733e-06, 8.919168523715729647e-06,
   2.741452060484219686e-05,-1.218376214503068158e-05,
   2.908273698472368731e-07,-9.995770077435141849e-06,
   4.060368387367727820e-07,-9.991753303879588133e-06,
  -3.400661743972051255e-05, 2.106062606639453599e-05,
  -8.838508480389845653e-06,-4.677688301081722517e-06,
   2.329121741094685507e-05,-5.529483874211051715e-05,
   2.750294777586188727e-05, 1.198281534691299844e-05,
   8.022586060484942352e-06, 5.969766570152697665e-06,
  -9.767871146007435517e-06,-2.142123543354908666e-06,
   4.633059649621891301e-05,-3.812447807255265160e-05,
   1.906646376629370229e-05, 2.316182116001695802e-05,
   1.227803990979659959e-05,-1.578764504203974020e-05,
   3.374119305725524183e-05, 2.148329330137795028e-05,
   2.806006225796098922e-05,-1.061286512113261705e-05,
   1.061286512113261875e-05, 2.806006225796098922e-05,
   1.614686414720532841e-05, 3.659615797063532486e-05,
  -3.659615797063532486e-05, 1.614686414720533180e-05,
   6.859468253649057063e-07, 9.976446108347993181e-06,
  -9.611964334452919578e-06, 2.758648515705665328e-06,
   3.092553497746171673e-05, 5.141606058769761635e-05,
  -2.551150465075517832e-05, 1.578490197798190444e-05,
   9.559317931031654505e-06,-2.935888399353199692e-06,
  -2.943225369123610459e-05,-5.808824550175256714e-06,
   3.872549700116871973e-06,-1.962150246082406408e-05,
  -9.970882128959795984e-06, 7.625677480658338511e-07,
   9.871880167929988849e-06, 1.595613346030486139e-06,
   1.042955951595671043e-06, 1.997278755915235824e-05,
   4.894320810099926788e-06,-8.720414199326934307e-06,
   3.596862322824940188e-05, 3.473122720354461691e-05,
  -2.778498176283564677e-05, 2.877489858259957029e-05,
   1.638319403450269401e-05,-1.147131000487020951e-05,
   1.643451522694559276e-05,-1.139766244697979656e-05,
   5.083065822561481928e-03, 5.350405764379685333e-03,
  -4.944412915050069163e-03, 4.697358930876590656e-03,
   3.712041865705078956e-05,-5.934706832460449817e-05,
   5.934706832460455916e-05, 3.712041865705069469e-05,
  -2.185845172887914930e-05, 2.054770274303821485e-05,
  -2.054770274303825212e-05,-2.185845172887911542e-05,
   1.671219693928757940e-05, 2.491390120921384285e-05,
  -3.314497923882517923e-05, 2.239219398044434614e-05,
  -1.575233632654342224e-05,-1.232330719634386539e-05,
  -5.863184717191841333e-05,-5.442707503815361416e-05,
   3.993239169979299940e-05,-4.478173838892705904e-05,
   9.752634700219264328e-06, 2.210456152941991720e-06,
   1.731630432164799166e-05, 1.000727758384242635e-05,
  -1.508849722626928314e-05, 2.592946685631743124e-05,
   2.623057414356163566e-04, 6.399764065894607756e-05,
  -2.112277828264650235e-05, 8.748616026333627519e-05,
  -4.995777260429624364e-05, 2.054496633588786097e-06,
  -2.465395960306440741e-06,-5.994932712515550050e-05,
  -2.744299534869891160e-05, 6.439628876178572108e-05,
  -3.692826443521262812e-05,-1.537215943851125003e-05,
  -6.707021448748529081e-04,-2.618370349287355838e-04,
   2.363844609654558481e-04,-6.054935066654892114e-04,
  -9.696097913550870163e-06,-2.446566011951135473e-06,
  -5.847920009517658006e-05, 5.459105381130044014e-05,
  -4.776717208488795712e-05,-5.116930008327942369e-05,
   2.471628869156615148e-05,-1.071872430530572022e-04,
   1.072293615423144508e-04, 2.453291713652527530e-05,
  -2.922484189113014379e-05, 6.360745723921405032e-05,
   4.019905953412727959e-06, 9.156437960567248400e-06,
   2.765595445768771564e-05,-1.162532507219918636e-05,
  -1.243842357751249355e-04,-1.006407566080369634e-04,
  -1.940515025888379409e-05,-4.841502187352836373e-06,
   4.836496280293990990e-06,-1.940639852550448083e-05,
  -7.977642438990271284e-05,-5.976797768214771610e-06,
   2.264235913532596955e-06,-2.991443189712733385e-05,
   9.797819133598429070e-06, 2.000684939037763550e-06,
   6.209383807315224776e-05,-3.231648609216582749e-05,
   1.309780314067912322e-05, 2.698976755898457392e-05,
   3.135121119121821610e-04,-1.555961300430166983e-04,
   5.305795235889813384e-05, 1.076329582027777185e-04,
  -3.141260407826073064e-05,-6.255596138676502397e-05,
   1.461914114533047837e-05,-1.364846922452864429e-05,
   7.891704977160764233e-06, 1.837718674208476468e-05,
  -2.244469929839651803e-04, 5.023492152333761904e-05,
   6.653961966748221093e-05, 2.173658240172115578e-05,
  -8.383483013026250791e-06, 2.880481231617905102e-05,
  -6.546645945692960449e-06, 1.889818580874211854e-05,
   7.490316301562733453e-05, 2.809833038197037192e-05,
  -1.153857641016796719e-05, 2.769225982881706358e-05,
   8.519771069344248210e-05, 2.243687814572171773e-04,
  -6.544540402132840431e-05, 2.483745342190079425e-05,
  -1.993655923773914222e-05,-1.591730429475478869e-06,
   2.403891094055767867e-06,-9.706766073616865330e-06,
   1.941770361272096438e-05, 4.790906637425033920e-06,
  -1.611760953368983530e-06,-9.869256640152546339e-06,
  -1.146572123794084696e-05,-1.638710579979979959e-05,
   4.629212456896971925e-05,-1.889548101771929597e-05,
   2.284744264491675317e-05, 5.547967523866050639e-05,
   3.100282214857670712e-04,-3.261633055424416360e-04,
   3.044673616026558017e-04, 2.893088759763821449e-04,
  -1.005095531293179520e-05, 1.729098890455511882e-05,
   3.865448147030374319e-05,-1.028742252762783527e-05,
   1.028742252762783866e-05, 3.865448147030374319e-05,
  -2.660072051978195341e-05, 1.387089282737241070e-05,
  -9.232597074624990561e-06,-1.774145290717832229e-05,
  -4.577597264565087104e-05,-7.748909812576620958e-05,
   9.073841985179042008e-06,-4.203021725854159210e-06,
   2.995505044114899970e-05, 1.641631221748424494e-06,
  -9.053758165273314030e-06, 4.246111525236566219e-06,
   7.300327308691869819e-06, 1.862002205116760164e-05,
   1.811065528296107945e-05, 8.485526808734625062e-06,
  -8.485526808734625062e-06, 1.811065528296107945e-05,
   5.684426149594609546e-06,-8.227229141685858161e-06,
  -9.421731432103493478e-06,-3.351264958387067103e-06,
  -9.703573497997001443e-06, 1.748830069986704751e-05,
   9.887369576694111470e-06, 1.496637181772432722e-06,
  -2.993274363544903984e-06, 1.977473915338821616e-05,
   5.489269080568728680e-05, 4.343722477450894659e-05,
  -3.723190694957885023e-05, 4.705087783344644815e-05,
   9.369230453293014369e-06,-3.495357022263504092e-06,
   1.552202377227873318e-04,-1.414449638597337902e-04,
   1.347094893902223579e-04, 1.478287978312262910e-04,
   6.175397050013591790e-06, 7.865397083090175777e-06,
  -1.123663706500395383e-04, 3.208953080787220621e-04,
   3.937905581827968950e-05,-7.020681082403104838e-06,
   3.892722317278776728e-06, 1.961751036601127519e-05,
  -8.090147097937553568e-06,-5.877883967358712576e-06,
  -6.977157182805523024e-06, 2.917737612682856123e-05,
   2.504225841688065171e-04,-1.009382451710797828e-04,
   3.344671131936760252e-05, 8.355427877684593421e-05,
  -1.895198326595789405e-05,-3.522530809356892251e-05,
   2.641898107017671729e-05,-1.421398744946836802e-05,
   2.667099188485528717e-05, 1.373529001797863489e-05,
  -1.974404775232341304e-05, 3.189447970099668313e-06,
  -4.784171955149662135e-06,-2.961607162848509076e-05,
  -1.684876736118075770e-05, 1.077585441664882920e-05,
   6.788898709049914591e-06, 1.881251855330010096e-05,
   2.653875518869053555e-05,-7.546982491721279077e-05,
   3.612388270306490421e-05, 1.717745902207914768e-05,
   2.617909903584078162e-05, 6.492037256263737913e-05,
  -3.514800143172483172e-05, 1.909497303887778782e-05,
   9.570836932535998690e-06,-2.898116700687695734e-06,
   5.796233401375494805e-06, 1.914167386507196689e-05,
   4.022863884867387909e-06,-1.959123697380616436e-05,
  -7.216847198773328786e-06,-6.922219045187574525e-06,
  -6.232412704310311535e-06, 7.820296150603982049e-06,
  -1.486813283976103561e-04, 1.984818598181403915e-05,
  -2.181717480075343800e-04, 2.830350457694094584e-05,
   8.616996375862511284e-03,-8.833061386539343626e-03,
   7.100811483954442768e-03, 6.927111683042269132e-03,
   3.170198931777843597e-05,-3.866502131507833391e-05,
   2.319897959076608541e-05, 1.902123408055372752e-05,
   6.067778120782566040e-04,-6.781745253026862531e-04,
   5.589352228912580637e-04, 5.000914082560304697e-04,
  -1.529868712270723396e-04, 1.438576283418824600e-04,
  -1.096059341327852216e-04,-1.165613109178150511e-04,
  -6.245640279941857512e-06, 5.967404777198851844e-05,
   1.933607601108207130e-05,-5.110397684491536486e-06,
   3.419222953665589939e-04,-7.476057738717375339e-05,
   4.364530402543604498e-03,-7.587979739512775573e-04,
   9.852213098292561961e-06,-1.712862243682342091e-06,
  -2.062370347185249735e-03, 1.775628087494454026e-04,
  -2.997257855715732537e-05, 1.282394102853287003e-06,
   1.239535931425104061e-05, 1.595191369945017363e-04,
   4.937701153950373948e-06, 4.975559372888919426e-05,
  -1.282090528103957881e-05,-1.535006149090652734e-05,
   3.356689649547782580e-05, 2.175461927182084372e-05,
  -1.854227011719391488e-05,-3.544268921655096123e-05,
  -4.376833506010627392e-04,-9.323804398455746902e-04,
   1.780051970102022405e-05,-9.118196004341588601e-06,
  -8.408219839743132432e-03,-2.012406368322635503e-02,
   3.453632254000506274e-04,-1.585062854945312445e-04,
   1.450625160950427340e-04, 3.941533539425682393e-04,
  -8.187801529524399498e-06,-5.741071860995812551e-06,
   1.003632064655733210e-05,-1.729948750337671558e-05,
   3.781612344612735976e-04, 1.303613468430180728e-04,
  -2.186653104303894980e-05,-6.649702865650323352e-05,
  -3.329647343518595329e-04, 2.216630002458588975e-04,
   6.002058308919407310e-06,-1.907813659811490883e-05,
   1.109237633138760704e-05, 2.787398764660112545e-05,
  -1.948682394156576195e-05,-4.501521150724439196e-06,
   9.449017644561476673e-07,-9.955257940180538826e-06,
   3.020911137270440903e-05,-2.179160608814126418e-04,
   1.949860922885807824e-05,-4.450195292376578613e-06,
  -6.499643172721082435e-06,-2.928744848270842835e-05,
  -1.400315773024286447e-05,-1.427976097775938141e-05,
  -4.961605794115229719e-05, 6.184399273997308278e-06,
   3.734162648277974993e-05,-1.433886088992296516e-05,
   1.991758849594742412e-05,-1.813744333169079511e-06,
   9.986772201036465716e-06, 3.873324645578531480e-05,
  -4.336364587443594957e-05, 2.489164953305654437e-05,
   2.944352834018562656e-05, 5.227885460566906512e-05,
   2.099955922408738328e-05,-3.404436094853370435e-05,
   4.815544947070874874e-05, 1.314574177681655733e-04,
  -5.618176374558862585e-05,-2.106203747112002391e-05,
  -4.597026783810870200e-06,-8.880728841087622447e-06,
  -6.796759825812964922e-05,-8.648933799620328264e-05,
  -7.878354091713915877e-05, 6.158858401162883205e-05,
   1.716820223643720396e-05,-1.025928028512686068e-05,
   2.724575273911854917e-03,-2.901222083327669159e-03,
  -2.599870650742358655e-05,-1.496887637536132849e-05,
  -1.305600221829200213e-04,-1.239115838313570794e-04,
  -1.845777914579650346e-04, 1.372262325523074928e-04,
  -1.148528111667897482e-04,-8.005517951441826880e-05,
   2.037694489515185327e-04,-2.967793990053798963e-04,
  -1.571318078265867963e-05, 9.875776399702195397e-05,
  -6.901675993195548881e-05, 1.331791532053527350e-04,
   1.136400762165677659e-03, 5.670037987079691805e-04,
  -1.666764539679350493e-05,-1.105394033486468442e-05,
   4.995688011241993529e-05, 2.076085121882545691e-06,
  -2.723903657525458843e-04, 1.475060503384588179e-03,
   8.412915047332029724e-06, 5.405817274600975554e-06,
  -4.412054832152048438e-04,-1.619806210039879154e-04,
   6.957531086317163792e-04,-2.139726059996770353e-03,
  -4.699338470425363059e-05,-1.707693749001913127e-05,
  -3.553065217843747570e-05, 3.517915228903187243e-05,
   2.673967074066590610e-05,-1.374226691950086244e-04,
  -1.181002191226038754e-05,-5.882621339532172655e-05,
   8.657320158726866671e-06,-1.802916547345720860e-05,
   3.993952661419379900e-05,-2.198684569033389664e-06,
   6.353494523432561729e-05, 6.374410352394365429e-05,
   1.124178711342472973e-03, 1.892676014651650427e-04,
  -4.926025533588160961e-04,-1.955574708989015354e-04,
  -9.994346135811661540e-05, 3.362221253673266348e-06,
  -1.152355500920452153e-04, 6.017281774176556360e-05,
   5.784489031275918920e-05, 1.164215128947603700e-04,
   2.361439603852592936e-04,-3.228560514742833320e-04,
   5.199658320436360837e-05,-2.751297063842283335e-04,
  -4.865913518524481514e-06,-1.939904342049475413e-05,
   1.255596878930721282e-06,-1.996054800043374291e-05,
  -3.624054220049068736e-05, 1.692994686980599163e-05,
   1.201228535192337441e-05,-6.398872596017395270e-04,
   4.590308890991434037e-05, 1.982186743292617666e-05,
  -1.151958462939669161e-05, 7.916627545846885406e-05,
   2.174271640783704011e-04, 3.709790133158982024e-04,
   5.578316551669468780e-05,-2.209611832284225002e-05,
   4.879694318158900822e-05, 1.090221702832843610e-05,
   8.992692742719052756e-04, 1.582313108190183931e-03,
   3.703450817675771442e-04,-2.185051953857541213e-04,
   2.443246146233425914e-05,-4.362401662950755264e-05,
   7.229957432567211018e-05, 6.908524844224428246e-05,
   3.042894478694149215e-06,-1.976716452077871325e-05,
  -4.602797664704802943e-05, 1.953011433091986476e-05,
   1.740256228642434808e-05, 9.856511850909582931e-06,
  -1.171809751877607295e-05,-2.761677371708096858e-05,
  -8.920532412621813134e-05, 4.519303206841035849e-05,
  -3.558942824119724880e-04,-1.250335658831846272e-03,
  -1.119216974972137284e-04, 4.358595342875295586e-04,
   1.156954686550627414e-05, 2.767933498707752661e-05,
  -1.376260380104535256e-05,-1.451174478191551136e-05,
  -2.220415698437647829e-04,-5.997950701128282081e-05,
  -2.450557485438126996e-04, 8.659951963525153477e-04,
  -1.591261945136848162e-05, 2.543203771222293504e-05,
  -1.317497084586437179e-05, 1.504726364528195362e-05,
   2.979950327358784023e-05, 2.668313333638738731e-05,
  -1.150560279228691292e-03, 5.136253925393447547e-04,
  -2.282458762945357671e-06, 1.986933270131269281e-05,
   1.469653836509878637e-04, 3.001959374005492274e-05,
   8.786187250910723178e-05,-1.950106046330270140e-05,
   2.213725802586295917e-04,-1.714473117597257014e-04,
   1.174430629541258061e-04, 2.431195733871570645e-04,
   8.227037395119855432e-04, 6.996846125169504677e-04,
  -3.753935854603308116e-05,-1.381291279753743824e-05,
   3.119240009681855237e-05, 9.501070558731787531e-05,
   6.143890827038146242e-04, 6.017691044365481049e-04,
  -1.329669719247493654e-05, 1.493980735389948756e-05,
  -1.688096954606554706e-04,-2.718515895088362061e-04,
   5.053504306415672245e-04,-3.416444676127253937e-04,
   4.671129688029191637e-05, 8.841976444076986210e-05,
  -1.038195303189714496e-06,-1.997303558582007088e-05,
  -3.315634404412849212e-05,-6.164946755347838834e-05,
  -7.995420487314934327e-05, 2.706496462673374172e-06,
  -2.427933014263124222e-04, 1.181160987440399549e-04,
  -1.369528578188363320e-05,-1.457529235907589155e-05,
   3.736303912182857388e-05,-3.322654522487566097e-05,
   2.914889986825995745e-04, 3.161236524637399598e-04,
   6.440757926217407321e-04, 1.365747551108431081e-03,
  -1.893124726236361497e-05, 6.450416815311257304e-06,
  -2.229395842269445063e-05, 5.570439316469726483e-05,
   1.139221599186230076e-06, 3.998377388576455986e-05,
   1.331347960468567721e-05,-1.492485379545201853e-05,
   1.877407541412840766e-04, 6.894497251041534702e-05,
   3.419249519898992799e-05, 2.075748713276852846e-05,
  -4.967417357304988696e-05,-5.698813897164278105e-06,
  -9.389501451771369955e-06, 3.888235155552173875e-05,
   1.308474396917167579e-05,-1.512578841783877173e-05,
  -1.669560751016118720e-05, 5.763034521731280705e-05,
   3.964188993510784031e-05, 5.340464621434732287e-06,
   4.894191169934616962e-05,-3.470863407299979445e-05,
   5.410671139107030563e-05, 2.593190664882593445e-05,
   1.999469744128881251e-05, 4.605151803347417388e-07,
  -6.975945737266545375e-07,-1.998783034275374289e-05,
  -1.975469001731961987e-05, 3.122854834860669384e-06,
  -1.301786183770805249e-05, 1.393934549151226872e-04,
  -2.891321681786375837e-05,-2.764101831053264043e-05,
   4.582722649624722028e-05,-6.557335824602593367e-05,
   6.424681919888119627e-05, 6.302655172882514563e-05,
   1.922269381831849880e-05, 5.521597809255924855e-06,
   9.895923781589849351e-06,-1.738018102635770841e-05,
  -7.691124067204686290e-05, 6.391135312514112615e-05,
   4.802629468073850070e-04, 1.390952979934508471e-04,
  -4.251785798490354462e-04, 2.003077013935244965e-04,
   2.624249992112315174e-05,-1.453723487771493192e-05,
   1.453723487771497936e-05, 2.624249992112312463e-05,
   9.050178810354655426e-05, 4.253735241009671284e-05,
   5.099219880012659771e-05,-6.164248260354517018e-05,
  -6.465732737631926482e-05,-4.711082695677795191e-05,
   9.699691399888214478e-05,-2.432280153875086056e-05,
   9.705656903126355607e-05,-2.408365437136922768e-05,
  -4.897376838603073211e-04, 6.325796400510703878e-04,
  -3.465081075318441841e-05, 4.898286755741234987e-05,
   6.456886449450621779e-06,-7.636007947802370125e-06,
  -1.862765651117385084e-05, 7.280825015183548259e-06,
  -2.744012927842599619e-04, 9.382926259076555060e-05,
  -2.733949168363244194e-03, 8.049981023616928182e-04,
   5.880277263666185182e-04,-1.192618674350905762e-04,
  -1.715339900037842185e-05,-8.835021733269148177e-05,
   2.246084330355029382e-05, 3.309849721805146133e-05,
   4.307719999345050832e-04, 6.977359701724046527e-04,
  -8.322669111632622892e-06, 5.543751334455422553e-06,
   5.936112873178659051e-03, 1.061264170491412612e-02,
  -1.881856935699795805e-04, 1.139567669582888478e-04,
  -5.851202059245500577e-05,-1.160876541505948320e-04,
   2.962055284808948294e-05, 6.342415036067521267e-05,
   7.250349630001177055e-06,-6.887120606083634432e-06,
   1.452743353216815597e-04,-1.224555735638179605e-04,
   4.812770955460027504e-06, 8.765685126119941804e-06,
   5.319159606083924917e-05,-2.776065756606840092e-05,
   1.074732562909361673e-06, 2.998074298475977332e-05,
   1.987290438935734421e-05, 2.251148847024935575e-06,
   2.574989677282208982e-06,-9.662785735070921722e-06,
  -9.174873414863642777e-06,-3.977649786146132464e-06,
   5.300407764508554242e-06,-8.479721547901053128e-06,
   3.917041775671535729e-07, 1.999616382802652626e-05,
  -6.117637350400178018e-06, 2.599280179458324106e-04,
  -1.916659953076621012e-06,-9.814602112376860261e-06,
  -3.931986251686283711e-05, 7.344958247328915421e-06,
   9.408655438743709055e-06,-3.387802065498875898e-06,
  -1.306759427418357599e-05,-3.780526391767851134e-05,
   7.769687773225900221e-06, 6.295391322752221556e-06,
  -9.790970411275718826e-06, 2.033936676871580147e-06,
  -1.323997379116467991e-05,-3.774523935557003076e-05,
  -1.610356973569118257e-05, 1.186065098414632057e-05,
   3.530771298264657478e-05, 4.851149764679555429e-05,
  -8.500138833043429802e-06, 1.810380180567018759e-05,
  -2.692450006379030821e-05,-5.361969131126135163e-05,
   2.910806332678947386e-05, 7.260898660883081846e-06,
  -1.408082821928930910e-05,-1.420317839988169429e-05,
  -4.989308310707629978e-05, 4.909867878131117758e-05,
   1.198423874950552983e-05,-1.601180881708404077e-05,
  -7.191643010072122665e-05,-5.411124727418577777e-05,
   8.044754437533059089e-05,-7.502128100731962591e-05,
   1.758697975674939479e-05, 9.523557267937595870e-06,
   3.337642398114197030e-05,-6.153059663477228347e-05,
  -2.892610163602438811e-06, 9.572502621646227183e-06,
   3.310968922151492969e-06,-6.992165247472736098e-05,
   9.972219681650668400e-06, 7.448722178327286461e-07,
   2.182618344123617385e-05,-5.588933454953197080e-05,
   2.820681868970357882e-05, 1.021642693930656719e-05,
   3.290136162247033930e-06, 9.443251772237907667e-06,
   1.787124393418916492e-05, 8.978788350590911145e-06,
  -2.992163269138387285e-05, 2.167001864767983757e-06,
  -8.876721248446955637e-06, 4.604760566779813091e-06,
   4.807285531021943575e-05,-6.983473352009891312e-04,
   1.945542455496879989e-04, 4.635348464346246856e-05,
   5.020300967021573251e-05,-2.449074474573042191e-04,
   4.124671675821836612e-06,-9.109724670190263209e-06,
   2.918328215387861851e-05, 6.952412727040138167e-06,
   1.854112252158707439e-05,-2.358446046954427601e-05,
  -6.287825525628580096e-06, 7.975251250060561166e-05,
   9.299109549496449668e-06, 2.852238702469454861e-05,
  -1.575161459491104099e-05, 3.676801106469298271e-05,
  -4.938450707545408836e-05, 7.821154704672795500e-06,
  -1.769830206784012074e-05, 9.315047177308668228e-06,
  -3.616951962829628825e-06, 9.322964040399539865e-06,
  -2.996205502336017450e-04,-1.508396094246179379e-05,
   3.280402174940225579e-04, 8.938465028445547118e-05,
   5.934105354572886552e-05,-8.867883855968100031e-06,
   5.827663202826097432e-05,-3.877930065695700887e-05,
  -6.580508798866219807e-05,-1.003478469863924193e-04,
  -1.956343311326375902e-04, 3.488942654763553465e-04,
  -1.316620535739696971e-05, 1.795178292997296051e-04,
   7.013806557784857812e-06, 1.872982961935250101e-05,
   1.545644720859662722e-06, 2.996015658164821212e-05,
   1.731917991356735241e-05,-1.000230009155320352e-05,
   2.374109548893652637e-05, 2.488701677280448802e-04,
   1.518313349072180515e-06,-4.997694192899390642e-05,
  -1.120388648740386112e-04,-1.534512716067772489e-04,
  -2.641449487457159047e-05, 1.422232261345633048e-05,
  -2.988522839297008338e-05,-2.621664337785210918e-06,
  -6.740280584726551219e-04,-9.193944618016702819e-04,
  -2.064526844363203447e-04, 1.580420484840573203e-04,
  -1.511452301974994396e-05, 3.703445954628539554e-05,
  -5.581511520331582690e-05,-4.224538927315715846e-05,
  -7.657778482353124705e-07, 1.998533423005860343e-05,
  -9.459965232904031635e-06,-3.241767695601734165e-06,
   8.354026909190071556e-05,-5.496383756664757086e-05,
   2.823831978418130649e-04, 6.840027262932739643e-04,
   3.006006264074927728e-05,-2.179366711547972471e-04,
  -4.889815631430400120e-06,-8.722941194953622818e-06,
   7.903699261236881227e-05, 1.237553226299210498e-05,
   4.135920461971203819e-05,-2.769285398676430646e-04,
  -2.448480269328632181e-05,-1.733477536834091725e-05,
   7.743982431549837047e-04,-4.585928052188288054e-04,
  -7.966711520272673377e-05,-7.290456451791450234e-06,
  -2.833829130917944809e-05, 9.845874551104367745e-06,
  -6.547994896553343354e-05, 6.174444334084759167e-05,
  -1.373189416780175342e-04,-2.207793202644423480e-04,
   4.744528405598438326e-04, 3.159026781853794489e-04,
  -3.794373794595627225e-04,-2.939851613072670482e-04,
   5.753687330071839467e-06,-8.178941380629329728e-06,
   1.174395689913237684e-04, 1.493584535107809195e-04,
  -2.518350881344814875e-04, 2.132582668603914746e-04,
  -3.970736182906114292e-05,-5.764829066482385556e-05,
  -2.182087867654158005e-06, 9.759021085018545162e-06,
   1.660689307339387789e-06, 9.861141466609666133e-06,
   5.558373837270897095e-06, 8.312910458145356032e-06,
  -9.902274767442941999e-06, 1.394616230388434658e-06,
  -4.241641187058639182e-05, 2.647353402975843200e-05,
  -1.978915699235324327e-05, 2.254748911812569739e-05,
  -1.892809695457758077e-04,-1.633178329754931960e-04,
  -3.689865325829782823e-04,-5.948520309895483733e-04,
   1.371517574772785562e-06, 9.905500469036856282e-06,
  -1.731431442653686049e-05, 2.449927582478750662e-05,
  -8.711174544431765589e-05,-2.261733418518643458e-05,
   1.818621162367559937e-05, 8.322361850994379866e-06,
   2.242533388085567386e-06,-1.987387843384681569e-05,
  -1.129800274263658176e-05, 1.650318557210626324e-05,
  -1.999349481155257804e-05,-5.100639375806277879e-07,
  -2.233364717355128192e-05, 2.003018232386627036e-05,
   1.806647823027973746e-05,-8.579182032969598611e-06,
   1.922699309017939482e-05,-5.506608458043286677e-06,
  -1.265820176269189974e-06,-5.998664600793538252e-05,
   1.594349488994151979e-05, 1.207497290657037863e-05,
  -3.925315700944527411e-06, 9.197385315833972981e-06,
  -9.975888133043423679e-06, 6.940143780955879904e-07,
  -1.854289828225899823e-04,-4.142574476553967616e-05,
  -6.345693003793934359e-06,-2.932118995371096307e-05,
  -4.884611983009879869e-05, 1.067972740961251685e-05,
   3.993784823431677098e-06,-9.167861407336327356e-06,
   3.685095971399991553e-05,-3.379359063723704908e-05,
  -2.379565828897654226e-04,-3.125163450807324903e-05,
   1.861822049035856766e-04,-9.714003591331043348e-05,
  -4.835733226562334504e-05,-1.271095653961981545e-05,
  -1.680877664608384196e-05, 2.484884358802369843e-05,
   2.642318987348901300e-05, 1.420616193451094363e-05,
   3.297508527657340232e-05, 2.264163755126188113e-05,
  -7.540588726010040977e-06,-1.852402552538649284e-05,
  -6.398224866028082733e-05,-1.789029677125955110e-04,
   1.017538718674033805e-05, 3.868412459394578097e-05,
  -4.097627586030947816e-05, 2.865213459098325531e-05,
  -6.663370522708948881e-04, 4.243759333078806341e-04,
  -5.659646588709326570e-06,-8.244295026920792102e-06,
   1.758355606300626683e-06,-9.844195526389710319e-06,
   6.992849438761822458e-06, 7.148430368046434424e-06,
  -2.998309000175621128e-05, 1.007131543834601076e-06,
   4.248105720235076663e-06,-1.954363317783328722e-05,
   6.896040269435151303e-06, 7.241866375619532353e-06,
  -8.840712651854475143e-06,-4.673521135861078796e-06,
   3.619557052468238981e-05, 1.702588248499160061e-05,
  -1.276941186374374535e-05, 2.714667789351176864e-05,
  -5.448306118604867453e-06,-8.385461253739879428e-06,
  -9.997945810817009072e-05, 2.026809413009531626e-06,
  -1.824128471708424134e-06,-8.998151229735307623e-05,
  -2.890908798618700470e-05, 8.016522426021043752e-06,
  -8.016522426020987848e-06,-2.890908798618701826e-05,
   7.873915915963920970e-05,-1.414725467477723718e-05,
   1.768406834347135335e-05, 9.842394894954904262e-05,
   1.199010548566081368e-03,-1.627074197056314680e-04,
   2.013765366721950918e-04, 1.486421034053915643e-03,
  -1.894643293779633202e-05,-6.405675525156289837e-06,
  -8.344023371533624233e-06, 5.511558216629909533e-06,
  -6.632506369617189863e-05, 4.473238117626582858e-05,
  -5.038217791087673151e-05,-7.457637795546767602e-05,
   3.019260800273139474e-06, 9.533313391467523049e-06,
  -2.708512182153483984e-06,-9.626212222838544748e-06,
   2.940709931408324459e-05,-5.934855510595420432e-06,
   5.934855510595474642e-06, 2.940709931408323443e-05,
  -9.920849099793394024e-06, 1.255688312890040470e-06,
  -1.670474748972941323e-05, 1.099779120116302899e-05,
  -1.649668680174458838e-05,-2.505712123459408766e-05,
  -4.805717669925159440e-04, 2.874904811810138710e-04,
  -3.490955842912302036e-04,-5.835514313480557680e-04,
  -1.003503013641811499e-02, 5.430126164388836274e-03,
  -6.738868298508914056e-03,-1.245364420783537547e-02,
  -1.011934660836383233e-04,-1.725105284380624190e-04,
   2.156381605475777934e-04,-1.264918326045483005e-04,
  -1.478266138765933491e-01, 7.193505563896211707e-02,
  -8.958192958104375936e-02,-1.840908764511074713e-01,
  -1.372817714147342525e-03,-2.588488269960531260e-03,
   3.216160210030385037e-03,-1.704674016760186978e-03,
  -2.222769335670398672e-05,-7.685004650642925279e-05,
   1.168904264974478023e-05, 1.622856376678009024e-05,
   1.550093956980740529e-03,-6.732820542178369078e-04,
   8.485689676877517179e-04, 1.953671084670432264e-03,
   1.289388606340438228e-05, 2.708777772693703694e-05,
  -3.611703696924941872e-05, 1.719184808453911426e-05,
  -3.618117376409310526e-05, 1.558554543962209450e-04,
  -1.245317393679104740e-04,-3.730745086444277239e-05,
  -8.846084324417306227e-06, 1.793730169577627614e-05,
   2.057019865397110558e-05,-2.183728296597736850e-05,
   6.473657522391144297e-05, 6.252340224491031073e-05,
  -5.011542209776071230e-05, 6.235739304976818773e-05,
  -8.650554224497937787e-04, 3.414368405579705870e-04,
  -3.195099511233264670e-04,-8.199471880146730731e-04,
  -1.458261671151088125e-05,-2.621730897413317079e-05,
   4.841050925864966029e-05,-1.250690182731902439e-05,
  -2.083559652700177775e-06,-3.994569788066845402e-05,
  -1.095873624105426587e-06, 9.939771677457689768e-06,
  -6.853533374169547882e-06,-7.282106857849875495e-06,
  -1.097444463905369527e-05, 1.672009464280467712e-05,
   1.437245260472025885e-05, 1.390800510947094468e-05,
   7.872624089794371478e-06,-6.166181147257139557e-06,
   3.366590974896119948e-05,-4.966494257295380837e-05,
   8.240711202907492631e-05, 5.664863535009025109e-05,
  -5.004884428455591900e-06,-8.657432174600201126e-06,
  -2.147406949448402134e-05,-2.094908922473888354e-05,
   3.458625397067292622e-05,-3.610804669704679011e-05,
  -9.797318101071626826e-05,-6.929109468496963365e-05,
   1.328031791882058811e-04,-1.877852912171378800e-04,
  -1.572527662885338861e-05, 1.235781837324199660e-05,
  -2.472881952944036088e-05,-3.144018900516295129e-05,
  -6.919743363349110249e-05, 7.219220995743650337e-05,
  -1.227266337398235350e-04,-1.176357656960297685e-04,
   9.899669878420657373e-06, 1.737804753987889247e-05,
   3.714817042612524950e-05, 5.932970111159799169e-05,
  -1.028671034390608136e-04, 7.948810621758176304e-05,
  -1.598873785018722557e-04,-6.002182586279812292e-06,
   4.501636939710063989e-06,-1.199155338764041782e-04,
  -1.923732214764384057e-03,-1.554167490257016965e-04,
   1.127377817059318116e-04,-1.395453400359906527e-03,
  -4.595729779263139704e-06, 3.973511378863780536e-05,
  -2.980133534147834555e-05,-3.446797334447405811e-06,
   3.969406764698693287e-05, 4.937711376379323314e-06,
  -3.703283532284543096e-06, 2.977055073524018949e-05,
  -7.241759952414215471e-06,-1.864287833977387062e-05,
   5.239017813313480068e-05,-2.924498649646472683e-05,
   4.874161368140132267e-05, 8.731698056926288801e-05,
  -1.057939542818239057e-05,-2.807269834508527588e-05,
   3.743091437177656990e-05,-1.410413589316022715e-05,
  -9.972758721193243915e-06, 7.376201521542891480e-07,
  -1.955397699899658095e-05, 4.200236127018659615e-06,
  -7.447791871745585002e-07, 9.972226630113838937e-06,
   1.996071201858567789e-05,-1.252986716246179112e-06,
   1.992575547225790218e-05, 1.721705218608667970e-06,
   2.329488251937763032e-06,-9.724889947145106813e-06,
   9.719103878086807883e-06,-2.353512227917667860e-06,
   6.846675073774693497e-06, 7.288555442208854523e-06,
  -1.179236187746358076e-05, 1.615364359365848243e-05,
   7.226395392387547408e-05, 3.432085318415035335e-05,
  -5.679421459920418246e-05, 1.169376636848006343e-04,
   6.292825597056625378e-05,-1.250601239424577226e-04,
   8.933149184014920418e-05, 4.494312589944493547e-05,
   1.530533784448585670e-04, 1.848639049317494707e-04,
  -2.221340035467318352e-04, 1.864309107103769188e-04,
  -8.785069398205962120e-06,-4.777295853168939108e-06,
  -9.334004207206064935e-06, 1.768831154915187468e-05,
  -2.975515294550219909e-05, 9.547057595505420381e-05,
  -1.430100860617342378e-04,-4.525610770509723657e-05,
   1.520055811027059178e-04, 4.994300064702460179e-05,
  -2.805559755781193940e-05, 8.551539888040105030e-05,
  -2.089613185097772320e-06, 9.779239067364370547e-06,
   1.351787664227529443e-03, 1.811151597973587523e-03,
  -1.594797100323810035e-03, 1.190261403557541084e-03,
  -4.786360693124092763e-05,-1.445943053967429067e-05,
   7.037869734578239426e-06,-1.872080098711344551e-05,
  -1.086041905668126342e-04,-1.746796471622976001e-05,
   3.054682236241533576e-05,-1.875283755690296630e-04,
  -2.537260163755276256e-05, 1.478385304517805803e-04,
  -1.971209684821274312e-04,-3.381307121023061345e-05,
  -9.978300718524354997e-06,-6.584183857520550440e-07,
  -1.421177910988638478e-05,-1.407214747406368710e-05,
   1.947102443435436801e-05, 4.569377143197443827e-06,
   1.015001150978308402e-06,-1.299960375267781329e-04,
   2.199878166207071381e-04, 2.315283666018338185e-06,
   9.649638176395616376e-06,-2.623829846740883024e-06,
  -1.999548338253224989e-04,-4.250227039543816243e-06,
   5.099644270798378661e-06,-2.399458139420467451e-04,
  -1.499897844778788183e-06,-1.994367835819731781e-05,
  -2.981225541211717731e-06, 2.985150405377301727e-05,
  -1.990241431021803035e-05,-1.973297905646434097e-06,
   1.288587953748138409e-04,-1.718752031422374711e-05,
   3.479762822254378883e-05, 2.576608722140123829e-04,
   8.044320582099406640e-06, 1.831089583751739687e-05,
  -3.188022199482164746e-05,-2.479589712947706331e-04,
   3.074792703870984413e-04,-3.945248131889317659e-05,
  -3.661920992418256355e-06,-1.966190058578484766e-05,
  -1.921042565647080867e-05, 2.304255945196210303e-05,
   1.637314103494895851e-05, 1.148565421078271235e-05,
   2.877194066900949589e-05,-2.778804473400382311e-05,
   2.778804473400387732e-05, 2.877194066900944506e-05,
  -2.997983310368258658e-05, 1.099821383379012726e-06,
  -1.669909773111775182e-06,-3.996512731556933626e-05,
   5.097419362847819071e-05, 1.621777777129974657e-04,
  -1.150488368666701192e-04, 3.411400204646659217e-05,
   2.790400115111555659e-04,-7.897260269140294437e-05,
   8.712751122317339387e-05, 3.079103713551328402e-04,
   1.898401999223916012e-05,-6.293408054008893376e-06,
   1.442656849008083650e-05, 1.385186347034242084e-05,
  -8.747186957969220553e-05, 9.617001628487599062e-05,
  -1.183630969660002977e-04,-1.076576856365453174e-04,
  -3.562612377819633440e-06,-1.968013701795306259e-05,
  -6.421974238273795380e-06,-3.948111253350072364e-05,
   4.929706110032918846e-05,-8.354625477566968709e-06,
  -1.787106423801312677e-04, 8.979146006208401818e-05,
  -6.030343133045057251e-05,-1.263467299528311168e-04,
   1.562695824339204332e-04, 3.463810295121950858e-04,
  -3.737093300690866554e-04, 1.686455947225258740e-04,
  -1.646888808547722669e-05, 1.134793925027915759e-05,
  -6.954922354175779842e-05, 7.931299057443376064e-06,
  -9.738458922891217448e-06,-8.947157323869499431e-05,
   8.998521529526264248e-05,-4.361950284293978269e-05,
   5.234340341152831386e-05, 1.079822583543148809e-04,
   1.294916225340432167e-05,-3.784599314240556165e-05,
   3.784599088234984622e-05, 1.294916885877593803e-05,
  -8.077095638823491132e-06, 2.889222258742478024e-05,
  -2.325727745290572388e-05,-1.684016004837203540e-04,
   2.771853258004899358e-04,-3.960170653994896567e-05,
   3.940605909201731500e-04,-1.132088807631448081e-04,
   7.778206551797047907e-05, 2.689794607098432958e-04,
  -1.139040106827863332e-04,-1.643954876216975104e-04,
   1.005474180263142049e-04,-6.549974601661922506e-05,
   6.557201168200347520e-06,-7.550040585304957139e-06,
   1.512385850602242201e-05, 1.308697458887321638e-05,
  -4.035688538908729223e-04, 2.598695445203367269e-04,
  -2.923411136755929172e-04,-4.540227673310162160e-04,
  -1.797483158976098834e-05,-2.401885570379510014e-05,
   3.360810931576872491e-05,-2.169089643650855807e-05,
   4.100311639724222405e-06, 3.978928806170251741e-05,
  -3.979118951164367478e-05, 4.081817885263688142e-06,
  -2.300329611250883396e-04,-1.211810083966278118e-04,
   1.213492777284159416e-04,-2.299442384466107020e-04,
   1.256618354255854017e-05,-2.724134782228535313e-05,
   6.241161243702637342e-04,-2.699612255510807821e-04,
   2.421710993914137015e-04, 5.598688762733234747e-04,
  -9.326370591231725258e-05, 3.061076300249649393e-04,
  -2.869490315903266476e-04,-8.752287283546912329e-05,
   1.761592231261769435e-05,-9.469914523152681940e-06,
   4.124234426841972336e-05, 9.109922633724804627e-05,
  -9.144630455627763600e-05, 4.046694185382084154e-05,
   1.378367116741284688e-04,-1.307709482831075250e-04,
   8.602263316788224417e-05, 9.746849020511174169e-05,
  -1.607628317846155873e-05, 2.532889889367309386e-05,
  -3.891142381250101362e-04,-4.434975870152992701e-04,
   4.509973668963992944e-04,-3.957289161187422036e-04,
   3.828948843425460211e-05,-3.215454984046711300e-05,
   2.608153601367132798e-05, 3.032743772836020077e-05,
   3.277268289421617854e-06,-9.447725258449861865e-06,
   1.146046764885680195e-05, 1.639078037402449874e-05,
   1.742780248107386152e-05, 9.811814341938798010e-06,
   4.997575811338566187e-05, 1.556791891155394954e-06,
  -2.219927953953084211e-06, 6.996479057268203581e-05,
  -1.763558040115296708e-05, 9.433255213046526691e-06,
  -3.678668577369942691e-05, 4.739978638967796287e-05,
  -7.109966032304968929e-05,-5.518005347901498904e-05,
  -1.868154672911185937e-05, 7.141415252455922883e-06,
   1.096209618493181807e-04, 1.165471781006744610e-04,
  -1.314092850495580695e-04, 1.230105678499371867e-04,
   8.658702705680121976e-05,-5.002686023992286595e-05,
   6.545292718142124895e-05, 1.123205872642391593e-04,
   3.497300803546865827e-04, 2.831763953706319050e-04,
  -4.766633654291130355e-05, 6.424889384711553121e-05,
   4.033510551117449858e-06,-9.150453138179782682e-06,
  -1.910006347797938949e-04, 1.613033090600307249e-04,
  -1.006167115200486463e-05, 3.871385764334153153e-05,
   4.520611461443439891e-04,-5.344536651073337379e-04,
   5.191722933627658651e-04, 4.391584336027788303e-04,
   3.669347397205430868e-05, 3.396452513818165315e-05,
  -4.012687081945046612e-05, 4.460755808424324206e-05,
   1.513812268004953963e-05,-1.307047213086695766e-05,
   1.279590137187267153e-05,-2.713420181397099948e-05,
   5.758497747487996421e-05,-8.175555252836083869e-05,
   7.326313128644047930e-05, 5.227345018368108353e-05,
   5.982344172044066067e-05, 4.599545708115093108e-06,
  -3.837748971792398889e-06, 4.985249926362275003e-05,
   1.479242169807219661e-05,-7.862050788634225183e-05,
   1.080845622245859829e-04, 2.043838077538437771e-05,
   1.298568527472537083e-05, 3.783347694761586398e-05,
  -3.783360386586841006e-05, 1.298531549561069380e-05,
   4.755504606212853215e-05, 5.136650264548709772e-05,
  -6.604979559627027850e-05, 6.113447882897928910e-05,
   7.045380989308570386e-07, 1.998758679949020077e-05,
   8.429480589182428369e-04, 9.896658880480656718e-04,
  -8.721022614960269054e-04, 7.341918315355431450e-04,
  -1.873322269476242283e-05,-7.004738929356199491e-06,
   2.570288336484987158e-06,-1.983415281445944075e-05,
  -4.244102932148682356e-05, 2.643405058126158927e-05,
  -2.643917627949315114e-05,-4.243783639232668150e-05,
  -2.055099896447549665e-04, 3.431699930882837471e-04,
  -2.140971968203735640e-04,-1.290828815670700032e-04,
   6.802614505630953353e-04, 4.210039891471261666e-04,
  -3.946542850663460503e-04, 6.377679791889612725e-04,
  -7.617382051565586256e-06, 6.478849487407966816e-06,
  -3.503315660908228491e-05, 4.871014204458363469e-05,
  -5.713682725480313530e-05,-4.043986858602269697e-05,
  -2.488654679078364543e-06,-9.685380626919180114e-06,
  -1.668193501574886942e-05, 1.103236348795360561e-05,
  -3.717781978695908061e-05,-1.475837782035661318e-05,
   1.129905299110620628e-05,-1.650246652789133636e-05,
   3.934227435516295438e-05,-7.223949651201032466e-06,
  -1.033703056352627798e-04,-3.761090151634711597e-05,
   6.562202742987041681e-05,-1.783080186530974190e-04,
   9.853492695607399417e-05,-1.705485765877754099e-05,
   2.729181711800396305e-05, 1.576551829734672229e-04,
   8.755687164705618780e-04, 8.820103592414795207e-05,
  -7.645369323706131023e-05, 7.862918241915105560e-04,
   8.308047028952257303e-05,-5.565640534989443487e-05,
   7.156062208507218850e-05, 1.085314579594205702e-04,
   2.842917117338796226e-05, 9.580304086729547985e-06,
  -4.473119645996012579e-05, 2.357946565621461485e-04,
  -2.378464397119487903e-04,-3.207913833553376531e-05,
   5.135090526676664444e-04, 2.234019982640167217e-04,
  -2.418274389809512673e-04, 5.161583959947898701e-04,
  -2.451774298660398254e-06, 1.984915118559049113e-05,
  -3.151641472602134024e-04, 7.353037197524181241e-04,
  -6.440109671929246903e-04,-2.743171050722752581e-04,
  -5.901226846694291423e-05,-3.765039402696144307e-05,
   2.972063999843116701e-05,-5.212181460850776244e-05,
   2.766626687770011396e-05,-1.160076191686880538e-05,
   7.719967919853879492e-06, 1.844998903296224423e-05,
   9.938211960098526198e-06,-1.109929293313149156e-06,
  -7.776694502790392041e-06, 2.897452368219829411e-05,
   3.415308203639069105e-05, 2.082227142786222988e-05,
  -1.032810105601688208e-05, 1.712688905133395763e-05,
  -1.197140042281937764e-04, 8.279927031804222662e-06,
  -6.003442057071223671e-05,-2.220267289015870967e-04,
  -1.039466796619649164e-04, 1.824694160325309258e-04,
  -1.816273327091840026e-04,-1.054111569661740514e-04,
  -3.898400787182546840e-06,-2.799728602405999133e-04,
   2.599749168028552600e-04,-3.611458617855627135e-06,
  -6.199003326208954239e-05,-1.365914923271761860e-04,
   2.191316530709522563e-04,-9.788421028129012903e-05,
  -2.286443919966892266e-05,-1.942208588397866491e-05,
   8.690932723720352915e-03, 1.097856270996679009e-03,
  -9.710340558397119372e-04, 7.688926639160987599e-03,
   1.405176058940949295e-05, 1.090987993716609103e-04,
  -1.487913794986384119e-04, 1.900329936858759867e-05,
   5.999292540638705634e-05, 9.213583361966300549e-07,
  -6.997565049505737587e-05,-1.846168408779711367e-06,
   2.588275600853504133e-06,-8.996277468716728360e-05,
  -5.499327701878764263e-05,-2.399457194314753722e-05,
   2.007142636156774673e-05,-4.579451761741970642e-05,
  -9.346755396100487337e-06,-6.937318043426772096e-05,
   7.925936463031607484e-05,-1.086062237620859002e-05,
   6.971230607946499538e-05,-3.924531030687600745e-05,
   4.424815218156810182e-05, 7.837155752259101311e-05,
   2.041696585901199427e-05,-2.198061657715585107e-05,
   1.510874494180105361e-05, 1.310442010481963856e-05,
  -6.366840490486584637e-04, 2.032617382019302928e-03,
  -1.810623171508371010e-03,-5.758851715376666052e-04,
  -1.999063552722686962e-05, 6.119568755843598528e-07,
   1.999911066968701467e-03, 5.340933665719037153e-04,
  -2.465649061417990798e-04, 9.174452283702203264e-04,
   1.248937882858736407e-05,-2.727664599022456372e-05,
   2.968794905684840095e-05, 4.315747999822760560e-06,
   2.651766900637173802e-05,-5.382205152601034036e-05,
   5.445630096895279855e-05, 2.518950743422408727e-05,
   1.561991703472931560e-05, 2.561285208304949886e-05,
   4.534241936363629773e-06, 1.947923638294174546e-05,
  -1.947923638294175562e-05, 4.534241936363596738e-06,
   7.087556708937279009e-05, 3.710328812598442271e-05,
  -2.782746609448840682e-05, 5.315667531702954852e-05,
  -1.106401571711365634e-04, 3.739769453069883795e-04,
  -3.932641525636478529e-04,-1.159452729023304829e-04,
   2.353129622936013835e-04, 2.168589628689811645e-04,
  -1.720825629117688708e-04, 1.949040572736162723e-04,
  -9.636549785887717429e-04,-1.107658893390649029e-04,
   1.212431672596591439e-04,-8.716077640732937219e-04,
  -2.897317534980867822e-04, 7.781716401234278703e-05,
  -7.247779356352522615e-05,-2.704569641184397335e-04,
  -9.979567136974872423e-05, 8.331160768981181735e-05,
  -1.157312649140958212e-04,-1.378632449980174294e-04,
  -1.746369556842395671e-06,-4.996949262671109351e-05,
   5.996339151781119464e-05,-2.095633002624461451e-06,
  -6.912120543037468783e-05,-1.105707736483471542e-05,
   2.192002484477282196e-05,-1.281386456569778864e-04,
   1.053095625627757323e-04,-5.753169589745139395e-05,
   5.602797584808261541e-05, 1.061172272647880303e-04,
  -4.710143750307999944e-04,-2.429927128832156823e-04,
   2.425951731710311620e-04,-4.599430203341685233e-04,
  -1.728251261638585076e-04,-5.010304140134072895e-04,
   4.309059555830948391e-04,-1.296921641542769137e-04,
  -5.762400217281803296e-05,-1.275910434693088328e-04,
   2.003966253458710708e-04,-9.078101425951678213e-05,
  -2.925704221307597898e-05,-2.727683047830686914e-05,
  -4.995321984686152815e-05, 2.162366049289534728e-06,
  -8.737345652086909373e-07,-1.998090558281980392e-05,
  -1.356237590716561771e-05,-1.469904621915087631e-05,
   1.502197827622246282e-07, 4.999977433965944356e-05,
  -3.881348354525073808e-05,-9.670237591835595313e-06,
  -5.533010781279511865e-08,-9.999846927786916514e-06,
  -4.080296066235589984e-06, 1.957935606734456462e-05,
  -3.600169443193974346e-05,-1.743209677661408162e-05,
  -1.382390427998693131e-05, 1.445336190848893946e-05,
  -2.153164400315825993e-05, 2.088990920327943968e-05,
  -3.908884691495792540e-05,-6.980015792861063483e-05,
   6.875122777000143375e-05, 1.316315616094341495e-05,
  -8.594254505547603898e-06,-4.925585030728710088e-05,
   3.566849338375212698e-04,-3.230367758936019545e-03,
   2.793755081558671471e-03, 3.017159993522074667e-04,
  -1.381748908122452974e-05, 3.753767434844946648e-05,
   4.999895216955295901e-05, 3.237003965951588866e-07,
  -9.767252807445236595e-07, 4.999045916698460009e-05,
  -1.217118230772511666e-03, 3.852301028258460491e-03,
  -3.397514087475458650e-03,-1.063248806914825250e-03,
   6.339804500865487585e-05, 6.770381731402452287e-04,
  -5.675026810520681503e-04, 5.329828326235847848e-05,
   3.717291235355341290e-04, 6.049111163762024802e-04,
  -5.342342543067287461e-04, 3.146327407078504347e-04,
  -1.697461242941343694e-05, 1.057650853879497232e-05,
  -2.971861623581627387e-05,-4.099249812865457108e-06,
   2.863765588990051188e-06,-3.989735388031788617e-05,
   1.322857233246955803e-03,-7.884470435268361695e-04,
   7.044603641351252247e-04, 1.198263575079626039e-03,
  -4.421455678123138722e-03,-2.867687166758721255e-03,
   2.516976821640791191e-03,-3.862243865853504793e-03,
  -2.181144103571810728e-03,-2.874202488585693134e-04,
   2.509119161096149092e-04,-1.903534399572070221e-03,
  -2.196222849255716539e-04, 6.830850579591846486e-05,
  -6.540265768634423655e-05,-2.100535464293875807e-04,
  -4.550606087969181888e-05,-2.071710460498237569e-05,
   2.071765262258848646e-05,-4.550581138502809341e-05,
  -8.223224613715350369e-06,-1.823125275323629792e-05,
  -2.215690492250332419e-05, 2.022551765110470378e-05,
  -1.129030097367285265e-05,-1.650845552811897428e-05,
   7.481623911932385254e-05,-9.382180111274860258e-05,
   1.015005972948415034e-04, 8.122578869294166688e-05,
  -2.399956550170159232e-04,-1.444151291755753814e-06,
   1.462624091158710278e-06,-2.599958859881593642e-04,
  -5.842858154597439134e-05,-5.464522722548989829e-05,
   6.812008924081571068e-05,-7.320965402065020137e-05,
   3.991138732075416188e-05, 3.011778813480073860e-05,
  -3.045209873454584080e-05, 3.965689955936383489e-05,
  -1.883916870922587052e-05,-3.528577223677165195e-05,
   3.529005894688586796e-05,-1.883113749950653140e-05,
   9.689660075855766565e-06, 2.471940050722678996e-06,
   1.136042755029022353e-04, 2.776581866026295786e-04,
  -2.900756073784399591e-04, 1.093441448090804461e-04,
   8.562944583732115230e-05,-2.770555910992023366e-05,
  -8.944134842900133549e-05, 1.001225205445719935e-05,
  -5.323098688387554226e-06,-8.984244331246612071e-05,
  -2.857937545029332060e-03, 1.085955280465738328e-04,
  -9.883022340506251655e-05,-2.598120972345534154e-03,
  -2.975303979037998334e-05,-3.841435048528810559e-06,
  -8.665134021136279883e-06, 4.991538079164238994e-06,
  -5.278085216089799117e-06,-8.493633877893155847e-06,
   8.472311622334046278e-06, 5.312243949035423565e-06,
  -2.217901450603758196e-07,-1.999877019047806913e-05,
   3.885055943098031199e-04, 3.410869669141111763e-05,
  -3.046559820806317046e-05, 3.486715464815344999e-04,
   1.994240131980498133e-03,-1.353183762834303311e-03,
   1.220980152615907741e-03, 1.769663094184323630e-03,
   9.385303761109790865e-06, 1.766114586632754375e-05,
  -2.393255579245337516e-05, 1.808957636986301956e-05,
   1.458087265675766625e-05,-1.368934449005563967e-05,
  -1.332917007911806821e-04,-2.909180683632324287e-04,
   2.545890426762052326e-04,-1.165522172642516926e-04,
   3.156775669914552716e-05,-3.485734882875970130e-04,
   3.562905354975348703e-04, 5.154662273010580763e-05,
  -2.286396266626475863e-05, 4.446615804401872647e-05,
  -4.446050611790673760e-05,-2.287495127294433565e-05,
  -1.950124630436015586e-05,-4.438625077282316469e-06,
  -4.548382608921884524e-05, 2.076587499446376432e-05,
  -2.076921701541867369e-05,-4.548230012396518602e-05,
   1.225990469828655040e-02,-7.835638888369689248e-03,
   6.868675371977174191e-03, 1.078913335881961401e-02,
   5.405891167338749509e-05,-4.447059779999464545e-05,
  -1.720569365191916989e-03,-2.614678003036527681e-03,
   2.279104479116016505e-03,-1.466213754291410213e-03,
   2.720006043977204682e-05,-1.265530371317684778e-05,
  -1.281700401961230458e-05,-1.535331911871964272e-05,
   3.200189750616768650e-05,-3.841716486161802477e-05,
   2.779870660648760294e-05, 2.876163957437792982e-05,
   5.002931223462430294e-06, 8.658561033642063666e-06,
  -3.505272950238653637e-04,-1.709696331026420437e-04,
   1.516630393338084691e-04,-3.264939853964107558e-04,
   3.050255396301433260e-05,-2.587651834643522647e-05,
   3.235257486371282993e-05, 3.812231498332514703e-05,
   9.929419948289195795e-06,-1.186009903211857111e-06,
  -4.999891610576994984e-05, 3.292237053718122317e-07,
  -1.848540847910477578e-07,-6.999975592076972380e-05,
  -3.252373305374011233e-05,-2.328533418804748932e-05,
   2.328007747990102223e-05,-3.252749594619612727e-05,
   5.505527273293557566e-04,-6.476045818477567991e-04,
   5.486183438887650777e-04, 4.662809375781394356e-04,
  -2.090922506059502946e-04,-1.950463371966989508e-05,
   2.151481130125635415e-05,-2.189454564376053344e-04,
  -2.765760908811968580e-05,-2.889734692889227240e-05,
   2.895245905212202219e-05,-2.759991150049575612e-05,
   1.302664000905106138e-05, 2.702418639061294982e-05,
   3.091287201515789532e-05, 2.538492355266149095e-05,
   1.977033316744748664e-05, 3.022238648440242471e-06,
   2.317444099920869680e-05,-1.177410093568684936e-04,
  -2.212425643211780239e-05,-4.483879210377878145e-05,
   1.229175329748557121e-04, 4.232351695423312469e-05,
  -9.992660486864846979e-06, 3.830618673922261103e-07,
   5.972288404283659062e-05,-1.484357676626691476e-04,
   1.113267788406973772e-04, 4.479227961328219516e-05,
   1.178375468652889235e-05,-1.615992343693832103e-05,
   2.423988515540744936e-05, 1.767563202979337918e-05,
   2.739258383141990007e-05, 1.223300253570778667e-05,
  -1.362372354404712337e-05, 2.672815288783301121e-05,
   6.021009327148610195e-04, 1.038014675630308291e-03,
  -9.772133645867368823e-04, 5.674099400548682053e-04,
  -7.305740507948585286e-05, 5.256058944734082308e-05,
  -8.869808608634706729e-03, 3.081979111900286228e-03,
  -2.727542011696539471e-03,-7.849625123178200978e-03,
  -3.603993839093178454e-05, 1.735289142413567830e-05,
  -9.909315662409556096e-06,-1.343675222189005507e-06,
  -1.817045271087270960e-05,-8.356712767705891222e-06,
  -1.464254659350865760e-05,-1.362335602033977710e-05,
   1.806698932955341292e-05,-1.085061468146657790e-04,
   9.849977667935671340e-05, 1.725670866987258654e-05,
  -1.715903620859000292e-05,-3.613263727424691495e-05,
   2.674562104557835600e-05,-1.358939862121632358e-05,
   2.505711789733137268e-03, 4.731896309011424714e-04,
  -4.193313348078129849e-04, 2.220756905122282191e-03,
   3.006526940670274780e-06,-1.977272858649063510e-05,
   9.985673430572364226e-06, 5.350945131106911871e-07,
  -2.886563482628301503e-05,-8.171604865366235873e-06,
   1.976758494610662332e-04,-9.656220036766916741e-05,
   1.489611423376883742e-04, 3.056314415655741459e-04,
  -9.353225375693541169e-06, 3.537961994069809317e-06,
  -6.073285837885938654e-05, 7.944507481986161931e-05,
  -1.381258299801349499e-04,-1.304655322002668124e-04,
  -2.450302511698112715e-04, 9.591976730641392111e-04,
  -8.440478912406842310e-04,-2.109103062729605774e-04,
   3.374097369094509243e-03, 7.662029390895798691e-04,
  -7.310177710128559206e-04, 3.105110790046531569e-03,
   5.095337294630482495e-05,-3.168207356526355346e-05,
  -1.037988757960746945e-05, 9.945983075510791884e-05,
  -1.094045577081738033e-04,-1.142990606605622374e-05,
  -5.343708729383323723e-05, 2.728511868310721657e-05,
  -1.384527638278619513e-05,-2.661406248366195818e-05,
   1.757020565294108649e-04, 9.554468761441270701e-05,
  -1.245266181298806615e-04, 2.282391758159296941e-04,
   8.073346411143633247e-06, 5.900938715634507777e-06,
   5.343132706282467261e-06,-1.927306236390715971e-05,
   3.903093850198867203e-05, 5.810839732477550445e-05,
   1.634846221684161405e-05,-1.152075445205313971e-05,
  -2.533195429003488069e-05, 4.310791217221710632e-05,
   2.805608303105067754e-04,-3.518318071116922452e-04,
   4.378351377389941724e-04, 3.491423666086314044e-04,
   8.097644265141125153e-06, 5.867551223059501667e-06,
  -3.701021132253535397e-06, 2.977083207736412745e-05,
  -2.969853509161864729e-05,-4.242288699734600127e-06,
  -2.263322625447984702e-04, 1.813110777954629420e-04,
  -1.996991144626725624e-04,-2.500405240812465378e-04,
  -4.205364279362263584e-05,-4.279592419596042893e-05,
   5.117813465696617256e-03, 9.962328308700450080e-03,
  -8.702186812817586450e-03, 4.463221333837670904e-03,
   2.588750525383911628e-04,-2.416003255886076809e-05,
   9.653740434988919786e-06, 3.498668393769462049e-04,
  -2.151597685765165350e-06, 9.765788621438106478e-06,
   9.999226612003866166e-06, 1.243670446449350868e-07,
  -5.561090923176247441e-06, 1.921130572720570735e-05,
  -1.920890268810527055e-05,-5.569385739819265122e-06,
   1.131319767001469832e-05,-1.649277291661938976e-05,
   4.981473589471977566e-05,-3.344386472492850781e-05,
   3.344675987419637995e-05, 4.981279207109201395e-05,
  -9.667408688116091941e-06,-2.557578788021495585e-06,
  -8.340117723052988699e-06,-5.517466480697226345e-06,
   1.271473926847440500e-04,-8.505489642186812600e-04,
   7.615340120814136863e-04, 1.138681186425123199e-04,
  -9.752382557546416023e-06,-2.211568323896969882e-06,
  -1.747452436193627624e-05, 9.728360515734174195e-06,
  -1.031828371905920951e-04,-3.657229854812242597e-04,
   3.368423875247172428e-04,-9.506422022321654448e-05,
  -6.728213603395902936e-04,-7.532671618162996817e-04,
   6.702840027474897848e-04,-6.005991638862003467e-04,
   5.363646318320114371e-06,-1.926736355010646239e-05,
   7.978102930445569974e-05,-5.915011675523673261e-06,
   6.067695899063759555e-06, 7.976956228083795339e-05,
  -1.959359969078914698e-05, 4.011340319283259111e-06,
  -2.091762510399222325e-05, 2.150471948221679158e-05,
   1.959094721602910871e-03,-1.065292387932822169e-03,
   7.023408353850565684e-04, 1.291362594684630207e-03,
   1.023204715302735057e-05,-2.820115620073448240e-05,
  -3.028087748622766261e-03, 4.028930948358473360e-03,
  -2.279545375345492543e-03,-1.710605998393837680e-03,
   1.369283372153559612e-05, 1.457759598405641391e-05,
   4.927150166592474692e-05,-8.504065121150908692e-06,
  -2.051668911554343518e-05, 6.692582063550764132e-05,
   1.550735784155797938e-05,-2.568115754349616957e-05,
  -3.723016413485137513e-05, 1.462582915571033178e-05,
   2.191755253730351912e-05, 5.585356650004133695e-05,
   9.869952155293283176e-06,-1.607496330391297553e-06,
   1.699052556205536755e-05,-2.472492752517473359e-05,
  -1.379361864948764084e-05,-1.448226793539281372e-05,
   4.868376625852914303e-05,-1.139696902184521655e-05,
   1.367226387828198319e-05, 5.842147893063497321e-05,
   4.248139496832771707e-03,-4.879980616298532081e-03,
   6.086776441040064184e-03, 5.298684040098981113e-03,
   1.332323878141104432e-04, 1.055894447250788607e-04,
  -1.304340199545091466e-04, 1.645811849468423074e-04,
  -2.995113650456370012e-05, 1.711555457761089324e-06,
  -4.644737908884002177e-05,-3.798211389295739213e-05,
   3.165175482196653346e-05,-3.870615476497398741e-05,
   2.476146242956591117e-05,-3.141448675928346849e-05,
  -1.777322585308752654e-03, 1.209803466581002964e-03,
  -1.041006070553838515e-03,-1.541397535053840983e-03,
  -2.374004967083512101e-03,-3.156992305385430443e-03,
   2.878556216988749882e-03,-2.145230548364305059e-03,
   4.768778151755788213e-05,-1.502915479771452085e-05,
   1.509694877456609450e-05, 6.835263080305048586e-05,
  -8.223787237579999152e-06, 1.823099897073707779e-05,
  -7.279775973398188978e-05,-3.317357649867504671e-05,
   2.080855510722831266e-05,-4.546431605500562994e-05,
   7.619464492307125242e-04,-4.599321781575073289e-04,
   4.343048890277384651e-04, 7.190127004209340275e-04,
  -1.625277046943944287e-04,-4.984721864629680660e-05,
   7.401969669534335414e-05,-2.492410168915408812e-04,
   1.659583303416624098e-05, 4.716543571199228340e-05,
  -5.659647877233958885e-05, 1.992080797990167945e-05,
  -1.988747523750864475e-04, 2.118567600403744401e-05,
  -2.338056642634176699e-05,-2.187540836500736705e-04,
  -2.446577295741559840e-04, 1.557003383413766069e-04,
  -1.356842271833149499e-04,-2.334304832143106799e-04,
  -2.438882419192278008e-05, 3.170465666957272908e-05,
  -7.442969871125300113e-05,-5.059861608534471292e-05,
   9.792724654918931782e-06,-2.835670192093824748e-05,
  -7.841363819342362401e-06,-8.965775489857366360e-05,
   2.988775162328709224e-04,-2.592740423702249482e-05,
  -1.850639562837778451e-04,-2.610581009748518997e-04,
   2.791286455239074546e-04,-1.564838625801038467e-04,
   5.576981065284325451e-05,-2.212980387951983308e-05,
   3.793860008801048703e-05, 8.161288270464419140e-05,
   9.370959713883416839e-06,-2.849886162710317945e-05,
   7.796717196504793888e-06,-6.261884776784576940e-06,
   3.031211039566634004e-05,-2.609934794896104105e-05,
   2.609939556308051264e-05, 3.031206939886905074e-05,
  -4.819441537577630243e-05, 5.076709885927238873e-05,
  -5.801954155345407337e-05,-5.507933185803017028e-05,
  -6.732319835088841010e-06,-2.923483999679268546e-05,
   9.057840058012679404e-06,-1.783130767732588032e-05,
   2.595540549826985788e-05, 1.504383346824813971e-05,
  -2.647419749244263234e-04,-2.584795673029386645e-04,
   2.593648126816795393e-04,-2.638747694316326536e-04,
   2.312298885878682000e-03,-2.410160547010137440e-03,
   2.070472913468548049e-03, 2.001884590727713489e-03,
   1.490774601344279108e-05, 3.711817760610939100e-05,
  -1.896923943111185663e-05, 6.337819451921232243e-06,
   1.216788952653386826e-05,-1.587269556408322870e-05,
   2.016867040750372586e-05, 2.220866348958179610e-05,
  -4.768041221859198130e-05, 3.642222248387849974e-05,
   3.046523484593887441e-06, 9.524636195562428549e-06,
  -9.998492208086478433e-06,-1.736478183968408079e-07,
  -3.003007660493287984e-06, 9.538445627617669597e-06,
  -1.627726316580833889e-05, 3.653834566357676994e-05,
  -3.655723582417882468e-05,-1.623479315837982983e-05,
  -6.451334309415895603e-05, 2.716668111520676378e-05,
  -3.512599723935573635e-05,-8.286232146120922149e-05,
   7.687587660073875832e-03,-4.178934788756565738e-03,
   3.705963475194832754e-03, 6.817876115075855586e-03,
  -2.659163440695505945e-05,-1.067374581839329920e-04,
   1.455122895208006836e-04,-3.641666649234488707e-05,
   4.896969931606196577e-05,-3.466941806397218337e-05,
  -7.966751876665245305e-06, 1.297556583141392381e-04,
  -1.397705523822886985e-04,-8.012033870989824862e-06,
   4.809899955108798929e-05, 1.207745264622653493e-04,
  -1.392467515352395458e-04, 5.577044187455626917e-05,
   2.135189246886730146e-05, 2.107360168547199068e-05,
  -4.104038136322982753e-05, 4.376856289119689520e-05,
  -2.843867249382655020e-05,-9.552062959846596287e-06,
  -7.709009156017952841e-06, 1.845457064882386885e-05,
  -1.463091266043650376e-05,-1.363584961499205234e-05,
  -6.621605583302765869e-05,-2.270317048161694124e-05,
   3.240957317554747836e-05,-9.460242896764772575e-05,
  -1.295517202045314768e-04, 1.078664878666155214e-05,
  -1.474002295844351743e-05,-1.793954618243855093e-04,
   8.746516186355947895e-06,-1.798606278766460434e-05,
  -1.975437641731539232e-05,-3.124837973881766513e-06,
   4.963192593166335140e-06,-8.681400767338117274e-06,
   2.775663035964747881e-05,-1.138285865140633180e-05,
  -2.212903692385741547e-05, 5.577011497946328394e-05,
   2.202364358343808094e-05,-3.339100362836803175e-05,
  -9.431707394517786349e-06,-3.323085256835660560e-06,
  -1.551949867055748221e-04,-1.261527490840229815e-04,
   1.317652564568223817e-04,-1.635173299404923399e-04,
   2.691470400706651189e-04,-9.423162265509384995e-04,
   8.202364677166758397e-04, 2.229621874391943986e-04,
  -5.896749232953280023e-05,-1.108308839477925407e-05,
   1.476040767663758675e-05,-7.862652456531103154e-05,
   1.702300063015872917e-05, 1.049844986393780044e-05,
   7.794859963954020403e-05, 1.800043927893632296e-05,
  -1.978537849751533034e-05, 8.779828470824505948e-05,
   3.903955070431201692e-05,-8.712834257889411597e-06,
  -3.646848712855379332e-05, 1.643318126701298965e-05,
  -6.131561245649630356e-05,-1.258586336692272926e-04,
   1.581253519535321834e-05,-1.224596793625215481e-05,
  -7.486429628860864489e-05, 1.414048695809710086e-04,
  -6.191476575097570759e-05,-3.265825748569271814e-05,
   3.303535558164269580e-06,-4.989074716634282568e-05,
   4.989572613767612723e-05, 3.227462345872336051e-06,
  -2.048335679851910884e-05, 2.191876123927994757e-05,
  -2.018250623632321047e-05, 5.650368520743381318e-05,
  -8.476584208565499622e-05,-3.024486758955642098e-05,
   1.034367861054660548e-05, 1.711748558643239087e-05,
  -4.868224404471175210e-05,-1.140346941816952092e-05,
  -8.916327158743290175e-06,-4.527594283751229476e-06,
   1.905445347551951935e-06,-9.816785524166891089e-06,
   5.672572746350401667e-05,-1.279929366947108675e-04,
   1.751107093123192165e-04, 7.373085842533266224e-05,
  -2.344610814067127886e-05,-3.240802389927451233e-05,
   2.652119907858359760e-04, 5.062212898934274365e-05,
  -5.166150966851898289e-05, 2.650114873336050576e-04,
  -6.871552142407553105e-06, 1.878248575546309944e-05,
  -1.734981476134600276e-05,-2.447414815161051666e-05,
  -1.908661886845964897e-05, 5.975029721278394420e-06,
  -5.288125655008163518e-07,-2.999533892574925511e-05,
   1.873870387972608685e-05,-4.635580844843436297e-05,
   6.488236471805776341e-05, 2.627315642614971687e-05,
  -5.526393992627251566e-07,-9.984717807448669323e-06,
  -1.425451808751890921e-04,-1.099130174695410212e-04,
  