/*
 * Copyright (c) 1999, 2001 Hewlett-Packard Co
 *                          David Mosberger-Tang <davidm@hpl.hp.com>
 * Copyright (c) 2000-2019 The strace developers.
 * All rights reserved.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

[1024 +   0] = { 0,	0,		SEN(printargs),			"ni_syscall"		},
[1024 +   1] = { 1,	TP|SE,		SEN(exit),			"exit"			},
[1024 +   2] = { 3,	TD,		SEN(read),			"read"			},
[1024 +   3] = { 3,	TD,		SEN(write),			"write"			},
[1024 +   4] = { 3,	TD|TF,		SEN(open),			"open"			},
[1024 +   5] = { 1,	TD,		SEN(close),			"close"			},
[1024 +   6] = { 2,	TD|TF,		SEN(creat),			"creat"			},
[1024 +   7] = { 2,	TF,		SEN(link),			"link"			},
[1024 +   8] = { 1,	TF,		SEN(unlink),			"unlink"		},
[1024 +   9] = { 3,	TF|TP|SE|SI,	SEN(execve),			"execve"		},
[1024 +  10] = { 1,	TF,		SEN(chdir),			"chdir"			},
[1024 +  11] = { 1,	TD,		SEN(fchdir),			"fchdir"		},
[1024 +  12] = { 2,	TF,		SEN(utimes),			"utimes"		},
[1024 +  13] = { 3,	TF,		SEN(mknod),			"mknod"			},
[1024 +  14] = { 2,	TF,		SEN(chmod),			"chmod"			},
[1024 +  15] = { 3,	TF,		SEN(chown),			"chown"			},
[1024 +  16] = { 3,	TD,		SEN(lseek),			"lseek"			},
[1024 +  17] = { 0,	PU|NF,		SEN(getpid),			"getpid"		},
[1024 +  18] = { 0,	PU|NF,		SEN(getppid),			"getppid"		},
[1024 +  19] = { 5,	TF,		SEN(mount),			"mount"			},
[1024 +  20] = { 2,	TF,		SEN(umount2),			"umount"		},
[1024 +  21] = { 1,	0,		SEN(setuid),			"setuid"		},
[1024 +  22] = { 0,	PU|NF,		SEN(getuid),			"getuid"		},
[1024 +  23] = { 0,	PU|NF,		SEN(geteuid),			"geteuid"		},
[1024 +  24] = { 4,	0,		SEN(ptrace),			"ptrace"		},
[1024 +  25] = { 2,	TF,		SEN(access),			"access"		},
[1024 +  26] = { 0,	0,		SEN(sync),			"sync"			},
[1024 +  27] = { 1,	TD,		SEN(fsync),			"fsync"			},
[1024 +  28] = { 1,	TD,		SEN(fdatasync),			"fdatasync"		},
[1024 +  29] = { 2,	TS,		SEN(kill),			"kill"			},
[1024 +  30] = { 2,	TF,		SEN(rename),			"rename"		},
[1024 +  31] = { 2,	TF,		SEN(mkdir),			"mkdir"			},
[1024 +  32] = { 1,	TF,		SEN(rmdir),			"rmdir"			},
[1024 +  33] = { 1,	TD,		SEN(dup),			"dup"			},
[1024 +  34] = { 0,	TD,		SEN(pipe),			"pipe"			},
[1024 +  35] = { 1,	0,		SEN(times),			"times"			},
[1024 +  36] = { 1,	TM|SI,		SEN(brk),			"brk"			},
[1024 +  37] = { 1,	0,		SEN(setgid),			"setgid"		},
[1024 +  38] = { 0,	PU|NF,		SEN(getgid),			"getgid"		},
[1024 +  39] = { 0,	PU|NF,		SEN(getegid),			"getegid"		},
[1024 +  40] = { 1,	TF,		SEN(acct),			"acct"			},
[1024 +  41] = { 3,	TD,		SEN(ioctl),			"ioctl"			},
[1024 +  42] = { 3,	TD,		SEN(fcntl),			"fcntl"			},
[1024 +  43] = { 1,	NF,		SEN(umask),			"umask"			},
[1024 +  44] = { 1,	TF,		SEN(chroot),			"chroot"		},
[1024 +  45] = { 2,	TSFA,		SEN(ustat),			"ustat"			},
[1024 +  46] = { 2,	TD,		SEN(dup2),			"dup2"			},
[1024 +  47] = { 2,	0,		SEN(setreuid),			"setreuid"		},
[1024 +  48] = { 2,	0,		SEN(setregid),			"setregid"		},
[1024 +  49] = { 3,	0,		SEN(getresuid),			"getresuid"		},
[1024 +  50] = { 3,	0,		SEN(setresuid),			"setresuid"		},
[1024 +  51] = { 3,	0,		SEN(getresgid),			"getresgid"		},
[1024 +  52] = { 3,	0,		SEN(setresgid),			"setresgid"		},
[1024 +  53] = { 2,	0,		SEN(getgroups),			"getgroups"		},
[1024 +  54] = { 2,	0,		SEN(setgroups),			"setgroups"		},
[1024 +  55] = { 1,	0,		SEN(getpgid),			"getpgid"		},
[1024 +  56] = { 2,	0,		SEN(setpgid),			"setpgid"		},
[1024 +  57] = { 0,	0,		SEN(setsid),			"setsid"		},
[1024 +  58] = { 1,	0,		SEN(getsid),			"getsid"		},
[1024 +  59] = { 2,	0,		SEN(sethostname),		"sethostname"		},
[1024 +  60] = { 2,	0,		SEN(setrlimit),			"setrlimit"		},
[1024 +  61] = { 2,	0,		SEN(getrlimit),			"getrlimit"		},
[1024 +  62] = { 2,	0,		SEN(getrusage),			"getrusage"		},
[1024 +  63] = { 2,	0,		SEN(gettimeofday),		"gettimeofday"		},
[1024 +  64] = { 2,	0,		SEN(settimeofday),		"settimeofday"		},
[1024 +  65] = { 5,	TD,		SEN(select),			"select"		},
[1024 +  66] = { 3,	TD,		SEN(poll_time64),		"poll"			},
[1024 +  67] = { 2,	TF,		SEN(symlink),			"symlink"		},
[1024 +  68] = { 3,	TF,		SEN(readlink),			"readlink"		},
[1024 +  69] = { 1,	TF,		SEN(uselib),			"uselib"		},
[1024 +  70] = { 2,	TF,		SEN(swapon),			"swapon"		},
[1024 +  71] = { 1,	TF,		SEN(swapoff),			"swapoff"		},
[1024 +  72] = { 4,	0,		SEN(reboot),			"reboot"		},
[1024 +  73] = { 2,	TF,		SEN(truncate),			"truncate"		},
[1024 +  74] = { 2,	TD,		SEN(ftruncate),			"ftruncate"		},
[1024 +  75] = { 2,	TD,		SEN(fchmod),			"fchmod"		},
[1024 +  76] = { 3,	TD,		SEN(fchown),			"fchown"		},
[1024 +  77] = { 2,	0,		SEN(getpriority),		"getpriority"		},
[1024 +  78] = { 3,	0,		SEN(setpriority),		"setpriority"		},
[1024 +  79] = { 2,	TF|TSF|TSFA,	SEN(statfs),			"statfs"		},
[1024 +  80] = { 2,	TD|TFSF|TSFA,	SEN(fstatfs),			"fstatfs"		},
[1024 +  81] = { 0,	PU|NF,		SEN(gettid),			"gettid"		},
[1024 +  82] = { 3,	TI,		SEN(semget),			"semget"		},
[1024 +  83] = { 3,	TI,		SEN(semop),			"semop"			},
[1024 +  84] = { 4,	TI,		SEN(semctl),			"semctl"		},
[1024 +  85] = { 2,	TI,		SEN(msgget),			"msgget"		},
[1024 +  86] = { 4,	TI,		SEN(msgsnd),			"msgsnd"		},
[1024 +  87] = { 5,	TI,		SEN(msgrcv),			"msgrcv"		},
[1024 +  88] = { 3,	TI,		SEN(msgctl),			"msgctl"		},
[1024 +  89] = { 3,	TI,		SEN(shmget),			"shmget"		},
[1024 +  90] = { 3,	TI|TM|SI,	SEN(shmat),			"shmat"			},
[1024 +  91] = { 1,	TI|TM|SI,	SEN(shmdt),			"shmdt"			},
[1024 +  92] = { 3,	TI,		SEN(shmctl),			"shmctl"		},
[1024 +  93] = { 3,	0,		SEN(syslog),			"syslog"		},
[1024 +  94] = { 3,	0,		SEN(setitimer),			"setitimer"		},
[1024 +  95] = { 2,	0,		SEN(getitimer),			"getitimer"		},
[1024 +  96] = { 2,	TF|TST|TSTA,	SEN(stat),			"stat"			},
[1024 +  97] = { 2,	TF|TLST|TSTA,	SEN(lstat),			"lstat"			},
[1024 +  98] = { 2,	TD|TFST|TSTA,	SEN(fstat),			"fstat"			},
[1024 +  99] = { 0,	0,		SEN(vhangup),			"vhangup"		},
[1024 + 100] = { 3,	TF,		SEN(chown),			"lchown"		},
[1024 + 101] = { 5,	TM|SI,		SEN(remap_file_pages),		"remap_file_pages"	},
[1024 + 102] = { 4,	TP,		SEN(wait4),			"wait4"			},
[1024 + 103] = { 1,	0,		SEN(sysinfo),			"sysinfo"		},
[1024 + 104] = { 5,	TP,		SEN(clone),			"clone"			},
[1024 + 105] = { 2,	0,		SEN(setdomainname),		"setdomainname"		},
[1024 + 106] = { 1,	0,		SEN(uname),			"uname"			},
[1024 + 107] = { 1,	0,		SEN(adjtimex64),		"adjtimex"		},
[1024 + 108] = { 2,	0,		SEN(create_module),		"create_module"		},
[1024 + 109] = { 3,	0,		SEN(init_module),		"init_module"		},
[1024 + 110] = { 2,	0,		SEN(delete_module),		"delete_module"		},
[1024 + 111] = { 1,	0,		SEN(get_kernel_syms),		"get_kernel_syms"	},
[1024 + 112] = { 5,	0,		SEN(query_module),		"query_module"		},
[1024 + 113] = { 4,	TF,		SEN(quotactl),			"quotactl"		},
[1024 + 114] = { 2,	0,		SEN(bdflush),			"bdflush"		},
[1024 + 115] = { 3,	0,		SEN(sysfs),			"sysfs"			},
[1024 + 116] = { 1,	NF,		SEN(personality),		"personality"		},
[1024 + 117] = { 5,	0,		SEN(afs_syscall),		"afs_syscall"		},
[1024 + 118] = { 1,	NF,		SEN(setfsuid),			"setfsuid"		},
[1024 + 119] = { 1,	NF,		SEN(setfsgid),			"setfsgid"		},
[1024 + 120] = { 3,	TD,		SEN(getdents),			"getdents"		},
[1024 + 121] = { 2,	TD,		SEN(flock),			"flock"			},
[1024 + 122] = { 3,	TD,		SEN(readv),			"readv"			},
[1024 + 123] = { 3,	TD,		SEN(writev),			"writev"		},
[1024 + 124] = { 4,	TD,		SEN(pread),			"pread64"		},
[1024 + 125] = { 4,	TD,		SEN(pwrite),			"pwrite64"		},
[1024 + 126] = { 1,	0,		SEN(printargs),			"_sysctl"		},
[1024 + 127] = { 6,	TD|TM|SI,	SEN(mmap),			"mmap"			},
[1024 + 128] = { 2,	TM|SI,		SEN(munmap),			"munmap"		},
[1024 + 129] = { 2,	TM,		SEN(mlock),			"mlock"			},
[1024 + 130] = { 1,	TM,		SEN(mlockall),			"mlockall"		},
[1024 + 131] = { 3,	TM|SI,		SEN(mprotect),			"mprotect"		},
[1024 + 132] = { 5,	TM|SI,		SEN(mremap),			"mremap"		},
[1024 + 133] = { 3,	TM,		SEN(msync),			"msync"			},
[1024 + 134] = { 2,	TM,		SEN(munlock),			"munlock"		},
[1024 + 135] = { 0,	TM,		SEN(munlockall),		"munlockall"		},
[1024 + 136] = { 2,	0,		SEN(sched_getparam),		"sched_getparam"	},
[1024 + 137] = { 2,	0,		SEN(sched_setparam),		"sched_setparam"	},
[1024 + 138] = { 1,	0,		SEN(sched_getscheduler),	"sched_getscheduler"	},
[1024 + 139] = { 3,	0,		SEN(sched_setscheduler),	"sched_setscheduler"	},
[1024 + 140] = { 0,	0,		SEN(sched_yield),		"sched_yield"		},
[1024 + 141] = { 1,	0,		SEN(sched_get_priority_max),	"sched_get_priority_max"},
[1024 + 142] = { 1,	0,		SEN(sched_get_priority_min),	"sched_get_priority_min"},
[1024 + 143] = { 2,	0,		SEN(sched_rr_get_interval_time64),"sched_rr_get_interval"},
[1024 + 144] = { 2,	0,		SEN(nanosleep_time64),		"nanosleep"		},
[1024 + 145] = { 3,	0,		SEN(nfsservctl),		"nfsservctl"		},
[1024 + 146] = { 5,	0,		SEN(prctl),			"prctl"			},
[1024 + 147] = { 0,	PU|NF,		SEN(getpagesize),		"getpagesize"		},
[1024 + 148] = { 6,	TD|TM|SI,	SEN(mmap_pgoff),		"mmap2"			},
[1024 + 149] = { 5,	0,		SEN(printargs),			"pciconfig_read"	},
[1024 + 150] = { 5,	0,		SEN(printargs),			"pciconfig_write"	},
[1024 + 151] = { MA,	0,		SEN(printargs),			"perfmonctl"		},
[1024 + 152] = { 2,	TS,		SEN(sigaltstack),		"sigaltstack"		},
[1024 + 153] = { 4,	TS,		SEN(rt_sigaction),		"rt_sigaction"		},
[1024 + 154] = { 2,	TS,		SEN(rt_sigpending),		"rt_sigpending"		},
[1024 + 155] = { 4,	TS,		SEN(rt_sigprocmask),		"rt_sigprocmask"	},
[1024 + 156] = { 3,	TS,		SEN(rt_sigqueueinfo),		"rt_sigqueueinfo"	},
[1024 + 157] = { 0,	TS,		SEN(rt_sigreturn),		"rt_sigreturn"		},
[1024 + 158] = { 2,	TS,		SEN(rt_sigsuspend),		"rt_sigsuspend"		},
[1024 + 159] = { 4,	TS,		SEN(rt_sigtimedwait_time64),	"rt_sigtimedwait"	},
[1024 + 160] = { 2,	TF,		SEN(getcwd),			"getcwd"		},
[1024 + 161] = { 2,	0,		SEN(capget),			"capget"		},
[1024 + 162] = { 2,	0,		SEN(capset),			"capset"		},
[1024 + 163] = { 4,	TD|TN,		SEN(sendfile),			"sendfile"		},
[1024 + 164] = { 5,	TN,		SEN(getpmsg),			"getpmsg"		},
[1024 + 165] = { 5,	TN,		SEN(putpmsg),			"putpmsg"		},
[1024 + 166] = { 3,	TN,		SEN(socket),			"socket"		},
[1024 + 167] = { 3,	TN,		SEN(bind),			"bind"			},
[1024 + 168] = { 3,	TN,		SEN(connect),			"connect"		},
[1024 + 169] = { 2,	TN,		SEN(listen),			"listen"		},
[1024 + 170] = { 3,	TN,		SEN(accept),			"accept"		},
[1024 + 171] = { 3,	TN,		SEN(getsockname),		"getsockname"		},
[1024 + 172] = { 3,	TN,		SEN(getpeername),		"getpeername"		},
[1024 + 173] = { 4,	TN,		SEN(socketpair),		"socketpair"		},
[1024 + 174] = { 4,	TN,		SEN(send),			"send"			},
[1024 + 175] = { 6,	TN,		SEN(sendto),			"sendto"		},
[1024 + 176] = { 4,	TN,		SEN(recv),			"recv"			},
[1024 + 177] = { 6,	TN,		SEN(recvfrom),			"recvfrom"		},
[1024 + 178] = { 2,	TN,		SEN(shutdown),			"shutdown"		},
[1024 + 179] = { 5,	TN,		SEN(setsockopt),		"setsockopt"		},
[1024 + 180] = { 5,	TN,		SEN(getsockopt),		"getsockopt"		},
[1024 + 181] = { 3,	TN,		SEN(sendmsg),			"sendmsg"		},
[1024 + 182] = { 3,	TN,		SEN(recvmsg),			"recvmsg"		},
[1024 + 183] = { 2,	TF,		SEN(pivotroot),			"pivot_root"		},
[1024 + 184] = { 3,	TM,		SEN(mincore),			"mincore"		},
[1024 + 185] = { 3,	TM,		SEN(madvise),			"madvise"		},
[1024 + 186] = { 2,	TF|TST|TSTA,	SEN(stat),			"stat"			},
[1024 + 187] = { 2,	TF|TLST|TSTA,	SEN(lstat),			"lstat"			},
[1024 + 188] = { 2,	TD|TFST|TSTA,	SEN(fstat),			"fstat"			},
[1024 + 189] = { 6,	TP,		SEN(clone),			"clone2"		},
[1024 + 190] = { 3,	TD,		SEN(getdents64),		"getdents64"		},
[1024 + 191] = { 2,	0,		SEN(printargs),			"getunwind"		},
[1024 + 192] = { 3,	TD,		SEN(readahead),			"readahead"		},
[1024 + 193] = { 5,	TF,		SEN(setxattr),			"setxattr"		},
[1024 + 194] = { 5,	TF,		SEN(setxattr),			"lsetxattr"		},
[1024 + 195] = { 5,	TD,		SEN(fsetxattr),			"fsetxattr"		},
[1024 + 196] = { 4,	TF,		SEN(getxattr),			"getxattr"		},
[1024 + 197] = { 4,	TF,		SEN(getxattr),			"lgetxattr"		},
[1024 + 198] = { 4,	TD,		SEN(fgetxattr),			"fgetxattr"		},
[1024 + 199] = { 3,	TF,		SEN(listxattr),			"listxattr"		},
[1024 + 200] = { 3,	TF,		SEN(listxattr),			"llistxattr"		},
[1024 + 201] = { 3,	TD,		SEN(flistxattr),		"flistxattr"		},
[1024 + 202] = { 2,	TF,		SEN(removexattr),		"removexattr"		},
[1024 + 203] = { 2,	TF,		SEN(removexattr),		"lremovexattr"		},
[1024 + 204] = { 2,	TD,		SEN(fremovexattr),		"fremovexattr"		},
[1024 + 205] = { 2,	TS,		SEN(kill),			"tkill"			},
[1024 + 206] = { 6,	0,		SEN(futex_time64),		"futex"			},
[1024 + 207] = { 3,	0,		SEN(sched_setaffinity),		"sched_setaffinity"	},
[1024 + 208] = { 3,	0,		SEN(sched_getaffinity),		"sched_getaffinity"	},
[1024 + 209] = { 1,	0,		SEN(set_tid_address),		"set_tid_address"	},
[1024 + 210] = { 4,	TD,		SEN(fadvise64),			"fadvise64"		},
[1024 + 211] = { 3,	TS,		SEN(tgkill),			"tgkill"		},
[1024 + 212] = { 1,	TP|SE,		SEN(exit),			"exit_group"		},
[1024 + 213] = { 3,	0,		SEN(lookup_dcookie),		"lookup_dcookie"	},
[1024 + 214] = { 2,	TM,		SEN(io_setup),			"io_setup"		},
[1024 + 215] = { 1,	TM,		SEN(io_destroy),		"io_destroy"		},
[1024 + 216] = { 5,	0,		SEN(io_getevents_time64),	"io_getevents"		},
[1024 + 217] = { 3,	0,		SEN(io_submit),			"io_submit"		},
[1024 + 218] = { 3,	0,		SEN(io_cancel),			"io_cancel"		},
[1024 + 219] = { 1,	TD,		SEN(epoll_create),		"epoll_create"		},
[1024 + 220] = { 4,	TD,		SEN(epoll_ctl),			"epoll_ctl"		},
[1024 + 221] = { 4,	TD,		SEN(epoll_wait),		"epoll_wait"		},
[1024 + 222] = { 0,	0,		SEN(restart_syscall),		"restart_syscall"	},
[1024 + 223] = { 4,	TI,		SEN(semtimedop_time64),		"semtimedop"		},
[1024 + 224] = { 3,	0,		SEN(timer_create),		"timer_create"		},
[1024 + 225] = { 4,	0,		SEN(timer_settime64),		"timer_settime"		},
[1024 + 226] = { 2,	0,		SEN(timer_gettime64),		"timer_gettime"		},
[1024 + 227] = { 1,	0,		SEN(timer_getoverrun),		"timer_getoverrun"	},
[1024 + 228] = { 1,	0,		SEN(timer_delete),		"timer_delete"		},
[1024 + 229] = { 2,	0,		SEN(clock_settime64),		"clock_settime"		},
[1024 + 230] = { 2,	0,		SEN(clock_gettime64),		"clock_gettime"		},
[1024 + 231] = { 2,	0,		SEN(clock_getres_time64),	"clock_getres"		},
[1024 + 232] = { 4,	0,		SEN(clock_nanosleep_time64),	"clock_nanosleep"	},
[1024 + 233] = { 3,	TD|TFSF|TSFA,	SEN(fstatfs64),			"fstatfs64"		},
[1024 + 234] = { 3,	TF|TSF|TSFA,	SEN(statfs64),			"statfs64"		},
[1024 + 235] = { 6,	TM,		SEN(mbind),			"mbind"			},
[1024 + 236] = { 5,	TM,		SEN(get_mempolicy),		"get_mempolicy"		},
[1024 + 237] = { 3,	TM,		SEN(set_mempolicy),		"set_mempolicy"		},
[1024 + 238] = { 4,	TD,		SEN(mq_open),			"mq_open"		},
[1024 + 239] = { 1,	0,		SEN(mq_unlink),			"mq_unlink"		},
[1024 + 240] = { 5,	TD,		SEN(mq_timedsend_time64),	"mq_timedsend"		},
[1024 + 241] = { 5,	TD,		SEN(mq_timedreceive_time64),	"mq_timedreceive"	},
[1024 + 242] = { 2,	TD,		SEN(mq_notify),			"mq_notify"		},
[1024 + 243] = { 3,	TD,		SEN(mq_getsetattr),		"mq_getsetattr"		},
[1024 + 244] = { 4,	0,		SEN(kexec_load),		"kexec_load"		},
[1024 + 245] = { 5,	0,		SEN(vserver),			"vserver"		},
[1024 + 246] = { 5,	TP,		SEN(waitid),			"waitid"		},
[1024 + 247] = { 5,	0,		SEN(add_key),			"add_key"		},
[1024 + 248] = { 4,	0,		SEN(request_key),		"request_key"		},
[1024 + 249] = { 5,	0,		SEN(keyctl),			"keyctl"		},
[1024 + 250] = { 3,	0,		SEN(ioprio_set),		"ioprio_set"		},
[1024 + 251] = { 2,	0,		SEN(ioprio_get),		"ioprio_get"		},
[1024 + 252] = { 6,	TM,		SEN(move_pages),		"move_pages"		},
[1024 + 253] = { 0,	TD,		SEN(inotify_init),		"inotify_init"		},
[1024 + 254] = { 3,	TD|TF,		SEN(inotify_add_watch),		"inotify_add_watch"	},
[1024 + 255] = { 2,	TD,		SEN(inotify_rm_watch),		"inotify_rm_watch"	},
[1024 + 256] = { 4,	TM,		SEN(migrate_pages),		"migrate_pages"		},
[1024 + 257] = { 4,	TD|TF,		SEN(openat),			"openat"		},
[1024 + 258] = { 3,	TD|TF,		SEN(mkdirat),			"mkdirat"		},
[1024 + 259] = { 4,	TD|TF,		SEN(mknodat),			"mknodat"		},
[1024 + 260] = { 5,	TD|TF,		SEN(fchownat),			"fchownat"		},
[1024 + 261] = { 3,	TD|TF,		SEN(futimesat),			"futimesat"		},
[1024 + 262] = { 4,	TD|TF|TFST|TSTA,SEN(newfstatat),		"newfstatat"		},
[1024 + 263] = { 3,	TD|TF,		SEN(unlinkat),			"unlinkat"		},
[1024 + 264] = { 4,	TD|TF,		SEN(renameat),			"renameat"		},
[1024 + 265] = { 5,	TD|TF,		SEN(linkat),			"linkat"		},
[1024 + 266] = { 3,	TD|TF,		SEN(symlinkat),			"symlinkat"		},
[1024 + 267] = { 4,	TD|TF,		SEN(readlinkat),		"readlinkat"		},
[1024 + 268] = { 3,	TD|TF,		SEN(fchmodat),			"fchmodat"		},
[1024 + 269] = { 3,	TD|TF,		SEN(faccessat),			"faccessat"		},
[1024 + 270] = { 6,	TD,		SEN(pselect6_time64),		"pselect6"		},
[1024 + 271] = { 5,	TD,		SEN(ppoll_time64),		"ppoll"			},
[1024 + 272] = { 1,	TP,		SEN(unshare),			"unshare"		},
[1024 + 273] = { 6,	TD,		SEN(splice),			"splice"		},
[1024 + 274] = { 2,	0,		SEN(set_robust_list),		"set_robust_list"	},
[1024 + 275] = { 3,	0,		SEN(get_robust_list),		"get_robust_list"	},
[1024 + 276] = { 4,	TD,		SEN(sync_file_range),		"sync_file_range"	},
[1024 + 277] = { 4,	TD,		SEN(tee),			"tee"			},
[1024 + 278] = { 4,	TD,		SEN(vmsplice),			"vmsplice"		},
[1024 + 279] = { 4,	TD,		SEN(fallocate),			"fallocate"		},
[1024 + 280] = { 3,	0,		SEN(getcpu),			"getcpu"		},
[1024 + 281] = { 6,	TD,		SEN(epoll_pwait),		"epoll_pwait"		},
[1024 + 282] = { 4,	TD|TF,		SEN(utimensat_time64),		"utimensat"		},
[1024 + 283] = { 3,	TD|TS,		SEN(signalfd),			"signalfd"		},
[1024 + 284] = { 4,	TD,		SEN(timerfd),			"timerfd"		},
[1024 + 285] = { 1,	TD,		SEN(eventfd),			"eventfd"		},
[1024 + 286] = { 2,	TD,		SEN(timerfd_create),		"timerfd_create"	},
[1024 + 287] = { 4,	TD,		SEN(timerfd_settime64),		"timerfd_settime"	},
[1024 + 288] = { 2,	TD,		SEN(timerfd_gettime64),		"timerfd_gettime"	},
[1024 + 289] = { 4,	TD|TS,		SEN(signalfd4),			"signalfd4"		},
[1024 + 290] = { 2,	TD,		SEN(eventfd2),			"eventfd2"		},
[1024 + 291] = { 1,	TD,		SEN(epoll_create1),		"epoll_create1"		},
[1024 + 292] = { 3,	TD,		SEN(dup3),			"dup3"			},
[1024 + 293] = { 2,	TD,		SEN(pipe2),			"pipe2"			},
[1024 + 294] = { 1,	TD,		SEN(inotify_init1),		"inotify_init1"		},
[1024 + 295] = { 4,	TD,		SEN(preadv),			"preadv"		},
[1024 + 296] = { 4,	TD,		SEN(pwritev),			"pwritev"		},
[1024 + 297] = { 4,	TP|TS,		SEN(rt_tgsigqueueinfo),		"rt_tgsigqueueinfo"	},
[1024 + 298] = { 5,	TN,		SEN(recvmmsg_time64),		"recvmmsg"		},
[1024 + 299] = { 2,	TD,		SEN(fanotify_init),		"fanotify_init"		},
[1024 + 300] = { 5,	TD|TF,		SEN(fanotify_mark),		"fanotify_mark"		},
[1024 + 301] = { 4,	0,		SEN(prlimit64),			"prlimit64"		},
[1024 + 302] = { 5,	TD|TF,		SEN(name_to_handle_at),		"name_to_handle_at"	},
[1024 + 303] = { 3,	TD,		SEN(open_by_handle_at),		"open_by_handle_at"	},
[1024 + 304] = { 2,	0,		SEN(clock_adjtime64),		"clock_adjtime"		},
[1024 + 305] = { 1,	TD,		SEN(syncfs),			"syncfs"		},
[1024 + 306] = { 2,	TD,		SEN(setns),			"setns"			},
[1024 + 307] = { 4,	TN,		SEN(sendmmsg),			"sendmmsg"		},
[1024 + 308] = { 6,	0,		SEN(process_vm_readv),		"process_vm_readv"	},
[1024 + 309] = { 6,	0,		SEN(process_vm_writev),		"process_vm_writev"	},
[1024 + 310] = { 4,	TN,		SEN(accept4),			"accept4"		},
[1024 + 311] = { 3,	TD,		SEN(finit_module),		"finit_module"		},
[1024 + 312] = { 3,	0,		SEN(sched_setattr),		"sched_setattr"		},
[1024 + 313] = { 4,	0,		SEN(sched_getattr),		"sched_getattr"		},
[1024 + 314] = { 5,	TD|TF,		SEN(renameat2),			"renameat2"		},
[1024 + 315] = { 3,	0,		SEN(getrandom),			"getrandom"		},
[1024 + 316] = { 2,	TD,		SEN(memfd_create),		"memfd_create"		},
[1024 + 317] = { 3,	TD,		SEN(bpf),			"bpf"			},
[1024 + 318] = { 5,	TD|TF|TP|SE|SI,	SEN(execveat),			"execveat"		},
[1024 + 319] = { 1,	TD,		SEN(userfaultfd),		"userfaultfd"		},
[1024 + 320] = { 2,	0,		SEN(membarrier),		"membarrier"		},
[1024 + 321] = { 5,	0,		SEN(kcmp),			"kcmp"			},
[1024 + 322] = { 3,	TM,		SEN(mlock2),			"mlock2"		},
[1024 + 323] = { 6,	TD,		SEN(copy_file_range),		"copy_file_range"	},
[1024 + 324] = { 6,	TD,		SEN(preadv2),			"preadv2"		},
[1024 + 325] = { 6,	TD,		SEN(pwritev2),			"pwritev2"		},
[1024 + 326] = { 5,	TD|TF|TSTA,	SEN(statx),			"statx"			},
[1024 + 327] = { 6,	0,		SEN(io_pgetevents_time64),	"io_pgetevents"		},
[1024 + 328] = { 5,	TD,		SEN(perf_event_open),		"perf_event_open"	},
[1024 + 329] = { 3,	0,		SEN(seccomp),			"seccomp"		},
[1024 + 330] = { 4,	TM|SI,		SEN(pkey_mprotect),		"pkey_mprotect"		},
[1024 + 331] = { 2,	0,		SEN(pkey_alloc),		"pkey_alloc"		},
[1024 + 332] = { 1,	0,		SEN(pkey_free),			"pkey_free"		},
[1024 + 333] = { 4,	0,		SEN(rseq),			"rseq"			},
/* [1024 + 334 ... 1024 + 423] - reserved to sync up with other architectures */
[1024 + 424] = { 4,	TD|TS,		SEN(pidfd_send_signal),		"pidfd_send_signal"	},
[1024 + 425] = { 2,	TD,		SEN(io_uring_setup),		"io_uring_setup"	},
[1024 + 426] = { 6,	TD|TS,		SEN(io_uring_enter),		"io_uring_enter"	},
[1024 + 427] = { 4,	TD|TM,		SEN(io_uring_register),		"io_uring_register"	},
