#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "endianess.h"
#include "libvga.h"
#include "svgalib_helper.h"

int __svgalib_pci_idev=0;

int __svgalib_pci_read_config_dword(int pos, int address);

static int proc_pci_read_config(int device, unsigned long *buf, int size)
{
   int i;

   for(i=0;i<size;i++) {
       buf[i]=__svgalib_pci_read_config_dword(device, i*4);
   }
   return 0;
};

/* 
   find a vga device of the specified vendor, and return
   its configuration (64 dwords) in conf 
   return zero if device found.
*/ 

int __svgalib_pci_find_vendor_vga(unsigned int vendor, unsigned long *conf, int cont)
{ unsigned long buf[64];
  int device;
  int s,f;
  
  if(__svgalib_pci_idev) {
      s=__svgalib_pci_idev;
      f=__svgalib_pci_idev+1;
  } else {
      s=1;
      f=17;
  }
  
  cont++;

  for(device=s;(device<f)&&cont;device++){
      proc_pci_read_config(device,buf,3); 
      if(((buf[0]&0xffff)==vendor)&&
        (((buf[2]>>16)&0xffff)==0x0300))  /* VGA Class */
              if(!(--cont)){
                proc_pci_read_config(device,buf,16); 
                memcpy(conf,buf,256); 
                return 0;
              };
    };

  return cont;
}

int __svgalib_pci_find_vendor_vga_pos(unsigned int vendor, unsigned long *conf, int cont)
{ unsigned long buf[64];
  int device;
  int s,f;
  
  if(__svgalib_pci_idev) {
      s=__svgalib_pci_idev;
      f=__svgalib_pci_idev+1;
  } else {
      s=1;
      f=17;
  }
  
  cont++;

  for(device=__svgalib_pci_idev;(device<32)&&cont;device++){
        proc_pci_read_config(device,buf,3); 
        if(((buf[0]&0xffff)==vendor)&&
           (((buf[2]>>16)&0xffff)==0x0300))  /* VGA Class */
              if(!(--cont)){
                proc_pci_read_config(device,buf,16); 
                memcpy(conf,buf,256); 
                return device;
              };
    };

  return 0;
}

int __svgalib_pci_read_config_byte(int pos, int address)
{
    pcic_t p;
   
    p.pcipos = pos;
    p.address = address;
    
    ioctl( __svgalib_mem_fd, SVGALIB_HELPER_IOCGPCIINB, &p);
    
    return p.val;
};

int __svgalib_pci_read_config_word(int pos, int address)
{
    pcic_t p;
   
    p.pcipos = pos;
    p.address = address;
    
    ioctl( __svgalib_mem_fd, SVGALIB_HELPER_IOCGPCIINW, &p);
    
    return p.val;
};

int __svgalib_pci_read_config_dword(int pos, int address)
{
    pcic_t p;
   
    p.pcipos = pos;
    p.address = address;
    
    if(ioctl( __svgalib_mem_fd, SVGALIB_HELPER_IOCGPCIINL, &p)) return -1;
    
    return p.val;
};

int __svgalib_pci_read_aperture_len(int pos, int address)
{
    pcic_t p;
   
    p.pcipos = pos;
    p.address = address;
    
    if(ioctl( __svgalib_mem_fd, SVGALIB_HELPER_IOCGPCIAPLEN, &p)) return -1;
    
    return p.val;
};

void __svgalib_pci_write_config_byte(int pos, int address, unsigned char data)
{
    pcic_t p;
   
    p.pcipos = pos;
    p.address = address;
    p.val = data;
    
    ioctl( __svgalib_mem_fd, SVGALIB_HELPER_IOCSPCIOUTB, &p);
};

void __svgalib_pci_write_config_word(int pos, int address, unsigned short data)
{
    pcic_t p;
   
    p.pcipos = pos;
    p.address = address;
    p.val = data;
    
    ioctl( __svgalib_mem_fd, SVGALIB_HELPER_IOCSPCIOUTW, &p);
};

void __svgalib_pci_write_config_dword(int pos, int address, unsigned int data)
{
    pcic_t p;
   
    p.pcipos = pos;
    p.address = address;
    p.val = data;
    
    ioctl( __svgalib_mem_fd, SVGALIB_HELPER_IOCSPCIOUTL, &p);
};

int memorytest(uint32_t *m, int max_mem) {
    unsigned char sav[1024];
    int i, j;

    max_mem*=4;
    for(i=0;i<max_mem;i++) {
        sav[i]=*(m+64*1024*i);
    }
    for(i=max_mem-1;i>=0;i--) {
        *(m+64*1024*i)=i;
    }
    for(i=0;i<max_mem;i++) {
//        printf("%i %i\n",i*256, *(m+64*1024*i));
        if(*(m+64*1024*i)!=i) break;
    }
    for(j=0;j<i;j++) {
        *(m+64*1024*j)=sav[j];
    }
    return i*256;
}
