#ifndef KERNEL_VERSION
# include <linux/version.h>
#endif
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)

# ifdef KERNEL_2_6
#  undef KERNEL_2_6
# endif

# define my_io_remap_page_range(vma, start, ofs, len, prot) io_remap_page_range(start,ofs,len,prot)

typedef void irqreturn_t;
# define IRQ_NONE
# define IRQ_HANDLED

#else /* Kernel 2.6 */

# ifndef KERNEL_2_6
#  define KERNEL_2_6
# endif

# define my_io_remap_page_range(vma, start, ofs, len, prot) io_remap_page_range(vma,start,ofs,len,prot)

# define pci_present() 1

# ifdef CONFIG_DEVFS_FS
typedef void* devfs_handle_t;
# endif

#endif


/* These are also not present in 2.6 kernels ... */
#if (!defined _LINUX_DEVFS_FS_KERNEL_H) || (defined KERNEL_2_6)
static inline int devfs_register_chrdev (unsigned int major, const char *name,
                                         struct file_operations *fops)
{
    return register_chrdev (major, name, fops);
}
static inline int devfs_unregister_chrdev (unsigned int major,const char *name)
{
    return unregister_chrdev (major, name);
}
#endif


/* Our main.c really do not like MINOR from 2.6 kernels ... */
#if (defined MINOR) && (!defined KERNEL_2_6)
# define my_minor(x) MINOR(x)
#else
# define my_minor(x) minor(x)
#endif
	
