#include <sys/ioctl.h>
#include "svgalib_helper.h"
#include "libvga.h"

void port_rep_outb(unsigned char* string, int length, int port)
{
  io_string_t iostr;

  iostr.port = port;
  iostr.string = string;
  iostr.length = length;
  
  ioctl(__svgalib_mem_fd,SVGAHELPER_REPOUTB,&iostr); 
}

void port_out(int value, int port)
{
    io_t iov;
    
    iov.val=value;
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGAHELPER_OUTB,&iov);
}

void port_outw(int value, int port)
{
    io_t iov;
    
    iov.val=value;
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGAHELPER_OUTW,&iov);
}

void port_outl(int value, int port)
{
    io_t iov;
    
    iov.val=value;
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGAHELPER_OUTL,&iov);
}

int port_in(int port)
{
    io_t iov;
    
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGAHELPER_INB,&iov);

    return iov.val;
}

int port_inw(int port)
{
    io_t iov;
    
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGAHELPER_INW,&iov);

    return iov.val;
}

int port_inl(int port)
{
    io_t iov;
    
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGAHELPER_INL,&iov);

    return iov.val;
}

