#ifndef KERNEL_VERSION
# include <linux/version.h>
#endif
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)

# ifdef KERNEL_2_6
#  undef KERNEL_2_6
# endif

# if defined (PG_chainlock)
#  define my_io_remap_page_range(vma, start, ofs, len, prot) \
		io_remap_page_range(vma,start,ofs,len,prot)
# else
#  define my_io_remap_page_range(vma, start, ofs, len, prot) \
		io_remap_page_range(start,ofs,len,prot)
# endif
# ifndef IRQ_HANDLED 
typedef void irqreturn_t;
#  define IRQ_NONE
#  define IRQ_HANDLED
# endif

#else /* Kernel 2.6 */

#define NO_TASK

# ifndef KERNEL_2_6
#  define KERNEL_2_6
# endif

# define my_io_remap_page_range(vma, start, ofs, len, prot) \
		io_remap_page_range(vma,start,ofs,len,prot)

# define pci_present() 1

# ifdef CONFIG_DEVFS_FS
typedef void* devfs_handle_t;
# endif

#endif

/* These are also not present in 2.6 kernels ... */
#if (!defined _LINUX_DEVFS_FS_KERNEL_H) || (defined KERNEL_2_6)
static inline int devfs_register_chrdev (unsigned int major, const char *name,
                                         struct file_operations *fops)
{
    return register_chrdev (major, name, fops);
}
static inline int devfs_unregister_chrdev (unsigned int major,const char *name)
{
    return unregister_chrdev (major, name);
}
#endif

#if (defined MINOR)
# define my_minor(x) MINOR(x)
#else
# define my_minor(x) minor(x)
#endif

#if !defined(MODULE_VERSION) 
# define MODULE_VERSION(x)
#endif
