#if NOHELPER
#include <sys/io.h>
void __svgalib_port_rep_outb(unsigned char* string, int length, int port)
{
	outsb(port, string, length);
}
void __svgalib_port_out(int value, int port)
{
	outb(value, port);
}
void __svgalib_port_outw(int value, int port)
{
	outw(value, port);
}
void __svgalib_port_outl(unsigned int value, int port)
{
	outl(value, port);
}
int __svgalib_port_in(int port)
{
	return inb(port);
}
int __svgalib_port_inw(int port)
{
	return inw(port);
}
int __svgalib_port_inl(int port)
{
	return inl(port);
}

#else
#include <sys/ioctl.h>
#include "svgalib_helper.h"
#include "libvga.h"

void __svgalib_port_rep_outb(unsigned char* string, int length, int port)
{
  io_string_t iostr;

  iostr.port = port;
  iostr.string = string;
  iostr.length = length;
  
  ioctl(__svgalib_mem_fd,SVGAHELPER_REPOUTB,&iostr); 
}

void __svgalib_port_out(int value, int port)
{
    io_t iov;
    
    iov.val=value;
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGAHELPER_OUTB,&iov);
}

void __svgalib_port_outw(int value, int port)
{
    io_t iov;
    
    iov.val=value;
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGAHELPER_OUTW,&iov);
}

void __svgalib_port_outl(int value, int port)
{
    io_t iov;
    
    iov.val=value;
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGAHELPER_OUTL,&iov);
}

int __svgalib_port_in(int port)
{
    io_t iov;
    
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGAHELPER_INB,&iov);

    return iov.val;
}

int __svgalib_port_inw(int port)
{
    io_t iov;
    
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGAHELPER_INW,&iov);

    return iov.val;
}

int __svgalib_port_inl(int port)
{
    io_t iov;
    
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGAHELPER_INL,&iov);

    return iov.val;
}
#endif
