/* A Bison parser, made by GNU Bison 3.0.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2013 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 22 "parser.y" /* yacc.c:339  */

#define yylex yylex

#include "swig.h"
#include "cparse.h"
#include "preprocessor.h"
#include <ctype.h>

/* We do this for portability */
#undef alloca
#define alloca malloc

/* -----------------------------------------------------------------------------
 *                               Externals
 * ----------------------------------------------------------------------------- */

int  yyparse();

/* NEW Variables */

static Node    *top = 0;      /* Top of the generated parse tree */
static int      unnamed = 0;  /* Unnamed datatype counter */
static Hash    *classes = 0;        /* Hash table of classes */
static Hash    *classes_typedefs = 0; /* Hash table of typedef classes: typedef struct X {...} Y; */
static Symtab  *prev_symtab = 0;
static Node    *current_class = 0;
String  *ModuleName = 0;
static Node    *module_node = 0;
static String  *Classprefix = 0;  
static String  *Namespaceprefix = 0;
static int      inclass = 0;
static Node    *currentOuterClass = 0; /* for nested classes */
static char    *last_cpptype = 0;
static int      inherit_list = 0;
static Parm    *template_parameters = 0;
static int      extendmode   = 0;
static int      compact_default_args = 0;
static int      template_reduce = 0;
static int      cparse_externc = 0;
int		ignore_nested_classes = 0;
int		kwargs_supported = 0;
/* -----------------------------------------------------------------------------
 *                            Assist Functions
 * ----------------------------------------------------------------------------- */


 
/* Called by the parser (yyparse) when an error is found.*/
static void yyerror (const char *e) {
  (void)e;
}

/* Copies a node.  Does not copy tree links or symbol table data (except for
   sym:name) */

static Node *copy_node(Node *n) {
  Node *nn;
  Iterator k;
  nn = NewHash();
  Setfile(nn,Getfile(n));
  Setline(nn,Getline(n));
  for (k = First(n); k.key; k = Next(k)) {
    String *ci;
    String *key = k.key;
    char *ckey = Char(key);
    if ((strcmp(ckey,"nextSibling") == 0) ||
	(strcmp(ckey,"previousSibling") == 0) ||
	(strcmp(ckey,"parentNode") == 0) ||
	(strcmp(ckey,"lastChild") == 0)) {
      continue;
    }
    if (Strncmp(key,"csym:",5) == 0) continue;
    /* We do copy sym:name.  For templates */
    if ((strcmp(ckey,"sym:name") == 0) || 
	(strcmp(ckey,"sym:weak") == 0) ||
	(strcmp(ckey,"sym:typename") == 0)) {
      String *ci = Copy(k.item);
      Setattr(nn,key, ci);
      Delete(ci);
      continue;
    }
    if (strcmp(ckey,"sym:symtab") == 0) {
      Setattr(nn,"sym:needs_symtab", "1");
    }
    /* We don't copy any other symbol table attributes */
    if (strncmp(ckey,"sym:",4) == 0) {
      continue;
    }
    /* If children.  We copy them recursively using this function */
    if (strcmp(ckey,"firstChild") == 0) {
      /* Copy children */
      Node *cn = k.item;
      while (cn) {
	Node *copy = copy_node(cn);
	appendChild(nn,copy);
	Delete(copy);
	cn = nextSibling(cn);
      }
      continue;
    }
    /* We don't copy the symbol table.  But we drop an attribute 
       requires_symtab so that functions know it needs to be built */

    if (strcmp(ckey,"symtab") == 0) {
      /* Node defined a symbol table. */
      Setattr(nn,"requires_symtab","1");
      continue;
    }
    /* Can't copy nodes */
    if (strcmp(ckey,"node") == 0) {
      continue;
    }
    if ((strcmp(ckey,"parms") == 0) || (strcmp(ckey,"pattern") == 0) || (strcmp(ckey,"throws") == 0)
	|| (strcmp(ckey,"kwargs") == 0)) {
      ParmList *pl = CopyParmList(k.item);
      Setattr(nn,key,pl);
      Delete(pl);
      continue;
    }
    if (strcmp(ckey,"nested:outer") == 0) { /* don't copy outer classes links, they will be updated later */
      Setattr(nn, key, k.item);
      continue;
    }
    /* Looks okay.  Just copy the data using Copy */
    ci = Copy(k.item);
    Setattr(nn, key, ci);
    Delete(ci);
  }
  return nn;
}

/* -----------------------------------------------------------------------------
 *                              Variables
 * ----------------------------------------------------------------------------- */

static char  *typemap_lang = 0;    /* Current language setting */

static int cplus_mode  = 0;

/* C++ modes */

#define  CPLUS_PUBLIC    1
#define  CPLUS_PRIVATE   2
#define  CPLUS_PROTECTED 3

/* include types */
static int   import_mode = 0;

void SWIG_typemap_lang(const char *tm_lang) {
  typemap_lang = Swig_copy_string(tm_lang);
}

void SWIG_cparse_set_compact_default_args(int defargs) {
  compact_default_args = defargs;
}

int SWIG_cparse_template_reduce(int treduce) {
  template_reduce = treduce;
  return treduce;  
}

/* -----------------------------------------------------------------------------
 *                           Assist functions
 * ----------------------------------------------------------------------------- */

static int promote_type(int t) {
  if (t <= T_UCHAR || t == T_CHAR) return T_INT;
  return t;
}

/* Perform type-promotion for binary operators */
static int promote(int t1, int t2) {
  t1 = promote_type(t1);
  t2 = promote_type(t2);
  return t1 > t2 ? t1 : t2;
}

static String *yyrename = 0;

/* Forward renaming operator */

static String *resolve_create_node_scope(String *cname);


Hash *Swig_cparse_features(void) {
  static Hash   *features_hash = 0;
  if (!features_hash) features_hash = NewHash();
  return features_hash;
}

/* Fully qualify any template parameters */
static String *feature_identifier_fix(String *s) {
  String *tp = SwigType_istemplate_templateprefix(s);
  if (tp) {
    String *ts, *ta, *tq;
    ts = SwigType_templatesuffix(s);
    ta = SwigType_templateargs(s);
    tq = Swig_symbol_type_qualify(ta,0);
    Append(tp,tq);
    Append(tp,ts);
    Delete(ts);
    Delete(ta);
    Delete(tq);
    return tp;
  } else {
    return NewString(s);
  }
}

static void set_access_mode(Node *n) {
  if (cplus_mode == CPLUS_PUBLIC)
    Setattr(n, "access", "public");
  else if (cplus_mode == CPLUS_PROTECTED)
    Setattr(n, "access", "protected");
  else
    Setattr(n, "access", "private");
}

static void restore_access_mode(Node *n) {
  String *mode = Getattr(n, "access");
  if (Strcmp(mode, "private") == 0)
    cplus_mode = CPLUS_PRIVATE;
  else if (Strcmp(mode, "protected") == 0)
    cplus_mode = CPLUS_PROTECTED;
  else
    cplus_mode = CPLUS_PUBLIC;
}

/* Generate the symbol table name for an object */
/* This is a bit of a mess. Need to clean up */
static String *add_oldname = 0;



static String *make_name(Node *n, String *name,SwigType *decl) {
  int destructor = name && (*(Char(name)) == '~');

  if (yyrename) {
    String *s = NewString(yyrename);
    Delete(yyrename);
    yyrename = 0;
    if (destructor  && (*(Char(s)) != '~')) {
      Insert(s,0,"~");
    }
    return s;
  }

  if (!name) return 0;
  return Swig_name_make(n,Namespaceprefix,name,decl,add_oldname);
}

/* Generate an unnamed identifier */
static String *make_unnamed() {
  unnamed++;
  return NewStringf("$unnamed%d$",unnamed);
}

/* Return if the node is a friend declaration */
static int is_friend(Node *n) {
  return Cmp(Getattr(n,"storage"),"friend") == 0;
}

static int is_operator(String *name) {
  return Strncmp(name,"operator ", 9) == 0;
}


/* Add declaration list to symbol table */
static int  add_only_one = 0;

static void add_symbols(Node *n) {
  String *decl;
  String *wrn = 0;

  if (inclass && n) {
    cparse_normalize_void(n);
  }
  while (n) {
    String *symname = 0;
    /* for friends, we need to pop the scope once */
    String *old_prefix = 0;
    Symtab *old_scope = 0;
    int isfriend = inclass && is_friend(n);
    int iscdecl = Cmp(nodeType(n),"cdecl") == 0;
    int only_csymbol = 0;
    
    if (inclass) {
      String *name = Getattr(n, "name");
      if (isfriend) {
	/* for friends, we need to add the scopename if needed */
	String *prefix = name ? Swig_scopename_prefix(name) : 0;
	old_prefix = Namespaceprefix;
	old_scope = Swig_symbol_popscope();
	Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	if (!prefix) {
	  if (name && !is_operator(name) && Namespaceprefix) {
	    String *nname = NewStringf("%s::%s", Namespaceprefix, name);
	    Setattr(n,"name",nname);
	    Delete(nname);
	  }
	} else {
	  Symtab *st = Swig_symbol_getscope(prefix);
	  String *ns = st ? Getattr(st,"name") : prefix;
	  String *base  = Swig_scopename_last(name);
	  String *nname = NewStringf("%s::%s", ns, base);
	  Setattr(n,"name",nname);
	  Delete(nname);
	  Delete(base);
	  Delete(prefix);
	}
	Namespaceprefix = 0;
      } else {
	/* for member functions, we need to remove the redundant
	   class scope if provided, as in
	   
	   struct Foo {
	   int Foo::method(int a);
	   };
	   
	*/
	String *prefix = name ? Swig_scopename_prefix(name) : 0;
	if (prefix) {
	  if (Classprefix && (Equal(prefix,Classprefix))) {
	    String *base = Swig_scopename_last(name);
	    Setattr(n,"name",base);
	    Delete(base);
	  }
	  Delete(prefix);
	}
      }
    }

    if (!isfriend && (inclass || extendmode)) {
      Setattr(n,"ismember","1");
    }

    if (extendmode) {
      Setattr(n,"isextendmember","1");
    }

    if (!isfriend && inclass) {
      if ((cplus_mode != CPLUS_PUBLIC)) {
	only_csymbol = 1;
	if (cplus_mode == CPLUS_PROTECTED) {
	  Setattr(n,"access", "protected");
	  only_csymbol = !Swig_need_protected(n);
	} else {
	  Setattr(n,"access", "private");
	  /* private are needed only when they are pure virtuals - why? */
	  if ((Cmp(Getattr(n,"storage"),"virtual") == 0) && (Cmp(Getattr(n,"value"),"0") == 0)) {
	    only_csymbol = 0;
	  }
	}
      } else {
	  Setattr(n,"access", "public");
      }
    }
    if (Getattr(n,"sym:name")) {
      n = nextSibling(n);
      continue;
    }
    decl = Getattr(n,"decl");
    if (!SwigType_isfunction(decl)) {
      String *name = Getattr(n,"name");
      String *makename = Getattr(n,"parser:makename");
      if (iscdecl) {	
	String *storage = Getattr(n, "storage");
	if (Cmp(storage,"typedef") == 0) {
	  Setattr(n,"kind","typedef");
	} else {
	  SwigType *type = Getattr(n,"type");
	  String *value = Getattr(n,"value");
	  Setattr(n,"kind","variable");
	  if (value && Len(value)) {
	    Setattr(n,"hasvalue","1");
	  }
	  if (type) {
	    SwigType *ty;
	    SwigType *tmp = 0;
	    if (decl) {
	      ty = tmp = Copy(type);
	      SwigType_push(ty,decl);
	    } else {
	      ty = type;
	    }
	    if (!SwigType_ismutable(ty) || (storage && Strstr(storage, "constexpr"))) {
	      SetFlag(n,"hasconsttype");
	      SetFlag(n,"feature:immutable");
	    }
	    if (tmp) Delete(tmp);
	  }
	  if (!type) {
	    Printf(stderr,"notype name %s\n", name);
	  }
	}
      }
      Swig_features_get(Swig_cparse_features(), Namespaceprefix, name, 0, n);
      if (makename) {
	symname = make_name(n, makename,0);
        Delattr(n,"parser:makename"); /* temporary information, don't leave it hanging around */
      } else {
        makename = name;
	symname = make_name(n, makename,0);
      }
      
      if (!symname) {
	symname = Copy(Getattr(n,"unnamed"));
      }
      if (symname) {
	wrn = Swig_name_warning(n, Namespaceprefix, symname,0);
      }
    } else {
      String *name = Getattr(n,"name");
      SwigType *fdecl = Copy(decl);
      SwigType *fun = SwigType_pop_function(fdecl);
      if (iscdecl) {	
	Setattr(n,"kind","function");
      }
      
      Swig_features_get(Swig_cparse_features(),Namespaceprefix,name,fun,n);

      symname = make_name(n, name,fun);
      wrn = Swig_name_warning(n, Namespaceprefix,symname,fun);
      
      Delete(fdecl);
      Delete(fun);
      
    }
    if (!symname) {
      n = nextSibling(n);
      continue;
    }
    if (cparse_cplusplus) {
      String *value = Getattr(n, "value");
      if (value && Strcmp(value, "delete") == 0) {
	/* C++11 deleted definition / deleted function */
        SetFlag(n,"deleted");
        SetFlag(n,"feature:ignore");
      }
    }
    if (only_csymbol || GetFlag(n,"feature:ignore")) {
      /* Only add to C symbol table and continue */
      Swig_symbol_add(0, n);
    } else if (strncmp(Char(symname),"$ignore",7) == 0) {
      char *c = Char(symname)+7;
      SetFlag(n,"feature:ignore");
      if (strlen(c)) {
	SWIG_WARN_NODE_BEGIN(n);
	Swig_warning(0,Getfile(n), Getline(n), "%s\n",c+1);
	SWIG_WARN_NODE_END(n);
      }
      Swig_symbol_add(0, n);
    } else {
      Node *c;
      if ((wrn) && (Len(wrn))) {
	String *metaname = symname;
	if (!Getmeta(metaname,"already_warned")) {
	  SWIG_WARN_NODE_BEGIN(n);
	  Swig_warning(0,Getfile(n),Getline(n), "%s\n", wrn);
	  SWIG_WARN_NODE_END(n);
	  Setmeta(metaname,"already_warned","1");
	}
      }
      c = Swig_symbol_add(symname,n);

      if (c != n) {
        /* symbol conflict attempting to add in the new symbol */
        if (Getattr(n,"sym:weak")) {
          Setattr(n,"sym:name",symname);
        } else {
          String *e = NewStringEmpty();
          String *en = NewStringEmpty();
          String *ec = NewStringEmpty();
          int redefined = Swig_need_redefined_warn(n,c,inclass);
          if (redefined) {
            Printf(en,"Identifier '%s' redefined (ignored)",symname);
            Printf(ec,"previous definition of '%s'",symname);
          } else {
            Printf(en,"Redundant redeclaration of '%s'",symname);
            Printf(ec,"previous declaration of '%s'",symname);
          }
          if (Cmp(symname,Getattr(n,"name"))) {
            Printf(en," (Renamed from '%s')", SwigType_namestr(Getattr(n,"name")));
          }
          Printf(en,",");
          if (Cmp(symname,Getattr(c,"name"))) {
            Printf(ec," (Renamed from '%s')", SwigType_namestr(Getattr(c,"name")));
          }
          Printf(ec,".");
	  SWIG_WARN_NODE_BEGIN(n);
          if (redefined) {
            Swig_warning(WARN_PARSE_REDEFINED,Getfile(n),Getline(n),"%s\n",en);
            Swig_warning(WARN_PARSE_REDEFINED,Getfile(c),Getline(c),"%s\n",ec);
          } else if (!is_friend(n) && !is_friend(c)) {
            Swig_warning(WARN_PARSE_REDUNDANT,Getfile(n),Getline(n),"%s\n",en);
            Swig_warning(WARN_PARSE_REDUNDANT,Getfile(c),Getline(c),"%s\n",ec);
          }
	  SWIG_WARN_NODE_END(n);
          Printf(e,"%s:%d:%s\n%s:%d:%s\n",Getfile(n),Getline(n),en,
                 Getfile(c),Getline(c),ec);
          Setattr(n,"error",e);
	  Delete(e);
          Delete(en);
          Delete(ec);
        }
      }
    }
    /* restore the class scope if needed */
    if (isfriend) {
      Swig_symbol_setscope(old_scope);
      if (old_prefix) {
	Delete(Namespaceprefix);
	Namespaceprefix = old_prefix;
      }
    }
    Delete(symname);

    if (add_only_one) return;
    n = nextSibling(n);
  }
}


/* add symbols a parse tree node copy */

static void add_symbols_copy(Node *n) {
  String *name;
  int    emode = 0;
  while (n) {
    char *cnodeType = Char(nodeType(n));

    if (strcmp(cnodeType,"access") == 0) {
      String *kind = Getattr(n,"kind");
      if (Strcmp(kind,"public") == 0) {
	cplus_mode = CPLUS_PUBLIC;
      } else if (Strcmp(kind,"private") == 0) {
	cplus_mode = CPLUS_PRIVATE;
      } else if (Strcmp(kind,"protected") == 0) {
	cplus_mode = CPLUS_PROTECTED;
      }
      n = nextSibling(n);
      continue;
    }

    add_oldname = Getattr(n,"sym:name");
    if ((add_oldname) || (Getattr(n,"sym:needs_symtab"))) {
      int old_inclass = -1;
      Node *old_current_class = 0;
      if (add_oldname) {
	DohIncref(add_oldname);
	/*  Disable this, it prevents %rename to work with templates */
	/* If already renamed, we used that name  */
	/*
	if (Strcmp(add_oldname, Getattr(n,"name")) != 0) {
	  Delete(yyrename);
	  yyrename = Copy(add_oldname);
	}
	*/
      }
      Delattr(n,"sym:needs_symtab");
      Delattr(n,"sym:name");

      add_only_one = 1;
      add_symbols(n);

      if (Getattr(n,"partialargs")) {
	Swig_symbol_cadd(Getattr(n,"partialargs"),n);
      }
      add_only_one = 0;
      name = Getattr(n,"name");
      if (Getattr(n,"requires_symtab")) {
	Swig_symbol_newscope();
	Swig_symbol_setscopename(name);
	Delete(Namespaceprefix);
	Namespaceprefix = Swig_symbol_qualifiedscopename(0);
      }
      if (strcmp(cnodeType,"class") == 0) {
	old_inclass = inclass;
	inclass = 1;
	old_current_class = current_class;
	current_class = n;
	if (Strcmp(Getattr(n,"kind"),"class") == 0) {
	  cplus_mode = CPLUS_PRIVATE;
	} else {
	  cplus_mode = CPLUS_PUBLIC;
	}
      }
      if (strcmp(cnodeType,"extend") == 0) {
	emode = cplus_mode;
	cplus_mode = CPLUS_PUBLIC;
      }
      add_symbols_copy(firstChild(n));
      if (strcmp(cnodeType,"extend") == 0) {
	cplus_mode = emode;
      }
      if (Getattr(n,"requires_symtab")) {
	Setattr(n,"symtab", Swig_symbol_popscope());
	Delattr(n,"requires_symtab");
	Delete(Namespaceprefix);
	Namespaceprefix = Swig_symbol_qualifiedscopename(0);
      }
      if (add_oldname) {
	Delete(add_oldname);
	add_oldname = 0;
      }
      if (strcmp(cnodeType,"class") == 0) {
	inclass = old_inclass;
	current_class = old_current_class;
      }
    } else {
      if (strcmp(cnodeType,"extend") == 0) {
	emode = cplus_mode;
	cplus_mode = CPLUS_PUBLIC;
      }
      add_symbols_copy(firstChild(n));
      if (strcmp(cnodeType,"extend") == 0) {
	cplus_mode = emode;
      }
    }
    n = nextSibling(n);
  }
}

/* Check a set of declarations to see if any are pure-abstract */

static List *pure_abstracts(Node *n) {
  List *abstracts = 0;
  while (n) {
    if (Cmp(nodeType(n),"cdecl") == 0) {
      String *decl = Getattr(n,"decl");
      if (SwigType_isfunction(decl)) {
	String *init = Getattr(n,"value");
	if (Cmp(init,"0") == 0) {
	  if (!abstracts) {
	    abstracts = NewList();
	  }
	  Append(abstracts,n);
	  SetFlag(n,"abstract");
	}
      }
    } else if (Cmp(nodeType(n),"destructor") == 0) {
      if (Cmp(Getattr(n,"value"),"0") == 0) {
	if (!abstracts) {
	  abstracts = NewList();
	}
	Append(abstracts,n);
	SetFlag(n,"abstract");
      }
    }
    n = nextSibling(n);
  }
  return abstracts;
}

/* Make a classname */

static String *make_class_name(String *name) {
  String *nname = 0;
  String *prefix;
  if (Namespaceprefix) {
    nname= NewStringf("%s::%s", Namespaceprefix, name);
  } else {
    nname = NewString(name);
  }
  prefix = SwigType_istemplate_templateprefix(nname);
  if (prefix) {
    String *args, *qargs;
    args   = SwigType_templateargs(nname);
    qargs  = Swig_symbol_type_qualify(args,0);
    Append(prefix,qargs);
    Delete(nname);
    Delete(args);
    Delete(qargs);
    nname = prefix;
  }
  return nname;
}

/* Use typedef name as class name */

static void add_typedef_name(Node *n, Node *decl, String *oldName, Symtab *cscope, String *scpname) {
  String *class_rename = 0;
  SwigType *decltype = Getattr(decl, "decl");
  if (!decltype || !Len(decltype)) {
    String *cname;
    String *tdscopename;
    String *class_scope = Swig_symbol_qualifiedscopename(cscope);
    String *name = Getattr(decl, "name");
    cname = Copy(name);
    Setattr(n, "tdname", cname);
    tdscopename = class_scope ? NewStringf("%s::%s", class_scope, name) : Copy(name);
    class_rename = Getattr(n, "class_rename");
    if (class_rename && (Strcmp(class_rename, oldName) == 0))
      Setattr(n, "class_rename", NewString(name));
    if (!classes_typedefs) classes_typedefs = NewHash();
    if (!Equal(scpname, tdscopename) && !Getattr(classes_typedefs, tdscopename)) {
      Setattr(classes_typedefs, tdscopename, n);
    }
    Setattr(n, "decl", decltype);
    Delete(class_scope);
    Delete(cname);
    Delete(tdscopename);
  }
}

/* If the class name is qualified.  We need to create or lookup namespace entries */

static Symtab *set_scope_to_global() {
  Symtab *symtab = Swig_symbol_global_scope();
  Swig_symbol_setscope(symtab);
  return symtab;
}
 
/* Remove the block braces, { and }, if the 'noblock' attribute is set.
 * Node *kw can be either a Hash or Parmlist. */
static String *remove_block(Node *kw, const String *inputcode) {
  String *modified_code = 0;
  while (kw) {
   String *name = Getattr(kw,"name");
   if (name && (Cmp(name,"noblock") == 0)) {
     char *cstr = Char(inputcode);
     size_t len = Len(inputcode);
     if (len && cstr[0] == '{') {
       --len; ++cstr; 
       if (len && cstr[len - 1] == '}') { --len; }
       /* we now remove the extra spaces */
       while (len && isspace((int)cstr[0])) { --len; ++cstr; }
       while (len && isspace((int)cstr[len - 1])) { --len; }
       modified_code = NewStringWithSize(cstr, len);
       break;
     }
   }
   kw = nextSibling(kw);
  }
  return modified_code;
}


static Node *nscope = 0;
static Node *nscope_inner = 0;

/* Remove the scope prefix from cname and return the base name without the prefix.
 * The scopes required for the symbol name are resolved and/or created, if required.
 * For example AA::BB::CC as input returns CC and creates the namespace AA then inner 
 * namespace BB in the current scope. If cname is found to already exist as a weak symbol
 * (forward reference) then the scope might be changed to match, such as when a symbol match 
 * is made via a using reference. */
static String *resolve_create_node_scope(String *cname) {
  Symtab *gscope = 0;
  Node *cname_node = 0;
  int skip_lookup = 0;
  nscope = 0;
  nscope_inner = 0;  

  if (Strncmp(cname,"::",2) == 0)
    skip_lookup = 1;

  cname_node = skip_lookup ? 0 : Swig_symbol_clookup_no_inherit(cname, 0);

  if (cname_node) {
    /* The symbol has been defined already or is in another scope.
       If it is a weak symbol, it needs replacing and if it was brought into the current scope
       via a using declaration, the scope needs adjusting appropriately for the new symbol.
       Similarly for defined templates. */
    Symtab *symtab = Getattr(cname_node, "sym:symtab");
    Node *sym_weak = Getattr(cname_node, "sym:weak");
    if ((symtab && sym_weak) || Equal(nodeType(cname_node), "template")) {
      /* Check if the scope is the current scope */
      String *current_scopename = Swig_symbol_qualifiedscopename(0);
      String *found_scopename = Swig_symbol_qualifiedscopename(symtab);
      int len;
      if (!current_scopename)
	current_scopename = NewString("");
      if (!found_scopename)
	found_scopename = NewString("");
      len = Len(current_scopename);
      if ((len > 0) && (Strncmp(current_scopename, found_scopename, len) == 0)) {
	if (Len(found_scopename) > len + 2) {
	  /* A matching weak symbol was found in non-global scope, some scope adjustment may be required */
	  String *new_cname = NewString(Char(found_scopename) + len + 2); /* skip over "::" prefix */
	  String *base = Swig_scopename_last(cname);
	  Printf(new_cname, "::%s", base);
	  cname = new_cname;
	  Delete(base);
	} else {
	  /* A matching weak symbol was found in the same non-global local scope, no scope adjustment required */
	  assert(len == Len(found_scopename));
	}
      } else {
	String *base = Swig_scopename_last(cname);
	if (Len(found_scopename) > 0) {
	  /* A matching weak symbol was found in a different scope to the local scope - probably via a using declaration */
	  cname = NewStringf("%s::%s", found_scopename, base);
	} else {
	  /* Either:
	      1) A matching weak symbol was found in a different scope to the local scope - this is actually a
	      symbol with the same name in a different scope which we don't want, so no adjustment required.
	      2) A matching weak symbol was found in the global scope - no adjustment required.
	  */
	  cname = Copy(base);
	}
	Delete(base);
      }
      Delete(current_scopename);
      Delete(found_scopename);
    }
  }

  if (Swig_scopename_check(cname)) {
    Node   *ns;
    String *prefix = Swig_scopename_prefix(cname);
    String *base = Swig_scopename_last(cname);
    if (prefix && (Strncmp(prefix,"::",2) == 0)) {
/* I don't think we can use :: global scope to declare classes and hence neither %template. - consider reporting error instead - wsfulton. */
      /* Use the global scope */
      String *nprefix = NewString(Char(prefix)+2);
      Delete(prefix);
      prefix= nprefix;
      gscope = set_scope_to_global();
    }
    if (Len(prefix) == 0) {
      /* Use the global scope, but we need to add a 'global' namespace.  */
      if (!gscope) gscope = set_scope_to_global();
      /* note that this namespace is not the "unnamed" one,
	 and we don't use Setattr(nscope,"name", ""),
	 because the unnamed namespace is private */
      nscope = new_node("namespace");
      Setattr(nscope,"symtab", gscope);;
      nscope_inner = nscope;
      return base;
    }
    /* Try to locate the scope */
    ns = Swig_symbol_clookup(prefix,0);
    if (!ns) {
      Swig_error(cparse_file,cparse_line,"Undefined scope '%s'\n", prefix);
    } else {
      Symtab *nstab = Getattr(ns,"symtab");
      if (!nstab) {
	Swig_error(cparse_file,cparse_line, "'%s' is not defined as a valid scope.\n", prefix);
	ns = 0;
      } else {
	/* Check if the node scope is the current scope */
	String *tname = Swig_symbol_qualifiedscopename(0);
	String *nname = Swig_symbol_qualifiedscopename(nstab);
	if (tname && (Strcmp(tname,nname) == 0)) {
	  ns = 0;
	  cname = base;
	}
	Delete(tname);
	Delete(nname);
      }
      if (ns) {
	/* we will try to create a new node using the namespaces we
	   can find in the scope name */
	List *scopes;
	String *sname;
	Iterator si;
	String *name = NewString(prefix);
	scopes = NewList();
	while (name) {
	  String *base = Swig_scopename_last(name);
	  String *tprefix = Swig_scopename_prefix(name);
	  Insert(scopes,0,base);
	  Delete(base);
	  Delete(name);
	  name = tprefix;
	}
	for (si = First(scopes); si.item; si = Next(si)) {
	  Node *ns1,*ns2;
	  sname = si.item;
	  ns1 = Swig_symbol_clookup(sname,0);
	  assert(ns1);
	  if (Strcmp(nodeType(ns1),"namespace") == 0) {
	    if (Getattr(ns1,"alias")) {
	      ns1 = Getattr(ns1,"namespace");
	    }
	  } else {
	    /* now this last part is a class */
	    si = Next(si);
	    /*  or a nested class tree, which is unrolled here */
	    for (; si.item; si = Next(si)) {
	      if (si.item) {
		Printf(sname,"::%s",si.item);
	      }
	    }
	    /* we get the 'inner' class */
	    nscope_inner = Swig_symbol_clookup(sname,0);
	    /* set the scope to the inner class */
	    Swig_symbol_setscope(Getattr(nscope_inner,"symtab"));
	    /* save the last namespace prefix */
	    Delete(Namespaceprefix);
	    Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	    /* and return the node name, including the inner class prefix */
	    break;
	  }
	  /* here we just populate the namespace tree as usual */
	  ns2 = new_node("namespace");
	  Setattr(ns2,"name",sname);
	  Setattr(ns2,"symtab", Getattr(ns1,"symtab"));
	  add_symbols(ns2);
	  Swig_symbol_setscope(Getattr(ns1,"symtab"));
	  Delete(Namespaceprefix);
	  Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	  if (nscope_inner) {
	    if (Getattr(nscope_inner,"symtab") != Getattr(ns2,"symtab")) {
	      appendChild(nscope_inner,ns2);
	      Delete(ns2);
	    }
	  }
	  nscope_inner = ns2;
	  if (!nscope) nscope = ns2;
	}
	cname = base;
	Delete(scopes);
      }
    }
    Delete(prefix);
  }

  return cname;
}
 
/* look for simple typedef name in typedef list */
static String *try_to_find_a_name_for_unnamed_structure(const char *storage, Node *decls) {
  String *name = 0;
  Node *n = decls;
  if (storage && (strcmp(storage, "typedef") == 0)) {
    for (; n; n = nextSibling(n)) {
      if (!Len(Getattr(n, "decl"))) {
	name = Copy(Getattr(n, "name"));
	break;
      }
    }
  }
  return name;
}

/* traverse copied tree segment, and update outer class links*/
static void update_nested_classes(Node *n)
{
  Node *c = firstChild(n);
  while (c) {
    if (Getattr(c, "nested:outer"))
      Setattr(c, "nested:outer", n);
    update_nested_classes(c);
    c = nextSibling(c);
  }
}

/* -----------------------------------------------------------------------------
 * nested_forward_declaration()
 * 
 * Nested struct handling for C++ code if the nested classes are disabled.
 * Create the nested class/struct/union as a forward declaration.
 * ----------------------------------------------------------------------------- */

static Node *nested_forward_declaration(const char *storage, const char *kind, String *sname, String *name, Node *cpp_opt_declarators) {
  Node *nn = 0;
  int warned = 0;

  if (sname) {
    /* Add forward declaration of the nested type */
    Node *n = new_node("classforward");
    Setattr(n, "kind", kind);
    Setattr(n, "name", sname);
    Setattr(n, "storage", storage);
    Setattr(n, "sym:weak", "1");
    add_symbols(n);
    nn = n;
  }

  /* Add any variable instances. Also add in any further typedefs of the nested type.
     Note that anonymous typedefs (eg typedef struct {...} a, b;) are treated as class forward declarations */
  if (cpp_opt_declarators) {
    int storage_typedef = (storage && (strcmp(storage, "typedef") == 0));
    int variable_of_anonymous_type = !sname && !storage_typedef;
    if (!variable_of_anonymous_type) {
      int anonymous_typedef = !sname && (storage && (strcmp(storage, "typedef") == 0));
      Node *n = cpp_opt_declarators;
      SwigType *type = name;
      while (n) {
	Setattr(n, "type", type);
	Setattr(n, "storage", storage);
	if (anonymous_typedef) {
	  Setattr(n, "nodeType", "classforward");
	  Setattr(n, "sym:weak", "1");
	}
	n = nextSibling(n);
      }
      add_symbols(cpp_opt_declarators);

      if (nn) {
	set_nextSibling(nn, cpp_opt_declarators);
      } else {
	nn = cpp_opt_declarators;
      }
    }
  }

  if (!currentOuterClass || !GetFlag(currentOuterClass, "nested")) {
    if (nn && Equal(nodeType(nn), "classforward")) {
      Node *n = nn;
      SWIG_WARN_NODE_BEGIN(n);
      Swig_warning(WARN_PARSE_NAMED_NESTED_CLASS, cparse_file, cparse_line,"Nested %s not currently supported (%s ignored)\n", kind, sname ? sname : name);
      SWIG_WARN_NODE_END(n);
      warned = 1;
    }

    if (!warned) {
      Swig_warning(WARN_PARSE_UNNAMED_NESTED_CLASS, cparse_file, cparse_line, "Nested %s not currently supported (ignored).\n", kind);
    }
  }

  return nn;
}


Node *Swig_cparse(File *f) {
  scanner_file(f);
  top = 0;
  yyparse();
  return top;
}

static void single_new_feature(const char *featurename, String *val, Hash *featureattribs, char *declaratorid, SwigType *type, ParmList *declaratorparms, String *qualifier) {
  String *fname;
  String *name;
  String *fixname;
  SwigType *t = Copy(type);

  /* Printf(stdout, "single_new_feature: [%s] [%s] [%s] [%s] [%s] [%s]\n", featurename, val, declaratorid, t, ParmList_str_defaultargs(declaratorparms), qualifier); */

  /* Warn about deprecated features */
  if (strcmp(featurename, "nestedworkaround") == 0)
    Swig_warning(WARN_DEPRECATED_NESTED_WORKAROUND, cparse_file, cparse_line, "The 'nestedworkaround' feature is deprecated.\n");

  fname = NewStringf("feature:%s",featurename);
  if (declaratorid) {
    fixname = feature_identifier_fix(declaratorid);
  } else {
    fixname = NewStringEmpty();
  }
  if (Namespaceprefix) {
    name = NewStringf("%s::%s",Namespaceprefix, fixname);
  } else {
    name = fixname;
  }

  if (declaratorparms) Setmeta(val,"parms",declaratorparms);
  if (!Len(t)) t = 0;
  if (t) {
    if (qualifier) SwigType_push(t,qualifier);
    if (SwigType_isfunction(t)) {
      SwigType *decl = SwigType_pop_function(t);
      if (SwigType_ispointer(t)) {
	String *nname = NewStringf("*%s",name);
	Swig_feature_set(Swig_cparse_features(), nname, decl, fname, val, featureattribs);
	Delete(nname);
      } else {
	Swig_feature_set(Swig_cparse_features(), name, decl, fname, val, featureattribs);
      }
      Delete(decl);
    } else if (SwigType_ispointer(t)) {
      String *nname = NewStringf("*%s",name);
      Swig_feature_set(Swig_cparse_features(),nname,0,fname,val, featureattribs);
      Delete(nname);
    }
  } else {
    /* Global feature, that is, feature not associated with any particular symbol */
    Swig_feature_set(Swig_cparse_features(),name,0,fname,val, featureattribs);
  }
  Delete(fname);
  Delete(name);
}

/* Add a new feature to the Hash. Additional features are added if the feature has a parameter list (declaratorparms)
 * and one or more of the parameters have a default argument. An extra feature is added for each defaulted parameter,
 * simulating the equivalent overloaded method. */
static void new_feature(const char *featurename, String *val, Hash *featureattribs, char *declaratorid, SwigType *type, ParmList *declaratorparms, String *qualifier) {

  ParmList *declparms = declaratorparms;

  /* remove the { and } braces if the noblock attribute is set */
  String *newval = remove_block(featureattribs, val);
  val = newval ? newval : val;

  /* Add the feature */
  single_new_feature(featurename, val, featureattribs, declaratorid, type, declaratorparms, qualifier);

  /* Add extra features if there are default parameters in the parameter list */
  if (type) {
    while (declparms) {
      if (ParmList_has_defaultargs(declparms)) {

        /* Create a parameter list for the new feature by copying all
           but the last (defaulted) parameter */
        ParmList* newparms = CopyParmListMax(declparms, ParmList_len(declparms)-1);

        /* Create new declaration - with the last parameter removed */
        SwigType *newtype = Copy(type);
        Delete(SwigType_pop_function(newtype)); /* remove the old parameter list from newtype */
        SwigType_add_function(newtype,newparms);

        single_new_feature(featurename, Copy(val), featureattribs, declaratorid, newtype, newparms, qualifier);
        declparms = newparms;
      } else {
        declparms = 0;
      }
    }
  }
}

/* check if a function declaration is a plain C object */
static int is_cfunction(Node *n) {
  if (!cparse_cplusplus || cparse_externc)
    return 1;
  if (Swig_storage_isexternc(n)) {
    return 1;
  }
  return 0;
}

/* If the Node is a function with parameters, check to see if any of the parameters
 * have default arguments. If so create a new function for each defaulted argument. 
 * The additional functions form a linked list of nodes with the head being the original Node n. */
static void default_arguments(Node *n) {
  Node *function = n;

  if (function) {
    ParmList *varargs = Getattr(function,"feature:varargs");
    if (varargs) {
      /* Handles the %varargs directive by looking for "feature:varargs" and 
       * substituting ... with an alternative set of arguments.  */
      Parm     *p = Getattr(function,"parms");
      Parm     *pp = 0;
      while (p) {
	SwigType *t = Getattr(p,"type");
	if (Strcmp(t,"v(...)") == 0) {
	  if (pp) {
	    ParmList *cv = Copy(varargs);
	    set_nextSibling(pp,cv);
	    Delete(cv);
	  } else {
	    ParmList *cv =  Copy(varargs);
	    Setattr(function,"parms", cv);
	    Delete(cv);
	  }
	  break;
	}
	pp = p;
	p = nextSibling(p);
      }
    }

    /* Do not add in functions if kwargs is being used or if user wants old default argument wrapping
       (one wrapped method per function irrespective of number of default arguments) */
    if (compact_default_args 
	|| is_cfunction(function) 
	|| GetFlag(function,"feature:compactdefaultargs") 
	|| (GetFlag(function,"feature:kwargs") && kwargs_supported)) {
      ParmList *p = Getattr(function,"parms");
      if (p) 
        Setattr(p,"compactdefargs", "1"); /* mark parameters for special handling */
      function = 0; /* don't add in extra methods */
    }
  }

  while (function) {
    ParmList *parms = Getattr(function,"parms");
    if (ParmList_has_defaultargs(parms)) {

      /* Create a parameter list for the new function by copying all
         but the last (defaulted) parameter */
      ParmList* newparms = CopyParmListMax(parms,ParmList_len(parms)-1);

      /* Create new function and add to symbol table */
      {
	SwigType *ntype = Copy(nodeType(function));
	char *cntype = Char(ntype);
        Node *new_function = new_node(ntype);
        SwigType *decl = Copy(Getattr(function,"decl"));
        int constqualifier = SwigType_isconst(decl);
	String *ccode = Copy(Getattr(function,"code"));
	String *cstorage = Copy(Getattr(function,"storage"));
	String *cvalue = Copy(Getattr(function,"value"));
	SwigType *ctype = Copy(Getattr(function,"type"));
	String *cthrow = Copy(Getattr(function,"throw"));

        Delete(SwigType_pop_function(decl)); /* remove the old parameter list from decl */
        SwigType_add_function(decl,newparms);
        if (constqualifier)
          SwigType_add_qualifier(decl,"const");

        Setattr(new_function,"name", Getattr(function,"name"));
        Setattr(new_function,"code", ccode);
        Setattr(new_function,"decl", decl);
        Setattr(new_function,"parms", newparms);
        Setattr(new_function,"storage", cstorage);
        Setattr(new_function,"value", cvalue);
        Setattr(new_function,"type", ctype);
        Setattr(new_function,"throw", cthrow);

	Delete(ccode);
	Delete(cstorage);
	Delete(cvalue);
	Delete(ctype);
	Delete(cthrow);
	Delete(decl);

        {
          Node *throws = Getattr(function,"throws");
	  ParmList *pl = CopyParmList(throws);
          if (throws) Setattr(new_function,"throws",pl);
	  Delete(pl);
        }

        /* copy specific attributes for global (or in a namespace) template functions - these are not templated class methods */
        if (strcmp(cntype,"template") == 0) {
          Node *templatetype = Getattr(function,"templatetype");
          Node *symtypename = Getattr(function,"sym:typename");
          Parm *templateparms = Getattr(function,"templateparms");
          if (templatetype) {
	    Node *tmp = Copy(templatetype);
	    Setattr(new_function,"templatetype",tmp);
	    Delete(tmp);
	  }
          if (symtypename) {
	    Node *tmp = Copy(symtypename);
	    Setattr(new_function,"sym:typename",tmp);
	    Delete(tmp);
	  }
          if (templateparms) {
	    Parm *tmp = CopyParmList(templateparms);
	    Setattr(new_function,"templateparms",tmp);
	    Delete(tmp);
	  }
        } else if (strcmp(cntype,"constructor") == 0) {
          /* only copied for constructors as this is not a user defined feature - it is hard coded in the parser */
          if (GetFlag(function,"feature:new")) SetFlag(new_function,"feature:new");
        }

        add_symbols(new_function);
        /* mark added functions as ones with overloaded parameters and point to the parsed method */
        Setattr(new_function,"defaultargs", n);

        /* Point to the new function, extending the linked list */
        set_nextSibling(function, new_function);
	Delete(new_function);
        function = new_function;
	
	Delete(ntype);
      }
    } else {
      function = 0;
    }
  }
}

/* -----------------------------------------------------------------------------
 * mark_nodes_as_extend()
 *
 * Used by the %extend to mark subtypes with "feature:extend".
 * template instances declared within %extend are skipped
 * ----------------------------------------------------------------------------- */

static void mark_nodes_as_extend(Node *n) {
  for (; n; n = nextSibling(n)) {
    if (Getattr(n, "template") && Strcmp(nodeType(n), "class") == 0)
      continue;
    /* Fix me: extend is not a feature. Replace with isextendmember? */
    Setattr(n, "feature:extend", "1");
    mark_nodes_as_extend(firstChild(n));
  }
}


#line 1343 "y.tab.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_Y_TAB_H_INCLUDED
# define YY_YY_Y_TAB_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    ID = 258,
    HBLOCK = 259,
    POUND = 260,
    STRING = 261,
    WSTRING = 262,
    INCLUDE = 263,
    IMPORT = 264,
    INSERT = 265,
    CHARCONST = 266,
    WCHARCONST = 267,
    NUM_INT = 268,
    NUM_FLOAT = 269,
    NUM_UNSIGNED = 270,
    NUM_LONG = 271,
    NUM_ULONG = 272,
    NUM_LONGLONG = 273,
    NUM_ULONGLONG = 274,
    NUM_BOOL = 275,
    TYPEDEF = 276,
    TYPE_INT = 277,
    TYPE_UNSIGNED = 278,
    TYPE_SHORT = 279,
    TYPE_LONG = 280,
    TYPE_FLOAT = 281,
    TYPE_DOUBLE = 282,
    TYPE_CHAR = 283,
    TYPE_WCHAR = 284,
    TYPE_VOID = 285,
    TYPE_SIGNED = 286,
    TYPE_BOOL = 287,
    TYPE_COMPLEX = 288,
    TYPE_TYPEDEF = 289,
    TYPE_RAW = 290,
    TYPE_NON_ISO_INT8 = 291,
    TYPE_NON_ISO_INT16 = 292,
    TYPE_NON_ISO_INT32 = 293,
    TYPE_NON_ISO_INT64 = 294,
    LPAREN = 295,
    RPAREN = 296,
    COMMA = 297,
    SEMI = 298,
    EXTERN = 299,
    INIT = 300,
    LBRACE = 301,
    RBRACE = 302,
    PERIOD = 303,
    CONST_QUAL = 304,
    VOLATILE = 305,
    REGISTER = 306,
    STRUCT = 307,
    UNION = 308,
    EQUAL = 309,
    SIZEOF = 310,
    MODULE = 311,
    LBRACKET = 312,
    RBRACKET = 313,
    BEGINFILE = 314,
    ENDOFFILE = 315,
    ILLEGAL = 316,
    CONSTANT = 317,
    NAME = 318,
    RENAME = 319,
    NAMEWARN = 320,
    EXTEND = 321,
    PRAGMA = 322,
    FEATURE = 323,
    VARARGS = 324,
    ENUM = 325,
    CLASS = 326,
    TYPENAME = 327,
    PRIVATE = 328,
    PUBLIC = 329,
    PROTECTED = 330,
    COLON = 331,
    STATIC = 332,
    VIRTUAL = 333,
    FRIEND = 334,
    THROW = 335,
    CATCH = 336,
    EXPLICIT = 337,
    STATIC_ASSERT = 338,
    CONSTEXPR = 339,
    THREAD_LOCAL = 340,
    DECLTYPE = 341,
    AUTO = 342,
    NOEXCEPT = 343,
    OVERRIDE = 344,
    FINAL = 345,
    USING = 346,
    NAMESPACE = 347,
    NATIVE = 348,
    INLINE = 349,
    TYPEMAP = 350,
    EXCEPT = 351,
    ECHO = 352,
    APPLY = 353,
    CLEAR = 354,
    SWIGTEMPLATE = 355,
    FRAGMENT = 356,
    WARN = 357,
    LESSTHAN = 358,
    GREATERTHAN = 359,
    DELETE_KW = 360,
    DEFAULT = 361,
    LESSTHANOREQUALTO = 362,
    GREATERTHANOREQUALTO = 363,
    EQUALTO = 364,
    NOTEQUALTO = 365,
    ARROW = 366,
    QUESTIONMARK = 367,
    TYPES = 368,
    PARMS = 369,
    NONID = 370,
    DSTAR = 371,
    DCNOT = 372,
    TEMPLATE = 373,
    OPERATOR = 374,
    COPERATOR = 375,
    PARSETYPE = 376,
    PARSEPARM = 377,
    PARSEPARMS = 378,
    CAST = 379,
    LOR = 380,
    LAND = 381,
    OR = 382,
    XOR = 383,
    AND = 384,
    LSHIFT = 385,
    RSHIFT = 386,
    PLUS = 387,
    MINUS = 388,
    STAR = 389,
    SLASH = 390,
    MODULO = 391,
    UMINUS = 392,
    NOT = 393,
    LNOT = 394,
    DCOLON = 395
  };
#endif
/* Tokens.  */
#define ID 258
#define HBLOCK 259
#define POUND 260
#define STRING 261
#define WSTRING 262
#define INCLUDE 263
#define IMPORT 264
#define INSERT 265
#define CHARCONST 266
#define WCHARCONST 267
#define NUM_INT 268
#define NUM_FLOAT 269
#define NUM_UNSIGNED 270
#define NUM_LONG 271
#define NUM_ULONG 272
#define NUM_LONGLONG 273
#define NUM_ULONGLONG 274
#define NUM_BOOL 275
#define TYPEDEF 276
#define TYPE_INT 277
#define TYPE_UNSIGNED 278
#define TYPE_SHORT 279
#define TYPE_LONG 280
#define TYPE_FLOAT 281
#define TYPE_DOUBLE 282
#define TYPE_CHAR 283
#define TYPE_WCHAR 284
#define TYPE_VOID 285
#define TYPE_SIGNED 286
#define TYPE_BOOL 287
#define TYPE_COMPLEX 288
#define TYPE_TYPEDEF 289
#define TYPE_RAW 290
#define TYPE_NON_ISO_INT8 291
#define TYPE_NON_ISO_INT16 292
#define TYPE_NON_ISO_INT32 293
#define TYPE_NON_ISO_INT64 294
#define LPAREN 295
#define RPAREN 296
#define COMMA 297
#define SEMI 298
#define EXTERN 299
#define INIT 300
#define LBRACE 301
#define RBRACE 302
#define PERIOD 303
#define CONST_QUAL 304
#define VOLATILE 305
#define REGISTER 306
#define STRUCT 307
#define UNION 308
#define EQUAL 309
#define SIZEOF 310
#define MODULE 311
#define LBRACKET 312
#define RBRACKET 313
#define BEGINFILE 314
#define ENDOFFILE 315
#define ILLEGAL 316
#define CONSTANT 317
#define NAME 318
#define RENAME 319
#define NAMEWARN 320
#define EXTEND 321
#define PRAGMA 322
#define FEATURE 323
#define VARARGS 324
#define ENUM 325
#define CLASS 326
#define TYPENAME 327
#define PRIVATE 328
#define PUBLIC 329
#define PROTECTED 330
#define COLON 331
#define STATIC 332
#define VIRTUAL 333
#define FRIEND 334
#define THROW 335
#define CATCH 336
#define EXPLICIT 337
#define STATIC_ASSERT 338
#define CONSTEXPR 339
#define THREAD_LOCAL 340
#define DECLTYPE 341
#define AUTO 342
#define NOEXCEPT 343
#define OVERRIDE 344
#define FINAL 345
#define USING 346
#define NAMESPACE 347
#define NATIVE 348
#define INLINE 349
#define TYPEMAP 350
#define EXCEPT 351
#define ECHO 352
#define APPLY 353
#define CLEAR 354
#define SWIGTEMPLATE 355
#define FRAGMENT 356
#define WARN 357
#define LESSTHAN 358
#define GREATERTHAN 359
#define DELETE_KW 360
#define DEFAULT 361
#define LESSTHANOREQUALTO 362
#define GREATERTHANOREQUALTO 363
#define EQUALTO 364
#define NOTEQUALTO 365
#define ARROW 366
#define QUESTIONMARK 367
#define TYPES 368
#define PARMS 369
#define NONID 370
#define DSTAR 371
#define DCNOT 372
#define TEMPLATE 373
#define OPERATOR 374
#define COPERATOR 375
#define PARSETYPE 376
#define PARSEPARM 377
#define PARSEPARMS 378
#define CAST 379
#define LOR 380
#define LAND 381
#define OR 382
#define XOR 383
#define AND 384
#define LSHIFT 385
#define RSHIFT 386
#define PLUS 387
#define MINUS 388
#define STAR 389
#define SLASH 390
#define MODULO 391
#define UMINUS 392
#define NOT 393
#define LNOT 394
#define DCOLON 395

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE YYSTYPE;
union YYSTYPE
{
#line 1299 "parser.y" /* yacc.c:355  */

  char  *id;
  List  *bases;
  struct Define {
    String *val;
    String *rawval;
    int     type;
    String *qualifier;
    String *bitfield;
    Parm   *throws;
    String *throwf;
    String *nexcept;
  } dtype;
  struct {
    const char *type;
    String *filename;
    int   line;
  } loc;
  struct {
    char      *id;
    SwigType  *type;
    String    *defarg;
    ParmList  *parms;
    short      have_parms;
    ParmList  *throws;
    String    *throwf;
    String    *nexcept;
  } decl;
  Parm         *tparms;
  struct {
    String     *method;
    Hash       *kwargs;
  } tmap;
  struct {
    String     *type;
    String     *us;
  } ptype;
  SwigType     *type;
  String       *str;
  Parm         *p;
  ParmList     *pl;
  int           intvalue;
  Node         *node;

#line 1708 "y.tab.c" /* yacc.c:355  */
};
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_Y_TAB_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 1723 "y.tab.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  61
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   5070

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  141
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  167
/* YYNRULES -- Number of rules.  */
#define YYNRULES  568
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1113

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   395

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1464,  1464,  1476,  1480,  1483,  1486,  1489,  1492,  1497,
    1502,  1507,  1508,  1509,  1510,  1511,  1517,  1533,  1543,  1544,
    1545,  1546,  1547,  1548,  1549,  1550,  1551,  1552,  1553,  1554,
    1555,  1556,  1557,  1558,  1559,  1560,  1561,  1562,  1563,  1570,
    1570,  1652,  1662,  1673,  1694,  1716,  1727,  1736,  1755,  1761,
    1767,  1772,  1779,  1786,  1790,  1803,  1812,  1827,  1840,  1840,
    1896,  1897,  1904,  1923,  1954,  1958,  1968,  1973,  1991,  2034,
    2040,  2053,  2059,  2085,  2091,  2098,  2099,  2102,  2103,  2110,
    2156,  2202,  2213,  2216,  2243,  2249,  2255,  2261,  2269,  2275,
    2281,  2287,  2295,  2296,  2297,  2300,  2305,  2315,  2351,  2352,
    2387,  2404,  2412,  2425,  2450,  2456,  2460,  2463,  2474,  2479,
    2492,  2504,  2794,  2804,  2811,  2812,  2816,  2816,  2841,  2847,
    2858,  2874,  2934,  2992,  2996,  3019,  3025,  3032,  3039,  3046,
    3055,  3056,  3057,  3058,  3059,  3060,  3061,  3072,  3077,  3082,
    3089,  3095,  3100,  3103,  3103,  3116,  3119,  3122,  3131,  3134,
    3141,  3163,  3192,  3290,  3342,  3343,  3344,  3345,  3346,  3347,
    3352,  3352,  3599,  3599,  3744,  3745,  3757,  3775,  3775,  4034,
    4040,  4046,  4049,  4052,  4055,  4058,  4061,  4064,  4069,  4105,
    4109,  4112,  4115,  4120,  4124,  4129,  4139,  4170,  4170,  4199,
    4199,  4221,  4248,  4265,  4270,  4265,  4278,  4279,  4280,  4280,
    4296,  4297,  4314,  4315,  4316,  4317,  4318,  4319,  4320,  4321,
    4322,  4323,  4324,  4325,  4326,  4327,  4328,  4329,  4330,  4339,
    4367,  4394,  4425,  4440,  4457,  4475,  4494,  4513,  4520,  4527,
    4534,  4542,  4550,  4553,  4557,  4560,  4561,  4562,  4563,  4564,
    4565,  4566,  4567,  4570,  4577,  4584,  4593,  4602,  4611,  4623,
    4626,  4629,  4630,  4631,  4632,  4634,  4643,  4644,  4654,  4664,
    4665,  4666,  4667,  4668,  4669,  4670,  4671,  4672,  4673,  4674,
    4675,  4676,  4683,  4694,  4698,  4701,  4705,  4709,  4719,  4727,
    4735,  4748,  4752,  4755,  4759,  4763,  4791,  4799,  4811,  4826,
    4836,  4845,  4856,  4860,  4864,  4871,  4888,  4905,  4913,  4921,
    4930,  4939,  4943,  4952,  4963,  4974,  4986,  4996,  5010,  5018,
    5027,  5036,  5040,  5049,  5060,  5071,  5083,  5093,  5103,  5114,
    5127,  5134,  5142,  5158,  5166,  5177,  5188,  5199,  5218,  5226,
    5243,  5251,  5258,  5265,  5276,  5287,  5298,  5318,  5339,  5345,
    5351,  5358,  5365,  5374,  5383,  5386,  5395,  5404,  5411,  5418,
    5425,  5435,  5446,  5457,  5468,  5475,  5482,  5485,  5502,  5512,
    5519,  5525,  5530,  5536,  5540,  5546,  5547,  5548,  5554,  5560,
    5564,  5565,  5569,  5576,  5579,  5580,  5581,  5582,  5583,  5585,
    5588,  5591,  5596,  5607,  5632,  5635,  5689,  5693,  5697,  5701,
    5705,  5709,  5713,  5717,  5721,  5725,  5729,  5733,  5737,  5741,
    5747,  5747,  5761,  5777,  5780,  5786,  5799,  5813,  5814,  5817,
    5818,  5822,  5828,  5831,  5835,  5840,  5848,  5860,  5875,  5876,
    5895,  5896,  5900,  5905,  5910,  5911,  5916,  5929,  5944,  5951,
    5968,  5975,  5982,  5989,  5997,  6005,  6009,  6013,  6019,  6020,
    6021,  6022,  6023,  6024,  6025,  6026,  6029,  6033,  6037,  6041,
    6045,  6049,  6053,  6057,  6061,  6065,  6069,  6073,  6077,  6081,
    6095,  6099,  6103,  6109,  6113,  6117,  6121,  6125,  6141,  6146,
    6149,  6154,  6159,  6159,  6160,  6163,  6180,  6189,  6189,  6207,
    6207,  6225,  6226,  6227,  6231,  6235,  6239,  6243,  6249,  6252,
    6256,  6262,  6263,  6266,  6269,  6272,  6275,  6280,  6285,  6290,
    6295,  6300,  6307,  6313,  6317,  6321,  6329,  6337,  6345,  6354,
    6363,  6370,  6379,  6380,  6383,  6384,  6385,  6386,  6389,  6401,
    6407,  6413,  6417,  6418,  6419,  6422,  6423,  6424,  6427,  6428,
    6431,  6436,  6440,  6443,  6446,  6449,  6454,  6458,  6461,  6468,
    6474,  6483,  6488,  6492,  6495,  6498,  6501,  6506,  6510,  6513,
    6516,  6522,  6527,  6530,  6542,  6545,  6548,  6552,  6557,  6570,
    6574,  6579,  6585,  6589,  6594,  6598,  6605,  6608,  6613
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ID", "HBLOCK", "POUND", "STRING",
  "WSTRING", "INCLUDE", "IMPORT", "INSERT", "CHARCONST", "WCHARCONST",
  "NUM_INT", "NUM_FLOAT", "NUM_UNSIGNED", "NUM_LONG", "NUM_ULONG",
  "NUM_LONGLONG", "NUM_ULONGLONG", "NUM_BOOL", "TYPEDEF", "TYPE_INT",
  "TYPE_UNSIGNED", "TYPE_SHORT", "TYPE_LONG", "TYPE_FLOAT", "TYPE_DOUBLE",
  "TYPE_CHAR", "TYPE_WCHAR", "TYPE_VOID", "TYPE_SIGNED", "TYPE_BOOL",
  "TYPE_COMPLEX", "TYPE_TYPEDEF", "TYPE_RAW", "TYPE_NON_ISO_INT8",
  "TYPE_NON_ISO_INT16", "TYPE_NON_ISO_INT32", "TYPE_NON_ISO_INT64",
  "LPAREN", "RPAREN", "COMMA", "SEMI", "EXTERN", "INIT", "LBRACE",
  "RBRACE", "PERIOD", "CONST_QUAL", "VOLATILE", "REGISTER", "STRUCT",
  "UNION", "EQUAL", "SIZEOF", "MODULE", "LBRACKET", "RBRACKET",
  "BEGINFILE", "ENDOFFILE", "ILLEGAL", "CONSTANT", "NAME", "RENAME",
  "NAMEWARN", "EXTEND", "PRAGMA", "FEATURE", "VARARGS", "ENUM", "CLASS",
  "TYPENAME", "PRIVATE", "PUBLIC", "PROTECTED", "COLON", "STATIC",
  "VIRTUAL", "FRIEND", "THROW", "CATCH", "EXPLICIT", "STATIC_ASSERT",
  "CONSTEXPR", "THREAD_LOCAL", "DECLTYPE", "AUTO", "NOEXCEPT", "OVERRIDE",
  "FINAL", "USING", "NAMESPACE", "NATIVE", "INLINE", "TYPEMAP", "EXCEPT",
  "ECHO", "APPLY", "CLEAR", "SWIGTEMPLATE", "FRAGMENT", "WARN", "LESSTHAN",
  "GREATERTHAN", "DELETE_KW", "DEFAULT", "LESSTHANOREQUALTO",
  "GREATERTHANOREQUALTO", "EQUALTO", "NOTEQUALTO", "ARROW", "QUESTIONMARK",
  "TYPES", "PARMS", "NONID", "DSTAR", "DCNOT", "TEMPLATE", "OPERATOR",
  "COPERATOR", "PARSETYPE", "PARSEPARM", "PARSEPARMS", "CAST", "LOR",
  "LAND", "OR", "XOR", "AND", "LSHIFT", "RSHIFT", "PLUS", "MINUS", "STAR",
  "SLASH", "MODULO", "UMINUS", "NOT", "LNOT", "DCOLON", "$accept",
  "program", "interface", "declaration", "swig_directive",
  "extend_directive", "$@1", "apply_directive", "clear_directive",
  "constant_directive", "echo_directive", "except_directive", "stringtype",
  "fname", "fragment_directive", "include_directive", "$@2", "includetype",
  "inline_directive", "insert_directive", "module_directive",
  "name_directive", "native_directive", "pragma_directive", "pragma_arg",
  "pragma_lang", "rename_directive", "rename_namewarn",
  "feature_directive", "stringbracesemi", "featattr", "varargs_directive",
  "varargs_parms", "typemap_directive", "typemap_type", "tm_list",
  "tm_tail", "typemap_parm", "types_directive", "template_directive",
  "warn_directive", "c_declaration", "$@3", "c_decl", "c_decl_tail",
  "initializer", "cpp_alternate_rettype", "cpp_lambda_decl",
  "lambda_introducer", "lambda_body", "lambda_tail", "$@4", "c_enum_key",
  "c_enum_inherit", "c_enum_forward_decl", "c_enum_decl",
  "c_constructor_decl", "cpp_declaration", "cpp_class_decl", "@5", "@6",
  "cpp_opt_declarators", "cpp_forward_class_decl", "cpp_template_decl",
  "$@7", "cpp_temp_possible", "template_parms", "templateparameters",
  "templateparameter", "templateparameterstail", "cpp_using_decl",
  "cpp_namespace_decl", "$@8", "$@9", "cpp_members", "$@10", "$@11",
  "$@12", "cpp_member", "cpp_constructor_decl", "cpp_destructor_decl",
  "cpp_conversion_operator", "cpp_catch_decl", "cpp_static_assert",
  "cpp_protection_decl", "cpp_swig_directive", "cpp_end", "cpp_vend",
  "anonymous_bitfield", "anon_bitfield_type", "storage_class", "parms",
  "rawparms", "ptail", "parm", "valparms", "rawvalparms", "valptail",
  "valparm", "def_args", "parameter_declarator",
  "typemap_parameter_declarator", "declarator", "notso_direct_declarator",
  "direct_declarator", "abstract_declarator", "direct_abstract_declarator",
  "pointer", "type_qualifier", "type_qualifier_raw", "type", "rawtype",
  "type_right", "decltype", "primitive_type", "primitive_type_list",
  "type_specifier", "definetype", "$@13", "default_delete",
  "deleted_definition", "explicit_default", "ename",
  "optional_constant_directive", "enumlist", "edecl", "etype", "expr",
  "valexpr", "exprnum", "exprcompound", "ellipsis", "variadic", "inherit",
  "raw_inherit", "$@14", "base_list", "base_specifier", "@15", "@16",
  "access_specifier", "templcpptype", "cpptype", "opt_virtual",
  "virt_specifier_seq", "exception_specification", "cpp_const", "ctor_end",
  "ctor_initializer", "mem_initializer_list", "mem_initializer",
  "template_decl", "identifier", "idstring", "idstringopt", "idcolon",
  "idcolontail", "idtemplate", "idcolonnt", "idcolontailnt", "string",
  "wstring", "stringbrace", "options", "kwargs", "stringnum", "empty", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395
};
# endif

#define YYPACT_NINF -861

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-861)))

#define YYTABLE_NINF -569

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     668,  4164,  4236,   196,   118,  3654,  -861,  -861,  -861,  -861,
    -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,
    -861,   -68,  -861,  -861,  -861,  -861,  -861,   232,  -861,  -861,
    -861,  -861,  -861,   285,   263,   281,   137,  -861,  -861,   219,
     265,  -861,    97,   321,  4881,   580,  1230,   580,  -861,  -861,
    -861,  2257,  -861,    97,   -68,  -861,   179,  -861,   400,   404,
    4598,  -861,   334,  -861,  -861,  -861,   416,  -861,  -861,    47,
     432,  4308,   441,  -861,  -861,   432,   468,   476,   487,   382,
    -861,  -861,   496,  -861,  -861,   149,   924,    60,   510,   257,
     515,   629,   294,  4669,  4669,   517,   528,   532,   540,   180,
    -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,
     432,  -861,  -861,  -861,  -861,  -861,  -861,  -861,   477,  -861,
    -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,
    -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,  4740,  -861,
    2182,  -861,  -861,   453,  -861,  -861,   534,   536,    97,   120,
     533,  -861,  -861,   580,  -861,  3326,   545,   236,  2316,  3120,
     592,  1322,  2188,   390,    97,  -861,  -861,   254,    63,   254,
     346,   763,   493,  -861,  -861,  -861,  -861,  -861,   106,   173,
    -861,  -861,  -861,   575,  -861,   582,  -861,  -861,   471,  -861,
    -861,   533,    83,   471,   471,  -861,   599,  1660,  -861,     1,
    1029,    97,   106,   106,  -861,   471,  4526,  -861,  -861,  4598,
    -861,  -861,    97,    30,  -861,    24,   591,   106,  -861,  -861,
     471,   106,  -861,  -861,  -861,   642,  4598,   604,   264,   652,
     663,   471,   532,   642,  4598,  4598,    97,   532,  1479,  1106,
    1477,   471,   220,   603,  1660,    97,  1810,   135,  -861,  -861,
    -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,  3120,
     371,  3120,  3120,  3120,  3120,  3120,  3120,  3120,  -861,   617,
    -861,   682,   688,   394,  2131,    15,  -861,  -861,   642,   738,
    -861,  -861,   707,   714,   706,  -861,   179,   660,  -861,  3439,
     198,   198,   726,   727,  1695,   658,   736,  -861,  -861,  -861,
     719,  3120,  -861,  -861,  -861,  -861,  4312,  -861,  2131,   746,
    3439,   744,    97,   364,   346,  -861,   750,   364,   346,  -861,
     666,  -861,  -861,  4598,  2450,  -861,  4598,  2584,   757,  2322,
    2456,   364,   346,   691,   784,  -861,  -861,   179,   766,  4598,
    -861,  -861,  -861,  -861,   772,   642,    97,  -861,  -861,  -861,
     251,   786,  -861,  -861,   654,   254,   495,  -861,   792,   779,
     793,   781,   637,   795,   797,  -861,   798,   799,  -861,  -861,
    -861,    97,  -861,   804,   805,  -861,   806,   807,  4669,  -861,
    -861,  -861,  -861,  -861,  4669,  -861,  -861,  -861,   810,  -861,
    -861,   693,   194,   817,   758,  -861,   818,  -861,    43,  -861,
    -861,   200,   261,   261,   261,   370,   724,   820,   272,   824,
    1753,  1878,   752,   784,   764,    62,   801,    23,  -861,  3511,
    1356,  -861,   823,  -861,   342,  -861,  2551,  4811,   831,  3069,
    2692,  -861,  -861,  -861,  -861,  -861,  -861,  2182,  -861,  -861,
    -861,  3120,  3120,  3120,  3120,  3120,  3120,  3120,  3120,  3120,
    3120,  3120,  3120,  3120,  3120,  3120,  3120,  3120,  -861,  -861,
    -861,  -861,  -861,   533,   422,   422,  1157,   765,   337,  -861,
     435,  -861,  -861,   422,   422,   489,   768,   261,   261,  3120,
    2131,  -861,  4598,  1866,    19,   837,  -861,  4598,  2718,   839,
    -861,   849,  -861,  4673,   853,  -861,  4760,   847,   848,   364,
     346,   852,   364,   346,   988,   854,   856,  2270,   364,  -861,
    -861,   582,    55,  -861,  -861,   471,  1297,  -861,   863,   864,
    -861,  -861,  -861,   369,  1252,  2005,   868,  4598,  1660,   866,
    -861,  3756,   871,  -861,  1066,  4669,   392,   876,   870,   663,
     407,   872,   471,  4598,   459,   833,  4598,  -861,  -861,  -861,
     261,  1254,   851,    26,  -861,  1844,  4951,   874,  4881,   448,
    -861,   887,   724,   896,   189,   855,   840,   548,  -861,   556,
    -861,   254,   860,  -861,  -861,   893,  3120,  2852,  2986,  3254,
      -1,  1230,   894,   682,  1107,  1107,   889,   889,  2288,  2935,
    3069,  2827,  2559,  2692,   875,   875,   687,   687,  -861,  -861,
    -861,    97,   768,  -861,  -861,  -861,  -861,   422,   508,    63,
    4885,   908,   594,   768,  -861,   851,   851,   910,  -861,  4897,
     851,  -861,  -861,  -861,  -861,   851,   906,   907,   912,   914,
    2404,   364,   346,   915,   920,   926,   364,  -861,  -861,  -861,
     642,  3858,  -861,   934,  -861,   194,   937,  -861,  -861,  2054,
    -861,  -861,   642,  -861,  -861,  -861,   946,  -861,   538,   642,
    -861,   933,   116,   699,  1252,  -861,   538,  -861,  -861,  -861,
    3960,    46,  4811,   403,  -861,  -861,  4598,  -861,  -861,   850,
    -861,   252,   885,  -861,   953,   954,  -861,    97,  1316,   818,
    -861,   538,   259,   851,  -861,  -861,   -68,  -861,  1356,  -861,
    -861,  -861,  -861,   383,  -861,  -861,   950,  1634,  4598,  3120,
    -861,  -861,  -861,  1660,  -861,  -861,  -861,  -861,   254,  -861,
    -861,   975,  -861,   756,  -861,  2054,  -861,  2131,  3120,  3120,
    3254,  3581,  3120,   989,   993,   999,  1001,  -861,  3120,   254,
    -861,  -861,  -861,  -861,   598,   364,  -861,  -861,   364,   364,
     851,   851,   994,   998,  1003,   364,   851,  1005,  1007,  -861,
     471,   471,  -861,  -861,  1010,   971,   973,   982,   921,  1017,
     106,  -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,
    -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,  -861,
    -861,  -861,  1013,  2054,  -861,  -861,  -861,  -861,  -861,  -861,
    -861,  -861,  4379,  1015,  4598,   728,  -861,   459,  -861,  1297,
    1373,   471,  1022,  -861,   538,  1026,  -861,    52,  1660,   141,
    -861,  4669,  -861,  1034,   255,   106,   363,  -861,  2182,   270,
    -861,  1025,    47,   329,  -861,  -861,  -861,  -861,  -861,  -861,
    -861,  -861,  4451,  -861,  4062,  1028,  -861,  -861,   548,  4598,
    -861,   463,  -861,   106,   171,  -861,  4598,   495,  1031,  1006,
    -861,  1043,  2685,  1356,  -861,   860,  -861,  -861,  -861,    97,
    -861,  1039,  2054,  2131,  2131,  2131,  3120,  3120,  -861,  4811,
    2422,  -861,  -861,   364,   364,   851,  1044,  1049,   364,   851,
     851,  -861,  -861,  2054,  -861,  -861,  -861,  -861,   106,  -861,
    1051,  -861,  -861,  1024,  1036,   -68,  1037,  4811,  1045,  1823,
    1047,   165,  1057,  -861,  -861,   642,  1059,  -861,   538,  1461,
     459,  -861,  1061,  -861,  1062,  -861,  -861,   252,  -861,  -861,
     252,  1011,  -861,  -861,   106,  4598,  1660,  -861,  -861,  -861,
    1083,  -861,  -861,  -861,   950,  1048,   950,  1488,  1084,  1089,
     495,    97,   475,  -861,  -861,  -861,   548,  -861,  1085,   860,
    1617,  1090,  2131,  2131,  1230,   364,   851,   851,   364,   364,
    -861,  2054,  1096,  4598,  1063,    25,  3120,  3511,  -861,  1095,
    -861,  1097,  -861,   538,  -861,  -861,  -861,  -861,  -861,  1099,
    -861,  1052,   538,  1109,  -861,  3120,   106,  -861,  1356,   613,
    -861,  1110,  1120,  1101,   418,  -861,  -861,  -861,  1119,  -861,
    -861,  -861,    97,  -861,  -861,  1356,  1617,  1127,   364,   364,
    1123,  4598,  1130,  4598,  1132,  1133,   -17,  2818,  1135,  -861,
    -861,  1134,  -861,  -861,     4,  -861,  -861,  2131,   950,   548,
    -861,  -861,  -861,    97,  1131,  -861,  -861,  1137,  1085,   548,
    -861,  -861,  -861,  1139,   538,  1141,  4598,  4598,  4598,  1138,
    -861,  1634,  -861,  4811,   463,  -861,  -861,  1140,  1142,  -861,
    -861,  -861,  2054,   538,  -861,   461,   538,  1146,  1148,  1150,
    4598,  -861,  1153,  -861,  1145,  -861,  -861,  -861,   498,  -861,
    -861,   495,  -861,   538,   538,   538,  1159,   463,  1155,  -861,
    -861,   495,  1151,  -861,  -861,  -861,   538,  -861,  -861,  1161,
    -861,  -861,  -861
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
     568,     0,     0,     0,     0,     0,    10,     4,   522,   386,
     394,   387,   388,   391,   392,   389,   390,   375,   393,   374,
     395,   568,   378,   396,   397,   398,   399,     0,   365,   366,
     367,   489,   490,   145,   484,   485,     0,   523,   524,     0,
       0,   534,     0,     0,     0,   363,   568,   370,   381,   373,
     383,   384,   488,     0,   568,   379,   532,     6,     0,     0,
     568,     1,    15,    64,    60,    61,     0,   260,    14,   256,
     568,     0,     0,    82,    83,   568,   568,     0,     0,   259,
     261,   262,     0,   263,   264,   266,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       9,    11,    18,    19,    20,    21,    22,    23,    24,    25,
     568,    26,    27,    28,    29,    30,    31,    32,     0,    33,
      34,    35,    36,    37,    38,    12,   113,   118,   115,   114,
      16,    13,   154,   155,   156,   157,   158,   159,     0,   271,
     568,   376,   521,     0,   147,   146,     0,     0,     0,     0,
       0,   377,     3,   369,   364,   568,     0,   400,     0,     0,
     534,   348,   347,   362,     0,   294,   277,   568,   301,   568,
     344,   338,   328,   291,   371,   385,   380,   540,     0,     0,
     530,     5,     8,     0,   272,   568,   274,    17,     0,   552,
     269,     0,   257,     0,     0,   559,     0,     0,   368,   568,
       0,     0,     0,     0,    78,     0,   568,   265,   268,   568,
     270,   267,     0,     0,   189,   568,     0,     0,    62,    63,
       0,     0,    51,    49,    46,    47,   568,     0,   568,     0,
     568,   568,     0,   112,   568,   568,     0,     0,     0,     0,
       0,     0,     0,   328,     0,   568,     0,   568,   554,   426,
     427,   438,   439,   440,   441,   442,   443,   444,   445,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   285,     0,
     280,   568,   419,   368,     0,   418,   420,   424,   421,   425,
     282,   279,     0,     0,     0,   535,   533,     0,   372,   568,
     348,   347,     0,     0,   338,   379,     0,   289,   405,   406,
     287,     0,   402,   403,   404,   354,     0,   418,   290,     0,
     568,     0,     0,   303,   346,   320,     0,   302,   345,   360,
     361,   329,   292,   568,     0,   293,   568,     0,     0,   341,
     340,   298,   339,   320,   349,   539,   538,   537,     0,     0,
     273,   276,   526,   525,     0,   527,     0,   551,   116,   258,
     562,     0,    68,    45,     0,   568,   400,    70,     0,     0,
       0,    74,     0,     0,     0,    98,     0,     0,   185,   119,
     568,     0,   187,     0,     0,   103,     0,     0,     0,   107,
     295,   296,   297,    42,     0,   104,   106,   528,     0,   529,
      54,     0,    53,     0,     0,   178,   568,   182,   488,   180,
     169,     0,     0,     0,     0,   525,     0,     0,     0,     0,
       0,     0,   320,     0,     0,   328,   568,   568,   408,   568,
     568,   472,     0,   471,   380,   474,     0,     0,     0,   436,
     435,   464,   463,   437,   465,   466,   520,     0,   281,   284,
     467,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   553,   486,
     487,   382,   531,     0,   348,   347,   338,   379,     0,   328,
       0,   358,   356,   341,   340,     0,   328,   349,     0,     0,
     401,   355,   568,   338,   379,     0,   321,   568,     0,     0,
     359,     0,   334,     0,     0,   352,     0,     0,     0,   300,
     343,     0,   299,   342,   350,     0,     0,     0,   304,   536,
       7,   568,     0,   170,   568,     0,     0,   558,     0,     0,
      69,    39,    77,     0,     0,     0,     0,     0,     0,     0,
     186,     0,     0,   568,   568,     0,     0,   108,     0,   568,
       0,     0,     0,     0,     0,   167,     0,   179,   184,    58,
       0,     0,     0,     0,    79,     0,     0,     0,     0,     0,
     149,     0,   379,     0,   498,   493,   494,     0,   126,   568,
     499,   568,   568,   162,   166,     0,   428,     0,     0,   362,
       0,   568,     0,   568,   461,   460,   458,   459,     0,   457,
     456,   452,   453,   451,   454,   455,   446,   447,   448,   449,
     450,     0,     0,   349,   332,   331,   330,   350,     0,   311,
       0,     0,     0,   320,   322,   349,     0,     0,   325,     0,
       0,   336,   335,   357,   353,     0,     0,     0,     0,     0,
       0,   305,   351,     0,     0,     0,   307,   275,    66,    67,
      65,     0,   563,   564,   567,   566,   560,    44,    43,     0,
      76,    73,    75,   557,    93,   556,     0,    88,   568,   555,
      92,     0,   566,     0,     0,    99,   568,   227,   190,   191,
       0,   256,     0,     0,    50,    48,   568,    41,   105,     0,
     545,   543,     0,    57,     0,     0,   110,     0,   568,   568,
     568,   568,     0,     0,   132,   131,   568,   134,   568,   136,
     130,   135,   140,     0,   148,   150,   568,   568,   568,     0,
     500,   496,   495,     0,   123,   125,   121,   127,   568,   128,
     491,   473,   475,   477,   492,     0,   160,   429,     0,     0,
     362,   361,     0,     0,     0,     0,     0,   283,     0,   568,
     333,   288,   337,   323,     0,   313,   327,   326,   312,   308,
       0,     0,     0,     0,     0,   306,     0,     0,     0,   117,
       0,     0,   198,   218,     0,     0,     0,     0,   261,     0,
       0,   240,   241,   233,   242,   216,   196,   238,   234,   232,
     235,   236,   237,   239,   217,   213,   214,   200,   208,   207,
     211,   210,     0,     0,   201,   202,   206,   212,   203,   204,
     205,   215,     0,   271,   568,   502,   503,     0,   505,     0,
       0,     0,     0,    90,   568,     0,   188,   257,     0,   568,
     101,     0,   100,     0,     0,     0,     0,   541,   568,     0,
      52,     0,   256,     0,   171,   172,   176,   175,   168,   173,
     177,   174,     0,   183,     0,     0,    81,   133,     0,   568,
     141,     0,   409,   414,     0,   410,   568,   400,   503,   568,
     153,     0,     0,   568,   129,   568,   482,   481,   483,     0,
     479,     0,     0,   432,   431,   430,     0,     0,   422,     0,
     462,   278,   324,   310,   309,     0,     0,     0,   314,     0,
       0,   565,   561,     0,   193,   230,   229,   231,     0,   228,
       0,    40,   192,   375,   374,   568,   378,     0,     0,     0,
     373,   379,     0,   504,    84,   566,    95,    89,   568,     0,
       0,    97,     0,    71,     0,   109,   546,   544,   550,   549,
     548,     0,    55,    56,     0,   568,     0,    59,    80,   122,
       0,   143,   142,   139,   568,   415,   568,     0,     0,     0,
       0,     0,     0,   513,   497,   501,     0,   476,   568,   568,
       0,     0,   434,   433,   568,   315,     0,     0,   319,   318,
     199,     0,     0,   568,   376,     0,     0,   568,   209,     0,
      96,     0,    91,   568,    86,    72,   102,   542,   547,     0,
     120,     0,   568,     0,   413,     0,   412,   151,   568,     0,
     510,     0,   512,   514,     0,   506,   507,   124,     0,   469,
     478,   470,     0,   164,   163,   568,     0,     0,   317,   316,
       0,   568,     0,   568,     0,     0,     0,     0,     0,    94,
      85,     0,   111,   167,     0,   144,   416,   417,   568,     0,
     508,   509,   511,     0,     0,   518,   519,     0,   568,     0,
     161,   423,   194,     0,   568,     0,   568,   568,   568,     0,
     249,   568,    87,     0,     0,   411,   152,   515,     0,   468,
     480,   165,     0,   568,   220,     0,   568,     0,     0,     0,
     568,   219,     0,   137,     0,   516,   195,   221,     0,   243,
     245,     0,   226,   568,   568,   568,     0,     0,     0,   246,
     248,   400,     0,   224,   223,   222,   568,   138,   517,     0,
     244,   225,   247
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -861,  -861,  -350,  -861,  -861,  -861,  -861,    32,    39,     6,
      44,  -861,   689,  -861,    67,    76,  -861,  -861,  -861,    81,
    -861,    82,  -861,    86,  -861,  -861,    88,  -861,    89,  -531,
    -635,    90,  -861,   112,  -861,  -331,   667,   -85,   129,   131,
     134,   136,  -861,   519,  -812,  -672,  -861,  -861,  -861,  -860,
    -807,  -861,  -119,  -861,  -861,  -861,  -861,  -861,    12,  -861,
    -861,   195,    22,    27,  -861,  -861,   280,  -861,   670,   531,
     140,  -861,  -861,  -861,  -701,  -861,  -861,  -861,  -861,   529,
    -861,   539,   156,   544,  -861,  -861,  -861,  -681,  -861,  -861,
      11,   -54,  -861,   717,    13,   406,  -861,   653,   808,    -7,
    -580,  -861,   -39,  1147,  -183,  -107,    -5,    18,    35,  -861,
     -64,     8,   -11,   695,  -525,  1201,  -861,  -338,  -861,  -154,
    -861,  -861,  -861,  -848,  -861,   258,  -861,  1192,  -115,  -482,
    -861,  -861,   211,   842,  -861,  -861,  -861,   398,  -861,  -861,
    -861,  -231,   -48,   305,   705,  -375,  -561,   213,  -861,  -861,
     234,   -19,   981,  -117,  -861,   919,  -224,  -137,  -861,  -266,
    1030,  -861,   602,   174,  -182,  -503,     0
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     4,     5,   100,   101,   102,   649,   771,   772,   773,
     774,   107,   390,   391,   775,   776,   690,   110,   111,   777,
     113,   778,   115,   779,   651,   203,   780,   118,   781,   657,
     526,   782,   364,   783,   374,   229,   385,   230,   784,   785,
     786,   787,   514,   126,   716,   567,   698,   127,   703,   851,
     943,   993,    42,   559,   128,   129,   130,   131,   788,   872,
     725,  1014,   789,   790,   688,   838,   394,   395,   396,   547,
     791,   136,   533,   370,   792,   971,  1072,   893,   793,   794,
     795,   796,   797,   798,   799,   800,  1074,  1087,   801,   908,
     802,   292,   184,   340,   185,   269,   270,   438,   271,   568,
     166,   379,   167,   313,   168,   169,   170,   242,    44,    45,
     272,   198,    47,    48,    49,    50,    51,   300,   301,   342,
     303,   304,   416,   853,   854,   944,  1036,   274,   307,   276,
     277,  1009,  1010,   422,   423,   572,   721,   722,   869,   959,
     870,    52,    53,   723,   570,   806,  1088,   860,   952,  1002,
    1003,   177,    54,   350,   388,    55,   180,    56,   682,   827,
     278,   279,   660,   194,   351,   646,   186
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
       6,   735,   141,   302,   398,   139,   183,   197,   227,    46,
      46,   105,   286,   686,    43,    58,   138,   132,   519,   245,
     531,   142,   663,  1058,   871,   275,   848,   133,   812,   228,
     228,   700,   134,   153,   644,   140,   939,   103,   375,   165,
     732,   335,   337,   644,   104,   571,   173,   538,   293,   106,
     850,   236,   189,   189,   142,   356,   407,  -286,   347,   638,
     614,   189,   462,     8,   171,  1023,  -407,   614,    46,  -407,
     195,   344,   108,   368,   246,   195,   204,   352,   371,   241,
     154,   109,   174,   358,   369,  -181,   112,   114,   362,   347,
     247,   116,   902,   117,   119,   120,   994,   807,   996,  -407,
       8,   639,   287,   323,   140,   815,   214,   468,   470,     8,
     195,   475,  1059,   509,   387,  1063,   557,   121,    61,  -286,
     324,   381,   347,     8,   409,   733,   140,   140,   734,   348,
     845,   190,   190,   813,   122,   615,   123,   349,     8,   124,
     280,   125,   693,   346,  1007,   135,   859,  -181,   273,    37,
      38,  1024,   365,   268,  1025,   366,   314,   318,   355,   163,
     322,   137,   325,    46,   641,   191,   332,   173,   349,   173,
    -527,   961,   377,   294,  1064,    39,     8,   148,   413,    41,
     393,   319,   293,   670,   923,   341,    37,    38,   288,   380,
    1065,   956,   970,   210,   718,    37,    38,    59,   320,   142,
     347,     8,   302,   293,   673,   414,   347,   420,   978,    37,
      38,   421,    39,   946,    46,   142,    41,    46,   947,   468,
     470,   475,  1097,     8,    37,    38,   211,  1066,   382,   709,
     386,   389,    31,    32,    46,   399,    60,  1071,   155,   285,
     543,  -255,    46,    46,   140,   418,   171,   425,   397,   201,
      39,    34,    35,   920,    41,   158,   404,  1083,     8,   549,
     408,   218,    37,    38,     8,   347,   165,     8,   328,   491,
    1020,   439,   494,   173,   932,     8,   914,   910,   565,   566,
     143,   980,   297,   235,   237,   314,   318,    37,    38,   332,
    1107,   171,   336,   515,   608,   609,   178,    46,   224,   539,
     189,   354,   846,   219,   155,   516,   916,   466,   157,    37,
      38,   146,   156,    39,   228,   398,   933,   160,    46,   179,
     228,   158,   275,   571,   500,   503,  1039,   644,   483,   147,
     159,    46,   858,   642,    46,    39,   164,   144,   490,    41,
     844,   298,   299,  1049,    37,    38,   410,    46,   518,   411,
      37,    38,   511,    37,    38,   173,   145,   981,   312,   149,
     684,    37,    38,   581,   152,   561,     8,   608,   150,   825,
       6,  1086,   404,   650,   926,   189,    39,   323,   604,    39,
     160,    31,    32,   160,  1017,   574,   326,    39,  -568,   984,
     161,    41,   826,   162,   324,  1092,   548,     8,   163,   164,
      34,    35,   164,   327,   487,   142,   163,   653,   661,   189,
       8,   427,  1103,  1104,  1105,   601,   560,   142,   421,   428,
     173,   488,  1031,   849,   425,  1111,   552,    46,   611,   850,
     913,  1034,   935,   617,   155,   674,  -568,   404,   675,    28,
      29,    30,   156,   181,   580,   273,   820,   182,   157,   655,
     268,   158,    37,    38,   187,   569,   188,   821,  1045,   314,
     318,   332,   289,   653,  1046,   189,   207,   208,   500,   503,
     159,   228,   193,   140,     8,   323,   605,   189,   332,   158,
       8,   200,   929,    37,    38,   658,  -568,  -568,   571,   666,
      46,   705,   324,  1075,   706,    46,    37,    38,  -568,   632,
     859,   281,   654,   941,  1089,   655,   942,  1090,   202,    39,
    -568,   341,   691,   160,     6,  1091,   205,   238,  1005,   949,
     161,  1006,   679,   162,   163,   156,   680,   206,   163,   323,
     606,   139,   164,     6,   139,    46,   209,   105,   189,   386,
     665,  1099,   138,   132,  1100,   672,   324,   704,   323,   740,
     217,    46,  1101,   133,    46,   220,   685,   231,   134,   397,
      37,    38,   717,   103,   719,   324,    37,    38,   232,   173,
     104,   173,   724,   656,   165,   106,   298,   299,   891,   892,
     234,   173,   282,   439,   283,    31,    32,    28,    29,    30,
     713,   714,    39,   296,   715,   309,   160,   319,   108,   171,
     298,   299,   632,   239,    34,    35,   240,   109,   818,   334,
     157,   163,   112,   114,   731,   164,   338,   116,   563,   117,
     119,   120,   823,   571,   339,   814,   564,   565,   566,    28,
      29,    30,   159,   900,   487,   743,   563,   372,   487,   882,
     571,   139,   353,   121,   564,   565,   566,   105,   347,   803,
     378,   488,   138,   132,   861,   488,  1040,     8,   808,  1041,
     122,   987,   123,   133,   988,   124,   808,   125,   134,   221,
     139,   135,   222,   103,   863,   223,   105,   847,   524,   525,
     104,   138,   132,   245,    46,   106,   858,   137,   139,   548,
       6,   808,   133,   805,   661,   383,   142,   134,   173,   842,
     835,   805,   103,   302,   398,   384,   855,   808,   108,   104,
     836,   864,   852,   275,   106,   837,    46,   109,   173,   413,
     153,   436,   112,   114,   437,   803,   805,   116,   440,   117,
     119,   120,   881,   569,   541,   542,   924,   108,   909,   173,
     810,   811,   805,    37,    38,   458,   109,   461,   319,   490,
     912,   112,   114,   121,   247,   459,   116,   228,   117,   119,
     120,   972,   460,  1109,   463,   731,     8,   471,   472,    39,
     122,   918,   123,    41,   477,   124,   479,   125,   909,   922,
     402,   135,   121,   403,   478,   236,   482,     8,   163,     1,
       2,     3,   485,   803,   247,   940,  1001,   137,   489,   122,
     163,   123,   948,   310,   124,   497,   125,   504,   563,   510,
     135,   328,    46,   512,   808,   964,   564,   565,   566,   142,
     158,   455,   456,   457,   408,   521,   137,   517,   280,   866,
     867,   868,   505,   520,   522,   523,   273,   527,   528,   529,
     550,   268,   530,   975,   139,   534,   535,   536,   537,   805,
     105,   540,    37,    38,     8,   138,   132,    46,   544,   953,
     546,   551,   545,   173,    46,   724,   133,   554,   555,   573,
     420,   134,   803,    37,    38,   556,   103,   558,    39,   582,
     983,   603,    41,   104,   607,   616,   974,   620,   106,   329,
     621,   408,   330,   803,   623,   625,   626,   414,   569,    39,
     627,   312,   633,    41,   634,   142,   647,   648,   998,   664,
     506,   108,   667,   507,   669,   683,   676,   677,   808,  1022,
     109,  1015,   312,  1028,   687,   112,   114,     8,   707,   712,
     116,   702,   117,   119,   120,   399,   708,  1102,   720,   726,
      37,    38,   736,    46,   855,   711,   855,   302,   397,   742,
     852,   746,   852,   805,   750,   751,   121,   165,  1011,   724,
     752,   151,   753,   756,   173,   172,    39,  1053,   757,  1055,
      41,   803,   176,   122,   758,   123,   760,  1015,   124,   761,
     125,    46,   171,   808,   135,    46,   804,   809,   828,   312,
     824,     8,   808,  1026,   829,   404,   441,   442,   173,  1082,
     137,   830,  1077,  1078,  1079,   213,   216,   453,   454,   455,
     456,   457,    71,    37,    38,   173,   212,   865,   805,   451,
     452,   453,   454,   455,   456,   457,  1096,   805,   310,    46,
     876,    46,     8,   569,   877,   189,   628,   243,   855,    39,
     878,   879,   885,    41,   852,   158,   886,   895,  1011,   896,
     569,   887,   199,   889,   808,   890,   894,   899,   897,   898,
     901,   808,  -197,   919,    46,    46,    46,   284,   215,   921,
     357,   938,   803,   808,   295,   925,   808,    37,    38,   934,
     315,   315,   951,   321,   954,   950,   960,    67,    46,   805,
     333,   973,   966,   808,   808,   808,   805,   967,   979,   192,
    -252,   811,   995,    39,   985,   986,   808,    41,   805,     8,
     671,   805,  -251,  -254,   629,   989,   243,   630,    37,    38,
     359,   976,   225,  -250,   992,   999,   312,   233,   805,   805,
     805,   367,  1000,  1008,   298,   299,  1021,  1016,  1029,  -253,
    1030,   805,  1032,    79,    80,    81,   408,   172,    83,  1044,
      84,    85,  1035,  1042,   311,   400,  1033,   406,   315,   315,
       8,   412,  1043,   415,   151,   243,   424,  1047,  1051,   343,
    1052,  1054,  1056,  1057,   343,   343,  1061,  1062,  1080,  1068,
    1073,   343,  1076,   360,   361,  1069,   343,  1093,  1084,  1094,
    1085,  1095,   172,  1098,  1110,    37,    38,   289,   373,   850,
    1106,   343,   376,  1108,  1112,   643,   678,   834,   467,   469,
     469,  1050,   343,   476,   158,   991,   689,   839,   345,   405,
     843,    39,   343,   345,   345,    41,   417,   840,   637,   484,
     345,   486,   841,     8,   931,   345,   737,   451,   452,   453,
     454,   455,   456,   457,   312,   583,    37,    38,   315,   315,
     345,   699,   175,   315,  1038,     8,   653,     8,   189,  1070,
     189,   345,   392,   957,  1012,   513,   575,   401,   345,   710,
     155,   345,    39,   406,  1081,   822,    41,  1067,   156,     0,
       0,     0,     0,   473,   157,     0,   474,   158,     0,     0,
     532,     0,   354,     0,   354,   654,     0,     0,   655,     0,
     156,     0,   156,   189,     0,     0,   159,     0,     0,   317,
     251,   252,   253,   254,   255,   256,   257,   258,   331,    37,
      38,   469,   469,   469,     0,     8,     0,   553,     0,   315,
     315,     0,   315,     0,     0,     0,     0,    67,   562,     0,
       0,    37,    38,    37,    38,    39,     0,     0,     0,   160,
     306,   308,     0,     0,     0,     0,   161,     0,     0,   162,
     832,     0,   310,     0,   163,     0,   656,    39,   164,    39,
     311,   160,     0,   160,     0,     0,     8,     0,   239,   158,
     239,   240,     0,   240,     0,   602,   163,   317,   163,   331,
     164,     0,   164,    79,    80,    81,   469,   469,    83,   769,
      84,    85,   613,     0,     0,    28,    29,    30,     0,     0,
     157,    37,    38,   354,     0,     0,   917,     0,     0,     0,
       0,   156,     0,   315,     0,     0,   315,     0,     0,     0,
       0,     0,   159,     0,   833,     0,   563,    39,     0,     0,
       0,    41,     0,   243,   564,   565,   566,   243,     0,     0,
       0,   426,     0,   429,   430,   431,   432,   433,   434,   435,
     312,     0,    37,    38,     8,     0,     0,     0,     0,   469,
     243,   315,     0,     0,   315,   701,   499,   502,     0,     0,
       8,   508,     8,     0,     0,   189,     0,     0,    39,     0,
       0,     8,   160,   480,     0,     0,   343,     0,     0,   239,
     172,   354,   240,     0,   982,     0,   343,   163,     0,   156,
       0,   164,     0,     0,     0,     0,   493,   408,     0,   496,
     739,   681,     0,   343,     0,   316,     0,     0,   354,     0,
       0,   997,     0,     0,   315,   315,   156,     0,     0,   315,
       0,     0,   640,     0,   315,   345,   645,     0,     0,   315,
      37,    38,     0,   652,   659,   662,     0,   499,   502,     0,
     508,     0,     0,     0,     0,     0,    37,    38,    37,    38,
       0,     0,   345,     0,   659,     0,    39,    37,    38,     0,
     160,   692,     0,   243,   298,   299,     0,   239,     0,     0,
     240,     0,    39,     0,    39,   163,    41,     0,    41,   164,
       0,     0,     0,    39,     0,   402,   831,   160,   403,     0,
       0,     0,   315,   163,   239,   312,     0,   240,     0,     0,
       8,     0,   163,     0,     0,     0,   164,     0,     0,     0,
     612,     0,   243,   584,   585,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   597,   598,   599,   600,
       0,   631,     0,   819,   636,     0,     0,   354,     0,     0,
    1013,     0,     0,     8,     0,   156,     0,     0,     0,   315,
     315,   610,     0,     0,   856,   315,     0,     0,     0,     0,
     619,     0,     0,    28,    29,    30,     0,     0,   857,     0,
       0,     0,     0,     0,   659,     0,     0,     0,     8,   612,
     354,   817,   631,   659,     0,     0,    37,    38,   156,     0,
       0,     0,     0,     0,   563,     0,     0,     0,     0,     0,
       0,   911,   564,   565,   566,     0,     0,     0,     0,   243,
       0,     0,    39,     0,     0,   155,   160,   243,     0,     0,
       0,   343,   343,   239,     0,     0,   240,     0,     0,    37,
      38,   163,   158,     0,     0,   164,     8,     0,     0,     0,
       0,     0,   744,   745,     0,     0,     0,   748,   727,   590,
     593,   598,   749,     0,     0,    39,     0,   755,     0,   160,
       0,     0,     0,     0,    37,    38,   239,     0,   958,   240,
     345,   345,   343,   408,   163,     0,     0,     0,   164,     0,
       0,   498,     0,     0,   315,   927,   928,   930,   315,   315,
      39,     0,     0,     8,   160,     0,     0,     0,     0,     0,
       0,   473,     0,     0,   474,     0,     8,     0,   243,     0,
       0,     0,     0,   164,   945,     0,     0,   659,   243,   915,
     744,   345,    37,    38,     0,     0,     0,     8,     0,     0,
     419,     0,     0,     0,     0,   243,     0,     0,   156,     0,
       0,     0,   817,   977,     0,     0,   243,     0,    39,     8,
    1004,   156,    41,     0,     0,     0,     0,     0,     0,   243,
       0,     8,     0,   172,   408,   315,   315,     0,     0,     0,
       0,   312,   628,     0,     0,     0,   562,   883,   884,    37,
      38,   862,     0,   888,     0,     0,   310,     0,     0,     0,
       0,     0,    37,    38,     0,   990,     0,     0,   408,     0,
     873,   874,   433,   158,   875,    39,   501,     0,     0,   160,
     880,  1048,     0,    37,    38,   243,   239,     0,    39,   240,
       0,     0,   160,     0,   163,     0,     0,     0,   164,   239,
     659,     0,   240,     0,     0,    37,    38,   163,     0,    39,
       0,   164,  1004,    41,     0,     0,     0,    37,    38,     0,
     629,     0,     0,   630,     0,     0,     0,   945,     0,     0,
       0,    39,   312,     0,     0,    41,     0,     0,     0,     0,
       0,     0,   473,    39,     0,   474,     0,    41,     0,     0,
       0,     0,     0,     0,   312,     0,     0,     0,     8,     0,
       0,   189,     0,     0,     0,     0,   312,     0,   251,   252,
     253,   254,   255,   256,   257,   258,     0,     0,     0,     0,
       0,     0,   965,     0,     0,     0,   968,   969,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   762,     0,  -568,    63,     0,
       0,     0,    64,    65,    66,     0,     0,     0,   962,   963,
       0,     0,     0,     0,     0,    67,  -568,  -568,  -568,  -568,
    -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,
    -568,  -568,  -568,  -568,    37,    38,     0,   763,    69,     0,
       0,  -568,     0,  -568,  -568,  -568,  -568,  -568,     0,     0,
     298,   299,     0,  1018,  1019,     0,    71,    72,    73,    74,
     764,    76,    77,    78,  -568,  -568,  -568,   765,   766,   767,
       0,    79,   768,    81,     0,    82,    83,   769,    84,    85,
    -568,  -568,     0,  -568,  -568,    86,     0,     0,     0,    90,
       0,    92,    93,    94,    95,    96,    97,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    98,  1027,  -568,
       0,     0,    99,  -568,  -568,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     8,     0,  1037,   189,   248,
       0,     8,   770,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,     0,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,   259,     0,     0,     0,     0,     0,   310,     0,
      27,    28,    29,    30,    31,    32,   316,   260,   441,   442,
     443,   444,     0,   445,     0,   158,     0,     0,     0,     0,
       0,     0,    33,    34,    35,     0,   446,   447,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,    36,     0,
       0,    37,    38,     8,     0,     0,     0,    37,    38,     9,
      10,    11,    12,    13,    14,    15,    16,     0,    18,     0,
      20,     0,     0,    23,    24,    25,    26,    39,     0,     0,
      40,    41,     0,    39,     0,     0,     0,    41,   261,     0,
     408,   262,     0,     0,   263,   264,   265,     0,   635,     8,
     266,   267,   189,   248,     0,     8,   312,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,     0,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,   259,     0,     0,    37,
      38,     0,   310,     0,   738,    28,    29,    30,    31,    32,
     498,   260,     0,     0,   305,     0,     0,     0,     0,   158,
       0,     0,     0,     0,     0,    39,    33,    34,    35,    41,
       0,     0,     0,     0,     0,   441,   442,   443,   444,     0,
     445,     0,    36,     0,     0,    37,    38,     8,   312,     0,
       0,    37,    38,   446,   447,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,    39,     0,     0,     0,    41,     0,    39,     0,     0,
       0,    41,   261,     0,   408,   262,     0,     0,   263,   264,
     265,     0,   754,     8,   266,   267,   189,   248,     0,     8,
     312,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,     0,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
     259,     0,     0,    37,    38,     0,   310,     0,     0,    28,
      29,    30,    31,    32,   501,   260,     0,     0,   492,     0,
       0,     0,     0,   158,     0,     0,     0,     0,     0,    39,
      33,    34,    35,    41,     0,     0,     0,     0,     0,   441,
     442,   443,   444,     0,     0,     0,    36,     0,     0,    37,
      38,     0,   312,     0,     0,    37,    38,   446,   447,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,    41,
       0,    39,     0,     0,     0,    41,   261,     0,     0,   262,
       0,     0,   263,   264,   265,     0,     0,     8,   266,   267,
     189,   248,   576,     0,   312,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,     0,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,   259,     0,     0,     0,     0,     0,
       0,     0,     0,    28,    29,    30,    31,    32,     0,   260,
       0,     0,   495,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,    34,    35,     0,   441,   442,
     443,   444,     0,   445,     0,     0,   441,   442,   443,   444,
      36,     0,     0,    37,    38,     0,   446,   577,   448,   449,
     578,   451,   452,   453,   454,   579,   456,   457,   450,   451,
     452,   453,   454,   455,   456,   457,     0,     0,     0,    39,
       0,     0,     0,    41,     0,     0,     0,     0,     0,     0,
     261,     0,     0,   262,     0,     0,   263,   264,   265,     0,
       0,     8,   266,   267,   189,   248,   955,     0,     0,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,     0,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,   259,     0,
       0,     0,     0,     0,     0,     0,     0,    28,    29,    30,
      31,    32,     0,   260,     0,     0,   618,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,    34,
      35,     0,   441,   442,   443,   444,     0,   445,     0,   441,
     442,   443,   444,     0,    36,     0,     0,    37,    38,     0,
     446,   447,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   451,   452,   453,   454,   455,   456,   457,     0,
       0,     0,     0,    39,     0,     0,     0,    41,     0,     0,
       0,     0,     0,     0,   261,     0,     0,   262,     0,     0,
     263,   264,   265,     0,     0,     8,   266,   267,   189,   248,
       0,  1060,     0,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,     0,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,   259,   728,     0,     0,     0,     0,     0,     0,
       0,    28,    29,    30,    31,    32,     0,   260,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    33,    34,    35,   441,   442,   443,   444,     0,
     445,     0,     0,     0,   441,   442,   443,   444,    36,     0,
       0,    37,    38,   446,   447,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   449,   450,   451,   452,   453,
     454,   455,   456,   457,     0,     0,     0,    39,     0,     0,
       0,    41,     0,     0,     0,     0,     0,     0,   261,     0,
       0,   262,     0,     0,   263,   264,   265,     0,     0,     8,
     266,   267,   189,   248,     0,     0,     0,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,     0,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,   259,   729,     0,     0,
       0,     0,     0,     0,     0,    28,    29,    30,    31,    32,
       0,   260,   441,   442,   443,   444,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    33,    34,    35,     0,
       0,   447,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,    36,     0,     0,    37,    38,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    39,     0,     0,     0,    41,     0,     0,     0,     0,
       0,     0,   261,     0,     0,   262,     0,     0,   263,   264,
     265,     0,     0,     8,   266,   267,   189,   248,     0,     0,
       0,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,     0,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
     259,     0,     0,     0,     0,     0,     0,     0,     0,    28,
      29,    30,    31,    32,     0,   260,   441,   442,   443,   444,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      33,    34,    35,     0,     0,     0,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,    36,     0,     0,    37,
      38,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,    41,
       0,     0,     0,     0,     0,     0,   261,     0,     0,   262,
       0,     0,   263,   264,   265,     0,     0,     8,   266,   267,
     189,   248,     0,     0,     0,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,     0,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,   259,     0,     0,     0,     0,     0,
       0,     0,     0,    28,    29,    30,    31,    32,     0,   260,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,    34,    35,     0,     0,     8,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      36,     0,     0,    37,    38,     0,     0,     0,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,   289,     0,     0,    39,
       0,     0,     0,    41,    27,    28,    29,    30,    31,    32,
       0,     0,     0,   158,     0,     0,   263,   264,   730,     0,
       0,     0,   266,   267,     0,     0,    33,    34,    35,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,     0,     0,    37,    38,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    39,     8,     0,    40,    41,     0,     0,     0,     0,
       0,     0,   290,     0,     0,   291,     0,     0,     0,     0,
     163,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,   289,
       0,     0,     0,     0,     0,     0,     0,    27,    28,    29,
      30,    31,    32,     0,     0,     0,   158,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
      34,    35,     0,     0,     8,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    36,     0,     0,    37,    38,
       0,     0,     0,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,     0,     0,     0,    39,     0,     0,    40,    41,    27,
      28,    29,    30,    31,    32,   464,     0,     0,   465,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
       0,    33,    34,    35,     8,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    36,     0,     0,
      37,    38,     0,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,     0,     0,     0,     0,     0,    39,     0,     0,    40,
      41,     0,     0,    31,    32,     0,     0,   402,     0,     0,
     403,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,    33,    34,    35,    -2,    62,     0,  -568,    63,     0,
       0,     0,    64,    65,    66,     0,     0,    36,     0,     0,
      37,    38,     0,     0,     0,    67,  -568,  -568,  -568,  -568,
    -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,
    -568,  -568,  -568,  -568,     0,     0,    39,    68,    69,     0,
      41,     0,     0,  -568,  -568,  -568,  -568,  -568,     0,     0,
      70,     0,     0,     0,     0,   163,    71,    72,    73,    74,
      75,    76,    77,    78,  -568,  -568,  -568,     0,     0,     0,
       0,    79,    80,    81,     0,    82,    83,     0,    84,    85,
    -568,  -568,     0,  -568,  -568,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    62,     0,  -568,
      63,     0,     0,     0,    64,    65,    66,    98,     0,  -568,
       0,     0,    99,  -568,     0,     0,     0,    67,  -568,  -568,
    -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,
    -568,  -568,  -568,  -568,  -568,  -568,     0,     0,     0,    68,
      69,     0,     0,   668,     0,  -568,  -568,  -568,  -568,  -568,
       0,     0,    70,     0,     0,     0,     0,     0,    71,    72,
      73,    74,    75,    76,    77,    78,  -568,  -568,  -568,     0,
       0,     0,     0,    79,    80,    81,     0,    82,    83,     0,
      84,    85,  -568,  -568,     0,  -568,  -568,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    62,
       0,  -568,    63,     0,     0,     0,    64,    65,    66,    98,
       0,  -568,     0,     0,    99,  -568,     0,     0,     0,    67,
    -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,
    -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,     0,     0,
       0,    68,    69,     0,     0,   759,     0,  -568,  -568,  -568,
    -568,  -568,     0,     0,    70,     0,     0,     0,     0,     0,
      71,    72,    73,    74,    75,    76,    77,    78,  -568,  -568,
    -568,     0,     0,     0,     0,    79,    80,    81,     0,    82,
      83,     0,    84,    85,  -568,  -568,     0,  -568,  -568,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    62,     0,  -568,    63,     0,     0,     0,    64,    65,
      66,    98,     0,  -568,     0,     0,    99,  -568,     0,     0,
       0,    67,  -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,
    -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,
       0,     0,     0,    68,    69,     0,     0,   816,     0,  -568,
    -568,  -568,  -568,  -568,     0,     0,    70,     0,     0,     0,
       0,     0,    71,    72,    73,    74,    75,    76,    77,    78,
    -568,  -568,  -568,     0,     0,     0,     0,    79,    80,    81,
       0,    82,    83,     0,    84,    85,  -568,  -568,     0,  -568,
    -568,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    62,     0,  -568,    63,     0,     0,     0,
      64,    65,    66,    98,     0,  -568,     0,     0,    99,  -568,
       0,     0,     0,    67,  -568,  -568,  -568,  -568,  -568,  -568,
    -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,
    -568,  -568,     0,     0,     0,    68,    69,     0,     0,     0,
       0,  -568,  -568,  -568,  -568,  -568,     0,     0,    70,     0,
       0,     0,   937,     0,    71,    72,    73,    74,    75,    76,
      77,    78,  -568,  -568,  -568,     0,     0,     0,     0,    79,
      80,    81,     0,    82,    83,     0,    84,    85,  -568,  -568,
       0,  -568,  -568,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,     7,     0,     8,     0,     0,
       0,     0,     0,     0,     0,    98,     0,  -568,     0,     0,
      99,  -568,     0,     0,     0,     0,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,     0,     0,     0,     0,     0,     0,
       0,     0,    27,    28,    29,    30,    31,    32,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,    34,    35,    57,     0,     8,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      36,     0,     0,    37,    38,     0,     0,     0,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,     0,     0,     0,    39,
       0,     0,    40,    41,    27,    28,    29,    30,    31,    32,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    33,    34,    35,   196,
       0,     8,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,     0,     0,    37,    38,     0,     0,     0,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,     0,     0,
       0,    39,     0,     0,    40,    41,     0,    28,    29,    30,
      31,    32,     0,     0,     0,     0,     0,     0,     0,     0,
     481,     0,     0,     0,     0,     0,     0,     0,    33,    34,
      35,     0,     8,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    36,     0,     0,    37,    38,     0,
       0,     9,    10,    11,    12,    13,    14,    15,    16,   903,
      18,   904,    20,   905,   906,    23,    24,    25,    26,   441,
     442,   443,   444,    39,   445,     0,     0,    41,    28,    29,
      30,    31,    32,     0,     0,     0,     0,   446,   447,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,    33,
      34,    35,     0,     0,     8,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    36,   244,     0,    37,    38,
       0,     0,     0,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,     0,     0,     0,    39,     0,     0,     0,    41,   907,
      28,    29,    30,    31,    32,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    33,    34,    35,     0,     0,     0,     0,     0,     8,
       0,     0,     0,     0,     0,     0,     0,    36,   936,   363,
      37,    38,     0,     0,     0,     0,     0,     0,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    39,     0,     0,     0,
      41,   907,     0,     0,    27,    28,    29,    30,    31,    32,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    33,    34,    35,     0,
       0,     8,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,     0,     0,    37,    38,     0,     0,     0,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,     0,     0,
       0,    39,     0,     0,    40,    41,    27,    28,    29,    30,
      31,    32,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,    34,
      35,     0,     8,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    36,     0,     0,    37,    38,     0,
       0,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,   226,
       0,     0,     0,    39,     0,     0,    40,    41,    28,    29,
      30,    31,    32,     0,     0,     0,     0,     0,     0,     0,
       0,   622,     0,     0,     0,     0,     0,     0,     0,    33,
      34,    35,     0,     8,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    36,     0,     0,    37,    38,
       0,     0,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
     441,   442,   443,   444,    39,   445,     0,     0,    41,    28,
      29,    30,    31,    32,     0,     0,     0,     0,   446,   447,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
      33,    34,    35,     0,     8,     0,     0,     0,   624,     0,
       0,     0,     0,     0,     0,     0,    36,   244,     0,    37,
      38,     0,     0,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,     0,     0,     0,     0,    39,     0,     0,     0,    41,
      28,    29,    30,    31,    32,     0,     0,   441,   442,   443,
     444,     0,   445,     0,     0,     0,     0,     0,     0,     0,
       0,    33,    34,    35,     8,   446,   447,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,    36,     0,     0,
      37,    38,     0,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,     0,     0,     0,     0,     0,    39,     0,     0,     0,
      41,     0,     0,    31,    32,     0,     0,     0,     0,     0,
       0,     0,     0,   741,     0,     0,     0,     0,     0,     0,
       0,    33,    34,    35,     8,   747,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    36,     0,     0,
      37,    38,     0,     9,    10,    11,    12,    13,    14,    15,
      16,   694,    18,   695,    20,   696,   697,    23,    24,    25,
      26,     0,   441,   442,   443,   444,    39,   445,     0,     0,
      41,     0,     0,     0,   441,   442,   443,   444,     0,   445,
     446,   447,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   446,   447,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,     0,     0,     0,    36,     0,     0,
      37,    38,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    39,     0,     0,     0,
      41
};

static const yytype_int16 yycheck[] =
{
       0,   581,    21,   157,   235,     5,    60,    71,    93,     1,
       2,     5,   149,   544,     1,     2,     5,     5,   356,   138,
     370,    21,   525,    40,   725,   140,   698,     5,   663,    93,
      94,   556,     5,    44,   516,   103,   848,     5,   220,    46,
      41,   178,   179,   525,     5,   420,    46,   378,   155,     5,
      46,    99,     6,     6,    54,    54,   238,    42,     6,     4,
      41,     6,   286,     3,    46,    40,    43,    41,    60,    46,
      70,   188,     5,    43,   138,    75,    76,   194,    54,   118,
      45,     5,    47,   200,    54,    42,     5,     5,   205,     6,
     138,     5,   793,     5,     5,     5,   944,   658,   946,    76,
       3,    46,   150,    40,   103,   666,    46,   290,   291,     3,
     110,   294,   129,   337,   231,   111,    54,     5,     0,   104,
      57,   228,     6,     3,   241,   126,   103,   103,   129,    46,
     691,    85,    85,   664,     5,   116,     5,    85,     3,     5,
     140,     5,   116,   191,   956,     5,   707,   104,   140,    89,
      90,   126,   206,   140,   129,   209,   161,   162,   197,   134,
     167,     5,   169,   155,   514,   118,   171,   167,    85,   169,
      54,   872,   226,   155,  1034,   115,     3,    40,   116,   119,
     234,   163,   289,   533,    43,   185,    89,    90,   153,   228,
    1038,   863,   893,    44,   569,    89,    90,     1,   163,   199,
       6,     3,   356,   310,   535,   244,     6,   246,    43,    89,
      90,    76,   115,    42,   206,   215,   119,   209,    47,   402,
     403,   404,  1082,     3,    89,    90,    77,  1039,   228,    40,
     230,   231,    52,    53,   226,   235,    40,  1049,    40,   119,
      46,    76,   234,   235,   103,   245,   228,   247,   235,    75,
     115,    71,    72,   814,   119,    57,   238,  1064,     3,    59,
      40,     4,    89,    90,     3,     6,   273,     3,    48,   323,
     971,   271,   326,   273,     4,     3,   807,   802,    89,    90,
      48,   916,    46,   103,   110,   290,   291,    89,    90,   294,
    1097,   273,   119,    42,   477,   478,   117,   289,     4,   384,
       6,    40,    43,    46,    40,    54,   809,   289,    54,    89,
      90,    48,    48,   115,   378,   546,    46,   119,   310,   140,
     384,    57,   437,   698,   329,   330,   998,   809,   310,    48,
      76,   323,   707,   515,   326,   115,   138,    52,   320,   119,
     690,   105,   106,  1015,    89,    90,   126,   339,   355,   129,
      89,    90,   339,    89,    90,   355,    71,   918,   138,   140,
     542,    89,    90,   427,    43,   419,     3,   550,   103,   117,
     370,  1072,   354,     4,   119,     6,   115,    40,    41,   115,
     119,    52,    53,   119,   964,    43,    40,   115,    46,   920,
     126,   119,   140,   129,    57,  1076,   396,     3,   134,   138,
      71,    72,   138,    57,    40,   405,   134,     4,   525,     6,
       3,    40,  1093,  1094,  1095,   463,   416,   417,    76,    48,
     420,    57,   983,    40,   424,  1106,   408,   419,   482,    46,
     805,   992,   103,   487,    40,    43,    42,   419,    46,    49,
      50,    51,    48,    43,   426,   437,    43,    43,    54,    46,
     437,    57,    89,    90,   120,   420,    40,    54,    40,   464,
     465,   466,    40,     4,    46,     6,    84,    85,   473,   474,
      76,   535,    40,   103,     3,    40,    41,     6,   483,    57,
       3,    40,   119,    89,    90,   524,   116,   117,   863,   528,
     482,    43,    57,  1054,    46,   487,    89,    90,   104,   504,
    1061,    48,    43,    40,    43,    46,    43,    46,    40,   115,
     140,   511,   551,   119,   514,    54,    40,    40,    43,   857,
     126,    46,   115,   129,   134,    48,   119,    40,   134,    40,
      41,   531,   138,   533,   534,   527,    40,   531,     6,   539,
     527,    43,   531,   531,    46,   534,    57,   558,    40,    41,
      40,   543,    54,   531,   546,    40,   543,    40,   531,   546,
      89,    90,   569,   531,   571,    57,    89,    90,    40,   569,
     531,   571,   572,   114,   581,   531,   105,   106,   760,   761,
      40,   581,    48,   583,    48,    52,    53,    49,    50,    51,
      42,    43,   115,    48,    46,     3,   119,   579,   531,   581,
     105,   106,   607,   126,    71,    72,   129,   531,   672,   116,
      54,   134,   531,   531,   579,   138,    41,   531,    80,   531,
     531,   531,   676,   998,    42,   664,    88,    89,    90,    49,
      50,    51,    76,   770,    40,    41,    80,    46,    40,    41,
    1015,   641,    43,   531,    88,    89,    90,   641,     6,   649,
      46,    57,   641,   641,   708,    57,    43,     3,   658,    46,
     531,   927,   531,   641,   930,   531,   666,   531,   641,    40,
     670,   531,    43,   641,   713,    46,   670,   696,    41,    42,
     641,   670,   670,   802,   676,   641,  1061,   531,   688,   689,
     690,   691,   670,   658,   811,    43,   696,   670,   698,   688,
     688,   666,   670,   857,   935,    42,   706,   707,   641,   670,
     688,   718,   706,   828,   670,   688,   708,   641,   718,   116,
     731,   104,   641,   641,    42,   725,   691,   641,    40,   641,
     641,   641,   739,   698,    41,    42,   821,   670,   802,   739,
      41,    42,   707,    89,    90,     7,   670,    41,   730,   731,
     804,   670,   670,   641,   802,    48,   670,   821,   670,   670,
     670,   898,    48,  1101,   104,   730,     3,    41,    41,   115,
     641,   810,   641,   119,   116,   641,    57,   641,   842,   818,
     126,   641,   670,   129,    48,   833,    40,     3,   134,   121,
     122,   123,    48,   793,   842,   849,   950,   641,    48,   670,
     134,   670,   856,    40,   670,    48,   670,   116,    80,    43,
     670,    48,   804,    41,   814,   879,    88,    89,    90,   819,
      57,   134,   135,   136,    40,    46,   670,    41,   828,    73,
      74,    75,    48,    41,    41,    54,   828,    42,    41,    41,
     116,   828,    43,   907,   844,    41,    41,    41,    41,   814,
     844,    41,    89,    90,     3,   844,   844,   849,    41,   859,
      42,    41,   104,   863,   856,   865,   844,    43,   116,    46,
     909,   844,   872,    89,    90,   111,   844,    76,   115,    48,
     919,   116,   119,   844,   116,    48,   905,    48,   844,   126,
      41,    40,   129,   893,    41,    48,    48,   936,   863,   115,
      48,   138,    48,   119,    48,   905,    43,    43,   947,    41,
     126,   844,    46,   129,    43,    43,    40,    47,   918,   973,
     844,   960,   138,   977,    91,   844,   844,     3,    41,    89,
     844,    57,   844,   844,   844,   935,    40,  1091,    78,    46,
      89,    90,    48,   935,   944,    90,   946,  1101,   935,    41,
     944,    41,   946,   918,    48,    48,   844,   964,   958,   959,
      48,    42,    48,    48,   964,    46,   115,  1021,    48,  1023,
     119,   971,    53,   844,    48,   844,    42,  1016,   844,    42,
     844,   973,   964,   983,   844,   977,    40,    54,   103,   138,
     140,     3,   992,   975,    41,   977,   107,   108,   998,  1063,
     844,    47,  1056,  1057,  1058,    86,    87,   132,   133,   134,
     135,   136,    62,    89,    90,  1015,    92,    42,   983,   130,
     131,   132,   133,   134,   135,   136,  1080,   992,    40,  1021,
      41,  1023,     3,   998,    41,     6,    48,   118,  1038,   115,
      41,    40,    48,   119,  1038,    57,    48,    76,  1048,    76,
    1015,    48,    71,    48,  1054,    48,    46,    40,    76,   138,
      47,  1061,    47,    41,  1056,  1057,  1058,   148,    87,    43,
      41,    43,  1072,  1073,   155,    41,  1076,    89,    90,    54,
     161,   162,    76,   164,    41,    54,    47,    21,  1080,  1054,
     171,    40,    48,  1093,  1094,  1095,  1061,    48,    41,    69,
      76,    42,    54,   115,    43,    43,  1106,   119,  1073,     3,
      44,  1076,    76,    76,   126,   104,   197,   129,    89,    90,
     201,    76,    92,    76,    41,    41,   138,    97,  1093,  1094,
    1095,   212,    43,    48,   105,   106,    40,    47,    43,    76,
      43,  1106,    43,    77,    78,    79,    40,   228,    82,    48,
      84,    85,    43,    43,    48,   236,   104,   238,   239,   240,
       3,   242,    42,   244,   245,   246,   247,    48,    41,   188,
      47,    41,    40,    40,   193,   194,    41,    43,    40,    48,
      41,   200,    41,   202,   203,    48,   205,    41,    48,    41,
      48,    41,   273,    48,    43,    89,    90,    40,   217,    46,
      41,   220,   221,    48,    43,   516,   539,   688,   289,   290,
     291,  1016,   231,   294,    57,   935,   546,   688,   188,   238,
     689,   115,   241,   193,   194,   119,   245,   688,   511,   310,
     200,   312,   688,     3,   828,   205,   583,   130,   131,   132,
     133,   134,   135,   136,   138,   437,    89,    90,   329,   330,
     220,   556,    51,   334,   996,     3,     4,     3,     6,  1048,
       6,   231,   232,   865,   959,   346,   424,   237,   238,   564,
      40,   241,   115,   354,  1061,   673,   119,  1043,    48,    -1,
      -1,    -1,    -1,   126,    54,    -1,   129,    57,    -1,    -1,
     371,    -1,    40,    -1,    40,    43,    -1,    -1,    46,    -1,
      48,    -1,    48,     6,    -1,    -1,    76,    -1,    -1,   162,
      13,    14,    15,    16,    17,    18,    19,    20,   171,    89,
      90,   402,   403,   404,    -1,     3,    -1,   408,    -1,   410,
     411,    -1,   413,    -1,    -1,    -1,    -1,    21,   419,    -1,
      -1,    89,    90,    89,    90,   115,    -1,    -1,    -1,   119,
     158,   159,    -1,    -1,    -1,    -1,   126,    -1,    -1,   129,
      44,    -1,    40,    -1,   134,    -1,   114,   115,   138,   115,
      48,   119,    -1,   119,    -1,    -1,     3,    -1,   126,    57,
     126,   129,    -1,   129,    -1,   466,   134,   240,   134,   242,
     138,    -1,   138,    77,    78,    79,   477,   478,    82,    83,
      84,    85,   483,    -1,    -1,    49,    50,    51,    -1,    -1,
      54,    89,    90,    40,    -1,    -1,    43,    -1,    -1,    -1,
      -1,    48,    -1,   504,    -1,    -1,   507,    -1,    -1,    -1,
      -1,    -1,    76,    -1,   118,    -1,    80,   115,    -1,    -1,
      -1,   119,    -1,   524,    88,    89,    90,   528,    -1,    -1,
      -1,   259,    -1,   261,   262,   263,   264,   265,   266,   267,
     138,    -1,    89,    90,     3,    -1,    -1,    -1,    -1,   550,
     551,   552,    -1,    -1,   555,   556,   329,   330,    -1,    -1,
       3,   334,     3,    -1,    -1,     6,    -1,    -1,   115,    -1,
      -1,     3,   119,   301,    -1,    -1,   515,    -1,    -1,   126,
     581,    40,   129,    -1,    43,    -1,   525,   134,    -1,    48,
      -1,   138,    -1,    -1,    -1,    -1,   324,    40,    -1,   327,
     601,   540,    -1,   542,    -1,    48,    -1,    -1,    40,    -1,
      -1,    43,    -1,    -1,   615,   616,    48,    -1,    -1,   620,
      -1,    -1,   512,    -1,   625,   515,   516,    -1,    -1,   630,
      89,    90,    -1,   523,   524,   525,    -1,   410,   411,    -1,
     413,    -1,    -1,    -1,    -1,    -1,    89,    90,    89,    90,
      -1,    -1,   542,    -1,   544,    -1,   115,    89,    90,    -1,
     119,   551,    -1,   664,   105,   106,    -1,   126,    -1,    -1,
     129,    -1,   115,    -1,   115,   134,   119,    -1,   119,   138,
      -1,    -1,    -1,   115,    -1,   126,   687,   119,   129,    -1,
      -1,    -1,   693,   134,   126,   138,    -1,   129,    -1,    -1,
       3,    -1,   134,    -1,    -1,    -1,   138,    -1,    -1,    -1,
     483,    -1,   713,   441,   442,   443,   444,   445,   446,   447,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
      -1,   504,    -1,   672,   507,    -1,    -1,    40,    -1,    -1,
      43,    -1,    -1,     3,    -1,    48,    -1,    -1,    -1,   750,
     751,   479,    -1,    -1,    40,   756,    -1,    -1,    -1,    -1,
     488,    -1,    -1,    49,    50,    51,    -1,    -1,    54,    -1,
      -1,    -1,    -1,    -1,   664,    -1,    -1,    -1,     3,   552,
      40,   671,   555,   673,    -1,    -1,    89,    90,    48,    -1,
      -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,    -1,    -1,
      -1,   802,    88,    89,    90,    -1,    -1,    -1,    -1,   810,
      -1,    -1,   115,    -1,    -1,    40,   119,   818,    -1,    -1,
      -1,   760,   761,   126,    -1,    -1,   129,    -1,    -1,    89,
      90,   134,    57,    -1,    -1,   138,     3,    -1,    -1,    -1,
      -1,    -1,   615,   616,    -1,    -1,    -1,   620,   576,   577,
     578,   579,   625,    -1,    -1,   115,    -1,   630,    -1,   119,
      -1,    -1,    -1,    -1,    89,    90,   126,    -1,   869,   129,
     760,   761,   811,    40,   134,    -1,    -1,    -1,   138,    -1,
      -1,    48,    -1,    -1,   885,   824,   825,   826,   889,   890,
     115,    -1,    -1,     3,   119,    -1,    -1,    -1,    -1,    -1,
      -1,   126,    -1,    -1,   129,    -1,     3,    -1,   909,    -1,
      -1,    -1,    -1,   138,   853,    -1,    -1,   807,   919,   809,
     693,   811,    89,    90,    -1,    -1,    -1,     3,    -1,    -1,
      40,    -1,    -1,    -1,    -1,   936,    -1,    -1,    48,    -1,
      -1,    -1,   832,    40,    -1,    -1,   947,    -1,   115,     3,
     951,    48,   119,    -1,    -1,    -1,    -1,    -1,    -1,   960,
      -1,     3,    -1,   964,    40,   966,   967,    -1,    -1,    -1,
      -1,   138,    48,    -1,    -1,    -1,   977,   750,   751,    89,
      90,   709,    -1,   756,    -1,    -1,    40,    -1,    -1,    -1,
      -1,    -1,    89,    90,    -1,   934,    -1,    -1,    40,    -1,
     728,   729,   730,    57,   732,   115,    48,    -1,    -1,   119,
     738,  1012,    -1,    89,    90,  1016,   126,    -1,   115,   129,
      -1,    -1,   119,    -1,   134,    -1,    -1,    -1,   138,   126,
     920,    -1,   129,    -1,    -1,    89,    90,   134,    -1,   115,
      -1,   138,  1043,   119,    -1,    -1,    -1,    89,    90,    -1,
     126,    -1,    -1,   129,    -1,    -1,    -1,   996,    -1,    -1,
      -1,   115,   138,    -1,    -1,   119,    -1,    -1,    -1,    -1,
      -1,    -1,   126,   115,    -1,   129,    -1,   119,    -1,    -1,
      -1,    -1,    -1,    -1,   138,    -1,    -1,    -1,     3,    -1,
      -1,     6,    -1,    -1,    -1,    -1,   138,    -1,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    -1,    -1,    -1,
      -1,    -1,   885,    -1,    -1,    -1,   889,   890,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     1,    -1,     3,     4,    -1,
      -1,    -1,     8,     9,    10,    -1,    -1,    -1,   876,   877,
      -1,    -1,    -1,    -1,    -1,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    89,    90,    -1,    43,    44,    -1,
      -1,    47,    -1,    49,    50,    51,    52,    53,    -1,    -1,
     105,   106,    -1,   966,   967,    -1,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    77,    78,    79,    -1,    81,    82,    83,    84,    85,
      86,    87,    -1,    89,    90,    91,    -1,    -1,    -1,    95,
      -1,    97,    98,    99,   100,   101,   102,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   113,   976,   115,
      -1,    -1,   118,   119,   120,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,    -1,   995,     6,     7,
      -1,     3,   138,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    -1,    -1,    -1,    -1,    -1,    40,    -1,
      48,    49,    50,    51,    52,    53,    48,    55,   107,   108,
     109,   110,    -1,   112,    -1,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    71,    72,    -1,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,    86,    -1,
      -1,    89,    90,     3,    -1,    -1,    -1,    89,    90,    22,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,   115,    -1,    -1,
     118,   119,    -1,   115,    -1,    -1,    -1,   119,   126,    -1,
      40,   129,    -1,    -1,   132,   133,   134,    -1,    48,     3,
     138,   139,     6,     7,    -1,     3,   138,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    -1,    -1,    89,
      90,    -1,    40,    -1,    76,    49,    50,    51,    52,    53,
      48,    55,    -1,    -1,    58,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,   115,    70,    71,    72,   119,
      -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,
     112,    -1,    86,    -1,    -1,    89,    90,     3,   138,    -1,
      -1,    89,    90,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,    -1,    -1,    -1,    -1,    -1,
      -1,   115,    -1,    -1,    -1,   119,    -1,   115,    -1,    -1,
      -1,   119,   126,    -1,    40,   129,    -1,    -1,   132,   133,
     134,    -1,    48,     3,   138,   139,     6,     7,    -1,     3,
     138,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    -1,    -1,    89,    90,    -1,    40,    -1,    -1,    49,
      50,    51,    52,    53,    48,    55,    -1,    -1,    58,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,   115,
      70,    71,    72,   119,    -1,    -1,    -1,    -1,    -1,   107,
     108,   109,   110,    -1,    -1,    -1,    86,    -1,    -1,    89,
      90,    -1,   138,    -1,    -1,    89,    90,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,    -1,
      -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,   119,
      -1,   115,    -1,    -1,    -1,   119,   126,    -1,    -1,   129,
      -1,    -1,   132,   133,   134,    -1,    -1,     3,   138,   139,
       6,     7,    41,    -1,   138,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    49,    50,    51,    52,    53,    -1,    55,
      -1,    -1,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    -1,   107,   108,
     109,   110,    -1,   112,    -1,    -1,   107,   108,   109,   110,
      86,    -1,    -1,    89,    90,    -1,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   129,   130,
     131,   132,   133,   134,   135,   136,    -1,    -1,    -1,   115,
      -1,    -1,    -1,   119,    -1,    -1,    -1,    -1,    -1,    -1,
     126,    -1,    -1,   129,    -1,    -1,   132,   133,   134,    -1,
      -1,     3,   138,   139,     6,     7,    41,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    49,    50,    51,
      52,    53,    -1,    55,    -1,    -1,    58,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,
      72,    -1,   107,   108,   109,   110,    -1,   112,    -1,   107,
     108,   109,   110,    -1,    86,    -1,    -1,    89,    90,    -1,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   130,   131,   132,   133,   134,   135,   136,    -1,
      -1,    -1,    -1,   115,    -1,    -1,    -1,   119,    -1,    -1,
      -1,    -1,    -1,    -1,   126,    -1,    -1,   129,    -1,    -1,
     132,   133,   134,    -1,    -1,     3,   138,   139,     6,     7,
      -1,    43,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    49,    50,    51,    52,    53,    -1,    55,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    71,    72,   107,   108,   109,   110,    -1,
     112,    -1,    -1,    -1,   107,   108,   109,   110,    86,    -1,
      -1,    89,    90,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   128,   129,   130,   131,   132,
     133,   134,   135,   136,    -1,    -1,    -1,   115,    -1,    -1,
      -1,   119,    -1,    -1,    -1,    -1,    -1,    -1,   126,    -1,
      -1,   129,    -1,    -1,   132,   133,   134,    -1,    -1,     3,
     138,   139,     6,     7,    -1,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    49,    50,    51,    52,    53,
      -1,    55,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,    -1,
      -1,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,    86,    -1,    -1,    89,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   115,    -1,    -1,    -1,   119,    -1,    -1,    -1,    -1,
      -1,    -1,   126,    -1,    -1,   129,    -1,    -1,   132,   133,
     134,    -1,    -1,     3,   138,   139,     6,     7,    -1,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    49,
      50,    51,    52,    53,    -1,    55,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    71,    72,    -1,    -1,    -1,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,    86,    -1,    -1,    89,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,   119,
      -1,    -1,    -1,    -1,    -1,    -1,   126,    -1,    -1,   129,
      -1,    -1,   132,   133,   134,    -1,    -1,     3,   138,   139,
       6,     7,    -1,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    49,    50,    51,    52,    53,    -1,    55,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    -1,    -1,     3,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    90,    -1,    -1,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    -1,    -1,   115,
      -1,    -1,    -1,   119,    48,    49,    50,    51,    52,    53,
      -1,    -1,    -1,    57,    -1,    -1,   132,   133,   134,    -1,
      -1,    -1,   138,   139,    -1,    -1,    70,    71,    72,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   115,     3,    -1,   118,   119,    -1,    -1,    -1,    -1,
      -1,    -1,   126,    -1,    -1,   129,    -1,    -1,    -1,    -1,
     134,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,    50,
      51,    52,    53,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      71,    72,    -1,    -1,     3,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    90,
      -1,    -1,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    -1,    -1,    -1,   115,    -1,    -1,   118,   119,    48,
      49,    50,    51,    52,    53,   126,    -1,    -1,   129,    -1,
      -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,     3,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    90,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,   118,
     119,    -1,    -1,    52,    53,    -1,    -1,   126,    -1,    -1,
     129,    -1,    -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,     0,     1,    -1,     3,     4,    -1,
      -1,    -1,     8,     9,    10,    -1,    -1,    86,    -1,    -1,
      89,    90,    -1,    -1,    -1,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    -1,    -1,   115,    43,    44,    -1,
     119,    -1,    -1,    49,    50,    51,    52,    53,    -1,    -1,
      56,    -1,    -1,    -1,    -1,   134,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    -1,    -1,    -1,
      -1,    77,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    -1,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,     1,    -1,     3,
       4,    -1,    -1,    -1,     8,     9,    10,   113,    -1,   115,
      -1,    -1,   118,   119,    -1,    -1,    -1,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    -1,    -1,    47,    -1,    49,    50,    51,    52,    53,
      -1,    -1,    56,    -1,    -1,    -1,    -1,    -1,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    -1,
      -1,    -1,    -1,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    -1,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,     1,
      -1,     3,     4,    -1,    -1,    -1,     8,     9,    10,   113,
      -1,   115,    -1,    -1,   118,   119,    -1,    -1,    -1,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    -1,    -1,    47,    -1,    49,    50,    51,
      52,    53,    -1,    -1,    56,    -1,    -1,    -1,    -1,    -1,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    -1,    -1,    -1,    -1,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    -1,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,     1,    -1,     3,     4,    -1,    -1,    -1,     8,     9,
      10,   113,    -1,   115,    -1,    -1,   118,   119,    -1,    -1,
      -1,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    -1,    -1,    47,    -1,    49,
      50,    51,    52,    53,    -1,    -1,    56,    -1,    -1,    -1,
      -1,    -1,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    -1,    -1,    -1,    -1,    77,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    -1,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,     1,    -1,     3,     4,    -1,    -1,    -1,
       8,     9,    10,   113,    -1,   115,    -1,    -1,   118,   119,
      -1,    -1,    -1,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    -1,    -1,    -1,
      -1,    49,    50,    51,    52,    53,    -1,    -1,    56,    -1,
      -1,    -1,    60,    -1,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    -1,    -1,    -1,    -1,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      -1,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,     1,    -1,     3,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,    -1,
     118,   119,    -1,    -1,    -1,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    49,    50,    51,    52,    53,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,     1,    -1,     3,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    90,    -1,    -1,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    -1,    -1,    -1,   115,
      -1,    -1,   118,   119,    48,    49,    50,    51,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,     1,
      -1,     3,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    90,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    -1,    -1,
      -1,   115,    -1,    -1,   118,   119,    -1,    49,    50,    51,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,
      72,    -1,     3,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    90,    -1,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,   107,
     108,   109,   110,   115,   112,    -1,    -1,   119,    49,    50,
      51,    52,    53,    -1,    -1,    -1,    -1,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,    70,
      71,    72,    -1,    -1,     3,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    87,    -1,    89,    90,
      -1,    -1,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    -1,    -1,    -1,   115,    -1,    -1,    -1,   119,   120,
      49,    50,    51,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,    -1,    -1,    -1,    -1,    -1,     3,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    87,    13,
      89,    90,    -1,    -1,    -1,    -1,    -1,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,   115,    -1,    -1,    -1,
     119,   120,    -1,    -1,    48,    49,    50,    51,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,    -1,
      -1,     3,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    90,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    -1,    -1,
      -1,   115,    -1,    -1,   118,   119,    48,    49,    50,    51,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,
      72,    -1,     3,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    90,    -1,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      -1,    -1,    -1,   115,    -1,    -1,   118,   119,    49,    50,
      51,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      71,    72,    -1,     3,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    90,
      -1,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
     107,   108,   109,   110,   115,   112,    -1,    -1,   119,    49,
      50,    51,    52,    53,    -1,    -1,    -1,    -1,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
      70,    71,    72,    -1,     3,    -1,    -1,    -1,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    87,    -1,    89,
      90,    -1,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,   119,
      49,    50,    51,    52,    53,    -1,    -1,   107,   108,   109,
     110,    -1,   112,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,     3,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,    86,    -1,    -1,
      89,    90,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,
     119,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,     3,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    90,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    -1,   107,   108,   109,   110,   115,   112,    -1,    -1,
     119,    -1,    -1,    -1,   107,   108,   109,   110,    -1,   112,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,    -1,    -1,    -1,    86,    -1,    -1,
      89,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,
     119
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,   121,   122,   123,   142,   143,   307,     1,     3,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    48,    49,    50,
      51,    52,    53,    70,    71,    72,    86,    89,    90,   115,
     118,   119,   193,   235,   249,   250,   252,   253,   254,   255,
     256,   257,   282,   283,   293,   296,   298,     1,   235,     1,
      40,     0,     1,     4,     8,     9,    10,    21,    43,    44,
      56,    62,    63,    64,    65,    66,    67,    68,    69,    77,
      78,    79,    81,    82,    84,    85,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   113,   118,
     144,   145,   146,   148,   149,   150,   151,   152,   155,   156,
     158,   159,   160,   161,   162,   163,   164,   167,   168,   169,
     172,   174,   179,   180,   181,   182,   184,   188,   195,   196,
     197,   198,   199,   203,   204,   211,   212,   223,   231,   307,
     103,   292,   307,    48,    52,    71,    48,    48,    40,   140,
     103,   296,    43,   253,   249,    40,    48,    54,    57,    76,
     119,   126,   129,   134,   138,   240,   241,   243,   245,   246,
     247,   248,   296,   307,   249,   256,   296,   292,   117,   140,
     297,    43,    43,   232,   233,   235,   307,   120,    40,     6,
      85,   118,   301,    40,   304,   307,     1,   251,   252,   293,
      40,   304,    40,   166,   307,    40,    40,    84,    85,    40,
      44,    77,    92,   296,    46,   293,   296,    40,     4,    46,
      40,    40,    43,    46,     4,   301,    40,   178,   251,   176,
     178,    40,    40,   301,    40,   103,   283,   304,    40,   126,
     129,   243,   248,   296,    87,   193,   251,   283,     7,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    40,
      55,   126,   129,   132,   133,   134,   138,   139,   235,   236,
     237,   239,   251,   252,   268,   269,   270,   271,   301,   302,
     307,    48,    48,    48,   296,   119,   298,   283,   249,    40,
     126,   129,   232,   246,   248,   296,    48,    46,   105,   106,
     258,   259,   260,   261,   262,    58,   268,   269,   268,     3,
      40,    48,   138,   244,   247,   296,    48,   244,   247,   248,
     249,   296,   240,    40,    57,   240,    40,    57,    48,   126,
     129,   244,   247,   296,   116,   298,   119,   298,    41,    42,
     234,   307,   260,   293,   294,   301,   283,     6,    46,    85,
     294,   305,   294,    43,    40,   243,    54,    41,   294,   296,
     293,   293,   294,    13,   173,   232,   232,   296,    43,    54,
     214,    54,    46,   293,   175,   305,   293,   232,    46,   242,
     243,   246,   307,    43,    42,   177,   307,   294,   295,   307,
     153,   154,   301,   232,   207,   208,   209,   235,   282,   307,
     296,   301,   126,   129,   248,   293,   296,   305,    40,   294,
     126,   129,   296,   116,   243,   296,   263,   293,   307,    40,
     243,    76,   274,   275,   296,   307,   268,    40,    48,   268,
     268,   268,   268,   268,   268,   268,   104,    42,   238,   307,
      40,   107,   108,   109,   110,   112,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,     7,    48,
      48,    41,   297,   104,   126,   129,   248,   296,   245,   296,
     245,    41,    41,   126,   129,   245,   296,   116,    48,    57,
     268,    58,    40,   248,   296,    48,   296,    40,    57,    48,
     248,   232,    58,   268,   232,    58,   268,    48,    48,   244,
     247,    48,   244,   247,   116,    48,   126,   129,   244,   297,
      43,   235,    41,   296,   183,    42,    54,    41,   240,   258,
      41,    46,    41,    54,    41,    42,   171,    42,    41,    41,
      43,   143,   296,   213,    41,    41,    41,    41,   176,   178,
      41,    41,    42,    46,    41,   104,    42,   210,   307,    59,
     116,    41,   248,   296,    43,   116,   111,    54,    76,   194,
     307,   232,   296,    80,    88,    89,    90,   186,   240,   249,
     285,   286,   276,    46,    43,   274,    41,   126,   129,   134,
     248,   251,    48,   239,   268,   268,   268,   268,   268,   268,
     268,   268,   268,   268,   268,   268,   268,   268,   268,   268,
     268,   283,   296,   116,    41,    41,    41,   116,   245,   245,
     268,   232,   244,   296,    41,   116,    48,   232,    58,   268,
      48,    41,    58,    41,    58,    48,    48,    48,    48,   126,
     129,   244,   247,    48,    48,    48,   244,   234,     4,    46,
     301,   143,   305,   153,   270,   301,   306,    43,    43,   147,
       4,   165,   301,     4,    43,    46,   114,   170,   243,   301,
     303,   294,   301,   306,    41,   235,   243,    46,    47,    43,
     143,    44,   231,   176,    43,    46,    40,    47,   177,   115,
     119,   293,   299,    43,   305,   235,   170,    91,   205,   209,
     157,   243,   301,   116,    30,    32,    34,    35,   187,   254,
     255,   296,    57,   189,   253,    43,    46,    41,    40,    40,
     285,    90,    89,    42,    43,    46,   185,   240,   286,   240,
      78,   277,   278,   284,   307,   201,    46,   268,    41,    41,
     134,   249,    41,   126,   129,   241,    48,   238,    76,   296,
      41,    58,    41,    41,   244,   244,    41,    58,   244,   244,
      48,    48,    48,    48,    48,   244,    48,    48,    48,    47,
      42,    42,     1,    43,    66,    73,    74,    75,    78,    83,
     138,   148,   149,   150,   151,   155,   156,   160,   162,   164,
     167,   169,   172,   174,   179,   180,   181,   182,   199,   203,
     204,   211,   215,   219,   220,   221,   222,   223,   224,   225,
     226,   229,   231,   307,    40,   249,   286,   287,   307,    54,
      41,    42,   171,   170,   243,   287,    47,   301,   251,   293,
      43,    54,   303,   232,   140,   117,   140,   300,   103,    41,
      47,   296,    44,   118,   184,   199,   203,   204,   206,   220,
     222,   224,   231,   210,   143,   287,    43,   292,   186,    40,
      46,   190,   150,   264,   265,   307,    40,    54,   286,   287,
     288,   232,   268,   243,   240,    42,    73,    74,    75,   279,
     281,   215,   200,   268,   268,   268,    41,    41,    41,    40,
     268,   240,    41,   244,   244,    48,    48,    48,   244,    48,
      48,   305,   305,   218,    46,    76,    76,    76,   138,    40,
     298,    47,   215,    30,    32,    34,    35,   120,   230,   251,
     255,   296,   232,   286,   170,   301,   306,    43,   243,    41,
     287,    43,   243,    43,   178,    41,   119,   293,   293,   119,
     293,   236,     4,    46,    54,   103,    87,    60,    43,   185,
     232,    40,    43,   191,   266,   293,    42,    47,   232,   258,
      54,    76,   289,   307,    41,    41,   186,   278,   296,   280,
      47,   215,   268,   268,   251,   244,    48,    48,   244,   244,
     215,   216,   298,    40,   292,   251,    76,    40,    43,    41,
     171,   287,    43,   243,   170,    43,    43,   300,   300,   104,
     293,   207,    41,   192,   264,    54,   264,    43,   243,    41,
      43,   260,   290,   291,   296,    43,    46,   185,    48,   272,
     273,   307,   284,    43,   202,   243,    47,   241,   244,   244,
     215,    40,   232,    40,   126,   129,   248,   268,   232,    43,
      43,   287,    43,   104,   287,    43,   267,   268,   266,   186,
      43,    46,    43,    42,    48,    40,    46,    48,   296,   186,
     202,    41,    47,   232,    41,   232,    40,    40,    40,   129,
      43,    41,    43,   111,   190,   264,   185,   291,    48,    48,
     273,   185,   217,    41,   227,   287,    41,   232,   232,   232,
      40,   288,   251,   191,    48,    48,   215,   228,   287,    43,
      46,    54,   228,    41,    41,    41,   232,   190,    48,    43,
      46,    54,   260,   228,   228,   228,    41,   191,    48,   258,
      43,   228,    43
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   141,   142,   142,   142,   142,   142,   142,   142,   143,
     143,   144,   144,   144,   144,   144,   144,   144,   145,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   147,
     146,   148,   149,   150,   150,   150,   151,   151,   152,   152,
     152,   152,   153,   154,   154,   155,   155,   155,   157,   156,
     158,   158,   159,   159,   160,   160,   160,   160,   161,   162,
     162,   163,   163,   164,   164,   165,   165,   166,   166,   167,
     167,   167,   168,   168,   169,   169,   169,   169,   169,   169,
     169,   169,   170,   170,   170,   171,   171,   172,   173,   173,
     174,   174,   174,   175,   176,   177,   177,   178,   178,   178,
     179,   180,   181,   182,   182,   182,   183,   182,   182,   182,
     182,   184,   184,   185,   185,   185,   186,   186,   186,   186,
     187,   187,   187,   187,   187,   187,   187,   188,   188,   188,
     189,   190,   191,   192,   191,   193,   193,   193,   194,   194,
     195,   196,   196,   197,   198,   198,   198,   198,   198,   198,
     200,   199,   201,   199,   202,   202,   203,   205,   204,   204,
     204,   206,   206,   206,   206,   206,   206,   206,   207,   208,
     208,   209,   209,   210,   210,   211,   211,   213,   212,   214,
     212,   212,   215,   216,   217,   215,   215,   215,   218,   215,
     219,   219,   219,   219,   219,   219,   219,   219,   219,   219,
     219,   219,   219,   219,   219,   219,   219,   219,   219,   220,
     221,   221,   222,   222,   222,   222,   222,   223,   224,   225,
     225,   225,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   227,   227,   227,   228,   228,   228,   229,
     230,   230,   230,   230,   230,   230,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   232,   233,   233,   234,   234,   235,   235,   235,
     236,   237,   237,   238,   238,   239,   239,   240,   240,   240,
     240,   240,   241,   241,   241,   242,   242,   242,   243,   243,
     243,   243,   243,   243,   243,   243,   243,   243,   243,   243,
     243,   243,   243,   243,   243,   243,   243,   243,   243,   243,
     244,   244,   244,   244,   244,   244,   244,   244,   245,   245,
     245,   245,   245,   245,   245,   245,   245,   245,   246,   246,
     246,   246,   246,   246,   246,   246,   246,   246,   246,   246,
     246,   246,   247,   247,   247,   247,   247,   247,   247,   248,
     248,   248,   248,   249,   249,   250,   250,   250,   251,   252,
     252,   252,   252,   253,   253,   253,   253,   253,   253,   253,
     253,   253,   254,   255,   256,   256,   257,   257,   257,   257,
     257,   257,   257,   257,   257,   257,   257,   257,   257,   257,
     259,   258,   258,   260,   260,   261,   262,   263,   263,   264,
     264,   265,   265,   265,   265,   266,   266,   267,   268,   268,
     269,   269,   269,   269,   269,   269,   269,   269,   269,   269,
     269,   269,   269,   269,   269,   269,   269,   269,   270,   270,
     270,   270,   270,   270,   270,   270,   271,   271,   271,   271,
     271,   271,   271,   271,   271,   271,   271,   271,   271,   271,
     271,   271,   271,   271,   271,   271,   271,   271,   272,   273,
     273,   274,   276,   275,   275,   277,   277,   279,   278,   280,
     278,   281,   281,   281,   282,   282,   282,   282,   283,   283,
     283,   284,   284,   285,   285,   285,   285,   286,   286,   286,
     286,   286,   287,   287,   287,   287,   288,   288,   288,   288,
     288,   288,   289,   289,   290,   290,   290,   290,   291,   291,
     292,   292,   293,   293,   293,   294,   294,   294,   295,   295,
     296,   296,   296,   296,   296,   296,   297,   297,   297,   297,
     298,   299,   299,   299,   299,   299,   299,   300,   300,   300,
     300,   301,   301,   302,   302,   303,   303,   303,   304,   304,
     305,   305,   305,   305,   305,   305,   306,   306,   307
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     3,     2,     3,     2,     5,     3,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       7,     5,     3,     5,     5,     3,     2,     2,     5,     2,
       5,     2,     4,     1,     1,     7,     7,     5,     0,     7,
       1,     1,     2,     2,     1,     5,     5,     5,     3,     4,
       3,     7,     8,     5,     3,     1,     1,     3,     1,     4,
       7,     6,     1,     1,     7,     9,     8,    10,     5,     7,
       6,     8,     1,     1,     5,     4,     5,     7,     1,     3,
       6,     6,     8,     1,     2,     3,     1,     2,     3,     6,
       5,     9,     2,     1,     1,     1,     0,     6,     1,     3,
       8,     5,     7,     1,     4,     1,     1,     2,     2,     3,
       1,     1,     1,     2,     1,     1,     1,    11,    13,     7,
       1,     1,     1,     0,     3,     1,     2,     2,     2,     1,
       5,     8,    10,     6,     1,     1,     1,     1,     1,     1,
       0,     9,     0,     8,     1,     3,     4,     0,     6,     3,
       4,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     1,     3,     1,     3,     4,     0,     6,     0,
       5,     5,     2,     0,     0,     7,     1,     1,     0,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     6,
       6,     7,     8,     8,     8,     9,     7,     5,     2,     2,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     4,     2,     2,     4,     2,     5,
       1,     1,     1,     2,     1,     1,     1,     2,     3,     1,
       1,     1,     1,     1,     1,     2,     1,     2,     2,     2,
       2,     1,     1,     2,     1,     3,     1,     2,     7,     3,
       1,     2,     1,     3,     1,     1,     1,     2,     5,     2,
       2,     1,     2,     2,     1,     1,     1,     1,     2,     3,
       3,     1,     2,     2,     3,     4,     5,     4,     5,     6,
       6,     4,     5,     5,     6,     7,     8,     8,     7,     7,
       1,     2,     3,     4,     5,     3,     4,     4,     1,     2,
       4,     4,     4,     5,     3,     4,     4,     5,     1,     2,
       2,     2,     3,     3,     1,     2,     2,     1,     1,     2,
       3,     4,     3,     4,     2,     3,     3,     4,     3,     3,
       2,     2,     1,     1,     2,     1,     1,     1,     1,     2,
       1,     2,     3,     1,     1,     1,     2,     2,     1,     1,
       2,     1,     4,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     5,     3,     3,     1,     1,     3,     1,     1,     1,
       1,     1,     5,     8,     1,     1,     1,     1,     3,     4,
       5,     5,     5,     6,     6,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     5,     2,     2,     2,     2,     2,     3,     1,
       1,     1,     0,     3,     1,     1,     3,     0,     4,     0,
       6,     1,     1,     1,     1,     1,     4,     4,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     4,     1,     1,
       2,     4,     1,     1,     2,     1,     3,     3,     4,     4,
       3,     4,     2,     1,     1,     3,     4,     6,     2,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     4,     1,     3,     1,     3,     3,     2,     2,     2,
       2,     2,     4,     1,     3,     1,     3,     3,     2,     2,
       2,     2,     1,     2,     1,     1,     1,     1,     3,     1,
       3,     5,     1,     3,     3,     5,     1,     1,     0
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);

        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1464 "parser.y" /* yacc.c:1646  */
    {
                   if (!classes) classes = NewHash();
		   Setattr((yyvsp[0].node),"classes",classes); 
		   Setattr((yyvsp[0].node),"name",ModuleName);
		   
		   if ((!module_node) && ModuleName) {
		     module_node = new_node("module");
		     Setattr(module_node,"name",ModuleName);
		   }
		   Setattr((yyvsp[0].node),"module",module_node);
	           top = (yyvsp[0].node);
               }
#line 4436 "y.tab.c" /* yacc.c:1646  */
    break;

  case 3:
#line 1476 "parser.y" /* yacc.c:1646  */
    {
                 top = Copy(Getattr((yyvsp[-1].p),"type"));
		 Delete((yyvsp[-1].p));
               }
#line 4445 "y.tab.c" /* yacc.c:1646  */
    break;

  case 4:
#line 1480 "parser.y" /* yacc.c:1646  */
    {
                 top = 0;
               }
#line 4453 "y.tab.c" /* yacc.c:1646  */
    break;

  case 5:
#line 1483 "parser.y" /* yacc.c:1646  */
    {
                 top = (yyvsp[-1].p);
               }
#line 4461 "y.tab.c" /* yacc.c:1646  */
    break;

  case 6:
#line 1486 "parser.y" /* yacc.c:1646  */
    {
                 top = 0;
               }
#line 4469 "y.tab.c" /* yacc.c:1646  */
    break;

  case 7:
#line 1489 "parser.y" /* yacc.c:1646  */
    {
                 top = (yyvsp[-2].pl);
               }
#line 4477 "y.tab.c" /* yacc.c:1646  */
    break;

  case 8:
#line 1492 "parser.y" /* yacc.c:1646  */
    {
                 top = 0;
               }
#line 4485 "y.tab.c" /* yacc.c:1646  */
    break;

  case 9:
#line 1497 "parser.y" /* yacc.c:1646  */
    {  
                   /* add declaration to end of linked list (the declaration isn't always a single declaration, sometimes it is a linked list itself) */
                   appendChild((yyvsp[-1].node),(yyvsp[0].node));
                   (yyval.node) = (yyvsp[-1].node);
               }
#line 4495 "y.tab.c" /* yacc.c:1646  */
    break;

  case 10:
#line 1502 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.node) = new_node("top");
               }
#line 4503 "y.tab.c" /* yacc.c:1646  */
    break;

  case 11:
#line 1507 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4509 "y.tab.c" /* yacc.c:1646  */
    break;

  case 12:
#line 1508 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4515 "y.tab.c" /* yacc.c:1646  */
    break;

  case 13:
#line 1509 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4521 "y.tab.c" /* yacc.c:1646  */
    break;

  case 14:
#line 1510 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 4527 "y.tab.c" /* yacc.c:1646  */
    break;

  case 15:
#line 1511 "parser.y" /* yacc.c:1646  */
    {
                  (yyval.node) = 0;
		  Swig_error(cparse_file, cparse_line,"Syntax error in input(1).\n");
		  exit(1);
               }
#line 4537 "y.tab.c" /* yacc.c:1646  */
    break;

  case 16:
#line 1517 "parser.y" /* yacc.c:1646  */
    { 
                  if ((yyval.node)) {
   		      add_symbols((yyval.node));
                  }
                  (yyval.node) = (yyvsp[0].node); 
	       }
#line 4548 "y.tab.c" /* yacc.c:1646  */
    break;

  case 17:
#line 1533 "parser.y" /* yacc.c:1646  */
    {
                  (yyval.node) = 0;
                  skip_decl();
               }
#line 4557 "y.tab.c" /* yacc.c:1646  */
    break;

  case 18:
#line 1543 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4563 "y.tab.c" /* yacc.c:1646  */
    break;

  case 19:
#line 1544 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4569 "y.tab.c" /* yacc.c:1646  */
    break;

  case 20:
#line 1545 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4575 "y.tab.c" /* yacc.c:1646  */
    break;

  case 21:
#line 1546 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4581 "y.tab.c" /* yacc.c:1646  */
    break;

  case 22:
#line 1547 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4587 "y.tab.c" /* yacc.c:1646  */
    break;

  case 23:
#line 1548 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4593 "y.tab.c" /* yacc.c:1646  */
    break;

  case 24:
#line 1549 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4599 "y.tab.c" /* yacc.c:1646  */
    break;

  case 25:
#line 1550 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4605 "y.tab.c" /* yacc.c:1646  */
    break;

  case 26:
#line 1551 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4611 "y.tab.c" /* yacc.c:1646  */
    break;

  case 27:
#line 1552 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4617 "y.tab.c" /* yacc.c:1646  */
    break;

  case 28:
#line 1553 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4623 "y.tab.c" /* yacc.c:1646  */
    break;

  case 29:
#line 1554 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4629 "y.tab.c" /* yacc.c:1646  */
    break;

  case 30:
#line 1555 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4635 "y.tab.c" /* yacc.c:1646  */
    break;

  case 31:
#line 1556 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4641 "y.tab.c" /* yacc.c:1646  */
    break;

  case 32:
#line 1557 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4647 "y.tab.c" /* yacc.c:1646  */
    break;

  case 33:
#line 1558 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4653 "y.tab.c" /* yacc.c:1646  */
    break;

  case 34:
#line 1559 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4659 "y.tab.c" /* yacc.c:1646  */
    break;

  case 35:
#line 1560 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4665 "y.tab.c" /* yacc.c:1646  */
    break;

  case 36:
#line 1561 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4671 "y.tab.c" /* yacc.c:1646  */
    break;

  case 37:
#line 1562 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4677 "y.tab.c" /* yacc.c:1646  */
    break;

  case 38:
#line 1563 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 4683 "y.tab.c" /* yacc.c:1646  */
    break;

  case 39:
#line 1570 "parser.y" /* yacc.c:1646  */
    {
               Node *cls;
	       String *clsname;
	       extendmode = 1;
	       cplus_mode = CPLUS_PUBLIC;
	       if (!classes) classes = NewHash();
	       if (!classes_typedefs) classes_typedefs = NewHash();
	       clsname = make_class_name((yyvsp[-1].str));
	       cls = Getattr(classes,clsname);
	       if (!cls) {
	         cls = Getattr(classes_typedefs, clsname);
		 if (!cls) {
		   /* No previous definition. Create a new scope */
		   Node *am = Getattr(Swig_extend_hash(),clsname);
		   if (!am) {
		     Swig_symbol_newscope();
		     Swig_symbol_setscopename((yyvsp[-1].str));
		     prev_symtab = 0;
		   } else {
		     prev_symtab = Swig_symbol_setscope(Getattr(am,"symtab"));
		   }
		   current_class = 0;
		 } else {
		   /* Previous typedef class definition.  Use its symbol table.
		      Deprecated, just the real name should be used. 
		      Note that %extend before the class typedef never worked, only %extend after the class typdef. */
		   prev_symtab = Swig_symbol_setscope(Getattr(cls, "symtab"));
		   current_class = cls;
		   SWIG_WARN_NODE_BEGIN(cls);
		   Swig_warning(WARN_PARSE_EXTEND_NAME, cparse_file, cparse_line, "Deprecated %%extend name used - the %s name '%s' should be used instead of the typedef name '%s'.\n", Getattr(cls, "kind"), SwigType_namestr(Getattr(cls, "name")), (yyvsp[-1].str));
		   SWIG_WARN_NODE_END(cls);
		 }
	       } else {
		 /* Previous class definition.  Use its symbol table */
		 prev_symtab = Swig_symbol_setscope(Getattr(cls,"symtab"));
		 current_class = cls;
	       }
	       Classprefix = NewString((yyvsp[-1].str));
	       Namespaceprefix= Swig_symbol_qualifiedscopename(0);
	       Delete(clsname);
	     }
#line 4729 "y.tab.c" /* yacc.c:1646  */
    break;

  case 40:
#line 1610 "parser.y" /* yacc.c:1646  */
    {
               String *clsname;
	       extendmode = 0;
               (yyval.node) = new_node("extend");
	       Setattr((yyval.node),"symtab",Swig_symbol_popscope());
	       if (prev_symtab) {
		 Swig_symbol_setscope(prev_symtab);
	       }
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
               clsname = make_class_name((yyvsp[-4].str));
	       Setattr((yyval.node),"name",clsname);

	       mark_nodes_as_extend((yyvsp[-1].node));
	       if (current_class) {
		 /* We add the extension to the previously defined class */
		 appendChild((yyval.node),(yyvsp[-1].node));
		 appendChild(current_class,(yyval.node));
	       } else {
		 /* We store the extensions in the extensions hash */
		 Node *am = Getattr(Swig_extend_hash(),clsname);
		 if (am) {
		   /* Append the members to the previous extend methods */
		   appendChild(am,(yyvsp[-1].node));
		 } else {
		   appendChild((yyval.node),(yyvsp[-1].node));
		   Setattr(Swig_extend_hash(),clsname,(yyval.node));
		 }
	       }
	       current_class = 0;
	       Delete(Classprefix);
	       Delete(clsname);
	       Classprefix = 0;
	       prev_symtab = 0;
	       (yyval.node) = 0;

	     }
#line 4770 "y.tab.c" /* yacc.c:1646  */
    break;

  case 41:
#line 1652 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.node) = new_node("apply");
                    Setattr((yyval.node),"pattern",Getattr((yyvsp[-3].p),"pattern"));
		    appendChild((yyval.node),(yyvsp[-1].p));
               }
#line 4780 "y.tab.c" /* yacc.c:1646  */
    break;

  case 42:
#line 1662 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.node) = new_node("clear");
		 appendChild((yyval.node),(yyvsp[-1].p));
               }
#line 4789 "y.tab.c" /* yacc.c:1646  */
    break;

  case 43:
#line 1673 "parser.y" /* yacc.c:1646  */
    {
		   if (((yyvsp[-1].dtype).type != T_ERROR) && ((yyvsp[-1].dtype).type != T_SYMBOL)) {
		     SwigType *type = NewSwigType((yyvsp[-1].dtype).type);
		     (yyval.node) = new_node("constant");
		     Setattr((yyval.node),"name",(yyvsp[-3].id));
		     Setattr((yyval.node),"type",type);
		     Setattr((yyval.node),"value",(yyvsp[-1].dtype).val);
		     if ((yyvsp[-1].dtype).rawval) Setattr((yyval.node),"rawval", (yyvsp[-1].dtype).rawval);
		     Setattr((yyval.node),"storage","%constant");
		     SetFlag((yyval.node),"feature:immutable");
		     add_symbols((yyval.node));
		     Delete(type);
		   } else {
		     if ((yyvsp[-1].dtype).type == T_ERROR) {
		       Swig_warning(WARN_PARSE_UNSUPPORTED_VALUE,cparse_file,cparse_line,"Unsupported constant value (ignored)\n");
		     }
		     (yyval.node) = 0;
		   }

	       }
#line 4814 "y.tab.c" /* yacc.c:1646  */
    break;

  case 44:
#line 1694 "parser.y" /* yacc.c:1646  */
    {
		 if (((yyvsp[-1].dtype).type != T_ERROR) && ((yyvsp[-1].dtype).type != T_SYMBOL)) {
		   SwigType_push((yyvsp[-3].type),(yyvsp[-2].decl).type);
		   /* Sneaky callback function trick */
		   if (SwigType_isfunction((yyvsp[-3].type))) {
		     SwigType_add_pointer((yyvsp[-3].type));
		   }
		   (yyval.node) = new_node("constant");
		   Setattr((yyval.node),"name",(yyvsp[-2].decl).id);
		   Setattr((yyval.node),"type",(yyvsp[-3].type));
		   Setattr((yyval.node),"value",(yyvsp[-1].dtype).val);
		   if ((yyvsp[-1].dtype).rawval) Setattr((yyval.node),"rawval", (yyvsp[-1].dtype).rawval);
		   Setattr((yyval.node),"storage","%constant");
		   SetFlag((yyval.node),"feature:immutable");
		   add_symbols((yyval.node));
		 } else {
		     if ((yyvsp[-1].dtype).type == T_ERROR) {
		       Swig_warning(WARN_PARSE_UNSUPPORTED_VALUE,cparse_file,cparse_line,"Unsupported constant value\n");
		     }
		   (yyval.node) = 0;
		 }
               }
#line 4841 "y.tab.c" /* yacc.c:1646  */
    break;

  case 45:
#line 1716 "parser.y" /* yacc.c:1646  */
    {
		 Swig_warning(WARN_PARSE_BAD_VALUE,cparse_file,cparse_line,"Bad constant value (ignored).\n");
		 (yyval.node) = 0;
	       }
#line 4850 "y.tab.c" /* yacc.c:1646  */
    break;

  case 46:
#line 1727 "parser.y" /* yacc.c:1646  */
    {
		 char temp[64];
		 Replace((yyvsp[0].str),"$file",cparse_file, DOH_REPLACE_ANY);
		 sprintf(temp,"%d", cparse_line);
		 Replace((yyvsp[0].str),"$line",temp,DOH_REPLACE_ANY);
		 Printf(stderr,"%s\n", (yyvsp[0].str));
		 Delete((yyvsp[0].str));
                 (yyval.node) = 0;
	       }
#line 4864 "y.tab.c" /* yacc.c:1646  */
    break;

  case 47:
#line 1736 "parser.y" /* yacc.c:1646  */
    {
		 char temp[64];
		 String *s = NewString((yyvsp[0].id));
		 Replace(s,"$file",cparse_file, DOH_REPLACE_ANY);
		 sprintf(temp,"%d", cparse_line);
		 Replace(s,"$line",temp,DOH_REPLACE_ANY);
		 Printf(stderr,"%s\n", s);
		 Delete(s);
                 (yyval.node) = 0;
               }
#line 4879 "y.tab.c" /* yacc.c:1646  */
    break;

  case 48:
#line 1755 "parser.y" /* yacc.c:1646  */
    {
                    skip_balanced('{','}');
		    (yyval.node) = 0;
		    Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
	       }
#line 4889 "y.tab.c" /* yacc.c:1646  */
    break;

  case 49:
#line 1761 "parser.y" /* yacc.c:1646  */
    {
                    skip_balanced('{','}');
		    (yyval.node) = 0;
		    Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
               }
#line 4899 "y.tab.c" /* yacc.c:1646  */
    break;

  case 50:
#line 1767 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.node) = 0;
		 Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
               }
#line 4908 "y.tab.c" /* yacc.c:1646  */
    break;

  case 51:
#line 1772 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.node) = 0;
		 Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
	       }
#line 4917 "y.tab.c" /* yacc.c:1646  */
    break;

  case 52:
#line 1779 "parser.y" /* yacc.c:1646  */
    {		 
                 (yyval.node) = NewHash();
                 Setattr((yyval.node),"value",(yyvsp[-3].id));
		 Setattr((yyval.node),"type",Getattr((yyvsp[-1].p),"type"));
               }
#line 4927 "y.tab.c" /* yacc.c:1646  */
    break;

  case 53:
#line 1786 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.node) = NewHash();
                 Setattr((yyval.node),"value",(yyvsp[0].id));
              }
#line 4936 "y.tab.c" /* yacc.c:1646  */
    break;

  case 54:
#line 1790 "parser.y" /* yacc.c:1646  */
    {
                (yyval.node) = (yyvsp[0].node);
              }
#line 4944 "y.tab.c" /* yacc.c:1646  */
    break;

  case 55:
#line 1803 "parser.y" /* yacc.c:1646  */
    {
                   Hash *p = (yyvsp[-2].node);
		   (yyval.node) = new_node("fragment");
		   Setattr((yyval.node),"value",Getattr((yyvsp[-4].node),"value"));
		   Setattr((yyval.node),"type",Getattr((yyvsp[-4].node),"type"));
		   Setattr((yyval.node),"section",Getattr(p,"name"));
		   Setattr((yyval.node),"kwargs",nextSibling(p));
		   Setattr((yyval.node),"code",(yyvsp[0].str));
                 }
#line 4958 "y.tab.c" /* yacc.c:1646  */
    break;

  case 56:
#line 1812 "parser.y" /* yacc.c:1646  */
    {
		   Hash *p = (yyvsp[-2].node);
		   String *code;
                   skip_balanced('{','}');
		   (yyval.node) = new_node("fragment");
		   Setattr((yyval.node),"value",Getattr((yyvsp[-4].node),"value"));
		   Setattr((yyval.node),"type",Getattr((yyvsp[-4].node),"type"));
		   Setattr((yyval.node),"section",Getattr(p,"name"));
		   Setattr((yyval.node),"kwargs",nextSibling(p));
		   Delitem(scanner_ccode,0);
		   Delitem(scanner_ccode,DOH_END);
		   code = Copy(scanner_ccode);
		   Setattr((yyval.node),"code",code);
		   Delete(code);
                 }
#line 4978 "y.tab.c" /* yacc.c:1646  */
    break;

  case 57:
#line 1827 "parser.y" /* yacc.c:1646  */
    {
		   (yyval.node) = new_node("fragment");
		   Setattr((yyval.node),"value",Getattr((yyvsp[-2].node),"value"));
		   Setattr((yyval.node),"type",Getattr((yyvsp[-2].node),"type"));
		   Setattr((yyval.node),"emitonly","1");
		 }
#line 4989 "y.tab.c" /* yacc.c:1646  */
    break;

  case 58:
#line 1840 "parser.y" /* yacc.c:1646  */
    {
                     (yyvsp[-3].loc).filename = Copy(cparse_file);
		     (yyvsp[-3].loc).line = cparse_line;
		     scanner_set_location(NewString((yyvsp[-1].id)),1);
                     if ((yyvsp[-2].node)) { 
		       String *maininput = Getattr((yyvsp[-2].node), "maininput");
		       if (maininput)
		         scanner_set_main_input_file(NewString(maininput));
		     }
               }
#line 5004 "y.tab.c" /* yacc.c:1646  */
    break;

  case 59:
#line 1849 "parser.y" /* yacc.c:1646  */
    {
                     String *mname = 0;
                     (yyval.node) = (yyvsp[-1].node);
		     scanner_set_location((yyvsp[-6].loc).filename,(yyvsp[-6].loc).line+1);
		     if (strcmp((yyvsp[-6].loc).type,"include") == 0) set_nodeType((yyval.node),"include");
		     if (strcmp((yyvsp[-6].loc).type,"import") == 0) {
		       mname = (yyvsp[-5].node) ? Getattr((yyvsp[-5].node),"module") : 0;
		       set_nodeType((yyval.node),"import");
		       if (import_mode) --import_mode;
		     }
		     
		     Setattr((yyval.node),"name",(yyvsp[-4].id));
		     /* Search for the module (if any) */
		     {
			 Node *n = firstChild((yyval.node));
			 while (n) {
			     if (Strcmp(nodeType(n),"module") == 0) {
			         if (mname) {
				   Setattr(n,"name", mname);
				   mname = 0;
				 }
				 Setattr((yyval.node),"module",Getattr(n,"name"));
				 break;
			     }
			     n = nextSibling(n);
			 }
			 if (mname) {
			   /* There is no module node in the import
			      node, ie, you imported a .h file
			      directly.  We are forced then to create
			      a new import node with a module node.
			   */			      
			   Node *nint = new_node("import");
			   Node *mnode = new_node("module");
			   Setattr(mnode,"name", mname);
                           Setattr(mnode,"options",(yyvsp[-5].node));
			   appendChild(nint,mnode);
			   Delete(mnode);
			   appendChild(nint,firstChild((yyval.node)));
			   (yyval.node) = nint;
			   Setattr((yyval.node),"module",mname);
			 }
		     }
		     Setattr((yyval.node),"options",(yyvsp[-5].node));
               }
#line 5054 "y.tab.c" /* yacc.c:1646  */
    break;

  case 60:
#line 1896 "parser.y" /* yacc.c:1646  */
    { (yyval.loc).type = "include"; }
#line 5060 "y.tab.c" /* yacc.c:1646  */
    break;

  case 61:
#line 1897 "parser.y" /* yacc.c:1646  */
    { (yyval.loc).type = "import"; ++import_mode;}
#line 5066 "y.tab.c" /* yacc.c:1646  */
    break;

  case 62:
#line 1904 "parser.y" /* yacc.c:1646  */
    {
                 String *cpps;
		 if (Namespaceprefix) {
		   Swig_error(cparse_file, cparse_start_line, "%%inline directive inside a namespace is disallowed.\n");
		   (yyval.node) = 0;
		 } else {
		   (yyval.node) = new_node("insert");
		   Setattr((yyval.node),"code",(yyvsp[0].str));
		   /* Need to run through the preprocessor */
		   Seek((yyvsp[0].str),0,SEEK_SET);
		   Setline((yyvsp[0].str),cparse_start_line);
		   Setfile((yyvsp[0].str),cparse_file);
		   cpps = Preprocessor_parse((yyvsp[0].str));
		   start_inline(Char(cpps), cparse_start_line);
		   Delete((yyvsp[0].str));
		   Delete(cpps);
		 }
		 
	       }
#line 5090 "y.tab.c" /* yacc.c:1646  */
    break;

  case 63:
#line 1923 "parser.y" /* yacc.c:1646  */
    {
                 String *cpps;
		 int start_line = cparse_line;
		 skip_balanced('{','}');
		 if (Namespaceprefix) {
		   Swig_error(cparse_file, cparse_start_line, "%%inline directive inside a namespace is disallowed.\n");
		   
		   (yyval.node) = 0;
		 } else {
		   String *code;
                   (yyval.node) = new_node("insert");
		   Delitem(scanner_ccode,0);
		   Delitem(scanner_ccode,DOH_END);
		   code = Copy(scanner_ccode);
		   Setattr((yyval.node),"code", code);
		   Delete(code);		   
		   cpps=Copy(scanner_ccode);
		   start_inline(Char(cpps), start_line);
		   Delete(cpps);
		 }
               }
#line 5116 "y.tab.c" /* yacc.c:1646  */
    break;

  case 64:
#line 1954 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.node) = new_node("insert");
		 Setattr((yyval.node),"code",(yyvsp[0].str));
	       }
#line 5125 "y.tab.c" /* yacc.c:1646  */
    break;

  case 65:
#line 1958 "parser.y" /* yacc.c:1646  */
    {
		 String *code = NewStringEmpty();
		 (yyval.node) = new_node("insert");
		 Setattr((yyval.node),"section",(yyvsp[-2].id));
		 Setattr((yyval.node),"code",code);
		 if (Swig_insert_file((yyvsp[0].id),code) < 0) {
		   Swig_error(cparse_file, cparse_line, "Couldn't find '%s'.\n", (yyvsp[0].id));
		   (yyval.node) = 0;
		 } 
               }
#line 5140 "y.tab.c" /* yacc.c:1646  */
    break;

  case 66:
#line 1968 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.node) = new_node("insert");
		 Setattr((yyval.node),"section",(yyvsp[-2].id));
		 Setattr((yyval.node),"code",(yyvsp[0].str));
               }
#line 5150 "y.tab.c" /* yacc.c:1646  */
    break;

  case 67:
#line 1973 "parser.y" /* yacc.c:1646  */
    {
		 String *code;
                 skip_balanced('{','}');
		 (yyval.node) = new_node("insert");
		 Setattr((yyval.node),"section",(yyvsp[-2].id));
		 Delitem(scanner_ccode,0);
		 Delitem(scanner_ccode,DOH_END);
		 code = Copy(scanner_ccode);
		 Setattr((yyval.node),"code", code);
		 Delete(code);
	       }
#line 5166 "y.tab.c" /* yacc.c:1646  */
    break;

  case 68:
#line 1991 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.node) = new_node("module");
		 if ((yyvsp[-1].node)) {
		   Setattr((yyval.node),"options",(yyvsp[-1].node));
		   if (Getattr((yyvsp[-1].node),"directors")) {
		     Wrapper_director_mode_set(1);
		     if (!cparse_cplusplus) {
		       Swig_error(cparse_file, cparse_line, "Directors are not supported for C code and require the -c++ option\n");
		     }
		   } 
		   if (Getattr((yyvsp[-1].node),"dirprot")) {
		     Wrapper_director_protected_mode_set(1);
		   } 
		   if (Getattr((yyvsp[-1].node),"allprotected")) {
		     Wrapper_all_protected_mode_set(1);
		   } 
		   if (Getattr((yyvsp[-1].node),"templatereduce")) {
		     template_reduce = 1;
		   }
		   if (Getattr((yyvsp[-1].node),"notemplatereduce")) {
		     template_reduce = 0;
		   }
		 }
		 if (!ModuleName) ModuleName = NewString((yyvsp[0].id));
		 if (!import_mode) {
		   /* first module included, we apply global
		      ModuleName, which can be modify by -module */
		   String *mname = Copy(ModuleName);
		   Setattr((yyval.node),"name",mname);
		   Delete(mname);
		 } else { 
		   /* import mode, we just pass the idstring */
		   Setattr((yyval.node),"name",(yyvsp[0].id));   
		 }		 
		 if (!module_node) module_node = (yyval.node);
	       }
#line 5207 "y.tab.c" /* yacc.c:1646  */
    break;

  case 69:
#line 2034 "parser.y" /* yacc.c:1646  */
    {
                 Swig_warning(WARN_DEPRECATED_NAME,cparse_file,cparse_line, "%%name is deprecated.  Use %%rename instead.\n");
		 Delete(yyrename);
                 yyrename = NewString((yyvsp[-1].id));
		 (yyval.node) = 0;
               }
#line 5218 "y.tab.c" /* yacc.c:1646  */
    break;

  case 70:
#line 2040 "parser.y" /* yacc.c:1646  */
    {
		 Swig_warning(WARN_DEPRECATED_NAME,cparse_file,cparse_line, "%%name is deprecated.  Use %%rename instead.\n");
		 (yyval.node) = 0;
		 Swig_error(cparse_file,cparse_line,"Missing argument to %%name directive.\n");
	       }
#line 5228 "y.tab.c" /* yacc.c:1646  */
    break;

  case 71:
#line 2053 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.node) = new_node("native");
		 Setattr((yyval.node),"name",(yyvsp[-4].id));
		 Setattr((yyval.node),"wrap:name",(yyvsp[-1].id));
	         add_symbols((yyval.node));
	       }
#line 5239 "y.tab.c" /* yacc.c:1646  */
    break;

  case 72:
#line 2059 "parser.y" /* yacc.c:1646  */
    {
		 if (!SwigType_isfunction((yyvsp[-1].decl).type)) {
		   Swig_error(cparse_file,cparse_line,"%%native declaration '%s' is not a function.\n", (yyvsp[-1].decl).id);
		   (yyval.node) = 0;
		 } else {
		     Delete(SwigType_pop_function((yyvsp[-1].decl).type));
		     /* Need check for function here */
		     SwigType_push((yyvsp[-2].type),(yyvsp[-1].decl).type);
		     (yyval.node) = new_node("native");
	             Setattr((yyval.node),"name",(yyvsp[-5].id));
		     Setattr((yyval.node),"wrap:name",(yyvsp[-1].decl).id);
		     Setattr((yyval.node),"type",(yyvsp[-2].type));
		     Setattr((yyval.node),"parms",(yyvsp[-1].decl).parms);
		     Setattr((yyval.node),"decl",(yyvsp[-1].decl).type);
		 }
	         add_symbols((yyval.node));
	       }
#line 5261 "y.tab.c" /* yacc.c:1646  */
    break;

  case 73:
#line 2085 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.node) = new_node("pragma");
		 Setattr((yyval.node),"lang",(yyvsp[-3].id));
		 Setattr((yyval.node),"name",(yyvsp[-2].id));
		 Setattr((yyval.node),"value",(yyvsp[0].str));
	       }
#line 5272 "y.tab.c" /* yacc.c:1646  */
    break;

  case 74:
#line 2091 "parser.y" /* yacc.c:1646  */
    {
		(yyval.node) = new_node("pragma");
		Setattr((yyval.node),"lang",(yyvsp[-1].id));
		Setattr((yyval.node),"name",(yyvsp[0].id));
	      }
#line 5282 "y.tab.c" /* yacc.c:1646  */
    break;

  case 75:
#line 2098 "parser.y" /* yacc.c:1646  */
    { (yyval.str) = NewString((yyvsp[0].id)); }
#line 5288 "y.tab.c" /* yacc.c:1646  */
    break;

  case 76:
#line 2099 "parser.y" /* yacc.c:1646  */
    { (yyval.str) = (yyvsp[0].str); }
#line 5294 "y.tab.c" /* yacc.c:1646  */
    break;

  case 77:
#line 2102 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (yyvsp[-1].id); }
#line 5300 "y.tab.c" /* yacc.c:1646  */
    break;

  case 78:
#line 2103 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (char *) "swig"; }
#line 5306 "y.tab.c" /* yacc.c:1646  */
    break;

  case 79:
#line 2110 "parser.y" /* yacc.c:1646  */
    {
                SwigType *t = (yyvsp[-2].decl).type;
		Hash *kws = NewHash();
		String *fixname;
		fixname = feature_identifier_fix((yyvsp[-2].decl).id);
		Setattr(kws,"name",(yyvsp[-1].id));
		if (!Len(t)) t = 0;
		/* Special declarator check */
		if (t) {
		  if (SwigType_isfunction(t)) {
		    SwigType *decl = SwigType_pop_function(t);
		    if (SwigType_ispointer(t)) {
		      String *nname = NewStringf("*%s",fixname);
		      if ((yyvsp[-3].intvalue)) {
			Swig_name_rename_add(Namespaceprefix, nname,decl,kws,(yyvsp[-2].decl).parms);
		      } else {
			Swig_name_namewarn_add(Namespaceprefix,nname,decl,kws);
		      }
		      Delete(nname);
		    } else {
		      if ((yyvsp[-3].intvalue)) {
			Swig_name_rename_add(Namespaceprefix,(fixname),decl,kws,(yyvsp[-2].decl).parms);
		      } else {
			Swig_name_namewarn_add(Namespaceprefix,(fixname),decl,kws);
		      }
		    }
		    Delete(decl);
		  } else if (SwigType_ispointer(t)) {
		    String *nname = NewStringf("*%s",fixname);
		    if ((yyvsp[-3].intvalue)) {
		      Swig_name_rename_add(Namespaceprefix,(nname),0,kws,(yyvsp[-2].decl).parms);
		    } else {
		      Swig_name_namewarn_add(Namespaceprefix,(nname),0,kws);
		    }
		    Delete(nname);
		  }
		} else {
		  if ((yyvsp[-3].intvalue)) {
		    Swig_name_rename_add(Namespaceprefix,(fixname),0,kws,(yyvsp[-2].decl).parms);
		  } else {
		    Swig_name_namewarn_add(Namespaceprefix,(fixname),0,kws);
		  }
		}
                (yyval.node) = 0;
		scanner_clear_rename();
              }
#line 5357 "y.tab.c" /* yacc.c:1646  */
    break;

  case 80:
#line 2156 "parser.y" /* yacc.c:1646  */
    {
		String *fixname;
		Hash *kws = (yyvsp[-4].node);
		SwigType *t = (yyvsp[-2].decl).type;
		fixname = feature_identifier_fix((yyvsp[-2].decl).id);
		if (!Len(t)) t = 0;
		/* Special declarator check */
		if (t) {
		  if ((yyvsp[-1].dtype).qualifier) SwigType_push(t,(yyvsp[-1].dtype).qualifier);
		  if (SwigType_isfunction(t)) {
		    SwigType *decl = SwigType_pop_function(t);
		    if (SwigType_ispointer(t)) {
		      String *nname = NewStringf("*%s",fixname);
		      if ((yyvsp[-6].intvalue)) {
			Swig_name_rename_add(Namespaceprefix, nname,decl,kws,(yyvsp[-2].decl).parms);
		      } else {
			Swig_name_namewarn_add(Namespaceprefix,nname,decl,kws);
		      }
		      Delete(nname);
		    } else {
		      if ((yyvsp[-6].intvalue)) {
			Swig_name_rename_add(Namespaceprefix,(fixname),decl,kws,(yyvsp[-2].decl).parms);
		      } else {
			Swig_name_namewarn_add(Namespaceprefix,(fixname),decl,kws);
		      }
		    }
		    Delete(decl);
		  } else if (SwigType_ispointer(t)) {
		    String *nname = NewStringf("*%s",fixname);
		    if ((yyvsp[-6].intvalue)) {
		      Swig_name_rename_add(Namespaceprefix,(nname),0,kws,(yyvsp[-2].decl).parms);
		    } else {
		      Swig_name_namewarn_add(Namespaceprefix,(nname),0,kws);
		    }
		    Delete(nname);
		  }
		} else {
		  if ((yyvsp[-6].intvalue)) {
		    Swig_name_rename_add(Namespaceprefix,(fixname),0,kws,(yyvsp[-2].decl).parms);
		  } else {
		    Swig_name_namewarn_add(Namespaceprefix,(fixname),0,kws);
		  }
		}
                (yyval.node) = 0;
		scanner_clear_rename();
              }
#line 5408 "y.tab.c" /* yacc.c:1646  */
    break;

  case 81:
#line 2202 "parser.y" /* yacc.c:1646  */
    {
		if ((yyvsp[-5].intvalue)) {
		  Swig_name_rename_add(Namespaceprefix,(yyvsp[-1].id),0,(yyvsp[-3].node),0);
		} else {
		  Swig_name_namewarn_add(Namespaceprefix,(yyvsp[-1].id),0,(yyvsp[-3].node));
		}
		(yyval.node) = 0;
		scanner_clear_rename();
              }
#line 5422 "y.tab.c" /* yacc.c:1646  */
    break;

  case 82:
#line 2213 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.intvalue) = 1;
                }
#line 5430 "y.tab.c" /* yacc.c:1646  */
    break;

  case 83:
#line 2216 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.intvalue) = 0;
                }
#line 5438 "y.tab.c" /* yacc.c:1646  */
    break;

  case 84:
#line 2243 "parser.y" /* yacc.c:1646  */
    {
                    String *val = (yyvsp[0].str) ? NewString((yyvsp[0].str)) : NewString("1");
                    new_feature((yyvsp[-4].id), val, 0, (yyvsp[-2].decl).id, (yyvsp[-2].decl).type, (yyvsp[-2].decl).parms, (yyvsp[-1].dtype).qualifier);
                    (yyval.node) = 0;
                    scanner_clear_rename();
                  }
#line 5449 "y.tab.c" /* yacc.c:1646  */
    break;

  case 85:
#line 2249 "parser.y" /* yacc.c:1646  */
    {
                    String *val = Len((yyvsp[-4].id)) ? NewString((yyvsp[-4].id)) : 0;
                    new_feature((yyvsp[-6].id), val, 0, (yyvsp[-2].decl).id, (yyvsp[-2].decl).type, (yyvsp[-2].decl).parms, (yyvsp[-1].dtype).qualifier);
                    (yyval.node) = 0;
                    scanner_clear_rename();
                  }
#line 5460 "y.tab.c" /* yacc.c:1646  */
    break;

  case 86:
#line 2255 "parser.y" /* yacc.c:1646  */
    {
                    String *val = (yyvsp[0].str) ? NewString((yyvsp[0].str)) : NewString("1");
                    new_feature((yyvsp[-5].id), val, (yyvsp[-4].node), (yyvsp[-2].decl).id, (yyvsp[-2].decl).type, (yyvsp[-2].decl).parms, (yyvsp[-1].dtype).qualifier);
                    (yyval.node) = 0;
                    scanner_clear_rename();
                  }
#line 5471 "y.tab.c" /* yacc.c:1646  */
    break;

  case 87:
#line 2261 "parser.y" /* yacc.c:1646  */
    {
                    String *val = Len((yyvsp[-5].id)) ? NewString((yyvsp[-5].id)) : 0;
                    new_feature((yyvsp[-7].id), val, (yyvsp[-4].node), (yyvsp[-2].decl).id, (yyvsp[-2].decl).type, (yyvsp[-2].decl).parms, (yyvsp[-1].dtype).qualifier);
                    (yyval.node) = 0;
                    scanner_clear_rename();
                  }
#line 5482 "y.tab.c" /* yacc.c:1646  */
    break;

  case 88:
#line 2269 "parser.y" /* yacc.c:1646  */
    {
                    String *val = (yyvsp[0].str) ? NewString((yyvsp[0].str)) : NewString("1");
                    new_feature((yyvsp[-2].id), val, 0, 0, 0, 0, 0);
                    (yyval.node) = 0;
                    scanner_clear_rename();
                  }
#line 5493 "y.tab.c" /* yacc.c:1646  */
    break;

  case 89:
#line 2275 "parser.y" /* yacc.c:1646  */
    {
                    String *val = Len((yyvsp[-2].id)) ? NewString((yyvsp[-2].id)) : 0;
                    new_feature((yyvsp[-4].id), val, 0, 0, 0, 0, 0);
                    (yyval.node) = 0;
                    scanner_clear_rename();
                  }
#line 5504 "y.tab.c" /* yacc.c:1646  */
    break;

  case 90:
#line 2281 "parser.y" /* yacc.c:1646  */
    {
                    String *val = (yyvsp[0].str) ? NewString((yyvsp[0].str)) : NewString("1");
                    new_feature((yyvsp[-3].id), val, (yyvsp[-2].node), 0, 0, 0, 0);
                    (yyval.node) = 0;
                    scanner_clear_rename();
                  }
#line 5515 "y.tab.c" /* yacc.c:1646  */
    break;

  case 91:
#line 2287 "parser.y" /* yacc.c:1646  */
    {
                    String *val = Len((yyvsp[-3].id)) ? NewString((yyvsp[-3].id)) : 0;
                    new_feature((yyvsp[-5].id), val, (yyvsp[-2].node), 0, 0, 0, 0);
                    (yyval.node) = 0;
                    scanner_clear_rename();
                  }
#line 5526 "y.tab.c" /* yacc.c:1646  */
    break;

  case 92:
#line 2295 "parser.y" /* yacc.c:1646  */
    { (yyval.str) = (yyvsp[0].str); }
#line 5532 "y.tab.c" /* yacc.c:1646  */
    break;

  case 93:
#line 2296 "parser.y" /* yacc.c:1646  */
    { (yyval.str) = 0; }
#line 5538 "y.tab.c" /* yacc.c:1646  */
    break;

  case 94:
#line 2297 "parser.y" /* yacc.c:1646  */
    { (yyval.str) = (yyvsp[-2].pl); }
#line 5544 "y.tab.c" /* yacc.c:1646  */
    break;

  case 95:
#line 2300 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.node) = NewHash();
		  Setattr((yyval.node),"name",(yyvsp[-2].id));
		  Setattr((yyval.node),"value",(yyvsp[0].id));
                }
#line 5554 "y.tab.c" /* yacc.c:1646  */
    break;

  case 96:
#line 2305 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.node) = NewHash();
		  Setattr((yyval.node),"name",(yyvsp[-3].id));
		  Setattr((yyval.node),"value",(yyvsp[-1].id));
                  set_nextSibling((yyval.node),(yyvsp[0].node));
                }
#line 5565 "y.tab.c" /* yacc.c:1646  */
    break;

  case 97:
#line 2315 "parser.y" /* yacc.c:1646  */
    {
                 Parm *val;
		 String *name;
		 SwigType *t;
		 if (Namespaceprefix) name = NewStringf("%s::%s", Namespaceprefix, (yyvsp[-2].decl).id);
		 else name = NewString((yyvsp[-2].decl).id);
		 val = (yyvsp[-4].pl);
		 if ((yyvsp[-2].decl).parms) {
		   Setmeta(val,"parms",(yyvsp[-2].decl).parms);
		 }
		 t = (yyvsp[-2].decl).type;
		 if (!Len(t)) t = 0;
		 if (t) {
		   if ((yyvsp[-1].dtype).qualifier) SwigType_push(t,(yyvsp[-1].dtype).qualifier);
		   if (SwigType_isfunction(t)) {
		     SwigType *decl = SwigType_pop_function(t);
		     if (SwigType_ispointer(t)) {
		       String *nname = NewStringf("*%s",name);
		       Swig_feature_set(Swig_cparse_features(), nname, decl, "feature:varargs", val, 0);
		       Delete(nname);
		     } else {
		       Swig_feature_set(Swig_cparse_features(), name, decl, "feature:varargs", val, 0);
		     }
		     Delete(decl);
		   } else if (SwigType_ispointer(t)) {
		     String *nname = NewStringf("*%s",name);
		     Swig_feature_set(Swig_cparse_features(),nname,0,"feature:varargs",val, 0);
		     Delete(nname);
		   }
		 } else {
		   Swig_feature_set(Swig_cparse_features(),name,0,"feature:varargs",val, 0);
		 }
		 Delete(name);
		 (yyval.node) = 0;
              }
#line 5605 "y.tab.c" /* yacc.c:1646  */
    break;

  case 98:
#line 2351 "parser.y" /* yacc.c:1646  */
    { (yyval.pl) = (yyvsp[0].pl); }
#line 5611 "y.tab.c" /* yacc.c:1646  */
    break;

  case 99:
#line 2352 "parser.y" /* yacc.c:1646  */
    { 
		  int i;
		  int n;
		  Parm *p;
		  n = atoi(Char((yyvsp[-2].dtype).val));
		  if (n <= 0) {
		    Swig_error(cparse_file, cparse_line,"Argument count in %%varargs must be positive.\n");
		    (yyval.pl) = 0;
		  } else {
		    String *name = Getattr((yyvsp[0].p), "name");
		    (yyval.pl) = Copy((yyvsp[0].p));
		    if (name)
		      Setattr((yyval.pl), "name", NewStringf("%s%d", name, n));
		    for (i = 1; i < n; i++) {
		      p = Copy((yyvsp[0].p));
		      name = Getattr(p, "name");
		      if (name)
		        Setattr(p, "name", NewStringf("%s%d", name, n-i));
		      set_nextSibling(p,(yyval.pl));
		      Delete((yyval.pl));
		      (yyval.pl) = p;
		    }
		  }
                }
#line 5640 "y.tab.c" /* yacc.c:1646  */
    break;

  case 100:
#line 2387 "parser.y" /* yacc.c:1646  */
    {
		   (yyval.node) = 0;
		   if ((yyvsp[-3].tmap).method) {
		     String *code = 0;
		     (yyval.node) = new_node("typemap");
		     Setattr((yyval.node),"method",(yyvsp[-3].tmap).method);
		     if ((yyvsp[-3].tmap).kwargs) {
		       ParmList *kw = (yyvsp[-3].tmap).kwargs;
                       code = remove_block(kw, (yyvsp[0].str));
		       Setattr((yyval.node),"kwargs", (yyvsp[-3].tmap).kwargs);
		     }
		     code = code ? code : NewString((yyvsp[0].str));
		     Setattr((yyval.node),"code", code);
		     Delete(code);
		     appendChild((yyval.node),(yyvsp[-1].p));
		   }
	       }
#line 5662 "y.tab.c" /* yacc.c:1646  */
    break;

  case 101:
#line 2404 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.node) = 0;
		 if ((yyvsp[-3].tmap).method) {
		   (yyval.node) = new_node("typemap");
		   Setattr((yyval.node),"method",(yyvsp[-3].tmap).method);
		   appendChild((yyval.node),(yyvsp[-1].p));
		 }
	       }
#line 5675 "y.tab.c" /* yacc.c:1646  */
    break;

  case 102:
#line 2412 "parser.y" /* yacc.c:1646  */
    {
		   (yyval.node) = 0;
		   if ((yyvsp[-5].tmap).method) {
		     (yyval.node) = new_node("typemapcopy");
		     Setattr((yyval.node),"method",(yyvsp[-5].tmap).method);
		     Setattr((yyval.node),"pattern", Getattr((yyvsp[-1].p),"pattern"));
		     appendChild((yyval.node),(yyvsp[-3].p));
		   }
	       }
#line 5689 "y.tab.c" /* yacc.c:1646  */
    break;

  case 103:
#line 2425 "parser.y" /* yacc.c:1646  */
    {
		 Hash *p;
		 String *name;
		 p = nextSibling((yyvsp[0].node));
		 if (p && (!Getattr(p,"value"))) {
 		   /* this is the deprecated two argument typemap form */
 		   Swig_warning(WARN_DEPRECATED_TYPEMAP_LANG,cparse_file, cparse_line,
				"Specifying the language name in %%typemap is deprecated - use #ifdef SWIG<LANG> instead.\n");
		   /* two argument typemap form */
		   name = Getattr((yyvsp[0].node),"name");
		   if (!name || (Strcmp(name,typemap_lang))) {
		     (yyval.tmap).method = 0;
		     (yyval.tmap).kwargs = 0;
		   } else {
		     (yyval.tmap).method = Getattr(p,"name");
		     (yyval.tmap).kwargs = nextSibling(p);
		   }
		 } else {
		   /* one-argument typemap-form */
		   (yyval.tmap).method = Getattr((yyvsp[0].node),"name");
		   (yyval.tmap).kwargs = p;
		 }
                }
#line 5717 "y.tab.c" /* yacc.c:1646  */
    break;

  case 104:
#line 2450 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.p) = (yyvsp[-1].p);
		 set_nextSibling((yyval.p),(yyvsp[0].p));
		}
#line 5726 "y.tab.c" /* yacc.c:1646  */
    break;

  case 105:
#line 2456 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.p) = (yyvsp[-1].p);
		 set_nextSibling((yyval.p),(yyvsp[0].p));
                }
#line 5735 "y.tab.c" /* yacc.c:1646  */
    break;

  case 106:
#line 2460 "parser.y" /* yacc.c:1646  */
    { (yyval.p) = 0;}
#line 5741 "y.tab.c" /* yacc.c:1646  */
    break;

  case 107:
#line 2463 "parser.y" /* yacc.c:1646  */
    {
                  Parm *parm;
		  SwigType_push((yyvsp[-1].type),(yyvsp[0].decl).type);
		  (yyval.p) = new_node("typemapitem");
		  parm = NewParmWithoutFileLineInfo((yyvsp[-1].type),(yyvsp[0].decl).id);
		  Setattr((yyval.p),"pattern",parm);
		  Setattr((yyval.p),"parms", (yyvsp[0].decl).parms);
		  Delete(parm);
		  /*		  $$ = NewParmWithoutFileLineInfo($1,$2.id);
				  Setattr($$,"parms",$2.parms); */
                }
#line 5757 "y.tab.c" /* yacc.c:1646  */
    break;

  case 108:
#line 2474 "parser.y" /* yacc.c:1646  */
    {
                  (yyval.p) = new_node("typemapitem");
		  Setattr((yyval.p),"pattern",(yyvsp[-1].pl));
		  /*		  Setattr($$,"multitype",$2); */
               }
#line 5767 "y.tab.c" /* yacc.c:1646  */
    break;

  case 109:
#line 2479 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.p) = new_node("typemapitem");
		 Setattr((yyval.p),"pattern", (yyvsp[-4].pl));
		 /*                 Setattr($$,"multitype",$2); */
		 Setattr((yyval.p),"parms",(yyvsp[-1].pl));
               }
#line 5778 "y.tab.c" /* yacc.c:1646  */
    break;

  case 110:
#line 2492 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.node) = new_node("types");
		   Setattr((yyval.node),"parms",(yyvsp[-2].pl));
                   if ((yyvsp[0].str))
		     Setattr((yyval.node),"convcode",NewString((yyvsp[0].str)));
               }
#line 5789 "y.tab.c" /* yacc.c:1646  */
    break;

  case 111:
#line 2504 "parser.y" /* yacc.c:1646  */
    {
                  Parm *p, *tp;
		  Node *n;
		  Node *outer_class = currentOuterClass;
		  Symtab *tscope = 0;
		  int     specialized = 0;
		  int     variadic = 0;

		  (yyval.node) = 0;

		  tscope = Swig_symbol_current();          /* Get the current scope */

		  /* If the class name is qualified, we need to create or lookup namespace entries */
		  if (!inclass) {
		    (yyvsp[-4].str) = resolve_create_node_scope((yyvsp[-4].str));
		  }
		  if (nscope_inner && Strcmp(nodeType(nscope_inner), "class") == 0) {
		    outer_class	= nscope_inner;
		  }

		  /*
		    We use the new namespace entry 'nscope' only to
		    emit the template node. The template parameters are
		    resolved in the current 'tscope'.

		    This is closer to the C++ (typedef) behavior.
		  */
		  n = Swig_cparse_template_locate((yyvsp[-4].str),(yyvsp[-2].p),tscope);

		  /* Patch the argument types to respect namespaces */
		  p = (yyvsp[-2].p);
		  while (p) {
		    SwigType *value = Getattr(p,"value");
		    if (!value) {
		      SwigType *ty = Getattr(p,"type");
		      if (ty) {
			SwigType *rty = 0;
			int reduce = template_reduce;
			if (reduce || !SwigType_ispointer(ty)) {
			  rty = Swig_symbol_typedef_reduce(ty,tscope);
			  if (!reduce) reduce = SwigType_ispointer(rty);
			}
			ty = reduce ? Swig_symbol_type_qualify(rty,tscope) : Swig_symbol_type_qualify(ty,tscope);
			Setattr(p,"type",ty);
			Delete(ty);
			Delete(rty);
		      }
		    } else {
		      value = Swig_symbol_type_qualify(value,tscope);
		      Setattr(p,"value",value);
		      Delete(value);
		    }

		    p = nextSibling(p);
		  }

		  /* Look for the template */
		  {
                    Node *nn = n;
                    Node *linklistend = 0;
                    while (nn) {
                      Node *templnode = 0;
                      if (Strcmp(nodeType(nn),"template") == 0) {
                        int nnisclass = (Strcmp(Getattr(nn,"templatetype"),"class") == 0); /* if not a templated class it is a templated function */
                        Parm *tparms = Getattr(nn,"templateparms");
                        if (!tparms) {
                          specialized = 1;
                        } else if (Getattr(tparms,"variadic") && strncmp(Char(Getattr(tparms,"variadic")), "1", 1)==0) {
                          variadic = 1;
                        }
                        if (nnisclass && !variadic && !specialized && (ParmList_len((yyvsp[-2].p)) > ParmList_len(tparms))) {
                          Swig_error(cparse_file, cparse_line, "Too many template parameters. Maximum of %d.\n", ParmList_len(tparms));
                        } else if (nnisclass && !specialized && ((ParmList_len((yyvsp[-2].p)) < (ParmList_numrequired(tparms) - (variadic?1:0))))) { /* Variadic parameter is optional */
                          Swig_error(cparse_file, cparse_line, "Not enough template parameters specified. %d required.\n", (ParmList_numrequired(tparms)-(variadic?1:0)) );
                        } else if (!nnisclass && ((ParmList_len((yyvsp[-2].p)) != ParmList_len(tparms)))) {
                          /* must be an overloaded templated method - ignore it as it is overloaded with a different number of template parameters */
                          nn = Getattr(nn,"sym:nextSibling"); /* repeat for overloaded templated functions */
                          continue;
                        } else {
			  String *tname = Copy((yyvsp[-4].str));
                          int def_supplied = 0;
                          /* Expand the template */
			  Node *templ = Swig_symbol_clookup((yyvsp[-4].str),0);
			  Parm *targs = templ ? Getattr(templ,"templateparms") : 0;

                          ParmList *temparms;
                          if (specialized) temparms = CopyParmList((yyvsp[-2].p));
                          else temparms = CopyParmList(tparms);

                          /* Create typedef's and arguments */
                          p = (yyvsp[-2].p);
                          tp = temparms;
                          if (!p && ParmList_len(p) != ParmList_len(temparms)) {
                            /* we have no template parameters supplied in %template for a template that has default args*/
                            p = tp;
                            def_supplied = 1;
                          }

                          while (p) {
                            String *value = Getattr(p,"value");
                            if (def_supplied) {
                              Setattr(p,"default","1");
                            }
                            if (value) {
                              Setattr(tp,"value",value);
                            } else {
                              SwigType *ty = Getattr(p,"type");
                              if (ty) {
                                Setattr(tp,"type",ty);
                              }
                              Delattr(tp,"value");
                            }
			    /* fix default arg values */
			    if (targs) {
			      Parm *pi = temparms;
			      Parm *ti = targs;
			      String *tv = Getattr(tp,"value");
			      if (!tv) tv = Getattr(tp,"type");
			      while(pi != tp && ti && pi) {
				String *name = Getattr(ti,"name");
				String *value = Getattr(pi,"value");
				if (!value) value = Getattr(pi,"type");
				Replaceid(tv, name, value);
				pi = nextSibling(pi);
				ti = nextSibling(ti);
			      }
			    }
                            p = nextSibling(p);
                            tp = nextSibling(tp);
                            if (!p && tp) {
                              p = tp;
                              def_supplied = 1;
                            } else if (p && !tp) { /* Variadic template - tp < p */
			      SWIG_WARN_NODE_BEGIN(nn);
                              Swig_warning(WARN_CPP11_VARIADIC_TEMPLATE,cparse_file, cparse_line,"Only the first variadic template argument is currently supported.\n");
			      SWIG_WARN_NODE_END(nn);
                              break;
                            }
                          }

                          templnode = copy_node(nn);
			  update_nested_classes(templnode); /* update classes nested withing template */
                          /* We need to set the node name based on name used to instantiate */
                          Setattr(templnode,"name",tname);
			  Delete(tname);
                          if (!specialized) {
                            Delattr(templnode,"sym:typename");
                          } else {
                            Setattr(templnode,"sym:typename","1");
                          }
			  /* for now, nested %template is allowed only in the same scope as the template declaration */
                          if ((yyvsp[-6].id) && !(nnisclass && ((outer_class && (outer_class != Getattr(nn, "nested:outer")))
			    ||(extendmode && current_class && (current_class != Getattr(nn, "nested:outer")))))) {
			    /*
			       Comment this out for 1.3.28. We need to
			       re-enable it later but first we need to
			       move %ignore from using %rename to use
			       %feature(ignore).

			       String *symname = Swig_name_make(templnode,0,$3,0,0);
			    */
			    String *symname = (yyvsp[-6].id);
                            Swig_cparse_template_expand(templnode,symname,temparms,tscope);
                            Setattr(templnode,"sym:name",symname);
                          } else {
                            static int cnt = 0;
                            String *nname = NewStringf("__dummy_%d__", cnt++);
                            Swig_cparse_template_expand(templnode,nname,temparms,tscope);
                            Setattr(templnode,"sym:name",nname);
			    Delete(nname);
                            Setattr(templnode,"feature:onlychildren", "typemap,typemapitem,typemapcopy,typedef,types,fragment");
			    if ((yyvsp[-6].id)) {
			      Swig_warning(WARN_PARSE_NESTED_TEMPLATE, cparse_file, cparse_line, "Named nested template instantiations not supported. Processing as if no name was given to %%template().\n");
			    }
                          }
                          Delattr(templnode,"templatetype");
                          Setattr(templnode,"template",nn);
                          Setfile(templnode,cparse_file);
                          Setline(templnode,cparse_line);
                          Delete(temparms);
			  if (outer_class && nnisclass) {
			    SetFlag(templnode, "nested");
			    Setattr(templnode, "nested:outer", outer_class);
			  }
                          add_symbols_copy(templnode);

                          if (Strcmp(nodeType(templnode),"class") == 0) {

                            /* Identify pure abstract methods */
                            Setattr(templnode,"abstracts", pure_abstracts(firstChild(templnode)));

                            /* Set up inheritance in symbol table */
                            {
                              Symtab  *csyms;
                              List *baselist = Getattr(templnode,"baselist");
                              csyms = Swig_symbol_current();
                              Swig_symbol_setscope(Getattr(templnode,"symtab"));
                              if (baselist) {
                                List *bases = Swig_make_inherit_list(Getattr(templnode,"name"),baselist, Namespaceprefix);
                                if (bases) {
                                  Iterator s;
                                  for (s = First(bases); s.item; s = Next(s)) {
                                    Symtab *st = Getattr(s.item,"symtab");
                                    if (st) {
				      Setfile(st,Getfile(s.item));
				      Setline(st,Getline(s.item));
                                      Swig_symbol_inherit(st);
                                    }
                                  }
				  Delete(bases);
                                }
                              }
                              Swig_symbol_setscope(csyms);
                            }

                            /* Merge in %extend methods for this class */

			    /* !!! This may be broken.  We may have to add the
			       %extend methods at the beginning of the class */
                            {
                              String *stmp = 0;
                              String *clsname;
                              Node *am;
                              if (Namespaceprefix) {
                                clsname = stmp = NewStringf("%s::%s", Namespaceprefix, Getattr(templnode,"name"));
                              } else {
                                clsname = Getattr(templnode,"name");
                              }
                              am = Getattr(Swig_extend_hash(),clsname);
                              if (am) {
                                Symtab *st = Swig_symbol_current();
                                Swig_symbol_setscope(Getattr(templnode,"symtab"));
                                /*			    Printf(stdout,"%s: %s %p %p\n", Getattr(templnode,"name"), clsname, Swig_symbol_current(), Getattr(templnode,"symtab")); */
                                Swig_extend_merge(templnode,am);
                                Swig_symbol_setscope(st);
				Swig_extend_append_previous(templnode,am);
                                Delattr(Swig_extend_hash(),clsname);
                              }
			      if (stmp) Delete(stmp);
                            }

                            /* Add to classes hash */
			    if (!classes)
			      classes = NewHash();

			    if (Namespaceprefix) {
			      String *temp = NewStringf("%s::%s", Namespaceprefix, Getattr(templnode,"name"));
			      Setattr(classes,temp,templnode);
			      Delete(temp);
			    } else {
			      String *qs = Swig_symbol_qualifiedscopename(templnode);
			      Setattr(classes, qs,templnode);
			      Delete(qs);
			    }
                          }
                        }

                        /* all the overloaded templated functions are added into a linked list */
                        if (nscope_inner) {
                          /* non-global namespace */
                          if (templnode) {
                            appendChild(nscope_inner,templnode);
			    Delete(templnode);
                            if (nscope) (yyval.node) = nscope;
                          }
                        } else {
                          /* global namespace */
                          if (!linklistend) {
                            (yyval.node) = templnode;
                          } else {
                            set_nextSibling(linklistend,templnode);
			    Delete(templnode);
                          }
                          linklistend = templnode;
                        }
                      }
                      nn = Getattr(nn,"sym:nextSibling"); /* repeat for overloaded templated functions. If a templated class there will never be a sibling. */
                    }
		  }
	          Swig_symbol_setscope(tscope);
		  Delete(Namespaceprefix);
		  Namespaceprefix = Swig_symbol_qualifiedscopename(0);
                }
#line 6077 "y.tab.c" /* yacc.c:1646  */
    break;

  case 112:
#line 2794 "parser.y" /* yacc.c:1646  */
    {
		  Swig_warning(0,cparse_file, cparse_line,"%s\n", (yyvsp[0].id));
		  (yyval.node) = 0;
               }
#line 6086 "y.tab.c" /* yacc.c:1646  */
    break;

  case 113:
#line 2804 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.node) = (yyvsp[0].node); 
                    if ((yyval.node)) {
   		      add_symbols((yyval.node));
                      default_arguments((yyval.node));
   	            }
                }
#line 6098 "y.tab.c" /* yacc.c:1646  */
    break;

  case 114:
#line 2811 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 6104 "y.tab.c" /* yacc.c:1646  */
    break;

  case 115:
#line 2812 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 6110 "y.tab.c" /* yacc.c:1646  */
    break;

  case 116:
#line 2816 "parser.y" /* yacc.c:1646  */
    {
		  if (Strcmp((yyvsp[-1].id),"C") == 0) {
		    cparse_externc = 1;
		  }
		}
#line 6120 "y.tab.c" /* yacc.c:1646  */
    break;

  case 117:
#line 2820 "parser.y" /* yacc.c:1646  */
    {
		  cparse_externc = 0;
		  if (Strcmp((yyvsp[-4].id),"C") == 0) {
		    Node *n = firstChild((yyvsp[-1].node));
		    (yyval.node) = new_node("extern");
		    Setattr((yyval.node),"name",(yyvsp[-4].id));
		    appendChild((yyval.node),n);
		    while (n) {
		      SwigType *decl = Getattr(n,"decl");
		      if (SwigType_isfunction(decl) && !Equal(Getattr(n, "storage"), "typedef")) {
			Setattr(n,"storage","externc");
		      }
		      n = nextSibling(n);
		    }
		  } else {
		     Swig_warning(WARN_PARSE_UNDEFINED_EXTERN,cparse_file, cparse_line,"Unrecognized extern type \"%s\".\n", (yyvsp[-4].id));
		    (yyval.node) = new_node("extern");
		    Setattr((yyval.node),"name",(yyvsp[-4].id));
		    appendChild((yyval.node),firstChild((yyvsp[-1].node)));
		  }
                }
#line 6146 "y.tab.c" /* yacc.c:1646  */
    break;

  case 118:
#line 2841 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.node) = (yyvsp[0].node);
		  SWIG_WARN_NODE_BEGIN((yyval.node));
		  Swig_warning(WARN_CPP11_LAMBDA, cparse_file, cparse_line, "Lambda expressions and closures are not fully supported yet.\n");
		  SWIG_WARN_NODE_END((yyval.node));
		}
#line 6157 "y.tab.c" /* yacc.c:1646  */
    break;

  case 119:
#line 2847 "parser.y" /* yacc.c:1646  */
    {
		  skip_decl();
		  (yyval.node) = new_node("using");
		  Setattr((yyval.node),"name",(yyvsp[-1].str));
		  add_symbols((yyval.node));
		  SWIG_WARN_NODE_BEGIN((yyval.node));
		  Swig_warning(WARN_CPP11_ALIAS_DECLARATION, cparse_file, cparse_line, "The 'using' keyword in type aliasing is not fully supported yet.\n");
		  SWIG_WARN_NODE_END((yyval.node));

		  (yyval.node) = 0; /* TODO - ignored for now */
		}
#line 6173 "y.tab.c" /* yacc.c:1646  */
    break;

  case 120:
#line 2858 "parser.y" /* yacc.c:1646  */
    {
		  skip_decl();
		  (yyval.node) = new_node("using");
		  Setattr((yyval.node),"uname",(yyvsp[0].id));
		  Setattr((yyval.node),"name",(yyvsp[-2].str));
		  add_symbols((yyval.node));
		  SWIG_WARN_NODE_BEGIN((yyval.node));
		  Swig_warning(WARN_CPP11_ALIAS_TEMPLATE, cparse_file, cparse_line, "The 'using' keyword in template aliasing is not fully supported yet.\n");
		  SWIG_WARN_NODE_END((yyval.node));
		}
#line 6188 "y.tab.c" /* yacc.c:1646  */
    break;

  case 121:
#line 2874 "parser.y" /* yacc.c:1646  */
    {
              (yyval.node) = new_node("cdecl");
	      if ((yyvsp[-1].dtype).qualifier) SwigType_push((yyvsp[-2].decl).type,(yyvsp[-1].dtype).qualifier);
	      Setattr((yyval.node),"type",(yyvsp[-3].type));
	      Setattr((yyval.node),"storage",(yyvsp[-4].id));
	      Setattr((yyval.node),"name",(yyvsp[-2].decl).id);
	      Setattr((yyval.node),"decl",(yyvsp[-2].decl).type);
	      Setattr((yyval.node),"parms",(yyvsp[-2].decl).parms);
	      Setattr((yyval.node),"value",(yyvsp[-1].dtype).val);
	      Setattr((yyval.node),"throws",(yyvsp[-1].dtype).throws);
	      Setattr((yyval.node),"throw",(yyvsp[-1].dtype).throwf);
	      Setattr((yyval.node),"noexcept",(yyvsp[-1].dtype).nexcept);
	      if (!(yyvsp[0].node)) {
		if (Len(scanner_ccode)) {
		  String *code = Copy(scanner_ccode);
		  Setattr((yyval.node),"code",code);
		  Delete(code);
		}
	      } else {
		Node *n = (yyvsp[0].node);
		/* Inherit attributes */
		while (n) {
		  String *type = Copy((yyvsp[-3].type));
		  Setattr(n,"type",type);
		  Setattr(n,"storage",(yyvsp[-4].id));
		  n = nextSibling(n);
		  Delete(type);
		}
	      }
	      if ((yyvsp[-1].dtype).bitfield) {
		Setattr((yyval.node),"bitfield", (yyvsp[-1].dtype).bitfield);
	      }

	      /* Look for "::" declarations (ignored) */
	      if (Strstr((yyvsp[-2].decl).id,"::")) {
                /* This is a special case. If the scope name of the declaration exactly
                   matches that of the declaration, then we will allow it. Otherwise, delete. */
                String *p = Swig_scopename_prefix((yyvsp[-2].decl).id);
		if (p) {
		  if ((Namespaceprefix && Strcmp(p,Namespaceprefix) == 0) ||
		      (inclass && Strcmp(p,Classprefix) == 0)) {
		    String *lstr = Swig_scopename_last((yyvsp[-2].decl).id);
		    Setattr((yyval.node),"name",lstr);
		    Delete(lstr);
		    set_nextSibling((yyval.node),(yyvsp[0].node));
		  } else {
		    Delete((yyval.node));
		    (yyval.node) = (yyvsp[0].node);
		  }
		  Delete(p);
		} else {
		  Delete((yyval.node));
		  (yyval.node) = (yyvsp[0].node);
		}
	      } else {
		set_nextSibling((yyval.node),(yyvsp[0].node));
	      }
           }
#line 6251 "y.tab.c" /* yacc.c:1646  */
    break;

  case 122:
#line 2934 "parser.y" /* yacc.c:1646  */
    {
              (yyval.node) = new_node("cdecl");
	      if ((yyvsp[-1].dtype).qualifier) SwigType_push((yyvsp[-4].decl).type,(yyvsp[-1].dtype).qualifier);
	      Setattr((yyval.node),"type",(yyvsp[-2].node));
	      Setattr((yyval.node),"storage",(yyvsp[-6].id));
	      Setattr((yyval.node),"name",(yyvsp[-4].decl).id);
	      Setattr((yyval.node),"decl",(yyvsp[-4].decl).type);
	      Setattr((yyval.node),"parms",(yyvsp[-4].decl).parms);
	      Setattr((yyval.node),"value",(yyvsp[-1].dtype).val);
	      Setattr((yyval.node),"throws",(yyvsp[-1].dtype).throws);
	      Setattr((yyval.node),"throw",(yyvsp[-1].dtype).throwf);
	      Setattr((yyval.node),"noexcept",(yyvsp[-1].dtype).nexcept);
	      if (!(yyvsp[0].node)) {
		if (Len(scanner_ccode)) {
		  String *code = Copy(scanner_ccode);
		  Setattr((yyval.node),"code",code);
		  Delete(code);
		}
	      } else {
		Node *n = (yyvsp[0].node);
		while (n) {
		  String *type = Copy((yyvsp[-2].node));
		  Setattr(n,"type",type);
		  Setattr(n,"storage",(yyvsp[-6].id));
		  n = nextSibling(n);
		  Delete(type);
		}
	      }
	      if ((yyvsp[-1].dtype).bitfield) {
		Setattr((yyval.node),"bitfield", (yyvsp[-1].dtype).bitfield);
	      }

	      if (Strstr((yyvsp[-4].decl).id,"::")) {
                String *p = Swig_scopename_prefix((yyvsp[-4].decl).id);
		if (p) {
		  if ((Namespaceprefix && Strcmp(p,Namespaceprefix) == 0) ||
		      (inclass && Strcmp(p,Classprefix) == 0)) {
		    String *lstr = Swig_scopename_last((yyvsp[-4].decl).id);
		    Setattr((yyval.node),"name",lstr);
		    Delete(lstr);
		    set_nextSibling((yyval.node),(yyvsp[0].node));
		  } else {
		    Delete((yyval.node));
		    (yyval.node) = (yyvsp[0].node);
		  }
		  Delete(p);
		} else {
		  Delete((yyval.node));
		  (yyval.node) = (yyvsp[0].node);
		}
	      } else {
		set_nextSibling((yyval.node),(yyvsp[0].node));
	      }
           }
#line 6310 "y.tab.c" /* yacc.c:1646  */
    break;

  case 123:
#line 2992 "parser.y" /* yacc.c:1646  */
    { 
                   (yyval.node) = 0;
                   Clear(scanner_ccode); 
               }
#line 6319 "y.tab.c" /* yacc.c:1646  */
    break;

  case 124:
#line 2996 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.node) = new_node("cdecl");
		 if ((yyvsp[-1].dtype).qualifier) SwigType_push((yyvsp[-2].decl).type,(yyvsp[-1].dtype).qualifier);
		 Setattr((yyval.node),"name",(yyvsp[-2].decl).id);
		 Setattr((yyval.node),"decl",(yyvsp[-2].decl).type);
		 Setattr((yyval.node),"parms",(yyvsp[-2].decl).parms);
		 Setattr((yyval.node),"value",(yyvsp[-1].dtype).val);
		 Setattr((yyval.node),"throws",(yyvsp[-1].dtype).throws);
		 Setattr((yyval.node),"throw",(yyvsp[-1].dtype).throwf);
		 Setattr((yyval.node),"noexcept",(yyvsp[-1].dtype).nexcept);
		 if ((yyvsp[-1].dtype).bitfield) {
		   Setattr((yyval.node),"bitfield", (yyvsp[-1].dtype).bitfield);
		 }
		 if (!(yyvsp[0].node)) {
		   if (Len(scanner_ccode)) {
		     String *code = Copy(scanner_ccode);
		     Setattr((yyval.node),"code",code);
		     Delete(code);
		   }
		 } else {
		   set_nextSibling((yyval.node),(yyvsp[0].node));
		 }
	       }
#line 6347 "y.tab.c" /* yacc.c:1646  */
    break;

  case 125:
#line 3019 "parser.y" /* yacc.c:1646  */
    { 
                   skip_balanced('{','}');
                   (yyval.node) = 0;
               }
#line 6356 "y.tab.c" /* yacc.c:1646  */
    break;

  case 126:
#line 3025 "parser.y" /* yacc.c:1646  */
    { 
                   (yyval.dtype) = (yyvsp[0].dtype); 
                   (yyval.dtype).qualifier = 0;
		   (yyval.dtype).throws = 0;
		   (yyval.dtype).throwf = 0;
		   (yyval.dtype).nexcept = 0;
              }
#line 6368 "y.tab.c" /* yacc.c:1646  */
    break;

  case 127:
#line 3032 "parser.y" /* yacc.c:1646  */
    { 
                   (yyval.dtype) = (yyvsp[0].dtype); 
		   (yyval.dtype).qualifier = (yyvsp[-1].str);
		   (yyval.dtype).throws = 0;
		   (yyval.dtype).throwf = 0;
		   (yyval.dtype).nexcept = 0;
	      }
#line 6380 "y.tab.c" /* yacc.c:1646  */
    break;

  case 128:
#line 3039 "parser.y" /* yacc.c:1646  */
    { 
		   (yyval.dtype) = (yyvsp[0].dtype); 
                   (yyval.dtype).qualifier = 0;
		   (yyval.dtype).throws = (yyvsp[-1].dtype).throws;
		   (yyval.dtype).throwf = (yyvsp[-1].dtype).throwf;
		   (yyval.dtype).nexcept = (yyvsp[-1].dtype).nexcept;
              }
#line 6392 "y.tab.c" /* yacc.c:1646  */
    break;

  case 129:
#line 3046 "parser.y" /* yacc.c:1646  */
    { 
                   (yyval.dtype) = (yyvsp[0].dtype); 
                   (yyval.dtype).qualifier = (yyvsp[-2].str);
		   (yyval.dtype).throws = (yyvsp[-1].dtype).throws;
		   (yyval.dtype).throwf = (yyvsp[-1].dtype).throwf;
		   (yyval.dtype).nexcept = (yyvsp[-1].dtype).nexcept;
              }
#line 6404 "y.tab.c" /* yacc.c:1646  */
    break;

  case 130:
#line 3055 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].type); }
#line 6410 "y.tab.c" /* yacc.c:1646  */
    break;

  case 131:
#line 3056 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].type); }
#line 6416 "y.tab.c" /* yacc.c:1646  */
    break;

  case 132:
#line 3057 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].type); }
#line 6422 "y.tab.c" /* yacc.c:1646  */
    break;

  case 133:
#line 3058 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = NewStringf("%s%s",(yyvsp[-1].type),(yyvsp[0].id)); }
#line 6428 "y.tab.c" /* yacc.c:1646  */
    break;

  case 134:
#line 3059 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].type); }
#line 6434 "y.tab.c" /* yacc.c:1646  */
    break;

  case 135:
#line 3060 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].str); }
#line 6440 "y.tab.c" /* yacc.c:1646  */
    break;

  case 136:
#line 3061 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].type); }
#line 6446 "y.tab.c" /* yacc.c:1646  */
    break;

  case 137:
#line 3072 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.node) = new_node("lambda");
		  Setattr((yyval.node),"name",(yyvsp[-8].str));
		  add_symbols((yyval.node));
	        }
#line 6456 "y.tab.c" /* yacc.c:1646  */
    break;

  case 138:
#line 3077 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.node) = new_node("lambda");
		  Setattr((yyval.node),"name",(yyvsp[-10].str));
		  add_symbols((yyval.node));
		}
#line 6466 "y.tab.c" /* yacc.c:1646  */
    break;

  case 139:
#line 3082 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.node) = new_node("lambda");
		  Setattr((yyval.node),"name",(yyvsp[-4].str));
		  add_symbols((yyval.node));
		}
#line 6476 "y.tab.c" /* yacc.c:1646  */
    break;

  case 140:
#line 3089 "parser.y" /* yacc.c:1646  */
    {
		  skip_balanced('[',']');
		  (yyval.node) = 0;
	        }
#line 6485 "y.tab.c" /* yacc.c:1646  */
    break;

  case 141:
#line 3095 "parser.y" /* yacc.c:1646  */
    {
		  skip_balanced('{','}');
		  (yyval.node) = 0;
		}
#line 6494 "y.tab.c" /* yacc.c:1646  */
    break;

  case 142:
#line 3100 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.pl) = 0;
		}
#line 6502 "y.tab.c" /* yacc.c:1646  */
    break;

  case 143:
#line 3103 "parser.y" /* yacc.c:1646  */
    {
		  skip_balanced('(',')');
		}
#line 6510 "y.tab.c" /* yacc.c:1646  */
    break;

  case 144:
#line 3105 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.pl) = 0;
		}
#line 6518 "y.tab.c" /* yacc.c:1646  */
    break;

  case 145:
#line 3116 "parser.y" /* yacc.c:1646  */
    {
		   (yyval.node) = (char *)"enum";
	      }
#line 6526 "y.tab.c" /* yacc.c:1646  */
    break;

  case 146:
#line 3119 "parser.y" /* yacc.c:1646  */
    {
		   (yyval.node) = (char *)"enum class";
	      }
#line 6534 "y.tab.c" /* yacc.c:1646  */
    break;

  case 147:
#line 3122 "parser.y" /* yacc.c:1646  */
    {
		   (yyval.node) = (char *)"enum struct";
	      }
#line 6542 "y.tab.c" /* yacc.c:1646  */
    break;

  case 148:
#line 3131 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.node) = (yyvsp[0].type);
              }
#line 6550 "y.tab.c" /* yacc.c:1646  */
    break;

  case 149:
#line 3134 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 6556 "y.tab.c" /* yacc.c:1646  */
    break;

  case 150:
#line 3141 "parser.y" /* yacc.c:1646  */
    {
		   SwigType *ty = 0;
		   int scopedenum = (yyvsp[-2].id) && !Equal((yyvsp[-3].node), "enum");
		   (yyval.node) = new_node("enumforward");
		   ty = NewStringf("enum %s", (yyvsp[-2].id));
		   Setattr((yyval.node),"enumkey",(yyvsp[-3].node));
		   if (scopedenum)
		     SetFlag((yyval.node), "scopedenum");
		   Setattr((yyval.node),"name",(yyvsp[-2].id));
		   Setattr((yyval.node),"inherit",(yyvsp[-1].node));
		   Setattr((yyval.node),"type",ty);
		   Setattr((yyval.node),"sym:weak", "1");
		   add_symbols((yyval.node));
	      }
#line 6575 "y.tab.c" /* yacc.c:1646  */
    break;

  case 151:
#line 3163 "parser.y" /* yacc.c:1646  */
    {
		  SwigType *ty = 0;
		  int scopedenum = (yyvsp[-5].id) && !Equal((yyvsp[-6].node), "enum");
                  (yyval.node) = new_node("enum");
		  ty = NewStringf("enum %s", (yyvsp[-5].id));
		  Setattr((yyval.node),"enumkey",(yyvsp[-6].node));
		  if (scopedenum)
		    SetFlag((yyval.node), "scopedenum");
		  Setattr((yyval.node),"name",(yyvsp[-5].id));
		  Setattr((yyval.node),"inherit",(yyvsp[-4].node));
		  Setattr((yyval.node),"type",ty);
		  appendChild((yyval.node),(yyvsp[-2].node));
		  add_symbols((yyval.node));      /* Add to tag space */

		  if (scopedenum) {
		    Swig_symbol_newscope();
		    Swig_symbol_setscopename((yyvsp[-5].id));
		    Delete(Namespaceprefix);
		    Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		  }

		  add_symbols((yyvsp[-2].node));      /* Add enum values to appropriate enum or enum class scope */

		  if (scopedenum) {
		    Setattr((yyval.node),"symtab", Swig_symbol_popscope());
		    Delete(Namespaceprefix);
		    Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		  }
               }
#line 6609 "y.tab.c" /* yacc.c:1646  */
    break;

  case 152:
#line 3192 "parser.y" /* yacc.c:1646  */
    {
		 Node *n;
		 SwigType *ty = 0;
		 String   *unnamed = 0;
		 int       unnamedinstance = 0;
		 int scopedenum = (yyvsp[-7].id) && !Equal((yyvsp[-8].node), "enum");

		 (yyval.node) = new_node("enum");
		 Setattr((yyval.node),"enumkey",(yyvsp[-8].node));
		 if (scopedenum)
		   SetFlag((yyval.node), "scopedenum");
		 Setattr((yyval.node),"inherit",(yyvsp[-6].node));
		 if ((yyvsp[-7].id)) {
		   Setattr((yyval.node),"name",(yyvsp[-7].id));
		   ty = NewStringf("enum %s", (yyvsp[-7].id));
		 } else if ((yyvsp[-2].decl).id) {
		   unnamed = make_unnamed();
		   ty = NewStringf("enum %s", unnamed);
		   Setattr((yyval.node),"unnamed",unnamed);
                   /* name is not set for unnamed enum instances, e.g. enum { foo } Instance; */
		   if ((yyvsp[-9].id) && Cmp((yyvsp[-9].id),"typedef") == 0) {
		     Setattr((yyval.node),"name",(yyvsp[-2].decl).id);
                   } else {
                     unnamedinstance = 1;
                   }
		   Setattr((yyval.node),"storage",(yyvsp[-9].id));
		 }
		 if ((yyvsp[-2].decl).id && Cmp((yyvsp[-9].id),"typedef") == 0) {
		   Setattr((yyval.node),"tdname",(yyvsp[-2].decl).id);
                   Setattr((yyval.node),"allows_typedef","1");
                 }
		 appendChild((yyval.node),(yyvsp[-4].node));
		 n = new_node("cdecl");
		 Setattr(n,"type",ty);
		 Setattr(n,"name",(yyvsp[-2].decl).id);
		 Setattr(n,"storage",(yyvsp[-9].id));
		 Setattr(n,"decl",(yyvsp[-2].decl).type);
		 Setattr(n,"parms",(yyvsp[-2].decl).parms);
		 Setattr(n,"unnamed",unnamed);

                 if (unnamedinstance) {
		   SwigType *cty = NewString("enum ");
		   Setattr((yyval.node),"type",cty);
		   SetFlag((yyval.node),"unnamedinstance");
		   SetFlag(n,"unnamedinstance");
		   Delete(cty);
                 }
		 if ((yyvsp[0].node)) {
		   Node *p = (yyvsp[0].node);
		   set_nextSibling(n,p);
		   while (p) {
		     SwigType *cty = Copy(ty);
		     Setattr(p,"type",cty);
		     Setattr(p,"unnamed",unnamed);
		     Setattr(p,"storage",(yyvsp[-9].id));
		     Delete(cty);
		     p = nextSibling(p);
		   }
		 } else {
		   if (Len(scanner_ccode)) {
		     String *code = Copy(scanner_ccode);
		     Setattr(n,"code",code);
		     Delete(code);
		   }
		 }

                 /* Ensure that typedef enum ABC {foo} XYZ; uses XYZ for sym:name, like structs.
                  * Note that class_rename/yyrename are bit of a mess so used this simple approach to change the name. */
                 if ((yyvsp[-2].decl).id && (yyvsp[-7].id) && Cmp((yyvsp[-9].id),"typedef") == 0) {
		   String *name = NewString((yyvsp[-2].decl).id);
                   Setattr((yyval.node), "parser:makename", name);
		   Delete(name);
                 }

		 add_symbols((yyval.node));       /* Add enum to tag space */
		 set_nextSibling((yyval.node),n);
		 Delete(n);

		 if (scopedenum) {
		   Swig_symbol_newscope();
		   Swig_symbol_setscopename((yyvsp[-7].id));
		   Delete(Namespaceprefix);
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		 }

		 add_symbols((yyvsp[-4].node));      /* Add enum values to appropriate enum or enum class scope */

		 if (scopedenum) {
		   Setattr((yyval.node),"symtab", Swig_symbol_popscope());
		   Delete(Namespaceprefix);
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		 }

	         add_symbols(n);
		 Delete(unnamed);
	       }
#line 6710 "y.tab.c" /* yacc.c:1646  */
    break;

  case 153:
#line 3290 "parser.y" /* yacc.c:1646  */
    {
                   /* This is a sick hack.  If the ctor_end has parameters,
                      and the parms parameter only has 1 parameter, this
                      could be a declaration of the form:

                         type (id)(parms)

			 Otherwise it's an error. */
                    int err = 0;
                    (yyval.node) = 0;

		    if ((ParmList_len((yyvsp[-2].pl)) == 1) && (!Swig_scopename_check((yyvsp[-4].type)))) {
		      SwigType *ty = Getattr((yyvsp[-2].pl),"type");
		      String *name = Getattr((yyvsp[-2].pl),"name");
		      err = 1;
		      if (!name) {
			(yyval.node) = new_node("cdecl");
			Setattr((yyval.node),"type",(yyvsp[-4].type));
			Setattr((yyval.node),"storage",(yyvsp[-5].id));
			Setattr((yyval.node),"name",ty);

			if ((yyvsp[0].decl).have_parms) {
			  SwigType *decl = NewStringEmpty();
			  SwigType_add_function(decl,(yyvsp[0].decl).parms);
			  Setattr((yyval.node),"decl",decl);
			  Setattr((yyval.node),"parms",(yyvsp[0].decl).parms);
			  if (Len(scanner_ccode)) {
			    String *code = Copy(scanner_ccode);
			    Setattr((yyval.node),"code",code);
			    Delete(code);
			  }
			}
			if ((yyvsp[0].decl).defarg) {
			  Setattr((yyval.node),"value",(yyvsp[0].decl).defarg);
			}
			Setattr((yyval.node),"throws",(yyvsp[0].decl).throws);
			Setattr((yyval.node),"throw",(yyvsp[0].decl).throwf);
			Setattr((yyval.node),"noexcept",(yyvsp[0].decl).nexcept);
			err = 0;
		      }
		    }
		    if (err) {
		      Swig_error(cparse_file,cparse_line,"Syntax error in input(2).\n");
		      exit(1);
		    }
                }
#line 6761 "y.tab.c" /* yacc.c:1646  */
    break;

  case 154:
#line 3342 "parser.y" /* yacc.c:1646  */
    {  (yyval.node) = (yyvsp[0].node); }
#line 6767 "y.tab.c" /* yacc.c:1646  */
    break;

  case 155:
#line 3343 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 6773 "y.tab.c" /* yacc.c:1646  */
    break;

  case 156:
#line 3344 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 6779 "y.tab.c" /* yacc.c:1646  */
    break;

  case 157:
#line 3345 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 6785 "y.tab.c" /* yacc.c:1646  */
    break;

  case 158:
#line 3346 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 6791 "y.tab.c" /* yacc.c:1646  */
    break;

  case 159:
#line 3347 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 6797 "y.tab.c" /* yacc.c:1646  */
    break;

  case 160:
#line 3352 "parser.y" /* yacc.c:1646  */
    {
                   String *prefix;
                   List *bases = 0;
		   Node *scope = 0;
		   String *code;
		   (yyval.node) = new_node("class");
		   Setline((yyval.node),cparse_start_line);
		   Setattr((yyval.node),"kind",(yyvsp[-3].id));
		   if ((yyvsp[-1].bases)) {
		     Setattr((yyval.node),"baselist", Getattr((yyvsp[-1].bases),"public"));
		     Setattr((yyval.node),"protectedbaselist", Getattr((yyvsp[-1].bases),"protected"));
		     Setattr((yyval.node),"privatebaselist", Getattr((yyvsp[-1].bases),"private"));
		   }
		   Setattr((yyval.node),"allows_typedef","1");

		   /* preserve the current scope */
		   Setattr((yyval.node),"prev_symtab",Swig_symbol_current());
		  
		   /* If the class name is qualified.  We need to create or lookup namespace/scope entries */
		   scope = resolve_create_node_scope((yyvsp[-2].str));
		   /* save nscope_inner to the class - it may be overwritten in nested classes*/
		   Setattr((yyval.node), "nested:innerscope", nscope_inner);
		   Setattr((yyval.node), "nested:nscope", nscope);
		   Setfile(scope,cparse_file);
		   Setline(scope,cparse_line);
		   (yyvsp[-2].str) = scope;
		   Setattr((yyval.node),"name",(yyvsp[-2].str));

		   if (currentOuterClass) {
		     SetFlag((yyval.node), "nested");
		     Setattr((yyval.node), "nested:outer", currentOuterClass);
		     set_access_mode((yyval.node));
		   }
		   Swig_features_get(Swig_cparse_features(), Namespaceprefix, Getattr((yyval.node), "name"), 0, (yyval.node));
		   /* save yyrename to the class attribute, to be used later in add_symbols()*/
		   Setattr((yyval.node), "class_rename", make_name((yyval.node), (yyvsp[-2].str), 0));
		   Setattr((yyval.node), "Classprefix", (yyvsp[-2].str));
		   Classprefix = NewString((yyvsp[-2].str));
		   /* Deal with inheritance  */
		   if ((yyvsp[-1].bases))
		     bases = Swig_make_inherit_list((yyvsp[-2].str),Getattr((yyvsp[-1].bases),"public"),Namespaceprefix);
		   prefix = SwigType_istemplate_templateprefix((yyvsp[-2].str));
		   if (prefix) {
		     String *fbase, *tbase;
		     if (Namespaceprefix) {
		       fbase = NewStringf("%s::%s", Namespaceprefix,(yyvsp[-2].str));
		       tbase = NewStringf("%s::%s", Namespaceprefix, prefix);
		     } else {
		       fbase = Copy((yyvsp[-2].str));
		       tbase = Copy(prefix);
		     }
		     Swig_name_inherit(tbase,fbase);
		     Delete(fbase);
		     Delete(tbase);
		   }
                   if (strcmp((yyvsp[-3].id),"class") == 0) {
		     cplus_mode = CPLUS_PRIVATE;
		   } else {
		     cplus_mode = CPLUS_PUBLIC;
		   }
		   if (!cparse_cplusplus) {
		     set_scope_to_global();
		   }
		   Swig_symbol_newscope();
		   Swig_symbol_setscopename((yyvsp[-2].str));
		   Swig_inherit_base_symbols(bases);
		   Delete(Namespaceprefix);
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		   cparse_start_line = cparse_line;

		   /* If there are active template parameters, we need to make sure they are
                      placed in the class symbol table so we can catch shadows */

		   if (template_parameters) {
		     Parm *tp = template_parameters;
		     while(tp) {
		       String *tpname = Copy(Getattr(tp,"name"));
		       Node *tn = new_node("templateparm");
		       Setattr(tn,"name",tpname);
		       Swig_symbol_cadd(tpname,tn);
		       tp = nextSibling(tp);
		       Delete(tpname);
		     }
		   }
		   Delete(prefix);
		   inclass = 1;
		   currentOuterClass = (yyval.node);
		   if (cparse_cplusplusout) {
		     /* save the structure declaration to declare it in global scope for C++ to see */
		     code = get_raw_text_balanced('{', '}');
		     Setattr((yyval.node), "code", code);
		     Delete(code);
		   }
               }
#line 6896 "y.tab.c" /* yacc.c:1646  */
    break;

  case 161:
#line 3445 "parser.y" /* yacc.c:1646  */
    {
		   Node *p;
		   SwigType *ty;
		   Symtab *cscope;
		   Node *am = 0;
		   String *scpname = 0;
		   (void) (yyvsp[-3].node);
		   (yyval.node) = currentOuterClass;
		   currentOuterClass = Getattr((yyval.node), "nested:outer");
		   nscope_inner = Getattr((yyval.node), "nested:innerscope");
		   nscope = Getattr((yyval.node), "nested:nscope");
		   Delattr((yyval.node), "nested:innerscope");
		   Delattr((yyval.node), "nested:nscope");
		   if (nscope_inner && Strcmp(nodeType(nscope_inner), "class") == 0) { /* actual parent class for this class */
		     Node* forward_declaration = Swig_symbol_clookup_no_inherit(Getattr((yyval.node),"name"), Getattr(nscope_inner, "symtab"));
		     if (forward_declaration) {
		       Setattr((yyval.node), "access", Getattr(forward_declaration, "access"));
		     }
		     Setattr((yyval.node), "nested:outer", nscope_inner);
		     SetFlag((yyval.node), "nested");
                   }
		   if (!currentOuterClass)
		     inclass = 0;
		   cscope = Getattr((yyval.node), "prev_symtab");
		   Delattr((yyval.node), "prev_symtab");
		   
		   /* Check for pure-abstract class */
		   Setattr((yyval.node),"abstracts", pure_abstracts((yyvsp[-2].node)));
		   
		   /* This bit of code merges in a previously defined %extend directive (if any) */
		   {
		     String *clsname = Swig_symbol_qualifiedscopename(0);
		     am = Getattr(Swig_extend_hash(), clsname);
		     if (am) {
		       Swig_extend_merge((yyval.node), am);
		       Delattr(Swig_extend_hash(), clsname);
		     }
		     Delete(clsname);
		   }
		   if (!classes) classes = NewHash();
		   scpname = Swig_symbol_qualifiedscopename(0);
		   Setattr(classes, scpname, (yyval.node));

		   appendChild((yyval.node), (yyvsp[-2].node));
		   
		   if (am) 
		     Swig_extend_append_previous((yyval.node), am);

		   p = (yyvsp[0].node);
		   if (p && !nscope_inner) {
		     if (!cparse_cplusplus && currentOuterClass)
		       appendChild(currentOuterClass, p);
		     else
		      appendSibling((yyval.node), p);
		   }
		   
		   if (nscope_inner) {
		     ty = NewString(scpname); /* if the class is declared out of scope, let the declarator use fully qualified type*/
		   } else if (cparse_cplusplus && !cparse_externc) {
		     ty = NewString((yyvsp[-6].str));
		   } else {
		     ty = NewStringf("%s %s", (yyvsp[-7].id), (yyvsp[-6].str));
		   }
		   while (p) {
		     Setattr(p, "storage", (yyvsp[-8].id));
		     Setattr(p, "type" ,ty);
		     if (!cparse_cplusplus && currentOuterClass && (!Getattr(currentOuterClass, "name"))) {
		       SetFlag(p, "hasconsttype");
		       SetFlag(p, "feature:immutable");
		     }
		     p = nextSibling(p);
		   }
		   if ((yyvsp[0].node) && Cmp((yyvsp[-8].id),"typedef") == 0)
		     add_typedef_name((yyval.node), (yyvsp[0].node), (yyvsp[-6].str), cscope, scpname);
		   Delete(scpname);

		   if (cplus_mode != CPLUS_PUBLIC) {
		   /* we 'open' the class at the end, to allow %template
		      to add new members */
		     Node *pa = new_node("access");
		     Setattr(pa, "kind", "public");
		     cplus_mode = CPLUS_PUBLIC;
		     appendChild((yyval.node), pa);
		     Delete(pa);
		   }
		   if (currentOuterClass)
		     restore_access_mode((yyval.node));
		   Setattr((yyval.node), "symtab", Swig_symbol_popscope());
		   Classprefix = Getattr((yyval.node), "Classprefix");
		   Delattr((yyval.node), "Classprefix");
		   Delete(Namespaceprefix);
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		   if (cplus_mode == CPLUS_PRIVATE) {
		     (yyval.node) = 0; /* skip private nested classes */
		   } else if (cparse_cplusplus && currentOuterClass && ignore_nested_classes && !GetFlag((yyval.node), "feature:flatnested")) {
		     (yyval.node) = nested_forward_declaration((yyvsp[-8].id), (yyvsp[-7].id), (yyvsp[-6].str), Copy((yyvsp[-6].str)), (yyvsp[0].node));
		   } else if (nscope_inner) {
		     /* this is tricky */
		     /* we add the declaration in the original namespace */
		     if (Strcmp(nodeType(nscope_inner), "class") == 0 && cparse_cplusplus && ignore_nested_classes && !GetFlag((yyval.node), "feature:flatnested"))
		       (yyval.node) = nested_forward_declaration((yyvsp[-8].id), (yyvsp[-7].id), (yyvsp[-6].str), Copy((yyvsp[-6].str)), (yyvsp[0].node));
		     appendChild(nscope_inner, (yyval.node));
		     Swig_symbol_setscope(Getattr(nscope_inner, "symtab"));
		     Delete(Namespaceprefix);
		     Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		     yyrename = Copy(Getattr((yyval.node), "class_rename"));
		     add_symbols((yyval.node));
		     Delattr((yyval.node), "class_rename");
		     /* but the variable definition in the current scope */
		     Swig_symbol_setscope(cscope);
		     Delete(Namespaceprefix);
		     Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		     add_symbols((yyvsp[0].node));
		     if (nscope) {
		       (yyval.node) = nscope; /* here we return recreated namespace tower instead of the class itself */
		       if ((yyvsp[0].node)) {
			 appendSibling((yyval.node), (yyvsp[0].node));
		       }
		     } else if (!SwigType_istemplate(ty) && template_parameters == 0) { /* for tempalte we need the class itself */
		       (yyval.node) = (yyvsp[0].node);
		     }
		   } else {
		     Delete(yyrename);
		     yyrename = 0;
		     if (!cparse_cplusplus && currentOuterClass) { /* nested C structs go into global scope*/
		       Node *outer = currentOuterClass;
		       while (Getattr(outer, "nested:outer"))
			 outer = Getattr(outer, "nested:outer");
		       appendSibling(outer, (yyval.node));
		       add_symbols((yyvsp[0].node));
		       set_scope_to_global();
		       Delete(Namespaceprefix);
		       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		       yyrename = Copy(Getattr((yyval.node), "class_rename"));
		       add_symbols((yyval.node));
		       if (!cparse_cplusplusout)
			 Delattr((yyval.node), "nested:outer");
		       Delattr((yyval.node), "class_rename");
		       (yyval.node) = 0;
		     } else {
		       yyrename = Copy(Getattr((yyval.node), "class_rename"));
		       add_symbols((yyval.node));
		       add_symbols((yyvsp[0].node));
		       Delattr((yyval.node), "class_rename");
		     }
		   }
		   Delete(ty);
		   Swig_symbol_setscope(cscope);
		   Delete(Namespaceprefix);
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	       }
#line 7052 "y.tab.c" /* yacc.c:1646  */
    break;

  case 162:
#line 3599 "parser.y" /* yacc.c:1646  */
    {
	       String *unnamed;
	       String *code;
	       unnamed = make_unnamed();
	       (yyval.node) = new_node("class");
	       Setline((yyval.node),cparse_start_line);
	       Setattr((yyval.node),"kind",(yyvsp[-2].id));
	       if ((yyvsp[-1].bases)) {
		 Setattr((yyval.node),"baselist", Getattr((yyvsp[-1].bases),"public"));
		 Setattr((yyval.node),"protectedbaselist", Getattr((yyvsp[-1].bases),"protected"));
		 Setattr((yyval.node),"privatebaselist", Getattr((yyvsp[-1].bases),"private"));
	       }
	       Setattr((yyval.node),"storage",(yyvsp[-3].id));
	       Setattr((yyval.node),"unnamed",unnamed);
	       Setattr((yyval.node),"allows_typedef","1");
	       if (currentOuterClass) {
		 SetFlag((yyval.node), "nested");
		 Setattr((yyval.node), "nested:outer", currentOuterClass);
		 set_access_mode((yyval.node));
	       }
	       Swig_features_get(Swig_cparse_features(), Namespaceprefix, 0, 0, (yyval.node));
	       /* save yyrename to the class attribute, to be used later in add_symbols()*/
	       Setattr((yyval.node), "class_rename", make_name((yyval.node),0,0));
	       if (strcmp((yyvsp[-2].id),"class") == 0) {
		 cplus_mode = CPLUS_PRIVATE;
	       } else {
		 cplus_mode = CPLUS_PUBLIC;
	       }
	       Swig_symbol_newscope();
	       cparse_start_line = cparse_line;
	       currentOuterClass = (yyval.node);
	       inclass = 1;
	       Classprefix = NewStringEmpty();
	       Delete(Namespaceprefix);
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	       /* save the structure declaration to make a typedef for it later*/
	       code = get_raw_text_balanced('{', '}');
	       Setattr((yyval.node), "code", code);
	       Delete(code);
	     }
#line 7097 "y.tab.c" /* yacc.c:1646  */
    break;

  case 163:
#line 3638 "parser.y" /* yacc.c:1646  */
    {
	       String *unnamed;
               List *bases = 0;
	       String *name = 0;
	       Node *n;
	       Classprefix = 0;
	       (yyval.node) = currentOuterClass;
	       currentOuterClass = Getattr((yyval.node), "nested:outer");
	       if (!currentOuterClass)
		 inclass = 0;
	       else
		 restore_access_mode((yyval.node));
	       unnamed = Getattr((yyval.node),"unnamed");
               /* Check for pure-abstract class */
	       Setattr((yyval.node),"abstracts", pure_abstracts((yyvsp[-2].node)));
	       n = (yyvsp[0].node);
	       if (cparse_cplusplus && currentOuterClass && ignore_nested_classes && !GetFlag((yyval.node), "feature:flatnested")) {
		 String *name = n ? Copy(Getattr(n, "name")) : 0;
		 (yyval.node) = nested_forward_declaration((yyvsp[-7].id), (yyvsp[-6].id), 0, name, n);
		 Swig_symbol_popscope();
	         Delete(Namespaceprefix);
		 Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	       } else if (n) {
	         appendSibling((yyval.node),n);
		 /* If a proper typedef name was given, we'll use it to set the scope name */
		 name = try_to_find_a_name_for_unnamed_structure((yyvsp[-7].id), n);
		 if (name) {
		   String *scpname = 0;
		   SwigType *ty;
		   Setattr((yyval.node),"tdname",name);
		   Setattr((yyval.node),"name",name);
		   Swig_symbol_setscopename(name);
		   if ((yyvsp[-5].bases))
		     bases = Swig_make_inherit_list(name,Getattr((yyvsp[-5].bases),"public"),Namespaceprefix);
		   Swig_inherit_base_symbols(bases);

		     /* If a proper name was given, we use that as the typedef, not unnamed */
		   Clear(unnamed);
		   Append(unnamed, name);
		   if (cparse_cplusplus && !cparse_externc) {
		     ty = NewString(name);
		   } else {
		     ty = NewStringf("%s %s", (yyvsp[-6].id),name);
		   }
		   while (n) {
		     Setattr(n,"storage",(yyvsp[-7].id));
		     Setattr(n, "type", ty);
		     if (!cparse_cplusplus && currentOuterClass && (!Getattr(currentOuterClass, "name"))) {
		       SetFlag(n,"hasconsttype");
		       SetFlag(n,"feature:immutable");
		     }
		     n = nextSibling(n);
		   }
		   n = (yyvsp[0].node);

		   /* Check for previous extensions */
		   {
		     String *clsname = Swig_symbol_qualifiedscopename(0);
		     Node *am = Getattr(Swig_extend_hash(),clsname);
		     if (am) {
		       /* Merge the extension into the symbol table */
		       Swig_extend_merge((yyval.node),am);
		       Swig_extend_append_previous((yyval.node),am);
		       Delattr(Swig_extend_hash(),clsname);
		     }
		     Delete(clsname);
		   }
		   if (!classes) classes = NewHash();
		   scpname = Swig_symbol_qualifiedscopename(0);
		   Setattr(classes,scpname,(yyval.node));
		   Delete(scpname);
		 } else { /* no suitable name was found for a struct */
		   Setattr((yyval.node), "nested:unnamed", Getattr(n, "name")); /* save the name of the first declarator for later use in name generation*/
		   while (n) { /* attach unnamed struct to the declarators, so that they would receive proper type later*/
		     Setattr(n, "nested:unnamedtype", (yyval.node));
		     Setattr(n, "storage", (yyvsp[-7].id));
		     n = nextSibling(n);
		   }
		   n = (yyvsp[0].node);
		   Swig_symbol_setscopename("<unnamed>");
		 }
		 appendChild((yyval.node),(yyvsp[-2].node));
		 /* Pop the scope */
		 Setattr((yyval.node),"symtab",Swig_symbol_popscope());
		 if (name) {
		   Delete(yyrename);
		   yyrename = Copy(Getattr((yyval.node), "class_rename"));
		   Delete(Namespaceprefix);
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		   add_symbols((yyval.node));
		   add_symbols(n);
		   Delattr((yyval.node), "class_rename");
		 }else if (cparse_cplusplus)
		   (yyval.node) = 0; /* ignore unnamed structs for C++ */
	         Delete(unnamed);
	       } else { /* unnamed struct w/o declarator*/
		 Swig_symbol_popscope();
	         Delete(Namespaceprefix);
		 Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		 add_symbols((yyvsp[-2].node));
		 Delete((yyval.node));
		 (yyval.node) = (yyvsp[-2].node); /* pass member list to outer class/namespace (instead of self)*/
	       }
              }
#line 7206 "y.tab.c" /* yacc.c:1646  */
    break;

  case 164:
#line 3744 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 7212 "y.tab.c" /* yacc.c:1646  */
    break;

  case 165:
#line 3745 "parser.y" /* yacc.c:1646  */
    {
                        (yyval.node) = new_node("cdecl");
                        Setattr((yyval.node),"name",(yyvsp[-2].decl).id);
                        Setattr((yyval.node),"decl",(yyvsp[-2].decl).type);
                        Setattr((yyval.node),"parms",(yyvsp[-2].decl).parms);
			set_nextSibling((yyval.node),(yyvsp[0].node));
                    }
#line 7224 "y.tab.c" /* yacc.c:1646  */
    break;

  case 166:
#line 3757 "parser.y" /* yacc.c:1646  */
    {
              if ((yyvsp[-3].id) && (Strcmp((yyvsp[-3].id),"friend") == 0)) {
		/* Ignore */
                (yyval.node) = 0; 
	      } else {
		(yyval.node) = new_node("classforward");
		Setattr((yyval.node),"kind",(yyvsp[-2].id));
		Setattr((yyval.node),"name",(yyvsp[-1].str));
		Setattr((yyval.node),"sym:weak", "1");
		add_symbols((yyval.node));
	      }
             }
#line 7241 "y.tab.c" /* yacc.c:1646  */
    break;

  case 167:
#line 3775 "parser.y" /* yacc.c:1646  */
    { 
		   if (currentOuterClass)
		     Setattr(currentOuterClass, "template_parameters", template_parameters);
		    template_parameters = (yyvsp[-1].tparms); 
		  }
#line 7251 "y.tab.c" /* yacc.c:1646  */
    break;

  case 168:
#line 3779 "parser.y" /* yacc.c:1646  */
    {
			String *tname = 0;
			int     error = 0;

			/* check if we get a namespace node with a class declaration, and retrieve the class */
			Symtab *cscope = Swig_symbol_current();
			Symtab *sti = 0;
			Node *ntop = (yyvsp[0].node);
			Node *ni = ntop;
			SwigType *ntype = ni ? nodeType(ni) : 0;
			while (ni && Strcmp(ntype,"namespace") == 0) {
			  sti = Getattr(ni,"symtab");
			  ni = firstChild(ni);
			  ntype = nodeType(ni);
			}
			if (sti) {
			  Swig_symbol_setscope(sti);
			  Delete(Namespaceprefix);
			  Namespaceprefix = Swig_symbol_qualifiedscopename(0);
			  (yyvsp[0].node) = ni;
			}

			(yyval.node) = (yyvsp[0].node);
			if ((yyval.node)) tname = Getattr((yyval.node),"name");
			
			/* Check if the class is a template specialization */
			if (((yyval.node)) && (Strchr(tname,'<')) && (!is_operator(tname))) {
			  /* If a specialization.  Check if defined. */
			  Node *tempn = 0;
			  {
			    String *tbase = SwigType_templateprefix(tname);
			    tempn = Swig_symbol_clookup_local(tbase,0);
			    if (!tempn || (Strcmp(nodeType(tempn),"template") != 0)) {
			      SWIG_WARN_NODE_BEGIN(tempn);
			      Swig_warning(WARN_PARSE_TEMPLATE_SP_UNDEF, Getfile((yyval.node)),Getline((yyval.node)),"Specialization of non-template '%s'.\n", tbase);
			      SWIG_WARN_NODE_END(tempn);
			      tempn = 0;
			      error = 1;
			    }
			    Delete(tbase);
			  }
			  Setattr((yyval.node),"specialization","1");
			  Setattr((yyval.node),"templatetype",nodeType((yyval.node)));
			  set_nodeType((yyval.node),"template");
			  /* Template partial specialization */
			  if (tempn && ((yyvsp[-3].tparms)) && ((yyvsp[0].node))) {
			    List   *tlist;
			    String *targs = SwigType_templateargs(tname);
			    tlist = SwigType_parmlist(targs);
			    /*			  Printf(stdout,"targs = '%s' %s\n", targs, tlist); */
			    if (!Getattr((yyval.node),"sym:weak")) {
			      Setattr((yyval.node),"sym:typename","1");
			    }
			    
			    if (Len(tlist) != ParmList_len(Getattr(tempn,"templateparms"))) {
			      Swig_error(Getfile((yyval.node)),Getline((yyval.node)),"Inconsistent argument count in template partial specialization. %d %d\n", Len(tlist), ParmList_len(Getattr(tempn,"templateparms")));
			      
			    } else {

			    /* This code builds the argument list for the partial template
			       specialization.  This is a little hairy, but the idea is as
			       follows:

			       $3 contains a list of arguments supplied for the template.
			       For example template<class T>.

			       tlist is a list of the specialization arguments--which may be
			       different.  For example class<int,T>.

			       tp is a copy of the arguments in the original template definition.
       
			       The patching algorithm walks through the list of supplied
			       arguments ($3), finds the position in the specialization arguments
			       (tlist), and then patches the name in the argument list of the
			       original template.
			    */

			    {
			      String *pn;
			      Parm *p, *p1;
			      int i, nargs;
			      Parm *tp = CopyParmList(Getattr(tempn,"templateparms"));
			      nargs = Len(tlist);
			      p = (yyvsp[-3].tparms);
			      while (p) {
				for (i = 0; i < nargs; i++){
				  pn = Getattr(p,"name");
				  if (Strcmp(pn,SwigType_base(Getitem(tlist,i))) == 0) {
				    int j;
				    Parm *p1 = tp;
				    for (j = 0; j < i; j++) {
				      p1 = nextSibling(p1);
				    }
				    Setattr(p1,"name",pn);
				    Setattr(p1,"partialarg","1");
				  }
				}
				p = nextSibling(p);
			      }
			      p1 = tp;
			      i = 0;
			      while (p1) {
				if (!Getattr(p1,"partialarg")) {
				  Delattr(p1,"name");
				  Setattr(p1,"type", Getitem(tlist,i));
				} 
				i++;
				p1 = nextSibling(p1);
			      }
			      Setattr((yyval.node),"templateparms",tp);
			      Delete(tp);
			    }
  #if 0
			    /* Patch the parameter list */
			    if (tempn) {
			      Parm *p,*p1;
			      ParmList *tp = CopyParmList(Getattr(tempn,"templateparms"));
			      p = (yyvsp[-3].tparms);
			      p1 = tp;
			      while (p && p1) {
				String *pn = Getattr(p,"name");
				Printf(stdout,"pn = '%s'\n", pn);
				if (pn) Setattr(p1,"name",pn);
				else Delattr(p1,"name");
				pn = Getattr(p,"type");
				if (pn) Setattr(p1,"type",pn);
				p = nextSibling(p);
				p1 = nextSibling(p1);
			      }
			      Setattr((yyval.node),"templateparms",tp);
			      Delete(tp);
			    } else {
			      Setattr((yyval.node),"templateparms",(yyvsp[-3].tparms));
			    }
  #endif
			    Delattr((yyval.node),"specialization");
			    Setattr((yyval.node),"partialspecialization","1");
			    /* Create a specialized name for matching */
			    {
			      Parm *p = (yyvsp[-3].tparms);
			      String *fname = NewString(Getattr((yyval.node),"name"));
			      String *ffname = 0;
			      ParmList *partialparms = 0;

			      char   tmp[32];
			      int    i, ilen;
			      while (p) {
				String *n = Getattr(p,"name");
				if (!n) {
				  p = nextSibling(p);
				  continue;
				}
				ilen = Len(tlist);
				for (i = 0; i < ilen; i++) {
				  if (Strstr(Getitem(tlist,i),n)) {
				    sprintf(tmp,"$%d",i+1);
				    Replaceid(fname,n,tmp);
				  }
				}
				p = nextSibling(p);
			      }
			      /* Patch argument names with typedef */
			      {
				Iterator tt;
				Parm *parm_current = 0;
				List *tparms = SwigType_parmlist(fname);
				ffname = SwigType_templateprefix(fname);
				Append(ffname,"<(");
				for (tt = First(tparms); tt.item; ) {
				  SwigType *rtt = Swig_symbol_typedef_reduce(tt.item,0);
				  SwigType *ttr = Swig_symbol_type_qualify(rtt,0);

				  Parm *newp = NewParmWithoutFileLineInfo(ttr, 0);
				  if (partialparms)
				    set_nextSibling(parm_current, newp);
				  else
				    partialparms = newp;
				  parm_current = newp;

				  Append(ffname,ttr);
				  tt = Next(tt);
				  if (tt.item) Putc(',',ffname);
				  Delete(rtt);
				  Delete(ttr);
				}
				Delete(tparms);
				Append(ffname,")>");
			      }
			      {
				Node *new_partial = NewHash();
				String *partials = Getattr(tempn,"partials");
				if (!partials) {
				  partials = NewList();
				  Setattr(tempn,"partials",partials);
				  Delete(partials);
				}
				/*			      Printf(stdout,"partial: fname = '%s', '%s'\n", fname, Swig_symbol_typedef_reduce(fname,0)); */
				Setattr(new_partial, "partialparms", partialparms);
				Setattr(new_partial, "templcsymname", ffname);
				Append(partials, new_partial);
			      }
			      Setattr((yyval.node),"partialargs",ffname);
			      Swig_symbol_cadd(ffname,(yyval.node));
			    }
			    }
			    Delete(tlist);
			    Delete(targs);
			  } else {
			    /* An explicit template specialization */
			    /* add default args from primary (unspecialized) template */
			    String *ty = Swig_symbol_template_deftype(tname,0);
			    String *fname = Swig_symbol_type_qualify(ty,0);
			    Swig_symbol_cadd(fname,(yyval.node));
			    Delete(ty);
			    Delete(fname);
			  }
			}  else if ((yyval.node)) {
			  Setattr((yyval.node),"templatetype",nodeType((yyvsp[0].node)));
			  set_nodeType((yyval.node),"template");
			  Setattr((yyval.node),"templateparms", (yyvsp[-3].tparms));
			  if (!Getattr((yyval.node),"sym:weak")) {
			    Setattr((yyval.node),"sym:typename","1");
			  }
			  add_symbols((yyval.node));
			  default_arguments((yyval.node));
			  /* We also place a fully parameterized version in the symbol table */
			  {
			    Parm *p;
			    String *fname = NewStringf("%s<(", Getattr((yyval.node),"name"));
			    p = (yyvsp[-3].tparms);
			    while (p) {
			      String *n = Getattr(p,"name");
			      if (!n) n = Getattr(p,"type");
			      Append(fname,n);
			      p = nextSibling(p);
			      if (p) Putc(',',fname);
			    }
			    Append(fname,")>");
			    Swig_symbol_cadd(fname,(yyval.node));
			  }
			}
			(yyval.node) = ntop;
			Swig_symbol_setscope(cscope);
			Delete(Namespaceprefix);
			Namespaceprefix = Swig_symbol_qualifiedscopename(0);
			if (error || (nscope_inner && Strcmp(nodeType(nscope_inner), "class") == 0)) {
			  (yyval.node) = 0;
			}
			if (currentOuterClass)
			  template_parameters = Getattr(currentOuterClass, "template_parameters");
			else
			  template_parameters = 0;
                }
#line 7509 "y.tab.c" /* yacc.c:1646  */
    break;

  case 169:
#line 4034 "parser.y" /* yacc.c:1646  */
    {
		  Swig_warning(WARN_PARSE_EXPLICIT_TEMPLATE, cparse_file, cparse_line, "Explicit template instantiation ignored.\n");
                  (yyval.node) = 0; 
		}
#line 7518 "y.tab.c" /* yacc.c:1646  */
    break;

  case 170:
#line 4040 "parser.y" /* yacc.c:1646  */
    {
		  Swig_warning(WARN_PARSE_EXPLICIT_TEMPLATE, cparse_file, cparse_line, "Explicit template instantiation ignored.\n");
                  (yyval.node) = 0; 
                }
#line 7527 "y.tab.c" /* yacc.c:1646  */
    break;

  case 171:
#line 4046 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.node) = (yyvsp[0].node);
                }
#line 7535 "y.tab.c" /* yacc.c:1646  */
    break;

  case 172:
#line 4049 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.node) = (yyvsp[0].node);
                }
#line 7543 "y.tab.c" /* yacc.c:1646  */
    break;

  case 173:
#line 4052 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.node) = (yyvsp[0].node);
                }
#line 7551 "y.tab.c" /* yacc.c:1646  */
    break;

  case 174:
#line 4055 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.node) = (yyvsp[0].node);
                }
#line 7559 "y.tab.c" /* yacc.c:1646  */
    break;

  case 175:
#line 4058 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.node) = 0;
                }
#line 7567 "y.tab.c" /* yacc.c:1646  */
    break;

  case 176:
#line 4061 "parser.y" /* yacc.c:1646  */
    {
                  (yyval.node) = (yyvsp[0].node);
                }
#line 7575 "y.tab.c" /* yacc.c:1646  */
    break;

  case 177:
#line 4064 "parser.y" /* yacc.c:1646  */
    {
                  (yyval.node) = (yyvsp[0].node);
                }
#line 7583 "y.tab.c" /* yacc.c:1646  */
    break;

  case 178:
#line 4069 "parser.y" /* yacc.c:1646  */
    {
		   /* Rip out the parameter names */
		  Parm *p = (yyvsp[0].pl);
		  (yyval.tparms) = (yyvsp[0].pl);

		  while (p) {
		    String *name = Getattr(p,"name");
		    if (!name) {
		      /* Hmmm. Maybe it's a 'class T' parameter */
		      char *type = Char(Getattr(p,"type"));
		      /* Template template parameter */
		      if (strncmp(type,"template<class> ",16) == 0) {
			type += 16;
		      }
		      if ((strncmp(type,"class ",6) == 0) || (strncmp(type,"typename ", 9) == 0)) {
			char *t = strchr(type,' ');
			Setattr(p,"name", t+1);
		      } else 
                      /* Variadic template args */
		      if ((strncmp(type,"class... ",9) == 0) || (strncmp(type,"typename... ", 12) == 0)) {
			char *t = strchr(type,' ');
			Setattr(p,"name", t+1);
			Setattr(p,"variadic", "1");
		      } else {
			/*
			 Swig_error(cparse_file, cparse_line, "Missing template parameter name\n");
			 $$.rparms = 0;
			 $$.parms = 0;
			 break; */
		      }
		    }
		    p = nextSibling(p);
		  }
                 }
#line 7622 "y.tab.c" /* yacc.c:1646  */
    break;

  case 179:
#line 4105 "parser.y" /* yacc.c:1646  */
    {
                      set_nextSibling((yyvsp[-1].p),(yyvsp[0].pl));
                      (yyval.pl) = (yyvsp[-1].p);
                   }
#line 7631 "y.tab.c" /* yacc.c:1646  */
    break;

  case 180:
#line 4109 "parser.y" /* yacc.c:1646  */
    { (yyval.pl) = 0; }
#line 7637 "y.tab.c" /* yacc.c:1646  */
    break;

  case 181:
#line 4112 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.p) = NewParmWithoutFileLineInfo(NewString((yyvsp[0].id)), 0);
                  }
#line 7645 "y.tab.c" /* yacc.c:1646  */
    break;

  case 182:
#line 4115 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.p) = (yyvsp[0].p);
                  }
#line 7653 "y.tab.c" /* yacc.c:1646  */
    break;

  case 183:
#line 4120 "parser.y" /* yacc.c:1646  */
    {
                         set_nextSibling((yyvsp[-1].p),(yyvsp[0].pl));
                         (yyval.pl) = (yyvsp[-1].p);
                       }
#line 7662 "y.tab.c" /* yacc.c:1646  */
    break;

  case 184:
#line 4124 "parser.y" /* yacc.c:1646  */
    { (yyval.pl) = 0; }
#line 7668 "y.tab.c" /* yacc.c:1646  */
    break;

  case 185:
#line 4129 "parser.y" /* yacc.c:1646  */
    {
                  String *uname = Swig_symbol_type_qualify((yyvsp[-1].str),0);
		  String *name = Swig_scopename_last((yyvsp[-1].str));
                  (yyval.node) = new_node("using");
		  Setattr((yyval.node),"uname",uname);
		  Setattr((yyval.node),"name", name);
		  Delete(uname);
		  Delete(name);
		  add_symbols((yyval.node));
             }
#line 7683 "y.tab.c" /* yacc.c:1646  */
    break;

  case 186:
#line 4139 "parser.y" /* yacc.c:1646  */
    {
	       Node *n = Swig_symbol_clookup((yyvsp[-1].str),0);
	       if (!n) {
		 Swig_error(cparse_file, cparse_line, "Nothing known about namespace '%s'\n", (yyvsp[-1].str));
		 (yyval.node) = 0;
	       } else {

		 while (Strcmp(nodeType(n),"using") == 0) {
		   n = Getattr(n,"node");
		 }
		 if (n) {
		   if (Strcmp(nodeType(n),"namespace") == 0) {
		     Symtab *current = Swig_symbol_current();
		     Symtab *symtab = Getattr(n,"symtab");
		     (yyval.node) = new_node("using");
		     Setattr((yyval.node),"node",n);
		     Setattr((yyval.node),"namespace", (yyvsp[-1].str));
		     if (current != symtab) {
		       Swig_symbol_inherit(symtab);
		     }
		   } else {
		     Swig_error(cparse_file, cparse_line, "'%s' is not a namespace.\n", (yyvsp[-1].str));
		     (yyval.node) = 0;
		   }
		 } else {
		   (yyval.node) = 0;
		 }
	       }
             }
#line 7717 "y.tab.c" /* yacc.c:1646  */
    break;

  case 187:
#line 4170 "parser.y" /* yacc.c:1646  */
    { 
                Hash *h;
                (yyvsp[-2].node) = Swig_symbol_current();
		h = Swig_symbol_clookup((yyvsp[-1].str),0);
		if (h && ((yyvsp[-2].node) == Getattr(h,"sym:symtab")) && (Strcmp(nodeType(h),"namespace") == 0)) {
		  if (Getattr(h,"alias")) {
		    h = Getattr(h,"namespace");
		    Swig_warning(WARN_PARSE_NAMESPACE_ALIAS, cparse_file, cparse_line, "Namespace alias '%s' not allowed here. Assuming '%s'\n",
				 (yyvsp[-1].str), Getattr(h,"name"));
		    (yyvsp[-1].str) = Getattr(h,"name");
		  }
		  Swig_symbol_setscope(Getattr(h,"symtab"));
		} else {
		  Swig_symbol_newscope();
		  Swig_symbol_setscopename((yyvsp[-1].str));
		}
		Delete(Namespaceprefix);
		Namespaceprefix = Swig_symbol_qualifiedscopename(0);
             }
#line 7741 "y.tab.c" /* yacc.c:1646  */
    break;

  case 188:
#line 4188 "parser.y" /* yacc.c:1646  */
    {
                Node *n = (yyvsp[-1].node);
		set_nodeType(n,"namespace");
		Setattr(n,"name",(yyvsp[-4].str));
                Setattr(n,"symtab", Swig_symbol_popscope());
		Swig_symbol_setscope((yyvsp[-5].node));
		(yyval.node) = n;
		Delete(Namespaceprefix);
		Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		add_symbols((yyval.node));
             }
#line 7757 "y.tab.c" /* yacc.c:1646  */
    break;

  case 189:
#line 4199 "parser.y" /* yacc.c:1646  */
    {
	       Hash *h;
	       (yyvsp[-1].node) = Swig_symbol_current();
	       h = Swig_symbol_clookup("    ",0);
	       if (h && (Strcmp(nodeType(h),"namespace") == 0)) {
		 Swig_symbol_setscope(Getattr(h,"symtab"));
	       } else {
		 Swig_symbol_newscope();
		 /* we don't use "__unnamed__", but a long 'empty' name */
		 Swig_symbol_setscopename("    ");
	       }
	       Namespaceprefix = 0;
             }
#line 7775 "y.tab.c" /* yacc.c:1646  */
    break;

  case 190:
#line 4211 "parser.y" /* yacc.c:1646  */
    {
	       (yyval.node) = (yyvsp[-1].node);
	       set_nodeType((yyval.node),"namespace");
	       Setattr((yyval.node),"unnamed","1");
	       Setattr((yyval.node),"symtab", Swig_symbol_popscope());
	       Swig_symbol_setscope((yyvsp[-4].node));
	       Delete(Namespaceprefix);
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	       add_symbols((yyval.node));
             }
#line 7790 "y.tab.c" /* yacc.c:1646  */
    break;

  case 191:
#line 4221 "parser.y" /* yacc.c:1646  */
    {
	       /* Namespace alias */
	       Node *n;
	       (yyval.node) = new_node("namespace");
	       Setattr((yyval.node),"name",(yyvsp[-3].id));
	       Setattr((yyval.node),"alias",(yyvsp[-1].str));
	       n = Swig_symbol_clookup((yyvsp[-1].str),0);
	       if (!n) {
		 Swig_error(cparse_file, cparse_line, "Unknown namespace '%s'\n", (yyvsp[-1].str));
		 (yyval.node) = 0;
	       } else {
		 if (Strcmp(nodeType(n),"namespace") != 0) {
		   Swig_error(cparse_file, cparse_line, "'%s' is not a namespace\n",(yyvsp[-1].str));
		   (yyval.node) = 0;
		 } else {
		   while (Getattr(n,"alias")) {
		     n = Getattr(n,"namespace");
		   }
		   Setattr((yyval.node),"namespace",n);
		   add_symbols((yyval.node));
		   /* Set up a scope alias */
		   Swig_symbol_alias((yyvsp[-3].id),Getattr(n,"symtab"));
		 }
	       }
             }
#line 7820 "y.tab.c" /* yacc.c:1646  */
    break;

  case 192:
#line 4248 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.node) = (yyvsp[-1].node);
                   /* Insert cpp_member (including any siblings) to the front of the cpp_members linked list */
		   if ((yyval.node)) {
		     Node *p = (yyval.node);
		     Node *pp =0;
		     while (p) {
		       pp = p;
		       p = nextSibling(p);
		     }
		     set_nextSibling(pp,(yyvsp[0].node));
		     if ((yyvsp[0].node))
		       set_previousSibling((yyvsp[0].node), pp);
		   } else {
		     (yyval.node) = (yyvsp[0].node);
		   }
             }
#line 7842 "y.tab.c" /* yacc.c:1646  */
    break;

  case 193:
#line 4265 "parser.y" /* yacc.c:1646  */
    { 
	       extendmode = 1;
	       if (cplus_mode != CPLUS_PUBLIC) {
		 Swig_error(cparse_file,cparse_line,"%%extend can only be used in a public section\n");
	       }
             }
#line 7853 "y.tab.c" /* yacc.c:1646  */
    break;

  case 194:
#line 4270 "parser.y" /* yacc.c:1646  */
    {
	       extendmode = 0;
	     }
#line 7861 "y.tab.c" /* yacc.c:1646  */
    break;

  case 195:
#line 4272 "parser.y" /* yacc.c:1646  */
    {
	       (yyval.node) = new_node("extend");
	       mark_nodes_as_extend((yyvsp[-3].node));
	       appendChild((yyval.node),(yyvsp[-3].node));
	       set_nextSibling((yyval.node),(yyvsp[0].node));
	     }
#line 7872 "y.tab.c" /* yacc.c:1646  */
    break;

  case 196:
#line 4278 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 7878 "y.tab.c" /* yacc.c:1646  */
    break;

  case 197:
#line 4279 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = 0;}
#line 7884 "y.tab.c" /* yacc.c:1646  */
    break;

  case 198:
#line 4280 "parser.y" /* yacc.c:1646  */
    {
	       int start_line = cparse_line;
	       skip_decl();
	       Swig_error(cparse_file,start_line,"Syntax error in input(3).\n");
	       exit(1);
	       }
#line 7895 "y.tab.c" /* yacc.c:1646  */
    break;

  case 199:
#line 4285 "parser.y" /* yacc.c:1646  */
    { 
		 (yyval.node) = (yyvsp[0].node);
   	     }
#line 7903 "y.tab.c" /* yacc.c:1646  */
    break;

  case 200:
#line 4296 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 7909 "y.tab.c" /* yacc.c:1646  */
    break;

  case 201:
#line 4297 "parser.y" /* yacc.c:1646  */
    { 
                 (yyval.node) = (yyvsp[0].node); 
		 if (extendmode && current_class) {
		   String *symname;
		   symname= make_name((yyval.node),Getattr((yyval.node),"name"), Getattr((yyval.node),"decl"));
		   if (Strcmp(symname,Getattr((yyval.node),"name")) == 0) {
		     /* No renaming operation.  Set name to class name */
		     Delete(yyrename);
		     yyrename = NewString(Getattr(current_class,"sym:name"));
		   } else {
		     Delete(yyrename);
		     yyrename = symname;
		   }
		 }
		 add_symbols((yyval.node));
                 default_arguments((yyval.node));
             }
#line 7931 "y.tab.c" /* yacc.c:1646  */
    break;

  case 202:
#line 4314 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 7937 "y.tab.c" /* yacc.c:1646  */
    break;

  case 203:
#line 4315 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 7943 "y.tab.c" /* yacc.c:1646  */
    break;

  case 204:
#line 4316 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 7949 "y.tab.c" /* yacc.c:1646  */
    break;

  case 205:
#line 4317 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 7955 "y.tab.c" /* yacc.c:1646  */
    break;

  case 206:
#line 4318 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 7961 "y.tab.c" /* yacc.c:1646  */
    break;

  case 207:
#line 4319 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 7967 "y.tab.c" /* yacc.c:1646  */
    break;

  case 208:
#line 4320 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 7973 "y.tab.c" /* yacc.c:1646  */
    break;

  case 209:
#line 4321 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 7979 "y.tab.c" /* yacc.c:1646  */
    break;

  case 210:
#line 4322 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 7985 "y.tab.c" /* yacc.c:1646  */
    break;

  case 211:
#line 4323 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 7991 "y.tab.c" /* yacc.c:1646  */
    break;

  case 212:
#line 4324 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 7997 "y.tab.c" /* yacc.c:1646  */
    break;

  case 213:
#line 4325 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 8003 "y.tab.c" /* yacc.c:1646  */
    break;

  case 214:
#line 4326 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 8009 "y.tab.c" /* yacc.c:1646  */
    break;

  case 215:
#line 4327 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 8015 "y.tab.c" /* yacc.c:1646  */
    break;

  case 216:
#line 4328 "parser.y" /* yacc.c:1646  */
    {(yyval.node) = (yyvsp[0].node); }
#line 8021 "y.tab.c" /* yacc.c:1646  */
    break;

  case 217:
#line 4329 "parser.y" /* yacc.c:1646  */
    {(yyval.node) = (yyvsp[0].node); }
#line 8027 "y.tab.c" /* yacc.c:1646  */
    break;

  case 218:
#line 4330 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 8033 "y.tab.c" /* yacc.c:1646  */
    break;

  case 219:
#line 4339 "parser.y" /* yacc.c:1646  */
    {
              if (inclass || extendmode) {
		SwigType *decl = NewStringEmpty();
		(yyval.node) = new_node("constructor");
		Setattr((yyval.node),"storage",(yyvsp[-5].id));
		Setattr((yyval.node),"name",(yyvsp[-4].type));
		Setattr((yyval.node),"parms",(yyvsp[-2].pl));
		SwigType_add_function(decl,(yyvsp[-2].pl));
		Setattr((yyval.node),"decl",decl);
		Setattr((yyval.node),"throws",(yyvsp[0].decl).throws);
		Setattr((yyval.node),"throw",(yyvsp[0].decl).throwf);
		Setattr((yyval.node),"noexcept",(yyvsp[0].decl).nexcept);
		if (Len(scanner_ccode)) {
		  String *code = Copy(scanner_ccode);
		  Setattr((yyval.node),"code",code);
		  Delete(code);
		}
		SetFlag((yyval.node),"feature:new");
		if ((yyvsp[0].decl).defarg)
		  Setattr((yyval.node),"value",(yyvsp[0].decl).defarg);
	      } else {
		(yyval.node) = 0;
              }
              }
#line 8062 "y.tab.c" /* yacc.c:1646  */
    break;

  case 220:
#line 4367 "parser.y" /* yacc.c:1646  */
    {
               String *name = NewStringf("%s",(yyvsp[-4].str));
	       if (*(Char(name)) != '~') Insert(name,0,"~");
               (yyval.node) = new_node("destructor");
	       Setattr((yyval.node),"name",name);
	       Delete(name);
	       if (Len(scanner_ccode)) {
		 String *code = Copy(scanner_ccode);
		 Setattr((yyval.node),"code",code);
		 Delete(code);
	       }
	       {
		 String *decl = NewStringEmpty();
		 SwigType_add_function(decl,(yyvsp[-2].pl));
		 Setattr((yyval.node),"decl",decl);
		 Delete(decl);
	       }
	       Setattr((yyval.node),"throws",(yyvsp[0].dtype).throws);
	       Setattr((yyval.node),"throw",(yyvsp[0].dtype).throwf);
	       Setattr((yyval.node),"noexcept",(yyvsp[0].dtype).nexcept);
	       if ((yyvsp[0].dtype).val)
	         Setattr((yyval.node),"value",(yyvsp[0].dtype).val);
	       add_symbols((yyval.node));
	      }
#line 8091 "y.tab.c" /* yacc.c:1646  */
    break;

  case 221:
#line 4394 "parser.y" /* yacc.c:1646  */
    {
		String *name;
		(yyval.node) = new_node("destructor");
		Setattr((yyval.node),"storage","virtual");
	        name = NewStringf("%s",(yyvsp[-4].str));
		if (*(Char(name)) != '~') Insert(name,0,"~");
		Setattr((yyval.node),"name",name);
		Delete(name);
		Setattr((yyval.node),"throws",(yyvsp[0].dtype).throws);
		Setattr((yyval.node),"throw",(yyvsp[0].dtype).throwf);
		Setattr((yyval.node),"noexcept",(yyvsp[0].dtype).nexcept);
		if ((yyvsp[0].dtype).val)
		  Setattr((yyval.node),"value",(yyvsp[0].dtype).val);
		if (Len(scanner_ccode)) {
		  String *code = Copy(scanner_ccode);
		  Setattr((yyval.node),"code",code);
		  Delete(code);
		}
		{
		  String *decl = NewStringEmpty();
		  SwigType_add_function(decl,(yyvsp[-2].pl));
		  Setattr((yyval.node),"decl",decl);
		  Delete(decl);
		}

		add_symbols((yyval.node));
	      }
#line 8123 "y.tab.c" /* yacc.c:1646  */
    break;

  case 222:
#line 4425 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.node) = new_node("cdecl");
                 Setattr((yyval.node),"type",(yyvsp[-5].type));
		 Setattr((yyval.node),"name",(yyvsp[-6].str));
		 Setattr((yyval.node),"storage",(yyvsp[-7].id));

		 SwigType_add_function((yyvsp[-4].type),(yyvsp[-2].pl));
		 if ((yyvsp[0].dtype).qualifier) {
		   SwigType_push((yyvsp[-4].type),(yyvsp[0].dtype).qualifier);
		 }
		 Setattr((yyval.node),"decl",(yyvsp[-4].type));
		 Setattr((yyval.node),"parms",(yyvsp[-2].pl));
		 Setattr((yyval.node),"conversion_operator","1");
		 add_symbols((yyval.node));
              }
#line 8143 "y.tab.c" /* yacc.c:1646  */
    break;

  case 223:
#line 4440 "parser.y" /* yacc.c:1646  */
    {
		 SwigType *decl;
                 (yyval.node) = new_node("cdecl");
                 Setattr((yyval.node),"type",(yyvsp[-5].type));
		 Setattr((yyval.node),"name",(yyvsp[-6].str));
		 Setattr((yyval.node),"storage",(yyvsp[-7].id));
		 decl = NewStringEmpty();
		 SwigType_add_reference(decl);
		 SwigType_add_function(decl,(yyvsp[-2].pl));
		 if ((yyvsp[0].dtype).qualifier) {
		   SwigType_push(decl,(yyvsp[0].dtype).qualifier);
		 }
		 Setattr((yyval.node),"decl",decl);
		 Setattr((yyval.node),"parms",(yyvsp[-2].pl));
		 Setattr((yyval.node),"conversion_operator","1");
		 add_symbols((yyval.node));
	       }
#line 8165 "y.tab.c" /* yacc.c:1646  */
    break;

  case 224:
#line 4457 "parser.y" /* yacc.c:1646  */
    {
		 SwigType *decl;
                 (yyval.node) = new_node("cdecl");
                 Setattr((yyval.node),"type",(yyvsp[-5].type));
		 Setattr((yyval.node),"name",(yyvsp[-6].str));
		 Setattr((yyval.node),"storage",(yyvsp[-7].id));
		 decl = NewStringEmpty();
		 SwigType_add_rvalue_reference(decl);
		 SwigType_add_function(decl,(yyvsp[-2].pl));
		 if ((yyvsp[0].dtype).qualifier) {
		   SwigType_push(decl,(yyvsp[0].dtype).qualifier);
		 }
		 Setattr((yyval.node),"decl",decl);
		 Setattr((yyval.node),"parms",(yyvsp[-2].pl));
		 Setattr((yyval.node),"conversion_operator","1");
		 add_symbols((yyval.node));
	       }
#line 8187 "y.tab.c" /* yacc.c:1646  */
    break;

  case 225:
#line 4475 "parser.y" /* yacc.c:1646  */
    {
		 SwigType *decl;
                 (yyval.node) = new_node("cdecl");
                 Setattr((yyval.node),"type",(yyvsp[-6].type));
		 Setattr((yyval.node),"name",(yyvsp[-7].str));
		 Setattr((yyval.node),"storage",(yyvsp[-8].id));
		 decl = NewStringEmpty();
		 SwigType_add_pointer(decl);
		 SwigType_add_reference(decl);
		 SwigType_add_function(decl,(yyvsp[-2].pl));
		 if ((yyvsp[0].dtype).qualifier) {
		   SwigType_push(decl,(yyvsp[0].dtype).qualifier);
		 }
		 Setattr((yyval.node),"decl",decl);
		 Setattr((yyval.node),"parms",(yyvsp[-2].pl));
		 Setattr((yyval.node),"conversion_operator","1");
		 add_symbols((yyval.node));
	       }
#line 8210 "y.tab.c" /* yacc.c:1646  */
    break;

  case 226:
#line 4494 "parser.y" /* yacc.c:1646  */
    {
		String *t = NewStringEmpty();
		(yyval.node) = new_node("cdecl");
		Setattr((yyval.node),"type",(yyvsp[-4].type));
		Setattr((yyval.node),"name",(yyvsp[-5].str));
		 Setattr((yyval.node),"storage",(yyvsp[-6].id));
		SwigType_add_function(t,(yyvsp[-2].pl));
		if ((yyvsp[0].dtype).qualifier) {
		  SwigType_push(t,(yyvsp[0].dtype).qualifier);
		}
		Setattr((yyval.node),"decl",t);
		Setattr((yyval.node),"parms",(yyvsp[-2].pl));
		Setattr((yyval.node),"conversion_operator","1");
		add_symbols((yyval.node));
              }
#line 8230 "y.tab.c" /* yacc.c:1646  */
    break;

  case 227:
#line 4513 "parser.y" /* yacc.c:1646  */
    {
                 skip_balanced('{','}');
                 (yyval.node) = 0;
               }
#line 8239 "y.tab.c" /* yacc.c:1646  */
    break;

  case 228:
#line 4520 "parser.y" /* yacc.c:1646  */
    {
                skip_balanced('(',')');
                (yyval.node) = 0;
              }
#line 8248 "y.tab.c" /* yacc.c:1646  */
    break;

  case 229:
#line 4527 "parser.y" /* yacc.c:1646  */
    { 
                (yyval.node) = new_node("access");
		Setattr((yyval.node),"kind","public");
                cplus_mode = CPLUS_PUBLIC;
              }
#line 8258 "y.tab.c" /* yacc.c:1646  */
    break;

  case 230:
#line 4534 "parser.y" /* yacc.c:1646  */
    { 
                (yyval.node) = new_node("access");
                Setattr((yyval.node),"kind","private");
		cplus_mode = CPLUS_PRIVATE;
	      }
#line 8268 "y.tab.c" /* yacc.c:1646  */
    break;

  case 231:
#line 4542 "parser.y" /* yacc.c:1646  */
    { 
		(yyval.node) = new_node("access");
		Setattr((yyval.node),"kind","protected");
		cplus_mode = CPLUS_PROTECTED;
	      }
#line 8278 "y.tab.c" /* yacc.c:1646  */
    break;

  case 232:
#line 4550 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 8284 "y.tab.c" /* yacc.c:1646  */
    break;

  case 233:
#line 4553 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 8290 "y.tab.c" /* yacc.c:1646  */
    break;

  case 234:
#line 4557 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 8296 "y.tab.c" /* yacc.c:1646  */
    break;

  case 235:
#line 4560 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 8302 "y.tab.c" /* yacc.c:1646  */
    break;

  case 236:
#line 4561 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 8308 "y.tab.c" /* yacc.c:1646  */
    break;

  case 237:
#line 4562 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 8314 "y.tab.c" /* yacc.c:1646  */
    break;

  case 238:
#line 4563 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 8320 "y.tab.c" /* yacc.c:1646  */
    break;

  case 239:
#line 4564 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 8326 "y.tab.c" /* yacc.c:1646  */
    break;

  case 240:
#line 4565 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 8332 "y.tab.c" /* yacc.c:1646  */
    break;

  case 241:
#line 4566 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 8338 "y.tab.c" /* yacc.c:1646  */
    break;

  case 242:
#line 4567 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 8344 "y.tab.c" /* yacc.c:1646  */
    break;

  case 243:
#line 4570 "parser.y" /* yacc.c:1646  */
    {
	            Clear(scanner_ccode);
		    (yyval.dtype).val = 0;
		    (yyval.dtype).throws = (yyvsp[-1].dtype).throws;
		    (yyval.dtype).throwf = (yyvsp[-1].dtype).throwf;
		    (yyval.dtype).nexcept = (yyvsp[-1].dtype).nexcept;
               }
#line 8356 "y.tab.c" /* yacc.c:1646  */
    break;

  case 244:
#line 4577 "parser.y" /* yacc.c:1646  */
    {
	            Clear(scanner_ccode);
		    (yyval.dtype).val = (yyvsp[-1].dtype).val;
		    (yyval.dtype).throws = (yyvsp[-3].dtype).throws;
		    (yyval.dtype).throwf = (yyvsp[-3].dtype).throwf;
		    (yyval.dtype).nexcept = (yyvsp[-3].dtype).nexcept;
               }
#line 8368 "y.tab.c" /* yacc.c:1646  */
    break;

  case 245:
#line 4584 "parser.y" /* yacc.c:1646  */
    { 
		    skip_balanced('{','}'); 
		    (yyval.dtype).val = 0;
		    (yyval.dtype).throws = (yyvsp[-1].dtype).throws;
		    (yyval.dtype).throwf = (yyvsp[-1].dtype).throwf;
		    (yyval.dtype).nexcept = (yyvsp[-1].dtype).nexcept;
	       }
#line 8380 "y.tab.c" /* yacc.c:1646  */
    break;

  case 246:
#line 4593 "parser.y" /* yacc.c:1646  */
    { 
                     Clear(scanner_ccode);
                     (yyval.dtype).val = 0;
                     (yyval.dtype).qualifier = (yyvsp[-1].dtype).qualifier;
                     (yyval.dtype).bitfield = 0;
                     (yyval.dtype).throws = (yyvsp[-1].dtype).throws;
                     (yyval.dtype).throwf = (yyvsp[-1].dtype).throwf;
                     (yyval.dtype).nexcept = (yyvsp[-1].dtype).nexcept;
                }
#line 8394 "y.tab.c" /* yacc.c:1646  */
    break;

  case 247:
#line 4602 "parser.y" /* yacc.c:1646  */
    { 
                     Clear(scanner_ccode);
                     (yyval.dtype).val = (yyvsp[-1].dtype).val;
                     (yyval.dtype).qualifier = (yyvsp[-3].dtype).qualifier;
                     (yyval.dtype).bitfield = 0;
                     (yyval.dtype).throws = (yyvsp[-3].dtype).throws; 
                     (yyval.dtype).throwf = (yyvsp[-3].dtype).throwf; 
                     (yyval.dtype).nexcept = (yyvsp[-3].dtype).nexcept; 
               }
#line 8408 "y.tab.c" /* yacc.c:1646  */
    break;

  case 248:
#line 4611 "parser.y" /* yacc.c:1646  */
    { 
                     skip_balanced('{','}');
                     (yyval.dtype).val = 0;
                     (yyval.dtype).qualifier = (yyvsp[-1].dtype).qualifier;
                     (yyval.dtype).bitfield = 0;
                     (yyval.dtype).throws = (yyvsp[-1].dtype).throws; 
                     (yyval.dtype).throwf = (yyvsp[-1].dtype).throwf; 
                     (yyval.dtype).nexcept = (yyvsp[-1].dtype).nexcept; 
               }
#line 8422 "y.tab.c" /* yacc.c:1646  */
    break;

  case 249:
#line 4623 "parser.y" /* yacc.c:1646  */
    { }
#line 8428 "y.tab.c" /* yacc.c:1646  */
    break;

  case 250:
#line 4626 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = (yyvsp[0].type);
                  /* Printf(stdout,"primitive = '%s'\n", $$);*/
                }
#line 8436 "y.tab.c" /* yacc.c:1646  */
    break;

  case 251:
#line 4629 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = (yyvsp[0].type); }
#line 8442 "y.tab.c" /* yacc.c:1646  */
    break;

  case 252:
#line 4630 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = (yyvsp[0].type); }
#line 8448 "y.tab.c" /* yacc.c:1646  */
    break;

  case 253:
#line 4631 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = NewStringf("%s%s",(yyvsp[-1].type),(yyvsp[0].id)); }
#line 8454 "y.tab.c" /* yacc.c:1646  */
    break;

  case 254:
#line 4632 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = (yyvsp[0].type); }
#line 8460 "y.tab.c" /* yacc.c:1646  */
    break;

  case 255:
#line 4634 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.type) = (yyvsp[0].str);
               }
#line 8468 "y.tab.c" /* yacc.c:1646  */
    break;

  case 256:
#line 4643 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "extern"; }
#line 8474 "y.tab.c" /* yacc.c:1646  */
    break;

  case 257:
#line 4644 "parser.y" /* yacc.c:1646  */
    {
                   if (strcmp((yyvsp[0].id),"C") == 0) {
		     (yyval.id) = "externc";
                   } else if (strcmp((yyvsp[0].id),"C++") == 0) {
		     (yyval.id) = "extern";
		   } else {
		     Swig_warning(WARN_PARSE_UNDEFINED_EXTERN,cparse_file, cparse_line,"Unrecognized extern type \"%s\".\n", (yyvsp[0].id));
		     (yyval.id) = 0;
		   }
               }
#line 8489 "y.tab.c" /* yacc.c:1646  */
    break;

  case 258:
#line 4654 "parser.y" /* yacc.c:1646  */
    {
                   if (strcmp((yyvsp[-1].id),"C") == 0) {
		     (yyval.id) = "externc thread_local";
                   } else if (strcmp((yyvsp[-1].id),"C++") == 0) {
		     (yyval.id) = "extern thread_local";
		   } else {
		     Swig_warning(WARN_PARSE_UNDEFINED_EXTERN,cparse_file, cparse_line,"Unrecognized extern type \"%s\".\n", (yyvsp[-1].id));
		     (yyval.id) = 0;
		   }
               }
#line 8504 "y.tab.c" /* yacc.c:1646  */
    break;

  case 259:
#line 4664 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "static"; }
#line 8510 "y.tab.c" /* yacc.c:1646  */
    break;

  case 260:
#line 4665 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "typedef"; }
#line 8516 "y.tab.c" /* yacc.c:1646  */
    break;

  case 261:
#line 4666 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "virtual"; }
#line 8522 "y.tab.c" /* yacc.c:1646  */
    break;

  case 262:
#line 4667 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "friend"; }
#line 8528 "y.tab.c" /* yacc.c:1646  */
    break;

  case 263:
#line 4668 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "explicit"; }
#line 8534 "y.tab.c" /* yacc.c:1646  */
    break;

  case 264:
#line 4669 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "constexpr"; }
#line 8540 "y.tab.c" /* yacc.c:1646  */
    break;

  case 265:
#line 4670 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "static constexpr"; }
#line 8546 "y.tab.c" /* yacc.c:1646  */
    break;

  case 266:
#line 4671 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "thread_local"; }
#line 8552 "y.tab.c" /* yacc.c:1646  */
    break;

  case 267:
#line 4672 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "static thread_local"; }
#line 8558 "y.tab.c" /* yacc.c:1646  */
    break;

  case 268:
#line 4673 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "static thread_local"; }
#line 8564 "y.tab.c" /* yacc.c:1646  */
    break;

  case 269:
#line 4674 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "extern thread_local"; }
#line 8570 "y.tab.c" /* yacc.c:1646  */
    break;

  case 270:
#line 4675 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "extern thread_local"; }
#line 8576 "y.tab.c" /* yacc.c:1646  */
    break;

  case 271:
#line 4676 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = 0; }
#line 8582 "y.tab.c" /* yacc.c:1646  */
    break;

  case 272:
#line 4683 "parser.y" /* yacc.c:1646  */
    {
                 Parm *p;
		 (yyval.pl) = (yyvsp[0].pl);
		 p = (yyvsp[0].pl);
                 while (p) {
		   Replace(Getattr(p,"type"),"typename ", "", DOH_REPLACE_ANY);
		   p = nextSibling(p);
                 }
               }
#line 8596 "y.tab.c" /* yacc.c:1646  */
    break;

  case 273:
#line 4694 "parser.y" /* yacc.c:1646  */
    {
                  set_nextSibling((yyvsp[-1].p),(yyvsp[0].pl));
                  (yyval.pl) = (yyvsp[-1].p);
		}
#line 8605 "y.tab.c" /* yacc.c:1646  */
    break;

  case 274:
#line 4698 "parser.y" /* yacc.c:1646  */
    { (yyval.pl) = 0; }
#line 8611 "y.tab.c" /* yacc.c:1646  */
    break;

  case 275:
#line 4701 "parser.y" /* yacc.c:1646  */
    {
                 set_nextSibling((yyvsp[-1].p),(yyvsp[0].pl));
		 (yyval.pl) = (yyvsp[-1].p);
                }
#line 8620 "y.tab.c" /* yacc.c:1646  */
    break;

  case 276:
#line 4705 "parser.y" /* yacc.c:1646  */
    { (yyval.pl) = 0; }
#line 8626 "y.tab.c" /* yacc.c:1646  */
    break;

  case 277:
#line 4709 "parser.y" /* yacc.c:1646  */
    {
                   SwigType_push((yyvsp[-1].type),(yyvsp[0].decl).type);
		   (yyval.p) = NewParmWithoutFileLineInfo((yyvsp[-1].type),(yyvsp[0].decl).id);
		   Setfile((yyval.p),cparse_file);
		   Setline((yyval.p),cparse_line);
		   if ((yyvsp[0].decl).defarg) {
		     Setattr((yyval.p),"value",(yyvsp[0].decl).defarg);
		   }
		}
#line 8640 "y.tab.c" /* yacc.c:1646  */
    break;

  case 278:
#line 4719 "parser.y" /* yacc.c:1646  */
    {
                  (yyval.p) = NewParmWithoutFileLineInfo(NewStringf("template<class> %s %s", (yyvsp[-2].id),(yyvsp[-1].str)), 0);
		  Setfile((yyval.p),cparse_file);
		  Setline((yyval.p),cparse_line);
                  if ((yyvsp[0].dtype).val) {
                    Setattr((yyval.p),"value",(yyvsp[0].dtype).val);
                  }
                }
#line 8653 "y.tab.c" /* yacc.c:1646  */
    break;

  case 279:
#line 4727 "parser.y" /* yacc.c:1646  */
    {
		  SwigType *t = NewString("v(...)");
		  (yyval.p) = NewParmWithoutFileLineInfo(t, 0);
		  Setfile((yyval.p),cparse_file);
		  Setline((yyval.p),cparse_line);
		}
#line 8664 "y.tab.c" /* yacc.c:1646  */
    break;

  case 280:
#line 4735 "parser.y" /* yacc.c:1646  */
    {
                 Parm *p;
		 (yyval.p) = (yyvsp[0].p);
		 p = (yyvsp[0].p);
                 while (p) {
		   if (Getattr(p,"type")) {
		     Replace(Getattr(p,"type"),"typename ", "", DOH_REPLACE_ANY);
		   }
		   p = nextSibling(p);
                 }
               }
#line 8680 "y.tab.c" /* yacc.c:1646  */
    break;

  case 281:
#line 4748 "parser.y" /* yacc.c:1646  */
    {
                  set_nextSibling((yyvsp[-1].p),(yyvsp[0].p));
                  (yyval.p) = (yyvsp[-1].p);
		}
#line 8689 "y.tab.c" /* yacc.c:1646  */
    break;

  case 282:
#line 4752 "parser.y" /* yacc.c:1646  */
    { (yyval.p) = 0; }
#line 8695 "y.tab.c" /* yacc.c:1646  */
    break;

  case 283:
#line 4755 "parser.y" /* yacc.c:1646  */
    {
                 set_nextSibling((yyvsp[-1].p),(yyvsp[0].p));
		 (yyval.p) = (yyvsp[-1].p);
                }
#line 8704 "y.tab.c" /* yacc.c:1646  */
    break;

  case 284:
#line 4759 "parser.y" /* yacc.c:1646  */
    { (yyval.p) = 0; }
#line 8710 "y.tab.c" /* yacc.c:1646  */
    break;

  case 285:
#line 4763 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.p) = (yyvsp[0].p);
		  {
		    /* We need to make a possible adjustment for integer parameters. */
		    SwigType *type;
		    Node     *n = 0;

		    while (!n) {
		      type = Getattr((yyvsp[0].p),"type");
		      n = Swig_symbol_clookup(type,0);     /* See if we can find a node that matches the typename */
		      if ((n) && (Strcmp(nodeType(n),"cdecl") == 0)) {
			SwigType *decl = Getattr(n,"decl");
			if (!SwigType_isfunction(decl)) {
			  String *value = Getattr(n,"value");
			  if (value) {
			    String *v = Copy(value);
			    Setattr((yyvsp[0].p),"type",v);
			    Delete(v);
			    n = 0;
			  }
			}
		      } else {
			break;
		      }
		    }
		  }

               }
#line 8743 "y.tab.c" /* yacc.c:1646  */
    break;

  case 286:
#line 4791 "parser.y" /* yacc.c:1646  */
    {
                  (yyval.p) = NewParmWithoutFileLineInfo(0,0);
                  Setfile((yyval.p),cparse_file);
		  Setline((yyval.p),cparse_line);
		  Setattr((yyval.p),"value",(yyvsp[0].dtype).val);
               }
#line 8754 "y.tab.c" /* yacc.c:1646  */
    break;

  case 287:
#line 4799 "parser.y" /* yacc.c:1646  */
    { 
                  (yyval.dtype) = (yyvsp[0].dtype); 
		  if ((yyvsp[0].dtype).type == T_ERROR) {
		    Swig_warning(WARN_PARSE_BAD_DEFAULT,cparse_file, cparse_line, "Can't set default argument (ignored)\n");
		    (yyval.dtype).val = 0;
		    (yyval.dtype).rawval = 0;
		    (yyval.dtype).bitfield = 0;
		    (yyval.dtype).throws = 0;
		    (yyval.dtype).throwf = 0;
		    (yyval.dtype).nexcept = 0;
		  }
               }
#line 8771 "y.tab.c" /* yacc.c:1646  */
    break;

  case 288:
#line 4811 "parser.y" /* yacc.c:1646  */
    { 
		  (yyval.dtype) = (yyvsp[-3].dtype);
		  if ((yyvsp[-3].dtype).type == T_ERROR) {
		    Swig_warning(WARN_PARSE_BAD_DEFAULT,cparse_file, cparse_line, "Can't set default argument (ignored)\n");
		    (yyval.dtype) = (yyvsp[-3].dtype);
		    (yyval.dtype).val = 0;
		    (yyval.dtype).rawval = 0;
		    (yyval.dtype).bitfield = 0;
		    (yyval.dtype).throws = 0;
		    (yyval.dtype).throwf = 0;
		    (yyval.dtype).nexcept = 0;
		  } else {
		    (yyval.dtype).val = NewStringf("%s[%s]",(yyvsp[-3].dtype).val,(yyvsp[-1].dtype).val); 
		  }		  
               }
#line 8791 "y.tab.c" /* yacc.c:1646  */
    break;

  case 289:
#line 4826 "parser.y" /* yacc.c:1646  */
    {
		 skip_balanced('{','}');
		 (yyval.dtype).val = NewString(scanner_ccode);
		 (yyval.dtype).rawval = 0;
                 (yyval.dtype).type = T_INT;
		 (yyval.dtype).bitfield = 0;
		 (yyval.dtype).throws = 0;
		 (yyval.dtype).throwf = 0;
		 (yyval.dtype).nexcept = 0;
	       }
#line 8806 "y.tab.c" /* yacc.c:1646  */
    break;

  case 290:
#line 4836 "parser.y" /* yacc.c:1646  */
    { 
		 (yyval.dtype).val = 0;
		 (yyval.dtype).rawval = 0;
		 (yyval.dtype).type = 0;
		 (yyval.dtype).bitfield = (yyvsp[0].dtype).val;
		 (yyval.dtype).throws = 0;
		 (yyval.dtype).throwf = 0;
		 (yyval.dtype).nexcept = 0;
	       }
#line 8820 "y.tab.c" /* yacc.c:1646  */
    break;

  case 291:
#line 4845 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.dtype).val = 0;
                 (yyval.dtype).rawval = 0;
                 (yyval.dtype).type = T_INT;
		 (yyval.dtype).bitfield = 0;
		 (yyval.dtype).throws = 0;
		 (yyval.dtype).throwf = 0;
		 (yyval.dtype).nexcept = 0;
               }
#line 8834 "y.tab.c" /* yacc.c:1646  */
    break;

  case 292:
#line 4856 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.decl) = (yyvsp[-1].decl);
		 (yyval.decl).defarg = (yyvsp[0].dtype).rawval ? (yyvsp[0].dtype).rawval : (yyvsp[0].dtype).val;
            }
#line 8843 "y.tab.c" /* yacc.c:1646  */
    break;

  case 293:
#line 4860 "parser.y" /* yacc.c:1646  */
    {
              (yyval.decl) = (yyvsp[-1].decl);
	      (yyval.decl).defarg = (yyvsp[0].dtype).rawval ? (yyvsp[0].dtype).rawval : (yyvsp[0].dtype).val;
            }
#line 8852 "y.tab.c" /* yacc.c:1646  */
    break;

  case 294:
#line 4864 "parser.y" /* yacc.c:1646  */
    {
   	      (yyval.decl).type = 0;
              (yyval.decl).id = 0;
	      (yyval.decl).defarg = (yyvsp[0].dtype).rawval ? (yyvsp[0].dtype).rawval : (yyvsp[0].dtype).val;
            }
#line 8862 "y.tab.c" /* yacc.c:1646  */
    break;

  case 295:
#line 4871 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.decl) = (yyvsp[0].decl);
		 if (SwigType_isfunction((yyvsp[0].decl).type)) {
		   Delete(SwigType_pop_function((yyvsp[0].decl).type));
		 } else if (SwigType_isarray((yyvsp[0].decl).type)) {
		   SwigType *ta = SwigType_pop_arrays((yyvsp[0].decl).type);
		   if (SwigType_isfunction((yyvsp[0].decl).type)) {
		     Delete(SwigType_pop_function((yyvsp[0].decl).type));
		   } else {
		     (yyval.decl).parms = 0;
		   }
		   SwigType_push((yyvsp[0].decl).type,ta);
		   Delete(ta);
		 } else {
		   (yyval.decl).parms = 0;
		 }
            }
#line 8884 "y.tab.c" /* yacc.c:1646  */
    break;

  case 296:
#line 4888 "parser.y" /* yacc.c:1646  */
    {
              (yyval.decl) = (yyvsp[0].decl);
	      if (SwigType_isfunction((yyvsp[0].decl).type)) {
		Delete(SwigType_pop_function((yyvsp[0].decl).type));
	      } else if (SwigType_isarray((yyvsp[0].decl).type)) {
		SwigType *ta = SwigType_pop_arrays((yyvsp[0].decl).type);
		if (SwigType_isfunction((yyvsp[0].decl).type)) {
		  Delete(SwigType_pop_function((yyvsp[0].decl).type));
		} else {
		  (yyval.decl).parms = 0;
		}
		SwigType_push((yyvsp[0].decl).type,ta);
		Delete(ta);
	      } else {
		(yyval.decl).parms = 0;
	      }
            }
#line 8906 "y.tab.c" /* yacc.c:1646  */
    break;

  case 297:
#line 4905 "parser.y" /* yacc.c:1646  */
    {
   	      (yyval.decl).type = 0;
              (yyval.decl).id = 0;
	      (yyval.decl).parms = 0;
	      }
#line 8916 "y.tab.c" /* yacc.c:1646  */
    break;

  case 298:
#line 4913 "parser.y" /* yacc.c:1646  */
    {
              (yyval.decl) = (yyvsp[0].decl);
	      if ((yyval.decl).type) {
		SwigType_push((yyvsp[-1].type),(yyval.decl).type);
		Delete((yyval.decl).type);
	      }
	      (yyval.decl).type = (yyvsp[-1].type);
           }
#line 8929 "y.tab.c" /* yacc.c:1646  */
    break;

  case 299:
#line 4921 "parser.y" /* yacc.c:1646  */
    {
              (yyval.decl) = (yyvsp[0].decl);
	      SwigType_add_reference((yyvsp[-2].type));
              if ((yyval.decl).type) {
		SwigType_push((yyvsp[-2].type),(yyval.decl).type);
		Delete((yyval.decl).type);
	      }
	      (yyval.decl).type = (yyvsp[-2].type);
           }
#line 8943 "y.tab.c" /* yacc.c:1646  */
    break;

  case 300:
#line 4930 "parser.y" /* yacc.c:1646  */
    {
              (yyval.decl) = (yyvsp[0].decl);
	      SwigType_add_rvalue_reference((yyvsp[-2].type));
              if ((yyval.decl).type) {
		SwigType_push((yyvsp[-2].type),(yyval.decl).type);
		Delete((yyval.decl).type);
	      }
	      (yyval.decl).type = (yyvsp[-2].type);
           }
#line 8957 "y.tab.c" /* yacc.c:1646  */
    break;

  case 301:
#line 4939 "parser.y" /* yacc.c:1646  */
    {
              (yyval.decl) = (yyvsp[0].decl);
	      if (!(yyval.decl).type) (yyval.decl).type = NewStringEmpty();
           }
#line 8966 "y.tab.c" /* yacc.c:1646  */
    break;

  case 302:
#line 4943 "parser.y" /* yacc.c:1646  */
    {
	     (yyval.decl) = (yyvsp[0].decl);
	     (yyval.decl).type = NewStringEmpty();
	     SwigType_add_reference((yyval.decl).type);
	     if ((yyvsp[0].decl).type) {
	       SwigType_push((yyval.decl).type,(yyvsp[0].decl).type);
	       Delete((yyvsp[0].decl).type);
	     }
           }
#line 8980 "y.tab.c" /* yacc.c:1646  */
    break;

  case 303:
#line 4952 "parser.y" /* yacc.c:1646  */
    {
	     /* Introduced in C++11, move operator && */
             /* Adds one S/R conflict */
	     (yyval.decl) = (yyvsp[0].decl);
	     (yyval.decl).type = NewStringEmpty();
	     SwigType_add_rvalue_reference((yyval.decl).type);
	     if ((yyvsp[0].decl).type) {
	       SwigType_push((yyval.decl).type,(yyvsp[0].decl).type);
	       Delete((yyvsp[0].decl).type);
	     }
           }
#line 8996 "y.tab.c" /* yacc.c:1646  */
    break;

  case 304:
#line 4963 "parser.y" /* yacc.c:1646  */
    { 
	     SwigType *t = NewStringEmpty();

	     (yyval.decl) = (yyvsp[0].decl);
	     SwigType_add_memberpointer(t,(yyvsp[-2].str));
	     if ((yyval.decl).type) {
	       SwigType_push(t,(yyval.decl).type);
	       Delete((yyval.decl).type);
	     }
	     (yyval.decl).type = t;
	     }
#line 9012 "y.tab.c" /* yacc.c:1646  */
    break;

  case 305:
#line 4974 "parser.y" /* yacc.c:1646  */
    { 
	     SwigType *t = NewStringEmpty();
	     (yyval.decl) = (yyvsp[0].decl);
	     SwigType_add_memberpointer(t,(yyvsp[-2].str));
	     SwigType_push((yyvsp[-3].type),t);
	     if ((yyval.decl).type) {
	       SwigType_push((yyvsp[-3].type),(yyval.decl).type);
	       Delete((yyval.decl).type);
	     }
	     (yyval.decl).type = (yyvsp[-3].type);
	     Delete(t);
	   }
#line 9029 "y.tab.c" /* yacc.c:1646  */
    break;

  case 306:
#line 4986 "parser.y" /* yacc.c:1646  */
    { 
	     (yyval.decl) = (yyvsp[0].decl);
	     SwigType_add_memberpointer((yyvsp[-4].type),(yyvsp[-3].str));
	     SwigType_add_reference((yyvsp[-4].type));
	     if ((yyval.decl).type) {
	       SwigType_push((yyvsp[-4].type),(yyval.decl).type);
	       Delete((yyval.decl).type);
	     }
	     (yyval.decl).type = (yyvsp[-4].type);
	   }
#line 9044 "y.tab.c" /* yacc.c:1646  */
    break;

  case 307:
#line 4996 "parser.y" /* yacc.c:1646  */
    { 
	     SwigType *t = NewStringEmpty();
	     (yyval.decl) = (yyvsp[0].decl);
	     SwigType_add_memberpointer(t,(yyvsp[-3].str));
	     SwigType_add_reference(t);
	     if ((yyval.decl).type) {
	       SwigType_push(t,(yyval.decl).type);
	       Delete((yyval.decl).type);
	     } 
	     (yyval.decl).type = t;
	   }
#line 9060 "y.tab.c" /* yacc.c:1646  */
    break;

  case 308:
#line 5010 "parser.y" /* yacc.c:1646  */
    {
              (yyval.decl) = (yyvsp[0].decl);
	      if ((yyval.decl).type) {
		SwigType_push((yyvsp[-4].type),(yyval.decl).type);
		Delete((yyval.decl).type);
	      }
	      (yyval.decl).type = (yyvsp[-4].type);
           }
#line 9073 "y.tab.c" /* yacc.c:1646  */
    break;

  case 309:
#line 5018 "parser.y" /* yacc.c:1646  */
    {
              (yyval.decl) = (yyvsp[0].decl);
	      SwigType_add_reference((yyvsp[-5].type));
              if ((yyval.decl).type) {
		SwigType_push((yyvsp[-5].type),(yyval.decl).type);
		Delete((yyval.decl).type);
	      }
	      (yyval.decl).type = (yyvsp[-5].type);
           }
#line 9087 "y.tab.c" /* yacc.c:1646  */
    break;

  case 310:
#line 5027 "parser.y" /* yacc.c:1646  */
    {
              (yyval.decl) = (yyvsp[0].decl);
	      SwigType_add_rvalue_reference((yyvsp[-5].type));
              if ((yyval.decl).type) {
		SwigType_push((yyvsp[-5].type),(yyval.decl).type);
		Delete((yyval.decl).type);
	      }
	      (yyval.decl).type = (yyvsp[-5].type);
           }
#line 9101 "y.tab.c" /* yacc.c:1646  */
    break;

  case 311:
#line 5036 "parser.y" /* yacc.c:1646  */
    {
              (yyval.decl) = (yyvsp[0].decl);
	      if (!(yyval.decl).type) (yyval.decl).type = NewStringEmpty();
           }
#line 9110 "y.tab.c" /* yacc.c:1646  */
    break;

  case 312:
#line 5040 "parser.y" /* yacc.c:1646  */
    {
	     (yyval.decl) = (yyvsp[0].decl);
	     (yyval.decl).type = NewStringEmpty();
	     SwigType_add_reference((yyval.decl).type);
	     if ((yyvsp[0].decl).type) {
	       SwigType_push((yyval.decl).type,(yyvsp[0].decl).type);
	       Delete((yyvsp[0].decl).type);
	     }
           }
#line 9124 "y.tab.c" /* yacc.c:1646  */
    break;

  case 313:
#line 5049 "parser.y" /* yacc.c:1646  */
    {
	     /* Introduced in C++11, move operator && */
             /* Adds one S/R conflict */
	     (yyval.decl) = (yyvsp[0].decl);
	     (yyval.decl).type = NewStringEmpty();
	     SwigType_add_rvalue_reference((yyval.decl).type);
	     if ((yyvsp[0].decl).type) {
	       SwigType_push((yyval.decl).type,(yyvsp[0].decl).type);
	       Delete((yyvsp[0].decl).type);
	     }
           }
#line 9140 "y.tab.c" /* yacc.c:1646  */
    break;

  case 314:
#line 5060 "parser.y" /* yacc.c:1646  */
    { 
	     SwigType *t = NewStringEmpty();

	     (yyval.decl) = (yyvsp[0].decl);
	     SwigType_add_memberpointer(t,(yyvsp[-5].str));
	     if ((yyval.decl).type) {
	       SwigType_push(t,(yyval.decl).type);
	       Delete((yyval.decl).type);
	     }
	     (yyval.decl).type = t;
	     }
#line 9156 "y.tab.c" /* yacc.c:1646  */
    break;

  case 315:
#line 5071 "parser.y" /* yacc.c:1646  */
    { 
	     SwigType *t = NewStringEmpty();
	     (yyval.decl) = (yyvsp[0].decl);
	     SwigType_add_memberpointer(t,(yyvsp[-5].str));
	     SwigType_push((yyvsp[-6].type),t);
	     if ((yyval.decl).type) {
	       SwigType_push((yyvsp[-6].type),(yyval.decl).type);
	       Delete((yyval.decl).type);
	     }
	     (yyval.decl).type = (yyvsp[-6].type);
	     Delete(t);
	   }
#line 9173 "y.tab.c" /* yacc.c:1646  */
    break;

  case 316:
#line 5083 "parser.y" /* yacc.c:1646  */
    { 
	     (yyval.decl) = (yyvsp[0].decl);
	     SwigType_add_memberpointer((yyvsp[-7].type),(yyvsp[-6].str));
	     SwigType_add_reference((yyvsp[-7].type));
	     if ((yyval.decl).type) {
	       SwigType_push((yyvsp[-7].type),(yyval.decl).type);
	       Delete((yyval.decl).type);
	     }
	     (yyval.decl).type = (yyvsp[-7].type);
	   }
#line 9188 "y.tab.c" /* yacc.c:1646  */
    break;

  case 317:
#line 5093 "parser.y" /* yacc.c:1646  */
    { 
	     (yyval.decl) = (yyvsp[0].decl);
	     SwigType_add_memberpointer((yyvsp[-7].type),(yyvsp[-6].str));
	     SwigType_add_rvalue_reference((yyvsp[-7].type));
	     if ((yyval.decl).type) {
	       SwigType_push((yyvsp[-7].type),(yyval.decl).type);
	       Delete((yyval.decl).type);
	     }
	     (yyval.decl).type = (yyvsp[-7].type);
	   }
#line 9203 "y.tab.c" /* yacc.c:1646  */
    break;

  case 318:
#line 5103 "parser.y" /* yacc.c:1646  */
    { 
	     SwigType *t = NewStringEmpty();
	     (yyval.decl) = (yyvsp[0].decl);
	     SwigType_add_memberpointer(t,(yyvsp[-6].str));
	     SwigType_add_reference(t);
	     if ((yyval.decl).type) {
	       SwigType_push(t,(yyval.decl).type);
	       Delete((yyval.decl).type);
	     } 
	     (yyval.decl).type = t;
	   }
#line 9219 "y.tab.c" /* yacc.c:1646  */
    break;

  case 319:
#line 5114 "parser.y" /* yacc.c:1646  */
    { 
	     SwigType *t = NewStringEmpty();
	     (yyval.decl) = (yyvsp[0].decl);
	     SwigType_add_memberpointer(t,(yyvsp[-6].str));
	     SwigType_add_rvalue_reference(t);
	     if ((yyval.decl).type) {
	       SwigType_push(t,(yyval.decl).type);
	       Delete((yyval.decl).type);
	     } 
	     (yyval.decl).type = t;
	   }
#line 9235 "y.tab.c" /* yacc.c:1646  */
    break;

  case 320:
#line 5127 "parser.y" /* yacc.c:1646  */
    {
                /* Note: This is non-standard C.  Template declarator is allowed to follow an identifier */
                 (yyval.decl).id = Char((yyvsp[0].str));
		 (yyval.decl).type = 0;
		 (yyval.decl).parms = 0;
		 (yyval.decl).have_parms = 0;
                  }
#line 9247 "y.tab.c" /* yacc.c:1646  */
    break;

  case 321:
#line 5134 "parser.y" /* yacc.c:1646  */
    {
                  (yyval.decl).id = Char(NewStringf("~%s",(yyvsp[0].str)));
                  (yyval.decl).type = 0;
                  (yyval.decl).parms = 0;
                  (yyval.decl).have_parms = 0;
                  }
#line 9258 "y.tab.c" /* yacc.c:1646  */
    break;

  case 322:
#line 5142 "parser.y" /* yacc.c:1646  */
    {
                  (yyval.decl).id = Char((yyvsp[-1].str));
                  (yyval.decl).type = 0;
                  (yyval.decl).parms = 0;
                  (yyval.decl).have_parms = 0;
                  }
#line 9269 "y.tab.c" /* yacc.c:1646  */
    break;

  case 323:
#line 5158 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.decl) = (yyvsp[-1].decl);
		    if ((yyval.decl).type) {
		      SwigType_push((yyvsp[-2].type),(yyval.decl).type);
		      Delete((yyval.decl).type);
		    }
		    (yyval.decl).type = (yyvsp[-2].type);
                  }
#line 9282 "y.tab.c" /* yacc.c:1646  */
    break;

  case 324:
#line 5166 "parser.y" /* yacc.c:1646  */
    {
		    SwigType *t;
		    (yyval.decl) = (yyvsp[-1].decl);
		    t = NewStringEmpty();
		    SwigType_add_memberpointer(t,(yyvsp[-3].str));
		    if ((yyval.decl).type) {
		      SwigType_push(t,(yyval.decl).type);
		      Delete((yyval.decl).type);
		    }
		    (yyval.decl).type = t;
		    }
#line 9298 "y.tab.c" /* yacc.c:1646  */
    break;

  case 325:
#line 5177 "parser.y" /* yacc.c:1646  */
    { 
		    SwigType *t;
		    (yyval.decl) = (yyvsp[-2].decl);
		    t = NewStringEmpty();
		    SwigType_add_array(t,"");
		    if ((yyval.decl).type) {
		      SwigType_push(t,(yyval.decl).type);
		      Delete((yyval.decl).type);
		    }
		    (yyval.decl).type = t;
                  }
#line 9314 "y.tab.c" /* yacc.c:1646  */
    break;

  case 326:
#line 5188 "parser.y" /* yacc.c:1646  */
    { 
		    SwigType *t;
		    (yyval.decl) = (yyvsp[-3].decl);
		    t = NewStringEmpty();
		    SwigType_add_array(t,(yyvsp[-1].dtype).val);
		    if ((yyval.decl).type) {
		      SwigType_push(t,(yyval.decl).type);
		      Delete((yyval.decl).type);
		    }
		    (yyval.decl).type = t;
                  }
#line 9330 "y.tab.c" /* yacc.c:1646  */
    break;

  case 327:
#line 5199 "parser.y" /* yacc.c:1646  */
    {
		    SwigType *t;
                    (yyval.decl) = (yyvsp[-3].decl);
		    t = NewStringEmpty();
		    SwigType_add_function(t,(yyvsp[-1].pl));
		    if (!(yyval.decl).have_parms) {
		      (yyval.decl).parms = (yyvsp[-1].pl);
		      (yyval.decl).have_parms = 1;
		    }
		    if (!(yyval.decl).type) {
		      (yyval.decl).type = t;
		    } else {
		      SwigType_push(t, (yyval.decl).type);
		      Delete((yyval.decl).type);
		      (yyval.decl).type = t;
		    }
		  }
#line 9352 "y.tab.c" /* yacc.c:1646  */
    break;

  case 328:
#line 5218 "parser.y" /* yacc.c:1646  */
    {
                /* Note: This is non-standard C.  Template declarator is allowed to follow an identifier */
                 (yyval.decl).id = Char((yyvsp[0].str));
		 (yyval.decl).type = 0;
		 (yyval.decl).parms = 0;
		 (yyval.decl).have_parms = 0;
                  }
#line 9364 "y.tab.c" /* yacc.c:1646  */
    break;

  case 329:
#line 5226 "parser.y" /* yacc.c:1646  */
    {
                  (yyval.decl).id = Char(NewStringf("~%s",(yyvsp[0].str)));
                  (yyval.decl).type = 0;
                  (yyval.decl).parms = 0;
                  (yyval.decl).have_parms = 0;
                  }
#line 9375 "y.tab.c" /* yacc.c:1646  */
    break;

  case 330:
#line 5243 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.decl) = (yyvsp[-1].decl);
		    if ((yyval.decl).type) {
		      SwigType_push((yyvsp[-2].type),(yyval.decl).type);
		      Delete((yyval.decl).type);
		    }
		    (yyval.decl).type = (yyvsp[-2].type);
                  }
#line 9388 "y.tab.c" /* yacc.c:1646  */
    break;

  case 331:
#line 5251 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.decl) = (yyvsp[-1].decl);
		    if (!(yyval.decl).type) {
		      (yyval.decl).type = NewStringEmpty();
		    }
		    SwigType_add_reference((yyval.decl).type);
                  }
#line 9400 "y.tab.c" /* yacc.c:1646  */
    break;

  case 332:
#line 5258 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.decl) = (yyvsp[-1].decl);
		    if (!(yyval.decl).type) {
		      (yyval.decl).type = NewStringEmpty();
		    }
		    SwigType_add_rvalue_reference((yyval.decl).type);
                  }
#line 9412 "y.tab.c" /* yacc.c:1646  */
    break;

  case 333:
#line 5265 "parser.y" /* yacc.c:1646  */
    {
		    SwigType *t;
		    (yyval.decl) = (yyvsp[-1].decl);
		    t = NewStringEmpty();
		    SwigType_add_memberpointer(t,(yyvsp[-3].str));
		    if ((yyval.decl).type) {
		      SwigType_push(t,(yyval.decl).type);
		      Delete((yyval.decl).type);
		    }
		    (yyval.decl).type = t;
		    }
#line 9428 "y.tab.c" /* yacc.c:1646  */
    break;

  case 334:
#line 5276 "parser.y" /* yacc.c:1646  */
    { 
		    SwigType *t;
		    (yyval.decl) = (yyvsp[-2].decl);
		    t = NewStringEmpty();
		    SwigType_add_array(t,"");
		    if ((yyval.decl).type) {
		      SwigType_push(t,(yyval.decl).type);
		      Delete((yyval.decl).type);
		    }
		    (yyval.decl).type = t;
                  }
#line 9444 "y.tab.c" /* yacc.c:1646  */
    break;

  case 335:
#line 5287 "parser.y" /* yacc.c:1646  */
    { 
		    SwigType *t;
		    (yyval.decl) = (yyvsp[-3].decl);
		    t = NewStringEmpty();
		    SwigType_add_array(t,(yyvsp[-1].dtype).val);
		    if ((yyval.decl).type) {
		      SwigType_push(t,(yyval.decl).type);
		      Delete((yyval.decl).type);
		    }
		    (yyval.decl).type = t;
                  }
#line 9460 "y.tab.c" /* yacc.c:1646  */
    break;

  case 336:
#line 5298 "parser.y" /* yacc.c:1646  */
    {
		    SwigType *t;
                    (yyval.decl) = (yyvsp[-3].decl);
		    t = NewStringEmpty();
		    SwigType_add_function(t,(yyvsp[-1].pl));
		    if (!(yyval.decl).have_parms) {
		      (yyval.decl).parms = (yyvsp[-1].pl);
		      (yyval.decl).have_parms = 1;
		    }
		    if (!(yyval.decl).type) {
		      (yyval.decl).type = t;
		    } else {
		      SwigType_push(t, (yyval.decl).type);
		      Delete((yyval.decl).type);
		      (yyval.decl).type = t;
		    }
                 }
#line 9482 "y.tab.c" /* yacc.c:1646  */
    break;

  case 337:
#line 5318 "parser.y" /* yacc.c:1646  */
    {
		    SwigType *t;
                    Append((yyvsp[-4].str), " "); /* intervening space is mandatory */
                    Append((yyvsp[-4].str), Char((yyvsp[-3].id)));
		    (yyval.decl).id = Char((yyvsp[-4].str));
		    t = NewStringEmpty();
		    SwigType_add_function(t,(yyvsp[-1].pl));
		    if (!(yyval.decl).have_parms) {
		      (yyval.decl).parms = (yyvsp[-1].pl);
		      (yyval.decl).have_parms = 1;
		    }
		    if (!(yyval.decl).type) {
		      (yyval.decl).type = t;
		    } else {
		      SwigType_push(t, (yyval.decl).type);
		      Delete((yyval.decl).type);
		      (yyval.decl).type = t;
		    }
		  }
#line 9506 "y.tab.c" /* yacc.c:1646  */
    break;

  case 338:
#line 5339 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.decl).type = (yyvsp[0].type);
                    (yyval.decl).id = 0;
		    (yyval.decl).parms = 0;
		    (yyval.decl).have_parms = 0;
                  }
#line 9517 "y.tab.c" /* yacc.c:1646  */
    break;

  case 339:
#line 5345 "parser.y" /* yacc.c:1646  */
    { 
                     (yyval.decl) = (yyvsp[0].decl);
                     SwigType_push((yyvsp[-1].type),(yyvsp[0].decl).type);
		     (yyval.decl).type = (yyvsp[-1].type);
		     Delete((yyvsp[0].decl).type);
                  }
#line 9528 "y.tab.c" /* yacc.c:1646  */
    break;

  case 340:
#line 5351 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.decl).type = (yyvsp[-1].type);
		    SwigType_add_reference((yyval.decl).type);
		    (yyval.decl).id = 0;
		    (yyval.decl).parms = 0;
		    (yyval.decl).have_parms = 0;
		  }
#line 9540 "y.tab.c" /* yacc.c:1646  */
    break;

  case 341:
#line 5358 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.decl).type = (yyvsp[-1].type);
		    SwigType_add_rvalue_reference((yyval.decl).type);
		    (yyval.decl).id = 0;
		    (yyval.decl).parms = 0;
		    (yyval.decl).have_parms = 0;
		  }
#line 9552 "y.tab.c" /* yacc.c:1646  */
    break;

  case 342:
#line 5365 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.decl) = (yyvsp[0].decl);
		    SwigType_add_reference((yyvsp[-2].type));
		    if ((yyval.decl).type) {
		      SwigType_push((yyvsp[-2].type),(yyval.decl).type);
		      Delete((yyval.decl).type);
		    }
		    (yyval.decl).type = (yyvsp[-2].type);
                  }
#line 9566 "y.tab.c" /* yacc.c:1646  */
    break;

  case 343:
#line 5374 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.decl) = (yyvsp[0].decl);
		    SwigType_add_rvalue_reference((yyvsp[-2].type));
		    if ((yyval.decl).type) {
		      SwigType_push((yyvsp[-2].type),(yyval.decl).type);
		      Delete((yyval.decl).type);
		    }
		    (yyval.decl).type = (yyvsp[-2].type);
                  }
#line 9580 "y.tab.c" /* yacc.c:1646  */
    break;

  case 344:
#line 5383 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.decl) = (yyvsp[0].decl);
                  }
#line 9588 "y.tab.c" /* yacc.c:1646  */
    break;

  case 345:
#line 5386 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.decl) = (yyvsp[0].decl);
		    (yyval.decl).type = NewStringEmpty();
		    SwigType_add_reference((yyval.decl).type);
		    if ((yyvsp[0].decl).type) {
		      SwigType_push((yyval.decl).type,(yyvsp[0].decl).type);
		      Delete((yyvsp[0].decl).type);
		    }
                  }
#line 9602 "y.tab.c" /* yacc.c:1646  */
    break;

  case 346:
#line 5395 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.decl) = (yyvsp[0].decl);
		    (yyval.decl).type = NewStringEmpty();
		    SwigType_add_rvalue_reference((yyval.decl).type);
		    if ((yyvsp[0].decl).type) {
		      SwigType_push((yyval.decl).type,(yyvsp[0].decl).type);
		      Delete((yyvsp[0].decl).type);
		    }
                  }
#line 9616 "y.tab.c" /* yacc.c:1646  */
    break;

  case 347:
#line 5404 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.decl).id = 0;
                    (yyval.decl).parms = 0;
		    (yyval.decl).have_parms = 0;
                    (yyval.decl).type = NewStringEmpty();
		    SwigType_add_reference((yyval.decl).type);
                  }
#line 9628 "y.tab.c" /* yacc.c:1646  */
    break;

  case 348:
#line 5411 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.decl).id = 0;
                    (yyval.decl).parms = 0;
		    (yyval.decl).have_parms = 0;
                    (yyval.decl).type = NewStringEmpty();
		    SwigType_add_rvalue_reference((yyval.decl).type);
                  }
#line 9640 "y.tab.c" /* yacc.c:1646  */
    break;

  case 349:
#line 5418 "parser.y" /* yacc.c:1646  */
    { 
		    (yyval.decl).type = NewStringEmpty();
                    SwigType_add_memberpointer((yyval.decl).type,(yyvsp[-1].str));
                    (yyval.decl).id = 0;
                    (yyval.decl).parms = 0;
		    (yyval.decl).have_parms = 0;
      	          }
#line 9652 "y.tab.c" /* yacc.c:1646  */
    break;

  case 350:
#line 5425 "parser.y" /* yacc.c:1646  */
    { 
		    SwigType *t = NewStringEmpty();
                    (yyval.decl).type = (yyvsp[-2].type);
		    (yyval.decl).id = 0;
		    (yyval.decl).parms = 0;
		    (yyval.decl).have_parms = 0;
		    SwigType_add_memberpointer(t,(yyvsp[-1].str));
		    SwigType_push((yyval.decl).type,t);
		    Delete(t);
                  }
#line 9667 "y.tab.c" /* yacc.c:1646  */
    break;

  case 351:
#line 5435 "parser.y" /* yacc.c:1646  */
    { 
		    (yyval.decl) = (yyvsp[0].decl);
		    SwigType_add_memberpointer((yyvsp[-3].type),(yyvsp[-2].str));
		    if ((yyval.decl).type) {
		      SwigType_push((yyvsp[-3].type),(yyval.decl).type);
		      Delete((yyval.decl).type);
		    }
		    (yyval.decl).type = (yyvsp[-3].type);
                  }
#line 9681 "y.tab.c" /* yacc.c:1646  */
    break;

  case 352:
#line 5446 "parser.y" /* yacc.c:1646  */
    { 
		    SwigType *t;
		    (yyval.decl) = (yyvsp[-2].decl);
		    t = NewStringEmpty();
		    SwigType_add_array(t,"");
		    if ((yyval.decl).type) {
		      SwigType_push(t,(yyval.decl).type);
		      Delete((yyval.decl).type);
		    }
		    (yyval.decl).type = t;
                  }
#line 9697 "y.tab.c" /* yacc.c:1646  */
    break;

  case 353:
#line 5457 "parser.y" /* yacc.c:1646  */
    { 
		    SwigType *t;
		    (yyval.decl) = (yyvsp[-3].decl);
		    t = NewStringEmpty();
		    SwigType_add_array(t,(yyvsp[-1].dtype).val);
		    if ((yyval.decl).type) {
		      SwigType_push(t,(yyval.decl).type);
		      Delete((yyval.decl).type);
		    }
		    (yyval.decl).type = t;
                  }
#line 9713 "y.tab.c" /* yacc.c:1646  */
    break;

  case 354:
#line 5468 "parser.y" /* yacc.c:1646  */
    { 
		    (yyval.decl).type = NewStringEmpty();
		    (yyval.decl).id = 0;
		    (yyval.decl).parms = 0;
		    (yyval.decl).have_parms = 0;
		    SwigType_add_array((yyval.decl).type,"");
                  }
#line 9725 "y.tab.c" /* yacc.c:1646  */
    break;

  case 355:
#line 5475 "parser.y" /* yacc.c:1646  */
    { 
		    (yyval.decl).type = NewStringEmpty();
		    (yyval.decl).id = 0;
		    (yyval.decl).parms = 0;
		    (yyval.decl).have_parms = 0;
		    SwigType_add_array((yyval.decl).type,(yyvsp[-1].dtype).val);
		  }
#line 9737 "y.tab.c" /* yacc.c:1646  */
    break;

  case 356:
#line 5482 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.decl) = (yyvsp[-1].decl);
		  }
#line 9745 "y.tab.c" /* yacc.c:1646  */
    break;

  case 357:
#line 5485 "parser.y" /* yacc.c:1646  */
    {
		    SwigType *t;
                    (yyval.decl) = (yyvsp[-3].decl);
		    t = NewStringEmpty();
                    SwigType_add_function(t,(yyvsp[-1].pl));
		    if (!(yyval.decl).type) {
		      (yyval.decl).type = t;
		    } else {
		      SwigType_push(t,(yyval.decl).type);
		      Delete((yyval.decl).type);
		      (yyval.decl).type = t;
		    }
		    if (!(yyval.decl).have_parms) {
		      (yyval.decl).parms = (yyvsp[-1].pl);
		      (yyval.decl).have_parms = 1;
		    }
		  }
#line 9767 "y.tab.c" /* yacc.c:1646  */
    break;

  case 358:
#line 5502 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.decl).type = NewStringEmpty();
                    SwigType_add_function((yyval.decl).type,(yyvsp[-1].pl));
		    (yyval.decl).parms = (yyvsp[-1].pl);
		    (yyval.decl).have_parms = 1;
		    (yyval.decl).id = 0;
                  }
#line 9779 "y.tab.c" /* yacc.c:1646  */
    break;

  case 359:
#line 5512 "parser.y" /* yacc.c:1646  */
    { 
             (yyval.type) = NewStringEmpty();
             SwigType_add_pointer((yyval.type));
	     SwigType_push((yyval.type),(yyvsp[-1].str));
	     SwigType_push((yyval.type),(yyvsp[0].type));
	     Delete((yyvsp[0].type));
           }
#line 9791 "y.tab.c" /* yacc.c:1646  */
    break;

  case 360:
#line 5519 "parser.y" /* yacc.c:1646  */
    {
	     (yyval.type) = NewStringEmpty();
	     SwigType_add_pointer((yyval.type));
	     SwigType_push((yyval.type),(yyvsp[0].type));
	     Delete((yyvsp[0].type));
	   }
#line 9802 "y.tab.c" /* yacc.c:1646  */
    break;

  case 361:
#line 5525 "parser.y" /* yacc.c:1646  */
    { 
	     (yyval.type) = NewStringEmpty();
	     SwigType_add_pointer((yyval.type));
	     SwigType_push((yyval.type),(yyvsp[0].str));
           }
#line 9812 "y.tab.c" /* yacc.c:1646  */
    break;

  case 362:
#line 5530 "parser.y" /* yacc.c:1646  */
    {
	     (yyval.type) = NewStringEmpty();
	     SwigType_add_pointer((yyval.type));
           }
#line 9821 "y.tab.c" /* yacc.c:1646  */
    break;

  case 363:
#line 5536 "parser.y" /* yacc.c:1646  */
    {
	          (yyval.str) = NewStringEmpty();
	          if ((yyvsp[0].id)) SwigType_add_qualifier((yyval.str),(yyvsp[0].id));
               }
#line 9830 "y.tab.c" /* yacc.c:1646  */
    break;

  case 364:
#line 5540 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.str) = (yyvsp[0].str);
	          if ((yyvsp[-1].id)) SwigType_add_qualifier((yyval.str),(yyvsp[-1].id));
               }
#line 9839 "y.tab.c" /* yacc.c:1646  */
    break;

  case 365:
#line 5546 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "const"; }
#line 9845 "y.tab.c" /* yacc.c:1646  */
    break;

  case 366:
#line 5547 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = "volatile"; }
#line 9851 "y.tab.c" /* yacc.c:1646  */
    break;

  case 367:
#line 5548 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = 0; }
#line 9857 "y.tab.c" /* yacc.c:1646  */
    break;

  case 368:
#line 5554 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.type) = (yyvsp[0].type);
                   Replace((yyval.type),"typename ","", DOH_REPLACE_ANY);
                }
#line 9866 "y.tab.c" /* yacc.c:1646  */
    break;

  case 369:
#line 5560 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.type) = (yyvsp[0].type);
	           SwigType_push((yyval.type),(yyvsp[-1].str));
               }
#line 9875 "y.tab.c" /* yacc.c:1646  */
    break;

  case 370:
#line 5564 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = (yyvsp[0].type); }
#line 9881 "y.tab.c" /* yacc.c:1646  */
    break;

  case 371:
#line 5565 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.type) = (yyvsp[-1].type);
	          SwigType_push((yyval.type),(yyvsp[0].str));
	       }
#line 9890 "y.tab.c" /* yacc.c:1646  */
    break;

  case 372:
#line 5569 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.type) = (yyvsp[-1].type);
	          SwigType_push((yyval.type),(yyvsp[0].str));
	          SwigType_push((yyval.type),(yyvsp[-2].str));
	       }
#line 9900 "y.tab.c" /* yacc.c:1646  */
    break;

  case 373:
#line 5576 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = (yyvsp[0].type);
                  /* Printf(stdout,"primitive = '%s'\n", $$);*/
               }
#line 9908 "y.tab.c" /* yacc.c:1646  */
    break;

  case 374:
#line 5579 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = (yyvsp[0].type); }
#line 9914 "y.tab.c" /* yacc.c:1646  */
    break;

  case 375:
#line 5580 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = (yyvsp[0].type); }
#line 9920 "y.tab.c" /* yacc.c:1646  */
    break;

  case 376:
#line 5581 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = NewStringf("%s%s",(yyvsp[-1].type),(yyvsp[0].id)); }
#line 9926 "y.tab.c" /* yacc.c:1646  */
    break;

  case 377:
#line 5582 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = NewStringf("enum %s", (yyvsp[0].str)); }
#line 9932 "y.tab.c" /* yacc.c:1646  */
    break;

  case 378:
#line 5583 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = (yyvsp[0].type); }
#line 9938 "y.tab.c" /* yacc.c:1646  */
    break;

  case 379:
#line 5585 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.type) = (yyvsp[0].str);
               }
#line 9946 "y.tab.c" /* yacc.c:1646  */
    break;

  case 380:
#line 5588 "parser.y" /* yacc.c:1646  */
    { 
		 (yyval.type) = NewStringf("%s %s", (yyvsp[-1].id), (yyvsp[0].str));
               }
#line 9954 "y.tab.c" /* yacc.c:1646  */
    break;

  case 381:
#line 5591 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.type) = (yyvsp[0].type);
               }
#line 9962 "y.tab.c" /* yacc.c:1646  */
    break;

  case 382:
#line 5596 "parser.y" /* yacc.c:1646  */
    {
                 Node *n = Swig_symbol_clookup((yyvsp[-1].str),0);
                 if (!n) {
		   Swig_error(cparse_file, cparse_line, "Identifier %s not defined.\n", (yyvsp[-1].str));
                   (yyval.type) = (yyvsp[-1].str);
                 } else {
                   (yyval.type) = Getattr(n, "type");
                 }
               }
#line 9976 "y.tab.c" /* yacc.c:1646  */
    break;

  case 383:
#line 5607 "parser.y" /* yacc.c:1646  */
    {
		 if (!(yyvsp[0].ptype).type) (yyvsp[0].ptype).type = NewString("int");
		 if ((yyvsp[0].ptype).us) {
		   (yyval.type) = NewStringf("%s %s", (yyvsp[0].ptype).us, (yyvsp[0].ptype).type);
		   Delete((yyvsp[0].ptype).us);
                   Delete((yyvsp[0].ptype).type);
		 } else {
                   (yyval.type) = (yyvsp[0].ptype).type;
		 }
		 if (Cmp((yyval.type),"signed int") == 0) {
		   Delete((yyval.type));
		   (yyval.type) = NewString("int");
                 } else if (Cmp((yyval.type),"signed long") == 0) {
		   Delete((yyval.type));
                   (yyval.type) = NewString("long");
                 } else if (Cmp((yyval.type),"signed short") == 0) {
		   Delete((yyval.type));
		   (yyval.type) = NewString("short");
		 } else if (Cmp((yyval.type),"signed long long") == 0) {
		   Delete((yyval.type));
		   (yyval.type) = NewString("long long");
		 }
               }
#line 10004 "y.tab.c" /* yacc.c:1646  */
    break;

  case 384:
#line 5632 "parser.y" /* yacc.c:1646  */
    { 
                 (yyval.ptype) = (yyvsp[0].ptype);
               }
#line 10012 "y.tab.c" /* yacc.c:1646  */
    break;

  case 385:
#line 5635 "parser.y" /* yacc.c:1646  */
    {
                    if ((yyvsp[-1].ptype).us && (yyvsp[0].ptype).us) {
		      Swig_error(cparse_file, cparse_line, "Extra %s specifier.\n", (yyvsp[0].ptype).us);
		    }
                    (yyval.ptype) = (yyvsp[0].ptype);
                    if ((yyvsp[-1].ptype).us) (yyval.ptype).us = (yyvsp[-1].ptype).us;
		    if ((yyvsp[-1].ptype).type) {
		      if (!(yyvsp[0].ptype).type) (yyval.ptype).type = (yyvsp[-1].ptype).type;
		      else {
			int err = 0;
			if ((Cmp((yyvsp[-1].ptype).type,"long") == 0)) {
			  if ((Cmp((yyvsp[0].ptype).type,"long") == 0) || (Strncmp((yyvsp[0].ptype).type,"double",6) == 0)) {
			    (yyval.ptype).type = NewStringf("long %s", (yyvsp[0].ptype).type);
			  } else if (Cmp((yyvsp[0].ptype).type,"int") == 0) {
			    (yyval.ptype).type = (yyvsp[-1].ptype).type;
			  } else {
			    err = 1;
			  }
			} else if ((Cmp((yyvsp[-1].ptype).type,"short")) == 0) {
			  if (Cmp((yyvsp[0].ptype).type,"int") == 0) {
			    (yyval.ptype).type = (yyvsp[-1].ptype).type;
			  } else {
			    err = 1;
			  }
			} else if (Cmp((yyvsp[-1].ptype).type,"int") == 0) {
			  (yyval.ptype).type = (yyvsp[0].ptype).type;
			} else if (Cmp((yyvsp[-1].ptype).type,"double") == 0) {
			  if (Cmp((yyvsp[0].ptype).type,"long") == 0) {
			    (yyval.ptype).type = NewString("long double");
			  } else if (Cmp((yyvsp[0].ptype).type,"complex") == 0) {
			    (yyval.ptype).type = NewString("double complex");
			  } else {
			    err = 1;
			  }
			} else if (Cmp((yyvsp[-1].ptype).type,"float") == 0) {
			  if (Cmp((yyvsp[0].ptype).type,"complex") == 0) {
			    (yyval.ptype).type = NewString("float complex");
			  } else {
			    err = 1;
			  }
			} else if (Cmp((yyvsp[-1].ptype).type,"complex") == 0) {
			  (yyval.ptype).type = NewStringf("%s complex", (yyvsp[0].ptype).type);
			} else {
			  err = 1;
			}
			if (err) {
			  Swig_error(cparse_file, cparse_line, "Extra %s specifier.\n", (yyvsp[-1].ptype).type);
			}
		      }
		    }
               }
#line 10068 "y.tab.c" /* yacc.c:1646  */
    break;

  case 386:
#line 5689 "parser.y" /* yacc.c:1646  */
    { 
		    (yyval.ptype).type = NewString("int");
                    (yyval.ptype).us = 0;
               }
#line 10077 "y.tab.c" /* yacc.c:1646  */
    break;

  case 387:
#line 5693 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.ptype).type = NewString("short");
                    (yyval.ptype).us = 0;
                }
#line 10086 "y.tab.c" /* yacc.c:1646  */
    break;

  case 388:
#line 5697 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.ptype).type = NewString("long");
                    (yyval.ptype).us = 0;
                }
#line 10095 "y.tab.c" /* yacc.c:1646  */
    break;

  case 389:
#line 5701 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.ptype).type = NewString("char");
                    (yyval.ptype).us = 0;
                }
#line 10104 "y.tab.c" /* yacc.c:1646  */
    break;

  case 390:
#line 5705 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.ptype).type = NewString("wchar_t");
                    (yyval.ptype).us = 0;
                }
#line 10113 "y.tab.c" /* yacc.c:1646  */
    break;

  case 391:
#line 5709 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.ptype).type = NewString("float");
                    (yyval.ptype).us = 0;
                }
#line 10122 "y.tab.c" /* yacc.c:1646  */
    break;

  case 392:
#line 5713 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.ptype).type = NewString("double");
                    (yyval.ptype).us = 0;
                }
#line 10131 "y.tab.c" /* yacc.c:1646  */
    break;

  case 393:
#line 5717 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.ptype).us = NewString("signed");
                    (yyval.ptype).type = 0;
                }
#line 10140 "y.tab.c" /* yacc.c:1646  */
    break;

  case 394:
#line 5721 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.ptype).us = NewString("unsigned");
                    (yyval.ptype).type = 0;
                }
#line 10149 "y.tab.c" /* yacc.c:1646  */
    break;

  case 395:
#line 5725 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.ptype).type = NewString("complex");
                    (yyval.ptype).us = 0;
                }
#line 10158 "y.tab.c" /* yacc.c:1646  */
    break;

  case 396:
#line 5729 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.ptype).type = NewString("__int8");
                    (yyval.ptype).us = 0;
                }
#line 10167 "y.tab.c" /* yacc.c:1646  */
    break;

  case 397:
#line 5733 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.ptype).type = NewString("__int16");
                    (yyval.ptype).us = 0;
                }
#line 10176 "y.tab.c" /* yacc.c:1646  */
    break;

  case 398:
#line 5737 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.ptype).type = NewString("__int32");
                    (yyval.ptype).us = 0;
                }
#line 10185 "y.tab.c" /* yacc.c:1646  */
    break;

  case 399:
#line 5741 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.ptype).type = NewString("__int64");
                    (yyval.ptype).us = 0;
                }
#line 10194 "y.tab.c" /* yacc.c:1646  */
    break;

  case 400:
#line 5747 "parser.y" /* yacc.c:1646  */
    { /* scanner_check_typedef(); */ }
#line 10200 "y.tab.c" /* yacc.c:1646  */
    break;

  case 401:
#line 5747 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.dtype) = (yyvsp[0].dtype);
		   if ((yyval.dtype).type == T_STRING) {
		     (yyval.dtype).rawval = NewStringf("\"%(escape)s\"",(yyval.dtype).val);
		   } else if ((yyval.dtype).type != T_CHAR && (yyval.dtype).type != T_WSTRING && (yyval.dtype).type != T_WCHAR) {
		     (yyval.dtype).rawval = 0;
		   }
		   (yyval.dtype).qualifier = 0;
		   (yyval.dtype).bitfield = 0;
		   (yyval.dtype).throws = 0;
		   (yyval.dtype).throwf = 0;
		   (yyval.dtype).nexcept = 0;
		   scanner_ignore_typedef();
                }
#line 10219 "y.tab.c" /* yacc.c:1646  */
    break;

  case 402:
#line 5761 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.dtype) = (yyvsp[0].dtype);
		}
#line 10227 "y.tab.c" /* yacc.c:1646  */
    break;

  case 403:
#line 5777 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.dtype) = (yyvsp[0].dtype);
		}
#line 10235 "y.tab.c" /* yacc.c:1646  */
    break;

  case 404:
#line 5780 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.dtype) = (yyvsp[0].dtype);
		}
#line 10243 "y.tab.c" /* yacc.c:1646  */
    break;

  case 405:
#line 5786 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.dtype).val = NewString("delete");
		  (yyval.dtype).rawval = 0;
		  (yyval.dtype).type = T_STRING;
		  (yyval.dtype).qualifier = 0;
		  (yyval.dtype).bitfield = 0;
		  (yyval.dtype).throws = 0;
		  (yyval.dtype).throwf = 0;
		  (yyval.dtype).nexcept = 0;
		}
#line 10258 "y.tab.c" /* yacc.c:1646  */
    break;

  case 406:
#line 5799 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.dtype).val = NewString("default");
		  (yyval.dtype).rawval = 0;
		  (yyval.dtype).type = T_STRING;
		  (yyval.dtype).qualifier = 0;
		  (yyval.dtype).bitfield = 0;
		  (yyval.dtype).throws = 0;
		  (yyval.dtype).throwf = 0;
		  (yyval.dtype).nexcept = 0;
		}
#line 10273 "y.tab.c" /* yacc.c:1646  */
    break;

  case 407:
#line 5813 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (yyvsp[0].id); }
#line 10279 "y.tab.c" /* yacc.c:1646  */
    break;

  case 408:
#line 5814 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (char *) 0;}
#line 10285 "y.tab.c" /* yacc.c:1646  */
    break;

  case 409:
#line 5817 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 10291 "y.tab.c" /* yacc.c:1646  */
    break;

  case 410:
#line 5818 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 10297 "y.tab.c" /* yacc.c:1646  */
    break;

  case 411:
#line 5822 "parser.y" /* yacc.c:1646  */
    {
		 Node *leftSibling = Getattr((yyvsp[-4].node),"_last");
		 set_nextSibling(leftSibling,(yyvsp[-1].node));
		 Setattr((yyvsp[-4].node),"_last",(yyvsp[-1].node));
		 (yyval.node) = (yyvsp[-4].node);
	       }
#line 10308 "y.tab.c" /* yacc.c:1646  */
    break;

  case 412:
#line 5828 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.node) = (yyvsp[-2].node);
	       }
#line 10316 "y.tab.c" /* yacc.c:1646  */
    break;

  case 413:
#line 5831 "parser.y" /* yacc.c:1646  */
    {
		 Setattr((yyvsp[-1].node),"_last",(yyvsp[-1].node));
		 (yyval.node) = (yyvsp[-1].node);
	       }
#line 10325 "y.tab.c" /* yacc.c:1646  */
    break;

  case 414:
#line 5835 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.node) = 0;
	       }
#line 10333 "y.tab.c" /* yacc.c:1646  */
    break;

  case 415:
#line 5840 "parser.y" /* yacc.c:1646  */
    {
		   SwigType *type = NewSwigType(T_INT);
		   (yyval.node) = new_node("enumitem");
		   Setattr((yyval.node),"name",(yyvsp[0].id));
		   Setattr((yyval.node),"type",type);
		   SetFlag((yyval.node),"feature:immutable");
		   Delete(type);
		 }
#line 10346 "y.tab.c" /* yacc.c:1646  */
    break;

  case 416:
#line 5848 "parser.y" /* yacc.c:1646  */
    {
		   SwigType *type = NewSwigType((yyvsp[0].dtype).type == T_BOOL ? T_BOOL : ((yyvsp[0].dtype).type == T_CHAR ? T_CHAR : T_INT));
		   (yyval.node) = new_node("enumitem");
		   Setattr((yyval.node),"name",(yyvsp[-2].id));
		   Setattr((yyval.node),"type",type);
		   SetFlag((yyval.node),"feature:immutable");
		   Setattr((yyval.node),"enumvalue", (yyvsp[0].dtype).val);
		   Setattr((yyval.node),"value",(yyvsp[-2].id));
		   Delete(type);
                 }
#line 10361 "y.tab.c" /* yacc.c:1646  */
    break;

  case 417:
#line 5860 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.dtype) = (yyvsp[0].dtype);
		   if (((yyval.dtype).type != T_INT) && ((yyval.dtype).type != T_UINT) &&
		       ((yyval.dtype).type != T_LONG) && ((yyval.dtype).type != T_ULONG) &&
		       ((yyval.dtype).type != T_LONGLONG) && ((yyval.dtype).type != T_ULONGLONG) &&
		       ((yyval.dtype).type != T_SHORT) && ((yyval.dtype).type != T_USHORT) &&
		       ((yyval.dtype).type != T_SCHAR) && ((yyval.dtype).type != T_UCHAR) &&
		       ((yyval.dtype).type != T_CHAR) && ((yyval.dtype).type != T_BOOL)) {
		     Swig_error(cparse_file,cparse_line,"Type error. Expecting an integral type\n");
		   }
                }
#line 10377 "y.tab.c" /* yacc.c:1646  */
    break;

  case 418:
#line 5875 "parser.y" /* yacc.c:1646  */
    { (yyval.dtype) = (yyvsp[0].dtype); }
#line 10383 "y.tab.c" /* yacc.c:1646  */
    break;

  case 419:
#line 5876 "parser.y" /* yacc.c:1646  */
    {
		 Node *n;
		 (yyval.dtype).val = (yyvsp[0].type);
		 (yyval.dtype).type = T_INT;
		 /* Check if value is in scope */
		 n = Swig_symbol_clookup((yyvsp[0].type),0);
		 if (n) {
                   /* A band-aid for enum values used in expressions. */
                   if (Strcmp(nodeType(n),"enumitem") == 0) {
                     String *q = Swig_symbol_qualified(n);
                     if (q) {
                       (yyval.dtype).val = NewStringf("%s::%s", q, Getattr(n,"name"));
                       Delete(q);
                     }
                   }
		 }
               }
#line 10405 "y.tab.c" /* yacc.c:1646  */
    break;

  case 420:
#line 5895 "parser.y" /* yacc.c:1646  */
    { (yyval.dtype) = (yyvsp[0].dtype); }
#line 10411 "y.tab.c" /* yacc.c:1646  */
    break;

  case 421:
#line 5896 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.dtype).val = NewString((yyvsp[0].id));
                    (yyval.dtype).type = T_STRING;
               }
#line 10420 "y.tab.c" /* yacc.c:1646  */
    break;

  case 422:
#line 5900 "parser.y" /* yacc.c:1646  */
    {
		  SwigType_push((yyvsp[-2].type),(yyvsp[-1].decl).type);
		  (yyval.dtype).val = NewStringf("sizeof(%s)",SwigType_str((yyvsp[-2].type),0));
		  (yyval.dtype).type = T_ULONG;
               }
#line 10430 "y.tab.c" /* yacc.c:1646  */
    break;

  case 423:
#line 5905 "parser.y" /* yacc.c:1646  */
    {
		  SwigType_push((yyvsp[-2].type),(yyvsp[-1].decl).type);
		  (yyval.dtype).val = NewStringf("sizeof...(%s)",SwigType_str((yyvsp[-2].type),0));
		  (yyval.dtype).type = T_ULONG;
               }
#line 10440 "y.tab.c" /* yacc.c:1646  */
    break;

  case 424:
#line 5910 "parser.y" /* yacc.c:1646  */
    { (yyval.dtype) = (yyvsp[0].dtype); }
#line 10446 "y.tab.c" /* yacc.c:1646  */
    break;

  case 425:
#line 5911 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.dtype).val = NewString((yyvsp[0].id));
		    (yyval.dtype).rawval = NewStringf("L\"%s\"", (yyval.dtype).val);
                    (yyval.dtype).type = T_WSTRING;
	       }
#line 10456 "y.tab.c" /* yacc.c:1646  */
    break;

  case 426:
#line 5916 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.dtype).val = NewString((yyvsp[0].str));
		  if (Len((yyval.dtype).val)) {
		    (yyval.dtype).rawval = NewStringf("'%(escape)s'", (yyval.dtype).val);
		  } else {
		    (yyval.dtype).rawval = NewString("'\\0'");
		  }
		  (yyval.dtype).type = T_CHAR;
		  (yyval.dtype).bitfield = 0;
		  (yyval.dtype).throws = 0;
		  (yyval.dtype).throwf = 0;
		  (yyval.dtype).nexcept = 0;
	       }
#line 10474 "y.tab.c" /* yacc.c:1646  */
    break;

  case 427:
#line 5929 "parser.y" /* yacc.c:1646  */
    {
		  (yyval.dtype).val = NewString((yyvsp[0].str));
		  if (Len((yyval.dtype).val)) {
		    (yyval.dtype).rawval = NewStringf("L\'%s\'", (yyval.dtype).val);
		  } else {
		    (yyval.dtype).rawval = NewString("L'\\0'");
		  }
		  (yyval.dtype).type = T_WCHAR;
		  (yyval.dtype).bitfield = 0;
		  (yyval.dtype).throws = 0;
		  (yyval.dtype).throwf = 0;
		  (yyval.dtype).nexcept = 0;
	       }
#line 10492 "y.tab.c" /* yacc.c:1646  */
    break;

  case 428:
#line 5944 "parser.y" /* yacc.c:1646  */
    {
   	            (yyval.dtype).val = NewStringf("(%s)",(yyvsp[-1].dtype).val);
		    (yyval.dtype).type = (yyvsp[-1].dtype).type;
   	       }
#line 10501 "y.tab.c" /* yacc.c:1646  */
    break;

  case 429:
#line 5951 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.dtype) = (yyvsp[0].dtype);
		 if ((yyvsp[0].dtype).type != T_STRING) {
		   switch ((yyvsp[-2].dtype).type) {
		     case T_FLOAT:
		     case T_DOUBLE:
		     case T_LONGDOUBLE:
		     case T_FLTCPLX:
		     case T_DBLCPLX:
		       (yyval.dtype).val = NewStringf("(%s)%s", (yyvsp[-2].dtype).val, (yyvsp[0].dtype).val); /* SwigType_str and decimal points don't mix! */
		       break;
		     default:
		       (yyval.dtype).val = NewStringf("(%s) %s", SwigType_str((yyvsp[-2].dtype).val,0), (yyvsp[0].dtype).val);
		       break;
		   }
		 }
 	       }
#line 10523 "y.tab.c" /* yacc.c:1646  */
    break;

  case 430:
#line 5968 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.dtype) = (yyvsp[0].dtype);
		 if ((yyvsp[0].dtype).type != T_STRING) {
		   SwigType_push((yyvsp[-3].dtype).val,(yyvsp[-2].type));
		   (yyval.dtype).val = NewStringf("(%s) %s", SwigType_str((yyvsp[-3].dtype).val,0), (yyvsp[0].dtype).val);
		 }
 	       }
#line 10535 "y.tab.c" /* yacc.c:1646  */
    break;

  case 431:
#line 5975 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.dtype) = (yyvsp[0].dtype);
		 if ((yyvsp[0].dtype).type != T_STRING) {
		   SwigType_add_reference((yyvsp[-3].dtype).val);
		   (yyval.dtype).val = NewStringf("(%s) %s", SwigType_str((yyvsp[-3].dtype).val,0), (yyvsp[0].dtype).val);
		 }
 	       }
#line 10547 "y.tab.c" /* yacc.c:1646  */
    break;

  case 432:
#line 5982 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.dtype) = (yyvsp[0].dtype);
		 if ((yyvsp[0].dtype).type != T_STRING) {
		   SwigType_add_rvalue_reference((yyvsp[-3].dtype).val);
		   (yyval.dtype).val = NewStringf("(%s) %s", SwigType_str((yyvsp[-3].dtype).val,0), (yyvsp[0].dtype).val);
		 }
 	       }
#line 10559 "y.tab.c" /* yacc.c:1646  */
    break;

  case 433:
#line 5989 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.dtype) = (yyvsp[0].dtype);
		 if ((yyvsp[0].dtype).type != T_STRING) {
		   SwigType_push((yyvsp[-4].dtype).val,(yyvsp[-3].type));
		   SwigType_add_reference((yyvsp[-4].dtype).val);
		   (yyval.dtype).val = NewStringf("(%s) %s", SwigType_str((yyvsp[-4].dtype).val,0), (yyvsp[0].dtype).val);
		 }
 	       }
#line 10572 "y.tab.c" /* yacc.c:1646  */
    break;

  case 434:
#line 5997 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.dtype) = (yyvsp[0].dtype);
		 if ((yyvsp[0].dtype).type != T_STRING) {
		   SwigType_push((yyvsp[-4].dtype).val,(yyvsp[-3].type));
		   SwigType_add_rvalue_reference((yyvsp[-4].dtype).val);
		   (yyval.dtype).val = NewStringf("(%s) %s", SwigType_str((yyvsp[-4].dtype).val,0), (yyvsp[0].dtype).val);
		 }
 	       }
#line 10585 "y.tab.c" /* yacc.c:1646  */
    break;

  case 435:
#line 6005 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype) = (yyvsp[0].dtype);
                 (yyval.dtype).val = NewStringf("&%s",(yyvsp[0].dtype).val);
	       }
#line 10594 "y.tab.c" /* yacc.c:1646  */
    break;

  case 436:
#line 6009 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype) = (yyvsp[0].dtype);
                 (yyval.dtype).val = NewStringf("&&%s",(yyvsp[0].dtype).val);
	       }
#line 10603 "y.tab.c" /* yacc.c:1646  */
    break;

  case 437:
#line 6013 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype) = (yyvsp[0].dtype);
                 (yyval.dtype).val = NewStringf("*%s",(yyvsp[0].dtype).val);
	       }
#line 10612 "y.tab.c" /* yacc.c:1646  */
    break;

  case 438:
#line 6019 "parser.y" /* yacc.c:1646  */
    { (yyval.dtype) = (yyvsp[0].dtype); }
#line 10618 "y.tab.c" /* yacc.c:1646  */
    break;

  case 439:
#line 6020 "parser.y" /* yacc.c:1646  */
    { (yyval.dtype) = (yyvsp[0].dtype); }
#line 10624 "y.tab.c" /* yacc.c:1646  */
    break;

  case 440:
#line 6021 "parser.y" /* yacc.c:1646  */
    { (yyval.dtype) = (yyvsp[0].dtype); }
#line 10630 "y.tab.c" /* yacc.c:1646  */
    break;

  case 441:
#line 6022 "parser.y" /* yacc.c:1646  */
    { (yyval.dtype) = (yyvsp[0].dtype); }
#line 10636 "y.tab.c" /* yacc.c:1646  */
    break;

  case 442:
#line 6023 "parser.y" /* yacc.c:1646  */
    { (yyval.dtype) = (yyvsp[0].dtype); }
#line 10642 "y.tab.c" /* yacc.c:1646  */
    break;

  case 443:
#line 6024 "parser.y" /* yacc.c:1646  */
    { (yyval.dtype) = (yyvsp[0].dtype); }
#line 10648 "y.tab.c" /* yacc.c:1646  */
    break;

  case 444:
#line 6025 "parser.y" /* yacc.c:1646  */
    { (yyval.dtype) = (yyvsp[0].dtype); }
#line 10654 "y.tab.c" /* yacc.c:1646  */
    break;

  case 445:
#line 6026 "parser.y" /* yacc.c:1646  */
    { (yyval.dtype) = (yyvsp[0].dtype); }
#line 10660 "y.tab.c" /* yacc.c:1646  */
    break;

  case 446:
#line 6029 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s+%s",(yyvsp[-2].dtype).val,(yyvsp[0].dtype).val);
		 (yyval.dtype).type = promote((yyvsp[-2].dtype).type,(yyvsp[0].dtype).type);
	       }
#line 10669 "y.tab.c" /* yacc.c:1646  */
    break;

  case 447:
#line 6033 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s-%s",(yyvsp[-2].dtype).val,(yyvsp[0].dtype).val);
		 (yyval.dtype).type = promote((yyvsp[-2].dtype).type,(yyvsp[0].dtype).type);
	       }
#line 10678 "y.tab.c" /* yacc.c:1646  */
    break;

  case 448:
#line 6037 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s*%s",(yyvsp[-2].dtype).val,(yyvsp[0].dtype).val);
		 (yyval.dtype).type = promote((yyvsp[-2].dtype).type,(yyvsp[0].dtype).type);
	       }
#line 10687 "y.tab.c" /* yacc.c:1646  */
    break;

  case 449:
#line 6041 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s/%s",(yyvsp[-2].dtype).val,(yyvsp[0].dtype).val);
		 (yyval.dtype).type = promote((yyvsp[-2].dtype).type,(yyvsp[0].dtype).type);
	       }
#line 10696 "y.tab.c" /* yacc.c:1646  */
    break;

  case 450:
#line 6045 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s%%%s",(yyvsp[-2].dtype).val,(yyvsp[0].dtype).val);
		 (yyval.dtype).type = promote((yyvsp[-2].dtype).type,(yyvsp[0].dtype).type);
	       }
#line 10705 "y.tab.c" /* yacc.c:1646  */
    break;

  case 451:
#line 6049 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s&%s",(yyvsp[-2].dtype).val,(yyvsp[0].dtype).val);
		 (yyval.dtype).type = promote((yyvsp[-2].dtype).type,(yyvsp[0].dtype).type);
	       }
#line 10714 "y.tab.c" /* yacc.c:1646  */
    break;

  case 452:
#line 6053 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s|%s",(yyvsp[-2].dtype).val,(yyvsp[0].dtype).val);
		 (yyval.dtype).type = promote((yyvsp[-2].dtype).type,(yyvsp[0].dtype).type);
	       }
#line 10723 "y.tab.c" /* yacc.c:1646  */
    break;

  case 453:
#line 6057 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s^%s",(yyvsp[-2].dtype).val,(yyvsp[0].dtype).val);
		 (yyval.dtype).type = promote((yyvsp[-2].dtype).type,(yyvsp[0].dtype).type);
	       }
#line 10732 "y.tab.c" /* yacc.c:1646  */
    break;

  case 454:
#line 6061 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s << %s",(yyvsp[-2].dtype).val,(yyvsp[0].dtype).val);
		 (yyval.dtype).type = promote_type((yyvsp[-2].dtype).type);
	       }
#line 10741 "y.tab.c" /* yacc.c:1646  */
    break;

  case 455:
#line 6065 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s >> %s",(yyvsp[-2].dtype).val,(yyvsp[0].dtype).val);
		 (yyval.dtype).type = promote_type((yyvsp[-2].dtype).type);
	       }
#line 10750 "y.tab.c" /* yacc.c:1646  */
    break;

  case 456:
#line 6069 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s&&%s",(yyvsp[-2].dtype).val,(yyvsp[0].dtype).val);
		 (yyval.dtype).type = cparse_cplusplus ? T_BOOL : T_INT;
	       }
#line 10759 "y.tab.c" /* yacc.c:1646  */
    break;

  case 457:
#line 6073 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s||%s",(yyvsp[-2].dtype).val,(yyvsp[0].dtype).val);
		 (yyval.dtype).type = cparse_cplusplus ? T_BOOL : T_INT;
	       }
#line 10768 "y.tab.c" /* yacc.c:1646  */
    break;

  case 458:
#line 6077 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s==%s",(yyvsp[-2].dtype).val,(yyvsp[0].dtype).val);
		 (yyval.dtype).type = cparse_cplusplus ? T_BOOL : T_INT;
	       }
#line 10777 "y.tab.c" /* yacc.c:1646  */
    break;

  case 459:
#line 6081 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s!=%s",(yyvsp[-2].dtype).val,(yyvsp[0].dtype).val);
		 (yyval.dtype).type = cparse_cplusplus ? T_BOOL : T_INT;
	       }
#line 10786 "y.tab.c" /* yacc.c:1646  */
    break;

  case 460:
#line 6095 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s >= %s", (yyvsp[-2].dtype).val, (yyvsp[0].dtype).val);
		 (yyval.dtype).type = cparse_cplusplus ? T_BOOL : T_INT;
	       }
#line 10795 "y.tab.c" /* yacc.c:1646  */
    break;

  case 461:
#line 6099 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s <= %s", (yyvsp[-2].dtype).val, (yyvsp[0].dtype).val);
		 (yyval.dtype).type = cparse_cplusplus ? T_BOOL : T_INT;
	       }
#line 10804 "y.tab.c" /* yacc.c:1646  */
    break;

  case 462:
#line 6103 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("%s?%s:%s", (yyvsp[-4].dtype).val, (yyvsp[-2].dtype).val, (yyvsp[0].dtype).val);
		 /* This may not be exactly right, but is probably good enough
		  * for the purposes of parsing constant expressions. */
		 (yyval.dtype).type = promote((yyvsp[-2].dtype).type, (yyvsp[0].dtype).type);
	       }
#line 10815 "y.tab.c" /* yacc.c:1646  */
    break;

  case 463:
#line 6109 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("-%s",(yyvsp[0].dtype).val);
		 (yyval.dtype).type = (yyvsp[0].dtype).type;
	       }
#line 10824 "y.tab.c" /* yacc.c:1646  */
    break;

  case 464:
#line 6113 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.dtype).val = NewStringf("+%s",(yyvsp[0].dtype).val);
		 (yyval.dtype).type = (yyvsp[0].dtype).type;
	       }
#line 10833 "y.tab.c" /* yacc.c:1646  */
    break;

  case 465:
#line 6117 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.dtype).val = NewStringf("~%s",(yyvsp[0].dtype).val);
		 (yyval.dtype).type = (yyvsp[0].dtype).type;
	       }
#line 10842 "y.tab.c" /* yacc.c:1646  */
    break;

  case 466:
#line 6121 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.dtype).val = NewStringf("!%s",(yyvsp[0].dtype).val);
		 (yyval.dtype).type = T_INT;
	       }
#line 10851 "y.tab.c" /* yacc.c:1646  */
    break;

  case 467:
#line 6125 "parser.y" /* yacc.c:1646  */
    {
		 String *qty;
                 skip_balanced('(',')');
		 qty = Swig_symbol_type_qualify((yyvsp[-1].type),0);
		 if (SwigType_istemplate(qty)) {
		   String *nstr = SwigType_namestr(qty);
		   Delete(qty);
		   qty = nstr;
		 }
		 (yyval.dtype).val = NewStringf("%s%s",qty,scanner_ccode);
		 Clear(scanner_ccode);
		 (yyval.dtype).type = T_INT;
		 Delete(qty);
               }
#line 10870 "y.tab.c" /* yacc.c:1646  */
    break;

  case 468:
#line 6141 "parser.y" /* yacc.c:1646  */
    {
	        (yyval.str) = NewString("...");
	      }
#line 10878 "y.tab.c" /* yacc.c:1646  */
    break;

  case 469:
#line 6146 "parser.y" /* yacc.c:1646  */
    {
	        (yyval.str) = (yyvsp[0].str);
	      }
#line 10886 "y.tab.c" /* yacc.c:1646  */
    break;

  case 470:
#line 6149 "parser.y" /* yacc.c:1646  */
    {
	        (yyval.str) = 0;
	      }
#line 10894 "y.tab.c" /* yacc.c:1646  */
    break;

  case 471:
#line 6154 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.bases) = (yyvsp[0].bases);
               }
#line 10902 "y.tab.c" /* yacc.c:1646  */
    break;

  case 472:
#line 6159 "parser.y" /* yacc.c:1646  */
    { inherit_list = 1; }
#line 10908 "y.tab.c" /* yacc.c:1646  */
    break;

  case 473:
#line 6159 "parser.y" /* yacc.c:1646  */
    { (yyval.bases) = (yyvsp[0].bases); inherit_list = 0; }
#line 10914 "y.tab.c" /* yacc.c:1646  */
    break;

  case 474:
#line 6160 "parser.y" /* yacc.c:1646  */
    { (yyval.bases) = 0; }
#line 10920 "y.tab.c" /* yacc.c:1646  */
    break;

  case 475:
#line 6163 "parser.y" /* yacc.c:1646  */
    {
		   Hash *list = NewHash();
		   Node *base = (yyvsp[0].node);
		   Node *name = Getattr(base,"name");
		   List *lpublic = NewList();
		   List *lprotected = NewList();
		   List *lprivate = NewList();
		   Setattr(list,"public",lpublic);
		   Setattr(list,"protected",lprotected);
		   Setattr(list,"private",lprivate);
		   Delete(lpublic);
		   Delete(lprotected);
		   Delete(lprivate);
		   Append(Getattr(list,Getattr(base,"access")),name);
	           (yyval.bases) = list;
               }
#line 10941 "y.tab.c" /* yacc.c:1646  */
    break;

  case 476:
#line 6180 "parser.y" /* yacc.c:1646  */
    {
		   Hash *list = (yyvsp[-2].bases);
		   Node *base = (yyvsp[0].node);
		   Node *name = Getattr(base,"name");
		   Append(Getattr(list,Getattr(base,"access")),name);
                   (yyval.bases) = list;
               }
#line 10953 "y.tab.c" /* yacc.c:1646  */
    break;

  case 477:
#line 6189 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.intvalue) = cparse_line;
	       }
#line 10961 "y.tab.c" /* yacc.c:1646  */
    break;

  case 478:
#line 6191 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.node) = NewHash();
		 Setfile((yyval.node),cparse_file);
		 Setline((yyval.node),(yyvsp[-2].intvalue));
		 Setattr((yyval.node),"name",(yyvsp[-1].str));
		 Setfile((yyvsp[-1].str),cparse_file);
		 Setline((yyvsp[-1].str),(yyvsp[-2].intvalue));
                 if (last_cpptype && (Strcmp(last_cpptype,"struct") != 0)) {
		   Setattr((yyval.node),"access","private");
		   Swig_warning(WARN_PARSE_NO_ACCESS, Getfile((yyval.node)), Getline((yyval.node)), "No access specifier given for base class '%s' (ignored).\n", SwigType_namestr((yyvsp[-1].str)));
                 } else {
		   Setattr((yyval.node),"access","public");
		 }
		 if ((yyvsp[0].str))
		   SetFlag((yyval.node), "variadic");
               }
#line 10982 "y.tab.c" /* yacc.c:1646  */
    break;

  case 479:
#line 6207 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.intvalue) = cparse_line;
	       }
#line 10990 "y.tab.c" /* yacc.c:1646  */
    break;

  case 480:
#line 6209 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.node) = NewHash();
		 Setfile((yyval.node),cparse_file);
		 Setline((yyval.node),(yyvsp[-3].intvalue));
		 Setattr((yyval.node),"name",(yyvsp[-1].str));
		 Setfile((yyvsp[-1].str),cparse_file);
		 Setline((yyvsp[-1].str),(yyvsp[-3].intvalue));
		 Setattr((yyval.node),"access",(yyvsp[-4].id));
	         if (Strcmp((yyvsp[-4].id),"public") != 0) {
		   Swig_warning(WARN_PARSE_PRIVATE_INHERIT, Getfile((yyval.node)), Getline((yyval.node)), "%s inheritance from base '%s' (ignored).\n", (yyvsp[-4].id), SwigType_namestr((yyvsp[-1].str)));
		 }
		 if ((yyvsp[0].str))
		   SetFlag((yyval.node), "variadic");
               }
#line 11009 "y.tab.c" /* yacc.c:1646  */
    break;

  case 481:
#line 6225 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (char*)"public"; }
#line 11015 "y.tab.c" /* yacc.c:1646  */
    break;

  case 482:
#line 6226 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (char*)"private"; }
#line 11021 "y.tab.c" /* yacc.c:1646  */
    break;

  case 483:
#line 6227 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (char*)"protected"; }
#line 11027 "y.tab.c" /* yacc.c:1646  */
    break;

  case 484:
#line 6231 "parser.y" /* yacc.c:1646  */
    { 
                   (yyval.id) = (char*)"class"; 
		   if (!inherit_list) last_cpptype = (yyval.id);
               }
#line 11036 "y.tab.c" /* yacc.c:1646  */
    break;

  case 485:
#line 6235 "parser.y" /* yacc.c:1646  */
    { 
                   (yyval.id) = (char *)"typename"; 
		   if (!inherit_list) last_cpptype = (yyval.id);
               }
#line 11045 "y.tab.c" /* yacc.c:1646  */
    break;

  case 486:
#line 6239 "parser.y" /* yacc.c:1646  */
    { 
                   (yyval.id) = (char *)"class..."; 
		   if (!inherit_list) last_cpptype = (yyval.id);
               }
#line 11054 "y.tab.c" /* yacc.c:1646  */
    break;

  case 487:
#line 6243 "parser.y" /* yacc.c:1646  */
    { 
                   (yyval.id) = (char *)"typename..."; 
		   if (!inherit_list) last_cpptype = (yyval.id);
               }
#line 11063 "y.tab.c" /* yacc.c:1646  */
    break;

  case 488:
#line 6249 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.id) = (yyvsp[0].id);
               }
#line 11071 "y.tab.c" /* yacc.c:1646  */
    break;

  case 489:
#line 6252 "parser.y" /* yacc.c:1646  */
    { 
                   (yyval.id) = (char*)"struct"; 
		   if (!inherit_list) last_cpptype = (yyval.id);
               }
#line 11080 "y.tab.c" /* yacc.c:1646  */
    break;

  case 490:
#line 6256 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.id) = (char*)"union"; 
		   if (!inherit_list) last_cpptype = (yyval.id);
               }
#line 11089 "y.tab.c" /* yacc.c:1646  */
    break;

  case 493:
#line 6266 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.str) = 0;
	       }
#line 11097 "y.tab.c" /* yacc.c:1646  */
    break;

  case 494:
#line 6269 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.str) = 0;
	       }
#line 11105 "y.tab.c" /* yacc.c:1646  */
    break;

  case 495:
#line 6272 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.str) = 0;
	       }
#line 11113 "y.tab.c" /* yacc.c:1646  */
    break;

  case 496:
#line 6275 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.str) = 0;
	       }
#line 11121 "y.tab.c" /* yacc.c:1646  */
    break;

  case 497:
#line 6280 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.dtype).throws = (yyvsp[-1].pl);
                    (yyval.dtype).throwf = NewString("1");
                    (yyval.dtype).nexcept = 0;
	       }
#line 11131 "y.tab.c" /* yacc.c:1646  */
    break;

  case 498:
#line 6285 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.dtype).throws = 0;
                    (yyval.dtype).throwf = 0;
                    (yyval.dtype).nexcept = NewString("true");
	       }
#line 11141 "y.tab.c" /* yacc.c:1646  */
    break;

  case 499:
#line 6290 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.dtype).throws = 0;
                    (yyval.dtype).throwf = 0;
                    (yyval.dtype).nexcept = 0;
	       }
#line 11151 "y.tab.c" /* yacc.c:1646  */
    break;

  case 500:
#line 6295 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.dtype).throws = 0;
                    (yyval.dtype).throwf = 0;
                    (yyval.dtype).nexcept = NewString("true");
	       }
#line 11161 "y.tab.c" /* yacc.c:1646  */
    break;

  case 501:
#line 6300 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.dtype).throws = 0;
                    (yyval.dtype).throwf = 0;
                    (yyval.dtype).nexcept = (yyvsp[-1].dtype).val;
	       }
#line 11171 "y.tab.c" /* yacc.c:1646  */
    break;

  case 502:
#line 6307 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.dtype).throws = 0;
                    (yyval.dtype).throwf = 0;
                    (yyval.dtype).nexcept = 0;
                    (yyval.dtype).qualifier = (yyvsp[0].str);
               }
#line 11182 "y.tab.c" /* yacc.c:1646  */
    break;

  case 503:
#line 6313 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.dtype) = (yyvsp[0].dtype);
                    (yyval.dtype).qualifier = 0;
               }
#line 11191 "y.tab.c" /* yacc.c:1646  */
    break;

  case 504:
#line 6317 "parser.y" /* yacc.c:1646  */
    {
		    (yyval.dtype) = (yyvsp[0].dtype);
                    (yyval.dtype).qualifier = (yyvsp[-1].str);
               }
#line 11200 "y.tab.c" /* yacc.c:1646  */
    break;

  case 505:
#line 6321 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.dtype).throws = 0;
                    (yyval.dtype).throwf = 0;
                    (yyval.dtype).nexcept = 0;
                    (yyval.dtype).qualifier = 0; 
               }
#line 11211 "y.tab.c" /* yacc.c:1646  */
    break;

  case 506:
#line 6329 "parser.y" /* yacc.c:1646  */
    { 
                    Clear(scanner_ccode); 
                    (yyval.decl).have_parms = 0; 
                    (yyval.decl).defarg = 0; 
		    (yyval.decl).throws = (yyvsp[-2].dtype).throws;
		    (yyval.decl).throwf = (yyvsp[-2].dtype).throwf;
		    (yyval.decl).nexcept = (yyvsp[-2].dtype).nexcept;
               }
#line 11224 "y.tab.c" /* yacc.c:1646  */
    break;

  case 507:
#line 6337 "parser.y" /* yacc.c:1646  */
    { 
                    skip_balanced('{','}'); 
                    (yyval.decl).have_parms = 0; 
                    (yyval.decl).defarg = 0; 
                    (yyval.decl).throws = (yyvsp[-2].dtype).throws;
                    (yyval.decl).throwf = (yyvsp[-2].dtype).throwf;
                    (yyval.decl).nexcept = (yyvsp[-2].dtype).nexcept;
               }
#line 11237 "y.tab.c" /* yacc.c:1646  */
    break;

  case 508:
#line 6345 "parser.y" /* yacc.c:1646  */
    { 
                    Clear(scanner_ccode); 
                    (yyval.decl).parms = (yyvsp[-2].pl); 
                    (yyval.decl).have_parms = 1; 
                    (yyval.decl).defarg = 0; 
		    (yyval.decl).throws = 0;
		    (yyval.decl).throwf = 0;
		    (yyval.decl).nexcept = 0;
               }
#line 11251 "y.tab.c" /* yacc.c:1646  */
    break;

  case 509:
#line 6354 "parser.y" /* yacc.c:1646  */
    {
                    skip_balanced('{','}'); 
                    (yyval.decl).parms = (yyvsp[-2].pl); 
                    (yyval.decl).have_parms = 1; 
                    (yyval.decl).defarg = 0; 
                    (yyval.decl).throws = 0;
                    (yyval.decl).throwf = 0;
                    (yyval.decl).nexcept = 0;
               }
#line 11265 "y.tab.c" /* yacc.c:1646  */
    break;

  case 510:
#line 6363 "parser.y" /* yacc.c:1646  */
    { 
                    (yyval.decl).have_parms = 0; 
                    (yyval.decl).defarg = (yyvsp[-1].dtype).val; 
                    (yyval.decl).throws = 0;
                    (yyval.decl).throwf = 0;
                    (yyval.decl).nexcept = 0;
               }
#line 11277 "y.tab.c" /* yacc.c:1646  */
    break;

  case 511:
#line 6370 "parser.y" /* yacc.c:1646  */
    {
                    (yyval.decl).have_parms = 0;
                    (yyval.decl).defarg = (yyvsp[-1].dtype).val;
                    (yyval.decl).throws = (yyvsp[-3].dtype).throws;
                    (yyval.decl).throwf = (yyvsp[-3].dtype).throwf;
                    (yyval.decl).nexcept = (yyvsp[-3].dtype).nexcept;
               }
#line 11289 "y.tab.c" /* yacc.c:1646  */
    break;

  case 518:
#line 6389 "parser.y" /* yacc.c:1646  */
    {
		  skip_balanced('(',')');
		  Clear(scanner_ccode);
		}
#line 11298 "y.tab.c" /* yacc.c:1646  */
    break;

  case 519:
#line 6401 "parser.y" /* yacc.c:1646  */
    {
		  skip_balanced('{','}');
		  Clear(scanner_ccode);
		}
#line 11307 "y.tab.c" /* yacc.c:1646  */
    break;

  case 520:
#line 6407 "parser.y" /* yacc.c:1646  */
    { 
                     String *s = NewStringEmpty();
                     SwigType_add_template(s,(yyvsp[-1].p));
                     (yyval.id) = Char(s);
		     scanner_last_id(1);
                 }
#line 11318 "y.tab.c" /* yacc.c:1646  */
    break;

  case 521:
#line 6413 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (char*)"";  }
#line 11324 "y.tab.c" /* yacc.c:1646  */
    break;

  case 522:
#line 6417 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (yyvsp[0].id); }
#line 11330 "y.tab.c" /* yacc.c:1646  */
    break;

  case 523:
#line 6418 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = Swig_copy_string("override"); }
#line 11336 "y.tab.c" /* yacc.c:1646  */
    break;

  case 524:
#line 6419 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = Swig_copy_string("final"); }
#line 11342 "y.tab.c" /* yacc.c:1646  */
    break;

  case 525:
#line 6422 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (yyvsp[0].id); }
#line 11348 "y.tab.c" /* yacc.c:1646  */
    break;

  case 526:
#line 6423 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (yyvsp[0].dtype).val; }
#line 11354 "y.tab.c" /* yacc.c:1646  */
    break;

  case 527:
#line 6424 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (yyvsp[0].id); }
#line 11360 "y.tab.c" /* yacc.c:1646  */
    break;

  case 528:
#line 6427 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (yyvsp[0].id); }
#line 11366 "y.tab.c" /* yacc.c:1646  */
    break;

  case 529:
#line 6428 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = 0; }
#line 11372 "y.tab.c" /* yacc.c:1646  */
    break;

  case 530:
#line 6431 "parser.y" /* yacc.c:1646  */
    { 
                  (yyval.str) = 0;
		  if (!(yyval.str)) (yyval.str) = NewStringf("%s%s", (yyvsp[-1].str),(yyvsp[0].str));
      	          Delete((yyvsp[0].str));
               }
#line 11382 "y.tab.c" /* yacc.c:1646  */
    break;

  case 531:
#line 6436 "parser.y" /* yacc.c:1646  */
    { 
		 (yyval.str) = NewStringf("::%s%s",(yyvsp[-1].str),(yyvsp[0].str));
                 Delete((yyvsp[0].str));
               }
#line 11391 "y.tab.c" /* yacc.c:1646  */
    break;

  case 532:
#line 6440 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.str) = NewString((yyvsp[0].str));
   	       }
#line 11399 "y.tab.c" /* yacc.c:1646  */
    break;

  case 533:
#line 6443 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.str) = NewStringf("::%s",(yyvsp[0].str));
               }
#line 11407 "y.tab.c" /* yacc.c:1646  */
    break;

  case 534:
#line 6446 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.str) = NewString((yyvsp[0].str));
	       }
#line 11415 "y.tab.c" /* yacc.c:1646  */
    break;

  case 535:
#line 6449 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.str) = NewStringf("::%s",(yyvsp[0].str));
               }
#line 11423 "y.tab.c" /* yacc.c:1646  */
    break;

  case 536:
#line 6454 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.str) = NewStringf("::%s%s",(yyvsp[-1].str),(yyvsp[0].str));
		   Delete((yyvsp[0].str));
               }
#line 11432 "y.tab.c" /* yacc.c:1646  */
    break;

  case 537:
#line 6458 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.str) = NewStringf("::%s",(yyvsp[0].str));
               }
#line 11440 "y.tab.c" /* yacc.c:1646  */
    break;

  case 538:
#line 6461 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.str) = NewStringf("::%s",(yyvsp[0].str));
               }
#line 11448 "y.tab.c" /* yacc.c:1646  */
    break;

  case 539:
#line 6468 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.str) = NewStringf("::~%s",(yyvsp[0].str));
               }
#line 11456 "y.tab.c" /* yacc.c:1646  */
    break;

  case 540:
#line 6474 "parser.y" /* yacc.c:1646  */
    {
                  (yyval.str) = NewStringf("%s%s",(yyvsp[-1].id),(yyvsp[0].id));
		  /*		  if (Len($2)) {
		    scanner_last_id(1);
		    } */
              }
#line 11467 "y.tab.c" /* yacc.c:1646  */
    break;

  case 541:
#line 6483 "parser.y" /* yacc.c:1646  */
    {
                  (yyval.str) = 0;
		  if (!(yyval.str)) (yyval.str) = NewStringf("%s%s", (yyvsp[-1].id),(yyvsp[0].str));
      	          Delete((yyvsp[0].str));
               }
#line 11477 "y.tab.c" /* yacc.c:1646  */
    break;

  case 542:
#line 6488 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.str) = NewStringf("::%s%s",(yyvsp[-1].id),(yyvsp[0].str));
                 Delete((yyvsp[0].str));
               }
#line 11486 "y.tab.c" /* yacc.c:1646  */
    break;

  case 543:
#line 6492 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.str) = NewString((yyvsp[0].id));
   	       }
#line 11494 "y.tab.c" /* yacc.c:1646  */
    break;

  case 544:
#line 6495 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.str) = NewStringf("::%s",(yyvsp[0].id));
               }
#line 11502 "y.tab.c" /* yacc.c:1646  */
    break;

  case 545:
#line 6498 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.str) = NewString((yyvsp[0].str));
	       }
#line 11510 "y.tab.c" /* yacc.c:1646  */
    break;

  case 546:
#line 6501 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.str) = NewStringf("::%s",(yyvsp[0].str));
               }
#line 11518 "y.tab.c" /* yacc.c:1646  */
    break;

  case 547:
#line 6506 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.str) = NewStringf("::%s%s",(yyvsp[-1].id),(yyvsp[0].str));
		   Delete((yyvsp[0].str));
               }
#line 11527 "y.tab.c" /* yacc.c:1646  */
    break;

  case 548:
#line 6510 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.str) = NewStringf("::%s",(yyvsp[0].id));
               }
#line 11535 "y.tab.c" /* yacc.c:1646  */
    break;

  case 549:
#line 6513 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.str) = NewStringf("::%s",(yyvsp[0].str));
               }
#line 11543 "y.tab.c" /* yacc.c:1646  */
    break;

  case 550:
#line 6516 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.str) = NewStringf("::~%s",(yyvsp[0].id));
               }
#line 11551 "y.tab.c" /* yacc.c:1646  */
    break;

  case 551:
#line 6522 "parser.y" /* yacc.c:1646  */
    { 
                   (yyval.id) = (char *) malloc(strlen((yyvsp[-1].id))+strlen((yyvsp[0].id))+1);
                   strcpy((yyval.id),(yyvsp[-1].id));
                   strcat((yyval.id),(yyvsp[0].id));
               }
#line 11561 "y.tab.c" /* yacc.c:1646  */
    break;

  case 552:
#line 6527 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (yyvsp[0].id);}
#line 11567 "y.tab.c" /* yacc.c:1646  */
    break;

  case 553:
#line 6530 "parser.y" /* yacc.c:1646  */
    {
                   (yyval.id) = (char *) malloc(strlen((yyvsp[-1].id))+strlen((yyvsp[0].id))+1);
                   strcpy((yyval.id),(yyvsp[-1].id));
                   strcat((yyval.id),(yyvsp[0].id));
               }
#line 11577 "y.tab.c" /* yacc.c:1646  */
    break;

  case 554:
#line 6542 "parser.y" /* yacc.c:1646  */
    { (yyval.id) = (yyvsp[0].id);}
#line 11583 "y.tab.c" /* yacc.c:1646  */
    break;

  case 555:
#line 6545 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.str) = NewString((yyvsp[0].id));
               }
#line 11591 "y.tab.c" /* yacc.c:1646  */
    break;

  case 556:
#line 6548 "parser.y" /* yacc.c:1646  */
    {
                  skip_balanced('{','}');
		  (yyval.str) = NewString(scanner_ccode);
               }
#line 11600 "y.tab.c" /* yacc.c:1646  */
    break;

  case 557:
#line 6552 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.str) = (yyvsp[0].str);
              }
#line 11608 "y.tab.c" /* yacc.c:1646  */
    break;

  case 558:
#line 6557 "parser.y" /* yacc.c:1646  */
    {
                  Hash *n;
                  (yyval.node) = NewHash();
                  n = (yyvsp[-1].node);
                  while(n) {
                     String *name, *value;
                     name = Getattr(n,"name");
                     value = Getattr(n,"value");
		     if (!value) value = (String *) "1";
                     Setattr((yyval.node),name, value);
		     n = nextSibling(n);
		  }
               }
#line 11626 "y.tab.c" /* yacc.c:1646  */
    break;

  case 559:
#line 6570 "parser.y" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 11632 "y.tab.c" /* yacc.c:1646  */
    break;

  case 560:
#line 6574 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.node) = NewHash();
		 Setattr((yyval.node),"name",(yyvsp[-2].id));
		 Setattr((yyval.node),"value",(yyvsp[0].id));
               }
#line 11642 "y.tab.c" /* yacc.c:1646  */
    break;

  case 561:
#line 6579 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.node) = NewHash();
		 Setattr((yyval.node),"name",(yyvsp[-4].id));
		 Setattr((yyval.node),"value",(yyvsp[-2].id));
		 set_nextSibling((yyval.node),(yyvsp[0].node));
               }
#line 11653 "y.tab.c" /* yacc.c:1646  */
    break;

  case 562:
#line 6585 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.node) = NewHash();
                 Setattr((yyval.node),"name",(yyvsp[0].id));
	       }
#line 11662 "y.tab.c" /* yacc.c:1646  */
    break;

  case 563:
#line 6589 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.node) = NewHash();
                 Setattr((yyval.node),"name",(yyvsp[-2].id));
                 set_nextSibling((yyval.node),(yyvsp[0].node));
               }
#line 11672 "y.tab.c" /* yacc.c:1646  */
    break;

  case 564:
#line 6594 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.node) = (yyvsp[0].node);
		 Setattr((yyval.node),"name",(yyvsp[-2].id));
               }
#line 11681 "y.tab.c" /* yacc.c:1646  */
    break;

  case 565:
#line 6598 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.node) = (yyvsp[-2].node);
		 Setattr((yyval.node),"name",(yyvsp[-4].id));
		 set_nextSibling((yyval.node),(yyvsp[0].node));
               }
#line 11691 "y.tab.c" /* yacc.c:1646  */
    break;

  case 566:
#line 6605 "parser.y" /* yacc.c:1646  */
    {
		 (yyval.id) = (yyvsp[0].id);
               }
#line 11699 "y.tab.c" /* yacc.c:1646  */
    break;

  case 567:
#line 6608 "parser.y" /* yacc.c:1646  */
    {
                 (yyval.id) = Char((yyvsp[0].dtype).val);
               }
#line 11707 "y.tab.c" /* yacc.c:1646  */
    break;


#line 11711 "y.tab.c" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 6615 "parser.y" /* yacc.c:1906  */


SwigType *Swig_cparse_type(String *s) {
   String *ns;
   ns = NewStringf("%s;",s);
   Seek(ns,0,SEEK_SET);
   scanner_file(ns);
   top = 0;
   scanner_next_token(PARSETYPE);
   yyparse();
   /*   Printf(stdout,"typeparse: '%s' ---> '%s'\n", s, top); */
   return top;
}


Parm *Swig_cparse_parm(String *s) {
   String *ns;
   ns = NewStringf("%s;",s);
   Seek(ns,0,SEEK_SET);
   scanner_file(ns);
   top = 0;
   scanner_next_token(PARSEPARM);
   yyparse();
   /*   Printf(stdout,"typeparse: '%s' ---> '%s'\n", s, top); */
   Delete(ns);
   return top;
}


ParmList *Swig_cparse_parms(String *s, Node *file_line_node) {
   String *ns;
   char *cs = Char(s);
   if (cs && cs[0] != '(') {
     ns = NewStringf("(%s);",s);
   } else {
     ns = NewStringf("%s;",s);
   }
   Setfile(ns, Getfile(file_line_node));
   Setline(ns, Getline(file_line_node));
   Seek(ns,0,SEEK_SET);
   scanner_file(ns);
   top = 0;
   scanner_next_token(PARSEPARMS);
   yyparse();
   /*   Printf(stdout,"typeparse: '%s' ---> '%s'\n", s, top); */
   return top;
}

