# Contributing to syslog-ng

syslog-ng is developed as a community project, and relies on
volunteers to produce syslog-ng. Reporting bugs, testing changes,
writing code, or simply providing feedback are all important
contributions. This guide provides guidelines to make contributing
easier.

## Table of contents

1. [Issues](#issues)
 1. [Reporting issues](#reporting-issues)
 2. [Feature requests](#feature-requests)
 3. [Testing](#testing)
2. [Patches](#patches)
3. [Additional resources](#additional-resources)

## Issues

One of the easiest ways to contribute to the development of syslog-ng
is to participate in the discussions about features, bugs and design.
Some of these discussions started on the
[mailing list][ar:mailing-list], some in the
[issue tracker][ar:issue-tracker]. Bugs tagged
[`help`][ar:issues:help] are generally good targets to contribute your
feedback - but pretty much any open issue can be a good start!

We use [waffle.io][ar:waffle] as our story board, to prioritize issues
and guide the development. Use this interface for browsing existing
issues and pull requests.

### Reporting bugs

When you report a bug, it is important to share as much relevant
information as you can, including:
 * version number of syslog-ng used;
 * the platform (operating system and its version, architecture, etc);
 * a backtrace from the core file if the issue is a crash (this can be
invaluable);
 * if possible, a configuration that triggers the problem;
 * a detailed description of the issue.

To make it easy to read reports, if you send a configuration snippet,
or a backtrace, use
[fenced code blocks](https://help.github.com/articles/github-flavored-markdown#fenced-code-blocks)
around them.

### Feature requests

We use the same [issue tracker][ar:issue-tracker] to handle features
requests (they're all tagged with the
[`enhancement`](https://github.com/balabit/syslog-ng/labels/enhancement)
label. You are welcome to share your ideas on existing requests, or to
submit your own.

### Testing

An incredibly useful way to contribute is to test patches and pull
requests - there's only so much [automated testing][ar:travis] can do.
For example, you can help testing on platforms the developers do not
have access to, or try configurations not thought of before.

## Patches

Of course, we also accept patches. If you want to submit a patch, the
guidelines are very, very simple:

 1. Open an issue first, if there is none open for the particular
    issue for the topic already in the
    [issue tracker][ar:issue-tracker]. That way, other contributors
    and developers can comment the issue and the patch.
 2. If you submit a pull request that fixes an existing issue, mention
    the issue somewhere in the pull request, so we can close the
    original issue as well.
 3. We are using a coding style very similar to
    [GNU Coding Standards](https://www.gnu.org/prep/standards/standards.html#Writing-C)
    for syslog-ng. Please try to follow the existing conventions.
 4. Always add a `Signed-off-by` tag to the end of **every** commit
    message you submit.
 5. Always create a separate branch for the pull request, forked off
    from the appropriate syslog-ng branch.
 6. If your patch should be applied to multiple branches, submit
    against the latest one only, and mention which other branches are
    affected. There is no need to submit pull requests for each
    branch.
 7. If possible, write tests! We love tests.
 8. A well-documented pull request is much easier to review and merge.

Before submitting a separate module, please consider submitting it to
the [Incubator](https://github.com/balabit/syslog-ng-incubator) first,
because it is easier to have your code accepted there. The Incubator
is the repository of new and experimental modules.

## Additional resources

For additional information, have a look at the
[syslog-ng.org](http://www.syslog-ng.org/) website, which is a
recommended starting point for finding out more about syslog-ng.

To contact us, visit the [mailing list][ar:mailing-list] where you can
ask questions, and discuss your feature requests with a wider
audience.

We also have an [IRC channel][ar:irc], where developers hang out.

We are using [waffle.io][ar:waffle], built on top of
[GitHub issues][ar:issue-tracker] to track issues, feature requests
and patches. We are also using [Travis CI][ar:travis] for automatic
testing.

 [ar:irc]: irc://chat.freenode.net/#syslog-ng
 [ar:mailing-list]: http://lists.balabit.com/mailman/listinfo/syslog-ng
 [ar:issue-tracker]: https://github.com/balabit/syslog-ng/issues
 [ar:issues:help]: https://github.com/balabit/syslog-ng/labels/help
 [ar:waffle]: https://waffle.io/balabit/syslog-ng
 [ar:travis]: https://travis-ci.org/algernon/syslog-ng/
