/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.asset;

import java.io.InputStream;
import java.net.URL;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ClasspathResource;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.asset.AbstractAsset;
import org.apache.tapestry.asset.AssetMessages;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;

public class PrivateAsset
extends AbstractAsset {
    private IEngineService _assetService;

    public PrivateAsset(ClasspathResource resourceLocation, Location location) {
        this(resourceLocation, null, location);
    }

    public PrivateAsset(ClasspathResource resourceLocation, IEngineService assetService, Location location) {
        super((Resource)resourceLocation, location);
        Defense.notNull((Object)assetService, (String)"assetService");
        this._assetService = assetService;
    }

    public String buildURL() {
        String path = this.getResourceLocation().getPath();
        ILink link = this._assetService.getLink(false, path);
        return link.getURL();
    }

    public InputStream getResourceAsStream() {
        Resource location = this.getResourceLocation();
        try {
            URL url = location.getResourceURL();
            return url.openStream();
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(AssetMessages.noSuchResource(location.getPath()));
        }
    }
}

