/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.describe;

import java.util.Collection;
import java.util.Iterator;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.describe.DescribableStrategy;
import org.apache.tapestry.describe.DescribeMessages;
import org.apache.tapestry.describe.HTMLDescriptionReceiverStyles;
import org.apache.tapestry.describe.RootDescriptionReciever;

public class HTMLDescriptionReceiver
implements RootDescriptionReciever {
    static final String NULL_VALUE = "<NULL>";
    private final IMarkupWriter _writer;
    private boolean _emitDefault = true;
    private String _title;
    private String _section;
    private DescribableStrategy _strategy;
    private HTMLDescriptionReceiverStyles _styles;
    private boolean _even = true;

    public HTMLDescriptionReceiver(IMarkupWriter writer, DescribableStrategy adapter) {
        this(writer, adapter, new HTMLDescriptionReceiverStyles());
    }

    public HTMLDescriptionReceiver(IMarkupWriter writer, DescribableStrategy strategy, HTMLDescriptionReceiverStyles styles) {
        Defense.notNull((Object)writer, (String)"writer");
        Defense.notNull((Object)strategy, (String)"strategy");
        Defense.notNull((Object)styles, (String)"styles");
        this._writer = writer;
        this._strategy = strategy;
        this._styles = styles;
    }

    public void describe(Object object) {
        if (object == null) {
            this._writer.print(NULL_VALUE);
            return;
        }
        this._strategy.describeObject(object, this);
        this.finishUp(object);
    }

    public void describeAlternate(Object alternate) {
        this._strategy.describeObject(alternate, this);
    }

    public void finishUp() {
        if (!this._emitDefault) {
            this._writer.end("table");
        }
        this._writer.println();
        this._emitDefault = true;
        this._title = null;
        this._section = null;
        this._even = true;
    }

    void finishUp(Object object) {
        if (this._emitDefault) {
            String value = this._title != null ? this._title : object.toString();
            this._writer.print(value);
        }
        this.finishUp();
    }

    public void title(String title) {
        Defense.notNull((Object)title, (String)"title");
        if (this._title != null) {
            throw new IllegalStateException(DescribeMessages.setTitleOnce());
        }
        this._title = title;
    }

    public void section(String section) {
        Defense.notNull((Object)section, (String)"section");
        if (this._title == null) {
            throw new IllegalStateException(DescribeMessages.mustSetTitleBeforeSection());
        }
        this._section = section;
    }

    private void assertTitleSet() {
        if (this._title == null) {
            throw new IllegalStateException(DescribeMessages.mustSetTitleBeforeProperty());
        }
    }

    private void emitSection() {
        if (this._emitDefault) {
            this._emitDefault = false;
            this._writer.begin("div");
            this._writer.attribute("class", this._styles.getHeaderClass());
            this._writer.print(this._title);
            this._writer.end();
            this._writer.println();
            this._writer.begin("table");
            this._writer.attribute("class", this._styles.getTableClass());
            this._writer.println();
            this._even = true;
        }
        if (this._section != null) {
            this._writer.begin("tr");
            this._writer.attribute("class", this._styles.getSubheaderClass());
            this._writer.begin("th");
            this._writer.attribute("colspan", 2);
            this._writer.print(this._section);
            this._writer.end("tr");
            this._writer.println();
            this._section = null;
            this._even = true;
        }
    }

    private void pair(String key, String value) {
        this.assertTitleSet();
        this.emitSection();
        this._writer.begin("tr");
        this.writeRowClass();
        this._writer.begin("th");
        this._writer.print(key);
        this._writer.end();
        this._writer.begin("td");
        this._writer.print(value);
        this._writer.end("tr");
        this._writer.println();
    }

    private void writeRowClass() {
        this._writer.attribute("class", this._even ? "even" : "odd");
        this._even = !this._even;
    }

    public void property(String key, Object value) {
        Defense.notNull((Object)key, (String)"key");
        this.assertTitleSet();
        this.emitSection();
        this._writer.begin("tr");
        this.writeRowClass();
        this._writer.begin("th");
        this._writer.print(key);
        this._writer.end();
        this._writer.begin("td");
        this.describeNested(value);
        this._writer.end("tr");
        this._writer.println();
    }

    private void describeNested(Object value) {
        if (value == null) {
            this._writer.print(NULL_VALUE);
            return;
        }
        new HTMLDescriptionReceiver(this._writer, this._strategy, this._styles).describe(value);
    }

    public void property(String key, boolean value) {
        Defense.notNull((Object)key, (String)"key");
        this.pair(key, value ? "true" : "false");
    }

    public void property(String key, byte value) {
        Defense.notNull((Object)key, (String)"key");
        this.pair(key, Byte.toString(value));
    }

    public void property(String key, short value) {
        Defense.notNull((Object)key, (String)"key");
        this.pair(key, Short.toString(value));
    }

    public void property(String key, int value) {
        Defense.notNull((Object)key, (String)"key");
        this.pair(key, Integer.toString(value));
    }

    public void property(String key, long value) {
        Defense.notNull((Object)key, (String)"key");
        this.pair(key, Long.toString(value));
    }

    public void property(String key, float value) {
        Defense.notNull((Object)key, (String)"key");
        this.pair(key, Float.toString(value));
    }

    public void property(String key, double value) {
        Defense.notNull((Object)key, (String)"key");
        this.pair(key, Double.toString(value));
    }

    public void property(String key, char value) {
        Defense.notNull((Object)key, (String)"key");
        this.pair(key, Character.toString(value));
    }

    public void array(String key, Object[] values) {
        Defense.notNull((Object)key, (String)"key");
        this.assertTitleSet();
        if (values == null || values.length == 0) {
            return;
        }
        this.emitSection();
        for (int i = 0; i < values.length; ++i) {
            this._writer.begin("tr");
            this.writeRowClass();
            this._writer.begin("th");
            if (i == 0) {
                this._writer.print(key);
            }
            this._writer.end();
            this._writer.begin("td");
            this.describeNested(values[i]);
            this._writer.end("tr");
            this._writer.println();
        }
    }

    public void collection(String key, Collection values) {
        Defense.notNull((Object)key, (String)"key");
        this.assertTitleSet();
        if (values == null || values.isEmpty()) {
            return;
        }
        this.emitSection();
        Iterator i = values.iterator();
        boolean first = true;
        while (i.hasNext()) {
            this._writer.begin("tr");
            this.writeRowClass();
            this._writer.begin("th");
            if (first) {
                this._writer.print(key);
            }
            this._writer.end();
            this._writer.begin("td");
            this.describeNested(i.next());
            this._writer.end("tr");
            this._writer.println();
            first = false;
        }
    }
}

