/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.ClassFab;
import org.apache.hivemind.service.ClassFactory;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.Defense;
import org.apache.hivemind.util.ToStringBuilder;
import org.apache.tapestry.enhance.ComponentConstructorImpl;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.JavaClassMapping;
import org.apache.tapestry.services.ComponentConstructor;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.util.IdAllocator;
import org.apache.tapestry.util.ObjectIdentityMap;

public class EnhancementOperationImpl
implements EnhancementOperation {
    private ClassResolver _resolver;
    private IComponentSpecification _specification;
    private Class _baseClass;
    private ClassFab _classFab;
    private final Set _claimedProperties = new HashSet();
    private final JavaClassMapping _javaClassMapping = new JavaClassMapping();
    private final List _constructorTypes = new ArrayList();
    private final List _constructorArguments = new ArrayList();
    private final ObjectIdentityMap _finalFields = new ObjectIdentityMap();
    private Set _addedInterfaces = new HashSet();
    private Map _incompleteMethods = new HashMap();
    private Map _properties = new HashMap();
    private BodyBuilder _constructorBuilder;
    private final IdAllocator _idAllocator = new IdAllocator();
    private final Map _methods = new HashMap();
    private final Log _log;
    static int _uid = 0;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Object;

    public EnhancementOperationImpl(ClassResolver classResolver, IComponentSpecification specification, Class baseClass, ClassFactory classFactory, Log log) {
        Defense.notNull((Object)classResolver, (String)"classResolver");
        Defense.notNull((Object)specification, (String)"specification");
        Defense.notNull((Object)baseClass, (String)"baseClass");
        Defense.notNull((Object)classFactory, (String)"classFactory");
        this._resolver = classResolver;
        this._specification = specification;
        this._baseClass = baseClass;
        this.introspectBaseClass();
        String name = this.newClassName();
        this._classFab = classFactory.newClass(name, this._baseClass);
        this._log = log;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("baseClass", this._baseClass.getName());
        builder.append("claimedProperties", (Object)this._claimedProperties);
        builder.append("classFab", (Object)this._classFab);
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectBaseClass() {
        try {
            Object object = HiveMind.INTROSPECTOR_MUTEX;
            synchronized (object) {
                this.addPropertiesDeclaredInBaseClass();
            }
        }
        catch (IntrospectionException ex) {
            throw new ApplicationRuntimeException(EnhanceMessages.unabelToIntrospectClass(this._baseClass, ex), (Throwable)ex);
        }
    }

    private void addPropertiesDeclaredInBaseClass() throws IntrospectionException {
        Class introspectClass;
        this.addPropertiesDeclaredInClass(introspectClass);
        ArrayList interfaceQueue = new ArrayList();
        for (introspectClass = this._baseClass; introspectClass != null; introspectClass = introspectClass.getSuperclass()) {
            this.addInterfacesToQueue(introspectClass, interfaceQueue);
        }
        while (!interfaceQueue.isEmpty()) {
            Class interfaceClass = (Class)interfaceQueue.remove(0);
            this.addPropertiesDeclaredInClass(interfaceClass);
            this.addInterfacesToQueue(interfaceClass, interfaceQueue);
        }
    }

    private void addInterfacesToQueue(Class introspectClass, List interfaceQueue) {
        Class<?>[] interfaces = introspectClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceQueue.add(interfaces[i]);
        }
    }

    private void addPropertiesDeclaredInClass(Class introspectClass) throws IntrospectionException {
        BeanInfo bi = Introspector.getBeanInfo(introspectClass);
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            String name = pd.getName();
            if (this._properties.containsKey(name)) continue;
            this._properties.put(name, pd);
        }
    }

    EnhancementOperationImpl() {
        this._log = null;
    }

    public void claimProperty(String propertyName) {
        Defense.notNull((Object)propertyName, (String)"propertyName");
        if (this._claimedProperties.contains(propertyName)) {
            throw new ApplicationRuntimeException(EnhanceMessages.claimedProperty(propertyName));
        }
        this._claimedProperties.add(propertyName);
    }

    public void claimReadonlyProperty(String propertyName) {
        this.claimProperty(propertyName);
        PropertyDescriptor pd = this.getPropertyDescriptor(propertyName);
        if (pd != null && pd.getWriteMethod() != null) {
            throw new ApplicationRuntimeException(EnhanceMessages.readonlyProperty(propertyName, pd.getWriteMethod()));
        }
    }

    public void addField(String name, Class type) {
        this._classFab.addField(name, type);
    }

    public String addInjectedField(String fieldName, Class fieldType, Object value) {
        Defense.notNull((Object)fieldName, (String)"fieldName");
        Defense.notNull((Object)fieldType, (String)"fieldType");
        Defense.notNull((Object)value, (String)"value");
        String existing = (String)this._finalFields.get(value);
        if (existing != null) {
            return existing;
        }
        String uniqueName = this._idAllocator.allocateId(fieldName);
        this._classFab.addField(uniqueName, fieldType);
        int parameterIndex = this.addConstructorParameter(fieldType, value);
        this.constructorBuilder().addln("{0} = ${1};", (Object)uniqueName, (Object)Integer.toString(parameterIndex));
        this._finalFields.put(value, uniqueName);
        return uniqueName;
    }

    public Class convertTypeName(String type) {
        Defense.notNull((Object)type, (String)"type");
        Class result = this._javaClassMapping.getType(type);
        if (result == null) {
            result = this._resolver.findClass(type);
            this._javaClassMapping.recordType(type, result);
        }
        return result;
    }

    public Class getPropertyType(String name) {
        Defense.notNull((Object)name, (String)"name");
        PropertyDescriptor pd = this.getPropertyDescriptor(name);
        return pd == null ? null : pd.getPropertyType();
    }

    public void validateProperty(String name, Class expectedType) {
        Defense.notNull((Object)name, (String)"name");
        Defense.notNull((Object)expectedType, (String)"expectedType");
        PropertyDescriptor pd = this.getPropertyDescriptor(name);
        if (pd == null) {
            return;
        }
        Class<?> propertyType = pd.getPropertyType();
        if (propertyType.equals(expectedType)) {
            return;
        }
        throw new ApplicationRuntimeException(EnhanceMessages.propertyTypeMismatch(this._baseClass, name, propertyType, expectedType));
    }

    private PropertyDescriptor getPropertyDescriptor(String name) {
        return (PropertyDescriptor)this._properties.get(name);
    }

    public String getAccessorMethodName(String propertyName) {
        Defense.notNull((Object)propertyName, (String)"propertyName");
        PropertyDescriptor pd = this.getPropertyDescriptor(propertyName);
        if (pd != null && pd.getReadMethod() != null) {
            return pd.getReadMethod().getName();
        }
        return EnhanceUtils.createAccessorMethodName(propertyName);
    }

    public void addMethod(int modifier, MethodSignature sig, String methodBody, Location location) {
        Defense.notNull((Object)sig, (String)"sig");
        Defense.notNull((Object)methodBody, (String)"methodBody");
        Defense.notNull((Object)location, (String)"location");
        Location existing = (Location)this._methods.get(sig);
        if (existing != null) {
            throw new ApplicationRuntimeException(EnhanceMessages.methodConflict(sig, existing), location, null);
        }
        this._methods.put(sig, location);
        this._classFab.addMethod(modifier, sig, methodBody);
    }

    public Class getBaseClass() {
        return this._baseClass;
    }

    public String getClassReference(Class clazz) {
        Defense.notNull((Object)clazz, (String)"clazz");
        String result = (String)this._finalFields.get(clazz);
        if (result == null) {
            result = this.addClassReference(clazz);
        }
        return result;
    }

    private String addClassReference(Class clazz) {
        StringBuffer buffer = new StringBuffer("_class$");
        Class<?> c = clazz;
        while (c.isArray()) {
            buffer.append("array$");
            c = c.getComponentType();
        }
        buffer.append(c.getName().replace('.', '$'));
        String fieldName = buffer.toString();
        return this.addInjectedField(fieldName, class$java$lang$Class == null ? (class$java$lang$Class = EnhancementOperationImpl.class$("java.lang.Class")) : class$java$lang$Class, clazz);
    }

    private int addConstructorParameter(Class type, Object value) {
        this._constructorTypes.add(type);
        this._constructorArguments.add(value);
        return this._constructorArguments.size();
    }

    private BodyBuilder constructorBuilder() {
        if (this._constructorBuilder == null) {
            this._constructorBuilder = new BodyBuilder();
            this._constructorBuilder.begin();
        }
        return this._constructorBuilder;
    }

    public ComponentConstructor getConstructor() {
        try {
            this.finalizeEnhancedClass();
            Constructor c = this.findConstructor();
            Object[] params = this._constructorArguments.toArray();
            return new ComponentConstructorImpl(c, params, this._classFab.toString(), this._specification.getLocation());
        }
        catch (Throwable t) {
            throw new ApplicationRuntimeException(EnhanceMessages.classEnhancementFailure(this._baseClass, t), (Object)this._classFab, null, t);
        }
    }

    void finalizeEnhancedClass() {
        this.finalizeIncompleteMethods();
        if (this._constructorBuilder != null) {
            this._constructorBuilder.end();
            Class[] types = this._constructorTypes.toArray(new Class[this._constructorTypes.size()]);
            this._classFab.addConstructor(types, null, this._constructorBuilder.toString());
        }
        if (this._log != null) {
            this._log.debug((Object)("Creating class:\n\n" + this._classFab));
        }
    }

    private void finalizeIncompleteMethods() {
        Iterator i = this._incompleteMethods.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            MethodSignature sig = (MethodSignature)e.getKey();
            BodyBuilder builder = (BodyBuilder)e.getValue();
            builder.end();
            this._classFab.addMethod(1, sig, builder.toString());
        }
    }

    private Constructor findConstructor() {
        Class componentClass = this._classFab.createClass();
        return componentClass.getConstructors()[0];
    }

    private String newClassName() {
        String baseName = this._baseClass.getName();
        int dotx = baseName.lastIndexOf(46);
        return "$" + baseName.substring(dotx + 1) + "_" + _uid++;
    }

    public void extendMethodImplementation(Class interfaceClass, MethodSignature methodSignature, String code) {
        this.addInterfaceIfNeeded(interfaceClass);
        BodyBuilder builder = (BodyBuilder)this._incompleteMethods.get(methodSignature);
        if (builder == null) {
            builder = this.createIncompleteMethod(methodSignature);
            this._incompleteMethods.put(methodSignature, builder);
        }
        builder.addln(code);
    }

    private void addInterfaceIfNeeded(Class interfaceClass) {
        if (this.implementsInterface(interfaceClass)) {
            return;
        }
        this._classFab.addInterface(interfaceClass);
        this._addedInterfaces.add(interfaceClass);
    }

    public boolean implementsInterface(Class interfaceClass) {
        if (interfaceClass.isAssignableFrom(this._baseClass)) {
            return true;
        }
        Iterator i = this._addedInterfaces.iterator();
        while (i.hasNext()) {
            Class addedInterface = (Class)i.next();
            if (!interfaceClass.isAssignableFrom(addedInterface)) continue;
            return true;
        }
        return false;
    }

    private BodyBuilder createIncompleteMethod(MethodSignature sig) {
        BodyBuilder result = new BodyBuilder();
        result.begin();
        if (this.existingImplementation(sig)) {
            result.addln("super.{0}($$);", (Object)sig.getName());
        }
        return result;
    }

    private boolean existingImplementation(MethodSignature sig) {
        Method m = this.findMethod(sig);
        return m != null && !Modifier.isAbstract(m.getModifiers());
    }

    private Method findMethod(MethodSignature sig) {
        try {
            return this._baseClass.getMethod(sig.getName(), sig.getParameterTypes());
        }
        catch (NoSuchMethodException ex) {
            for (Class c = this._baseClass; c != (class$java$lang$Object == null ? EnhancementOperationImpl.class$("java.lang.Object") : class$java$lang$Object); c = c.getSuperclass()) {
                try {
                    return c.getDeclaredMethod(sig.getName(), sig.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            return null;
        }
    }

    public List findUnclaimedAbstractProperties() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator i = this._properties.values().iterator();
        while (i.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)i.next();
            String name = pd.getName();
            if (this._claimedProperties.contains(name) || !this.isAbstractProperty(pd)) continue;
            result.add(name);
        }
        return result;
    }

    private boolean isAbstractProperty(PropertyDescriptor pd) {
        return this.isExistingAbstractMethod(pd.getReadMethod()) || this.isExistingAbstractMethod(pd.getWriteMethod());
    }

    private boolean isExistingAbstractMethod(Method m) {
        return m != null && Modifier.isAbstract(m.getModifiers());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

