/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import java.util.Iterator;
import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.spec.IBeanSpecification;
import org.apache.tapestry.spec.IComponentSpecification;

public class InjectBeanWorker
implements EnhancementWorker {
    private ErrorLog _errorLog;

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        Iterator i = spec.getBeanNames().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            IBeanSpecification bs = spec.getBeanSpecification(name);
            String propertyName = bs.getPropertyName();
            if (propertyName == null) continue;
            try {
                this.injectBean(op, name, propertyName, bs.getLocation());
            }
            catch (Exception ex) {
                this._errorLog.error(EnhanceMessages.errorAddingProperty(propertyName, op.getBaseClass(), ex), bs.getLocation(), (Throwable)ex);
            }
        }
    }

    public void injectBean(EnhancementOperation op, String beanName, String propertyName, Location location) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)beanName, (String)"beanName");
        Defense.notNull((Object)propertyName, (String)"propertyName");
        op.claimReadonlyProperty(propertyName);
        Class propertyType = EnhanceUtils.extractPropertyType(op, propertyName, null);
        String methodName = op.getAccessorMethodName(propertyName);
        MethodSignature sig = new MethodSignature(propertyType, methodName, null, null);
        op.addMethod(1, sig, "return (" + ClassFabUtils.getJavaClassName((Class)propertyType) + ") getBeans().getBean(\"" + beanName + "\");", location);
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }
}

