/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import java.util.Iterator;
import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.binding.BindingSource;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.enhance.InitialValueBindingCreator;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IPropertySpecification;

public class SpecifiedPropertyWorker
implements EnhancementWorker {
    private ErrorLog _errorLog;
    private BindingSource _bindingSource;
    static /* synthetic */ Class class$org$apache$tapestry$IComponent;
    static /* synthetic */ Class class$org$apache$tapestry$event$PageDetachListener;
    static /* synthetic */ Class class$org$apache$tapestry$enhance$InitialValueBindingCreator;
    static /* synthetic */ Class class$org$apache$tapestry$IBinding;

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        Iterator i = spec.getPropertySpecificationNames().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            IPropertySpecification ps = spec.getPropertySpecification(name);
            try {
                this.performEnhancement(op, ps);
            }
            catch (RuntimeException ex) {
                this._errorLog.error(EnhanceMessages.errorAddingProperty(name, op.getBaseClass(), ex), ps.getLocation(), (Throwable)ex);
            }
        }
    }

    private void performEnhancement(EnhancementOperation op, IPropertySpecification ps) {
        Defense.notNull((Object)ps, (String)"ps");
        String propertyName = ps.getName();
        String specifiedType = ps.getType();
        boolean persistent = ps.isPersistent();
        String initialValue = ps.getInitialValue();
        Location location = ps.getLocation();
        this.addProperty(op, propertyName, specifiedType, persistent, initialValue, location);
    }

    public void addProperty(EnhancementOperation op, String propertyName, String specifiedType, boolean persistent, String initialValue, Location location) {
        Class propertyType = EnhanceUtils.extractPropertyType(op, propertyName, specifiedType);
        op.claimProperty(propertyName);
        String field = "_$" + propertyName;
        op.addField(field, propertyType);
        EnhanceUtils.createSimpleAccessor(op, field, propertyName, propertyType, location);
        this.addMutator(op, propertyName, propertyType, field, persistent, location);
        if (initialValue == null) {
            this.addReinitializer(op, propertyType, field);
        } else {
            this.addInitialValue(op, propertyName, propertyType, field, initialValue, location);
        }
    }

    private void addReinitializer(EnhancementOperation op, Class propertyType, String fieldName) {
        String defaultFieldName = fieldName + "$default";
        op.addField(defaultFieldName, propertyType);
        op.extendMethodImplementation(class$org$apache$tapestry$IComponent == null ? (class$org$apache$tapestry$IComponent = SpecifiedPropertyWorker.class$("org.apache.tapestry.IComponent")) : class$org$apache$tapestry$IComponent, EnhanceUtils.FINISH_LOAD_SIGNATURE, defaultFieldName + " = " + fieldName + ";");
        op.extendMethodImplementation(class$org$apache$tapestry$event$PageDetachListener == null ? (class$org$apache$tapestry$event$PageDetachListener = SpecifiedPropertyWorker.class$("org.apache.tapestry.event.PageDetachListener")) : class$org$apache$tapestry$event$PageDetachListener, EnhanceUtils.PAGE_DETACHED_SIGNATURE, fieldName + " = " + defaultFieldName + ";");
    }

    private void addInitialValue(EnhancementOperation op, String propertyName, Class propertyType, String fieldName, String initialValue, Location location) {
        String description = EnhanceMessages.initialValueForProperty(propertyName);
        InitialValueBindingCreator creator = new InitialValueBindingCreator(this._bindingSource, description, initialValue, location);
        String creatorField = op.addInjectedField(fieldName + "$initialValueBindingCreator", class$org$apache$tapestry$enhance$InitialValueBindingCreator == null ? (class$org$apache$tapestry$enhance$InitialValueBindingCreator = SpecifiedPropertyWorker.class$("org.apache.tapestry.enhance.InitialValueBindingCreator")) : class$org$apache$tapestry$enhance$InitialValueBindingCreator, creator);
        String bindingField = fieldName + "$initialValueBinding";
        op.addField(bindingField, class$org$apache$tapestry$IBinding == null ? (class$org$apache$tapestry$IBinding = SpecifiedPropertyWorker.class$("org.apache.tapestry.IBinding")) : class$org$apache$tapestry$IBinding);
        BodyBuilder builder = new BodyBuilder();
        builder.addln("{0} = {1}.createBinding(this);", (Object)bindingField, (Object)creatorField);
        op.extendMethodImplementation(class$org$apache$tapestry$IComponent == null ? (class$org$apache$tapestry$IComponent = SpecifiedPropertyWorker.class$("org.apache.tapestry.IComponent")) : class$org$apache$tapestry$IComponent, EnhanceUtils.FINISH_LOAD_SIGNATURE, builder.toString());
        builder.clear();
        builder.addln("{0} = {1};", (Object)fieldName, (Object)EnhanceUtils.createUnwrapExpression(op, bindingField, propertyType));
        String code = builder.toString();
        op.extendMethodImplementation(class$org$apache$tapestry$IComponent == null ? (class$org$apache$tapestry$IComponent = SpecifiedPropertyWorker.class$("org.apache.tapestry.IComponent")) : class$org$apache$tapestry$IComponent, EnhanceUtils.FINISH_LOAD_SIGNATURE, code);
        op.extendMethodImplementation(class$org$apache$tapestry$event$PageDetachListener == null ? (class$org$apache$tapestry$event$PageDetachListener = SpecifiedPropertyWorker.class$("org.apache.tapestry.event.PageDetachListener")) : class$org$apache$tapestry$event$PageDetachListener, EnhanceUtils.PAGE_DETACHED_SIGNATURE, code);
    }

    private void addMutator(EnhancementOperation op, String propertyName, Class propertyType, String fieldName, boolean persistent, Location location) {
        String methodName = EnhanceUtils.createMutatorMethodName(propertyName);
        BodyBuilder body = new BodyBuilder();
        body.begin();
        if (persistent) {
            body.add("org.apache.tapestry.Tapestry#fireObservedChange(this, ");
            body.addQuoted(propertyName);
            body.addln(", ($w) $1);");
        }
        body.addln(fieldName + " = $1;");
        body.end();
        MethodSignature sig = new MethodSignature(Void.TYPE, methodName, new Class[]{propertyType}, null);
        op.addMethod(1, sig, body.toString(), location);
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }

    public void setBindingSource(BindingSource bindingSource) {
        this._bindingSource = bindingSource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

