/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ClasspathResource;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.NestedMarkupWriter;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.StaleLinkException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.FormEventType;
import org.apache.tapestry.form.FormMessages;
import org.apache.tapestry.form.FormSupport;
import org.apache.tapestry.form.HiddenFieldData;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.services.ServiceConstants;
import org.apache.tapestry.util.IdAllocator;
import org.apache.tapestry.valid.IValidationDelegate;

public class FormSupportImpl
implements FormSupport {
    public static final String FORM_IDS = "formids";
    public static final String RESERVED_FORM_IDS = "reservedids";
    public static final String SUBMIT_MODE = "submitmode";
    public static final String SCRIPT = "/org/apache/tapestry/form/Form.js";
    private static final Set _standardReservedIds;
    public static final String FIELD_FOCUS_ATTRIBUTE = "org.apache.tapestry.field-focused";
    private static final Set _submitModes;
    private int _allocatedIdIndex;
    private final List _allocatedIds = new ArrayList();
    private final IRequestCycle _cycle;
    private final IdAllocator _elementIdAllocator = new IdAllocator();
    private String _encodingType;
    private final List _deferredRunnables = new ArrayList();
    private final Map _prerenderMap = new HashMap();
    private Map _events;
    private final IForm _form;
    private final List _hiddenValues = new ArrayList();
    private final boolean _rewinding;
    private final IMarkupWriter _writer;
    private final Resource _script;
    private final IValidationDelegate _delegate;
    private final PageRenderSupport _pageRenderSupport;

    public FormSupportImpl(IMarkupWriter writer, IRequestCycle cycle, IForm form) {
        Defense.notNull((Object)writer, (String)"writer");
        Defense.notNull((Object)cycle, (String)"cycle");
        Defense.notNull((Object)form, (String)"form");
        this._writer = writer;
        this._cycle = cycle;
        this._form = form;
        this._delegate = form.getDelegate();
        this._rewinding = cycle.isRewound(form);
        this._allocatedIdIndex = 0;
        this._script = new ClasspathResource(cycle.getEngine().getClassResolver(), SCRIPT);
        this._pageRenderSupport = TapestryUtils.getOptionalPageRenderSupport(cycle);
    }

    FormSupportImpl(IRequestCycle cycle) {
        this._cycle = cycle;
        this._form = null;
        this._rewinding = false;
        this._writer = null;
        this._delegate = null;
        this._pageRenderSupport = null;
        this._script = null;
    }

    public void addEventHandler(FormEventType type, String functionName) {
        ArrayList<String> functionList;
        if (this._events == null) {
            this._events = new HashMap();
        }
        if ((functionList = (ArrayList<String>)this._events.get(type)) == null) {
            functionList = new ArrayList<String>();
            this._events.put(type, functionList);
        }
        functionList.add(functionName);
    }

    private void addHiddenFieldsForLinkParameters(ILink link) {
        Object[] names = link.getParameterNames();
        int count = Tapestry.size(names);
        StringBuffer extraIds = new StringBuffer();
        String sep = "";
        boolean hasExtra = false;
        this.preallocateReservedIds();
        for (int i = 0; i < count; ++i) {
            Object name = names[i];
            if (!_standardReservedIds.contains(name)) {
                this._elementIdAllocator.allocateId((String)name);
                extraIds.append(sep);
                extraIds.append((String)name);
                sep = ",";
                hasExtra = true;
            }
            this.addHiddenFieldsForLinkParameter(link, (String)name);
        }
        if (hasExtra) {
            this.addHiddenValue(RESERVED_FORM_IDS, extraIds.toString());
        }
    }

    public void addHiddenValue(String name, String value) {
        this._hiddenValues.add(new HiddenFieldData(name, value));
    }

    public void addHiddenValue(String name, String id, String value) {
        this._hiddenValues.add(new HiddenFieldData(name, id, value));
    }

    private String buildAllocatedIdList() {
        StringBuffer buffer = new StringBuffer();
        int count = this._allocatedIds.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(this._allocatedIds.get(i));
        }
        return buffer.toString();
    }

    private void emitEventHandlers(String formId) {
        if (this._events == null || this._events.isEmpty()) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator i = this._events.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            FormEventType type = (FormEventType)entry.getKey();
            Object value = entry.getValue();
            buffer.append("Tapestry.");
            buffer.append(type.getAddHandlerFunctionName());
            buffer.append("('");
            buffer.append(formId);
            buffer.append("', function (event)\n{");
            List l = (List)value;
            int count = l.size();
            for (int j = 0; j < count; ++j) {
                String functionName = (String)l.get(j);
                if (j > 0) {
                    buffer.append(";");
                }
                buffer.append("\n  ");
                buffer.append(functionName);
                if (functionName.endsWith(")")) continue;
                buffer.append("()");
            }
            buffer.append(";\n});\n");
        }
        this._pageRenderSupport.addInitializationScript(buffer.toString());
    }

    public String getElementId(IFormComponent component) {
        return this.getElementId(component, component.getId());
    }

    public String getElementId(IFormComponent component, String baseId) {
        String filteredId = TapestryUtils.convertTapestryIdToNMToken(baseId);
        String result = this._elementIdAllocator.allocateId(filteredId);
        if (this._rewinding) {
            if (this._allocatedIdIndex >= this._allocatedIds.size()) {
                throw new StaleLinkException(FormMessages.formTooManyIds(this._form, this._allocatedIds.size(), component), component);
            }
            String expected = (String)this._allocatedIds.get(this._allocatedIdIndex);
            if (!result.equals(expected)) {
                throw new StaleLinkException(FormMessages.formIdMismatch(this._form, this._allocatedIdIndex, expected, result, component), component);
            }
        } else {
            this._allocatedIds.add(result);
        }
        ++this._allocatedIdIndex;
        component.setName(result);
        return result;
    }

    public boolean isRewinding() {
        return this._rewinding;
    }

    private void preallocateReservedIds() {
        for (int i = 0; i < ServiceConstants.RESERVED_IDS.length; ++i) {
            this._elementIdAllocator.allocateId(ServiceConstants.RESERVED_IDS[i]);
        }
    }

    private void reinitializeIdAllocatorForRewind() {
        String allocatedFormIds = this._cycle.getParameter(FORM_IDS);
        String[] ids = TapestryUtils.split(allocatedFormIds);
        for (int i = 0; i < ids.length; ++i) {
            this._allocatedIds.add(ids[i]);
        }
        this.preallocateReservedIds();
        String extraReservedIds = this._cycle.getParameter(RESERVED_FORM_IDS);
        ids = TapestryUtils.split(extraReservedIds);
        for (int i = 0; i < ids.length; ++i) {
            this._elementIdAllocator.allocateId(ids[i]);
        }
    }

    public void render(String method, IRender informalParametersRenderer, ILink link, String scheme) {
        this.render(method, informalParametersRenderer, link, scheme, null);
    }

    public void render(String method, IRender informalParametersRenderer, ILink link, String scheme, Integer port) {
        String formId = this._form.getName();
        this.emitEventManagerInitialization(formId);
        this.addHiddenFieldsForLinkParameters(link);
        this.addHiddenValue(SUBMIT_MODE, null);
        this.addHiddenValue("submitname", null);
        NestedMarkupWriter nested = this._writer.getNestedWriter();
        this._form.renderBody(nested, this._cycle);
        this.runDeferredRunnables();
        int portI = port == null ? 0 : port;
        this.writeTag(this._writer, method, link.getURL(scheme, null, portI, null, false));
        this._writer.attribute("name", formId);
        this._writer.attribute("id", formId);
        if (this._encodingType != null) {
            this._writer.attribute("enctype", this._encodingType);
        }
        this.emitEventHandlers(formId);
        informalParametersRenderer.render(this._writer, this._cycle);
        this._writer.println();
        this.writeHiddenFields();
        nested.close();
        this._writer.end();
        String fieldId = this._delegate.getFocusField();
        if (fieldId == null || this._pageRenderSupport == null) {
            return;
        }
        if (!this._form.getFocus() || this._cycle.getAttribute(FIELD_FOCUS_ATTRIBUTE) != null) {
            return;
        }
        this._pageRenderSupport.addInitializationScript("Tapestry.set_focus('" + fieldId + "');");
        this._cycle.setAttribute(FIELD_FOCUS_ATTRIBUTE, Boolean.TRUE);
    }

    protected void emitEventManagerInitialization(String formId) {
        if (this._pageRenderSupport == null) {
            return;
        }
        this._pageRenderSupport.addExternalScript(this._script);
        this._pageRenderSupport.addInitializationScript("Tapestry.register_form('" + formId + "');");
    }

    public String rewind() {
        this._form.getDelegate().clear();
        String mode = this._cycle.getParameter(SUBMIT_MODE);
        if ("cancel".equals(mode)) {
            return mode;
        }
        this.reinitializeIdAllocatorForRewind();
        this._form.renderBody(this._writer, this._cycle);
        int expected = this._allocatedIds.size();
        if (this._allocatedIdIndex < expected) {
            String nextExpectedId = (String)this._allocatedIds.get(this._allocatedIdIndex);
            throw new StaleLinkException(FormMessages.formTooFewIds(this._form, expected - this._allocatedIdIndex, nextExpectedId), this._form);
        }
        this.runDeferredRunnables();
        if (_submitModes.contains(mode)) {
            return mode;
        }
        return "submit";
    }

    private void runDeferredRunnables() {
        Iterator i = this._deferredRunnables.iterator();
        while (i.hasNext()) {
            Runnable r = (Runnable)i.next();
            r.run();
        }
    }

    public void setEncodingType(String encodingType) {
        if (this._encodingType != null && !this._encodingType.equals(encodingType)) {
            throw new ApplicationRuntimeException(FormMessages.encodingTypeContention(this._form, this._encodingType, encodingType), (Object)this._form, null, null);
        }
        this._encodingType = encodingType;
    }

    protected void writeHiddenField(IMarkupWriter writer, String name, String id, String value) {
        writer.beginEmpty("input");
        writer.attribute("type", "hidden");
        writer.attribute("name", name);
        if (HiveMind.isNonBlank((String)id)) {
            writer.attribute("id", id);
        }
        writer.attribute("value", value == null ? "" : value);
        writer.println();
    }

    private void writeHiddenField(String name, String id, String value) {
        this.writeHiddenField(this._writer, name, id, value);
    }

    protected void writeHiddenFields() {
        this._writer.begin("div");
        this._writer.attribute("style", "display:none;");
        this.writeHiddenFieldList();
        this._writer.end();
    }

    protected void writeHiddenFieldList() {
        this.writeHiddenField(FORM_IDS, null, this.buildAllocatedIdList());
        Iterator i = this._hiddenValues.iterator();
        while (i.hasNext()) {
            HiddenFieldData data = (HiddenFieldData)i.next();
            this.writeHiddenField(data.getName(), data.getId(), data.getValue());
        }
    }

    private void addHiddenFieldsForLinkParameter(ILink link, String parameterName) {
        String[] values = link.getParameterValues(parameterName);
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            this.addHiddenValue(parameterName, values[i]);
        }
    }

    protected void writeTag(IMarkupWriter writer, String method, String url) {
        writer.begin("form");
        writer.attribute("method", method);
        writer.attribute("action", url);
    }

    public void prerenderField(IMarkupWriter writer, IComponent field, Location location) {
        Defense.notNull((Object)writer, (String)"writer");
        Defense.notNull((Object)field, (String)"field");
        String key = field.getExtendedId();
        if (this._prerenderMap.containsKey(key)) {
            throw new ApplicationRuntimeException(FormMessages.fieldAlreadyPrerendered(field), (Object)field, location, null);
        }
        NestedMarkupWriter nested = writer.getNestedWriter();
        field.render(nested, this._cycle);
        this._prerenderMap.put(key, nested.getBuffer());
    }

    public boolean wasPrerendered(IMarkupWriter writer, IComponent field) {
        String key = field.getExtendedId();
        if (!this._prerenderMap.containsKey(key)) {
            return false;
        }
        String buffer = (String)this._prerenderMap.get(key);
        writer.printRaw(buffer);
        this._prerenderMap.remove(key);
        return true;
    }

    public void addDeferredRunnable(Runnable runnable) {
        Defense.notNull((Object)runnable, (String)"runnable");
        this._deferredRunnables.add(runnable);
    }

    public void registerForFocus(IFormComponent field, int priority) {
        this._delegate.registerForFocus(field, priority);
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(ServiceConstants.RESERVED_IDS));
        set.add(FORM_IDS);
        set.add(RESERVED_FORM_IDS);
        set.add(SUBMIT_MODE);
        set.add("submitname");
        _standardReservedIds = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("cancel");
        set.add("submit");
        set.add("refresh");
        _submitModes = Collections.unmodifiableSet(set);
    }
}

