/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.form.ValidatableField;
import org.apache.tapestry.form.ValidatableFieldSupport;
import org.apache.tapestry.valid.ValidatorException;

public abstract class RadioGroup
extends AbstractFormComponent
implements ValidatableField {
    private Object _selection;
    private int _selectedOption;
    private boolean _rewinding;
    private boolean _rendering;
    private int _nextOptionId;
    private static final String ATTRIBUTE_NAME = "org.apache.tapestry.active.RadioGroup";

    public static RadioGroup get(IRequestCycle cycle) {
        return (RadioGroup)cycle.getAttribute(ATTRIBUTE_NAME);
    }

    public int getNextOptionId() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "nextOptionId");
        }
        return this._nextOptionId++;
    }

    public boolean isRewinding() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "rewinding");
        }
        return this._rewinding;
    }

    public boolean isSelection(Object value) {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "selection");
        }
        if (this._selection == value) {
            return true;
        }
        if (this._selection == null || value == null) {
            return false;
        }
        return this._selection.equals(value);
    }

    public void updateSelection(Object value) {
        this.getBinding("selected").setObject(value);
        this._selection = value;
    }

    public boolean isSelected(int option) {
        return this._selectedOption == option;
    }

    protected void prepareForRender(IRequestCycle cycle) {
        if (cycle.getAttribute(ATTRIBUTE_NAME) != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("RadioGroup.may-not-nest"), (Object)this, null, null);
        }
        cycle.setAttribute(ATTRIBUTE_NAME, this);
        this._rendering = true;
        this._nextOptionId = 0;
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._rendering = false;
        this._selection = null;
        cycle.removeAttribute(ATTRIBUTE_NAME);
    }

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        this._rewinding = false;
        this._selection = this.getBinding("selected").getObject();
        this.renderBody(writer, cycle);
        this.getValidatableFieldSupport().renderContributions(this, writer, cycle);
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String value = cycle.getParameter(this.getName());
        this._selectedOption = value == null ? -1 : Integer.parseInt(value);
        this._rewinding = true;
        this.renderBody(writer, cycle);
        try {
            this.getValidatableFieldSupport().validate(this, writer, cycle, this._selection);
        }
        catch (ValidatorException e) {
            this.getForm().getDelegate().record(e);
        }
    }

    public abstract ValidatableFieldSupport getValidatableFieldSupport();

    public boolean isRequired() {
        return this.getValidatableFieldSupport().isRequired(this);
    }

    protected boolean getCanTakeFocus() {
        return false;
    }

    protected boolean getAlwaysRenderBodyOnRewind() {
        return true;
    }

    public abstract /* synthetic */ Object getValidators();
}

