/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import java.util.HashSet;
import java.util.Set;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.form.ValidatableField;
import org.apache.tapestry.form.ValidatableFieldSupport;
import org.apache.tapestry.valid.ValidatorException;

public abstract class Select
extends AbstractFormComponent
implements ValidatableField {
    private boolean _rewinding;
    private boolean _rendering;
    private Set _selections;
    private int _nextOptionId;
    private static final String ATTRIBUTE_NAME = "org.apache.tapestry.active.Select";

    public static Select get(IRequestCycle cycle) {
        return (Select)cycle.getAttribute(ATTRIBUTE_NAME);
    }

    public abstract boolean isMultiple();

    public boolean isRewinding() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "rewinding");
        }
        return this._rewinding;
    }

    public String getNextOptionId() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "nextOptionId");
        }
        return Integer.toString(this._nextOptionId++);
    }

    public boolean isSelected(String value) {
        if (this._selections == null) {
            return false;
        }
        return this._selections.contains(value);
    }

    protected void prepareForRender(IRequestCycle cycle) {
        if (cycle.getAttribute(ATTRIBUTE_NAME) != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("Select.may-not-nest"), (Object)this, null, null);
        }
        cycle.setAttribute(ATTRIBUTE_NAME, this);
        this._rendering = true;
        this._nextOptionId = 0;
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._rendering = false;
        this._selections = null;
        cycle.removeAttribute(ATTRIBUTE_NAME);
    }

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        this._rewinding = false;
        this.renderDelegatePrefix(writer, cycle);
        writer.begin("select");
        writer.attribute("name", this.getName());
        if (this.isMultiple()) {
            writer.attribute("multiple", "multiple");
        }
        if (this.isDisabled()) {
            writer.attribute("disabled", "disabled");
        }
        this.renderIdAttribute(writer, cycle);
        this.renderDelegateAttributes(writer, cycle);
        this.getValidatableFieldSupport().renderContributions(this, writer, cycle);
        this.renderInformalParameters(writer, cycle);
        this.renderBody(writer, cycle);
        writer.end();
        this.renderDelegateSuffix(writer, cycle);
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        this._selections = null;
        this._rewinding = true;
        String[] parameters = cycle.getParameters(this.getName());
        try {
            if (parameters != null) {
                int length = parameters.length;
                this._selections = new HashSet(length > 30 ? 101 : 7);
                for (int i = 0; i < length; ++i) {
                    this._selections.add(parameters[i]);
                }
            }
            this.renderBody(writer, cycle);
            this.getValidatableFieldSupport().validate(this, writer, cycle, parameters);
        }
        catch (ValidatorException e) {
            this.getForm().getDelegate().record(e);
        }
    }

    public abstract ValidatableFieldSupport getValidatableFieldSupport();

    public boolean isRequired() {
        return this.getValidatableFieldSupport().isRequired(this);
    }

    public abstract /* synthetic */ Object getValidators();
}

