/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form.validator;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.form.FormComponentContributorContext;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.ValidationMessages;
import org.apache.tapestry.form.validator.BaseValidator;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class MinLength
extends BaseValidator {
    private int _minLength;

    public MinLength() {
    }

    public MinLength(String initializer) {
        super(initializer);
    }

    public void setMinLength(int minLength) {
        this._minLength = minLength;
    }

    public int getMinLength() {
        return this._minLength;
    }

    public void validate(IFormComponent field, ValidationMessages messages, Object object) throws ValidatorException {
        String string = (String)object;
        if (string.length() < this._minLength) {
            throw new ValidatorException(this.buildMessage(messages, field), ValidationConstraint.MINIMUM_WIDTH);
        }
    }

    protected String buildMessage(ValidationMessages messages, IFormComponent field) {
        return messages.formatValidationMessage(this.getMessage(), "field-too-short", new Object[]{new Integer(this._minLength), field.getDisplayName()});
    }

    public void renderContribution(IMarkupWriter writer, IRequestCycle cycle, FormComponentContributorContext context, IFormComponent field) {
        context.includeClasspathScript("/org/apache/tapestry/form/validator/StringValidator.js");
        StringBuffer buffer = new StringBuffer("function(event) { Tapestry.validate_min_length(event, '");
        buffer.append(field.getClientId());
        buffer.append("', ");
        buffer.append(this._minLength);
        buffer.append(", ");
        buffer.append(TapestryUtils.enquote(this.buildMessage(context, field)));
        buffer.append("); }");
        context.addSubmitHandler(buffer.toString());
    }
}

