/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.html;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Resource;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.html.HTMLMessages;

public abstract class Script
extends AbstractComponent {
    private Map _symbols;

    public abstract IScriptSource getScriptSource();

    private Map getInputSymbols() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map baseSymbols = this.getBaseSymbols();
        if (baseSymbols != null) {
            result.putAll(baseSymbols);
        }
        Iterator i = this.getBindingNames().iterator();
        while (i.hasNext()) {
            String bindingName = (String)i.next();
            if (this.getSpecification().getParameter(bindingName) != null) continue;
            IBinding binding = this.getBinding(bindingName);
            Object value = binding.getObject();
            result.put(bindingName, value);
        }
        return result;
    }

    private IScript getParsedScript() {
        IAsset scriptAsset = this.getScriptAsset();
        String scriptPath = this.getScriptPath();
        if (scriptAsset != null && scriptPath != null) {
            throw new ApplicationRuntimeException(HTMLMessages.multiAssetParameterError(this.getBinding("scriptAsset"), this.getBinding("scriptPath")));
        }
        if (scriptPath == null && scriptAsset == null) {
            throw new ApplicationRuntimeException(HTMLMessages.noScriptPathError());
        }
        IScriptSource source = this.getScriptSource();
        Resource scriptLocation = null;
        if (scriptPath != null) {
            Resource rootLocation = this.getContainer().getSpecification().getSpecificationLocation();
            scriptLocation = rootLocation.getRelativeResource(scriptPath);
        } else {
            scriptLocation = scriptAsset.getResourceLocation();
        }
        try {
            return source.getScript(scriptLocation);
        }
        catch (RuntimeException ex) {
            throw new ApplicationRuntimeException(ex.getMessage(), (Object)this, this.getBinding("script").getLocation(), (Throwable)ex);
        }
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (!cycle.isRewinding()) {
            PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport(cycle, this);
            this._symbols = this.getInputSymbols();
            this.getParsedScript().execute(cycle, pageRenderSupport, this._symbols);
        }
        this.renderBody(writer, cycle);
    }

    public abstract String getScriptPath();

    public abstract IAsset getScriptAsset();

    public abstract Map getBaseSymbols();

    public Map getSymbols() {
        return this._symbols;
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._symbols = null;
        super.cleanupAfterRender(cycle);
    }
}

