/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.markup;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.NestedMarkupWriter;
import org.apache.tapestry.markup.MarkupFilter;
import org.apache.tapestry.markup.MarkupMessages;
import org.apache.tapestry.markup.NestedMarkupWriterImpl;

public class MarkupWriterImpl
implements IMarkupWriter {
    private PrintWriter _writer;
    private MarkupFilter _filter;
    private boolean _openTag = false;
    private boolean _emptyTag = false;
    private String _contentType;
    private List _activeElementStack;

    public MarkupWriterImpl(String contentType, PrintWriter writer, MarkupFilter filter) {
        Defense.notNull((Object)contentType, (String)"contentType");
        Defense.notNull((Object)writer, (String)"writer");
        Defense.notNull((Object)filter, (String)"filter");
        this._contentType = contentType;
        this._writer = writer;
        this._filter = filter;
    }

    public void attribute(String name, int value) {
        this.checkTagOpen();
        this._writer.print(' ');
        this._writer.print(name);
        this._writer.print("=\"");
        this._writer.print(value);
        this._writer.print('\"');
    }

    public void attribute(String name, boolean value) {
        this.checkTagOpen();
        this._writer.print(' ');
        this._writer.print(name);
        this._writer.print("=\"");
        this._writer.print(value);
        this._writer.print('\"');
    }

    public void attribute(String name, String value) {
        this.attribute(name, value, false);
    }

    public void attribute(String name, String value, boolean raw) {
        this.checkTagOpen();
        this._writer.print(' ');
        this._writer.print(name);
        this._writer.print("=\"");
        if (value != null) {
            char[] data = value.toCharArray();
            this.maybePrintFiltered(data, 0, data.length, raw, true);
        }
        this._writer.print('\"');
    }

    private void maybePrintFiltered(char[] data, int offset, int length, boolean raw, boolean isAttribute) {
        if (data == null || length <= 0) {
            return;
        }
        if (raw) {
            this._writer.write(data, offset, length);
            return;
        }
        this._filter.print(this._writer, data, offset, length, isAttribute);
    }

    public void attributeRaw(String name, String value) {
        this.attribute(name, value, true);
    }

    public void begin(String name) {
        if (this._openTag) {
            this.closeTag();
        }
        this.push(name);
        this._writer.print('<');
        this._writer.print(name);
        this._openTag = true;
        this._emptyTag = false;
    }

    public void beginEmpty(String name) {
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.print('<');
        this._writer.print(name);
        this._openTag = true;
        this._emptyTag = true;
    }

    public boolean checkError() {
        return this._writer.checkError();
    }

    public void close() {
        if (this._openTag) {
            this.closeTag();
        }
        while (!this.stackEmpty()) {
            this._writer.print("</");
            this._writer.print(this.pop());
            this._writer.print('>');
        }
        this._writer.close();
        this._writer = null;
        this._filter = null;
        this._activeElementStack = null;
    }

    public void closeTag() {
        if (this._emptyTag) {
            this._writer.print('/');
        }
        this._writer.print('>');
        this._openTag = false;
        this._emptyTag = false;
    }

    public void comment(String value) {
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.print("<!-- ");
        this._writer.print(value);
        this._writer.println(" -->");
    }

    public void end() {
        if (this._openTag) {
            this.closeTag();
        }
        if (this.stackEmpty()) {
            throw new ApplicationRuntimeException(MarkupMessages.endWithEmptyStack());
        }
        this._writer.print("</");
        this._writer.print(this.pop());
        this._writer.print('>');
    }

    public void end(String name) {
        String tagName;
        if (this._openTag) {
            this.closeTag();
        }
        if (this._activeElementStack == null || !this._activeElementStack.contains(name)) {
            throw new ApplicationRuntimeException(MarkupMessages.elementNotOnStack(name, this._activeElementStack));
        }
        do {
            tagName = this.pop();
            this._writer.print("</");
            this._writer.print(tagName);
            this._writer.print('>');
        } while (!tagName.equals(name));
    }

    public void flush() {
        this._writer.flush();
    }

    public NestedMarkupWriter getNestedWriter() {
        return new NestedMarkupWriterImpl(this, this._filter);
    }

    public void print(char[] data, int offset, int length) {
        this.print(data, offset, length, false);
    }

    public void printRaw(char[] buffer, int offset, int length) {
        this.print(buffer, offset, length, true);
    }

    public void print(char[] buffer, int offset, int length, boolean raw) {
        if (this._openTag) {
            this.closeTag();
        }
        this.maybePrintFiltered(buffer, offset, length, raw, false);
    }

    public void print(String value) {
        this.print(value, false);
    }

    public void printRaw(String value) {
        this.print(value, true);
    }

    public void print(String value, boolean raw) {
        if (value == null || value.length() == 0) {
            this.print(null, 0, 0, raw);
            return;
        }
        char[] buffer = value.toCharArray();
        this.print(buffer, 0, buffer.length, raw);
    }

    public void print(char value) {
        char[] data = new char[]{value};
        this.print(data, 0, 1);
    }

    public void print(int value) {
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.print(value);
    }

    public void println() {
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.println();
    }

    public String getContentType() {
        return this._contentType;
    }

    private void checkTagOpen() {
        if (!this._openTag) {
            throw new IllegalStateException(MarkupMessages.tagNotOpen());
        }
    }

    private void push(String name) {
        if (this._activeElementStack == null) {
            this._activeElementStack = new ArrayList();
        }
        this._activeElementStack.add(name);
    }

    private String pop() {
        int lastIndex = this._activeElementStack.size() - 1;
        return (String)this._activeElementStack.remove(lastIndex);
    }

    private boolean stackEmpty() {
        return this._activeElementStack == null || this._activeElementStack.isEmpty();
    }
}

